DATA_MISSING = '*DATA MISSING*'
PARAM_ATTR_DICT = {type(1.0):'floatValue',
                   type(1):'intValue',
                   type(''):'textValue',
                   type(True):'booleanValue'}

def getObjBooleanParameter(dataObj, code, default=True, groupId=None):

  run = dataObj.run
  runParameter = dataObj.findFirstRunParameter(code=code, groupId=groupId)
  
  if not runParameter: # Not already set.
    runParameter = dataObj.run.newRunParameter(code=code, groupId=groupId)
    bool = default
    runParameter.booleanValue = bool
  
  elif runParameter.booleanValue is None:
    bool = default
    runParameter.booleanValue = bool
  
  else:
    bool = runParameter.booleanValue
    
  if runParameter not in dataObj.runParameters:
    dataObj.addRunParameter(runParameter)
  
  return bool

def toggleObjBooleanParameter(dataObj, code, default=True, groupId=None):

  run = dataObj.run
  runParameter = dataObj.findFirstRunParameter(code=code, groupId=groupId)
  
  if not runParameter: # Not already set.
    runParameter = dataObj.run.newRunParameter(code=code, groupId=groupId)
    bool = default
  
  elif runParameter.booleanValue is None:
    bool = default
  
  else:
    bool = not runParameter.booleanValue
    
  if runParameter not in dataObj.runParameters:
    dataObj.addRunParameter(runParameter)

  runParameter.booleanValue =  bool
  
  return bool

def setObjRunParameter(dataObj, code, value, groupId=None):

  run = dataObj.run
  runParameter = dataObj.findFirstRunParameter(code=code, groupId=groupId)
  
  if not runParameter: # Not already set.
    runParameter = dataObj.run.newRunParameter(code=code, groupId=groupId)
    
  if runParameter not in dataObj.runParameters:
    dataObj.addRunParameter(runParameter)
  
  setattr(runParameter, PARAM_ATTR_DICT[type(value)], value)
  
  
def getObjRunParameter(dataObj, code, groupId=None):

  runParameter = dataObj.findFirstRunParameter(code=code, groupId=groupId)

  return runParameter

def deleteRunParameter(run, code, groupId=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    return runParameter.delete()
      
def setRunParameter(run, code, value, groupId=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId) or \
                 run.newRunParameter(code=code, groupId=groupId)

  setattr(runParameter, PARAM_ATTR_DICT[type(value)], value)
 
def getRunParameter(run, code, groupId=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId)
  
  return runParameter

# Run get parameters by type
 
def getRunTextParameter(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    return runParameter.textValue
 
def getRunBooleanParameter(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    return runParameter.booleanValue

def getRunIntParameter(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    return runParameter.intValue

def getRunIntParameterList(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    data = runParameter.textValue
    if data:
      values = [int(x) for x in data.split(',')]
    else:
      values = []
  
    return values or None

def getRunTextParameterDict(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    data = runParameter.textValue or ''
    paramDict = {}
    
    if data:
      pairs = [x.split(':') for x in data.split(',')]
    
      for key, value in pairs:
        paramDict[key] = value
  
    return paramDict

def getRunTextParameterList(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    data = runParameter.textValue
    if data:
      values = [x for x in data.split(',')]
    else:
      values = []
  
    return values or None

def getRunFloatParameter(run, code, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data)
  
  if runParameter:
    return runParameter.floatValue

# Run set parameters by type
 
def setRunTextParameter(run, code, value, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)

  runParameter.textValue = value or None
 
def setRunBooleanParameter(run, code, value, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)
  
  runParameter.booleanValue = value

def setRunIntParameter(run, code, value, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)
  
  runParameter.intValue = value

def setRunIntParameterList(run, code, listData, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)
  
  values = [str(x) for x in listData or []]
  value = ','.join(values)
  
  runParameter.textValue = value or None

def setRunTextParameterDict(run, code, dictData, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)
  
  values = ['%s:%s' % (str(key), str(value)) for key, value in dictData.items()]
  value = ','.join(values)

  runParameter.textValue = value or None
  
def setRunTextParameterList(run, code, listData, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)
  
  values = [str(x) for x in listData or []]
  value = ','.join(values)
  
  runParameter.textValue = value or None


def setRunFloatParameter(run, code, value, groupId=None, data=None):

  runParameter = run.findFirstRunParameter(code=code, groupId=groupId, data=data) or \
                 run.newRunParameter(code=code, groupId=groupId, data=data)
                 
  runParameter.floatValue = value

# Data objects get parameters by type

def getDataTextParameter(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    return runParameter.textValue
 
def getDataBooleanParameter(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    return runParameter.booleanValue

def getDataIntParameter(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    return runParameter.intValue

def getDataIntParameterList(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    data = runParameter.textValue
    
    if data:
      values = [int(x) for x in data.split(',')]
    else:
      values = []
  
    return values or None

def getDataTextParameterDict(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    data = runParameter.textValue or ''
    paramDict = {}
    
    if data:
      pairs = [x.split(':') for x in data.split(',')]
    
      for key, value in pairs:
        paramDict[key] = value
  
    return paramDict

def getDataTextParameterList(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    data = runParameter.textValue
    
    if data:
      values = [x for x in data.split(',')]
    else:
      values = []
  
    return values or None

def getDataFloatParameter(data, code, groupId=None):

  runParameter = data.findFirstRunParameter(code=code, groupId=groupId)
  
  if runParameter:
    return runParameter.floatValue


# Data objects set parameters by type

def fetchDataRunParameter(datum, code, groupId=None):

  runParameter = datum.findFirstRunParameter(code=code, groupId=groupId)
  
  if not runParameter:
    runParameter = datum.run.newRunParameter(code=code, groupId=groupId, data=datum)
 
  return runParameter

def setDataTextParameter(datum, code, value, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  runParameter.textValue = value or None
 
def setDataBooleanParameter(datum, code, value, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  runParameter.booleanValue = value

def setDataIntParameter(datum, code, value, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  runParameter.intValue = value

def setDataIntParameterList(datum, code, listData, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  
  values = [str(x) for x in listData or []]
  value = ','.join(values)
  
  runParameter.textValue = value or None

def setDataTextParameterDict(datum, code, dictData, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  
  values = ['%s:%s' % (str(key), str(value)) for key, value in dictData.items()]
  value = ','.join(values)

  runParameter.textValue = value or None
  
def setDataTextParameterList(datum, code, listData, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  
  values = [str(x) for x in listData or []]
  value = ','.join(values)

  runParameter.textValue = value or None

def setDataFloatParameter(datum, code, value, groupId=None):

  runParameter = fetchDataRunParameter(datum, code, groupId)
  runParameter.floatValue = value

# Misc

def getRangeString(numbers):

  if len(numbers) == 1:
    return '%d' % (numbers[0],)

  numbers.sort()
  ranges = [[numbers[0],None]]
  
  for i, numberA in enumerate(numbers[:-1]):
    numberB = numbers[i+1]
    
    if numberB != (numberA+1):
      ranges[-1][1] = numberA
      ranges.append([numberB,None])
  
  ranges[-1][1] = numbers[-1]
  
  ranges = ['%d-%d' % tuple(r) for r in ranges]
  
  return ','.join(ranges)   

def getDataObjText(datum, missingText=DATA_MISSING):
  
  # TBD missing data info
    
  funcs = {'ConstraintStoreData':getConstraintStoreDataInfo,
           'DerivedListData':getDerivedListDataInfo,
           'ExternalData':getExternalDataInfo,
           'MeasurementListData':getMeasurementListDataInfo,
           'MolResidueData':getMolResidueDataInfo,
           'MolSystemData':getMolSystemDataInfo,
           'PeakListData':getPeakListDataInfo,
           'SpectrumData':getSpectrumDataInfo,
           'SpinSystemData':getSpinSystemDataInfo,
           'StructureEnsembleData':getStructureEnsembleDataInfo,
           'ViolationListData':getViolationListDataInfo}
  
  func = funcs[datum.className]

  return func(datum)

def getConstraintStoreDataInfo(datum):

  serials = list(datum.constraintListSerials)
  constraintLists = [cl for cl in datum.constraintLists if cl]
  
  if constraintLists and not serials:
    serials = [cl.serial for cl in constraintLists]
  
  if serials:
    if len(serials) == 1:
     
     if constraintLists:
       cList =  '%d - %s' % (serials[0], constraintLists[0].className[:-14])
     else:
       cList = str(serials[0])
     
     info = 'Restraint List %d:%s' % (datum.constraintStoreSerial, cList)
   
    else:
      serials.sort()
      cLists = ','.join([str(s) for s in serials])
      info = 'Restraint Lists %d:%s' % (datum.constraintStoreSerial, cLists)
 
    
  else:
    info = 'Restraint Lists %d:* all *' % (datum.constraintStoreSerial)


  return info

def getDerivedListDataInfo(datum):

  derivedDataList = datum.derivedDataList

  if derivedDataList:
    dType = derivedDataList.className[:-4]
  else:
    dType = 'Derived Data'

  info = '%s List %d' % (dType, datum.derivedDataListSerial)

  return info
  
def getExternalDataInfo(datum):

  dataStore = datum.dataStore
  
  if dataStore:
    fileName = dataStore.fullPath
  else:
    fileName = '* No file *'

  info = 'External Data; %s' % fileName

  return info
  
def getMeasurementListDataInfo(datum):

  mList = datum.measurementList

  if mList:
    dType = mList.className[:-4]
  else:
    dType = 'Measurement'

  info = '%s List %d' % (dType, datum.measurementListSerial)

  return info
  
def getMolResidueDataInfo(datum):
  
  residueSeqIds = datum.residueSeqIds
  
  if residueSeqIds:
  
    ranges = []
    start = residueSeqIds[0]
    end = start
    for i in residueSeqIds[1:]:
      if i == end+1:
        end = i
      else:
        ranges.append((start,end))
        start = end = i
 
    ranges.append((start,end))
 
    texts = []
    for start, end in ranges:
      if start == end:
        text = '%d' % (start)
      else:
        text = '%d-%d' % (start,end)
 
      texts.append(text)
  
    residues =  ','.join(texts)
    
  else:
    residues = '* all *'

  info = 'Chain %s:%s; Residues %s' % (datum.molSystemCode, datum.chainCode, residues)

  return info
  
def getMolSystemDataInfo(datum):

  chainCodes = list(datum.chainCodes)
  
  if chainCodes:
    chainCodes.sort()
    chains = ','.join(chainCodes)
    
  else:
    molSystem = datum.molSystem
    
    if molSystem:
      chains = ','.join([c.code for c in molSystem.sortedChains()])
    else:
      chains = '* all *'

  info = 'Chains %s:%s' % (datum.molSystemCode, chains)

  return info
  
def getPeakListDataInfo(datum):

  spectrum = datum.dataSource
  
  if spectrum:
    eName = spectrum.experiment.name
    sName = spectrum.name
  
  else:
    eName = str(datum.experimentSerial)
    sName = str(datum.dataSourceSerial)

  info = 'PeakList %s:%s:%d' % (eName, sName, datum.peakListSerial)

  return info
  
def getSpectrumDataInfo(datum):

  spectrum = datum.dataSource
  
  if spectrum:
    eName = spectrum.experiment.name
    sName = spectrum.name
  
  else:
    eName = str(datum.experimentSerial)
    sName = str(datum.dataSourceSerial)

  info = 'Spectrum %s:%s' % (eName, sName)  

  return info
  
def getSpinSystemDataInfo(datum):

  spinSystem = datum.resoanceGroup
  
  if spinSystem:
  
    residue = spinSystem.residue
    if residue:
      assignInfo = '%d%s' % (residue.seqCode, residue.ccpCode)
      
    elif spinSystem.ccpCode:
      assignInfo = spinSystem.ccpCode
      
    else:
      assignInfo = ''
  
  else:
    assignInfo = ''

  info = 'Spin System %d%s' % (datum.resonanceGroupSerial, assignInfo)  

  return info
  
def getStructureEnsembleDataInfo(datum):

  serials = list(datum.modelSerials)
  models = datum.models
    
  if models and not serials:
    serials = [m.serial for m in models]

  if serials:
    serials.sort()
    
    ranges = []
    start = serials[0]
    end = start
    for i in serials[1:]:
      if i == end+1:
        end = i
      else:
        ranges.append((start,end))
        start = end = i
 
    ranges.append((start,end))
 
    texts = []
    for start, end in ranges:
      if start == end:
        text = '%d' % (start)
      else:
        text = '%d-%d' % (start,end)
 
      texts.append(text)

    modelInfo =  ','.join(texts)
  
  else:
    modelInfo = '* all *'

  info = 'Structure Ensemble %s:%d; models %s' % (datum.molSystemCode, datum.ensembleId, modelInfo)

  return info
  
def getViolationListDataInfo(datum):

  info = 'Violation List %d:%d' % (datum.constraintStoreSerial, datum.violationListSerial)

  return info
  















