//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/**
 * A generic attribute that can be placed in a JcfAttributeCollection. Can be read
 * and written; data is processed as an array of bytes. 
 */
public class JcfAttribute
{
  protected short atrNameIndex;
    public final short getNameIndex() { return atrNameIndex; }

  /** Returns data as a string of bytes. May not be valid in subclasses. */
  protected int atrLength;
    public int getLength() { return atrLength; }

  /** Returns data as a string of bytes. May not be valid in subclasses. */
  protected byte atrData[];
    public final byte[] getData() { return atrData; }

  protected JcfConstantPool constPool;
    public final JcfConstantPool getConstPool() { return constPool; }

  /** Reads header information, then calls readData to read the actual attribute
   * contents. */
  public JcfAttribute (JcfClassInput ist, short nameIndex, JcfConstantPool p)
    throws IOException, ClassFormatError
  {
    constPool = p;
    atrNameIndex = nameIndex;
    atrLength = ist.readInt();
    readData(ist);
  }

  /** Allocates atrData array, then reads bytes into it. */
  public void readData (JcfClassInput ist) throws IOException, ClassFormatError
  {
    atrData = new byte[atrLength];
    ist.readFully(atrData);
  }

  /** Writes header data and length, then calls writeData. */
  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeCPRef(getNameIndex());
    ost.writeInt(getLength());
    writeData(ost);
  }

  /** Writes the actual attribute data. */
  public void writeData (JcfClassOutput ost) throws IOException
    { ost.write(atrData); }
}
