//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;
import lti.java.jcf.RuntimeConstants;       

public class CptUnicode extends CptGeneric implements RuntimeConstants
{
  public byte value[];
  CptUnicode (JcfClassInput ist, JcfConstantPool p, int i) throws IOException
  {
    super(ist, p, i);
    value = new byte[ist.readShort()];
    ist.readFully(value);
  }
  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeShort((short)(value.length));
    ost.write(value);
  }
  public int getTag() { return CONSTANT_UNICODE; }
}
