package http.utils.multipartrequest;

import java.io.IOException;

/**
	Wrapper for MultipartRequest
*/
public class CgiMultipartRequest extends MultipartRequest
{
	/** 
	 * Constructor.
	 *
	 * @param strSaveDirectory		The temporary directory to save the file from where they can then be moved to wherever by the
	 * 								calling process.  <b>If you specify <u>null</u> for this parameter, then any files uploaded
	 *								will be silently ignored.</B>
	 *
	 * @exception IllegalArgumentException 	If the System.getProperty("CONTENT_TYPE") does not contain a Content-Type of "multipart/form-data" or the boundary is not found.
	 * @exception IOException				If the System.getProperty("CONTENT_LENGTH") is higher than MAX_READ_BYTES or strSaveDirectory is invalid or cannot be written to.
	 *
	 * @see MultipartRequest#MAX_READ_BYTES
	 */
	public CgiMultipartRequest(String strSaveDirectory) throws IllegalArgumentException, IOException, NumberFormatException
	{
		super(null, 
			System.getProperty("CONTENT_TYPE"), 
			Integer.parseInt(System.getProperty("CONTENT_LENGTH")), 
			System.in, 
			strSaveDirectory,
			MultipartRequest.MAX_READ_BYTES);
	}

	/** 
	 * Constructor.
	 *
	 * @param strSaveDirectory		The temporary directory to save the file from where they can then be moved to wherever by the
	 * 								calling process.  <b>If you specify <u>null</u> for this parameter, then any files uploaded
	 *								will be silently ignored.</B>
	 * @param intMaxReadBytes		Overrides the MAX_BYTES_READ value, to allow arbitrarily long files.
	 *
	 * @exception IllegalArgumentException 	If the System.getProperty("CONTENT_TYPE") does not contain a Content-Type of "multipart/form-data" or the boundary is not found.
	 * @exception IOException				If the System.getProperty("CONTENT_LENGTH") is higher than MAX_READ_BYTES or strSaveDirectory is invalid or cannot be written to.
	 *
	 * @see MultipartRequest#MAX_READ_BYTES
	 */
	public CgiMultipartRequest(String strSaveDirectory, int intMaxReadBytes) throws IllegalArgumentException, IOException, NumberFormatException
	{
		super(null, 
			System.getProperty("CONTENT_TYPE"), 
			Integer.parseInt(System.getProperty("CONTENT_LENGTH")), 
			System.in, 
			strSaveDirectory,
			intMaxReadBytes);
	}

	/** 
	 * Constructor - load into memory constructor
	 *
	 * @param debug					A PrintWriter that can be used for debugging.
	 * @param intMaxReadBytes		Overrides the MAX_BYTES_READ value, to allow arbitrarily long files.
	 *
	 * @exception IllegalArgumentException 	If the System.getProperty("CONTENT_TYPE") does not contain a Content-Type of "multipart/form-data" or the boundary is not found.
	 * @exception IOException				If the System.getProperty("CONTENT_LENGTH") is higher than MAX_READ_BYTES or strSaveDirectory is invalid or cannot be written to.
	 *
	 * @see MultipartRequest#MAX_READ_BYTES
	 */
	public CgiMultipartRequest(int intMaxReadBytes) throws IllegalArgumentException, IOException, NumberFormatException
	{
 	    super(null, 
			System.getProperty("CONTENT_TYPE"), 
			Integer.parseInt(System.getProperty("CONTENT_LENGTH")), 
			System.in, 
			intMaxReadBytes);
	}
}