/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.platform.test;

import ccl.platform.Linux;
import ccl.platform.Native;
import ccl.util.Test;
import ccl.util.Util;

/**
 * Tests 'getPID()' on Linux.
 *
 * @version $Id: NativeTest.java,v 1.5 2003/05/01 16:44:00 clemens Exp clemens $
 * @author  Chr. Clemens Lee clemens@kclee.com
 */
public class NativeTest extends Test 
{
    public NativeTest() 
    {
        super();
    }

    public NativeTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * Insert your test code into the _doIt() method and
     * test bugs with 'bugIf( boolean expression );' or
     * 'bugIf( boolean expression, "comment about what went wrong" );'.
     * Then just invoke the main routine.
     *
     * @exception   Exception   whatever can go wrong.
     */
    protected void _doIt() 
        throws Exception
    {
        Native pNative = Native.getInstance();
        int pid = pNative.getPID();
        bugIf ( pid == -1 && Util.isOSLinux(),
                "PID on Linux is -1!" );
        if ( Util.isOSLinux() ) 
        {
            Linux linux = (Linux)pNative;
            for( int i = 0; i < 30; i++ )
            {
            int posixPID = linux.getPIDViaPOSIX();
            int procPID  = linux.getPIDViaProc();
            bugIf( posixPID <= 1 || procPID <= 1 );
            if ( posixPID != procPID ) 
            {
                bugIf( linux.getPGID( posixPID ) !=
                       linux.getPGID( procPID  )
                       , "pgid of posix pid "
                       + posixPID
                       + "is "
                       + linux.getPGID( posixPID )
                       + " while pgid of proc pid "
                       + procPID
                       + " is "
                       + linux.getPGID( procPID )
                       + "." );
            }
            else 
            {
                bugIf( false );
            }
            }
            /*Util.println( "pgrpid:    " + linux.getPGID( 0 ) );

            bugIf( linux.getPIDViaProc() != linux.getPIDViaPOSIX()
            , "PIDs differ: posix ("
            + linux.getPIDViaPOSIX()
            + ") and proc system ("
            + linux.getPIDViaProc()
            + ")." );

            bugIf( linux.getPIDViaProc() != linux.getMainJavaPID()
            , "PIDs differ: main pid ("
            + linux.getMainJavaPID()
            + ") and proc system ("
            + linux.getPIDViaProc()
            + ")." );*/
            /*int pid = linux.getPID();
              int procPid = linux.getPIDViaProc();
              while ( pid > 1 && pid != procPid ) {
              pid = linux.getPPID()
              bugIf( linux.getPIDViaProc() != linux.getMainJavaPID()
              , "PIDs differ: main pid ("
              + linux.getMainJavaPID()
              + ") and proc system ("
              + linux.getPIDViaProc()
              + ")." );
            */
            /*// performance test for getPIDViaProc
              Util.println( new Date().toString() );
              for( int i = 0; i < 100000; i++ ) {
              linux.getPIDViaPOSIX();
              }
              Util.println( new Date().toString() );

              // performance test for getPIDViaPOSIX
              Util.println( new Date().toString() );
              for( int i = 0; i < 100000; i++ ) {
              linux.getPIDViaProc();
              }
              Util.println( new Date().toString() );*/
        }
    }

    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test)(new NativeTest());
        pTest.setVerbose( true  );
        pTest.setTiming ( false );
        pTest.run();
        Test.printResult( pTest );

        System.exit( 0 );
    }
}
