/**
 * Redistribution and use of this software and associated documentation
 * ("Software"), with or without modification, are permitted provided
 * that the following conditions are met:
 *
 * 1. Redistributions of source code must retain copyright
 *    statements and notices.  Redistributions must also contain a
 *    copy of this document.
 *
 * 2. Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *
 * 3. The name "Exolab" must not be used to endorse or promote
 *    products derived from this Software without prior written
 *    permission of Intalio, Inc.  For written permission,
 *    please contact info@exolab.org.
 *
 * 4. Products derived from this Software may not be called "Exolab"
 *    nor may "Exolab" appear in their names without prior written
 *    permission of Intalio, Inc. Exolab is a registered
 *    trademark of Intalio, Inc.
 *
 * 5. Due credit should be given to the Exolab Project
 *    (http://www.exolab.org/).
 *
 * THIS SOFTWARE IS PROVIDED BY INTALIO, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * INTALIO, INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright 1999, 2000 (C) Intalio, Inc. All Rights Reserved.
 *
 * $Id: XMLNaming.java,v 1.2 2003/09/12 09:23:33 kvisco Exp $
 */

package org.exolab.castor.xml;

import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;

/**
 * An abstract class to handing XML naming
 * @author <a href="mailto:kvisco@intalio.com">Keith Visco</a>
 * @version $Revision: 1.2 $ $Date: 2003/09/12 09:23:33 $
**/
public abstract class XMLNaming {


    //--------------------/
    //- Abstract Methods -/
    //--------------------/
    
    /**
     * Creates the XML Name for the given class The actual
     * behavior of this method is determined by the
     * implementation. The only restriction is that the name
     * returned must be a valid xml name.
     * 
     * @param c the Class to create the XML Name for
     * @return the XML name based on the given class
    **/
    public abstract String createXMLName(Class c);

    
    /**
     * Converts the given String to an XML name. The actual
     * behavior of this method is determined by the
     * implementation. The only restriction is that the name
     * returned must be a valid xml name.
     *
     * @return an XML name based on the given String
    **/
    public abstract String toXMLName(String name);
    
    
    /**
     * Returns the default instance of XMLNaming
     * @see org.exolab.castor.util.Configuration
    **/
    public static final XMLNaming getInstance() {
        Configuration config = LocalConfiguration.getInstance();
        return config.getXMLNaming(); 
    } //-- getInstance
    
} //-- Naming
