/**
 * Redistribution and use of this software and associated documentation
 * ("Software"), with or without modification, are permitted provided
 * that the following conditions are met:
 *
 * 1. Redistributions of source code must retain copyright
 *    statements and notices.  Redistributions must also contain a
 *    copy of this document.
 *
 * 2. Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *
 * 3. The name "Exolab" must not be used to endorse or promote
 *    products derived from this Software without prior written
 *    permission of Intalio, Inc.  For written permission,
 *    please contact info@exolab.org.
 *
 * 4. Products derived from this Software may not be called "Exolab"
 *    nor may "Exolab" appear in their names without prior written
 *    permission of Intalio, Inc. Exolab is a registered
 *    trademark of Intalio, Inc.
 *
 * 5. Due credit should be given to the Exolab Project
 *    (http://www.exolab.org/).
 *
 * THIS SOFTWARE IS PROVIDED BY INTALIO, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * INTALIO, INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright 1999-2002 (C) Intalio, Inc. All Rights Reserved.
 *
 * $Id: XMLException.java,v 1.4 2004/10/05 20:25:33 wguttmann Exp $
 */

package org.exolab.castor.xml;

import org.exolab.castor.core.exceptions.CastorException;

/**
 * An exception that is used to signal an error that
 * has occured during marshalling or unmarshalling.
 *
 * @author <a href="mailto:kvisco@intalio.com">Keith Visco</a>
 * @version $Revision: 1.4 $ $Date: 2004/10/05 20:25:33 $
**/
public class XMLException extends CastorException {
    /**
     * The location for this Exception
    **/
    private Location  _location   = null;

    /**
     * The error code for this Exception
     */
    private int errorCode = -1;
    
    /**
     * Creates a new XMLException with no message
     * or nested Exception.
    **/
    public XMLException() {
        super();
    } //-- XMLException
    
    /**
     * Creates a new XMLException with the given message.
     *
     * @param message the message for this Exception
    **/
    public XMLException(String message) {
        super(message);
    } //-- XMLException(String)

    
    /**
     * Creates a new XMLException with the given nested
     * exception.
     *
     * @param exception the nested exception
    **/
    public XMLException(Throwable exception) {
        super(exception);
    } //-- XMLException(Exception)

    /**
     * Creates a new XMLException with the given message.
     *
     * @param message the message for this Exception
     * @param errorCode the errorCode for this Exception
    **/
    public XMLException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    } //-- XMLException(String)

    /**
     * Creates a new XMLException with the given message
     * and nested exception.
     *
     * @param message the detail message for this exception
     * @param exception the nested exception
    **/
    public XMLException(String message, Throwable exception) {
        super(message, exception);
    } //-- XMLException(String, Exception)

    /**
     * Creates a new XMLException with the given message,
     * nested exception, and errorCode.
     *
     * @param message the detail message for this exception
     * @param exception the nested exception
     * @param errorCode the errorCode for this Exception
    **/
    public XMLException
        (String message, Throwable exception, int errorCode) 
    {
    		super(message, exception);
    		this.errorCode = errorCode;
    } //-- XMLException(String, Exception, int)
    
    /**
     * Sets the location information for this Exception
     *
     * @param location, the location information for this validation
     * exception
    **/
    public void setLocation(Location location) {
        this._location = location;
    } //-- setLocation
    
    /**
     * Returns the String representation of this Exception.
     *
     * @return the String representation of this Exception.
    **/
    public String toString() {
        String message;

        Throwable t = getCause();
        if (t==null)
            message = getMessage();
        else
            message = t.getMessage();
        
        if (_location == null)
            return message;
        else
            return message + "{" + _location.toString() + "}";
    } //-- toString

    /**
     * Returns the error code for this Exception, or -1 if no error code exists.
     * 
     * @return the error code for this Exception, or -1 if no error code exists
     */
    public int getErrorCode() {
        return errorCode;
    }

    /**
     * Sets the error code for this Exception
     * 
     * @param errorCode the error code
     */
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }
    
} //-- XMLException
