/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import javax.security.jacc.EJBMethodPermission;

public final class EJBMethodPermissionCollection
extends PermissionCollection {
    private LinkedList collection = new LinkedList();
    private HashMap permissions = new HashMap();
    private static final String WILDCARD = new String("$WILDCARD");

    public void add(Permission permission) {
        String parametersKey;
        Object parameter;
        String interfaceKey;
        HashMap parameters;
        String methodKey;
        HashMap interfaces;
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Read only collection");
        }
        if (!(permission instanceof EJBMethodPermission)) {
            throw new IllegalArgumentException("Wrong permission type");
        }
        if (this.collection.contains(permission)) {
            return;
        }
        this.collection.add(permission);
        EJBMethodPermission p = (EJBMethodPermission)permission;
        EJBMethodPermission.MethodSpec spec = p.methodSpec;
        Object test = this.permissions.get(p.getName());
        if (test instanceof Boolean) {
            return;
        }
        if (spec.methodName == null && spec.methodInterface == null && spec.methodParams == null) {
            this.permissions.put(p.getName(), new Boolean(true));
            return;
        }
        HashMap methods = (HashMap)test;
        if (methods == null) {
            methods = new HashMap();
            this.permissions.put(p.getName(), methods);
        }
        if ((interfaces = (HashMap)methods.get(methodKey = spec.methodName == null || spec.methodName.length() == 0 ? WILDCARD : spec.methodName)) == null) {
            interfaces = new HashMap();
            methods.put(methodKey, interfaces);
        }
        if ((parameters = (HashMap)interfaces.get(interfaceKey = spec.methodInterface == null || spec.methodInterface.length() == 0 ? WILDCARD : spec.methodInterface)) == null) {
            parameters = new HashMap();
            interfaces.put(interfaceKey, parameters);
        }
        if ((parameter = parameters.get(parametersKey = spec.methodParams == null ? WILDCARD : spec.methodParams)) == null) {
            parameter = new Boolean(true);
            parameters.put(parametersKey, parameter);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission p = (EJBMethodPermission)permission;
        EJBMethodPermission.MethodSpec spec = p.methodSpec;
        Object test = this.permissions.get(p.getName());
        if (test == null) {
            return false;
        }
        if (test instanceof Boolean) {
            return true;
        }
        HashMap methods = (HashMap)test;
        String methodKey = spec.methodName == null || spec.methodName.length() == 0 ? WILDCARD : spec.methodName;
        HashMap interfaces = (HashMap)methods.get(methodKey);
        if (this.methodImplies(interfaces, spec)) {
            return true;
        }
        if (methodKey != WILDCARD) {
            return this.methodImplies((HashMap)methods.get(WILDCARD), spec);
        }
        return false;
    }

    protected boolean methodImplies(HashMap interfaces, EJBMethodPermission.MethodSpec spec) {
        if (interfaces == null) {
            return false;
        }
        String interfaceKey = spec.methodInterface == null || spec.methodInterface.length() == 0 ? WILDCARD : spec.methodInterface;
        HashMap parameters = (HashMap)interfaces.get(interfaceKey);
        if (this.interfaceImplies(parameters, spec)) {
            return true;
        }
        if (interfaceKey != WILDCARD) {
            return this.interfaceImplies((HashMap)interfaces.get(WILDCARD), spec);
        }
        return false;
    }

    protected boolean interfaceImplies(HashMap parameters, EJBMethodPermission.MethodSpec spec) {
        if (parameters == null) {
            return false;
        }
        String parametersKey = spec.methodParams == null ? WILDCARD : spec.methodParams;
        Object parameter = parameters.get(parametersKey);
        if (parameter != null) {
            return true;
        }
        if (parametersKey != WILDCARD) {
            return parameters.containsKey(WILDCARD);
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.collection);
    }
}

