/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.activation.DataSource;

public class URLDataSource
implements DataSource {
    private URL url;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public URLDataSource(URL url) {
        this.url = url;
    }

    public String getContentType() {
        URLConnection connection = null;
        try {
            connection = this.url.openConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (connection == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        return connection.getContentType();
    }

    public String getName() {
        return this.url.getFile();
    }

    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    public OutputStream getOutputStream() throws IOException {
        URLConnection connection = this.url.openConnection();
        if (connection == null) {
            return null;
        }
        connection.setDoOutput(true);
        return connection.getOutputStream();
    }

    public URL getURL() {
        return this.url;
    }
}

