/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.util;

import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.helpers.AttributeListImpl;

public final class Namespaces {
    public static final String XML_NAMESPACE_PREFIX = "xml";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private Namespace _first = null;
    private Namespace _last = null;
    private Namespaces _parent = null;
    private static final String CDATA = "CDATA";
    private static final String XMLNS = "xmlns";

    public Namespaces() {
    }

    public Namespaces(Namespaces namespaces) {
        this._parent = namespaces;
    }

    public synchronized void addNamespace(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if (string == null) {
            string = "";
        }
        if (XML_NAMESPACE_PREFIX.equalsIgnoreCase(string)) {
            if (!XML_NAMESPACE.equals(string2)) {
                String string3 = "The prefix 'xml' is reserved (XML 1.0 Specification) and cannot be declared.";
                throw new IllegalArgumentException(string3);
            }
            return;
        }
        if (XML_NAMESPACE.equals(string2)) {
            String string4 = "The namespace 'http://www.w3.org/XML/1998/namespace";
            string4 = String.valueOf(string4) + "' is reserved (XML 1.0 Specification) and cannot be declared.";
            throw new IllegalArgumentException(string4);
        }
        if (this._first == null) {
            this._last = this._first = new Namespace(string, string2);
        } else {
            boolean bl = false;
            Namespace namespace = this._first;
            while (namespace != null) {
                if (namespace.prefix.equals(string)) {
                    bl = true;
                    namespace.uri = string2;
                    break;
                }
                namespace = namespace.next;
            }
            if (!bl) {
                this._last = this._last.next = new Namespace(string, string2);
            }
        }
    }

    public Namespaces createNamespaces() {
        return new Namespaces(this);
    }

    public void declareAsAttributes(AttributeListImpl attributeListImpl, boolean bl) {
        Namespace namespace = this._first;
        String string = null;
        while (namespace != null) {
            if (namespace.prefix != null) {
                int n = namespace.prefix.length();
                if (n > 0) {
                    StringBuffer stringBuffer = new StringBuffer(6 + n);
                    stringBuffer.append(XMLNS);
                    stringBuffer.append(':');
                    stringBuffer.append(namespace.prefix);
                    string = stringBuffer.toString();
                    attributeListImpl.addAttribute(string, CDATA, namespace.uri);
                } else {
                    attributeListImpl.addAttribute(XMLNS, CDATA, namespace.uri);
                }
            } else {
                attributeListImpl.addAttribute(XMLNS, CDATA, namespace.uri);
            }
            namespace = namespace.next;
        }
        if (!bl && this._parent != null) {
            this._parent.declareAsAttributes(attributeListImpl, false);
        }
    }

    public Enumeration getLocalNamespacePrefixes() {
        return new NamespaceEnumerator(this._first, 1);
    }

    public Enumeration getLocalNamespaces() {
        return new NamespaceEnumerator(this._first);
    }

    public String getNamespacePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI must not be null.");
        }
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.uri.equals(string)) {
                return namespace.prefix;
            }
            namespace = namespace.next;
        }
        if (this._parent != null) {
            return this._parent.getNamespacePrefix(string);
        }
        if (XML_NAMESPACE.equals(string)) {
            return XML_NAMESPACE_PREFIX;
        }
        return null;
    }

    public String[] getNamespacePrefixes(String string) {
        return this.getNamespacePrefixes(string, false);
    }

    public String[] getNamespacePrefixes(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI must not be null.");
        }
        Vector vector = new Vector(3);
        this.getNamespacePrefixes(string, bl, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void getNamespacePrefixes(String string, boolean bl, Vector vector) {
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.uri.equals(string)) {
                vector.addElement(namespace.prefix);
            }
            namespace = namespace.next;
        }
        if (this._parent != null && !bl) {
            this._parent.getNamespacePrefixes(string, bl, vector);
        }
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.prefix.equals(string)) {
                return namespace.uri;
            }
            namespace = namespace.next;
        }
        if (this._parent != null) {
            return this._parent.getNamespaceURI(string);
        }
        if (XML_NAMESPACE_PREFIX.equals(string)) {
            return XML_NAMESPACE;
        }
        return null;
    }

    public String getNonDefaultNamespacePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI must not be null.");
        }
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.uri.equals(string) && namespace.prefix.length() > 0) {
                return namespace.prefix;
            }
            namespace = namespace.next;
        }
        if (this._parent != null) {
            return this._parent.getNonDefaultNamespacePrefix(string);
        }
        if (XML_NAMESPACE.equals(string)) {
            return XML_NAMESPACE_PREFIX;
        }
        return null;
    }

    public Namespaces getParent() {
        return this._parent;
    }

    public synchronized boolean removeNamespace(String string) {
        if (string == null) {
            return false;
        }
        Namespace namespace = this._first;
        Namespace namespace2 = null;
        while (namespace != null) {
            if (namespace.prefix.equals(string)) {
                if (namespace == this._first) {
                    this._first = this._first.next;
                    if (this._last == namespace) {
                        this._last = null;
                    }
                } else {
                    namespace2.next = namespace.next;
                    if (this._last == namespace) {
                        this._last = namespace2;
                    }
                }
                return true;
            }
            namespace2 = namespace;
            namespace = namespace.next;
        }
        return false;
    }

    public void setParent(Namespaces namespaces) {
        this._parent = namespaces;
    }

    class Namespace {
        String prefix = null;
        String uri = null;
        Namespace next = null;

        Namespace() {
        }

        Namespace(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
        }
    }

    static class NamespaceEnumerator
    implements Enumeration {
        public static final int URI = 0;
        public static final int PREFIX = 1;
        private Namespace _namespace = null;
        private int _returnType = 0;

        NamespaceEnumerator(Namespace namespace) {
            this._namespace = namespace;
        }

        NamespaceEnumerator(Namespace namespace, int n) {
            this._namespace = namespace;
            this._returnType = n;
        }

        public boolean hasMoreElements() {
            return this._namespace != null;
        }

        public Object nextElement() {
            String string = null;
            if (this._namespace != null) {
                string = this._returnType == 0 ? this._namespace.uri : this._namespace.prefix;
                this._namespace = this._namespace.next;
            }
            return string;
        }
    }
}

