/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.exolab.adaptx.xpath.XPathNode;

public class XPNWriter {
    private static final String ENTITY_AMP = "&amp;";
    private static final String ENTITY_GT = "&gt;";
    private static final String ENTITY_LT = "&lt;";
    private static final String ENTITY_QUOT = "&quot;";
    private static final String ENTITY_APOS = "&apos;";
    private static final String XML_DECL_BEGIN = "<?xml ";
    private static final String XML_DECL_END = "?>\n";
    private static final String COMMENT_BEGIN = "<-- ";
    private static final String COMMENT_END = " -->";
    private static final String PI_BEGIN = "<?";
    private static final String PI_END = "?>";
    private static final String VERSION_ATTR = "version";
    private static final String REUSE_ERR = "This XPNWriter was previously used. Please create a new one.";
    private OutputStream _os = null;
    private Writer _writer = null;
    private boolean _saveLocation = false;
    private boolean _usable = true;
    private String _encoding = "UTF-8";
    private boolean _indent = false;
    private String _indentStr = "  ";

    public XPNWriter(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            String string = "The argument 'os' must not be null.";
            throw new IllegalArgumentException(string);
        }
        this._os = outputStream;
    }

    public void setEncoding(String string) {
        this._encoding = string == null ? "UTF-8" : string;
    }

    public void setIndentation(boolean bl) {
        this._indent = bl;
    }

    private void write(String string, boolean bl) throws IOException {
        this.write(string.toCharArray(), bl);
    }

    public void write(XPathNode xPathNode) throws IOException {
        if (this._writer == null) {
            this._writer = new OutputStreamWriter(this._os, this._encoding);
        }
        this.write(xPathNode, "");
    }

    /*
     * Unable to fully structure code
     */
    private void write(XPathNode var1_1, String var2_2) throws IOException {
        if (var1_1 == null) {
            return;
        }
        switch (var1_1.getNodeType()) {
            case 9: {
                this._writer.write("<?xml ");
                this._writer.write(" version=\"1.0\"");
                this._writer.write("?>\n");
                var3_3 = var1_1.getFirstChild();
                while (var3_3 != null) {
                    this.write(var3_3, "");
                    var3_3 = var3_3.getNext();
                }
                break;
            }
            case 2: {
                var3_4 = var1_1.getNamespaceURI();
                var4_7 = null;
                if (var3_4 != null && var3_4.length() > 0) {
                    var4_7 = var1_1.getNamespacePrefix(var3_4);
                }
                var5_9 = var1_1.getLocalName();
                if (var4_7 != null && var4_7.length() > 0) {
                    var5_9 = String.valueOf(var4_7) + ':' + var5_9;
                }
                this._writer.write(32);
                this._writer.write(var5_9);
                this._writer.write("=\"");
                this.write(var1_1.getStringValue(), true);
                this._writer.write(34);
                break;
            }
            case 13: {
                this._writer.write(32);
                this._writer.write("xmlns");
                var3_5 = var1_1.getLocalName();
                if (var3_5 != null && var3_5.length() > 0) {
                    this._writer.write(58);
                    this._writer.write(var3_5);
                }
                this._writer.write("=\"");
                this._writer.write(var1_1.getStringValue());
                this._writer.write(34);
                break;
            }
            case 1: {
                var3_6 = var1_1.getNamespaceURI();
                var4_8 = null;
                if (var3_6 != null && var3_6.length() > 0) {
                    var4_8 = var1_1.getNamespacePrefix(var3_6);
                }
                var5_10 = var1_1.getLocalName();
                if (var4_8 != null && var4_8.length() > 0) {
                    var5_10 = String.valueOf(var4_8) + ':' + var5_10;
                }
                if (this._indent) {
                    this._writer.write(var2_2);
                }
                this._writer.write(60);
                this._writer.write(var5_10);
                var6_11 = var1_1.getFirstNamespace();
                while (var6_11 != null) {
                    this.write(var6_11, "");
                    var6_11 = var6_11.getNext();
                }
                var7_12 = var1_1.getFirstAttribute();
                while (var7_12 != null) {
                    this.write(var7_12, "");
                    var7_12 = var7_12.getNext();
                }
                var8_13 = var1_1.getFirstChild();
                if (var8_13 == null) ** GOTO lbl67
                this._writer.write(62);
                if (!this._indent) ** GOTO lbl74
                this._writer.write(10);
                if (true) ** GOTO lbl74
lbl67:
                // 1 sources

                this._writer.write("/>");
                if (!this._indent) break;
                this._writer.write(10);
                break;
                do {
                    this.write(var8_13, String.valueOf(var2_2) + this._indentStr);
                    var8_13 = var8_13.getNext();
lbl74:
                    // 3 sources

                } while (var8_13 != null);
                if (this._indent) {
                    this._writer.write(var2_2);
                }
                this._writer.write("</");
                this._writer.write(var5_10);
                this._writer.write(62);
                if (!this._indent) break;
                this._writer.write(10);
                break;
            }
            case 3: {
                if (this._indent) {
                    this._writer.write(var2_2);
                }
                this.write(var1_1.getStringValue(), false);
                if (!this._indent) break;
                this._writer.write(10);
                break;
            }
            case 8: {
                if (this._indent) {
                    this._writer.write(var2_2);
                }
                this._writer.write("<-- ");
                this._writer.write(var1_1.getStringValue());
                this._writer.write(" -->");
                if (!this._indent) break;
                this._writer.write(10);
                break;
            }
            case 7: {
                if (this._indent) {
                    this._writer.write(var2_2);
                }
                this._writer.write("<?");
                this._writer.write(var1_1.getLocalName());
                this._writer.write(32);
                this._writer.write(var1_1.getStringValue());
                this._writer.write("?>");
                if (!this._indent) break;
                this._writer.write(10);
                break;
            }
        }
        this._writer.flush();
    }

    private void write(char[] cArray, boolean bl) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            switch (cArray[n3]) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    char c = cArray[n3];
                    if (n2 > 0) {
                        this._writer.write(cArray, n, n2);
                        n += n2;
                        n2 = 0;
                    }
                    ++n;
                    if (c == '&') {
                        this._writer.write(ENTITY_AMP);
                        break;
                    }
                    if (c == '>') {
                        this._writer.write(ENTITY_GT);
                        break;
                    }
                    if (c == '<') {
                        this._writer.write(ENTITY_LT);
                        break;
                    }
                    if (c == '\'') {
                        if (bl) {
                            this._writer.write(ENTITY_APOS);
                            break;
                        }
                        this._writer.write(c);
                        break;
                    }
                    if (c != '\"') break;
                    if (bl) {
                        this._writer.write(ENTITY_QUOT);
                        break;
                    }
                    this._writer.write(c);
                    break;
                }
                default: {
                    ++n2;
                    break;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            this._writer.write(cArray, n, n2);
        }
    }
}

