/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.exolab.adaptx.net.URIException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.URIResolver;
import org.exolab.adaptx.net.impl.URILocationImpl;
import org.exolab.adaptx.net.impl.URIResolverImpl;
import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.util.ErrorObserverAdapter;
import org.exolab.adaptx.xml.DOM2SAX;
import org.exolab.adaptx.xml.DOMURILocation;
import org.exolab.adaptx.xml.SAXURILocation;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.util.Configuration;
import org.exolab.adaptx.xslt.util.DefaultObserver;
import org.exolab.adaptx.xslt.util.StylesheetHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XSLTReader
extends ErrorObserverAdapter {
    private static final String _MISSING_DOCUMENT_ELEMENT_ERR = "invalid stylesheet, missing document element.";
    private static final String _UNABLE_TO_CREATE_PARSER_ERR = "unable to create a SAX or DOM based XML parser.";
    private DOMParser _domParser = null;
    private static ErrorObserver _errorObserver = new DefaultObserver();
    private boolean _removeDefaultErrorObserver = true;
    private URIResolver _resolver = null;
    private EntityResolver _entityResolver = null;

    public XSLTReader() {
        super.addErrorObserver(_errorObserver);
    }

    public XSLTReader(URIResolver uRIResolver) {
        this();
        this._resolver = uRIResolver;
    }

    public void addErrorObserver(ErrorObserver errorObserver) {
        if (errorObserver == null) {
            return;
        }
        if (this._removeDefaultErrorObserver) {
            this.removeErrorObserver(_errorObserver);
            this._removeDefaultErrorObserver = false;
        }
        super.addErrorObserver(errorObserver);
    }

    public URIResolver getURIResolver() {
        if (this._resolver == null) {
            this._resolver = new URIResolverImpl();
        }
        return this._resolver;
    }

    public XSLTStylesheet read(String string) throws XSLException, IOException {
        return this.read(string, null);
    }

    public XSLTStylesheet read(String string, String string2) throws XSLException, IOException {
        URILocation uRILocation = null;
        try {
            uRILocation = this.getURIResolver().resolve(string, string2);
        }
        catch (URIException uRIException) {
            this.receiveError((Exception)uRIException, 0);
        }
        return this.read(uRILocation);
    }

    public XSLTStylesheet read(URL uRL) throws XSLException, IOException {
        InputStream inputStream = uRL.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return this.read(new URILocationImpl(inputStreamReader, uRL.toString()));
    }

    public XSLTStylesheet read(URILocation uRILocation) throws XSLException, IOException {
        Object object;
        Object object2;
        if (uRILocation instanceof DOMURILocation) {
            DOMURILocation dOMURILocation = (DOMURILocation)uRILocation;
            return this.read(dOMURILocation.getNode(), uRILocation.getAbsoluteURI());
        }
        if (uRILocation instanceof SAXURILocation && (object2 = ((SAXURILocation)(object = (SAXURILocation)uRILocation)).getXMLReader()) != null) {
            return this.read(((SAXURILocation)object).getInputSource(), uRILocation, (XMLReader)object2);
        }
        object = Configuration.getSAXParser();
        if (object != null) {
            object2 = new InputSource();
            ((InputSource)object2).setSystemId(uRILocation.getAbsoluteURI());
            ((InputSource)object2).setCharacterStream(uRILocation.getReader());
            return this.read((InputSource)object2, uRILocation, (Parser)object);
        }
        object2 = Configuration.getDOMParser();
        if (object2 == null) {
            String string = "XSLReader: unable to create a SAX or DOM based XML parser.";
            throw new XSLException(string);
        }
        Document document = object2.readDocument(uRILocation, this);
        return this.read(document, uRILocation.getAbsoluteURI());
    }

    public XSLTStylesheet read(Document document, String string) throws XSLException {
        StylesheetHandler stylesheetHandler = new StylesheetHandler(this);
        XSLTStylesheet xSLTStylesheet = stylesheetHandler.getStylesheet();
        if (string != null) {
            xSLTStylesheet.setURILocation(new URILocationImpl(string));
        }
        if (document == null) {
            return xSLTStylesheet;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new XSLException(_MISSING_DOCUMENT_ELEMENT_ERR);
        }
        try {
            DOM2SAX.process(document, (DocumentHandler)stylesheetHandler);
        }
        catch (SAXException sAXException) {
            String string2 = sAXException.getMessage();
            Exception exception = sAXException.getException();
            if (exception != null && string2 == null) {
                string2 = exception.getMessage();
            }
            if (string2 == null) {
                string2 = "XSLReader: stylesheet parse error.";
            }
            throw new XSLException(string2);
        }
        return xSLTStylesheet;
    }

    public XSLTStylesheet read(Node node, String string) throws XSLException {
        StylesheetHandler stylesheetHandler = new StylesheetHandler(this);
        XSLTStylesheet xSLTStylesheet = stylesheetHandler.getStylesheet();
        if (string != null) {
            xSLTStylesheet.setURILocation(new URILocationImpl(string));
        }
        if (node == null) {
            return xSLTStylesheet;
        }
        try {
            DOM2SAX.process(node, (DocumentHandler)stylesheetHandler);
        }
        catch (SAXException sAXException) {
            String string2 = sAXException.getMessage();
            Exception exception = sAXException.getException();
            if (exception != null && string2 == null) {
                string2 = exception.getMessage();
            }
            if (string2 == null) {
                string2 = "XSLReader: stylesheet parse error.";
            }
            throw new XSLException(string2);
        }
        return xSLTStylesheet;
    }

    public XSLTStylesheet read(InputSource inputSource) throws XSLException, IOException {
        Parser parser = Configuration.getSAXParser();
        if (parser == null) {
            throw new XSLException("Unable to create SAX Parser!");
        }
        String string = inputSource.getSystemId();
        if (string == null) {
            string = inputSource.getPublicId();
        }
        URILocationImpl uRILocationImpl = new URILocationImpl(string);
        return this.read(inputSource, (URILocation)uRILocationImpl, parser);
    }

    private XSLTStylesheet read(InputSource inputSource, URILocation uRILocation, Parser parser) throws XSLException, IOException {
        StylesheetHandler stylesheetHandler = new StylesheetHandler(this);
        XSLTStylesheet xSLTStylesheet = stylesheetHandler.getStylesheet();
        xSLTStylesheet.setURILocation(uRILocation);
        parser.setDocumentHandler(stylesheetHandler);
        if (this._entityResolver != null) {
            parser.setEntityResolver(this._entityResolver);
        }
        try {
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            SAXParseException sAXParseException = null;
            Exception exception = sAXException.getException();
            if (sAXException instanceof SAXParseException) {
                sAXParseException = (SAXParseException)sAXException;
            } else if (exception != null && exception instanceof SAXParseException) {
                sAXParseException = (SAXParseException)exception;
            }
            if (sAXParseException != null) {
                StringBuffer stringBuffer = new StringBuffer(((SAXException)sAXParseException).toString());
                stringBuffer.append("\n - ");
                stringBuffer.append(sAXParseException.getSystemId());
                stringBuffer.append("; line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append(", column: ");
                stringBuffer.append(sAXParseException.getColumnNumber());
                this.receiveError(stringBuffer.toString());
                throw new XSLException(stringBuffer.toString());
            }
            this.receiveError(sAXException.toString());
            throw new XSLException(sAXException.toString());
        }
        return xSLTStylesheet;
    }

    private XSLTStylesheet read(InputSource inputSource, URILocation uRILocation, XMLReader xMLReader) throws XSLException, IOException {
        StylesheetHandler stylesheetHandler = new StylesheetHandler(this);
        XSLTStylesheet xSLTStylesheet = stylesheetHandler.getStylesheet();
        xSLTStylesheet.setURILocation(uRILocation);
        xMLReader.setContentHandler(stylesheetHandler);
        if (this._entityResolver != null) {
            xMLReader.setEntityResolver(this._entityResolver);
        }
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            SAXParseException sAXParseException = null;
            Exception exception = sAXException.getException();
            if (sAXException instanceof SAXParseException) {
                sAXParseException = (SAXParseException)sAXException;
            } else if (exception != null && exception instanceof SAXParseException) {
                sAXParseException = (SAXParseException)exception;
            }
            if (sAXParseException != null) {
                StringBuffer stringBuffer = new StringBuffer(((SAXException)sAXParseException).toString());
                stringBuffer.append("\n - ");
                stringBuffer.append(sAXParseException.getSystemId());
                stringBuffer.append("; line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append(", column: ");
                stringBuffer.append(sAXParseException.getColumnNumber());
                this.receiveError(stringBuffer.toString());
                throw new XSLException(stringBuffer.toString());
            }
            this.receiveError(sAXException.toString());
            throw new XSLException(sAXException.toString());
        }
        return xSLTStylesheet;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._resolver = uRIResolver;
    }
}

