/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.functions.FunctionCallImpl;

public class LangFunctionCall
extends FunctionCallImpl {
    private static final String XML_LANG = "xml:lang";
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";

    public LangFunctionCall() {
        super("lang");
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.getParameterCount() != 1) {
            throw new XPathException("invalid number of parameters for function: " + this);
        }
        String string = this.getParameter(0).evaluate(xPathContext).stringValue();
        XPathNode xPathNode = xPathContext.getNode();
        String string2 = this.getLangAttr(xPathNode);
        if (string2 == null) {
            return BooleanResult.FALSE;
        }
        if (string2.equalsIgnoreCase(string)) {
            return BooleanResult.TRUE;
        }
        int n = string2.indexOf(45);
        if (n >= 0 && (string2 = string2.substring(0, n)).equalsIgnoreCase(string)) {
            return BooleanResult.TRUE;
        }
        return BooleanResult.FALSE;
    }

    private String getLangAttr(XPathNode xPathNode) {
        String string = null;
        if (xPathNode == null) {
            return null;
        }
        if (xPathNode.getNodeType() != 1) {
            xPathNode = xPathNode.getParentNode();
        }
        while (xPathNode != null) {
            if (xPathNode.getNodeType() != 1) break;
            string = xPathNode.getAttribute(XML_NS, XML_LANG);
            if (string == null) {
                string = xPathNode.getAttribute("", XML_LANG);
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            xPathNode = xPathNode.getParentNode();
        }
        return string;
    }
}

