/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.NodeExpressionImpl;

class AttributeExpr
extends NodeExpressionImpl {
    private static final String WILD_CARD = "*";
    private static final String UNRESOLVABLE_PREFIX_ERROR = "Unable to resolve namespace from prefix: ";
    private final String _local;
    private final String _prefix;

    AttributeExpr(String string) throws XPathException {
        if (string == null) {
            throw new XPathException("Argument qname is null");
        }
        if (string.equals(WILD_CARD)) {
            this._local = WILD_CARD;
            this._prefix = null;
        } else {
            int n = string.indexOf(58);
            if (n >= 1) {
                this._local = string.substring(n + 1);
                this._prefix = string.substring(0, n);
            } else {
                this._local = string;
                this._prefix = null;
            }
        }
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        if (xPathNode == null) {
            return xPathContext.newNodeSet();
        }
        if (xPathNode.getNodeType() == 1) {
            if (WILD_CARD.equals(this._local)) {
                NodeSet nodeSet = xPathContext.newNodeSet();
                XPathNode xPathNode2 = xPathNode.getFirstAttribute();
                while (xPathNode2 != null) {
                    nodeSet.add(xPathNode2);
                    xPathNode2 = xPathNode2.getNext();
                }
                return nodeSet;
            }
            String string = "";
            if (this._prefix != null && (string = xPathContext.getNamespaceURI(this._prefix)) == null) {
                String string2 = UNRESOLVABLE_PREFIX_ERROR + this._prefix;
                throw new XPathException(string2);
            }
            XPathNode xPathNode3 = xPathNode.getFirstAttribute();
            while (xPathNode3 != null) {
                if (xPathNode3.getLocalName().equals(this._local) && this.nsEquals(string, xPathNode3.getNamespaceURI())) {
                    NodeSet nodeSet = xPathContext.newNodeSet(1);
                    nodeSet.add(xPathNode3);
                    return nodeSet;
                }
                xPathNode3 = xPathNode3.getNext();
            }
        }
        return xPathContext.newNodeSet();
    }

    public double getDefaultPriority() {
        if (WILD_CARD.equals(this._local)) {
            return -0.25;
        }
        return 0.0;
    }

    public short getExprType() {
        return 7;
    }

    public String getName() {
        return this._prefix == null ? this._local : String.valueOf(this._prefix) + ':' + this._local;
    }

    public short getNodeExprType() {
        return 1;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (xPathNode == null) {
            return false;
        }
        String string = "";
        if (this._prefix != null && (string = xPathContext.getNamespaceURI(this._prefix)) == null) {
            String string2 = UNRESOLVABLE_PREFIX_ERROR + this._prefix;
            throw new XPathException(string2);
        }
        if (xPathNode.getNodeType() == 2) {
            return WILD_CARD.equals(this._local) || xPathNode.getLocalName().equals(this._local) && this.nsEquals(string, xPathNode.getNamespaceURI());
        }
        return false;
    }

    private boolean nsEquals(String string, String string2) {
        if (string == null) {
            return string2 == null || string2.length() == 0;
        }
        if (string2 == null) {
            return string.length() == 0;
        }
        return string.equals(string2);
    }

    public String toString() {
        return this.getName();
    }
}

