/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath;

import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;

public final class NodeSet
extends XPathResult {
    private int DefaultSize = 8;
    private XPathNode[] _nodes;
    private int _count;

    public NodeSet() {
    }

    public NodeSet(int n) {
        if (n > 0) {
            this._nodes = new XPathNode[n];
        }
    }

    public NodeSet(XPathNode xPathNode) {
        if (xPathNode == null) {
            throw new IllegalArgumentException("Argument node is null");
        }
        this._nodes = new XPathNode[1];
        this._nodes[0] = xPathNode;
        this._count = 1;
    }

    public void add(NodeSet nodeSet) {
        if (nodeSet == null) {
            throw new IllegalArgumentException("Argument nodeSet is null");
        }
        int n = nodeSet.size();
        if (this._nodes == null || this._count == 0) {
            this.ensureSize(n);
            int n2 = 0;
            while (n2 < n) {
                this._nodes[this._count++] = nodeSet.item(n2);
                ++n2;
            }
        } else {
            this.ensureSize(n);
            int n3 = this._count;
            int n4 = 0;
            while (n4 < n) {
                XPathNode xPathNode = nodeSet.item(n4);
                int n5 = 0;
                while (n5 < n3) {
                    if (this._nodes[n5].equals(xPathNode)) break;
                    ++n5;
                }
                if (n5 == n3) {
                    this._nodes[this._count++] = xPathNode;
                }
                ++n4;
            }
        }
    }

    public void add(NodeSet nodeSet, boolean bl) {
        if (nodeSet == null) {
            throw new IllegalArgumentException("Argument nodeSet is null");
        }
        int n = nodeSet.size();
        if (this._nodes == null || this._count == 0) {
            this.ensureSize(n);
            int n2 = 0;
            while (n2 < n) {
                this._nodes[this._count++] = nodeSet.item(n2);
                ++n2;
            }
        } else if (bl) {
            this.ensureSize(n);
            int n3 = 0;
            while (n3 < n) {
                this._nodes[this._count++] = nodeSet.item(n3);
                ++n3;
            }
        } else {
            this.ensureSize(n);
            int n4 = this._count;
            int n5 = 0;
            while (n5 < n) {
                XPathNode xPathNode = nodeSet.item(n5);
                int n6 = 0;
                while (n6 < n4) {
                    if (this._nodes[n6].equals(xPathNode)) break;
                    ++n6;
                }
                if (n6 == n4) {
                    this._nodes[this._count++] = xPathNode;
                }
                ++n5;
            }
        }
    }

    public boolean add(XPathNode xPathNode) {
        if (xPathNode == null) {
            throw new IllegalArgumentException("Argument node is null");
        }
        if (this._nodes == null) {
            this.increaseSize();
        } else if (this._count == 0) {
            if (this._count == this._nodes.length) {
                this.increaseSize();
            }
        } else {
            int n = 0;
            while (n < this._count) {
                if (this._nodes[n].equals(xPathNode)) {
                    return false;
                }
                ++n;
            }
            if (this._count == this._nodes.length) {
                this.increaseSize();
            }
        }
        this._nodes[this._count++] = xPathNode;
        return true;
    }

    public boolean add(XPathNode xPathNode, boolean bl) {
        if (this._nodes == null) {
            this.increaseSize();
        } else if (this._count == 0) {
            if (this._count == this._nodes.length) {
                this.increaseSize();
            }
        } else {
            if (!bl) {
                int n = 0;
                while (n < this._count) {
                    if (this._nodes[n].equals(xPathNode)) {
                        return false;
                    }
                    ++n;
                }
            }
            if (this._count == this._nodes.length) {
                this.increaseSize();
            }
        }
        this._nodes[this._count++] = xPathNode;
        return true;
    }

    public boolean booleanValue() {
        return this._count > 0;
    }

    public void clear() {
        if (this._nodes != null) {
            int n = 0;
            while (n < this._count) {
                this._nodes[n] = null;
                ++n;
            }
        }
        this._count = 0;
    }

    public boolean contains(XPathNode xPathNode) {
        int n = 0;
        while (n < this._count) {
            if (this._nodes[n] == xPathNode) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void ensureSize(int n) {
        if (this._nodes == null) {
            this._nodes = new XPathNode[n];
        } else if (n > this._nodes.length - this._count) {
            XPathNode[] xPathNodeArray = new XPathNode[this._count + n];
            int n2 = 0;
            while (n2 < this._count) {
                xPathNodeArray[n2] = this._nodes[n2];
                ++n2;
            }
            this._nodes = xPathNodeArray;
        }
    }

    public boolean equals(XPathResult xPathResult) {
        if (xPathResult == this) {
            return true;
        }
        if (xPathResult != null && xPathResult instanceof NodeSet) {
            NodeSet nodeSet = (NodeSet)xPathResult;
            if (this._count != nodeSet._count) {
                return false;
            }
            int n = 0;
            while (n < this._count) {
                if (!nodeSet.contains(this._nodes[n])) {
                    return false;
                }
                ++n;
            }
        }
        return false;
    }

    public int getResultType() {
        return 3;
    }

    private void increaseSize() {
        if (this._nodes == null) {
            this._nodes = new XPathNode[this.DefaultSize];
        } else {
            XPathNode[] xPathNodeArray = new XPathNode[this._count + this.DefaultSize];
            int n = 0;
            while (n < this._count) {
                xPathNodeArray[n] = this._nodes[n];
                ++n;
            }
            this._nodes = xPathNodeArray;
        }
    }

    public int indexOf(XPathNode xPathNode) {
        int n = 0;
        while (n < this._count) {
            if (this._nodes[n] == xPathNode) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public XPathNode item(int n) {
        if (this._nodes == null) {
            throw new IndexOutOfBoundsException();
        }
        if (n < 0 || n >= this._count) {
            throw new IndexOutOfBoundsException();
        }
        return this._nodes[n];
    }

    public Object javaObject() {
        return this;
    }

    public double numberValue() {
        if (this._count > 0) {
            try {
                Double d = Double.valueOf(this.stringValue());
                return d;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return Double.NaN;
    }

    public void remove(int n) {
        if (this._nodes == null) {
            throw new IndexOutOfBoundsException();
        }
        if (n < 0 || n >= this._count) {
            throw new IndexOutOfBoundsException();
        }
        ++n;
        while (n < this._count) {
            this._nodes[n - 1] = this._nodes[n];
            ++n;
        }
        --this._count;
    }

    public boolean remove(XPathNode xPathNode) {
        int n = 0;
        while (n < this._count) {
            if (this._nodes[n] == xPathNode) {
                this._nodes[n] = null;
                ++n;
                while (n < this._count) {
                    this._nodes[n - 1] = this._nodes[n];
                    ++n;
                }
                --this._count;
                return true;
            }
            ++n;
        }
        return false;
    }

    public int size() {
        return this._count;
    }

    public String stringValue() {
        return this._count == 0 ? "" : this._nodes[0].getStringValue();
    }

    public XPathNode[] toArray() {
        if (this._nodes == null) {
            return new XPathNode[0];
        }
        XPathNode[] xPathNodeArray = new XPathNode[this._count];
        int n = 0;
        while (n < this._count) {
            xPathNodeArray[n] = this._nodes[n];
            ++n;
        }
        return xPathNodeArray;
    }

    public String toString() {
        if (this._count == 0) {
            return "";
        }
        if (this._count == 1) {
            return this._nodes[0].getStringValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._count) {
            stringBuffer.append(this._nodes[n].getStringValue());
            ++n;
        }
        return stringBuffer.toString();
    }
}

