/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xml;

import java.io.IOException;
import java.io.Reader;
import org.exolab.adaptx.net.ObjectURILocation;
import org.exolab.adaptx.net.impl.URIUtils;
import org.w3c.dom.Node;

public final class DOMURILocation
extends ObjectURILocation {
    private String _documentBase = null;
    private String _absoluteURI = null;
    private String _relativeURI = null;
    private Node _node;

    public DOMURILocation(Node node, String string) {
        if (node == null) {
            String string2 = "The argument 'node' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        if (string != null) {
            this._absoluteURI = URIUtils.resolveAsString(string, null);
        }
    }

    public String getAbsoluteURI() {
        return this._absoluteURI;
    }

    public String getBaseURI() {
        if (this._documentBase == null && this._absoluteURI != null) {
            this._documentBase = URIUtils.getDocumentBase(this._absoluteURI);
        }
        return this._documentBase;
    }

    public Node getNode() {
        return this._node;
    }

    public Object getObject() {
        return this.getNode();
    }

    public Reader getReader() throws IOException {
        return null;
    }

    public String getRelativeURI() {
        if (this._relativeURI == null && this._absoluteURI != null) {
            int n = this.getBaseURI().length();
            this._relativeURI = this._absoluteURI.substring(n);
        }
        return this._relativeURI;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DOMURILocation (");
        stringBuffer.append(System.identityHashCode(this._node));
        stringBuffer.append(") at ");
        if (this.getAbsoluteURI() != null) {
            stringBuffer.append(this.getAbsoluteURI());
        } else {
            stringBuffer.append(" unspecified or unknown URL");
        }
        return stringBuffer.toString();
    }
}

