/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.net.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.impl.URIUtils;

public final class URILocationImpl
extends URILocation {
    private String _documentBase = null;
    private String _absoluteURI = null;
    private String _relativeURI = null;
    private Reader _reader = null;
    private InputStream _is = null;

    public URILocationImpl(InputStream inputStream, String string) {
        this(string, null);
        this._is = inputStream;
    }

    public URILocationImpl(Reader reader, String string) {
        this(string, null);
        this._reader = reader;
    }

    public URILocationImpl(String string) {
        this(string, null);
    }

    public URILocationImpl(String string, String string2) {
        if (string == null) {
            throw new IllegalStateException("href must not be null");
        }
        this._absoluteURI = URIUtils.resolveAsString(string, string2);
    }

    public String getAbsoluteURI() {
        return this._absoluteURI;
    }

    public String getBaseURI() {
        if (this._documentBase == null) {
            this._documentBase = URIUtils.getDocumentBase(this._absoluteURI);
        }
        return this._documentBase;
    }

    public Reader getReader() throws IOException {
        if (this._reader != null) {
            return this._reader;
        }
        if (this._is != null) {
            return new InputStreamReader(this._is);
        }
        return URIUtils.getReader(this._absoluteURI, null);
    }

    public String getRelativeURI() {
        if (this._relativeURI == null) {
            int n = this.getBaseURI().length();
            this._relativeURI = this._absoluteURI.substring(n);
        }
        return this._relativeURI;
    }

    public String toString() {
        return this.getAbsoluteURI();
    }
}

