/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.jaxp.transform;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.exolab.adaptx.util.ErrorObserver;

public class ErrorListenerWrapper
implements ErrorObserver {
    private ErrorListener _listener = null;

    public ErrorListenerWrapper(ErrorListener errorListener) {
        if (errorListener == null) {
            String string = "The argument 'listener' must not be null.";
            throw new IllegalArgumentException(string);
        }
        this._listener = errorListener;
    }

    public ErrorListener getListener() {
        return this._listener;
    }

    public void receiveError(Exception exception) {
        try {
            this._listener.error(new TransformerException(exception));
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException.getMessage());
        }
    }

    public void receiveError(Exception exception, int n) {
        try {
            switch (n) {
                case 0: {
                    this._listener.fatalError(new TransformerException(exception));
                    break;
                }
                case 2: {
                    this._listener.warning(new TransformerException(exception));
                    break;
                }
                default: {
                    this._listener.error(new TransformerException(exception));
                    break;
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException.getMessage());
        }
    }

    public void receiveError(Exception exception, String string) {
        try {
            this._listener.error(new TransformerException(string, exception));
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException.getMessage());
        }
    }

    public void receiveError(Exception exception, String string, int n) {
        try {
            switch (n) {
                case 0: {
                    this._listener.fatalError(new TransformerException(string, exception));
                    break;
                }
                case 2: {
                    this._listener.warning(new TransformerException(string, exception));
                    break;
                }
                default: {
                    this._listener.error(new TransformerException(string, exception));
                    break;
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException.getMessage());
        }
    }

    public void receiveError(String string) {
        try {
            this._listener.error(new TransformerException(string));
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException.getMessage());
        }
    }

    public void receiveError(String string, int n) {
        try {
            switch (n) {
                case 0: {
                    this._listener.fatalError(new TransformerException(string));
                    break;
                }
                case 2: {
                    this._listener.warning(new TransformerException(string));
                    break;
                }
                default: {
                    this._listener.error(new TransformerException(string));
                    break;
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException.getMessage());
        }
    }
}

