/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2014 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            K.U. Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "worhp_interface.hpp"
      #include <string>

      const std::string casadi::WorhpInterface::meta_doc=
      "\n"
"WORHP interface\n"
"\n"
"\n"
">List of available options\n"
"\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"|       Id        |      Type       |     Default     |   Description   |\n"
"+=================+=================+=================+=================+\n"
"| AcceptTolFeas   | OT_DOUBLE         | 0.001           | Tolerance for   |\n"
"|                 |                 |                 | acceptable      |\n"
"|                 |                 |                 | feasibility     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| AcceptTolOpti   | OT_DOUBLE         | 0.001           | Tolerance for   |\n"
"|                 |                 |                 | acceptable      |\n"
"|                 |                 |                 | optimality      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| AlphaMinConst   | OT_BOOL      | False           | Use a constant  |\n"
"|                 |                 |                 | lower bound on  |\n"
"|                 |                 |                 | Armijo stepsize |\n"
"|                 |                 |                 | in Filter       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Ares            | OT_INTVECTO | [42, 41, 42,    | Armijo recovery |\n"
"|                 | R               | 43, 44, 41, 50] | strategies.     |\n"
"|                 |                 |                 | Vector of size  |\n"
"|                 |                 |                 | 7               |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ArmijoBeta      | OT_DOUBLE         | 0.712           | Trial stepsize  |\n"
"|                 |                 |                 | decrease factor |\n"
"|                 |                 |                 | for Armijo rule |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ArmijoMaxAlpha  | OT_DOUBLE         | 1               | Initial alpha   |\n"
"|                 |                 |                 | for Armijo rule |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ArmijoMinAlpha  | OT_DOUBLE         | 0.000           | Lower bound on  |\n"
"|                 |                 |                 | alpha for       |\n"
"|                 |                 |                 | Armijo rule     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ArmijoMinAlphaR | OT_DOUBLE         | 0.000           | Lower bound on  |\n"
"| ec              |                 |                 | alpha for       |\n"
"|                 |                 |                 | Armijo rule     |\n"
"|                 |                 |                 | during recovery |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ArmijoSigma     | OT_DOUBLE         | 0.005           | Scale factor    |\n"
"|                 |                 |                 | for linearised  |\n"
"|                 |                 |                 | descent check   |\n"
"|                 |                 |                 | in Armijo rule  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| AutoQPRecovery  | OT_BOOL      | True            | Enable          |\n"
"|                 |                 |                 | automatic QP    |\n"
"|                 |                 |                 | recovery        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BFGSmaxblockSiz | OT_INT      | 300             | Block size      |\n"
"| e               |                 |                 | parameter used  |\n"
"|                 |                 |                 | by certain BFGS |\n"
"|                 |                 |                 | methods         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BFGSmethod      | OT_INT      | 0               | Choose BFGS     |\n"
"|                 |                 |                 | method (0:      |\n"
"|                 |                 |                 | dense, 1-3:     |\n"
"|                 |                 |                 | block, 100+:    |\n"
"|                 |                 |                 | sparse)         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BFGSminblockSiz | OT_INT      | 300             | Block size      |\n"
"| e               |                 |                 | parameter used  |\n"
"|                 |                 |                 | by certain BFGS |\n"
"|                 |                 |                 | methods         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BFGSrestart     | OT_INT      | 50              | Restart BFGS    |\n"
"|                 |                 |                 | update after    |\n"
"|                 |                 |                 | this many       |\n"
"|                 |                 |                 | iterations      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BettsFactor     | OT_DOUBLE         | 2.100           | Update factor   |\n"
"|                 |                 |                 | for Betts'      |\n"
"|                 |                 |                 | Hessian         |\n"
"|                 |                 |                 | regularisation  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BettsPoint      | OT_DOUBLE         | 1               | Smallest        |\n"
"|                 |                 |                 | eigenvalue of   |\n"
"|                 |                 |                 | the regularised |\n"
"|                 |                 |                 | Hessian         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| BoundTolFac     | OT_DOUBLE         | 1000            | Factor in       |\n"
"|                 |                 |                 | determining     |\n"
"|                 |                 |                 | active          |\n"
"|                 |                 |                 | constraints by  |\n"
"|                 |                 |                 | KKT             |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CheckFJ         | OT_DOUBLE         | 1.000e+12       | Upper bound     |\n"
"|                 |                 |                 | used by Fritz-  |\n"
"|                 |                 |                 | John heuristic  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CheckStructureD | OT_BOOL      | True            | Enable          |\n"
"| F               |                 |                 | structural      |\n"
"|                 |                 |                 | checking of DF  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CheckStructureD | OT_BOOL      | True            | Enable          |\n"
"| G               |                 |                 | structural      |\n"
"|                 |                 |                 | checking of DG  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CheckStructureH | OT_BOOL      | True            | Enable          |\n"
"| M               |                 |                 | structural      |\n"
"|                 |                 |                 | checking of HM  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepBettsSum | OT_DOUBLE         | 0.500           | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepConStop  | OT_DOUBLE         | 0.000           | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepConvio   | OT_DOUBLE         | 1               | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepMaxIter  | OT_INT      | 50              | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepMethod   | OT_INT      | 0               | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepMode     | OT_INT      | 1               | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepPFactor  | OT_DOUBLE         | 1               | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepPMax     | OT_DOUBLE         | 1000000         | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CorStepRecovery | OT_BOOL      | False           | (experimental)  |\n"
"| DX              |                 |                 |                 |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CurvBCond       | OT_DOUBLE         | 0.020           | Block BFGS      |\n"
"|                 |                 |                 | curvature       |\n"
"|                 |                 |                 | condition bound |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CurvBFac        | OT_DOUBLE         | 0.300           | Block BFGS      |\n"
"|                 |                 |                 | curvature       |\n"
"|                 |                 |                 | condition       |\n"
"|                 |                 |                 | regularisation  |\n"
"|                 |                 |                 | factor          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CurvCond        | OT_DOUBLE         | 0.020           | BFGS Curvature  |\n"
"|                 |                 |                 | condition bound |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| CurvFac         | OT_DOUBLE         | 0.300           | BFGS curvature  |\n"
"|                 |                 |                 | condition       |\n"
"|                 |                 |                 | regularisation  |\n"
"|                 |                 |                 | factor          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| DebugMarker05   | OT_INT      | 42              | Debug marker.   |\n"
"|                 |                 |                 | Used to find    |\n"
"|                 |                 |                 | memory alignmen |\n"
"|                 |                 |                 | t/padding       |\n"
"|                 |                 |                 | issues          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| DebugMarker06   | OT_INT      | 42              | Debug marker.   |\n"
"|                 |                 |                 | Used to find    |\n"
"|                 |                 |                 | memory alignmen |\n"
"|                 |                 |                 | t/padding       |\n"
"|                 |                 |                 | issues          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FGtogether      | OT_BOOL      | False           | F and G cannot  |\n"
"|                 |                 |                 | be evaluated    |\n"
"|                 |                 |                 | separately      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FJandND         | OT_BOOL      | False           | Enable Fritz-   |\n"
"|                 |                 |                 | John and non-   |\n"
"|                 |                 |                 | differentiable  |\n"
"|                 |                 |                 | check           |\n"
"|                 |                 |                 | heuristics      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasibleDual    | OT_BOOL      | False           | Activate dual   |\n"
"|                 |                 |                 | feasibility     |\n"
"|                 |                 |                 | mode            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasibleInit    | OT_BOOL      | False           | Activate        |\n"
"|                 |                 |                 | initial         |\n"
"|                 |                 |                 | feasibility     |\n"
"|                 |                 |                 | mode            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasibleInitTol | OT_DOUBLE         | 0.001           | Feasibility     |\n"
"|                 |                 |                 | tolerance for   |\n"
"|                 |                 |                 | no-objective    |\n"
"|                 |                 |                 | feasible mode   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasibleOnly    | OT_BOOL      | False           | Activate        |\n"
"|                 |                 |                 | feasible-only   |\n"
"|                 |                 |                 | mode            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FidifEps        | OT_DOUBLE         | 0.000           | Finite          |\n"
"|                 |                 |                 | difference      |\n"
"|                 |                 |                 | perturbation    |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FidifHM         | OT_BOOL      | False           | Approximate     |\n"
"|                 |                 |                 | Hessian by      |\n"
"|                 |                 |                 | finite          |\n"
"|                 |                 |                 | differences     |\n"
"|                 |                 |                 | (otherwise      |\n"
"|                 |                 |                 | BFGS)           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FilterBisecAlph | OT_BOOL      | True            | Filter          |\n"
"| a               |                 |                 | heuristic to    |\n"
"|                 |                 |                 | save Armijo     |\n"
"|                 |                 |                 | iterations      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FilterGammaCV   | OT_DOUBLE         | 0.000           | Constraint      |\n"
"|                 |                 |                 | violation       |\n"
"|                 |                 |                 | decrease factor |\n"
"|                 |                 |                 | in Filter       |\n"
"|                 |                 |                 | acceptance      |\n"
"|                 |                 |                 | check           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FilterGammaF    | OT_DOUBLE         | 0.000           | Objective       |\n"
"|                 |                 |                 | decrease factor |\n"
"|                 |                 |                 | in Filter       |\n"
"|                 |                 |                 | acceptance      |\n"
"|                 |                 |                 | check           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FilterIntersecA | OT_BOOL      | True            | Filter          |\n"
"| lpha            |                 |                 | heuristic to    |\n"
"|                 |                 |                 | save Armijo     |\n"
"|                 |                 |                 | iterations      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FirstDifCentral | OT_BOOL      | True            | Use central     |\n"
"|                 |                 |                 | finite          |\n"
"|                 |                 |                 | difference      |\n"
"|                 |                 |                 | quotient for    |\n"
"|                 |                 |                 | first           |\n"
"|                 |                 |                 | derivatives     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FocusOnFeas     | OT_BOOL      | True            | Enable Focus-   |\n"
"|                 |                 |                 | on-Feasibility  |\n"
"|                 |                 |                 | mode            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FocusOnFeasFact | OT_DOUBLE         | 1.360           | Factor in       |\n"
"| or              |                 |                 | Focus-on-       |\n"
"|                 |                 |                 | Feasibility     |\n"
"|                 |                 |                 | mode            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| GammaAlpha      | OT_DOUBLE         | 0.050           | Safety factor   |\n"
"|                 |                 |                 | for alphamin    |\n"
"|                 |                 |                 | calculation by  |\n"
"|                 |                 |                 | Filter          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| GroupMethod     | OT_INT      | 1               | Select method   |\n"
"|                 |                 |                 | to determine    |\n"
"|                 |                 |                 | graph colouring |\n"
"|                 |                 |                 | groups          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| IgnoreFilterCri | OT_BOOL      | False           | Activate        |\n"
"| t               |                 |                 | accelerating    |\n"
"|                 |                 |                 | heuristics for  |\n"
"|                 |                 |                 | Filter          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| IncBettsTau     | OT_DOUBLE         | 2               | Increase factor |\n"
"|                 |                 |                 | for Betts'      |\n"
"|                 |                 |                 | update          |\n"
"|                 |                 |                 | dampening term  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| IncBettsTauMore | OT_DOUBLE         | 100             | Larger increase |\n"
"|                 |                 |                 | factor for      |\n"
"|                 |                 |                 | Betts' update   |\n"
"|                 |                 |                 | dampening term  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| IncreaseIWS     | OT_DOUBLE         | 1               | Increase factor |\n"
"|                 |                 |                 | for estimated   |\n"
"|                 |                 |                 | integer         |\n"
"|                 |                 |                 | workspace       |\n"
"|                 |                 |                 | requirement     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| IncreaseRWS     | OT_DOUBLE         | 1               | Increase factor |\n"
"|                 |                 |                 | for estimated   |\n"
"|                 |                 |                 | real workspace  |\n"
"|                 |                 |                 | requirement     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Infty           | OT_DOUBLE         | 1.000e+20       | Upper bound for |\n"
"|                 |                 |                 | numbers to be   |\n"
"|                 |                 |                 | regarded as     |\n"
"|                 |                 |                 | finite          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| InftyUnbounded  | OT_DOUBLE         | 1.000e+20       | Tolerance for   |\n"
"|                 |                 |                 | unboundedness   |\n"
"|                 |                 |                 | detection       |\n"
"|                 |                 |                 | heuristic       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| InitialLMest    | OT_BOOL      | True            | Enable initial  |\n"
"|                 |                 |                 | Lagrange        |\n"
"|                 |                 |                 | multiplier      |\n"
"|                 |                 |                 | estimate        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| KeepAcceptableS | OT_BOOL      | True            | Save acceptable |\n"
"| ol              |                 |                 | solutions as    |\n"
"|                 |                 |                 | fallback        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LMestQPipComTol | OT_DOUBLE         | 0.003           | IP              |\n"
"|                 |                 |                 | complementarity |\n"
"|                 |                 |                 | tolerance in    |\n"
"|                 |                 |                 | initial         |\n"
"|                 |                 |                 | multiplier      |\n"
"|                 |                 |                 | estimate        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LMestQPipResTol | OT_DOUBLE         | 1               | IP residual     |\n"
"|                 |                 |                 | tolerance in    |\n"
"|                 |                 |                 | initial         |\n"
"|                 |                 |                 | multiplier      |\n"
"|                 |                 |                 | estimate        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LinMult         | OT_BOOL      | False           | Control         |\n"
"|                 |                 |                 | Lagrange        |\n"
"|                 |                 |                 | multiplier      |\n"
"|                 |                 |                 | update          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LogLevel        | OT_INT      | 0               | Enable XML      |\n"
"|                 |                 |                 | logfiles and    |\n"
"|                 |                 |                 | writing         |\n"
"|                 |                 |                 | interval        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LogResult       | OT_INT      | 0               | Enable XML      |\n"
"|                 |                 |                 | result logging  |\n"
"|                 |                 |                 | and detail      |\n"
"|                 |                 |                 | level           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LowPassAlphaF   | OT_DOUBLE         | 0.950           | Lowpass-filter  |\n"
"|                 |                 |                 | update factor   |\n"
"|                 |                 |                 | for objective   |\n"
"|                 |                 |                 | values          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LowPassAlphaG   | OT_DOUBLE         | 0.950           | Lowpass-filter  |\n"
"|                 |                 |                 | update factor   |\n"
"|                 |                 |                 | for constraint  |\n"
"|                 |                 |                 | values          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LowPassAlphaMer | OT_DOUBLE         | 0.100           | Lowpass-filter  |\n"
"| it              |                 |                 | update factor   |\n"
"|                 |                 |                 | for merit       |\n"
"|                 |                 |                 | function values |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LowPassFilter   | OT_BOOL      | True            | Enable lowpass- |\n"
"|                 |                 |                 | filter          |\n"
"|                 |                 |                 | termination     |\n"
"|                 |                 |                 | criterion       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MAPivotThreshol | OT_DOUBLE         | 0.000           | Pivoting        |\n"
"| d               |                 |                 | tolerance for   |\n"
"|                 |                 |                 | MA solvers      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MatrixCC        | OT_BOOL      | False           | Not to be       |\n"
"|                 |                 |                 | included into a |\n"
"|                 |                 |                 | parameter file! |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxCalls        | OT_INT      | 2.147e+09       | Upper bound to  |\n"
"|                 |                 |                 | Reverse         |\n"
"|                 |                 |                 | Communication   |\n"
"|                 |                 |                 | calls           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxForce        | OT_INT      | 1000            | Maximum number  |\n"
"|                 |                 |                 | of Force        |\n"
"|                 |                 |                 | recovery        |\n"
"|                 |                 |                 | strategy steps  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxGPart        | OT_INT      | 1               | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxIter         | OT_INT      | 500             | Upper bound on  |\n"
"|                 |                 |                 | major           |\n"
"|                 |                 |                 | iterations      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxLScounter    | OT_INT      | 3               | Control         |\n"
"|                 |                 |                 | activation of   |\n"
"|                 |                 |                 | Filter          |\n"
"|                 |                 |                 | acceleration    |\n"
"|                 |                 |                 | heuristics      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxNorm         | OT_BOOL      | True            | Select max-norm |\n"
"|                 |                 |                 | instead of      |\n"
"|                 |                 |                 | 1-norm in       |\n"
"|                 |                 |                 | Filter          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MeritFunction   | OT_INT      | 4               | Select merit    |\n"
"|                 |                 |                 | function and    |\n"
"|                 |                 |                 | penalty update  |\n"
"|                 |                 |                 | [0, 3..5]       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MeritGradTol    | OT_DOUBLE         | 0.000           | Threshold of    |\n"
"|                 |                 |                 | meritfunction   |\n"
"|                 |                 |                 | gradient for    |\n"
"|                 |                 |                 | increasing      |\n"
"|                 |                 |                 | Hessian         |\n"
"|                 |                 |                 | regularisation  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MinBettsTau     | OT_DOUBLE         | 0.000           | Lower bound for |\n"
"|                 |                 |                 | Betts' update   |\n"
"|                 |                 |                 | dampening term  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MoreRelax       | OT_BOOL      | False           | Introduce one   |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | variable for    |\n"
"|                 |                 |                 | every           |\n"
"|                 |                 |                 | constraint      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| NLPmethod       | OT_INT      | 1               | Select (1)      |\n"
"|                 |                 |                 | Meritfunction   |\n"
"|                 |                 |                 | or (3) Filter   |\n"
"|                 |                 |                 | globalisation   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| NLPprint        | OT_INT      | 2               | NLP print level |\n"
"|                 |                 |                 | [-1..4]         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PairMethod      | OT_INT      | 1               | Select method   |\n"
"|                 |                 |                 | to determine    |\n"
"|                 |                 |                 | graph colouring |\n"
"|                 |                 |                 | pairgroups      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PenUpdEpsBar    | OT_DOUBLE         | 0.900           | Penalty update  |\n"
"|                 |                 |                 | parameter       |\n"
"|                 |                 |                 | factor for      |\n"
"|                 |                 |                 | MeritFunction = |\n"
"|                 |                 |                 | 3               |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PenUpdEpsKFac   | OT_DOUBLE         | 2               | Penalty update  |\n"
"|                 |                 |                 | parameter       |\n"
"|                 |                 |                 | factor for      |\n"
"|                 |                 |                 | MeritFunction = |\n"
"|                 |                 |                 | 4               |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PenUpdEpsKSeque | OT_INT      | 2               | Penalty update  |\n"
"| nce             |                 |                 | parameter       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PenUpdMaxDeltaK | OT_DOUBLE         | 11              | Max penalty for |\n"
"|                 |                 |                 | MeritFunction = |\n"
"|                 |                 |                 | 4               |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PenUpdMaxFac    | OT_DOUBLE         | 100000000       | Max factor for  |\n"
"|                 |                 |                 | increasing      |\n"
"|                 |                 |                 | penalty for     |\n"
"|                 |                 |                 | MeritFunction = |\n"
"|                 |                 |                 | 4               |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PenUpdRBar      | OT_DOUBLE         | 2               | Penalty update  |\n"
"|                 |                 |                 | parameter for   |\n"
"|                 |                 |                 | MeritFunction = |\n"
"|                 |                 |                 | 3               |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PrecisionF      | OT_DOUBLE         | 0.000           | (currently      |\n"
"|                 |                 |                 | unused)         |\n"
"|                 |                 |                 | Relative        |\n"
"|                 |                 |                 | precision of    |\n"
"|                 |                 |                 | objective       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| PrecisionG      | OT_DOUBLE         | 0.000           | (currently      |\n"
"|                 |                 |                 | unused)         |\n"
"|                 |                 |                 | Relative        |\n"
"|                 |                 |                 | precision of    |\n"
"|                 |                 |                 | constraints     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| QPscaleParam    | OT_DOUBLE         | 0               | (currently      |\n"
"|                 |                 |                 | unused) Scaling |\n"
"|                 |                 |                 | factor for QP   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| QuadraticProble | OT_BOOL      | False           | Not to be       |\n"
"| m               |                 |                 | included into a |\n"
"|                 |                 |                 | parameter file! |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ReduceBettsTau  | OT_DOUBLE         | 0.300           | Decrease factor |\n"
"|                 |                 |                 | for Betts'      |\n"
"|                 |                 |                 | update          |\n"
"|                 |                 |                 | dampening term  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| RegStrategy     | OT_INT      | 1               | Select Hessian  |\n"
"|                 |                 |                 | regularisation  |\n"
"|                 |                 |                 | strategy in     |\n"
"|                 |                 |                 | Filter          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ReinitFilter    | OT_BOOL      | False           | Enables Filter- |\n"
"|                 |                 |                 | reinitialisatio |\n"
"|                 |                 |                 | n accelerating  |\n"
"|                 |                 |                 | heuristic       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| RelaxMaxDelta   | OT_DOUBLE         | 0.920           | Upper bound for |\n"
"|                 |                 |                 | accepting the   |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | variable        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| RelaxMaxPen     | OT_DOUBLE         | 50000000        | Upper bound on  |\n"
"|                 |                 |                 | the constraint  |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | penalty         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| RelaxRho        | OT_DOUBLE         | 6               | Update factor   |\n"
"|                 |                 |                 | for the         |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | penalty         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| RelaxStart      | OT_DOUBLE         | 1               | Initial value   |\n"
"|                 |                 |                 | of the          |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | penalty         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| RestUntilFeas   | OT_BOOL      | False           | Do restoration  |\n"
"|                 |                 |                 | until a         |\n"
"|                 |                 |                 | feasible        |\n"
"|                 |                 |                 | solution is     |\n"
"|                 |                 |                 | found           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaleConIter    | OT_BOOL      | False           | Scale           |\n"
"|                 |                 |                 | constraints in  |\n"
"|                 |                 |                 | every iteration |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaleFacObj     | OT_DOUBLE         | 10              | Value to scale  |\n"
"|                 |                 |                 | large objective |\n"
"|                 |                 |                 | functions to    |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaleFacQP      | OT_DOUBLE         | 10              | Upper bound on  |\n"
"|                 |                 |                 | resulting       |\n"
"|                 |                 |                 | matrix norm for |\n"
"|                 |                 |                 | QP scaling      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaledFD        | OT_BOOL      | True            | Use a scaled    |\n"
"|                 |                 |                 | perturbation    |\n"
"|                 |                 |                 | for finite      |\n"
"|                 |                 |                 | differences     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaledKKT       | OT_BOOL      | True            | Scale KKT       |\n"
"|                 |                 |                 | conditions      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaledObj       | OT_BOOL      | True            | Scale the       |\n"
"|                 |                 |                 | objective       |\n"
"|                 |                 |                 | function        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ScaledQP        | OT_BOOL      | True            | Scale some      |\n"
"|                 |                 |                 | matrices handed |\n"
"|                 |                 |                 | to the QP       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| StartBettsTau   | OT_DOUBLE         | 0.100           | Initial value   |\n"
"|                 |                 |                 | for Betts'      |\n"
"|                 |                 |                 | update          |\n"
"|                 |                 |                 | dampening term  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| SwitchingDelta  | OT_DOUBLE         | 0.010           | Filter          |\n"
"|                 |                 |                 | switching       |\n"
"|                 |                 |                 | condition       |\n"
"|                 |                 |                 | parameter       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| SwitchingSCV    | OT_DOUBLE         | 1.100           | Filter          |\n"
"|                 |                 |                 | switching       |\n"
"|                 |                 |                 | condition       |\n"
"|                 |                 |                 | parameter       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| SwitchingSF     | OT_DOUBLE         | 2.300           | Filter          |\n"
"|                 |                 |                 | switching       |\n"
"|                 |                 |                 | condition       |\n"
"|                 |                 |                 | parameter       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TakeQPSol       | OT_BOOL      | False           | Evaluate QP     |\n"
"|                 |                 |                 | search          |\n"
"|                 |                 |                 | direction       |\n"
"|                 |                 |                 | regardless of   |\n"
"|                 |                 |                 | convergence     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Timeout         | OT_DOUBLE         | 300             | Timeout in      |\n"
"|                 |                 |                 | seconds         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TolComp         | OT_DOUBLE         | 0.001           | Complementarity |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TolFeas         | OT_DOUBLE         | 0.000           | Feasibility     |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TolOpti         | OT_DOUBLE         | 0.000           | Optimality      |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TolWeakActive   | OT_DOUBLE         | 1               | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TooBig          | OT_BOOL      | True            | Enable too-big  |\n"
"|                 |                 |                 | termination     |\n"
"|                 |                 |                 | heuristics      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TooBigCV        | OT_DOUBLE         | 1.000e+25       | Upper bound on  |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation for   |\n"
"|                 |                 |                 | too-big         |\n"
"|                 |                 |                 | heuristic       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| TooBigKKT       | OT_DOUBLE         | 1.000e+30       | Upper bound on  |\n"
"|                 |                 |                 | KKT values for  |\n"
"|                 |                 |                 | too-big         |\n"
"|                 |                 |                 | heuristic       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| UserDF          | OT_BOOL      | True            | Objective       |\n"
"|                 |                 |                 | gradient values |\n"
"|                 |                 |                 | supplied by     |\n"
"|                 |                 |                 | caller          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| UserDG          | OT_BOOL      | True            | Jacobian values |\n"
"|                 |                 |                 | supplied by     |\n"
"|                 |                 |                 | caller          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| UserHM          | OT_BOOL      | True            | Hessian values  |\n"
"|                 |                 |                 | supplied by     |\n"
"|                 |                 |                 | caller          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| UserHMstructure | OT_INT      | 2               | Enable          |\n"
"|                 |                 |                 | automatic       |\n"
"|                 |                 |                 | Hessian         |\n"
"|                 |                 |                 | structure       |\n"
"|                 |                 |                 | generation or   |\n"
"|                 |                 |                 | checking        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| WeakActiveSet   | OT_BOOL      | False           | (experimental)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| eps             | OT_DOUBLE         | 0.000           | Machine epsilon |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| internalParChan | OT_INT      | 0               | Counter for     |\n"
"| ged             |                 |                 | changed         |\n"
"|                 |                 |                 | parameters.     |\n"
"|                 |                 |                 | Internal use    |\n"
"|                 |                 |                 | only.           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_time      | OT_BOOL      | True            | Print           |\n"
"|                 |                 |                 | information     |\n"
"|                 |                 |                 | about execution |\n"
"|                 |                 |                 | time            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipBarrier    | OT_DOUBLE         | 7.800           | IP barrier      |\n"
"|                 |                 |                 | parameter.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipComTol     | OT_DOUBLE         | 0.000           | IP              |\n"
"|                 |                 |                 | complementarity |\n"
"|                 |                 |                 | tolerance.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipFracBound  | OT_DOUBLE         | 0.880           | IP fraction-to- |\n"
"|                 |                 |                 | the-boundary    |\n"
"|                 |                 |                 | parameter.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipLsMethod   | OT_STRING       | None            | Select the      |\n"
"|                 |                 |                 | direct linear   |\n"
"|                 |                 |                 | solver used by  |\n"
"|                 |                 |                 | the IP method.  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipMinAlpha   | OT_DOUBLE         | 0.000           | IP line search  |\n"
"|                 |                 |                 | minimum step    |\n"
"|                 |                 |                 | size.           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipRelaxDiv   | OT_DOUBLE         | 2               | The relaxation  |\n"
"|                 |                 |                 | term is divided |\n"
"|                 |                 |                 | by this value   |\n"
"|                 |                 |                 | if successful.  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipRelaxMax   | OT_DOUBLE         | 0.000           | Maximum         |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | value.          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipRelaxMin   | OT_DOUBLE         | 0.000           | Mimimum         |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | value.          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipRelaxMult  | OT_DOUBLE         | 10              | The relaxation  |\n"
"|                 |                 |                 | term is         |\n"
"|                 |                 |                 | multiplied by   |\n"
"|                 |                 |                 | this value if   |\n"
"|                 |                 |                 | unsuccessful.   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipResTol     | OT_DOUBLE         | 0.000           | IP residuals    |\n"
"|                 |                 |                 | tolerance.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_ipTryRelax   | OT_BOOL      | True            | Enable          |\n"
"|                 |                 |                 | relaxation      |\n"
"|                 |                 |                 | strategy when   |\n"
"|                 |                 |                 | encountering an |\n"
"|                 |                 |                 | error.          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsItMaxIter  | OT_INT      | 1000            | Maximum number  |\n"
"|                 |                 |                 | of iterations   |\n"
"|                 |                 |                 | of the          |\n"
"|                 |                 |                 | iterative       |\n"
"|                 |                 |                 | linear solvers. |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsItMethod   | OT_STRING       | None            | Select the      |\n"
"|                 |                 |                 | iterative       |\n"
"|                 |                 |                 | linear solver.  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsItPrecondM | OT_STRING       | None            | Select          |\n"
"| ethod           |                 |                 | preconditioner  |\n"
"|                 |                 |                 | for the         |\n"
"|                 |                 |                 | iterative       |\n"
"|                 |                 |                 | linear solver.  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsRefineMaxI | OT_INT      | 10              | Maximum number  |\n"
"| ter             |                 |                 | of iterative    |\n"
"|                 |                 |                 | refinement      |\n"
"|                 |                 |                 | steps of the    |\n"
"|                 |                 |                 | direct linear   |\n"
"|                 |                 |                 | solvers.        |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsScale      | OT_BOOL      | True            | Enables scaling |\n"
"|                 |                 |                 | on linear       |\n"
"|                 |                 |                 | solver level.   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsTol        | OT_DOUBLE         | 0.000           | Tolerance for   |\n"
"|                 |                 |                 | the linear      |\n"
"|                 |                 |                 | solver.         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_lsTrySimple  | OT_BOOL      | False           | Some matrices   |\n"
"|                 |                 |                 | can be solved   |\n"
"|                 |                 |                 | without calling |\n"
"|                 |                 |                 | a linear        |\n"
"|                 |                 |                 | equation solver |\n"
"|                 |                 |                 | .Currently only |\n"
"|                 |                 |                 | diagonal        |\n"
"|                 |                 |                 | matrices are    |\n"
"|                 |                 |                 | supported.Non-  |\n"
"|                 |                 |                 | diagonal        |\n"
"|                 |                 |                 | matrices will   |\n"
"|                 |                 |                 | besolved with   |\n"
"|                 |                 |                 | the chosen      |\n"
"|                 |                 |                 | linear equation |\n"
"|                 |                 |                 | solver.         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_maxIter      | OT_INT      | 80              | Imposes an      |\n"
"|                 |                 |                 | upper limit on  |\n"
"|                 |                 |                 | the number of   |\n"
"|                 |                 |                 | minor solver    |\n"
"|                 |                 |                 | iterations,     |\n"
"|                 |                 |                 | i.e. for the    |\n"
"|                 |                 |                 | quadratic       |\n"
"|                 |                 |                 | subproblem      |\n"
"|                 |                 |                 | solver.If the   |\n"
"|                 |                 |                 | limit is        |\n"
"|                 |                 |                 | reached before  |\n"
"|                 |                 |                 | convergence,    |\n"
"|                 |                 |                 | WORHP will      |\n"
"|                 |                 |                 | activate QP     |\n"
"|                 |                 |                 | recovery        |\n"
"|                 |                 |                 | strategies to   |\n"
"|                 |                 |                 | prevent a       |\n"
"|                 |                 |                 | solver          |\n"
"|                 |                 |                 | breakdown.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_method       | OT_STRING       | None            | Select the      |\n"
"|                 |                 |                 | solution method |\n"
"|                 |                 |                 | used by the QP  |\n"
"|                 |                 |                 | solver.         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_nsnBeta      | OT_DOUBLE         | 0.900           | NSN stepsize    |\n"
"|                 |                 |                 | decrease        |\n"
"|                 |                 |                 | factor.         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_nsnGradStep  | OT_BOOL      | True            | Enable gradient |\n"
"|                 |                 |                 | steps in the    |\n"
"|                 |                 |                 | NSN method.     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_nsnKKT       | OT_DOUBLE         | 0.000           | NSN KKT         |\n"
"|                 |                 |                 | tolerance.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_nsnLsMethod  | OT_STRING       | None            | Select the      |\n"
"|                 |                 |                 | direct linear   |\n"
"|                 |                 |                 | solver used by  |\n"
"|                 |                 |                 | the NSN method. |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_nsnMinAlpha  | OT_DOUBLE         | 0.000           | NSN line search |\n"
"|                 |                 |                 | minimum step    |\n"
"|                 |                 |                 | size.           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_nsnSigma     | OT_DOUBLE         | 0.010           | NSN line search |\n"
"|                 |                 |                 | slope           |\n"
"|                 |                 |                 | parameter.      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_printLevel   | OT_STRING       | None            | Controls the    |\n"
"|                 |                 |                 | amount of QP    |\n"
"|                 |                 |                 | solver output.  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_scaleIntern  | OT_BOOL      | False           | Enable scaling  |\n"
"|                 |                 |                 | on QP level.    |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| qp_strict       | OT_BOOL      | True            | Use strict      |\n"
"|                 |                 |                 | termination     |\n"
"|                 |                 |                 | criteria in IP  |\n"
"|                 |                 |                 | method.         |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"\n"
"\n"
">List of available monitors\n"
"\n"
"+-------------+\n"
"|     Id      |\n"
"+=============+\n"
"| eval_f      |\n"
"+-------------+\n"
"| eval_g      |\n"
"+-------------+\n"
"| eval_grad_f |\n"
"+-------------+\n"
"| eval_h      |\n"
"+-------------+\n"
"| eval_jac_g  |\n"
"+-------------+\n"
"\n"
"\n"
">List of available stats\n"
"\n"
"+--------------------+\n"
"|         Id         |\n"
"+====================+\n"
"| iter_count         |\n"
"+--------------------+\n"
"| iteration          |\n"
"+--------------------+\n"
"| iterations         |\n"
"+--------------------+\n"
"| n_eval_f           |\n"
"+--------------------+\n"
"| n_eval_g           |\n"
"+--------------------+\n"
"| n_eval_grad_f      |\n"
"+--------------------+\n"
"| n_eval_h           |\n"
"+--------------------+\n"
"| n_eval_jac_g       |\n"
"+--------------------+\n"
"| return_code        |\n"
"+--------------------+\n"
"| return_status      |\n"
"+--------------------+\n"
"| t_callback_fun     |\n"
"+--------------------+\n"
"| t_callback_prepare |\n"
"+--------------------+\n"
"| t_eval_f           |\n"
"+--------------------+\n"
"| t_eval_g           |\n"
"+--------------------+\n"
"| t_eval_grad_f      |\n"
"+--------------------+\n"
"| t_eval_h           |\n"
"+--------------------+\n"
"| t_eval_jac_g       |\n"
"+--------------------+\n"
"| t_mainloop         |\n"
"+--------------------+\n"
"\n"
"\n"
"\n"
"\n"
;
