/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2014 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            K.U. Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "knitro_interface.hpp"
      #include <string>

      const std::string casadi::KnitroInterface::meta_doc=
      "\n"
"KNITRO interface\n"
"\n"
"\n"
">List of available options\n"
"\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"|       Id        |      Type       |     Default     |   Description   |\n"
"+=================+=================+=================+=================+\n"
"| BarRule         | OT_INT      | 0               | Barrier Rule    |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Debug           | OT_INT      | 0               | Debug level     |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Delta           | OT_DOUBLE         | 1               | Initial region  |\n"
"|                 |                 |                 | scaling factor  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasModeTol     | OT_DOUBLE         | 0.000           | Feasible mode   |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasTol         | OT_DOUBLE         | 0.000           | Feasible        |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| FeasTolAbs      | OT_DOUBLE         | 0               | Absolute        |\n"
"|                 |                 |                 | feasible        |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Feasible        | OT_BOOL      | 1               | Allow           |\n"
"|                 |                 |                 | infeasible      |\n"
"|                 |                 |                 | iterations      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| GradOpt         | OT_INT      | 1               | Gradient        |\n"
"|                 |                 |                 | calculation     |\n"
"|                 |                 |                 | method          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| HessOpt         | OT_INT      | 1               | Hessian         |\n"
"|                 |                 |                 | calculation     |\n"
"|                 |                 |                 | method          |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| HonorBnds       | OT_BOOL      | 0               | Enforce bounds  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| InitPt          | OT_BOOL      | 0               | Use initial     |\n"
"|                 |                 |                 | point strategy  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LmSize          | OT_INT      | 10              | Memory pairsize |\n"
"|                 |                 |                 | limit           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| LpSolver        | OT_BOOL      | 0               | Use LpSolver    |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxCgIt         | OT_INT      | 0               | Maximum         |\n"
"|                 |                 |                 | conjugate       |\n"
"|                 |                 |                 | gradient        |\n"
"|                 |                 |                 | iterations      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| MaxIt           | OT_INT      | 10000           | Iteration limit |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Mu              | OT_DOUBLE         | 0.100           | Initial barrier |\n"
"|                 |                 |                 | parameter       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Multistart      | OT_BOOL      | 0               | Use multistart  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| NewPoint        | OT_BOOL      | 0               | Select new-     |\n"
"|                 |                 |                 | point feature   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ObjRange        | OT_DOUBLE         | 1.000e+20       | Maximum         |\n"
"|                 |                 |                 | objective value |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| OptTol          | OT_DOUBLE         | 0.000           | Relative        |\n"
"|                 |                 |                 | optimality      |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| OptTolAbs       | OT_DOUBLE         | 0               | Absolute        |\n"
"|                 |                 |                 | optimality      |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| OutLev          | OT_INT      | 2               | Log output      |\n"
"|                 |                 |                 | level           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Pivot           | OT_DOUBLE         | 0.000           | Initial pivot   |\n"
"|                 |                 |                 | threshold       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Scale           | OT_BOOL      | 1               | Perform scaling |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ShiftInit       | OT_BOOL      | 1               | Interior-point  |\n"
"|                 |                 |                 | shifting        |\n"
"|                 |                 |                 | initial point   |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| Soc             | OT_INT      | 1               | Second order    |\n"
"|                 |                 |                 | correction      |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| XTol            | OT_DOUBLE         | 0.000           | Relative        |\n"
"|                 |                 |                 | solution change |\n"
"|                 |                 |                 | tolerance       |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| contype         | OT_INTVECTO |                 |                 |\n"
"|                 | R               |                 |                 |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"\n"
"\n"
">List of available monitors\n"
"\n"
"+-------------+\n"
"|     Id      |\n"
"+=============+\n"
"| eval_f      |\n"
"+-------------+\n"
"| eval_g      |\n"
"+-------------+\n"
"| eval_grad_f |\n"
"+-------------+\n"
"| eval_h      |\n"
"+-------------+\n"
"| eval_jac_g  |\n"
"+-------------+\n"
"\n"
"\n"
">List of available stats\n"
"\n"
"+---------------+\n"
"|      Id       |\n"
"+===============+\n"
"| return_status |\n"
"+---------------+\n"
"\n"
"\n"
"\n"
"\n"
;
