//! Emoji constants used by `wrangler`.
//!
//! For the unfamiliar:
//!
//! > Emoji are ideograms and smileys used in electronic messages and web
//! > pages. Emoji exist in various genres, including facial expressions, common
//! > objects, places and types of weather, and animals. They are much like
//! > emoticons, but emoji are actual pictures instead of typographics.
//!
//! -- https://en.wikipedia.org/wiki/Emoji

#![allow(missing_docs)]

use console::Emoji;

pub static DOWN: Emoji = Emoji("⬇️ ", "");
pub static EAR: Emoji = Emoji("👂 ", "");
pub static EYES: Emoji = Emoji("👀 ", "");
pub static FILES: Emoji = Emoji("🗂️ ", "");
pub static INFO: Emoji = Emoji("💁 ", "");
pub static MICROSCOPE: Emoji = Emoji("🔬 ", "");
pub static SLEUTH: Emoji = Emoji("🕵️ ", "");
pub static SPARKLES: Emoji = Emoji("✨ ", "");
pub static SWIRL: Emoji = Emoji("🌀 ", "");
pub static TAIL: Emoji = Emoji("🦚 ", "");
pub static WARN: Emoji = Emoji("⚠️ ", "");
pub static WAVING: Emoji = Emoji("👋 ", "");
pub static WORKER: Emoji = Emoji("👷 ", "");
pub static X: Emoji = Emoji("❌ ", "");
pub static NO_ENTRY: Emoji = Emoji("⛔ ", "");
