//! Low-level GraphQL queries used by this crate.
//!
//! If possible, users should prefer the high-level functions exposed under
//! [`crate`].
//!
//! This module is primarily used in combination with
//! [`crate::graphql::execute_query()`] as an "escape hatch" for accessing
//! information that may not be exposed via the high-level functions.
//!
//! # Backwards Compatibility
//!
//! Queries won't be deleted or have breaking changes to their inputs during
//! patch releases, however new fields may be added to the response types
//! generated by `graphql_client` at any time.
//!
//! Users should treat all response types as if they had the `#[non_exhaustive]`
//! attribute.

use graphql_client::*;

/// The GraphQL schema exposed by the WAPM backend.
pub const SCHEMA: &str = include_str!("../graphql/schema.graphql");

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_package_version.graphql",
    response_derives = "Debug"
)]
pub struct GetPackageVersionQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/whoami.graphql",
    response_derives = "Debug"
)]
pub struct WhoAmIQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_package_by_command.graphql",
    response_derives = "Debug"
)]
pub struct GetPackageByCommandQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/test_if_registry_present.graphql",
    response_derives = "Debug"
)]
pub struct TestIfRegistryPresent;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_bindings.graphql",
    response_derives = "Debug,Clone,PartialEq,Eq"
)]
pub struct GetBindingsQuery;
