;; Tests for i16x8 [min_s, min_u, max_s, max_u, avgr_u, abs] operations.

(module
  (func (export "i16x8.min_s") (param v128 v128) (result v128) (i16x8.min_s (local.get 0) (local.get 1)))
  (func (export "i16x8.min_u") (param v128 v128) (result v128) (i16x8.min_u (local.get 0) (local.get 1)))
  (func (export "i16x8.max_s") (param v128 v128) (result v128) (i16x8.max_s (local.get 0) (local.get 1)))
  (func (export "i16x8.max_u") (param v128 v128) (result v128) (i16x8.max_u (local.get 0) (local.get 1)))
  (func (export "i16x8.avgr_u") (param v128 v128) (result v128) (i16x8.avgr_u (local.get 0) (local.get 1)))
  (func (export "i16x8.abs") (param v128) (result v128) (i16x8.abs (local.get 0)))
  (func (export "i16x8.min_s_with_const_0") (result v128) (i16x8.min_s (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.min_s_with_const_1") (result v128) (i16x8.min_s (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.min_u_with_const_2") (result v128) (i16x8.min_u (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.min_u_with_const_3") (result v128) (i16x8.min_u (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.max_s_with_const_4") (result v128) (i16x8.max_s (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.max_s_with_const_5") (result v128) (i16x8.max_s (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.max_u_with_const_6") (result v128) (i16x8.max_u (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.max_u_with_const_7") (result v128) (i16x8.max_u (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.avgr_u_with_const_8") (result v128) (i16x8.avgr_u (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.avgr_u_with_const_9") (result v128) (i16x8.avgr_u (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.abs_with_const_10") (result v128) (i16x8.abs (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.min_s_with_const_11") (param v128) (result v128) (i16x8.min_s (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.min_s_with_const_12") (param v128) (result v128) (i16x8.min_s (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.min_u_with_const_13") (param v128) (result v128) (i16x8.min_u (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.min_u_with_const_14") (param v128) (result v128) (i16x8.min_u (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.max_s_with_const_15") (param v128) (result v128) (i16x8.max_s (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.max_s_with_const_16") (param v128) (result v128) (i16x8.max_s (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.max_u_with_const_17") (param v128) (result v128) (i16x8.max_u (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.max_u_with_const_18") (param v128) (result v128) (i16x8.max_u (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.avgr_u_with_const_19") (param v128) (result v128) (i16x8.avgr_u (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.avgr_u_with_const_20") (param v128) (result v128) (i16x8.avgr_u (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
)

(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1)
                                     (v128.const i16x8 0 0 -1 -1 0 0 -1 -1))
                                     (v128.const i16x8 0 0 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                     (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 128 128 128 128 128 128 128 128))
                                     (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 123 123 123 123 123 123 123 123)
                                     (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i16x8 123 123 123 123 123 123 123 123))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1)
                                     (v128.const i16x8 0 0 -1 -1 0 0 -1 -1))
                                     (v128.const i16x8 0 0 0 0 0 0 -1 -1))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 128 128 128 128 128 128 128 128))
                                     (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 123 123 123 123 123 123 123 123)
                                     (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i16x8 123 123 123 123 123 123 123 123))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1)
                                     (v128.const i16x8 0 0 -1 -1 0 0 -1 -1))
                                     (v128.const i16x8 0 0 0 0 0 0 -1 -1))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 128 128 128 128 128 128 128 128))
                                     (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 123 123 123 123 123 123 123 123)
                                     (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i16x8 123 123 123 123 123 123 123 123))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1)
                                     (v128.const i16x8 0 0 -1 -1 0 0 -1 -1))
                                     (v128.const i16x8 0 0 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                     (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                     (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 1 1 1 1 1 1 1 1))
                                     (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                     (v128.const i16x8 128 128 128 128 128 128 128 128))
                                     (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                     (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                     (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 123 123 123 123 123 123 123 123)
                                     (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i16x8 123 123 123 123 123 123 123 123))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                      (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                      (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1)
                                      (v128.const i16x8 0 0 -1 -1 0 0 -1 -1))
                                      (v128.const i16x8 0 0 32768 32768 32768 32768 65535 65535))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                      (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                      (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                      (v128.const i16x8 1 1 1 1 1 1 1 1))
                                      (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                      (v128.const i16x8 1 1 1 1 1 1 1 1))
                                      (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                      (v128.const i16x8 128 128 128 128 128 128 128 128))
                                      (v128.const i16x8 32832 32832 32832 32832 32832 32832 32832 32832))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                      (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                      (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                      (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                      (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 123 123 123 123 123 123 123 123)
                                      (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                      (v128.const i16x8 123 123 123 123 123 123 123 123))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                      (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                      (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i16x8 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
                                   (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000))
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                   (v128.const i16x8 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3))
                                   (v128.const i16x8 123 123 123 123 123 123 123 123))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                   (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                   (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                   (v128.const i16x8 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0))
                                   (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))

;; Const vs const
(assert_return (invoke "i16x8.min_s_with_const_0") (v128.const i16x8 -32768 -32768 16384 16384 16384 16384 -32768 -32768))
(assert_return (invoke "i16x8.min_s_with_const_1") (v128.const i16x8 0 0 1 1 1 1 0 0))
(assert_return (invoke "i16x8.min_u_with_const_2") (v128.const i16x8 -32768 -32768 16384 16384 16384 16384 -32768 -32768))
(assert_return (invoke "i16x8.min_u_with_const_3") (v128.const i16x8 0 0 1 1 1 1 0 0))
(assert_return (invoke "i16x8.max_s_with_const_4") (v128.const i16x8 65535 65535 32767 32767 32767 32767 65535 65535))
(assert_return (invoke "i16x8.max_s_with_const_5") (v128.const i16x8 3 3 2 2 2 2 3 3))
(assert_return (invoke "i16x8.max_u_with_const_6") (v128.const i16x8 65535 65535 32767 32767 32767 32767 65535 65535))
(assert_return (invoke "i16x8.max_u_with_const_7") (v128.const i16x8 3 3 2 2 2 2 3 3))
(assert_return (invoke "i16x8.avgr_u_with_const_8") (v128.const i16x8 49152 49152 24576 24576 24576 24576 49152 49152))
(assert_return (invoke "i16x8.avgr_u_with_const_9") (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.abs_with_const_10") (v128.const i16x8 32768 32768 32767 32767 16384 16384 1 1))

;; Param vs const
(assert_return (invoke "i16x8.min_s_with_const_11" (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                                   (v128.const i16x8 -32768 -32768 16384 16384 16384 16384 -32768 -32768))
(assert_return (invoke "i16x8.min_s_with_const_12" (v128.const i16x8 3 3 2 2 1 1 0 0))
                                                   (v128.const i16x8 0 0 1 1 1 1 0 0))
(assert_return (invoke "i16x8.min_u_with_const_13" (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                                   (v128.const i16x8 -32768 -32768 16384 16384 16384 16384 -32768 -32768))
(assert_return (invoke "i16x8.min_u_with_const_14" (v128.const i16x8 3 3 2 2 1 1 0 0))
                                                   (v128.const i16x8 0 0 1 1 1 1 0 0))
(assert_return (invoke "i16x8.max_s_with_const_15" (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                                   (v128.const i16x8 65535 65535 32767 32767 32767 32767 65535 65535))
(assert_return (invoke "i16x8.max_s_with_const_16" (v128.const i16x8 3 3 2 2 1 1 0 0))
                                                   (v128.const i16x8 3 3 2 2 2 2 3 3))
(assert_return (invoke "i16x8.max_u_with_const_17" (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                                   (v128.const i16x8 65535 65535 32767 32767 32767 32767 65535 65535))
(assert_return (invoke "i16x8.max_u_with_const_18" (v128.const i16x8 3 3 2 2 1 1 0 0))
                                                   (v128.const i16x8 3 3 2 2 2 2 3 3))
(assert_return (invoke "i16x8.avgr_u_with_const_19" (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                                    (v128.const i16x8 49152 49152 24576 24576 24576 24576 49152 49152))
(assert_return (invoke "i16x8.avgr_u_with_const_20" (v128.const i16x8 3 3 2 2 1 1 0 0))
                                                    (v128.const i16x8 2 2 2 2 2 2 2 2))

;; Test different lanes go through different if-then clauses
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)
                                     (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                     (v128.const i16x8 -32768 -32768 16384 16384 16384 16384 -32768 -32768))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 0 0 1 1 2 2 128 128)
                                     (v128.const i16x8 0 0 2 2 1 1 128 128))
                                     (v128.const i16x8 0 0 1 1 1 1 128 128))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)
                                     (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                     (v128.const i16x8 -32768 -32768 16384 16384 16384 16384 -32768 -32768))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 0 0 1 1 2 2 128 128)
                                     (v128.const i16x8 0 0 2 2 1 1 128 128))
                                     (v128.const i16x8 0 0 1 1 1 1 128 128))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)
                                     (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                     (v128.const i16x8 65535 65535 32767 32767 32767 32767 65535 65535))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 0 0 1 1 2 2 128 128)
                                     (v128.const i16x8 0 0 2 2 1 1 128 128))
                                     (v128.const i16x8 0 0 2 2 2 2 128 128))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)
                                     (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                     (v128.const i16x8 65535 65535 32767 32767 32767 32767 65535 65535))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 0 0 1 1 2 2 128 128)
                                     (v128.const i16x8 0 0 2 2 1 1 128 128))
                                     (v128.const i16x8 0 0 2 2 2 2 128 128))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)
                                      (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768))
                                      (v128.const i16x8 49152 49152 24576 24576 24576 24576 49152 49152))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 0 0 1 1 2 2 128 128)
                                      (v128.const i16x8 0 0 2 2 1 1 128 128))
                                      (v128.const i16x8 0 0 2 2 2 2 128 128))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535))
                                   (v128.const i16x8 32768 32768 32767 32767 16384 16384 1 1))

;; Test opposite signs of zero
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0)
                                     (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
                                     (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0))
(assert_return (invoke "i16x8.min_s" (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0)
                                     (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
                                     (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0))
(assert_return (invoke "i16x8.min_u" (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0)
                                     (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
                                     (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0))
(assert_return (invoke "i16x8.max_s" (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0)
                                     (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
                                     (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0))
(assert_return (invoke "i16x8.max_u" (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0)
                                      (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.avgr_u" (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0)
                                      (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))
                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0))
                                   (v128.const i16x8 -0 -0 -0 -0 +0 +0 +0 +0))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
                                   (v128.const i16x8 +0 +0 0 0 -0 -0 0 0))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0))
                                   (v128.const i16x8 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i16x8.abs" (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))
                                   (v128.const i16x8 +0 +0 +0 +0 +0 +0 +0 +0))

;; Unknown operators
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.avgr (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 1 1 1 1 1 1 1 1)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.avgr_s (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 1 1 1 1 1 1 1 1)))") "unknown operator")

;; Type check
(assert_invalid (module (func (result v128) (i16x8.min_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.min_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.max_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.max_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.avgr_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.abs (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i16x8.min_s-1st-arg-empty (result v128)
      (i16x8.min_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.min_s-arg-empty (result v128)
      (i16x8.min_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.min_u-1st-arg-empty (result v128)
      (i16x8.min_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.min_u-arg-empty (result v128)
      (i16x8.min_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.max_s-1st-arg-empty (result v128)
      (i16x8.max_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.max_s-arg-empty (result v128)
      (i16x8.max_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.max_u-1st-arg-empty (result v128)
      (i16x8.max_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.max_u-arg-empty (result v128)
      (i16x8.max_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.avgr_u-1st-arg-empty (result v128)
      (i16x8.avgr_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.avgr_u-arg-empty (result v128)
      (i16x8.avgr_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.abs-arg-empty (result v128)
      (i16x8.abs)
    )
  )
  "type mismatch"
)

;; Combination
(module
  (func (export "i16x8.min_s-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.abs") (param v128 v128) (result v128) (i16x8.min_s (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.min_s") (param v128 v128) (result v128) (i16x8.abs (i16x8.min_s (local.get 0) (local.get 1))))
  (func (export "i16x8.min_u-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.abs") (param v128 v128) (result v128) (i16x8.min_u (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.min_u") (param v128 v128) (result v128) (i16x8.abs (i16x8.min_u (local.get 0) (local.get 1))))
  (func (export "i16x8.max_s-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.abs") (param v128 v128) (result v128) (i16x8.max_s (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.max_s") (param v128 v128) (result v128) (i16x8.abs (i16x8.max_s (local.get 0) (local.get 1))))
  (func (export "i16x8.max_u-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.abs") (param v128 v128) (result v128) (i16x8.max_u (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.max_u") (param v128 v128) (result v128) (i16x8.abs (i16x8.max_u (local.get 0) (local.get 1))))
  (func (export "i16x8.avgr_u-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.abs") (param v128 v128) (result v128) (i16x8.avgr_u (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.avgr_u") (param v128 v128) (result v128) (i16x8.abs (i16x8.avgr_u (local.get 0) (local.get 1))))
  (func (export "i16x8.abs-i16x8.abs") (param v128) (result v128) (i16x8.abs (i16x8.abs (local.get 0))))
)

(assert_return (invoke "i16x8.min_s-i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_s-i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_s-i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_s-i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_s-i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_s-i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.abs-i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                               (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_u-i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_u-i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_u-i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.min_u-i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_u-i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.min_u-i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.abs-i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                               (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.max_s-i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_s-i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_s-i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_s-i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_s-i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_s-i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
                                               (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.abs-i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                               (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.max_u-i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_u-i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_u-i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_u-i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_u-i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                 (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.max_u-i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i16x8 0 0 0 0 0 0 0 0))
                                               (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.abs-i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                               (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.avgr_u-i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                   (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                   (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.avgr_u-i16x8.max_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.avgr_u-i16x8.max_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.avgr_u-i16x8.min_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.avgr_u-i16x8.min_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 2 2 2 2 2 2 2 2))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.avgr_u-i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.abs-i16x8.avgr_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.abs-i16x8.abs" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
