<p align="center">
  <img
    width="400"
    src="https://raw.githubusercontent.com/starship/starship/master/media/logo.png"
    alt="Starship – Cross-shell prompt"
 />
</p>

<p align="center">
  <a href="https://github.com/starship/starship/actions"
    ><img
      src="https://img.shields.io/github/workflow/status/starship/starship/Main workflow/master?label=workflow&style=flat-square"
      alt="GitHub Actions workflow status"
 /></a>
  <a href="https://crates.io/crates/starship"
    ><img
      src="https://img.shields.io/crates/v/starship?style=flat-square"
      alt="Crates.io version"
 /></a>
  <a href="https://repology.org/project/starship/versions"
    ><img
      src="https://img.shields.io/repology/repositories/starship?label=in%20repositories&style=flat-square"
      alt="Packaging status" /></a
><br />
  <a href="https://discord.gg/starship"
    ><img
      src="https://img.shields.io/discord/567163873606500352?label=discord&logoColor=white&style=flat-square"
      alt="Chat on Discord"
 /></a>
  <a href="https://twitter.com/StarshipPrompt"
    ><img
      src="https://img.shields.io/badge/twitter-@StarshipPrompt-1DA1F3?style=flat-square"
      alt="Follow @StarshipPrompt on Twitter"
 /></a>
</p>

<p align="center">
  <a href="https://starship.rs">Website</a>
  ·
  <a href="#🚀-installation">Kurulum</a>
  ·
  <a href="https://starship.rs/config/">Yapılandırma</a>
</p>

<p align="center">
  <a href="https://github.com/starship/starship/blob/master/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-us.png"
      alt="English"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/de-DE/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-de.png"
      alt="Deutsch"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/es-ES/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-es.png"
      alt="Español"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/fr-FR/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-fr.png"
      alt="Français"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/id-ID/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-id.png"
      alt="Bahasa Indonesia"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/it-IT/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-it.png"
      alt="Italiano"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/ja-JP/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-jp.png"
      alt="日本語"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/pt-BR/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-br.png"
      alt="Português do Brasil"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/ru-RU/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-ru.png"
      alt="Русский"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/vi-VN/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-vn.png"
      alt="Tiếng Việt"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/zh-CN/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-cn.png"
      alt="简体中文"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/zh-TW/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-tw.png"
      alt="繁體中文"
 /></a>
</p>

[![SWUbanner](https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner2-direct.svg)](https://vshymanskyy.github.io/StandWithUkraine)

<h1></h1>

<img
  src="https://raw.githubusercontent.com/starship/starship/master/media/demo.gif"
  alt="Starship with iTerm2 and the Snazzy theme"
  width="50%"
  align="right"
 />

**Sade, hızlı, dilediğiniz gibi özelleştirilebilen ve istenilen shell'de kullanılabilen prompt!**

- **Hızlı:** _gerçekten_ hızlı! 🚀
- **Özelleştirilebilir:** promptunuzu en ince ayrıntısına kadar özelleştirin.
- **Evrensel:** herhangi bir shell ve işletim sisteminde çalışır.
- **Akıllı:** bir bakışta ilgili bilgilere ulaş.
- **Zengin içerik:** bütün sevdiğiniz araçları destekler.
- **Kolay:** hızlı kurulum -  dakikalar içinde kullanmaya başla.

<p align="center">
<a href="https://starship.rs/config/"><strong>Starship dokümantasyonunu incele &nbsp;&nbsp;▶</strong></a>
</p>

<a name="🚀-installation"></a>

## 🚀 Kurulum

### Ön koşullar

- [Nerd Font](https://www.nerdfonts.com/) kurulu ve terminalinizde kullanılıyor olmalı (başlarken [Fira Code Nerd Font](https://www.nerdfonts.com/font-downloads)'u deneyebilirsiniz).

### 1. Adım Starship'i Kur

Kurulum talimatlarını görmek için aşağıdaki listeden işletim sisteminizi seçiniz:

<details>
<summary>Android</summary>

Starship'i herhangi bir paket yöneticisi ile yükleyin:

| Repository                                                                        | Instructions           |
| --------------------------------------------------------------------------------- | ---------------------- |
| [Termux](https://github.com/termux/termux-packages/tree/master/packages/starship) | `pkg install starship` |

</details>

<details>
<summary>BSD</summary>

Starship'i herhangi bir paket yöneticisi ile yükleyin:

| Distribution | Repository                                               | Instructions                      |
| ------------ | -------------------------------------------------------- | --------------------------------- |
| **_Any_**    | **[crates.io](https://crates.io/crates/starship)**       | `cargo install starship --locked` |
| FreeBSD      | [FreshPorts](https://www.freshports.org/shells/starship) | `pkg install starship`            |
| NetBSD       | [pkgsrc](https://pkgsrc.se/shells/starship)              | `pkgin install starship`          |

</details>

<details>
<summary>Linux</summary>

Sisteminiz için son sürümü yükleyin:

```sh
curl -sS https://starship.rs/install.sh | sh
```

Alternatif olarak aşağıdaki paket yöneticileri ile de Starship'i yükleyebilirsiniz:

| Distribution       | Repository                                                                                      | Instructions                                                                   |
| ------------------ | ----------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------ |
| **_Any_**          | **[crates.io](https://crates.io/crates/starship)**                                              | `cargo install starship --locked`                                              |
| _Any_              | [conda-forge](https://anaconda.org/conda-forge/starship)                                        | `conda install -c conda-forge starship`                                        |
| _Any_              | [Linuxbrew](https://formulae.brew.sh/formula/starship)                                          | `brew install starship`                                                        |
| _Any_              | [Snapcraft](https://snapcraft.io/starship)                                                      | `snap install starship`                                                        |
| Alpine Linux 3.13+ | [Alpine Linux Packages](https://pkgs.alpinelinux.org/packages?name=starship)                    | `apk add starship`                                                             |
| Arch Linux         | [Arch Linux Community](https://archlinux.org/packages/community/x86_64/starship)                | `pacman -S starship`                                                           |
| CentOS 7+          | [Copr](https://copr.fedorainfracloud.org/coprs/atim/starship)                                   | `dnf copr enable atim/starship` <br /> `dnf install starship` |
| Fedora 31+         | [Fedora Packages](https://src.fedoraproject.org/rpms/rust-starship)                             | `dnf install starship`                                                         |
| NixOS              | [nixpkgs](https://github.com/NixOS/nixpkgs/blob/master/pkgs/tools/misc/starship/default.nix)    | `nix-env -iA nixos.starship`                                                   |
| Gentoo             | [Gentoo Packages](https://packages.gentoo.org/packages/app-shells/starship)                     | `emerge app-shells/starship`                                                   |
| Manjaro            |                                                                                                 | `pacman -S starship`                                                           |
| NixOS              | [nixpkgs](https://github.com/NixOS/nixpkgs/blob/master/pkgs/tools/misc/starship/default.nix)    | `nix-env -iA nixpkgs.starship`                                                 |
| Void Linux         | [Void Linux Packages](https://github.com/void-linux/void-packages/tree/master/srcpkgs/starship) | `xbps-install -S starship`                                                     |

</details>

<details>
<summary>macOS</summary>

Sisteminiz için son sürümü yükleyin:

```sh
curl -sS https://starship.rs/install.sh | sh
```

Alternatif olarak aşağıdaki paket yöneticileri ile de Starship'i yükleyebilirsiniz:

| Repository                                               | Instructions                            |
| -------------------------------------------------------- | --------------------------------------- |
| **[crates.io](https://crates.io/crates/starship)**       | `cargo install starship --locked`       |
| [conda-forge](https://anaconda.org/conda-forge/starship) | `conda install -c conda-forge starship` |
| [Homebrew](https://formulae.brew.sh/formula/starship)    | `brew install starship`                 |
| [MacPorts](https://ports.macports.org/port/starship)     | `port install starship`                 |

</details>

<details>
<summary>Windows</summary>

Starship'i herhangi bir paket yöneticisi ile yükleyin:

| Repository                                                                       | Instructions                            |
| -------------------------------------------------------------------------------- | --------------------------------------- |
| **[crates.io](https://crates.io/crates/starship)**                               | `cargo install starship --locked`       |
| [Chocolatey ](https://community.chocolatey.org/packages/starship)                | `choco install starship`                |
| [conda-forge](https://anaconda.org/conda-forge/starship)                         | `conda install -c conda-forge starship` |
| [Scoop](https://github.com/ScoopInstaller/Main/blob/master/bucket/starship.json) | `scoop install starship`                |

</details>

### 2. Adım Shell'inizi Starship kullanmaya hazır hale getirin

Shell'ı starshiple çalışması için ayarla. Aşağıdaki listeden shell'inizi seçin:

<details>
<summary>Bash</summary>

`~/.bashrc` dosyasının sonuna ekleyin:

```sh
eval "$(starship init bash)"
```

</details>

<details>
<summary>Cmd</summary>

Cmd ıle beraber [Clink](https://chrisant996.github.io/clink/clink.html) (v1.2.30+) kullanmalısınız. `%LocalAppData%\clink\starship.lua` dosyasını belirtilen dizinde aşağıdaki kod içeriği olacak şekilde oluşturun:

```lua
load(io.popen('starship init cmd'):read("*a"))()
```

</details>

<details>
<summary>Elvish</summary>

`~/.elvish/rc.elv` dosyasının sonuna ekleyin:

```sh
eval (starship init elvish)
```

Not: Elvish v0.18'den sonraki sürümler desteklenmektedir

</details>

<details>
<summary>Fish</summary>

`~/.config/fish/config.fish` dosyasının sonuna ekleyin:

```fish
starship init fish | source
```

</details>

<details>
<summary>Ion</summary>

`~/.config/ion/initrc` dosyasının sonuna ekleyin:

```sh
eval $(starship init ion)
```

</details>

<details>
<summary>Nushell</summary>

Add the following to the end of your Nushell env file (find it by running `$nu.env-path` in Nushell):

```sh
mkdir ~/.cache/starship
starship init nu | save ~/.cache/starship/init.nu
```

Aşağıdaki kodu Nushell ayarlarınızın (`$nu.config-path` komutu ile ulaşabilirsiniz) sonuna ekleyin:

```sh
source ~/.cache/starship/init.nu
```

Not: Nushell v0.61'tan sonraki sürümler desteklenmektedir

</details>

<details>
<summary>PowerShell</summary>

Aşağıdaki kodu PowerShell ayarlarınızın (`$PROFILE` komutu ile ulaşabilirsiniz) sonuna ekleyin:

```powershell
Invoke-Expression (&starship init powershell)
```

</details>

<details>
<summary>Tcsh</summary>

`~/.tcshrc` dosyasının sonuna ekleyın:

```sh
eval `starship init tcsh`
```

</details>

<details>
<summary>Xonsh</summary>

`~/.xonshrc` dosyasının sonuna ekleyin:

```python
execx($(starship init xonsh))
```

</details>

<details>
<summary>Zsh</summary>

`~/.zshrc` dosyasının sonuna ekleyin:

```sh
eval "$(starship init zsh)"
```

</details>

### 3. Adım Starship'i Yapılandır

Shellinizi yeniden başlatın, işte yeni shell promptunuzun güzelliği ile karşı karşıyasınız. Eğer varsayılan görünümden memnunsanız, keyfini çıkartın!

Daha fazla özelleştirme seçeneği için:

- **[Configuration](https://starship.rs/config/)** – Starship'i yapılandırmayı ve dilediğiniz gibi düzenlenemeyi öğrenin

- **[Presets](https://starship.rs/presets/)** – başkalaranın oluşturduğu düzenlemelerden ilham alın

## 🤝 Katkıda Bulunmak

Katılımcılara **yetenek düzeyleri fark etmeksizin**, her zaman açığız! Eğer katkıda bulunmaya kolay bir şekilde başlamak istiyorsanız [good first issue](https://github.com/starship/starship/labels/🌱%20good%20first%20issue)'lardan bir tanesini deneyin.

Eğer ingilizce harici bir dili akıcı seviyede kullanabiliyorsanız, dosyaların diğer diller ile güncel bir şekilde çevirilebilmesi için yardımlarınızı bekliyoruz. Çeviriye [Starship Crowdin](https://translate.starship.rs/)'den destekte bulunabilirsiniz.

Eğer starship'e katkıda bulunmak istiyorsanız lütfen [Katkı Kılavuzu](https://github.com/starship/starship/blob/master/CONTRIBUTING.md)'na göz atınız. Ayrıca, istediğiniz zaman [Discord server](https://discord.gg/8Jzqu3T)'ımıza gelip merhaba diyebilir, iletişime geçebilirsiniz. 👋

## 💭 İlham Kaynakları

Lütfen starship'in oluşmasında ilham kaynağı olan çalışmalara da göz atın. 🙏

- **[denysdovhan/spaceship-prompt](https://github.com/denysdovhan/spaceship-prompt)** – A ZSH prompt for astronauts.

- **[denysdovhan/robbyrussell-node](https://github.com/denysdovhan/robbyrussell-node)** – Cross-shell robbyrussell theme written in JavaScript.

- **[reujab/silver](https://github.com/reujab/silver)** – A cross-shell customizable powerline-like prompt with icons.

<p align="center">
    <br>
    <img width="100" src="https://raw.githubusercontent.com/starship/starship/master/media/icon.png" alt="Starship rocket icon">
</p>

## 📝 Lisans

Copyright © 2019-present, [Starship Contributors](https://github.com/starship/starship/graphs/contributors).<br /> This project is [ISC](https://github.com/starship/starship/blob/master/LICENSE) licensed.
