# Preset

Ecco una raccolta dei preset di configurazione inviati dalla community per Starship. Se hai un preset da condividere, per favore [ invia un PR ](https://github.com/starship/starship/edit/master/docs/presets/README.md) aggiornando questo file! 😊

To get details on how to use a preset, simply click on the image.

## [Nerd Font Symbols](./nerd-font.md)

This preset changes the symbols for each module to use Nerd Font symbols.

[![Screenshot dei preset di Nerd Font Symbols](/presets/img/nerd-font-symbols.png "Click to view Nerd Font Symbols preset")](./nerd-font)

## [No Nerd Fonts](./no-nerd-font.md)

This preset changes the symbols for several modules so that no Nerd Font symbols are used anywhere in the prompt.

::: tip

This preset will become the default preset [in a future release of starship](https://github.com/starship/starship/pull/3544).

:::

[Click to view No Nerd Font preset](./no-nerd-font)

## [Bracketed Segments](./bracketed-segments.md)

This preset changes the format of all the built-in modules to show their segment in brackets instead of using the default Starship wording ("via", "on", etc.).

[![Screenshot of Bracketed Segments preset](/presets/img/bracketed-segments.png "Click to view Bracketed Segments preset")](./bracketed-segments)

## [Plain Text Symbols](./plain-text.md)

This preset changes the symbols for each module into plain text. Great if you don't have access to Unicode.

[![Screenshot of Plain Text Symbols preset](/presets/img/plain-text-symbols.png "Click to view Plain Text Symbols preset")](./plain-text)

## [No Runtime Versions](./no-runtimes.md)

This preset hides the version of language runtimes. If you work in containers or virtualized environments, this one is for you!

[![Screenshot of Hide Runtime Versions preset](/presets/img/no-runtime-versions.png "Click to view No Runtime Versions preset")](./no-runtimes)

## [No Empty Icons](./no-empty-icons.md)

This preset does not show icons if the toolset is not found.

[![Screenshot of No Empty Icons preset](/presets/img/no-empty-icons.png "Click to view No Runtime Versions preset")](./no-empty-icons.md)

## [Pure Prompt](./pure-preset.md)

This preset emulates the look and behavior of [Pure](https://github.com/sindresorhus/pure).

[![Screenshot of Pure preset](/presets/img/pure-preset.png "Click to view Pure Prompt preset")](./pure-preset)

## [Pastel Powerline](./pastel-powerline.md)

This preset is inspired by [M365Princess](https://github.com/JanDeDobbeleer/oh-my-posh/blob/main/themes/M365Princess.omp.json). It also shows how path substitution works in starship.

[![Screenshot of Pastel Powerline preset](/presets/img/pastel-powerline.png "Click to view Pure Prompt preset")](./pastel-powerline)

## [Tokyo Night](./tokyo-night.md)

This preset is inspired by [tokyo-night-vscode-theme](https://github.com/enkia/tokyo-night-vscode-theme).

[![Screenshot of Tokyo Night preset](/presets/img/tokyo-night.png "Click to view Tokyo Night preset")](./tokyo-night)

## [Gruvbox Rainbow](./gruvbox-rainbow.md)

This preset is heavily inspired by [Pastel Powerline](./pastel-powerline.md), and [Tokyo Night](./tokyo-night.md).

[![Screenshot of Gruvbox Rainbow preset](/presets/img/gruvbox-rainbow.png "Click to view Gruvbox Rainbow preset")](./gruvbox-rainbow)

## [Jetpack](./jetpack.md)

This is a pseudo minimalist preset inspired by the [geometry](https://github.com/geometry-zsh/geometry) and [spaceship](https://github.com/spaceship-prompt/spaceship-prompt) prompts.

[![Screenshot of Jetpack preset](/presets/img/jetpack.png "Click to view Jetpack preset")](./jetpack)

## [Catppuccin Powerline](./catppuccin-powerline.md)

This preset is a minimally modified version of [Gruvbox Rainbow](./gruvbox-rainbow.md) using the [Catppuccin](https://github.com/catppuccin/catppuccin) theme palette.

[![Screenshot of Catppuccin Powerline preset](/presets/img/catppuccin-powerline.png "Click to view Catppuccin Powerline preset")](./catppuccin-powerline)
