<p align="center">
  <img
    width="400"
    src="https://raw.githubusercontent.com/starship/starship/master/media/logo.png"
    alt="Starship – універсальний командний рядок "
 />
</p>

<p align="center">
  <a href="https://github.com/starship/starship/actions"
    ><img
      src="https://img.shields.io/github/actions/workflow/status/starship/starship/workflow.yml?branch=master&label=workflow&style=flat-square"
      alt="Статус дій GitHub"
 /></a>
  <a href="https://crates.io/crates/starship"
    ><img
      src="https://img.shields.io/crates/v/starship?style=flat-square"
      alt="Версія Crates.io"
 /></a>
  <a href="https://repology.org/project/starship/versions"
    ><img
      src="https://img.shields.io/repology/repositories/starship?label=in%20repositories&style=flat-square"
      alt="Стан пакування" /></a
><br />
  <a href="https://discord.gg/starship"
    ><img
      src="https://img.shields.io/discord/567163873606500352?label=discord&logoColor=white&style=flat-square"
      alt="Чат в Discord"
 /></a>
  <a href="https://twitter.com/StarshipPrompt"
    ><img
      src="https://img.shields.io/badge/twitter-@StarshipPrompt-1DA1F3?style=flat-square"
      alt="Слідкуйте за @StarshipPrompt на Twitter"
 /></a>
  <a href="https://stand-with-ukraine.pp.ua"
    ><img
      src="https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/badges/StandWithUkraineFlat.svg"
      alt="Підтримуйте Україну"
 /></a>
</p>

<p align="center">
  <a href="https://starship.rs">Вебсайт</a>
  ·
  <a href="#🚀-installation">Встановлення</a>
  ·
  <a href="https://starship.rs/config/">Налаштування</a>
</p>

<p align="center">
  <a href="https://github.com/starship/starship/blob/master/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-us.png"
      alt="English"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/de-DE/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-de.png"
      alt="Deutsch"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/es-ES/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-es.png"
      alt="Español"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/fr-FR/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-fr.png"
      alt="Français"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/id-ID/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-id.png"
      alt="Bahasa Indonesia"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/it-IT/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-it.png"
      alt="Italiano"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/ja-JP/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-jp.png"
      alt="日本語"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/pt-BR/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-br.png"
      alt="Português do Brasil"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/ru-RU/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-ru.png"
      alt="Русский"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/uk-UA/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-ua.png"
      alt="Українська"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/vi-VN/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-vn.png"
      alt="Tiếng Việt"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/zh-CN/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-cn.png"
      alt="简体中文"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/zh-TW/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-tw.png"
      alt="繁體中文"
 /></a>
</p>

<h1></h1>

<img
  src="https://raw.githubusercontent.com/starship/starship/master/media/demo.gif"
  alt="Starship в iTerm2 з темою Snazzy"
  width="50%"
  align="right"
 />

**Простий, супер швидкий та безмежно адаптивний командний рядок для будь-якої оболонки!**

- **Швидкий:** так, швидкий – _реально_ швидкий! 🚀
- **Адаптивний:** налаштуйте кожен елемент вашого командного рядка.
- **Універсальний:** працює у всіх оболонках, в будь-якій операційній системі.
- **Інформативний:** одразу показує потрібну інформацію.
- **Багато функцій:** підтримує всі ваші улюблені інструменти.
- **Простий:** швидка інсталяція дозволяє почати роботу за лічені хвилини.

<p align="center">
<a href="https://starship.rs/config/"><strong>Ознайомтесь з документацією Starship &nbsp;&nbsp;▶</strong></a>
</p>

<a name="🚀-installation"></a>

## 🚀 Встановлення

### Передумови

- Встановлений та увімкнений у Вашому терміналі набір шрифтів [Nerd Font](https://www.nerdfonts.com/) (для прикладу, спробуйте [Fira Code Nerd Font](https://www.nerdfonts.com/font-downloads)).

### Крок 1. Встановіть Starship

Оберіть вашу операційну систему зі списку нижче для ознайомлення з інструкцією зі встановлення:

<details>
<summary>Android</summary>

Встановіть Starship використовуючи будь-який з наступних менеджерів пакунків:

| Репозиторій                                                                       | Команда для встановлення |
| --------------------------------------------------------------------------------- | ------------------------ |
| [Termux](https://github.com/termux/termux-packages/tree/master/packages/starship) | `pkg install starship`   |

</details>

<details>
<summary>BSD</summary>

Встановіть Starship використовуючи будь-який з наступних менеджерів пакунків:

| Дистрибутив     | Репозиторій                                              | Команда для встановлення          |
| --------------- | -------------------------------------------------------- | --------------------------------- |
| **_Будь-який_** | **[crates.io](https://crates.io/crates/starship)**       | `cargo install starship --locked` |
| FreeBSD         | [FreshPorts](https://www.freshports.org/shells/starship) | `pkg install starship`            |
| NetBSD          | [pkgsrc](https://pkgsrc.se/shells/starship)              | `pkgin install starship`          |

</details>

<details>
<summary>Linux</summary>

Встановіть останню версію для вашої системи:

```sh
curl -sS https://starship.rs/install.sh | sh
```

Як варіант, можете встановити Starship скориставшись будь-яким з наступних менеджерів пакунків:

| Дистрибутив        | Репозиторій                                                                                     | Команда для встановлення                                                       |
| ------------------ | ----------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------ |
| **_Будь-який_**    | **[crates.io](https://crates.io/crates/starship)**                                              | `cargo install starship --locked`                                              |
| _Будь-який_        | [conda-forge](https://anaconda.org/conda-forge/starship)                                        | `conda install -c conda-forge starship`                                        |
| _Будь-який_        | [Linuxbrew](https://formulae.brew.sh/formula/starship)                                          | `brew install starship`                                                        |
| Alpine Linux 3.13+ | [Alpine Linux Packages](https://pkgs.alpinelinux.org/packages?name=starship)                    | `apk add starship`                                                             |
| Arch Linux         | [Arch Linux Extra](https://archlinux.org/packages/extra/x86_64/starship)                        | `pacman -S starship`                                                           |
| CentOS 7+          | [Copr](https://copr.fedorainfracloud.org/coprs/atim/starship)                                   | `dnf copr enable atim/starship` <br /> `dnf install starship` |
| Gentoo             | [Gentoo Packages](https://packages.gentoo.org/packages/app-shells/starship)                     | `emerge app-shells/starship`                                                   |
| Manjaro            |                                                                                                 | `pacman -S starship`                                                           |
| NixOS              | [nixpkgs](https://github.com/NixOS/nixpkgs/blob/master/pkgs/tools/misc/starship/default.nix)    | `nix-env -iA nixpkgs.starship`                                                 |
| openSUSE           | [OSS](https://software.opensuse.org/package/starship)                                           | `zypper in starship`                                                           |
| Void Linux         | [Void Linux Packages](https://github.com/void-linux/void-packages/tree/master/srcpkgs/starship) | `xbps-install -S starship`                                                     |

</details>

<details>
<summary>macOS</summary>

Встановіть останню версію для вашої системи:

```sh
curl -sS https://starship.rs/install.sh | sh
```

Як варіант, можете встановити Starship скориставшись будь-яким з наступних менеджерів пакунків:

| Репозиторій                                              | Команда для встановлення                |
| -------------------------------------------------------- | --------------------------------------- |
| **[crates.io](https://crates.io/crates/starship)**       | `cargo install starship --locked`       |
| [conda-forge](https://anaconda.org/conda-forge/starship) | `conda install -c conda-forge starship` |
| [Homebrew](https://formulae.brew.sh/formula/starship)    | `brew install starship`                 |
| [MacPorts](https://ports.macports.org/port/starship)     | `port install starship`                 |

</details>

<details>
<summary>Windows</summary>

Встановіть останню версію для вашої системи за допомогою MSI-інсталятора з розділу [релізів](https://github.com/starship/starship/releases/latest).

Встановіть Starship використовуючи будь-який з наступних менеджерів пакунків:

| Репозиторій                                                                                  | Команда для встановлення                |
| -------------------------------------------------------------------------------------------- | --------------------------------------- |
| **[crates.io](https://crates.io/crates/starship)**                                           | `cargo install starship --locked`       |
| [Chocolatey](https://community.chocolatey.org/packages/starship)                             | `choco install starship`                |
| [conda-forge](https://anaconda.org/conda-forge/starship)                                     | `conda install -c conda-forge starship` |
| [Scoop](https://github.com/ScoopInstaller/Main/blob/master/bucket/starship.json)             | `scoop install starship`                |
| [winget](https://github.com/microsoft/winget-pkgs/tree/master/manifests/s/Starship/Starship) | `winget install --id Starship.Starship` |

</details>

### Крок 2. Налаштуйте оболонку для використання Starship

Налаштуйте свою оболонку, щоб ініціалізувати starship. Виберіть ваш варіант зі списку:

<details>
<summary>Bash</summary>

Додайте наступний рядок наприкінці `~/.bashrc`:

```sh
eval "$(starship init bash)"
```

</details>

<details>
<summary>Cmd</summary>

Вам потрібно використовувати [Clink](https://chrisant996.github.io/clink/clink.html) (v1.2.30+) разом з Cmd. Створіть файл `%LocalAppData%\clink\starship.lua` із наступним вмістом:

```lua
load(io.popen('starship init cmd'):read("*a"))()
```

</details>

<details>
<summary>Elvish</summary>

Додайте наступний рядок наприкінці `~/.elvish/rc.elv`:

```sh
eval (starship init elvish)
```

Примітка: Підтримується лише Elvish v0.18+

</details>

<details>
<summary>Fish</summary>

Додайте наступний рядок наприкінці `~/.config/fish/config.fish`:

```fish
starship init fish | source
```

</details>

<details>
<summary>Ion</summary>

Додайте наступний рядок наприкінці `~/.config/ion/initrc`:

```sh
eval $(starship init ion)
```

</details>

<details>
<summary>Nushell</summary>

Додайте наступне в кінець вашого файлу env (його можна знайти за допомогою змінної `$nu.env-path` в Nushell):

```sh
mkdir ~/.cache/starship
starship init nu | save -f ~/.cache/starship/init.nu
```

Додайте наступний рядок наприкінці Вашої конфігурації Nushell (знайдіть її виконавши `$nu.config-path`):

```sh
use ~/.cache/starship/init.nu
```

Примітка: Підтримується лише Nushell v0.78+

</details>

<details>
<summary>PowerShell</summary>

Додайте наступний рядок наприкінці вашої конфігурації PowerShell (знайдіть її виконавши команду `$PROFILE`):

```powershell
Invoke-Expression (&starship init powershell)
```

</details>

<details>
<summary>Tcsh</summary>

Додайте наступний рядок наприкінці `~/.tcshrc`:

```sh
eval `starship init tcsh`
```

</details>

<details>
<summary>Xonsh</summary>

Додайте наступний рядок наприкінці `~/.xonshrc`:

```python
execx($(starship init xonsh))
```

</details>

<details>
<summary>Zsh</summary>

Додайте наступний рядок наприкінці `~/.zshrc`:

```sh
eval "$(starship init zsh)"
```

</details>

### Крок 3. Налаштуйте starship

Запустіть новий екземпляр вашої оболонки і ви побачите новий яскравий командний рядок. Якщо ви задоволені налаштуваннями, насолоджуйтесь!

Якщо ви бажаєте додатково налаштувати Starship:

- **[Налаштування](https://starship.rs/config/)** – дізнайтесь як налаштувати Starship, щоб підлаштувати командний рядок під свої потреби

- **[Шаблони](https://starship.rs/presets/)** – спробуйте готові налаштування, створені іншими

## 🤝 Участь

Ми завжди раді вашому внеску, незалежно від рівня **вашого досвіду**! Якщо ви шукаєте спосіб допомоги проєкту, але ще не визначились, що можна зробити, спробуйте [завдання для початківців](https://github.com/starship/starship/labels/🌱%20good%20first%20issue).

Якщо ви вільно володієте мовою відмінною від англійської, ми будемо дуже вдячні, якщо ви допоможете в перекладі документації та її підтримці в актуальному стані. Якщо у вас є бажання, переклади можна робити за допомогою [Starship Crowdin](https://translate.starship.rs/).

Якщо ви зацікавлені у допомозі в розвитку starship, будь ласка, ознайомтесь з [Настановами з участі](https://github.com/starship/starship/blob/master/CONTRIBUTING.md). Також, завітайте до нашого [сервера Discord](https://discord.gg/8Jzqu3T). 👋

## 💭 Подяки

Будь ласка, перегляньте роботи, які надихнули на створення starship. 🙏

- **[denysdovhan/spaceship-prompt](https://github.com/denysdovhan/spaceship-prompt)** – Командний рядок ZSH для астронавтів.

- **[denysdovhan/robbyrussell-node](https://github.com/denysdovhan/robbyrussell-node)** – Крос-оболонкова тема robbyrussell написана з використаннями JavaScript.

- **[reujab/silver](https://github.com/reujab/silver)** – Крос-оболонковий командний рядок подібний до powerline з підтримкою значків.

## ❤️ Спонсори

Підтримайте цей проєкт [ставши спонсором](https://github.com/sponsors/starship). Ваше імʼя або логотип показуватимуться тут з посиланням на ваш сайт.

**Підтримувачі**

- [Appwrite](https://appwrite.io/)

<p align="center">
    <br>
    <img width="100" src="https://raw.githubusercontent.com/starship/starship/master/media/icon.png" alt="Starship rocket icon">
</p>

## 📝 Ліцензія

Авторські права © 2019-по сьогодні, [Учасники Starship](https://github.com/starship/starship/graphs/contributors).<br /> Цей проєкт ліцензується на умовах Ліцензії [ISC](https://github.com/starship/starship/blob/master/LICENSE).
