; Copyright (c) 2019-2020, The rav1e contributors. All rights reserved
;
; This source code is subject to the terms of the BSD 2 Clause License and
; the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
; was not distributed with this source code in the LICENSE file, you can
; obtain it at www.aomedia.org/license/software. If the Alliance for Open
; Media Patent License 1.0 was not distributed with this source code in the
; PATENTS file, you can obtain it at www.aomedia.org/license/patent.

; Copyright © 2018, VideoLAN and dav1d authors
; Copyright © 2018, Two Orioles, LLC
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
;
; 1. Redistributions of source code must retain the above copyright notice, this
;    list of conditions and the following disclaimer.
;
; 2. Redistributions in binary form must reproduce the above copyright notice,
;    this list of conditions and the following disclaimer in the documentation
;    and/or other materials provided with the distribution.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

%include "config.asm"
%include "ext/x86/x86inc.asm"

SECTION_RODATA 16

align 8, db 0
const mc_subpel_filters, db  0,   1,  -3,  63,   4,  -1,   0,   0, ; REGULAR
                         db  0,   1,  -5,  61,   9,  -2,   0,   0,
                         db  0,   1,  -6,  58,  14,  -4,   1,   0,
                         db  0,   1,  -7,  55,  19,  -5,   1,   0,
                         db  0,   1,  -7,  51,  24,  -6,   1,   0,
                         db  0,   1,  -8,  47,  29,  -6,   1,   0,
                         db  0,   1,  -7,  42,  33,  -6,   1,   0,
                         db  0,   1,  -7,  38,  38,  -7,   1,   0,
                         db  0,   1,  -6,  33,  42,  -7,   1,   0,
                         db  0,   1,  -6,  29,  47,  -8,   1,   0,
                         db  0,   1,  -6,  24,  51,  -7,   1,   0,
                         db  0,   1,  -5,  19,  55,  -7,   1,   0,
                         db  0,   1,  -4,  14,  58,  -6,   1,   0,
                         db  0,   0,  -2,   9,  61,  -5,   1,   0,
                         db  0,   0,  -1,   4,  63,  -3,   1,   0,
                         db  0,   1,  14,  31,  17,   1,   0,   0, ; SMOOTH
                         db  0,   0,  13,  31,  18,   2,   0,   0,
                         db  0,   0,  11,  31,  20,   2,   0,   0,
                         db  0,   0,  10,  30,  21,   3,   0,   0,
                         db  0,   0,   9,  29,  22,   4,   0,   0,
                         db  0,   0,   8,  28,  23,   5,   0,   0,
                         db  0,  -1,   8,  27,  24,   6,   0,   0,
                         db  0,  -1,   7,  26,  26,   7,  -1,   0,
                         db  0,   0,   6,  24,  27,   8,  -1,   0,
                         db  0,   0,   5,  23,  28,   8,   0,   0,
                         db  0,   0,   4,  22,  29,   9,   0,   0,
                         db  0,   0,   3,  21,  30,  10,   0,   0,
                         db  0,   0,   2,  20,  31,  11,   0,   0,
                         db  0,   0,   2,  18,  31,  13,   0,   0,
                         db  0,   0,   1,  17,  31,  14,   1,   0,
                         db -1,   1,  -3,  63,   4,  -1,   1,   0, ; SHARP
                         db -1,   3,  -6,  62,   8,  -3,   2,  -1,
                         db -1,   4,  -9,  60,  13,  -5,   3,  -1,
                         db -2,   5, -11,  58,  19,  -7,   3,  -1,
                         db -2,   5, -11,  54,  24,  -9,   4,  -1,
                         db -2,   5, -12,  50,  30, -10,   4,  -1,
                         db -2,   5, -12,  45,  35, -11,   5,  -1,
                         db -2,   6, -12,  40,  40, -12,   6,  -2,
                         db -1,   5, -11,  35,  45, -12,   5,  -2,
                         db -1,   4, -10,  30,  50, -12,   5,  -2,
                         db -1,   4,  -9,  24,  54, -11,   5,  -2,
                         db -1,   3,  -7,  19,  58, -11,   5,  -2,
                         db -1,   3,  -5,  13,  60,  -9,   4,  -1,
                         db -1,   2,  -3,   8,  62,  -6,   3,  -1,
                         db  0,   1,  -1,   4,  63,  -3,   1,  -1,
                         db  0,   0,  -2,  63,   4,  -1,   0,   0, ; REGULAR 4
                         db  0,   0,  -4,  61,   9,  -2,   0,   0,
                         db  0,   0,  -5,  58,  14,  -3,   0,   0,
                         db  0,   0,  -6,  55,  19,  -4,   0,   0,
                         db  0,   0,  -6,  51,  24,  -5,   0,   0,
                         db  0,   0,  -7,  47,  29,  -5,   0,   0,
                         db  0,   0,  -6,  42,  33,  -5,   0,   0,
                         db  0,   0,  -6,  38,  38,  -6,   0,   0,
                         db  0,   0,  -5,  33,  42,  -6,   0,   0,
                         db  0,   0,  -5,  29,  47,  -7,   0,   0,
                         db  0,   0,  -5,  24,  51,  -6,   0,   0,
                         db  0,   0,  -4,  19,  55,  -6,   0,   0,
                         db  0,   0,  -3,  14,  58,  -5,   0,   0,
                         db  0,   0,  -2,   9,  61,  -4,   0,   0,
                         db  0,   0,  -1,   4,  63,  -2,   0,   0,
                         db  0,   0,  15,  31,  17,   1,   0,   0, ; SMOOTH 4
                         db  0,   0,  13,  31,  18,   2,   0,   0,
                         db  0,   0,  11,  31,  20,   2,   0,   0,
                         db  0,   0,  10,  30,  21,   3,   0,   0,
                         db  0,   0,   9,  29,  22,   4,   0,   0,
                         db  0,   0,   8,  28,  23,   5,   0,   0,
                         db  0,   0,   7,  27,  24,   6,   0,   0,
                         db  0,   0,   6,  26,  26,   6,   0,   0,
                         db  0,   0,   6,  24,  27,   7,   0,   0,
                         db  0,   0,   5,  23,  28,   8,   0,   0,
                         db  0,   0,   4,  22,  29,   9,   0,   0,
                         db  0,   0,   3,  21,  30,  10,   0,   0,
                         db  0,   0,   2,  20,  31,  11,   0,   0,
                         db  0,   0,   2,  18,  31,  13,   0,   0,
                         db  0,   0,   1,  17,  31,  15,   0,   0

align 16, db 0
const filter_intra_taps, db  -6,  10,  -5,   2,  -3,   1,  -3,   1, ; 0
                         db  -4,   6,  -3,   2,  -3,   2,  -3,   1,
                         db   0,   0,  10,   0,   1,  10,   1,   2,
                         db   0,   0,   6,   0,   2,   6,   2,   2,
                         db   0,  12,   0,   9,   0,   7,  10,   5,
                         db   0,   2,   0,   2,   0,   2,   6,   3,
                         db   0,   0,   0,   0,   0,   0,   0,   0,
                         db  12,   0,   9,   0,   7,   0,   5,   0,
                         db -10,  16,  -6,   0,  -4,   0,  -2,   0, ; 1
                         db -10,  16,  -6,   0,  -4,   0,  -2,   0,
                         db   0,   0,  16,   0,   0,  16,   0,   0,
                         db   0,   0,  16,   0,   0,  16,   0,   0,
                         db   0,  10,   0,   6,   0,   4,  16,   2,
                         db   0,   0,   0,   0,   0,   0,  16,   0,
                         db   0,   0,   0,   0,   0,   0,   0,   0,
                         db  10,   0,   6,   0,   4,   0,   2,   0,
                         db  -8,   8,  -8,   0,  -8,   0,  -8,   0, ; 2
                         db  -4,   4,  -4,   0,  -4,   0,  -4,   0,
                         db   0,   0,   8,   0,   0,   8,   0,   0,
                         db   0,   0,   4,   0,   0,   4,   0,   0,
                         db   0,  16,   0,  16,   0,  16,   8,  16,
                         db   0,   0,   0,   0,   0,   0,   4,   0,
                         db   0,   0,   0,   0,   0,   0,   0,   0,
                         db  16,   0,  16,   0,  16,   0,  16,   0,
                         db  -2,   8,  -1,   3,  -1,   2,   0,   1, ; 3
                         db  -1,   4,  -1,   3,  -1,   2,  -1,   2,
                         db   0,   0,   8,   0,   3,   8,   2,   3,
                         db   0,   0,   4,   0,   3,   4,   2,   3,
                         db   0,  10,   0,   6,   0,   4,   8,   2,
                         db   0,   3,   0,   4,   0,   4,   4,   3,
                         db   0,   0,   0,   0,   0,   0,   0,   0,
                         db  10,   0,   6,   0,   4,   0,   3,   0,
                         db -12,  14, -10,   0,  -9,   0,  -8,   0, ; 4
                         db -10,  12,  -9,   1,  -8,   0,  -7,   0,
                         db   0,   0,  14,   0,   0,  14,   0,   0,
                         db   0,   0,  12,   0,   0,  12,   0,   1,
                         db   0,  14,   0,  12,   0,  11,  14,  10,
                         db   0,   0,   0,   0,   0,   1,  12,   1,
                         db   0,   0,   0,   0,   0,   0,   0,   0,
                         db  14,   0,  12,   0,  11,   0,   9,   0

align 16, db 0
const sgr_x_by_x, db 255, 128,  85,  64,  51,  43,  37,  32,  28,  26,  23,  21,  20,  18,  17,
                  db  16,  15,  14,  13,  13,  12,  12,  11,  11,  10,  10,   9,   9,   9,   9,
                  db   8,   8,   8,   8,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   6,
                  db   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   4,   4,   4,   4,
                  db   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,
                  db   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
                  db   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   2,
                  db   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
                  db   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
                  db   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
                  db   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
                  db   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                  db   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                  db   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                  db   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                  db   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                  db   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                  db   0

align 8, db 0
const mc_warp_filter, db 0, 127,   0, 0,   0,   1, 0, 0,  0, 127,   0, 0,  -1,   2, 0, 0, ; [-1, 0)
                      db 1, 127,  -1, 0,  -3,   4, 0, 0,  1, 126,  -2, 0,  -4,   6, 1, 0,
                      db 1, 126,  -3, 0,  -5,   8, 1, 0,  1, 125,  -4, 0,  -6,  11, 1, 0,
                      db 1, 124,  -4, 0,  -7,  13, 1, 0,  2, 123,  -5, 0,  -8,  15, 1, 0,
                      db 2, 122,  -6, 0,  -9,  18, 1, 0,  2, 121,  -6, 0, -10,  20, 1, 0,
                      db 2, 120,  -7, 0, -11,  22, 2, 0,  2, 119,  -8, 0, -12,  25, 2, 0,
                      db 3, 117,  -8, 0, -13,  27, 2, 0,  3, 116,  -9, 0, -13,  29, 2, 0,
                      db 3, 114, -10, 0, -14,  32, 3, 0,  3, 113, -10, 0, -15,  35, 2, 0,
                      db 3, 111, -11, 0, -15,  37, 3, 0,  3, 109, -11, 0, -16,  40, 3, 0,
                      db 3, 108, -12, 0, -16,  42, 3, 0,  4, 106, -13, 0, -17,  45, 3, 0,
                      db 4, 104, -13, 0, -17,  47, 3, 0,  4, 102, -14, 0, -17,  50, 3, 0,
                      db 4, 100, -14, 0, -17,  52, 3, 0,  4,  98, -15, 0, -18,  55, 4, 0,
                      db 4,  96, -15, 0, -18,  58, 3, 0,  4,  94, -16, 0, -18,  60, 4, 0,
                      db 4,  91, -16, 0, -18,  63, 4, 0,  4,  89, -16, 0, -18,  65, 4, 0,
                      db 4,  87, -17, 0, -18,  68, 4, 0,  4,  85, -17, 0, -18,  70, 4, 0,
                      db 4,  82, -17, 0, -18,  73, 4, 0,  4,  80, -17, 0, -18,  75, 4, 0,
                      db 4,  78, -18, 0, -18,  78, 4, 0,  4,  75, -18, 0, -17,  80, 4, 0,
                      db 4,  73, -18, 0, -17,  82, 4, 0,  4,  70, -18, 0, -17,  85, 4, 0,
                      db 4,  68, -18, 0, -17,  87, 4, 0,  4,  65, -18, 0, -16,  89, 4, 0,
                      db 4,  63, -18, 0, -16,  91, 4, 0,  4,  60, -18, 0, -16,  94, 4, 0,
                      db 3,  58, -18, 0, -15,  96, 4, 0,  4,  55, -18, 0, -15,  98, 4, 0,
                      db 3,  52, -17, 0, -14, 100, 4, 0,  3,  50, -17, 0, -14, 102, 4, 0,
                      db 3,  47, -17, 0, -13, 104, 4, 0,  3,  45, -17, 0, -13, 106, 4, 0,
                      db 3,  42, -16, 0, -12, 108, 3, 0,  3,  40, -16, 0, -11, 109, 3, 0,
                      db 3,  37, -15, 0, -11, 111, 3, 0,  2,  35, -15, 0, -10, 113, 3, 0,
                      db 3,  32, -14, 0, -10, 114, 3, 0,  2,  29, -13, 0,  -9, 116, 3, 0,
                      db 2,  27, -13, 0,  -8, 117, 3, 0,  2,  25, -12, 0,  -8, 119, 2, 0,
                      db 2,  22, -11, 0,  -7, 120, 2, 0,  1,  20, -10, 0,  -6, 121, 2, 0,
                      db 1,  18,  -9, 0,  -6, 122, 2, 0,  1,  15,  -8, 0,  -5, 123, 2, 0,
                      db 1,  13,  -7, 0,  -4, 124, 1, 0,  1,  11,  -6, 0,  -4, 125, 1, 0,
                      db 1,   8,  -5, 0,  -3, 126, 1, 0,  1,   6,  -4, 0,  -2, 126, 1, 0,
                      db 0,   4,  -3, 0,  -1, 127, 1, 0,  0,   2,  -1, 0,   0, 127, 0, 0,
                      db  0,   0,   1, 0, 0, 127,   0,  0,   0,  -1,   2, 0, 0, 127,   0,  0, ; [0, 1)
                      db  0,  -3,   4, 1, 1, 127,  -2,  0,   0,  -5,   6, 1, 1, 127,  -2,  0,
                      db  0,  -6,   8, 1, 2, 126,  -3,  0,  -1,  -7,  11, 2, 2, 126,  -4, -1,
                      db -1,  -8,  13, 2, 3, 125,  -5, -1,  -1, -10,  16, 3, 3, 124,  -6, -1,
                      db -1, -11,  18, 3, 4, 123,  -7, -1,  -1, -12,  20, 3, 4, 122,  -7, -1,
                      db -1, -13,  23, 3, 4, 121,  -8, -1,  -2, -14,  25, 4, 5, 120,  -9, -1,
                      db -1, -15,  27, 4, 5, 119, -10, -1,  -1, -16,  30, 4, 5, 118, -11, -1,
                      db -2, -17,  33, 5, 6, 116, -12, -1,  -2, -17,  35, 5, 6, 114, -12, -1,
                      db -2, -18,  38, 5, 6, 113, -13, -1,  -2, -19,  41, 6, 7, 111, -14, -2,
                      db -2, -19,  43, 6, 7, 110, -15, -2,  -2, -20,  46, 6, 7, 108, -15, -2,
                      db -2, -20,  49, 6, 7, 106, -16, -2,  -2, -21,  51, 7, 7, 104, -16, -2,
                      db -2, -21,  54, 7, 7, 102, -17, -2,  -2, -21,  56, 7, 8, 100, -18, -2,
                      db -2, -22,  59, 7, 8,  98, -18, -2,  -2, -22,  62, 7, 8,  96, -19, -2,
                      db -2, -22,  64, 7, 8,  94, -19, -2,  -2, -22,  67, 8, 8,  91, -20, -2,
                      db -2, -22,  69, 8, 8,  89, -20, -2,  -2, -22,  72, 8, 8,  87, -21, -2,
                      db -2, -21,  74, 8, 8,  84, -21, -2,  -2, -22,  77, 8, 8,  82, -21, -2,
                      db -2, -21,  79, 8, 8,  79, -21, -2,  -2, -21,  82, 8, 8,  77, -22, -2,
                      db -2, -21,  84, 8, 8,  74, -21, -2,  -2, -21,  87, 8, 8,  72, -22, -2,
                      db -2, -20,  89, 8, 8,  69, -22, -2,  -2, -20,  91, 8, 8,  67, -22, -2,
                      db -2, -19,  94, 8, 7,  64, -22, -2,  -2, -19,  96, 8, 7,  62, -22, -2,
                      db -2, -18,  98, 8, 7,  59, -22, -2,  -2, -18, 100, 8, 7,  56, -21, -2,
                      db -2, -17, 102, 7, 7,  54, -21, -2,  -2, -16, 104, 7, 7,  51, -21, -2,
                      db -2, -16, 106, 7, 6,  49, -20, -2,  -2, -15, 108, 7, 6,  46, -20, -2,
                      db -2, -15, 110, 7, 6,  43, -19, -2,  -2, -14, 111, 7, 6,  41, -19, -2,
                      db -1, -13, 113, 6, 5,  38, -18, -2,  -1, -12, 114, 6, 5,  35, -17, -2,
                      db -1, -12, 116, 6, 5,  33, -17, -2,  -1, -11, 118, 5, 4,  30, -16, -1,
                      db -1, -10, 119, 5, 4,  27, -15, -1,  -1,  -9, 120, 5, 4,  25, -14, -2,
                      db -1,  -8, 121, 4, 3,  23, -13, -1,  -1,  -7, 122, 4, 3,  20, -12, -1,
                      db -1,  -7, 123, 4, 3,  18, -11, -1,  -1,  -6, 124, 3, 3,  16, -10, -1,
                      db -1,  -5, 125, 3, 2,  13,  -8, -1,  -1,  -4, 126, 2, 2,  11,  -7, -1,
                      db  0,  -3, 126, 2, 1,   8,  -6,  0,   0,  -2, 127, 1, 1,   6,  -5,  0,
                      db  0,  -2, 127, 1, 1,   4,  -3,  0,   0,   0, 127, 0, 0,   2,  -1,  0,
                      db 0, 0, 127,   0, 0,   1,   0, 0,  0, 0, 127,   0, 0,  -1,   2, 0, ; [1, 2)
                      db 0, 1, 127,  -1, 0,  -3,   4, 0,  0, 1, 126,  -2, 0,  -4,   6, 1,
                      db 0, 1, 126,  -3, 0,  -5,   8, 1,  0, 1, 125,  -4, 0,  -6,  11, 1,
                      db 0, 1, 124,  -4, 0,  -7,  13, 1,  0, 2, 123,  -5, 0,  -8,  15, 1,
                      db 0, 2, 122,  -6, 0,  -9,  18, 1,  0, 2, 121,  -6, 0, -10,  20, 1,
                      db 0, 2, 120,  -7, 0, -11,  22, 2,  0, 2, 119,  -8, 0, -12,  25, 2,
                      db 0, 3, 117,  -8, 0, -13,  27, 2,  0, 3, 116,  -9, 0, -13,  29, 2,
                      db 0, 3, 114, -10, 0, -14,  32, 3,  0, 3, 113, -10, 0, -15,  35, 2,
                      db 0, 3, 111, -11, 0, -15,  37, 3,  0, 3, 109, -11, 0, -16,  40, 3,
                      db 0, 3, 108, -12, 0, -16,  42, 3,  0, 4, 106, -13, 0, -17,  45, 3,
                      db 0, 4, 104, -13, 0, -17,  47, 3,  0, 4, 102, -14, 0, -17,  50, 3,
                      db 0, 4, 100, -14, 0, -17,  52, 3,  0, 4,  98, -15, 0, -18,  55, 4,
                      db 0, 4,  96, -15, 0, -18,  58, 3,  0, 4,  94, -16, 0, -18,  60, 4,
                      db 0, 4,  91, -16, 0, -18,  63, 4,  0, 4,  89, -16, 0, -18,  65, 4,
                      db 0, 4,  87, -17, 0, -18,  68, 4,  0, 4,  85, -17, 0, -18,  70, 4,
                      db 0, 4,  82, -17, 0, -18,  73, 4,  0, 4,  80, -17, 0, -18,  75, 4,
                      db 0, 4,  78, -18, 0, -18,  78, 4,  0, 4,  75, -18, 0, -17,  80, 4,
                      db 0, 4,  73, -18, 0, -17,  82, 4,  0, 4,  70, -18, 0, -17,  85, 4,
                      db 0, 4,  68, -18, 0, -17,  87, 4,  0, 4,  65, -18, 0, -16,  89, 4,
                      db 0, 4,  63, -18, 0, -16,  91, 4,  0, 4,  60, -18, 0, -16,  94, 4,
                      db 0, 3,  58, -18, 0, -15,  96, 4,  0, 4,  55, -18, 0, -15,  98, 4,
                      db 0, 3,  52, -17, 0, -14, 100, 4,  0, 3,  50, -17, 0, -14, 102, 4,
                      db 0, 3,  47, -17, 0, -13, 104, 4,  0, 3,  45, -17, 0, -13, 106, 4,
                      db 0, 3,  42, -16, 0, -12, 108, 3,  0, 3,  40, -16, 0, -11, 109, 3,
                      db 0, 3,  37, -15, 0, -11, 111, 3,  0, 2,  35, -15, 0, -10, 113, 3,
                      db 0, 3,  32, -14, 0, -10, 114, 3,  0, 2,  29, -13, 0,  -9, 116, 3,
                      db 0, 2,  27, -13, 0,  -8, 117, 3,  0, 2,  25, -12, 0,  -8, 119, 2,
                      db 0, 2,  22, -11, 0,  -7, 120, 2,  0, 1,  20, -10, 0,  -6, 121, 2,
                      db 0, 1,  18,  -9, 0,  -6, 122, 2,  0, 1,  15,  -8, 0,  -5, 123, 2,
                      db 0, 1,  13,  -7, 0,  -4, 124, 1,  0, 1,  11,  -6, 0,  -4, 125, 1,
                      db 0, 1,   8,  -5, 0,  -3, 126, 1,  0, 1,   6,  -4, 0,  -2, 126, 1,
                      db 0, 0,   4,  -3, 0,  -1, 127, 1,  0, 0,   2,  -1, 0,   0, 127, 0,
                      db 0, 0,   2,  -1, 0,   0, 127, 0 ; dummy (replicate row index 191)

; Values that are 0 will never be used
align 2, db 0
const dr_intra_derivative, dw       0,    ; Angles:
                           dw 1023, 0,    ;  3,  93, 183
                           dw  547,       ;  6,  96, 186
                           dw  372, 0, 0, ;  9,  99, 189
                           dw  273,       ; 14, 104, 194
                           dw  215, 0,    ; 17, 107, 197
                           dw  178,       ; 20, 110, 200
                           dw  151, 0,    ; 23, 113, 203 (113 & 203 are base angles)
                           dw  132,       ; 26, 116, 206
                           dw  116, 0,    ; 29, 119, 209
                           dw  102, 0,    ; 32, 122, 212
                           dw   90,       ; 36, 126, 216
                           dw   80, 0,    ; 39, 129, 219
                           dw   71,       ; 42, 132, 222
                           dw   64, 0,    ; 45, 135, 225 (45 & 135 are base angles)
                           dw   57,       ; 48, 138, 228
                           dw   51, 0,    ; 51, 141, 231
                           dw   45, 0,    ; 54, 144, 234
                           dw   40,       ; 58, 148, 238
                           dw   35, 0,    ; 61, 151, 241
                           dw   31,       ; 64, 154, 244
                           dw   27, 0,    ; 67, 157, 247 (67 & 157 are base angles)
                           dw   23,       ; 70, 160, 250
                           dw   19, 0,    ; 73, 163, 253
                           dw   15, 0,    ; 76, 166, 256
                           dw   11, 0,    ; 81, 171, 261
                           dw    7,       ; 84, 174, 264
                           dw    3        ; 87, 177, 267

; Taken from the spec. Range is [-2048, 2047], mean is 0 and stddev is 512
align 2, db 0
const gaussian_sequence, dw 56,    568,   -180,  172,   124,   -84,   172,   -64,   -900,  24,   820,
                         dw 224,   1248,  996,   272,   -8,    -916,  -388,  -732,  -104,  -188, 800,
                         dw 112,   -652,  -320,  -376,  140,   -252,  492,   -168,  44,    -788, 588,
                         dw -584,  500,   -228,  12,    680,   272,   -476,  972,   -100,  652,  368,
                         dw 432,   -196,  -720,  -192,  1000,  -332,  652,   -136,  -552,  -604, -4,
                         dw 192,   -220,  -136,  1000,  -52,   372,   -96,   -624,  124,   -24,  396,
                         dw 540,   -12,   -104,  640,   464,   244,   -208,  -84,   368,   -528, -740,
                         dw 248,   -968,  -848,  608,   376,   -60,   -292,  -40,   -156,  252,  -292,
                         dw 248,   224,   -280,  400,   -244,  244,   -60,   76,    -80,   212,  532,
                         dw 340,   128,   -36,   824,   -352,  -60,   -264,  -96,   -612,  416,  -704,
                         dw 220,   -204,  640,   -160,  1220,  -408,  900,   336,   20,    -336, -96,
                         dw -792,  304,   48,    -28,   -1232, -1172, -448,  104,   -292,  -520, 244,
                         dw 60,    -948,  0,     -708,  268,   108,   356,   -548,  488,   -344, -136,
                         dw 488,   -196,  -224,  656,   -236,  -1128, 60,    4,     140,   276,  -676,
                         dw -376,  168,   -108,  464,   8,     564,   64,    240,   308,   -300, -400,
                         dw -456,  -136,  56,    120,   -408,  -116,  436,   504,   -232,  328,  844,
                         dw -164,  -84,   784,   -168,  232,   -224,  348,   -376,  128,   568,  96,
                         dw -1244, -288,  276,   848,   832,   -360,  656,   464,   -384,  -332, -356,
                         dw 728,   -388,  160,   -192,  468,   296,   224,   140,   -776,  -100, 280,
                         dw 4,     196,   44,    -36,   -648,  932,   16,    1428,  28,    528,  808,
                         dw 772,   20,    268,   88,    -332,  -284,  124,   -384,  -448,  208,  -228,
                         dw -1044, -328,  660,   380,   -148,  -300,  588,   240,   540,   28,   136,
                         dw -88,   -436,  256,   296,   -1000, 1400,  0,     -48,   1056,  -136, 264,
                         dw -528,  -1108, 632,   -484,  -592,  -344,  796,   124,   -668,  -768, 388,
                         dw 1296,  -232,  -188,  -200,  -288,  -4,    308,   100,   -168,  256,  -500,
                         dw 204,   -508,  648,   -136,  372,   -272,  -120,  -1004, -552,  -548, -384,
                         dw 548,   -296,  428,   -108,  -8,    -912,  -324,  -224,  -88,   -112, -220,
                         dw -100,  996,   -796,  548,   360,   -216,  180,   428,   -200,  -212, 148,
                         dw 96,    148,   284,   216,   -412,  -320,  120,   -300,  -384,  -604, -572,
                         dw -332,  -8,    -180,  -176,  696,   116,   -88,   628,   76,    44,   -516,
                         dw 240,   -208,  -40,   100,   -592,  344,   -308,  -452,  -228,  20,   916,
                         dw -1752, -136,  -340,  -804,  140,   40,    512,   340,   248,   184,  -492,
                         dw 896,   -156,  932,   -628,  328,   -688,  -448,  -616,  -752,  -100, 560,
                         dw -1020, 180,   -800,  -64,   76,    576,   1068,  396,   660,   552,  -108,
                         dw -28,   320,   -628,  312,   -92,   -92,   -472,  268,   16,    560,  516,
                         dw -672,  -52,   492,   -100,  260,   384,   284,   292,   304,   -148, 88,
                         dw -152,  1012,  1064,  -228,  164,   -376,  -684,  592,   -392,  156,  196,
                         dw -524,  -64,   -884,  160,   -176,  636,   648,   404,   -396,  -436, 864,
                         dw 424,   -728,  988,   -604,  904,   -592,  296,   -224,  536,   -176, -920,
                         dw 436,   -48,   1176,  -884,  416,   -776,  -824,  -884,  524,   -548, -564,
                         dw -68,   -164,  -96,   692,   364,   -692,  -1012, -68,   260,   -480, 876,
                         dw -1116, 452,   -332,  -352,  892,   -1088, 1220,  -676,  12,    -292, 244,
                         dw 496,   372,   -32,   280,   200,   112,   -440,  -96,   24,    -644, -184,
                         dw 56,    -432,  224,   -980,  272,   -260,  144,   -436,  420,   356,  364,
                         dw -528,  76,    172,   -744,  -368,  404,   -752,  -416,  684,   -688, 72,
                         dw 540,   416,   92,    444,   480,   -72,   -1416, 164,   -1172, -68,  24,
                         dw 424,   264,   1040,  128,   -912,  -524,  -356,  64,    876,   -12,  4,
                         dw -88,   532,   272,   -524,  320,   276,   -508,  940,   24,    -400, -120,
                         dw 756,   60,    236,   -412,  100,   376,   -484,  400,   -100,  -740, -108,
                         dw -260,  328,   -268,  224,   -200,  -416,  184,   -604,  -564,  -20,  296,
                         dw 60,    892,   -888,  60,    164,   68,    -760,  216,   -296,  904,  -336,
                         dw -28,   404,   -356,  -568,  -208,  -1480, -512,  296,   328,   -360, -164,
                         dw -1560, -776,  1156,  -428,  164,   -504,  -112,  120,   -216,  -148, -264,
                         dw 308,   32,    64,    -72,   72,    116,   176,   -64,   -272,  460,  -536,
                         dw -784,  -280,  348,   108,   -752,  -132,  524,   -540,  -776,  116,  -296,
                         dw -1196, -288,  -560,  1040,  -472,  116,   -848,  -1116, 116,   636,  696,
                         dw 284,   -176,  1016,  204,   -864,  -648,  -248,  356,   972,   -584, -204,
                         dw 264,   880,   528,   -24,   -184,  116,   448,   -144,  828,   524,  212,
                         dw -212,  52,    12,    200,   268,   -488,  -404,  -880,  824,   -672, -40,
                         dw 908,   -248,  500,   716,   -576,  492,   -576,  16,    720,   -108, 384,
                         dw 124,   344,   280,   576,   -500,  252,   104,   -308,  196,   -188, -8,
                         dw 1268,  296,   1032,  -1196, 436,   316,   372,   -432,  -200,  -660, 704,
                         dw -224,  596,   -132,  268,   32,    -452,  884,   104,   -1008, 424,  -1348,
                         dw -280,  4,     -1168, 368,   476,   696,   300,   -8,    24,    180,  -592,
                         dw -196,  388,   304,   500,   724,   -160,  244,   -84,   272,   -256, -420,
                         dw 320,   208,   -144,  -156,  156,   364,   452,   28,    540,   316,  220,
                         dw -644,  -248,  464,   72,    360,   32,    -388,  496,   -680,  -48,  208,
                         dw -116,  -408,  60,    -604,  -392,  548,   -840,  784,   -460,  656,  -544,
                         dw -388,  -264,  908,   -800,  -628,  -612,  -568,  572,   -220,  164,  288,
                         dw -16,   -308,  308,   -112,  -636,  -760,  280,   -668,  432,   364,  240,
                         dw -196,  604,   340,   384,   196,   592,   -44,   -500,  432,   -580, -132,
                         dw 636,   -76,   392,   4,     -412,  540,   508,   328,   -356,  -36,  16,
                         dw -220,  -64,   -248,  -60,   24,    -192,  368,   1040,  92,    -24,  -1044,
                         dw -32,   40,    104,   148,   192,   -136,  -520,  56,    -816,  -224, 732,
                         dw 392,   356,   212,   -80,   -424,  -1008, -324,  588,   -1496, 576,  460,
                         dw -816,  -848,  56,    -580,  -92,   -1372, -112,  -496,  200,   364,  52,
                         dw -140,  48,    -48,   -60,   84,    72,    40,    132,   -356,  -268, -104,
                         dw -284,  -404,  732,   -520,  164,   -304,  -540,  120,   328,   -76,  -460,
                         dw 756,   388,   588,   236,   -436,  -72,   -176,  -404,  -316,  -148, 716,
                         dw -604,  404,   -72,   -88,   -888,  -68,   944,   88,    -220,  -344, 960,
                         dw 472,   460,   -232,  704,   120,   832,   -228,  692,   -508,  132,  -476,
                         dw 844,   -748,  -364,  -44,   1116,  -1104, -1056, 76,    428,   552,  -692,
                         dw 60,    356,   96,    -384,  -188,  -612,  -576,  736,   508,   892,  352,
                         dw -1132, 504,   -24,   -352,  324,   332,   -600,  -312,  292,   508,  -144,
                         dw -8,    484,   48,    284,   -260,  -240,  256,   -100,  -292,  -204, -44,
                         dw 472,   -204,  908,   -188,  -1000, -256,  92,    1164,  -392,  564,  356,
                         dw 652,   -28,   -884,  256,   484,   -192,  760,   -176,  376,   -524, -452,
                         dw -436,  860,   -736,  212,   124,   504,   -476,  468,   76,    -472, 552,
                         dw -692,  -944,  -620,  740,   -240,  400,   132,   20,    192,   -196, 264,
                         dw -668,  -1012, -60,   296,   -316,  -828,  76,    -156,  284,   -768, -448,
                         dw -832,  148,   248,   652,   616,   1236,  288,   -328,  -400,  -124, 588,
                         dw 220,   520,   -696,  1032,  768,   -740,  -92,   -272,  296,   448,  -464,
                         dw 412,   -200,  392,   440,   -200,  264,   -152,  -260,  320,   1032, 216,
                         dw 320,   -8,    -64,   156,   -1016, 1084,  1172,  536,   484,   -432, 132,
                         dw 372,   -52,   -256,  84,    116,   -352,  48,    116,   304,   -384, 412,
                         dw 924,   -300,  528,   628,   180,   648,   44,    -980,  -220,  1320, 48,
                         dw 332,   748,   524,   -268,  -720,  540,   -276,  564,   -344,  -208, -196,
                         dw 436,   896,   88,    -392,  132,   80,    -964,  -288,  568,   56,   -48,
                         dw -456,  888,   8,     552,   -156,  -292,  948,   288,   128,   -716, -292,
                         dw 1192,  -152,  876,   352,   -600,  -260,  -812,  -468,  -28,   -120, -32,
                         dw -44,   1284,  496,   192,   464,   312,   -76,   -516,  -380,  -456, -1012,
                         dw -48,   308,   -156,  36,    492,   -156,  -808,  188,   1652,  68,   -120,
                         dw -116,  316,   160,   -140,  352,   808,   -416,  592,   316,   -480, 56,
                         dw 528,   -204,  -568,  372,   -232,  752,   -344,  744,   -4,    324,  -416,
                         dw -600,  768,   268,   -248,  -88,   -132,  -420,  -432,  80,    -288, 404,
                         dw -316,  -1216, -588,  520,   -108,  92,    -320,  368,   -480,  -216, -92,
                         dw 1688,  -300,  180,   1020,  -176,  820,   -68,   -228,  -260,  436,  -904,
                         dw 20,    40,    -508,  440,   -736,  312,   332,   204,   760,   -372, 728,
                         dw 96,    -20,   -632,  -520,  -560,  336,   1076,  -64,   -532,  776,  584,
                         dw 192,   396,   -728,  -520,  276,   -188,  80,    -52,   -612,  -252, -48,
                         dw 648,   212,   -688,  228,   -52,   -260,  428,   -412,  -272,  -404, 180,
                         dw 816,   -796,  48,    152,   484,   -88,   -216,  988,   696,   188,  -528,
                         dw 648,   -116,  -180,  316,   476,   12,    -564,  96,    476,   -252, -364,
                         dw -376,  -392,  556,   -256,  -576,  260,   -352,  120,   -16,   -136, -260,
                         dw -492,  72,    556,   660,   580,   616,   772,   436,   424,   -32,  -324,
                         dw -1268, 416,   -324,  -80,   920,   160,   228,   724,   32,    -516, 64,
                         dw 384,   68,    -128,  136,   240,   248,   -204,  -68,   252,   -932, -120,
                         dw -480,  -628,  -84,   192,   852,   -404,  -288,  -132,  204,   100,  168,
                         dw -68,   -196,  -868,  460,   1080,  380,   -80,   244,   0,     484,  -888,
                         dw 64,    184,   352,   600,   460,   164,   604,   -196,  320,   -64,  588,
                         dw -184,  228,   12,    372,   48,    -848,  -344,  224,   208,   -200, 484,
                         dw 128,   -20,   272,   -468,  -840,  384,   256,   -720,  -520,  -464, -580,
                         dw 112,   -120,  644,   -356,  -208,  -608,  -528,  704,   560,   -424, 392,
                         dw 828,   40,    84,    200,   -152,  0,     -144,  584,   280,   -120, 80,
                         dw -556,  -972,  -196,  -472,  724,   80,    168,   -32,   88,    160,  -688,
                         dw 0,     160,   356,   372,   -776,  740,   -128,  676,   -248,  -480, 4,
                         dw -364,  96,    544,   232,   -1032, 956,   236,   356,   20,    -40,  300,
                         dw 24,    -676,  -596,  132,   1120,  -104,  532,   -1096, 568,   648,  444,
                         dw 508,   380,   188,   -376,  -604,  1488,  424,   24,    756,   -220, -192,
                         dw 716,   120,   920,   688,   168,   44,    -460,  568,   284,   1144, 1160,
                         dw 600,   424,   888,   656,   -356,  -320,  220,   316,   -176,  -724, -188,
                         dw -816,  -628,  -348,  -228,  -380,  1012,  -452,  -660,  736,   928,  404,
                         dw -696,  -72,   -268,  -892,  128,   184,   -344,  -780,  360,   336,  400,
                         dw 344,   428,   548,   -112,  136,   -228,  -216,  -820,  -516,  340,  92,
                         dw -136,  116,   -300,  376,   -244,  100,   -316,  -520,  -284,  -12,  824,
                         dw 164,   -548,  -180,  -128,  116,   -924,  -828,  268,   -368,  -580, 620,
                         dw 192,   160,   0,     -1676, 1068,  424,   -56,   -360,  468,   -156, 720,
                         dw 288,   -528,  556,   -364,  548,   -148,  504,   316,   152,   -648, -620,
                         dw -684,  -24,   -376,  -384,  -108,  -920,  -1032, 768,   180,   -264, -508,
                         dw -1268, -260,  -60,   300,   -240,  988,   724,   -376,  -576,  -212, -736,
                         dw 556,   192,   1092,  -620,  -880,  376,   -56,   -4,    -216,  -32,  836,
                         dw 268,   396,   1332,  864,   -600,  100,   56,    -412,  -92,   356,  180,
                         dw 884,   -468,  -436,  292,   -388,  -804,  -704,  -840,  368,   -348, 140,
                         dw -724,  1536,  940,   372,   112,   -372,  436,   -480,  1136,  296,  -32,
                         dw -228,  132,   -48,   -220,  868,   -1016, -60,   -1044, -464,  328,  916,
                         dw 244,   12,    -736,  -296,  360,   468,   -376,  -108,  -92,   788,  368,
                         dw -56,   544,   400,   -672,  -420,  728,   16,    320,   44,    -284, -380,
                         dw -796,  488,   132,   204,   -596,  -372,  88,    -152,  -908,  -636, -572,
                         dw -624,  -116,  -692,  -200,  -56,   276,   -88,   484,   -324,  948,  864,
                         dw 1000,  -456,  -184,  -276,  292,   -296,  156,   676,   320,   160,  908,
                         dw -84,   -1236, -288,  -116,  260,   -372,  -644,  732,   -756,  -96,  84,
                         dw 344,   -520,  348,   -688,  240,   -84,   216,   -1044, -136,  -676, -396,
                         dw -1500, 960,   -40,   176,   168,   1516,  420,   -504,  -344,  -364, -360,
                         dw 1216,  -940,  -380,  -212,  252,   -660,  -708,  484,   -444,  -152, 928,
                         dw -120,  1112,  476,   -260,  560,   -148,  -344,  108,   -196,  228,  -288,
                         dw 504,   560,   -328,  -88,   288,   -1008, 460,   -228,  468,   -836, -196,
                         dw 76,    388,   232,   412,   -1168, -716,  -644,  756,   -172,  -356, -504,
                         dw 116,   432,   528,   48,    476,   -168,  -608,  448,   160,   -532, -272,
                         dw 28,    -676,  -12,   828,   980,   456,   520,   104,   -104,  256,  -344,
                         dw -4,    -28,   -368,  -52,   -524,  -572,  -556,  -200,  768,   1124, -208,
                         dw -512,  176,   232,   248,   -148,  -888,  604,   -600,  -304,  804,  -156,
                         dw -212,  488,   -192,  -804,  -256,  368,   -360,  -916,  -328,  228,  -240,
                         dw -448,  -472,  856,   -556,  -364,  572,   -12,   -156,  -368,  -340, 432,
                         dw 252,   -752,  -152,  288,   268,   -580,  -848,  -592,  108,   -76,  244,
                         dw 312,   -716,  592,   -80,   436,   360,   4,     -248,  160,   516,  584,
                         dw 732,   44,    -468,  -280,  -292,  -156,  -588,  28,    308,   912,  24,
                         dw 124,   156,   180,   -252,  944,   -924,  -772,  -520,  -428,  -624, 300,
                         dw -212,  -1144, 32,    -724,  800,   -1128, -212,  -1288, -848,  180,  -416,
                         dw 440,   192,   -576,  -792,  -76,   -1080, 80,    -532,  -352,  -132, 380,
                         dw -820,  148,   1112,  128,   164,   456,   700,   -924,  144,   -668, -384,
                         dw 648,   -832,  508,   552,   -52,   -100,  -656,  208,   -568,  748,  -88,
                         dw 680,   232,   300,   192,   -408,  -1012, -152,  -252,  -268,  272,  -876,
                         dw -664,  -648,  -332,  -136,  16,    12,    1152,  -28,   332,   -536, 320,
                         dw -672,  -460,  -316,  532,   -260,  228,   -40,   1052,  -816,  180,  88,
                         dw -496,  -556,  -672,  -368,  428,   92,    356,   404,   -408,  252,  196,
                         dw -176,  -556,  792,   268,   32,    372,   40,    96,    -332,  328,  120,
                         dw 372,   -900,  -40,   472,   -264,  -592,  952,   128,   656,   112,  664,
                         dw -232,  420,   4,     -344,  -464,  556,   244,   -416,  -32,   252,  0,
                         dw -412,  188,   -696,  508,   -476,  324,   -1096, 656,   -312,  560,  264,
                         dw -136,  304,   160,   -64,   -580,  248,   336,   -720,  560,   -348, -288,
                         dw -276,  -196,  -500,  852,   -544,  -236,  -1128, -992,  -776,  116,  56,
                         dw 52,    860,   884,   212,   -12,   168,   1020,  512,   -552,  924,  -148,
                         dw 716,   188,   164,   -340,  -520,  -184,  880,   -152,  -680,  -208, -1156,
                         dw -300,  -528,  -472,  364,   100,   -744,  -1056, -32,   540,   280,  144,
                         dw -676,  -32,   -232,  -280,  -224,  96,    568,   -76,   172,   148,  148,
                         dw 104,   32,    -296,  -32,   788,   -80,   32,    -16,   280,   288,  944,
                         dw 428,   -484

align 8, db 0
const resize_filter, db 0,  0,  0, -128,    0,  0,  0, 0, 0,  0,  1, -128,   -2,  1,  0, 0,
                     db 0, -1,  3, -127,   -4,  2, -1, 0, 0, -1,  4, -127,   -6,  3, -1, 0,
                     db 0, -2,  6, -126,   -8,  3, -1, 0, 0, -2,  7, -125,  -11,  4, -1, 0,
                     db 1, -2,  8, -125,  -13,  5, -2, 0, 1, -3,  9, -124,  -15,  6, -2, 0,
                     db 1, -3, 10, -123,  -18,  6, -2, 1, 1, -3, 11, -122,  -20,  7, -3, 1,
                     db 1, -4, 12, -121,  -22,  8, -3, 1, 1, -4, 13, -120,  -25,  9, -3, 1,
                     db 1, -4, 14, -118,  -28,  9, -3, 1, 1, -4, 15, -117,  -30, 10, -4, 1,
                     db 1, -5, 16, -116,  -32, 11, -4, 1, 1, -5, 16, -114,  -35, 12, -4, 1,
                     db 1, -5, 17, -112,  -38, 12, -4, 1, 1, -5, 18, -111,  -40, 13, -5, 1,
                     db 1, -5, 18, -109,  -43, 14, -5, 1, 1, -6, 19, -107,  -45, 14, -5, 1,
                     db 1, -6, 19, -105,  -48, 15, -5, 1, 1, -6, 19, -103,  -51, 16, -5, 1,
                     db 1, -6, 20, -101,  -53, 16, -6, 1, 1, -6, 20,  -99,  -56, 17, -6, 1,
                     db 1, -6, 20,  -97,  -58, 17, -6, 1, 1, -6, 20,  -95,  -61, 18, -6, 1,
                     db 2, -7, 20,  -93,  -64, 18, -6, 2, 2, -7, 20,  -91,  -66, 19, -6, 1,
                     db 2, -7, 20,  -88,  -69, 19, -6, 1, 2, -7, 20,  -86,  -71, 19, -6, 1,
                     db 2, -7, 20,  -84,  -74, 20, -7, 2, 2, -7, 20,  -81,  -76, 20, -7, 1,
                     db 2, -7, 20,  -79,  -79, 20, -7, 2, 1, -7, 20,  -76,  -81, 20, -7, 2,
                     db 2, -7, 20,  -74,  -84, 20, -7, 2, 1, -6, 19,  -71,  -86, 20, -7, 2,
                     db 1, -6, 19,  -69,  -88, 20, -7, 2, 1, -6, 19,  -66,  -91, 20, -7, 2,
                     db 2, -6, 18,  -64,  -93, 20, -7, 2, 1, -6, 18,  -61,  -95, 20, -6, 1,
                     db 1, -6, 17,  -58,  -97, 20, -6, 1, 1, -6, 17,  -56,  -99, 20, -6, 1,
                     db 1, -6, 16,  -53, -101, 20, -6, 1, 1, -5, 16,  -51, -103, 19, -6, 1,
                     db 1, -5, 15,  -48, -105, 19, -6, 1, 1, -5, 14,  -45, -107, 19, -6, 1,
                     db 1, -5, 14,  -43, -109, 18, -5, 1, 1, -5, 13,  -40, -111, 18, -5, 1,
                     db 1, -4, 12,  -38, -112, 17, -5, 1, 1, -4, 12,  -35, -114, 16, -5, 1,
                     db 1, -4, 11,  -32, -116, 16, -5, 1, 1, -4, 10,  -30, -117, 15, -4, 1,
                     db 1, -3,  9,  -28, -118, 14, -4, 1, 1, -3,  9,  -25, -120, 13, -4, 1,
                     db 1, -3,  8,  -22, -121, 12, -4, 1, 1, -3,  7,  -20, -122, 11, -3, 1,
                     db 1, -2,  6,  -18, -123, 10, -3, 1, 0, -2,  6,  -15, -124,  9, -3, 1,
                     db 0, -2,  5,  -13, -125,  8, -2, 1, 0, -1,  4,  -11, -125,  7, -2, 0,
                     db 0, -1,  3,   -8, -126,  6, -2, 0, 0, -1,  3,   -6, -127,  4, -1, 0,
                     db 0, -1,  2,   -4, -127,  3, -1, 0, 0,  0,  1,   -2, -128,  1,  0, 0,

align 16, db 0    ; Unused
const obmc_masks, db  0,  0,
                  ; 2
                  db 19,  0,
                  ; 4
                  db 25, 14,  5,  0,
                  ; 8
                  db 28, 22, 16, 11,  7,  3,  0,  0,
                  ; 16
                  db 30, 27, 24, 21, 18, 15, 12, 10,  8,  6,  4,  3,  0,  0,  0,  0,
                  ; 32
                  db 31, 29, 28, 26, 24, 23, 21, 20, 19, 17, 16, 14, 13, 12, 11,  9,
                  db  8,  7,  6,  5,  4,  4,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,
