#![recursion_limit="256"]
#[macro_use]
extern crate clap;
#[macro_use]
extern crate log;
extern crate env_logger;
extern crate libpijul;
extern crate getch;
extern crate toml;
extern crate regex;
extern crate reqwest;
extern crate chrono;
extern crate thrussh;
extern crate thrussh_keys;
extern crate term;
extern crate rand;
extern crate tokio_core;
extern crate tokio_io;
extern crate futures;
extern crate username;
extern crate shell_escape;
extern crate cryptovec;
extern crate ignore;

#[cfg(unix)]
extern crate tokio_uds;

extern crate tar;
extern crate flate2;
#[macro_use]
extern crate serde_derive;
extern crate bs58;
extern crate hex;
#[macro_use]
extern crate error_chain;
extern crate bincode;
extern crate tempdir;
extern crate progrs;

#[cfg(unix)]
extern crate pager;
extern crate isatty;

extern crate base64;
extern crate line;
extern crate rpassword;

mod error;
mod commands;
mod meta;
mod relativize;
mod cli;

macro_rules! pijul_subcommand_dispatch {
    ($default:expr, $p:expr => $($subcommand_name:expr => $subcommand:ident),*) => {{
        match $p {
            $(($subcommand_name, Some(args)) =>
             {
                 let res = commands::$subcommand::run(&args);
                 commands::$subcommand::explain(res)
             }
              ),*
                ("", None) => { $default; println!(""); },
            _ => panic!("Incorrect subcommand name")
        }
    }}
}

fn main() {
    env_logger::init();
    let time0 = chrono::Local::now();
    let app = cli::build_cli();
    let mut app_help = app.clone();

    let args = app.get_matches();
    pijul_subcommand_dispatch!(app_help.print_help().unwrap(), args.subcommand() =>
                               "info" => info,
                               "generate-completions" => generate_completions,
                               "log" => log,
                               "patch" => patch,
                               "init" => init,
                               "add" => add,
                               "record" => record,
                               "pull" => pull,
                               "push" => push,
                               "apply" => apply,
                               "clone" => clone,
                               "remove" => remove,
                               "mv" => mv,
                               "ls" => ls,
                               "revert" => revert,
                               "unrecord" => unrecord,
                               "fork" => fork,
                               "branches" => branches,
                               "delete-branch" => delete_branch,
                               "checkout" => checkout,
                               "diff" => diff,
                               "credit" => credit,
                               "dist" => dist,
                               "key" => key,
                               "rollback" => rollback,
                               "status" => status,
                               "show-dependencies" => show_dependencies,
                               "tag" => tag,
                               "sign" => sign,
                               "challenge" => challenge
                               );
    let time1 = chrono::Local::now();
    info!("The command took: {:?}", time1.signed_duration_since(time0));
}
