use clap::{SubCommand, ArgMatches, AppSettings};
use commands::{StaticSubcommand, default_explain};
use error::Error;
use std::io::stdin;
use rand;
use rand::Rng;
use std::io::Read;

pub fn invocation() -> StaticSubcommand {
    return SubCommand::with_name("challenge")
        .setting(AppSettings::Hidden)
        .about("Prove ownership of a signature key")
}

pub fn run(_: &ArgMatches) -> Result<(), Error> {
    let challenge: String = rand::thread_rng()
        .gen_ascii_chars()
        .take(80)
        .collect::<String>();
    println!("{}", challenge);
    let mut v = Vec::new();
    stdin().read_to_end(&mut v)?;
    Ok(())
}

pub fn explain(res: Result<(), Error>) {
    default_explain(res)
}
