# histogram

Creates a new table with a histogram based on the column name passed in.

Syntax: `histogram <column_name>  ...args`

## Parameters

* `<column-name>`: name of the column to graph by
* `args`: column name to give the histogram's frequency column

## Examples

Let's say we have this file `random_numers.csv` which contains 50 random numbers.

**Note**: The input doesn't have to be numbers it works on strings too. Try it out.

```shell
> open random_numbers.csv
────┬────────────────
 #  │ random numbers
────┼────────────────
  0 │              5
  1 │              2
  2 │              0
...
 47 │              1
 48 │              1
 49 │              2
────┴────────────────
```

If we now want to see how often the different numbers were generated, we can use the `histogram` function:

```shell
> open random_numbers.csv | histogram "random numbers"
───┬────────────────┬─────────────┬────────────┬──────────────────────────────────────────────────────────────────────────────────────────────────────
 # │ random numbers │    count    │ percentage │ frequency
───┼────────────────┼─────────────┼────────────┼──────────────────────────────────────────────────────────────────────────────────────────────────────
 0 │ 0              │           8 │ 57.14%     │ *********************************************************
 1 │ 1              │          14 │ 100.00%    │ ****************************************************************************************************
 2 │ 2              │           9 │ 64.29%     │ ****************************************************************
 3 │ 3              │           6 │ 42.86%     │ ******************************************
 4 │ 4              │           3 │ 21.43%     │ *********************
 5 │ 5              │          10 │ 71.43%     │ ***********************************************************************
───┴────────────────┴─────────────┴────────────┴──────────────────────────────────────────────────────────────────────────────────────────────────────
```

We can also set the name of the second column or sort the table:

```shell
> open random_numbers.csv | histogram "random numbers" probability
───┬────────────────┬─────────────┬────────────┬──────────────────────────────────────────────────────────────────────────────────────────────────────
 # │ random numbers │    count    │ percentage │ probability
───┼────────────────┼─────────────┼────────────┼──────────────────────────────────────────────────────────────────────────────────────────────────────
 0 │ 0              │           8 │ 57.14%     │ *********************************************************
 1 │ 1              │          14 │ 100.00%    │ ****************************************************************************************************
 2 │ 2              │           9 │ 64.29%     │ ****************************************************************
 3 │ 3              │           6 │ 42.86%     │ ******************************************
 4 │ 4              │           3 │ 21.43%     │ *********************
 5 │ 5              │          10 │ 71.43%     │ ***********************************************************************
───┴────────────────┴─────────────┴────────────┴──────────────────────────────────────────────────────────────────────────────────────────────────────

```

```shell
> open random_numbers.csv | histogram "random numbers" probability | sort-by probability
───┬────────────────┬─────────────┬────────────┬──────────────────────────────────────────────────────────────────────────────────────────────────────
 # │ random numbers │    count    │ percentage │ probability
───┼────────────────┼─────────────┼────────────┼──────────────────────────────────────────────────────────────────────────────────────────────────────
 0 │ 4              │           3 │ 21.43%     │ *********************
 1 │ 3              │           6 │ 42.86%     │ ******************************************
 2 │ 0              │           8 │ 57.14%     │ *********************************************************
 3 │ 2              │           9 │ 64.29%     │ ****************************************************************
 4 │ 5              │          10 │ 71.43%     │ ***********************************************************************
 5 │ 1              │          14 │ 100.00%    │ ****************************************************************************************************
───┴────────────────┴─────────────┴────────────┴──────────────────────────────────────────────────────────────────────────────────────────────────────

```

Of course, histogram operations are not restricted to just analyzing numbers in files, you can also analyze your directories

```shell
> ls -la | histogram type | sort-by count
───┬─────────┬─────────────┬────────────┬──────────────────────────────────────────────────────────────────────────────────────────────────────
 # │ type    │    count    │ percentage │ frequency
───┼─────────┼─────────────┼────────────┼──────────────────────────────────────────────────────────────────────────────────────────────────────
 0 │ Dir     │           5 │ 4.76%      │ ****
 1 │ Symlink │          28 │ 26.67%     │ **************************
 2 │ File    │         105 │ 100.00%    │ ****************************************************************************************************
───┴─────────┴─────────────┴────────────┴──────────────────────────────────────────────────────────────────────────────────────────────────────
```
