#include "feedhqapi.h"

#include "fileurlreader.h"
#include "logger.h"

namespace newsboat {

FeedHqUrlReader::FeedHqUrlReader(ConfigContainer* c,
	const std::string& url_file,
	RemoteApi* a)
	: cfg(c)
	, file(url_file)
	, api(a)
{
}

FeedHqUrlReader::~FeedHqUrlReader() {}

void FeedHqUrlReader::write_config()
{
	// NOTHING
}

#define BROADCAST_FRIENDS_URL                                    \
	"http://feedhq.org/reader/atom/user/-/state/com.google/" \
	"broadcast-friends"
#define STARRED_ITEMS_URL \
	"http://feedhq.org/reader/atom/user/-/state/com.google/starred"
#define SHARED_ITEMS_URL \
	"http://feedhq.org/reader/atom/user/-/state/com.google/broadcast"

#define ADD_URL(url, caption)                 \
	do {                                  \
		tmptags.clear();              \
		urls.push_back((url));        \
		tmptags.push_back((caption)); \
		tags[(url)] = tmptags;        \
	} while (0)

void FeedHqUrlReader::reload()
{
	urls.clear();
	tags.clear();
	alltags.clear();

	if (cfg->get_configvalue_as_bool("feedhq-show-special-feeds")) {
		std::vector<std::string> tmptags;
		ADD_URL(BROADCAST_FRIENDS_URL,
			std::string("~") + _("People you follow"));
		ADD_URL(STARRED_ITEMS_URL,
			std::string("~") + _("Starred items"));
		ADD_URL(SHARED_ITEMS_URL, std::string("~") + _("Shared items"));
	}

	FileUrlReader ur(file);
	ur.reload();

	for (const auto& url : ur.get_urls()) {
		if (utils::is_query_url(url)) {
			urls.push_back(url);

			auto url_tags = ur.get_tags(url);
			tags[url] = url_tags;
			for (const auto& tag : url_tags) {
				alltags.insert(tag);
			}
		}
	}

	std::vector<TaggedFeedUrl> feedurls = api->get_subscribed_urls();
	for (const auto& tagged : feedurls) {
		std::string url = tagged.first;
		std::vector<std::string> url_tags = tagged.second;

		LOG(Level::DEBUG, "added %s to URL list", url);
		urls.push_back(url);
		tags[tagged.first] = url_tags;
		for (const auto& tag : url_tags) {
			LOG(Level::DEBUG, "%s: added tag %s", url, tag);
			alltags.insert(tag);
		}
	}
}

std::string FeedHqUrlReader::get_source()
{
	return "FeedHQ";
}

} // namespace newsboat
