#!/bin/bash
set -Eeuo pipefail

# Add ad-hoc tests that can't be easily added in tests_ok/ nor tests_failed/

function assert_equals() {
  if [ "$1" != "$2" ]; then
      echo "Error differs:"
      echo "actual: $1"
      echo "expected: $2"
      exit 1
  fi
}

echo "Check file not found error"
actual=$(hurl does_not_exist.hurl 2>&1 || true)
expected="error: hurl: cannot access 'does_not_exist.hurl': No such file or directory"
assert_equals "$actual" "$expected"

echo "Check multiple Hurl files"
actual=$(hurl tests_ok/hello.hurl tests_ok/hello.hurl)
expected="Hello World!Hello World!"
assert_equals "$actual" "$expected"

echo "Check stdin"
actual=$(echo 'GET http://localhost:8000/hello' | hurl)
expected="Hello World!"
assert_equals "$actual" "$expected"

echo "Check hurlfmt --color"
actual=$(echo 'GET http://localhost:8000/hello' | hurlfmt --color)
expected="[33mGET[0m [32mhttp://localhost:8000/hello[0m"
assert_equals "$actual" "$expected"

