// amends "package://github.com/jdx/hk/releases/download/v0.7.5/hk@0.7.5#/Config.pkl"
amends "pkl/Config.pkl"
import "pkl/builtins.pkl"

// defines what happens during git pre-commit hook
local linters = new Mapping<String, Step> {
    ["actionlint"] = builtins.actionlint
    // TODO: fails on releases with hk-example.pkl
    //["pkl"] {
        //glob = new { "*.pkl" }
        //check = "pkl eval {{files}} >/dev/null"
    //}
    // predefined formatters+linters
     ["cargo-clippy"] = (builtins.cargo_clippy) {
         profiles = List("slow")
         check = "cargo clippy --manifest-path {{workspace_indicator}} -- -D warnings"
     }
     ["cargo-fmt"] = builtins.cargo_fmt
     ["dbg"] = new LinterStep {
         // ensure no dbg! macros are used
         glob = List("**/*.rs")
         check = "sleep 1.5; ! rg -e 'dbg!' {{files}}"
     }
     ["eslint"] = (builtins.eslint) {
         dir = "docs"
         prefix = "bun run"
     }
     ["prettier"] = (builtins.prettier) {
         glob = List("*.js", "*.ts", "*.yml", "*.yaml") // override the default globs
     }
}

hooks = new {
    ["pre-commit"] {
        fix = true
        steps = new {
            ["stash"] = new StashStep {}
            ["prelint"] {
                run = "mise run prelint && sleep 1"
                exclusive = true
            }
            ...linters
            ["postlint"] {
                run = "echo postlint && sleep 1"
                exclusive = true
            }
        }
    }
    ["pre-push"] {
        steps = linters
    }
    ["check"] {
        steps = linters
    }
    ["fix"] {
        fix = true
        steps = linters
    }
    //["prepare-commit-msg"] {
    //    ["render-commit-msg"] {
    //        run = "echo 'default commit message' > {{commit_msg_file}}"
    //    }
    //}

    // TODO
    // ["commit-msg"] {}
}
