---
slug: 2.0.0
title: "What's new in 2.0.0? \U0001F195"
date: 2024-02-19T00:00:00.000Z
authors: orhun
tags:
  - release
---

<center>

  <a href="https://github.com/orhun/git-cliff">
    <img src="/img/git-cliff-anim.gif" />
  </a>

</center>

> [**git-cliff**](https://github.com/orhun/git-cliff) is a command-line tool (written in [Rust](https://www.rust-lang.org/)) that provides a highly customizable way to generate changelogs from git history.
>
> It supports using [custom regular expressions](/docs/configuration/git#commit_parsers) to alter changelogs which are mostly based on [conventional commits](/docs/configuration/git#conventional_commits). With a single [configuration file](/docs/configuration), a wide variety of formats can be applied for a changelog, thanks to the Jinja2/Django-inspired [template engine](/docs/category/templating).
>
> More information and examples can be found in the [GitHub repository](https://github.com/orhun/git-cliff).

## What's new? ⛰️

The full changelog can be found [here](https://github.com/orhun/git-cliff/blob/main/CHANGELOG.md).

### 🚀 GitHub Integration

This highly requested feature is now experimentally available with the `2.0.0` version of `git-cliff`!

For repositories hosted on GitHub, you can now use the following variables in your changelog:

- GitHub usernames (`${{ commit.github.username }}` or `${{ contributor.username }}`)
- Contributors list (`${{ github.contributors }}`)
- Pull requests (`${{ commit.github.pr_number }}` or `${{ contributor.pr_number }}`)

To quickly set things up for your project, you can use the built-in GitHub template:

```sh
# creates cliff.toml
$ git cliff --init github
```

And simply run `git cliff` to generate a changelog like the following:

```md
## What's Changed

- feat(commit): add merge_commit flag to the context by @orhun in #389
- test(fixture): add test fixture for bumping version by @orhun in #360

## New Contributors

- @someone made their first contribution in #360
- @cliffjumper made their first contribution in #389

<!-- generated by git-cliff -->
```

:::tip

For detailed documentation and usage examples, check out the [GitHub integration](/docs/integration/github)!

:::

:::warning

This is an experimental feature so please [report bugs](https://github.com/orhun/git-cliff/issues/new/choose) to help us improve!

:::

---

### 🦀 RustLab 2023

I gave a talk about `git-cliff` at [RustLab 2023](https://rustlab.it/talks/turning-git-commits-into-changelog-with-git-cliff) - you can watch the recording here:

<iframe width="100%" height="315" src="https://www.youtube.com/embed/RWh8qbiLRts?si=BDBCBtu2nVPGSAAJ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

---

### 📋 Built-in Templates

As briefly mentioned, the example templates are now embedded into the binary which means you can quickly initialize `git-cliff` or generate a changelog using one of them.

```sh
# creates cliff.toml with keepachangelog template
$ git cliff --init keepachangelog
```

```sh
# generates a changelog in keepachangelog format
$ git cliff --config keepachangelog
```

Here is the full list of supported templates as of now:

- [`keepachangelog.toml`](https://github.com/orhun/git-cliff/tree/main/examples/keepachangelog.toml): changelog in [Keep a Changelog format](https://keepachangelog.com/en/1.1.0/).
- [`github.toml`](https://github.com/orhun/git-cliff/tree/main/examples/github.toml): changelog in the [GitHub's format](https://docs.github.com/en/repositories/releasing-projects-on-github/automatically-generated-release-notes).
- [`github-keepachangelog.toml`](https://github.com/orhun/git-cliff/tree/main/examples/github-keepachangelog.toml): combination of the previous two formats.
- [`detailed.toml`](https://github.com/orhun/git-cliff/tree/main/examples/detailed.toml): changelog that contains links to the commits.
- [`minimal.toml`](https://github.com/orhun/git-cliff/tree/main/examples/minimal.toml): minimal changelog.
- [`scoped.toml`](https://github.com/orhun/git-cliff/tree/main/examples/scoped.toml): changelog with commits are grouped by their scopes.
- [`scopesorted.toml`](https://github.com/orhun/git-cliff/tree/main/examples/scopesorted.toml): changelog with commits grouped by their scopes and sorted by group.
- [`cocogitto.toml`](https://github.com/orhun/git-cliff/tree/main/examples/cocogitto.toml): changelog similar to [cocogitto's format](https://github.com/cocogitto/cocogitto/blob/main/CHANGELOG.md).
- [`unconventional.toml`](https://github.com/orhun/git-cliff/tree/main/examples/unconventional.toml): changelog for unconventional commits.

---

### 📄 Footer Template

Now you can use a template in `[changelog.footer]` as well!

Before:

```toml
# changelog footer
footer = """
<!-- generated by git-cliff -->
"""
```

After:

```toml
# template for the changelog footer
footer = """
<!-- generated by git-cliff at {{ now() | date(format="%Y-%m-%d") }} -->
"""
```

For example, [`keepachangelog.toml`](https://github.com/orhun/git-cliff/tree/main/examples/keepachangelog.toml) uses this for adding links to the end of the changelog.

```toml
# template for the changelog footer
footer = """
{% for release in releases -%}
    {% if release.version -%}
        {% if release.previous.version -%}
            [{{ release.version | trim_start_matches(pat="v") }}]: \
                https://github.com/{{ remote.github.owner }}/{{ remote.github.repo }}\
                    /compare/{{ release.previous.version }}..{{ release.version }}
        {% endif -%}
    {% else -%}
        [unreleased]: https://github.com/{{ remote.github.owner }}/{{ remote.github.repo }}\
            /compare/{{ release.previous.version }}..HEAD
    {% endif -%}
{% endfor %}
<!-- generated by git-cliff -->
"""
```

Results in:

```md
[unreleased]: https://github.com/orhun/git-cliff/compare/v1.4.0..HEAD
[1.4.0]: https://github.com/orhun/git-cliff/compare/v1.3.1..v1.4.0
[1.3.1]: https://github.com/orhun/git-cliff/compare/v1.3.1-rc.0..v1.3.1
[1.3.1-rc.0]: https://github.com/orhun/git-cliff/compare/v1.3.0..v1.3.1-rc.0
```

---

### 🧶 Improve Skipping

Do you want to skip erroneous commits in the changelog? We now support two comfortable ways of doing that.

#### 1. `.cliffignore`

You can now add a `.cliffignore` file at the root of your repository for listing the commits that will be skipped:

```bash
# skip commits by their SHA1

4f88dda8c746173ea59f920b7579b7f6c74bd6c8
10c3194381f2cc4f93eb97404369568882ed8677
```

#### 2. `--skip-commit`

You can skip commits by using this argument as follows:

```sh
$ git cliff --skip-commit 10c3194381f2cc4f93eb97404369568882ed8677 \
            --skip-commit 4f88dda8c746173ea59f920b7579b7f6c74bd6c8
```

---

### 🖨️ Print Bumped Version

If you want to use the `--bump` option but are only interested in the bumped version instead of the entire changelog, you can simply use the newly added `--bumped-version` flag!

```sh
# print the next semantic version
$ git cliff --bumped-version

v2.0.0
```

---

### 🚫 Disable Command Execution

If you are using external commands (e.g. via `replace_command`) in your configuration, you can now entirely skip executing those commands with `--no-exec` flag.

```sh
$ git cliff --no-exec
```

For example, this is useful in the cases where the execution takes time.

---

### 🔄 Filter Merge Commits

The [template context](/docs/templating/context) has a new field called `merge_commit` (bool) which can be used to filter out merge commits.

For example, you can use `filter(attribute="merge_commit", value=false)` as follows:

```jinja2
{% for group, commits in commits |
  filter(attribute="merge_commit", value=false) |
  group_by(attribute="group") %}
    ### {{ group | upper_first }}
    {% for commit in commits %}
        - {{ commit.message | upper_first }}\
    {% endfor %}
{% endfor %}\n
```

---

### 🔍 Match by commit SHA

It is now possible to use the SHA1 of a commit with [`commit_parsers`](/docs/configuration/git#commit_parsers).

For example, to skip a specific commit:

```toml
commit_parsers = [
    { sha = "f6f2472bdf0bbb5f9fcaf2d72c1fa9f98f772bb2", skip = true }
]
```

To override the group of a specific commit:

```toml
commit_parsers = [
    { sha = "f6f2472bdf0bbb5f9fcaf2d72c1fa9f98f772bb2", group = "Stuff" }
]
```

---

### 🔠 Regex Scope Values

It is now possible to use regex-replace for the `scope` value in [`commit_parsers`](/docs/configuration/git#commit_parsers):

```toml
[git]
# regex for parsing and grouping commits
commit_parsers = [
  { message = "^\\[(.*)\\]", group = "Changes to ${1}", scope = "${1}" },
]
```

In this example, `[codebase]: rewrite everything in Rust` will appear in the changelog as:

```md
### Changes to codebase

- (codebase) Rewrite everything in Rust
```

---

### 📈 Bump Improvements

There was some love towards `--bump` flag to improve its behavior:

- Tag prefixes are now supported!
  - This means that for example if you have `testing/v1.0.0-beta.1` as the current version and if you run `git cliff --bump`, you will see `testing/v1.0.0-beta.2` in your changelog.
- If no tags exist, `--bump` will yield `0.1.0` as default.
- Other behavioral fixes!

---

### 📚 Documentation Improvements

- Added [Tips And Tricks](/docs/tips-and-tricks)!

- Added installation instructions for Homebrew

```bash
brew install git-cliff
```

- Added [instructions](https://github.com/orhun/git-cliff/tree/main/.github/fixtures#fixtures) for adding new test fixtures

---

### 🌐 Website Improvements

- Made dark theme default (sorry moths)
- Added a search bar

---

### 🧰 Other

There were a lot of bug fixes and improvements in this release but mainly:

- _(changelog)_ Fix previous version links ([#364](https://github.com/orhun/git-cliff/issues/364))
- _(cli)_ Fix broken pipe when stdout is interrupted ([#407](https://github.com/orhun/git-cliff/issues/407))
- _(commit)_ Trim the trailing newline from message ([#403](https://github.com/orhun/git-cliff/issues/403))
- _(git)_ Sort commits in topological order ([#415](https://github.com/orhun/git-cliff/issues/415))
- _(args)_ Set `CHANGELOG.md` as default missing value for output option ([#354](https://github.com/orhun/git-cliff/issues/354))
- _(changelog)_ Disable the default behavior of next-version ([#343](https://github.com/orhun/git-cliff/issues/343))

---

## Contributions 👥

Any contribution is highly appreciated! See the [contribution guidelines](https://github.com/orhun/git-cliff/blob/main/CONTRIBUTING.md) for getting started.

Feel free to [submit issues](https://github.com/orhun/git-cliff/issues/new/choose) and join our [Discord](https://discord.gg/W3mAwMDWH4) / [Matrix](https://matrix.to/#/#git-cliff:matrix.org) for discussion!

Follow `git-cliff` on [Twitter](https://twitter.com/git_cliff) & [Mastodon](https://fosstodon.org/@git_cliff) to not miss any news!

## Support 🌟

If you liked `git-cliff` and/or my other projects [on GitHub](https://github.com/orhun), consider [donating](https://donate.orhun.dev) to support my open source endeavors.

- 💖 GitHub Sponsors: [@orhun](https://github.com/sponsors/orhun)
- ☕ Buy Me A Coffee: [https://www.buymeacoffee.com/orhun](https://www.buymeacoffee.com/orhun)

Have a fantastic day! ⛰️
