# Contributing

**Repository:**
- [GitLab repository][gitlab]
- _Mirror: [GitHub repository][github]_

**Issues:** (bug reporting, feature requests, enhancements, etc.)
- [GitLab issue board][gitlab-issues]
- _Alternatively: [GitHub issue board][github-issues]_

**Pull/merge requests:** (fixes, implemented features, etc.)
- [GitLab merge requests][gitlab-mr]
- _Alternatively: [GitHub pull requests][github-pr]_



Contributions to the `ffsend` project are welcome!
When contributing new features, alternative implementations or bigger
improvements, please first discuss the change you wish to make via an issue
or email.
Small changes such as fixed commands, fixed spelling or dependency updates
are always welcome without discussion.

The `ffsend` repository is primarily hosted on [GitLab][gitlab].
[GitHub][github] hosts a mirror, for publicity and findability.
Please open any issues or pull requests on the [GitLab][gitlab] pages if possible.
Otherwise opening these on [GitHub][github] is fine, though they might be
manually moved over to [GitLab][gitlab].

Please note we have a code of conduct, please follow it in all your interactions
with the project.

## Pull Request Process

1. Ensure you've discussed your improvements in an issue when working on a
   bigger change
2. Ensure your branch is up-to-date with the latest [`master`][branch-master]
3. Ensure the project builds with your changes: `cargo build`
4. Ensure the project tests succeed with your changes: `cargo test`
5. Update the `README.md` with details of significant changes, this includes new
   compiler features, command-line arguments, environment variables or new
   package installation instructions.
6. Submit your pull request.
7. Fix any issues continuous integration might report.

Additional notes:
- Do not change version numbers, this is done by @timvisee

## Code of Conduct

### Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

### Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

### Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

### Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project owner at 3a4fb3964f@sinenomine.email. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

### Attribution
This Code of Conduct is adapted from the [Contributor Covenant][coc-homepage], version 1.4,
available at [https://contributor-covenant.org/version/1/4][coc-version]

## License
This project is released under the GNU GPL-3.0 license.
Check out the [LICENSE](LICENSE) file for more information.

[branch-master]: https://gitlab.com/timvisee/ffsend/tree/master
[gitlab]: https://gitlab.com/timvisee/ffsend
[gitlab-issues]: https://gitlab.com/timvisee/ffsend/issues
[gitlab-mr]: https://gitlab.com/timvisee/ffsend/merge_requests
[github]: https://github.com/timvisee/ffsend
[github-issues]: https://github.com/timvisee/ffsend/issues
[github-pr]: https://github.com/timvisee/ffsend/pulls
[coc-homepage]: https://contributor-covenant.org
[coc-version]: https://contributor-covenant.org/version/1/4/
