#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1264
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 242
#define ALIAS_COUNT 1
#define TOKEN_COUNT 88
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 31
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 66

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_import = 9,
  anon_sym_DOT = 10,
  anon_sym_as = 11,
  anon_sym_SLASH = 12,
  anon_sym_COMMA = 13,
  anon_sym_const = 14,
  anon_sym_EQ = 15,
  anon_sym_POUND = 16,
  anon_sym_LPAREN = 17,
  anon_sym_RPAREN = 18,
  anon_sym_LBRACK = 19,
  anon_sym_RBRACK = 20,
  anon_sym_LT_LT = 21,
  anon_sym_GT_GT = 22,
  anon_sym_COLON = 23,
  anon_sym_DASH = 24,
  anon_sym_size = 25,
  anon_sym_external = 26,
  anon_sym_type = 27,
  anon_sym_fn = 28,
  anon_sym_DASH_GT = 29,
  anon_sym_try = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_LT_DOT = 37,
  anon_sym_LT_EQ_DOT = 38,
  anon_sym_GT = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT_DOT = 41,
  anon_sym_GT_EQ_DOT = 42,
  anon_sym_PIPE_GT = 43,
  anon_sym_PLUS = 44,
  anon_sym_PLUS_DOT = 45,
  anon_sym_DASH_DOT = 46,
  anon_sym_STAR = 47,
  anon_sym_STAR_DOT = 48,
  anon_sym_SLASH_DOT = 49,
  anon_sym_PERCENT = 50,
  anon_sym_todo = 51,
  anon_sym_DOT_DOT = 52,
  anon_sym_case = 53,
  anon_sym_PIPE = 54,
  anon_sym_let = 55,
  anon_sym_assert = 56,
  sym_visibility_modifier = 57,
  sym_opacity_modifier = 58,
  anon_sym_DQUOTE = 59,
  sym_escape_sequence = 60,
  sym_quoted_content = 61,
  sym_float = 62,
  sym__hex = 63,
  sym__decimal = 64,
  sym__octal = 65,
  sym__binary = 66,
  anon_sym_binary = 67,
  anon_sym_bytes = 68,
  anon_sym_int = 69,
  anon_sym_float = 70,
  anon_sym_bit_string = 71,
  anon_sym_bits = 72,
  anon_sym_utf8 = 73,
  anon_sym_utf16 = 74,
  anon_sym_utf32 = 75,
  anon_sym_utf8_codepoint = 76,
  anon_sym_utf16_codepoint = 77,
  anon_sym_utf32_codepoint = 78,
  anon_sym_signed = 79,
  anon_sym_unsigned = 80,
  anon_sym_big = 81,
  anon_sym_little = 82,
  anon_sym_native = 83,
  anon_sym_unit = 84,
  sym__discard_name = 85,
  sym__name = 86,
  sym__upname = 87,
  sym_source_file = 88,
  sym__statement = 89,
  sym_target_group = 90,
  sym_target = 91,
  sym_import = 92,
  sym_module = 93,
  sym_unqualified_imports = 94,
  sym_unqualified_import = 95,
  sym_constant = 96,
  sym__constant_value = 97,
  sym_constant_tuple = 98,
  sym_constant_list = 99,
  sym__constant_bit_string = 100,
  sym_constant_bit_string_segment = 101,
  sym_constant_bit_string_segment_options = 102,
  sym__constant_bit_string_segment_option = 103,
  sym__constant_bit_string_named_segment_option = 104,
  sym__constant_bit_string_segment_option_size = 105,
  sym_constant_record = 106,
  sym_constant_record_arguments = 107,
  sym_constant_record_argument = 108,
  sym__constant_type = 109,
  sym__constant_type_annotation = 110,
  sym_constant_tuple_type = 111,
  sym_constant_type = 112,
  sym_constant_type_arguments = 113,
  sym_constant_type_argument = 114,
  sym_external_type = 115,
  sym_external_function = 116,
  sym_external_function_parameters = 117,
  sym_external_function_parameter = 118,
  sym_external_function_body = 119,
  sym_function = 120,
  sym_function_parameters = 121,
  sym_function_parameter = 122,
  sym__labeled_discard_param = 123,
  sym__discard_param = 124,
  sym__labeled_name_param = 125,
  sym__name_param = 126,
  aux_sym__expression_seq = 127,
  sym_try = 128,
  sym__expression = 129,
  sym_binary_expression = 130,
  sym__expression_unit = 131,
  sym_record = 132,
  sym_todo = 133,
  sym_tuple = 134,
  sym_list = 135,
  sym__expression_bit_string = 136,
  sym_expression_bit_string_segment = 137,
  sym_expression_bit_string_segment_options = 138,
  sym__expression_bit_string_segment_option = 139,
  sym__expression_bit_string_named_segment_option = 140,
  sym__expression_bit_string_segment_option_size = 141,
  sym_anonymous_function = 142,
  sym_expression_group = 143,
  sym_case = 144,
  sym_case_subjects = 145,
  sym_case_clauses = 146,
  sym_case_clause = 147,
  sym_case_clause_patterns = 148,
  sym_case_clause_pattern = 149,
  sym_case_clause_guard = 150,
  sym__case_clause_guard_expression = 151,
  sym__case_clause_guard_binary_expression = 152,
  sym__case_clause_guard_unit = 153,
  sym__case_clause_tuple_access = 154,
  sym_let = 155,
  sym_assert = 156,
  sym__assignment = 157,
  sym_record_update = 158,
  sym_record_update_arguments = 159,
  sym_record_update_argument = 160,
  sym__maybe_tuple_expression = 161,
  sym_tuple_access = 162,
  sym__maybe_record_expression = 163,
  sym_field_access = 164,
  sym__maybe_function_expression = 165,
  sym_arguments = 166,
  sym_argument = 167,
  sym_hole = 168,
  sym_function_call = 169,
  sym__pattern = 170,
  sym_record_pattern = 171,
  sym_record_pattern_arguments = 172,
  sym_record_pattern_argument = 173,
  sym_pattern_spread = 174,
  sym_tuple_pattern = 175,
  sym__pattern_bit_string = 176,
  sym_pattern_bit_string_segment = 177,
  sym_pattern_bit_string_segment_options = 178,
  sym__pattern_bit_string_segment_option = 179,
  sym__pattern_bit_string_named_segment_option = 180,
  sym__pattern_bit_string_segment_option_size = 181,
  sym__pattern_bit_string_segment_argument = 182,
  sym_list_pattern = 183,
  sym_list_pattern_tail = 184,
  sym_type_definition = 185,
  sym_data_constructors = 186,
  sym_data_constructor = 187,
  sym_data_constructor_arguments = 188,
  sym_data_constructor_argument = 189,
  sym_type_alias = 190,
  sym_string = 191,
  sym__string_part = 192,
  sym_integer = 193,
  sym__bit_string_segment_option = 194,
  sym__type = 195,
  sym__type_annotation = 196,
  sym_type_hole = 197,
  sym_tuple_type = 198,
  sym_function_type = 199,
  sym_function_parameter_types = 200,
  sym_type = 201,
  sym_type_arguments = 202,
  sym_type_argument = 203,
  sym_type_var = 204,
  sym_type_name = 205,
  sym_type_parameters = 206,
  sym_type_parameter = 207,
  sym_identifier = 208,
  sym_label = 209,
  sym_discard = 210,
  sym_type_identifier = 211,
  sym_remote_type_identifier = 212,
  aux_sym_source_file_repeat1 = 213,
  aux_sym_target_group_repeat1 = 214,
  aux_sym_module_repeat1 = 215,
  aux_sym_unqualified_imports_repeat1 = 216,
  aux_sym_constant_tuple_repeat1 = 217,
  aux_sym__constant_bit_string_repeat1 = 218,
  aux_sym_constant_bit_string_segment_options_repeat1 = 219,
  aux_sym_constant_record_arguments_repeat1 = 220,
  aux_sym_constant_tuple_type_repeat1 = 221,
  aux_sym_constant_type_arguments_repeat1 = 222,
  aux_sym_external_function_parameters_repeat1 = 223,
  aux_sym_function_parameters_repeat1 = 224,
  aux_sym_tuple_repeat1 = 225,
  aux_sym__expression_bit_string_repeat1 = 226,
  aux_sym_expression_bit_string_segment_options_repeat1 = 227,
  aux_sym_case_clauses_repeat1 = 228,
  aux_sym_case_clause_patterns_repeat1 = 229,
  aux_sym_case_clause_pattern_repeat1 = 230,
  aux_sym_record_update_arguments_repeat1 = 231,
  aux_sym_arguments_repeat1 = 232,
  aux_sym_record_pattern_arguments_repeat1 = 233,
  aux_sym__pattern_bit_string_repeat1 = 234,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 235,
  aux_sym_data_constructors_repeat1 = 236,
  aux_sym_data_constructor_arguments_repeat1 = 237,
  aux_sym_string_repeat1 = 238,
  aux_sym_tuple_type_repeat1 = 239,
  aux_sym_type_arguments_repeat1 = 240,
  aux_sym_type_parameters_repeat1 = 241,
  alias_sym_function_body = 242,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_COMMA] = ",",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_COLON] = ":",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_external] = "external",
  [anon_sym_type] = "type",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_try] = "try",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_todo] = "todo",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [sym_escape_sequence] = "escape_sequence",
  [sym_quoted_content] = "quoted_content",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__expression_seq] = "_expression_seq",
  [sym_try] = "try",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_expression_group] = "expression_group",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let] = "let",
  [sym_assert] = "assert",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym__string_part] = "_string_part",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_function_body] = "function_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_quoted_content] = sym_quoted_content,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__expression_seq] = aux_sym__expression_seq,
  [sym_try] = sym_try,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_expression_group] = sym_expression_group,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let] = sym_let,
  [sym_assert] = sym_assert,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym__string_part] = sym__string_part,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__expression_seq] = {
    .visible = false,
    .named = false,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_group] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__string_part] = {
    .visible = false,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_body = 4,
  field_clauses = 5,
  field_constructor = 6,
  field_field = 7,
  field_function = 8,
  field_guard = 9,
  field_imports = 10,
  field_index = 11,
  field_label = 12,
  field_left = 13,
  field_message = 14,
  field_module = 15,
  field_name = 16,
  field_operator = 17,
  field_options = 18,
  field_parameter_types = 19,
  field_parameters = 20,
  field_pattern = 21,
  field_patterns = 22,
  field_record = 23,
  field_return_type = 24,
  field_right = 25,
  field_spread = 26,
  field_subjects = 27,
  field_target = 28,
  field_tuple = 29,
  field_type = 30,
  field_value = 31,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 4},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 1},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 3},
  [12] = {.index = 21, .length = 2},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 2},
  [15] = {.index = 27, .length = 1},
  [16] = {.index = 28, .length = 2},
  [17] = {.index = 30, .length = 2},
  [18] = {.index = 32, .length = 2},
  [19] = {.index = 34, .length = 1},
  [20] = {.index = 35, .length = 3},
  [21] = {.index = 38, .length = 3},
  [22] = {.index = 41, .length = 2},
  [23] = {.index = 43, .length = 2},
  [24] = {.index = 45, .length = 1},
  [25] = {.index = 46, .length = 2},
  [26] = {.index = 48, .length = 3},
  [27] = {.index = 51, .length = 2},
  [28] = {.index = 53, .length = 1},
  [29] = {.index = 54, .length = 1},
  [30] = {.index = 55, .length = 3},
  [31] = {.index = 58, .length = 3},
  [32] = {.index = 61, .length = 1},
  [33] = {.index = 62, .length = 1},
  [34] = {.index = 63, .length = 2},
  [35] = {.index = 65, .length = 1},
  [36] = {.index = 66, .length = 2},
  [37] = {.index = 68, .length = 2},
  [38] = {.index = 70, .length = 4},
  [39] = {.index = 74, .length = 4},
  [40] = {.index = 78, .length = 2},
  [41] = {.index = 80, .length = 4},
  [42] = {.index = 84, .length = 2},
  [43] = {.index = 86, .length = 2},
  [44] = {.index = 88, .length = 3},
  [45] = {.index = 91, .length = 1},
  [46] = {.index = 92, .length = 1},
  [47] = {.index = 93, .length = 3},
  [48] = {.index = 96, .length = 2},
  [49] = {.index = 98, .length = 3},
  [50] = {.index = 101, .length = 3},
  [51] = {.index = 104, .length = 2},
  [52] = {.index = 106, .length = 2},
  [53] = {.index = 108, .length = 3},
  [54] = {.index = 111, .length = 2},
  [55] = {.index = 113, .length = 1},
  [56] = {.index = 114, .length = 2},
  [57] = {.index = 116, .length = 2},
  [58] = {.index = 118, .length = 3},
  [59] = {.index = 121, .length = 3},
  [60] = {.index = 124, .length = 3},
  [61] = {.index = 127, .length = 3},
  [62] = {.index = 130, .length = 4},
  [63] = {.index = 134, .length = 4},
  [64] = {.index = 138, .length = 4},
  [65] = {.index = 130, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_module, 1},
  [2] =
    {field_value, 0},
  [3] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_arguments, 1},
    {field_name, 0},
  [11] =
    {field_name, 0},
    {field_parameters, 1},
  [13] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [15] =
    {field_name, 0, .inherited = true},
  [16] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [18] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [21] =
    {field_index, 2},
    {field_tuple, 0},
  [23] =
    {field_field, 2},
    {field_record, 0},
  [25] =
    {field_module, 0},
    {field_name, 2},
  [27] =
    {field_target, 1},
  [28] =
    {field_imports, 3},
    {field_module, 1},
  [30] =
    {field_alias, 3},
    {field_module, 1},
  [32] =
    {field_name, 1},
    {field_value, 3},
  [34] =
    {field_type, 1},
  [35] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [38] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [41] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [43] =
    {field_label, 0},
    {field_name, 1},
  [45] =
    {field_assign, 1, .inherited = true},
  [46] =
    {field_assign, 1},
    {field_assign, 2},
  [48] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1},
    {field_value, 3},
  [51] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [53] =
    {field_message, 2},
  [54] =
    {field_assign, 0, .inherited = true},
  [55] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [58] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [61] =
    {field_spread, 3},
  [62] =
    {field_type, 0},
  [63] =
    {field_body, 3},
    {field_parameters, 1},
  [65] =
    {field_assign, 2, .inherited = true},
  [66] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [68] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [70] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [74] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [78] =
    {field_clauses, 3},
    {field_subjects, 1},
  [80] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [84] =
    {field_name, 2},
    {field_value, 4},
  [86] =
    {field_label, 0},
    {field_value, 2},
  [88] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [91] =
    {field_spread, 4},
  [92] =
    {field_return_type, 2},
  [93] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [96] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [98] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [101] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [104] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [106] =
    {field_patterns, 0},
    {field_value, 2},
  [108] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [111] =
    {field_alias, 2},
    {field_name, 0},
  [113] =
    {field_spread, 5},
  [114] =
    {field_name, 0},
    {field_type, 2},
  [116] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [118] =
    {field_body, 5},
    {field_parameters, 1},
    {field_return_type, 3},
  [121] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [124] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [127] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [130] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [134] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [138] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [34] = {
    [3] = alias_sym_function_body,
  },
  [47] = {
    [4] = alias_sym_function_body,
  },
  [58] = {
    [5] = alias_sym_function_body,
  },
  [60] = {
    [5] = alias_sym_function_body,
  },
  [63] = {
    [6] = alias_sym_function_body,
  },
  [65] = {
    [7] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__expression_seq, 2,
    aux_sym__expression_seq,
    alias_sym_function_body,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(156);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(201);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(219);
      if (lookahead == '=') ADVANCE(190);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(298);
      if (lookahead == 'a') ADVANCE(403);
      if (lookahead == 'b') ADVANCE(351);
      if (lookahead == 'c') ADVANCE(307);
      if (lookahead == 'e') ADVANCE(396);
      if (lookahead == 'f') ADVANCE(361);
      if (lookahead == 'i') ADVANCE(342);
      if (lookahead == 'j') ADVANCE(305);
      if (lookahead == 'l') ADVANCE(334);
      if (lookahead == 'n') ADVANCE(313);
      if (lookahead == 'o') ADVANCE(389);
      if (lookahead == 'p') ADVANCE(428);
      if (lookahead == 's') ADVANCE(352);
      if (lookahead == 't') ADVANCE(376);
      if (lookahead == 'u') ADVANCE(366);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(241);
      if (lookahead == '}') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(216);
      END_STATE();
    case 2:
      if (lookahead == '.') ADVANCE(238);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 5:
      if (lookahead == '1') ADVANCE(7);
      if (lookahead == '3') ADVANCE(6);
      if (lookahead == '8') ADVANCE(275);
      END_STATE();
    case 6:
      if (lookahead == '2') ADVANCE(278);
      END_STATE();
    case 7:
      if (lookahead == '6') ADVANCE(276);
      END_STATE();
    case 8:
      if (lookahead == '<') ADVANCE(196);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(218);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 11:
      if (lookahead == '>') ADVANCE(213);
      END_STATE();
    case 12:
      if (lookahead == '>') ADVANCE(197);
      END_STATE();
    case 13:
      if (lookahead == '>') ADVANCE(229);
      if (lookahead == '|') ADVANCE(215);
      END_STATE();
    case 14:
      if (lookahead == '_') ADVANCE(107);
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(98);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 23:
      if (lookahead == 'b') ADVANCE(245);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(82);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(87);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(88);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(286);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(288);
      END_STATE();
    case 30:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(43);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(44);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(247);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(5);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(170);
      END_STATE();
    case 47:
      if (lookahead == 'f') ADVANCE(170);
      if (lookahead == 'm') ADVANCE(89);
      END_STATE();
    case 48:
      if (lookahead == 'g') ADVANCE(290);
      if (lookahead == 'n') ADVANCE(17);
      if (lookahead == 't') ADVANCE(14);
      END_STATE();
    case 49:
      if (lookahead == 'g') ADVANCE(174);
      END_STATE();
    case 50:
      if (lookahead == 'g') ADVANCE(270);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(74);
      if (lookahead == 'z') ADVANCE(33);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(48);
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 's') ADVANCE(55);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(207);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(83);
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(18);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 68:
      if (lookahead == 'm') ADVANCE(89);
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(116);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(81);
      END_STATE();
    case 90:
      if (lookahead == 'p') ADVANCE(16);
      END_STATE();
    case 91:
      if (lookahead == 'p') ADVANCE(34);
      END_STATE();
    case 92:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(114);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 96:
      if (lookahead == 'q') ADVANCE(124);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(66);
      if (lookahead == 'x') ADVANCE(119);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 99:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(182);
      END_STATE();
    case 104:
      if (lookahead == 's') ADVANCE(264);
      END_STATE();
    case 105:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(111);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(266);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(280);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(23);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 125:
      if (lookahead == 'v') ADVANCE(20);
      END_STATE();
    case 126:
      if (lookahead == 'v') ADVANCE(37);
      END_STATE();
    case 127:
      if (lookahead == 'x') ADVANCE(119);
      END_STATE();
    case 128:
      if (lookahead == 'y') ADVANCE(262);
      END_STATE();
    case 129:
      if (lookahead == 'y') ADVANCE(91);
      END_STATE();
    case 130:
      if (lookahead == '|') ADVANCE(215);
      END_STATE();
    case 131:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(261);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(132)
      if (lookahead == '\r') SKIP(132)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(219);
      if (lookahead == '=') ADVANCE(190);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'a') ADVANCE(408);
      if (lookahead == 'c') ADVANCE(308);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 't') ADVANCE(377);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(133)
      if (lookahead == '\r') SKIP(133)
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '=') ADVANCE(189);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == '_') ADVANCE(298);
      if (lookahead == 'a') ADVANCE(408);
      if (lookahead == 'c') ADVANCE(308);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 't') ADVANCE(378);
      if (lookahead == '{') ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(134)
      if (lookahead == '\r') SKIP(134)
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '>') ADVANCE(12);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'a') ADVANCE(408);
      if (lookahead == 'c') ADVANCE(308);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 't') ADVANCE(378);
      if (lookahead == '{') ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(135)
      if (lookahead == '\r') SKIP(135)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '0') ADVANCE(258);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(220);
      if (lookahead == '=') ADVANCE(190);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'b') ADVANCE(53);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(97);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 'j') ADVANCE(15);
      if (lookahead == 'l') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 's') ADVANCE(54);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == 'u') ADVANCE(70);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(136)
      if (lookahead == '\r') SKIP(136)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == '<') ADVANCE(219);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(298);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(137)
      if (lookahead == '\r') SKIP(137)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(220);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(173);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(138)
      if (lookahead == '\r') SKIP(138)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(220);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(173);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(139)
      if (lookahead == '\r') SKIP(139)
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '>') ADVANCE(12);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(140)
      if (lookahead == '\r') SKIP(140)
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '-') ADVANCE(203);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == '_') ADVANCE(298);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == '|') ADVANCE(240);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(141)
      if (lookahead == '\r') SKIP(141)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '<') ADVANCE(220);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(224);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == '|') ADVANCE(242);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == 'f') ADVANCE(365);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '=') ADVANCE(189);
      if (lookahead == '>') ADVANCE(12);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(240);
      if (lookahead == '}') ADVANCE(173);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(299);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(145)
      if (lookahead == '\r') SKIP(145)
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(258);
      if (lookahead == '}') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') ADVANCE(253);
      if (lookahead == '\r') ADVANCE(253);
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '/') ADVANCE(251);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(252);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == ')') ADVANCE(193);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == ',') ADVANCE(186);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == ':') ADVANCE(198);
      if (lookahead == '<') ADVANCE(219);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(225);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == ']') ADVANCE(195);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'a') ADVANCE(408);
      if (lookahead == 'c') ADVANCE(308);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 't') ADVANCE(377);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 148:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(250);
      END_STATE();
    case 149:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(250);
      if (lookahead != 0) ADVANCE(252);
      END_STATE();
    case 150:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(260);
      END_STATE();
    case 151:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(254);
      END_STATE();
    case 152:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      END_STATE();
    case 153:
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != 'e' &&
          lookahead != 'f' &&
          lookahead != 'n' &&
          lookahead != 'r' &&
          lookahead != 't') ADVANCE(252);
      END_STATE();
    case 154:
      if (eof) ADVANCE(156);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(154)
      if (lookahead == '\r') SKIP(154)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(192);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == '<') ADVANCE(219);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(224);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'a') ADVANCE(408);
      if (lookahead == 'c') ADVANCE(307);
      if (lookahead == 'e') ADVANCE(432);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'i') ADVANCE(343);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(389);
      if (lookahead == 'p') ADVANCE(428);
      if (lookahead == 't') ADVANCE(376);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead == '|') ADVANCE(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 155:
      if (eof) ADVANCE(156);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(155)
      if (lookahead == '\r') SKIP(155)
      if (lookahead == '"') ADVANCE(249);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == '0') ADVANCE(256);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '[') ADVANCE(194);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'a') ADVANCE(403);
      if (lookahead == 'c') ADVANCE(307);
      if (lookahead == 'e') ADVANCE(432);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'i') ADVANCE(343);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(389);
      if (lookahead == 'p') ADVANCE(428);
      if (lookahead == 't') ADVANCE(376);
      if (lookahead == '{') ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(436);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead != 0) ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(159);
      if (lookahead != 0) ADVANCE(157);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '/') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead != 0) ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead != 0) ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(164);
      if (lookahead != 0) ADVANCE(161);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(164);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"') ADVANCE(169);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"') ADVANCE(169);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(252);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(169);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(169);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(238);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(235);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(232);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(232);
      if (lookahead == '>') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_try);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(222);
      if (lookahead == '<') ADVANCE(196);
      if (lookahead == '=') ADVANCE(221);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(222);
      if (lookahead == '=') ADVANCE(221);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(223);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(227);
      if (lookahead == '=') ADVANCE(226);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(227);
      if (lookahead == '=') ADVANCE(226);
      if (lookahead == '>') ADVANCE(197);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(228);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(231);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(234);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(229);
      if (lookahead == '|') ADVANCE(215);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(215);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead == '\\') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(252);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '\\') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') ADVANCE(253);
      if (lookahead == '\r') ADVANCE(253);
      if (lookahead == '/') ADVANCE(251);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(252);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(254);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(151);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(131);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(150);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(257);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(257);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(131);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(150);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(259);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(259);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(260);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(261);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(24);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(26);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(298);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(299);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(299);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(300);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(303);
      if (lookahead == '3') ADVANCE(302);
      if (lookahead == '8') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(410);
      if (lookahead == 's') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(407);
      if (lookahead == 'o') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(426);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(171);
      if (lookahead == 'm') ADVANCE(388);
      if (lookahead == 'n') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(171);
      if (lookahead == 'm') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(291);
      if (lookahead == 'n') ADVANCE(309);
      if (lookahead == 't') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(370);
      if (lookahead == 'z') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(435);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(346);
      if (lookahead == 'y') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(431);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(413);
      if (lookahead == 's') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(382);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(358);
      if (lookahead == 't') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(322);
      if (lookahead == 'r') ADVANCE(433);
      if (lookahead == 'y') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(322);
      if (lookahead == 'r') ADVANCE(433);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(429);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(363);
      if (lookahead == 'x') ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(416);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'x') ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(435);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(436);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 154},
  [2] = {.lex_state = 154},
  [3] = {.lex_state = 154},
  [4] = {.lex_state = 154},
  [5] = {.lex_state = 154},
  [6] = {.lex_state = 154},
  [7] = {.lex_state = 154},
  [8] = {.lex_state = 154},
  [9] = {.lex_state = 154},
  [10] = {.lex_state = 154},
  [11] = {.lex_state = 154},
  [12] = {.lex_state = 154},
  [13] = {.lex_state = 154},
  [14] = {.lex_state = 154},
  [15] = {.lex_state = 154},
  [16] = {.lex_state = 154},
  [17] = {.lex_state = 154},
  [18] = {.lex_state = 154},
  [19] = {.lex_state = 132},
  [20] = {.lex_state = 154},
  [21] = {.lex_state = 154},
  [22] = {.lex_state = 154},
  [23] = {.lex_state = 154},
  [24] = {.lex_state = 154},
  [25] = {.lex_state = 154},
  [26] = {.lex_state = 133},
  [27] = {.lex_state = 154},
  [28] = {.lex_state = 154},
  [29] = {.lex_state = 154},
  [30] = {.lex_state = 154},
  [31] = {.lex_state = 154},
  [32] = {.lex_state = 154},
  [33] = {.lex_state = 133},
  [34] = {.lex_state = 154},
  [35] = {.lex_state = 133},
  [36] = {.lex_state = 132},
  [37] = {.lex_state = 154},
  [38] = {.lex_state = 154},
  [39] = {.lex_state = 133},
  [40] = {.lex_state = 154},
  [41] = {.lex_state = 154},
  [42] = {.lex_state = 132},
  [43] = {.lex_state = 133},
  [44] = {.lex_state = 147},
  [45] = {.lex_state = 154},
  [46] = {.lex_state = 133},
  [47] = {.lex_state = 154},
  [48] = {.lex_state = 154},
  [49] = {.lex_state = 154},
  [50] = {.lex_state = 154},
  [51] = {.lex_state = 154},
  [52] = {.lex_state = 154},
  [53] = {.lex_state = 154},
  [54] = {.lex_state = 133},
  [55] = {.lex_state = 154},
  [56] = {.lex_state = 154},
  [57] = {.lex_state = 154},
  [58] = {.lex_state = 154},
  [59] = {.lex_state = 154},
  [60] = {.lex_state = 154},
  [61] = {.lex_state = 154},
  [62] = {.lex_state = 154},
  [63] = {.lex_state = 154},
  [64] = {.lex_state = 154},
  [65] = {.lex_state = 133},
  [66] = {.lex_state = 154},
  [67] = {.lex_state = 133},
  [68] = {.lex_state = 133},
  [69] = {.lex_state = 154},
  [70] = {.lex_state = 133},
  [71] = {.lex_state = 133},
  [72] = {.lex_state = 154},
  [73] = {.lex_state = 133},
  [74] = {.lex_state = 147},
  [75] = {.lex_state = 154},
  [76] = {.lex_state = 154},
  [77] = {.lex_state = 133},
  [78] = {.lex_state = 154},
  [79] = {.lex_state = 133},
  [80] = {.lex_state = 154},
  [81] = {.lex_state = 154},
  [82] = {.lex_state = 133},
  [83] = {.lex_state = 154},
  [84] = {.lex_state = 154},
  [85] = {.lex_state = 132},
  [86] = {.lex_state = 132},
  [87] = {.lex_state = 132},
  [88] = {.lex_state = 132},
  [89] = {.lex_state = 132},
  [90] = {.lex_state = 147},
  [91] = {.lex_state = 132},
  [92] = {.lex_state = 132},
  [93] = {.lex_state = 132},
  [94] = {.lex_state = 132},
  [95] = {.lex_state = 133},
  [96] = {.lex_state = 132},
  [97] = {.lex_state = 132},
  [98] = {.lex_state = 132},
  [99] = {.lex_state = 132},
  [100] = {.lex_state = 132},
  [101] = {.lex_state = 132},
  [102] = {.lex_state = 132},
  [103] = {.lex_state = 132},
  [104] = {.lex_state = 132},
  [105] = {.lex_state = 132},
  [106] = {.lex_state = 132},
  [107] = {.lex_state = 132},
  [108] = {.lex_state = 132},
  [109] = {.lex_state = 147},
  [110] = {.lex_state = 132},
  [111] = {.lex_state = 132},
  [112] = {.lex_state = 132},
  [113] = {.lex_state = 147},
  [114] = {.lex_state = 132},
  [115] = {.lex_state = 147},
  [116] = {.lex_state = 132},
  [117] = {.lex_state = 132},
  [118] = {.lex_state = 147},
  [119] = {.lex_state = 132},
  [120] = {.lex_state = 132},
  [121] = {.lex_state = 132},
  [122] = {.lex_state = 132},
  [123] = {.lex_state = 132},
  [124] = {.lex_state = 132},
  [125] = {.lex_state = 132},
  [126] = {.lex_state = 132},
  [127] = {.lex_state = 132},
  [128] = {.lex_state = 132},
  [129] = {.lex_state = 132},
  [130] = {.lex_state = 132},
  [131] = {.lex_state = 147},
  [132] = {.lex_state = 132},
  [133] = {.lex_state = 147},
  [134] = {.lex_state = 147},
  [135] = {.lex_state = 147},
  [136] = {.lex_state = 147},
  [137] = {.lex_state = 147},
  [138] = {.lex_state = 147},
  [139] = {.lex_state = 147},
  [140] = {.lex_state = 147},
  [141] = {.lex_state = 147},
  [142] = {.lex_state = 147},
  [143] = {.lex_state = 147},
  [144] = {.lex_state = 134},
  [145] = {.lex_state = 133},
  [146] = {.lex_state = 147},
  [147] = {.lex_state = 134},
  [148] = {.lex_state = 147},
  [149] = {.lex_state = 147},
  [150] = {.lex_state = 134},
  [151] = {.lex_state = 147},
  [152] = {.lex_state = 134},
  [153] = {.lex_state = 147},
  [154] = {.lex_state = 134},
  [155] = {.lex_state = 147},
  [156] = {.lex_state = 147},
  [157] = {.lex_state = 147},
  [158] = {.lex_state = 134},
  [159] = {.lex_state = 147},
  [160] = {.lex_state = 147},
  [161] = {.lex_state = 134},
  [162] = {.lex_state = 134},
  [163] = {.lex_state = 134},
  [164] = {.lex_state = 147},
  [165] = {.lex_state = 134},
  [166] = {.lex_state = 134},
  [167] = {.lex_state = 134},
  [168] = {.lex_state = 134},
  [169] = {.lex_state = 134},
  [170] = {.lex_state = 134},
  [171] = {.lex_state = 134},
  [172] = {.lex_state = 134},
  [173] = {.lex_state = 147},
  [174] = {.lex_state = 134},
  [175] = {.lex_state = 147},
  [176] = {.lex_state = 147},
  [177] = {.lex_state = 134},
  [178] = {.lex_state = 147},
  [179] = {.lex_state = 134},
  [180] = {.lex_state = 147},
  [181] = {.lex_state = 147},
  [182] = {.lex_state = 147},
  [183] = {.lex_state = 134},
  [184] = {.lex_state = 147},
  [185] = {.lex_state = 134},
  [186] = {.lex_state = 134},
  [187] = {.lex_state = 134},
  [188] = {.lex_state = 147},
  [189] = {.lex_state = 147},
  [190] = {.lex_state = 147},
  [191] = {.lex_state = 147},
  [192] = {.lex_state = 147},
  [193] = {.lex_state = 134},
  [194] = {.lex_state = 134},
  [195] = {.lex_state = 134},
  [196] = {.lex_state = 134},
  [197] = {.lex_state = 134},
  [198] = {.lex_state = 134},
  [199] = {.lex_state = 134},
  [200] = {.lex_state = 134},
  [201] = {.lex_state = 134},
  [202] = {.lex_state = 134},
  [203] = {.lex_state = 134},
  [204] = {.lex_state = 134},
  [205] = {.lex_state = 134},
  [206] = {.lex_state = 134},
  [207] = {.lex_state = 134},
  [208] = {.lex_state = 134},
  [209] = {.lex_state = 134},
  [210] = {.lex_state = 134},
  [211] = {.lex_state = 134},
  [212] = {.lex_state = 134},
  [213] = {.lex_state = 134},
  [214] = {.lex_state = 134},
  [215] = {.lex_state = 134},
  [216] = {.lex_state = 134},
  [217] = {.lex_state = 134},
  [218] = {.lex_state = 134},
  [219] = {.lex_state = 134},
  [220] = {.lex_state = 134},
  [221] = {.lex_state = 134},
  [222] = {.lex_state = 134},
  [223] = {.lex_state = 134},
  [224] = {.lex_state = 134},
  [225] = {.lex_state = 134},
  [226] = {.lex_state = 134},
  [227] = {.lex_state = 134},
  [228] = {.lex_state = 134},
  [229] = {.lex_state = 134},
  [230] = {.lex_state = 134},
  [231] = {.lex_state = 134},
  [232] = {.lex_state = 134},
  [233] = {.lex_state = 134},
  [234] = {.lex_state = 134},
  [235] = {.lex_state = 134},
  [236] = {.lex_state = 134},
  [237] = {.lex_state = 134},
  [238] = {.lex_state = 134},
  [239] = {.lex_state = 134},
  [240] = {.lex_state = 134},
  [241] = {.lex_state = 134},
  [242] = {.lex_state = 134},
  [243] = {.lex_state = 134},
  [244] = {.lex_state = 134},
  [245] = {.lex_state = 134},
  [246] = {.lex_state = 134},
  [247] = {.lex_state = 134},
  [248] = {.lex_state = 134},
  [249] = {.lex_state = 134},
  [250] = {.lex_state = 134},
  [251] = {.lex_state = 134},
  [252] = {.lex_state = 134},
  [253] = {.lex_state = 134},
  [254] = {.lex_state = 134},
  [255] = {.lex_state = 134},
  [256] = {.lex_state = 134},
  [257] = {.lex_state = 134},
  [258] = {.lex_state = 134},
  [259] = {.lex_state = 134},
  [260] = {.lex_state = 134},
  [261] = {.lex_state = 134},
  [262] = {.lex_state = 134},
  [263] = {.lex_state = 134},
  [264] = {.lex_state = 134},
  [265] = {.lex_state = 134},
  [266] = {.lex_state = 134},
  [267] = {.lex_state = 134},
  [268] = {.lex_state = 134},
  [269] = {.lex_state = 134},
  [270] = {.lex_state = 134},
  [271] = {.lex_state = 134},
  [272] = {.lex_state = 134},
  [273] = {.lex_state = 147},
  [274] = {.lex_state = 147},
  [275] = {.lex_state = 147},
  [276] = {.lex_state = 147},
  [277] = {.lex_state = 147},
  [278] = {.lex_state = 147},
  [279] = {.lex_state = 135},
  [280] = {.lex_state = 147},
  [281] = {.lex_state = 135},
  [282] = {.lex_state = 135},
  [283] = {.lex_state = 135},
  [284] = {.lex_state = 135},
  [285] = {.lex_state = 147},
  [286] = {.lex_state = 147},
  [287] = {.lex_state = 147},
  [288] = {.lex_state = 147},
  [289] = {.lex_state = 147},
  [290] = {.lex_state = 135},
  [291] = {.lex_state = 135},
  [292] = {.lex_state = 136},
  [293] = {.lex_state = 136},
  [294] = {.lex_state = 136},
  [295] = {.lex_state = 136},
  [296] = {.lex_state = 136},
  [297] = {.lex_state = 136},
  [298] = {.lex_state = 136},
  [299] = {.lex_state = 136},
  [300] = {.lex_state = 136},
  [301] = {.lex_state = 136},
  [302] = {.lex_state = 136},
  [303] = {.lex_state = 136},
  [304] = {.lex_state = 136},
  [305] = {.lex_state = 136},
  [306] = {.lex_state = 136},
  [307] = {.lex_state = 136},
  [308] = {.lex_state = 136},
  [309] = {.lex_state = 136},
  [310] = {.lex_state = 136},
  [311] = {.lex_state = 136},
  [312] = {.lex_state = 136},
  [313] = {.lex_state = 136},
  [314] = {.lex_state = 136},
  [315] = {.lex_state = 136},
  [316] = {.lex_state = 136},
  [317] = {.lex_state = 136},
  [318] = {.lex_state = 136},
  [319] = {.lex_state = 136},
  [320] = {.lex_state = 136},
  [321] = {.lex_state = 136},
  [322] = {.lex_state = 136},
  [323] = {.lex_state = 136},
  [324] = {.lex_state = 136},
  [325] = {.lex_state = 136},
  [326] = {.lex_state = 136},
  [327] = {.lex_state = 136},
  [328] = {.lex_state = 136},
  [329] = {.lex_state = 136},
  [330] = {.lex_state = 136},
  [331] = {.lex_state = 136},
  [332] = {.lex_state = 136},
  [333] = {.lex_state = 136},
  [334] = {.lex_state = 136},
  [335] = {.lex_state = 136},
  [336] = {.lex_state = 136},
  [337] = {.lex_state = 136},
  [338] = {.lex_state = 136},
  [339] = {.lex_state = 136},
  [340] = {.lex_state = 136},
  [341] = {.lex_state = 136},
  [342] = {.lex_state = 136},
  [343] = {.lex_state = 136},
  [344] = {.lex_state = 136},
  [345] = {.lex_state = 136},
  [346] = {.lex_state = 136},
  [347] = {.lex_state = 136},
  [348] = {.lex_state = 136},
  [349] = {.lex_state = 137},
  [350] = {.lex_state = 135},
  [351] = {.lex_state = 137},
  [352] = {.lex_state = 137},
  [353] = {.lex_state = 137},
  [354] = {.lex_state = 135},
  [355] = {.lex_state = 137},
  [356] = {.lex_state = 155},
  [357] = {.lex_state = 137},
  [358] = {.lex_state = 137},
  [359] = {.lex_state = 135},
  [360] = {.lex_state = 137},
  [361] = {.lex_state = 137},
  [362] = {.lex_state = 135},
  [363] = {.lex_state = 135},
  [364] = {.lex_state = 137},
  [365] = {.lex_state = 137},
  [366] = {.lex_state = 137},
  [367] = {.lex_state = 135},
  [368] = {.lex_state = 155},
  [369] = {.lex_state = 155},
  [370] = {.lex_state = 137},
  [371] = {.lex_state = 135},
  [372] = {.lex_state = 137},
  [373] = {.lex_state = 155},
  [374] = {.lex_state = 137},
  [375] = {.lex_state = 137},
  [376] = {.lex_state = 137},
  [377] = {.lex_state = 135},
  [378] = {.lex_state = 137},
  [379] = {.lex_state = 137},
  [380] = {.lex_state = 137},
  [381] = {.lex_state = 137},
  [382] = {.lex_state = 135},
  [383] = {.lex_state = 137},
  [384] = {.lex_state = 137},
  [385] = {.lex_state = 137},
  [386] = {.lex_state = 137},
  [387] = {.lex_state = 154},
  [388] = {.lex_state = 137},
  [389] = {.lex_state = 137},
  [390] = {.lex_state = 137},
  [391] = {.lex_state = 137},
  [392] = {.lex_state = 136},
  [393] = {.lex_state = 137},
  [394] = {.lex_state = 137},
  [395] = {.lex_state = 137},
  [396] = {.lex_state = 135},
  [397] = {.lex_state = 137},
  [398] = {.lex_state = 136},
  [399] = {.lex_state = 137},
  [400] = {.lex_state = 137},
  [401] = {.lex_state = 137},
  [402] = {.lex_state = 137},
  [403] = {.lex_state = 136},
  [404] = {.lex_state = 137},
  [405] = {.lex_state = 154},
  [406] = {.lex_state = 137},
  [407] = {.lex_state = 137},
  [408] = {.lex_state = 137},
  [409] = {.lex_state = 137},
  [410] = {.lex_state = 137},
  [411] = {.lex_state = 136},
  [412] = {.lex_state = 136},
  [413] = {.lex_state = 136},
  [414] = {.lex_state = 136},
  [415] = {.lex_state = 137},
  [416] = {.lex_state = 136},
  [417] = {.lex_state = 137},
  [418] = {.lex_state = 154},
  [419] = {.lex_state = 136},
  [420] = {.lex_state = 155},
  [421] = {.lex_state = 135},
  [422] = {.lex_state = 137},
  [423] = {.lex_state = 135},
  [424] = {.lex_state = 137},
  [425] = {.lex_state = 137},
  [426] = {.lex_state = 137},
  [427] = {.lex_state = 155},
  [428] = {.lex_state = 155},
  [429] = {.lex_state = 138},
  [430] = {.lex_state = 155},
  [431] = {.lex_state = 155},
  [432] = {.lex_state = 155},
  [433] = {.lex_state = 154},
  [434] = {.lex_state = 154},
  [435] = {.lex_state = 154},
  [436] = {.lex_state = 136},
  [437] = {.lex_state = 139},
  [438] = {.lex_state = 140},
  [439] = {.lex_state = 140},
  [440] = {.lex_state = 154},
  [441] = {.lex_state = 154},
  [442] = {.lex_state = 154},
  [443] = {.lex_state = 154},
  [444] = {.lex_state = 154},
  [445] = {.lex_state = 154},
  [446] = {.lex_state = 154},
  [447] = {.lex_state = 154},
  [448] = {.lex_state = 137},
  [449] = {.lex_state = 154},
  [450] = {.lex_state = 154},
  [451] = {.lex_state = 154},
  [452] = {.lex_state = 154},
  [453] = {.lex_state = 154},
  [454] = {.lex_state = 136},
  [455] = {.lex_state = 154},
  [456] = {.lex_state = 154},
  [457] = {.lex_state = 136},
  [458] = {.lex_state = 154},
  [459] = {.lex_state = 154},
  [460] = {.lex_state = 154},
  [461] = {.lex_state = 154},
  [462] = {.lex_state = 154},
  [463] = {.lex_state = 154},
  [464] = {.lex_state = 154},
  [465] = {.lex_state = 154},
  [466] = {.lex_state = 154},
  [467] = {.lex_state = 154},
  [468] = {.lex_state = 154},
  [469] = {.lex_state = 154},
  [470] = {.lex_state = 154},
  [471] = {.lex_state = 154},
  [472] = {.lex_state = 154},
  [473] = {.lex_state = 154},
  [474] = {.lex_state = 154},
  [475] = {.lex_state = 139},
  [476] = {.lex_state = 154},
  [477] = {.lex_state = 154},
  [478] = {.lex_state = 154},
  [479] = {.lex_state = 154},
  [480] = {.lex_state = 154},
  [481] = {.lex_state = 154},
  [482] = {.lex_state = 154},
  [483] = {.lex_state = 140},
  [484] = {.lex_state = 154},
  [485] = {.lex_state = 140},
  [486] = {.lex_state = 154},
  [487] = {.lex_state = 154},
  [488] = {.lex_state = 154},
  [489] = {.lex_state = 154},
  [490] = {.lex_state = 154},
  [491] = {.lex_state = 154},
  [492] = {.lex_state = 154},
  [493] = {.lex_state = 154},
  [494] = {.lex_state = 154},
  [495] = {.lex_state = 154},
  [496] = {.lex_state = 139},
  [497] = {.lex_state = 139},
  [498] = {.lex_state = 139},
  [499] = {.lex_state = 139},
  [500] = {.lex_state = 139},
  [501] = {.lex_state = 154},
  [502] = {.lex_state = 154},
  [503] = {.lex_state = 154},
  [504] = {.lex_state = 154},
  [505] = {.lex_state = 139},
  [506] = {.lex_state = 154},
  [507] = {.lex_state = 139},
  [508] = {.lex_state = 139},
  [509] = {.lex_state = 154},
  [510] = {.lex_state = 138},
  [511] = {.lex_state = 138},
  [512] = {.lex_state = 138},
  [513] = {.lex_state = 136},
  [514] = {.lex_state = 137},
  [515] = {.lex_state = 138},
  [516] = {.lex_state = 136},
  [517] = {.lex_state = 137},
  [518] = {.lex_state = 138},
  [519] = {.lex_state = 138},
  [520] = {.lex_state = 136},
  [521] = {.lex_state = 138},
  [522] = {.lex_state = 138},
  [523] = {.lex_state = 138},
  [524] = {.lex_state = 138},
  [525] = {.lex_state = 136},
  [526] = {.lex_state = 138},
  [527] = {.lex_state = 138},
  [528] = {.lex_state = 138},
  [529] = {.lex_state = 138},
  [530] = {.lex_state = 137},
  [531] = {.lex_state = 138},
  [532] = {.lex_state = 137},
  [533] = {.lex_state = 138},
  [534] = {.lex_state = 138},
  [535] = {.lex_state = 136},
  [536] = {.lex_state = 137},
  [537] = {.lex_state = 136},
  [538] = {.lex_state = 139},
  [539] = {.lex_state = 136},
  [540] = {.lex_state = 137},
  [541] = {.lex_state = 137},
  [542] = {.lex_state = 139},
  [543] = {.lex_state = 136},
  [544] = {.lex_state = 136},
  [545] = {.lex_state = 136},
  [546] = {.lex_state = 136},
  [547] = {.lex_state = 136},
  [548] = {.lex_state = 136},
  [549] = {.lex_state = 139},
  [550] = {.lex_state = 139},
  [551] = {.lex_state = 136},
  [552] = {.lex_state = 139},
  [553] = {.lex_state = 136},
  [554] = {.lex_state = 136},
  [555] = {.lex_state = 136},
  [556] = {.lex_state = 137},
  [557] = {.lex_state = 139},
  [558] = {.lex_state = 137},
  [559] = {.lex_state = 136},
  [560] = {.lex_state = 136},
  [561] = {.lex_state = 139},
  [562] = {.lex_state = 139},
  [563] = {.lex_state = 137},
  [564] = {.lex_state = 136},
  [565] = {.lex_state = 139},
  [566] = {.lex_state = 139},
  [567] = {.lex_state = 136},
  [568] = {.lex_state = 136},
  [569] = {.lex_state = 139},
  [570] = {.lex_state = 137},
  [571] = {.lex_state = 136},
  [572] = {.lex_state = 139},
  [573] = {.lex_state = 137},
  [574] = {.lex_state = 136},
  [575] = {.lex_state = 139},
  [576] = {.lex_state = 139},
  [577] = {.lex_state = 137},
  [578] = {.lex_state = 139},
  [579] = {.lex_state = 137},
  [580] = {.lex_state = 137},
  [581] = {.lex_state = 137},
  [582] = {.lex_state = 137},
  [583] = {.lex_state = 137},
  [584] = {.lex_state = 139},
  [585] = {.lex_state = 137},
  [586] = {.lex_state = 137},
  [587] = {.lex_state = 139},
  [588] = {.lex_state = 137},
  [589] = {.lex_state = 137},
  [590] = {.lex_state = 139},
  [591] = {.lex_state = 139},
  [592] = {.lex_state = 137},
  [593] = {.lex_state = 137},
  [594] = {.lex_state = 139},
  [595] = {.lex_state = 139},
  [596] = {.lex_state = 139},
  [597] = {.lex_state = 137},
  [598] = {.lex_state = 137},
  [599] = {.lex_state = 139},
  [600] = {.lex_state = 137},
  [601] = {.lex_state = 139},
  [602] = {.lex_state = 137},
  [603] = {.lex_state = 139},
  [604] = {.lex_state = 137},
  [605] = {.lex_state = 139},
  [606] = {.lex_state = 139},
  [607] = {.lex_state = 139},
  [608] = {.lex_state = 139},
  [609] = {.lex_state = 139},
  [610] = {.lex_state = 139},
  [611] = {.lex_state = 139},
  [612] = {.lex_state = 139},
  [613] = {.lex_state = 139},
  [614] = {.lex_state = 139},
  [615] = {.lex_state = 139},
  [616] = {.lex_state = 132},
  [617] = {.lex_state = 141},
  [618] = {.lex_state = 141},
  [619] = {.lex_state = 141},
  [620] = {.lex_state = 142},
  [621] = {.lex_state = 141},
  [622] = {.lex_state = 135},
  [623] = {.lex_state = 141},
  [624] = {.lex_state = 142},
  [625] = {.lex_state = 135},
  [626] = {.lex_state = 135},
  [627] = {.lex_state = 142},
  [628] = {.lex_state = 141},
  [629] = {.lex_state = 141},
  [630] = {.lex_state = 142},
  [631] = {.lex_state = 142},
  [632] = {.lex_state = 142},
  [633] = {.lex_state = 142},
  [634] = {.lex_state = 142},
  [635] = {.lex_state = 142},
  [636] = {.lex_state = 142},
  [637] = {.lex_state = 142},
  [638] = {.lex_state = 142},
  [639] = {.lex_state = 142},
  [640] = {.lex_state = 142},
  [641] = {.lex_state = 142},
  [642] = {.lex_state = 142},
  [643] = {.lex_state = 142},
  [644] = {.lex_state = 142},
  [645] = {.lex_state = 142},
  [646] = {.lex_state = 142},
  [647] = {.lex_state = 142},
  [648] = {.lex_state = 142},
  [649] = {.lex_state = 142},
  [650] = {.lex_state = 142},
  [651] = {.lex_state = 142},
  [652] = {.lex_state = 142},
  [653] = {.lex_state = 142},
  [654] = {.lex_state = 142},
  [655] = {.lex_state = 138},
  [656] = {.lex_state = 142},
  [657] = {.lex_state = 138},
  [658] = {.lex_state = 143},
  [659] = {.lex_state = 137},
  [660] = {.lex_state = 142},
  [661] = {.lex_state = 138},
  [662] = {.lex_state = 142},
  [663] = {.lex_state = 142},
  [664] = {.lex_state = 142},
  [665] = {.lex_state = 142},
  [666] = {.lex_state = 142},
  [667] = {.lex_state = 142},
  [668] = {.lex_state = 143},
  [669] = {.lex_state = 142},
  [670] = {.lex_state = 142},
  [671] = {.lex_state = 142},
  [672] = {.lex_state = 142},
  [673] = {.lex_state = 142},
  [674] = {.lex_state = 138},
  [675] = {.lex_state = 138},
  [676] = {.lex_state = 142},
  [677] = {.lex_state = 142},
  [678] = {.lex_state = 142},
  [679] = {.lex_state = 142},
  [680] = {.lex_state = 142},
  [681] = {.lex_state = 142},
  [682] = {.lex_state = 142},
  [683] = {.lex_state = 142},
  [684] = {.lex_state = 142},
  [685] = {.lex_state = 142},
  [686] = {.lex_state = 138},
  [687] = {.lex_state = 142},
  [688] = {.lex_state = 137},
  [689] = {.lex_state = 144},
  [690] = {.lex_state = 137},
  [691] = {.lex_state = 138},
  [692] = {.lex_state = 137},
  [693] = {.lex_state = 144},
  [694] = {.lex_state = 137},
  [695] = {.lex_state = 143},
  [696] = {.lex_state = 138},
  [697] = {.lex_state = 138},
  [698] = {.lex_state = 138},
  [699] = {.lex_state = 144},
  [700] = {.lex_state = 143},
  [701] = {.lex_state = 144},
  [702] = {.lex_state = 143},
  [703] = {.lex_state = 143},
  [704] = {.lex_state = 143},
  [705] = {.lex_state = 143},
  [706] = {.lex_state = 144},
  [707] = {.lex_state = 144},
  [708] = {.lex_state = 143},
  [709] = {.lex_state = 143},
  [710] = {.lex_state = 143},
  [711] = {.lex_state = 143},
  [712] = {.lex_state = 143},
  [713] = {.lex_state = 135},
  [714] = {.lex_state = 135},
  [715] = {.lex_state = 135},
  [716] = {.lex_state = 143},
  [717] = {.lex_state = 143},
  [718] = {.lex_state = 143},
  [719] = {.lex_state = 144},
  [720] = {.lex_state = 143},
  [721] = {.lex_state = 143},
  [722] = {.lex_state = 144},
  [723] = {.lex_state = 143},
  [724] = {.lex_state = 135},
  [725] = {.lex_state = 143},
  [726] = {.lex_state = 143},
  [727] = {.lex_state = 143},
  [728] = {.lex_state = 143},
  [729] = {.lex_state = 144},
  [730] = {.lex_state = 143},
  [731] = {.lex_state = 143},
  [732] = {.lex_state = 143},
  [733] = {.lex_state = 143},
  [734] = {.lex_state = 143},
  [735] = {.lex_state = 143},
  [736] = {.lex_state = 143},
  [737] = {.lex_state = 144},
  [738] = {.lex_state = 143},
  [739] = {.lex_state = 143},
  [740] = {.lex_state = 143},
  [741] = {.lex_state = 143},
  [742] = {.lex_state = 143},
  [743] = {.lex_state = 143},
  [744] = {.lex_state = 143},
  [745] = {.lex_state = 144},
  [746] = {.lex_state = 143},
  [747] = {.lex_state = 143},
  [748] = {.lex_state = 144},
  [749] = {.lex_state = 143},
  [750] = {.lex_state = 143},
  [751] = {.lex_state = 143},
  [752] = {.lex_state = 143},
  [753] = {.lex_state = 143},
  [754] = {.lex_state = 143},
  [755] = {.lex_state = 143},
  [756] = {.lex_state = 143},
  [757] = {.lex_state = 135},
  [758] = {.lex_state = 144},
  [759] = {.lex_state = 143},
  [760] = {.lex_state = 135},
  [761] = {.lex_state = 135},
  [762] = {.lex_state = 135},
  [763] = {.lex_state = 145},
  [764] = {.lex_state = 143},
  [765] = {.lex_state = 135},
  [766] = {.lex_state = 135},
  [767] = {.lex_state = 135},
  [768] = {.lex_state = 135},
  [769] = {.lex_state = 135},
  [770] = {.lex_state = 135},
  [771] = {.lex_state = 135},
  [772] = {.lex_state = 135},
  [773] = {.lex_state = 135},
  [774] = {.lex_state = 135},
  [775] = {.lex_state = 135},
  [776] = {.lex_state = 135},
  [777] = {.lex_state = 135},
  [778] = {.lex_state = 135},
  [779] = {.lex_state = 135},
  [780] = {.lex_state = 135},
  [781] = {.lex_state = 135},
  [782] = {.lex_state = 135},
  [783] = {.lex_state = 135},
  [784] = {.lex_state = 135},
  [785] = {.lex_state = 135},
  [786] = {.lex_state = 135},
  [787] = {.lex_state = 135},
  [788] = {.lex_state = 135},
  [789] = {.lex_state = 143},
  [790] = {.lex_state = 135},
  [791] = {.lex_state = 143},
  [792] = {.lex_state = 145},
  [793] = {.lex_state = 145},
  [794] = {.lex_state = 135},
  [795] = {.lex_state = 145},
  [796] = {.lex_state = 135},
  [797] = {.lex_state = 135},
  [798] = {.lex_state = 145},
  [799] = {.lex_state = 145},
  [800] = {.lex_state = 135},
  [801] = {.lex_state = 145},
  [802] = {.lex_state = 145},
  [803] = {.lex_state = 143},
  [804] = {.lex_state = 145},
  [805] = {.lex_state = 135},
  [806] = {.lex_state = 145},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 135},
  [809] = {.lex_state = 145},
  [810] = {.lex_state = 145},
  [811] = {.lex_state = 145},
  [812] = {.lex_state = 145},
  [813] = {.lex_state = 145},
  [814] = {.lex_state = 145},
  [815] = {.lex_state = 145},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 146},
  [818] = {.lex_state = 144},
  [819] = {.lex_state = 146},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 146},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 146},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 146},
  [826] = {.lex_state = 135},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 146},
  [829] = {.lex_state = 135},
  [830] = {.lex_state = 143},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 146},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 146},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 143},
  [838] = {.lex_state = 143},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 145},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 146},
  [843] = {.lex_state = 144},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 133},
  [846] = {.lex_state = 143},
  [847] = {.lex_state = 146},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 146},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 145},
  [852] = {.lex_state = 144},
  [853] = {.lex_state = 143},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 135},
  [858] = {.lex_state = 145},
  [859] = {.lex_state = 143},
  [860] = {.lex_state = 145},
  [861] = {.lex_state = 145},
  [862] = {.lex_state = 145},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 135},
  [865] = {.lex_state = 135},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 135},
  [869] = {.lex_state = 135},
  [870] = {.lex_state = 135},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 145},
  [873] = {.lex_state = 135},
  [874] = {.lex_state = 135},
  [875] = {.lex_state = 135},
  [876] = {.lex_state = 135},
  [877] = {.lex_state = 135},
  [878] = {.lex_state = 135},
  [879] = {.lex_state = 135},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 143},
  [882] = {.lex_state = 145},
  [883] = {.lex_state = 135},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 145},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 135},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 133},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 133},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 133},
  [908] = {.lex_state = 135},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 145},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 143},
  [934] = {.lex_state = 133},
  [935] = {.lex_state = 138},
  [936] = {.lex_state = 133},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 135},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 133},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 135},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 135},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 133},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 133},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 133},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 133},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 135},
  [972] = {.lex_state = 133},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 135},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 135},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 133},
  [979] = {.lex_state = 145},
  [980] = {.lex_state = 133},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 133},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 135},
  [989] = {.lex_state = 133},
  [990] = {.lex_state = 133},
  [991] = {.lex_state = 135},
  [992] = {.lex_state = 145},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 145},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 133},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 133},
  [1005] = {.lex_state = 133},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 135},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 133},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 145},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 145},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 145},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 145},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 145},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 145},
  [1044] = {.lex_state = 133},
  [1045] = {.lex_state = 145},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 145},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 133},
  [1058] = {.lex_state = 135},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 145},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 145},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 145},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 135},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 133},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 145},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 145},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 145},
  [1097] = {.lex_state = 135},
  [1098] = {.lex_state = 145},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 145},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 145},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 145},
  [1111] = {.lex_state = 135},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 145},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 145},
  [1116] = {.lex_state = 133},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 145},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 145},
  [1133] = {.lex_state = 145},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 145},
  [1136] = {.lex_state = 145},
  [1137] = {.lex_state = 133},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 145},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 133},
  [1142] = {.lex_state = 145},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 133},
  [1164] = {.lex_state = 133},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 133},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 133},
  [1192] = {.lex_state = 133},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 133},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 135},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 133},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 133},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 135},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 145},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 135},
  [1222] = {.lex_state = 145},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 135},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 133},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 133},
  [1243] = {.lex_state = 133},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 133},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 133},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 133},
  [1259] = {.lex_state = 133},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1206),
    [sym__statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__expression_seq] = STATE(4),
    [sym_try] = STATE(459),
    [sym__expression] = STATE(47),
    [sym_binary_expression] = STATE(47),
    [sym__expression_unit] = STATE(47),
    [sym_record] = STATE(28),
    [sym_todo] = STATE(47),
    [sym_tuple] = STATE(29),
    [sym_list] = STATE(47),
    [sym__expression_bit_string] = STATE(47),
    [sym_anonymous_function] = STATE(30),
    [sym_expression_group] = STATE(20),
    [sym_case] = STATE(20),
    [sym_let] = STATE(47),
    [sym_assert] = STATE(47),
    [sym_record_update] = STATE(28),
    [sym__maybe_tuple_expression] = STATE(1204),
    [sym_tuple_access] = STATE(20),
    [sym__maybe_record_expression] = STATE(1203),
    [sym_field_access] = STATE(20),
    [sym__maybe_function_expression] = STATE(1103),
    [sym_function_call] = STATE(20),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(47),
    [sym_integer] = STATE(47),
    [sym_identifier] = STATE(17),
    [sym_type_identifier] = STATE(6),
    [sym_remote_type_identifier] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_const] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_external] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_case] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [sym_visibility_modifier] = ACTIONS(41),
    [sym_opacity_modifier] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_float] = ACTIONS(47),
    [sym__hex] = ACTIONS(49),
    [sym__decimal] = ACTIONS(51),
    [sym__octal] = ACTIONS(49),
    [sym__binary] = ACTIONS(49),
    [sym__name] = ACTIONS(53),
    [sym__upname] = ACTIONS(55),
  },
  [2] = {
    [sym__statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__expression_seq] = STATE(4),
    [sym_try] = STATE(459),
    [sym__expression] = STATE(47),
    [sym_binary_expression] = STATE(47),
    [sym__expression_unit] = STATE(47),
    [sym_record] = STATE(28),
    [sym_todo] = STATE(47),
    [sym_tuple] = STATE(29),
    [sym_list] = STATE(47),
    [sym__expression_bit_string] = STATE(47),
    [sym_anonymous_function] = STATE(30),
    [sym_expression_group] = STATE(20),
    [sym_case] = STATE(20),
    [sym_let] = STATE(47),
    [sym_assert] = STATE(47),
    [sym_record_update] = STATE(28),
    [sym__maybe_tuple_expression] = STATE(1204),
    [sym_tuple_access] = STATE(20),
    [sym__maybe_record_expression] = STATE(1203),
    [sym_field_access] = STATE(20),
    [sym__maybe_function_expression] = STATE(1103),
    [sym_function_call] = STATE(20),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(47),
    [sym_integer] = STATE(47),
    [sym_identifier] = STATE(17),
    [sym_type_identifier] = STATE(6),
    [sym_remote_type_identifier] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(57),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(62),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_const] = ACTIONS(68),
    [anon_sym_POUND] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(74),
    [anon_sym_LT_LT] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(80),
    [anon_sym_external] = ACTIONS(83),
    [anon_sym_type] = ACTIONS(86),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(92),
    [anon_sym_todo] = ACTIONS(95),
    [anon_sym_case] = ACTIONS(98),
    [anon_sym_let] = ACTIONS(101),
    [anon_sym_assert] = ACTIONS(104),
    [sym_visibility_modifier] = ACTIONS(107),
    [sym_opacity_modifier] = ACTIONS(110),
    [anon_sym_DQUOTE] = ACTIONS(113),
    [sym_float] = ACTIONS(116),
    [sym__hex] = ACTIONS(119),
    [sym__decimal] = ACTIONS(122),
    [sym__octal] = ACTIONS(119),
    [sym__binary] = ACTIONS(119),
    [sym__name] = ACTIONS(125),
    [sym__upname] = ACTIONS(128),
  },
  [3] = {
    [sym__statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__expression_seq] = STATE(4),
    [sym_try] = STATE(459),
    [sym__expression] = STATE(47),
    [sym_binary_expression] = STATE(47),
    [sym__expression_unit] = STATE(47),
    [sym_record] = STATE(28),
    [sym_todo] = STATE(47),
    [sym_tuple] = STATE(29),
    [sym_list] = STATE(47),
    [sym__expression_bit_string] = STATE(47),
    [sym_anonymous_function] = STATE(30),
    [sym_expression_group] = STATE(20),
    [sym_case] = STATE(20),
    [sym_let] = STATE(47),
    [sym_assert] = STATE(47),
    [sym_record_update] = STATE(28),
    [sym__maybe_tuple_expression] = STATE(1204),
    [sym_tuple_access] = STATE(20),
    [sym__maybe_record_expression] = STATE(1203),
    [sym_field_access] = STATE(20),
    [sym__maybe_function_expression] = STATE(1103),
    [sym_function_call] = STATE(20),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(47),
    [sym_integer] = STATE(47),
    [sym_identifier] = STATE(17),
    [sym_type_identifier] = STATE(6),
    [sym_remote_type_identifier] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(131),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_const] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_external] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_case] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [sym_visibility_modifier] = ACTIONS(41),
    [sym_opacity_modifier] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_float] = ACTIONS(47),
    [sym__hex] = ACTIONS(49),
    [sym__decimal] = ACTIONS(51),
    [sym__octal] = ACTIONS(49),
    [sym__binary] = ACTIONS(49),
    [sym__name] = ACTIONS(53),
    [sym__upname] = ACTIONS(55),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(133), 1,
      ts_builtin_sym_end,
    ACTIONS(137), 1,
      anon_sym_LBRACE,
    ACTIONS(140), 1,
      anon_sym_POUND,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(146), 1,
      anon_sym_LT_LT,
    ACTIONS(149), 1,
      anon_sym_DASH,
    ACTIONS(152), 1,
      anon_sym_fn,
    ACTIONS(155), 1,
      anon_sym_try,
    ACTIONS(158), 1,
      anon_sym_todo,
    ACTIONS(161), 1,
      anon_sym_case,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(167), 1,
      anon_sym_assert,
    ACTIONS(170), 1,
      anon_sym_DQUOTE,
    ACTIONS(173), 1,
      sym_float,
    ACTIONS(179), 1,
      sym__decimal,
    ACTIONS(182), 1,
      sym__name,
    ACTIONS(185), 1,
      sym__upname,
    STATE(5), 1,
      aux_sym__expression_seq,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(459), 1,
      sym_try,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(176), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    ACTIONS(135), 7,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      sym_visibility_modifier,
      sym_opacity_modifier,
    STATE(47), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [124] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(188), 1,
      ts_builtin_sym_end,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(195), 1,
      anon_sym_POUND,
    ACTIONS(198), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LT_LT,
    ACTIONS(204), 1,
      anon_sym_DASH,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(210), 1,
      anon_sym_try,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(216), 1,
      anon_sym_case,
    ACTIONS(219), 1,
      anon_sym_let,
    ACTIONS(222), 1,
      anon_sym_assert,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(228), 1,
      sym_float,
    ACTIONS(234), 1,
      sym__decimal,
    ACTIONS(237), 1,
      sym__name,
    ACTIONS(240), 1,
      sym__upname,
    STATE(5), 1,
      aux_sym__expression_seq,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(459), 1,
      sym_try,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(231), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    ACTIONS(190), 7,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      sym_visibility_modifier,
      sym_opacity_modifier,
    STATE(47), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [248] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(247), 1,
      anon_sym_LPAREN,
    STATE(32), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(245), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(243), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [315] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(251), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(249), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [377] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(255), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(253), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [439] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(259), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(257), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [501] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(263), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(261), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [563] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(267), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(265), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [625] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(271), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(269), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [687] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(273), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [749] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(279), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(277), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [811] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(283), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(281), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [873] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(287), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(285), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [935] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(289), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1001] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(301), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(299), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1063] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(305), 18,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(303), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1125] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(289), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1191] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(312), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(310), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1253] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(305), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(303), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1315] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(316), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(314), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1377] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(320), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(318), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1439] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(324), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(322), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1500] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(330), 1,
      anon_sym_RPAREN,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(342), 1,
      anon_sym_DOT_DOT,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(951), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [1621] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(366), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(364), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1682] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(289), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1745] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(370), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(289), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1808] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(289), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1871] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(372), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1932] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(376), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1993] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(380), 1,
      anon_sym_RPAREN,
    ACTIONS(382), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(925), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [2114] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(384), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2175] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(388), 1,
      anon_sym_RPAREN,
    ACTIONS(390), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(926), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [2296] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(316), 17,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(314), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2357] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(394), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(392), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2418] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(400), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(398), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(396), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2481] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(402), 1,
      anon_sym_RPAREN,
    ACTIONS(404), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1001), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [2602] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(408), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(406), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2663] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(412), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(410), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2724] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(320), 17,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(318), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2785] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(414), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [2903] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(312), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(310), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2963] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(418), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(416), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3023] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(420), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [3141] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(432), 1,
      anon_sym_AMP_AMP,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(422), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(424), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [3221] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(448), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(446), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3281] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(432), 1,
      anon_sym_AMP_AMP,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(450), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(452), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [3361] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(454), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3429] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(454), 19,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(456), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [3499] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(456), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [3573] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(456), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [3649] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(458), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [3767] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(462), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(460), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3827] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(432), 1,
      anon_sym_AMP_AMP,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(456), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [3905] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 21,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(454), 22,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3969] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(456), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(454), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4029] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(466), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(464), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4089] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(470), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(468), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4149] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(474), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(472), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4209] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(432), 1,
      anon_sym_AMP_AMP,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(476), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(478), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [4289] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(480), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4349] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(484), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4409] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(488), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [4527] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(432), 1,
      anon_sym_AMP_AMP,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(490), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(492), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [4607] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(494), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [4725] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(388), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(926), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [4843] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(496), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4903] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [5021] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(330), 1,
      anon_sym_RPAREN,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(951), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [5139] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(432), 1,
      anon_sym_AMP_AMP,
    ACTIONS(440), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(426), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(428), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(434), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(444), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(438), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(502), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(504), 15,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5219] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(380), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(925), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [5337] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(273), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(506), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5457] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(512), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(510), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5517] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(402), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1001), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [5635] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(514), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5695] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(518), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [5813] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(522), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(520), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5873] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(524), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5933] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(528), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6051] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(530), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6111] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(534), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6171] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(540), 1,
      anon_sym_RBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6286] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(574), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6401] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(576), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6516] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(578), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6631] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(580), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6746] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_LPAREN,
    STATE(143), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(245), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(243), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6809] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [6924] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(586), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7039] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(588), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7154] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(188), 1,
      anon_sym_RBRACE,
    ACTIONS(590), 1,
      anon_sym_LBRACE,
    ACTIONS(593), 1,
      anon_sym_POUND,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(599), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(605), 1,
      anon_sym_fn,
    ACTIONS(608), 1,
      anon_sym_try,
    ACTIONS(611), 1,
      anon_sym_todo,
    ACTIONS(614), 1,
      anon_sym_case,
    ACTIONS(617), 1,
      anon_sym_let,
    ACTIONS(620), 1,
      anon_sym_assert,
    ACTIONS(623), 1,
      anon_sym_DQUOTE,
    ACTIONS(626), 1,
      sym_float,
    ACTIONS(632), 1,
      sym__decimal,
    ACTIONS(635), 1,
      sym__name,
    ACTIONS(638), 1,
      sym__upname,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(629), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7269] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      sym_float,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_argument,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1148), 1,
      sym_hole,
    STATE(1154), 1,
      sym_label,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7384] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(641), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7499] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(643), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7614] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7729] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(647), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7844] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(649), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [7959] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(651), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8074] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(653), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8189] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8304] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(657), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8419] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(659), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8534] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(661), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8649] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(663), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8764] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(97), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [8876] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(271), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(269), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8934] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(105), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9046] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(85), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9158] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(100), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9270] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(301), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(299), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9328] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(98), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9440] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(263), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(261), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9498] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(96), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9610] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(86), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9722] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(259), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(257), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9780] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(101), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [9892] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(99), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10004] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(102), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10116] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(88), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10228] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(103), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10340] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(91), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10452] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(104), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10564] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(107), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10676] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(87), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10788] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(93), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [10900] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(89), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [11012] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(92), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [11124] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(289), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11186] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(552), 1,
      anon_sym_try,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_float,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    STATE(106), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(616), 1,
      sym_try,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [11298] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(289), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(287), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(285), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11418] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(283), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(281), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11476] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(251), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(249), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11534] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(255), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(253), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11592] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(470), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(468), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11650] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(279), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(277), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11708] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(514), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11766] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(267), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(265), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11824] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(289), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11883] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(376), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11940] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(669), 1,
      anon_sym_RBRACK,
    ACTIONS(671), 1,
      anon_sym_DOT_DOT,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [12049] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(358), 1,
      sym__discard_name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(677), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1083), 1,
      sym_hole,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(573), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [12158] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(394), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(392), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12215] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(679), 1,
      anon_sym_RBRACK,
    ACTIONS(681), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [12324] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(384), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12381] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(408), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(406), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12438] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(683), 1,
      anon_sym_RBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [12547] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(366), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(364), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12604] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(687), 1,
      anon_sym_RBRACK,
    ACTIONS(689), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [12713] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(289), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12772] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(691), 1,
      anon_sym_RBRACK,
    ACTIONS(693), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [12881] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(324), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(322), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12938] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(412), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(410), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12995] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(695), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(398), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(396), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13054] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(697), 1,
      anon_sym_RBRACK,
    ACTIONS(699), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13163] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(372), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13220] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(370), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(289), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13279] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(701), 1,
      anon_sym_RBRACK,
    ACTIONS(703), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13388] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(705), 1,
      anon_sym_RBRACK,
    ACTIONS(707), 1,
      anon_sym_DOT_DOT,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13497] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(709), 1,
      anon_sym_RPAREN,
    ACTIONS(711), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(541), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13603] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(522), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(520), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13659] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(713), 1,
      anon_sym_RPAREN,
    ACTIONS(715), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(556), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13765] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(717), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13871] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(719), 1,
      anon_sym_RBRACK,
    ACTIONS(721), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(532), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [13977] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(723), 1,
      anon_sym_RPAREN,
    ACTIONS(725), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(558), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14083] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(727), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1184), 1,
      sym_case_subjects,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(540), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14189] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(727), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    STATE(1223), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(540), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14295] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(729), 1,
      anon_sym_RBRACK,
    ACTIONS(731), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(514), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14401] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(727), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    STATE(1234), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(540), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14507] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(530), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14563] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(733), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14669] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(480), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14725] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(496), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14781] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(735), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [14887] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(534), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14943] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(727), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    STATE(1238), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(540), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [15049] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(418), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(416), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15105] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(484), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15161] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(466), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(464), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15217] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(737), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [15323] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(474), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(472), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15379] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(739), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [15485] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(741), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [15591] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(743), 1,
      anon_sym_RBRACK,
    ACTIONS(745), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(517), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [15697] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(448), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(446), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15753] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(524), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15809] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(512), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(510), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15865] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(462), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(460), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15921] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(506), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15977] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(747), 1,
      anon_sym_RBRACK,
    ACTIONS(749), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(530), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16083] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(751), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16189] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(753), 1,
      anon_sym_RPAREN,
    ACTIONS(755), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(536), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16295] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(757), 1,
      anon_sym_RPAREN,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16401] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(761), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(51), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16504] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(763), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(72), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16607] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(787), 1,
      sym_float,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(333), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16710] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(797), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(331), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16813] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(799), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(330), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [16916] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(801), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(327), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17019] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(803), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(336), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17122] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(805), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(577), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17225] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(807), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(598), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17328] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(809), 1,
      anon_sym_GT_GT,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(913), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17435] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(817), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(588), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17538] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(819), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(597), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17641] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(821), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(585), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17744] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(823), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17847] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(825), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(604), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [17950] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(827), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(579), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18053] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(829), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(589), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18156] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(831), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(600), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18259] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(833), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18366] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(835), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(406), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18469] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(837), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(593), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18572] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(839), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(583), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18675] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(841), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(424), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18778] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(843), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(408), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18881] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(845), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(407), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [18984] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(847), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(404), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19087] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(849), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(402), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19190] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(851), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(401), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19293] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(853), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(400), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19396] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(855), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(410), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19499] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(857), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(328), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19602] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(859), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19709] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(861), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19816] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(863), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(937), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [19923] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(865), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20030] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(867), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20137] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(869), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(58), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20240] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(871), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(340), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20343] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(873), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(342), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20446] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(875), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(57), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20549] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(877), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(56), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20652] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(879), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20755] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(881), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(53), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20858] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(883), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(52), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [20961] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(885), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(50), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21064] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(887), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(968), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21171] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(889), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21274] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(891), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(580), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21377] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(893), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21484] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(895), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21591] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(897), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(581), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21694] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(899), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21801] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    ACTIONS(901), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(975), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [21908] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(903), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(285), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22011] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(905), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(586), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22114] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22217] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(907), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(286), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22320] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(909), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(602), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22423] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(326), 1,
      anon_sym_LBRACE,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(911), 1,
      sym_float,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(592), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22526] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(913), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(276), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22629] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(915), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(62), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22732] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(917), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(275), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22835] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(919), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(273), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [22938] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(921), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(274), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23041] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(923), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(277), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23144] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(925), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(278), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23247] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(927), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(280), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23350] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(929), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23453] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(931), 1,
      anon_sym_LBRACE,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23556] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(328), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    ACTIONS(334), 1,
      anon_sym_LT_LT,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(338), 1,
      anon_sym_fn,
    ACTIONS(340), 1,
      anon_sym_todo,
    ACTIONS(344), 1,
      anon_sym_case,
    ACTIONS(346), 1,
      anon_sym_let,
    ACTIONS(348), 1,
      anon_sym_assert,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(673), 1,
      sym_float,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(934), 1,
      anon_sym_LBRACE,
    STATE(357), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1086), 1,
      sym__maybe_function_expression,
    STATE(1201), 1,
      sym__maybe_record_expression,
    STATE(1217), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(349), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(379), 2,
      sym_record,
      sym_record_update,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(448), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23659] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(937), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(289), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23762] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(558), 1,
      anon_sym_let,
    ACTIONS(560), 1,
      anon_sym_assert,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(939), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(288), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23865] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(941), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(326), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [23968] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(765), 1,
      anon_sym_LBRACE,
    ACTIONS(767), 1,
      anon_sym_POUND,
    ACTIONS(769), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      anon_sym_LT_LT,
    ACTIONS(773), 1,
      anon_sym_DASH,
    ACTIONS(775), 1,
      anon_sym_fn,
    ACTIONS(777), 1,
      anon_sym_todo,
    ACTIONS(779), 1,
      anon_sym_case,
    ACTIONS(781), 1,
      anon_sym_let,
    ACTIONS(783), 1,
      anon_sym_assert,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      sym__decimal,
    ACTIONS(793), 1,
      sym__name,
    ACTIONS(795), 1,
      sym__upname,
    ACTIONS(943), 1,
      sym_float,
    STATE(299), 1,
      sym_identifier,
    STATE(310), 1,
      sym_anonymous_function,
    STATE(317), 1,
      sym_tuple,
    STATE(1129), 1,
      sym__maybe_function_expression,
    STATE(1173), 1,
      sym__maybe_tuple_expression,
    STATE(1212), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(292), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(311), 2,
      sym_record,
      sym_record_update,
    ACTIONS(789), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(301), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [24071] = 28,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(53), 1,
      sym__name,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(759), 1,
      anon_sym_fn,
    ACTIONS(945), 1,
      sym_float,
    STATE(17), 1,
      sym_identifier,
    STATE(29), 1,
      sym_tuple,
    STATE(30), 1,
      sym_anonymous_function,
    STATE(1103), 1,
      sym__maybe_function_expression,
    STATE(1203), 1,
      sym__maybe_record_expression,
    STATE(1204), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(28), 2,
      sym_record,
      sym_record_update,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(20), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(66), 10,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [24174] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(538), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_LT_LT,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(550), 1,
      anon_sym_fn,
    ACTIONS(554), 1,
      anon_sym_todo,
    ACTIONS(556), 1,
      anon_sym_case,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(811), 1,
      anon_sym_let,
    ACTIONS(813), 1,
      anon_sym_assert,
    ACTIONS(815), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(142), 1,
      sym_anonymous_function,
    STATE(160), 1,
      sym_tuple,
    STATE(1066), 1,
      sym_expression_bit_string_segment,
    STATE(1089), 1,
      sym__maybe_function_expression,
    STATE(1171), 1,
      sym__maybe_record_expression,
    STATE(1215), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(90), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(131), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 8,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_string,
      sym_integer,
  [24278] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(951), 1,
      anon_sym_AMP_AMP,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(456), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24349] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(456), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24418] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 14,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24475] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(456), 16,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 25,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24528] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(456), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24595] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 12,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24658] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(320), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(318), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [24711] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 12,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(454), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24772] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(273), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [24825] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(316), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(314), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [24878] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(305), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(303), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [24931] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(312), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(310), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [24984] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(951), 1,
      anon_sym_AMP_AMP,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(965), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(504), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(502), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25057] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(951), 1,
      anon_sym_AMP_AMP,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(965), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(478), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(476), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25130] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(951), 1,
      anon_sym_AMP_AMP,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(965), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(424), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(422), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25203] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(951), 1,
      anon_sym_AMP_AMP,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(965), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(492), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(490), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25276] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(951), 1,
      anon_sym_AMP_AMP,
    ACTIONS(959), 1,
      anon_sym_PIPE_GT,
    ACTIONS(965), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(947), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(949), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(953), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(961), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(963), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(957), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(452), 8,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(450), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25349] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(470), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(468), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [25400] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(514), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [25451] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(967), 1,
      anon_sym_LPAREN,
    STATE(319), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(245), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(243), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25505] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(283), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(281), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25554] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(320), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(318), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25603] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(251), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(249), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25652] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(271), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(269), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25701] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(263), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(261), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25750] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(287), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(285), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25799] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(969), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(289), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25852] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(301), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(299), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25901] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(289), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25954] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(279), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(277), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26003] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(267), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(265), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26052] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(312), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(310), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26101] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(305), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(303), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26150] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(316), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(314), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26199] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(255), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(253), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26248] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(273), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26297] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(259), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(257), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26346] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(289), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26396] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(289), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26446] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(973), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(398), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(396), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26496] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(412), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(410), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26544] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(372), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26592] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(324), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(322), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26640] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(366), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(364), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26688] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(370), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(289), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26738] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(394), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(392), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26786] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(376), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26834] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(384), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26882] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(408), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(406), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26930] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(480), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26977] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(484), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27024] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(506), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27071] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(418), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(416), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27118] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(979), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(981), 1,
      anon_sym_AMP_AMP,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(983), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(504), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(502), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27185] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(456), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(454), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27232] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(979), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(981), 1,
      anon_sym_AMP_AMP,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(983), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(997), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(995), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27299] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(496), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27346] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 9,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(454), 21,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27397] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(981), 1,
      anon_sym_AMP_AMP,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(983), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(456), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 11,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27462] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(979), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(981), 1,
      anon_sym_AMP_AMP,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(983), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(492), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(490), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27529] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(983), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(456), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 12,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27592] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(524), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27639] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(462), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(460), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27686] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(979), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(981), 1,
      anon_sym_AMP_AMP,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(983), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1001), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(999), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27753] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(522), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(520), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27800] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(534), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27847] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(456), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(985), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(987), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 14,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27908] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(989), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(454), 18,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27965] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(530), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28012] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(975), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(977), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(991), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(993), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(454), 19,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28067] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(470), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(468), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28114] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(514), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28161] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(512), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(510), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28208] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(448), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(446), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28255] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(466), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(464), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28302] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(474), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(472), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28349] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1003), 1,
      anon_sym_LPAREN,
    STATE(385), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(245), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(243), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28397] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1009), 1,
      anon_sym_size,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1005), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(908), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [28454] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(283), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(281), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28497] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(267), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(265), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28540] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(279), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(277), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28583] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1019), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1017), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(988), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [28640] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(301), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(299), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28683] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1025), 1,
      anon_sym_SLASH,
    STATE(369), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1021), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1023), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [28730] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(1027), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(289), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28777] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(263), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(261), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28820] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1019), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1031), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(988), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [28877] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(259), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(257), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28920] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(1033), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(289), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [28967] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1009), 1,
      anon_sym_size,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1036), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(908), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [29024] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1040), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1038), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(991), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [29081] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(255), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(253), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29124] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(251), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(249), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29167] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(271), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(269), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29210] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1040), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1042), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(991), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [29267] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1025), 1,
      anon_sym_SLASH,
    STATE(356), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1044), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1046), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [29314] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1052), 1,
      anon_sym_SLASH,
    STATE(369), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1048), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1050), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [29361] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(287), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(285), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29404] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1019), 1,
      anon_sym_size,
    STATE(1049), 1,
      sym_pattern_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(874), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [29460] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(372), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29502] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1048), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1050), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [29544] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(394), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(392), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29586] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(384), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29628] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(412), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(410), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29670] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1040), 1,
      anon_sym_size,
    STATE(1107), 1,
      sym_constant_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(868), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [29726] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1055), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(398), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(396), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29770] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1057), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(289), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29814] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1059), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(289), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29858] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(291), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(289), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29902] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1009), 1,
      anon_sym_size,
    ACTIONS(1015), 1,
      anon_sym_unit,
    STATE(1085), 1,
      sym_expression_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(864), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [29958] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(324), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(322), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30000] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(366), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(364), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30042] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(376), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30084] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(408), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(406), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30126] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    STATE(494), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1061), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1063), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [30171] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(418), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(416), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30212] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(462), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(460), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30253] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(506), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30294] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(448), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(446), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30335] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1069), 1,
      anon_sym_RPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1075), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(927), 1,
      sym__pattern,
    STATE(929), 1,
      sym_record_pattern_argument,
    STATE(1158), 1,
      sym_label,
    STATE(1237), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [30412] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(530), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30453] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(524), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30494] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(474), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(472), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30535] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1009), 1,
      anon_sym_size,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(908), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30588] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(466), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(464), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30629] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(881), 1,
      sym_case_clause_pattern,
    STATE(935), 1,
      sym_case_clause_patterns,
    STATE(1153), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(413), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [30704] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(512), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(510), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30745] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
    ACTIONS(454), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DOT_DOT,
  [30790] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 8,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_DOT,
  [30847] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DOT_DOT,
  [30902] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1113), 1,
      anon_sym_RBRACE,
    ACTIONS(1115), 1,
      anon_sym_POUND,
    ACTIONS(1118), 1,
      anon_sym_LBRACK,
    ACTIONS(1121), 1,
      anon_sym_LT_LT,
    ACTIONS(1124), 1,
      anon_sym_DASH,
    ACTIONS(1127), 1,
      anon_sym_DQUOTE,
    ACTIONS(1130), 1,
      sym_float,
    ACTIONS(1136), 1,
      sym__decimal,
    ACTIONS(1139), 1,
      sym__discard_name,
    ACTIONS(1142), 1,
      sym__name,
    ACTIONS(1145), 1,
      sym__upname,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(881), 1,
      sym_case_clause_pattern,
    STATE(935), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1133), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [30977] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(454), 11,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DOT_DOT,
  [31030] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1152), 1,
      anon_sym_LPAREN,
    STATE(469), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1148), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1150), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31075] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(502), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DOT_DOT,
  [31134] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(454), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DOT_DOT,
  [31185] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(456), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(454), 16,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DOT_DOT,
  [31234] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(496), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31275] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(456), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(454), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31316] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(881), 1,
      sym_case_clause_pattern,
    STATE(935), 1,
      sym_case_clause_patterns,
    STATE(1255), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(413), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31391] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(881), 1,
      sym_case_clause_pattern,
    STATE(935), 1,
      sym_case_clause_patterns,
    STATE(1190), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(413), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31466] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1156), 1,
      anon_sym_RBRACE,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(881), 1,
      sym_case_clause_pattern,
    STATE(935), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31541] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(881), 1,
      sym_case_clause_pattern,
    STATE(935), 1,
      sym_case_clause_patterns,
    STATE(1208), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(413), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31616] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(249), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(305), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(303), 19,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31659] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1075), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1158), 1,
      anon_sym_RPAREN,
    STATE(764), 1,
      sym_identifier,
    STATE(822), 1,
      sym_record_pattern_argument,
    STATE(927), 1,
      sym__pattern,
    STATE(1155), 1,
      sym_pattern_spread,
    STATE(1158), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31736] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(484), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31777] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym_type_parameters,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1162), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31822] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1075), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1166), 1,
      anon_sym_RPAREN,
    STATE(764), 1,
      sym_identifier,
    STATE(927), 1,
      sym__pattern,
    STATE(929), 1,
      sym_record_pattern_argument,
    STATE(1158), 1,
      sym_label,
    STATE(1159), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31899] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1172), 1,
      anon_sym_DOT,
    ACTIONS(1174), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1168), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1170), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31944] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1040), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(991), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [31997] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(480), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32038] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(1007), 1,
      anon_sym_DASH,
    ACTIONS(1015), 1,
      anon_sym_unit,
    ACTIONS(1019), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1013), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(988), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1011), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [32091] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(490), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DOT_DOT,
  [32150] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(534), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32191] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(522), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(520), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32232] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1176), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1178), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32272] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1182), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32312] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1184), 1,
      anon_sym_LPAREN,
    STATE(527), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1150), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1148), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [32356] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1190), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1186), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1188), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32398] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1192), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1194), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32438] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1196), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1198), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32478] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(303), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1200), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1202), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32520] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1204), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1206), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32559] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1208), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1210), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32598] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1212), 1,
      anon_sym_RBRACK,
    ACTIONS(1214), 1,
      anon_sym_DOT_DOT,
    STATE(764), 1,
      sym_identifier,
    STATE(791), 1,
      sym__pattern,
    STATE(1157), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [32669] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1224), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(661), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(691), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [32736] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_if,
    ACTIONS(1228), 1,
      anon_sym_DASH_GT,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(933), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [32807] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1230), 1,
      anon_sym_if,
    STATE(791), 1,
      sym__pattern,
    STATE(803), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [32876] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1234), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1236), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32915] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1238), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1240), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32954] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1242), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1244), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32993] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1246), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1248), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33032] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1250), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1252), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33071] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1256), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33110] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1258), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1260), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33149] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1262), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1264), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33188] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1266), 5,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [33245] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1268), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1270), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33284] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1272), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1274), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33323] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1276), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1278), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33362] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1280), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1282), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33401] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1284), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1286), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33440] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1214), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1288), 1,
      anon_sym_RBRACK,
    STATE(764), 1,
      sym_identifier,
    STATE(791), 1,
      sym__pattern,
    STATE(1257), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [33511] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1290), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1292), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33550] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1294), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1296), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33589] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1214), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1298), 1,
      anon_sym_RBRACK,
    STATE(764), 1,
      sym_identifier,
    STATE(836), 1,
      sym__pattern,
    STATE(1189), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [33660] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1300), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1302), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33699] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(422), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(424), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33738] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1304), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1306), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33777] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1308), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1310), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33816] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1312), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1314), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33855] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1316), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1318), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33894] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1320), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1322), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33933] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1324), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1326), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33972] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1328), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1330), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34011] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1332), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1334), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34050] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1336), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1338), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34089] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1340), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1342), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34128] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1344), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1346), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34167] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1348), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1350), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34206] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1352), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1354), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34245] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1356), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1358), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34284] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1360), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1362), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34323] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1364), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(659), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(688), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [34390] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1366), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1368), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34429] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1370), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1372), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34468] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1374), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1376), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34507] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1378), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1380), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34546] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1382), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1384), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34585] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1386), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1388), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34624] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1390), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1392), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34663] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1394), 1,
      anon_sym_if,
    ACTIONS(1396), 1,
      anon_sym_DASH_GT,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(933), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [34734] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1398), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1400), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34773] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1402), 1,
      anon_sym_if,
    STATE(791), 1,
      sym__pattern,
    STATE(803), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1404), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [34842] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1406), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1408), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34881] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1410), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1412), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34920] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1414), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1416), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34959] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1418), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1420), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34998] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1422), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1424), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35037] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1426), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1428), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35076] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1430), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1432), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35115] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1434), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1436), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35154] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1438), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1440), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35193] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1442), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1444), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35232] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1446), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(661), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(674), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35299] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1448), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(661), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(698), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35366] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1450), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(661), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(697), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35433] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1452), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(661), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(696), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35500] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1454), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(659), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35567] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1456), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1458), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35606] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1460), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1462), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35645] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1464), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1466), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35684] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1468), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1470), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35723] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1446), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(659), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(674), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35790] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1472), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1474), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35829] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1476), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(659), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(694), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35896] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1478), 1,
      sym_float,
    STATE(655), 1,
      sym__case_clause_tuple_access,
    STATE(659), 1,
      sym_identifier,
    STATE(686), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(690), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [35963] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1480), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1482), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36002] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1270), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1268), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36040] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1376), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1374), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36078] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1380), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1378), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36116] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(927), 1,
      sym__pattern,
    STATE(929), 1,
      sym_record_pattern_argument,
    STATE(1158), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36184] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1484), 1,
      anon_sym_COMMA,
    ACTIONS(1486), 1,
      anon_sym_RBRACK,
    ACTIONS(1488), 1,
      anon_sym_DOT_DOT,
    STATE(880), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [36246] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1412), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1410), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36284] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1490), 1,
      anon_sym_GT_GT,
    STATE(764), 1,
      sym_identifier,
    STATE(947), 1,
      sym__pattern,
    STATE(1050), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36352] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1492), 1,
      anon_sym_COMMA,
    ACTIONS(1494), 1,
      anon_sym_RBRACK,
    ACTIONS(1496), 1,
      anon_sym_DOT_DOT,
    STATE(885), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [36414] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1420), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1418), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36452] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1424), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1422), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36490] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1498), 1,
      anon_sym_GT_GT,
    STATE(764), 1,
      sym_identifier,
    STATE(947), 1,
      sym__pattern,
    STATE(1050), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36558] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1428), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1426), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36596] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1482), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1480), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36634] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1334), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1332), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36672] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1338), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1336), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36710] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1500), 1,
      anon_sym_GT_GT,
    STATE(764), 1,
      sym_identifier,
    STATE(946), 1,
      sym_pattern_bit_string_segment,
    STATE(947), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36778] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1462), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1460), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36816] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1342), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1340), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36854] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1474), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1472), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36892] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1262), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [36930] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1502), 1,
      anon_sym_COMMA,
    ACTIONS(1504), 1,
      anon_sym_RBRACK,
    ACTIONS(1506), 1,
      anon_sym_DOT_DOT,
    STATE(866), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [36992] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1302), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1300), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37030] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1508), 1,
      anon_sym_COMMA,
    ACTIONS(1510), 1,
      anon_sym_RBRACK,
    ACTIONS(1512), 1,
      anon_sym_DOT_DOT,
    STATE(855), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [37092] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1310), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1308), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37130] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1470), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1468), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37168] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(393), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(966), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37233] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1514), 1,
      anon_sym_COMMA,
    ACTIONS(1516), 1,
      anon_sym_RPAREN,
    STATE(950), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [37292] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(173), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(980), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37357] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1518), 1,
      anon_sym_RPAREN,
    ACTIONS(1520), 1,
      sym_float,
    STATE(1056), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [37422] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1522), 1,
      anon_sym_RPAREN,
    STATE(764), 1,
      sym_identifier,
    STATE(791), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37487] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1524), 1,
      anon_sym_LBRACE,
    ACTIONS(1526), 1,
      anon_sym_COMMA,
    STATE(939), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [37546] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1528), 1,
      anon_sym_COMMA,
    ACTIONS(1530), 1,
      anon_sym_RPAREN,
    STATE(1006), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [37605] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    ACTIONS(1532), 1,
      anon_sym_RPAREN,
    STATE(1056), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [37670] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(341), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(934), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37735] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(334), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(934), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37800] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(189), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(980), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37865] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    STATE(803), 1,
      sym_identifier,
    STATE(830), 1,
      sym__pattern,
    STATE(933), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37930] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(81), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(944), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37995] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(394), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(966), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38060] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    ACTIONS(1534), 1,
      anon_sym_RPAREN,
    STATE(1056), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38125] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    ACTIONS(1536), 1,
      anon_sym_RPAREN,
    STATE(897), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38190] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1538), 1,
      anon_sym_RPAREN,
    STATE(764), 1,
      sym_identifier,
    STATE(915), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38255] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    ACTIONS(1540), 1,
      anon_sym_RPAREN,
    STATE(1056), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38320] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(947), 1,
      sym__pattern,
    STATE(1050), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38385] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(83), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(944), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38450] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1542), 1,
      anon_sym_RPAREN,
    STATE(764), 1,
      sym_identifier,
    STATE(791), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38515] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1544), 1,
      anon_sym_COMMA,
    ACTIONS(1546), 1,
      anon_sym_RPAREN,
    STATE(901), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [38574] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    ACTIONS(1548), 1,
      anon_sym_RPAREN,
    STATE(888), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38639] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1550), 1,
      anon_sym_COMMA,
    ACTIONS(1552), 1,
      anon_sym_RPAREN,
    STATE(924), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [38698] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(173), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(966), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38763] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(189), 1,
      sym__assignment,
    STATE(764), 1,
      sym_identifier,
    STATE(966), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38828] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1554), 1,
      anon_sym_GT_GT,
    ACTIONS(1556), 1,
      sym_float,
    STATE(1100), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38890] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      sym_float,
    ACTIONS(1558), 1,
      anon_sym_GT_GT,
    STATE(963), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38952] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1560), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [39006] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(930), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39068] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      sym_float,
    ACTIONS(1562), 1,
      anon_sym_GT_GT,
    STATE(1100), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39130] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      sym_float,
    ACTIONS(1564), 1,
      anon_sym_GT_GT,
    STATE(1100), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39192] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1079), 1,
      sym__discard_name,
    ACTIONS(1081), 1,
      anon_sym_DASH,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      sym_float,
    ACTIONS(1089), 1,
      sym__decimal,
    ACTIONS(1091), 1,
      sym__name,
    ACTIONS(1093), 1,
      sym__upname,
    STATE(791), 1,
      sym__pattern,
    STATE(803), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(1087), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(838), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39254] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(978), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39316] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      sym_float,
    ACTIONS(1566), 1,
      anon_sym_GT_GT,
    STATE(1100), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39378] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1568), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [39432] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(791), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39494] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      sym_float,
    ACTIONS(1570), 1,
      anon_sym_GT_GT,
    STATE(1021), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39556] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1572), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [39610] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(675), 1,
      sym__name,
    ACTIONS(1067), 1,
      anon_sym_POUND,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_LT_LT,
    ACTIONS(1077), 1,
      sym_float,
    ACTIONS(1079), 1,
      sym__discard_name,
    STATE(764), 1,
      sym_identifier,
    STATE(1005), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(695), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(789), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39672] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(360), 1,
      sym__name,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    STATE(1056), 1,
      sym_constant_record_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1198), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39734] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1574), 1,
      anon_sym_RBRACK,
    ACTIONS(1576), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(960), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39793] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1578), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [39846] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1580), 1,
      anon_sym_RPAREN,
    ACTIONS(1582), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39905] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1584), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [39958] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1586), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40011] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1588), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40064] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1590), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40117] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1592), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40170] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1594), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40229] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1596), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40282] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1598), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40335] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1600), 1,
      anon_sym_RBRACK,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40394] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1602), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40447] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1604), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40500] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      sym_float,
    STATE(1100), 1,
      sym_constant_bit_string_segment,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(962), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40559] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1606), 1,
      anon_sym_RPAREN,
    ACTIONS(1608), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1027), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40618] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1610), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40671] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1612), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40724] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1614), 1,
      anon_sym_RBRACK,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40783] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1616), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40842] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1618), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40901] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1620), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40954] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1622), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41007] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1624), 1,
      anon_sym_RBRACK,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41066] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1626), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41119] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1628), 1,
      anon_sym_RPAREN,
    ACTIONS(1630), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(893), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41178] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1632), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41231] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    ACTIONS(1634), 1,
      anon_sym_RBRACK,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41290] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1101), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1154), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1636), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1095), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1099), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1103), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1111), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1097), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1105), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1107), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41343] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1638), 1,
      anon_sym_RBRACK,
    ACTIONS(1640), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1020), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41402] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1642), 1,
      sym_float,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(780), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41458] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1644), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1054), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41514] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1646), 1,
      anon_sym_POUND,
    ACTIONS(1648), 1,
      anon_sym_LBRACK,
    ACTIONS(1650), 1,
      anon_sym_LT_LT,
    ACTIONS(1652), 1,
      sym_float,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(405), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(486), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41570] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1646), 1,
      anon_sym_POUND,
    ACTIONS(1648), 1,
      anon_sym_LBRACK,
    ACTIONS(1650), 1,
      anon_sym_LT_LT,
    ACTIONS(1654), 1,
      sym_float,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(405), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(470), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41626] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1646), 1,
      anon_sym_POUND,
    ACTIONS(1648), 1,
      anon_sym_LBRACK,
    ACTIONS(1650), 1,
      anon_sym_LT_LT,
    ACTIONS(1656), 1,
      sym_float,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(405), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(451), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41682] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1658), 1,
      sym_float,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(779), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41738] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1660), 1,
      sym_float,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(771), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41794] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(568), 1,
      sym__decimal,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1582), 1,
      sym_float,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(566), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(943), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41850] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(336), 1,
      anon_sym_DASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    ACTIONS(356), 1,
      sym__decimal,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1218), 1,
      anon_sym_POUND,
    ACTIONS(1220), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_LT_LT,
    ACTIONS(1662), 1,
      sym_float,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(429), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(354), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(784), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41906] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(1646), 1,
      anon_sym_POUND,
    ACTIONS(1648), 1,
      anon_sym_LBRACK,
    ACTIONS(1650), 1,
      anon_sym_LT_LT,
    ACTIONS(1664), 1,
      sym_float,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(405), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    ACTIONS(49), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(441), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41962] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(424), 9,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(422), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [41994] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(305), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 13,
      anon_sym_if,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42024] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(316), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(314), 13,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42054] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(320), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(318), 13,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42084] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1668), 1,
      anon_sym_RPAREN,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1674), 1,
      sym__name,
    STATE(914), 1,
      sym_data_constructor_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1169), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1131), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42131] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(470), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(468), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42160] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1676), 1,
      anon_sym_RBRACE,
    ACTIONS(1678), 1,
      anon_sym_import,
    ACTIONS(1680), 1,
      anon_sym_const,
    ACTIONS(1682), 1,
      anon_sym_external,
    ACTIONS(1684), 1,
      anon_sym_type,
    ACTIONS(1686), 1,
      anon_sym_fn,
    ACTIONS(1688), 1,
      sym_visibility_modifier,
    ACTIONS(1690), 1,
      sym_opacity_modifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(626), 9,
      sym__statement,
      sym_import,
      sym_constant,
      sym_external_type,
      sym_external_function,
      sym_function,
      sym_type_definition,
      sym_type_alias,
      aux_sym_target_group_repeat1,
  [42203] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(312), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(310), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42232] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1674), 1,
      sym__name,
    ACTIONS(1692), 1,
      anon_sym_RPAREN,
    STATE(1041), 1,
      sym_data_constructor_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1169), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1131), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42279] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1678), 1,
      anon_sym_import,
    ACTIONS(1680), 1,
      anon_sym_const,
    ACTIONS(1682), 1,
      anon_sym_external,
    ACTIONS(1684), 1,
      anon_sym_type,
    ACTIONS(1686), 1,
      anon_sym_fn,
    ACTIONS(1688), 1,
      sym_visibility_modifier,
    ACTIONS(1690), 1,
      sym_opacity_modifier,
    ACTIONS(1694), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(622), 9,
      sym__statement,
      sym_import,
      sym_constant,
      sym_external_type,
      sym_external_function,
      sym_function,
      sym_type_definition,
      sym_type_alias,
      aux_sym_target_group_repeat1,
  [42322] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1696), 1,
      anon_sym_RBRACE,
    ACTIONS(1698), 1,
      anon_sym_import,
    ACTIONS(1701), 1,
      anon_sym_const,
    ACTIONS(1704), 1,
      anon_sym_external,
    ACTIONS(1707), 1,
      anon_sym_type,
    ACTIONS(1710), 1,
      anon_sym_fn,
    ACTIONS(1713), 1,
      sym_visibility_modifier,
    ACTIONS(1716), 1,
      sym_opacity_modifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(626), 9,
      sym__statement,
      sym_import,
      sym_constant,
      sym_external_type,
      sym_external_function,
      sym_function,
      sym_type_definition,
      sym_type_alias,
      aux_sym_target_group_repeat1,
  [42365] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1674), 1,
      sym__name,
    ACTIONS(1719), 1,
      anon_sym_RPAREN,
    STATE(1041), 1,
      sym_data_constructor_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1169), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1131), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42412] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(514), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42441] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(273), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42470] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1721), 1,
      anon_sym_RPAREN,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1039), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42514] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1725), 1,
      anon_sym_RPAREN,
    STATE(1015), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42558] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1727), 1,
      anon_sym_RPAREN,
    STATE(918), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42602] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1674), 1,
      sym__name,
    STATE(1041), 1,
      sym_data_constructor_argument,
    STATE(1156), 1,
      sym_identifier,
    STATE(1169), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1131), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42646] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1729), 1,
      anon_sym_RPAREN,
    STATE(967), 1,
      sym_external_function_parameter,
    STATE(1088), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1092), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42690] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1731), 1,
      anon_sym_RPAREN,
    STATE(1081), 1,
      sym_external_function_parameter,
    STATE(1088), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1092), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42734] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1733), 1,
      anon_sym_RPAREN,
    STATE(1081), 1,
      sym_external_function_parameter,
    STATE(1088), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1092), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42778] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1735), 1,
      anon_sym_RPAREN,
    STATE(1039), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42822] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1737), 1,
      anon_sym_RPAREN,
    STATE(1039), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42866] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1739), 1,
      anon_sym_RPAREN,
    STATE(1039), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42910] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1741), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(917), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42951] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1743), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [42992] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1745), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43033] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1747), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43074] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1749), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43115] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1751), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43156] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1753), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(916), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43197] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1039), 1,
      sym_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1134), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43238] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1081), 1,
      sym_external_function_parameter,
    STATE(1088), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1092), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43279] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1755), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1016), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43320] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1757), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43361] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1243), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43399] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(1759), 1,
      anon_sym_POUND,
    ACTIONS(1761), 1,
      anon_sym_fn,
    ACTIONS(1763), 1,
      sym__discard_name,
    ACTIONS(1765), 1,
      sym__name,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(387), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(443), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43437] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1040), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43475] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1235), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43513] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1769), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1767), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43539] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1177), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43577] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1773), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1771), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43603] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(303), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(1200), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [43629] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1777), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1779), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1775), 9,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43657] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(1759), 1,
      anon_sym_POUND,
    ACTIONS(1761), 1,
      anon_sym_fn,
    ACTIONS(1763), 1,
      sym__discard_name,
    ACTIONS(1765), 1,
      sym__name,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(387), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(444), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43695] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1781), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1779), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1775), 9,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43723] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(1759), 1,
      anon_sym_POUND,
    ACTIONS(1761), 1,
      anon_sym_fn,
    ACTIONS(1763), 1,
      sym__discard_name,
    ACTIONS(1765), 1,
      sym__name,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(387), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(442), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43761] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1783), 1,
      anon_sym_fn,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(709), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43799] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1239), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43837] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1232), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43875] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1230), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43913] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1783), 1,
      anon_sym_fn,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(702), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43951] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1785), 1,
      anon_sym_LPAREN,
    STATE(704), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1061), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [43979] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1783), 1,
      anon_sym_fn,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(769), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44017] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1783), 1,
      anon_sym_fn,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(770), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44055] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1226), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44093] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(709), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44131] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(983), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44169] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1789), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1787), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44195] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1793), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1791), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44221] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1035), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44259] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(1759), 1,
      anon_sym_POUND,
    ACTIONS(1761), 1,
      anon_sym_fn,
    ACTIONS(1763), 1,
      sym__discard_name,
    ACTIONS(1765), 1,
      sym__name,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(387), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(435), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44297] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(702), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44335] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1187), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44373] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1195), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44411] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1178), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44449] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1192), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44487] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1166), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44525] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(55), 1,
      sym__upname,
    ACTIONS(1759), 1,
      anon_sym_POUND,
    ACTIONS(1761), 1,
      anon_sym_fn,
    ACTIONS(1763), 1,
      sym__discard_name,
    ACTIONS(1765), 1,
      sym__name,
    STATE(1218), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(387), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(492), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44563] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(362), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    ACTIONS(1783), 1,
      anon_sym_fn,
    STATE(1213), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(781), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44601] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1797), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1795), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44627] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1666), 1,
      anon_sym_POUND,
    ACTIONS(1670), 1,
      anon_sym_fn,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1723), 1,
      sym__name,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(668), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1076), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44665] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1799), 1,
      anon_sym_RBRACE,
    ACTIONS(1801), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1803), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1805), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1807), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1809), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44698] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    ACTIONS(1813), 1,
      anon_sym_RPAREN,
    STATE(1042), 1,
      sym_constant_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1112), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [44737] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1807), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1809), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1787), 5,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [44764] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1815), 1,
      anon_sym_DASH_GT,
    ACTIONS(1817), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1819), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1821), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1823), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1825), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44797] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1805), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1787), 3,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1807), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1809), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44826] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    ACTIONS(1827), 1,
      anon_sym_RPAREN,
    STATE(905), 1,
      sym_constant_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1112), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [44865] = 7,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1803), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1787), 2,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
    ACTIONS(1805), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1807), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1809), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44896] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1831), 1,
      anon_sym_LPAREN,
    STATE(741), 1,
      sym_record_pattern_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1829), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [44923] = 7,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1819), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1787), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1821), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1823), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1825), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44954] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1821), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1787), 3,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1823), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1825), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44983] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1823), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1825), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1787), 5,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [45010] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    ACTIONS(1833), 1,
      anon_sym_RPAREN,
    STATE(1042), 1,
      sym_constant_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1112), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [45049] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1386), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45071] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    ACTIONS(1835), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1051), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [45107] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1250), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45129] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1390), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45151] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1438), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45173] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1258), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45195] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    STATE(1042), 1,
      sym_constant_type_argument,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1112), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [45231] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    ACTIONS(1837), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(902), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [45267] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1456), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45289] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1208), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45311] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1464), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45333] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1839), 1,
      anon_sym_LPAREN,
    STATE(754), 1,
      sym_type_parameters,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 10,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45359] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1316), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45381] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1841), 1,
      anon_sym_SLASH,
    STATE(715), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1044), 10,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45407] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1843), 1,
      anon_sym_SLASH,
    STATE(714), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1048), 10,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45433] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1841), 1,
      anon_sym_SLASH,
    STATE(714), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1021), 10,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45459] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1234), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45481] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1366), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45503] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1360), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45525] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    ACTIONS(1846), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1051), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [45561] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1848), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45582] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1850), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45603] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(570), 1,
      sym__name,
    ACTIONS(572), 1,
      sym__upname,
    ACTIONS(1672), 1,
      sym__discard_name,
    ACTIONS(1811), 1,
      anon_sym_POUND,
    STATE(1156), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(845), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1051), 4,
      sym__constant_type,
      sym_constant_tuple_type,
      sym_constant_type,
      sym_type_hole,
  [45636] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1852), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45657] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1050), 1,
      anon_sym_SLASH,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1048), 10,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45680] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1852), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45701] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1854), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45722] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1856), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45743] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1858), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45764] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1860), 1,
      anon_sym_RPAREN,
    ACTIONS(1862), 1,
      sym__discard_name,
    ACTIONS(1864), 1,
      sym__name,
    STATE(852), 1,
      sym_label,
    STATE(854), 1,
      sym__labeled_name_param,
    STATE(856), 1,
      sym__name_param,
    STATE(867), 1,
      sym__discard_param,
    STATE(884), 1,
      sym__labeled_discard_param,
    STATE(956), 1,
      sym_discard,
    STATE(959), 1,
      sym_identifier,
    STATE(973), 1,
      sym_function_parameter,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
  [45805] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1866), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45826] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1868), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45847] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1870), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45868] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1872), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45889] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1866), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45910] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1874), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45931] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1876), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [45952] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1862), 1,
      sym__discard_name,
    ACTIONS(1864), 1,
      sym__name,
    ACTIONS(1878), 1,
      anon_sym_RPAREN,
    STATE(852), 1,
      sym_label,
    STATE(854), 1,
      sym__labeled_name_param,
    STATE(856), 1,
      sym__name_param,
    STATE(867), 1,
      sym__discard_param,
    STATE(884), 1,
      sym__labeled_discard_param,
    STATE(956), 1,
      sym_discard,
    STATE(959), 1,
      sym_identifier,
    STATE(1149), 1,
      sym_function_parameter,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
  [45993] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1880), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46014] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1882), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46035] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1884), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46056] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1886), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46077] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1888), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46098] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1890), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46119] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1892), 11,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      anon_sym_PIPE,
  [46140] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1862), 1,
      sym__discard_nam