---
name: Bug report
about: Found a bug?  Make sure it hasn't already been filed/solved - if so, please report it!
title: ""
labels: "bug"
assignees: ""
---

Before you report, please take a look at [Troubleshooting](https://clementtsang.github.io/bottom/nightly/troubleshooting) to see if there's already an answer to your problem. Also check out [existing issues](https://github.com/ClementTsang/bottom/issues) and [known problems](https://clementtsang.github.io/bottom/nightly/support/#known-problems) to see if your problem is already reported/known.

Also, **please fill in all fields if possible** - if the issue is too hard to reproduce or vague, it may not be fixed!

## Describe the bug

Give a high level description of the bug.

## What operating system/architecture are you using?

Please mention what operating system, version, and architecture you're experiencing the problem on (ex: macOS 10.13, x86_64). Please also ensure that your system is [on the list of supported systems](https://github.com/ClementTsang/bottom#support) - bug reports on unsupported systems are likely to be closed.

## What terminal are you using `bottom` on?

Please mention what terminal/terminal emulator you are using `bottom` on (ex: Konsole, Kitty).

## What version are you on?

Please ensure that the bug still exists on the [latest stable release](https://github.com/ClementTsang/bottom/releases/latest) or newer (i.e. nightly). If so, mention
what version you are using here.

## How did you install `bottom`?

Please mention how you installed `bottom`. If you manually compiled it, please also mention your _Rust version_.

## How can we reproduce this?

Provide detailed steps on _how_ to reproduce your problem, to the best of your ability. Be as detailed as possible, and include config files or flags if relevant.
If maintainers cannot reproduce the bug, it will be very hard to fix it.

## What is the actual behaviour?

What is the _actual_ result of the given steps? Be detailed. Please include screenshots if the issue is a visual one.

## What is the expected behaviour?

What do you believe the expected behaviour should be given these steps?
