.TH ALACRITTY "1" "August 2018" "alacritty 0.10.1" "User Commands"
.SH NAME
Alacritty \- A fast, cross-platform, OpenGL terminal emulator
.SH "SYNOPSIS"
alacritty [SUBCOMMANDS] [FLAGS] [OPTIONS]
.SH DESCRIPTION
Alacritty is a modern terminal emulator that comes with sensible defaults, but
allows for extensive configuration. By integrating with other applications,
rather than reimplementing their functionality, it manages to provide a flexible
set of features with high performance.
.SH "FLAGS"
.TP
\fB\-h\fR, \fB\-\-help\fR
Prints help information
.TP
\fB\-\-hold\fR
Remain open after child process exits
.TP
\fB\-\-print\-events\fR
Print all events to stdout
.TP
\fB\-q\fR
Reduces the level of verbosity (the min level is \fB\-qq\fR)
.TP
\fB\-\-ref\-test\fR
Generates ref test
.TP
\fB\-v\fR
Increases the level of verbosity (the max level is \fB\-vvv\fR)
.TP
\fB\-V\fR, \fB\-\-version\fR
Prints version information
.SH "OPTIONS"
.TP
\fB\-\-class\fR <instance> | <instance>,<general>
Defines the window class hint on Linux [default: Alacritty,Alacritty]

On Wayland the instance class sets the `app_id`, while the general class is ignored.
.TP
\fB\-e\fR, \fB\-\-command\fR <command>...
Command and args to execute (must be last argument)
.TP
\fB\-\-config\-file\fR <config\-file>
Specify alternative configuration file

Alacritty looks for the configuration file at the following paths:
    1. $XDG_CONFIG_HOME/alacritty/alacritty.yml
    2. $XDG_CONFIG_HOME/alacritty.yml
    3. $HOME/.config/alacritty/alacritty.yml
    4. $HOME/.alacritty.yml

On Windows, the configuration file is located at %APPDATA%\\alacritty\\alacritty.yml.
.TP
\fB\-\-embed\fR <parent>
Defines the X11 window ID (as a decimal integer) to embed Alacritty within
.TP
\fB\-o\fR, \fB\-\-option\fR <option>...
Override configuration file options [example: cursor.style=Beam]
.TP
\fB\-\-socket\fR <socket>
Path for IPC socket creation
.TP
\fB\-t\fR, \fB\-\-title\fR <title>
Defines the window title [default: Alacritty]
.TP
\fB\-\-working\-directory\fR <working\-directory>
Start the shell in the specified working directory
.SH "SUBCOMMANDS"
.TP
\fBmsg\fR
Available socket messages
.SH "SEE ALSO"
See the alacritty github repository at https://github.com/alacritty/alacritty for the full documentation.
.SH "BUGS"
Found a bug? Please report it at https://github.com/alacritty/alacritty/issues.
.SH "MAINTAINERS"
.sp
.RS 4
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
.el \{\
.sp -1
.IP \(bu 2.3
.\}
Christian Duerr <contact@christianduerr.com>
.sp
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
Joe Wilm <joe@jwilm.com>
