(* 
   html documentation for HereDoc 
   also an illustration of its use
*)

(* Misc *)

let output = Text.iter print_string

let fr = true
let en = false

let rec mapi i l f = match l with
| [] -> []
| t::q -> (f i t)::(mapi (succ i) q f)

let itoa = string_of_int

INCLUDE "doc.layout.tpl"."init"

(* The document *)

TEMPLATE_FILE "doc.sections.tpl"


module Author = struct
  let mail = "Alain.Frisch@inria.fr"
  let homepage = "http://www.eleves.ens.fr/home/frisch"
end


let ocaml = link "OCaml" "http://caml.inria.fr"
let pfour = link "Camlp4" "http://caml.inria.fr/camlp4/index.html"

let time = ref ""

module Document = struct INCLUDE ."document_init" end

(* Layout *)

TEMPLATE_FILE "doc.layout.tpl"

let _ =  
  let r = TPL."page" in
  time := string_of_float (Sys.time ());
  output r

