Template file for doc.ml (html documentation for HereDoc)

==link txt dest==
<a href="$dest">$txt</a>
====

==mailto mail==
<a href="mailto:$mail">$mail</a>
====

==init==
let link = TPL."link"
let mailto = TPL."mailto"
====

==page==
<html>
<body>
<a name="top">
<h1>$Document.title</h1>
<b><small>$Document.subtitle</small></b>
<p>
$$TPL ."toc"$$
$[mapi 1 Document.sections -> no -> (title,body)]$
$$TPL ."section"$$
$[]$
<p>
<small>$$link "Return to the top" "#top"$$</small>
<address>
$Document.footer
</address>
</body>
</html>
====

==section==
<a name="$$itoa no$$">
<h2><a href="#top">$$string_of_int no$$. $title</a></h2>
$body
====

==toc==
<ul>
$[mapi 1 Document.sections -> no -> (title,_)]$
<li><a href="#$$itoa no$$">$title</a></li>
$[]$
</ul>
====
