How to contribute
=================

If you want to help out with Cadabra, or think you can contribute a
useful add-on package or perhaps just a sample notebook or a bit of
documentation, you are more than welcome! Even just dropping us a
note with some details about what computations you do with Cadabra
is a useful contribution, and helps to get a better idea of what
people expect from the software. 

Below are some tips on how to get started contributing to Cadabra. For
any questions, please post in the [questions and answers][1] forum or
get in touch directly via [email][2]


Get familiar with the software
------------------------------

The first thing to do is to get familiar with how the software works,
by playing with the [tutorials][3] Details of the software, including
some of the logic that is behind its inner workings, are described in
the [reference guide][4], and documentation is available separately
for all [properties and algorithms][5]. If you get stuck, do not
hesitate to post a question on the [questions and answers][1] site. If
you want to contribute at the level of the C++ core, or if you are
simply interested in how things work behind the scenes, you will find
the [doxygen][6] documentation useful.


Identify something to work on
-----------------------------

Most likely you will have used (or will have tried to use) Cadabra for
a concrete project, and found that you see room for improvement. This
can be as simple as reporting a bug, perhaps even fixing it, or adding
a tutorial or other documentation, providing add-on functionality in
the form of packages, or helping with the core. We are also always
interested to hear about issues installing Cadabra on new systems.


Setup your development environment
----------------------------------

Contributions in any form are welcome, but if you want to submit
substantial code contributions, it is useful to get familiar with the
git version control system. This is used to track software changes
over time and to effectively manage contributions from different
authors. We also utilise [github][7], a web interface to git,
extensively and use it for communication, issue tracking, merging
patches (pull requests) and so on. Check out the source code from
there and follow the instructions on how to build it.


[1] https://cadabra.science/qa/
[2] mailto:info@cadabra.science
[3] https://cadabra.science/tutorials.html
[4] https://cadabra.science/help.html
[5] https://cadabra.science/man.html
[6] https://cadabra.science/doxygen/html/
[7] https://github.com/kpeeters/cadabra2