// CaboCha -- Yet Another Japanese Dependency Parser
//
//  $Id: normalizer_rule.h 41 2008-01-20 09:31:34Z taku-ku $;
//
//  Copyright(C) 2001-2008 Taku Kudo <taku@chasen.org>
#ifndef CABOCHA_NORMALIZER_RULE_H_
#define CABOCHA_NORMALIZER_RULE_H_
namespace {
static const char utf8_table[] = "\xE3\x80\x8C\x00\xE3\x80\x8D\x00\xE3\x80\x81\x00\xE3\x83\xBB\x00\xE3\x83\xB2\x00\xE3\x83\xB2\xE3\x82\x9B\x00\xE3\x82\xA1\x00\xE3\x82\xA3\x00\xE3\x82\xA5\x00\xE3\x82\xA7\x00\xE3\x82\xA9\x00\xE3\x83\xA3\x00\xE3\x83\xA5\x00\xE3\x83\xA7\x00\xE3\x83\x83\x00\xE3\x83\xBC\x00\xE3\x82\xA2\x00\xE3\x82\xA4\x00\xE3\x82\xA6\x00\xE3\x83\xB4\x00\xE3\x82\xA8\x00\xE3\x82\xAA\x00\xE3\x82\xAB\x00\xE3\x82\xAD\x00\xE3\x82\xAF\x00\xE3\x82\xB1\x00\xE3\x82\xB3\x00\xE3\x82\xAC\x00\xE3\x82\xAE\x00\xE3\x82\xB0\x00\xE3\x82\xB2\x00\xE3\x82\xB4\x00\xE3\x82\xB5\x00\xE3\x82\xB7\x00\xE3\x82\xB9\x00\xE3\x82\xBB\x00\xE3\x82\xBD\x00\xE3\x82\xB6\x00\xE3\x82\xB8\x00\xE3\x82\xBA\x00\xE3\x82\xBC\x00\xE3\x82\xBE\x00\xE3\x82\xBF\x00\xE3\x83\x81\x00\xE3\x83\x84\x00\xE3\x83\x86\x00\xE3\x83\x88\x00\xE3\x83\x80\x00\xE3\x83\x82\x00\xE3\x83\x85\x00\xE3\x83\x87\x00\xE3\x83\x89\x00\xE3\x83\x8A\x00\xE3\x83\x8B\x00\xE3\x83\x8C\x00\xE3\x83\x8D\x00\xE3\x83\x8E\x00\xE3\x83\x8F\x00\xE3\x83\x92\x00\xE3\x83\x95\x00\xE3\x83\x98\x00\xE3\x83\x9B\x00\xE3\x83\x90\x00\xE3\x83\x93\x00\xE3\x83\x96\x00\xE3\x83\x99\x00\xE3\x83\x9C\x00\xE3\x83\x91\x00\xE3\x83\x94\x00\xE3\x83\x97\x00\xE3\x83\x9A\x00\xE3\x83\x9D\x00\xE3\x83\x9E\x00\xE3\x83\x9F\x00\xE3\x83\xA0\x00\xE3\x83\xA1\x00\xE3\x83\xA2\x00\xE3\x83\xA4\x00\xE3\x83\xA6\x00\xE3\x83\xA8\x00\xE3\x83\xA9\x00\xE3\x83\xAA\x00\xE3\x83\xAB\x00\xE3\x83\xAC\x00\xE3\x83\xAD\x00\xE3\x83\xAF\x00\xE3\x83\xAF\xE3\x82\x9B\x00\xE3\x83\xB3\x00\xE3\x82\x9B\x00\xE3\x82\x9C\x00\x25\x00\x40\x00\x21\x00\x22\x00\x23\x00\x24\x00\x26\x00\x27\x00\x28\x00\x29\x00\x3D\x00\x7E\x00\x5E\x00\x7C\x00\x7B\x00\x7D\x00\x2A\x00\x60\x00\x3F\x00\x3E\x00\x3C\x00\x3B\x00\x3A\x00\x2B\x00\x2D\x00\x5C\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6A\x00\x6B\x00\x6C\x00\x6D\x00\x6E\x00\x6F\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7A\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4A\x00\x4B\x00\x4C\x00\x4D\x00\x4E\x00\x4F\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5A\x00\x5F\x5F\x5F\x00\x5F\x5F\x5F\x00\x2D\x00\x2D\x00";
static const DoubleArray utf8_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{35,1},{-547,35},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,2},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{-553,151},{-381,152},{151,3},{-373,154},{27,26},{158,27},{152,3},{-543,158},{0,0},{0,0},{154,3},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{-371,190},{-375,191},{-377,192},{100,4},{176,4},{339,4},{420,4},{-367,197},{-379,198},{-383,199},{-385,200},{-399,201},{-413,202},{-415,203},{-419,204},{-421,205},{-423,206},{-425,207},{-427,208},{-429,209},{-431,210},{-433,211},{-435,212},{-437,213},{-411,214},{-409,215},{-407,216},{-387,217},{-405,218},{-403,219},{-369,220},{-491,221},{-493,222},{-495,223},{-497,224},{-499,225},{-501,226},{-503,227},{2,1},{26,1},{190,100},{-505,231},{191,100},{192,100},{197,100},{198,100},{-507,236},{199,100},{200,100},{201,100},{202,100},{4,1},{203,100},{-509,243},{-511,244},{204,100},{205,100},{206,100},{207,100},{208,100},{209,100},{210,100},{211,100},{212,100},{213,100},{214,100},{215,100},{216,100},{217,100},{218,100},{219,100},{220,100},{221,100},{222,100},{223,100},{224,100},{225,100},{226,100},{227,100},{231,100},{236,100},{243,100},{244,100},{288,100},{289,100},{290,100},{292,100},{293,100},{294,100},{295,100},{296,100},{297,100},{298,100},{299,100},{300,100},{301,100},{302,100},{303,100},{-513,288},{-515,289},{-517,290},{304,100},{-519,292},{-521,293},{-523,294},{-525,295},{-527,296},{-529,297},{-531,298},{-533,299},{-535,300},{-537,301},{-539,302},{-541,303},{-391,304},{336,176},{337,176},{338,176},{369,176},{370,176},{371,176},{372,176},{373,176},{374,176},{375,176},{376,176},{377,176},{378,176},{379,176},{380,176},{381,176},{382,176},{383,176},{384,176},{385,176},{386,176},{387,176},{388,176},{389,176},{390,176},{391,176},{392,176},{393,176},{394,176},{395,176},{396,176},{-401,336},{-439,337},{-441,338},{397,176},{398,176},{399,176},{400,176},{401,176},{403,176},{405,176},{406,176},{407,176},{408,176},{409,176},{410,176},{411,176},{412,176},{413,176},{414,176},{415,176},{416,176},{421,176},{422,176},{423,176},{427,176},{431,176},{435,176},{439,176},{443,176},{447,176},{451,176},{454,176},{457,176},{-443,369},{-445,370},{-447,371},{-449,372},{-451,373},{-453,374},{-455,375},{-457,376},{-459,377},{-461,378},{-463,379},{-465,380},{-467,381},{-469,382},{-471,383},{-473,384},{-475,385},{-477,386},{-479,387},{-481,388},{-483,389},{-485,390},{-487,391},{-489,392},{-395,393},{-393,394},{-397,395},{-389,396},{-1,397},{-5,398},{-9,399},{-13,400},{-17,401},{-21,402},{-28,403},{402,245},{-32,405},{-36,406},{-40,407},{-44,408},{-48,409},{-52,410},{-56,411},{-60,412},{-64,413},{-68,414},{-72,415},{-76,416},{418,258},{-80,418},{245,228},{258,229},{-84,421},{-88,422},{-92,423},{266,233},{426,266},{-112,426},{-96,427},{270,237},{430,270},{-116,430},{-100,431},{274,241},{434,274},{-120,434},{-104,435},{438,277},{277,246},{-124,438},{-108,439},{282,249},{442,282},{-128,442},{-132,443},{286,253},{446,286},{-152,446},{-136,447},{291,257},{-156,449},{449,291},{-140,451},{305,261},{-160,453},{-144,454},{306,264},{-164,456},{-148,457},{307,267},{-168,459},{-172,460},{-192,461},{308,271},{-176,463},{453,305},{456,306},{459,307},{461,308},{460,339},{463,339},{503,339},{507,339},{511,339},{515,339},{516,339},{517,339},{518,339},{519,339},{520,339},{526,339},{532,339},{536,339},{540,339},{544,339},{545,339},{546,339},{547,339},{548,339},{549,339},{550,339},{551,339},{552,339},{553,339},{554,339},{555,339},{556,339},{557,339},{560,339},{561,339},{562,339},{342,309},{502,342},{-196,502},{-180,503},{346,313},{506,346},{-200,506},{-184,507},{350,317},{510,350},{-204,510},{-188,511},{354,321},{514,354},{-208,514},{-212,515},{-216,516},{-220,517},{-224,518},{-228,519},{-232,520},{363,330},{524,363},{525,363},{-252,524},{-272,525},{-236,526},{529,368},{530,368},{-256,529},{-276,530},{368,340},{-240,532},{-260,533},{404,343},{-280,535},{-244,536},{-264,537},{417,347},{-284,539},{-248,540},{-268,541},{419,351},{-288,543},{-292,544},{-296,545},{-300,546},{-304,547},{-308,548},{-312,549},{-316,550},{-320,551},{-324,552},{-328,553},{-332,554},{-336,555},{-340,556},{-344,557},{424,367},{-348,559},{-355,560},{-359,561},{-363,562},{533,404},{535,404},{-417,565},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{537,417},{539,417},{541,419},{543,419},{0,0},{0,0},{0,0},{559,424},{0,0},{0,0},{565,420},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{228,401},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{229,416},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{233,423},{0,0},{0,0},{0,0},{237,427},{0,0},{0,0},{0,0},{241,431},{0,0},{0,0},{0,0},{246,435},{0,0},{0,0},{0,0},{249,439},{0,0},{0,0},{0,0},{253,443},{0,0},{0,0},{0,0},{257,447},{0,0},{0,0},{0,0},{261,451},{0,0},{0,0},{264,454},{0,0},{0,0},{267,457},{0,0},{0,0},{271,460},{0,0},{0,0},{309,463},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{313,503},{0,0},{0,0},{0,0},{317,507},{0,0},{0,0},{0,0},{321,511},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{330,520},{0,0},{0,0},{0,0},{0,0},{0,0},{340,526},{0,0},{0,0},{0,0},{0,0},{0,0},{343,532},{0,0},{0,0},{0,0},{347,536},{0,0},{0,0},{0,0},{351,540},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{367,557},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
static const char euc_jp_win_table[] = "\xE3\x80\x8C\x00\xE3\x80\x8D\x00\xE3\x80\x81\x00\xE3\x83\xBB\x00\xE3\x83\xB2\x00\xE3\x83\xB2\xE3\x82\x9B\x00\xE3\x82\xA1\x00\xE3\x82\xA3\x00\xE3\x82\xA5\x00\xE3\x82\xA7\x00\xE3\x82\xA9\x00\xE3\x83\xA3\x00\xE3\x83\xA5\x00\xE3\x83\xA7\x00\xE3\x83\x83\x00\xE3\x83\xBC\x00\xE3\x82\xA2\x00\xE3\x82\xA4\x00\xE3\x82\xA6\x00\xE3\x83\xB4\x00\xE3\x82\xA8\x00\xE3\x82\xAA\x00\xE3\x82\xAB\x00\xE3\x82\xAD\x00\xE3\x82\xAF\x00\xE3\x82\xB1\x00\xE3\x82\xB3\x00\xE3\x82\xAC\x00\xE3\x82\xAE\x00\xE3\x82\xB0\x00\xE3\x82\xB2\x00\xE3\x82\xB4\x00\xE3\x82\xB5\x00\xE3\x82\xB7\x00\xE3\x82\xB9\x00\xE3\x82\xBB\x00\xE3\x82\xBD\x00\xE3\x82\xB6\x00\xE3\x82\xB8\x00\xE3\x82\xBA\x00\xE3\x82\xBC\x00\xE3\x82\xBE\x00\xE3\x82\xBF\x00\xE3\x83\x81\x00\xE3\x83\x84\x00\xE3\x83\x86\x00\xE3\x83\x88\x00\xE3\x83\x80\x00\xE3\x83\x82\x00\xE3\x83\x85\x00\xE3\x83\x87\x00\xE3\x83\x89\x00\xE3\x83\x8A\x00\xE3\x83\x8B\x00\xE3\x83\x8C\x00\xE3\x83\x8D\x00\xE3\x83\x8E\x00\xE3\x83\x8F\x00\xE3\x83\x92\x00\xE3\x83\x95\x00\xE3\x83\x98\x00\xE3\x83\x9B\x00\xE3\x83\x90\x00\xE3\x83\x93\x00\xE3\x83\x96\x00\xE3\x83\x99\x00\xE3\x83\x9C\x00\xE3\x83\x91\x00\xE3\x83\x94\x00\xE3\x83\x97\x00\xE3\x83\x9A\x00\xE3\x83\x9D\x00\xE3\x83\x9E\x00\xE3\x83\x9F\x00\xE3\x83\xA0\x00\xE3\x83\xA1\x00\xE3\x83\xA2\x00\xE3\x83\xA4\x00\xE3\x83\xA6\x00\xE3\x83\xA8\x00\xE3\x83\xA9\x00\xE3\x83\xAA\x00\xE3\x83\xAB\x00\xE3\x83\xAC\x00\xE3\x83\xAD\x00\xE3\x83\xAF\x00\xE3\x83\xAF\xE3\x82\x9B\x00\xE3\x83\xB3\x00\xE3\x82\x9B\x00\xE3\x82\x9C\x00\x25\x00\x40\x00\x21\x00\x22\x00\x23\x00\x24\x00\x26\x00\x27\x00\x28\x00\x29\x00\x3D\x00\x7E\x00\x5E\x00\x7C\x00\x7B\x00\x7D\x00\x2A\x00\x60\x00\x3F\x00\x3E\x00\x3C\x00\x3B\x00\x3A\x00\x2B\x00\x2D\x00\x5C\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6A\x00\x6B\x00\x6C\x00\x6D\x00\x6E\x00\x6F\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7A\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4A\x00\x4B\x00\x4C\x00\x4D\x00\x4E\x00\x4F\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5A\x00\x5F\x5F\x5F\x00\x5F\x5F\x5F\x00\x2D\x00\x2D\x00";
static const DoubleArray euc_jp_win_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{35,1},{-547,35},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,2},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{-553,151},{-381,152},{151,3},{-373,154},{27,26},{158,27},{152,3},{-543,158},{0,0},{0,0},{154,3},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{-371,190},{-375,191},{-377,192},{100,4},{176,4},{339,4},{420,4},{-367,197},{-379,198},{-383,199},{-385,200},{-399,201},{-413,202},{-415,203},{-419,204},{-421,205},{-423,206},{-425,207},{-427,208},{-429,209},{-431,210},{-433,211},{-435,212},{-437,213},{-411,214},{-409,215},{-407,216},{-387,217},{-405,218},{-403,219},{-369,220},{-491,221},{-493,222},{-495,223},{-497,224},{-499,225},{-501,226},{-503,227},{2,1},{26,1},{190,100},{-505,231},{191,100},{192,100},{197,100},{198,100},{-507,236},{199,100},{200,100},{201,100},{202,100},{4,1},{203,100},{-509,243},{-511,244},{204,100},{205,100},{206,100},{207,100},{208,100},{209,100},{210,100},{211,100},{212,100},{213,100},{214,100},{215,100},{216,100},{217,100},{218,100},{219,100},{220,100},{221,100},{222,100},{223,100},{224,100},{225,100},{226,100},{227,100},{231,100},{236,100},{243,100},{244,100},{288,100},{289,100},{290,100},{292,100},{293,100},{294,100},{295,100},{296,100},{297,100},{298,100},{299,100},{300,100},{301,100},{302,100},{303,100},{-513,288},{-515,289},{-517,290},{304,100},{-519,292},{-521,293},{-523,294},{-525,295},{-527,296},{-529,297},{-531,298},{-533,299},{-535,300},{-537,301},{-539,302},{-541,303},{-391,304},{336,176},{337,176},{338,176},{369,176},{370,176},{371,176},{372,176},{373,176},{374,176},{375,176},{376,176},{377,176},{378,176},{379,176},{380,176},{381,176},{382,176},{383,176},{384,176},{385,176},{386,176},{387,176},{388,176},{389,176},{390,176},{391,176},{392,176},{393,176},{394,176},{395,176},{396,176},{-401,336},{-439,337},{-441,338},{397,176},{398,176},{399,176},{400,176},{401,176},{403,176},{405,176},{406,176},{407,176},{408,176},{409,176},{410,176},{411,176},{412,176},{413,176},{414,176},{415,176},{416,176},{421,176},{422,176},{423,176},{427,176},{431,176},{435,176},{439,176},{443,176},{447,176},{451,176},{454,176},{457,176},{-443,369},{-445,370},{-447,371},{-449,372},{-451,373},{-453,374},{-455,375},{-457,376},{-459,377},{-461,378},{-463,379},{-465,380},{-467,381},{-469,382},{-471,383},{-473,384},{-475,385},{-477,386},{-479,387},{-481,388},{-483,389},{-485,390},{-487,391},{-489,392},{-395,393},{-393,394},{-397,395},{-389,396},{-1,397},{-5,398},{-9,399},{-13,400},{-17,401},{-21,402},{-28,403},{402,245},{-32,405},{-36,406},{-40,407},{-44,408},{-48,409},{-52,410},{-56,411},{-60,412},{-64,413},{-68,414},{-72,415},{-76,416},{418,258},{-80,418},{245,228},{258,229},{-84,421},{-88,422},{-92,423},{266,233},{426,266},{-112,426},{-96,427},{270,237},{430,270},{-116,430},{-100,431},{274,241},{434,274},{-120,434},{-104,435},{438,277},{277,246},{-124,438},{-108,439},{282,249},{442,282},{-128,442},{-132,443},{286,253},{446,286},{-152,446},{-136,447},{291,257},{-156,449},{449,291},{-140,451},{305,261},{-160,453},{-144,454},{306,264},{-164,456},{-148,457},{307,267},{-168,459},{-172,460},{-192,461},{308,271},{-176,463},{453,305},{456,306},{459,307},{461,308},{460,339},{463,339},{503,339},{507,339},{511,339},{515,339},{516,339},{517,339},{518,339},{519,339},{520,339},{526,339},{532,339},{536,339},{540,339},{544,339},{545,339},{546,339},{547,339},{548,339},{549,339},{550,339},{551,339},{552,339},{553,339},{554,339},{555,339},{556,339},{557,339},{560,339},{561,339},{562,339},{342,309},{502,342},{-196,502},{-180,503},{346,313},{506,346},{-200,506},{-184,507},{350,317},{510,350},{-204,510},{-188,511},{354,321},{514,354},{-208,514},{-212,515},{-216,516},{-220,517},{-224,518},{-228,519},{-232,520},{363,330},{524,363},{525,363},{-252,524},{-272,525},{-236,526},{529,368},{530,368},{-256,529},{-276,530},{368,340},{-240,532},{-260,533},{404,343},{-280,535},{-244,536},{-264,537},{417,347},{-284,539},{-248,540},{-268,541},{419,351},{-288,543},{-292,544},{-296,545},{-300,546},{-304,547},{-308,548},{-312,549},{-316,550},{-320,551},{-324,552},{-328,553},{-332,554},{-336,555},{-340,556},{-344,557},{424,367},{-348,559},{-355,560},{-359,561},{-363,562},{533,404},{535,404},{-417,565},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{537,417},{539,417},{541,419},{543,419},{0,0},{0,0},{0,0},{559,424},{0,0},{0,0},{565,420},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{228,401},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{229,416},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{233,423},{0,0},{0,0},{0,0},{237,427},{0,0},{0,0},{0,0},{241,431},{0,0},{0,0},{0,0},{246,435},{0,0},{0,0},{0,0},{249,439},{0,0},{0,0},{0,0},{253,443},{0,0},{0,0},{0,0},{257,447},{0,0},{0,0},{0,0},{261,451},{0,0},{0,0},{264,454},{0,0},{0,0},{267,457},{0,0},{0,0},{271,460},{0,0},{0,0},{309,463},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{313,503},{0,0},{0,0},{0,0},{317,507},{0,0},{0,0},{0,0},{321,511},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{330,520},{0,0},{0,0},{0,0},{0,0},{0,0},{340,526},{0,0},{0,0},{0,0},{0,0},{0,0},{343,532},{0,0},{0,0},{0,0},{347,536},{0,0},{0,0},{0,0},{351,540},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{367,557},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
static const char cp932_table[] = "\x81\x75\x00\x81\x76\x00\x81\x41\x00\x81\x45\x00\x83\x92\x00\x83\x92\x81\x4A\x00\x83\x40\x00\x83\x42\x00\x83\x44\x00\x83\x46\x00\x83\x48\x00\x83\x83\x00\x83\x85\x00\x83\x87\x00\x83\x62\x00\x81\x5B\x00\x83\x41\x00\x83\x43\x00\x83\x45\x00\x83\x94\x00\x83\x47\x00\x83\x49\x00\x83\x4A\x00\x83\x4C\x00\x83\x4E\x00\x83\x50\x00\x83\x52\x00\x83\x4B\x00\x83\x4D\x00\x83\x4F\x00\x83\x51\x00\x83\x53\x00\x83\x54\x00\x83\x56\x00\x83\x58\x00\x83\x5A\x00\x83\x5C\x00\x83\x55\x00\x83\x57\x00\x83\x59\x00\x83\x5B\x00\x83\x5D\x00\x83\x5E\x00\x83\x60\x00\x83\x63\x00\x83\x65\x00\x83\x67\x00\x83\x5F\x00\x83\x61\x00\x83\x64\x00\x83\x66\x00\x83\x68\x00\x83\x69\x00\x83\x6A\x00\x83\x6B\x00\x83\x6C\x00\x83\x6D\x00\x83\x6E\x00\x83\x71\x00\x83\x74\x00\x83\x77\x00\x83\x7A\x00\x83\x6F\x00\x83\x72\x00\x83\x75\x00\x83\x78\x00\x83\x7B\x00\x83\x70\x00\x83\x73\x00\x83\x76\x00\x83\x79\x00\x83\x7C\x00\x83\x7D\x00\x83\x7E\x00\x83\x80\x00\x83\x81\x00\x83\x82\x00\x83\x84\x00\x83\x86\x00\x83\x88\x00\x83\x89\x00\x83\x8A\x00\x83\x8B\x00\x83\x8C\x00\x83\x8D\x00\x83\x8F\x00\x83\x8F\x81\x4A\x00\x83\x93\x00\x81\x4A\x00\x81\x4B\x00\x25\x00\x40\x00\x21\x00\x22\x00\x23\x00\x24\x00\x26\x00\x27\x00\x28\x00\x29\x00\x3D\x00\x7E\x00\x5E\x00\x7C\x00\x7B\x00\x7D\x00\x2A\x00\x60\x00\x3F\x00\x3E\x00\x3C\x00\x3B\x00\x3A\x00\x2B\x00\x2D\x00\x5C\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6A\x00\x6B\x00\x6C\x00\x6D\x00\x6E\x00\x6F\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7A\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4A\x00\x4B\x00\x4C\x00\x4D\x00\x4E\x00\x4F\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5A\x00\x5F\x5F\x5F\x00\x5F\x5F\x5F\x00\x2D\x00\x2D\x00";
static const DoubleArray cp932_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{35,1},{-455,35},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{-451,66},{-319,67},{66,3},{-317,69},{-311,70},{-279,71},{-309,72},{-299,73},{67,3},{69,3},{70,3},{71,3},{-461,78},{-297,79},{-301,80},{72,3},{-289,82},{73,3},{-281,84},{-291,85},{-293,86},{-303,87},{-305,88},{-321,89},{-323,90},{-295,91},{-315,92},{-313,93},{-325,94},{-285,95},{78,3},{-275,97},{-283,98},{-287,99},{79,3},{-307,101},{80,3},{-277,103},{-327,104},{-329,105},{82,3},{-331,107},{84,3},{85,3},{86,3},{-333,111},{-335,112},{-337,113},{-339,114},{87,3},{88,3},{-341,117},{-343,118},{-345,119},{-399,120},{-401,121},{-403,122},{-405,123},{-407,124},{-409,125},{-411,126},{89,3},{90,3},{-413,129},{-415,130},{3,1},{146,1},{91,3},{-417,134},{92,3},{93,3},{-419,137},{-421,138},{-423,139},{-425,140},{-427,141},{-429,142},{-431,143},{-433,144},{-435,145},{0,0},{94,3},{95,3},{-437,149},{-439,150},{97,3},{98,3},{99,3},{101,3},{103,3},{-441,156},{-443,157},{-445,158},{-447,159},{-449,160},{-347,161},{-349,162},{-351,163},{311,1},{312,1},{313,1},{314,1},{315,1},{317,1},{318,1},{319,1},{320,1},{321,1},{322,1},{323,1},{324,1},{325,1},{326,1},{327,1},{328,1},{329,1},{331,1},{332,1},{333,1},{335,1},{337,1},{339,1},{341,1},{343,1},{345,1},{347,1},{349,1},{351,1},{353,1},{355,1},{357,1},{359,1},{361,1},{363,1},{364,1},{365,1},{366,1},{367,1},{368,1},{371,1},{374,1},{377,1},{380,1},{383,1},{384,1},{385,1},{386,1},{387,1},{388,1},{389,1},{390,1},{391,1},{392,1},{393,1},{394,1},{395,1},{396,1},{398,1},{399,1},{400,1},{104,146},{105,146},{107,146},{111,146},{112,146},{113,146},{114,146},{117,146},{118,146},{119,146},{-353,236},{-355,237},{-357,238},{-359,239},{-361,240},{-363,241},{-365,242},{120,146},{121,146},{122,146},{123,146},{124,146},{125,146},{126,146},{129,146},{130,146},{134,146},{137,146},{138,146},{139,146},{140,146},{141,146},{142,146},{143,146},{144,146},{145,146},{149,146},{150,146},{156,146},{157,146},{158,146},{159,146},{160,146},{-367,269},{-369,270},{-371,271},{-373,272},{-375,273},{-377,274},{-379,275},{161,146},{162,146},{163,146},{236,146},{237,146},{238,146},{239,146},{240,146},{241,146},{242,146},{269,146},{270,146},{271,146},{272,146},{273,146},{274,146},{275,146},{302,146},{303,146},{304,146},{305,146},{306,146},{307,146},{308,146},{309,146},{310,146},{-381,302},{-383,303},{-385,304},{-387,305},{-389,306},{-391,307},{-393,308},{-395,309},{-397,310},{-1,311},{-4,312},{-7,313},{-10,314},{-13,315},{-16,316},{-21,317},{-24,318},{-27,319},{-30,320},{-33,321},{-36,322},{-39,323},{-42,324},{-45,325},{-48,326},{-51,327},{-54,328},{-57,329},{-60,330},{-63,331},{-66,332},{-69,333},{-84,334},{-72,335},{-87,336},{-75,337},{-90,338},{-78,339},{-93,340},{-81,341},{-96,342},{-99,343},{-114,344},{-102,345},{-117,346},{-105,347},{-120,348},{-108,349},{-123,350},{-111,351},{-126,352},{-129,353},{-144,354},{-132,355},{-147,356},{-135,357},{-150,358},{-138,359},{-153,360},{-141,361},{-156,362},{-159,363},{-162,364},{-165,365},{-168,366},{-171,367},{-174,368},{-189,369},{-204,370},{-177,371},{-192,372},{-207,373},{-180,374},{-195,375},{-210,376},{-183,377},{-198,378},{-213,379},{-186,380},{-201,381},{-216,382},{-219,383},{-222,384},{-225,385},{-228,386},{-231,387},{-234,388},{-237,389},{-240,390},{-243,391},{-246,392},{-249,393},{-252,394},{-255,395},{-258,396},{-261,397},{-266,398},{-269,399},{-272,400},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{316,315},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{330,329},{0,0},{0,0},{0,0},{334,333},{0,0},{336,335},{0,0},{338,337},{0,0},{340,339},{0,0},{342,341},{0,0},{344,343},{0,0},{346,345},{0,0},{348,347},{0,0},{350,349},{0,0},{352,351},{0,0},{354,353},{0,0},{356,355},{0,0},{358,357},{0,0},{360,359},{0,0},{362,361},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{369,368},{370,368},{0,0},{372,371},{373,371},{0,0},{375,374},{376,374},{0,0},{378,377},{379,377},{0,0},{381,380},{382,380},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{397,396},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
}
#endif
