// CaboCha -- Yet Another Japanese Dependency Parser
//
//  $Id: char_category.h 41 2008-01-20 09:31:34Z taku-ku $;
//
//  Copyright(C) 2001-2008 Taku Kudo <taku@chasen.org>
#ifndef CABOCHA_CHAR_CATEGORY_H_
#define CABOCHA_CHAR_CATEGORY_H_

namespace CaboCha {

  enum {
    OTHER,
    KANJI,
    SYMBOL,
    HYPHEN,
    MONEY,
    ALPHANUMERIC,
    KANJINUMERIC,
    CAPALPHA,
    ALPHA,
    HIRAGANA,
    KATAKANA,
    GREEK,
    CYRILLIC,
    SPACE
  };

  static const unsigned char char_category[65536] = {
    OTHER,        /* 0x0 */
    OTHER,        /* 0x1 */
    OTHER,        /* 0x2 */
    OTHER,        /* 0x3 */
    OTHER,        /* 0x4 */
    OTHER,        /* 0x5 */
    OTHER,        /* 0x6 */
    OTHER,        /* 0x7 */
    OTHER,        /* 0x8 */
    SPACE,        /* 0x9 */
    SPACE,        /* 0xa */
    SPACE,        /* 0xb */
    OTHER,        /* 0xc */
    OTHER,        /* 0xd */
    OTHER,        /* 0xe */
    OTHER,        /* 0xf */
    OTHER,        /* 0x10 */
    OTHER,        /* 0x11 */
    OTHER,        /* 0x12 */
    OTHER,        /* 0x13 */
    OTHER,        /* 0x14 */
    OTHER,        /* 0x15 */
    OTHER,        /* 0x16 */
    OTHER,        /* 0x17 */
    OTHER,        /* 0x18 */
    OTHER,        /* 0x19 */
    OTHER,        /* 0x1a */
    OTHER,        /* 0x1b */
    OTHER,        /* 0x1c */
    OTHER,        /* 0x1d */
    OTHER,        /* 0x1e */
    OTHER,        /* 0x1f */
    SPACE,        /* 0x20 */
    SYMBOL,        /* 0x21 */
    SYMBOL,        /* 0x22 */
    SYMBOL,        /* 0x23 */
    SYMBOL,        /* 0x24 */
    SYMBOL,        /* 0x25 */
    SYMBOL,        /* 0x26 */
    SYMBOL,        /* 0x27 */
    SYMBOL,        /* 0x28 */
    SYMBOL,        /* 0x29 */
    SYMBOL,        /* 0x2a */
    SYMBOL,        /* 0x2b */
    SYMBOL,        /* 0x2c */
    SYMBOL,        /* 0x2d */
    SYMBOL,        /* 0x2e */
    SYMBOL,        /* 0x2f */
    ALPHANUMERIC,        /* 0x30 */
    ALPHANUMERIC,        /* 0x31 */
    ALPHANUMERIC,        /* 0x32 */
    ALPHANUMERIC,        /* 0x33 */
    ALPHANUMERIC,        /* 0x34 */
    ALPHANUMERIC,        /* 0x35 */
    ALPHANUMERIC,        /* 0x36 */
    ALPHANUMERIC,        /* 0x37 */
    ALPHANUMERIC,        /* 0x38 */
    ALPHANUMERIC,        /* 0x39 */
    SYMBOL,        /* 0x3a */
    SYMBOL,        /* 0x3b */
    SYMBOL,        /* 0x3c */
    SYMBOL,        /* 0x3d */
    SYMBOL,        /* 0x3e */
    SYMBOL,        /* 0x3f */
    SYMBOL,        /* 0x40 */
    ALPHA,        /* 0x41 */
    ALPHA,        /* 0x42 */
    ALPHA,        /* 0x43 */
    ALPHA,        /* 0x44 */
    ALPHA,        /* 0x45 */
    ALPHA,        /* 0x46 */
    ALPHA,        /* 0x47 */
    ALPHA,        /* 0x48 */
    ALPHA,        /* 0x49 */
    ALPHA,        /* 0x4a */
    ALPHA,        /* 0x4b */
    ALPHA,        /* 0x4c */
    ALPHA,        /* 0x4d */
    ALPHA,        /* 0x4e */
    ALPHA,        /* 0x4f */
    ALPHA,        /* 0x50 */
    ALPHA,        /* 0x51 */
    ALPHA,        /* 0x52 */
    ALPHA,        /* 0x53 */
    ALPHA,        /* 0x54 */
    ALPHA,        /* 0x55 */
    ALPHA,        /* 0x56 */
    ALPHA,        /* 0x57 */
    ALPHA,        /* 0x58 */
    ALPHA,        /* 0x59 */
    ALPHA,        /* 0x5a */
    SYMBOL,        /* 0x5b */
    SYMBOL,        /* 0x5c */
    SYMBOL,        /* 0x5d */
    SYMBOL,        /* 0x5e */
    SYMBOL,        /* 0x5f */
    SYMBOL,        /* 0x60 */
    ALPHA,        /* 0x61 */
    ALPHA,        /* 0x62 */
    ALPHA,        /* 0x63 */
    ALPHA,        /* 0x64 */
    ALPHA,        /* 0x65 */
    ALPHA,        /* 0x66 */
    ALPHA,        /* 0x67 */
    ALPHA,        /* 0x68 */
    ALPHA,        /* 0x69 */
    ALPHA,        /* 0x6a */
    ALPHA,        /* 0x6b */
    ALPHA,        /* 0x6c */
    ALPHA,        /* 0x6d */
    ALPHA,        /* 0x6e */
    ALPHA,        /* 0x6f */
    ALPHA,        /* 0x70 */
    ALPHA,        /* 0x71 */
    ALPHA,        /* 0x72 */
    ALPHA,        /* 0x73 */
    ALPHA,        /* 0x74 */
    ALPHA,        /* 0x75 */
    ALPHA,        /* 0x76 */
    ALPHA,        /* 0x77 */
    ALPHA,        /* 0x78 */
    ALPHA,        /* 0x79 */
    ALPHA,        /* 0x7a */
    SYMBOL,        /* 0x7b */
    SYMBOL,        /* 0x7c */
    SYMBOL,        /* 0x7d */
    SYMBOL,        /* 0x7e */
    OTHER,        /* 0x7f */
    OTHER,        /* 0x80 */
    OTHER,        /* 0x81 */
    OTHER,        /* 0x82 */
    OTHER,        /* 0x83 */
    OTHER,        /* 0x84 */
    OTHER,        /* 0x85 */
    OTHER,        /* 0x86 */
    OTHER,        /* 0x87 */
    OTHER,        /* 0x88 */
    OTHER,        /* 0x89 */
    OTHER,        /* 0x8a */
    OTHER,        /* 0x8b */
    OTHER,        /* 0x8c */
    OTHER,        /* 0x8d */
    OTHER,        /* 0x8e */
    OTHER,        /* 0x8f */
    OTHER,        /* 0x90 */
    OTHER,        /* 0x91 */
    OTHER,        /* 0x92 */
    OTHER,        /* 0x93 */
    OTHER,        /* 0x94 */
    OTHER,        /* 0x95 */
    OTHER,        /* 0x96 */
    OTHER,        /* 0x97 */
    OTHER,        /* 0x98 */
    OTHER,        /* 0x99 */
    OTHER,        /* 0x9a */
    OTHER,        /* 0x9b */
    OTHER,        /* 0x9c */
    OTHER,        /* 0x9d */
    OTHER,        /* 0x9e */
    OTHER,        /* 0x9f */
    OTHER,        /* 0xa0 */
    SYMBOL,        /* 0xa1 */
    SYMBOL,        /* 0xa2 */
    SYMBOL,        /* 0xa3 */
    SYMBOL,        /* 0xa4 */
    SYMBOL,        /* 0xa5 */
    SYMBOL,        /* 0xa6 */
    SYMBOL,        /* 0xa7 */
    SYMBOL,        /* 0xa8 */
    SYMBOL,        /* 0xa9 */
    SYMBOL,        /* 0xaa */
    SYMBOL,        /* 0xab */
    SYMBOL,        /* 0xac */
    SYMBOL,        /* 0xad */
    SYMBOL,        /* 0xae */
    SYMBOL,        /* 0xaf */
    SYMBOL,        /* 0xb0 */
    SYMBOL,        /* 0xb1 */
    SYMBOL,        /* 0xb2 */
    SYMBOL,        /* 0xb3 */
    SYMBOL,        /* 0xb4 */
    SYMBOL,        /* 0xb5 */
    SYMBOL,        /* 0xb6 */
    SYMBOL,        /* 0xb7 */
    SYMBOL,        /* 0xb8 */
    SYMBOL,        /* 0xb9 */
    SYMBOL,        /* 0xba */
    SYMBOL,        /* 0xbb */
    SYMBOL,        /* 0xbc */
    SYMBOL,        /* 0xbd */
    SYMBOL,        /* 0xbe */
    SYMBOL,        /* 0xbf */
    ALPHA,        /* 0xc0 */
    ALPHA,        /* 0xc1 */
    ALPHA,        /* 0xc2 */
    ALPHA,        /* 0xc3 */
    ALPHA,        /* 0xc4 */
    ALPHA,        /* 0xc5 */
    ALPHA,        /* 0xc6 */
    ALPHA,        /* 0xc7 */
    ALPHA,        /* 0xc8 */
    ALPHA,        /* 0xc9 */
    ALPHA,        /* 0xca */
    ALPHA,        /* 0xcb */
    ALPHA,        /* 0xcc */
    ALPHA,        /* 0xcd */
    ALPHA,        /* 0xce */
    ALPHA,        /* 0xcf */
    ALPHA,        /* 0xd0 */
    ALPHA,        /* 0xd1 */
    ALPHA,        /* 0xd2 */
    ALPHA,        /* 0xd3 */
    ALPHA,        /* 0xd4 */
    ALPHA,        /* 0xd5 */
    ALPHA,        /* 0xd6 */
    ALPHA,        /* 0xd7 */
    ALPHA,        /* 0xd8 */
    ALPHA,        /* 0xd9 */
    ALPHA,        /* 0xda */
    ALPHA,        /* 0xdb */
    ALPHA,        /* 0xdc */
    ALPHA,        /* 0xdd */
    ALPHA,        /* 0xde */
    ALPHA,        /* 0xdf */
    ALPHA,        /* 0xe0 */
    ALPHA,        /* 0xe1 */
    ALPHA,        /* 0xe2 */
    ALPHA,        /* 0xe3 */
    ALPHA,        /* 0xe4 */
    ALPHA,        /* 0xe5 */
    ALPHA,        /* 0xe6 */
    ALPHA,        /* 0xe7 */
    ALPHA,        /* 0xe8 */
    ALPHA,        /* 0xe9 */
    ALPHA,        /* 0xea */
    ALPHA,        /* 0xeb */
    ALPHA,        /* 0xec */
    ALPHA,        /* 0xed */
    ALPHA,        /* 0xee */
    ALPHA,        /* 0xef */
    ALPHA,        /* 0xf0 */
    ALPHA,        /* 0xf1 */
    ALPHA,        /* 0xf2 */
    ALPHA,        /* 0xf3 */
    ALPHA,        /* 0xf4 */
    ALPHA,        /* 0xf5 */
    ALPHA,        /* 0xf6 */
    ALPHA,        /* 0xf7 */
    ALPHA,        /* 0xf8 */
    ALPHA,        /* 0xf9 */
    ALPHA,        /* 0xfa */
    ALPHA,        /* 0xfb */
    ALPHA,        /* 0xfc */
    ALPHA,        /* 0xfd */
    ALPHA,        /* 0xfe */
    ALPHA,        /* 0xff */
    ALPHA,        /* 0x100 */
    ALPHA,        /* 0x101 */
    ALPHA,        /* 0x102 */
    ALPHA,        /* 0x103 */
    ALPHA,        /* 0x104 */
    ALPHA,        /* 0x105 */
    ALPHA,        /* 0x106 */
    ALPHA,        /* 0x107 */
    ALPHA,        /* 0x108 */
    ALPHA,        /* 0x109 */
    ALPHA,        /* 0x10a */
    ALPHA,        /* 0x10b */
    ALPHA,        /* 0x10c */
    ALPHA,        /* 0x10d */
    ALPHA,        /* 0x10e */
    ALPHA,        /* 0x10f */
    ALPHA,        /* 0x110 */
    ALPHA,        /* 0x111 */
    ALPHA,        /* 0x112 */
    ALPHA,        /* 0x113 */
    ALPHA,        /* 0x114 */
    ALPHA,        /* 0x115 */
    ALPHA,        /* 0x116 */
    ALPHA,        /* 0x117 */
    ALPHA,        /* 0x118 */
    ALPHA,        /* 0x119 */
    ALPHA,        /* 0x11a */
    ALPHA,        /* 0x11b */
    ALPHA,        /* 0x11c */
    ALPHA,        /* 0x11d */
    ALPHA,        /* 0x11e */
    ALPHA,        /* 0x11f */
    ALPHA,        /* 0x120 */
    ALPHA,        /* 0x121 */
    ALPHA,        /* 0x122 */
    ALPHA,        /* 0x123 */
    ALPHA,        /* 0x124 */
    ALPHA,        /* 0x125 */
    ALPHA,        /* 0x126 */
    ALPHA,        /* 0x127 */
    ALPHA,        /* 0x128 */
    ALPHA,        /* 0x129 */
    ALPHA,        /* 0x12a */
    ALPHA,        /* 0x12b */
    ALPHA,        /* 0x12c */
    ALPHA,        /* 0x12d */
    ALPHA,        /* 0x12e */
    ALPHA,        /* 0x12f */
    ALPHA,        /* 0x130 */
    ALPHA,        /* 0x131 */
    ALPHA,        /* 0x132 */
    ALPHA,        /* 0x133 */
    ALPHA,        /* 0x134 */
    ALPHA,        /* 0x135 */
    ALPHA,        /* 0x136 */
    ALPHA,        /* 0x137 */
    ALPHA,        /* 0x138 */
    ALPHA,        /* 0x139 */
    ALPHA,        /* 0x13a */
    ALPHA,        /* 0x13b */
    ALPHA,        /* 0x13c */
    ALPHA,        /* 0x13d */
    ALPHA,        /* 0x13e */
    ALPHA,        /* 0x13f */
    ALPHA,        /* 0x140 */
    ALPHA,        /* 0x141 */
    ALPHA,        /* 0x142 */
    ALPHA,        /* 0x143 */
    ALPHA,        /* 0x144 */
    ALPHA,        /* 0x145 */
    ALPHA,        /* 0x146 */
    ALPHA,        /* 0x147 */
    ALPHA,        /* 0x148 */
    ALPHA,        /* 0x149 */
    ALPHA,        /* 0x14a */
    ALPHA,        /* 0x14b */
    ALPHA,        /* 0x14c */
    ALPHA,        /* 0x14d */
    ALPHA,        /* 0x14e */
    ALPHA,        /* 0x14f */
    ALPHA,        /* 0x150 */
    ALPHA,        /* 0x151 */
    ALPHA,        /* 0x152 */
    ALPHA,        /* 0x153 */
    ALPHA,        /* 0x154 */
    ALPHA,        /* 0x155 */
    ALPHA,        /* 0x156 */
    ALPHA,        /* 0x157 */
    ALPHA,        /* 0x158 */
    ALPHA,        /* 0x159 */
    ALPHA,        /* 0x15a */
    ALPHA,        /* 0x15b */
    ALPHA,        /* 0x15c */
    ALPHA,        /* 0x15d */
    ALPHA,        /* 0x15e */
    ALPHA,        /* 0x15f */
    ALPHA,        /* 0x160 */
    ALPHA,        /* 0x161 */
    ALPHA,        /* 0x162 */
    ALPHA,        /* 0x163 */
    ALPHA,        /* 0x164 */
    ALPHA,        /* 0x165 */
    ALPHA,        /* 0x166 */
    ALPHA,        /* 0x167 */
    ALPHA,        /* 0x168 */
    ALPHA,        /* 0x169 */
    ALPHA,        /* 0x16a */
    ALPHA,        /* 0x16b */
    ALPHA,        /* 0x16c */
    ALPHA,        /* 0x16d */
    ALPHA,        /* 0x16e */
    ALPHA,        /* 0x16f */
    ALPHA,        /* 0x170 */
    ALPHA,        /* 0x171 */
    ALPHA,        /* 0x172 */
    ALPHA,        /* 0x173 */
    ALPHA,        /* 0x174 */
    ALPHA,        /* 0x175 */
    ALPHA,        /* 0x176 */
    ALPHA,        /* 0x177 */
    ALPHA,        /* 0x178 */
    ALPHA,        /* 0x179 */
    ALPHA,        /* 0x17a */
    ALPHA,        /* 0x17b */
    ALPHA,        /* 0x17c */
    ALPHA,        /* 0x17d */
    ALPHA,        /* 0x17e */
    ALPHA,        /* 0x17f */
    ALPHA,        /* 0x180 */
    ALPHA,        /* 0x181 */
    ALPHA,        /* 0x182 */
    ALPHA,        /* 0x183 */
    ALPHA,        /* 0x184 */
    ALPHA,        /* 0x185 */
    ALPHA,        /* 0x186 */
    ALPHA,        /* 0x187 */
    ALPHA,        /* 0x188 */
    ALPHA,        /* 0x189 */
    ALPHA,        /* 0x18a */
    ALPHA,        /* 0x18b */
    ALPHA,        /* 0x18c */
    ALPHA,        /* 0x18d */
    ALPHA,        /* 0x18e */
    ALPHA,        /* 0x18f */
    ALPHA,        /* 0x190 */
    ALPHA,        /* 0x191 */
    ALPHA,        /* 0x192 */
    ALPHA,        /* 0x193 */
    ALPHA,        /* 0x194 */
    ALPHA,        /* 0x195 */
    ALPHA,        /* 0x196 */
    ALPHA,        /* 0x197 */
    ALPHA,        /* 0x198 */
    ALPHA,        /* 0x199 */
    ALPHA,        /* 0x19a */
    ALPHA,        /* 0x19b */
    ALPHA,        /* 0x19c */
    ALPHA,        /* 0x19d */
    ALPHA,        /* 0x19e */
    ALPHA,        /* 0x19f */
    ALPHA,        /* 0x1a0 */
    ALPHA,        /* 0x1a1 */
    ALPHA,        /* 0x1a2 */
    ALPHA,        /* 0x1a3 */
    ALPHA,        /* 0x1a4 */
    ALPHA,        /* 0x1a5 */
    ALPHA,        /* 0x1a6 */
    ALPHA,        /* 0x1a7 */
    ALPHA,        /* 0x1a8 */
    ALPHA,        /* 0x1a9 */
    ALPHA,        /* 0x1aa */
    ALPHA,        /* 0x1ab */
    ALPHA,        /* 0x1ac */
    ALPHA,        /* 0x1ad */
    ALPHA,        /* 0x1ae */
    ALPHA,        /* 0x1af */
    ALPHA,        /* 0x1b0 */
    ALPHA,        /* 0x1b1 */
    ALPHA,        /* 0x1b2 */
    ALPHA,        /* 0x1b3 */
    ALPHA,        /* 0x1b4 */
    ALPHA,        /* 0x1b5 */
    ALPHA,        /* 0x1b6 */
    ALPHA,        /* 0x1b7 */
    ALPHA,        /* 0x1b8 */
    ALPHA,        /* 0x1b9 */
    ALPHA,        /* 0x1ba */
    ALPHA,        /* 0x1bb */
    ALPHA,        /* 0x1bc */
    ALPHA,        /* 0x1bd */
    ALPHA,        /* 0x1be */
    ALPHA,        /* 0x1bf */
    ALPHA,        /* 0x1c0 */
    ALPHA,        /* 0x1c1 */
    ALPHA,        /* 0x1c2 */
    ALPHA,        /* 0x1c3 */
    ALPHA,        /* 0x1c4 */
    ALPHA,        /* 0x1c5 */
    ALPHA,        /* 0x1c6 */
    ALPHA,        /* 0x1c7 */
    ALPHA,        /* 0x1c8 */
    ALPHA,        /* 0x1c9 */
    ALPHA,        /* 0x1ca */
    ALPHA,        /* 0x1cb */
    ALPHA,        /* 0x1cc */
    ALPHA,        /* 0x1cd */
    ALPHA,        /* 0x1ce */
    ALPHA,        /* 0x1cf */
    ALPHA,        /* 0x1d0 */
    ALPHA,        /* 0x1d1 */
    ALPHA,        /* 0x1d2 */
    ALPHA,        /* 0x1d3 */
    ALPHA,        /* 0x1d4 */
    ALPHA,        /* 0x1d5 */
    ALPHA,        /* 0x1d6 */
    ALPHA,        /* 0x1d7 */
    ALPHA,        /* 0x1d8 */
    ALPHA,        /* 0x1d9 */
    ALPHA,        /* 0x1da */
    ALPHA,        /* 0x1db */
    ALPHA,        /* 0x1dc */
    ALPHA,        /* 0x1dd */
    ALPHA,        /* 0x1de */
    ALPHA,        /* 0x1df */
    ALPHA,        /* 0x1e0 */
    ALPHA,        /* 0x1e1 */
    ALPHA,        /* 0x1e2 */
    ALPHA,        /* 0x1e3 */
    ALPHA,        /* 0x1e4 */
    ALPHA,        /* 0x1e5 */
    ALPHA,        /* 0x1e6 */
    ALPHA,        /* 0x1e7 */
    ALPHA,        /* 0x1e8 */
    ALPHA,        /* 0x1e9 */
    ALPHA,        /* 0x1ea */
    ALPHA,        /* 0x1eb */
    ALPHA,        /* 0x1ec */
    ALPHA,        /* 0x1ed */
    ALPHA,        /* 0x1ee */
    ALPHA,        /* 0x1ef */
    ALPHA,        /* 0x1f0 */
    ALPHA,        /* 0x1f1 */
    ALPHA,        /* 0x1f2 */
    ALPHA,        /* 0x1f3 */
    ALPHA,        /* 0x1f4 */
    ALPHA,        /* 0x1f5 */
    ALPHA,        /* 0x1f6 */
    ALPHA,        /* 0x1f7 */
    ALPHA,        /* 0x1f8 */
    ALPHA,        /* 0x1f9 */
    ALPHA,        /* 0x1fa */
    ALPHA,        /* 0x1fb */
    ALPHA,        /* 0x1fc */
    ALPHA,        /* 0x1fd */
    ALPHA,        /* 0x1fe */
    ALPHA,        /* 0x1ff */
    ALPHA,        /* 0x200 */
    ALPHA,        /* 0x201 */
    ALPHA,        /* 0x202 */
    ALPHA,        /* 0x203 */
    ALPHA,        /* 0x204 */
    ALPHA,        /* 0x205 */
    ALPHA,        /* 0x206 */
    ALPHA,        /* 0x207 */
    ALPHA,        /* 0x208 */
    ALPHA,        /* 0x209 */
    ALPHA,        /* 0x20a */
    ALPHA,        /* 0x20b */
    ALPHA,        /* 0x20c */
    ALPHA,        /* 0x20d */
    ALPHA,        /* 0x20e */
    ALPHA,        /* 0x20f */
    ALPHA,        /* 0x210 */
    ALPHA,        /* 0x211 */
    ALPHA,        /* 0x212 */
    ALPHA,        /* 0x213 */
    ALPHA,        /* 0x214 */
    ALPHA,        /* 0x215 */
    ALPHA,        /* 0x216 */
    ALPHA,        /* 0x217 */
    ALPHA,        /* 0x218 */
    ALPHA,        /* 0x219 */
    ALPHA,        /* 0x21a */
    ALPHA,        /* 0x21b */
    ALPHA,        /* 0x21c */
    ALPHA,        /* 0x21d */
    ALPHA,        /* 0x21e */
    ALPHA,        /* 0x21f */
    ALPHA,        /* 0x220 */
    ALPHA,        /* 0x221 */
    ALPHA,        /* 0x222 */
    ALPHA,        /* 0x223 */
    ALPHA,        /* 0x224 */
    ALPHA,        /* 0x225 */
    ALPHA,        /* 0x226 */
    ALPHA,        /* 0x227 */
    ALPHA,        /* 0x228 */
    ALPHA,        /* 0x229 */
    ALPHA,        /* 0x22a */
    ALPHA,        /* 0x22b */
    ALPHA,        /* 0x22c */
    ALPHA,        /* 0x22d */
    ALPHA,        /* 0x22e */
    ALPHA,        /* 0x22f */
    ALPHA,        /* 0x230 */
    ALPHA,        /* 0x231 */
    ALPHA,        /* 0x232 */
    ALPHA,        /* 0x233 */
    ALPHA,        /* 0x234 */
    ALPHA,        /* 0x235 */
    ALPHA,        /* 0x236 */
    OTHER,        /* 0x237 */
    OTHER,        /* 0x238 */
    OTHER,        /* 0x239 */
    OTHER,        /* 0x23a */
    OTHER,        /* 0x23b */
    OTHER,        /* 0x23c */
    OTHER,        /* 0x23d */
    OTHER,        /* 0x23e */
    OTHER,        /* 0x23f */
    OTHER,        /* 0x240 */
    OTHER,        /* 0x241 */
    OTHER,        /* 0x242 */
    OTHER,        /* 0x243 */
    OTHER,        /* 0x244 */
    OTHER,        /* 0x245 */
    OTHER,        /* 0x246 */
    OTHER,        /* 0x247 */
    OTHER,        /* 0x248 */
    OTHER,        /* 0x249 */
    OTHER,        /* 0x24a */
    OTHER,        /* 0x24b */
    OTHER,        /* 0x24c */
    OTHER,        /* 0x24d */
    OTHER,        /* 0x24e */
    OTHER,        /* 0x24f */
    OTHER,        /* 0x250 */
    OTHER,        /* 0x251 */
    OTHER,        /* 0x252 */
    OTHER,        /* 0x253 */
    OTHER,        /* 0x254 */
    OTHER,        /* 0x255 */
    OTHER,        /* 0x256 */
    OTHER,        /* 0x257 */
    OTHER,        /* 0x258 */
    OTHER,        /* 0x259 */
    OTHER,        /* 0x25a */
    OTHER,        /* 0x25b */
    OTHER,        /* 0x25c */
    OTHER,        /* 0x25d */
    OTHER,        /* 0x25e */
    OTHER,        /* 0x25f */
    OTHER,        /* 0x260 */
    OTHER,        /* 0x261 */
    OTHER,        /* 0x262 */
    OTHER,        /* 0x263 */
    OTHER,        /* 0x264 */
    OTHER,        /* 0x265 */
    OTHER,        /* 0x266 */
    OTHER,        /* 0x267 */
    OTHER,        /* 0x268 */
    OTHER,        /* 0x269 */
    OTHER,        /* 0x26a */
    OTHER,        /* 0x26b */
    OTHER,        /* 0x26c */
    OTHER,        /* 0x26d */
    OTHER,        /* 0x26e */
    OTHER,        /* 0x26f */
    OTHER,        /* 0x270 */
    OTHER,        /* 0x271 */
    OTHER,        /* 0x272 */
    OTHER,        /* 0x273 */
    OTHER,        /* 0x274 */
    OTHER,        /* 0x275 */
    OTHER,        /* 0x276 */
    OTHER,        /* 0x277 */
    OTHER,        /* 0x278 */
    OTHER,        /* 0x279 */
    OTHER,        /* 0x27a */
    OTHER,        /* 0x27b */
    OTHER,        /* 0x27c */
    OTHER,        /* 0x27d */
    OTHER,        /* 0x27e */
    OTHER,        /* 0x27f */
    OTHER,        /* 0x280 */
    OTHER,        /* 0x281 */
    OTHER,        /* 0x282 */
    OTHER,        /* 0x283 */
    OTHER,        /* 0x284 */
    OTHER,        /* 0x285 */
    OTHER,        /* 0x286 */
    OTHER,        /* 0x287 */
    OTHER,        /* 0x288 */
    OTHER,        /* 0x289 */
    OTHER,        /* 0x28a */
    OTHER,        /* 0x28b */
    OTHER,        /* 0x28c */
    OTHER,        /* 0x28d */
    OTHER,        /* 0x28e */
    OTHER,        /* 0x28f */
    OTHER,        /* 0x290 */
    OTHER,        /* 0x291 */
    OTHER,        /* 0x292 */
    OTHER,        /* 0x293 */
    OTHER,        /* 0x294 */
    OTHER,        /* 0x295 */
    OTHER,        /* 0x296 */
    OTHER,        /* 0x297 */
    OTHER,        /* 0x298 */
    OTHER,        /* 0x299 */
    OTHER,        /* 0x29a */
    OTHER,        /* 0x29b */
    OTHER,        /* 0x29c */
    OTHER,        /* 0x29d */
    OTHER,        /* 0x29e */
    OTHER,        /* 0x29f */
    OTHER,        /* 0x2a0 */
    OTHER,        /* 0x2a1 */
    OTHER,        /* 0x2a2 */
    OTHER,        /* 0x2a3 */
    OTHER,        /* 0x2a4 */
    OTHER,        /* 0x2a5 */
    OTHER,        /* 0x2a6 */
    OTHER,        /* 0x2a7 */
    OTHER,        /* 0x2a8 */
    OTHER,        /* 0x2a9 */
    OTHER,        /* 0x2aa */
    OTHER,        /* 0x2ab */
    OTHER,        /* 0x2ac */
    OTHER,        /* 0x2ad */
    OTHER,        /* 0x2ae */
    OTHER,        /* 0x2af */
    OTHER,        /* 0x2b0 */
    OTHER,        /* 0x2b1 */
    OTHER,        /* 0x2b2 */
    OTHER,        /* 0x2b3 */
    OTHER,        /* 0x2b4 */
    OTHER,        /* 0x2b5 */
    OTHER,        /* 0x2b6 */
    OTHER,        /* 0x2b7 */
    OTHER,        /* 0x2b8 */
    OTHER,        /* 0x2b9 */
    OTHER,        /* 0x2ba */
    OTHER,        /* 0x2bb */
    OTHER,        /* 0x2bc */
    OTHER,        /* 0x2bd */
    OTHER,        /* 0x2be */
    OTHER,        /* 0x2bf */
    OTHER,        /* 0x2c0 */
    OTHER,        /* 0x2c1 */
    OTHER,        /* 0x2c2 */
    OTHER,        /* 0x2c3 */
    OTHER,        /* 0x2c4 */
    OTHER,        /* 0x2c5 */
    OTHER,        /* 0x2c6 */
    OTHER,        /* 0x2c7 */
    OTHER,        /* 0x2c8 */
    OTHER,        /* 0x2c9 */
    OTHER,        /* 0x2ca */
    OTHER,        /* 0x2cb */
    OTHER,        /* 0x2cc */
    OTHER,        /* 0x2cd */
    OTHER,        /* 0x2ce */
    OTHER,        /* 0x2cf */
    OTHER,        /* 0x2d0 */
    OTHER,        /* 0x2d1 */
    OTHER,        /* 0x2d2 */
    OTHER,        /* 0x2d3 */
    OTHER,        /* 0x2d4 */
    OTHER,        /* 0x2d5 */
    OTHER,        /* 0x2d6 */
    OTHER,        /* 0x2d7 */
    OTHER,        /* 0x2d8 */
    OTHER,        /* 0x2d9 */
    OTHER,        /* 0x2da */
    OTHER,        /* 0x2db */
    OTHER,        /* 0x2dc */
    OTHER,        /* 0x2dd */
    OTHER,        /* 0x2de */
    OTHER,        /* 0x2df */
    OTHER,        /* 0x2e0 */
    OTHER,        /* 0x2e1 */
    OTHER,        /* 0x2e2 */
    OTHER,        /* 0x2e3 */
    OTHER,        /* 0x2e4 */
    OTHER,        /* 0x2e5 */
    OTHER,        /* 0x2e6 */
    OTHER,        /* 0x2e7 */
    OTHER,        /* 0x2e8 */
    OTHER,        /* 0x2e9 */
    OTHER,        /* 0x2ea */
    OTHER,        /* 0x2eb */
    OTHER,        /* 0x2ec */
    OTHER,        /* 0x2ed */
    OTHER,        /* 0x2ee */
    OTHER,        /* 0x2ef */
    OTHER,        /* 0x2f0 */
    OTHER,        /* 0x2f1 */
    OTHER,        /* 0x2f2 */
    OTHER,        /* 0x2f3 */
    OTHER,        /* 0x2f4 */
    OTHER,        /* 0x2f5 */
    OTHER,        /* 0x2f6 */
    OTHER,        /* 0x2f7 */
    OTHER,        /* 0x2f8 */
    OTHER,        /* 0x2f9 */
    OTHER,        /* 0x2fa */
    OTHER,        /* 0x2fb */
    OTHER,        /* 0x2fc */
    OTHER,        /* 0x2fd */
    OTHER,        /* 0x2fe */
    OTHER,        /* 0x2ff */
    OTHER,        /* 0x300 */
    OTHER,        /* 0x301 */
    OTHER,        /* 0x302 */
    OTHER,        /* 0x303 */
    OTHER,        /* 0x304 */
    OTHER,        /* 0x305 */
    OTHER,        /* 0x306 */
    OTHER,        /* 0x307 */
    OTHER,        /* 0x308 */
    OTHER,        /* 0x309 */
    OTHER,        /* 0x30a */
    OTHER,        /* 0x30b */
    OTHER,        /* 0x30c */
    OTHER,        /* 0x30d */
    OTHER,        /* 0x30e */
    OTHER,        /* 0x30f */
    OTHER,        /* 0x310 */
    OTHER,        /* 0x311 */
    OTHER,        /* 0x312 */
    OTHER,        /* 0x313 */
    OTHER,        /* 0x314 */
    OTHER,        /* 0x315 */
    OTHER,        /* 0x316 */
    OTHER,        /* 0x317 */
    OTHER,        /* 0x318 */
    OTHER,        /* 0x319 */
    OTHER,        /* 0x31a */
    OTHER,        /* 0x31b */
    OTHER,        /* 0x31c */
    OTHER,        /* 0x31d */
    OTHER,        /* 0x31e */
    OTHER,        /* 0x31f */
    OTHER,        /* 0x320 */
    OTHER,        /* 0x321 */
    OTHER,        /* 0x322 */
    OTHER,        /* 0x323 */
    OTHER,        /* 0x324 */
    OTHER,        /* 0x325 */
    OTHER,        /* 0x326 */
    OTHER,        /* 0x327 */
    OTHER,        /* 0x328 */
    OTHER,        /* 0x329 */
    OTHER,        /* 0x32a */
    OTHER,        /* 0x32b */
    OTHER,        /* 0x32c */
    OTHER,        /* 0x32d */
    OTHER,        /* 0x32e */
    OTHER,        /* 0x32f */
    OTHER,        /* 0x330 */
    OTHER,        /* 0x331 */
    OTHER,        /* 0x332 */
    OTHER,        /* 0x333 */
    OTHER,        /* 0x334 */
    OTHER,        /* 0x335 */
    OTHER,        /* 0x336 */
    OTHER,        /* 0x337 */
    OTHER,        /* 0x338 */
    OTHER,        /* 0x339 */
    OTHER,        /* 0x33a */
    OTHER,        /* 0x33b */
    OTHER,        /* 0x33c */
    OTHER,        /* 0x33d */
    OTHER,        /* 0x33e */
    OTHER,        /* 0x33f */
    OTHER,        /* 0x340 */
    OTHER,        /* 0x341 */
    OTHER,        /* 0x342 */
    OTHER,        /* 0x343 */
    OTHER,        /* 0x344 */
    OTHER,        /* 0x345 */
    OTHER,        /* 0x346 */
    OTHER,        /* 0x347 */
    OTHER,        /* 0x348 */
    OTHER,        /* 0x349 */
    OTHER,        /* 0x34a */
    OTHER,        /* 0x34b */
    OTHER,        /* 0x34c */
    OTHER,        /* 0x34d */
    OTHER,        /* 0x34e */
    OTHER,        /* 0x34f */
    OTHER,        /* 0x350 */
    OTHER,        /* 0x351 */
    OTHER,        /* 0x352 */
    OTHER,        /* 0x353 */
    OTHER,        /* 0x354 */
    OTHER,        /* 0x355 */
    OTHER,        /* 0x356 */
    OTHER,        /* 0x357 */
    OTHER,        /* 0x358 */
    OTHER,        /* 0x359 */
    OTHER,        /* 0x35a */
    OTHER,        /* 0x35b */
    OTHER,        /* 0x35c */
    OTHER,        /* 0x35d */
    OTHER,        /* 0x35e */
    OTHER,        /* 0x35f */
    OTHER,        /* 0x360 */
    OTHER,        /* 0x361 */
    OTHER,        /* 0x362 */
    OTHER,        /* 0x363 */
    OTHER,        /* 0x364 */
    OTHER,        /* 0x365 */
    OTHER,        /* 0x366 */
    OTHER,        /* 0x367 */
    OTHER,        /* 0x368 */
    OTHER,        /* 0x369 */
    OTHER,        /* 0x36a */
    OTHER,        /* 0x36b */
    OTHER,        /* 0x36c */
    OTHER,        /* 0x36d */
    OTHER,        /* 0x36e */
    OTHER,        /* 0x36f */
    OTHER,        /* 0x370 */
    OTHER,        /* 0x371 */
    OTHER,        /* 0x372 */
    OTHER,        /* 0x373 */
    GREEK,        /* 0x374 */
    GREEK,        /* 0x375 */
    GREEK,        /* 0x376 */
    GREEK,        /* 0x377 */
    GREEK,        /* 0x378 */
    GREEK,        /* 0x379 */
    GREEK,        /* 0x37a */
    GREEK,        /* 0x37b */
    GREEK,        /* 0x37c */
    GREEK,        /* 0x37d */
    GREEK,        /* 0x37e */
    GREEK,        /* 0x37f */
    GREEK,        /* 0x380 */
    GREEK,        /* 0x381 */
    GREEK,        /* 0x382 */
    GREEK,        /* 0x383 */
    GREEK,        /* 0x384 */
    GREEK,        /* 0x385 */
    GREEK,        /* 0x386 */
    GREEK,        /* 0x387 */
    GREEK,        /* 0x388 */
    GREEK,        /* 0x389 */
    GREEK,        /* 0x38a */
    GREEK,        /* 0x38b */
    GREEK,        /* 0x38c */
    GREEK,        /* 0x38d */
    GREEK,        /* 0x38e */
    GREEK,        /* 0x38f */
    GREEK,        /* 0x390 */
    GREEK,        /* 0x391 */
    GREEK,        /* 0x392 */
    GREEK,        /* 0x393 */
    GREEK,        /* 0x394 */
    GREEK,        /* 0x395 */
    GREEK,        /* 0x396 */
    GREEK,        /* 0x397 */
    GREEK,        /* 0x398 */
    GREEK,        /* 0x399 */
    GREEK,        /* 0x39a */
    GREEK,        /* 0x39b */
    GREEK,        /* 0x39c */
    GREEK,        /* 0x39d */
    GREEK,        /* 0x39e */
    GREEK,        /* 0x39f */
    GREEK,        /* 0x3a0 */
    GREEK,        /* 0x3a1 */
    GREEK,        /* 0x3a2 */
    GREEK,        /* 0x3a3 */
    GREEK,        /* 0x3a4 */
    GREEK,        /* 0x3a5 */
    GREEK,        /* 0x3a6 */
    GREEK,        /* 0x3a7 */
    GREEK,        /* 0x3a8 */
    GREEK,        /* 0x3a9 */
    GREEK,        /* 0x3aa */
    GREEK,        /* 0x3ab */
    GREEK,        /* 0x3ac */
    GREEK,        /* 0x3ad */
    GREEK,        /* 0x3ae */
    GREEK,        /* 0x3af */
    GREEK,        /* 0x3b0 */
    GREEK,        /* 0x3b1 */
    GREEK,        /* 0x3b2 */
    GREEK,        /* 0x3b3 */
    GREEK,        /* 0x3b4 */
    GREEK,        /* 0x3b5 */
    GREEK,        /* 0x3b6 */
    GREEK,        /* 0x3b7 */
    GREEK,        /* 0x3b8 */
    GREEK,        /* 0x3b9 */
    GREEK,        /* 0x3ba */
    GREEK,        /* 0x3bb */
    GREEK,        /* 0x3bc */
    GREEK,        /* 0x3bd */
    GREEK,        /* 0x3be */
    GREEK,        /* 0x3bf */
    GREEK,        /* 0x3c0 */
    GREEK,        /* 0x3c1 */
    GREEK,        /* 0x3c2 */
    GREEK,        /* 0x3c3 */
    GREEK,        /* 0x3c4 */
    GREEK,        /* 0x3c5 */
    GREEK,        /* 0x3c6 */
    GREEK,        /* 0x3c7 */
    GREEK,        /* 0x3c8 */
    GREEK,        /* 0x3c9 */
    GREEK,        /* 0x3ca */
    GREEK,        /* 0x3cb */
    GREEK,        /* 0x3cc */
    GREEK,        /* 0x3cd */
    GREEK,        /* 0x3ce */
    GREEK,        /* 0x3cf */
    GREEK,        /* 0x3d0 */
    GREEK,        /* 0x3d1 */
    GREEK,        /* 0x3d2 */
    GREEK,        /* 0x3d3 */
    GREEK,        /* 0x3d4 */
    GREEK,        /* 0x3d5 */
    GREEK,        /* 0x3d6 */
    GREEK,        /* 0x3d7 */
    GREEK,        /* 0x3d8 */
    GREEK,        /* 0x3d9 */
    GREEK,        /* 0x3da */
    GREEK,        /* 0x3db */
    GREEK,        /* 0x3dc */
    GREEK,        /* 0x3dd */
    GREEK,        /* 0x3de */
    GREEK,        /* 0x3df */
    GREEK,        /* 0x3e0 */
    GREEK,        /* 0x3e1 */
    GREEK,        /* 0x3e2 */
    GREEK,        /* 0x3e3 */
    GREEK,        /* 0x3e4 */
    GREEK,        /* 0x3e5 */
    GREEK,        /* 0x3e6 */
    GREEK,        /* 0x3e7 */
    GREEK,        /* 0x3e8 */
    GREEK,        /* 0x3e9 */
    GREEK,        /* 0x3ea */
    GREEK,        /* 0x3eb */
    GREEK,        /* 0x3ec */
    GREEK,        /* 0x3ed */
    GREEK,        /* 0x3ee */
    GREEK,        /* 0x3ef */
    GREEK,        /* 0x3f0 */
    GREEK,        /* 0x3f1 */
    GREEK,        /* 0x3f2 */
    GREEK,        /* 0x3f3 */
    GREEK,        /* 0x3f4 */
    GREEK,        /* 0x3f5 */
    GREEK,        /* 0x3f6 */
    GREEK,        /* 0x3f7 */
    GREEK,        /* 0x3f8 */
    GREEK,        /* 0x3f9 */
    GREEK,        /* 0x3fa */
    GREEK,        /* 0x3fb */
    OTHER,        /* 0x3fc */
    OTHER,        /* 0x3fd */
    OTHER,        /* 0x3fe */
    OTHER,        /* 0x3ff */
    CYRILLIC,        /* 0x400 */
    CYRILLIC,        /* 0x401 */
    CYRILLIC,        /* 0x402 */
    CYRILLIC,        /* 0x403 */
    CYRILLIC,        /* 0x404 */
    CYRILLIC,        /* 0x405 */
    CYRILLIC,        /* 0x406 */
    CYRILLIC,        /* 0x407 */
    CYRILLIC,        /* 0x408 */
    CYRILLIC,        /* 0x409 */
    CYRILLIC,        /* 0x40a */
    CYRILLIC,        /* 0x40b */
    CYRILLIC,        /* 0x40c */
    CYRILLIC,        /* 0x40d */
    CYRILLIC,        /* 0x40e */
    CYRILLIC,        /* 0x40f */
    CYRILLIC,        /* 0x410 */
    CYRILLIC,        /* 0x411 */
    CYRILLIC,        /* 0x412 */
    CYRILLIC,        /* 0x413 */
    CYRILLIC,        /* 0x414 */
    CYRILLIC,        /* 0x415 */
    CYRILLIC,        /* 0x416 */
    CYRILLIC,        /* 0x417 */
    CYRILLIC,        /* 0x418 */
    CYRILLIC,        /* 0x419 */
    CYRILLIC,        /* 0x41a */
    CYRILLIC,        /* 0x41b */
    CYRILLIC,        /* 0x41c */
    CYRILLIC,        /* 0x41d */
    CYRILLIC,        /* 0x41e */
    CYRILLIC,        /* 0x41f */
    CYRILLIC,        /* 0x420 */
    CYRILLIC,        /* 0x421 */
    CYRILLIC,        /* 0x422 */
    CYRILLIC,        /* 0x423 */
    CYRILLIC,        /* 0x424 */
    CYRILLIC,        /* 0x425 */
    CYRILLIC,        /* 0x426 */
    CYRILLIC,        /* 0x427 */
    CYRILLIC,        /* 0x428 */
    CYRILLIC,        /* 0x429 */
    CYRILLIC,        /* 0x42a */
    CYRILLIC,        /* 0x42b */
    CYRILLIC,        /* 0x42c */
    CYRILLIC,        /* 0x42d */
    CYRILLIC,        /* 0x42e */
    CYRILLIC,        /* 0x42f */
    CYRILLIC,        /* 0x430 */
    CYRILLIC,        /* 0x431 */
    CYRILLIC,        /* 0x432 */
    CYRILLIC,        /* 0x433 */
    CYRILLIC,        /* 0x434 */
    CYRILLIC,        /* 0x435 */
    CYRILLIC,        /* 0x436 */
    CYRILLIC,        /* 0x437 */
    CYRILLIC,        /* 0x438 */
    CYRILLIC,        /* 0x439 */
    CYRILLIC,        /* 0x43a */
    CYRILLIC,        /* 0x43b */
    CYRILLIC,        /* 0x43c */
    CYRILLIC,        /* 0x43d */
    CYRILLIC,        /* 0x43e */
    CYRILLIC,        /* 0x43f */
    CYRILLIC,        /* 0x440 */
    CYRILLIC,        /* 0x441 */
    CYRILLIC,        /* 0x442 */
    CYRILLIC,        /* 0x443 */
    CYRILLIC,        /* 0x444 */
    CYRILLIC,        /* 0x445 */
    CYRILLIC,        /* 0x446 */
    CYRILLIC,        /* 0x447 */
    CYRILLIC,        /* 0x448 */
    CYRILLIC,        /* 0x449 */
    CYRILLIC,        /* 0x44a */
    CYRILLIC,        /* 0x44b */
    CYRILLIC,        /* 0x44c */
    CYRILLIC,        /* 0x44d */
    CYRILLIC,        /* 0x44e */
    CYRILLIC,        /* 0x44f */
    CYRILLIC,        /* 0x450 */
    CYRILLIC,        /* 0x451 */
    CYRILLIC,        /* 0x452 */
    CYRILLIC,        /* 0x453 */
    CYRILLIC,        /* 0x454 */
    CYRILLIC,        /* 0x455 */
    CYRILLIC,        /* 0x456 */
    CYRILLIC,        /* 0x457 */
    CYRILLIC,        /* 0x458 */
    CYRILLIC,        /* 0x459 */
    CYRILLIC,        /* 0x45a */
    CYRILLIC,        /* 0x45b */
    CYRILLIC,        /* 0x45c */
    CYRILLIC,        /* 0x45d */
    CYRILLIC,        /* 0x45e */
    CYRILLIC,        /* 0x45f */
    CYRILLIC,        /* 0x460 */
    CYRILLIC,        /* 0x461 */
    CYRILLIC,        /* 0x462 */
    CYRILLIC,        /* 0x463 */
    CYRILLIC,        /* 0x464 */
    CYRILLIC,        /* 0x465 */
    CYRILLIC,        /* 0x466 */
    CYRILLIC,        /* 0x467 */
    CYRILLIC,        /* 0x468 */
    CYRILLIC,        /* 0x469 */
    CYRILLIC,        /* 0x46a */
    CYRILLIC,        /* 0x46b */
    CYRILLIC,        /* 0x46c */
    CYRILLIC,        /* 0x46d */
    CYRILLIC,        /* 0x46e */
    CYRILLIC,        /* 0x46f */
    CYRILLIC,        /* 0x470 */
    CYRILLIC,        /* 0x471 */
    CYRILLIC,        /* 0x472 */
    CYRILLIC,        /* 0x473 */
    CYRILLIC,        /* 0x474 */
    CYRILLIC,        /* 0x475 */
    CYRILLIC,        /* 0x476 */
    CYRILLIC,        /* 0x477 */
    CYRILLIC,        /* 0x478 */
    CYRILLIC,        /* 0x479 */
    CYRILLIC,        /* 0x47a */
    CYRILLIC,        /* 0x47b */
    CYRILLIC,        /* 0x47c */
    CYRILLIC,        /* 0x47d */
    CYRILLIC,        /* 0x47e */
    CYRILLIC,        /* 0x47f */
    CYRILLIC,        /* 0x480 */
    CYRILLIC,        /* 0x481 */
    CYRILLIC,        /* 0x482 */
    CYRILLIC,        /* 0x483 */
    CYRILLIC,        /* 0x484 */
    CYRILLIC,        /* 0x485 */
    CYRILLIC,        /* 0x486 */
    CYRILLIC,        /* 0x487 */
    CYRILLIC,        /* 0x488 */
    CYRILLIC,        /* 0x489 */
    CYRILLIC,        /* 0x48a */
    CYRILLIC,        /* 0x48b */
    CYRILLIC,        /* 0x48c */
    CYRILLIC,        /* 0x48d */
    CYRILLIC,        /* 0x48e */
    CYRILLIC,        /* 0x48f */
    CYRILLIC,        /* 0x490 */
    CYRILLIC,        /* 0x491 */
    CYRILLIC,        /* 0x492 */
    CYRILLIC,        /* 0x493 */
    CYRILLIC,        /* 0x494 */
    CYRILLIC,        /* 0x495 */
    CYRILLIC,        /* 0x496 */
    CYRILLIC,        /* 0x497 */
    CYRILLIC,        /* 0x498 */
    CYRILLIC,        /* 0x499 */
    CYRILLIC,        /* 0x49a */
    CYRILLIC,        /* 0x49b */
    CYRILLIC,        /* 0x49c */
    CYRILLIC,        /* 0x49d */
    CYRILLIC,        /* 0x49e */
    CYRILLIC,        /* 0x49f */
    CYRILLIC,        /* 0x4a0 */
    CYRILLIC,        /* 0x4a1 */
    CYRILLIC,        /* 0x4a2 */
    CYRILLIC,        /* 0x4a3 */
    CYRILLIC,        /* 0x4a4 */
    CYRILLIC,        /* 0x4a5 */
    CYRILLIC,        /* 0x4a6 */
    CYRILLIC,        /* 0x4a7 */
    CYRILLIC,        /* 0x4a8 */
    CYRILLIC,        /* 0x4a9 */
    CYRILLIC,        /* 0x4aa */
    CYRILLIC,        /* 0x4ab */
    CYRILLIC,        /* 0x4ac */
    CYRILLIC,        /* 0x4ad */
    CYRILLIC,        /* 0x4ae */
    CYRILLIC,        /* 0x4af */
    CYRILLIC,        /* 0x4b0 */
    CYRILLIC,        /* 0x4b1 */
    CYRILLIC,        /* 0x4b2 */
    CYRILLIC,        /* 0x4b3 */
    CYRILLIC,        /* 0x4b4 */
    CYRILLIC,        /* 0x4b5 */
    CYRILLIC,        /* 0x4b6 */
    CYRILLIC,        /* 0x4b7 */
    CYRILLIC,        /* 0x4b8 */
    CYRILLIC,        /* 0x4b9 */
    CYRILLIC,        /* 0x4ba */
    CYRILLIC,        /* 0x4bb */
    CYRILLIC,        /* 0x4bc */
    CYRILLIC,        /* 0x4bd */
    CYRILLIC,        /* 0x4be */
    CYRILLIC,        /* 0x4bf */
    CYRILLIC,        /* 0x4c0 */
    CYRILLIC,        /* 0x4c1 */
    CYRILLIC,        /* 0x4c2 */
    CYRILLIC,        /* 0x4c3 */
    CYRILLIC,        /* 0x4c4 */
    CYRILLIC,        /* 0x4c5 */
    CYRILLIC,        /* 0x4c6 */
    CYRILLIC,        /* 0x4c7 */
    CYRILLIC,        /* 0x4c8 */
    CYRILLIC,        /* 0x4c9 */
    CYRILLIC,        /* 0x4ca */
    CYRILLIC,        /* 0x4cb */
    CYRILLIC,        /* 0x4cc */
    CYRILLIC,        /* 0x4cd */
    CYRILLIC,        /* 0x4ce */
    CYRILLIC,        /* 0x4cf */
    CYRILLIC,        /* 0x4d0 */
    CYRILLIC,        /* 0x4d1 */
    CYRILLIC,        /* 0x4d2 */
    CYRILLIC,        /* 0x4d3 */
    CYRILLIC,        /* 0x4d4 */
    CYRILLIC,        /* 0x4d5 */
    CYRILLIC,        /* 0x4d6 */
    CYRILLIC,        /* 0x4d7 */
    CYRILLIC,        /* 0x4d8 */
    CYRILLIC,        /* 0x4d9 */
    CYRILLIC,        /* 0x4da */
    CYRILLIC,        /* 0x4db */
    CYRILLIC,        /* 0x4dc */
    CYRILLIC,        /* 0x4dd */
    CYRILLIC,        /* 0x4de */
    CYRILLIC,        /* 0x4df */
    CYRILLIC,        /* 0x4e0 */
    CYRILLIC,        /* 0x4e1 */
    CYRILLIC,        /* 0x4e2 */
    CYRILLIC,        /* 0x4e3 */
    CYRILLIC,        /* 0x4e4 */
    CYRILLIC,        /* 0x4e5 */
    CYRILLIC,        /* 0x4e6 */
    CYRILLIC,        /* 0x4e7 */
    CYRILLIC,        /* 0x4e8 */
    CYRILLIC,        /* 0x4e9 */
    CYRILLIC,        /* 0x4ea */
    CYRILLIC,        /* 0x4eb */
    CYRILLIC,        /* 0x4ec */
    CYRILLIC,        /* 0x4ed */
    CYRILLIC,        /* 0x4ee */
    CYRILLIC,        /* 0x4ef */
    CYRILLIC,        /* 0x4f0 */
    CYRILLIC,        /* 0x4f1 */
    CYRILLIC,        /* 0x4f2 */
    CYRILLIC,        /* 0x4f3 */
    CYRILLIC,        /* 0x4f4 */
    CYRILLIC,        /* 0x4f5 */
    CYRILLIC,        /* 0x4f6 */
    CYRILLIC,        /* 0x4f7 */
    CYRILLIC,        /* 0x4f8 */
    CYRILLIC,        /* 0x4f9 */
    OTHER,        /* 0x4fa */
    OTHER,        /* 0x4fb */
    OTHER,        /* 0x4fc */
    OTHER,        /* 0x4fd */
    OTHER,        /* 0x4fe */
    OTHER,        /* 0x4ff */
    CYRILLIC,        /* 0x500 */
    CYRILLIC,        /* 0x501 */
    CYRILLIC,        /* 0x502 */
    CYRILLIC,        /* 0x503 */
    CYRILLIC,        /* 0x504 */
    CYRILLIC,        /* 0x505 */
    CYRILLIC,        /* 0x506 */
    CYRILLIC,        /* 0x507 */
    CYRILLIC,        /* 0x508 */
    CYRILLIC,        /* 0x509 */
    CYRILLIC,        /* 0x50a */
    CYRILLIC,        /* 0x50b */
    CYRILLIC,        /* 0x50c */
    CYRILLIC,        /* 0x50d */
    CYRILLIC,        /* 0x50e */
    CYRILLIC,        /* 0x50f */
    OTHER,        /* 0x510 */
    OTHER,        /* 0x511 */
    OTHER,        /* 0x512 */
    OTHER,        /* 0x513 */
    OTHER,        /* 0x514 */
    OTHER,        /* 0x515 */
    OTHER,        /* 0x516 */
    OTHER,        /* 0x517 */
    OTHER,        /* 0x518 */
    OTHER,        /* 0x519 */
    OTHER,        /* 0x51a */
    OTHER,        /* 0x51b */
    OTHER,        /* 0x51c */
    OTHER,        /* 0x51d */
    OTHER,        /* 0x51e */
    OTHER,        /* 0x51f */
    OTHER,        /* 0x520 */
    OTHER,        /* 0x521 */
    OTHER,        /* 0x522 */
    OTHER,        /* 0x523 */
    OTHER,        /* 0x524 */
    OTHER,        /* 0x525 */
    OTHER,        /* 0x526 */
    OTHER,        /* 0x527 */
    OTHER,        /* 0x528 */
    OTHER,        /* 0x529 */
    OTHER,        /* 0x52a */
    OTHER,        /* 0x52b */
    OTHER,        /* 0x52c */
    OTHER,        /* 0x52d */
    OTHER,        /* 0x52e */
    OTHER,        /* 0x52f */
    OTHER,        /* 0x530 */
    OTHER,        /* 0x531 */
    OTHER,        /* 0x532 */
    OTHER,        /* 0x533 */
    OTHER,        /* 0x534 */
    OTHER,        /* 0x535 */
    OTHER,        /* 0x536 */
    OTHER,        /* 0x537 */
    OTHER,        /* 0x538 */
    OTHER,        /* 0x539 */
    OTHER,        /* 0x53a */
    OTHER,        /* 0x53b */
    OTHER,        /* 0x53c */
    OTHER,        /* 0x53d */
    OTHER,        /* 0x53e */
    OTHER,        /* 0x53f */
    OTHER,        /* 0x540 */
    OTHER,        /* 0x541 */
    OTHER,        /* 0x542 */
    OTHER,        /* 0x543 */
    OTHER,        /* 0x544 */
    OTHER,        /* 0x545 */
    OTHER,        /* 0x546 */
    OTHER,        /* 0x547 */
    OTHER,        /* 0x548 */
    OTHER,        /* 0x549 */
    OTHER,        /* 0x54a */
    OTHER,        /* 0x54b */
    OTHER,        /* 0x54c */
    OTHER,        /* 0x54d */
    OTHER,        /* 0x54e */
    OTHER,        /* 0x54f */
    OTHER,        /* 0x550 */
    OTHER,        /* 0x551 */
    OTHER,        /* 0x552 */
    OTHER,        /* 0x553 */
    OTHER,        /* 0x554 */
    OTHER,        /* 0x555 */
    OTHER,        /* 0x556 */
    OTHER,        /* 0x557 */
    OTHER,        /* 0x558 */
    OTHER,        /* 0x559 */
    OTHER,        /* 0x55a */
    OTHER,        /* 0x55b */
    OTHER,        /* 0x55c */
    OTHER,        /* 0x55d */
    OTHER,        /* 0x55e */
    OTHER,        /* 0x55f */
    OTHER,        /* 0x560 */
    OTHER,        /* 0x561 */
    OTHER,        /* 0x562 */
    OTHER,        /* 0x563 */
    OTHER,        /* 0x564 */
    OTHER,        /* 0x565 */
    OTHER,        /* 0x566 */
    OTHER,        /* 0x567 */
    OTHER,        /* 0x568 */
    OTHER,        /* 0x569 */
    OTHER,        /* 0x56a */
    OTHER,        /* 0x56b */
    OTHER,        /* 0x56c */
    OTHER,        /* 0x56d */
    OTHER,        /* 0x56e */
    OTHER,        /* 0x56f */
    OTHER,        /* 0x570 */
    OTHER,        /* 0x571 */
    OTHER,        /* 0x572 */
    OTHER,        /* 0x573 */
    OTHER,        /* 0x574 */
    OTHER,        /* 0x575 */
    OTHER,        /* 0x576 */
    OTHER,        /* 0x577 */
    OTHER,        /* 0x578 */
    OTHER,        /* 0x579 */
    OTHER,        /* 0x57a */
    OTHER,        /* 0x57b */
    OTHER,        /* 0x57c */
    OTHER,        /* 0x57d */
    OTHER,        /* 0x57e */
    OTHER,        /* 0x57f */
    OTHER,        /* 0x580 */
    OTHER,        /* 0x581 */
    OTHER,        /* 0x582 */
    OTHER,        /* 0x583 */
    OTHER,        /* 0x584 */
    OTHER,        /* 0x585 */
    OTHER,        /* 0x586 */
    OTHER,        /* 0x587 */
    OTHER,        /* 0x588 */
    OTHER,        /* 0x589 */
    OTHER,        /* 0x58a */
    OTHER,        /* 0x58b */
    OTHER,        /* 0x58c */
    OTHER,        /* 0x58d */
    OTHER,        /* 0x58e */
    OTHER,        /* 0x58f */
    OTHER,        /* 0x590 */
    OTHER,        /* 0x591 */
    OTHER,        /* 0x592 */
    OTHER,        /* 0x593 */
    OTHER,        /* 0x594 */
    OTHER,        /* 0x595 */
    OTHER,        /* 0x596 */
    OTHER,        /* 0x597 */
    OTHER,        /* 0x598 */
    OTHER,        /* 0x599 */
    OTHER,        /* 0x59a */
    OTHER,        /* 0x59b */
    OTHER,        /* 0x59c */
    OTHER,        /* 0x59d */
    OTHER,        /* 0x59e */
    OTHER,        /* 0x59f */
    OTHER,        /* 0x5a0 */
    OTHER,        /* 0x5a1 */
    OTHER,        /* 0x5a2 */
    OTHER,        /* 0x5a3 */
    OTHER,        /* 0x5a4 */
    OTHER,        /* 0x5a5 */
    OTHER,        /* 0x5a6 */
    OTHER,        /* 0x5a7 */
    OTHER,        /* 0x5a8 */
    OTHER,        /* 0x5a9 */
    OTHER,        /* 0x5aa */
    OTHER,        /* 0x5ab */
    OTHER,        /* 0x5ac */
    OTHER,        /* 0x5ad */
    OTHER,        /* 0x5ae */
    OTHER,        /* 0x5af */
    OTHER,        /* 0x5b0 */
    OTHER,        /* 0x5b1 */
    OTHER,        /* 0x5b2 */
    OTHER,        /* 0x5b3 */
    OTHER,        /* 0x5b4 */
    OTHER,        /* 0x5b5 */
    OTHER,        /* 0x5b6 */
    OTHER,        /* 0x5b7 */
    OTHER,        /* 0x5b8 */
    OTHER,        /* 0x5b9 */
    OTHER,        /* 0x5ba */
    OTHER,        /* 0x5bb */
    OTHER,        /* 0x5bc */
    OTHER,        /* 0x5bd */
    OTHER,        /* 0x5be */
    OTHER,        /* 0x5bf */
    OTHER,        /* 0x5c0 */
    OTHER,        /* 0x5c1 */
    OTHER,        /* 0x5c2 */
    OTHER,        /* 0x5c3 */
    OTHER,        /* 0x5c4 */
    OTHER,        /* 0x5c5 */
    OTHER,        /* 0x5c6 */
    OTHER,        /* 0x5c7 */
    OTHER,        /* 0x5c8 */
    OTHER,        /* 0x5c9 */
    OTHER,        /* 0x5ca */
    OTHER,        /* 0x5cb */
    OTHER,        /* 0x5cc */
    OTHER,        /* 0x5cd */
    OTHER,        /* 0x5ce */
    OTHER,        /* 0x5cf */
    OTHER,        /* 0x5d0 */
    OTHER,        /* 0x5d1 */
    OTHER,        /* 0x5d2 */
    OTHER,        /* 0x5d3 */
    OTHER,        /* 0x5d4 */
    OTHER,        /* 0x5d5 */
    OTHER,        /* 0x5d6 */
    OTHER,        /* 0x5d7 */
    OTHER,        /* 0x5d8 */
    OTHER,        /* 0x5d9 */
    OTHER,        /* 0x5da */
    OTHER,        /* 0x5db */
    OTHER,        /* 0x5dc */
    OTHER,        /* 0x5dd */
    OTHER,        /* 0x5de */
    OTHER,        /* 0x5df */
    OTHER,        /* 0x5e0 */
    OTHER,        /* 0x5e1 */
    OTHER,        /* 0x5e2 */
    OTHER,        /* 0x5e3 */
    OTHER,        /* 0x5e4 */
    OTHER,        /* 0x5e5 */
    OTHER,        /* 0x5e6 */
    OTHER,        /* 0x5e7 */
    OTHER,        /* 0x5e8 */
    OTHER,        /* 0x5e9 */
    OTHER,        /* 0x5ea */
    OTHER,        /* 0x5eb */
    OTHER,        /* 0x5ec */
    OTHER,        /* 0x5ed */
    OTHER,        /* 0x5ee */
    OTHER,        /* 0x5ef */
    OTHER,        /* 0x5f0 */
    OTHER,        /* 0x5f1 */
    OTHER,        /* 0x5f2 */
    OTHER,        /* 0x5f3 */
    OTHER,        /* 0x5f4 */
    OTHER,        /* 0x5f5 */
    OTHER,        /* 0x5f6 */
    OTHER,        /* 0x5f7 */
    OTHER,        /* 0x5f8 */
    OTHER,        /* 0x5f9 */
    OTHER,        /* 0x5fa */
    OTHER,        /* 0x5fb */
    OTHER,        /* 0x5fc */
    OTHER,        /* 0x5fd */
    OTHER,        /* 0x5fe */
    OTHER,        /* 0x5ff */
    OTHER,        /* 0x600 */
    OTHER,        /* 0x601 */
    OTHER,        /* 0x602 */
    OTHER,        /* 0x603 */
    OTHER,        /* 0x604 */
    OTHER,        /* 0x605 */
    OTHER,        /* 0x606 */
    OTHER,        /* 0x607 */
    OTHER,        /* 0x608 */
    OTHER,        /* 0x609 */
    OTHER,        /* 0x60a */
    OTHER,        /* 0x60b */
    OTHER,        /* 0x60c */
    OTHER,        /* 0x60d */
    OTHER,        /* 0x60e */
    OTHER,        /* 0x60f */
    OTHER,        /* 0x610 */
    OTHER,        /* 0x611 */
    OTHER,        /* 0x612 */
    OTHER,        /* 0x613 */
    OTHER,        /* 0x614 */
    OTHER,        /* 0x615 */
    OTHER,        /* 0x616 */
    OTHER,        /* 0x617 */
    OTHER,        /* 0x618 */
    OTHER,        /* 0x619 */
    OTHER,        /* 0x61a */
    OTHER,        /* 0x61b */
    OTHER,        /* 0x61c */
    OTHER,        /* 0x61d */
    OTHER,        /* 0x61e */
    OTHER,        /* 0x61f */
    OTHER,        /* 0x620 */
    OTHER,        /* 0x621 */
    OTHER,        /* 0x622 */
    OTHER,        /* 0x623 */
    OTHER,        /* 0x624 */
    OTHER,        /* 0x625 */
    OTHER,        /* 0x626 */
    OTHER,        /* 0x627 */
    OTHER,        /* 0x628 */
    OTHER,        /* 0x629 */
    OTHER,        /* 0x62a */
    OTHER,        /* 0x62b */
    OTHER,        /* 0x62c */
    OTHER,        /* 0x62d */
    OTHER,        /* 0x62e */
    OTHER,        /* 0x62f */
    OTHER,        /* 0x630 */
    OTHER,        /* 0x631 */
    OTHER,        /* 0x632 */
    OTHER,        /* 0x633 */
    OTHER,        /* 0x634 */
    OTHER,        /* 0x635 */
    OTHER,        /* 0x636 */
    OTHER,        /* 0x637 */
    OTHER,        /* 0x638 */
    OTHER,        /* 0x639 */
    OTHER,        /* 0x63a */
    OTHER,        /* 0x63b */
    OTHER,        /* 0x63c */
    OTHER,        /* 0x63d */
    OTHER,        /* 0x63e */
    OTHER,        /* 0x63f */
    OTHER,        /* 0x640 */
    OTHER,        /* 0x641 */
    OTHER,        /* 0x642 */
    OTHER,        /* 0x643 */
    OTHER,        /* 0x644 */
    OTHER,        /* 0x645 */
    OTHER,        /* 0x646 */
    OTHER,        /* 0x647 */
    OTHER,        /* 0x648 */
    OTHER,        /* 0x649 */
    OTHER,        /* 0x64a */
    OTHER,        /* 0x64b */
    OTHER,        /* 0x64c */
    OTHER,        /* 0x64d */
    OTHER,        /* 0x64e */
    OTHER,        /* 0x64f */
    OTHER,        /* 0x650 */
    OTHER,        /* 0x651 */
    OTHER,        /* 0x652 */
    OTHER,        /* 0x653 */
    OTHER,        /* 0x654 */
    OTHER,        /* 0x655 */
    OTHER,        /* 0x656 */
    OTHER,        /* 0x657 */
    OTHER,        /* 0x658 */
    OTHER,        /* 0x659 */
    OTHER,        /* 0x65a */
    OTHER,        /* 0x65b */
    OTHER,        /* 0x65c */
    OTHER,        /* 0x65d */
    OTHER,        /* 0x65e */
    OTHER,        /* 0x65f */
    OTHER,        /* 0x660 */
    OTHER,        /* 0x661 */
    OTHER,        /* 0x662 */
    OTHER,        /* 0x663 */
    OTHER,        /* 0x664 */
    OTHER,        /* 0x665 */
    OTHER,        /* 0x666 */
    OTHER,        /* 0x667 */
    OTHER,        /* 0x668 */
    OTHER,        /* 0x669 */
    OTHER,        /* 0x66a */
    OTHER,        /* 0x66b */
    OTHER,        /* 0x66c */
    OTHER,        /* 0x66d */
    OTHER,        /* 0x66e */
    OTHER,        /* 0x66f */
    OTHER,        /* 0x670 */
    OTHER,        /* 0x671 */
    OTHER,        /* 0x672 */
    OTHER,        /* 0x673 */
    OTHER,        /* 0x674 */
    OTHER,        /* 0x675 */
    OTHER,        /* 0x676 */
    OTHER,        /* 0x677 */
    OTHER,        /* 0x678 */
    OTHER,        /* 0x679 */
    OTHER,        /* 0x67a */
    OTHER,        /* 0x67b */
    OTHER,        /* 0x67c */
    OTHER,        /* 0x67d */
    OTHER,        /* 0x67e */
    OTHER,        /* 0x67f */
    OTHER,        /* 0x680 */
    OTHER,        /* 0x681 */
    OTHER,        /* 0x682 */
    OTHER,        /* 0x683 */
    OTHER,        /* 0x684 */
    OTHER,        /* 0x685 */
    OTHER,        /* 0x686 */
    OTHER,        /* 0x687 */
    OTHER,        /* 0x688 */
    OTHER,        /* 0x689 */
    OTHER,        /* 0x68a */
    OTHER,        /* 0x68b */
    OTHER,        /* 0x68c */
    OTHER,        /* 0x68d */
    OTHER,        /* 0x68e */
    OTHER,        /* 0x68f */
    OTHER,        /* 0x690 */
    OTHER,        /* 0x691 */
    OTHER,        /* 0x692 */
    OTHER,        /* 0x693 */
    OTHER,        /* 0x694 */
    OTHER,        /* 0x695 */
    OTHER,        /* 0x696 */
    OTHER,        /* 0x697 */
    OTHER,        /* 0x698 */
    OTHER,        /* 0x699 */
    OTHER,        /* 0x69a */
    OTHER,        /* 0x69b */
    OTHER,        /* 0x69c */
    OTHER,        /* 0x69d */
    OTHER,        /* 0x69e */
    OTHER,        /* 0x69f */
    OTHER,        /* 0x6a0 */
    OTHER,        /* 0x6a1 */
    OTHER,        /* 0x6a2 */
    OTHER,        /* 0x6a3 */
    OTHER,        /* 0x6a4 */
    OTHER,        /* 0x6a5 */
    OTHER,        /* 0x6a6 */
    OTHER,        /* 0x6a7 */
    OTHER,        /* 0x6a8 */
    OTHER,        /* 0x6a9 */
    OTHER,        /* 0x6aa */
    OTHER,        /* 0x6ab */
    OTHER,        /* 0x6ac */
    OTHER,        /* 0x6ad */
    OTHER,        /* 0x6ae */
    OTHER,        /* 0x6af */
    OTHER,        /* 0x6b0 */
    OTHER,        /* 0x6b1 */
    OTHER,        /* 0x6b2 */
    OTHER,        /* 0x6b3 */
    OTHER,        /* 0x6b4 */
    OTHER,        /* 0x6b5 */
    OTHER,        /* 0x6b6 */
    OTHER,        /* 0x6b7 */
    OTHER,        /* 0x6b8 */
    OTHER,        /* 0x6b9 */
    OTHER,        /* 0x6ba */
    OTHER,        /* 0x6bb */
    OTHER,        /* 0x6bc */
    OTHER,        /* 0x6bd */
    OTHER,        /* 0x6be */
    OTHER,        /* 0x6bf */
    OTHER,        /* 0x6c0 */
    OTHER,        /* 0x6c1 */
    OTHER,        /* 0x6c2 */
    OTHER,        /* 0x6c3 */
    OTHER,        /* 0x6c4 */
    OTHER,        /* 0x6c5 */
    OTHER,        /* 0x6c6 */
    OTHER,        /* 0x6c7 */
    OTHER,        /* 0x6c8 */
    OTHER,        /* 0x6c9 */
    OTHER,        /* 0x6ca */
    OTHER,        /* 0x6cb */
    OTHER,        /* 0x6cc */
    OTHER,        /* 0x6cd */
    OTHER,        /* 0x6ce */
    OTHER,        /* 0x6cf */
    OTHER,        /* 0x6d0 */
    OTHER,        /* 0x6d1 */
    OTHER,        /* 0x6d2 */
    OTHER,        /* 0x6d3 */
    OTHER,        /* 0x6d4 */
    OTHER,        /* 0x6d5 */
    OTHER,        /* 0x6d6 */
    OTHER,        /* 0x6d7 */
    OTHER,        /* 0x6d8 */
    OTHER,        /* 0x6d9 */
    OTHER,        /* 0x6da */
    OTHER,        /* 0x6db */
    OTHER,        /* 0x6dc */
    OTHER,        /* 0x6dd */
    OTHER,        /* 0x6de */
    OTHER,        /* 0x6df */
    OTHER,        /* 0x6e0 */
    OTHER,        /* 0x6e1 */
    OTHER,        /* 0x6e2 */
    OTHER,        /* 0x6e3 */
    OTHER,        /* 0x6e4 */
    OTHER,        /* 0x6e5 */
    OTHER,        /* 0x6e6 */
    OTHER,        /* 0x6e7 */
    OTHER,        /* 0x6e8 */
    OTHER,        /* 0x6e9 */
    OTHER,        /* 0x6ea */
    OTHER,        /* 0x6eb */
    OTHER,        /* 0x6ec */
    OTHER,        /* 0x6ed */
    OTHER,        /* 0x6ee */
    OTHER,        /* 0x6ef */
    OTHER,        /* 0x6f0 */
    OTHER,        /* 0x6f1 */
    OTHER,        /* 0x6f2 */
    OTHER,        /* 0x6f3 */
    OTHER,        /* 0x6f4 */
    OTHER,        /* 0x6f5 */
    OTHER,        /* 0x6f6 */
    OTHER,        /* 0x6f7 */
    OTHER,        /* 0x6f8 */
    OTHER,        /* 0x6f9 */
    OTHER,        /* 0x6fa */
    OTHER,        /* 0x6fb */
    OTHER,        /* 0x6fc */
    OTHER,        /* 0x6fd */
    OTHER,        /* 0x6fe */
    OTHER,        /* 0x6ff */
    OTHER,        /* 0x700 */
    OTHER,        /* 0x701 */
    OTHER,        /* 0x702 */
    OTHER,        /* 0x703 */
    OTHER,        /* 0x704 */
    OTHER,        /* 0x705 */
    OTHER,        /* 0x706 */
    OTHER,        /* 0x707 */
    OTHER,        /* 0x708 */
    OTHER,        /* 0x709 */
    OTHER,        /* 0x70a */
    OTHER,        /* 0x70b */
    OTHER,        /* 0x70c */
    OTHER,        /* 0x70d */
    OTHER,        /* 0x70e */
    OTHER,        /* 0x70f */
    OTHER,        /* 0x710 */
    OTHER,        /* 0x711 */
    OTHER,        /* 0x712 */
    OTHER,        /* 0x713 */
    OTHER,        /* 0x714 */
    OTHER,        /* 0x715 */
    OTHER,        /* 0x716 */
    OTHER,        /* 0x717 */
    OTHER,        /* 0x718 */
    OTHER,        /* 0x719 */
    OTHER,        /* 0x71a */
    OTHER,        /* 0x71b */
    OTHER,        /* 0x71c */
    OTHER,        /* 0x71d */
    OTHER,        /* 0x71e */
    OTHER,        /* 0x71f */
    OTHER,        /* 0x720 */
    OTHER,        /* 0x721 */
    OTHER,        /* 0x722 */
    OTHER,        /* 0x723 */
    OTHER,        /* 0x724 */
    OTHER,        /* 0x725 */
    OTHER,        /* 0x726 */
    OTHER,        /* 0x727 */
    OTHER,        /* 0x728 */
    OTHER,        /* 0x729 */
    OTHER,        /* 0x72a */
    OTHER,        /* 0x72b */
    OTHER,        /* 0x72c */
    OTHER,        /* 0x72d */
    OTHER,        /* 0x72e */
    OTHER,        /* 0x72f */
    OTHER,        /* 0x730 */
    OTHER,        /* 0x731 */
    OTHER,        /* 0x732 */
    OTHER,        /* 0x733 */
    OTHER,        /* 0x734 */
    OTHER,        /* 0x735 */
    OTHER,        /* 0x736 */
    OTHER,        /* 0x737 */
    OTHER,        /* 0x738 */
    OTHER,        /* 0x739 */
    OTHER,        /* 0x73a */
    OTHER,        /* 0x73b */
    OTHER,        /* 0x73c */
    OTHER,        /* 0x73d */
    OTHER,        /* 0x73e */
    OTHER,        /* 0x73f */
    OTHER,        /* 0x740 */
    OTHER,        /* 0x741 */
    OTHER,        /* 0x742 */
    OTHER,        /* 0x743 */
    OTHER,        /* 0x744 */
    OTHER,        /* 0x745 */
    OTHER,        /* 0x746 */
    OTHER,        /* 0x747 */
    OTHER,        /* 0x748 */
    OTHER,        /* 0x749 */
    OTHER,        /* 0x74a */
    OTHER,        /* 0x74b */
    OTHER,        /* 0x74c */
    OTHER,        /* 0x74d */
    OTHER,        /* 0x74e */
    OTHER,        /* 0x74f */
    OTHER,        /* 0x750 */
    OTHER,        /* 0x751 */
    OTHER,        /* 0x752 */
    OTHER,        /* 0x753 */
    OTHER,        /* 0x754 */
    OTHER,        /* 0x755 */
    OTHER,        /* 0x756 */
    OTHER,        /* 0x757 */
    OTHER,        /* 0x758 */
    OTHER,        /* 0x759 */
    OTHER,        /* 0x75a */
    OTHER,        /* 0x75b */
    OTHER,        /* 0x75c */
    OTHER,        /* 0x75d */
    OTHER,        /* 0x75e */
    OTHER,        /* 0x75f */
    OTHER,        /* 0x760 */
    OTHER,        /* 0x761 */
    OTHER,        /* 0x762 */
    OTHER,        /* 0x763 */
    OTHER,        /* 0x764 */
    OTHER,        /* 0x765 */
    OTHER,        /* 0x766 */
    OTHER,        /* 0x767 */
    OTHER,        /* 0x768 */
    OTHER,        /* 0x769 */
    OTHER,        /* 0x76a */
    OTHER,        /* 0x76b */
    OTHER,        /* 0x76c */
    OTHER,        /* 0x76d */
    OTHER,        /* 0x76e */
    OTHER,        /* 0x76f */
    OTHER,        /* 0x770 */
    OTHER,        /* 0x771 */
    OTHER,        /* 0x772 */
    OTHER,        /* 0x773 */
    OTHER,        /* 0x774 */
    OTHER,        /* 0x775 */
    OTHER,        /* 0x776 */
    OTHER,        /* 0x777 */
    OTHER,        /* 0x778 */
    OTHER,        /* 0x779 */
    OTHER,        /* 0x77a */
    OTHER,        /* 0x77b */
    OTHER,        /* 0x77c */
    OTHER,        /* 0x77d */
    OTHER,        /* 0x77e */
    OTHER,        /* 0x77f */
    OTHER,        /* 0x780 */
    OTHER,        /* 0x781 */
    OTHER,        /* 0x782 */
    OTHER,        /* 0x783 */
    OTHER,        /* 0x784 */
    OTHER,        /* 0x785 */
    OTHER,        /* 0x786 */
    OTHER,        /* 0x787 */
    OTHER,        /* 0x788 */
    OTHER,        /* 0x789 */
    OTHER,        /* 0x78a */
    OTHER,        /* 0x78b */
    OTHER,        /* 0x78c */
    OTHER,        /* 0x78d */
    OTHER,        /* 0x78e */
    OTHER,        /* 0x78f */
    OTHER,        /* 0x790 */
    OTHER,        /* 0x791 */
    OTHER,        /* 0x792 */
    OTHER,        /* 0x793 */
    OTHER,        /* 0x794 */
    OTHER,        /* 0x795 */
    OTHER,        /* 0x796 */
    OTHER,        /* 0x797 */
    OTHER,        /* 0x798 */
    OTHER,        /* 0x799 */
    OTHER,        /* 0x79a */
    OTHER,        /* 0x79b */
    OTHER,        /* 0x79c */
    OTHER,        /* 0x79d */
    OTHER,        /* 0x79e */
    OTHER,        /* 0x79f */
    OTHER,        /* 0x7a0 */
    OTHER,        /* 0x7a1 */
    OTHER,        /* 0x7a2 */
    OTHER,        /* 0x7a3 */
    OTHER,        /* 0x7a4 */
    OTHER,        /* 0x7a5 */
    OTHER,        /* 0x7a6 */
    OTHER,        /* 0x7a7 */
    OTHER,        /* 0x7a8 */
    OTHER,        /* 0x7a9 */
    OTHER,        /* 0x7aa */
    OTHER,        /* 0x7ab */
    OTHER,        /* 0x7ac */
    OTHER,        /* 0x7ad */
    OTHER,        /* 0x7ae */
    OTHER,        /* 0x7af */
    OTHER,        /* 0x7b0 */
    OTHER,        /* 0x7b1 */
    OTHER,        /* 0x7b2 */
    OTHER,        /* 0x7b3 */
    OTHER,        /* 0x7b4 */
    OTHER,        /* 0x7b5 */
    OTHER,        /* 0x7b6 */
    OTHER,        /* 0x7b7 */
    OTHER,        /* 0x7b8 */
    OTHER,        /* 0x7b9 */
    OTHER,        /* 0x7ba */
    OTHER,        /* 0x7bb */
    OTHER,        /* 0x7bc */
    OTHER,        /* 0x7bd */
    OTHER,        /* 0x7be */
    OTHER,        /* 0x7bf */
    OTHER,        /* 0x7c0 */
    OTHER,        /* 0x7c1 */
    OTHER,        /* 0x7c2 */
    OTHER,        /* 0x7c3 */
    OTHER,        /* 0x7c4 */
    OTHER,        /* 0x7c5 */
    OTHER,        /* 0x7c6 */
    OTHER,        /* 0x7c7 */
    OTHER,        /* 0x7c8 */
    OTHER,        /* 0x7c9 */
    OTHER,        /* 0x7ca */
    OTHER,        /* 0x7cb */
    OTHER,        /* 0x7cc */
    OTHER,        /* 0x7cd */
    OTHER,        /* 0x7ce */
    OTHER,        /* 0x7cf */
    OTHER,        /* 0x7d0 */
    OTHER,        /* 0x7d1 */
    OTHER,        /* 0x7d2 */
    OTHER,        /* 0x7d3 */
    OTHER,        /* 0x7d4 */
    OTHER,        /* 0x7d5 */
    OTHER,        /* 0x7d6 */
    OTHER,        /* 0x7d7 */
    OTHER,        /* 0x7d8 */
    OTHER,        /* 0x7d9 */
    OTHER,        /* 0x7da */
    OTHER,        /* 0x7db */
    OTHER,        /* 0x7dc */
    OTHER,        /* 0x7dd */
    OTHER,        /* 0x7de */
    OTHER,        /* 0x7df */
    OTHER,        /* 0x7e0 */
    OTHER,        /* 0x7e1 */
    OTHER,        /* 0x7e2 */
    OTHER,        /* 0x7e3 */
    OTHER,        /* 0x7e4 */
    OTHER,        /* 0x7e5 */
    OTHER,        /* 0x7e6 */
    OTHER,        /* 0x7e7 */
    OTHER,        /* 0x7e8 */
    OTHER,        /* 0x7e9 */
    OTHER,        /* 0x7ea */
    OTHER,        /* 0x7eb */
    OTHER,        /* 0x7ec */
    OTHER,        /* 0x7ed */
    OTHER,        /* 0x7ee */
    OTHER,        /* 0x7ef */
    OTHER,        /* 0x7f0 */
    OTHER,        /* 0x7f1 */
    OTHER,        /* 0x7f2 */
    OTHER,        /* 0x7f3 */
    OTHER,        /* 0x7f4 */
    OTHER,        /* 0x7f5 */
    OTHER,        /* 0x7f6 */
    OTHER,        /* 0x7f7 */
    OTHER,        /* 0x7f8 */
    OTHER,        /* 0x7f9 */
    OTHER,        /* 0x7fa */
    OTHER,        /* 0x7fb */
    OTHER,        /* 0x7fc */
    OTHER,        /* 0x7fd */
    OTHER,        /* 0x7fe */
    OTHER,        /* 0x7ff */
    OTHER,        /* 0x800 */
    OTHER,        /* 0x801 */
    OTHER,        /* 0x802 */
    OTHER,        /* 0x803 */
    OTHER,        /* 0x804 */
    OTHER,        /* 0x805 */
    OTHER,        /* 0x806 */
    OTHER,        /* 0x807 */
    OTHER,        /* 0x808 */
    OTHER,        /* 0x809 */
    OTHER,        /* 0x80a */
    OTHER,        /* 0x80b */
    OTHER,        /* 0x80c */
    OTHER,        /* 0x80d */
    OTHER,        /* 0x80e */
    OTHER,        /* 0x80f */
    OTHER,        /* 0x810 */
    OTHER,        /* 0x811 */
    OTHER,        /* 0x812 */
    OTHER,        /* 0x813 */
    OTHER,        /* 0x814 */
    OTHER,        /* 0x815 */
    OTHER,        /* 0x816 */
    OTHER,        /* 0x817 */
    OTHER,        /* 0x818 */
    OTHER,        /* 0x819 */
    OTHER,        /* 0x81a */
    OTHER,        /* 0x81b */
    OTHER,        /* 0x81c */
    OTHER,        /* 0x81d */
    OTHER,        /* 0x81e */
    OTHER,        /* 0x81f */
    OTHER,        /* 0x820 */
    OTHER,        /* 0x821 */
    OTHER,        /* 0x822 */
    OTHER,        /* 0x823 */
    OTHER,        /* 0x824 */
    OTHER,        /* 0x825 */
    OTHER,        /* 0x826 */
    OTHER,        /* 0x827 */
    OTHER,        /* 0x828 */
    OTHER,        /* 0x829 */
    OTHER,        /* 0x82a */
    OTHER,        /* 0x82b */
    OTHER,        /* 0x82c */
    OTHER,        /* 0x82d */
    OTHER,        /* 0x82e */
    OTHER,        /* 0x82f */
    OTHER,        /* 0x830 */
    OTHER,        /* 0x831 */
    OTHER,        /* 0x832 */
    OTHER,        /* 0x833 */
    OTHER,        /* 0x834 */
    OTHER,        /* 0x835 */
    OTHER,        /* 0x836 */
    OTHER,        /* 0x837 */
    OTHER,        /* 0x838 */
    OTHER,        /* 0x839 */
    OTHER,        /* 0x83a */
    OTHER,        /* 0x83b */
    OTHER,        /* 0x83c */
    OTHER,        /* 0x83d */
    OTHER,        /* 0x83e */
    OTHER,        /* 0x83f */
    OTHER,        /* 0x840 */
    OTHER,        /* 0x841 */
    OTHER,        /* 0x842 */
    OTHER,        /* 0x843 */
    OTHER,        /* 0x844 */
    OTHER,        /* 0x845 */
    OTHER,        /* 0x846 */
    OTHER,        /* 0x847 */
    OTHER,        /* 0x848 */
    OTHER,        /* 0x849 */
    OTHER,        /* 0x84a */
    OTHER,        /* 0x84b */
    OTHER,        /* 0x84c */
    OTHER,        /* 0x84d */
    OTHER,        /* 0x84e */
    OTHER,        /* 0x84f */
    OTHER,        /* 0x850 */
    OTHER,        /* 0x851 */
    OTHER,        /* 0x852 */
    OTHER,        /* 0x853 */
    OTHER,        /* 0x854 */
    OTHER,        /* 0x855 */
    OTHER,        /* 0x856 */
    OTHER,        /* 0x857 */
    OTHER,        /* 0x858 */
    OTHER,        /* 0x859 */
    OTHER,        /* 0x85a */
    OTHER,        /* 0x85b */
    OTHER,        /* 0x85c */
    OTHER,        /* 0x85d */
    OTHER,        /* 0x85e */
    OTHER,        /* 0x85f */
    OTHER,        /* 0x860 */
    OTHER,        /* 0x861 */
    OTHER,        /* 0x862 */
    OTHER,        /* 0x863 */
    OTHER,        /* 0x864 */
    OTHER,        /* 0x865 */
    OTHER,        /* 0x866 */
    OTHER,        /* 0x867 */
    OTHER,        /* 0x868 */
    OTHER,        /* 0x869 */
    OTHER,        /* 0x86a */
    OTHER,        /* 0x86b */
    OTHER,        /* 0x86c */
    OTHER,        /* 0x86d */
    OTHER,        /* 0x86e */
    OTHER,        /* 0x86f */
    OTHER,        /* 0x870 */
    OTHER,        /* 0x871 */
    OTHER,        /* 0x872 */
    OTHER,        /* 0x873 */
    OTHER,        /* 0x874 */
    OTHER,        /* 0x875 */
    OTHER,        /* 0x876 */
    OTHER,        /* 0x877 */
    OTHER,        /* 0x878 */
    OTHER,        /* 0x879 */
    OTHER,        /* 0x87a */
    OTHER,        /* 0x87b */
    OTHER,        /* 0x87c */
    OTHER,        /* 0x87d */
    OTHER,        /* 0x87e */
    OTHER,        /* 0x87f */
    OTHER,        /* 0x880 */
    OTHER,        /* 0x881 */
    OTHER,        /* 0x882 */
    OTHER,        /* 0x883 */
    OTHER,        /* 0x884 */
    OTHER,        /* 0x885 */
    OTHER,        /* 0x886 */
    OTHER,        /* 0x887 */
    OTHER,        /* 0x888 */
    OTHER,        /* 0x889 */
    OTHER,        /* 0x88a */
    OTHER,        /* 0x88b */
    OTHER,        /* 0x88c */
    OTHER,        /* 0x88d */
    OTHER,        /* 0x88e */
    OTHER,        /* 0x88f */
    OTHER,        /* 0x890 */
    OTHER,        /* 0x891 */
    OTHER,        /* 0x892 */
    OTHER,        /* 0x893 */
    OTHER,        /* 0x894 */
    OTHER,        /* 0x895 */
    OTHER,        /* 0x896 */
    OTHER,        /* 0x897 */
    OTHER,        /* 0x898 */
    OTHER,        /* 0x899 */
    OTHER,        /* 0x89a */
    OTHER,        /* 0x89b */
    OTHER,        /* 0x89c */
    OTHER,        /* 0x89d */
    OTHER,        /* 0x89e */
    OTHER,        /* 0x89f */
    OTHER,        /* 0x8a0 */
    OTHER,        /* 0x8a1 */
    OTHER,        /* 0x8a2 */
    OTHER,        /* 0x8a3 */
    OTHER,        /* 0x8a4 */
    OTHER,        /* 0x8a5 */
    OTHER,        /* 0x8a6 */
    OTHER,        /* 0x8a7 */
    OTHER,        /* 0x8a8 */
    OTHER,        /* 0x8a9 */
    OTHER,        /* 0x8aa */
    OTHER,        /* 0x8ab */
    OTHER,        /* 0x8ac */
    OTHER,        /* 0x8ad */
    OTHER,        /* 0x8ae */
    OTHER,        /* 0x8af */
    OTHER,        /* 0x8b0 */
    OTHER,        /* 0x8b1 */
    OTHER,        /* 0x8b2 */
    OTHER,        /* 0x8b3 */
    OTHER,        /* 0x8b4 */
    OTHER,        /* 0x8b5 */
    OTHER,        /* 0x8b6 */
    OTHER,        /* 0x8b7 */
    OTHER,        /* 0x8b8 */
    OTHER,        /* 0x8b9 */
    OTHER,        /* 0x8ba */
    OTHER,        /* 0x8bb */
    OTHER,        /* 0x8bc */
    OTHER,        /* 0x8bd */
    OTHER,        /* 0x8be */
    OTHER,        /* 0x8bf */
    OTHER,        /* 0x8c0 */
    OTHER,        /* 0x8c1 */
    OTHER,        /* 0x8c2 */
    OTHER,        /* 0x8c3 */
    OTHER,        /* 0x8c4 */
    OTHER,        /* 0x8c5 */
    OTHER,        /* 0x8c6 */
    OTHER,        /* 0x8c7 */
    OTHER,        /* 0x8c8 */
    OTHER,        /* 0x8c9 */
    OTHER,        /* 0x8ca */
    OTHER,        /* 0x8cb */
    OTHER,        /* 0x8cc */
    OTHER,        /* 0x8cd */
    OTHER,        /* 0x8ce */
    OTHER,        /* 0x8cf */
    OTHER,        /* 0x8d0 */
    OTHER,        /* 0x8d1 */
    OTHER,        /* 0x8d2 */
    OTHER,        /* 0x8d3 */
    OTHER,        /* 0x8d4 */
    OTHER,        /* 0x8d5 */
    OTHER,        /* 0x8d6 */
    OTHER,        /* 0x8d7 */
    OTHER,        /* 0x8d8 */
    OTHER,        /* 0x8d9 */
    OTHER,        /* 0x8da */
    OTHER,        /* 0x8db */
    OTHER,        /* 0x8dc */
    OTHER,        /* 0x8dd */
    OTHER,        /* 0x8de */
    OTHER,        /* 0x8df */
    OTHER,        /* 0x8e0 */
    OTHER,        /* 0x8e1 */
    OTHER,        /* 0x8e2 */
    OTHER,        /* 0x8e3 */
    OTHER,        /* 0x8e4 */
    OTHER,        /* 0x8e5 */
    OTHER,        /* 0x8e6 */
    OTHER,        /* 0x8e7 */
    OTHER,        /* 0x8e8 */
    OTHER,        /* 0x8e9 */
    OTHER,        /* 0x8ea */
    OTHER,        /* 0x8eb */
    OTHER,        /* 0x8ec */
    OTHER,        /* 0x8ed */
    OTHER,        /* 0x8ee */
    OTHER,        /* 0x8ef */
    OTHER,        /* 0x8f0 */
    OTHER,        /* 0x8f1 */
    OTHER,        /* 0x8f2 */
    OTHER,        /* 0x8f3 */
    OTHER,        /* 0x8f4 */
    OTHER,        /* 0x8f5 */
    OTHER,        /* 0x8f6 */
    OTHER,        /* 0x8f7 */
    OTHER,        /* 0x8f8 */
    OTHER,        /* 0x8f9 */
    OTHER,        /* 0x8fa */
    OTHER,        /* 0x8fb */
    OTHER,        /* 0x8fc */
    OTHER,        /* 0x8fd */
    OTHER,        /* 0x8fe */
    OTHER,        /* 0x8ff */
    OTHER,        /* 0x900 */
    OTHER,        /* 0x901 */
    OTHER,        /* 0x902 */
    OTHER,        /* 0x903 */
    OTHER,        /* 0x904 */
    OTHER,        /* 0x905 */
    OTHER,        /* 0x906 */
    OTHER,        /* 0x907 */
    OTHER,        /* 0x908 */
    OTHER,        /* 0x909 */
    OTHER,        /* 0x90a */
    OTHER,        /* 0x90b */
    OTHER,        /* 0x90c */
    OTHER,        /* 0x90d */
    OTHER,        /* 0x90e */
    OTHER,        /* 0x90f */
    OTHER,        /* 0x910 */
    OTHER,        /* 0x911 */
    OTHER,        /* 0x912 */
    OTHER,        /* 0x913 */
    OTHER,        /* 0x914 */
    OTHER,        /* 0x915 */
    OTHER,        /* 0x916 */
    OTHER,        /* 0x917 */
    OTHER,        /* 0x918 */
    OTHER,        /* 0x919 */
    OTHER,        /* 0x91a */
    OTHER,        /* 0x91b */
    OTHER,        /* 0x91c */
    OTHER,        /* 0x91d */
    OTHER,        /* 0x91e */
    OTHER,        /* 0x91f */
    OTHER,        /* 0x920 */
    OTHER,        /* 0x921 */
    OTHER,        /* 0x922 */
    OTHER,        /* 0x923 */
    OTHER,        /* 0x924 */
    OTHER,        /* 0x925 */
    OTHER,        /* 0x926 */
    OTHER,        /* 0x927 */
    OTHER,        /* 0x928 */
    OTHER,        /* 0x929 */
    OTHER,        /* 0x92a */
    OTHER,        /* 0x92b */
    OTHER,        /* 0x92c */
    OTHER,        /* 0x92d */
    OTHER,        /* 0x92e */
    OTHER,        /* 0x92f */
    OTHER,        /* 0x930 */
    OTHER,        /* 0x931 */
    OTHER,        /* 0x932 */
    OTHER,        /* 0x933 */
    OTHER,        /* 0x934 */
    OTHER,        /* 0x935 */
    OTHER,        /* 0x936 */
    OTHER,        /* 0x937 */
    OTHER,        /* 0x938 */
    OTHER,        /* 0x939 */
    OTHER,        /* 0x93a */
    OTHER,        /* 0x93b */
    OTHER,        /* 0x93c */
    OTHER,        /* 0x93d */
    OTHER,        /* 0x93e */
    OTHER,        /* 0x93f */
    OTHER,        /* 0x940 */
    OTHER,        /* 0x941 */
    OTHER,        /* 0x942 */
    OTHER,        /* 0x943 */
    OTHER,        /* 0x944 */
    OTHER,        /* 0x945 */
    OTHER,        /* 0x946 */
    OTHER,        /* 0x947 */
    OTHER,        /* 0x948 */
    OTHER,        /* 0x949 */
    OTHER,        /* 0x94a */
    OTHER,        /* 0x94b */
    OTHER,        /* 0x94c */
    OTHER,        /* 0x94d */
    OTHER,        /* 0x94e */
    OTHER,        /* 0x94f */
    OTHER,        /* 0x950 */
    OTHER,        /* 0x951 */
    OTHER,        /* 0x952 */
    OTHER,        /* 0x953 */
    OTHER,        /* 0x954 */
    OTHER,        /* 0x955 */
    OTHER,        /* 0x956 */
    OTHER,        /* 0x957 */
    OTHER,        /* 0x958 */
    OTHER,        /* 0x959 */
    OTHER,        /* 0x95a */
    OTHER,        /* 0x95b */
    OTHER,        /* 0x95c */
    OTHER,        /* 0x95d */
    OTHER,        /* 0x95e */
    OTHER,        /* 0x95f */
    OTHER,        /* 0x960 */
    OTHER,        /* 0x961 */
    OTHER,        /* 0x962 */
    OTHER,        /* 0x963 */
    OTHER,        /* 0x964 */
    OTHER,        /* 0x965 */
    OTHER,        /* 0x966 */
    OTHER,        /* 0x967 */
    OTHER,        /* 0x968 */
    OTHER,        /* 0x969 */
    OTHER,        /* 0x96a */
    OTHER,        /* 0x96b */
    OTHER,        /* 0x96c */
    OTHER,        /* 0x96d */
    OTHER,        /* 0x96e */
    OTHER,        /* 0x96f */
    OTHER,        /* 0x970 */
    OTHER,        /* 0x971 */
    OTHER,        /* 0x972 */
    OTHER,        /* 0x973 */
    OTHER,        /* 0x974 */
    OTHER,        /* 0x975 */
    OTHER,        /* 0x976 */
    OTHER,        /* 0x977 */
    OTHER,        /* 0x978 */
    OTHER,        /* 0x979 */
    OTHER,        /* 0x97a */
    OTHER,        /* 0x97b */
    OTHER,        /* 0x97c */
    OTHER,        /* 0x97d */
    OTHER,        /* 0x97e */
    OTHER,        /* 0x97f */
    OTHER,        /* 0x980 */
    OTHER,        /* 0x981 */
    OTHER,        /* 0x982 */
    OTHER,        /* 0x983 */
    OTHER,        /* 0x984 */
    OTHER,        /* 0x985 */
    OTHER,        /* 0x986 */
    OTHER,        /* 0x987 */
    OTHER,        /* 0x988 */
    OTHER,        /* 0x989 */
    OTHER,        /* 0x98a */
    OTHER,        /* 0x98b */
    OTHER,        /* 0x98c */
    OTHER,        /* 0x98d */
    OTHER,        /* 0x98e */
    OTHER,        /* 0x98f */
    OTHER,        /* 0x990 */
    OTHER,        /* 0x991 */
    OTHER,        /* 0x992 */
    OTHER,        /* 0x993 */
    OTHER,        /* 0x994 */
    OTHER,        /* 0x995 */
    OTHER,        /* 0x996 */
    OTHER,        /* 0x997 */
    OTHER,        /* 0x998 */
    OTHER,        /* 0x999 */
    OTHER,        /* 0x99a */
    OTHER,        /* 0x99b */
    OTHER,        /* 0x99c */
    OTHER,        /* 0x99d */
    OTHER,        /* 0x99e */
    OTHER,        /* 0x99f */
    OTHER,        /* 0x9a0 */
    OTHER,        /* 0x9a1 */
    OTHER,        /* 0x9a2 */
    OTHER,        /* 0x9a3 */
    OTHER,        /* 0x9a4 */
    OTHER,        /* 0x9a5 */
    OTHER,        /* 0x9a6 */
    OTHER,        /* 0x9a7 */
    OTHER,        /* 0x9a8 */
    OTHER,        /* 0x9a9 */
    OTHER,        /* 0x9aa */
    OTHER,        /* 0x9ab */
    OTHER,        /* 0x9ac */
    OTHER,        /* 0x9ad */
    OTHER,        /* 0x9ae */
    OTHER,        /* 0x9af */
    OTHER,        /* 0x9b0 */
    OTHER,        /* 0x9b1 */
    OTHER,        /* 0x9b2 */
    OTHER,        /* 0x9b3 */
    OTHER,        /* 0x9b4 */
    OTHER,        /* 0x9b5 */
    OTHER,        /* 0x9b6 */
    OTHER,        /* 0x9b7 */
    OTHER,        /* 0x9b8 */
    OTHER,        /* 0x9b9 */
    OTHER,        /* 0x9ba */
    OTHER,        /* 0x9bb */
    OTHER,        /* 0x9bc */
    OTHER,        /* 0x9bd */
    OTHER,        /* 0x9be */
    OTHER,        /* 0x9bf */
    OTHER,        /* 0x9c0 */
    OTHER,        /* 0x9c1 */
    OTHER,        /* 0x9c2 */
    OTHER,        /* 0x9c3 */
    OTHER,        /* 0x9c4 */
    OTHER,        /* 0x9c5 */
    OTHER,        /* 0x9c6 */
    OTHER,        /* 0x9c7 */
    OTHER,        /* 0x9c8 */
    OTHER,        /* 0x9c9 */
    OTHER,        /* 0x9ca */
    OTHER,        /* 0x9cb */
    OTHER,        /* 0x9cc */
    OTHER,        /* 0x9cd */
    OTHER,        /* 0x9ce */
    OTHER,        /* 0x9cf */
    OTHER,        /* 0x9d0 */
    OTHER,        /* 0x9d1 */
    OTHER,        /* 0x9d2 */
    OTHER,        /* 0x9d3 */
    OTHER,        /* 0x9d4 */
    OTHER,        /* 0x9d5 */
    OTHER,        /* 0x9d6 */
    OTHER,        /* 0x9d7 */
    OTHER,        /* 0x9d8 */
    OTHER,        /* 0x9d9 */
    OTHER,        /* 0x9da */
    OTHER,        /* 0x9db */
    OTHER,        /* 0x9dc */
    OTHER,        /* 0x9dd */
    OTHER,        /* 0x9de */
    OTHER,        /* 0x9df */
    OTHER,        /* 0x9e0 */
    OTHER,        /* 0x9e1 */
    OTHER,        /* 0x9e2 */
    OTHER,        /* 0x9e3 */
    OTHER,        /* 0x9e4 */
    OTHER,        /* 0x9e5 */
    OTHER,        /* 0x9e6 */
    OTHER,        /* 0x9e7 */
    OTHER,        /* 0x9e8 */
    OTHER,        /* 0x9e9 */
    OTHER,        /* 0x9ea */
    OTHER,        /* 0x9eb */
    OTHER,        /* 0x9ec */
    OTHER,        /* 0x9ed */
    OTHER,        /* 0x9ee */
    OTHER,        /* 0x9ef */
    OTHER,        /* 0x9f0 */
    OTHER,        /* 0x9f1 */
    OTHER,        /* 0x9f2 */
    OTHER,        /* 0x9f3 */
    OTHER,        /* 0x9f4 */
    OTHER,        /* 0x9f5 */
    OTHER,        /* 0x9f6 */
    OTHER,        /* 0x9f7 */
    OTHER,        /* 0x9f8 */
    OTHER,        /* 0x9f9 */
    OTHER,        /* 0x9fa */
    OTHER,        /* 0x9fb */
    OTHER,        /* 0x9fc */
    OTHER,        /* 0x9fd */
    OTHER,        /* 0x9fe */
    OTHER,        /* 0x9ff */
    OTHER,        /* 0xa00 */
    OTHER,        /* 0xa01 */
    OTHER,        /* 0xa02 */
    OTHER,        /* 0xa03 */
    OTHER,        /* 0xa04 */
    OTHER,        /* 0xa05 */
    OTHER,        /* 0xa06 */
    OTHER,        /* 0xa07 */
    OTHER,        /* 0xa08 */
    OTHER,        /* 0xa09 */
    OTHER,        /* 0xa0a */
    OTHER,        /* 0xa0b */
    OTHER,        /* 0xa0c */
    OTHER,        /* 0xa0d */
    OTHER,        /* 0xa0e */
    OTHER,        /* 0xa0f */
    OTHER,        /* 0xa10 */
    OTHER,        /* 0xa11 */
    OTHER,        /* 0xa12 */
    OTHER,        /* 0xa13 */
    OTHER,        /* 0xa14 */
    OTHER,        /* 0xa15 */
    OTHER,        /* 0xa16 */
    OTHER,        /* 0xa17 */
    OTHER,        /* 0xa18 */
    OTHER,        /* 0xa19 */
    OTHER,        /* 0xa1a */
    OTHER,        /* 0xa1b */
    OTHER,        /* 0xa1c */
    OTHER,        /* 0xa1d */
    OTHER,        /* 0xa1e */
    OTHER,        /* 0xa1f */
    OTHER,        /* 0xa20 */
    OTHER,        /* 0xa21 */
    OTHER,        /* 0xa22 */
    OTHER,        /* 0xa23 */
    OTHER,        /* 0xa24 */
    OTHER,        /* 0xa25 */
    OTHER,        /* 0xa26 */
    OTHER,        /* 0xa27 */
    OTHER,        /* 0xa28 */
    OTHER,        /* 0xa29 */
    OTHER,        /* 0xa2a */
    OTHER,        /* 0xa2b */
    OTHER,        /* 0xa2c */
    OTHER,        /* 0xa2d */
    OTHER,        /* 0xa2e */
    OTHER,        /* 0xa2f */
    OTHER,        /* 0xa30 */
    OTHER,        /* 0xa31 */
    OTHER,        /* 0xa32 */
    OTHER,        /* 0xa33 */
    OTHER,        /* 0xa34 */
    OTHER,        /* 0xa35 */
    OTHER,        /* 0xa36 */
    OTHER,        /* 0xa37 */
    OTHER,        /* 0xa38 */
    OTHER,        /* 0xa39 */
    OTHER,        /* 0xa3a */
    OTHER,        /* 0xa3b */
    OTHER,        /* 0xa3c */
    OTHER,        /* 0xa3d */
    OTHER,        /* 0xa3e */
    OTHER,        /* 0xa3f */
    OTHER,        /* 0xa40 */
    OTHER,        /* 0xa41 */
    OTHER,        /* 0xa42 */
    OTHER,        /* 0xa43 */
    OTHER,        /* 0xa44 */
    OTHER,        /* 0xa45 */
    OTHER,        /* 0xa46 */
    OTHER,        /* 0xa47 */
    OTHER,        /* 0xa48 */
    OTHER,        /* 0xa49 */
    OTHER,        /* 0xa4a */
    OTHER,        /* 0xa4b */
    OTHER,        /* 0xa4c */
    OTHER,        /* 0xa4d */
    OTHER,        /* 0xa4e */
    OTHER,        /* 0xa4f */
    OTHER,        /* 0xa50 */
    OTHER,        /* 0xa51 */
    OTHER,        /* 0xa52 */
    OTHER,        /* 0xa53 */
    OTHER,        /* 0xa54 */
    OTHER,        /* 0xa55 */
    OTHER,        /* 0xa56 */
    OTHER,        /* 0xa57 */
    OTHER,        /* 0xa58 */
    OTHER,        /* 0xa59 */
    OTHER,        /* 0xa5a */
    OTHER,        /* 0xa5b */
    OTHER,        /* 0xa5c */
    OTHER,        /* 0xa5d */
    OTHER,        /* 0xa5e */
    OTHER,        /* 0xa5f */
    OTHER,        /* 0xa60 */
    OTHER,        /* 0xa61 */
    OTHER,        /* 0xa62 */
    OTHER,        /* 0xa63 */
    OTHER,        /* 0xa64 */
    OTHER,        /* 0xa65 */
    OTHER,        /* 0xa66 */
    OTHER,        /* 0xa67 */
    OTHER,        /* 0xa68 */
    OTHER,        /* 0xa69 */
    OTHER,        /* 0xa6a */
    OTHER,        /* 0xa6b */
    OTHER,        /* 0xa6c */
    OTHER,        /* 0xa6d */
    OTHER,        /* 0xa6e */
    OTHER,        /* 0xa6f */
    OTHER,        /* 0xa70 */
    OTHER,        /* 0xa71 */
    OTHER,        /* 0xa72 */
    OTHER,        /* 0xa73 */
    OTHER,        /* 0xa74 */
    OTHER,        /* 0xa75 */
    OTHER,        /* 0xa76 */
    OTHER,        /* 0xa77 */
    OTHER,        /* 0xa78 */
    OTHER,        /* 0xa79 */
    OTHER,        /* 0xa7a */
    OTHER,        /* 0xa7b */
    OTHER,        /* 0xa7c */
    OTHER,        /* 0xa7d */
    OTHER,        /* 0xa7e */
    OTHER,        /* 0xa7f */
    OTHER,        /* 0xa80 */
    OTHER,        /* 0xa81 */
    OTHER,        /* 0xa82 */
    OTHER,        /* 0xa83 */
    OTHER,        /* 0xa84 */
    OTHER,        /* 0xa85 */
    OTHER,        /* 0xa86 */
    OTHER,        /* 0xa87 */
    OTHER,        /* 0xa88 */
    OTHER,        /* 0xa89 */
    OTHER,        /* 0xa8a */
    OTHER,        /* 0xa8b */
    OTHER,        /* 0xa8c */
    OTHER,        /* 0xa8d */
    OTHER,        /* 0xa8e */
    OTHER,        /* 0xa8f */
    OTHER,        /* 0xa90 */
    OTHER,        /* 0xa91 */
    OTHER,        /* 0xa92 */
    OTHER,        /* 0xa93 */
    OTHER,        /* 0xa94 */
    OTHER,        /* 0xa95 */
    OTHER,        /* 0xa96 */
    OTHER,        /* 0xa97 */
    OTHER,        /* 0xa98 */
    OTHER,        /* 0xa99 */
    OTHER,        /* 0xa9a */
    OTHER,        /* 0xa9b */
    OTHER,        /* 0xa9c */
    OTHER,        /* 0xa9d */
    OTHER,        /* 0xa9e */
    OTHER,        /* 0xa9f */
    OTHER,        /* 0xaa0 */
    OTHER,        /* 0xaa1 */
    OTHER,        /* 0xaa2 */
    OTHER,        /* 0xaa3 */
    OTHER,        /* 0xaa4 */
    OTHER,        /* 0xaa5 */
    OTHER,        /* 0xaa6 */
    OTHER,        /* 0xaa7 */
    OTHER,        /* 0xaa8 */
    OTHER,        /* 0xaa9 */
    OTHER,        /* 0xaaa */
    OTHER,        /* 0xaab */
    OTHER,        /* 0xaac */
    OTHER,        /* 0xaad */
    OTHER,        /* 0xaae */
    OTHER,        /* 0xaaf */
    OTHER,        /* 0xab0 */
    OTHER,        /* 0xab1 */
    OTHER,        /* 0xab2 */
    OTHER,        /* 0xab3 */
    OTHER,        /* 0xab4 */
    OTHER,        /* 0xab5 */
    OTHER,        /* 0xab6 */
    OTHER,        /* 0xab7 */
    OTHER,        /* 0xab8 */
    OTHER,        /* 0xab9 */
    OTHER,        /* 0xaba */
    OTHER,        /* 0xabb */
    OTHER,        /* 0xabc */
    OTHER,        /* 0xabd */
    OTHER,        /* 0xabe */
    OTHER,        /* 0xabf */
    OTHER,        /* 0xac0 */
    OTHER,        /* 0xac1 */
    OTHER,        /* 0xac2 */
    OTHER,        /* 0xac3 */
    OTHER,        /* 0xac4 */
    OTHER,        /* 0xac5 */
    OTHER,        /* 0xac6 */
    OTHER,        /* 0xac7 */
    OTHER,        /* 0xac8 */
    OTHER,        /* 0xac9 */
    OTHER,        /* 0xaca */
    OTHER,        /* 0xacb */
    OTHER,        /* 0xacc */
    OTHER,        /* 0xacd */
    OTHER,        /* 0xace */
    OTHER,        /* 0xacf */
    OTHER,        /* 0xad0 */
    OTHER,        /* 0xad1 */
    OTHER,        /* 0xad2 */
    OTHER,        /* 0xad3 */
    OTHER,        /* 0xad4 */
    OTHER,        /* 0xad5 */
    OTHER,        /* 0xad6 */
    OTHER,        /* 0xad7 */
    OTHER,        /* 0xad8 */
    OTHER,        /* 0xad9 */
    OTHER,        /* 0xada */
    OTHER,        /* 0xadb */
    OTHER,        /* 0xadc */
    OTHER,        /* 0xadd */
    OTHER,        /* 0xade */
    OTHER,        /* 0xadf */
    OTHER,        /* 0xae0 */
    OTHER,        /* 0xae1 */
    OTHER,        /* 0xae2 */
    OTHER,        /* 0xae3 */
    OTHER,        /* 0xae4 */
    OTHER,        /* 0xae5 */
    OTHER,        /* 0xae6 */
    OTHER,        /* 0xae7 */
    OTHER,        /* 0xae8 */
    OTHER,        /* 0xae9 */
    OTHER,        /* 0xaea */
    OTHER,        /* 0xaeb */
    OTHER,        /* 0xaec */
    OTHER,        /* 0xaed */
    OTHER,        /* 0xaee */
    OTHER,        /* 0xaef */
    OTHER,        /* 0xaf0 */
    OTHER,        /* 0xaf1 */
    OTHER,        /* 0xaf2 */
    OTHER,        /* 0xaf3 */
    OTHER,        /* 0xaf4 */
    OTHER,        /* 0xaf5 */
    OTHER,        /* 0xaf6 */
    OTHER,        /* 0xaf7 */
    OTHER,        /* 0xaf8 */
    OTHER,        /* 0xaf9 */
    OTHER,        /* 0xafa */
    OTHER,        /* 0xafb */
    OTHER,        /* 0xafc */
    OTHER,        /* 0xafd */
    OTHER,        /* 0xafe */
    OTHER,        /* 0xaff */
    OTHER,        /* 0xb00 */
    OTHER,        /* 0xb01 */
    OTHER,        /* 0xb02 */
    OTHER,        /* 0xb03 */
    OTHER,        /* 0xb04 */
    OTHER,        /* 0xb05 */
    OTHER,        /* 0xb06 */
    OTHER,        /* 0xb07 */
    OTHER,        /* 0xb08 */
    OTHER,        /* 0xb09 */
    OTHER,        /* 0xb0a */
    OTHER,        /* 0xb0b */
    OTHER,        /* 0xb0c */
    OTHER,        /* 0xb0d */
    OTHER,        /* 0xb0e */
    OTHER,        /* 0xb0f */
    OTHER,        /* 0xb10 */
    OTHER,        /* 0xb11 */
    OTHER,        /* 0xb12 */
    OTHER,        /* 0xb13 */
    OTHER,        /* 0xb14 */
    OTHER,        /* 0xb15 */
    OTHER,        /* 0xb16 */
    OTHER,        /* 0xb17 */
    OTHER,        /* 0xb18 */
    OTHER,        /* 0xb19 */
    OTHER,        /* 0xb1a */
    OTHER,        /* 0xb1b */
    OTHER,        /* 0xb1c */
    OTHER,        /* 0xb1d */
    OTHER,        /* 0xb1e */
    OTHER,        /* 0xb1f */
    OTHER,        /* 0xb20 */
    OTHER,        /* 0xb21 */
    OTHER,        /* 0xb22 */
    OTHER,        /* 0xb23 */
    OTHER,        /* 0xb24 */
    OTHER,        /* 0xb25 */
    OTHER,        /* 0xb26 */
    OTHER,        /* 0xb27 */
    OTHER,        /* 0xb28 */
    OTHER,        /* 0xb29 */
    OTHER,        /* 0xb2a */
    OTHER,        /* 0xb2b */
    OTHER,        /* 0xb2c */
    OTHER,        /* 0xb2d */
    OTHER,        /* 0xb2e */
    OTHER,        /* 0xb2f */
    OTHER,        /* 0xb30 */
    OTHER,        /* 0xb31 */
    OTHER,        /* 0xb32 */
    OTHER,        /* 0xb33 */
    OTHER,        /* 0xb34 */
    OTHER,        /* 0xb35 */
    OTHER,        /* 0xb36 */
    OTHER,        /* 0xb37 */
    OTHER,        /* 0xb38 */
    OTHER,        /* 0xb39 */
    OTHER,        /* 0xb3a */
    OTHER,        /* 0xb3b */
    OTHER,        /* 0xb3c */
    OTHER,        /* 0xb3d */
    OTHER,        /* 0xb3e */
    OTHER,        /* 0xb3f */
    OTHER,        /* 0xb40 */
    OTHER,        /* 0xb41 */
    OTHER,        /* 0xb42 */
    OTHER,        /* 0xb43 */
    OTHER,        /* 0xb44 */
    OTHER,        /* 0xb45 */
    OTHER,        /* 0xb46 */
    OTHER,        /* 0xb47 */
    OTHER,        /* 0xb48 */
    OTHER,        /* 0xb49 */
    OTHER,        /* 0xb4a */
    OTHER,        /* 0xb4b */
    OTHER,        /* 0xb4c */
    OTHER,        /* 0xb4d */
    OTHER,        /* 0xb4e */
    OTHER,        /* 0xb4f */
    OTHER,        /* 0xb50 */
    OTHER,        /* 0xb51 */
    OTHER,        /* 0xb52 */
    OTHER,        /* 0xb53 */
    OTHER,        /* 0xb54 */
    OTHER,        /* 0xb55 */
    OTHER,        /* 0xb56 */
    OTHER,        /* 0xb57 */
    OTHER,        /* 0xb58 */
    OTHER,        /* 0xb59 */
    OTHER,        /* 0xb5a */
    OTHER,        /* 0xb5b */
    OTHER,        /* 0xb5c */
    OTHER,        /* 0xb5d */
    OTHER,        /* 0xb5e */
    OTHER,        /* 0xb5f */
    OTHER,        /* 0xb60 */
    OTHER,        /* 0xb61 */
    OTHER,        /* 0xb62 */
    OTHER,        /* 0xb63 */
    OTHER,        /* 0xb64 */
    OTHER,        /* 0xb65 */
    OTHER,        /* 0xb66 */
    OTHER,        /* 0xb67 */
    OTHER,        /* 0xb68 */
    OTHER,        /* 0xb69 */
    OTHER,        /* 0xb6a */
    OTHER,        /* 0xb6b */
    OTHER,        /* 0xb6c */
    OTHER,        /* 0xb6d */
    OTHER,        /* 0xb6e */
    OTHER,        /* 0xb6f */
    OTHER,        /* 0xb70 */
    OTHER,        /* 0xb71 */
    OTHER,        /* 0xb72 */
    OTHER,        /* 0xb73 */
    OTHER,        /* 0xb74 */
    OTHER,        /* 0xb75 */
    OTHER,        /* 0xb76 */
    OTHER,        /* 0xb77 */
    OTHER,        /* 0xb78 */
    OTHER,        /* 0xb79 */
    OTHER,        /* 0xb7a */
    OTHER,        /* 0xb7b */
    OTHER,        /* 0xb7c */
    OTHER,        /* 0xb7d */
    OTHER,        /* 0xb7e */
    OTHER,        /* 0xb7f */
    OTHER,        /* 0xb80 */
    OTHER,        /* 0xb81 */
    OTHER,        /* 0xb82 */
    OTHER,        /* 0xb83 */
    OTHER,        /* 0xb84 */
    OTHER,        /* 0xb85 */
    OTHER,        /* 0xb86 */
    OTHER,        /* 0xb87 */
    OTHER,        /* 0xb88 */
    OTHER,        /* 0xb89 */
    OTHER,        /* 0xb8a */
    OTHER,        /* 0xb8b */
    OTHER,        /* 0xb8c */
    OTHER,        /* 0xb8d */
    OTHER,        /* 0xb8e */
    OTHER,        /* 0xb8f */
    OTHER,        /* 0xb90 */
    OTHER,        /* 0xb91 */
    OTHER,        /* 0xb92 */
    OTHER,        /* 0xb93 */
    OTHER,        /* 0xb94 */
    OTHER,        /* 0xb95 */
    OTHER,        /* 0xb96 */
    OTHER,        /* 0xb97 */
    OTHER,        /* 0xb98 */
    OTHER,        /* 0xb99 */
    OTHER,        /* 0xb9a */
    OTHER,        /* 0xb9b */
    OTHER,        /* 0xb9c */
    OTHER,        /* 0xb9d */
    OTHER,        /* 0xb9e */
    OTHER,        /* 0xb9f */
    OTHER,        /* 0xba0 */
    OTHER,        /* 0xba1 */
    OTHER,        /* 0xba2 */
    OTHER,        /* 0xba3 */
    OTHER,        /* 0xba4 */
    OTHER,        /* 0xba5 */
    OTHER,        /* 0xba6 */
    OTHER,        /* 0xba7 */
    OTHER,        /* 0xba8 */
    OTHER,        /* 0xba9 */
    OTHER,        /* 0xbaa */
    OTHER,        /* 0xbab */
    OTHER,        /* 0xbac */
    OTHER,        /* 0xbad */
    OTHER,        /* 0xbae */
    OTHER,        /* 0xbaf */
    OTHER,        /* 0xbb0 */
    OTHER,        /* 0xbb1 */
    OTHER,        /* 0xbb2 */
    OTHER,        /* 0xbb3 */
    OTHER,        /* 0xbb4 */
    OTHER,        /* 0xbb5 */
    OTHER,        /* 0xbb6 */
    OTHER,        /* 0xbb7 */
    OTHER,        /* 0xbb8 */
    OTHER,        /* 0xbb9 */
    OTHER,        /* 0xbba */
    OTHER,        /* 0xbbb */
    OTHER,        /* 0xbbc */
    OTHER,        /* 0xbbd */
    OTHER,        /* 0xbbe */
    OTHER,        /* 0xbbf */
    OTHER,        /* 0xbc0 */
    OTHER,        /* 0xbc1 */
    OTHER,        /* 0xbc2 */
    OTHER,        /* 0xbc3 */
    OTHER,        /* 0xbc4 */
    OTHER,        /* 0xbc5 */
    OTHER,        /* 0xbc6 */
    OTHER,        /* 0xbc7 */
    OTHER,        /* 0xbc8 */
    OTHER,        /* 0xbc9 */
    OTHER,        /* 0xbca */
    OTHER,        /* 0xbcb */
    OTHER,        /* 0xbcc */
    OTHER,        /* 0xbcd */
    OTHER,        /* 0xbce */
    OTHER,        /* 0xbcf */
    OTHER,        /* 0xbd0 */
    OTHER,        /* 0xbd1 */
    OTHER,        /* 0xbd2 */
    OTHER,        /* 0xbd3 */
    OTHER,        /* 0xbd4 */
    OTHER,        /* 0xbd5 */
    OTHER,        /* 0xbd6 */
    OTHER,        /* 0xbd7 */
    OTHER,        /* 0xbd8 */
    OTHER,        /* 0xbd9 */
    OTHER,        /* 0xbda */
    OTHER,        /* 0xbdb */
    OTHER,        /* 0xbdc */
    OTHER,        /* 0xbdd */
    OTHER,        /* 0xbde */
    OTHER,        /* 0xbdf */
    OTHER,        /* 0xbe0 */
    OTHER,        /* 0xbe1 */
    OTHER,        /* 0xbe2 */
    OTHER,        /* 0xbe3 */
    OTHER,        /* 0xbe4 */
    OTHER,        /* 0xbe5 */
    OTHER,        /* 0xbe6 */
    OTHER,        /* 0xbe7 */
    OTHER,        /* 0xbe8 */
    OTHER,        /* 0xbe9 */
    OTHER,        /* 0xbea */
    OTHER,        /* 0xbeb */
    OTHER,        /* 0xbec */
    OTHER,        /* 0xbed */
    OTHER,        /* 0xbee */
    OTHER,        /* 0xbef */
    OTHER,        /* 0xbf0 */
    OTHER,        /* 0xbf1 */
    OTHER,        /* 0xbf2 */
    OTHER,        /* 0xbf3 */
    OTHER,        /* 0xbf4 */
    OTHER,        /* 0xbf5 */
    OTHER,        /* 0xbf6 */
    OTHER,        /* 0xbf7 */
    OTHER,        /* 0xbf8 */
    OTHER,        /* 0xbf9 */
    OTHER,        /* 0xbfa */
    OTHER,        /* 0xbfb */
    OTHER,        /* 0xbfc */
    OTHER,        /* 0xbfd */
    OTHER,        /* 0xbfe */
    OTHER,        /* 0xbff */
    OTHER,        /* 0xc00 */
    OTHER,        /* 0xc01 */
    OTHER,        /* 0xc02 */
    OTHER,        /* 0xc03 */
    OTHER,        /* 0xc04 */
    OTHER,        /* 0xc05 */
    OTHER,        /* 0xc06 */
    OTHER,        /* 0xc07 */
    OTHER,        /* 0xc08 */
    OTHER,        /* 0xc09 */
    OTHER,        /* 0xc0a */
    OTHER,        /* 0xc0b */
    OTHER,        /* 0xc0c */
    OTHER,        /* 0xc0d */
    OTHER,        /* 0xc0e */
    OTHER,        /* 0xc0f */
    OTHER,        /* 0xc10 */
    OTHER,        /* 0xc11 */
    OTHER,        /* 0xc12 */
    OTHER,        /* 0xc13 */
    OTHER,        /* 0xc14 */
    OTHER,        /* 0xc15 */
    OTHER,        /* 0xc16 */
    OTHER,        /* 0xc17 */
    OTHER,        /* 0xc18 */
    OTHER,        /* 0xc19 */
    OTHER,        /* 0xc1a */
    OTHER,        /* 0xc1b */
    OTHER,        /* 0xc1c */
    OTHER,        /* 0xc1d */
    OTHER,        /* 0xc1e */
    OTHER,        /* 0xc1f */
    OTHER,        /* 0xc20 */
    OTHER,        /* 0xc21 */
    OTHER,        /* 0xc22 */
    OTHER,        /* 0xc23 */
    OTHER,        /* 0xc24 */
    OTHER,        /* 0xc25 */
    OTHER,        /* 0xc26 */
    OTHER,        /* 0xc27 */
    OTHER,        /* 0xc28 */
    OTHER,        /* 0xc29 */
    OTHER,        /* 0xc2a */
    OTHER,        /* 0xc2b */
    OTHER,        /* 0xc2c */
    OTHER,        /* 0xc2d */
    OTHER,        /* 0xc2e */
    OTHER,        /* 0xc2f */
    OTHER,        /* 0xc30 */
    OTHER,        /* 0xc31 */
    OTHER,        /* 0xc32 */
    OTHER,        /* 0xc33 */
    OTHER,        /* 0xc34 */
    OTHER,        /* 0xc35 */
    OTHER,        /* 0xc36 */
    OTHER,        /* 0xc37 */
    OTHER,        /* 0xc38 */
    OTHER,        /* 0xc39 */
    OTHER,        /* 0xc3a */
    OTHER,        /* 0xc3b */
    OTHER,        /* 0xc3c */
    OTHER,        /* 0xc3d */
    OTHER,        /* 0xc3e */
    OTHER,        /* 0xc3f */
    OTHER,        /* 0xc40 */
    OTHER,        /* 0xc41 */
    OTHER,        /* 0xc42 */
    OTHER,        /* 0xc43 */
    OTHER,        /* 0xc44 */
    OTHER,        /* 0xc45 */
    OTHER,        /* 0xc46 */
    OTHER,        /* 0xc47 */
    OTHER,        /* 0xc48 */
    OTHER,        /* 0xc49 */
    OTHER,        /* 0xc4a */
    OTHER,        /* 0xc4b */
    OTHER,        /* 0xc4c */
    OTHER,        /* 0xc4d */
    OTHER,        /* 0xc4e */
    OTHER,        /* 0xc4f */
    OTHER,        /* 0xc50 */
    OTHER,        /* 0xc51 */
    OTHER,        /* 0xc52 */
    OTHER,        /* 0xc53 */
    OTHER,        /* 0xc54 */
    OTHER,        /* 0xc55 */
    OTHER,        /* 0xc56 */
    OTHER,        /* 0xc57 */
    OTHER,        /* 0xc58 */
    OTHER,        /* 0xc59 */
    OTHER,        /* 0xc5a */
    OTHER,        /* 0xc5b */
    OTHER,        /* 0xc5c */
    OTHER,        /* 0xc5d */
    OTHER,        /* 0xc5e */
    OTHER,        /* 0xc5f */
    OTHER,        /* 0xc60 */
    OTHER,        /* 0xc61 */
    OTHER,        /* 0xc62 */
    OTHER,        /* 0xc63 */
    OTHER,        /* 0xc64 */
    OTHER,        /* 0xc65 */
    OTHER,        /* 0xc66 */
    OTHER,        /* 0xc67 */
    OTHER,        /* 0xc68 */
    OTHER,        /* 0xc69 */
    OTHER,        /* 0xc6a */
    OTHER,        /* 0xc6b */
    OTHER,        /* 0xc6c */
    OTHER,        /* 0xc6d */
    OTHER,        /* 0xc6e */
    OTHER,        /* 0xc6f */
    OTHER,        /* 0xc70 */
    OTHER,        /* 0xc71 */
    OTHER,        /* 0xc72 */
    OTHER,        /* 0xc73 */
    OTHER,        /* 0xc74 */
    OTHER,        /* 0xc75 */
    OTHER,        /* 0xc76 */
    OTHER,        /* 0xc77 */
    OTHER,        /* 0xc78 */
    OTHER,        /* 0xc79 */
    OTHER,        /* 0xc7a */
    OTHER,        /* 0xc7b */
    OTHER,        /* 0xc7c */
    OTHER,        /* 0xc7d */
    OTHER,        /* 0xc7e */
    OTHER,        /* 0xc7f */
    OTHER,        /* 0xc80 */
    OTHER,        /* 0xc81 */
    OTHER,        /* 0xc82 */
    OTHER,        /* 0xc83 */
    OTHER,        /* 0xc84 */
    OTHER,        /* 0xc85 */
    OTHER,        /* 0xc86 */
    OTHER,        /* 0xc87 */
    OTHER,        /* 0xc88 */
    OTHER,        /* 0xc89 */
    OTHER,        /* 0xc8a */
    OTHER,        /* 0xc8b */
    OTHER,        /* 0xc8c */
    OTHER,        /* 0xc8d */
    OTHER,        /* 0xc8e */
    OTHER,        /* 0xc8f */
    OTHER,        /* 0xc90 */
    OTHER,        /* 0xc91 */
    OTHER,        /* 0xc92 */
    OTHER,        /* 0xc93 */
    OTHER,        /* 0xc94 */
    OTHER,        /* 0xc95 */
    OTHER,        /* 0xc96 */
    OTHER,        /* 0xc97 */
    OTHER,        /* 0xc98 */
    OTHER,        /* 0xc99 */
    OTHER,        /* 0xc9a */
    OTHER,        /* 0xc9b */
    OTHER,        /* 0xc9c */
    OTHER,        /* 0xc9d */
    OTHER,        /* 0xc9e */
    OTHER,        /* 0xc9f */
    OTHER,        /* 0xca0 */
    OTHER,        /* 0xca1 */
    OTHER,        /* 0xca2 */
    OTHER,        /* 0xca3 */
    OTHER,        /* 0xca4 */
    OTHER,        /* 0xca5 */
    OTHER,        /* 0xca6 */
    OTHER,        /* 0xca7 */
    OTHER,        /* 0xca8 */
    OTHER,        /* 0xca9 */
    OTHER,        /* 0xcaa */
    OTHER,        /* 0xcab */
    OTHER,        /* 0xcac */
    OTHER,        /* 0xcad */
    OTHER,        /* 0xcae */
    OTHER,        /* 0xcaf */
    OTHER,        /* 0xcb0 */
    OTHER,        /* 0xcb1 */
    OTHER,        /* 0xcb2 */
    OTHER,        /* 0xcb3 */
    OTHER,        /* 0xcb4 */
    OTHER,        /* 0xcb5 */
    OTHER,        /* 0xcb6 */
    OTHER,        /* 0xcb7 */
    OTHER,        /* 0xcb8 */
    OTHER,        /* 0xcb9 */
    OTHER,        /* 0xcba */
    OTHER,        /* 0xcbb */
    OTHER,        /* 0xcbc */
    OTHER,        /* 0xcbd */
    OTHER,        /* 0xcbe */
    OTHER,        /* 0xcbf */
    OTHER,        /* 0xcc0 */
    OTHER,        /* 0xcc1 */
    OTHER,        /* 0xcc2 */
    OTHER,        /* 0xcc3 */
    OTHER,        /* 0xcc4 */
    OTHER,        /* 0xcc5 */
    OTHER,        /* 0xcc6 */
    OTHER,        /* 0xcc7 */
    OTHER,        /* 0xcc8 */
    OTHER,        /* 0xcc9 */
    OTHER,        /* 0xcca */
    OTHER,        /* 0xccb */
    OTHER,        /* 0xccc */
    OTHER,        /* 0xccd */
    OTHER,        /* 0xcce */
    OTHER,        /* 0xccf */
    OTHER,        /* 0xcd0 */
    OTHER,        /* 0xcd1 */
    OTHER,        /* 0xcd2 */
    OTHER,        /* 0xcd3 */
    OTHER,        /* 0xcd4 */
    OTHER,        /* 0xcd5 */
    OTHER,        /* 0xcd6 */
    OTHER,        /* 0xcd7 */
    OTHER,        /* 0xcd8 */
    OTHER,        /* 0xcd9 */
    OTHER,        /* 0xcda */
    OTHER,        /* 0xcdb */
    OTHER,        /* 0xcdc */
    OTHER,        /* 0xcdd */
    OTHER,        /* 0xcde */
    OTHER,        /* 0xcdf */
    OTHER,        /* 0xce0 */
    OTHER,        /* 0xce1 */
    OTHER,        /* 0xce2 */
    OTHER,        /* 0xce3 */
    OTHER,        /* 0xce4 */
    OTHER,        /* 0xce5 */
    OTHER,        /* 0xce6 */
    OTHER,        /* 0xce7 */
    OTHER,        /* 0xce8 */
    OTHER,        /* 0xce9 */
    OTHER,        /* 0xcea */
    OTHER,        /* 0xceb */
    OTHER,        /* 0xcec */
    OTHER,        /* 0xced */
    OTHER,        /* 0xcee */
    OTHER,        /* 0xcef */
    OTHER,        /* 0xcf0 */
    OTHER,        /* 0xcf1 */
    OTHER,        /* 0xcf2 */
    OTHER,        /* 0xcf3 */
    OTHER,        /* 0xcf4 */
    OTHER,        /* 0xcf5 */
    OTHER,        /* 0xcf6 */
    OTHER,        /* 0xcf7 */
    OTHER,        /* 0xcf8 */
    OTHER,        /* 0xcf9 */
    OTHER,        /* 0xcfa */
    OTHER,        /* 0xcfb */
    OTHER,        /* 0xcfc */
    OTHER,        /* 0xcfd */
    OTHER,        /* 0xcfe */
    OTHER,        /* 0xcff */
    OTHER,        /* 0xd00 */
    OTHER,        /* 0xd01 */
    OTHER,        /* 0xd02 */
    OTHER,        /* 0xd03 */
    OTHER,        /* 0xd04 */
    OTHER,        /* 0xd05 */
    OTHER,        /* 0xd06 */
    OTHER,        /* 0xd07 */
    OTHER,        /* 0xd08 */
    OTHER,        /* 0xd09 */
    OTHER,        /* 0xd0a */
    OTHER,        /* 0xd0b */
    OTHER,        /* 0xd0c */
    OTHER,        /* 0xd0d */
    OTHER,        /* 0xd0e */
    OTHER,        /* 0xd0f */
    OTHER,        /* 0xd10 */
    OTHER,        /* 0xd11 */
    OTHER,        /* 0xd12 */
    OTHER,        /* 0xd13 */
    OTHER,        /* 0xd14 */
    OTHER,        /* 0xd15 */
    OTHER,        /* 0xd16 */
    OTHER,        /* 0xd17 */
    OTHER,        /* 0xd18 */
    OTHER,        /* 0xd19 */
    OTHER,        /* 0xd1a */
    OTHER,        /* 0xd1b */
    OTHER,        /* 0xd1c */
    OTHER,        /* 0xd1d */
    OTHER,        /* 0xd1e */
    OTHER,        /* 0xd1f */
    OTHER,        /* 0xd20 */
    OTHER,        /* 0xd21 */
    OTHER,        /* 0xd22 */
    OTHER,        /* 0xd23 */
    OTHER,        /* 0xd24 */
    OTHER,        /* 0xd25 */
    OTHER,        /* 0xd26 */
    OTHER,        /* 0xd27 */
    OTHER,        /* 0xd28 */
    OTHER,        /* 0xd29 */
    OTHER,        /* 0xd2a */
    OTHER,        /* 0xd2b */
    OTHER,        /* 0xd2c */
    OTHER,        /* 0xd2d */
    OTHER,        /* 0xd2e */
    OTHER,        /* 0xd2f */
    OTHER,        /* 0xd30 */
    OTHER,        /* 0xd31 */
    OTHER,        /* 0xd32 */
    OTHER,        /* 0xd33 */
    OTHER,        /* 0xd34 */
    OTHER,        /* 0xd35 */
    OTHER,        /* 0xd36 */
    OTHER,        /* 0xd37 */
    OTHER,        /* 0xd38 */
    OTHER,        /* 0xd39 */
    OTHER,        /* 0xd3a */
    OTHER,        /* 0xd3b */
    OTHER,        /* 0xd3c */
    OTHER,        /* 0xd3d */
    OTHER,        /* 0xd3e */
    OTHER,        /* 0xd3f */
    OTHER,        /* 0xd40 */
    OTHER,        /* 0xd41 */
    OTHER,        /* 0xd42 */
    OTHER,        /* 0xd43 */
    OTHER,        /* 0xd44 */
    OTHER,        /* 0xd45 */
    OTHER,        /* 0xd46 */
    OTHER,        /* 0xd47 */
    OTHER,        /* 0xd48 */
    OTHER,        /* 0xd49 */
    OTHER,        /* 0xd4a */
    OTHER,        /* 0xd4b */
    OTHER,        /* 0xd4c */
    OTHER,        /* 0xd4d */
    OTHER,        /* 0xd4e */
    OTHER,        /* 0xd4f */
    OTHER,        /* 0xd50 */
    OTHER,        /* 0xd51 */
    OTHER,        /* 0xd52 */
    OTHER,        /* 0xd53 */
    OTHER,        /* 0xd54 */
    OTHER,        /* 0xd55 */
    OTHER,        /* 0xd56 */
    OTHER,        /* 0xd57 */
    OTHER,        /* 0xd58 */
    OTHER,        /* 0xd59 */
    OTHER,        /* 0xd5a */
    OTHER,        /* 0xd5b */
    OTHER,        /* 0xd5c */
    OTHER,        /* 0xd5d */
    OTHER,        /* 0xd5e */
    OTHER,        /* 0xd5f */
    OTHER,        /* 0xd60 */
    OTHER,        /* 0xd61 */
    OTHER,        /* 0xd62 */
    OTHER,        /* 0xd63 */
    OTHER,        /* 0xd64 */
    OTHER,        /* 0xd65 */
    OTHER,        /* 0xd66 */
    OTHER,        /* 0xd67 */
    OTHER,        /* 0xd68 */
    OTHER,        /* 0xd69 */
    OTHER,        /* 0xd6a */
    OTHER,        /* 0xd6b */
    OTHER,        /* 0xd6c */
    OTHER,        /* 0xd6d */
    OTHER,        /* 0xd6e */
    OTHER,        /* 0xd6f */
    OTHER,        /* 0xd70 */
    OTHER,        /* 0xd71 */
    OTHER,        /* 0xd72 */
    OTHER,        /* 0xd73 */
    OTHER,        /* 0xd74 */
    OTHER,        /* 0xd75 */
    OTHER,        /* 0xd76 */
    OTHER,        /* 0xd77 */
    OTHER,        /* 0xd78 */
    OTHER,        /* 0xd79 */
    OTHER,        /* 0xd7a */
    OTHER,        /* 0xd7b */
    OTHER,        /* 0xd7c */
    OTHER,        /* 0xd7d */
    OTHER,        /* 0xd7e */
    OTHER,        /* 0xd7f */
    OTHER,        /* 0xd80 */
    OTHER,        /* 0xd81 */
    OTHER,        /* 0xd82 */
    OTHER,        /* 0xd83 */
    OTHER,        /* 0xd84 */
    OTHER,        /* 0xd85 */
    OTHER,        /* 0xd86 */
    OTHER,        /* 0xd87 */
    OTHER,        /* 0xd88 */
    OTHER,        /* 0xd89 */
    OTHER,        /* 0xd8a */
    OTHER,        /* 0xd8b */
    OTHER,        /* 0xd8c */
    OTHER,        /* 0xd8d */
    OTHER,        /* 0xd8e */
    OTHER,        /* 0xd8f */
    OTHER,        /* 0xd90 */
    OTHER,        /* 0xd91 */
    OTHER,        /* 0xd92 */
    OTHER,        /* 0xd93 */
    OTHER,        /* 0xd94 */
    OTHER,        /* 0xd95 */
    OTHER,        /* 0xd96 */
    OTHER,        /* 0xd97 */
    OTHER,        /* 0xd98 */
    OTHER,        /* 0xd99 */
    OTHER,        /* 0xd9a */
    OTHER,        /* 0xd9b */
    OTHER,        /* 0xd9c */
    OTHER,        /* 0xd9d */
    OTHER,        /* 0xd9e */
    OTHER,        /* 0xd9f */
    OTHER,        /* 0xda0 */
    OTHER,        /* 0xda1 */
    OTHER,        /* 0xda2 */
    OTHER,        /* 0xda3 */
    OTHER,        /* 0xda4 */
    OTHER,        /* 0xda5 */
    OTHER,        /* 0xda6 */
    OTHER,        /* 0xda7 */
    OTHER,        /* 0xda8 */
    OTHER,        /* 0xda9 */
    OTHER,        /* 0xdaa */
    OTHER,        /* 0xdab */
    OTHER,        /* 0xdac */
    OTHER,        /* 0xdad */
    OTHER,        /* 0xdae */
    OTHER,        /* 0xdaf */
    OTHER,        /* 0xdb0 */
    OTHER,        /* 0xdb1 */
    OTHER,        /* 0xdb2 */
    OTHER,        /* 0xdb3 */
    OTHER,        /* 0xdb4 */
    OTHER,        /* 0xdb5 */
    OTHER,        /* 0xdb6 */
    OTHER,        /* 0xdb7 */
    OTHER,        /* 0xdb8 */
    OTHER,        /* 0xdb9 */
    OTHER,        /* 0xdba */
    OTHER,        /* 0xdbb */
    OTHER,        /* 0xdbc */
    OTHER,        /* 0xdbd */
    OTHER,        /* 0xdbe */
    OTHER,        /* 0xdbf */
    OTHER,        /* 0xdc0 */
    OTHER,        /* 0xdc1 */
    OTHER,        /* 0xdc2 */
    OTHER,        /* 0xdc3 */
    OTHER,        /* 0xdc4 */
    OTHER,        /* 0xdc5 */
    OTHER,        /* 0xdc6 */
    OTHER,        /* 0xdc7 */
    OTHER,        /* 0xdc8 */
    OTHER,        /* 0xdc9 */
    OTHER,        /* 0xdca */
    OTHER,        /* 0xdcb */
    OTHER,        /* 0xdcc */
    OTHER,        /* 0xdcd */
    OTHER,        /* 0xdce */
    OTHER,        /* 0xdcf */
    OTHER,        /* 0xdd0 */
    OTHER,        /* 0xdd1 */
    OTHER,        /* 0xdd2 */
    OTHER,        /* 0xdd3 */
    OTHER,        /* 0xdd4 */
    OTHER,        /* 0xdd5 */
    OTHER,        /* 0xdd6 */
    OTHER,        /* 0xdd7 */
    OTHER,        /* 0xdd8 */
    OTHER,        /* 0xdd9 */
    OTHER,        /* 0xdda */
    OTHER,        /* 0xddb */
    OTHER,        /* 0xddc */
    OTHER,        /* 0xddd */
    OTHER,        /* 0xdde */
    OTHER,        /* 0xddf */
    OTHER,        /* 0xde0 */
    OTHER,        /* 0xde1 */
    OTHER,        /* 0xde2 */
    OTHER,        /* 0xde3 */
    OTHER,        /* 0xde4 */
    OTHER,        /* 0xde5 */
    OTHER,        /* 0xde6 */
    OTHER,        /* 0xde7 */
    OTHER,        /* 0xde8 */
    OTHER,        /* 0xde9 */
    OTHER,        /* 0xdea */
    OTHER,        /* 0xdeb */
    OTHER,        /* 0xdec */
    OTHER,        /* 0xded */
    OTHER,        /* 0xdee */
    OTHER,        /* 0xdef */
    OTHER,        /* 0xdf0 */
    OTHER,        /* 0xdf1 */
    OTHER,        /* 0xdf2 */
    OTHER,        /* 0xdf3 */
    OTHER,        /* 0xdf4 */
    OTHER,        /* 0xdf5 */
    OTHER,        /* 0xdf6 */
    OTHER,        /* 0xdf7 */
    OTHER,        /* 0xdf8 */
    OTHER,        /* 0xdf9 */
    OTHER,        /* 0xdfa */
    OTHER,        /* 0xdfb */
    OTHER,        /* 0xdfc */
    OTHER,        /* 0xdfd */
    OTHER,        /* 0xdfe */
    OTHER,        /* 0xdff */
    OTHER,        /* 0xe00 */
    OTHER,        /* 0xe01 */
    OTHER,        /* 0xe02 */
    OTHER,        /* 0xe03 */
    OTHER,        /* 0xe04 */
    OTHER,        /* 0xe05 */
    OTHER,        /* 0xe06 */
    OTHER,        /* 0xe07 */
    OTHER,        /* 0xe08 */
    OTHER,        /* 0xe09 */
    OTHER,        /* 0xe0a */
    OTHER,        /* 0xe0b */
    OTHER,        /* 0xe0c */
    OTHER,        /* 0xe0d */
    OTHER,        /* 0xe0e */
    OTHER,        /* 0xe0f */
    OTHER,        /* 0xe10 */
    OTHER,        /* 0xe11 */
    OTHER,        /* 0xe12 */
    OTHER,        /* 0xe13 */
    OTHER,        /* 0xe14 */
    OTHER,        /* 0xe15 */
    OTHER,        /* 0xe16 */
    OTHER,        /* 0xe17 */
    OTHER,        /* 0xe18 */
    OTHER,        /* 0xe19 */
    OTHER,        /* 0xe1a */
    OTHER,        /* 0xe1b */
    OTHER,        /* 0xe1c */
    OTHER,        /* 0xe1d */
    OTHER,        /* 0xe1e */
    OTHER,        /* 0xe1f */
    OTHER,        /* 0xe20 */
    OTHER,        /* 0xe21 */
    OTHER,        /* 0xe22 */
    OTHER,        /* 0xe23 */
    OTHER,        /* 0xe24 */
    OTHER,        /* 0xe25 */
    OTHER,        /* 0xe26 */
    OTHER,        /* 0xe27 */
    OTHER,        /* 0xe28 */
    OTHER,        /* 0xe29 */
    OTHER,        /* 0xe2a */
    OTHER,        /* 0xe2b */
    OTHER,        /* 0xe2c */
    OTHER,        /* 0xe2d */
    OTHER,        /* 0xe2e */
    OTHER,        /* 0xe2f */
    OTHER,        /* 0xe30 */
    OTHER,        /* 0xe31 */
    OTHER,        /* 0xe32 */
    OTHER,        /* 0xe33 */
    OTHER,        /* 0xe34 */
    OTHER,        /* 0xe35 */
    OTHER,        /* 0xe36 */
    OTHER,        /* 0xe37 */
    OTHER,        /* 0xe38 */
    OTHER,        /* 0xe39 */
    OTHER,        /* 0xe3a */
    OTHER,        /* 0xe3b */
    OTHER,        /* 0xe3c */
    OTHER,        /* 0xe3d */
    OTHER,        /* 0xe3e */
    OTHER,        /* 0xe3f */
    OTHER,        /* 0xe40 */
    OTHER,        /* 0xe41 */
    OTHER,        /* 0xe42 */
    OTHER,        /* 0xe43 */
    OTHER,        /* 0xe44 */
    OTHER,        /* 0xe45 */
    OTHER,        /* 0xe46 */
    OTHER,        /* 0xe47 */
    OTHER,        /* 0xe48 */
    OTHER,        /* 0xe49 */
    OTHER,        /* 0xe4a */
    OTHER,        /* 0xe4b */
    OTHER,        /* 0xe4c */
    OTHER,        /* 0xe4d */
    OTHER,        /* 0xe4e */
    OTHER,        /* 0xe4f */
    OTHER,        /* 0xe50 */
    OTHER,        /* 0xe51 */
    OTHER,        /* 0xe52 */
    OTHER,        /* 0xe53 */
    OTHER,        /* 0xe54 */
    OTHER,        /* 0xe55 */
    OTHER,        /* 0xe56 */
    OTHER,        /* 0xe57 */
    OTHER,        /* 0xe58 */
    OTHER,        /* 0xe59 */
    OTHER,        /* 0xe5a */
    OTHER,        /* 0xe5b */
    OTHER,        /* 0xe5c */
    OTHER,        /* 0xe5d */
    OTHER,        /* 0xe5e */
    OTHER,        /* 0xe5f */
    OTHER,        /* 0xe60 */
    OTHER,        /* 0xe61 */
    OTHER,        /* 0xe62 */
    OTHER,        /* 0xe63 */
    OTHER,        /* 0xe64 */
    OTHER,        /* 0xe65 */
    OTHER,        /* 0xe66 */
    OTHER,        /* 0xe67 */
    OTHER,        /* 0xe68 */
    OTHER,        /* 0xe69 */
    OTHER,        /* 0xe6a */
    OTHER,        /* 0xe6b */
    OTHER,        /* 0xe6c */
    OTHER,        /* 0xe6d */
    OTHER,        /* 0xe6e */
    OTHER,        /* 0xe6f */
    OTHER,        /* 0xe70 */
    OTHER,        /* 0xe71 */
    OTHER,        /* 0xe72 */
    OTHER,        /* 0xe73 */
    OTHER,        /* 0xe74 */
    OTHER,        /* 0xe75 */
    OTHER,        /* 0xe76 */
    OTHER,        /* 0xe77 */
    OTHER,        /* 0xe78 */
    OTHER,        /* 0xe79 */
    OTHER,        /* 0xe7a */
    OTHER,        /* 0xe7b */
    OTHER,        /* 0xe7c */
    OTHER,        /* 0xe7d */
    OTHER,        /* 0xe7e */
    OTHER,        /* 0xe7f */
    OTHER,        /* 0xe80 */
    OTHER,        /* 0xe81 */
    OTHER,        /* 0xe82 */
    OTHER,        /* 0xe83 */
    OTHER,        /* 0xe84 */
    OTHER,        /* 0xe85 */
    OTHER,        /* 0xe86 */
    OTHER,        /* 0xe87 */
    OTHER,        /* 0xe88 */
    OTHER,        /* 0xe89 */
    OTHER,        /* 0xe8a */
    OTHER,        /* 0xe8b */
    OTHER,        /* 0xe8c */
    OTHER,        /* 0xe8d */
    OTHER,        /* 0xe8e */
    OTHER,        /* 0xe8f */
    OTHER,        /* 0xe90 */
    OTHER,        /* 0xe91 */
    OTHER,        /* 0xe92 */
    OTHER,        /* 0xe93 */
    OTHER,        /* 0xe94 */
    OTHER,        /* 0xe95 */
    OTHER,        /* 0xe96 */
    OTHER,        /* 0xe97 */
    OTHER,        /* 0xe98 */
    OTHER,        /* 0xe99 */
    OTHER,        /* 0xe9a */
    OTHER,        /* 0xe9b */
    OTHER,        /* 0xe9c */
    OTHER,        /* 0xe9d */
    OTHER,        /* 0xe9e */
    OTHER,        /* 0xe9f */
    OTHER,        /* 0xea0 */
    OTHER,        /* 0xea1 */
    OTHER,        /* 0xea2 */
    OTHER,        /* 0xea3 */
    OTHER,        /* 0xea4 */
    OTHER,        /* 0xea5 */
    OTHER,        /* 0xea6 */
    OTHER,        /* 0xea7 */
    OTHER,        /* 0xea8 */
    OTHER,        /* 0xea9 */
    OTHER,        /* 0xeaa */
    OTHER,        /* 0xeab */
    OTHER,        /* 0xeac */
    OTHER,        /* 0xead */
    OTHER,        /* 0xeae */
    OTHER,        /* 0xeaf */
    OTHER,        /* 0xeb0 */
    OTHER,        /* 0xeb1 */
    OTHER,        /* 0xeb2 */
    OTHER,        /* 0xeb3 */
    OTHER,        /* 0xeb4 */
    OTHER,        /* 0xeb5 */
    OTHER,        /* 0xeb6 */
    OTHER,        /* 0xeb7 */
    OTHER,        /* 0xeb8 */
    OTHER,        /* 0xeb9 */
    OTHER,        /* 0xeba */
    OTHER,        /* 0xebb */
    OTHER,        /* 0xebc */
    OTHER,        /* 0xebd */
    OTHER,        /* 0xebe */
    OTHER,        /* 0xebf */
    OTHER,        /* 0xec0 */
    OTHER,        /* 0xec1 */
    OTHER,        /* 0xec2 */
    OTHER,        /* 0xec3 */
    OTHER,        /* 0xec4 */
    OTHER,        /* 0xec5 */
    OTHER,        /* 0xec6 */
    OTHER,        /* 0xec7 */
    OTHER,        /* 0xec8 */
    OTHER,        /* 0xec9 */
    OTHER,        /* 0xeca */
    OTHER,        /* 0xecb */
    OTHER,        /* 0xecc */
    OTHER,        /* 0xecd */
    OTHER,        /* 0xece */
    OTHER,        /* 0xecf */
    OTHER,        /* 0xed0 */
    OTHER,        /* 0xed1 */
    OTHER,        /* 0xed2 */
    OTHER,        /* 0xed3 */
    OTHER,        /* 0xed4 */
    OTHER,        /* 0xed5 */
    OTHER,        /* 0xed6 */
    OTHER,        /* 0xed7 */
    OTHER,        /* 0xed8 */
    OTHER,        /* 0xed9 */
    OTHER,        /* 0xeda */
    OTHER,        /* 0xedb */
    OTHER,        /* 0xedc */
    OTHER,        /* 0xedd */
    OTHER,        /* 0xede */
    OTHER,        /* 0xedf */
    OTHER,        /* 0xee0 */
    OTHER,        /* 0xee1 */
    OTHER,        /* 0xee2 */
    OTHER,        /* 0xee3 */
    OTHER,        /* 0xee4 */
    OTHER,        /* 0xee5 */
    OTHER,        /* 0xee6 */
    OTHER,        /* 0xee7 */
    OTHER,        /* 0xee8 */
    OTHER,        /* 0xee9 */
    OTHER,        /* 0xeea */
    OTHER,        /* 0xeeb */
    OTHER,        /* 0xeec */
    OTHER,        /* 0xeed */
    OTHER,        /* 0xeee */
    OTHER,        /* 0xeef */
    OTHER,        /* 0xef0 */
    OTHER,        /* 0xef1 */
    OTHER,        /* 0xef2 */
    OTHER,        /* 0xef3 */
    OTHER,        /* 0xef4 */
    OTHER,        /* 0xef5 */
    OTHER,        /* 0xef6 */
    OTHER,        /* 0xef7 */
    OTHER,        /* 0xef8 */
    OTHER,        /* 0xef9 */
    OTHER,        /* 0xefa */
    OTHER,        /* 0xefb */
    OTHER,        /* 0xefc */
    OTHER,        /* 0xefd */
    OTHER,        /* 0xefe */
    OTHER,        /* 0xeff */
    OTHER,        /* 0xf00 */
    OTHER,        /* 0xf01 */
    OTHER,        /* 0xf02 */
    OTHER,        /* 0xf03 */
    OTHER,        /* 0xf04 */
    OTHER,        /* 0xf05 */
    OTHER,        /* 0xf06 */
    OTHER,        /* 0xf07 */
    OTHER,        /* 0xf08 */
    OTHER,        /* 0xf09 */
    OTHER,        /* 0xf0a */
    OTHER,        /* 0xf0b */
    OTHER,        /* 0xf0c */
    OTHER,        /* 0xf0d */
    OTHER,        /* 0xf0e */
    OTHER,        /* 0xf0f */
    OTHER,        /* 0xf10 */
    OTHER,        /* 0xf11 */
    OTHER,        /* 0xf12 */
    OTHER,        /* 0xf13 */
    OTHER,        /* 0xf14 */
    OTHER,        /* 0xf15 */
    OTHER,        /* 0xf16 */
    OTHER,        /* 0xf17 */
    OTHER,        /* 0xf18 */
    OTHER,        /* 0xf19 */
    OTHER,        /* 0xf1a */
    OTHER,        /* 0xf1b */
    OTHER,        /* 0xf1c */
    OTHER,        /* 0xf1d */
    OTHER,        /* 0xf1e */
    OTHER,        /* 0xf1f */
    OTHER,        /* 0xf20 */
    OTHER,        /* 0xf21 */
    OTHER,        /* 0xf22 */
    OTHER,        /* 0xf23 */
    OTHER,        /* 0xf24 */
    OTHER,        /* 0xf25 */
    OTHER,        /* 0xf26 */
    OTHER,        /* 0xf27 */
    OTHER,        /* 0xf28 */
    OTHER,        /* 0xf29 */
    OTHER,        /* 0xf2a */
    OTHER,        /* 0xf2b */
    OTHER,        /* 0xf2c */
    OTHER,        /* 0xf2d */
    OTHER,        /* 0xf2e */
    OTHER,        /* 0xf2f */
    OTHER,        /* 0xf30 */
    OTHER,        /* 0xf31 */
    OTHER,        /* 0xf32 */
    OTHER,        /* 0xf33 */
    OTHER,        /* 0xf34 */
    OTHER,        /* 0xf35 */
    OTHER,        /* 0xf36 */
    OTHER,        /* 0xf37 */
    OTHER,        /* 0xf38 */
    OTHER,        /* 0xf39 */
    OTHER,        /* 0xf3a */
    OTHER,        /* 0xf3b */
    OTHER,        /* 0xf3c */
    OTHER,        /* 0xf3d */
    OTHER,        /* 0xf3e */
    OTHER,        /* 0xf3f */
    OTHER,        /* 0xf40 */
    OTHER,        /* 0xf41 */
    OTHER,        /* 0xf42 */
    OTHER,        /* 0xf43 */
    OTHER,        /* 0xf44 */
    OTHER,        /* 0xf45 */
    OTHER,        /* 0xf46 */
    OTHER,        /* 0xf47 */
    OTHER,        /* 0xf48 */
    OTHER,        /* 0xf49 */
    OTHER,        /* 0xf4a */
    OTHER,        /* 0xf4b */
    OTHER,        /* 0xf4c */
    OTHER,        /* 0xf4d */
    OTHER,        /* 0xf4e */
    OTHER,        /* 0xf4f */
    OTHER,        /* 0xf50 */
    OTHER,        /* 0xf51 */
    OTHER,        /* 0xf52 */
    OTHER,        /* 0xf53 */
    OTHER,        /* 0xf54 */
    OTHER,        /* 0xf55 */
    OTHER,        /* 0xf56 */
    OTHER,        /* 0xf57 */
    OTHER,        /* 0xf58 */
    OTHER,        /* 0xf59 */
    OTHER,        /* 0xf5a */
    OTHER,        /* 0xf5b */
    OTHER,        /* 0xf5c */
    OTHER,        /* 0xf5d */
    OTHER,        /* 0xf5e */
    OTHER,        /* 0xf5f */
    OTHER,        /* 0xf60 */
    OTHER,        /* 0xf61 */
    OTHER,        /* 0xf62 */
    OTHER,        /* 0xf63 */
    OTHER,        /* 0xf64 */
    OTHER,        /* 0xf65 */
    OTHER,        /* 0xf66 */
    OTHER,        /* 0xf67 */
    OTHER,        /* 0xf68 */
    OTHER,        /* 0xf69 */
    OTHER,        /* 0xf6a */
    OTHER,        /* 0xf6b */
    OTHER,        /* 0xf6c */
    OTHER,        /* 0xf6d */
    OTHER,        /* 0xf6e */
    OTHER,        /* 0xf6f */
    OTHER,        /* 0xf70 */
    OTHER,        /* 0xf71 */
    OTHER,        /* 0xf72 */
    OTHER,        /* 0xf73 */
    OTHER,        /* 0xf74 */
    OTHER,        /* 0xf75 */
    OTHER,        /* 0xf76 */
    OTHER,        /* 0xf77 */
    OTHER,        /* 0xf78 */
    OTHER,        /* 0xf79 */
    OTHER,        /* 0xf7a */
    OTHER,        /* 0xf7b */
    OTHER,        /* 0xf7c */
    OTHER,        /* 0xf7d */
    OTHER,        /* 0xf7e */
    OTHER,        /* 0xf7f */
    OTHER,        /* 0xf80 */
    OTHER,        /* 0xf81 */
    OTHER,        /* 0xf82 */
    OTHER,        /* 0xf83 */
    OTHER,        /* 0xf84 */
    OTHER,        /* 0xf85 */
    OTHER,        /* 0xf86 */
    OTHER,        /* 0xf87 */
    OTHER,        /* 0xf88 */
    OTHER,        /* 0xf89 */
    OTHER,        /* 0xf8a */
    OTHER,        /* 0xf8b */
    OTHER,        /* 0xf8c */
    OTHER,        /* 0xf8d */
    OTHER,        /* 0xf8e */
    OTHER,        /* 0xf8f */
    OTHER,        /* 0xf90 */
    OTHER,        /* 0xf91 */
    OTHER,        /* 0xf92 */
    OTHER,        /* 0xf93 */
    OTHER,        /* 0xf94 */
    OTHER,        /* 0xf95 */
    OTHER,        /* 0xf96 */
    OTHER,        /* 0xf97 */
    OTHER,        /* 0xf98 */
    OTHER,        /* 0xf99 */
    OTHER,        /* 0xf9a */
    OTHER,        /* 0xf9b */
    OTHER,        /* 0xf9c */
    OTHER,        /* 0xf9d */
    OTHER,        /* 0xf9e */
    OTHER,        /* 0xf9f */
    OTHER,        /* 0xfa0 */
    OTHER,        /* 0xfa1 */
    OTHER,        /* 0xfa2 */
    OTHER,        /* 0xfa3 */
    OTHER,        /* 0xfa4 */
    OTHER,        /* 0xfa5 */
    OTHER,        /* 0xfa6 */
    OTHER,        /* 0xfa7 */
    OTHER,        /* 0xfa8 */
    OTHER,        /* 0xfa9 */
    OTHER,        /* 0xfaa */
    OTHER,        /* 0xfab */
    OTHER,        /* 0xfac */
    OTHER,        /* 0xfad */
    OTHER,        /* 0xfae */
    OTHER,        /* 0xfaf */
    OTHER,        /* 0xfb0 */
    OTHER,        /* 0xfb1 */
    OTHER,        /* 0xfb2 */
    OTHER,        /* 0xfb3 */
    OTHER,        /* 0xfb4 */
    OTHER,        /* 0xfb5 */
    OTHER,        /* 0xfb6 */
    OTHER,        /* 0xfb7 */
    OTHER,        /* 0xfb8 */
    OTHER,        /* 0xfb9 */
    OTHER,        /* 0xfba */
    OTHER,        /* 0xfbb */
    OTHER,        /* 0xfbc */
    OTHER,        /* 0xfbd */
    OTHER,        /* 0xfbe */
    OTHER,        /* 0xfbf */
    OTHER,        /* 0xfc0 */
    OTHER,        /* 0xfc1 */
    OTHER,        /* 0xfc2 */
    OTHER,        /* 0xfc3 */
    OTHER,        /* 0xfc4 */
    OTHER,        /* 0xfc5 */
    OTHER,        /* 0xfc6 */
    OTHER,        /* 0xfc7 */
    OTHER,        /* 0xfc8 */
    OTHER,        /* 0xfc9 */
    OTHER,        /* 0xfca */
    OTHER,        /* 0xfcb */
    OTHER,        /* 0xfcc */
    OTHER,        /* 0xfcd */
    OTHER,        /* 0xfce */
    OTHER,        /* 0xfcf */
    OTHER,        /* 0xfd0 */
    OTHER,        /* 0xfd1 */
    OTHER,        /* 0xfd2 */
    OTHER,        /* 0xfd3 */
    OTHER,        /* 0xfd4 */
    OTHER,        /* 0xfd5 */
    OTHER,        /* 0xfd6 */
    OTHER,        /* 0xfd7 */
    OTHER,        /* 0xfd8 */
    OTHER,        /* 0xfd9 */
    OTHER,        /* 0xfda */
    OTHER,        /* 0xfdb */
    OTHER,        /* 0xfdc */
    OTHER,        /* 0xfdd */
    OTHER,        /* 0xfde */
    OTHER,        /* 0xfdf */
    OTHER,        /* 0xfe0 */
    OTHER,        /* 0xfe1 */
    OTHER,        /* 0xfe2 */
    OTHER,        /* 0xfe3 */
    OTHER,        /* 0xfe4 */
    OTHER,        /* 0xfe5 */
    OTHER,        /* 0xfe6 */
    OTHER,        /* 0xfe7 */
    OTHER,        /* 0xfe8 */
    OTHER,        /* 0xfe9 */
    OTHER,        /* 0xfea */
    OTHER,        /* 0xfeb */
    OTHER,        /* 0xfec */
    OTHER,        /* 0xfed */
    OTHER,        /* 0xfee */
    OTHER,        /* 0xfef */
    OTHER,        /* 0xff0 */
    OTHER,        /* 0xff1 */
    OTHER,        /* 0xff2 */
    OTHER,        /* 0xff3 */
    OTHER,        /* 0xff4 */
    OTHER,        /* 0xff5 */
    OTHER,        /* 0xff6 */
    OTHER,        /* 0xff7 */
    OTHER,        /* 0xff8 */
    OTHER,        /* 0xff9 */
    OTHER,        /* 0xffa */
    OTHER,        /* 0xffb */
    OTHER,        /* 0xffc */
    OTHER,        /* 0xffd */
    OTHER,        /* 0xffe */
    OTHER,        /* 0xfff */
    OTHER,        /* 0x1000 */
    OTHER,        /* 0x1001 */
    OTHER,        /* 0x1002 */
    OTHER,        /* 0x1003 */
    OTHER,        /* 0x1004 */
    OTHER,        /* 0x1005 */
    OTHER,        /* 0x1006 */
    OTHER,        /* 0x1007 */
    OTHER,        /* 0x1008 */
    OTHER,        /* 0x1009 */
    OTHER,        /* 0x100a */
    OTHER,        /* 0x100b */
    OTHER,        /* 0x100c */
    OTHER,        /* 0x100d */
    OTHER,        /* 0x100e */
    OTHER,        /* 0x100f */
    OTHER,        /* 0x1010 */
    OTHER,        /* 0x1011 */
    OTHER,        /* 0x1012 */
    OTHER,        /* 0x1013 */
    OTHER,        /* 0x1014 */
    OTHER,        /* 0x1015 */
    OTHER,        /* 0x1016 */
    OTHER,        /* 0x1017 */
    OTHER,        /* 0x1018 */
    OTHER,        /* 0x1019 */
    OTHER,        /* 0x101a */
    OTHER,        /* 0x101b */
    OTHER,        /* 0x101c */
    OTHER,        /* 0x101d */
    OTHER,        /* 0x101e */
    OTHER,        /* 0x101f */
    OTHER,        /* 0x1020 */
    OTHER,        /* 0x1021 */
    OTHER,        /* 0x1022 */
    OTHER,        /* 0x1023 */
    OTHER,        /* 0x1024 */
    OTHER,        /* 0x1025 */
    OTHER,        /* 0x1026 */
    OTHER,        /* 0x1027 */
    OTHER,        /* 0x1028 */
    OTHER,        /* 0x1029 */
    OTHER,        /* 0x102a */
    OTHER,        /* 0x102b */
    OTHER,        /* 0x102c */
    OTHER,        /* 0x102d */
    OTHER,        /* 0x102e */
    OTHER,        /* 0x102f */
    OTHER,        /* 0x1030 */
    OTHER,        /* 0x1031 */
    OTHER,        /* 0x1032 */
    OTHER,        /* 0x1033 */
    OTHER,        /* 0x1034 */
    OTHER,        /* 0x1035 */
    OTHER,        /* 0x1036 */
    OTHER,        /* 0x1037 */
    OTHER,        /* 0x1038 */
    OTHER,        /* 0x1039 */
    OTHER,        /* 0x103a */
    OTHER,        /* 0x103b */
    OTHER,        /* 0x103c */
    OTHER,        /* 0x103d */
    OTHER,        /* 0x103e */
    OTHER,        /* 0x103f */
    OTHER,        /* 0x1040 */
    OTHER,        /* 0x1041 */
    OTHER,        /* 0x1042 */
    OTHER,        /* 0x1043 */
    OTHER,        /* 0x1044 */
    OTHER,        /* 0x1045 */
    OTHER,        /* 0x1046 */
    OTHER,        /* 0x1047 */
    OTHER,        /* 0x1048 */
    OTHER,        /* 0x1049 */
    OTHER,        /* 0x104a */
    OTHER,        /* 0x104b */
    OTHER,        /* 0x104c */
    OTHER,        /* 0x104d */
    OTHER,        /* 0x104e */
    OTHER,        /* 0x104f */
    OTHER,        /* 0x1050 */
    OTHER,        /* 0x1051 */
    OTHER,        /* 0x1052 */
    OTHER,        /* 0x1053 */
    OTHER,        /* 0x1054 */
    OTHER,        /* 0x1055 */
    OTHER,        /* 0x1056 */
    OTHER,        /* 0x1057 */
    OTHER,        /* 0x1058 */
    OTHER,        /* 0x1059 */
    OTHER,        /* 0x105a */
    OTHER,        /* 0x105b */
    OTHER,        /* 0x105c */
    OTHER,        /* 0x105d */
    OTHER,        /* 0x105e */
    OTHER,        /* 0x105f */
    OTHER,        /* 0x1060 */
    OTHER,        /* 0x1061 */
    OTHER,        /* 0x1062 */
    OTHER,        /* 0x1063 */
    OTHER,        /* 0x1064 */
    OTHER,        /* 0x1065 */
    OTHER,        /* 0x1066 */
    OTHER,        /* 0x1067 */
    OTHER,        /* 0x1068 */
    OTHER,        /* 0x1069 */
    OTHER,        /* 0x106a */
    OTHER,        /* 0x106b */
    OTHER,        /* 0x106c */
    OTHER,        /* 0x106d */
    OTHER,        /* 0x106e */
    OTHER,        /* 0x106f */
    OTHER,        /* 0x1070 */
    OTHER,        /* 0x1071 */
    OTHER,        /* 0x1072 */
    OTHER,        /* 0x1073 */
    OTHER,        /* 0x1074 */
    OTHER,        /* 0x1075 */
    OTHER,        /* 0x1076 */
    OTHER,        /* 0x1077 */
    OTHER,        /* 0x1078 */
    OTHER,        /* 0x1079 */
    OTHER,        /* 0x107a */
    OTHER,        /* 0x107b */
    OTHER,        /* 0x107c */
    OTHER,        /* 0x107d */
    OTHER,        /* 0x107e */
    OTHER,        /* 0x107f */
    OTHER,        /* 0x1080 */
    OTHER,        /* 0x1081 */
    OTHER,        /* 0x1082 */
    OTHER,        /* 0x1083 */
    OTHER,        /* 0x1084 */
    OTHER,        /* 0x1085 */
    OTHER,        /* 0x1086 */
    OTHER,        /* 0x1087 */
    OTHER,        /* 0x1088 */
    OTHER,        /* 0x1089 */
    OTHER,        /* 0x108a */
    OTHER,        /* 0x108b */
    OTHER,        /* 0x108c */
    OTHER,        /* 0x108d */
    OTHER,        /* 0x108e */
    OTHER,        /* 0x108f */
    OTHER,        /* 0x1090 */
    OTHER,        /* 0x1091 */
    OTHER,        /* 0x1092 */
    OTHER,        /* 0x1093 */
    OTHER,        /* 0x1094 */
    OTHER,        /* 0x1095 */
    OTHER,        /* 0x1096 */
    OTHER,        /* 0x1097 */
    OTHER,        /* 0x1098 */
    OTHER,        /* 0x1099 */
    OTHER,        /* 0x109a */
    OTHER,        /* 0x109b */
    OTHER,        /* 0x109c */
    OTHER,        /* 0x109d */
    OTHER,        /* 0x109e */
    OTHER,        /* 0x109f */
    OTHER,        /* 0x10a0 */
    OTHER,        /* 0x10a1 */
    OTHER,        /* 0x10a2 */
    OTHER,        /* 0x10a3 */
    OTHER,        /* 0x10a4 */
    OTHER,        /* 0x10a5 */
    OTHER,        /* 0x10a6 */
    OTHER,        /* 0x10a7 */
    OTHER,        /* 0x10a8 */
    OTHER,        /* 0x10a9 */
    OTHER,        /* 0x10aa */
    OTHER,        /* 0x10ab */
    OTHER,        /* 0x10ac */
    OTHER,        /* 0x10ad */
    OTHER,        /* 0x10ae */
    OTHER,        /* 0x10af */
    OTHER,        /* 0x10b0 */
    OTHER,        /* 0x10b1 */
    OTHER,        /* 0x10b2 */
    OTHER,        /* 0x10b3 */
    OTHER,        /* 0x10b4 */
    OTHER,        /* 0x10b5 */
    OTHER,        /* 0x10b6 */
    OTHER,        /* 0x10b7 */
    OTHER,        /* 0x10b8 */
    OTHER,        /* 0x10b9 */
    OTHER,        /* 0x10ba */
    OTHER,        /* 0x10bb */
    OTHER,        /* 0x10bc */
    OTHER,        /* 0x10bd */
    OTHER,        /* 0x10be */
    OTHER,        /* 0x10bf */
    OTHER,        /* 0x10c0 */
    OTHER,        /* 0x10c1 */
    OTHER,        /* 0x10c2 */
    OTHER,        /* 0x10c3 */
    OTHER,        /* 0x10c4 */
    OTHER,        /* 0x10c5 */
    OTHER,        /* 0x10c6 */
    OTHER,        /* 0x10c7 */
    OTHER,        /* 0x10c8 */
    OTHER,        /* 0x10c9 */
    OTHER,        /* 0x10ca */
    OTHER,        /* 0x10cb */
    OTHER,        /* 0x10cc */
    OTHER,        /* 0x10cd */
    OTHER,        /* 0x10ce */
    OTHER,        /* 0x10cf */
    OTHER,        /* 0x10d0 */
    OTHER,        /* 0x10d1 */
    OTHER,        /* 0x10d2 */
    OTHER,        /* 0x10d3 */
    OTHER,        /* 0x10d4 */
    OTHER,        /* 0x10d5 */
    OTHER,        /* 0x10d6 */
    OTHER,        /* 0x10d7 */
    OTHER,        /* 0x10d8 */
    OTHER,        /* 0x10d9 */
    OTHER,        /* 0x10da */
    OTHER,        /* 0x10db */
    OTHER,        /* 0x10dc */
    OTHER,        /* 0x10dd */
    OTHER,        /* 0x10de */
    OTHER,        /* 0x10df */
    OTHER,        /* 0x10e0 */
    OTHER,        /* 0x10e1 */
    OTHER,        /* 0x10e2 */
    OTHER,        /* 0x10e3 */
    OTHER,        /* 0x10e4 */
    OTHER,        /* 0x10e5 */
    OTHER,        /* 0x10e6 */
    OTHER,        /* 0x10e7 */
    OTHER,        /* 0x10e8 */
    OTHER,        /* 0x10e9 */
    OTHER,        /* 0x10ea */
    OTHER,        /* 0x10eb */
    OTHER,        /* 0x10ec */
    OTHER,        /* 0x10ed */
    OTHER,        /* 0x10ee */
    OTHER,        /* 0x10ef */
    OTHER,        /* 0x10f0 */
    OTHER,        /* 0x10f1 */
    OTHER,        /* 0x10f2 */
    OTHER,        /* 0x10f3 */
    OTHER,        /* 0x10f4 */
    OTHER,        /* 0x10f5 */
    OTHER,        /* 0x10f6 */
    OTHER,        /* 0x10f7 */
    OTHER,        /* 0x10f8 */
    OTHER,        /* 0x10f9 */
    OTHER,        /* 0x10fa */
    OTHER,        /* 0x10fb */
    OTHER,        /* 0x10fc */
    OTHER,        /* 0x10fd */
    OTHER,        /* 0x10fe */
    OTHER,        /* 0x10ff */
    OTHER,        /* 0x1100 */
    OTHER,        /* 0x1101 */
    OTHER,        /* 0x1102 */
    OTHER,        /* 0x1103 */
    OTHER,        /* 0x1104 */
    OTHER,        /* 0x1105 */
    OTHER,        /* 0x1106 */
    OTHER,        /* 0x1107 */
    OTHER,        /* 0x1108 */
    OTHER,        /* 0x1109 */
    OTHER,        /* 0x110a */
    OTHER,        /* 0x110b */
    OTHER,        /* 0x110c */
    OTHER,        /* 0x110d */
    OTHER,        /* 0x110e */
    OTHER,        /* 0x110f */
    OTHER,        /* 0x1110 */
    OTHER,        /* 0x1111 */
    OTHER,        /* 0x1112 */
    OTHER,        /* 0x1113 */
    OTHER,        /* 0x1114 */
    OTHER,        /* 0x1115 */
    OTHER,        /* 0x1116 */
    OTHER,        /* 0x1117 */
    OTHER,        /* 0x1118 */
    OTHER,        /* 0x1119 */
    OTHER,        /* 0x111a */
    OTHER,        /* 0x111b */
    OTHER,        /* 0x111c */
    OTHER,        /* 0x111d */
    OTHER,        /* 0x111e */
    OTHER,        /* 0x111f */
    OTHER,        /* 0x1120 */
    OTHER,        /* 0x1121 */
    OTHER,        /* 0x1122 */
    OTHER,        /* 0x1123 */
    OTHER,        /* 0x1124 */
    OTHER,        /* 0x1125 */
    OTHER,        /* 0x1126 */
    OTHER,        /* 0x1127 */
    OTHER,        /* 0x1128 */
    OTHER,        /* 0x1129 */
    OTHER,        /* 0x112a */
    OTHER,        /* 0x112b */
    OTHER,        /* 0x112c */
    OTHER,        /* 0x112d */
    OTHER,        /* 0x112e */
    OTHER,        /* 0x112f */
    OTHER,        /* 0x1130 */
    OTHER,        /* 0x1131 */
    OTHER,        /* 0x1132 */
    OTHER,        /* 0x1133 */
    OTHER,        /* 0x1134 */
    OTHER,        /* 0x1135 */
    OTHER,        /* 0x1136 */
    OTHER,        /* 0x1137 */
    OTHER,        /* 0x1138 */
    OTHER,        /* 0x1139 */
    OTHER,        /* 0x113a */
    OTHER,        /* 0x113b */
    OTHER,        /* 0x113c */
    OTHER,        /* 0x113d */
    OTHER,        /* 0x113e */
    OTHER,        /* 0x113f */
    OTHER,        /* 0x1140 */
    OTHER,        /* 0x1141 */
    OTHER,        /* 0x1142 */
    OTHER,        /* 0x1143 */
    OTHER,        /* 0x1144 */
    OTHER,        /* 0x1145 */
    OTHER,        /* 0x1146 */
    OTHER,        /* 0x1147 */
    OTHER,        /* 0x1148 */
    OTHER,        /* 0x1149 */
    OTHER,        /* 0x114a */
    OTHER,        /* 0x114b */
    OTHER,        /* 0x114c */
    OTHER,        /* 0x114d */
    OTHER,        /* 0x114e */
    OTHER,        /* 0x114f */
    OTHER,        /* 0x1150 */
    OTHER,        /* 0x1151 */
    OTHER,        /* 0x1152 */
    OTHER,        /* 0x1153 */
    OTHER,        /* 0x1154 */
    OTHER,        /* 0x1155 */
    OTHER,        /* 0x1156 */
    OTHER,        /* 0x1157 */
    OTHER,        /* 0x1158 */
    OTHER,        /* 0x1159 */
    OTHER,        /* 0x115a */
    OTHER,        /* 0x115b */
    OTHER,        /* 0x115c */
    OTHER,        /* 0x115d */
    OTHER,        /* 0x115e */
    OTHER,        /* 0x115f */
    OTHER,        /* 0x1160 */
    OTHER,        /* 0x1161 */
    OTHER,        /* 0x1162 */
    OTHER,        /* 0x1163 */
    OTHER,        /* 0x1164 */
    OTHER,        /* 0x1165 */
    OTHER,        /* 0x1166 */
    OTHER,        /* 0x1167 */
    OTHER,        /* 0x1168 */
    OTHER,        /* 0x1169 */
    OTHER,        /* 0x116a */
    OTHER,        /* 0x116b */
    OTHER,        /* 0x116c */
    OTHER,        /* 0x116d */
    OTHER,        /* 0x116e */
    OTHER,        /* 0x116f */
    OTHER,        /* 0x1170 */
    OTHER,        /* 0x1171 */
    OTHER,        /* 0x1172 */
    OTHER,        /* 0x1173 */
    OTHER,        /* 0x1174 */
    OTHER,        /* 0x1175 */
    OTHER,        /* 0x1176 */
    OTHER,        /* 0x1177 */
    OTHER,        /* 0x1178 */
    OTHER,        /* 0x1179 */
    OTHER,        /* 0x117a */
    OTHER,        /* 0x117b */
    OTHER,        /* 0x117c */
    OTHER,        /* 0x117d */
    OTHER,        /* 0x117e */
    OTHER,        /* 0x117f */
    OTHER,        /* 0x1180 */
    OTHER,        /* 0x1181 */
    OTHER,        /* 0x1182 */
    OTHER,        /* 0x1183 */
    OTHER,        /* 0x1184 */
    OTHER,        /* 0x1185 */
    OTHER,        /* 0x1186 */
    OTHER,        /* 0x1187 */
    OTHER,        /* 0x1188 */
    OTHER,        /* 0x1189 */
    OTHER,        /* 0x118a */
    OTHER,        /* 0x118b */
    OTHER,        /* 0x118c */
    OTHER,        /* 0x118d */
    OTHER,        /* 0x118e */
    OTHER,        /* 0x118f */
    OTHER,        /* 0x1190 */
    OTHER,        /* 0x1191 */
    OTHER,        /* 0x1192 */
    OTHER,        /* 0x1193 */
    OTHER,        /* 0x1194 */
    OTHER,        /* 0x1195 */
    OTHER,        /* 0x1196 */
    OTHER,        /* 0x1197 */
    OTHER,        /* 0x1198 */
    OTHER,        /* 0x1199 */
    OTHER,        /* 0x119a */
    OTHER,        /* 0x119b */
    OTHER,        /* 0x119c */
    OTHER,        /* 0x119d */
    OTHER,        /* 0x119e */
    OTHER,        /* 0x119f */
    OTHER,        /* 0x11a0 */
    OTHER,        /* 0x11a1 */
    OTHER,        /* 0x11a2 */
    OTHER,        /* 0x11a3 */
    OTHER,        /* 0x11a4 */
    OTHER,        /* 0x11a5 */
    OTHER,        /* 0x11a6 */
    OTHER,        /* 0x11a7 */
    OTHER,        /* 0x11a8 */
    OTHER,        /* 0x11a9 */
    OTHER,        /* 0x11aa */
    OTHER,        /* 0x11ab */
    OTHER,        /* 0x11ac */
    OTHER,        /* 0x11ad */
    OTHER,        /* 0x11ae */
    OTHER,        /* 0x11af */
    OTHER,        /* 0x11b0 */
    OTHER,        /* 0x11b1 */
    OTHER,        /* 0x11b2 */
    OTHER,        /* 0x11b3 */
    OTHER,        /* 0x11b4 */
    OTHER,        /* 0x11b5 */
    OTHER,        /* 0x11b6 */
    OTHER,        /* 0x11b7 */
    OTHER,        /* 0x11b8 */
    OTHER,        /* 0x11b9 */
    OTHER,        /* 0x11ba */
    OTHER,        /* 0x11bb */
    OTHER,        /* 0x11bc */
    OTHER,        /* 0x11bd */
    OTHER,        /* 0x11be */
    OTHER,        /* 0x11bf */
    OTHER,        /* 0x11c0 */
    OTHER,        /* 0x11c1 */
    OTHER,        /* 0x11c2 */
    OTHER,        /* 0x11c3 */
    OTHER,        /* 0x11c4 */
    OTHER,        /* 0x11c5 */
    OTHER,        /* 0x11c6 */
    OTHER,        /* 0x11c7 */
    OTHER,        /* 0x11c8 */
    OTHER,        /* 0x11c9 */
    OTHER,        /* 0x11ca */
    OTHER,        /* 0x11cb */
    OTHER,        /* 0x11cc */
    OTHER,        /* 0x11cd */
    OTHER,        /* 0x11ce */
    OTHER,        /* 0x11cf */
    OTHER,        /* 0x11d0 */
    OTHER,        /* 0x11d1 */
    OTHER,        /* 0x11d2 */
    OTHER,        /* 0x11d3 */
    OTHER,        /* 0x11d4 */
    OTHER,        /* 0x11d5 */
    OTHER,        /* 0x11d6 */
    OTHER,        /* 0x11d7 */
    OTHER,        /* 0x11d8 */
    OTHER,        /* 0x11d9 */
    OTHER,        /* 0x11da */
    OTHER,        /* 0x11db */
    OTHER,        /* 0x11dc */
    OTHER,        /* 0x11dd */
    OTHER,        /* 0x11de */
    OTHER,        /* 0x11df */
    OTHER,        /* 0x11e0 */
    OTHER,        /* 0x11e1 */
    OTHER,        /* 0x11e2 */
    OTHER,        /* 0x11e3 */
    OTHER,        /* 0x11e4 */
    OTHER,        /* 0x11e5 */
    OTHER,        /* 0x11e6 */
    OTHER,        /* 0x11e7 */
    OTHER,        /* 0x11e8 */
    OTHER,        /* 0x11e9 */
    OTHER,        /* 0x11ea */
    OTHER,        /* 0x11eb */
    OTHER,        /* 0x11ec */
    OTHER,        /* 0x11ed */
    OTHER,        /* 0x11ee */
    OTHER,        /* 0x11ef */
    OTHER,        /* 0x11f0 */
    OTHER,        /* 0x11f1 */
    OTHER,        /* 0x11f2 */
    OTHER,        /* 0x11f3 */
    OTHER,        /* 0x11f4 */
    OTHER,        /* 0x11f5 */
    OTHER,        /* 0x11f6 */
    OTHER,        /* 0x11f7 */
    OTHER,        /* 0x11f8 */
    OTHER,        /* 0x11f9 */
    OTHER,        /* 0x11fa */
    OTHER,        /* 0x11fb */
    OTHER,        /* 0x11fc */
    OTHER,        /* 0x11fd */
    OTHER,        /* 0x11fe */
    OTHER,        /* 0x11ff */
    OTHER,        /* 0x1200 */
    OTHER,        /* 0x1201 */
    OTHER,        /* 0x1202 */
    OTHER,        /* 0x1203 */
    OTHER,        /* 0x1204 */
    OTHER,        /* 0x1205 */
    OTHER,        /* 0x1206 */
    OTHER,        /* 0x1207 */
    OTHER,        /* 0x1208 */
    OTHER,        /* 0x1209 */
    OTHER,        /* 0x120a */
    OTHER,        /* 0x120b */
    OTHER,        /* 0x120c */
    OTHER,        /* 0x120d */
    OTHER,        /* 0x120e */
    OTHER,        /* 0x120f */
    OTHER,        /* 0x1210 */
    OTHER,        /* 0x1211 */
    OTHER,        /* 0x1212 */
    OTHER,        /* 0x1213 */
    OTHER,        /* 0x1214 */
    OTHER,        /* 0x1215 */
    OTHER,        /* 0x1216 */
    OTHER,        /* 0x1217 */
    OTHER,        /* 0x1218 */
    OTHER,        /* 0x1219 */
    OTHER,        /* 0x121a */
    OTHER,        /* 0x121b */
    OTHER,        /* 0x121c */
    OTHER,        /* 0x121d */
    OTHER,        /* 0x121e */
    OTHER,        /* 0x121f */
    OTHER,        /* 0x1220 */
    OTHER,        /* 0x1221 */
    OTHER,        /* 0x1222 */
    OTHER,        /* 0x1223 */
    OTHER,        /* 0x1224 */
    OTHER,        /* 0x1225 */
    OTHER,        /* 0x1226 */
    OTHER,        /* 0x1227 */
    OTHER,        /* 0x1228 */
    OTHER,        /* 0x1229 */
    OTHER,        /* 0x122a */
    OTHER,        /* 0x122b */
    OTHER,        /* 0x122c */
    OTHER,        /* 0x122d */
    OTHER,        /* 0x122e */
    OTHER,        /* 0x122f */
    OTHER,        /* 0x1230 */
    OTHER,        /* 0x1231 */
    OTHER,        /* 0x1232 */
    OTHER,        /* 0x1233 */
    OTHER,        /* 0x1234 */
    OTHER,        /* 0x1235 */
    OTHER,        /* 0x1236 */
    OTHER,        /* 0x1237 */
    OTHER,        /* 0x1238 */
    OTHER,        /* 0x1239 */
    OTHER,        /* 0x123a */
    OTHER,        /* 0x123b */
    OTHER,        /* 0x123c */
    OTHER,        /* 0x123d */
    OTHER,        /* 0x123e */
    OTHER,        /* 0x123f */
    OTHER,        /* 0x1240 */
    OTHER,        /* 0x1241 */
    OTHER,        /* 0x1242 */
    OTHER,        /* 0x1243 */
    OTHER,        /* 0x1244 */
    OTHER,        /* 0x1245 */
    OTHER,        /* 0x1246 */
    OTHER,        /* 0x1247 */
    OTHER,        /* 0x1248 */
    OTHER,        /* 0x1249 */
    OTHER,        /* 0x124a */
    OTHER,        /* 0x124b */
    OTHER,        /* 0x124c */
    OTHER,        /* 0x124d */
    OTHER,        /* 0x124e */
    OTHER,        /* 0x124f */
    OTHER,        /* 0x1250 */
    OTHER,        /* 0x1251 */
    OTHER,        /* 0x1252 */
    OTHER,        /* 0x1253 */
    OTHER,        /* 0x1254 */
    OTHER,        /* 0x1255 */
    OTHER,        /* 0x1256 */
    OTHER,        /* 0x1257 */
    OTHER,        /* 0x1258 */
    OTHER,        /* 0x1259 */
    OTHER,        /* 0x125a */
    OTHER,        /* 0x125b */
    OTHER,        /* 0x125c */
    OTHER,        /* 0x125d */
    OTHER,        /* 0x125e */
    OTHER,        /* 0x125f */
    OTHER,        /* 0x1260 */
    OTHER,        /* 0x1261 */
    OTHER,        /* 0x1262 */
    OTHER,        /* 0x1263 */
    OTHER,        /* 0x1264 */
    OTHER,        /* 0x1265 */
    OTHER,        /* 0x1266 */
    OTHER,        /* 0x1267 */
    OTHER,        /* 0x1268 */
    OTHER,        /* 0x1269 */
    OTHER,        /* 0x126a */
    OTHER,        /* 0x126b */
    OTHER,        /* 0x126c */
    OTHER,        /* 0x126d */
    OTHER,        /* 0x126e */
    OTHER,        /* 0x126f */
    OTHER,        /* 0x1270 */
    OTHER,        /* 0x1271 */
    OTHER,        /* 0x1272 */
    OTHER,        /* 0x1273 */
    OTHER,        /* 0x1274 */
    OTHER,        /* 0x1275 */
    OTHER,        /* 0x1276 */
    OTHER,        /* 0x1277 */
    OTHER,        /* 0x1278 */
    OTHER,        /* 0x1279 */
    OTHER,        /* 0x127a */
    OTHER,        /* 0x127b */
    OTHER,        /* 0x127c */
    OTHER,        /* 0x127d */
    OTHER,        /* 0x127e */
    OTHER,        /* 0x127f */
    OTHER,        /* 0x1280 */
    OTHER,        /* 0x1281 */
    OTHER,        /* 0x1282 */
    OTHER,        /* 0x1283 */
    OTHER,        /* 0x1284 */
    OTHER,        /* 0x1285 */
    OTHER,        /* 0x1286 */
    OTHER,        /* 0x1287 */
    OTHER,        /* 0x1288 */
    OTHER,        /* 0x1289 */
    OTHER,        /* 0x128a */
    OTHER,        /* 0x128b */
    OTHER,        /* 0x128c */
    OTHER,        /* 0x128d */
    OTHER,        /* 0x128e */
    OTHER,        /* 0x128f */
    OTHER,        /* 0x1290 */
    OTHER,        /* 0x1291 */
    OTHER,        /* 0x1292 */
    OTHER,        /* 0x1293 */
    OTHER,        /* 0x1294 */
    OTHER,        /* 0x1295 */
    OTHER,        /* 0x1296 */
    OTHER,        /* 0x1297 */
    OTHER,        /* 0x1298 */
    OTHER,        /* 0x1299 */
    OTHER,        /* 0x129a */
    OTHER,        /* 0x129b */
    OTHER,        /* 0x129c */
    OTHER,        /* 0x129d */
    OTHER,        /* 0x129e */
    OTHER,        /* 0x129f */
    OTHER,        /* 0x12a0 */
    OTHER,        /* 0x12a1 */
    OTHER,        /* 0x12a2 */
    OTHER,        /* 0x12a3 */
    OTHER,        /* 0x12a4 */
    OTHER,        /* 0x12a5 */
    OTHER,        /* 0x12a6 */
    OTHER,        /* 0x12a7 */
    OTHER,        /* 0x12a8 */
    OTHER,        /* 0x12a9 */
    OTHER,        /* 0x12aa */
    OTHER,        /* 0x12ab */
    OTHER,        /* 0x12ac */
    OTHER,        /* 0x12ad */
    OTHER,        /* 0x12ae */
    OTHER,        /* 0x12af */
    OTHER,        /* 0x12b0 */
    OTHER,        /* 0x12b1 */
    OTHER,        /* 0x12b2 */
    OTHER,        /* 0x12b3 */
    OTHER,        /* 0x12b4 */
    OTHER,        /* 0x12b5 */
    OTHER,        /* 0x12b6 */
    OTHER,        /* 0x12b7 */
    OTHER,        /* 0x12b8 */
    OTHER,        /* 0x12b9 */
    OTHER,        /* 0x12ba */
    OTHER,        /* 0x12bb */
    OTHER,        /* 0x12bc */
    OTHER,        /* 0x12bd */
    OTHER,        /* 0x12be */
    OTHER,        /* 0x12bf */
    OTHER,        /* 0x12c0 */
    OTHER,        /* 0x12c1 */
    OTHER,        /* 0x12c2 */
    OTHER,        /* 0x12c3 */
    OTHER,        /* 0x12c4 */
    OTHER,        /* 0x12c5 */
    OTHER,        /* 0x12c6 */
    OTHER,        /* 0x12c7 */
    OTHER,        /* 0x12c8 */
    OTHER,        /* 0x12c9 */
    OTHER,        /* 0x12ca */
    OTHER,        /* 0x12cb */
    OTHER,        /* 0x12cc */
    OTHER,        /* 0x12cd */
    OTHER,        /* 0x12ce */
    OTHER,        /* 0x12cf */
    OTHER,        /* 0x12d0 */
    OTHER,        /* 0x12d1 */
    OTHER,        /* 0x12d2 */
    OTHER,        /* 0x12d3 */
    OTHER,        /* 0x12d4 */
    OTHER,        /* 0x12d5 */
    OTHER,        /* 0x12d6 */
    OTHER,        /* 0x12d7 */
    OTHER,        /* 0x12d8 */
    OTHER,        /* 0x12d9 */
    OTHER,        /* 0x12da */
    OTHER,        /* 0x12db */
    OTHER,        /* 0x12dc */
    OTHER,        /* 0x12dd */
    OTHER,        /* 0x12de */
    OTHER,        /* 0x12df */
    OTHER,        /* 0x12e0 */
    OTHER,        /* 0x12e1 */
    OTHER,        /* 0x12e2 */
    OTHER,        /* 0x12e3 */
    OTHER,        /* 0x12e4 */
    OTHER,        /* 0x12e5 */
    OTHER,        /* 0x12e6 */
    OTHER,        /* 0x12e7 */
    OTHER,        /* 0x12e8 */
    OTHER,        /* 0x12e9 */
    OTHER,        /* 0x12ea */
    OTHER,        /* 0x12eb */
    OTHER,        /* 0x12ec */
    OTHER,        /* 0x12ed */
    OTHER,        /* 0x12ee */
    OTHER,        /* 0x12ef */
    OTHER,        /* 0x12f0 */
    OTHER,        /* 0x12f1 */
    OTHER,        /* 0x12f2 */
    OTHER,        /* 0x12f3 */
    OTHER,        /* 0x12f4 */
    OTHER,        /* 0x12f5 */
    OTHER,        /* 0x12f6 */
    OTHER,        /* 0x12f7 */
    OTHER,        /* 0x12f8 */
    OTHER,        /* 0x12f9 */
    OTHER,        /* 0x12fa */
    OTHER,        /* 0x12fb */
    OTHER,        /* 0x12fc */
    OTHER,        /* 0x12fd */
    OTHER,        /* 0x12fe */
    OTHER,        /* 0x12ff */
    OTHER,        /* 0x1300 */
    OTHER,        /* 0x1301 */
    OTHER,        /* 0x1302 */
    OTHER,        /* 0x1303 */
    OTHER,        /* 0x1304 */
    OTHER,        /* 0x1305 */
    OTHER,        /* 0x1306 */
    OTHER,        /* 0x1307 */
    OTHER,        /* 0x1308 */
    OTHER,        /* 0x1309 */
    OTHER,        /* 0x130a */
    OTHER,        /* 0x130b */
    OTHER,        /* 0x130c */
    OTHER,        /* 0x130d */
    OTHER,        /* 0x130e */
    OTHER,        /* 0x130f */
    OTHER,        /* 0x1310 */
    OTHER,        /* 0x1311 */
    OTHER,        /* 0x1312 */
    OTHER,        /* 0x1313 */
    OTHER,        /* 0x1314 */
    OTHER,        /* 0x1315 */
    OTHER,        /* 0x1316 */
    OTHER,        /* 0x1317 */
    OTHER,        /* 0x1318 */
    OTHER,        /* 0x1319 */
    OTHER,        /* 0x131a */
    OTHER,        /* 0x131b */
    OTHER,        /* 0x131c */
    OTHER,        /* 0x131d */
    OTHER,        /* 0x131e */
    OTHER,        /* 0x131f */
    OTHER,        /* 0x1320 */
    OTHER,        /* 0x1321 */
    OTHER,        /* 0x1322 */
    OTHER,        /* 0x1323 */
    OTHER,        /* 0x1324 */
    OTHER,        /* 0x1325 */
    OTHER,        /* 0x1326 */
    OTHER,        /* 0x1327 */
    OTHER,        /* 0x1328 */
    OTHER,        /* 0x1329 */
    OTHER,        /* 0x132a */
    OTHER,        /* 0x132b */
    OTHER,        /* 0x132c */
    OTHER,        /* 0x132d */
    OTHER,        /* 0x132e */
    OTHER,        /* 0x132f */
    OTHER,        /* 0x1330 */
    OTHER,        /* 0x1331 */
    OTHER,        /* 0x1332 */
    OTHER,        /* 0x1333 */
    OTHER,        /* 0x1334 */
    OTHER,        /* 0x1335 */
    OTHER,        /* 0x1336 */
    OTHER,        /* 0x1337 */
    OTHER,        /* 0x1338 */
    OTHER,        /* 0x1339 */
    OTHER,        /* 0x133a */
    OTHER,        /* 0x133b */
    OTHER,        /* 0x133c */
    OTHER,        /* 0x133d */
    OTHER,        /* 0x133e */
    OTHER,        /* 0x133f */
    OTHER,        /* 0x1340 */
    OTHER,        /* 0x1341 */
    OTHER,        /* 0x1342 */
    OTHER,        /* 0x1343 */
    OTHER,        /* 0x1344 */
    OTHER,        /* 0x1345 */
    OTHER,        /* 0x1346 */
    OTHER,        /* 0x1347 */
    OTHER,        /* 0x1348 */
    OTHER,        /* 0x1349 */
    OTHER,        /* 0x134a */
    OTHER,        /* 0x134b */
    OTHER,        /* 0x134c */
    OTHER,        /* 0x134d */
    OTHER,        /* 0x134e */
    OTHER,        /* 0x134f */
    OTHER,        /* 0x1350 */
    OTHER,        /* 0x1351 */
    OTHER,        /* 0x1352 */
    OTHER,        /* 0x1353 */
    OTHER,        /* 0x1354 */
    OTHER,        /* 0x1355 */
    OTHER,        /* 0x1356 */
    OTHER,        /* 0x1357 */
    OTHER,        /* 0x1358 */
    OTHER,        /* 0x1359 */
    OTHER,        /* 0x135a */
    OTHER,        /* 0x135b */
    OTHER,        /* 0x135c */
    OTHER,        /* 0x135d */
    OTHER,        /* 0x135e */
    OTHER,        /* 0x135f */
    OTHER,        /* 0x1360 */
    OTHER,        /* 0x1361 */
    OTHER,        /* 0x1362 */
    OTHER,        /* 0x1363 */
    OTHER,        /* 0x1364 */
    OTHER,        /* 0x1365 */
    OTHER,        /* 0x1366 */
    OTHER,        /* 0x1367 */
    OTHER,        /* 0x1368 */
    OTHER,        /* 0x1369 */
    OTHER,        /* 0x136a */
    OTHER,        /* 0x136b */
    OTHER,        /* 0x136c */
    OTHER,        /* 0x136d */
    OTHER,        /* 0x136e */
    OTHER,        /* 0x136f */
    OTHER,        /* 0x1370 */
    OTHER,        /* 0x1371 */
    OTHER,        /* 0x1372 */
    OTHER,        /* 0x1373 */
    OTHER,        /* 0x1374 */
    OTHER,        /* 0x1375 */
    OTHER,        /* 0x1376 */
    OTHER,        /* 0x1377 */
    OTHER,        /* 0x1378 */
    OTHER,        /* 0x1379 */
    OTHER,        /* 0x137a */
    OTHER,        /* 0x137b */
    OTHER,        /* 0x137c */
    OTHER,        /* 0x137d */
    OTHER,        /* 0x137e */
    OTHER,        /* 0x137f */
    OTHER,        /* 0x1380 */
    OTHER,        /* 0x1381 */
    OTHER,        /* 0x1382 */
    OTHER,        /* 0x1383 */
    OTHER,        /* 0x1384 */
    OTHER,        /* 0x1385 */
    OTHER,        /* 0x1386 */
    OTHER,        /* 0x1387 */
    OTHER,        /* 0x1388 */
    OTHER,        /* 0x1389 */
    OTHER,        /* 0x138a */
    OTHER,        /* 0x138b */
    OTHER,        /* 0x138c */
    OTHER,        /* 0x138d */
    OTHER,        /* 0x138e */
    OTHER,        /* 0x138f */
    OTHER,        /* 0x1390 */
    OTHER,        /* 0x1391 */
    OTHER,        /* 0x1392 */
    OTHER,        /* 0x1393 */
    OTHER,        /* 0x1394 */
    OTHER,        /* 0x1395 */
    OTHER,        /* 0x1396 */
    OTHER,        /* 0x1397 */
    OTHER,        /* 0x1398 */
    OTHER,        /* 0x1399 */
    OTHER,        /* 0x139a */
    OTHER,        /* 0x139b */
    OTHER,        /* 0x139c */
    OTHER,        /* 0x139d */
    OTHER,        /* 0x139e */
    OTHER,        /* 0x139f */
    OTHER,        /* 0x13a0 */
    OTHER,        /* 0x13a1 */
    OTHER,        /* 0x13a2 */
    OTHER,        /* 0x13a3 */
    OTHER,        /* 0x13a4 */
    OTHER,        /* 0x13a5 */
    OTHER,        /* 0x13a6 */
    OTHER,        /* 0x13a7 */
    OTHER,        /* 0x13a8 */
    OTHER,        /* 0x13a9 */
    OTHER,        /* 0x13aa */
    OTHER,        /* 0x13ab */
    OTHER,        /* 0x13ac */
    OTHER,        /* 0x13ad */
    OTHER,        /* 0x13ae */
    OTHER,        /* 0x13af */
    OTHER,        /* 0x13b0 */
    OTHER,        /* 0x13b1 */
    OTHER,        /* 0x13b2 */
    OTHER,        /* 0x13b3 */
    OTHER,        /* 0x13b4 */
    OTHER,        /* 0x13b5 */
    OTHER,        /* 0x13b6 */
    OTHER,        /* 0x13b7 */
    OTHER,        /* 0x13b8 */
    OTHER,        /* 0x13b9 */
    OTHER,        /* 0x13ba */
    OTHER,        /* 0x13bb */
    OTHER,        /* 0x13bc */
    OTHER,        /* 0x13bd */
    OTHER,        /* 0x13be */
    OTHER,        /* 0x13bf */
    OTHER,        /* 0x13c0 */
    OTHER,        /* 0x13c1 */
    OTHER,        /* 0x13c2 */
    OTHER,        /* 0x13c3 */
    OTHER,        /* 0x13c4 */
    OTHER,        /* 0x13c5 */
    OTHER,        /* 0x13c6 */
    OTHER,        /* 0x13c7 */
    OTHER,        /* 0x13c8 */
    OTHER,        /* 0x13c9 */
    OTHER,        /* 0x13ca */
    OTHER,        /* 0x13cb */
    OTHER,        /* 0x13cc */
    OTHER,        /* 0x13cd */
    OTHER,        /* 0x13ce */
    OTHER,        /* 0x13cf */
    OTHER,        /* 0x13d0 */
    OTHER,        /* 0x13d1 */
    OTHER,        /* 0x13d2 */
    OTHER,        /* 0x13d3 */
    OTHER,        /* 0x13d4 */
    OTHER,        /* 0x13d5 */
    OTHER,        /* 0x13d6 */
    OTHER,        /* 0x13d7 */
    OTHER,        /* 0x13d8 */
    OTHER,        /* 0x13d9 */
    OTHER,        /* 0x13da */
    OTHER,        /* 0x13db */
    OTHER,        /* 0x13dc */
    OTHER,        /* 0x13dd */
    OTHER,        /* 0x13de */
    OTHER,        /* 0x13df */
    OTHER,        /* 0x13e0 */
    OTHER,        /* 0x13e1 */
    OTHER,        /* 0x13e2 */
    OTHER,        /* 0x13e3 */
    OTHER,        /* 0x13e4 */
    OTHER,        /* 0x13e5 */
    OTHER,        /* 0x13e6 */
    OTHER,        /* 0x13e7 */
    OTHER,        /* 0x13e8 */
    OTHER,        /* 0x13e9 */
    OTHER,        /* 0x13ea */
    OTHER,        /* 0x13eb */
    OTHER,        /* 0x13ec */
    OTHER,        /* 0x13ed */
    OTHER,        /* 0x13ee */
    OTHER,        /* 0x13ef */
    OTHER,        /* 0x13f0 */
    OTHER,        /* 0x13f1 */
    OTHER,        /* 0x13f2 */
    OTHER,        /* 0x13f3 */
    OTHER,        /* 0x13f4 */
    OTHER,        /* 0x13f5 */
    OTHER,        /* 0x13f6 */
    OTHER,        /* 0x13f7 */
    OTHER,        /* 0x13f8 */
    OTHER,        /* 0x13f9 */
    OTHER,        /* 0x13fa */
    OTHER,        /* 0x13fb */
    OTHER,        /* 0x13fc */
    OTHER,        /* 0x13fd */
    OTHER,        /* 0x13fe */
    OTHER,        /* 0x13ff */
    OTHER,        /* 0x1400 */
    OTHER,        /* 0x1401 */
    OTHER,        /* 0x1402 */
    OTHER,        /* 0x1403 */
    OTHER,        /* 0x1404 */
    OTHER,        /* 0x1405 */
    OTHER,        /* 0x1406 */
    OTHER,        /* 0x1407 */
    OTHER,        /* 0x1408 */
    OTHER,        /* 0x1409 */
    OTHER,        /* 0x140a */
    OTHER,        /* 0x140b */
    OTHER,        /* 0x140c */
    OTHER,        /* 0x140d */
    OTHER,        /* 0x140e */
    OTHER,        /* 0x140f */
    OTHER,        /* 0x1410 */
    OTHER,        /* 0x1411 */
    OTHER,        /* 0x1412 */
    OTHER,        /* 0x1413 */
    OTHER,        /* 0x1414 */
    OTHER,        /* 0x1415 */
    OTHER,        /* 0x1416 */
    OTHER,        /* 0x1417 */
    OTHER,        /* 0x1418 */
    OTHER,        /* 0x1419 */
    OTHER,        /* 0x141a */
    OTHER,        /* 0x141b */
    OTHER,        /* 0x141c */
    OTHER,        /* 0x141d */
    OTHER,        /* 0x141e */
    OTHER,        /* 0x141f */
    OTHER,        /* 0x1420 */
    OTHER,        /* 0x1421 */
    OTHER,        /* 0x1422 */
    OTHER,        /* 0x1423 */
    OTHER,        /* 0x1424 */
    OTHER,        /* 0x1425 */
    OTHER,        /* 0x1426 */
    OTHER,        /* 0x1427 */
    OTHER,        /* 0x1428 */
    OTHER,        /* 0x1429 */
    OTHER,        /* 0x142a */
    OTHER,        /* 0x142b */
    OTHER,        /* 0x142c */
    OTHER,        /* 0x142d */
    OTHER,        /* 0x142e */
    OTHER,        /* 0x142f */
    OTHER,        /* 0x1430 */
    OTHER,        /* 0x1431 */
    OTHER,        /* 0x1432 */
    OTHER,        /* 0x1433 */
    OTHER,        /* 0x1434 */
    OTHER,        /* 0x1435 */
    OTHER,        /* 0x1436 */
    OTHER,        /* 0x1437 */
    OTHER,        /* 0x1438 */
    OTHER,        /* 0x1439 */
    OTHER,        /* 0x143a */
    OTHER,        /* 0x143b */
    OTHER,        /* 0x143c */
    OTHER,        /* 0x143d */
    OTHER,        /* 0x143e */
    OTHER,        /* 0x143f */
    OTHER,        /* 0x1440 */
    OTHER,        /* 0x1441 */
    OTHER,        /* 0x1442 */
    OTHER,        /* 0x1443 */
    OTHER,        /* 0x1444 */
    OTHER,        /* 0x1445 */
    OTHER,        /* 0x1446 */
    OTHER,        /* 0x1447 */
    OTHER,        /* 0x1448 */
    OTHER,        /* 0x1449 */
    OTHER,        /* 0x144a */
    OTHER,        /* 0x144b */
    OTHER,        /* 0x144c */
    OTHER,        /* 0x144d */
    OTHER,        /* 0x144e */
    OTHER,        /* 0x144f */
    OTHER,        /* 0x1450 */
    OTHER,        /* 0x1451 */
    OTHER,        /* 0x1452 */
    OTHER,        /* 0x1453 */
    OTHER,        /* 0x1454 */
    OTHER,        /* 0x1455 */
    OTHER,        /* 0x1456 */
    OTHER,        /* 0x1457 */
    OTHER,        /* 0x1458 */
    OTHER,        /* 0x1459 */
    OTHER,        /* 0x145a */
    OTHER,        /* 0x145b */
    OTHER,        /* 0x145c */
    OTHER,        /* 0x145d */
    OTHER,        /* 0x145e */
    OTHER,        /* 0x145f */
    OTHER,        /* 0x1460 */
    OTHER,        /* 0x1461 */
    OTHER,        /* 0x1462 */
    OTHER,        /* 0x1463 */
    OTHER,        /* 0x1464 */
    OTHER,        /* 0x1465 */
    OTHER,        /* 0x1466 */
    OTHER,        /* 0x1467 */
    OTHER,        /* 0x1468 */
    OTHER,        /* 0x1469 */
    OTHER,        /* 0x146a */
    OTHER,        /* 0x146b */
    OTHER,        /* 0x146c */
    OTHER,        /* 0x146d */
    OTHER,        /* 0x146e */
    OTHER,        /* 0x146f */
    OTHER,        /* 0x1470 */
    OTHER,        /* 0x1471 */
    OTHER,        /* 0x1472 */
    OTHER,        /* 0x1473 */
    OTHER,        /* 0x1474 */
    OTHER,        /* 0x1475 */
    OTHER,        /* 0x1476 */
    OTHER,        /* 0x1477 */
    OTHER,        /* 0x1478 */
    OTHER,        /* 0x1479 */
    OTHER,        /* 0x147a */
    OTHER,        /* 0x147b */
    OTHER,        /* 0x147c */
    OTHER,        /* 0x147d */
    OTHER,        /* 0x147e */
    OTHER,        /* 0x147f */
    OTHER,        /* 0x1480 */
    OTHER,        /* 0x1481 */
    OTHER,        /* 0x1482 */
    OTHER,        /* 0x1483 */
    OTHER,        /* 0x1484 */
    OTHER,        /* 0x1485 */
    OTHER,        /* 0x1486 */
    OTHER,        /* 0x1487 */
    OTHER,        /* 0x1488 */
    OTHER,        /* 0x1489 */
    OTHER,        /* 0x148a */
    OTHER,        /* 0x148b */
    OTHER,        /* 0x148c */
    OTHER,        /* 0x148d */
    OTHER,        /* 0x148e */
    OTHER,        /* 0x148f */
    OTHER,        /* 0x1490 */
    OTHER,        /* 0x1491 */
    OTHER,        /* 0x1492 */
    OTHER,        /* 0x1493 */
    OTHER,        /* 0x1494 */
    OTHER,        /* 0x1495 */
    OTHER,        /* 0x1496 */
    OTHER,        /* 0x1497 */
    OTHER,        /* 0x1498 */
    OTHER,        /* 0x1499 */
    OTHER,        /* 0x149a */
    OTHER,        /* 0x149b */
    OTHER,        /* 0x149c */
    OTHER,        /* 0x149d */
    OTHER,        /* 0x149e */
    OTHER,        /* 0x149f */
    OTHER,        /* 0x14a0 */
    OTHER,        /* 0x14a1 */
    OTHER,        /* 0x14a2 */
    OTHER,        /* 0x14a3 */
    OTHER,        /* 0x14a4 */
    OTHER,        /* 0x14a5 */
    OTHER,        /* 0x14a6 */
    OTHER,        /* 0x14a7 */
    OTHER,        /* 0x14a8 */
    OTHER,        /* 0x14a9 */
    OTHER,        /* 0x14aa */
    OTHER,        /* 0x14ab */
    OTHER,        /* 0x14ac */
    OTHER,        /* 0x14ad */
    OTHER,        /* 0x14ae */
    OTHER,        /* 0x14af */
    OTHER,        /* 0x14b0 */
    OTHER,        /* 0x14b1 */
    OTHER,        /* 0x14b2 */
    OTHER,        /* 0x14b3 */
    OTHER,        /* 0x14b4 */
    OTHER,        /* 0x14b5 */
    OTHER,        /* 0x14b6 */
    OTHER,        /* 0x14b7 */
    OTHER,        /* 0x14b8 */
    OTHER,        /* 0x14b9 */
    OTHER,        /* 0x14ba */
    OTHER,        /* 0x14bb */
    OTHER,        /* 0x14bc */
    OTHER,        /* 0x14bd */
    OTHER,        /* 0x14be */
    OTHER,        /* 0x14bf */
    OTHER,        /* 0x14c0 */
    OTHER,        /* 0x14c1 */
    OTHER,        /* 0x14c2 */
    OTHER,        /* 0x14c3 */
    OTHER,        /* 0x14c4 */
    OTHER,        /* 0x14c5 */
    OTHER,        /* 0x14c6 */
    OTHER,        /* 0x14c7 */
    OTHER,        /* 0x14c8 */
    OTHER,        /* 0x14c9 */
    OTHER,        /* 0x14ca */
    OTHER,        /* 0x14cb */
    OTHER,        /* 0x14cc */
    OTHER,        /* 0x14cd */
    OTHER,        /* 0x14ce */
    OTHER,        /* 0x14cf */
    OTHER,        /* 0x14d0 */
    OTHER,        /* 0x14d1 */
    OTHER,        /* 0x14d2 */
    OTHER,        /* 0x14d3 */
    OTHER,        /* 0x14d4 */
    OTHER,        /* 0x14d5 */
    OTHER,        /* 0x14d6 */
    OTHER,        /* 0x14d7 */
    OTHER,        /* 0x14d8 */
    OTHER,        /* 0x14d9 */
    OTHER,        /* 0x14da */
    OTHER,        /* 0x14db */
    OTHER,        /* 0x14dc */
    OTHER,        /* 0x14dd */
    OTHER,        /* 0x14de */
    OTHER,        /* 0x14df */
    OTHER,        /* 0x14e0 */
    OTHER,        /* 0x14e1 */
    OTHER,        /* 0x14e2 */
    OTHER,        /* 0x14e3 */
    OTHER,        /* 0x14e4 */
    OTHER,        /* 0x14e5 */
    OTHER,        /* 0x14e6 */
    OTHER,        /* 0x14e7 */
    OTHER,        /* 0x14e8 */
    OTHER,        /* 0x14e9 */
    OTHER,        /* 0x14ea */
    OTHER,        /* 0x14eb */
    OTHER,        /* 0x14ec */
    OTHER,        /* 0x14ed */
    OTHER,        /* 0x14ee */
    OTHER,        /* 0x14ef */
    OTHER,        /* 0x14f0 */
    OTHER,        /* 0x14f1 */
    OTHER,        /* 0x14f2 */
    OTHER,        /* 0x14f3 */
    OTHER,        /* 0x14f4 */
    OTHER,        /* 0x14f5 */
    OTHER,        /* 0x14f6 */
    OTHER,        /* 0x14f7 */
    OTHER,        /* 0x14f8 */
    OTHER,        /* 0x14f9 */
    OTHER,        /* 0x14fa */
    OTHER,        /* 0x14fb */
    OTHER,        /* 0x14fc */
    OTHER,        /* 0x14fd */
    OTHER,        /* 0x14fe */
    OTHER,        /* 0x14ff */
    OTHER,        /* 0x1500 */
    OTHER,        /* 0x1501 */
    OTHER,        /* 0x1502 */
    OTHER,        /* 0x1503 */
    OTHER,        /* 0x1504 */
    OTHER,        /* 0x1505 */
    OTHER,        /* 0x1506 */
    OTHER,        /* 0x1507 */
    OTHER,        /* 0x1508 */
    OTHER,        /* 0x1509 */
    OTHER,        /* 0x150a */
    OTHER,        /* 0x150b */
    OTHER,        /* 0x150c */
    OTHER,        /* 0x150d */
    OTHER,        /* 0x150e */
    OTHER,        /* 0x150f */
    OTHER,        /* 0x1510 */
    OTHER,        /* 0x1511 */
    OTHER,        /* 0x1512 */
    OTHER,        /* 0x1513 */
    OTHER,        /* 0x1514 */
    OTHER,        /* 0x1515 */
    OTHER,        /* 0x1516 */
    OTHER,        /* 0x1517 */
    OTHER,        /* 0x1518 */
    OTHER,        /* 0x1519 */
    OTHER,        /* 0x151a */
    OTHER,        /* 0x151b */
    OTHER,        /* 0x151c */
    OTHER,        /* 0x151d */
    OTHER,        /* 0x151e */
    OTHER,        /* 0x151f */
    OTHER,        /* 0x1520 */
    OTHER,        /* 0x1521 */
    OTHER,        /* 0x1522 */
    OTHER,        /* 0x1523 */
    OTHER,        /* 0x1524 */
    OTHER,        /* 0x1525 */
    OTHER,        /* 0x1526 */
    OTHER,        /* 0x1527 */
    OTHER,        /* 0x1528 */
    OTHER,        /* 0x1529 */
    OTHER,        /* 0x152a */
    OTHER,        /* 0x152b */
    OTHER,        /* 0x152c */
    OTHER,        /* 0x152d */
    OTHER,        /* 0x152e */
    OTHER,        /* 0x152f */
    OTHER,        /* 0x1530 */
    OTHER,        /* 0x1531 */
    OTHER,        /* 0x1532 */
    OTHER,        /* 0x1533 */
    OTHER,        /* 0x1534 */
    OTHER,        /* 0x1535 */
    OTHER,        /* 0x1536 */
    OTHER,        /* 0x1537 */
    OTHER,        /* 0x1538 */
    OTHER,        /* 0x1539 */
    OTHER,        /* 0x153a */
    OTHER,        /* 0x153b */
    OTHER,        /* 0x153c */
    OTHER,        /* 0x153d */
    OTHER,        /* 0x153e */
    OTHER,        /* 0x153f */
    OTHER,        /* 0x1540 */
    OTHER,        /* 0x1541 */
    OTHER,        /* 0x1542 */
    OTHER,        /* 0x1543 */
    OTHER,        /* 0x1544 */
    OTHER,        /* 0x1545 */
    OTHER,        /* 0x1546 */
    OTHER,        /* 0x1547 */
    OTHER,        /* 0x1548 */
    OTHER,        /* 0x1549 */
    OTHER,        /* 0x154a */
    OTHER,        /* 0x154b */
    OTHER,        /* 0x154c */
    OTHER,        /* 0x154d */
    OTHER,        /* 0x154e */
    OTHER,        /* 0x154f */
    OTHER,        /* 0x1550 */
    OTHER,        /* 0x1551 */
    OTHER,        /* 0x1552 */
    OTHER,        /* 0x1553 */
    OTHER,        /* 0x1554 */
    OTHER,        /* 0x1555 */
    OTHER,        /* 0x1556 */
    OTHER,        /* 0x1557 */
    OTHER,        /* 0x1558 */
    OTHER,        /* 0x1559 */
    OTHER,        /* 0x155a */
    OTHER,        /* 0x155b */
    OTHER,        /* 0x155c */
    OTHER,        /* 0x155d */
    OTHER,        /* 0x155e */
    OTHER,        /* 0x155f */
    OTHER,        /* 0x1560 */
    OTHER,        /* 0x1561 */
    OTHER,        /* 0x1562 */
    OTHER,        /* 0x1563 */
    OTHER,        /* 0x1564 */
    OTHER,        /* 0x1565 */
    OTHER,        /* 0x1566 */
    OTHER,        /* 0x1567 */
    OTHER,        /* 0x1568 */
    OTHER,        /* 0x1569 */
    OTHER,        /* 0x156a */
    OTHER,        /* 0x156b */
    OTHER,        /* 0x156c */
    OTHER,        /* 0x156d */
    OTHER,        /* 0x156e */
    OTHER,        /* 0x156f */
    OTHER,        /* 0x1570 */
    OTHER,        /* 0x1571 */
    OTHER,        /* 0x1572 */
    OTHER,        /* 0x1573 */
    OTHER,        /* 0x1574 */
    OTHER,        /* 0x1575 */
    OTHER,        /* 0x1576 */
    OTHER,        /* 0x1577 */
    OTHER,        /* 0x1578 */
    OTHER,        /* 0x1579 */
    OTHER,        /* 0x157a */
    OTHER,        /* 0x157b */
    OTHER,        /* 0x157c */
    OTHER,        /* 0x157d */
    OTHER,        /* 0x157e */
    OTHER,        /* 0x157f */
    OTHER,        /* 0x1580 */
    OTHER,        /* 0x1581 */
    OTHER,        /* 0x1582 */
    OTHER,        /* 0x1583 */
    OTHER,        /* 0x1584 */
    OTHER,        /* 0x1585 */
    OTHER,        /* 0x1586 */
    OTHER,        /* 0x1587 */
    OTHER,        /* 0x1588 */
    OTHER,        /* 0x1589 */
    OTHER,        /* 0x158a */
    OTHER,        /* 0x158b */
    OTHER,        /* 0x158c */
    OTHER,        /* 0x158d */
    OTHER,        /* 0x158e */
    OTHER,        /* 0x158f */
    OTHER,        /* 0x1590 */
    OTHER,        /* 0x1591 */
    OTHER,        /* 0x1592 */
    OTHER,        /* 0x1593 */
    OTHER,        /* 0x1594 */
    OTHER,        /* 0x1595 */
    OTHER,        /* 0x1596 */
    OTHER,        /* 0x1597 */
    OTHER,        /* 0x1598 */
    OTHER,        /* 0x1599 */
    OTHER,        /* 0x159a */
    OTHER,        /* 0x159b */
    OTHER,        /* 0x159c */
    OTHER,        /* 0x159d */
    OTHER,        /* 0x159e */
    OTHER,        /* 0x159f */
    OTHER,        /* 0x15a0 */
    OTHER,        /* 0x15a1 */
    OTHER,        /* 0x15a2 */
    OTHER,        /* 0x15a3 */
    OTHER,        /* 0x15a4 */
    OTHER,        /* 0x15a5 */
    OTHER,        /* 0x15a6 */
    OTHER,        /* 0x15a7 */
    OTHER,        /* 0x15a8 */
    OTHER,        /* 0x15a9 */
    OTHER,        /* 0x15aa */
    OTHER,        /* 0x15ab */
    OTHER,        /* 0x15ac */
    OTHER,        /* 0x15ad */
    OTHER,        /* 0x15ae */
    OTHER,        /* 0x15af */
    OTHER,        /* 0x15b0 */
    OTHER,        /* 0x15b1 */
    OTHER,        /* 0x15b2 */
    OTHER,        /* 0x15b3 */
    OTHER,        /* 0x15b4 */
    OTHER,        /* 0x15b5 */
    OTHER,        /* 0x15b6 */
    OTHER,        /* 0x15b7 */
    OTHER,        /* 0x15b8 */
    OTHER,        /* 0x15b9 */
    OTHER,        /* 0x15ba */
    OTHER,        /* 0x15bb */
    OTHER,        /* 0x15bc */
    OTHER,        /* 0x15bd */
    OTHER,        /* 0x15be */
    OTHER,        /* 0x15bf */
    OTHER,        /* 0x15c0 */
    OTHER,        /* 0x15c1 */
    OTHER,        /* 0x15c2 */
    OTHER,        /* 0x15c3 */
    OTHER,        /* 0x15c4 */
    OTHER,        /* 0x15c5 */
    OTHER,        /* 0x15c6 */
    OTHER,        /* 0x15c7 */
    OTHER,        /* 0x15c8 */
    OTHER,        /* 0x15c9 */
    OTHER,        /* 0x15ca */
    OTHER,        /* 0x15cb */
    OTHER,        /* 0x15cc */
    OTHER,        /* 0x15cd */
    OTHER,        /* 0x15ce */
    OTHER,        /* 0x15cf */
    OTHER,        /* 0x15d0 */
    OTHER,        /* 0x15d1 */
    OTHER,        /* 0x15d2 */
    OTHER,        /* 0x15d3 */
    OTHER,        /* 0x15d4 */
    OTHER,        /* 0x15d5 */
    OTHER,        /* 0x15d6 */
    OTHER,        /* 0x15d7 */
    OTHER,        /* 0x15d8 */
    OTHER,        /* 0x15d9 */
    OTHER,        /* 0x15da */
    OTHER,        /* 0x15db */
    OTHER,        /* 0x15dc */
    OTHER,        /* 0x15dd */
    OTHER,        /* 0x15de */
    OTHER,        /* 0x15df */
    OTHER,        /* 0x15e0 */
    OTHER,        /* 0x15e1 */
    OTHER,        /* 0x15e2 */
    OTHER,        /* 0x15e3 */
    OTHER,        /* 0x15e4 */
    OTHER,        /* 0x15e5 */
    OTHER,        /* 0x15e6 */
    OTHER,        /* 0x15e7 */
    OTHER,        /* 0x15e8 */
    OTHER,        /* 0x15e9 */
    OTHER,        /* 0x15ea */
    OTHER,        /* 0x15eb */
    OTHER,        /* 0x15ec */
    OTHER,        /* 0x15ed */
    OTHER,        /* 0x15ee */
    OTHER,        /* 0x15ef */
    OTHER,        /* 0x15f0 */
    OTHER,        /* 0x15f1 */
    OTHER,        /* 0x15f2 */
    OTHER,        /* 0x15f3 */
    OTHER,        /* 0x15f4 */
    OTHER,        /* 0x15f5 */
    OTHER,        /* 0x15f6 */
    OTHER,        /* 0x15f7 */
    OTHER,        /* 0x15f8 */
    OTHER,        /* 0x15f9 */
    OTHER,        /* 0x15fa */
    OTHER,        /* 0x15fb */
    OTHER,        /* 0x15fc */
    OTHER,        /* 0x15fd */
    OTHER,        /* 0x15fe */
    OTHER,        /* 0x15ff */
    OTHER,        /* 0x1600 */
    OTHER,        /* 0x1601 */
    OTHER,        /* 0x1602 */
    OTHER,        /* 0x1603 */
    OTHER,        /* 0x1604 */
    OTHER,        /* 0x1605 */
    OTHER,        /* 0x1606 */
    OTHER,        /* 0x1607 */
    OTHER,        /* 0x1608 */
    OTHER,        /* 0x1609 */
    OTHER,        /* 0x160a */
    OTHER,        /* 0x160b */
    OTHER,        /* 0x160c */
    OTHER,        /* 0x160d */
    OTHER,        /* 0x160e */
    OTHER,        /* 0x160f */
    OTHER,        /* 0x1610 */
    OTHER,        /* 0x1611 */
    OTHER,        /* 0x1612 */
    OTHER,        /* 0x1613 */
    OTHER,        /* 0x1614 */
    OTHER,        /* 0x1615 */
    OTHER,        /* 0x1616 */
    OTHER,        /* 0x1617 */
    OTHER,        /* 0x1618 */
    OTHER,        /* 0x1619 */
    OTHER,        /* 0x161a */
    OTHER,        /* 0x161b */
    OTHER,        /* 0x161c */
    OTHER,        /* 0x161d */
    OTHER,        /* 0x161e */
    OTHER,        /* 0x161f */
    OTHER,        /* 0x1620 */
    OTHER,        /* 0x1621 */
    OTHER,        /* 0x1622 */
    OTHER,        /* 0x1623 */
    OTHER,        /* 0x1624 */
    OTHER,        /* 0x1625 */
    OTHER,        /* 0x1626 */
    OTHER,        /* 0x1627 */
    OTHER,        /* 0x1628 */
    OTHER,        /* 0x1629 */
    OTHER,        /* 0x162a */
    OTHER,        /* 0x162b */
    OTHER,        /* 0x162c */
    OTHER,        /* 0x162d */
    OTHER,        /* 0x162e */
    OTHER,        /* 0x162f */
    OTHER,        /* 0x1630 */
    OTHER,        /* 0x1631 */
    OTHER,        /* 0x1632 */
    OTHER,        /* 0x1633 */
    OTHER,        /* 0x1634 */
    OTHER,        /* 0x1635 */
    OTHER,        /* 0x1636 */
    OTHER,        /* 0x1637 */
    OTHER,        /* 0x1638 */
    OTHER,        /* 0x1639 */
    OTHER,        /* 0x163a */
    OTHER,        /* 0x163b */
    OTHER,        /* 0x163c */
    OTHER,        /* 0x163d */
    OTHER,        /* 0x163e */
    OTHER,        /* 0x163f */
    OTHER,        /* 0x1640 */
    OTHER,        /* 0x1641 */
    OTHER,        /* 0x1642 */
    OTHER,        /* 0x1643 */
    OTHER,        /* 0x1644 */
    OTHER,        /* 0x1645 */
    OTHER,        /* 0x1646 */
    OTHER,        /* 0x1647 */
    OTHER,        /* 0x1648 */
    OTHER,        /* 0x1649 */
    OTHER,        /* 0x164a */
    OTHER,        /* 0x164b */
    OTHER,        /* 0x164c */
    OTHER,        /* 0x164d */
    OTHER,        /* 0x164e */
    OTHER,        /* 0x164f */
    OTHER,        /* 0x1650 */
    OTHER,        /* 0x1651 */
    OTHER,        /* 0x1652 */
    OTHER,        /* 0x1653 */
    OTHER,        /* 0x1654 */
    OTHER,        /* 0x1655 */
    OTHER,        /* 0x1656 */
    OTHER,        /* 0x1657 */
    OTHER,        /* 0x1658 */
    OTHER,        /* 0x1659 */
    OTHER,        /* 0x165a */
    OTHER,        /* 0x165b */
    OTHER,        /* 0x165c */
    OTHER,        /* 0x165d */
    OTHER,        /* 0x165e */
    OTHER,        /* 0x165f */
    OTHER,        /* 0x1660 */
    OTHER,        /* 0x1661 */
    OTHER,        /* 0x1662 */
    OTHER,        /* 0x1663 */
    OTHER,        /* 0x1664 */
    OTHER,        /* 0x1665 */
    OTHER,        /* 0x1666 */
    OTHER,        /* 0x1667 */
    OTHER,        /* 0x1668 */
    OTHER,        /* 0x1669 */
    OTHER,        /* 0x166a */
    OTHER,        /* 0x166b */
    OTHER,        /* 0x166c */
    OTHER,        /* 0x166d */
    OTHER,        /* 0x166e */
    OTHER,        /* 0x166f */
    OTHER,        /* 0x1670 */
    OTHER,        /* 0x1671 */
    OTHER,        /* 0x1672 */
    OTHER,        /* 0x1673 */
    OTHER,        /* 0x1674 */
    OTHER,        /* 0x1675 */
    OTHER,        /* 0x1676 */
    OTHER,        /* 0x1677 */
    OTHER,        /* 0x1678 */
    OTHER,        /* 0x1679 */
    OTHER,        /* 0x167a */
    OTHER,        /* 0x167b */
    OTHER,        /* 0x167c */
    OTHER,        /* 0x167d */
    OTHER,        /* 0x167e */
    OTHER,        /* 0x167f */
    OTHER,        /* 0x1680 */
    OTHER,        /* 0x1681 */
    OTHER,        /* 0x1682 */
    OTHER,        /* 0x1683 */
    OTHER,        /* 0x1684 */
    OTHER,        /* 0x1685 */
    OTHER,        /* 0x1686 */
    OTHER,        /* 0x1687 */
    OTHER,        /* 0x1688 */
    OTHER,        /* 0x1689 */
    OTHER,        /* 0x168a */
    OTHER,        /* 0x168b */
    OTHER,        /* 0x168c */
    OTHER,        /* 0x168d */
    OTHER,        /* 0x168e */
    OTHER,        /* 0x168f */
    OTHER,        /* 0x1690 */
    OTHER,        /* 0x1691 */
    OTHER,        /* 0x1692 */
    OTHER,        /* 0x1693 */
    OTHER,        /* 0x1694 */
    OTHER,        /* 0x1695 */
    OTHER,        /* 0x1696 */
    OTHER,        /* 0x1697 */
    OTHER,        /* 0x1698 */
    OTHER,        /* 0x1699 */
    OTHER,        /* 0x169a */
    OTHER,        /* 0x169b */
    OTHER,        /* 0x169c */
    OTHER,        /* 0x169d */
    OTHER,        /* 0x169e */
    OTHER,        /* 0x169f */
    OTHER,        /* 0x16a0 */
    OTHER,        /* 0x16a1 */
    OTHER,        /* 0x16a2 */
    OTHER,        /* 0x16a3 */
    OTHER,        /* 0x16a4 */
    OTHER,        /* 0x16a5 */
    OTHER,        /* 0x16a6 */
    OTHER,        /* 0x16a7 */
    OTHER,        /* 0x16a8 */
    OTHER,        /* 0x16a9 */
    OTHER,        /* 0x16aa */
    OTHER,        /* 0x16ab */
    OTHER,        /* 0x16ac */
    OTHER,        /* 0x16ad */
    OTHER,        /* 0x16ae */
    OTHER,        /* 0x16af */
    OTHER,        /* 0x16b0 */
    OTHER,        /* 0x16b1 */
    OTHER,        /* 0x16b2 */
    OTHER,        /* 0x16b3 */
    OTHER,        /* 0x16b4 */
    OTHER,        /* 0x16b5 */
    OTHER,        /* 0x16b6 */
    OTHER,        /* 0x16b7 */
    OTHER,        /* 0x16b8 */
    OTHER,        /* 0x16b9 */
    OTHER,        /* 0x16ba */
    OTHER,        /* 0x16bb */
    OTHER,        /* 0x16bc */
    OTHER,        /* 0x16bd */
    OTHER,        /* 0x16be */
    OTHER,        /* 0x16bf */
    OTHER,        /* 0x16c0 */
    OTHER,        /* 0x16c1 */
    OTHER,        /* 0x16c2 */
    OTHER,        /* 0x16c3 */
    OTHER,        /* 0x16c4 */
    OTHER,        /* 0x16c5 */
    OTHER,        /* 0x16c6 */
    OTHER,        /* 0x16c7 */
    OTHER,        /* 0x16c8 */
    OTHER,        /* 0x16c9 */
    OTHER,        /* 0x16ca */
    OTHER,        /* 0x16cb */
    OTHER,        /* 0x16cc */
    OTHER,        /* 0x16cd */
    OTHER,        /* 0x16ce */
    OTHER,        /* 0x16cf */
    OTHER,        /* 0x16d0 */
    OTHER,        /* 0x16d1 */
    OTHER,        /* 0x16d2 */
    OTHER,        /* 0x16d3 */
    OTHER,        /* 0x16d4 */
    OTHER,        /* 0x16d5 */
    OTHER,        /* 0x16d6 */
    OTHER,        /* 0x16d7 */
    OTHER,        /* 0x16d8 */
    OTHER,        /* 0x16d9 */
    OTHER,        /* 0x16da */
    OTHER,        /* 0x16db */
    OTHER,        /* 0x16dc */
    OTHER,        /* 0x16dd */
    OTHER,        /* 0x16de */
    OTHER,        /* 0x16df */
    OTHER,        /* 0x16e0 */
    OTHER,        /* 0x16e1 */
    OTHER,        /* 0x16e2 */
    OTHER,        /* 0x16e3 */
    OTHER,        /* 0x16e4 */
    OTHER,        /* 0x16e5 */
    OTHER,        /* 0x16e6 */
    OTHER,        /* 0x16e7 */
    OTHER,        /* 0x16e8 */
    OTHER,        /* 0x16e9 */
    OTHER,        /* 0x16ea */
    OTHER,        /* 0x16eb */
    OTHER,        /* 0x16ec */
    OTHER,        /* 0x16ed */
    OTHER,        /* 0x16ee */
    OTHER,        /* 0x16ef */
    OTHER,        /* 0x16f0 */
    OTHER,        /* 0x16f1 */
    OTHER,        /* 0x16f2 */
    OTHER,        /* 0x16f3 */
    OTHER,        /* 0x16f4 */
    OTHER,        /* 0x16f5 */
    OTHER,        /* 0x16f6 */
    OTHER,        /* 0x16f7 */
    OTHER,        /* 0x16f8 */
    OTHER,        /* 0x16f9 */
    OTHER,        /* 0x16fa */
    OTHER,        /* 0x16fb */
    OTHER,        /* 0x16fc */
    OTHER,        /* 0x16fd */
    OTHER,        /* 0x16fe */
    OTHER,        /* 0x16ff */
    OTHER,        /* 0x1700 */
    OTHER,        /* 0x1701 */
    OTHER,        /* 0x1702 */
    OTHER,        /* 0x1703 */
    OTHER,        /* 0x1704 */
    OTHER,        /* 0x1705 */
    OTHER,        /* 0x1706 */
    OTHER,        /* 0x1707 */
    OTHER,        /* 0x1708 */
    OTHER,        /* 0x1709 */
    OTHER,        /* 0x170a */
    OTHER,        /* 0x170b */
    OTHER,        /* 0x170c */
    OTHER,        /* 0x170d */
    OTHER,        /* 0x170e */
    OTHER,        /* 0x170f */
    OTHER,        /* 0x1710 */
    OTHER,        /* 0x1711 */
    OTHER,        /* 0x1712 */
    OTHER,        /* 0x1713 */
    OTHER,        /* 0x1714 */
    OTHER,        /* 0x1715 */
    OTHER,        /* 0x1716 */
    OTHER,        /* 0x1717 */
    OTHER,        /* 0x1718 */
    OTHER,        /* 0x1719 */
    OTHER,        /* 0x171a */
    OTHER,        /* 0x171b */
    OTHER,        /* 0x171c */
    OTHER,        /* 0x171d */
    OTHER,        /* 0x171e */
    OTHER,        /* 0x171f */
    OTHER,        /* 0x1720 */
    OTHER,        /* 0x1721 */
    OTHER,        /* 0x1722 */
    OTHER,        /* 0x1723 */
    OTHER,        /* 0x1724 */
    OTHER,        /* 0x1725 */
    OTHER,        /* 0x1726 */
    OTHER,        /* 0x1727 */
    OTHER,        /* 0x1728 */
    OTHER,        /* 0x1729 */
    OTHER,        /* 0x172a */
    OTHER,        /* 0x172b */
    OTHER,        /* 0x172c */
    OTHER,        /* 0x172d */
    OTHER,        /* 0x172e */
    OTHER,        /* 0x172f */
    OTHER,        /* 0x1730 */
    OTHER,        /* 0x1731 */
    OTHER,        /* 0x1732 */
    OTHER,        /* 0x1733 */
    OTHER,        /* 0x1734 */
    OTHER,        /* 0x1735 */
    OTHER,        /* 0x1736 */
    OTHER,        /* 0x1737 */
    OTHER,        /* 0x1738 */
    OTHER,        /* 0x1739 */
    OTHER,        /* 0x173a */
    OTHER,        /* 0x173b */
    OTHER,        /* 0x173c */
    OTHER,        /* 0x173d */
    OTHER,        /* 0x173e */
    OTHER,        /* 0x173f */
    OTHER,        /* 0x1740 */
    OTHER,        /* 0x1741 */
    OTHER,        /* 0x1742 */
    OTHER,        /* 0x1743 */
    OTHER,        /* 0x1744 */
    OTHER,        /* 0x1745 */
    OTHER,        /* 0x1746 */
    OTHER,        /* 0x1747 */
    OTHER,        /* 0x1748 */
    OTHER,        /* 0x1749 */
    OTHER,        /* 0x174a */
    OTHER,        /* 0x174b */
    OTHER,        /* 0x174c */
    OTHER,        /* 0x174d */
    OTHER,        /* 0x174e */
    OTHER,        /* 0x174f */
    OTHER,        /* 0x1750 */
    OTHER,        /* 0x1751 */
    OTHER,        /* 0x1752 */
    OTHER,        /* 0x1753 */
    OTHER,        /* 0x1754 */
    OTHER,        /* 0x1755 */
    OTHER,        /* 0x1756 */
    OTHER,        /* 0x1757 */
    OTHER,        /* 0x1758 */
    OTHER,        /* 0x1759 */
    OTHER,        /* 0x175a */
    OTHER,        /* 0x175b */
    OTHER,        /* 0x175c */
    OTHER,        /* 0x175d */
    OTHER,        /* 0x175e */
    OTHER,        /* 0x175f */
    OTHER,        /* 0x1760 */
    OTHER,        /* 0x1761 */
    OTHER,        /* 0x1762 */
    OTHER,        /* 0x1763 */
    OTHER,        /* 0x1764 */
    OTHER,        /* 0x1765 */
    OTHER,        /* 0x1766 */
    OTHER,        /* 0x1767 */
    OTHER,        /* 0x1768 */
    OTHER,        /* 0x1769 */
    OTHER,        /* 0x176a */
    OTHER,        /* 0x176b */
    OTHER,        /* 0x176c */
    OTHER,        /* 0x176d */
    OTHER,        /* 0x176e */
    OTHER,        /* 0x176f */
    OTHER,        /* 0x1770 */
    OTHER,        /* 0x1771 */
    OTHER,        /* 0x1772 */
    OTHER,        /* 0x1773 */
    OTHER,        /* 0x1774 */
    OTHER,        /* 0x1775 */
    OTHER,        /* 0x1776 */
    OTHER,        /* 0x1777 */
    OTHER,        /* 0x1778 */
    OTHER,        /* 0x1779 */
    OTHER,        /* 0x177a */
    OTHER,        /* 0x177b */
    OTHER,        /* 0x177c */
    OTHER,        /* 0x177d */
    OTHER,        /* 0x177e */
    OTHER,        /* 0x177f */
    OTHER,        /* 0x1780 */
    OTHER,        /* 0x1781 */
    OTHER,        /* 0x1782 */
    OTHER,        /* 0x1783 */
    OTHER,        /* 0x1784 */
    OTHER,        /* 0x1785 */
    OTHER,        /* 0x1786 */
    OTHER,        /* 0x1787 */
    OTHER,        /* 0x1788 */
    OTHER,        /* 0x1789 */
    OTHER,        /* 0x178a */
    OTHER,        /* 0x178b */
    OTHER,        /* 0x178c */
    OTHER,        /* 0x178d */
    OTHER,        /* 0x178e */
    OTHER,        /* 0x178f */
    OTHER,        /* 0x1790 */
    OTHER,        /* 0x1791 */
    OTHER,        /* 0x1792 */
    OTHER,        /* 0x1793 */
    OTHER,        /* 0x1794 */
    OTHER,        /* 0x1795 */
    OTHER,        /* 0x1796 */
    OTHER,        /* 0x1797 */
    OTHER,        /* 0x1798 */
    OTHER,        /* 0x1799 */
    OTHER,        /* 0x179a */
    OTHER,        /* 0x179b */
    OTHER,        /* 0x179c */
    OTHER,        /* 0x179d */
    OTHER,        /* 0x179e */
    OTHER,        /* 0x179f */
    OTHER,        /* 0x17a0 */
    OTHER,        /* 0x17a1 */
    OTHER,        /* 0x17a2 */
    OTHER,        /* 0x17a3 */
    OTHER,        /* 0x17a4 */
    OTHER,        /* 0x17a5 */
    OTHER,        /* 0x17a6 */
    OTHER,        /* 0x17a7 */
    OTHER,        /* 0x17a8 */
    OTHER,        /* 0x17a9 */
    OTHER,        /* 0x17aa */
    OTHER,        /* 0x17ab */
    OTHER,        /* 0x17ac */
    OTHER,        /* 0x17ad */
    OTHER,        /* 0x17ae */
    OTHER,        /* 0x17af */
    OTHER,        /* 0x17b0 */
    OTHER,        /* 0x17b1 */
    OTHER,        /* 0x17b2 */
    OTHER,        /* 0x17b3 */
    OTHER,        /* 0x17b4 */
    OTHER,        /* 0x17b5 */
    OTHER,        /* 0x17b6 */
    OTHER,        /* 0x17b7 */
    OTHER,        /* 0x17b8 */
    OTHER,        /* 0x17b9 */
    OTHER,        /* 0x17ba */
    OTHER,        /* 0x17bb */
    OTHER,        /* 0x17bc */
    OTHER,        /* 0x17bd */
    OTHER,        /* 0x17be */
    OTHER,        /* 0x17bf */
    OTHER,        /* 0x17c0 */
    OTHER,        /* 0x17c1 */
    OTHER,        /* 0x17c2 */
    OTHER,        /* 0x17c3 */
    OTHER,        /* 0x17c4 */
    OTHER,        /* 0x17c5 */
    OTHER,        /* 0x17c6 */
    OTHER,        /* 0x17c7 */
    OTHER,        /* 0x17c8 */
    OTHER,        /* 0x17c9 */
    OTHER,        /* 0x17ca */
    OTHER,        /* 0x17cb */
    OTHER,        /* 0x17cc */
    OTHER,        /* 0x17cd */
    OTHER,        /* 0x17ce */
    OTHER,        /* 0x17cf */
    OTHER,        /* 0x17d0 */
    OTHER,        /* 0x17d1 */
    OTHER,        /* 0x17d2 */
    OTHER,        /* 0x17d3 */
    OTHER,        /* 0x17d4 */
    OTHER,        /* 0x17d5 */
    OTHER,        /* 0x17d6 */
    OTHER,        /* 0x17d7 */
    OTHER,        /* 0x17d8 */
    OTHER,        /* 0x17d9 */
    OTHER,        /* 0x17da */
    OTHER,        /* 0x17db */
    OTHER,        /* 0x17dc */
    OTHER,        /* 0x17dd */
    OTHER,        /* 0x17de */
    OTHER,        /* 0x17df */
    OTHER,        /* 0x17e0 */
    OTHER,        /* 0x17e1 */
    OTHER,        /* 0x17e2 */
    OTHER,        /* 0x17e3 */
    OTHER,        /* 0x17e4 */
    OTHER,        /* 0x17e5 */
    OTHER,        /* 0x17e6 */
    OTHER,        /* 0x17e7 */
    OTHER,        /* 0x17e8 */
    OTHER,        /* 0x17e9 */
    OTHER,        /* 0x17ea */
    OTHER,        /* 0x17eb */
    OTHER,        /* 0x17ec */
    OTHER,        /* 0x17ed */
    OTHER,        /* 0x17ee */
    OTHER,        /* 0x17ef */
    OTHER,        /* 0x17f0 */
    OTHER,        /* 0x17f1 */
    OTHER,        /* 0x17f2 */
    OTHER,        /* 0x17f3 */
    OTHER,        /* 0x17f4 */
    OTHER,        /* 0x17f5 */
    OTHER,        /* 0x17f6 */
    OTHER,        /* 0x17f7 */
    OTHER,        /* 0x17f8 */
    OTHER,        /* 0x17f9 */
    OTHER,        /* 0x17fa */
    OTHER,        /* 0x17fb */
    OTHER,        /* 0x17fc */
    OTHER,        /* 0x17fd */
    OTHER,        /* 0x17fe */
    OTHER,        /* 0x17ff */
    OTHER,        /* 0x1800 */
    OTHER,        /* 0x1801 */
    OTHER,        /* 0x1802 */
    OTHER,        /* 0x1803 */
    OTHER,        /* 0x1804 */
    OTHER,        /* 0x1805 */
    OTHER,        /* 0x1806 */
    OTHER,        /* 0x1807 */
    OTHER,        /* 0x1808 */
    OTHER,        /* 0x1809 */
    OTHER,        /* 0x180a */
    OTHER,        /* 0x180b */
    OTHER,        /* 0x180c */
    OTHER,        /* 0x180d */
    OTHER,        /* 0x180e */
    OTHER,        /* 0x180f */
    OTHER,        /* 0x1810 */
    OTHER,        /* 0x1811 */
    OTHER,        /* 0x1812 */
    OTHER,        /* 0x1813 */
    OTHER,        /* 0x1814 */
    OTHER,        /* 0x1815 */
    OTHER,        /* 0x1816 */
    OTHER,        /* 0x1817 */
    OTHER,        /* 0x1818 */
    OTHER,        /* 0x1819 */
    OTHER,        /* 0x181a */
    OTHER,        /* 0x181b */
    OTHER,        /* 0x181c */
    OTHER,        /* 0x181d */
    OTHER,        /* 0x181e */
    OTHER,        /* 0x181f */
    OTHER,        /* 0x1820 */
    OTHER,        /* 0x1821 */
    OTHER,        /* 0x1822 */
    OTHER,        /* 0x1823 */
    OTHER,        /* 0x1824 */
    OTHER,        /* 0x1825 */
    OTHER,        /* 0x1826 */
    OTHER,        /* 0x1827 */
    OTHER,        /* 0x1828 */
    OTHER,        /* 0x1829 */
    OTHER,        /* 0x182a */
    OTHER,        /* 0x182b */
    OTHER,        /* 0x182c */
    OTHER,        /* 0x182d */
    OTHER,        /* 0x182e */
    OTHER,        /* 0x182f */
    OTHER,        /* 0x1830 */
    OTHER,        /* 0x1831 */
    OTHER,        /* 0x1832 */
    OTHER,        /* 0x1833 */
    OTHER,        /* 0x1834 */
    OTHER,        /* 0x1835 */
    OTHER,        /* 0x1836 */
    OTHER,        /* 0x1837 */
    OTHER,        /* 0x1838 */
    OTHER,        /* 0x1839 */
    OTHER,        /* 0x183a */
    OTHER,        /* 0x183b */
    OTHER,        /* 0x183c */
    OTHER,        /* 0x183d */
    OTHER,        /* 0x183e */
    OTHER,        /* 0x183f */
    OTHER,        /* 0x1840 */
    OTHER,        /* 0x1841 */
    OTHER,        /* 0x1842 */
    OTHER,        /* 0x1843 */
    OTHER,        /* 0x1844 */
    OTHER,        /* 0x1845 */
    OTHER,        /* 0x1846 */
    OTHER,        /* 0x1847 */
    OTHER,        /* 0x1848 */
    OTHER,        /* 0x1849 */
    OTHER,        /* 0x184a */
    OTHER,        /* 0x184b */
    OTHER,        /* 0x184c */
    OTHER,        /* 0x184d */
    OTHER,        /* 0x184e */
    OTHER,        /* 0x184f */
    OTHER,        /* 0x1850 */
    OTHER,        /* 0x1851 */
    OTHER,        /* 0x1852 */
    OTHER,        /* 0x1853 */
    OTHER,        /* 0x1854 */
    OTHER,        /* 0x1855 */
    OTHER,        /* 0x1856 */
    OTHER,        /* 0x1857 */
    OTHER,        /* 0x1858 */
    OTHER,        /* 0x1859 */
    OTHER,        /* 0x185a */
    OTHER,        /* 0x185b */
    OTHER,        /* 0x185c */
    OTHER,        /* 0x185d */
    OTHER,        /* 0x185e */
    OTHER,        /* 0x185f */
    OTHER,        /* 0x1860 */
    OTHER,        /* 0x1861 */
    OTHER,        /* 0x1862 */
    OTHER,        /* 0x1863 */
    OTHER,        /* 0x1864 */
    OTHER,        /* 0x1865 */
    OTHER,        /* 0x1866 */
    OTHER,        /* 0x1867 */
    OTHER,        /* 0x1868 */
    OTHER,        /* 0x1869 */
    OTHER,        /* 0x186a */
    OTHER,        /* 0x186b */
    OTHER,        /* 0x186c */
    OTHER,        /* 0x186d */
    OTHER,        /* 0x186e */
    OTHER,        /* 0x186f */
    OTHER,        /* 0x1870 */
    OTHER,        /* 0x1871 */
    OTHER,        /* 0x1872 */
    OTHER,        /* 0x1873 */
    OTHER,        /* 0x1874 */
    OTHER,        /* 0x1875 */
    OTHER,        /* 0x1876 */
    OTHER,        /* 0x1877 */
    OTHER,        /* 0x1878 */
    OTHER,        /* 0x1879 */
    OTHER,        /* 0x187a */
    OTHER,        /* 0x187b */
    OTHER,        /* 0x187c */
    OTHER,        /* 0x187d */
    OTHER,        /* 0x187e */
    OTHER,        /* 0x187f */
    OTHER,        /* 0x1880 */
    OTHER,        /* 0x1881 */
    OTHER,        /* 0x1882 */
    OTHER,        /* 0x1883 */
    OTHER,        /* 0x1884 */
    OTHER,        /* 0x1885 */
    OTHER,        /* 0x1886 */
    OTHER,        /* 0x1887 */
    OTHER,        /* 0x1888 */
    OTHER,        /* 0x1889 */
    OTHER,        /* 0x188a */
    OTHER,        /* 0x188b */
    OTHER,        /* 0x188c */
    OTHER,        /* 0x188d */
    OTHER,        /* 0x188e */
    OTHER,        /* 0x188f */
    OTHER,        /* 0x1890 */
    OTHER,        /* 0x1891 */
    OTHER,        /* 0x1892 */
    OTHER,        /* 0x1893 */
    OTHER,        /* 0x1894 */
    OTHER,        /* 0x1895 */
    OTHER,        /* 0x1896 */
    OTHER,        /* 0x1897 */
    OTHER,        /* 0x1898 */
    OTHER,        /* 0x1899 */
    OTHER,        /* 0x189a */
    OTHER,        /* 0x189b */
    OTHER,        /* 0x189c */
    OTHER,        /* 0x189d */
    OTHER,        /* 0x189e */
    OTHER,        /* 0x189f */
    OTHER,        /* 0x18a0 */
    OTHER,        /* 0x18a1 */
    OTHER,        /* 0x18a2 */
    OTHER,        /* 0x18a3 */
    OTHER,        /* 0x18a4 */
    OTHER,        /* 0x18a5 */
    OTHER,        /* 0x18a6 */
    OTHER,        /* 0x18a7 */
    OTHER,        /* 0x18a8 */
    OTHER,        /* 0x18a9 */
    OTHER,        /* 0x18aa */
    OTHER,        /* 0x18ab */
    OTHER,        /* 0x18ac */
    OTHER,        /* 0x18ad */
    OTHER,        /* 0x18ae */
    OTHER,        /* 0x18af */
    OTHER,        /* 0x18b0 */
    OTHER,        /* 0x18b1 */
    OTHER,        /* 0x18b2 */
    OTHER,        /* 0x18b3 */
    OTHER,        /* 0x18b4 */
    OTHER,        /* 0x18b5 */
    OTHER,        /* 0x18b6 */
    OTHER,        /* 0x18b7 */
    OTHER,        /* 0x18b8 */
    OTHER,        /* 0x18b9 */
    OTHER,        /* 0x18ba */
    OTHER,        /* 0x18bb */
    OTHER,        /* 0x18bc */
    OTHER,        /* 0x18bd */
    OTHER,        /* 0x18be */
    OTHER,        /* 0x18bf */
    OTHER,        /* 0x18c0 */
    OTHER,        /* 0x18c1 */
    OTHER,        /* 0x18c2 */
    OTHER,        /* 0x18c3 */
    OTHER,        /* 0x18c4 */
    OTHER,        /* 0x18c5 */
    OTHER,        /* 0x18c6 */
    OTHER,        /* 0x18c7 */
    OTHER,        /* 0x18c8 */
    OTHER,        /* 0x18c9 */
    OTHER,        /* 0x18ca */
    OTHER,        /* 0x18cb */
    OTHER,        /* 0x18cc */
    OTHER,        /* 0x18cd */
    OTHER,        /* 0x18ce */
    OTHER,        /* 0x18cf */
    OTHER,        /* 0x18d0 */
    OTHER,        /* 0x18d1 */
    OTHER,        /* 0x18d2 */
    OTHER,        /* 0x18d3 */
    OTHER,        /* 0x18d4 */
    OTHER,        /* 0x18d5 */
    OTHER,        /* 0x18d6 */
    OTHER,        /* 0x18d7 */
    OTHER,        /* 0x18d8 */
    OTHER,        /* 0x18d9 */
    OTHER,        /* 0x18da */
    OTHER,        /* 0x18db */
    OTHER,        /* 0x18dc */
    OTHER,        /* 0x18dd */
    OTHER,        /* 0x18de */
    OTHER,        /* 0x18df */
    OTHER,        /* 0x18e0 */
    OTHER,        /* 0x18e1 */
    OTHER,        /* 0x18e2 */
    OTHER,        /* 0x18e3 */
    OTHER,        /* 0x18e4 */
    OTHER,        /* 0x18e5 */
    OTHER,        /* 0x18e6 */
    OTHER,        /* 0x18e7 */
    OTHER,        /* 0x18e8 */
    OTHER,        /* 0x18e9 */
    OTHER,        /* 0x18ea */
    OTHER,        /* 0x18eb */
    OTHER,        /* 0x18ec */
    OTHER,        /* 0x18ed */
    OTHER,        /* 0x18ee */
    OTHER,        /* 0x18ef */
    OTHER,        /* 0x18f0 */
    OTHER,        /* 0x18f1 */
    OTHER,        /* 0x18f2 */
    OTHER,        /* 0x18f3 */
    OTHER,        /* 0x18f4 */
    OTHER,        /* 0x18f5 */
    OTHER,        /* 0x18f6 */
    OTHER,        /* 0x18f7 */
    OTHER,        /* 0x18f8 */
    OTHER,        /* 0x18f9 */
    OTHER,        /* 0x18fa */
    OTHER,        /* 0x18fb */
    OTHER,        /* 0x18fc */
    OTHER,        /* 0x18fd */
    OTHER,        /* 0x18fe */
    OTHER,        /* 0x18ff */
    OTHER,        /* 0x1900 */
    OTHER,        /* 0x1901 */
    OTHER,        /* 0x1902 */
    OTHER,        /* 0x1903 */
    OTHER,        /* 0x1904 */
    OTHER,        /* 0x1905 */
    OTHER,        /* 0x1906 */
    OTHER,        /* 0x1907 */
    OTHER,        /* 0x1908 */
    OTHER,        /* 0x1909 */
    OTHER,        /* 0x190a */
    OTHER,        /* 0x190b */
    OTHER,        /* 0x190c */
    OTHER,        /* 0x190d */
    OTHER,        /* 0x190e */
    OTHER,        /* 0x190f */
    OTHER,        /* 0x1910 */
    OTHER,        /* 0x1911 */
    OTHER,        /* 0x1912 */
    OTHER,        /* 0x1913 */
    OTHER,        /* 0x1914 */
    OTHER,        /* 0x1915 */
    OTHER,        /* 0x1916 */
    OTHER,        /* 0x1917 */
    OTHER,        /* 0x1918 */
    OTHER,        /* 0x1919 */
    OTHER,        /* 0x191a */
    OTHER,        /* 0x191b */
    OTHER,        /* 0x191c */
    OTHER,        /* 0x191d */
    OTHER,        /* 0x191e */
    OTHER,        /* 0x191f */
    OTHER,        /* 0x1920 */
    OTHER,        /* 0x1921 */
    OTHER,        /* 0x1922 */
    OTHER,        /* 0x1923 */
    OTHER,        /* 0x1924 */
    OTHER,        /* 0x1925 */
    OTHER,        /* 0x1926 */
    OTHER,        /* 0x1927 */
    OTHER,        /* 0x1928 */
    OTHER,        /* 0x1929 */
    OTHER,        /* 0x192a */
    OTHER,        /* 0x192b */
    OTHER,        /* 0x192c */
    OTHER,        /* 0x192d */
    OTHER,        /* 0x192e */
    OTHER,        /* 0x192f */
    OTHER,        /* 0x1930 */
    OTHER,        /* 0x1931 */
    OTHER,        /* 0x1932 */
    OTHER,        /* 0x1933 */
    OTHER,        /* 0x1934 */
    OTHER,        /* 0x1935 */
    OTHER,        /* 0x1936 */
    OTHER,        /* 0x1937 */
    OTHER,        /* 0x1938 */
    OTHER,        /* 0x1939 */
    OTHER,        /* 0x193a */
    OTHER,        /* 0x193b */
    OTHER,        /* 0x193c */
    OTHER,        /* 0x193d */
    OTHER,        /* 0x193e */
    OTHER,        /* 0x193f */
    OTHER,        /* 0x1940 */
    OTHER,        /* 0x1941 */
    OTHER,        /* 0x1942 */
    OTHER,        /* 0x1943 */
    OTHER,        /* 0x1944 */
    OTHER,        /* 0x1945 */
    OTHER,        /* 0x1946 */
    OTHER,        /* 0x1947 */
    OTHER,        /* 0x1948 */
    OTHER,        /* 0x1949 */
    OTHER,        /* 0x194a */
    OTHER,        /* 0x194b */
    OTHER,        /* 0x194c */
    OTHER,        /* 0x194d */
    OTHER,        /* 0x194e */
    OTHER,        /* 0x194f */
    OTHER,        /* 0x1950 */
    OTHER,        /* 0x1951 */
    OTHER,        /* 0x1952 */
    OTHER,        /* 0x1953 */
    OTHER,        /* 0x1954 */
    OTHER,        /* 0x1955 */
    OTHER,        /* 0x1956 */
    OTHER,        /* 0x1957 */
    OTHER,        /* 0x1958 */
    OTHER,        /* 0x1959 */
    OTHER,        /* 0x195a */
    OTHER,        /* 0x195b */
    OTHER,        /* 0x195c */
    OTHER,        /* 0x195d */
    OTHER,        /* 0x195e */
    OTHER,        /* 0x195f */
    OTHER,        /* 0x1960 */
    OTHER,        /* 0x1961 */
    OTHER,        /* 0x1962 */
    OTHER,        /* 0x1963 */
    OTHER,        /* 0x1964 */
    OTHER,        /* 0x1965 */
    OTHER,        /* 0x1966 */
    OTHER,        /* 0x1967 */
    OTHER,        /* 0x1968 */
    OTHER,        /* 0x1969 */
    OTHER,        /* 0x196a */
    OTHER,        /* 0x196b */
    OTHER,        /* 0x196c */
    OTHER,        /* 0x196d */
    OTHER,        /* 0x196e */
    OTHER,        /* 0x196f */
    OTHER,        /* 0x1970 */
    OTHER,        /* 0x1971 */
    OTHER,        /* 0x1972 */
    OTHER,        /* 0x1973 */
    OTHER,        /* 0x1974 */
    OTHER,        /* 0x1975 */
    OTHER,        /* 0x1976 */
    OTHER,        /* 0x1977 */
    OTHER,        /* 0x1978 */
    OTHER,        /* 0x1979 */
    OTHER,        /* 0x197a */
    OTHER,        /* 0x197b */
    OTHER,        /* 0x197c */
    OTHER,        /* 0x197d */
    OTHER,        /* 0x197e */
    OTHER,        /* 0x197f */
    OTHER,        /* 0x1980 */
    OTHER,        /* 0x1981 */
    OTHER,        /* 0x1982 */
    OTHER,        /* 0x1983 */
    OTHER,        /* 0x1984 */
    OTHER,        /* 0x1985 */
    OTHER,        /* 0x1986 */
    OTHER,        /* 0x1987 */
    OTHER,        /* 0x1988 */
    OTHER,        /* 0x1989 */
    OTHER,        /* 0x198a */
    OTHER,        /* 0x198b */
    OTHER,        /* 0x198c */
    OTHER,        /* 0x198d */
    OTHER,        /* 0x198e */
    OTHER,        /* 0x198f */
    OTHER,        /* 0x1990 */
    OTHER,        /* 0x1991 */
    OTHER,        /* 0x1992 */
    OTHER,        /* 0x1993 */
    OTHER,        /* 0x1994 */
    OTHER,        /* 0x1995 */
    OTHER,        /* 0x1996 */
    OTHER,        /* 0x1997 */
    OTHER,        /* 0x1998 */
    OTHER,        /* 0x1999 */
    OTHER,        /* 0x199a */
    OTHER,        /* 0x199b */
    OTHER,        /* 0x199c */
    OTHER,        /* 0x199d */
    OTHER,        /* 0x199e */
    OTHER,        /* 0x199f */
    OTHER,        /* 0x19a0 */
    OTHER,        /* 0x19a1 */
    OTHER,        /* 0x19a2 */
    OTHER,        /* 0x19a3 */
    OTHER,        /* 0x19a4 */
    OTHER,        /* 0x19a5 */
    OTHER,        /* 0x19a6 */
    OTHER,        /* 0x19a7 */
    OTHER,        /* 0x19a8 */
    OTHER,        /* 0x19a9 */
    OTHER,        /* 0x19aa */
    OTHER,        /* 0x19ab */
    OTHER,        /* 0x19ac */
    OTHER,        /* 0x19ad */
    OTHER,        /* 0x19ae */
    OTHER,        /* 0x19af */
    OTHER,        /* 0x19b0 */
    OTHER,        /* 0x19b1 */
    OTHER,        /* 0x19b2 */
    OTHER,        /* 0x19b3 */
    OTHER,        /* 0x19b4 */
    OTHER,        /* 0x19b5 */
    OTHER,        /* 0x19b6 */
    OTHER,        /* 0x19b7 */
    OTHER,        /* 0x19b8 */
    OTHER,        /* 0x19b9 */
    OTHER,        /* 0x19ba */
    OTHER,        /* 0x19bb */
    OTHER,        /* 0x19bc */
    OTHER,        /* 0x19bd */
    OTHER,        /* 0x19be */
    OTHER,        /* 0x19bf */
    OTHER,        /* 0x19c0 */
    OTHER,        /* 0x19c1 */
    OTHER,        /* 0x19c2 */
    OTHER,        /* 0x19c3 */
    OTHER,        /* 0x19c4 */
    OTHER,        /* 0x19c5 */
    OTHER,        /* 0x19c6 */
    OTHER,        /* 0x19c7 */
    OTHER,        /* 0x19c8 */
    OTHER,        /* 0x19c9 */
    OTHER,        /* 0x19ca */
    OTHER,        /* 0x19cb */
    OTHER,        /* 0x19cc */
    OTHER,        /* 0x19cd */
    OTHER,        /* 0x19ce */
    OTHER,        /* 0x19cf */
    OTHER,        /* 0x19d0 */
    OTHER,        /* 0x19d1 */
    OTHER,        /* 0x19d2 */
    OTHER,        /* 0x19d3 */
    OTHER,        /* 0x19d4 */
    OTHER,        /* 0x19d5 */
    OTHER,        /* 0x19d6 */
    OTHER,        /* 0x19d7 */
    OTHER,        /* 0x19d8 */
    OTHER,        /* 0x19d9 */
    OTHER,        /* 0x19da */
    OTHER,        /* 0x19db */
    OTHER,        /* 0x19dc */
    OTHER,        /* 0x19dd */
    OTHER,        /* 0x19de */
    OTHER,        /* 0x19df */
    OTHER,        /* 0x19e0 */
    OTHER,        /* 0x19e1 */
    OTHER,        /* 0x19e2 */
    OTHER,        /* 0x19e3 */
    OTHER,        /* 0x19e4 */
    OTHER,        /* 0x19e5 */
    OTHER,        /* 0x19e6 */
    OTHER,        /* 0x19e7 */
    OTHER,        /* 0x19e8 */
    OTHER,        /* 0x19e9 */
    OTHER,        /* 0x19ea */
    OTHER,        /* 0x19eb */
    OTHER,        /* 0x19ec */
    OTHER,        /* 0x19ed */
    OTHER,        /* 0x19ee */
    OTHER,        /* 0x19ef */
    OTHER,        /* 0x19f0 */
    OTHER,        /* 0x19f1 */
    OTHER,        /* 0x19f2 */
    OTHER,        /* 0x19f3 */
    OTHER,        /* 0x19f4 */
    OTHER,        /* 0x19f5 */
    OTHER,        /* 0x19f6 */
    OTHER,        /* 0x19f7 */
    OTHER,        /* 0x19f8 */
    OTHER,        /* 0x19f9 */
    OTHER,        /* 0x19fa */
    OTHER,        /* 0x19fb */
    OTHER,        /* 0x19fc */
    OTHER,        /* 0x19fd */
    OTHER,        /* 0x19fe */
    OTHER,        /* 0x19ff */
    OTHER,        /* 0x1a00 */
    OTHER,        /* 0x1a01 */
    OTHER,        /* 0x1a02 */
    OTHER,        /* 0x1a03 */
    OTHER,        /* 0x1a04 */
    OTHER,        /* 0x1a05 */
    OTHER,        /* 0x1a06 */
    OTHER,        /* 0x1a07 */
    OTHER,        /* 0x1a08 */
    OTHER,        /* 0x1a09 */
    OTHER,        /* 0x1a0a */
    OTHER,        /* 0x1a0b */
    OTHER,        /* 0x1a0c */
    OTHER,        /* 0x1a0d */
    OTHER,        /* 0x1a0e */
    OTHER,        /* 0x1a0f */
    OTHER,        /* 0x1a10 */
    OTHER,        /* 0x1a11 */
    OTHER,        /* 0x1a12 */
    OTHER,        /* 0x1a13 */
    OTHER,        /* 0x1a14 */
    OTHER,        /* 0x1a15 */
    OTHER,        /* 0x1a16 */
    OTHER,        /* 0x1a17 */
    OTHER,        /* 0x1a18 */
    OTHER,        /* 0x1a19 */
    OTHER,        /* 0x1a1a */
    OTHER,        /* 0x1a1b */
    OTHER,        /* 0x1a1c */
    OTHER,        /* 0x1a1d */
    OTHER,        /* 0x1a1e */
    OTHER,        /* 0x1a1f */
    OTHER,        /* 0x1a20 */
    OTHER,        /* 0x1a21 */
    OTHER,        /* 0x1a22 */
    OTHER,        /* 0x1a23 */
    OTHER,        /* 0x1a24 */
    OTHER,        /* 0x1a25 */
    OTHER,        /* 0x1a26 */
    OTHER,        /* 0x1a27 */
    OTHER,        /* 0x1a28 */
    OTHER,        /* 0x1a29 */
    OTHER,        /* 0x1a2a */
    OTHER,        /* 0x1a2b */
    OTHER,        /* 0x1a2c */
    OTHER,        /* 0x1a2d */
    OTHER,        /* 0x1a2e */
    OTHER,        /* 0x1a2f */
    OTHER,        /* 0x1a30 */
    OTHER,        /* 0x1a31 */
    OTHER,        /* 0x1a32 */
    OTHER,        /* 0x1a33 */
    OTHER,        /* 0x1a34 */
    OTHER,        /* 0x1a35 */
    OTHER,        /* 0x1a36 */
    OTHER,        /* 0x1a37 */
    OTHER,        /* 0x1a38 */
    OTHER,        /* 0x1a39 */
    OTHER,        /* 0x1a3a */
    OTHER,        /* 0x1a3b */
    OTHER,        /* 0x1a3c */
    OTHER,        /* 0x1a3d */
    OTHER,        /* 0x1a3e */
    OTHER,        /* 0x1a3f */
    OTHER,        /* 0x1a40 */
    OTHER,        /* 0x1a41 */
    OTHER,        /* 0x1a42 */
    OTHER,        /* 0x1a43 */
    OTHER,        /* 0x1a44 */
    OTHER,        /* 0x1a45 */
    OTHER,        /* 0x1a46 */
    OTHER,        /* 0x1a47 */
    OTHER,        /* 0x1a48 */
    OTHER,        /* 0x1a49 */
    OTHER,        /* 0x1a4a */
    OTHER,        /* 0x1a4b */
    OTHER,        /* 0x1a4c */
    OTHER,        /* 0x1a4d */
    OTHER,        /* 0x1a4e */
    OTHER,        /* 0x1a4f */
    OTHER,        /* 0x1a50 */
    OTHER,        /* 0x1a51 */
    OTHER,        /* 0x1a52 */
    OTHER,        /* 0x1a53 */
    OTHER,        /* 0x1a54 */
    OTHER,        /* 0x1a55 */
    OTHER,        /* 0x1a56 */
    OTHER,        /* 0x1a57 */
    OTHER,        /* 0x1a58 */
    OTHER,        /* 0x1a59 */
    OTHER,        /* 0x1a5a */
    OTHER,        /* 0x1a5b */
    OTHER,        /* 0x1a5c */
    OTHER,        /* 0x1a5d */
    OTHER,        /* 0x1a5e */
    OTHER,        /* 0x1a5f */
    OTHER,        /* 0x1a60 */
    OTHER,        /* 0x1a61 */
    OTHER,        /* 0x1a62 */
    OTHER,        /* 0x1a63 */
    OTHER,        /* 0x1a64 */
    OTHER,        /* 0x1a65 */
    OTHER,        /* 0x1a66 */
    OTHER,        /* 0x1a67 */
    OTHER,        /* 0x1a68 */
    OTHER,        /* 0x1a69 */
    OTHER,        /* 0x1a6a */
    OTHER,        /* 0x1a6b */
    OTHER,        /* 0x1a6c */
    OTHER,        /* 0x1a6d */
    OTHER,        /* 0x1a6e */
    OTHER,        /* 0x1a6f */
    OTHER,        /* 0x1a70 */
    OTHER,        /* 0x1a71 */
    OTHER,        /* 0x1a72 */
    OTHER,        /* 0x1a73 */
    OTHER,        /* 0x1a74 */
    OTHER,        /* 0x1a75 */
    OTHER,        /* 0x1a76 */
    OTHER,        /* 0x1a77 */
    OTHER,        /* 0x1a78 */
    OTHER,        /* 0x1a79 */
    OTHER,        /* 0x1a7a */
    OTHER,        /* 0x1a7b */
    OTHER,        /* 0x1a7c */
    OTHER,        /* 0x1a7d */
    OTHER,        /* 0x1a7e */
    OTHER,        /* 0x1a7f */
    OTHER,        /* 0x1a80 */
    OTHER,        /* 0x1a81 */
    OTHER,        /* 0x1a82 */
    OTHER,        /* 0x1a83 */
    OTHER,        /* 0x1a84 */
    OTHER,        /* 0x1a85 */
    OTHER,        /* 0x1a86 */
    OTHER,        /* 0x1a87 */
    OTHER,        /* 0x1a88 */
    OTHER,        /* 0x1a89 */
    OTHER,        /* 0x1a8a */
    OTHER,        /* 0x1a8b */
    OTHER,        /* 0x1a8c */
    OTHER,        /* 0x1a8d */
    OTHER,        /* 0x1a8e */
    OTHER,        /* 0x1a8f */
    OTHER,        /* 0x1a90 */
    OTHER,        /* 0x1a91 */
    OTHER,        /* 0x1a92 */
    OTHER,        /* 0x1a93 */
    OTHER,        /* 0x1a94 */
    OTHER,        /* 0x1a95 */
    OTHER,        /* 0x1a96 */
    OTHER,        /* 0x1a97 */
    OTHER,        /* 0x1a98 */
    OTHER,        /* 0x1a99 */
    OTHER,        /* 0x1a9a */
    OTHER,        /* 0x1a9b */
    OTHER,        /* 0x1a9c */
    OTHER,        /* 0x1a9d */
    OTHER,        /* 0x1a9e */
    OTHER,        /* 0x1a9f */
    OTHER,        /* 0x1aa0 */
    OTHER,        /* 0x1aa1 */
    OTHER,        /* 0x1aa2 */
    OTHER,        /* 0x1aa3 */
    OTHER,        /* 0x1aa4 */
    OTHER,        /* 0x1aa5 */
    OTHER,        /* 0x1aa6 */
    OTHER,        /* 0x1aa7 */
    OTHER,        /* 0x1aa8 */
    OTHER,        /* 0x1aa9 */
    OTHER,        /* 0x1aaa */
    OTHER,        /* 0x1aab */
    OTHER,        /* 0x1aac */
    OTHER,        /* 0x1aad */
    OTHER,        /* 0x1aae */
    OTHER,        /* 0x1aaf */
    OTHER,        /* 0x1ab0 */
    OTHER,        /* 0x1ab1 */
    OTHER,        /* 0x1ab2 */
    OTHER,        /* 0x1ab3 */
    OTHER,        /* 0x1ab4 */
    OTHER,        /* 0x1ab5 */
    OTHER,        /* 0x1ab6 */
    OTHER,        /* 0x1ab7 */
    OTHER,        /* 0x1ab8 */
    OTHER,        /* 0x1ab9 */
    OTHER,        /* 0x1aba */
    OTHER,        /* 0x1abb */
    OTHER,        /* 0x1abc */
    OTHER,        /* 0x1abd */
    OTHER,        /* 0x1abe */
    OTHER,        /* 0x1abf */
    OTHER,        /* 0x1ac0 */
    OTHER,        /* 0x1ac1 */
    OTHER,        /* 0x1ac2 */
    OTHER,        /* 0x1ac3 */
    OTHER,        /* 0x1ac4 */
    OTHER,        /* 0x1ac5 */
    OTHER,        /* 0x1ac6 */
    OTHER,        /* 0x1ac7 */
    OTHER,        /* 0x1ac8 */
    OTHER,        /* 0x1ac9 */
    OTHER,        /* 0x1aca */
    OTHER,        /* 0x1acb */
    OTHER,        /* 0x1acc */
    OTHER,        /* 0x1acd */
    OTHER,        /* 0x1ace */
    OTHER,        /* 0x1acf */
    OTHER,        /* 0x1ad0 */
    OTHER,        /* 0x1ad1 */
    OTHER,        /* 0x1ad2 */
    OTHER,        /* 0x1ad3 */
    OTHER,        /* 0x1ad4 */
    OTHER,        /* 0x1ad5 */
    OTHER,        /* 0x1ad6 */
    OTHER,        /* 0x1ad7 */
    OTHER,        /* 0x1ad8 */
    OTHER,        /* 0x1ad9 */
    OTHER,        /* 0x1ada */
    OTHER,        /* 0x1adb */
    OTHER,        /* 0x1adc */
    OTHER,        /* 0x1add */
    OTHER,        /* 0x1ade */
    OTHER,        /* 0x1adf */
    OTHER,        /* 0x1ae0 */
    OTHER,        /* 0x1ae1 */
    OTHER,        /* 0x1ae2 */
    OTHER,        /* 0x1ae3 */
    OTHER,        /* 0x1ae4 */
    OTHER,        /* 0x1ae5 */
    OTHER,        /* 0x1ae6 */
    OTHER,        /* 0x1ae7 */
    OTHER,        /* 0x1ae8 */
    OTHER,        /* 0x1ae9 */
    OTHER,        /* 0x1aea */
    OTHER,        /* 0x1aeb */
    OTHER,        /* 0x1aec */
    OTHER,        /* 0x1aed */
    OTHER,        /* 0x1aee */
    OTHER,        /* 0x1aef */
    OTHER,        /* 0x1af0 */
    OTHER,        /* 0x1af1 */
    OTHER,        /* 0x1af2 */
    OTHER,        /* 0x1af3 */
    OTHER,        /* 0x1af4 */
    OTHER,        /* 0x1af5 */
    OTHER,        /* 0x1af6 */
    OTHER,        /* 0x1af7 */
    OTHER,        /* 0x1af8 */
    OTHER,        /* 0x1af9 */
    OTHER,        /* 0x1afa */
    OTHER,        /* 0x1afb */
    OTHER,        /* 0x1afc */
    OTHER,        /* 0x1afd */
    OTHER,        /* 0x1afe */
    OTHER,        /* 0x1aff */
    OTHER,        /* 0x1b00 */
    OTHER,        /* 0x1b01 */
    OTHER,        /* 0x1b02 */
    OTHER,        /* 0x1b03 */
    OTHER,        /* 0x1b04 */
    OTHER,        /* 0x1b05 */
    OTHER,        /* 0x1b06 */
    OTHER,        /* 0x1b07 */
    OTHER,        /* 0x1b08 */
    OTHER,        /* 0x1b09 */
    OTHER,        /* 0x1b0a */
    OTHER,        /* 0x1b0b */
    OTHER,        /* 0x1b0c */
    OTHER,        /* 0x1b0d */
    OTHER,        /* 0x1b0e */
    OTHER,        /* 0x1b0f */
    OTHER,        /* 0x1b10 */
    OTHER,        /* 0x1b11 */
    OTHER,        /* 0x1b12 */
    OTHER,        /* 0x1b13 */
    OTHER,        /* 0x1b14 */
    OTHER,        /* 0x1b15 */
    OTHER,        /* 0x1b16 */
    OTHER,        /* 0x1b17 */
    OTHER,        /* 0x1b18 */
    OTHER,        /* 0x1b19 */
    OTHER,        /* 0x1b1a */
    OTHER,        /* 0x1b1b */
    OTHER,        /* 0x1b1c */
    OTHER,        /* 0x1b1d */
    OTHER,        /* 0x1b1e */
    OTHER,        /* 0x1b1f */
    OTHER,        /* 0x1b20 */
    OTHER,        /* 0x1b21 */
    OTHER,        /* 0x1b22 */
    OTHER,        /* 0x1b23 */
    OTHER,        /* 0x1b24 */
    OTHER,        /* 0x1b25 */
    OTHER,        /* 0x1b26 */
    OTHER,        /* 0x1b27 */
    OTHER,        /* 0x1b28 */
    OTHER,        /* 0x1b29 */
    OTHER,        /* 0x1b2a */
    OTHER,        /* 0x1b2b */
    OTHER,        /* 0x1b2c */
    OTHER,        /* 0x1b2d */
    OTHER,        /* 0x1b2e */
    OTHER,        /* 0x1b2f */
    OTHER,        /* 0x1b30 */
    OTHER,        /* 0x1b31 */
    OTHER,        /* 0x1b32 */
    OTHER,        /* 0x1b33 */
    OTHER,        /* 0x1b34 */
    OTHER,        /* 0x1b35 */
    OTHER,        /* 0x1b36 */
    OTHER,        /* 0x1b37 */
    OTHER,        /* 0x1b38 */
    OTHER,        /* 0x1b39 */
    OTHER,        /* 0x1b3a */
    OTHER,        /* 0x1b3b */
    OTHER,        /* 0x1b3c */
    OTHER,        /* 0x1b3d */
    OTHER,        /* 0x1b3e */
    OTHER,        /* 0x1b3f */
    OTHER,        /* 0x1b40 */
    OTHER,        /* 0x1b41 */
    OTHER,        /* 0x1b42 */
    OTHER,        /* 0x1b43 */
    OTHER,        /* 0x1b44 */
    OTHER,        /* 0x1b45 */
    OTHER,        /* 0x1b46 */
    OTHER,        /* 0x1b47 */
    OTHER,        /* 0x1b48 */
    OTHER,        /* 0x1b49 */
    OTHER,        /* 0x1b4a */
    OTHER,        /* 0x1b4b */
    OTHER,        /* 0x1b4c */
    OTHER,        /* 0x1b4d */
    OTHER,        /* 0x1b4e */
    OTHER,        /* 0x1b4f */
    OTHER,        /* 0x1b50 */
    OTHER,        /* 0x1b51 */
    OTHER,        /* 0x1b52 */
    OTHER,        /* 0x1b53 */
    OTHER,        /* 0x1b54 */
    OTHER,        /* 0x1b55 */
    OTHER,        /* 0x1b56 */
    OTHER,        /* 0x1b57 */
    OTHER,        /* 0x1b58 */
    OTHER,        /* 0x1b59 */
    OTHER,        /* 0x1b5a */
    OTHER,        /* 0x1b5b */
    OTHER,        /* 0x1b5c */
    OTHER,        /* 0x1b5d */
    OTHER,        /* 0x1b5e */
    OTHER,        /* 0x1b5f */
    OTHER,        /* 0x1b60 */
    OTHER,        /* 0x1b61 */
    OTHER,        /* 0x1b62 */
    OTHER,        /* 0x1b63 */
    OTHER,        /* 0x1b64 */
    OTHER,        /* 0x1b65 */
    OTHER,        /* 0x1b66 */
    OTHER,        /* 0x1b67 */
    OTHER,        /* 0x1b68 */
    OTHER,        /* 0x1b69 */
    OTHER,        /* 0x1b6a */
    OTHER,        /* 0x1b6b */
    OTHER,        /* 0x1b6c */
    OTHER,        /* 0x1b6d */
    OTHER,        /* 0x1b6e */
    OTHER,        /* 0x1b6f */
    OTHER,        /* 0x1b70 */
    OTHER,        /* 0x1b71 */
    OTHER,        /* 0x1b72 */
    OTHER,        /* 0x1b73 */
    OTHER,        /* 0x1b74 */
    OTHER,        /* 0x1b75 */
    OTHER,        /* 0x1b76 */
    OTHER,        /* 0x1b77 */
    OTHER,        /* 0x1b78 */
    OTHER,        /* 0x1b79 */
    OTHER,        /* 0x1b7a */
    OTHER,        /* 0x1b7b */
    OTHER,        /* 0x1b7c */
    OTHER,        /* 0x1b7d */
    OTHER,        /* 0x1b7e */
    OTHER,        /* 0x1b7f */
    OTHER,        /* 0x1b80 */
    OTHER,        /* 0x1b81 */
    OTHER,        /* 0x1b82 */
    OTHER,        /* 0x1b83 */
    OTHER,        /* 0x1b84 */
    OTHER,        /* 0x1b85 */
    OTHER,        /* 0x1b86 */
    OTHER,        /* 0x1b87 */
    OTHER,        /* 0x1b88 */
    OTHER,        /* 0x1b89 */
    OTHER,        /* 0x1b8a */
    OTHER,        /* 0x1b8b */
    OTHER,        /* 0x1b8c */
    OTHER,        /* 0x1b8d */
    OTHER,        /* 0x1b8e */
    OTHER,        /* 0x1b8f */
    OTHER,        /* 0x1b90 */
    OTHER,        /* 0x1b91 */
    OTHER,        /* 0x1b92 */
    OTHER,        /* 0x1b93 */
    OTHER,        /* 0x1b94 */
    OTHER,        /* 0x1b95 */
    OTHER,        /* 0x1b96 */
    OTHER,        /* 0x1b97 */
    OTHER,        /* 0x1b98 */
    OTHER,        /* 0x1b99 */
    OTHER,        /* 0x1b9a */
    OTHER,        /* 0x1b9b */
    OTHER,        /* 0x1b9c */
    OTHER,        /* 0x1b9d */
    OTHER,        /* 0x1b9e */
    OTHER,        /* 0x1b9f */
    OTHER,        /* 0x1ba0 */
    OTHER,        /* 0x1ba1 */
    OTHER,        /* 0x1ba2 */
    OTHER,        /* 0x1ba3 */
    OTHER,        /* 0x1ba4 */
    OTHER,        /* 0x1ba5 */
    OTHER,        /* 0x1ba6 */
    OTHER,        /* 0x1ba7 */
    OTHER,        /* 0x1ba8 */
    OTHER,        /* 0x1ba9 */
    OTHER,        /* 0x1baa */
    OTHER,        /* 0x1bab */
    OTHER,        /* 0x1bac */
    OTHER,        /* 0x1bad */
    OTHER,        /* 0x1bae */
    OTHER,        /* 0x1baf */
    OTHER,        /* 0x1bb0 */
    OTHER,        /* 0x1bb1 */
    OTHER,        /* 0x1bb2 */
    OTHER,        /* 0x1bb3 */
    OTHER,        /* 0x1bb4 */
    OTHER,        /* 0x1bb5 */
    OTHER,        /* 0x1bb6 */
    OTHER,        /* 0x1bb7 */
    OTHER,        /* 0x1bb8 */
    OTHER,        /* 0x1bb9 */
    OTHER,        /* 0x1bba */
    OTHER,        /* 0x1bbb */
    OTHER,        /* 0x1bbc */
    OTHER,        /* 0x1bbd */
    OTHER,        /* 0x1bbe */
    OTHER,        /* 0x1bbf */
    OTHER,        /* 0x1bc0 */
    OTHER,        /* 0x1bc1 */
    OTHER,        /* 0x1bc2 */
    OTHER,        /* 0x1bc3 */
    OTHER,        /* 0x1bc4 */
    OTHER,        /* 0x1bc5 */
    OTHER,        /* 0x1bc6 */
    OTHER,        /* 0x1bc7 */
    OTHER,        /* 0x1bc8 */
    OTHER,        /* 0x1bc9 */
    OTHER,        /* 0x1bca */
    OTHER,        /* 0x1bcb */
    OTHER,        /* 0x1bcc */
    OTHER,        /* 0x1bcd */
    OTHER,        /* 0x1bce */
    OTHER,        /* 0x1bcf */
    OTHER,        /* 0x1bd0 */
    OTHER,        /* 0x1bd1 */
    OTHER,        /* 0x1bd2 */
    OTHER,        /* 0x1bd3 */
    OTHER,        /* 0x1bd4 */
    OTHER,        /* 0x1bd5 */
    OTHER,        /* 0x1bd6 */
    OTHER,        /* 0x1bd7 */
    OTHER,        /* 0x1bd8 */
    OTHER,        /* 0x1bd9 */
    OTHER,        /* 0x1bda */
    OTHER,        /* 0x1bdb */
    OTHER,        /* 0x1bdc */
    OTHER,        /* 0x1bdd */
    OTHER,        /* 0x1bde */
    OTHER,        /* 0x1bdf */
    OTHER,        /* 0x1be0 */
    OTHER,        /* 0x1be1 */
    OTHER,        /* 0x1be2 */
    OTHER,        /* 0x1be3 */
    OTHER,        /* 0x1be4 */
    OTHER,        /* 0x1be5 */
    OTHER,        /* 0x1be6 */
    OTHER,        /* 0x1be7 */
    OTHER,        /* 0x1be8 */
    OTHER,        /* 0x1be9 */
    OTHER,        /* 0x1bea */
    OTHER,        /* 0x1beb */
    OTHER,        /* 0x1bec */
    OTHER,        /* 0x1bed */
    OTHER,        /* 0x1bee */
    OTHER,        /* 0x1bef */
    OTHER,        /* 0x1bf0 */
    OTHER,        /* 0x1bf1 */
    OTHER,        /* 0x1bf2 */
    OTHER,        /* 0x1bf3 */
    OTHER,        /* 0x1bf4 */
    OTHER,        /* 0x1bf5 */
    OTHER,        /* 0x1bf6 */
    OTHER,        /* 0x1bf7 */
    OTHER,        /* 0x1bf8 */
    OTHER,        /* 0x1bf9 */
    OTHER,        /* 0x1bfa */
    OTHER,        /* 0x1bfb */
    OTHER,        /* 0x1bfc */
    OTHER,        /* 0x1bfd */
    OTHER,        /* 0x1bfe */
    OTHER,        /* 0x1bff */
    OTHER,        /* 0x1c00 */
    OTHER,        /* 0x1c01 */
    OTHER,        /* 0x1c02 */
    OTHER,        /* 0x1c03 */
    OTHER,        /* 0x1c04 */
    OTHER,        /* 0x1c05 */
    OTHER,        /* 0x1c06 */
    OTHER,        /* 0x1c07 */
    OTHER,        /* 0x1c08 */
    OTHER,        /* 0x1c09 */
    OTHER,        /* 0x1c0a */
    OTHER,        /* 0x1c0b */
    OTHER,        /* 0x1c0c */
    OTHER,        /* 0x1c0d */
    OTHER,        /* 0x1c0e */
    OTHER,        /* 0x1c0f */
    OTHER,        /* 0x1c10 */
    OTHER,        /* 0x1c11 */
    OTHER,        /* 0x1c12 */
    OTHER,        /* 0x1c13 */
    OTHER,        /* 0x1c14 */
    OTHER,        /* 0x1c15 */
    OTHER,        /* 0x1c16 */
    OTHER,        /* 0x1c17 */
    OTHER,        /* 0x1c18 */
    OTHER,        /* 0x1c19 */
    OTHER,        /* 0x1c1a */
    OTHER,        /* 0x1c1b */
    OTHER,        /* 0x1c1c */
    OTHER,        /* 0x1c1d */
    OTHER,        /* 0x1c1e */
    OTHER,        /* 0x1c1f */
    OTHER,        /* 0x1c20 */
    OTHER,        /* 0x1c21 */
    OTHER,        /* 0x1c22 */
    OTHER,        /* 0x1c23 */
    OTHER,        /* 0x1c24 */
    OTHER,        /* 0x1c25 */
    OTHER,        /* 0x1c26 */
    OTHER,        /* 0x1c27 */
    OTHER,        /* 0x1c28 */
    OTHER,        /* 0x1c29 */
    OTHER,        /* 0x1c2a */
    OTHER,        /* 0x1c2b */
    OTHER,        /* 0x1c2c */
    OTHER,        /* 0x1c2d */
    OTHER,        /* 0x1c2e */
    OTHER,        /* 0x1c2f */
    OTHER,        /* 0x1c30 */
    OTHER,        /* 0x1c31 */
    OTHER,        /* 0x1c32 */
    OTHER,        /* 0x1c33 */
    OTHER,        /* 0x1c34 */
    OTHER,        /* 0x1c35 */
    OTHER,        /* 0x1c36 */
    OTHER,        /* 0x1c37 */
    OTHER,        /* 0x1c38 */
    OTHER,        /* 0x1c39 */
    OTHER,        /* 0x1c3a */
    OTHER,        /* 0x1c3b */
    OTHER,        /* 0x1c3c */
    OTHER,        /* 0x1c3d */
    OTHER,        /* 0x1c3e */
    OTHER,        /* 0x1c3f */
    OTHER,        /* 0x1c40 */
    OTHER,        /* 0x1c41 */
    OTHER,        /* 0x1c42 */
    OTHER,        /* 0x1c43 */
    OTHER,        /* 0x1c44 */
    OTHER,        /* 0x1c45 */
    OTHER,        /* 0x1c46 */
    OTHER,        /* 0x1c47 */
    OTHER,        /* 0x1c48 */
    OTHER,        /* 0x1c49 */
    OTHER,        /* 0x1c4a */
    OTHER,        /* 0x1c4b */
    OTHER,        /* 0x1c4c */
    OTHER,        /* 0x1c4d */
    OTHER,        /* 0x1c4e */
    OTHER,        /* 0x1c4f */
    OTHER,        /* 0x1c50 */
    OTHER,        /* 0x1c51 */
    OTHER,        /* 0x1c52 */
    OTHER,        /* 0x1c53 */
    OTHER,        /* 0x1c54 */
    OTHER,        /* 0x1c55 */
    OTHER,        /* 0x1c56 */
    OTHER,        /* 0x1c57 */
    OTHER,        /* 0x1c58 */
    OTHER,        /* 0x1c59 */
    OTHER,        /* 0x1c5a */
    OTHER,        /* 0x1c5b */
    OTHER,        /* 0x1c5c */
    OTHER,        /* 0x1c5d */
    OTHER,        /* 0x1c5e */
    OTHER,        /* 0x1c5f */
    OTHER,        /* 0x1c60 */
    OTHER,        /* 0x1c61 */
    OTHER,        /* 0x1c62 */
    OTHER,        /* 0x1c63 */
    OTHER,        /* 0x1c64 */
    OTHER,        /* 0x1c65 */
    OTHER,        /* 0x1c66 */
    OTHER,        /* 0x1c67 */
    OTHER,        /* 0x1c68 */
    OTHER,        /* 0x1c69 */
    OTHER,        /* 0x1c6a */
    OTHER,        /* 0x1c6b */
    OTHER,        /* 0x1c6c */
    OTHER,        /* 0x1c6d */
    OTHER,        /* 0x1c6e */
    OTHER,        /* 0x1c6f */
    OTHER,        /* 0x1c70 */
    OTHER,        /* 0x1c71 */
    OTHER,        /* 0x1c72 */
    OTHER,        /* 0x1c73 */
    OTHER,        /* 0x1c74 */
    OTHER,        /* 0x1c75 */
    OTHER,        /* 0x1c76 */
    OTHER,        /* 0x1c77 */
    OTHER,        /* 0x1c78 */
    OTHER,        /* 0x1c79 */
    OTHER,        /* 0x1c7a */
    OTHER,        /* 0x1c7b */
    OTHER,        /* 0x1c7c */
    OTHER,        /* 0x1c7d */
    OTHER,        /* 0x1c7e */
    OTHER,        /* 0x1c7f */
    OTHER,        /* 0x1c80 */
    OTHER,        /* 0x1c81 */
    OTHER,        /* 0x1c82 */
    OTHER,        /* 0x1c83 */
    OTHER,        /* 0x1c84 */
    OTHER,        /* 0x1c85 */
    OTHER,        /* 0x1c86 */
    OTHER,        /* 0x1c87 */
    OTHER,        /* 0x1c88 */
    OTHER,        /* 0x1c89 */
    OTHER,        /* 0x1c8a */
    OTHER,        /* 0x1c8b */
    OTHER,        /* 0x1c8c */
    OTHER,        /* 0x1c8d */
    OTHER,        /* 0x1c8e */
    OTHER,        /* 0x1c8f */
    OTHER,        /* 0x1c90 */
    OTHER,        /* 0x1c91 */
    OTHER,        /* 0x1c92 */
    OTHER,        /* 0x1c93 */
    OTHER,        /* 0x1c94 */
    OTHER,        /* 0x1c95 */
    OTHER,        /* 0x1c96 */
    OTHER,        /* 0x1c97 */
    OTHER,        /* 0x1c98 */
    OTHER,        /* 0x1c99 */
    OTHER,        /* 0x1c9a */
    OTHER,        /* 0x1c9b */
    OTHER,        /* 0x1c9c */
    OTHER,        /* 0x1c9d */
    OTHER,        /* 0x1c9e */
    OTHER,        /* 0x1c9f */
    OTHER,        /* 0x1ca0 */
    OTHER,        /* 0x1ca1 */
    OTHER,        /* 0x1ca2 */
    OTHER,        /* 0x1ca3 */
    OTHER,        /* 0x1ca4 */
    OTHER,        /* 0x1ca5 */
    OTHER,        /* 0x1ca6 */
    OTHER,        /* 0x1ca7 */
    OTHER,        /* 0x1ca8 */
    OTHER,        /* 0x1ca9 */
    OTHER,        /* 0x1caa */
    OTHER,        /* 0x1cab */
    OTHER,        /* 0x1cac */
    OTHER,        /* 0x1cad */
    OTHER,        /* 0x1cae */
    OTHER,        /* 0x1caf */
    OTHER,        /* 0x1cb0 */
    OTHER,        /* 0x1cb1 */
    OTHER,        /* 0x1cb2 */
    OTHER,        /* 0x1cb3 */
    OTHER,        /* 0x1cb4 */
    OTHER,        /* 0x1cb5 */
    OTHER,        /* 0x1cb6 */
    OTHER,        /* 0x1cb7 */
    OTHER,        /* 0x1cb8 */
    OTHER,        /* 0x1cb9 */
    OTHER,        /* 0x1cba */
    OTHER,        /* 0x1cbb */
    OTHER,        /* 0x1cbc */
    OTHER,        /* 0x1cbd */
    OTHER,        /* 0x1cbe */
    OTHER,        /* 0x1cbf */
    OTHER,        /* 0x1cc0 */
    OTHER,        /* 0x1cc1 */
    OTHER,        /* 0x1cc2 */
    OTHER,        /* 0x1cc3 */
    OTHER,        /* 0x1cc4 */
    OTHER,        /* 0x1cc5 */
    OTHER,        /* 0x1cc6 */
    OTHER,        /* 0x1cc7 */
    OTHER,        /* 0x1cc8 */
    OTHER,        /* 0x1cc9 */
    OTHER,        /* 0x1cca */
    OTHER,        /* 0x1ccb */
    OTHER,        /* 0x1ccc */
    OTHER,        /* 0x1ccd */
    OTHER,        /* 0x1cce */
    OTHER,        /* 0x1ccf */
    OTHER,        /* 0x1cd0 */
    OTHER,        /* 0x1cd1 */
    OTHER,        /* 0x1cd2 */
    OTHER,        /* 0x1cd3 */
    OTHER,        /* 0x1cd4 */
    OTHER,        /* 0x1cd5 */
    OTHER,        /* 0x1cd6 */
    OTHER,        /* 0x1cd7 */
    OTHER,        /* 0x1cd8 */
    OTHER,        /* 0x1cd9 */
    OTHER,        /* 0x1cda */
    OTHER,        /* 0x1cdb */
    OTHER,        /* 0x1cdc */
    OTHER,        /* 0x1cdd */
    OTHER,        /* 0x1cde */
    OTHER,        /* 0x1cdf */
    OTHER,        /* 0x1ce0 */
    OTHER,        /* 0x1ce1 */
    OTHER,        /* 0x1ce2 */
    OTHER,        /* 0x1ce3 */
    OTHER,        /* 0x1ce4 */
    OTHER,        /* 0x1ce5 */
    OTHER,        /* 0x1ce6 */
    OTHER,        /* 0x1ce7 */
    OTHER,        /* 0x1ce8 */
    OTHER,        /* 0x1ce9 */
    OTHER,        /* 0x1cea */
    OTHER,        /* 0x1ceb */
    OTHER,        /* 0x1cec */
    OTHER,        /* 0x1ced */
    OTHER,        /* 0x1cee */
    OTHER,        /* 0x1cef */
    OTHER,        /* 0x1cf0 */
    OTHER,        /* 0x1cf1 */
    OTHER,        /* 0x1cf2 */
    OTHER,        /* 0x1cf3 */
    OTHER,        /* 0x1cf4 */
    OTHER,        /* 0x1cf5 */
    OTHER,        /* 0x1cf6 */
    OTHER,        /* 0x1cf7 */
    OTHER,        /* 0x1cf8 */
    OTHER,        /* 0x1cf9 */
    OTHER,        /* 0x1cfa */
    OTHER,        /* 0x1cfb */
    OTHER,        /* 0x1cfc */
    OTHER,        /* 0x1cfd */
    OTHER,        /* 0x1cfe */
    OTHER,        /* 0x1cff */
    OTHER,        /* 0x1d00 */
    OTHER,        /* 0x1d01 */
    OTHER,        /* 0x1d02 */
    OTHER,        /* 0x1d03 */
    OTHER,        /* 0x1d04 */
    OTHER,        /* 0x1d05 */
    OTHER,        /* 0x1d06 */
    OTHER,        /* 0x1d07 */
    OTHER,        /* 0x1d08 */
    OTHER,        /* 0x1d09 */
    OTHER,        /* 0x1d0a */
    OTHER,        /* 0x1d0b */
    OTHER,        /* 0x1d0c */
    OTHER,        /* 0x1d0d */
    OTHER,        /* 0x1d0e */
    OTHER,        /* 0x1d0f */
    OTHER,        /* 0x1d10 */
    OTHER,        /* 0x1d11 */
    OTHER,        /* 0x1d12 */
    OTHER,        /* 0x1d13 */
    OTHER,        /* 0x1d14 */
    OTHER,        /* 0x1d15 */
    OTHER,        /* 0x1d16 */
    OTHER,        /* 0x1d17 */
    OTHER,        /* 0x1d18 */
    OTHER,        /* 0x1d19 */
    OTHER,        /* 0x1d1a */
    OTHER,        /* 0x1d1b */
    OTHER,        /* 0x1d1c */
    OTHER,        /* 0x1d1d */
    OTHER,        /* 0x1d1e */
    OTHER,        /* 0x1d1f */
    OTHER,        /* 0x1d20 */
    OTHER,        /* 0x1d21 */
    OTHER,        /* 0x1d22 */
    OTHER,        /* 0x1d23 */
    OTHER,        /* 0x1d24 */
    OTHER,        /* 0x1d25 */
    OTHER,        /* 0x1d26 */
    OTHER,        /* 0x1d27 */
    OTHER,        /* 0x1d28 */
    OTHER,        /* 0x1d29 */
    OTHER,        /* 0x1d2a */
    OTHER,        /* 0x1d2b */
    OTHER,        /* 0x1d2c */
    OTHER,        /* 0x1d2d */
    OTHER,        /* 0x1d2e */
    OTHER,        /* 0x1d2f */
    OTHER,        /* 0x1d30 */
    OTHER,        /* 0x1d31 */
    OTHER,        /* 0x1d32 */
    OTHER,        /* 0x1d33 */
    OTHER,        /* 0x1d34 */
    OTHER,        /* 0x1d35 */
    OTHER,        /* 0x1d36 */
    OTHER,        /* 0x1d37 */
    OTHER,        /* 0x1d38 */
    OTHER,        /* 0x1d39 */
    OTHER,        /* 0x1d3a */
    OTHER,        /* 0x1d3b */
    OTHER,        /* 0x1d3c */
    OTHER,        /* 0x1d3d */
    OTHER,        /* 0x1d3e */
    OTHER,        /* 0x1d3f */
    OTHER,        /* 0x1d40 */
    OTHER,        /* 0x1d41 */
    OTHER,        /* 0x1d42 */
    OTHER,        /* 0x1d43 */
    OTHER,        /* 0x1d44 */
    OTHER,        /* 0x1d45 */
    OTHER,        /* 0x1d46 */
    OTHER,        /* 0x1d47 */
    OTHER,        /* 0x1d48 */
    OTHER,        /* 0x1d49 */
    OTHER,        /* 0x1d4a */
    OTHER,        /* 0x1d4b */
    OTHER,        /* 0x1d4c */
    OTHER,        /* 0x1d4d */
    OTHER,        /* 0x1d4e */
    OTHER,        /* 0x1d4f */
    OTHER,        /* 0x1d50 */
    OTHER,        /* 0x1d51 */
    OTHER,        /* 0x1d52 */
    OTHER,        /* 0x1d53 */
    OTHER,        /* 0x1d54 */
    OTHER,        /* 0x1d55 */
    OTHER,        /* 0x1d56 */
    OTHER,        /* 0x1d57 */
    OTHER,        /* 0x1d58 */
    OTHER,        /* 0x1d59 */
    OTHER,        /* 0x1d5a */
    OTHER,        /* 0x1d5b */
    OTHER,        /* 0x1d5c */
    OTHER,        /* 0x1d5d */
    OTHER,        /* 0x1d5e */
    OTHER,        /* 0x1d5f */
    OTHER,        /* 0x1d60 */
    OTHER,        /* 0x1d61 */
    OTHER,        /* 0x1d62 */
    OTHER,        /* 0x1d63 */
    OTHER,        /* 0x1d64 */
    OTHER,        /* 0x1d65 */
    OTHER,        /* 0x1d66 */
    OTHER,        /* 0x1d67 */
    OTHER,        /* 0x1d68 */
    OTHER,        /* 0x1d69 */
    OTHER,        /* 0x1d6a */
    OTHER,        /* 0x1d6b */
    OTHER,        /* 0x1d6c */
    OTHER,        /* 0x1d6d */
    OTHER,        /* 0x1d6e */
    OTHER,        /* 0x1d6f */
    OTHER,        /* 0x1d70 */
    OTHER,        /* 0x1d71 */
    OTHER,        /* 0x1d72 */
    OTHER,        /* 0x1d73 */
    OTHER,        /* 0x1d74 */
    OTHER,        /* 0x1d75 */
    OTHER,        /* 0x1d76 */
    OTHER,        /* 0x1d77 */
    OTHER,        /* 0x1d78 */
    OTHER,        /* 0x1d79 */
    OTHER,        /* 0x1d7a */
    OTHER,        /* 0x1d7b */
    OTHER,        /* 0x1d7c */
    OTHER,        /* 0x1d7d */
    OTHER,        /* 0x1d7e */
    OTHER,        /* 0x1d7f */
    OTHER,        /* 0x1d80 */
    OTHER,        /* 0x1d81 */
    OTHER,        /* 0x1d82 */
    OTHER,        /* 0x1d83 */
    OTHER,        /* 0x1d84 */
    OTHER,        /* 0x1d85 */
    OTHER,        /* 0x1d86 */
    OTHER,        /* 0x1d87 */
    OTHER,        /* 0x1d88 */
    OTHER,        /* 0x1d89 */
    OTHER,        /* 0x1d8a */
    OTHER,        /* 0x1d8b */
    OTHER,        /* 0x1d8c */
    OTHER,        /* 0x1d8d */
    OTHER,        /* 0x1d8e */
    OTHER,        /* 0x1d8f */
    OTHER,        /* 0x1d90 */
    OTHER,        /* 0x1d91 */
    OTHER,        /* 0x1d92 */
    OTHER,        /* 0x1d93 */
    OTHER,        /* 0x1d94 */
    OTHER,        /* 0x1d95 */
    OTHER,        /* 0x1d96 */
    OTHER,        /* 0x1d97 */
    OTHER,        /* 0x1d98 */
    OTHER,        /* 0x1d99 */
    OTHER,        /* 0x1d9a */
    OTHER,        /* 0x1d9b */
    OTHER,        /* 0x1d9c */
    OTHER,        /* 0x1d9d */
    OTHER,        /* 0x1d9e */
    OTHER,        /* 0x1d9f */
    OTHER,        /* 0x1da0 */
    OTHER,        /* 0x1da1 */
    OTHER,        /* 0x1da2 */
    OTHER,        /* 0x1da3 */
    OTHER,        /* 0x1da4 */
    OTHER,        /* 0x1da5 */
    OTHER,        /* 0x1da6 */
    OTHER,        /* 0x1da7 */
    OTHER,        /* 0x1da8 */
    OTHER,        /* 0x1da9 */
    OTHER,        /* 0x1daa */
    OTHER,        /* 0x1dab */
    OTHER,        /* 0x1dac */
    OTHER,        /* 0x1dad */
    OTHER,        /* 0x1dae */
    OTHER,        /* 0x1daf */
    OTHER,        /* 0x1db0 */
    OTHER,        /* 0x1db1 */
    OTHER,        /* 0x1db2 */
    OTHER,        /* 0x1db3 */
    OTHER,        /* 0x1db4 */
    OTHER,        /* 0x1db5 */
    OTHER,        /* 0x1db6 */
    OTHER,        /* 0x1db7 */
    OTHER,        /* 0x1db8 */
    OTHER,        /* 0x1db9 */
    OTHER,        /* 0x1dba */
    OTHER,        /* 0x1dbb */
    OTHER,        /* 0x1dbc */
    OTHER,        /* 0x1dbd */
    OTHER,        /* 0x1dbe */
    OTHER,        /* 0x1dbf */
    OTHER,        /* 0x1dc0 */
    OTHER,        /* 0x1dc1 */
    OTHER,        /* 0x1dc2 */
    OTHER,        /* 0x1dc3 */
    OTHER,        /* 0x1dc4 */
    OTHER,        /* 0x1dc5 */
    OTHER,        /* 0x1dc6 */
    OTHER,        /* 0x1dc7 */
    OTHER,        /* 0x1dc8 */
    OTHER,        /* 0x1dc9 */
    OTHER,        /* 0x1dca */
    OTHER,        /* 0x1dcb */
    OTHER,        /* 0x1dcc */
    OTHER,        /* 0x1dcd */
    OTHER,        /* 0x1dce */
    OTHER,        /* 0x1dcf */
    OTHER,        /* 0x1dd0 */
    OTHER,        /* 0x1dd1 */
    OTHER,        /* 0x1dd2 */
    OTHER,        /* 0x1dd3 */
    OTHER,        /* 0x1dd4 */
    OTHER,        /* 0x1dd5 */
    OTHER,        /* 0x1dd6 */
    OTHER,        /* 0x1dd7 */
    OTHER,        /* 0x1dd8 */
    OTHER,        /* 0x1dd9 */
    OTHER,        /* 0x1dda */
    OTHER,        /* 0x1ddb */
    OTHER,        /* 0x1ddc */
    OTHER,        /* 0x1ddd */
    OTHER,        /* 0x1dde */
    OTHER,        /* 0x1ddf */
    OTHER,        /* 0x1de0 */
    OTHER,        /* 0x1de1 */
    OTHER,        /* 0x1de2 */
    OTHER,        /* 0x1de3 */
    OTHER,        /* 0x1de4 */
    OTHER,        /* 0x1de5 */
    OTHER,        /* 0x1de6 */
    OTHER,        /* 0x1de7 */
    OTHER,        /* 0x1de8 */
    OTHER,        /* 0x1de9 */
    OTHER,        /* 0x1dea */
    OTHER,        /* 0x1deb */
    OTHER,        /* 0x1dec */
    OTHER,        /* 0x1ded */
    OTHER,        /* 0x1dee */
    OTHER,        /* 0x1def */
    OTHER,        /* 0x1df0 */
    OTHER,        /* 0x1df1 */
    OTHER,        /* 0x1df2 */
    OTHER,        /* 0x1df3 */
    OTHER,        /* 0x1df4 */
    OTHER,        /* 0x1df5 */
    OTHER,        /* 0x1df6 */
    OTHER,        /* 0x1df7 */
    OTHER,        /* 0x1df8 */
    OTHER,        /* 0x1df9 */
    OTHER,        /* 0x1dfa */
    OTHER,        /* 0x1dfb */
    OTHER,        /* 0x1dfc */
    OTHER,        /* 0x1dfd */
    OTHER,        /* 0x1dfe */
    OTHER,        /* 0x1dff */
    ALPHA,        /* 0x1e00 */
    ALPHA,        /* 0x1e01 */
    ALPHA,        /* 0x1e02 */
    ALPHA,        /* 0x1e03 */
    ALPHA,        /* 0x1e04 */
    ALPHA,        /* 0x1e05 */
    ALPHA,        /* 0x1e06 */
    ALPHA,        /* 0x1e07 */
    ALPHA,        /* 0x1e08 */
    ALPHA,        /* 0x1e09 */
    ALPHA,        /* 0x1e0a */
    ALPHA,        /* 0x1e0b */
    ALPHA,        /* 0x1e0c */
    ALPHA,        /* 0x1e0d */
    ALPHA,        /* 0x1e0e */
    ALPHA,        /* 0x1e0f */
    ALPHA,        /* 0x1e10 */
    ALPHA,        /* 0x1e11 */
    ALPHA,        /* 0x1e12 */
    ALPHA,        /* 0x1e13 */
    ALPHA,        /* 0x1e14 */
    ALPHA,        /* 0x1e15 */
    ALPHA,        /* 0x1e16 */
    ALPHA,        /* 0x1e17 */
    ALPHA,        /* 0x1e18 */
    ALPHA,        /* 0x1e19 */
    ALPHA,        /* 0x1e1a */
    ALPHA,        /* 0x1e1b */
    ALPHA,        /* 0x1e1c */
    ALPHA,        /* 0x1e1d */
    ALPHA,        /* 0x1e1e */
    ALPHA,        /* 0x1e1f */
    ALPHA,        /* 0x1e20 */
    ALPHA,        /* 0x1e21 */
    ALPHA,        /* 0x1e22 */
    ALPHA,        /* 0x1e23 */
    ALPHA,        /* 0x1e24 */
    ALPHA,        /* 0x1e25 */
    ALPHA,        /* 0x1e26 */
    ALPHA,        /* 0x1e27 */
    ALPHA,        /* 0x1e28 */
    ALPHA,        /* 0x1e29 */
    ALPHA,        /* 0x1e2a */
    ALPHA,        /* 0x1e2b */
    ALPHA,        /* 0x1e2c */
    ALPHA,        /* 0x1e2d */
    ALPHA,        /* 0x1e2e */
    ALPHA,        /* 0x1e2f */
    ALPHA,        /* 0x1e30 */
    ALPHA,        /* 0x1e31 */
    ALPHA,        /* 0x1e32 */
    ALPHA,        /* 0x1e33 */
    ALPHA,        /* 0x1e34 */
    ALPHA,        /* 0x1e35 */
    ALPHA,        /* 0x1e36 */
    ALPHA,        /* 0x1e37 */
    ALPHA,        /* 0x1e38 */
    ALPHA,        /* 0x1e39 */
    ALPHA,        /* 0x1e3a */
    ALPHA,        /* 0x1e3b */
    ALPHA,        /* 0x1e3c */
    ALPHA,        /* 0x1e3d */
    ALPHA,        /* 0x1e3e */
    ALPHA,        /* 0x1e3f */
    ALPHA,        /* 0x1e40 */
    ALPHA,        /* 0x1e41 */
    ALPHA,        /* 0x1e42 */
    ALPHA,        /* 0x1e43 */
    ALPHA,        /* 0x1e44 */
    ALPHA,        /* 0x1e45 */
    ALPHA,        /* 0x1e46 */
    ALPHA,        /* 0x1e47 */
    ALPHA,        /* 0x1e48 */
    ALPHA,        /* 0x1e49 */
    ALPHA,        /* 0x1e4a */
    ALPHA,        /* 0x1e4b */
    ALPHA,        /* 0x1e4c */
    ALPHA,        /* 0x1e4d */
    ALPHA,        /* 0x1e4e */
    ALPHA,        /* 0x1e4f */
    ALPHA,        /* 0x1e50 */
    ALPHA,        /* 0x1e51 */
    ALPHA,        /* 0x1e52 */
    ALPHA,        /* 0x1e53 */
    ALPHA,        /* 0x1e54 */
    ALPHA,        /* 0x1e55 */
    ALPHA,        /* 0x1e56 */
    ALPHA,        /* 0x1e57 */
    ALPHA,        /* 0x1e58 */
    ALPHA,        /* 0x1e59 */
    ALPHA,        /* 0x1e5a */
    ALPHA,        /* 0x1e5b */
    ALPHA,        /* 0x1e5c */
    ALPHA,        /* 0x1e5d */
    ALPHA,        /* 0x1e5e */
    ALPHA,        /* 0x1e5f */
    ALPHA,        /* 0x1e60 */
    ALPHA,        /* 0x1e61 */
    ALPHA,        /* 0x1e62 */
    ALPHA,        /* 0x1e63 */
    ALPHA,        /* 0x1e64 */
    ALPHA,        /* 0x1e65 */
    ALPHA,        /* 0x1e66 */
    ALPHA,        /* 0x1e67 */
    ALPHA,        /* 0x1e68 */
    ALPHA,        /* 0x1e69 */
    ALPHA,        /* 0x1e6a */
    ALPHA,        /* 0x1e6b */
    ALPHA,        /* 0x1e6c */
    ALPHA,        /* 0x1e6d */
    ALPHA,        /* 0x1e6e */
    ALPHA,        /* 0x1e6f */
    ALPHA,        /* 0x1e70 */
    ALPHA,        /* 0x1e71 */
    ALPHA,        /* 0x1e72 */
    ALPHA,        /* 0x1e73 */
    ALPHA,        /* 0x1e74 */
    ALPHA,        /* 0x1e75 */
    ALPHA,        /* 0x1e76 */
    ALPHA,        /* 0x1e77 */
    ALPHA,        /* 0x1e78 */
    ALPHA,        /* 0x1e79 */
    ALPHA,        /* 0x1e7a */
    ALPHA,        /* 0x1e7b */
    ALPHA,        /* 0x1e7c */
    ALPHA,        /* 0x1e7d */
    ALPHA,        /* 0x1e7e */
    ALPHA,        /* 0x1e7f */
    ALPHA,        /* 0x1e80 */
    ALPHA,        /* 0x1e81 */
    ALPHA,        /* 0x1e82 */
    ALPHA,        /* 0x1e83 */
    ALPHA,        /* 0x1e84 */
    ALPHA,        /* 0x1e85 */
    ALPHA,        /* 0x1e86 */
    ALPHA,        /* 0x1e87 */
    ALPHA,        /* 0x1e88 */
    ALPHA,        /* 0x1e89 */
    ALPHA,        /* 0x1e8a */
    ALPHA,        /* 0x1e8b */
    ALPHA,        /* 0x1e8c */
    ALPHA,        /* 0x1e8d */
    ALPHA,        /* 0x1e8e */
    ALPHA,        /* 0x1e8f */
    ALPHA,        /* 0x1e90 */
    ALPHA,        /* 0x1e91 */
    ALPHA,        /* 0x1e92 */
    ALPHA,        /* 0x1e93 */
    ALPHA,        /* 0x1e94 */
    ALPHA,        /* 0x1e95 */
    ALPHA,        /* 0x1e96 */
    ALPHA,        /* 0x1e97 */
    ALPHA,        /* 0x1e98 */
    ALPHA,        /* 0x1e99 */
    ALPHA,        /* 0x1e9a */
    ALPHA,        /* 0x1e9b */
    ALPHA,        /* 0x1e9c */
    ALPHA,        /* 0x1e9d */
    ALPHA,        /* 0x1e9e */
    ALPHA,        /* 0x1e9f */
    ALPHA,        /* 0x1ea0 */
    ALPHA,        /* 0x1ea1 */
    ALPHA,        /* 0x1ea2 */
    ALPHA,        /* 0x1ea3 */
    ALPHA,        /* 0x1ea4 */
    ALPHA,        /* 0x1ea5 */
    ALPHA,        /* 0x1ea6 */
    ALPHA,        /* 0x1ea7 */
    ALPHA,        /* 0x1ea8 */
    ALPHA,        /* 0x1ea9 */
    ALPHA,        /* 0x1eaa */
    ALPHA,        /* 0x1eab */
    ALPHA,        /* 0x1eac */
    ALPHA,        /* 0x1ead */
    ALPHA,        /* 0x1eae */
    ALPHA,        /* 0x1eaf */
    ALPHA,        /* 0x1eb0 */
    ALPHA,        /* 0x1eb1 */
    ALPHA,        /* 0x1eb2 */
    ALPHA,        /* 0x1eb3 */
    ALPHA,        /* 0x1eb4 */
    ALPHA,        /* 0x1eb5 */
    ALPHA,        /* 0x1eb6 */
    ALPHA,        /* 0x1eb7 */
    ALPHA,        /* 0x1eb8 */
    ALPHA,        /* 0x1eb9 */
    ALPHA,        /* 0x1eba */
    ALPHA,        /* 0x1ebb */
    ALPHA,        /* 0x1ebc */
    ALPHA,        /* 0x1ebd */
    ALPHA,        /* 0x1ebe */
    ALPHA,        /* 0x1ebf */
    ALPHA,        /* 0x1ec0 */
    ALPHA,        /* 0x1ec1 */
    ALPHA,        /* 0x1ec2 */
    ALPHA,        /* 0x1ec3 */
    ALPHA,        /* 0x1ec4 */
    ALPHA,        /* 0x1ec5 */
    ALPHA,        /* 0x1ec6 */
    ALPHA,        /* 0x1ec7 */
    ALPHA,        /* 0x1ec8 */
    ALPHA,        /* 0x1ec9 */
    ALPHA,        /* 0x1eca */
    ALPHA,        /* 0x1ecb */
    ALPHA,        /* 0x1ecc */
    ALPHA,        /* 0x1ecd */
    ALPHA,        /* 0x1ece */
    ALPHA,        /* 0x1ecf */
    ALPHA,        /* 0x1ed0 */
    ALPHA,        /* 0x1ed1 */
    ALPHA,        /* 0x1ed2 */
    ALPHA,        /* 0x1ed3 */
    ALPHA,        /* 0x1ed4 */
    ALPHA,        /* 0x1ed5 */
    ALPHA,        /* 0x1ed6 */
    ALPHA,        /* 0x1ed7 */
    ALPHA,        /* 0x1ed8 */
    ALPHA,        /* 0x1ed9 */
    ALPHA,        /* 0x1eda */
    ALPHA,        /* 0x1edb */
    ALPHA,        /* 0x1edc */
    ALPHA,        /* 0x1edd */
    ALPHA,        /* 0x1ede */
    ALPHA,        /* 0x1edf */
    ALPHA,        /* 0x1ee0 */
    ALPHA,        /* 0x1ee1 */
    ALPHA,        /* 0x1ee2 */
    ALPHA,        /* 0x1ee3 */
    ALPHA,        /* 0x1ee4 */
    ALPHA,        /* 0x1ee5 */
    ALPHA,        /* 0x1ee6 */
    ALPHA,        /* 0x1ee7 */
    ALPHA,        /* 0x1ee8 */
    ALPHA,        /* 0x1ee9 */
    ALPHA,        /* 0x1eea */
    ALPHA,        /* 0x1eeb */
    ALPHA,        /* 0x1eec */
    ALPHA,        /* 0x1eed */
    ALPHA,        /* 0x1eee */
    ALPHA,        /* 0x1eef */
    ALPHA,        /* 0x1ef0 */
    ALPHA,        /* 0x1ef1 */
    ALPHA,        /* 0x1ef2 */
    ALPHA,        /* 0x1ef3 */
    ALPHA,        /* 0x1ef4 */
    ALPHA,        /* 0x1ef5 */
    ALPHA,        /* 0x1ef6 */
    ALPHA,        /* 0x1ef7 */
    ALPHA,        /* 0x1ef8 */
    ALPHA,        /* 0x1ef9 */
    OTHER,        /* 0x1efa */
    OTHER,        /* 0x1efb */
    OTHER,        /* 0x1efc */
    OTHER,        /* 0x1efd */
    OTHER,        /* 0x1efe */
    OTHER,        /* 0x1eff */
    OTHER,        /* 0x1f00 */
    OTHER,        /* 0x1f01 */
    OTHER,        /* 0x1f02 */
    OTHER,        /* 0x1f03 */
    OTHER,        /* 0x1f04 */
    OTHER,        /* 0x1f05 */
    OTHER,        /* 0x1f06 */
    OTHER,        /* 0x1f07 */
    OTHER,        /* 0x1f08 */
    OTHER,        /* 0x1f09 */
    OTHER,        /* 0x1f0a */
    OTHER,        /* 0x1f0b */
    OTHER,        /* 0x1f0c */
    OTHER,        /* 0x1f0d */
    OTHER,        /* 0x1f0e */
    OTHER,        /* 0x1f0f */
    OTHER,        /* 0x1f10 */
    OTHER,        /* 0x1f11 */
    OTHER,        /* 0x1f12 */
    OTHER,        /* 0x1f13 */
    OTHER,        /* 0x1f14 */
    OTHER,        /* 0x1f15 */
    OTHER,        /* 0x1f16 */
    OTHER,        /* 0x1f17 */
    OTHER,        /* 0x1f18 */
    OTHER,        /* 0x1f19 */
    OTHER,        /* 0x1f1a */
    OTHER,        /* 0x1f1b */
    OTHER,        /* 0x1f1c */
    OTHER,        /* 0x1f1d */
    OTHER,        /* 0x1f1e */
    OTHER,        /* 0x1f1f */
    OTHER,        /* 0x1f20 */
    OTHER,        /* 0x1f21 */
    OTHER,        /* 0x1f22 */
    OTHER,        /* 0x1f23 */
    OTHER,        /* 0x1f24 */
    OTHER,        /* 0x1f25 */
    OTHER,        /* 0x1f26 */
    OTHER,        /* 0x1f27 */
    OTHER,        /* 0x1f28 */
    OTHER,        /* 0x1f29 */
    OTHER,        /* 0x1f2a */
    OTHER,        /* 0x1f2b */
    OTHER,        /* 0x1f2c */
    OTHER,        /* 0x1f2d */
    OTHER,        /* 0x1f2e */
    OTHER,        /* 0x1f2f */
    OTHER,        /* 0x1f30 */
    OTHER,        /* 0x1f31 */
    OTHER,        /* 0x1f32 */
    OTHER,        /* 0x1f33 */
    OTHER,        /* 0x1f34 */
    OTHER,        /* 0x1f35 */
    OTHER,        /* 0x1f36 */
    OTHER,        /* 0x1f37 */
    OTHER,        /* 0x1f38 */
    OTHER,        /* 0x1f39 */
    OTHER,        /* 0x1f3a */
    OTHER,        /* 0x1f3b */
    OTHER,        /* 0x1f3c */
    OTHER,        /* 0x1f3d */
    OTHER,        /* 0x1f3e */
    OTHER,        /* 0x1f3f */
    OTHER,        /* 0x1f40 */
    OTHER,        /* 0x1f41 */
    OTHER,        /* 0x1f42 */
    OTHER,        /* 0x1f43 */
    OTHER,        /* 0x1f44 */
    OTHER,        /* 0x1f45 */
    OTHER,        /* 0x1f46 */
    OTHER,        /* 0x1f47 */
    OTHER,        /* 0x1f48 */
    OTHER,        /* 0x1f49 */
    OTHER,        /* 0x1f4a */
    OTHER,        /* 0x1f4b */
    OTHER,        /* 0x1f4c */
    OTHER,        /* 0x1f4d */
    OTHER,        /* 0x1f4e */
    OTHER,        /* 0x1f4f */
    OTHER,        /* 0x1f50 */
    OTHER,        /* 0x1f51 */
    OTHER,        /* 0x1f52 */
    OTHER,        /* 0x1f53 */
    OTHER,        /* 0x1f54 */
    OTHER,        /* 0x1f55 */
    OTHER,        /* 0x1f56 */
    OTHER,        /* 0x1f57 */
    OTHER,        /* 0x1f58 */
    OTHER,        /* 0x1f59 */
    OTHER,        /* 0x1f5a */
    OTHER,        /* 0x1f5b */
    OTHER,        /* 0x1f5c */
    OTHER,        /* 0x1f5d */
    OTHER,        /* 0x1f5e */
    OTHER,        /* 0x1f5f */
    OTHER,        /* 0x1f60 */
    OTHER,        /* 0x1f61 */
    OTHER,        /* 0x1f62 */
    OTHER,        /* 0x1f63 */
    OTHER,        /* 0x1f64 */
    OTHER,        /* 0x1f65 */
    OTHER,        /* 0x1f66 */
    OTHER,        /* 0x1f67 */
    OTHER,        /* 0x1f68 */
    OTHER,        /* 0x1f69 */
    OTHER,        /* 0x1f6a */
    OTHER,        /* 0x1f6b */
    OTHER,        /* 0x1f6c */
    OTHER,        /* 0x1f6d */
    OTHER,        /* 0x1f6e */
    OTHER,        /* 0x1f6f */
    OTHER,        /* 0x1f70 */
    OTHER,        /* 0x1f71 */
    OTHER,        /* 0x1f72 */
    OTHER,        /* 0x1f73 */
    OTHER,        /* 0x1f74 */
    OTHER,        /* 0x1f75 */
    OTHER,        /* 0x1f76 */
    OTHER,        /* 0x1f77 */
    OTHER,        /* 0x1f78 */
    OTHER,        /* 0x1f79 */
    OTHER,        /* 0x1f7a */
    OTHER,        /* 0x1f7b */
    OTHER,        /* 0x1f7c */
    OTHER,        /* 0x1f7d */
    OTHER,        /* 0x1f7e */
    OTHER,        /* 0x1f7f */
    OTHER,        /* 0x1f80 */
    OTHER,        /* 0x1f81 */
    OTHER,        /* 0x1f82 */
    OTHER,        /* 0x1f83 */
    OTHER,        /* 0x1f84 */
    OTHER,        /* 0x1f85 */
    OTHER,        /* 0x1f86 */
    OTHER,        /* 0x1f87 */
    OTHER,        /* 0x1f88 */
    OTHER,        /* 0x1f89 */
    OTHER,        /* 0x1f8a */
    OTHER,        /* 0x1f8b */
    OTHER,        /* 0x1f8c */
    OTHER,        /* 0x1f8d */
    OTHER,        /* 0x1f8e */
    OTHER,        /* 0x1f8f */
    OTHER,        /* 0x1f90 */
    OTHER,        /* 0x1f91 */
    OTHER,        /* 0x1f92 */
    OTHER,        /* 0x1f93 */
    OTHER,        /* 0x1f94 */
    OTHER,        /* 0x1f95 */
    OTHER,        /* 0x1f96 */
    OTHER,        /* 0x1f97 */
    OTHER,        /* 0x1f98 */
    OTHER,        /* 0x1f99 */
    OTHER,        /* 0x1f9a */
    OTHER,        /* 0x1f9b */
    OTHER,        /* 0x1f9c */
    OTHER,        /* 0x1f9d */
    OTHER,        /* 0x1f9e */
    OTHER,        /* 0x1f9f */
    OTHER,        /* 0x1fa0 */
    OTHER,        /* 0x1fa1 */
    OTHER,        /* 0x1fa2 */
    OTHER,        /* 0x1fa3 */
    OTHER,        /* 0x1fa4 */
    OTHER,        /* 0x1fa5 */
    OTHER,        /* 0x1fa6 */
    OTHER,        /* 0x1fa7 */
    OTHER,        /* 0x1fa8 */
    OTHER,        /* 0x1fa9 */
    OTHER,        /* 0x1faa */
    OTHER,        /* 0x1fab */
    OTHER,        /* 0x1fac */
    OTHER,        /* 0x1fad */
    OTHER,        /* 0x1fae */
    OTHER,        /* 0x1faf */
    OTHER,        /* 0x1fb0 */
    OTHER,        /* 0x1fb1 */
    OTHER,        /* 0x1fb2 */
    OTHER,        /* 0x1fb3 */
    OTHER,        /* 0x1fb4 */
    OTHER,        /* 0x1fb5 */
    OTHER,        /* 0x1fb6 */
    OTHER,        /* 0x1fb7 */
    OTHER,        /* 0x1fb8 */
    OTHER,        /* 0x1fb9 */
    OTHER,        /* 0x1fba */
    OTHER,        /* 0x1fbb */
    OTHER,        /* 0x1fbc */
    OTHER,        /* 0x1fbd */
    OTHER,        /* 0x1fbe */
    OTHER,        /* 0x1fbf */
    OTHER,        /* 0x1fc0 */
    OTHER,        /* 0x1fc1 */
    OTHER,        /* 0x1fc2 */
    OTHER,        /* 0x1fc3 */
    OTHER,        /* 0x1fc4 */
    OTHER,        /* 0x1fc5 */
    OTHER,        /* 0x1fc6 */
    OTHER,        /* 0x1fc7 */
    OTHER,        /* 0x1fc8 */
    OTHER,        /* 0x1fc9 */
    OTHER,        /* 0x1fca */
    OTHER,        /* 0x1fcb */
    OTHER,        /* 0x1fcc */
    OTHER,        /* 0x1fcd */
    OTHER,        /* 0x1fce */
    OTHER,        /* 0x1fcf */
    OTHER,        /* 0x1fd0 */
    OTHER,        /* 0x1fd1 */
    OTHER,        /* 0x1fd2 */
    OTHER,        /* 0x1fd3 */
    OTHER,        /* 0x1fd4 */
    OTHER,        /* 0x1fd5 */
    OTHER,        /* 0x1fd6 */
    OTHER,        /* 0x1fd7 */
    OTHER,        /* 0x1fd8 */
    OTHER,        /* 0x1fd9 */
    OTHER,        /* 0x1fda */
    OTHER,        /* 0x1fdb */
    OTHER,        /* 0x1fdc */
    OTHER,        /* 0x1fdd */
    OTHER,        /* 0x1fde */
    OTHER,        /* 0x1fdf */
    OTHER,        /* 0x1fe0 */
    OTHER,        /* 0x1fe1 */
    OTHER,        /* 0x1fe2 */
    OTHER,        /* 0x1fe3 */
    OTHER,        /* 0x1fe4 */
    OTHER,        /* 0x1fe5 */
    OTHER,        /* 0x1fe6 */
    OTHER,        /* 0x1fe7 */
    OTHER,        /* 0x1fe8 */
    OTHER,        /* 0x1fe9 */
    OTHER,        /* 0x1fea */
    OTHER,        /* 0x1feb */
    OTHER,        /* 0x1fec */
    OTHER,        /* 0x1fed */
    OTHER,        /* 0x1fee */
    OTHER,        /* 0x1fef */
    OTHER,        /* 0x1ff0 */
    OTHER,        /* 0x1ff1 */
    OTHER,        /* 0x1ff2 */
    OTHER,        /* 0x1ff3 */
    OTHER,        /* 0x1ff4 */
    OTHER,        /* 0x1ff5 */
    OTHER,        /* 0x1ff6 */
    OTHER,        /* 0x1ff7 */
    OTHER,        /* 0x1ff8 */
    OTHER,        /* 0x1ff9 */
    OTHER,        /* 0x1ffa */
    OTHER,        /* 0x1ffb */
    OTHER,        /* 0x1ffc */
    OTHER,        /* 0x1ffd */
    OTHER,        /* 0x1ffe */
    OTHER,        /* 0x1fff */
    SYMBOL,        /* 0x2000 */
    SYMBOL,        /* 0x2001 */
    SYMBOL,        /* 0x2002 */
    SYMBOL,        /* 0x2003 */
    SYMBOL,        /* 0x2004 */
    SYMBOL,        /* 0x2005 */
    SYMBOL,        /* 0x2006 */
    SYMBOL,        /* 0x2007 */
    SYMBOL,        /* 0x2008 */
    SYMBOL,        /* 0x2009 */
    SYMBOL,        /* 0x200a */
    SYMBOL,        /* 0x200b */
    SYMBOL,        /* 0x200c */
    SYMBOL,        /* 0x200d */
    SYMBOL,        /* 0x200e */
    SYMBOL,        /* 0x200f */
    SYMBOL,        /* 0x2010 */
    SYMBOL,        /* 0x2011 */
    SYMBOL,        /* 0x2012 */
    SYMBOL,        /* 0x2013 */
    SYMBOL,        /* 0x2014 */
    SYMBOL,        /* 0x2015 */
    SYMBOL,        /* 0x2016 */
    SYMBOL,        /* 0x2017 */
    SYMBOL,        /* 0x2018 */
    SYMBOL,        /* 0x2019 */
    SYMBOL,        /* 0x201a */
    SYMBOL,        /* 0x201b */
    SYMBOL,        /* 0x201c */
    SYMBOL,        /* 0x201d */
    SYMBOL,        /* 0x201e */
    SYMBOL,        /* 0x201f */
    SYMBOL,        /* 0x2020 */
    SYMBOL,        /* 0x2021 */
    SYMBOL,        /* 0x2022 */
    SYMBOL,        /* 0x2023 */
    SYMBOL,        /* 0x2024 */
    SYMBOL,        /* 0x2025 */
    SYMBOL,        /* 0x2026 */
    SYMBOL,        /* 0x2027 */
    SYMBOL,        /* 0x2028 */
    SYMBOL,        /* 0x2029 */
    SYMBOL,        /* 0x202a */
    SYMBOL,        /* 0x202b */
    SYMBOL,        /* 0x202c */
    SYMBOL,        /* 0x202d */
    SYMBOL,        /* 0x202e */
    SYMBOL,        /* 0x202f */
    SYMBOL,        /* 0x2030 */
    SYMBOL,        /* 0x2031 */
    SYMBOL,        /* 0x2032 */
    SYMBOL,        /* 0x2033 */
    SYMBOL,        /* 0x2034 */
    SYMBOL,        /* 0x2035 */
    SYMBOL,        /* 0x2036 */
    SYMBOL,        /* 0x2037 */
    SYMBOL,        /* 0x2038 */
    SYMBOL,        /* 0x2039 */
    SYMBOL,        /* 0x203a */
    SYMBOL,        /* 0x203b */
    SYMBOL,        /* 0x203c */
    SYMBOL,        /* 0x203d */
    SYMBOL,        /* 0x203e */
    SYMBOL,        /* 0x203f */
    SYMBOL,        /* 0x2040 */
    SYMBOL,        /* 0x2041 */
    SYMBOL,        /* 0x2042 */
    SYMBOL,        /* 0x2043 */
    SYMBOL,        /* 0x2044 */
    SYMBOL,        /* 0x2045 */
    SYMBOL,        /* 0x2046 */
    SYMBOL,        /* 0x2047 */
    SYMBOL,        /* 0x2048 */
    SYMBOL,        /* 0x2049 */
    SYMBOL,        /* 0x204a */
    SYMBOL,        /* 0x204b */
    SYMBOL,        /* 0x204c */
    SYMBOL,        /* 0x204d */
    SYMBOL,        /* 0x204e */
    SYMBOL,        /* 0x204f */
    SYMBOL,        /* 0x2050 */
    SYMBOL,        /* 0x2051 */
    SYMBOL,        /* 0x2052 */
    SYMBOL,        /* 0x2053 */
    SYMBOL,        /* 0x2054 */
    SYMBOL,        /* 0x2055 */
    SYMBOL,        /* 0x2056 */
    SYMBOL,        /* 0x2057 */
    SYMBOL,        /* 0x2058 */
    SYMBOL,        /* 0x2059 */
    SYMBOL,        /* 0x205a */
    SYMBOL,        /* 0x205b */
    SYMBOL,        /* 0x205c */
    SYMBOL,        /* 0x205d */
    SYMBOL,        /* 0x205e */
    SYMBOL,        /* 0x205f */
    SYMBOL,        /* 0x2060 */
    SYMBOL,        /* 0x2061 */
    SYMBOL,        /* 0x2062 */
    SYMBOL,        /* 0x2063 */
    SYMBOL,        /* 0x2064 */
    SYMBOL,        /* 0x2065 */
    SYMBOL,        /* 0x2066 */
    SYMBOL,        /* 0x2067 */
    SYMBOL,        /* 0x2068 */
    SYMBOL,        /* 0x2069 */
    SYMBOL,        /* 0x206a */
    SYMBOL,        /* 0x206b */
    SYMBOL,        /* 0x206c */
    SYMBOL,        /* 0x206d */
    SYMBOL,        /* 0x206e */
    SYMBOL,        /* 0x206f */
    ALPHANUMERIC,        /* 0x2070 */
    ALPHANUMERIC,        /* 0x2071 */
    ALPHANUMERIC,        /* 0x2072 */
    ALPHANUMERIC,        /* 0x2073 */
    ALPHANUMERIC,        /* 0x2074 */
    ALPHANUMERIC,        /* 0x2075 */
    ALPHANUMERIC,        /* 0x2076 */
    ALPHANUMERIC,        /* 0x2077 */
    ALPHANUMERIC,        /* 0x2078 */
    ALPHANUMERIC,        /* 0x2079 */
    ALPHANUMERIC,        /* 0x207a */
    ALPHANUMERIC,        /* 0x207b */
    ALPHANUMERIC,        /* 0x207c */
    ALPHANUMERIC,        /* 0x207d */
    ALPHANUMERIC,        /* 0x207e */
    ALPHANUMERIC,        /* 0x207f */
    ALPHANUMERIC,        /* 0x2080 */
    ALPHANUMERIC,        /* 0x2081 */
    ALPHANUMERIC,        /* 0x2082 */
    ALPHANUMERIC,        /* 0x2083 */
    ALPHANUMERIC,        /* 0x2084 */
    ALPHANUMERIC,        /* 0x2085 */
    ALPHANUMERIC,        /* 0x2086 */
    ALPHANUMERIC,        /* 0x2087 */
    ALPHANUMERIC,        /* 0x2088 */
    ALPHANUMERIC,        /* 0x2089 */
    ALPHANUMERIC,        /* 0x208a */
    ALPHANUMERIC,        /* 0x208b */
    ALPHANUMERIC,        /* 0x208c */
    ALPHANUMERIC,        /* 0x208d */
    ALPHANUMERIC,        /* 0x208e */
    ALPHANUMERIC,        /* 0x208f */
    ALPHANUMERIC,        /* 0x2090 */
    ALPHANUMERIC,        /* 0x2091 */
    ALPHANUMERIC,        /* 0x2092 */
    ALPHANUMERIC,        /* 0x2093 */
    ALPHANUMERIC,        /* 0x2094 */
    ALPHANUMERIC,        /* 0x2095 */
    ALPHANUMERIC,        /* 0x2096 */
    ALPHANUMERIC,        /* 0x2097 */
    ALPHANUMERIC,        /* 0x2098 */
    ALPHANUMERIC,        /* 0x2099 */
    ALPHANUMERIC,        /* 0x209a */
    ALPHANUMERIC,        /* 0x209b */
    ALPHANUMERIC,        /* 0x209c */
    ALPHANUMERIC,        /* 0x209d */
    ALPHANUMERIC,        /* 0x209e */
    ALPHANUMERIC,        /* 0x209f */
    SYMBOL,        /* 0x20a0 */
    SYMBOL,        /* 0x20a1 */
    SYMBOL,        /* 0x20a2 */
    SYMBOL,        /* 0x20a3 */
    SYMBOL,        /* 0x20a4 */
    SYMBOL,        /* 0x20a5 */
    SYMBOL,        /* 0x20a6 */
    SYMBOL,        /* 0x20a7 */
    SYMBOL,        /* 0x20a8 */
    SYMBOL,        /* 0x20a9 */
    SYMBOL,        /* 0x20aa */
    SYMBOL,        /* 0x20ab */
    SYMBOL,        /* 0x20ac */
    SYMBOL,        /* 0x20ad */
    SYMBOL,        /* 0x20ae */
    SYMBOL,        /* 0x20af */
    SYMBOL,        /* 0x20b0 */
    SYMBOL,        /* 0x20b1 */
    SYMBOL,        /* 0x20b2 */
    SYMBOL,        /* 0x20b3 */
    SYMBOL,        /* 0x20b4 */
    SYMBOL,        /* 0x20b5 */
    SYMBOL,        /* 0x20b6 */
    SYMBOL,        /* 0x20b7 */
    SYMBOL,        /* 0x20b8 */
    SYMBOL,        /* 0x20b9 */
    SYMBOL,        /* 0x20ba */
    SYMBOL,        /* 0x20bb */
    SYMBOL,        /* 0x20bc */
    SYMBOL,        /* 0x20bd */
    SYMBOL,        /* 0x20be */
    SYMBOL,        /* 0x20bf */
    SYMBOL,        /* 0x20c0 */
    SYMBOL,        /* 0x20c1 */
    SYMBOL,        /* 0x20c2 */
    SYMBOL,        /* 0x20c3 */
    SYMBOL,        /* 0x20c4 */
    SYMBOL,        /* 0x20c5 */
    SYMBOL,        /* 0x20c6 */
    SYMBOL,        /* 0x20c7 */
    SYMBOL,        /* 0x20c8 */
    SYMBOL,        /* 0x20c9 */
    SYMBOL,        /* 0x20ca */
    SYMBOL,        /* 0x20cb */
    SYMBOL,        /* 0x20cc */
    SYMBOL,        /* 0x20cd */
    SYMBOL,        /* 0x20ce */
    SYMBOL,        /* 0x20cf */
    SYMBOL,        /* 0x20d0 */
    SYMBOL,        /* 0x20d1 */
    SYMBOL,        /* 0x20d2 */
    SYMBOL,        /* 0x20d3 */
    SYMBOL,        /* 0x20d4 */
    SYMBOL,        /* 0x20d5 */
    SYMBOL,        /* 0x20d6 */
    SYMBOL,        /* 0x20d7 */
    SYMBOL,        /* 0x20d8 */
    SYMBOL,        /* 0x20d9 */
    SYMBOL,        /* 0x20da */
    SYMBOL,        /* 0x20db */
    SYMBOL,        /* 0x20dc */
    SYMBOL,        /* 0x20dd */
    SYMBOL,        /* 0x20de */
    SYMBOL,        /* 0x20df */
    SYMBOL,        /* 0x20e0 */
    SYMBOL,        /* 0x20e1 */
    SYMBOL,        /* 0x20e2 */
    SYMBOL,        /* 0x20e3 */
    SYMBOL,        /* 0x20e4 */
    SYMBOL,        /* 0x20e5 */
    SYMBOL,        /* 0x20e6 */
    SYMBOL,        /* 0x20e7 */
    SYMBOL,        /* 0x20e8 */
    SYMBOL,        /* 0x20e9 */
    SYMBOL,        /* 0x20ea */
    SYMBOL,        /* 0x20eb */
    SYMBOL,        /* 0x20ec */
    SYMBOL,        /* 0x20ed */
    SYMBOL,        /* 0x20ee */
    SYMBOL,        /* 0x20ef */
    SYMBOL,        /* 0x20f0 */
    SYMBOL,        /* 0x20f1 */
    SYMBOL,        /* 0x20f2 */
    SYMBOL,        /* 0x20f3 */
    SYMBOL,        /* 0x20f4 */
    SYMBOL,        /* 0x20f5 */
    SYMBOL,        /* 0x20f6 */
    SYMBOL,        /* 0x20f7 */
    SYMBOL,        /* 0x20f8 */
    SYMBOL,        /* 0x20f9 */
    SYMBOL,        /* 0x20fa */
    SYMBOL,        /* 0x20fb */
    SYMBOL,        /* 0x20fc */
    SYMBOL,        /* 0x20fd */
    SYMBOL,        /* 0x20fe */
    SYMBOL,        /* 0x20ff */
    SYMBOL,        /* 0x2100 */
    SYMBOL,        /* 0x2101 */
    SYMBOL,        /* 0x2102 */
    SYMBOL,        /* 0x2103 */
    SYMBOL,        /* 0x2104 */
    SYMBOL,        /* 0x2105 */
    SYMBOL,        /* 0x2106 */
    SYMBOL,        /* 0x2107 */
    SYMBOL,        /* 0x2108 */
    SYMBOL,        /* 0x2109 */
    SYMBOL,        /* 0x210a */
    SYMBOL,        /* 0x210b */
    SYMBOL,        /* 0x210c */
    SYMBOL,        /* 0x210d */
    SYMBOL,        /* 0x210e */
    SYMBOL,        /* 0x210f */
    SYMBOL,        /* 0x2110 */
    SYMBOL,        /* 0x2111 */
    SYMBOL,        /* 0x2112 */
    SYMBOL,        /* 0x2113 */
    SYMBOL,        /* 0x2114 */
    SYMBOL,        /* 0x2115 */
    SYMBOL,        /* 0x2116 */
    SYMBOL,        /* 0x2117 */
    SYMBOL,        /* 0x2118 */
    SYMBOL,        /* 0x2119 */
    SYMBOL,        /* 0x211a */
    SYMBOL,        /* 0x211b */
    SYMBOL,        /* 0x211c */
    SYMBOL,        /* 0x211d */
    SYMBOL,        /* 0x211e */
    SYMBOL,        /* 0x211f */
    SYMBOL,        /* 0x2120 */
    SYMBOL,        /* 0x2121 */
    SYMBOL,        /* 0x2122 */
    SYMBOL,        /* 0x2123 */
    SYMBOL,        /* 0x2124 */
    SYMBOL,        /* 0x2125 */
    SYMBOL,        /* 0x2126 */
    SYMBOL,        /* 0x2127 */
    SYMBOL,        /* 0x2128 */
    SYMBOL,        /* 0x2129 */
    SYMBOL,        /* 0x212a */
    SYMBOL,        /* 0x212b */
    SYMBOL,        /* 0x212c */
    SYMBOL,        /* 0x212d */
    SYMBOL,        /* 0x212e */
    SYMBOL,        /* 0x212f */
    SYMBOL,        /* 0x2130 */
    SYMBOL,        /* 0x2131 */
    SYMBOL,        /* 0x2132 */
    SYMBOL,        /* 0x2133 */
    SYMBOL,        /* 0x2134 */
    SYMBOL,        /* 0x2135 */
    SYMBOL,        /* 0x2136 */
    SYMBOL,        /* 0x2137 */
    SYMBOL,        /* 0x2138 */
    SYMBOL,        /* 0x2139 */
    SYMBOL,        /* 0x213a */
    SYMBOL,        /* 0x213b */
    SYMBOL,        /* 0x213c */
    SYMBOL,        /* 0x213d */
    SYMBOL,        /* 0x213e */
    SYMBOL,        /* 0x213f */
    SYMBOL,        /* 0x2140 */
    SYMBOL,        /* 0x2141 */
    SYMBOL,        /* 0x2142 */
    SYMBOL,        /* 0x2143 */
    SYMBOL,        /* 0x2144 */
    SYMBOL,        /* 0x2145 */
    SYMBOL,        /* 0x2146 */
    SYMBOL,        /* 0x2147 */
    SYMBOL,        /* 0x2148 */
    SYMBOL,        /* 0x2149 */
    SYMBOL,        /* 0x214a */
    SYMBOL,        /* 0x214b */
    SYMBOL,        /* 0x214c */
    SYMBOL,        /* 0x214d */
    SYMBOL,        /* 0x214e */
    SYMBOL,        /* 0x214f */
    ALPHANUMERIC,        /* 0x2150 */
    ALPHANUMERIC,        /* 0x2151 */
    ALPHANUMERIC,        /* 0x2152 */
    ALPHANUMERIC,        /* 0x2153 */
    ALPHANUMERIC,        /* 0x2154 */
    ALPHANUMERIC,        /* 0x2155 */
    ALPHANUMERIC,        /* 0x2156 */
    ALPHANUMERIC,        /* 0x2157 */
    ALPHANUMERIC,        /* 0x2158 */
    ALPHANUMERIC,        /* 0x2159 */
    ALPHANUMERIC,        /* 0x215a */
    ALPHANUMERIC,        /* 0x215b */
    ALPHANUMERIC,        /* 0x215c */
    ALPHANUMERIC,        /* 0x215d */
    ALPHANUMERIC,        /* 0x215e */
    ALPHANUMERIC,        /* 0x215f */
    ALPHANUMERIC,        /* 0x2160 */
    ALPHANUMERIC,        /* 0x2161 */
    ALPHANUMERIC,        /* 0x2162 */
    ALPHANUMERIC,        /* 0x2163 */
    ALPHANUMERIC,        /* 0x2164 */
    ALPHANUMERIC,        /* 0x2165 */
    ALPHANUMERIC,        /* 0x2166 */
    ALPHANUMERIC,        /* 0x2167 */
    ALPHANUMERIC,        /* 0x2168 */
    ALPHANUMERIC,        /* 0x2169 */
    ALPHANUMERIC,        /* 0x216a */
    ALPHANUMERIC,        /* 0x216b */
    ALPHANUMERIC,        /* 0x216c */
    ALPHANUMERIC,        /* 0x216d */
    ALPHANUMERIC,        /* 0x216e */
    ALPHANUMERIC,        /* 0x216f */
    ALPHANUMERIC,        /* 0x2170 */
    ALPHANUMERIC,        /* 0x2171 */
    ALPHANUMERIC,        /* 0x2172 */
    ALPHANUMERIC,        /* 0x2173 */
    ALPHANUMERIC,        /* 0x2174 */
    ALPHANUMERIC,        /* 0x2175 */
    ALPHANUMERIC,        /* 0x2176 */
    ALPHANUMERIC,        /* 0x2177 */
    ALPHANUMERIC,        /* 0x2178 */
    ALPHANUMERIC,        /* 0x2179 */
    ALPHANUMERIC,        /* 0x217a */
    ALPHANUMERIC,        /* 0x217b */
    ALPHANUMERIC,        /* 0x217c */
    ALPHANUMERIC,        /* 0x217d */
    ALPHANUMERIC,        /* 0x217e */
    ALPHANUMERIC,        /* 0x217f */
    ALPHANUMERIC,        /* 0x2180 */
    ALPHANUMERIC,        /* 0x2181 */
    ALPHANUMERIC,        /* 0x2182 */
    ALPHANUMERIC,        /* 0x2183 */
    ALPHANUMERIC,        /* 0x2184 */
    ALPHANUMERIC,        /* 0x2185 */
    ALPHANUMERIC,        /* 0x2186 */
    ALPHANUMERIC,        /* 0x2187 */
    ALPHANUMERIC,        /* 0x2188 */
    ALPHANUMERIC,        /* 0x2189 */
    ALPHANUMERIC,        /* 0x218a */
    ALPHANUMERIC,        /* 0x218b */
    ALPHANUMERIC,        /* 0x218c */
    ALPHANUMERIC,        /* 0x218d */
    ALPHANUMERIC,        /* 0x218e */
    ALPHANUMERIC,        /* 0x218f */
    SYMBOL,        /* 0x2190 */
    SYMBOL,        /* 0x2191 */
    SYMBOL,        /* 0x2192 */
    SYMBOL,        /* 0x2193 */
    SYMBOL,        /* 0x2194 */
    SYMBOL,        /* 0x2195 */
    SYMBOL,        /* 0x2196 */
    SYMBOL,        /* 0x2197 */
    SYMBOL,        /* 0x2198 */
    SYMBOL,        /* 0x2199 */
    SYMBOL,        /* 0x219a */
    SYMBOL,        /* 0x219b */
    SYMBOL,        /* 0x219c */
    SYMBOL,        /* 0x219d */
    SYMBOL,        /* 0x219e */
    SYMBOL,        /* 0x219f */
    SYMBOL,        /* 0x21a0 */
    SYMBOL,        /* 0x21a1 */
    SYMBOL,        /* 0x21a2 */
    SYMBOL,        /* 0x21a3 */
    SYMBOL,        /* 0x21a4 */
    SYMBOL,        /* 0x21a5 */
    SYMBOL,        /* 0x21a6 */
    SYMBOL,        /* 0x21a7 */
    SYMBOL,        /* 0x21a8 */
    SYMBOL,        /* 0x21a9 */
    SYMBOL,        /* 0x21aa */
    SYMBOL,        /* 0x21ab */
    SYMBOL,        /* 0x21ac */
    SYMBOL,        /* 0x21ad */
    SYMBOL,        /* 0x21ae */
    SYMBOL,        /* 0x21af */
    SYMBOL,        /* 0x21b0 */
    SYMBOL,        /* 0x21b1 */
    SYMBOL,        /* 0x21b2 */
    SYMBOL,        /* 0x21b3 */
    SYMBOL,        /* 0x21b4 */
    SYMBOL,        /* 0x21b5 */
    SYMBOL,        /* 0x21b6 */
    SYMBOL,        /* 0x21b7 */
    SYMBOL,        /* 0x21b8 */
    SYMBOL,        /* 0x21b9 */
    SYMBOL,        /* 0x21ba */
    SYMBOL,        /* 0x21bb */
    SYMBOL,        /* 0x21bc */
    SYMBOL,        /* 0x21bd */
    SYMBOL,        /* 0x21be */
    SYMBOL,        /* 0x21bf */
    SYMBOL,        /* 0x21c0 */
    SYMBOL,        /* 0x21c1 */
    SYMBOL,        /* 0x21c2 */
    SYMBOL,        /* 0x21c3 */
    SYMBOL,        /* 0x21c4 */
    SYMBOL,        /* 0x21c5 */
    SYMBOL,        /* 0x21c6 */
    SYMBOL,        /* 0x21c7 */
    SYMBOL,        /* 0x21c8 */
    SYMBOL,        /* 0x21c9 */
    SYMBOL,        /* 0x21ca */
    SYMBOL,        /* 0x21cb */
    SYMBOL,        /* 0x21cc */
    SYMBOL,        /* 0x21cd */
    SYMBOL,        /* 0x21ce */
    SYMBOL,        /* 0x21cf */
    SYMBOL,        /* 0x21d0 */
    SYMBOL,        /* 0x21d1 */
    SYMBOL,        /* 0x21d2 */
    SYMBOL,        /* 0x21d3 */
    SYMBOL,        /* 0x21d4 */
    SYMBOL,        /* 0x21d5 */
    SYMBOL,        /* 0x21d6 */
    SYMBOL,        /* 0x21d7 */
    SYMBOL,        /* 0x21d8 */
    SYMBOL,        /* 0x21d9 */
    SYMBOL,        /* 0x21da */
    SYMBOL,        /* 0x21db */
    SYMBOL,        /* 0x21dc */
    SYMBOL,        /* 0x21dd */
    SYMBOL,        /* 0x21de */
    SYMBOL,        /* 0x21df */
    SYMBOL,        /* 0x21e0 */
    SYMBOL,        /* 0x21e1 */
    SYMBOL,        /* 0x21e2 */
    SYMBOL,        /* 0x21e3 */
    SYMBOL,        /* 0x21e4 */
    SYMBOL,        /* 0x21e5 */
    SYMBOL,        /* 0x21e6 */
    SYMBOL,        /* 0x21e7 */
    SYMBOL,        /* 0x21e8 */
    SYMBOL,        /* 0x21e9 */
    SYMBOL,        /* 0x21ea */
    SYMBOL,        /* 0x21eb */
    SYMBOL,        /* 0x21ec */
    SYMBOL,        /* 0x21ed */
    SYMBOL,        /* 0x21ee */
    SYMBOL,        /* 0x21ef */
    SYMBOL,        /* 0x21f0 */
    SYMBOL,        /* 0x21f1 */
    SYMBOL,        /* 0x21f2 */
    SYMBOL,        /* 0x21f3 */
    SYMBOL,        /* 0x21f4 */
    SYMBOL,        /* 0x21f5 */
    SYMBOL,        /* 0x21f6 */
    SYMBOL,        /* 0x21f7 */
    SYMBOL,        /* 0x21f8 */
    SYMBOL,        /* 0x21f9 */
    SYMBOL,        /* 0x21fa */
    SYMBOL,        /* 0x21fb */
    SYMBOL,        /* 0x21fc */
    SYMBOL,        /* 0x21fd */
    SYMBOL,        /* 0x21fe */
    SYMBOL,        /* 0x21ff */
    SYMBOL,        /* 0x2200 */
    SYMBOL,        /* 0x2201 */
    SYMBOL,        /* 0x2202 */
    SYMBOL,        /* 0x2203 */
    SYMBOL,        /* 0x2204 */
    SYMBOL,        /* 0x2205 */
    SYMBOL,        /* 0x2206 */
    SYMBOL,        /* 0x2207 */
    SYMBOL,        /* 0x2208 */
    SYMBOL,        /* 0x2209 */
    SYMBOL,        /* 0x220a */
    SYMBOL,        /* 0x220b */
    SYMBOL,        /* 0x220c */
    SYMBOL,        /* 0x220d */
    SYMBOL,        /* 0x220e */
    SYMBOL,        /* 0x220f */
    SYMBOL,        /* 0x2210 */
    SYMBOL,        /* 0x2211 */
    SYMBOL,        /* 0x2212 */
    SYMBOL,        /* 0x2213 */
    SYMBOL,        /* 0x2214 */
    SYMBOL,        /* 0x2215 */
    SYMBOL,        /* 0x2216 */
    SYMBOL,        /* 0x2217 */
    SYMBOL,        /* 0x2218 */
    SYMBOL,        /* 0x2219 */
    SYMBOL,        /* 0x221a */
    SYMBOL,        /* 0x221b */
    SYMBOL,        /* 0x221c */
    SYMBOL,        /* 0x221d */
    SYMBOL,        /* 0x221e */
    SYMBOL,        /* 0x221f */
    SYMBOL,        /* 0x2220 */
    SYMBOL,        /* 0x2221 */
    SYMBOL,        /* 0x2222 */
    SYMBOL,        /* 0x2223 */
    SYMBOL,        /* 0x2224 */
    SYMBOL,        /* 0x2225 */
    SYMBOL,        /* 0x2226 */
    SYMBOL,        /* 0x2227 */
    SYMBOL,        /* 0x2228 */
    SYMBOL,        /* 0x2229 */
    SYMBOL,        /* 0x222a */
    SYMBOL,        /* 0x222b */
    SYMBOL,        /* 0x222c */
    SYMBOL,        /* 0x222d */
    SYMBOL,        /* 0x222e */
    SYMBOL,        /* 0x222f */
    SYMBOL,        /* 0x2230 */
    SYMBOL,        /* 0x2231 */
    SYMBOL,        /* 0x2232 */
    SYMBOL,        /* 0x2233 */
    SYMBOL,        /* 0x2234 */
    SYMBOL,        /* 0x2235 */
    SYMBOL,        /* 0x2236 */
    SYMBOL,        /* 0x2237 */
    SYMBOL,        /* 0x2238 */
    SYMBOL,        /* 0x2239 */
    SYMBOL,        /* 0x223a */
    SYMBOL,        /* 0x223b */
    SYMBOL,        /* 0x223c */
    SYMBOL,        /* 0x223d */
    SYMBOL,        /* 0x223e */
    SYMBOL,        /* 0x223f */
    SYMBOL,        /* 0x2240 */
    SYMBOL,        /* 0x2241 */
    SYMBOL,        /* 0x2242 */
    SYMBOL,        /* 0x2243 */
    SYMBOL,        /* 0x2244 */
    SYMBOL,        /* 0x2245 */
    SYMBOL,        /* 0x2246 */
    SYMBOL,        /* 0x2247 */
    SYMBOL,        /* 0x2248 */
    SYMBOL,        /* 0x2249 */
    SYMBOL,        /* 0x224a */
    SYMBOL,        /* 0x224b */
    SYMBOL,        /* 0x224c */
    SYMBOL,        /* 0x224d */
    SYMBOL,        /* 0x224e */
    SYMBOL,        /* 0x224f */
    SYMBOL,        /* 0x2250 */
    SYMBOL,        /* 0x2251 */
    SYMBOL,        /* 0x2252 */
    SYMBOL,        /* 0x2253 */
    SYMBOL,        /* 0x2254 */
    SYMBOL,        /* 0x2255 */
    SYMBOL,        /* 0x2256 */
    SYMBOL,        /* 0x2257 */
    SYMBOL,        /* 0x2258 */
    SYMBOL,        /* 0x2259 */
    SYMBOL,        /* 0x225a */
    SYMBOL,        /* 0x225b */
    SYMBOL,        /* 0x225c */
    SYMBOL,        /* 0x225d */
    SYMBOL,        /* 0x225e */
    SYMBOL,        /* 0x225f */
    SYMBOL,        /* 0x2260 */
    SYMBOL,        /* 0x2261 */
    SYMBOL,        /* 0x2262 */
    SYMBOL,        /* 0x2263 */
    SYMBOL,        /* 0x2264 */
    SYMBOL,        /* 0x2265 */
    SYMBOL,        /* 0x2266 */
    SYMBOL,        /* 0x2267 */
    SYMBOL,        /* 0x2268 */
    SYMBOL,        /* 0x2269 */
    SYMBOL,        /* 0x226a */
    SYMBOL,        /* 0x226b */
    SYMBOL,        /* 0x226c */
    SYMBOL,        /* 0x226d */
    SYMBOL,        /* 0x226e */
    SYMBOL,        /* 0x226f */
    SYMBOL,        /* 0x2270 */
    SYMBOL,        /* 0x2271 */
    SYMBOL,        /* 0x2272 */
    SYMBOL,        /* 0x2273 */
    SYMBOL,        /* 0x2274 */
    SYMBOL,        /* 0x2275 */
    SYMBOL,        /* 0x2276 */
    SYMBOL,        /* 0x2277 */
    SYMBOL,        /* 0x2278 */
    SYMBOL,        /* 0x2279 */
    SYMBOL,        /* 0x227a */
    SYMBOL,        /* 0x227b */
    SYMBOL,        /* 0x227c */
    SYMBOL,        /* 0x227d */
    SYMBOL,        /* 0x227e */
    SYMBOL,        /* 0x227f */
    SYMBOL,        /* 0x2280 */
    SYMBOL,        /* 0x2281 */
    SYMBOL,        /* 0x2282 */
    SYMBOL,        /* 0x2283 */
    SYMBOL,        /* 0x2284 */
    SYMBOL,        /* 0x2285 */
    SYMBOL,        /* 0x2286 */
    SYMBOL,        /* 0x2287 */
    SYMBOL,        /* 0x2288 */
    SYMBOL,        /* 0x2289 */
    SYMBOL,        /* 0x228a */
    SYMBOL,        /* 0x228b */
    SYMBOL,        /* 0x228c */
    SYMBOL,        /* 0x228d */
    SYMBOL,        /* 0x228e */
    SYMBOL,        /* 0x228f */
    SYMBOL,        /* 0x2290 */
    SYMBOL,        /* 0x2291 */
    SYMBOL,        /* 0x2292 */
    SYMBOL,        /* 0x2293 */
    SYMBOL,        /* 0x2294 */
    SYMBOL,        /* 0x2295 */
    SYMBOL,        /* 0x2296 */
    SYMBOL,        /* 0x2297 */
    SYMBOL,        /* 0x2298 */
    SYMBOL,        /* 0x2299 */
    SYMBOL,        /* 0x229a */
    SYMBOL,        /* 0x229b */
    SYMBOL,        /* 0x229c */
    SYMBOL,        /* 0x229d */
    SYMBOL,        /* 0x229e */
    SYMBOL,        /* 0x229f */
    SYMBOL,        /* 0x22a0 */
    SYMBOL,        /* 0x22a1 */
    SYMBOL,        /* 0x22a2 */
    SYMBOL,        /* 0x22a3 */
    SYMBOL,        /* 0x22a4 */
    SYMBOL,        /* 0x22a5 */
    SYMBOL,        /* 0x22a6 */
    SYMBOL,        /* 0x22a7 */
    SYMBOL,        /* 0x22a8 */
    SYMBOL,        /* 0x22a9 */
    SYMBOL,        /* 0x22aa */
    SYMBOL,        /* 0x22ab */
    SYMBOL,        /* 0x22ac */
    SYMBOL,        /* 0x22ad */
    SYMBOL,        /* 0x22ae */
    SYMBOL,        /* 0x22af */
    SYMBOL,        /* 0x22b0 */
    SYMBOL,        /* 0x22b1 */
    SYMBOL,        /* 0x22b2 */
    SYMBOL,        /* 0x22b3 */
    SYMBOL,        /* 0x22b4 */
    SYMBOL,        /* 0x22b5 */
    SYMBOL,        /* 0x22b6 */
    SYMBOL,        /* 0x22b7 */
    SYMBOL,        /* 0x22b8 */
    SYMBOL,        /* 0x22b9 */
    SYMBOL,        /* 0x22ba */
    SYMBOL,        /* 0x22bb */
    SYMBOL,        /* 0x22bc */
    SYMBOL,        /* 0x22bd */
    SYMBOL,        /* 0x22be */
    SYMBOL,        /* 0x22bf */
    SYMBOL,        /* 0x22c0 */
    SYMBOL,        /* 0x22c1 */
    SYMBOL,        /* 0x22c2 */
    SYMBOL,        /* 0x22c3 */
    SYMBOL,        /* 0x22c4 */
    SYMBOL,        /* 0x22c5 */
    SYMBOL,        /* 0x22c6 */
    SYMBOL,        /* 0x22c7 */
    SYMBOL,        /* 0x22c8 */
    SYMBOL,        /* 0x22c9 */
    SYMBOL,        /* 0x22ca */
    SYMBOL,        /* 0x22cb */
    SYMBOL,        /* 0x22cc */
    SYMBOL,        /* 0x22cd */
    SYMBOL,        /* 0x22ce */
    SYMBOL,        /* 0x22cf */
    SYMBOL,        /* 0x22d0 */
    SYMBOL,        /* 0x22d1 */
    SYMBOL,        /* 0x22d2 */
    SYMBOL,        /* 0x22d3 */
    SYMBOL,        /* 0x22d4 */
    SYMBOL,        /* 0x22d5 */
    SYMBOL,        /* 0x22d6 */
    SYMBOL,        /* 0x22d7 */
    SYMBOL,        /* 0x22d8 */
    SYMBOL,        /* 0x22d9 */
    SYMBOL,        /* 0x22da */
    SYMBOL,        /* 0x22db */
    SYMBOL,        /* 0x22dc */
    SYMBOL,        /* 0x22dd */
    SYMBOL,        /* 0x22de */
    SYMBOL,        /* 0x22df */
    SYMBOL,        /* 0x22e0 */
    SYMBOL,        /* 0x22e1 */
    SYMBOL,        /* 0x22e2 */
    SYMBOL,        /* 0x22e3 */
    SYMBOL,        /* 0x22e4 */
    SYMBOL,        /* 0x22e5 */
    SYMBOL,        /* 0x22e6 */
    SYMBOL,        /* 0x22e7 */
    SYMBOL,        /* 0x22e8 */
    SYMBOL,        /* 0x22e9 */
    SYMBOL,        /* 0x22ea */
    SYMBOL,        /* 0x22eb */
    SYMBOL,        /* 0x22ec */
    SYMBOL,        /* 0x22ed */
    SYMBOL,        /* 0x22ee */
    SYMBOL,        /* 0x22ef */
    SYMBOL,        /* 0x22f0 */
    SYMBOL,        /* 0x22f1 */
    SYMBOL,        /* 0x22f2 */
    SYMBOL,        /* 0x22f3 */
    SYMBOL,        /* 0x22f4 */
    SYMBOL,        /* 0x22f5 */
    SYMBOL,        /* 0x22f6 */
    SYMBOL,        /* 0x22f7 */
    SYMBOL,        /* 0x22f8 */
    SYMBOL,        /* 0x22f9 */
    SYMBOL,        /* 0x22fa */
    SYMBOL,        /* 0x22fb */
    SYMBOL,        /* 0x22fc */
    SYMBOL,        /* 0x22fd */
    SYMBOL,        /* 0x22fe */
    SYMBOL,        /* 0x22ff */
    SYMBOL,        /* 0x2300 */
    SYMBOL,        /* 0x2301 */
    SYMBOL,        /* 0x2302 */
    SYMBOL,        /* 0x2303 */
    SYMBOL,        /* 0x2304 */
    SYMBOL,        /* 0x2305 */
    SYMBOL,        /* 0x2306 */
    SYMBOL,        /* 0x2307 */
    SYMBOL,        /* 0x2308 */
    SYMBOL,        /* 0x2309 */
    SYMBOL,        /* 0x230a */
    SYMBOL,        /* 0x230b */
    SYMBOL,        /* 0x230c */
    SYMBOL,        /* 0x230d */
    SYMBOL,        /* 0x230e */
    SYMBOL,        /* 0x230f */
    SYMBOL,        /* 0x2310 */
    SYMBOL,        /* 0x2311 */
    SYMBOL,        /* 0x2312 */
    SYMBOL,        /* 0x2313 */
    SYMBOL,        /* 0x2314 */
    SYMBOL,        /* 0x2315 */
    SYMBOL,        /* 0x2316 */
    SYMBOL,        /* 0x2317 */
    SYMBOL,        /* 0x2318 */
    SYMBOL,        /* 0x2319 */
    SYMBOL,        /* 0x231a */
    SYMBOL,        /* 0x231b */
    SYMBOL,        /* 0x231c */
    SYMBOL,        /* 0x231d */
    SYMBOL,        /* 0x231e */
    SYMBOL,        /* 0x231f */
    SYMBOL,        /* 0x2320 */
    SYMBOL,        /* 0x2321 */
    SYMBOL,        /* 0x2322 */
    SYMBOL,        /* 0x2323 */
    SYMBOL,        /* 0x2324 */
    SYMBOL,        /* 0x2325 */
    SYMBOL,        /* 0x2326 */
    SYMBOL,        /* 0x2327 */
    SYMBOL,        /* 0x2328 */
    SYMBOL,        /* 0x2329 */
    SYMBOL,        /* 0x232a */
    SYMBOL,        /* 0x232b */
    SYMBOL,        /* 0x232c */
    SYMBOL,        /* 0x232d */
    SYMBOL,        /* 0x232e */
    SYMBOL,        /* 0x232f */
    SYMBOL,        /* 0x2330 */
    SYMBOL,        /* 0x2331 */
    SYMBOL,        /* 0x2332 */
    SYMBOL,        /* 0x2333 */
    SYMBOL,        /* 0x2334 */
    SYMBOL,        /* 0x2335 */
    SYMBOL,        /* 0x2336 */
    SYMBOL,        /* 0x2337 */
    SYMBOL,        /* 0x2338 */
    SYMBOL,        /* 0x2339 */
    SYMBOL,        /* 0x233a */
    SYMBOL,        /* 0x233b */
    SYMBOL,        /* 0x233c */
    SYMBOL,        /* 0x233d */
    SYMBOL,        /* 0x233e */
    SYMBOL,        /* 0x233f */
    SYMBOL,        /* 0x2340 */
    SYMBOL,        /* 0x2341 */
    SYMBOL,        /* 0x2342 */
    SYMBOL,        /* 0x2343 */
    SYMBOL,        /* 0x2344 */
    SYMBOL,        /* 0x2345 */
    SYMBOL,        /* 0x2346 */
    SYMBOL,        /* 0x2347 */
    SYMBOL,        /* 0x2348 */
    SYMBOL,        /* 0x2349 */
    SYMBOL,        /* 0x234a */
    SYMBOL,        /* 0x234b */
    SYMBOL,        /* 0x234c */
    SYMBOL,        /* 0x234d */
    SYMBOL,        /* 0x234e */
    SYMBOL,        /* 0x234f */
    SYMBOL,        /* 0x2350 */
    SYMBOL,        /* 0x2351 */
    SYMBOL,        /* 0x2352 */
    SYMBOL,        /* 0x2353 */
    SYMBOL,        /* 0x2354 */
    SYMBOL,        /* 0x2355 */
    SYMBOL,        /* 0x2356 */
    SYMBOL,        /* 0x2357 */
    SYMBOL,        /* 0x2358 */
    SYMBOL,        /* 0x2359 */
    SYMBOL,        /* 0x235a */
    SYMBOL,        /* 0x235b */
    SYMBOL,        /* 0x235c */
    SYMBOL,        /* 0x235d */
    SYMBOL,        /* 0x235e */
    SYMBOL,        /* 0x235f */
    SYMBOL,        /* 0x2360 */
    SYMBOL,        /* 0x2361 */
    SYMBOL,        /* 0x2362 */
    SYMBOL,        /* 0x2363 */
    SYMBOL,        /* 0x2364 */
    SYMBOL,        /* 0x2365 */
    SYMBOL,        /* 0x2366 */
    SYMBOL,        /* 0x2367 */
    SYMBOL,        /* 0x2368 */
    SYMBOL,        /* 0x2369 */
    SYMBOL,        /* 0x236a */
    SYMBOL,        /* 0x236b */
    SYMBOL,        /* 0x236c */
    SYMBOL,        /* 0x236d */
    SYMBOL,        /* 0x236e */
    SYMBOL,        /* 0x236f */
    SYMBOL,        /* 0x2370 */
    SYMBOL,        /* 0x2371 */
    SYMBOL,        /* 0x2372 */
    SYMBOL,        /* 0x2373 */
    SYMBOL,        /* 0x2374 */
    SYMBOL,        /* 0x2375 */
    SYMBOL,        /* 0x2376 */
    SYMBOL,        /* 0x2377 */
    SYMBOL,        /* 0x2378 */
    SYMBOL,        /* 0x2379 */
    SYMBOL,        /* 0x237a */
    SYMBOL,        /* 0x237b */
    SYMBOL,        /* 0x237c */
    SYMBOL,        /* 0x237d */
    SYMBOL,        /* 0x237e */
    SYMBOL,        /* 0x237f */
    SYMBOL,        /* 0x2380 */
    SYMBOL,        /* 0x2381 */
    SYMBOL,        /* 0x2382 */
    SYMBOL,        /* 0x2383 */
    SYMBOL,        /* 0x2384 */
    SYMBOL,        /* 0x2385 */
    SYMBOL,        /* 0x2386 */
    SYMBOL,        /* 0x2387 */
    SYMBOL,        /* 0x2388 */
    SYMBOL,        /* 0x2389 */
    SYMBOL,        /* 0x238a */
    SYMBOL,        /* 0x238b */
    SYMBOL,        /* 0x238c */
    SYMBOL,        /* 0x238d */
    SYMBOL,        /* 0x238e */
    SYMBOL,        /* 0x238f */
    SYMBOL,        /* 0x2390 */
    SYMBOL,        /* 0x2391 */
    SYMBOL,        /* 0x2392 */
    SYMBOL,        /* 0x2393 */
    SYMBOL,        /* 0x2394 */
    SYMBOL,        /* 0x2395 */
    SYMBOL,        /* 0x2396 */
    SYMBOL,        /* 0x2397 */
    SYMBOL,        /* 0x2398 */
    SYMBOL,        /* 0x2399 */
    SYMBOL,        /* 0x239a */
    SYMBOL,        /* 0x239b */
    SYMBOL,        /* 0x239c */
    SYMBOL,        /* 0x239d */
    SYMBOL,        /* 0x239e */
    SYMBOL,        /* 0x239f */
    SYMBOL,        /* 0x23a0 */
    SYMBOL,        /* 0x23a1 */
    SYMBOL,        /* 0x23a2 */
    SYMBOL,        /* 0x23a3 */
    SYMBOL,        /* 0x23a4 */
    SYMBOL,        /* 0x23a5 */
    SYMBOL,        /* 0x23a6 */
    SYMBOL,        /* 0x23a7 */
    SYMBOL,        /* 0x23a8 */
    SYMBOL,        /* 0x23a9 */
    SYMBOL,        /* 0x23aa */
    SYMBOL,        /* 0x23ab */
    SYMBOL,        /* 0x23ac */
    SYMBOL,        /* 0x23ad */
    SYMBOL,        /* 0x23ae */
    SYMBOL,        /* 0x23af */
    SYMBOL,        /* 0x23b0 */
    SYMBOL,        /* 0x23b1 */
    SYMBOL,        /* 0x23b2 */
    SYMBOL,        /* 0x23b3 */
    SYMBOL,        /* 0x23b4 */
    SYMBOL,        /* 0x23b5 */
    SYMBOL,        /* 0x23b6 */
    SYMBOL,        /* 0x23b7 */
    SYMBOL,        /* 0x23b8 */
    SYMBOL,        /* 0x23b9 */
    SYMBOL,        /* 0x23ba */
    SYMBOL,        /* 0x23bb */
    SYMBOL,        /* 0x23bc */
    SYMBOL,        /* 0x23bd */
    SYMBOL,        /* 0x23be */
    SYMBOL,        /* 0x23bf */
    SYMBOL,        /* 0x23c0 */
    SYMBOL,        /* 0x23c1 */
    SYMBOL,        /* 0x23c2 */
    SYMBOL,        /* 0x23c3 */
    SYMBOL,        /* 0x23c4 */
    SYMBOL,        /* 0x23c5 */
    SYMBOL,        /* 0x23c6 */
    SYMBOL,        /* 0x23c7 */
    SYMBOL,        /* 0x23c8 */
    SYMBOL,        /* 0x23c9 */
    SYMBOL,        /* 0x23ca */
    SYMBOL,        /* 0x23cb */
    SYMBOL,        /* 0x23cc */
    SYMBOL,        /* 0x23cd */
    SYMBOL,        /* 0x23ce */
    SYMBOL,        /* 0x23cf */
    SYMBOL,        /* 0x23d0 */
    SYMBOL,        /* 0x23d1 */
    SYMBOL,        /* 0x23d2 */
    SYMBOL,        /* 0x23d3 */
    SYMBOL,        /* 0x23d4 */
    SYMBOL,        /* 0x23d5 */
    SYMBOL,        /* 0x23d6 */
    SYMBOL,        /* 0x23d7 */
    SYMBOL,        /* 0x23d8 */
    SYMBOL,        /* 0x23d9 */
    SYMBOL,        /* 0x23da */
    SYMBOL,        /* 0x23db */
    SYMBOL,        /* 0x23dc */
    SYMBOL,        /* 0x23dd */
    SYMBOL,        /* 0x23de */
    SYMBOL,        /* 0x23df */
    SYMBOL,        /* 0x23e0 */
    SYMBOL,        /* 0x23e1 */
    SYMBOL,        /* 0x23e2 */
    SYMBOL,        /* 0x23e3 */
    SYMBOL,        /* 0x23e4 */
    SYMBOL,        /* 0x23e5 */
    SYMBOL,        /* 0x23e6 */
    SYMBOL,        /* 0x23e7 */
    SYMBOL,        /* 0x23e8 */
    SYMBOL,        /* 0x23e9 */
    SYMBOL,        /* 0x23ea */
    SYMBOL,        /* 0x23eb */
    SYMBOL,        /* 0x23ec */
    SYMBOL,        /* 0x23ed */
    SYMBOL,        /* 0x23ee */
    SYMBOL,        /* 0x23ef */
    SYMBOL,        /* 0x23f0 */
    SYMBOL,        /* 0x23f1 */
    SYMBOL,        /* 0x23f2 */
    SYMBOL,        /* 0x23f3 */
    SYMBOL,        /* 0x23f4 */
    SYMBOL,        /* 0x23f5 */
    SYMBOL,        /* 0x23f6 */
    SYMBOL,        /* 0x23f7 */
    SYMBOL,        /* 0x23f8 */
    SYMBOL,        /* 0x23f9 */
    SYMBOL,        /* 0x23fa */
    SYMBOL,        /* 0x23fb */
    SYMBOL,        /* 0x23fc */
    SYMBOL,        /* 0x23fd */
    SYMBOL,        /* 0x23fe */
    SYMBOL,        /* 0x23ff */
    OTHER,        /* 0x2400 */
    OTHER,        /* 0x2401 */
    OTHER,        /* 0x2402 */
    OTHER,        /* 0x2403 */
    OTHER,        /* 0x2404 */
    OTHER,        /* 0x2405 */
    OTHER,        /* 0x2406 */
    OTHER,        /* 0x2407 */
    OTHER,        /* 0x2408 */
    OTHER,        /* 0x2409 */
    OTHER,        /* 0x240a */
    OTHER,        /* 0x240b */
    OTHER,        /* 0x240c */
    OTHER,        /* 0x240d */
    OTHER,        /* 0x240e */
    OTHER,        /* 0x240f */
    OTHER,        /* 0x2410 */
    OTHER,        /* 0x2411 */
    OTHER,        /* 0x2412 */
    OTHER,        /* 0x2413 */
    OTHER,        /* 0x2414 */
    OTHER,        /* 0x2415 */
    OTHER,        /* 0x2416 */
    OTHER,        /* 0x2417 */
    OTHER,        /* 0x2418 */
    OTHER,        /* 0x2419 */
    OTHER,        /* 0x241a */
    OTHER,        /* 0x241b */
    OTHER,        /* 0x241c */
    OTHER,        /* 0x241d */
    OTHER,        /* 0x241e */
    OTHER,        /* 0x241f */
    OTHER,        /* 0x2420 */
    OTHER,        /* 0x2421 */
    OTHER,        /* 0x2422 */
    OTHER,        /* 0x2423 */
    OTHER,        /* 0x2424 */
    OTHER,        /* 0x2425 */
    OTHER,        /* 0x2426 */
    OTHER,        /* 0x2427 */
    OTHER,        /* 0x2428 */
    OTHER,        /* 0x2429 */
    OTHER,        /* 0x242a */
    OTHER,        /* 0x242b */
    OTHER,        /* 0x242c */
    OTHER,        /* 0x242d */
    OTHER,        /* 0x242e */
    OTHER,        /* 0x242f */
    OTHER,        /* 0x2430 */
    OTHER,        /* 0x2431 */
    OTHER,        /* 0x2432 */
    OTHER,        /* 0x2433 */
    OTHER,        /* 0x2434 */
    OTHER,        /* 0x2435 */
    OTHER,        /* 0x2436 */
    OTHER,        /* 0x2437 */
    OTHER,        /* 0x2438 */
    OTHER,        /* 0x2439 */
    OTHER,        /* 0x243a */
    OTHER,        /* 0x243b */
    OTHER,        /* 0x243c */
    OTHER,        /* 0x243d */
    OTHER,        /* 0x243e */
    OTHER,        /* 0x243f */
    OTHER,        /* 0x2440 */
    OTHER,        /* 0x2441 */
    OTHER,        /* 0x2442 */
    OTHER,        /* 0x2443 */
    OTHER,        /* 0x2444 */
    OTHER,        /* 0x2445 */
    OTHER,        /* 0x2446 */
    OTHER,        /* 0x2447 */
    OTHER,        /* 0x2448 */
    OTHER,        /* 0x2449 */
    OTHER,        /* 0x244a */
    OTHER,        /* 0x244b */
    OTHER,        /* 0x244c */
    OTHER,        /* 0x244d */
    OTHER,        /* 0x244e */
    OTHER,        /* 0x244f */
    OTHER,        /* 0x2450 */
    OTHER,        /* 0x2451 */
    OTHER,        /* 0x2452 */
    OTHER,        /* 0x2453 */
    OTHER,        /* 0x2454 */
    OTHER,        /* 0x2455 */
    OTHER,        /* 0x2456 */
    OTHER,        /* 0x2457 */
    OTHER,        /* 0x2458 */
    OTHER,        /* 0x2459 */
    OTHER,        /* 0x245a */
    OTHER,        /* 0x245b */
    OTHER,        /* 0x245c */
    OTHER,        /* 0x245d */
    OTHER,        /* 0x245e */
    OTHER,        /* 0x245f */
    SYMBOL,        /* 0x2460 */
    SYMBOL,        /* 0x2461 */
    SYMBOL,        /* 0x2462 */
    SYMBOL,        /* 0x2463 */
    SYMBOL,        /* 0x2464 */
    SYMBOL,        /* 0x2465 */
    SYMBOL,        /* 0x2466 */
    SYMBOL,        /* 0x2467 */
    SYMBOL,        /* 0x2468 */
    SYMBOL,        /* 0x2469 */
    SYMBOL,        /* 0x246a */
    SYMBOL,        /* 0x246b */
    SYMBOL,        /* 0x246c */
    SYMBOL,        /* 0x246d */
    SYMBOL,        /* 0x246e */
    SYMBOL,        /* 0x246f */
    SYMBOL,        /* 0x2470 */
    SYMBOL,        /* 0x2471 */
    SYMBOL,        /* 0x2472 */
    SYMBOL,        /* 0x2473 */
    SYMBOL,        /* 0x2474 */
    SYMBOL,        /* 0x2475 */
    SYMBOL,        /* 0x2476 */
    SYMBOL,        /* 0x2477 */
    SYMBOL,        /* 0x2478 */
    SYMBOL,        /* 0x2479 */
    SYMBOL,        /* 0x247a */
    SYMBOL,        /* 0x247b */
    SYMBOL,        /* 0x247c */
    SYMBOL,        /* 0x247d */
    SYMBOL,        /* 0x247e */
    SYMBOL,        /* 0x247f */
    SYMBOL,        /* 0x2480 */
    SYMBOL,        /* 0x2481 */
    SYMBOL,        /* 0x2482 */
    SYMBOL,        /* 0x2483 */
    SYMBOL,        /* 0x2484 */
    SYMBOL,        /* 0x2485 */
    SYMBOL,        /* 0x2486 */
    SYMBOL,        /* 0x2487 */
    SYMBOL,        /* 0x2488 */
    SYMBOL,        /* 0x2489 */
    SYMBOL,        /* 0x248a */
    SYMBOL,        /* 0x248b */
    SYMBOL,        /* 0x248c */
    SYMBOL,        /* 0x248d */
    SYMBOL,        /* 0x248e */
    SYMBOL,        /* 0x248f */
    SYMBOL,        /* 0x2490 */
    SYMBOL,        /* 0x2491 */
    SYMBOL,        /* 0x2492 */
    SYMBOL,        /* 0x2493 */
    SYMBOL,        /* 0x2494 */
    SYMBOL,        /* 0x2495 */
    SYMBOL,        /* 0x2496 */
    SYMBOL,        /* 0x2497 */
    SYMBOL,        /* 0x2498 */
    SYMBOL,        /* 0x2499 */
    SYMBOL,        /* 0x249a */
    SYMBOL,        /* 0x249b */
    SYMBOL,        /* 0x249c */
    SYMBOL,        /* 0x249d */
    SYMBOL,        /* 0x249e */
    SYMBOL,        /* 0x249f */
    SYMBOL,        /* 0x24a0 */
    SYMBOL,        /* 0x24a1 */
    SYMBOL,        /* 0x24a2 */
    SYMBOL,        /* 0x24a3 */
    SYMBOL,        /* 0x24a4 */
    SYMBOL,        /* 0x24a5 */
    SYMBOL,        /* 0x24a6 */
    SYMBOL,        /* 0x24a7 */
    SYMBOL,        /* 0x24a8 */
    SYMBOL,        /* 0x24a9 */
    SYMBOL,        /* 0x24aa */
    SYMBOL,        /* 0x24ab */
    SYMBOL,        /* 0x24ac */
    SYMBOL,        /* 0x24ad */
    SYMBOL,        /* 0x24ae */
    SYMBOL,        /* 0x24af */
    SYMBOL,        /* 0x24b0 */
    SYMBOL,        /* 0x24b1 */
    SYMBOL,        /* 0x24b2 */
    SYMBOL,        /* 0x24b3 */
    SYMBOL,        /* 0x24b4 */
    SYMBOL,        /* 0x24b5 */
    SYMBOL,        /* 0x24b6 */
    SYMBOL,        /* 0x24b7 */
    SYMBOL,        /* 0x24b8 */
    SYMBOL,        /* 0x24b9 */
    SYMBOL,        /* 0x24ba */
    SYMBOL,        /* 0x24bb */
    SYMBOL,        /* 0x24bc */
    SYMBOL,        /* 0x24bd */
    SYMBOL,        /* 0x24be */
    SYMBOL,        /* 0x24bf */
    SYMBOL,        /* 0x24c0 */
    SYMBOL,        /* 0x24c1 */
    SYMBOL,        /* 0x24c2 */
    SYMBOL,        /* 0x24c3 */
    SYMBOL,        /* 0x24c4 */
    SYMBOL,        /* 0x24c5 */
    SYMBOL,        /* 0x24c6 */
    SYMBOL,        /* 0x24c7 */
    SYMBOL,        /* 0x24c8 */
    SYMBOL,        /* 0x24c9 */
    SYMBOL,        /* 0x24ca */
    SYMBOL,        /* 0x24cb */
    SYMBOL,        /* 0x24cc */
    SYMBOL,        /* 0x24cd */
    SYMBOL,        /* 0x24ce */
    SYMBOL,        /* 0x24cf */
    SYMBOL,        /* 0x24d0 */
    SYMBOL,        /* 0x24d1 */
    SYMBOL,        /* 0x24d2 */
    SYMBOL,        /* 0x24d3 */
    SYMBOL,        /* 0x24d4 */
    SYMBOL,        /* 0x24d5 */
    SYMBOL,        /* 0x24d6 */
    SYMBOL,        /* 0x24d7 */
    SYMBOL,        /* 0x24d8 */
    SYMBOL,        /* 0x24d9 */
    SYMBOL,        /* 0x24da */
    SYMBOL,        /* 0x24db */
    SYMBOL,        /* 0x24dc */
    SYMBOL,        /* 0x24dd */
    SYMBOL,        /* 0x24de */
    SYMBOL,        /* 0x24df */
    SYMBOL,        /* 0x24e0 */
    SYMBOL,        /* 0x24e1 */
    SYMBOL,        /* 0x24e2 */
    SYMBOL,        /* 0x24e3 */
    SYMBOL,        /* 0x24e4 */
    SYMBOL,        /* 0x24e5 */
    SYMBOL,        /* 0x24e6 */
    SYMBOL,        /* 0x24e7 */
    SYMBOL,        /* 0x24e8 */
    SYMBOL,        /* 0x24e9 */
    SYMBOL,        /* 0x24ea */
    SYMBOL,        /* 0x24eb */
    SYMBOL,        /* 0x24ec */
    SYMBOL,        /* 0x24ed */
    SYMBOL,        /* 0x24ee */
    SYMBOL,        /* 0x24ef */
    SYMBOL,        /* 0x24f0 */
    SYMBOL,        /* 0x24f1 */
    SYMBOL,        /* 0x24f2 */
    SYMBOL,        /* 0x24f3 */
    SYMBOL,        /* 0x24f4 */
    SYMBOL,        /* 0x24f5 */
    SYMBOL,        /* 0x24f6 */
    SYMBOL,        /* 0x24f7 */
    SYMBOL,        /* 0x24f8 */
    SYMBOL,        /* 0x24f9 */
    SYMBOL,        /* 0x24fa */
    SYMBOL,        /* 0x24fb */
    SYMBOL,        /* 0x24fc */
    SYMBOL,        /* 0x24fd */
    SYMBOL,        /* 0x24fe */
    SYMBOL,        /* 0x24ff */
    OTHER,        /* 0x2500 */
    SYMBOL,        /* 0x2501 */
    SYMBOL,        /* 0x2502 */
    SYMBOL,        /* 0x2503 */
    SYMBOL,        /* 0x2504 */
    SYMBOL,        /* 0x2505 */
    SYMBOL,        /* 0x2506 */
    SYMBOL,        /* 0x2507 */
    SYMBOL,        /* 0x2508 */
    SYMBOL,        /* 0x2509 */
    SYMBOL,        /* 0x250a */
    SYMBOL,        /* 0x250b */
    SYMBOL,        /* 0x250c */
    SYMBOL,        /* 0x250d */
    SYMBOL,        /* 0x250e */
    SYMBOL,        /* 0x250f */
    SYMBOL,        /* 0x2510 */
    SYMBOL,        /* 0x2511 */
    SYMBOL,        /* 0x2512 */
    SYMBOL,        /* 0x2513 */
    SYMBOL,        /* 0x2514 */
    SYMBOL,        /* 0x2515 */
    SYMBOL,        /* 0x2516 */
    SYMBOL,        /* 0x2517 */
    SYMBOL,        /* 0x2518 */
    SYMBOL,        /* 0x2519 */
    SYMBOL,        /* 0x251a */
    SYMBOL,        /* 0x251b */
    SYMBOL,        /* 0x251c */
    SYMBOL,        /* 0x251d */
    SYMBOL,        /* 0x251e */
    SYMBOL,        /* 0x251f */
    SYMBOL,        /* 0x2520 */
    SYMBOL,        /* 0x2521 */
    SYMBOL,        /* 0x2522 */
    SYMBOL,        /* 0x2523 */
    SYMBOL,        /* 0x2524 */
    SYMBOL,        /* 0x2525 */
    SYMBOL,        /* 0x2526 */
    SYMBOL,        /* 0x2527 */
    SYMBOL,        /* 0x2528 */
    SYMBOL,        /* 0x2529 */
    SYMBOL,        /* 0x252a */
    SYMBOL,        /* 0x252b */
    SYMBOL,        /* 0x252c */
    SYMBOL,        /* 0x252d */
    SYMBOL,        /* 0x252e */
    SYMBOL,        /* 0x252f */
    SYMBOL,        /* 0x2530 */
    SYMBOL,        /* 0x2531 */
    SYMBOL,        /* 0x2532 */
    SYMBOL,        /* 0x2533 */
    SYMBOL,        /* 0x2534 */
    SYMBOL,        /* 0x2535 */
    SYMBOL,        /* 0x2536 */
    SYMBOL,        /* 0x2537 */
    SYMBOL,        /* 0x2538 */
    SYMBOL,        /* 0x2539 */
    SYMBOL,        /* 0x253a */
    SYMBOL,        /* 0x253b */
    SYMBOL,        /* 0x253c */
    SYMBOL,        /* 0x253d */
    SYMBOL,        /* 0x253e */
    SYMBOL,        /* 0x253f */
    SYMBOL,        /* 0x2540 */
    SYMBOL,        /* 0x2541 */
    SYMBOL,        /* 0x2542 */
    SYMBOL,        /* 0x2543 */
    SYMBOL,        /* 0x2544 */
    SYMBOL,        /* 0x2545 */
    SYMBOL,        /* 0x2546 */
    SYMBOL,        /* 0x2547 */
    SYMBOL,        /* 0x2548 */
    SYMBOL,        /* 0x2549 */
    SYMBOL,        /* 0x254a */
    SYMBOL,        /* 0x254b */
    SYMBOL,        /* 0x254c */
    SYMBOL,        /* 0x254d */
    SYMBOL,        /* 0x254e */
    SYMBOL,        /* 0x254f */
    SYMBOL,        /* 0x2550 */
    SYMBOL,        /* 0x2551 */
    SYMBOL,        /* 0x2552 */
    SYMBOL,        /* 0x2553 */
    SYMBOL,        /* 0x2554 */
    SYMBOL,        /* 0x2555 */
    SYMBOL,        /* 0x2556 */
    SYMBOL,        /* 0x2557 */
    SYMBOL,        /* 0x2558 */
    SYMBOL,        /* 0x2559 */
    SYMBOL,        /* 0x255a */
    SYMBOL,        /* 0x255b */
    SYMBOL,        /* 0x255c */
    SYMBOL,        /* 0x255d */
    SYMBOL,        /* 0x255e */
    SYMBOL,        /* 0x255f */
    SYMBOL,        /* 0x2560 */
    SYMBOL,        /* 0x2561 */
    SYMBOL,        /* 0x2562 */
    SYMBOL,        /* 0x2563 */
    SYMBOL,        /* 0x2564 */
    SYMBOL,        /* 0x2565 */
    SYMBOL,        /* 0x2566 */
    SYMBOL,        /* 0x2567 */
    SYMBOL,        /* 0x2568 */
    SYMBOL,        /* 0x2569 */
    SYMBOL,        /* 0x256a */
    SYMBOL,        /* 0x256b */
    SYMBOL,        /* 0x256c */
    SYMBOL,        /* 0x256d */
    SYMBOL,        /* 0x256e */
    SYMBOL,        /* 0x256f */
    SYMBOL,        /* 0x2570 */
    SYMBOL,        /* 0x2571 */
    SYMBOL,        /* 0x2572 */
    SYMBOL,        /* 0x2573 */
    SYMBOL,        /* 0x2574 */
    SYMBOL,        /* 0x2575 */
    SYMBOL,        /* 0x2576 */
    SYMBOL,        /* 0x2577 */
    SYMBOL,        /* 0x2578 */
    SYMBOL,        /* 0x2579 */
    SYMBOL,        /* 0x257a */
    SYMBOL,        /* 0x257b */
    SYMBOL,        /* 0x257c */
    SYMBOL,        /* 0x257d */
    SYMBOL,        /* 0x257e */
    SYMBOL,        /* 0x257f */
    SYMBOL,        /* 0x2580 */
    SYMBOL,        /* 0x2581 */
    SYMBOL,        /* 0x2582 */
    SYMBOL,        /* 0x2583 */
    SYMBOL,        /* 0x2584 */
    SYMBOL,        /* 0x2585 */
    SYMBOL,        /* 0x2586 */
    SYMBOL,        /* 0x2587 */
    SYMBOL,        /* 0x2588 */
    SYMBOL,        /* 0x2589 */
    SYMBOL,        /* 0x258a */
    SYMBOL,        /* 0x258b */
    SYMBOL,        /* 0x258c */
    SYMBOL,        /* 0x258d */
    SYMBOL,        /* 0x258e */
    SYMBOL,        /* 0x258f */
    SYMBOL,        /* 0x2590 */
    SYMBOL,        /* 0x2591 */
    SYMBOL,        /* 0x2592 */
    SYMBOL,        /* 0x2593 */
    SYMBOL,        /* 0x2594 */
    SYMBOL,        /* 0x2595 */
    SYMBOL,        /* 0x2596 */
    SYMBOL,        /* 0x2597 */
    SYMBOL,        /* 0x2598 */
    SYMBOL,        /* 0x2599 */
    SYMBOL,        /* 0x259a */
    SYMBOL,        /* 0x259b */
    SYMBOL,        /* 0x259c */
    SYMBOL,        /* 0x259d */
    SYMBOL,        /* 0x259e */
    SYMBOL,        /* 0x259f */
    SYMBOL,        /* 0x25a0 */
    SYMBOL,        /* 0x25a1 */
    SYMBOL,        /* 0x25a2 */
    SYMBOL,        /* 0x25a3 */
    SYMBOL,        /* 0x25a4 */
    SYMBOL,        /* 0x25a5 */
    SYMBOL,        /* 0x25a6 */
    SYMBOL,        /* 0x25a7 */
    SYMBOL,        /* 0x25a8 */
    SYMBOL,        /* 0x25a9 */
    SYMBOL,        /* 0x25aa */
    SYMBOL,        /* 0x25ab */
    SYMBOL,        /* 0x25ac */
    SYMBOL,        /* 0x25ad */
    SYMBOL,        /* 0x25ae */
    SYMBOL,        /* 0x25af */
    SYMBOL,        /* 0x25b0 */
    SYMBOL,        /* 0x25b1 */
    SYMBOL,        /* 0x25b2 */
    SYMBOL,        /* 0x25b3 */
    SYMBOL,        /* 0x25b4 */
    SYMBOL,        /* 0x25b5 */
    SYMBOL,        /* 0x25b6 */
    SYMBOL,        /* 0x25b7 */
    SYMBOL,        /* 0x25b8 */
    SYMBOL,        /* 0x25b9 */
    SYMBOL,        /* 0x25ba */
    SYMBOL,        /* 0x25bb */
    SYMBOL,        /* 0x25bc */
    SYMBOL,        /* 0x25bd */
    SYMBOL,        /* 0x25be */
    SYMBOL,        /* 0x25bf */
    SYMBOL,        /* 0x25c0 */
    SYMBOL,        /* 0x25c1 */
    SYMBOL,        /* 0x25c2 */
    SYMBOL,        /* 0x25c3 */
    SYMBOL,        /* 0x25c4 */
    SYMBOL,        /* 0x25c5 */
    SYMBOL,        /* 0x25c6 */
    SYMBOL,        /* 0x25c7 */
    SYMBOL,        /* 0x25c8 */
    SYMBOL,        /* 0x25c9 */
    SYMBOL,        /* 0x25ca */
    SYMBOL,        /* 0x25cb */
    SYMBOL,        /* 0x25cc */
    SYMBOL,        /* 0x25cd */
    SYMBOL,        /* 0x25ce */
    SYMBOL,        /* 0x25cf */
    SYMBOL,        /* 0x25d0 */
    SYMBOL,        /* 0x25d1 */
    SYMBOL,        /* 0x25d2 */
    SYMBOL,        /* 0x25d3 */
    SYMBOL,        /* 0x25d4 */
    SYMBOL,        /* 0x25d5 */
    SYMBOL,        /* 0x25d6 */
    SYMBOL,        /* 0x25d7 */
    SYMBOL,        /* 0x25d8 */
    SYMBOL,        /* 0x25d9 */
    SYMBOL,        /* 0x25da */
    SYMBOL,        /* 0x25db */
    SYMBOL,        /* 0x25dc */
    SYMBOL,        /* 0x25dd */
    SYMBOL,        /* 0x25de */
    SYMBOL,        /* 0x25df */
    SYMBOL,        /* 0x25e0 */
    SYMBOL,        /* 0x25e1 */
    SYMBOL,        /* 0x25e2 */
    SYMBOL,        /* 0x25e3 */
    SYMBOL,        /* 0x25e4 */
    SYMBOL,        /* 0x25e5 */
    SYMBOL,        /* 0x25e6 */
    SYMBOL,        /* 0x25e7 */
    SYMBOL,        /* 0x25e8 */
    SYMBOL,        /* 0x25e9 */
    SYMBOL,        /* 0x25ea */
    SYMBOL,        /* 0x25eb */
    SYMBOL,        /* 0x25ec */
    SYMBOL,        /* 0x25ed */
    SYMBOL,        /* 0x25ee */
    SYMBOL,        /* 0x25ef */
    SYMBOL,        /* 0x25f0 */
    SYMBOL,        /* 0x25f1 */
    SYMBOL,        /* 0x25f2 */
    SYMBOL,        /* 0x25f3 */
    SYMBOL,        /* 0x25f4 */
    SYMBOL,        /* 0x25f5 */
    SYMBOL,        /* 0x25f6 */
    SYMBOL,        /* 0x25f7 */
    SYMBOL,        /* 0x25f8 */
    SYMBOL,        /* 0x25f9 */
    SYMBOL,        /* 0x25fa */
    SYMBOL,        /* 0x25fb */
    SYMBOL,        /* 0x25fc */
    SYMBOL,        /* 0x25fd */
    SYMBOL,        /* 0x25fe */
    SYMBOL,        /* 0x25ff */
    SYMBOL,        /* 0x2600 */
    SYMBOL,        /* 0x2601 */
    SYMBOL,        /* 0x2602 */
    SYMBOL,        /* 0x2603 */
    SYMBOL,        /* 0x2604 */
    SYMBOL,        /* 0x2605 */
    SYMBOL,        /* 0x2606 */
    SYMBOL,        /* 0x2607 */
    SYMBOL,        /* 0x2608 */
    SYMBOL,        /* 0x2609 */
    SYMBOL,        /* 0x260a */
    SYMBOL,        /* 0x260b */
    SYMBOL,        /* 0x260c */
    SYMBOL,        /* 0x260d */
    SYMBOL,        /* 0x260e */
    SYMBOL,        /* 0x260f */
    SYMBOL,        /* 0x2610 */
    SYMBOL,        /* 0x2611 */
    SYMBOL,        /* 0x2612 */
    SYMBOL,        /* 0x2613 */
    SYMBOL,        /* 0x2614 */
    SYMBOL,        /* 0x2615 */
    SYMBOL,        /* 0x2616 */
    SYMBOL,        /* 0x2617 */
    SYMBOL,        /* 0x2618 */
    SYMBOL,        /* 0x2619 */
    SYMBOL,        /* 0x261a */
    SYMBOL,        /* 0x261b */
    SYMBOL,        /* 0x261c */
    SYMBOL,        /* 0x261d */
    SYMBOL,        /* 0x261e */
    SYMBOL,        /* 0x261f */
    SYMBOL,        /* 0x2620 */
    SYMBOL,        /* 0x2621 */
    SYMBOL,        /* 0x2622 */
    SYMBOL,        /* 0x2623 */
    SYMBOL,        /* 0x2624 */
    SYMBOL,        /* 0x2625 */
    SYMBOL,        /* 0x2626 */
    SYMBOL,        /* 0x2627 */
    SYMBOL,        /* 0x2628 */
    SYMBOL,        /* 0x2629 */
    SYMBOL,        /* 0x262a */
    SYMBOL,        /* 0x262b */
    SYMBOL,        /* 0x262c */
    SYMBOL,        /* 0x262d */
    SYMBOL,        /* 0x262e */
    SYMBOL,        /* 0x262f */
    SYMBOL,        /* 0x2630 */
    SYMBOL,        /* 0x2631 */
    SYMBOL,        /* 0x2632 */
    SYMBOL,        /* 0x2633 */
    SYMBOL,        /* 0x2634 */
    SYMBOL,        /* 0x2635 */
    SYMBOL,        /* 0x2636 */
    SYMBOL,        /* 0x2637 */
    SYMBOL,        /* 0x2638 */
    SYMBOL,        /* 0x2639 */
    SYMBOL,        /* 0x263a */
    SYMBOL,        /* 0x263b */
    SYMBOL,        /* 0x263c */
    SYMBOL,        /* 0x263d */
    SYMBOL,        /* 0x263e */
    SYMBOL,        /* 0x263f */
    SYMBOL,        /* 0x2640 */
    SYMBOL,        /* 0x2641 */
    SYMBOL,        /* 0x2642 */
    SYMBOL,        /* 0x2643 */
    SYMBOL,        /* 0x2644 */
    SYMBOL,        /* 0x2645 */
    SYMBOL,        /* 0x2646 */
    SYMBOL,        /* 0x2647 */
    SYMBOL,        /* 0x2648 */
    SYMBOL,        /* 0x2649 */
    SYMBOL,        /* 0x264a */
    SYMBOL,        /* 0x264b */
    SYMBOL,        /* 0x264c */
    SYMBOL,        /* 0x264d */
    SYMBOL,        /* 0x264e */
    SYMBOL,        /* 0x264f */
    SYMBOL,        /* 0x2650 */
    SYMBOL,        /* 0x2651 */
    SYMBOL,        /* 0x2652 */
    SYMBOL,        /* 0x2653 */
    SYMBOL,        /* 0x2654 */
    SYMBOL,        /* 0x2655 */
    SYMBOL,        /* 0x2656 */
    SYMBOL,        /* 0x2657 */
    SYMBOL,        /* 0x2658 */
    SYMBOL,        /* 0x2659 */
    SYMBOL,        /* 0x265a */
    SYMBOL,        /* 0x265b */
    SYMBOL,        /* 0x265c */
    SYMBOL,        /* 0x265d */
    SYMBOL,        /* 0x265e */
    SYMBOL,        /* 0x265f */
    SYMBOL,        /* 0x2660 */
    SYMBOL,        /* 0x2661 */
    SYMBOL,        /* 0x2662 */
    SYMBOL,        /* 0x2663 */
    SYMBOL,        /* 0x2664 */
    SYMBOL,        /* 0x2665 */
    SYMBOL,        /* 0x2666 */
    SYMBOL,        /* 0x2667 */
    SYMBOL,        /* 0x2668 */
    SYMBOL,        /* 0x2669 */
    SYMBOL,        /* 0x266a */
    SYMBOL,        /* 0x266b */
    SYMBOL,        /* 0x266c */
    SYMBOL,        /* 0x266d */
    SYMBOL,        /* 0x266e */
    SYMBOL,        /* 0x266f */
    SYMBOL,        /* 0x2670 */
    SYMBOL,        /* 0x2671 */
    SYMBOL,        /* 0x2672 */
    SYMBOL,        /* 0x2673 */
    SYMBOL,        /* 0x2674 */
    SYMBOL,        /* 0x2675 */
    SYMBOL,        /* 0x2676 */
    SYMBOL,        /* 0x2677 */
    SYMBOL,        /* 0x2678 */
    SYMBOL,        /* 0x2679 */
    SYMBOL,        /* 0x267a */
    SYMBOL,        /* 0x267b */
    SYMBOL,        /* 0x267c */
    SYMBOL,        /* 0x267d */
    SYMBOL,        /* 0x267e */
    SYMBOL,        /* 0x267f */
    SYMBOL,        /* 0x2680 */
    SYMBOL,        /* 0x2681 */
    SYMBOL,        /* 0x2682 */
    SYMBOL,        /* 0x2683 */
    SYMBOL,        /* 0x2684 */
    SYMBOL,        /* 0x2685 */
    SYMBOL,        /* 0x2686 */
    SYMBOL,        /* 0x2687 */
    SYMBOL,        /* 0x2688 */
    SYMBOL,        /* 0x2689 */
    SYMBOL,        /* 0x268a */
    SYMBOL,        /* 0x268b */
    SYMBOL,        /* 0x268c */
    SYMBOL,        /* 0x268d */
    SYMBOL,        /* 0x268e */
    SYMBOL,        /* 0x268f */
    SYMBOL,        /* 0x2690 */
    SYMBOL,        /* 0x2691 */
    SYMBOL,        /* 0x2692 */
    SYMBOL,        /* 0x2693 */
    SYMBOL,        /* 0x2694 */
    SYMBOL,        /* 0x2695 */
    SYMBOL,        /* 0x2696 */
    SYMBOL,        /* 0x2697 */
    SYMBOL,        /* 0x2698 */
    SYMBOL,        /* 0x2699 */
    SYMBOL,        /* 0x269a */
    SYMBOL,        /* 0x269b */
    SYMBOL,        /* 0x269c */
    SYMBOL,        /* 0x269d */
    SYMBOL,        /* 0x269e */
    SYMBOL,        /* 0x269f */
    SYMBOL,        /* 0x26a0 */
    SYMBOL,        /* 0x26a1 */
    SYMBOL,        /* 0x26a2 */
    SYMBOL,        /* 0x26a3 */
    SYMBOL,        /* 0x26a4 */
    SYMBOL,        /* 0x26a5 */
    SYMBOL,        /* 0x26a6 */
    SYMBOL,        /* 0x26a7 */
    SYMBOL,        /* 0x26a8 */
    SYMBOL,        /* 0x26a9 */
    SYMBOL,        /* 0x26aa */
    SYMBOL,        /* 0x26ab */
    SYMBOL,        /* 0x26ac */
    SYMBOL,        /* 0x26ad */
    SYMBOL,        /* 0x26ae */
    SYMBOL,        /* 0x26af */
    SYMBOL,        /* 0x26b0 */
    SYMBOL,        /* 0x26b1 */
    SYMBOL,        /* 0x26b2 */
    SYMBOL,        /* 0x26b3 */
    SYMBOL,        /* 0x26b4 */
    SYMBOL,        /* 0x26b5 */
    SYMBOL,        /* 0x26b6 */
    SYMBOL,        /* 0x26b7 */
    SYMBOL,        /* 0x26b8 */
    SYMBOL,        /* 0x26b9 */
    SYMBOL,        /* 0x26ba */
    SYMBOL,        /* 0x26bb */
    SYMBOL,        /* 0x26bc */
    SYMBOL,        /* 0x26bd */
    SYMBOL,        /* 0x26be */
    SYMBOL,        /* 0x26bf */
    SYMBOL,        /* 0x26c0 */
    SYMBOL,        /* 0x26c1 */
    SYMBOL,        /* 0x26c2 */
    SYMBOL,        /* 0x26c3 */
    SYMBOL,        /* 0x26c4 */
    SYMBOL,        /* 0x26c5 */
    SYMBOL,        /* 0x26c6 */
    SYMBOL,        /* 0x26c7 */
    SYMBOL,        /* 0x26c8 */
    SYMBOL,        /* 0x26c9 */
    SYMBOL,        /* 0x26ca */
    SYMBOL,        /* 0x26cb */
    SYMBOL,        /* 0x26cc */
    SYMBOL,        /* 0x26cd */
    SYMBOL,        /* 0x26ce */
    SYMBOL,        /* 0x26cf */
    SYMBOL,        /* 0x26d0 */
    SYMBOL,        /* 0x26d1 */
    SYMBOL,        /* 0x26d2 */
    SYMBOL,        /* 0x26d3 */
    SYMBOL,        /* 0x26d4 */
    SYMBOL,        /* 0x26d5 */
    SYMBOL,        /* 0x26d6 */
    SYMBOL,        /* 0x26d7 */
    SYMBOL,        /* 0x26d8 */
    SYMBOL,        /* 0x26d9 */
    SYMBOL,        /* 0x26da */
    SYMBOL,        /* 0x26db */
    SYMBOL,        /* 0x26dc */
    SYMBOL,        /* 0x26dd */
    SYMBOL,        /* 0x26de */
    SYMBOL,        /* 0x26df */
    SYMBOL,        /* 0x26e0 */
    SYMBOL,        /* 0x26e1 */
    SYMBOL,        /* 0x26e2 */
    SYMBOL,        /* 0x26e3 */
    SYMBOL,        /* 0x26e4 */
    SYMBOL,        /* 0x26e5 */
    SYMBOL,        /* 0x26e6 */
    SYMBOL,        /* 0x26e7 */
    SYMBOL,        /* 0x26e8 */
    SYMBOL,        /* 0x26e9 */
    SYMBOL,        /* 0x26ea */
    SYMBOL,        /* 0x26eb */
    SYMBOL,        /* 0x26ec */
    SYMBOL,        /* 0x26ed */
    SYMBOL,        /* 0x26ee */
    SYMBOL,        /* 0x26ef */
    SYMBOL,        /* 0x26f0 */
    SYMBOL,        /* 0x26f1 */
    SYMBOL,        /* 0x26f2 */
    SYMBOL,        /* 0x26f3 */
    SYMBOL,        /* 0x26f4 */
    SYMBOL,        /* 0x26f5 */
    SYMBOL,        /* 0x26f6 */
    SYMBOL,        /* 0x26f7 */
    SYMBOL,        /* 0x26f8 */
    SYMBOL,        /* 0x26f9 */
    SYMBOL,        /* 0x26fa */
    SYMBOL,        /* 0x26fb */
    SYMBOL,        /* 0x26fc */
    SYMBOL,        /* 0x26fd */
    SYMBOL,        /* 0x26fe */
    OTHER,        /* 0x26ff */
    SYMBOL,        /* 0x2700 */
    SYMBOL,        /* 0x2701 */
    SYMBOL,        /* 0x2702 */
    SYMBOL,        /* 0x2703 */
    SYMBOL,        /* 0x2704 */
    SYMBOL,        /* 0x2705 */
    SYMBOL,        /* 0x2706 */
    SYMBOL,        /* 0x2707 */
    SYMBOL,        /* 0x2708 */
    SYMBOL,        /* 0x2709 */
    SYMBOL,        /* 0x270a */
    SYMBOL,        /* 0x270b */
    SYMBOL,        /* 0x270c */
    SYMBOL,        /* 0x270d */
    SYMBOL,        /* 0x270e */
    SYMBOL,        /* 0x270f */
    SYMBOL,        /* 0x2710 */
    SYMBOL,        /* 0x2711 */
    SYMBOL,        /* 0x2712 */
    SYMBOL,        /* 0x2713 */
    SYMBOL,        /* 0x2714 */
    SYMBOL,        /* 0x2715 */
    SYMBOL,        /* 0x2716 */
    SYMBOL,        /* 0x2717 */
    SYMBOL,        /* 0x2718 */
    SYMBOL,        /* 0x2719 */
    SYMBOL,        /* 0x271a */
    SYMBOL,        /* 0x271b */
    SYMBOL,        /* 0x271c */
    SYMBOL,        /* 0x271d */
    SYMBOL,        /* 0x271e */
    SYMBOL,        /* 0x271f */
    SYMBOL,        /* 0x2720 */
    SYMBOL,        /* 0x2721 */
    SYMBOL,        /* 0x2722 */
    SYMBOL,        /* 0x2723 */
    SYMBOL,        /* 0x2724 */
    SYMBOL,        /* 0x2725 */
    SYMBOL,        /* 0x2726 */
    SYMBOL,        /* 0x2727 */
    SYMBOL,        /* 0x2728 */
    SYMBOL,        /* 0x2729 */
    SYMBOL,        /* 0x272a */
    SYMBOL,        /* 0x272b */
    SYMBOL,        /* 0x272c */
    SYMBOL,        /* 0x272d */
    SYMBOL,        /* 0x272e */
    SYMBOL,        /* 0x272f */
    SYMBOL,        /* 0x2730 */
    SYMBOL,        /* 0x2731 */
    SYMBOL,        /* 0x2732 */
    SYMBOL,        /* 0x2733 */
    SYMBOL,        /* 0x2734 */
    SYMBOL,        /* 0x2735 */
    SYMBOL,        /* 0x2736 */
    SYMBOL,        /* 0x2737 */
    SYMBOL,        /* 0x2738 */
    SYMBOL,        /* 0x2739 */
    SYMBOL,        /* 0x273a */
    SYMBOL,        /* 0x273b */
    SYMBOL,        /* 0x273c */
    SYMBOL,        /* 0x273d */
    SYMBOL,        /* 0x273e */
    SYMBOL,        /* 0x273f */
    SYMBOL,        /* 0x2740 */
    SYMBOL,        /* 0x2741 */
    SYMBOL,        /* 0x2742 */
    SYMBOL,        /* 0x2743 */
    SYMBOL,        /* 0x2744 */
    SYMBOL,        /* 0x2745 */
    SYMBOL,        /* 0x2746 */
    SYMBOL,        /* 0x2747 */
    SYMBOL,        /* 0x2748 */
    SYMBOL,        /* 0x2749 */
    SYMBOL,        /* 0x274a */
    SYMBOL,        /* 0x274b */
    SYMBOL,        /* 0x274c */
    SYMBOL,        /* 0x274d */
    SYMBOL,        /* 0x274e */
    SYMBOL,        /* 0x274f */
    SYMBOL,        /* 0x2750 */
    SYMBOL,        /* 0x2751 */
    SYMBOL,        /* 0x2752 */
    SYMBOL,        /* 0x2753 */
    SYMBOL,        /* 0x2754 */
    SYMBOL,        /* 0x2755 */
    SYMBOL,        /* 0x2756 */
    SYMBOL,        /* 0x2757 */
    SYMBOL,        /* 0x2758 */
    SYMBOL,        /* 0x2759 */
    SYMBOL,        /* 0x275a */
    SYMBOL,        /* 0x275b */
    SYMBOL,        /* 0x275c */
    SYMBOL,        /* 0x275d */
    SYMBOL,        /* 0x275e */
    SYMBOL,        /* 0x275f */
    SYMBOL,        /* 0x2760 */
    SYMBOL,        /* 0x2761 */
    SYMBOL,        /* 0x2762 */
    SYMBOL,        /* 0x2763 */
    SYMBOL,        /* 0x2764 */
    SYMBOL,        /* 0x2765 */
    SYMBOL,        /* 0x2766 */
    SYMBOL,        /* 0x2767 */
    SYMBOL,        /* 0x2768 */
    SYMBOL,        /* 0x2769 */
    SYMBOL,        /* 0x276a */
    SYMBOL,        /* 0x276b */
    SYMBOL,        /* 0x276c */
    SYMBOL,        /* 0x276d */
    SYMBOL,        /* 0x276e */
    SYMBOL,        /* 0x276f */
    SYMBOL,        /* 0x2770 */
    SYMBOL,        /* 0x2771 */
    SYMBOL,        /* 0x2772 */
    SYMBOL,        /* 0x2773 */
    SYMBOL,        /* 0x2774 */
    SYMBOL,        /* 0x2775 */
    SYMBOL,        /* 0x2776 */
    SYMBOL,        /* 0x2777 */
    SYMBOL,        /* 0x2778 */
    SYMBOL,        /* 0x2779 */
    SYMBOL,        /* 0x277a */
    SYMBOL,        /* 0x277b */
    SYMBOL,        /* 0x277c */
    SYMBOL,        /* 0x277d */
    SYMBOL,        /* 0x277e */
    SYMBOL,        /* 0x277f */
    SYMBOL,        /* 0x2780 */
    SYMBOL,        /* 0x2781 */
    SYMBOL,        /* 0x2782 */
    SYMBOL,        /* 0x2783 */
    SYMBOL,        /* 0x2784 */
    SYMBOL,        /* 0x2785 */
    SYMBOL,        /* 0x2786 */
    SYMBOL,        /* 0x2787 */
    SYMBOL,        /* 0x2788 */
    SYMBOL,        /* 0x2789 */
    SYMBOL,        /* 0x278a */
    SYMBOL,        /* 0x278b */
    SYMBOL,        /* 0x278c */
    SYMBOL,        /* 0x278d */
    SYMBOL,        /* 0x278e */
    SYMBOL,        /* 0x278f */
    SYMBOL,        /* 0x2790 */
    SYMBOL,        /* 0x2791 */
    SYMBOL,        /* 0x2792 */
    SYMBOL,        /* 0x2793 */
    SYMBOL,        /* 0x2794 */
    SYMBOL,        /* 0x2795 */
    SYMBOL,        /* 0x2796 */
    SYMBOL,        /* 0x2797 */
    SYMBOL,        /* 0x2798 */
    SYMBOL,        /* 0x2799 */
    SYMBOL,        /* 0x279a */
    SYMBOL,        /* 0x279b */
    SYMBOL,        /* 0x279c */
    SYMBOL,        /* 0x279d */
    SYMBOL,        /* 0x279e */
    SYMBOL,        /* 0x279f */
    SYMBOL,        /* 0x27a0 */
    SYMBOL,        /* 0x27a1 */
    SYMBOL,        /* 0x27a2 */
    SYMBOL,        /* 0x27a3 */
    SYMBOL,        /* 0x27a4 */
    SYMBOL,        /* 0x27a5 */
    SYMBOL,        /* 0x27a6 */
    SYMBOL,        /* 0x27a7 */
    SYMBOL,        /* 0x27a8 */
    SYMBOL,        /* 0x27a9 */
    SYMBOL,        /* 0x27aa */
    SYMBOL,        /* 0x27ab */
    SYMBOL,        /* 0x27ac */
    SYMBOL,        /* 0x27ad */
    SYMBOL,        /* 0x27ae */
    SYMBOL,        /* 0x27af */
    SYMBOL,        /* 0x27b0 */
    SYMBOL,        /* 0x27b1 */
    SYMBOL,        /* 0x27b2 */
    SYMBOL,        /* 0x27b3 */
    SYMBOL,        /* 0x27b4 */
    SYMBOL,        /* 0x27b5 */
    SYMBOL,        /* 0x27b6 */
    SYMBOL,        /* 0x27b7 */
    SYMBOL,        /* 0x27b8 */
    SYMBOL,        /* 0x27b9 */
    SYMBOL,        /* 0x27ba */
    SYMBOL,        /* 0x27bb */
    SYMBOL,        /* 0x27bc */
    SYMBOL,        /* 0x27bd */
    SYMBOL,        /* 0x27be */
    SYMBOL,        /* 0x27bf */
    SYMBOL,        /* 0x27c0 */
    SYMBOL,        /* 0x27c1 */
    SYMBOL,        /* 0x27c2 */
    SYMBOL,        /* 0x27c3 */
    SYMBOL,        /* 0x27c4 */
    SYMBOL,        /* 0x27c5 */
    SYMBOL,        /* 0x27c6 */
    SYMBOL,        /* 0x27c7 */
    SYMBOL,        /* 0x27c8 */
    SYMBOL,        /* 0x27c9 */
    SYMBOL,        /* 0x27ca */
    SYMBOL,        /* 0x27cb */
    SYMBOL,        /* 0x27cc */
    SYMBOL,        /* 0x27cd */
    SYMBOL,        /* 0x27ce */
    SYMBOL,        /* 0x27cf */
    SYMBOL,        /* 0x27d0 */
    SYMBOL,        /* 0x27d1 */
    SYMBOL,        /* 0x27d2 */
    SYMBOL,        /* 0x27d3 */
    SYMBOL,        /* 0x27d4 */
    SYMBOL,        /* 0x27d5 */
    SYMBOL,        /* 0x27d6 */
    SYMBOL,        /* 0x27d7 */
    SYMBOL,        /* 0x27d8 */
    SYMBOL,        /* 0x27d9 */
    SYMBOL,        /* 0x27da */
    SYMBOL,        /* 0x27db */
    SYMBOL,        /* 0x27dc */
    SYMBOL,        /* 0x27dd */
    SYMBOL,        /* 0x27de */
    SYMBOL,        /* 0x27df */
    SYMBOL,        /* 0x27e0 */
    SYMBOL,        /* 0x27e1 */
    SYMBOL,        /* 0x27e2 */
    SYMBOL,        /* 0x27e3 */
    SYMBOL,        /* 0x27e4 */
    SYMBOL,        /* 0x27e5 */
    SYMBOL,        /* 0x27e6 */
    SYMBOL,        /* 0x27e7 */
    SYMBOL,        /* 0x27e8 */
    SYMBOL,        /* 0x27e9 */
    SYMBOL,        /* 0x27ea */
    SYMBOL,        /* 0x27eb */
    SYMBOL,        /* 0x27ec */
    SYMBOL,        /* 0x27ed */
    SYMBOL,        /* 0x27ee */
    SYMBOL,        /* 0x27ef */
    SYMBOL,        /* 0x27f0 */
    SYMBOL,        /* 0x27f1 */
    SYMBOL,        /* 0x27f2 */
    SYMBOL,        /* 0x27f3 */
    SYMBOL,        /* 0x27f4 */
    SYMBOL,        /* 0x27f5 */
    SYMBOL,        /* 0x27f6 */
    SYMBOL,        /* 0x27f7 */
    SYMBOL,        /* 0x27f8 */
    SYMBOL,        /* 0x27f9 */
    SYMBOL,        /* 0x27fa */
    SYMBOL,        /* 0x27fb */
    SYMBOL,        /* 0x27fc */
    SYMBOL,        /* 0x27fd */
    SYMBOL,        /* 0x27fe */
    SYMBOL,        /* 0x27ff */
    SYMBOL,        /* 0x2800 */
    SYMBOL,        /* 0x2801 */
    SYMBOL,        /* 0x2802 */
    SYMBOL,        /* 0x2803 */
    SYMBOL,        /* 0x2804 */
    SYMBOL,        /* 0x2805 */
    SYMBOL,        /* 0x2806 */
    SYMBOL,        /* 0x2807 */
    SYMBOL,        /* 0x2808 */
    SYMBOL,        /* 0x2809 */
    SYMBOL,        /* 0x280a */
    SYMBOL,        /* 0x280b */
    SYMBOL,        /* 0x280c */
    SYMBOL,        /* 0x280d */
    SYMBOL,        /* 0x280e */
    SYMBOL,        /* 0x280f */
    SYMBOL,        /* 0x2810 */
    SYMBOL,        /* 0x2811 */
    SYMBOL,        /* 0x2812 */
    SYMBOL,        /* 0x2813 */
    SYMBOL,        /* 0x2814 */
    SYMBOL,        /* 0x2815 */
    SYMBOL,        /* 0x2816 */
    SYMBOL,        /* 0x2817 */
    SYMBOL,        /* 0x2818 */
    SYMBOL,        /* 0x2819 */
    SYMBOL,        /* 0x281a */
    SYMBOL,        /* 0x281b */
    SYMBOL,        /* 0x281c */
    SYMBOL,        /* 0x281d */
    SYMBOL,        /* 0x281e */
    SYMBOL,        /* 0x281f */
    SYMBOL,        /* 0x2820 */
    SYMBOL,        /* 0x2821 */
    SYMBOL,        /* 0x2822 */
    SYMBOL,        /* 0x2823 */
    SYMBOL,        /* 0x2824 */
    SYMBOL,        /* 0x2825 */
    SYMBOL,        /* 0x2826 */
    SYMBOL,        /* 0x2827 */
    SYMBOL,        /* 0x2828 */
    SYMBOL,        /* 0x2829 */
    SYMBOL,        /* 0x282a */
    SYMBOL,        /* 0x282b */
    SYMBOL,        /* 0x282c */
    SYMBOL,        /* 0x282d */
    SYMBOL,        /* 0x282e */
    SYMBOL,        /* 0x282f */
    SYMBOL,        /* 0x2830 */
    SYMBOL,        /* 0x2831 */
    SYMBOL,        /* 0x2832 */
    SYMBOL,        /* 0x2833 */
    SYMBOL,        /* 0x2834 */
    SYMBOL,        /* 0x2835 */
    SYMBOL,        /* 0x2836 */
    SYMBOL,        /* 0x2837 */
    SYMBOL,        /* 0x2838 */
    SYMBOL,        /* 0x2839 */
    SYMBOL,        /* 0x283a */
    SYMBOL,        /* 0x283b */
    SYMBOL,        /* 0x283c */
    SYMBOL,        /* 0x283d */
    SYMBOL,        /* 0x283e */
    SYMBOL,        /* 0x283f */
    SYMBOL,        /* 0x2840 */
    SYMBOL,        /* 0x2841 */
    SYMBOL,        /* 0x2842 */
    SYMBOL,        /* 0x2843 */
    SYMBOL,        /* 0x2844 */
    SYMBOL,        /* 0x2845 */
    SYMBOL,        /* 0x2846 */
    SYMBOL,        /* 0x2847 */
    SYMBOL,        /* 0x2848 */
    SYMBOL,        /* 0x2849 */
    SYMBOL,        /* 0x284a */
    SYMBOL,        /* 0x284b */
    SYMBOL,        /* 0x284c */
    SYMBOL,        /* 0x284d */
    SYMBOL,        /* 0x284e */
    SYMBOL,        /* 0x284f */
    SYMBOL,        /* 0x2850 */
    SYMBOL,        /* 0x2851 */
    SYMBOL,        /* 0x2852 */
    SYMBOL,        /* 0x2853 */
    SYMBOL,        /* 0x2854 */
    SYMBOL,        /* 0x2855 */
    SYMBOL,        /* 0x2856 */
    SYMBOL,        /* 0x2857 */
    SYMBOL,        /* 0x2858 */
    SYMBOL,        /* 0x2859 */
    SYMBOL,        /* 0x285a */
    SYMBOL,        /* 0x285b */
    SYMBOL,        /* 0x285c */
    SYMBOL,        /* 0x285d */
    SYMBOL,        /* 0x285e */
    SYMBOL,        /* 0x285f */
    SYMBOL,        /* 0x2860 */
    SYMBOL,        /* 0x2861 */
    SYMBOL,        /* 0x2862 */
    SYMBOL,        /* 0x2863 */
    SYMBOL,        /* 0x2864 */
    SYMBOL,        /* 0x2865 */
    SYMBOL,        /* 0x2866 */
    SYMBOL,        /* 0x2867 */
    SYMBOL,        /* 0x2868 */
    SYMBOL,        /* 0x2869 */
    SYMBOL,        /* 0x286a */
    SYMBOL,        /* 0x286b */
    SYMBOL,        /* 0x286c */
    SYMBOL,        /* 0x286d */
    SYMBOL,        /* 0x286e */
    SYMBOL,        /* 0x286f */
    SYMBOL,        /* 0x2870 */
    SYMBOL,        /* 0x2871 */
    SYMBOL,        /* 0x2872 */
    SYMBOL,        /* 0x2873 */
    SYMBOL,        /* 0x2874 */
    SYMBOL,        /* 0x2875 */
    SYMBOL,        /* 0x2876 */
    SYMBOL,        /* 0x2877 */
    SYMBOL,        /* 0x2878 */
    SYMBOL,        /* 0x2879 */
    SYMBOL,        /* 0x287a */
    SYMBOL,        /* 0x287b */
    SYMBOL,        /* 0x287c */
    SYMBOL,        /* 0x287d */
    SYMBOL,        /* 0x287e */
    SYMBOL,        /* 0x287f */
    SYMBOL,        /* 0x2880 */
    SYMBOL,        /* 0x2881 */
    SYMBOL,        /* 0x2882 */
    SYMBOL,        /* 0x2883 */
    SYMBOL,        /* 0x2884 */
    SYMBOL,        /* 0x2885 */
    SYMBOL,        /* 0x2886 */
    SYMBOL,        /* 0x2887 */
    SYMBOL,        /* 0x2888 */
    SYMBOL,        /* 0x2889 */
    SYMBOL,        /* 0x288a */
    SYMBOL,        /* 0x288b */
    SYMBOL,        /* 0x288c */
    SYMBOL,        /* 0x288d */
    SYMBOL,        /* 0x288e */
    SYMBOL,        /* 0x288f */
    SYMBOL,        /* 0x2890 */
    SYMBOL,        /* 0x2891 */
    SYMBOL,        /* 0x2892 */
    SYMBOL,        /* 0x2893 */
    SYMBOL,        /* 0x2894 */
    SYMBOL,        /* 0x2895 */
    SYMBOL,        /* 0x2896 */
    SYMBOL,        /* 0x2897 */
    SYMBOL,        /* 0x2898 */
    SYMBOL,        /* 0x2899 */
    SYMBOL,        /* 0x289a */
    SYMBOL,        /* 0x289b */
    SYMBOL,        /* 0x289c */
    SYMBOL,        /* 0x289d */
    SYMBOL,        /* 0x289e */
    SYMBOL,        /* 0x289f */
    SYMBOL,        /* 0x28a0 */
    SYMBOL,        /* 0x28a1 */
    SYMBOL,        /* 0x28a2 */
    SYMBOL,        /* 0x28a3 */
    SYMBOL,        /* 0x28a4 */
    SYMBOL,        /* 0x28a5 */
    SYMBOL,        /* 0x28a6 */
    SYMBOL,        /* 0x28a7 */
    SYMBOL,        /* 0x28a8 */
    SYMBOL,        /* 0x28a9 */
    SYMBOL,        /* 0x28aa */
    SYMBOL,        /* 0x28ab */
    SYMBOL,        /* 0x28ac */
    SYMBOL,        /* 0x28ad */
    SYMBOL,        /* 0x28ae */
    SYMBOL,        /* 0x28af */
    SYMBOL,        /* 0x28b0 */
    SYMBOL,        /* 0x28b1 */
    SYMBOL,        /* 0x28b2 */
    SYMBOL,        /* 0x28b3 */
    SYMBOL,        /* 0x28b4 */
    SYMBOL,        /* 0x28b5 */
    SYMBOL,        /* 0x28b6 */
    SYMBOL,        /* 0x28b7 */
    SYMBOL,        /* 0x28b8 */
    SYMBOL,        /* 0x28b9 */
    SYMBOL,        /* 0x28ba */
    SYMBOL,        /* 0x28bb */
    SYMBOL,        /* 0x28bc */
    SYMBOL,        /* 0x28bd */
    SYMBOL,        /* 0x28be */
    SYMBOL,        /* 0x28bf */
    SYMBOL,        /* 0x28c0 */
    SYMBOL,        /* 0x28c1 */
    SYMBOL,        /* 0x28c2 */
    SYMBOL,        /* 0x28c3 */
    SYMBOL,        /* 0x28c4 */
    SYMBOL,        /* 0x28c5 */
    SYMBOL,        /* 0x28c6 */
    SYMBOL,        /* 0x28c7 */
    SYMBOL,        /* 0x28c8 */
    SYMBOL,        /* 0x28c9 */
    SYMBOL,        /* 0x28ca */
    SYMBOL,        /* 0x28cb */
    SYMBOL,        /* 0x28cc */
    SYMBOL,        /* 0x28cd */
    SYMBOL,        /* 0x28ce */
    SYMBOL,        /* 0x28cf */
    SYMBOL,        /* 0x28d0 */
    SYMBOL,        /* 0x28d1 */
    SYMBOL,        /* 0x28d2 */
    SYMBOL,        /* 0x28d3 */
    SYMBOL,        /* 0x28d4 */
    SYMBOL,        /* 0x28d5 */
    SYMBOL,        /* 0x28d6 */
    SYMBOL,        /* 0x28d7 */
    SYMBOL,        /* 0x28d8 */
    SYMBOL,        /* 0x28d9 */
    SYMBOL,        /* 0x28da */
    SYMBOL,        /* 0x28db */
    SYMBOL,        /* 0x28dc */
    SYMBOL,        /* 0x28dd */
    SYMBOL,        /* 0x28de */
    SYMBOL,        /* 0x28df */
    SYMBOL,        /* 0x28e0 */
    SYMBOL,        /* 0x28e1 */
    SYMBOL,        /* 0x28e2 */
    SYMBOL,        /* 0x28e3 */
    SYMBOL,        /* 0x28e4 */
    SYMBOL,        /* 0x28e5 */
    SYMBOL,        /* 0x28e6 */
    SYMBOL,        /* 0x28e7 */
    SYMBOL,        /* 0x28e8 */
    SYMBOL,        /* 0x28e9 */
    SYMBOL,        /* 0x28ea */
    SYMBOL,        /* 0x28eb */
    SYMBOL,        /* 0x28ec */
    SYMBOL,        /* 0x28ed */
    SYMBOL,        /* 0x28ee */
    SYMBOL,        /* 0x28ef */
    SYMBOL,        /* 0x28f0 */
    SYMBOL,        /* 0x28f1 */
    SYMBOL,        /* 0x28f2 */
    SYMBOL,        /* 0x28f3 */
    SYMBOL,        /* 0x28f4 */
    SYMBOL,        /* 0x28f5 */
    SYMBOL,        /* 0x28f6 */
    SYMBOL,        /* 0x28f7 */
    SYMBOL,        /* 0x28f8 */
    SYMBOL,        /* 0x28f9 */
    SYMBOL,        /* 0x28fa */
    SYMBOL,        /* 0x28fb */
    SYMBOL,        /* 0x28fc */
    SYMBOL,        /* 0x28fd */
    SYMBOL,        /* 0x28fe */
    SYMBOL,        /* 0x28ff */
    SYMBOL,        /* 0x2900 */
    SYMBOL,        /* 0x2901 */
    SYMBOL,        /* 0x2902 */
    SYMBOL,        /* 0x2903 */
    SYMBOL,        /* 0x2904 */
    SYMBOL,        /* 0x2905 */
    SYMBOL,        /* 0x2906 */
    SYMBOL,        /* 0x2907 */
    SYMBOL,        /* 0x2908 */
    SYMBOL,        /* 0x2909 */
    SYMBOL,        /* 0x290a */
    SYMBOL,        /* 0x290b */
    SYMBOL,        /* 0x290c */
    SYMBOL,        /* 0x290d */
    SYMBOL,        /* 0x290e */
    SYMBOL,        /* 0x290f */
    SYMBOL,        /* 0x2910 */
    SYMBOL,        /* 0x2911 */
    SYMBOL,        /* 0x2912 */
    SYMBOL,        /* 0x2913 */
    SYMBOL,        /* 0x2914 */
    SYMBOL,        /* 0x2915 */
    SYMBOL,        /* 0x2916 */
    SYMBOL,        /* 0x2917 */
    SYMBOL,        /* 0x2918 */
    SYMBOL,        /* 0x2919 */
    SYMBOL,        /* 0x291a */
    SYMBOL,        /* 0x291b */
    SYMBOL,        /* 0x291c */
    SYMBOL,        /* 0x291d */
    SYMBOL,        /* 0x291e */
    SYMBOL,        /* 0x291f */
    SYMBOL,        /* 0x2920 */
    SYMBOL,        /* 0x2921 */
    SYMBOL,        /* 0x2922 */
    SYMBOL,        /* 0x2923 */
    SYMBOL,        /* 0x2924 */
    SYMBOL,        /* 0x2925 */
    SYMBOL,        /* 0x2926 */
    SYMBOL,        /* 0x2927 */
    SYMBOL,        /* 0x2928 */
    SYMBOL,        /* 0x2929 */
    SYMBOL,        /* 0x292a */
    SYMBOL,        /* 0x292b */
    SYMBOL,        /* 0x292c */
    SYMBOL,        /* 0x292d */
    SYMBOL,        /* 0x292e */
    SYMBOL,        /* 0x292f */
    SYMBOL,        /* 0x2930 */
    SYMBOL,        /* 0x2931 */
    SYMBOL,        /* 0x2932 */
    SYMBOL,        /* 0x2933 */
    SYMBOL,        /* 0x2934 */
    SYMBOL,        /* 0x2935 */
    SYMBOL,        /* 0x2936 */
    SYMBOL,        /* 0x2937 */
    SYMBOL,        /* 0x2938 */
    SYMBOL,        /* 0x2939 */
    SYMBOL,        /* 0x293a */
    SYMBOL,        /* 0x293b */
    SYMBOL,        /* 0x293c */
    SYMBOL,        /* 0x293d */
    SYMBOL,        /* 0x293e */
    SYMBOL,        /* 0x293f */
    SYMBOL,        /* 0x2940 */
    SYMBOL,        /* 0x2941 */
    SYMBOL,        /* 0x2942 */
    SYMBOL,        /* 0x2943 */
    SYMBOL,        /* 0x2944 */
    SYMBOL,        /* 0x2945 */
    SYMBOL,        /* 0x2946 */
    SYMBOL,        /* 0x2947 */
    SYMBOL,        /* 0x2948 */
    SYMBOL,        /* 0x2949 */
    SYMBOL,        /* 0x294a */
    SYMBOL,        /* 0x294b */
    SYMBOL,        /* 0x294c */
    SYMBOL,        /* 0x294d */
    SYMBOL,        /* 0x294e */
    SYMBOL,        /* 0x294f */
    SYMBOL,        /* 0x2950 */
    SYMBOL,        /* 0x2951 */
    SYMBOL,        /* 0x2952 */
    SYMBOL,        /* 0x2953 */
    SYMBOL,        /* 0x2954 */
    SYMBOL,        /* 0x2955 */
    SYMBOL,        /* 0x2956 */
    SYMBOL,        /* 0x2957 */
    SYMBOL,        /* 0x2958 */
    SYMBOL,        /* 0x2959 */
    SYMBOL,        /* 0x295a */
    SYMBOL,        /* 0x295b */
    SYMBOL,        /* 0x295c */
    SYMBOL,        /* 0x295d */
    SYMBOL,        /* 0x295e */
    SYMBOL,        /* 0x295f */
    SYMBOL,        /* 0x2960 */
    SYMBOL,        /* 0x2961 */
    SYMBOL,        /* 0x2962 */
    SYMBOL,        /* 0x2963 */
    SYMBOL,        /* 0x2964 */
    SYMBOL,        /* 0x2965 */
    SYMBOL,        /* 0x2966 */
    SYMBOL,        /* 0x2967 */
    SYMBOL,        /* 0x2968 */
    SYMBOL,        /* 0x2969 */
    SYMBOL,        /* 0x296a */
    SYMBOL,        /* 0x296b */
    SYMBOL,        /* 0x296c */
    SYMBOL,        /* 0x296d */
    SYMBOL,        /* 0x296e */
    SYMBOL,        /* 0x296f */
    SYMBOL,        /* 0x2970 */
    SYMBOL,        /* 0x2971 */
    SYMBOL,        /* 0x2972 */
    SYMBOL,        /* 0x2973 */
    SYMBOL,        /* 0x2974 */
    SYMBOL,        /* 0x2975 */
    SYMBOL,        /* 0x2976 */
    SYMBOL,        /* 0x2977 */
    SYMBOL,        /* 0x2978 */
    SYMBOL,        /* 0x2979 */
    SYMBOL,        /* 0x297a */
    SYMBOL,        /* 0x297b */
    SYMBOL,        /* 0x297c */
    SYMBOL,        /* 0x297d */
    SYMBOL,        /* 0x297e */
    SYMBOL,        /* 0x297f */
    OTHER,        /* 0x2980 */
    OTHER,        /* 0x2981 */
    OTHER,        /* 0x2982 */
    OTHER,        /* 0x2983 */
    OTHER,        /* 0x2984 */
    OTHER,        /* 0x2985 */
    OTHER,        /* 0x2986 */
    OTHER,        /* 0x2987 */
    OTHER,        /* 0x2988 */
    OTHER,        /* 0x2989 */
    OTHER,        /* 0x298a */
    OTHER,        /* 0x298b */
    OTHER,        /* 0x298c */
    OTHER,        /* 0x298d */
    OTHER,        /* 0x298e */
    OTHER,        /* 0x298f */
    OTHER,        /* 0x2990 */
    OTHER,        /* 0x2991 */
    OTHER,        /* 0x2992 */
    OTHER,        /* 0x2993 */
    OTHER,        /* 0x2994 */
    OTHER,        /* 0x2995 */
    OTHER,        /* 0x2996 */
    OTHER,        /* 0x2997 */
    OTHER,        /* 0x2998 */
    OTHER,        /* 0x2999 */
    OTHER,        /* 0x299a */
    OTHER,        /* 0x299b */
    OTHER,        /* 0x299c */
    OTHER,        /* 0x299d */
    OTHER,        /* 0x299e */
    OTHER,        /* 0x299f */
    OTHER,        /* 0x29a0 */
    OTHER,        /* 0x29a1 */
    OTHER,        /* 0x29a2 */
    OTHER,        /* 0x29a3 */
    OTHER,        /* 0x29a4 */
    OTHER,        /* 0x29a5 */
    OTHER,        /* 0x29a6 */
    OTHER,        /* 0x29a7 */
    OTHER,        /* 0x29a8 */
    OTHER,        /* 0x29a9 */
    OTHER,        /* 0x29aa */
    OTHER,        /* 0x29ab */
    OTHER,        /* 0x29ac */
    OTHER,        /* 0x29ad */
    OTHER,        /* 0x29ae */
    OTHER,        /* 0x29af */
    OTHER,        /* 0x29b0 */
    OTHER,        /* 0x29b1 */
    OTHER,        /* 0x29b2 */
    OTHER,        /* 0x29b3 */
    OTHER,        /* 0x29b4 */
    OTHER,        /* 0x29b5 */
    OTHER,        /* 0x29b6 */
    OTHER,        /* 0x29b7 */
    OTHER,        /* 0x29b8 */
    OTHER,        /* 0x29b9 */
    OTHER,        /* 0x29ba */
    OTHER,        /* 0x29bb */
    OTHER,        /* 0x29bc */
    OTHER,        /* 0x29bd */
    OTHER,        /* 0x29be */
    OTHER,        /* 0x29bf */
    OTHER,        /* 0x29c0 */
    OTHER,        /* 0x29c1 */
    OTHER,        /* 0x29c2 */
    OTHER,        /* 0x29c3 */
    OTHER,        /* 0x29c4 */
    OTHER,        /* 0x29c5 */
    OTHER,        /* 0x29c6 */
    OTHER,        /* 0x29c7 */
    OTHER,        /* 0x29c8 */
    OTHER,        /* 0x29c9 */
    OTHER,        /* 0x29ca */
    OTHER,        /* 0x29cb */
    OTHER,        /* 0x29cc */
    OTHER,        /* 0x29cd */
    OTHER,        /* 0x29ce */
    OTHER,        /* 0x29cf */
    OTHER,        /* 0x29d0 */
    OTHER,        /* 0x29d1 */
    OTHER,        /* 0x29d2 */
    OTHER,        /* 0x29d3 */
    OTHER,        /* 0x29d4 */
    OTHER,        /* 0x29d5 */
    OTHER,        /* 0x29d6 */
    OTHER,        /* 0x29d7 */
    OTHER,        /* 0x29d8 */
    OTHER,        /* 0x29d9 */
    OTHER,        /* 0x29da */
    OTHER,        /* 0x29db */
    OTHER,        /* 0x29dc */
    OTHER,        /* 0x29dd */
    OTHER,        /* 0x29de */
    OTHER,        /* 0x29df */
    OTHER,        /* 0x29e0 */
    OTHER,        /* 0x29e1 */
    OTHER,        /* 0x29e2 */
    OTHER,        /* 0x29e3 */
    OTHER,        /* 0x29e4 */
    OTHER,        /* 0x29e5 */
    OTHER,        /* 0x29e6 */
    OTHER,        /* 0x29e7 */
    OTHER,        /* 0x29e8 */
    OTHER,        /* 0x29e9 */
    OTHER,        /* 0x29ea */
    OTHER,        /* 0x29eb */
    OTHER,        /* 0x29ec */
    OTHER,        /* 0x29ed */
    OTHER,        /* 0x29ee */
    OTHER,        /* 0x29ef */
    OTHER,        /* 0x29f0 */
    OTHER,        /* 0x29f1 */
    OTHER,        /* 0x29f2 */
    OTHER,        /* 0x29f3 */
    OTHER,        /* 0x29f4 */
    OTHER,        /* 0x29f5 */
    OTHER,        /* 0x29f6 */
    OTHER,        /* 0x29f7 */
    OTHER,        /* 0x29f8 */
    OTHER,        /* 0x29f9 */
    OTHER,        /* 0x29fa */
    OTHER,        /* 0x29fb */
    OTHER,        /* 0x29fc */
    OTHER,        /* 0x29fd */
    OTHER,        /* 0x29fe */
    OTHER,        /* 0x29ff */
    SYMBOL,        /* 0x2a00 */
    SYMBOL,        /* 0x2a01 */
    SYMBOL,        /* 0x2a02 */
    SYMBOL,        /* 0x2a03 */
    SYMBOL,        /* 0x2a04 */
    SYMBOL,        /* 0x2a05 */
    SYMBOL,        /* 0x2a06 */
    SYMBOL,        /* 0x2a07 */
    SYMBOL,        /* 0x2a08 */
    SYMBOL,        /* 0x2a09 */
    SYMBOL,        /* 0x2a0a */
    SYMBOL,        /* 0x2a0b */
    SYMBOL,        /* 0x2a0c */
    SYMBOL,        /* 0x2a0d */
    SYMBOL,        /* 0x2a0e */
    SYMBOL,        /* 0x2a0f */
    SYMBOL,        /* 0x2a10 */
    SYMBOL,        /* 0x2a11 */
    SYMBOL,        /* 0x2a12 */
    SYMBOL,        /* 0x2a13 */
    SYMBOL,        /* 0x2a14 */
    SYMBOL,        /* 0x2a15 */
    SYMBOL,        /* 0x2a16 */
    SYMBOL,        /* 0x2a17 */
    SYMBOL,        /* 0x2a18 */
    SYMBOL,        /* 0x2a19 */
    SYMBOL,        /* 0x2a1a */
    SYMBOL,        /* 0x2a1b */
    SYMBOL,        /* 0x2a1c */
    SYMBOL,        /* 0x2a1d */
    SYMBOL,        /* 0x2a1e */
    SYMBOL,        /* 0x2a1f */
    SYMBOL,        /* 0x2a20 */
    SYMBOL,        /* 0x2a21 */
    SYMBOL,        /* 0x2a22 */
    SYMBOL,        /* 0x2a23 */
    SYMBOL,        /* 0x2a24 */
    SYMBOL,        /* 0x2a25 */
    SYMBOL,        /* 0x2a26 */
    SYMBOL,        /* 0x2a27 */
    SYMBOL,        /* 0x2a28 */
    SYMBOL,        /* 0x2a29 */
    SYMBOL,        /* 0x2a2a */
    SYMBOL,        /* 0x2a2b */
    SYMBOL,        /* 0x2a2c */
    SYMBOL,        /* 0x2a2d */
    SYMBOL,        /* 0x2a2e */
    SYMBOL,        /* 0x2a2f */
    SYMBOL,        /* 0x2a30 */
    SYMBOL,        /* 0x2a31 */
    SYMBOL,        /* 0x2a32 */
    SYMBOL,        /* 0x2a33 */
    SYMBOL,        /* 0x2a34 */
    SYMBOL,        /* 0x2a35 */
    SYMBOL,        /* 0x2a36 */
    SYMBOL,        /* 0x2a37 */
    SYMBOL,        /* 0x2a38 */
    SYMBOL,        /* 0x2a39 */
    SYMBOL,        /* 0x2a3a */
    SYMBOL,        /* 0x2a3b */
    SYMBOL,        /* 0x2a3c */
    SYMBOL,        /* 0x2a3d */
    SYMBOL,        /* 0x2a3e */
    SYMBOL,        /* 0x2a3f */
    SYMBOL,        /* 0x2a40 */
    SYMBOL,        /* 0x2a41 */
    SYMBOL,        /* 0x2a42 */
    SYMBOL,        /* 0x2a43 */
    SYMBOL,        /* 0x2a44 */
    SYMBOL,        /* 0x2a45 */
    SYMBOL,        /* 0x2a46 */
    SYMBOL,        /* 0x2a47 */
    SYMBOL,        /* 0x2a48 */
    SYMBOL,        /* 0x2a49 */
    SYMBOL,        /* 0x2a4a */
    SYMBOL,        /* 0x2a4b */
    SYMBOL,        /* 0x2a4c */
    SYMBOL,        /* 0x2a4d */
    SYMBOL,        /* 0x2a4e */
    SYMBOL,        /* 0x2a4f */
    SYMBOL,        /* 0x2a50 */
    SYMBOL,        /* 0x2a51 */
    SYMBOL,        /* 0x2a52 */
    SYMBOL,        /* 0x2a53 */
    SYMBOL,        /* 0x2a54 */
    SYMBOL,        /* 0x2a55 */
    SYMBOL,        /* 0x2a56 */
    SYMBOL,        /* 0x2a57 */
    SYMBOL,        /* 0x2a58 */
    SYMBOL,        /* 0x2a59 */
    SYMBOL,        /* 0x2a5a */
    SYMBOL,        /* 0x2a5b */
    SYMBOL,        /* 0x2a5c */
    SYMBOL,        /* 0x2a5d */
    SYMBOL,        /* 0x2a5e */
    SYMBOL,        /* 0x2a5f */
    SYMBOL,        /* 0x2a60 */
    SYMBOL,        /* 0x2a61 */
    SYMBOL,        /* 0x2a62 */
    SYMBOL,        /* 0x2a63 */
    SYMBOL,        /* 0x2a64 */
    SYMBOL,        /* 0x2a65 */
    SYMBOL,        /* 0x2a66 */
    SYMBOL,        /* 0x2a67 */
    SYMBOL,        /* 0x2a68 */
    SYMBOL,        /* 0x2a69 */
    SYMBOL,        /* 0x2a6a */
    SYMBOL,        /* 0x2a6b */
    SYMBOL,        /* 0x2a6c */
    SYMBOL,        /* 0x2a6d */
    SYMBOL,        /* 0x2a6e */
    SYMBOL,        /* 0x2a6f */
    SYMBOL,        /* 0x2a70 */
    SYMBOL,        /* 0x2a71 */
    SYMBOL,        /* 0x2a72 */
    SYMBOL,        /* 0x2a73 */
    SYMBOL,        /* 0x2a74 */
    SYMBOL,        /* 0x2a75 */
    SYMBOL,        /* 0x2a76 */
    SYMBOL,        /* 0x2a77 */
    SYMBOL,        /* 0x2a78 */
    SYMBOL,        /* 0x2a79 */
    SYMBOL,        /* 0x2a7a */
    SYMBOL,        /* 0x2a7b */
    SYMBOL,        /* 0x2a7c */
    SYMBOL,        /* 0x2a7d */
    SYMBOL,        /* 0x2a7e */
    SYMBOL,        /* 0x2a7f */
    SYMBOL,        /* 0x2a80 */
    SYMBOL,        /* 0x2a81 */
    SYMBOL,        /* 0x2a82 */
    SYMBOL,        /* 0x2a83 */
    SYMBOL,        /* 0x2a84 */
    SYMBOL,        /* 0x2a85 */
    SYMBOL,        /* 0x2a86 */
    SYMBOL,        /* 0x2a87 */
    SYMBOL,        /* 0x2a88 */
    SYMBOL,        /* 0x2a89 */
    SYMBOL,        /* 0x2a8a */
    SYMBOL,        /* 0x2a8b */
    SYMBOL,        /* 0x2a8c */
    SYMBOL,        /* 0x2a8d */
    SYMBOL,        /* 0x2a8e */
    SYMBOL,        /* 0x2a8f */
    SYMBOL,        /* 0x2a90 */
    SYMBOL,        /* 0x2a91 */
    SYMBOL,        /* 0x2a92 */
    SYMBOL,        /* 0x2a93 */
    SYMBOL,        /* 0x2a94 */
    SYMBOL,        /* 0x2a95 */
    SYMBOL,        /* 0x2a96 */
    SYMBOL,        /* 0x2a97 */
    SYMBOL,        /* 0x2a98 */
    SYMBOL,        /* 0x2a99 */
    SYMBOL,        /* 0x2a9a */
    SYMBOL,        /* 0x2a9b */
    SYMBOL,        /* 0x2a9c */
    SYMBOL,        /* 0x2a9d */
    SYMBOL,        /* 0x2a9e */
    SYMBOL,        /* 0x2a9f */
    SYMBOL,        /* 0x2aa0 */
    SYMBOL,        /* 0x2aa1 */
    SYMBOL,        /* 0x2aa2 */
    SYMBOL,        /* 0x2aa3 */
    SYMBOL,        /* 0x2aa4 */
    SYMBOL,        /* 0x2aa5 */
    SYMBOL,        /* 0x2aa6 */
    SYMBOL,        /* 0x2aa7 */
    SYMBOL,        /* 0x2aa8 */
    SYMBOL,        /* 0x2aa9 */
    SYMBOL,        /* 0x2aaa */
    SYMBOL,        /* 0x2aab */
    SYMBOL,        /* 0x2aac */
    SYMBOL,        /* 0x2aad */
    SYMBOL,        /* 0x2aae */
    SYMBOL,        /* 0x2aaf */
    SYMBOL,        /* 0x2ab0 */
    SYMBOL,        /* 0x2ab1 */
    SYMBOL,        /* 0x2ab2 */
    SYMBOL,        /* 0x2ab3 */
    SYMBOL,        /* 0x2ab4 */
    SYMBOL,        /* 0x2ab5 */
    SYMBOL,        /* 0x2ab6 */
    SYMBOL,        /* 0x2ab7 */
    SYMBOL,        /* 0x2ab8 */
    SYMBOL,        /* 0x2ab9 */
    SYMBOL,        /* 0x2aba */
    SYMBOL,        /* 0x2abb */
    SYMBOL,        /* 0x2abc */
    SYMBOL,        /* 0x2abd */
    SYMBOL,        /* 0x2abe */
    SYMBOL,        /* 0x2abf */
    SYMBOL,        /* 0x2ac0 */
    SYMBOL,        /* 0x2ac1 */
    SYMBOL,        /* 0x2ac2 */
    SYMBOL,        /* 0x2ac3 */
    SYMBOL,        /* 0x2ac4 */
    SYMBOL,        /* 0x2ac5 */
    SYMBOL,        /* 0x2ac6 */
    SYMBOL,        /* 0x2ac7 */
    SYMBOL,        /* 0x2ac8 */
    SYMBOL,        /* 0x2ac9 */
    SYMBOL,        /* 0x2aca */
    SYMBOL,        /* 0x2acb */
    SYMBOL,        /* 0x2acc */
    SYMBOL,        /* 0x2acd */
    SYMBOL,        /* 0x2ace */
    SYMBOL,        /* 0x2acf */
    SYMBOL,        /* 0x2ad0 */
    SYMBOL,        /* 0x2ad1 */
    SYMBOL,        /* 0x2ad2 */
    SYMBOL,        /* 0x2ad3 */
    SYMBOL,        /* 0x2ad4 */
    SYMBOL,        /* 0x2ad5 */
    SYMBOL,        /* 0x2ad6 */
    SYMBOL,        /* 0x2ad7 */
    SYMBOL,        /* 0x2ad8 */
    SYMBOL,        /* 0x2ad9 */
    SYMBOL,        /* 0x2ada */
    SYMBOL,        /* 0x2adb */
    SYMBOL,        /* 0x2adc */
    SYMBOL,        /* 0x2add */
    SYMBOL,        /* 0x2ade */
    SYMBOL,        /* 0x2adf */
    SYMBOL,        /* 0x2ae0 */
    SYMBOL,        /* 0x2ae1 */
    SYMBOL,        /* 0x2ae2 */
    SYMBOL,        /* 0x2ae3 */
    SYMBOL,        /* 0x2ae4 */
    SYMBOL,        /* 0x2ae5 */
    SYMBOL,        /* 0x2ae6 */
    SYMBOL,        /* 0x2ae7 */
    SYMBOL,        /* 0x2ae8 */
    SYMBOL,        /* 0x2ae9 */
    SYMBOL,        /* 0x2aea */
    SYMBOL,        /* 0x2aeb */
    SYMBOL,        /* 0x2aec */
    SYMBOL,        /* 0x2aed */
    SYMBOL,        /* 0x2aee */
    SYMBOL,        /* 0x2aef */
    SYMBOL,        /* 0x2af0 */
    SYMBOL,        /* 0x2af1 */
    SYMBOL,        /* 0x2af2 */
    SYMBOL,        /* 0x2af3 */
    SYMBOL,        /* 0x2af4 */
    SYMBOL,        /* 0x2af5 */
    SYMBOL,        /* 0x2af6 */
    SYMBOL,        /* 0x2af7 */
    SYMBOL,        /* 0x2af8 */
    SYMBOL,        /* 0x2af9 */
    SYMBOL,        /* 0x2afa */
    SYMBOL,        /* 0x2afb */
    SYMBOL,        /* 0x2afc */
    SYMBOL,        /* 0x2afd */
    SYMBOL,        /* 0x2afe */
    SYMBOL,        /* 0x2aff */
    SYMBOL,        /* 0x2b00 */
    SYMBOL,        /* 0x2b01 */
    SYMBOL,        /* 0x2b02 */
    SYMBOL,        /* 0x2b03 */
    SYMBOL,        /* 0x2b04 */
    SYMBOL,        /* 0x2b05 */
    SYMBOL,        /* 0x2b06 */
    SYMBOL,        /* 0x2b07 */
    SYMBOL,        /* 0x2b08 */
    SYMBOL,        /* 0x2b09 */
    SYMBOL,        /* 0x2b0a */
    SYMBOL,        /* 0x2b0b */
    SYMBOL,        /* 0x2b0c */
    SYMBOL,        /* 0x2b0d */
    SYMBOL,        /* 0x2b0e */
    SYMBOL,        /* 0x2b0f */
    SYMBOL,        /* 0x2b10 */
    SYMBOL,        /* 0x2b11 */
    SYMBOL,        /* 0x2b12 */
    SYMBOL,        /* 0x2b13 */
    SYMBOL,        /* 0x2b14 */
    SYMBOL,        /* 0x2b15 */
    SYMBOL,        /* 0x2b16 */
    SYMBOL,        /* 0x2b17 */
    SYMBOL,        /* 0x2b18 */
    SYMBOL,        /* 0x2b19 */
    SYMBOL,        /* 0x2b1a */
    SYMBOL,        /* 0x2b1b */
    SYMBOL,        /* 0x2b1c */
    SYMBOL,        /* 0x2b1d */
    SYMBOL,        /* 0x2b1e */
    SYMBOL,        /* 0x2b1f */
    SYMBOL,        /* 0x2b20 */
    SYMBOL,        /* 0x2b21 */
    SYMBOL,        /* 0x2b22 */
    SYMBOL,        /* 0x2b23 */
    SYMBOL,        /* 0x2b24 */
    SYMBOL,        /* 0x2b25 */
    SYMBOL,        /* 0x2b26 */
    SYMBOL,        /* 0x2b27 */
    SYMBOL,        /* 0x2b28 */
    SYMBOL,        /* 0x2b29 */
    SYMBOL,        /* 0x2b2a */
    SYMBOL,        /* 0x2b2b */
    SYMBOL,        /* 0x2b2c */
    SYMBOL,        /* 0x2b2d */
    SYMBOL,        /* 0x2b2e */
    SYMBOL,        /* 0x2b2f */
    SYMBOL,        /* 0x2b30 */
    SYMBOL,        /* 0x2b31 */
    SYMBOL,        /* 0x2b32 */
    SYMBOL,        /* 0x2b33 */
    SYMBOL,        /* 0x2b34 */
    SYMBOL,        /* 0x2b35 */
    SYMBOL,        /* 0x2b36 */
    SYMBOL,        /* 0x2b37 */
    SYMBOL,        /* 0x2b38 */
    SYMBOL,        /* 0x2b39 */
    SYMBOL,        /* 0x2b3a */
    SYMBOL,        /* 0x2b3b */
    SYMBOL,        /* 0x2b3c */
    SYMBOL,        /* 0x2b3d */
    SYMBOL,        /* 0x2b3e */
    SYMBOL,        /* 0x2b3f */
    SYMBOL,        /* 0x2b40 */
    SYMBOL,        /* 0x2b41 */
    SYMBOL,        /* 0x2b42 */
    SYMBOL,        /* 0x2b43 */
    SYMBOL,        /* 0x2b44 */
    SYMBOL,        /* 0x2b45 */
    SYMBOL,        /* 0x2b46 */
    SYMBOL,        /* 0x2b47 */
    SYMBOL,        /* 0x2b48 */
    SYMBOL,        /* 0x2b49 */
    SYMBOL,        /* 0x2b4a */
    SYMBOL,        /* 0x2b4b */
    SYMBOL,        /* 0x2b4c */
    SYMBOL,        /* 0x2b4d */
    SYMBOL,        /* 0x2b4e */
    SYMBOL,        /* 0x2b4f */
    SYMBOL,        /* 0x2b50 */
    SYMBOL,        /* 0x2b51 */
    SYMBOL,        /* 0x2b52 */
    SYMBOL,        /* 0x2b53 */
    SYMBOL,        /* 0x2b54 */
    SYMBOL,        /* 0x2b55 */
    SYMBOL,        /* 0x2b56 */
    SYMBOL,        /* 0x2b57 */
    SYMBOL,        /* 0x2b58 */
    SYMBOL,        /* 0x2b59 */
    SYMBOL,        /* 0x2b5a */
    SYMBOL,        /* 0x2b5b */
    SYMBOL,        /* 0x2b5c */
    SYMBOL,        /* 0x2b5d */
    SYMBOL,        /* 0x2b5e */
    SYMBOL,        /* 0x2b5f */
    SYMBOL,        /* 0x2b60 */
    SYMBOL,        /* 0x2b61 */
    SYMBOL,        /* 0x2b62 */
    SYMBOL,        /* 0x2b63 */
    SYMBOL,        /* 0x2b64 */
    SYMBOL,        /* 0x2b65 */
    SYMBOL,        /* 0x2b66 */
    SYMBOL,        /* 0x2b67 */
    SYMBOL,        /* 0x2b68 */
    SYMBOL,        /* 0x2b69 */
    SYMBOL,        /* 0x2b6a */
    SYMBOL,        /* 0x2b6b */
    SYMBOL,        /* 0x2b6c */
    SYMBOL,        /* 0x2b6d */
    SYMBOL,        /* 0x2b6e */
    SYMBOL,        /* 0x2b6f */
    SYMBOL,        /* 0x2b70 */
    SYMBOL,        /* 0x2b71 */
    SYMBOL,        /* 0x2b72 */
    SYMBOL,        /* 0x2b73 */
    SYMBOL,        /* 0x2b74 */
    SYMBOL,        /* 0x2b75 */
    SYMBOL,        /* 0x2b76 */
    SYMBOL,        /* 0x2b77 */
    SYMBOL,        /* 0x2b78 */
    SYMBOL,        /* 0x2b79 */
    SYMBOL,        /* 0x2b7a */
    SYMBOL,        /* 0x2b7b */
    SYMBOL,        /* 0x2b7c */
    SYMBOL,        /* 0x2b7d */
    SYMBOL,        /* 0x2b7e */
    SYMBOL,        /* 0x2b7f */
    SYMBOL,        /* 0x2b80 */
    SYMBOL,        /* 0x2b81 */
    SYMBOL,        /* 0x2b82 */
    SYMBOL,        /* 0x2b83 */
    SYMBOL,        /* 0x2b84 */
    SYMBOL,        /* 0x2b85 */
    SYMBOL,        /* 0x2b86 */
    SYMBOL,        /* 0x2b87 */
    SYMBOL,        /* 0x2b88 */
    SYMBOL,        /* 0x2b89 */
    SYMBOL,        /* 0x2b8a */
    SYMBOL,        /* 0x2b8b */
    SYMBOL,        /* 0x2b8c */
    SYMBOL,        /* 0x2b8d */
    SYMBOL,        /* 0x2b8e */
    SYMBOL,        /* 0x2b8f */
    SYMBOL,        /* 0x2b90 */
    SYMBOL,        /* 0x2b91 */
    SYMBOL,        /* 0x2b92 */
    SYMBOL,        /* 0x2b93 */
    SYMBOL,        /* 0x2b94 */
    SYMBOL,        /* 0x2b95 */
    SYMBOL,        /* 0x2b96 */
    SYMBOL,        /* 0x2b97 */
    SYMBOL,        /* 0x2b98 */
    SYMBOL,        /* 0x2b99 */
    SYMBOL,        /* 0x2b9a */
    SYMBOL,        /* 0x2b9b */
    SYMBOL,        /* 0x2b9c */
    SYMBOL,        /* 0x2b9d */
    SYMBOL,        /* 0x2b9e */
    SYMBOL,        /* 0x2b9f */
    SYMBOL,        /* 0x2ba0 */
    SYMBOL,        /* 0x2ba1 */
    SYMBOL,        /* 0x2ba2 */
    SYMBOL,        /* 0x2ba3 */
    SYMBOL,        /* 0x2ba4 */
    SYMBOL,        /* 0x2ba5 */
    SYMBOL,        /* 0x2ba6 */
    SYMBOL,        /* 0x2ba7 */
    SYMBOL,        /* 0x2ba8 */
    SYMBOL,        /* 0x2ba9 */
    SYMBOL,        /* 0x2baa */
    SYMBOL,        /* 0x2bab */
    SYMBOL,        /* 0x2bac */
    SYMBOL,        /* 0x2bad */
    SYMBOL,        /* 0x2bae */
    SYMBOL,        /* 0x2baf */
    SYMBOL,        /* 0x2bb0 */
    SYMBOL,        /* 0x2bb1 */
    SYMBOL,        /* 0x2bb2 */
    SYMBOL,        /* 0x2bb3 */
    SYMBOL,        /* 0x2bb4 */
    SYMBOL,        /* 0x2bb5 */
    SYMBOL,        /* 0x2bb6 */
    SYMBOL,        /* 0x2bb7 */
    SYMBOL,        /* 0x2bb8 */
    SYMBOL,        /* 0x2bb9 */
    SYMBOL,        /* 0x2bba */
    SYMBOL,        /* 0x2bbb */
    SYMBOL,        /* 0x2bbc */
    SYMBOL,        /* 0x2bbd */
    SYMBOL,        /* 0x2bbe */
    SYMBOL,        /* 0x2bbf */
    SYMBOL,        /* 0x2bc0 */
    SYMBOL,        /* 0x2bc1 */
    SYMBOL,        /* 0x2bc2 */
    SYMBOL,        /* 0x2bc3 */
    SYMBOL,        /* 0x2bc4 */
    SYMBOL,        /* 0x2bc5 */
    SYMBOL,        /* 0x2bc6 */
    SYMBOL,        /* 0x2bc7 */
    SYMBOL,        /* 0x2bc8 */
    SYMBOL,        /* 0x2bc9 */
    SYMBOL,        /* 0x2bca */
    SYMBOL,        /* 0x2bcb */
    SYMBOL,        /* 0x2bcc */
    SYMBOL,        /* 0x2bcd */
    SYMBOL,        /* 0x2bce */
    SYMBOL,        /* 0x2bcf */
    SYMBOL,        /* 0x2bd0 */
    SYMBOL,        /* 0x2bd1 */
    SYMBOL,        /* 0x2bd2 */
    SYMBOL,        /* 0x2bd3 */
    SYMBOL,        /* 0x2bd4 */
    SYMBOL,        /* 0x2bd5 */
    SYMBOL,        /* 0x2bd6 */
    SYMBOL,        /* 0x2bd7 */
    SYMBOL,        /* 0x2bd8 */
    SYMBOL,        /* 0x2bd9 */
    SYMBOL,        /* 0x2bda */
    SYMBOL,        /* 0x2bdb */
    SYMBOL,        /* 0x2bdc */
    SYMBOL,        /* 0x2bdd */
    SYMBOL,        /* 0x2bde */
    SYMBOL,        /* 0x2bdf */
    SYMBOL,        /* 0x2be0 */
    SYMBOL,        /* 0x2be1 */
    SYMBOL,        /* 0x2be2 */
    SYMBOL,        /* 0x2be3 */
    SYMBOL,        /* 0x2be4 */
    SYMBOL,        /* 0x2be5 */
    SYMBOL,        /* 0x2be6 */
    SYMBOL,        /* 0x2be7 */
    SYMBOL,        /* 0x2be8 */
    SYMBOL,        /* 0x2be9 */
    SYMBOL,        /* 0x2bea */
    SYMBOL,        /* 0x2beb */
    SYMBOL,        /* 0x2bec */
    SYMBOL,        /* 0x2bed */
    SYMBOL,        /* 0x2bee */
    SYMBOL,        /* 0x2bef */
    SYMBOL,        /* 0x2bf0 */
    SYMBOL,        /* 0x2bf1 */
    SYMBOL,        /* 0x2bf2 */
    SYMBOL,        /* 0x2bf3 */
    SYMBOL,        /* 0x2bf4 */
    SYMBOL,        /* 0x2bf5 */
    SYMBOL,        /* 0x2bf6 */
    SYMBOL,        /* 0x2bf7 */
    SYMBOL,        /* 0x2bf8 */
    SYMBOL,        /* 0x2bf9 */
    SYMBOL,        /* 0x2bfa */
    SYMBOL,        /* 0x2bfb */
    SYMBOL,        /* 0x2bfc */
    SYMBOL,        /* 0x2bfd */
    SYMBOL,        /* 0x2bfe */
    SYMBOL,        /* 0x2bff */
    OTHER,        /* 0x2c00 */
    OTHER,        /* 0x2c01 */
    OTHER,        /* 0x2c02 */
    OTHER,        /* 0x2c03 */
    OTHER,        /* 0x2c04 */
    OTHER,        /* 0x2c05 */
    OTHER,        /* 0x2c06 */
    OTHER,        /* 0x2c07 */
    OTHER,        /* 0x2c08 */
    OTHER,        /* 0x2c09 */
    OTHER,        /* 0x2c0a */
    OTHER,        /* 0x2c0b */
    OTHER,        /* 0x2c0c */
    OTHER,        /* 0x2c0d */
    OTHER,        /* 0x2c0e */
    OTHER,        /* 0x2c0f */
    OTHER,        /* 0x2c10 */
    OTHER,        /* 0x2c11 */
    OTHER,        /* 0x2c12 */
    OTHER,        /* 0x2c13 */
    OTHER,        /* 0x2c14 */
    OTHER,        /* 0x2c15 */
    OTHER,        /* 0x2c16 */
    OTHER,        /* 0x2c17 */
    OTHER,        /* 0x2c18 */
    OTHER,        /* 0x2c19 */
    OTHER,        /* 0x2c1a */
    OTHER,        /* 0x2c1b */
    OTHER,        /* 0x2c1c */
    OTHER,        /* 0x2c1d */
    OTHER,        /* 0x2c1e */
    OTHER,        /* 0x2c1f */
    OTHER,        /* 0x2c20 */
    OTHER,        /* 0x2c21 */
    OTHER,        /* 0x2c22 */
    OTHER,        /* 0x2c23 */
    OTHER,        /* 0x2c24 */
    OTHER,        /* 0x2c25 */
    OTHER,        /* 0x2c26 */
    OTHER,        /* 0x2c27 */
    OTHER,        /* 0x2c28 */
    OTHER,        /* 0x2c29 */
    OTHER,        /* 0x2c2a */
    OTHER,        /* 0x2c2b */
    OTHER,        /* 0x2c2c */
    OTHER,        /* 0x2c2d */
    OTHER,        /* 0x2c2e */
    OTHER,        /* 0x2c2f */
    OTHER,        /* 0x2c30 */
    OTHER,        /* 0x2c31 */
    OTHER,        /* 0x2c32 */
    OTHER,        /* 0x2c33 */
    OTHER,        /* 0x2c34 */
    OTHER,        /* 0x2c35 */
    OTHER,        /* 0x2c36 */
    OTHER,        /* 0x2c37 */
    OTHER,        /* 0x2c38 */
    OTHER,        /* 0x2c39 */
    OTHER,        /* 0x2c3a */
    OTHER,        /* 0x2c3b */
    OTHER,        /* 0x2c3c */
    OTHER,        /* 0x2c3d */
    OTHER,        /* 0x2c3e */
    OTHER,        /* 0x2c3f */
    OTHER,        /* 0x2c40 */
    OTHER,        /* 0x2c41 */
    OTHER,        /* 0x2c42 */
    OTHER,        /* 0x2c43 */
    OTHER,        /* 0x2c44 */
    OTHER,        /* 0x2c45 */
    OTHER,        /* 0x2c46 */
    OTHER,        /* 0x2c47 */
    OTHER,        /* 0x2c48 */
    OTHER,        /* 0x2c49 */
    OTHER,        /* 0x2c4a */
    OTHER,        /* 0x2c4b */
    OTHER,        /* 0x2c4c */
    OTHER,        /* 0x2c4d */
    OTHER,        /* 0x2c4e */
    OTHER,        /* 0x2c4f */
    OTHER,        /* 0x2c50 */
    OTHER,        /* 0x2c51 */
    OTHER,        /* 0x2c52 */
    OTHER,        /* 0x2c53 */
    OTHER,        /* 0x2c54 */
    OTHER,        /* 0x2c55 */
    OTHER,        /* 0x2c56 */
    OTHER,        /* 0x2c57 */
    OTHER,        /* 0x2c58 */
    OTHER,        /* 0x2c59 */
    OTHER,        /* 0x2c5a */
    OTHER,        /* 0x2c5b */
    OTHER,        /* 0x2c5c */
    OTHER,        /* 0x2c5d */
    OTHER,        /* 0x2c5e */
    OTHER,        /* 0x2c5f */
    OTHER,        /* 0x2c60 */
    OTHER,        /* 0x2c61 */
    OTHER,        /* 0x2c62 */
    OTHER,        /* 0x2c63 */
    OTHER,        /* 0x2c64 */
    OTHER,        /* 0x2c65 */
    OTHER,        /* 0x2c66 */
    OTHER,        /* 0x2c67 */
    OTHER,        /* 0x2c68 */
    OTHER,        /* 0x2c69 */
    OTHER,        /* 0x2c6a */
    OTHER,        /* 0x2c6b */
    OTHER,        /* 0x2c6c */
    OTHER,        /* 0x2c6d */
    OTHER,        /* 0x2c6e */
    OTHER,        /* 0x2c6f */
    OTHER,        /* 0x2c70 */
    OTHER,        /* 0x2c71 */
    OTHER,        /* 0x2c72 */
    OTHER,        /* 0x2c73 */
    OTHER,        /* 0x2c74 */
    OTHER,        /* 0x2c75 */
    OTHER,        /* 0x2c76 */
    OTHER,        /* 0x2c77 */
    OTHER,        /* 0x2c78 */
    OTHER,        /* 0x2c79 */
    OTHER,        /* 0x2c7a */
    OTHER,        /* 0x2c7b */
    OTHER,        /* 0x2c7c */
    OTHER,        /* 0x2c7d */
    OTHER,        /* 0x2c7e */
    OTHER,        /* 0x2c7f */
    OTHER,        /* 0x2c80 */
    OTHER,        /* 0x2c81 */
    OTHER,        /* 0x2c82 */
    OTHER,        /* 0x2c83 */
    OTHER,        /* 0x2c84 */
    OTHER,        /* 0x2c85 */
    OTHER,        /* 0x2c86 */
    OTHER,        /* 0x2c87 */
    OTHER,        /* 0x2c88 */
    OTHER,        /* 0x2c89 */
    OTHER,        /* 0x2c8a */
    OTHER,        /* 0x2c8b */
    OTHER,        /* 0x2c8c */
    OTHER,        /* 0x2c8d */
    OTHER,        /* 0x2c8e */
    OTHER,        /* 0x2c8f */
    OTHER,        /* 0x2c90 */
    OTHER,        /* 0x2c91 */
    OTHER,        /* 0x2c92 */
    OTHER,        /* 0x2c93 */
    OTHER,        /* 0x2c94 */
    OTHER,        /* 0x2c95 */
    OTHER,        /* 0x2c96 */
    OTHER,        /* 0x2c97 */
    OTHER,        /* 0x2c98 */
    OTHER,        /* 0x2c99 */
    OTHER,        /* 0x2c9a */
    OTHER,        /* 0x2c9b */
    OTHER,        /* 0x2c9c */
    OTHER,        /* 0x2c9d */
    OTHER,        /* 0x2c9e */
    OTHER,        /* 0x2c9f */
    OTHER,        /* 0x2ca0 */
    OTHER,        /* 0x2ca1 */
    OTHER,        /* 0x2ca2 */
    OTHER,        /* 0x2ca3 */
    OTHER,        /* 0x2ca4 */
    OTHER,        /* 0x2ca5 */
    OTHER,        /* 0x2ca6 */
    OTHER,        /* 0x2ca7 */
    OTHER,        /* 0x2ca8 */
    OTHER,        /* 0x2ca9 */
    OTHER,        /* 0x2caa */
    OTHER,        /* 0x2cab */
    OTHER,        /* 0x2cac */
    OTHER,        /* 0x2cad */
    OTHER,        /* 0x2cae */
    OTHER,        /* 0x2caf */
    OTHER,        /* 0x2cb0 */
    OTHER,        /* 0x2cb1 */
    OTHER,        /* 0x2cb2 */
    OTHER,        /* 0x2cb3 */
    OTHER,        /* 0x2cb4 */
    OTHER,        /* 0x2cb5 */
    OTHER,        /* 0x2cb6 */
    OTHER,        /* 0x2cb7 */
    OTHER,        /* 0x2cb8 */
    OTHER,        /* 0x2cb9 */
    OTHER,        /* 0x2cba */
    OTHER,        /* 0x2cbb */
    OTHER,        /* 0x2cbc */
    OTHER,        /* 0x2cbd */
    OTHER,        /* 0x2cbe */
    OTHER,        /* 0x2cbf */
    OTHER,        /* 0x2cc0 */
    OTHER,        /* 0x2cc1 */
    OTHER,        /* 0x2cc2 */
    OTHER,        /* 0x2cc3 */
    OTHER,        /* 0x2cc4 */
    OTHER,        /* 0x2cc5 */
    OTHER,        /* 0x2cc6 */
    OTHER,        /* 0x2cc7 */
    OTHER,        /* 0x2cc8 */
    OTHER,        /* 0x2cc9 */
    OTHER,        /* 0x2cca */
    OTHER,        /* 0x2ccb */
    OTHER,        /* 0x2ccc */
    OTHER,        /* 0x2ccd */
    OTHER,        /* 0x2cce */
    OTHER,        /* 0x2ccf */
    OTHER,        /* 0x2cd0 */
    OTHER,        /* 0x2cd1 */
    OTHER,        /* 0x2cd2 */
    OTHER,        /* 0x2cd3 */
    OTHER,        /* 0x2cd4 */
    OTHER,        /* 0x2cd5 */
    OTHER,        /* 0x2cd6 */
    OTHER,        /* 0x2cd7 */
    OTHER,        /* 0x2cd8 */
    OTHER,        /* 0x2cd9 */
    OTHER,        /* 0x2cda */
    OTHER,        /* 0x2cdb */
    OTHER,        /* 0x2cdc */
    OTHER,        /* 0x2cdd */
    OTHER,        /* 0x2cde */
    OTHER,        /* 0x2cdf */
    OTHER,        /* 0x2ce0 */
    OTHER,        /* 0x2ce1 */
    OTHER,        /* 0x2ce2 */
    OTHER,        /* 0x2ce3 */
    OTHER,        /* 0x2ce4 */
    OTHER,        /* 0x2ce5 */
    OTHER,        /* 0x2ce6 */
    OTHER,        /* 0x2ce7 */
    OTHER,        /* 0x2ce8 */
    OTHER,        /* 0x2ce9 */
    OTHER,        /* 0x2cea */
    OTHER,        /* 0x2ceb */
    OTHER,        /* 0x2cec */
    OTHER,        /* 0x2ced */
    OTHER,        /* 0x2cee */
    OTHER,        /* 0x2cef */
    OTHER,        /* 0x2cf0 */
    OTHER,        /* 0x2cf1 */
    OTHER,        /* 0x2cf2 */
    OTHER,        /* 0x2cf3 */
    OTHER,        /* 0x2cf4 */
    OTHER,        /* 0x2cf5 */
    OTHER,        /* 0x2cf6 */
    OTHER,        /* 0x2cf7 */
    OTHER,        /* 0x2cf8 */
    OTHER,        /* 0x2cf9 */
    OTHER,        /* 0x2cfa */
    OTHER,        /* 0x2cfb */
    OTHER,        /* 0x2cfc */
    OTHER,        /* 0x2cfd */
    OTHER,        /* 0x2cfe */
    OTHER,        /* 0x2cff */
    OTHER,        /* 0x2d00 */
    OTHER,        /* 0x2d01 */
    OTHER,        /* 0x2d02 */
    OTHER,        /* 0x2d03 */
    OTHER,        /* 0x2d04 */
    OTHER,        /* 0x2d05 */
    OTHER,        /* 0x2d06 */
    OTHER,        /* 0x2d07 */
    OTHER,        /* 0x2d08 */
    OTHER,        /* 0x2d09 */
    OTHER,        /* 0x2d0a */
    OTHER,        /* 0x2d0b */
    OTHER,        /* 0x2d0c */
    OTHER,        /* 0x2d0d */
    OTHER,        /* 0x2d0e */
    OTHER,        /* 0x2d0f */
    OTHER,        /* 0x2d10 */
    OTHER,        /* 0x2d11 */
    OTHER,        /* 0x2d12 */
    OTHER,        /* 0x2d13 */
    OTHER,        /* 0x2d14 */
    OTHER,        /* 0x2d15 */
    OTHER,        /* 0x2d16 */
    OTHER,        /* 0x2d17 */
    OTHER,        /* 0x2d18 */
    OTHER,        /* 0x2d19 */
    OTHER,        /* 0x2d1a */
    OTHER,        /* 0x2d1b */
    OTHER,        /* 0x2d1c */
    OTHER,        /* 0x2d1d */
    OTHER,        /* 0x2d1e */
    OTHER,        /* 0x2d1f */
    OTHER,        /* 0x2d20 */
    OTHER,        /* 0x2d21 */
    OTHER,        /* 0x2d22 */
    OTHER,        /* 0x2d23 */
    OTHER,        /* 0x2d24 */
    OTHER,        /* 0x2d25 */
    OTHER,        /* 0x2d26 */
    OTHER,        /* 0x2d27 */
    OTHER,        /* 0x2d28 */
    OTHER,        /* 0x2d29 */
    OTHER,        /* 0x2d2a */
    OTHER,        /* 0x2d2b */
    OTHER,        /* 0x2d2c */
    OTHER,        /* 0x2d2d */
    OTHER,        /* 0x2d2e */
    OTHER,        /* 0x2d2f */
    OTHER,        /* 0x2d30 */
    OTHER,        /* 0x2d31 */
    OTHER,        /* 0x2d32 */
    OTHER,        /* 0x2d33 */
    OTHER,        /* 0x2d34 */
    OTHER,        /* 0x2d35 */
    OTHER,        /* 0x2d36 */
    OTHER,        /* 0x2d37 */
    OTHER,        /* 0x2d38 */
    OTHER,        /* 0x2d39 */
    OTHER,        /* 0x2d3a */
    OTHER,        /* 0x2d3b */
    OTHER,        /* 0x2d3c */
    OTHER,        /* 0x2d3d */
    OTHER,        /* 0x2d3e */
    OTHER,        /* 0x2d3f */
    OTHER,        /* 0x2d40 */
    OTHER,        /* 0x2d41 */
    OTHER,        /* 0x2d42 */
    OTHER,        /* 0x2d43 */
    OTHER,        /* 0x2d44 */
    OTHER,        /* 0x2d45 */
    OTHER,        /* 0x2d46 */
    OTHER,        /* 0x2d47 */
    OTHER,        /* 0x2d48 */
    OTHER,        /* 0x2d49 */
    OTHER,        /* 0x2d4a */
    OTHER,        /* 0x2d4b */
    OTHER,        /* 0x2d4c */
    OTHER,        /* 0x2d4d */
    OTHER,        /* 0x2d4e */
    OTHER,        /* 0x2d4f */
    OTHER,        /* 0x2d50 */
    OTHER,        /* 0x2d51 */
    OTHER,        /* 0x2d52 */
    OTHER,        /* 0x2d53 */
    OTHER,        /* 0x2d54 */
    OTHER,        /* 0x2d55 */
    OTHER,        /* 0x2d56 */
    OTHER,        /* 0x2d57 */
    OTHER,        /* 0x2d58 */
    OTHER,        /* 0x2d59 */
    OTHER,        /* 0x2d5a */
    OTHER,        /* 0x2d5b */
    OTHER,        /* 0x2d5c */
    OTHER,        /* 0x2d5d */
    OTHER,        /* 0x2d5e */
    OTHER,        /* 0x2d5f */
    OTHER,        /* 0x2d60 */
    OTHER,        /* 0x2d61 */
    OTHER,        /* 0x2d62 */
    OTHER,        /* 0x2d63 */
    OTHER,        /* 0x2d64 */
    OTHER,        /* 0x2d65 */
    OTHER,        /* 0x2d66 */
    OTHER,        /* 0x2d67 */
    OTHER,        /* 0x2d68 */
    OTHER,        /* 0x2d69 */
    OTHER,        /* 0x2d6a */
    OTHER,        /* 0x2d6b */
    OTHER,        /* 0x2d6c */
    OTHER,        /* 0x2d6d */
    OTHER,        /* 0x2d6e */
    OTHER,        /* 0x2d6f */
    OTHER,        /* 0x2d70 */
    OTHER,        /* 0x2d71 */
    OTHER,        /* 0x2d72 */
    OTHER,        /* 0x2d73 */
    OTHER,        /* 0x2d74 */
    OTHER,        /* 0x2d75 */
    OTHER,        /* 0x2d76 */
    OTHER,        /* 0x2d77 */
    OTHER,        /* 0x2d78 */
    OTHER,        /* 0x2d79 */
    OTHER,        /* 0x2d7a */
    OTHER,        /* 0x2d7b */
    OTHER,        /* 0x2d7c */
    OTHER,        /* 0x2d7d */
    OTHER,        /* 0x2d7e */
    OTHER,        /* 0x2d7f */
    OTHER,        /* 0x2d80 */
    OTHER,        /* 0x2d81 */
    OTHER,        /* 0x2d82 */
    OTHER,        /* 0x2d83 */
    OTHER,        /* 0x2d84 */
    OTHER,        /* 0x2d85 */
    OTHER,        /* 0x2d86 */
    OTHER,        /* 0x2d87 */
    OTHER,        /* 0x2d88 */
    OTHER,        /* 0x2d89 */
    OTHER,        /* 0x2d8a */
    OTHER,        /* 0x2d8b */
    OTHER,        /* 0x2d8c */
    OTHER,        /* 0x2d8d */
    OTHER,        /* 0x2d8e */
    OTHER,        /* 0x2d8f */
    OTHER,        /* 0x2d90 */
    OTHER,        /* 0x2d91 */
    OTHER,        /* 0x2d92 */
    OTHER,        /* 0x2d93 */
    OTHER,        /* 0x2d94 */
    OTHER,        /* 0x2d95 */
    OTHER,        /* 0x2d96 */
    OTHER,        /* 0x2d97 */
    OTHER,        /* 0x2d98 */
    OTHER,        /* 0x2d99 */
    OTHER,        /* 0x2d9a */
    OTHER,        /* 0x2d9b */
    OTHER,        /* 0x2d9c */
    OTHER,        /* 0x2d9d */
    OTHER,        /* 0x2d9e */
    OTHER,        /* 0x2d9f */
    OTHER,        /* 0x2da0 */
    OTHER,        /* 0x2da1 */
    OTHER,        /* 0x2da2 */
    OTHER,        /* 0x2da3 */
    OTHER,        /* 0x2da4 */
    OTHER,        /* 0x2da5 */
    OTHER,        /* 0x2da6 */
    OTHER,        /* 0x2da7 */
    OTHER,        /* 0x2da8 */
    OTHER,        /* 0x2da9 */
    OTHER,        /* 0x2daa */
    OTHER,        /* 0x2dab */
    OTHER,        /* 0x2dac */
    OTHER,        /* 0x2dad */
    OTHER,        /* 0x2dae */
    OTHER,        /* 0x2daf */
    OTHER,        /* 0x2db0 */
    OTHER,        /* 0x2db1 */
    OTHER,        /* 0x2db2 */
    OTHER,        /* 0x2db3 */
    OTHER,        /* 0x2db4 */
    OTHER,        /* 0x2db5 */
    OTHER,        /* 0x2db6 */
    OTHER,        /* 0x2db7 */
    OTHER,        /* 0x2db8 */
    OTHER,        /* 0x2db9 */
    OTHER,        /* 0x2dba */
    OTHER,        /* 0x2dbb */
    OTHER,        /* 0x2dbc */
    OTHER,        /* 0x2dbd */
    OTHER,        /* 0x2dbe */
    OTHER,        /* 0x2dbf */
    OTHER,        /* 0x2dc0 */
    OTHER,        /* 0x2dc1 */
    OTHER,        /* 0x2dc2 */
    OTHER,        /* 0x2dc3 */
    OTHER,        /* 0x2dc4 */
    OTHER,        /* 0x2dc5 */
    OTHER,        /* 0x2dc6 */
    OTHER,        /* 0x2dc7 */
    OTHER,        /* 0x2dc8 */
    OTHER,        /* 0x2dc9 */
    OTHER,        /* 0x2dca */
    OTHER,        /* 0x2dcb */
    OTHER,        /* 0x2dcc */
    OTHER,        /* 0x2dcd */
    OTHER,        /* 0x2dce */
    OTHER,        /* 0x2dcf */
    OTHER,        /* 0x2dd0 */
    OTHER,        /* 0x2dd1 */
    OTHER,        /* 0x2dd2 */
    OTHER,        /* 0x2dd3 */
    OTHER,        /* 0x2dd4 */
    OTHER,        /* 0x2dd5 */
    OTHER,        /* 0x2dd6 */
    OTHER,        /* 0x2dd7 */
    OTHER,        /* 0x2dd8 */
    OTHER,        /* 0x2dd9 */
    OTHER,        /* 0x2dda */
    OTHER,        /* 0x2ddb */
    OTHER,        /* 0x2ddc */
    OTHER,        /* 0x2ddd */
    OTHER,        /* 0x2dde */
    OTHER,        /* 0x2ddf */
    OTHER,        /* 0x2de0 */
    OTHER,        /* 0x2de1 */
    OTHER,        /* 0x2de2 */
    OTHER,        /* 0x2de3 */
    OTHER,        /* 0x2de4 */
    OTHER,        /* 0x2de5 */
    OTHER,        /* 0x2de6 */
    OTHER,        /* 0x2de7 */
    OTHER,        /* 0x2de8 */
    OTHER,        /* 0x2de9 */
    OTHER,        /* 0x2dea */
    OTHER,        /* 0x2deb */
    OTHER,        /* 0x2dec */
    OTHER,        /* 0x2ded */
    OTHER,        /* 0x2dee */
    OTHER,        /* 0x2def */
    OTHER,        /* 0x2df0 */
    OTHER,        /* 0x2df1 */
    OTHER,        /* 0x2df2 */
    OTHER,        /* 0x2df3 */
    OTHER,        /* 0x2df4 */
    OTHER,        /* 0x2df5 */
    OTHER,        /* 0x2df6 */
    OTHER,        /* 0x2df7 */
    OTHER,        /* 0x2df8 */
    OTHER,        /* 0x2df9 */
    OTHER,        /* 0x2dfa */
    OTHER,        /* 0x2dfb */
    OTHER,        /* 0x2dfc */
    OTHER,        /* 0x2dfd */
    OTHER,        /* 0x2dfe */
    OTHER,        /* 0x2dff */
    OTHER,        /* 0x2e00 */
    OTHER,        /* 0x2e01 */
    OTHER,        /* 0x2e02 */
    OTHER,        /* 0x2e03 */
    OTHER,        /* 0x2e04 */
    OTHER,        /* 0x2e05 */
    OTHER,        /* 0x2e06 */
    OTHER,        /* 0x2e07 */
    OTHER,        /* 0x2e08 */
    OTHER,        /* 0x2e09 */
    OTHER,        /* 0x2e0a */
    OTHER,        /* 0x2e0b */
    OTHER,        /* 0x2e0c */
    OTHER,        /* 0x2e0d */
    OTHER,        /* 0x2e0e */
    OTHER,        /* 0x2e0f */
    OTHER,        /* 0x2e10 */
    OTHER,        /* 0x2e11 */
    OTHER,        /* 0x2e12 */
    OTHER,        /* 0x2e13 */
    OTHER,        /* 0x2e14 */
    OTHER,        /* 0x2e15 */
    OTHER,        /* 0x2e16 */
    OTHER,        /* 0x2e17 */
    OTHER,        /* 0x2e18 */
    OTHER,        /* 0x2e19 */
    OTHER,        /* 0x2e1a */
    OTHER,        /* 0x2e1b */
    OTHER,        /* 0x2e1c */
    OTHER,        /* 0x2e1d */
    OTHER,        /* 0x2e1e */
    OTHER,        /* 0x2e1f */
    OTHER,        /* 0x2e20 */
    OTHER,        /* 0x2e21 */
    OTHER,        /* 0x2e22 */
    OTHER,        /* 0x2e23 */
    OTHER,        /* 0x2e24 */
    OTHER,        /* 0x2e25 */
    OTHER,        /* 0x2e26 */
    OTHER,        /* 0x2e27 */
    OTHER,        /* 0x2e28 */
    OTHER,        /* 0x2e29 */
    OTHER,        /* 0x2e2a */
    OTHER,        /* 0x2e2b */
    OTHER,        /* 0x2e2c */
    OTHER,        /* 0x2e2d */
    OTHER,        /* 0x2e2e */
    OTHER,        /* 0x2e2f */
    OTHER,        /* 0x2e30 */
    OTHER,        /* 0x2e31 */
    OTHER,        /* 0x2e32 */
    OTHER,        /* 0x2e33 */
    OTHER,        /* 0x2e34 */
    OTHER,        /* 0x2e35 */
    OTHER,        /* 0x2e36 */
    OTHER,        /* 0x2e37 */
    OTHER,        /* 0x2e38 */
    OTHER,        /* 0x2e39 */
    OTHER,        /* 0x2e3a */
    OTHER,        /* 0x2e3b */
    OTHER,        /* 0x2e3c */
    OTHER,        /* 0x2e3d */
    OTHER,        /* 0x2e3e */
    OTHER,        /* 0x2e3f */
    OTHER,        /* 0x2e40 */
    OTHER,        /* 0x2e41 */
    OTHER,        /* 0x2e42 */
    OTHER,        /* 0x2e43 */
    OTHER,        /* 0x2e44 */
    OTHER,        /* 0x2e45 */
    OTHER,        /* 0x2e46 */
    OTHER,        /* 0x2e47 */
    OTHER,        /* 0x2e48 */
    OTHER,        /* 0x2e49 */
    OTHER,        /* 0x2e4a */
    OTHER,        /* 0x2e4b */
    OTHER,        /* 0x2e4c */
    OTHER,        /* 0x2e4d */
    OTHER,        /* 0x2e4e */
    OTHER,        /* 0x2e4f */
    OTHER,        /* 0x2e50 */
    OTHER,        /* 0x2e51 */
    OTHER,        /* 0x2e52 */
    OTHER,        /* 0x2e53 */
    OTHER,        /* 0x2e54 */
    OTHER,        /* 0x2e55 */
    OTHER,        /* 0x2e56 */
    OTHER,        /* 0x2e57 */
    OTHER,        /* 0x2e58 */
    OTHER,        /* 0x2e59 */
    OTHER,        /* 0x2e5a */
    OTHER,        /* 0x2e5b */
    OTHER,        /* 0x2e5c */
    OTHER,        /* 0x2e5d */
    OTHER,        /* 0x2e5e */
    OTHER,        /* 0x2e5f */
    OTHER,        /* 0x2e60 */
    OTHER,        /* 0x2e61 */
    OTHER,        /* 0x2e62 */
    OTHER,        /* 0x2e63 */
    OTHER,        /* 0x2e64 */
    OTHER,        /* 0x2e65 */
    OTHER,        /* 0x2e66 */
    OTHER,        /* 0x2e67 */
    OTHER,        /* 0x2e68 */
    OTHER,        /* 0x2e69 */
    OTHER,        /* 0x2e6a */
    OTHER,        /* 0x2e6b */
    OTHER,        /* 0x2e6c */
    OTHER,        /* 0x2e6d */
    OTHER,        /* 0x2e6e */
    OTHER,        /* 0x2e6f */
    OTHER,        /* 0x2e70 */
    OTHER,        /* 0x2e71 */
    OTHER,        /* 0x2e72 */
    OTHER,        /* 0x2e73 */
    OTHER,        /* 0x2e74 */
    OTHER,        /* 0x2e75 */
    OTHER,        /* 0x2e76 */
    OTHER,        /* 0x2e77 */
    OTHER,        /* 0x2e78 */
    OTHER,        /* 0x2e79 */
    OTHER,        /* 0x2e7a */
    OTHER,        /* 0x2e7b */
    OTHER,        /* 0x2e7c */
    OTHER,        /* 0x2e7d */
    OTHER,        /* 0x2e7e */
    OTHER,        /* 0x2e7f */
    KANJI,        /* 0x2e80 */
    KANJI,        /* 0x2e81 */
    KANJI,        /* 0x2e82 */
    KANJI,        /* 0x2e83 */
    KANJI,        /* 0x2e84 */
    KANJI,        /* 0x2e85 */
    KANJI,        /* 0x2e86 */
    KANJI,        /* 0x2e87 */
    KANJI,        /* 0x2e88 */
    KANJI,        /* 0x2e89 */
    KANJI,        /* 0x2e8a */
    KANJI,        /* 0x2e8b */
    KANJI,        /* 0x2e8c */
    KANJI,        /* 0x2e8d */
    KANJI,        /* 0x2e8e */
    KANJI,        /* 0x2e8f */
    KANJI,        /* 0x2e90 */
    KANJI,        /* 0x2e91 */
    KANJI,        /* 0x2e92 */
    KANJI,        /* 0x2e93 */
    KANJI,        /* 0x2e94 */
    KANJI,        /* 0x2e95 */
    KANJI,        /* 0x2e96 */
    KANJI,        /* 0x2e97 */
    KANJI,        /* 0x2e98 */
    KANJI,        /* 0x2e99 */
    KANJI,        /* 0x2e9a */
    KANJI,        /* 0x2e9b */
    KANJI,        /* 0x2e9c */
    KANJI,        /* 0x2e9d */
    KANJI,        /* 0x2e9e */
    KANJI,        /* 0x2e9f */
    KANJI,        /* 0x2ea0 */
    KANJI,        /* 0x2ea1 */
    KANJI,        /* 0x2ea2 */
    KANJI,        /* 0x2ea3 */
    KANJI,        /* 0x2ea4 */
    KANJI,        /* 0x2ea5 */
    KANJI,        /* 0x2ea6 */
    KANJI,        /* 0x2ea7 */
    KANJI,        /* 0x2ea8 */
    KANJI,        /* 0x2ea9 */
    KANJI,        /* 0x2eaa */
    KANJI,        /* 0x2eab */
    KANJI,        /* 0x2eac */
    KANJI,        /* 0x2ead */
    KANJI,        /* 0x2eae */
    KANJI,        /* 0x2eaf */
    KANJI,        /* 0x2eb0 */
    KANJI,        /* 0x2eb1 */
    KANJI,        /* 0x2eb2 */
    KANJI,        /* 0x2eb3 */
    KANJI,        /* 0x2eb4 */
    KANJI,        /* 0x2eb5 */
    KANJI,        /* 0x2eb6 */
    KANJI,        /* 0x2eb7 */
    KANJI,        /* 0x2eb8 */
    KANJI,        /* 0x2eb9 */
    KANJI,        /* 0x2eba */
    KANJI,        /* 0x2ebb */
    KANJI,        /* 0x2ebc */
    KANJI,        /* 0x2ebd */
    KANJI,        /* 0x2ebe */
    KANJI,        /* 0x2ebf */
    KANJI,        /* 0x2ec0 */
    KANJI,        /* 0x2ec1 */
    KANJI,        /* 0x2ec2 */
    KANJI,        /* 0x2ec3 */
    KANJI,        /* 0x2ec4 */
    KANJI,        /* 0x2ec5 */
    KANJI,        /* 0x2ec6 */
    KANJI,        /* 0x2ec7 */
    KANJI,        /* 0x2ec8 */
    KANJI,        /* 0x2ec9 */
    KANJI,        /* 0x2eca */
    KANJI,        /* 0x2ecb */
    KANJI,        /* 0x2ecc */
    KANJI,        /* 0x2ecd */
    KANJI,        /* 0x2ece */
    KANJI,        /* 0x2ecf */
    KANJI,        /* 0x2ed0 */
    KANJI,        /* 0x2ed1 */
    KANJI,        /* 0x2ed2 */
    KANJI,        /* 0x2ed3 */
    KANJI,        /* 0x2ed4 */
    KANJI,        /* 0x2ed5 */
    KANJI,        /* 0x2ed6 */
    KANJI,        /* 0x2ed7 */
    KANJI,        /* 0x2ed8 */
    KANJI,        /* 0x2ed9 */
    KANJI,        /* 0x2eda */
    KANJI,        /* 0x2edb */
    KANJI,        /* 0x2edc */
    KANJI,        /* 0x2edd */
    KANJI,        /* 0x2ede */
    KANJI,        /* 0x2edf */
    KANJI,        /* 0x2ee0 */
    KANJI,        /* 0x2ee1 */
    KANJI,        /* 0x2ee2 */
    KANJI,        /* 0x2ee3 */
    KANJI,        /* 0x2ee4 */
    KANJI,        /* 0x2ee5 */
    KANJI,        /* 0x2ee6 */
    KANJI,        /* 0x2ee7 */
    KANJI,        /* 0x2ee8 */
    KANJI,        /* 0x2ee9 */
    KANJI,        /* 0x2eea */
    KANJI,        /* 0x2eeb */
    KANJI,        /* 0x2eec */
    KANJI,        /* 0x2eed */
    KANJI,        /* 0x2eee */
    KANJI,        /* 0x2eef */
    KANJI,        /* 0x2ef0 */
    KANJI,        /* 0x2ef1 */
    KANJI,        /* 0x2ef2 */
    KANJI,        /* 0x2ef3 */
    OTHER,        /* 0x2ef4 */
    OTHER,        /* 0x2ef5 */
    OTHER,        /* 0x2ef6 */
    OTHER,        /* 0x2ef7 */
    OTHER,        /* 0x2ef8 */
    OTHER,        /* 0x2ef9 */
    OTHER,        /* 0x2efa */
    OTHER,        /* 0x2efb */
    OTHER,        /* 0x2efc */
    OTHER,        /* 0x2efd */
    OTHER,        /* 0x2efe */
    OTHER,        /* 0x2eff */
    KANJI,        /* 0x2f00 */
    KANJI,        /* 0x2f01 */
    KANJI,        /* 0x2f02 */
    KANJI,        /* 0x2f03 */
    KANJI,        /* 0x2f04 */
    KANJI,        /* 0x2f05 */
    KANJI,        /* 0x2f06 */
    KANJI,        /* 0x2f07 */
    KANJI,        /* 0x2f08 */
    KANJI,        /* 0x2f09 */
    KANJI,        /* 0x2f0a */
    KANJI,        /* 0x2f0b */
    KANJI,        /* 0x2f0c */
    KANJI,        /* 0x2f0d */
    KANJI,        /* 0x2f0e */
    KANJI,        /* 0x2f0f */
    KANJI,        /* 0x2f10 */
    KANJI,        /* 0x2f11 */
    KANJI,        /* 0x2f12 */
    KANJI,        /* 0x2f13 */
    KANJI,        /* 0x2f14 */
    KANJI,        /* 0x2f15 */
    KANJI,        /* 0x2f16 */
    KANJI,        /* 0x2f17 */
    KANJI,        /* 0x2f18 */
    KANJI,        /* 0x2f19 */
    KANJI,        /* 0x2f1a */
    KANJI,        /* 0x2f1b */
    KANJI,        /* 0x2f1c */
    KANJI,        /* 0x2f1d */
    KANJI,        /* 0x2f1e */
    KANJI,        /* 0x2f1f */
    KANJI,        /* 0x2f20 */
    KANJI,        /* 0x2f21 */
    KANJI,        /* 0x2f22 */
    KANJI,        /* 0x2f23 */
    KANJI,        /* 0x2f24 */
    KANJI,        /* 0x2f25 */
    KANJI,        /* 0x2f26 */
    KANJI,        /* 0x2f27 */
    KANJI,        /* 0x2f28 */
    KANJI,        /* 0x2f29 */
    KANJI,        /* 0x2f2a */
    KANJI,        /* 0x2f2b */
    KANJI,        /* 0x2f2c */
    KANJI,        /* 0x2f2d */
    KANJI,        /* 0x2f2e */
    KANJI,        /* 0x2f2f */
    KANJI,        /* 0x2f30 */
    KANJI,        /* 0x2f31 */
    KANJI,        /* 0x2f32 */
    KANJI,        /* 0x2f33 */
    KANJI,        /* 0x2f34 */
    KANJI,        /* 0x2f35 */
    KANJI,        /* 0x2f36 */
    KANJI,        /* 0x2f37 */
    KANJI,        /* 0x2f38 */
    KANJI,        /* 0x2f39 */
    KANJI,        /* 0x2f3a */
    KANJI,        /* 0x2f3b */
    KANJI,        /* 0x2f3c */
    KANJI,        /* 0x2f3d */
    KANJI,        /* 0x2f3e */
    KANJI,        /* 0x2f3f */
    KANJI,        /* 0x2f40 */
    KANJI,        /* 0x2f41 */
    KANJI,        /* 0x2f42 */
    KANJI,        /* 0x2f43 */
    KANJI,        /* 0x2f44 */
    KANJI,        /* 0x2f45 */
    KANJI,        /* 0x2f46 */
    KANJI,        /* 0x2f47 */
    KANJI,        /* 0x2f48 */
    KANJI,        /* 0x2f49 */
    KANJI,        /* 0x2f4a */
    KANJI,        /* 0x2f4b */
    KANJI,        /* 0x2f4c */
    KANJI,        /* 0x2f4d */
    KANJI,        /* 0x2f4e */
    KANJI,        /* 0x2f4f */
    KANJI,        /* 0x2f50 */
    KANJI,        /* 0x2f51 */
    KANJI,        /* 0x2f52 */
    KANJI,        /* 0x2f53 */
    KANJI,        /* 0x2f54 */
    KANJI,        /* 0x2f55 */
    KANJI,        /* 0x2f56 */
    KANJI,        /* 0x2f57 */
    KANJI,        /* 0x2f58 */
    KANJI,        /* 0x2f59 */
    KANJI,        /* 0x2f5a */
    KANJI,        /* 0x2f5b */
    KANJI,        /* 0x2f5c */
    KANJI,        /* 0x2f5d */
    KANJI,        /* 0x2f5e */
    KANJI,        /* 0x2f5f */
    KANJI,        /* 0x2f60 */
    KANJI,        /* 0x2f61 */
    KANJI,        /* 0x2f62 */
    KANJI,        /* 0x2f63 */
    KANJI,        /* 0x2f64 */
    KANJI,        /* 0x2f65 */
    KANJI,        /* 0x2f66 */
    KANJI,        /* 0x2f67 */
    KANJI,        /* 0x2f68 */
    KANJI,        /* 0x2f69 */
    KANJI,        /* 0x2f6a */
    KANJI,        /* 0x2f6b */
    KANJI,        /* 0x2f6c */
    KANJI,        /* 0x2f6d */
    KANJI,        /* 0x2f6e */
    KANJI,        /* 0x2f6f */
    KANJI,        /* 0x2f70 */
    KANJI,        /* 0x2f71 */
    KANJI,        /* 0x2f72 */
    KANJI,        /* 0x2f73 */
    KANJI,        /* 0x2f74 */
    KANJI,        /* 0x2f75 */
    KANJI,        /* 0x2f76 */
    KANJI,        /* 0x2f77 */
    KANJI,        /* 0x2f78 */
    KANJI,        /* 0x2f79 */
    KANJI,        /* 0x2f7a */
    KANJI,        /* 0x2f7b */
    KANJI,        /* 0x2f7c */
    KANJI,        /* 0x2f7d */
    KANJI,        /* 0x2f7e */
    KANJI,        /* 0x2f7f */
    KANJI,        /* 0x2f80 */
    KANJI,        /* 0x2f81 */
    KANJI,        /* 0x2f82 */
    KANJI,        /* 0x2f83 */
    KANJI,        /* 0x2f84 */
    KANJI,        /* 0x2f85 */
    KANJI,        /* 0x2f86 */
    KANJI,        /* 0x2f87 */
    KANJI,        /* 0x2f88 */
    KANJI,        /* 0x2f89 */
    KANJI,        /* 0x2f8a */
    KANJI,        /* 0x2f8b */
    KANJI,        /* 0x2f8c */
    KANJI,        /* 0x2f8d */
    KANJI,        /* 0x2f8e */
    KANJI,        /* 0x2f8f */
    KANJI,        /* 0x2f90 */
    KANJI,        /* 0x2f91 */
    KANJI,        /* 0x2f92 */
    KANJI,        /* 0x2f93 */
    KANJI,        /* 0x2f94 */
    KANJI,        /* 0x2f95 */
    KANJI,        /* 0x2f96 */
    KANJI,        /* 0x2f97 */
    KANJI,        /* 0x2f98 */
    KANJI,        /* 0x2f99 */
    KANJI,        /* 0x2f9a */
    KANJI,        /* 0x2f9b */
    KANJI,        /* 0x2f9c */
    KANJI,        /* 0x2f9d */
    KANJI,        /* 0x2f9e */
    KANJI,        /* 0x2f9f */
    KANJI,        /* 0x2fa0 */
    KANJI,        /* 0x2fa1 */
    KANJI,        /* 0x2fa2 */
    KANJI,        /* 0x2fa3 */
    KANJI,        /* 0x2fa4 */
    KANJI,        /* 0x2fa5 */
    KANJI,        /* 0x2fa6 */
    KANJI,        /* 0x2fa7 */
    KANJI,        /* 0x2fa8 */
    KANJI,        /* 0x2fa9 */
    KANJI,        /* 0x2faa */
    KANJI,        /* 0x2fab */
    KANJI,        /* 0x2fac */
    KANJI,        /* 0x2fad */
    KANJI,        /* 0x2fae */
    KANJI,        /* 0x2faf */
    KANJI,        /* 0x2fb0 */
    KANJI,        /* 0x2fb1 */
    KANJI,        /* 0x2fb2 */
    KANJI,        /* 0x2fb3 */
    KANJI,        /* 0x2fb4 */
    KANJI,        /* 0x2fb5 */
    KANJI,        /* 0x2fb6 */
    KANJI,        /* 0x2fb7 */
    KANJI,        /* 0x2fb8 */
    KANJI,        /* 0x2fb9 */
    KANJI,        /* 0x2fba */
    KANJI,        /* 0x2fbb */
    KANJI,        /* 0x2fbc */
    KANJI,        /* 0x2fbd */
    KANJI,        /* 0x2fbe */
    KANJI,        /* 0x2fbf */
    KANJI,        /* 0x2fc0 */
    KANJI,        /* 0x2fc1 */
    KANJI,        /* 0x2fc2 */
    KANJI,        /* 0x2fc3 */
    KANJI,        /* 0x2fc4 */
    KANJI,        /* 0x2fc5 */
    KANJI,        /* 0x2fc6 */
    KANJI,        /* 0x2fc7 */
    KANJI,        /* 0x2fc8 */
    KANJI,        /* 0x2fc9 */
    KANJI,        /* 0x2fca */
    KANJI,        /* 0x2fcb */
    KANJI,        /* 0x2fcc */
    KANJI,        /* 0x2fcd */
    KANJI,        /* 0x2fce */
    KANJI,        /* 0x2fcf */
    KANJI,        /* 0x2fd0 */
    KANJI,        /* 0x2fd1 */
    KANJI,        /* 0x2fd2 */
    KANJI,        /* 0x2fd3 */
    KANJI,        /* 0x2fd4 */
    KANJI,        /* 0x2fd5 */
    OTHER,        /* 0x2fd6 */
    OTHER,        /* 0x2fd7 */
    OTHER,        /* 0x2fd8 */
    OTHER,        /* 0x2fd9 */
    OTHER,        /* 0x2fda */
    OTHER,        /* 0x2fdb */
    OTHER,        /* 0x2fdc */
    OTHER,        /* 0x2fdd */
    OTHER,        /* 0x2fde */
    OTHER,        /* 0x2fdf */
    OTHER,        /* 0x2fe0 */
    OTHER,        /* 0x2fe1 */
    OTHER,        /* 0x2fe2 */
    OTHER,        /* 0x2fe3 */
    OTHER,        /* 0x2fe4 */
    OTHER,        /* 0x2fe5 */
    OTHER,        /* 0x2fe6 */
    OTHER,        /* 0x2fe7 */
    OTHER,        /* 0x2fe8 */
    OTHER,        /* 0x2fe9 */
    OTHER,        /* 0x2fea */
    OTHER,        /* 0x2feb */
    OTHER,        /* 0x2fec */
    OTHER,        /* 0x2fed */
    OTHER,        /* 0x2fee */
    OTHER,        /* 0x2fef */
    OTHER,        /* 0x2ff0 */
    OTHER,        /* 0x2ff1 */
    OTHER,        /* 0x2ff2 */
    OTHER,        /* 0x2ff3 */
    OTHER,        /* 0x2ff4 */
    OTHER,        /* 0x2ff5 */
    OTHER,        /* 0x2ff6 */
    OTHER,        /* 0x2ff7 */
    OTHER,        /* 0x2ff8 */
    OTHER,        /* 0x2ff9 */
    OTHER,        /* 0x2ffa */
    OTHER,        /* 0x2ffb */
    OTHER,        /* 0x2ffc */
    OTHER,        /* 0x2ffd */
    OTHER,        /* 0x2ffe */
    OTHER,        /* 0x2fff */
    SYMBOL,        /* 0x3000 */
    SYMBOL,        /* 0x3001 */
    SYMBOL,        /* 0x3002 */
    SYMBOL,        /* 0x3003 */
    SYMBOL,        /* 0x3004 */
    SYMBOL,        /* 0x3005 */
    SYMBOL,        /* 0x3006 */
    SYMBOL,        /* 0x3007 */
    SYMBOL,        /* 0x3008 */
    SYMBOL,        /* 0x3009 */
    SYMBOL,        /* 0x300a */
    SYMBOL,        /* 0x300b */
    SYMBOL,        /* 0x300c */
    SYMBOL,        /* 0x300d */
    SYMBOL,        /* 0x300e */
    SYMBOL,        /* 0x300f */
    SYMBOL,        /* 0x3010 */
    SYMBOL,        /* 0x3011 */
    SYMBOL,        /* 0x3012 */
    SYMBOL,        /* 0x3013 */
    SYMBOL,        /* 0x3014 */
    SYMBOL,        /* 0x3015 */
    SYMBOL,        /* 0x3016 */
    SYMBOL,        /* 0x3017 */
    SYMBOL,        /* 0x3018 */
    SYMBOL,        /* 0x3019 */
    SYMBOL,        /* 0x301a */
    SYMBOL,        /* 0x301b */
    SYMBOL,        /* 0x301c */
    SYMBOL,        /* 0x301d */
    SYMBOL,        /* 0x301e */
    SYMBOL,        /* 0x301f */
    SYMBOL,        /* 0x3020 */
    SYMBOL,        /* 0x3021 */
    SYMBOL,        /* 0x3022 */
    SYMBOL,        /* 0x3023 */
    SYMBOL,        /* 0x3024 */
    SYMBOL,        /* 0x3025 */
    SYMBOL,        /* 0x3026 */
    SYMBOL,        /* 0x3027 */
    SYMBOL,        /* 0x3028 */
    SYMBOL,        /* 0x3029 */
    SYMBOL,        /* 0x302a */
    SYMBOL,        /* 0x302b */
    SYMBOL,        /* 0x302c */
    SYMBOL,        /* 0x302d */
    SYMBOL,        /* 0x302e */
    SYMBOL,        /* 0x302f */
    SYMBOL,        /* 0x3030 */
    SYMBOL,        /* 0x3031 */
    SYMBOL,        /* 0x3032 */
    SYMBOL,        /* 0x3033 */
    SYMBOL,        /* 0x3034 */
    SYMBOL,        /* 0x3035 */
    SYMBOL,        /* 0x3036 */
    SYMBOL,        /* 0x3037 */
    SYMBOL,        /* 0x3038 */
    SYMBOL,        /* 0x3039 */
    SYMBOL,        /* 0x303a */
    SYMBOL,        /* 0x303b */
    SYMBOL,        /* 0x303c */
    SYMBOL,        /* 0x303d */
    SYMBOL,        /* 0x303e */
    SYMBOL,        /* 0x303f */
    OTHER,        /* 0x3040 */
    HIRAGANA,        /* 0x3041 */
    HIRAGANA,        /* 0x3042 */
    HIRAGANA,        /* 0x3043 */
    HIRAGANA,        /* 0x3044 */
    HIRAGANA,        /* 0x3045 */
    HIRAGANA,        /* 0x3046 */
    HIRAGANA,        /* 0x3047 */
    HIRAGANA,        /* 0x3048 */
    HIRAGANA,        /* 0x3049 */
    HIRAGANA,        /* 0x304a */
    HIRAGANA,        /* 0x304b */
    HIRAGANA,        /* 0x304c */
    HIRAGANA,        /* 0x304d */
    HIRAGANA,        /* 0x304e */
    HIRAGANA,        /* 0x304f */
    HIRAGANA,        /* 0x3050 */
    HIRAGANA,        /* 0x3051 */
    HIRAGANA,        /* 0x3052 */
    HIRAGANA,        /* 0x3053 */
    HIRAGANA,        /* 0x3054 */
    HIRAGANA,        /* 0x3055 */
    HIRAGANA,        /* 0x3056 */
    HIRAGANA,        /* 0x3057 */
    HIRAGANA,        /* 0x3058 */
    HIRAGANA,        /* 0x3059 */
    HIRAGANA,        /* 0x305a */
    HIRAGANA,        /* 0x305b */
    HIRAGANA,        /* 0x305c */
    HIRAGANA,        /* 0x305d */
    HIRAGANA,        /* 0x305e */
    HIRAGANA,        /* 0x305f */
    HIRAGANA,        /* 0x3060 */
    HIRAGANA,        /* 0x3061 */
    HIRAGANA,        /* 0x3062 */
    HIRAGANA,        /* 0x3063 */
    HIRAGANA,        /* 0x3064 */
    HIRAGANA,        /* 0x3065 */
    HIRAGANA,        /* 0x3066 */
    HIRAGANA,        /* 0x3067 */
    HIRAGANA,        /* 0x3068 */
    HIRAGANA,        /* 0x3069 */
    HIRAGANA,        /* 0x306a */
    HIRAGANA,        /* 0x306b */
    HIRAGANA,        /* 0x306c */
    HIRAGANA,        /* 0x306d */
    HIRAGANA,        /* 0x306e */
    HIRAGANA,        /* 0x306f */
    HIRAGANA,        /* 0x3070 */
    HIRAGANA,        /* 0x3071 */
    HIRAGANA,        /* 0x3072 */
    HIRAGANA,        /* 0x3073 */
    HIRAGANA,        /* 0x3074 */
    HIRAGANA,        /* 0x3075 */
    HIRAGANA,        /* 0x3076 */
    HIRAGANA,        /* 0x3077 */
    HIRAGANA,        /* 0x3078 */
    HIRAGANA,        /* 0x3079 */
    HIRAGANA,        /* 0x307a */
    HIRAGANA,        /* 0x307b */
    HIRAGANA,        /* 0x307c */
    HIRAGANA,        /* 0x307d */
    HIRAGANA,        /* 0x307e */
    HIRAGANA,        /* 0x307f */
    HIRAGANA,        /* 0x3080 */
    HIRAGANA,        /* 0x3081 */
    HIRAGANA,        /* 0x3082 */
    HIRAGANA,        /* 0x3083 */
    HIRAGANA,        /* 0x3084 */
    HIRAGANA,        /* 0x3085 */
    HIRAGANA,        /* 0x3086 */
    HIRAGANA,        /* 0x3087 */
    HIRAGANA,        /* 0x3088 */
    HIRAGANA,        /* 0x3089 */
    HIRAGANA,        /* 0x308a */
    HIRAGANA,        /* 0x308b */
    HIRAGANA,        /* 0x308c */
    HIRAGANA,        /* 0x308d */
    HIRAGANA,        /* 0x308e */
    HIRAGANA,        /* 0x308f */
    HIRAGANA,        /* 0x3090 */
    HIRAGANA,        /* 0x3091 */
    HIRAGANA,        /* 0x3092 */
    HIRAGANA,        /* 0x3093 */
    HIRAGANA,        /* 0x3094 */
    HIRAGANA,        /* 0x3095 */
    HIRAGANA,        /* 0x3096 */
    HIRAGANA,        /* 0x3097 */
    HIRAGANA,        /* 0x3098 */
    HIRAGANA,        /* 0x3099 */
    HIRAGANA,        /* 0x309a */
    HIRAGANA,        /* 0x309b */
    HIRAGANA,        /* 0x309c */
    HIRAGANA,        /* 0x309d */
    HIRAGANA,        /* 0x309e */
    HIRAGANA,        /* 0x309f */
    OTHER,        /* 0x30a0 */
    KATAKANA,        /* 0x30a1 */
    KATAKANA,        /* 0x30a2 */
    KATAKANA,        /* 0x30a3 */
    KATAKANA,        /* 0x30a4 */
    KATAKANA,        /* 0x30a5 */
    KATAKANA,        /* 0x30a6 */
    KATAKANA,        /* 0x30a7 */
    KATAKANA,        /* 0x30a8 */
    KATAKANA,        /* 0x30a9 */
    KATAKANA,        /* 0x30aa */
    KATAKANA,        /* 0x30ab */
    KATAKANA,        /* 0x30ac */
    KATAKANA,        /* 0x30ad */
    KATAKANA,        /* 0x30ae */
    KATAKANA,        /* 0x30af */
    KATAKANA,        /* 0x30b0 */
    KATAKANA,        /* 0x30b1 */
    KATAKANA,        /* 0x30b2 */
    KATAKANA,        /* 0x30b3 */
    KATAKANA,        /* 0x30b4 */
    KATAKANA,        /* 0x30b5 */
    KATAKANA,        /* 0x30b6 */
    KATAKANA,        /* 0x30b7 */
    KATAKANA,        /* 0x30b8 */
    KATAKANA,        /* 0x30b9 */
    KATAKANA,        /* 0x30ba */
    KATAKANA,        /* 0x30bb */
    KATAKANA,        /* 0x30bc */
    KATAKANA,        /* 0x30bd */
    KATAKANA,        /* 0x30be */
    KATAKANA,        /* 0x30bf */
    KATAKANA,        /* 0x30c0 */
    KATAKANA,        /* 0x30c1 */
    KATAKANA,        /* 0x30c2 */
    KATAKANA,        /* 0x30c3 */
    KATAKANA,        /* 0x30c4 */
    KATAKANA,        /* 0x30c5 */
    KATAKANA,        /* 0x30c6 */
    KATAKANA,        /* 0x30c7 */
    KATAKANA,        /* 0x30c8 */
    KATAKANA,        /* 0x30c9 */
    KATAKANA,        /* 0x30ca */
    KATAKANA,        /* 0x30cb */
    KATAKANA,        /* 0x30cc */
    KATAKANA,        /* 0x30cd */
    KATAKANA,        /* 0x30ce */
    KATAKANA,        /* 0x30cf */
    KATAKANA,        /* 0x30d0 */
    KATAKANA,        /* 0x30d1 */
    KATAKANA,        /* 0x30d2 */
    KATAKANA,        /* 0x30d3 */
    KATAKANA,        /* 0x30d4 */
    KATAKANA,        /* 0x30d5 */
    KATAKANA,        /* 0x30d6 */
    KATAKANA,        /* 0x30d7 */
    KATAKANA,        /* 0x30d8 */
    KATAKANA,        /* 0x30d9 */
    KATAKANA,        /* 0x30da */
    KATAKANA,        /* 0x30db */
    KATAKANA,        /* 0x30dc */
    KATAKANA,        /* 0x30dd */
    KATAKANA,        /* 0x30de */
    KATAKANA,        /* 0x30df */
    KATAKANA,        /* 0x30e0 */
    KATAKANA,        /* 0x30e1 */
    KATAKANA,        /* 0x30e2 */
    KATAKANA,        /* 0x30e3 */
    KATAKANA,        /* 0x30e4 */
    KATAKANA,        /* 0x30e5 */
    KATAKANA,        /* 0x30e6 */
    KATAKANA,        /* 0x30e7 */
    KATAKANA,        /* 0x30e8 */
    KATAKANA,        /* 0x30e9 */
    KATAKANA,        /* 0x30ea */
    KATAKANA,        /* 0x30eb */
    KATAKANA,        /* 0x30ec */
    KATAKANA,        /* 0x30ed */
    KATAKANA,        /* 0x30ee */
    KATAKANA,        /* 0x30ef */
    KATAKANA,        /* 0x30f0 */
    KATAKANA,        /* 0x30f1 */
    KATAKANA,        /* 0x30f2 */
    KATAKANA,        /* 0x30f3 */
    KATAKANA,        /* 0x30f4 */
    KATAKANA,        /* 0x30f5 */
    KATAKANA,        /* 0x30f6 */
    KATAKANA,        /* 0x30f7 */
    KATAKANA,        /* 0x30f8 */
    KATAKANA,        /* 0x30f9 */
    KATAKANA,        /* 0x30fa */
    KATAKANA,        /* 0x30fb */
    KATAKANA,        /* 0x30fc */
    KATAKANA,        /* 0x30fd */
    KATAKANA,        /* 0x30fe */
    KATAKANA,        /* 0x30ff */
    OTHER,        /* 0x3100 */
    OTHER,        /* 0x3101 */
    OTHER,        /* 0x3102 */
    OTHER,        /* 0x3103 */
    OTHER,        /* 0x3104 */
    OTHER,        /* 0x3105 */
    OTHER,        /* 0x3106 */
    OTHER,        /* 0x3107 */
    OTHER,        /* 0x3108 */
    OTHER,        /* 0x3109 */
    OTHER,        /* 0x310a */
    OTHER,        /* 0x310b */
    OTHER,        /* 0x310c */
    OTHER,        /* 0x310d */
    OTHER,        /* 0x310e */
    OTHER,        /* 0x310f */
    OTHER,        /* 0x3110 */
    OTHER,        /* 0x3111 */
    OTHER,        /* 0x3112 */
    OTHER,        /* 0x3113 */
    OTHER,        /* 0x3114 */
    OTHER,        /* 0x3115 */
    OTHER,        /* 0x3116 */
    OTHER,        /* 0x3117 */
    OTHER,        /* 0x3118 */
    OTHER,        /* 0x3119 */
    OTHER,        /* 0x311a */
    OTHER,        /* 0x311b */
    OTHER,        /* 0x311c */
    OTHER,        /* 0x311d */
    OTHER,        /* 0x311e */
    OTHER,        /* 0x311f */
    OTHER,        /* 0x3120 */
    OTHER,        /* 0x3121 */
    OTHER,        /* 0x3122 */
    OTHER,        /* 0x3123 */
    OTHER,        /* 0x3124 */
    OTHER,        /* 0x3125 */
    OTHER,        /* 0x3126 */
    OTHER,        /* 0x3127 */
    OTHER,        /* 0x3128 */
    OTHER,        /* 0x3129 */
    OTHER,        /* 0x312a */
    OTHER,        /* 0x312b */
    OTHER,        /* 0x312c */
    OTHER,        /* 0x312d */
    OTHER,        /* 0x312e */
    OTHER,        /* 0x312f */
    OTHER,        /* 0x3130 */
    OTHER,        /* 0x3131 */
    OTHER,        /* 0x3132 */
    OTHER,        /* 0x3133 */
    OTHER,        /* 0x3134 */
    OTHER,        /* 0x3135 */
    OTHER,        /* 0x3136 */
    OTHER,        /* 0x3137 */
    OTHER,        /* 0x3138 */
    OTHER,        /* 0x3139 */
    OTHER,        /* 0x313a */
    OTHER,        /* 0x313b */
    OTHER,        /* 0x313c */
    OTHER,        /* 0x313d */
    OTHER,        /* 0x313e */
    OTHER,        /* 0x313f */
    OTHER,        /* 0x3140 */
    OTHER,        /* 0x3141 */
    OTHER,        /* 0x3142 */
    OTHER,        /* 0x3143 */
    OTHER,        /* 0x3144 */
    OTHER,        /* 0x3145 */
    OTHER,        /* 0x3146 */
    OTHER,        /* 0x3147 */
    OTHER,        /* 0x3148 */
    OTHER,        /* 0x3149 */
    OTHER,        /* 0x314a */
    OTHER,        /* 0x314b */
    OTHER,        /* 0x314c */
    OTHER,        /* 0x314d */
    OTHER,        /* 0x314e */
    OTHER,        /* 0x314f */
    OTHER,        /* 0x3150 */
    OTHER,        /* 0x3151 */
    OTHER,        /* 0x3152 */
    OTHER,        /* 0x3153 */
    OTHER,        /* 0x3154 */
    OTHER,        /* 0x3155 */
    OTHER,        /* 0x3156 */
    OTHER,        /* 0x3157 */
    OTHER,        /* 0x3158 */
    OTHER,        /* 0x3159 */
    OTHER,        /* 0x315a */
    OTHER,        /* 0x315b */
    OTHER,        /* 0x315c */
    OTHER,        /* 0x315d */
    OTHER,        /* 0x315e */
    OTHER,        /* 0x315f */
    OTHER,        /* 0x3160 */
    OTHER,        /* 0x3161 */
    OTHER,        /* 0x3162 */
    OTHER,        /* 0x3163 */
    OTHER,        /* 0x3164 */
    OTHER,        /* 0x3165 */
    OTHER,        /* 0x3166 */
    OTHER,        /* 0x3167 */
    OTHER,        /* 0x3168 */
    OTHER,        /* 0x3169 */
    OTHER,        /* 0x316a */
    OTHER,        /* 0x316b */
    OTHER,        /* 0x316c */
    OTHER,        /* 0x316d */
    OTHER,        /* 0x316e */
    OTHER,        /* 0x316f */
    OTHER,        /* 0x3170 */
    OTHER,        /* 0x3171 */
    OTHER,        /* 0x3172 */
    OTHER,        /* 0x3173 */
    OTHER,        /* 0x3174 */
    OTHER,        /* 0x3175 */
    OTHER,        /* 0x3176 */
    OTHER,        /* 0x3177 */
    OTHER,        /* 0x3178 */
    OTHER,        /* 0x3179 */
    OTHER,        /* 0x317a */
    OTHER,        /* 0x317b */
    OTHER,        /* 0x317c */
    OTHER,        /* 0x317d */
    OTHER,        /* 0x317e */
    OTHER,        /* 0x317f */
    OTHER,        /* 0x3180 */
    OTHER,        /* 0x3181 */
    OTHER,        /* 0x3182 */
    OTHER,        /* 0x3183 */
    OTHER,        /* 0x3184 */
    OTHER,        /* 0x3185 */
    OTHER,        /* 0x3186 */
    OTHER,        /* 0x3187 */
    OTHER,        /* 0x3188 */
    OTHER,        /* 0x3189 */
    OTHER,        /* 0x318a */
    OTHER,        /* 0x318b */
    OTHER,        /* 0x318c */
    OTHER,        /* 0x318d */
    OTHER,        /* 0x318e */
    OTHER,        /* 0x318f */
    OTHER,        /* 0x3190 */
    OTHER,        /* 0x3191 */
    OTHER,        /* 0x3192 */
    OTHER,        /* 0x3193 */
    OTHER,        /* 0x3194 */
    OTHER,        /* 0x3195 */
    OTHER,        /* 0x3196 */
    OTHER,        /* 0x3197 */
    OTHER,        /* 0x3198 */
    OTHER,        /* 0x3199 */
    OTHER,        /* 0x319a */
    OTHER,        /* 0x319b */
    OTHER,        /* 0x319c */
    OTHER,        /* 0x319d */
    OTHER,        /* 0x319e */
    OTHER,        /* 0x319f */
    OTHER,        /* 0x31a0 */
    OTHER,        /* 0x31a1 */
    OTHER,        /* 0x31a2 */
    OTHER,        /* 0x31a3 */
    OTHER,        /* 0x31a4 */
    OTHER,        /* 0x31a5 */
    OTHER,        /* 0x31a6 */
    OTHER,        /* 0x31a7 */
    OTHER,        /* 0x31a8 */
    OTHER,        /* 0x31a9 */
    OTHER,        /* 0x31aa */
    OTHER,        /* 0x31ab */
    OTHER,        /* 0x31ac */
    OTHER,        /* 0x31ad */
    OTHER,        /* 0x31ae */
    OTHER,        /* 0x31af */
    OTHER,        /* 0x31b0 */
    OTHER,        /* 0x31b1 */
    OTHER,        /* 0x31b2 */
    OTHER,        /* 0x31b3 */
    OTHER,        /* 0x31b4 */
    OTHER,        /* 0x31b5 */
    OTHER,        /* 0x31b6 */
    OTHER,        /* 0x31b7 */
    OTHER,        /* 0x31b8 */
    OTHER,        /* 0x31b9 */
    OTHER,        /* 0x31ba */
    OTHER,        /* 0x31bb */
    OTHER,        /* 0x31bc */
    OTHER,        /* 0x31bd */
    OTHER,        /* 0x31be */
    OTHER,        /* 0x31bf */
    OTHER,        /* 0x31c0 */
    OTHER,        /* 0x31c1 */
    OTHER,        /* 0x31c2 */
    OTHER,        /* 0x31c3 */
    OTHER,        /* 0x31c4 */
    OTHER,        /* 0x31c5 */
    OTHER,        /* 0x31c6 */
    OTHER,        /* 0x31c7 */
    OTHER,        /* 0x31c8 */
    OTHER,        /* 0x31c9 */
    OTHER,        /* 0x31ca */
    OTHER,        /* 0x31cb */
    OTHER,        /* 0x31cc */
    OTHER,        /* 0x31cd */
    OTHER,        /* 0x31ce */
    OTHER,        /* 0x31cf */
    OTHER,        /* 0x31d0 */
    OTHER,        /* 0x31d1 */
    OTHER,        /* 0x31d2 */
    OTHER,        /* 0x31d3 */
    OTHER,        /* 0x31d4 */
    OTHER,        /* 0x31d5 */
    OTHER,        /* 0x31d6 */
    OTHER,        /* 0x31d7 */
    OTHER,        /* 0x31d8 */
    OTHER,        /* 0x31d9 */
    OTHER,        /* 0x31da */
    OTHER,        /* 0x31db */
    OTHER,        /* 0x31dc */
    OTHER,        /* 0x31dd */
    OTHER,        /* 0x31de */
    OTHER,        /* 0x31df */
    OTHER,        /* 0x31e0 */
    OTHER,        /* 0x31e1 */
    OTHER,        /* 0x31e2 */
    OTHER,        /* 0x31e3 */
    OTHER,        /* 0x31e4 */
    OTHER,        /* 0x31e5 */
    OTHER,        /* 0x31e6 */
    OTHER,        /* 0x31e7 */
    OTHER,        /* 0x31e8 */
    OTHER,        /* 0x31e9 */
    OTHER,        /* 0x31ea */
    OTHER,        /* 0x31eb */
    OTHER,        /* 0x31ec */
    OTHER,        /* 0x31ed */
    OTHER,        /* 0x31ee */
    OTHER,        /* 0x31ef */
    KATAKANA,        /* 0x31f0 */
    KATAKANA,        /* 0x31f1 */
    KATAKANA,        /* 0x31f2 */
    KATAKANA,        /* 0x31f3 */
    KATAKANA,        /* 0x31f4 */
    KATAKANA,        /* 0x31f5 */
    KATAKANA,        /* 0x31f6 */
    KATAKANA,        /* 0x31f7 */
    KATAKANA,        /* 0x31f8 */
    KATAKANA,        /* 0x31f9 */
    KATAKANA,        /* 0x31fa */
    KATAKANA,        /* 0x31fb */
    KATAKANA,        /* 0x31fc */
    KATAKANA,        /* 0x31fd */
    KATAKANA,        /* 0x31fe */
    KATAKANA,        /* 0x31ff */
    SYMBOL,        /* 0x3200 */
    SYMBOL,        /* 0x3201 */
    SYMBOL,        /* 0x3202 */
    SYMBOL,        /* 0x3203 */
    SYMBOL,        /* 0x3204 */
    SYMBOL,        /* 0x3205 */
    SYMBOL,        /* 0x3206 */
    SYMBOL,        /* 0x3207 */
    SYMBOL,        /* 0x3208 */
    SYMBOL,        /* 0x3209 */
    SYMBOL,        /* 0x320a */
    SYMBOL,        /* 0x320b */
    SYMBOL,        /* 0x320c */
    SYMBOL,        /* 0x320d */
    SYMBOL,        /* 0x320e */
    SYMBOL,        /* 0x320f */
    SYMBOL,        /* 0x3210 */
    SYMBOL,        /* 0x3211 */
    SYMBOL,        /* 0x3212 */
    SYMBOL,        /* 0x3213 */
    SYMBOL,        /* 0x3214 */
    SYMBOL,        /* 0x3215 */
    SYMBOL,        /* 0x3216 */
    SYMBOL,        /* 0x3217 */
    SYMBOL,        /* 0x3218 */
    SYMBOL,        /* 0x3219 */
    SYMBOL,        /* 0x321a */
    SYMBOL,        /* 0x321b */
    SYMBOL,        /* 0x321c */
    SYMBOL,        /* 0x321d */
    SYMBOL,        /* 0x321e */
    SYMBOL,        /* 0x321f */
    SYMBOL,        /* 0x3220 */
    SYMBOL,        /* 0x3221 */
    SYMBOL,        /* 0x3222 */
    SYMBOL,        /* 0x3223 */
    SYMBOL,        /* 0x3224 */
    SYMBOL,        /* 0x3225 */
    SYMBOL,        /* 0x3226 */
    SYMBOL,        /* 0x3227 */
    SYMBOL,        /* 0x3228 */
    SYMBOL,        /* 0x3229 */
    SYMBOL,        /* 0x322a */
    SYMBOL,        /* 0x322b */
    SYMBOL,        /* 0x322c */
    SYMBOL,        /* 0x322d */
    SYMBOL,        /* 0x322e */
    SYMBOL,        /* 0x322f */
    SYMBOL,        /* 0x3230 */
    SYMBOL,        /* 0x3231 */
    SYMBOL,        /* 0x3232 */
    SYMBOL,        /* 0x3233 */
    SYMBOL,        /* 0x3234 */
    SYMBOL,        /* 0x3235 */
    SYMBOL,        /* 0x3236 */
    SYMBOL,        /* 0x3237 */
    SYMBOL,        /* 0x3238 */
    SYMBOL,        /* 0x3239 */
    SYMBOL,        /* 0x323a */
    SYMBOL,        /* 0x323b */
    SYMBOL,        /* 0x323c */
    SYMBOL,        /* 0x323d */
    SYMBOL,        /* 0x323e */
    SYMBOL,        /* 0x323f */
    SYMBOL,        /* 0x3240 */
    SYMBOL,        /* 0x3241 */
    SYMBOL,        /* 0x3242 */
    SYMBOL,        /* 0x3243 */
    SYMBOL,        /* 0x3244 */
    SYMBOL,        /* 0x3245 */
    SYMBOL,        /* 0x3246 */
    SYMBOL,        /* 0x3247 */
    SYMBOL,        /* 0x3248 */
    SYMBOL,        /* 0x3249 */
    SYMBOL,        /* 0x324a */
    SYMBOL,        /* 0x324b */
    SYMBOL,        /* 0x324c */
    SYMBOL,        /* 0x324d */
    SYMBOL,        /* 0x324e */
    SYMBOL,        /* 0x324f */
    SYMBOL,        /* 0x3250 */
    SYMBOL,        /* 0x3251 */
    SYMBOL,        /* 0x3252 */
    SYMBOL,        /* 0x3253 */
    SYMBOL,        /* 0x3254 */
    SYMBOL,        /* 0x3255 */
    SYMBOL,        /* 0x3256 */
    SYMBOL,        /* 0x3257 */
    SYMBOL,        /* 0x3258 */
    SYMBOL,        /* 0x3259 */
    SYMBOL,        /* 0x325a */
    SYMBOL,        /* 0x325b */
    SYMBOL,        /* 0x325c */
    SYMBOL,        /* 0x325d */
    SYMBOL,        /* 0x325e */
    SYMBOL,        /* 0x325f */
    SYMBOL,        /* 0x3260 */
    SYMBOL,        /* 0x3261 */
    SYMBOL,        /* 0x3262 */
    SYMBOL,        /* 0x3263 */
    SYMBOL,        /* 0x3264 */
    SYMBOL,        /* 0x3265 */
    SYMBOL,        /* 0x3266 */
    SYMBOL,        /* 0x3267 */
    SYMBOL,        /* 0x3268 */
    SYMBOL,        /* 0x3269 */
    SYMBOL,        /* 0x326a */
    SYMBOL,        /* 0x326b */
    SYMBOL,        /* 0x326c */
    SYMBOL,        /* 0x326d */
    SYMBOL,        /* 0x326e */
    SYMBOL,        /* 0x326f */
    SYMBOL,        /* 0x3270 */
    SYMBOL,        /* 0x3271 */
    SYMBOL,        /* 0x3272 */
    SYMBOL,        /* 0x3273 */
    SYMBOL,        /* 0x3274 */
    SYMBOL,        /* 0x3275 */
    SYMBOL,        /* 0x3276 */
    SYMBOL,        /* 0x3277 */
    SYMBOL,        /* 0x3278 */
    SYMBOL,        /* 0x3279 */
    SYMBOL,        /* 0x327a */
    SYMBOL,        /* 0x327b */
    SYMBOL,        /* 0x327c */
    SYMBOL,        /* 0x327d */
    SYMBOL,        /* 0x327e */
    SYMBOL,        /* 0x327f */
    SYMBOL,        /* 0x3280 */
    SYMBOL,        /* 0x3281 */
    SYMBOL,        /* 0x3282 */
    SYMBOL,        /* 0x3283 */
    SYMBOL,        /* 0x3284 */
    SYMBOL,        /* 0x3285 */
    SYMBOL,        /* 0x3286 */
    SYMBOL,        /* 0x3287 */
    SYMBOL,        /* 0x3288 */
    SYMBOL,        /* 0x3289 */
    SYMBOL,        /* 0x328a */
    SYMBOL,        /* 0x328b */
    SYMBOL,        /* 0x328c */
    SYMBOL,        /* 0x328d */
    SYMBOL,        /* 0x328e */
    SYMBOL,        /* 0x328f */
    SYMBOL,        /* 0x3290 */
    SYMBOL,        /* 0x3291 */
    SYMBOL,        /* 0x3292 */
    SYMBOL,        /* 0x3293 */
    SYMBOL,        /* 0x3294 */
    SYMBOL,        /* 0x3295 */
    SYMBOL,        /* 0x3296 */
    SYMBOL,        /* 0x3297 */
    SYMBOL,        /* 0x3298 */
    SYMBOL,        /* 0x3299 */
    SYMBOL,        /* 0x329a */
    SYMBOL,        /* 0x329b */
    SYMBOL,        /* 0x329c */
    SYMBOL,        /* 0x329d */
    SYMBOL,        /* 0x329e */
    SYMBOL,        /* 0x329f */
    SYMBOL,        /* 0x32a0 */
    SYMBOL,        /* 0x32a1 */
    SYMBOL,        /* 0x32a2 */
    SYMBOL,        /* 0x32a3 */
    SYMBOL,        /* 0x32a4 */
    SYMBOL,        /* 0x32a5 */
    SYMBOL,        /* 0x32a6 */
    SYMBOL,        /* 0x32a7 */
    SYMBOL,        /* 0x32a8 */
    SYMBOL,        /* 0x32a9 */
    SYMBOL,        /* 0x32aa */
    SYMBOL,        /* 0x32ab */
    SYMBOL,        /* 0x32ac */
    SYMBOL,        /* 0x32ad */
    SYMBOL,        /* 0x32ae */
    SYMBOL,        /* 0x32af */
    SYMBOL,        /* 0x32b0 */
    SYMBOL,        /* 0x32b1 */
    SYMBOL,        /* 0x32b2 */
    SYMBOL,        /* 0x32b3 */
    SYMBOL,        /* 0x32b4 */
    SYMBOL,        /* 0x32b5 */
    SYMBOL,        /* 0x32b6 */
    SYMBOL,        /* 0x32b7 */
    SYMBOL,        /* 0x32b8 */
    SYMBOL,        /* 0x32b9 */
    SYMBOL,        /* 0x32ba */
    SYMBOL,        /* 0x32bb */
    SYMBOL,        /* 0x32bc */
    SYMBOL,        /* 0x32bd */
    SYMBOL,        /* 0x32be */
    SYMBOL,        /* 0x32bf */
    SYMBOL,        /* 0x32c0 */
    SYMBOL,        /* 0x32c1 */
    SYMBOL,        /* 0x32c2 */
    SYMBOL,        /* 0x32c3 */
    SYMBOL,        /* 0x32c4 */
    SYMBOL,        /* 0x32c5 */
    SYMBOL,        /* 0x32c6 */
    SYMBOL,        /* 0x32c7 */
    SYMBOL,        /* 0x32c8 */
    SYMBOL,        /* 0x32c9 */
    SYMBOL,        /* 0x32ca */
    SYMBOL,        /* 0x32cb */
    SYMBOL,        /* 0x32cc */
    SYMBOL,        /* 0x32cd */
    SYMBOL,        /* 0x32ce */
    SYMBOL,        /* 0x32cf */
    SYMBOL,        /* 0x32d0 */
    SYMBOL,        /* 0x32d1 */
    SYMBOL,        /* 0x32d2 */
    SYMBOL,        /* 0x32d3 */
    SYMBOL,        /* 0x32d4 */
    SYMBOL,        /* 0x32d5 */
    SYMBOL,        /* 0x32d6 */
    SYMBOL,        /* 0x32d7 */
    SYMBOL,        /* 0x32d8 */
    SYMBOL,        /* 0x32d9 */
    SYMBOL,        /* 0x32da */
    SYMBOL,        /* 0x32db */
    SYMBOL,        /* 0x32dc */
    SYMBOL,        /* 0x32dd */
    SYMBOL,        /* 0x32de */
    SYMBOL,        /* 0x32df */
    SYMBOL,        /* 0x32e0 */
    SYMBOL,        /* 0x32e1 */
    SYMBOL,        /* 0x32e2 */
    SYMBOL,        /* 0x32e3 */
    SYMBOL,        /* 0x32e4 */
    SYMBOL,        /* 0x32e5 */
    SYMBOL,        /* 0x32e6 */
    SYMBOL,        /* 0x32e7 */
    SYMBOL,        /* 0x32e8 */
    SYMBOL,        /* 0x32e9 */
    SYMBOL,        /* 0x32ea */
    SYMBOL,        /* 0x32eb */
    SYMBOL,        /* 0x32ec */
    SYMBOL,        /* 0x32ed */
    SYMBOL,        /* 0x32ee */
    SYMBOL,        /* 0x32ef */
    SYMBOL,        /* 0x32f0 */
    SYMBOL,        /* 0x32f1 */
    SYMBOL,        /* 0x32f2 */
    SYMBOL,        /* 0x32f3 */
    SYMBOL,        /* 0x32f4 */
    SYMBOL,        /* 0x32f5 */
    SYMBOL,        /* 0x32f6 */
    SYMBOL,        /* 0x32f7 */
    SYMBOL,        /* 0x32f8 */
    SYMBOL,        /* 0x32f9 */
    SYMBOL,        /* 0x32fa */
    SYMBOL,        /* 0x32fb */
    SYMBOL,        /* 0x32fc */
    SYMBOL,        /* 0x32fd */
    SYMBOL,        /* 0x32fe */
    OTHER,        /* 0x32ff */
    SYMBOL,        /* 0x3300 */
    SYMBOL,        /* 0x3301 */
    SYMBOL,        /* 0x3302 */
    SYMBOL,        /* 0x3303 */
    SYMBOL,        /* 0x3304 */
    SYMBOL,        /* 0x3305 */
    SYMBOL,        /* 0x3306 */
    SYMBOL,        /* 0x3307 */
    SYMBOL,        /* 0x3308 */
    SYMBOL,        /* 0x3309 */
    SYMBOL,        /* 0x330a */
    SYMBOL,        /* 0x330b */
    SYMBOL,        /* 0x330c */
    SYMBOL,        /* 0x330d */
    SYMBOL,        /* 0x330e */
    SYMBOL,        /* 0x330f */
    SYMBOL,        /* 0x3310 */
    SYMBOL,        /* 0x3311 */
    SYMBOL,        /* 0x3312 */
    SYMBOL,        /* 0x3313 */
    SYMBOL,        /* 0x3314 */
    SYMBOL,        /* 0x3315 */
    SYMBOL,        /* 0x3316 */
    SYMBOL,        /* 0x3317 */
    SYMBOL,        /* 0x3318 */
    SYMBOL,        /* 0x3319 */
    SYMBOL,        /* 0x331a */
    SYMBOL,        /* 0x331b */
    SYMBOL,        /* 0x331c */
    SYMBOL,        /* 0x331d */
    SYMBOL,        /* 0x331e */
    SYMBOL,        /* 0x331f */
    SYMBOL,        /* 0x3320 */
    SYMBOL,        /* 0x3321 */
    SYMBOL,        /* 0x3322 */
    SYMBOL,        /* 0x3323 */
    SYMBOL,        /* 0x3324 */
    SYMBOL,        /* 0x3325 */
    SYMBOL,        /* 0x3326 */
    SYMBOL,        /* 0x3327 */
    SYMBOL,        /* 0x3328 */
    SYMBOL,        /* 0x3329 */
    SYMBOL,        /* 0x332a */
    SYMBOL,        /* 0x332b */
    SYMBOL,        /* 0x332c */
    SYMBOL,        /* 0x332d */
    SYMBOL,        /* 0x332e */
    SYMBOL,        /* 0x332f */
    SYMBOL,        /* 0x3330 */
    SYMBOL,        /* 0x3331 */
    SYMBOL,        /* 0x3332 */
    SYMBOL,        /* 0x3333 */
    SYMBOL,        /* 0x3334 */
    SYMBOL,        /* 0x3335 */
    SYMBOL,        /* 0x3336 */
    SYMBOL,        /* 0x3337 */
    SYMBOL,        /* 0x3338 */
    SYMBOL,        /* 0x3339 */
    SYMBOL,        /* 0x333a */
    SYMBOL,        /* 0x333b */
    SYMBOL,        /* 0x333c */
    SYMBOL,        /* 0x333d */
    SYMBOL,        /* 0x333e */
    SYMBOL,        /* 0x333f */
    SYMBOL,        /* 0x3340 */
    SYMBOL,        /* 0x3341 */
    SYMBOL,        /* 0x3342 */
    SYMBOL,        /* 0x3343 */
    SYMBOL,        /* 0x3344 */
    SYMBOL,        /* 0x3345 */
    SYMBOL,        /* 0x3346 */
    SYMBOL,        /* 0x3347 */
    SYMBOL,        /* 0x3348 */
    SYMBOL,        /* 0x3349 */
    SYMBOL,        /* 0x334a */
    SYMBOL,        /* 0x334b */
    SYMBOL,        /* 0x334c */
    SYMBOL,        /* 0x334d */
    SYMBOL,        /* 0x334e */
    SYMBOL,        /* 0x334f */
    SYMBOL,        /* 0x3350 */
    SYMBOL,        /* 0x3351 */
    SYMBOL,        /* 0x3352 */
    SYMBOL,        /* 0x3353 */
    SYMBOL,        /* 0x3354 */
    SYMBOL,        /* 0x3355 */
    SYMBOL,        /* 0x3356 */
    SYMBOL,        /* 0x3357 */
    SYMBOL,        /* 0x3358 */
    SYMBOL,        /* 0x3359 */
    SYMBOL,        /* 0x335a */
    SYMBOL,        /* 0x335b */
    SYMBOL,        /* 0x335c */
    SYMBOL,        /* 0x335d */
    SYMBOL,        /* 0x335e */
    SYMBOL,        /* 0x335f */
    SYMBOL,        /* 0x3360 */
    SYMBOL,        /* 0x3361 */
    SYMBOL,        /* 0x3362 */
    SYMBOL,        /* 0x3363 */
    SYMBOL,        /* 0x3364 */
    SYMBOL,        /* 0x3365 */
    SYMBOL,        /* 0x3366 */
    SYMBOL,        /* 0x3367 */
    SYMBOL,        /* 0x3368 */
    SYMBOL,        /* 0x3369 */
    SYMBOL,        /* 0x336a */
    SYMBOL,        /* 0x336b */
    SYMBOL,        /* 0x336c */
    SYMBOL,        /* 0x336d */
    SYMBOL,        /* 0x336e */
    SYMBOL,        /* 0x336f */
    SYMBOL,        /* 0x3370 */
    SYMBOL,        /* 0x3371 */
    SYMBOL,        /* 0x3372 */
    SYMBOL,        /* 0x3373 */
    SYMBOL,        /* 0x3374 */
    SYMBOL,        /* 0x3375 */
    SYMBOL,        /* 0x3376 */
    SYMBOL,        /* 0x3377 */
    SYMBOL,        /* 0x3378 */
    SYMBOL,        /* 0x3379 */
    SYMBOL,        /* 0x337a */
    SYMBOL,        /* 0x337b */
    SYMBOL,        /* 0x337c */
    SYMBOL,        /* 0x337d */
    SYMBOL,        /* 0x337e */
    SYMBOL,        /* 0x337f */
    SYMBOL,        /* 0x3380 */
    SYMBOL,        /* 0x3381 */
    SYMBOL,        /* 0x3382 */
    SYMBOL,        /* 0x3383 */
    SYMBOL,        /* 0x3384 */
    SYMBOL,        /* 0x3385 */
    SYMBOL,        /* 0x3386 */
    SYMBOL,        /* 0x3387 */
    SYMBOL,        /* 0x3388 */
    SYMBOL,        /* 0x3389 */
    SYMBOL,        /* 0x338a */
    SYMBOL,        /* 0x338b */
    SYMBOL,        /* 0x338c */
    SYMBOL,        /* 0x338d */
    SYMBOL,        /* 0x338e */
    SYMBOL,        /* 0x338f */
    SYMBOL,        /* 0x3390 */
    SYMBOL,        /* 0x3391 */
    SYMBOL,        /* 0x3392 */
    SYMBOL,        /* 0x3393 */
    SYMBOL,        /* 0x3394 */
    SYMBOL,        /* 0x3395 */
    SYMBOL,        /* 0x3396 */
    SYMBOL,        /* 0x3397 */
    SYMBOL,        /* 0x3398 */
    SYMBOL,        /* 0x3399 */
    SYMBOL,        /* 0x339a */
    SYMBOL,        /* 0x339b */
    SYMBOL,        /* 0x339c */
    SYMBOL,        /* 0x339d */
    SYMBOL,        /* 0x339e */
    SYMBOL,        /* 0x339f */
    SYMBOL,        /* 0x33a0 */
    SYMBOL,        /* 0x33a1 */
    SYMBOL,        /* 0x33a2 */
    SYMBOL,        /* 0x33a3 */
    SYMBOL,        /* 0x33a4 */
    SYMBOL,        /* 0x33a5 */
    SYMBOL,        /* 0x33a6 */
    SYMBOL,        /* 0x33a7 */
    SYMBOL,        /* 0x33a8 */
    SYMBOL,        /* 0x33a9 */
    SYMBOL,        /* 0x33aa */
    SYMBOL,        /* 0x33ab */
    SYMBOL,        /* 0x33ac */
    SYMBOL,        /* 0x33ad */
    SYMBOL,        /* 0x33ae */
    SYMBOL,        /* 0x33af */
    SYMBOL,        /* 0x33b0 */
    SYMBOL,        /* 0x33b1 */
    SYMBOL,        /* 0x33b2 */
    SYMBOL,        /* 0x33b3 */
    SYMBOL,        /* 0x33b4 */
    SYMBOL,        /* 0x33b5 */
    SYMBOL,        /* 0x33b6 */
    SYMBOL,        /* 0x33b7 */
    SYMBOL,        /* 0x33b8 */
    SYMBOL,        /* 0x33b9 */
    SYMBOL,        /* 0x33ba */
    SYMBOL,        /* 0x33bb */
    SYMBOL,        /* 0x33bc */
    SYMBOL,        /* 0x33bd */
    SYMBOL,        /* 0x33be */
    SYMBOL,        /* 0x33bf */
    SYMBOL,        /* 0x33c0 */
    SYMBOL,        /* 0x33c1 */
    SYMBOL,        /* 0x33c2 */
    SYMBOL,        /* 0x33c3 */
    SYMBOL,        /* 0x33c4 */
    SYMBOL,        /* 0x33c5 */
    SYMBOL,        /* 0x33c6 */
    SYMBOL,        /* 0x33c7 */
    SYMBOL,        /* 0x33c8 */
    SYMBOL,        /* 0x33c9 */
    SYMBOL,        /* 0x33ca */
    SYMBOL,        /* 0x33cb */
    SYMBOL,        /* 0x33cc */
    SYMBOL,        /* 0x33cd */
    SYMBOL,        /* 0x33ce */
    SYMBOL,        /* 0x33cf */
    SYMBOL,        /* 0x33d0 */
    SYMBOL,        /* 0x33d1 */
    SYMBOL,        /* 0x33d2 */
    SYMBOL,        /* 0x33d3 */
    SYMBOL,        /* 0x33d4 */
    SYMBOL,        /* 0x33d5 */
    SYMBOL,        /* 0x33d6 */
    SYMBOL,        /* 0x33d7 */
    SYMBOL,        /* 0x33d8 */
    SYMBOL,        /* 0x33d9 */
    SYMBOL,        /* 0x33da */
    SYMBOL,        /* 0x33db */
    SYMBOL,        /* 0x33dc */
    SYMBOL,        /* 0x33dd */
    SYMBOL,        /* 0x33de */
    SYMBOL,        /* 0x33df */
    SYMBOL,        /* 0x33e0 */
    SYMBOL,        /* 0x33e1 */
    SYMBOL,        /* 0x33e2 */
    SYMBOL,        /* 0x33e3 */
    SYMBOL,        /* 0x33e4 */
    SYMBOL,        /* 0x33e5 */
    SYMBOL,        /* 0x33e6 */
    SYMBOL,        /* 0x33e7 */
    SYMBOL,        /* 0x33e8 */
    SYMBOL,        /* 0x33e9 */
    SYMBOL,        /* 0x33ea */
    SYMBOL,        /* 0x33eb */
    SYMBOL,        /* 0x33ec */
    SYMBOL,        /* 0x33ed */
    SYMBOL,        /* 0x33ee */
    SYMBOL,        /* 0x33ef */
    SYMBOL,        /* 0x33f0 */
    SYMBOL,        /* 0x33f1 */
    SYMBOL,        /* 0x33f2 */
    SYMBOL,        /* 0x33f3 */
    SYMBOL,        /* 0x33f4 */
    SYMBOL,        /* 0x33f5 */
    SYMBOL,        /* 0x33f6 */
    SYMBOL,        /* 0x33f7 */
    SYMBOL,        /* 0x33f8 */
    SYMBOL,        /* 0x33f9 */
    SYMBOL,        /* 0x33fa */
    SYMBOL,        /* 0x33fb */
    SYMBOL,        /* 0x33fc */
    SYMBOL,        /* 0x33fd */
    SYMBOL,        /* 0x33fe */
    SYMBOL,        /* 0x33ff */
    KANJI,        /* 0x3400 */
    KANJI,        /* 0x3401 */
    KANJI,        /* 0x3402 */
    KANJI,        /* 0x3403 */
    KANJI,        /* 0x3404 */
    KANJI,        /* 0x3405 */
    KANJI,        /* 0x3406 */
    KANJI,        /* 0x3407 */
    KANJI,        /* 0x3408 */
    KANJI,        /* 0x3409 */
    KANJI,        /* 0x340a */
    KANJI,        /* 0x340b */
    KANJI,        /* 0x340c */
    KANJI,        /* 0x340d */
    KANJI,        /* 0x340e */
    KANJI,        /* 0x340f */
    KANJI,        /* 0x3410 */
    KANJI,        /* 0x3411 */
    KANJI,        /* 0x3412 */
    KANJI,        /* 0x3413 */
    KANJI,        /* 0x3414 */
    KANJI,        /* 0x3415 */
    KANJI,        /* 0x3416 */
    KANJI,        /* 0x3417 */
    KANJI,        /* 0x3418 */
    KANJI,        /* 0x3419 */
    KANJI,        /* 0x341a */
    KANJI,        /* 0x341b */
    KANJI,        /* 0x341c */
    KANJI,        /* 0x341d */
    KANJI,        /* 0x341e */
    KANJI,        /* 0x341f */
    KANJI,        /* 0x3420 */
    KANJI,        /* 0x3421 */
    KANJI,        /* 0x3422 */
    KANJI,        /* 0x3423 */
    KANJI,        /* 0x3424 */
    KANJI,        /* 0x3425 */
    KANJI,        /* 0x3426 */
    KANJI,        /* 0x3427 */
    KANJI,        /* 0x3428 */
    KANJI,        /* 0x3429 */
    KANJI,        /* 0x342a */
    KANJI,        /* 0x342b */
    KANJI,        /* 0x342c */
    KANJI,        /* 0x342d */
    KANJI,        /* 0x342e */
    KANJI,        /* 0x342f */
    KANJI,        /* 0x3430 */
    KANJI,        /* 0x3431 */
    KANJI,        /* 0x3432 */
    KANJI,        /* 0x3433 */
    KANJI,        /* 0x3434 */
    KANJI,        /* 0x3435 */
    KANJI,        /* 0x3436 */
    KANJI,        /* 0x3437 */
    KANJI,        /* 0x3438 */
    KANJI,        /* 0x3439 */
    KANJI,        /* 0x343a */
    KANJI,        /* 0x343b */
    KANJI,        /* 0x343c */
    KANJI,        /* 0x343d */
    KANJI,        /* 0x343e */
    KANJI,        /* 0x343f */
    KANJI,        /* 0x3440 */
    KANJI,        /* 0x3441 */
    KANJI,        /* 0x3442 */
    KANJI,        /* 0x3443 */
    KANJI,        /* 0x3444 */
    KANJI,        /* 0x3445 */
    KANJI,        /* 0x3446 */
    KANJI,        /* 0x3447 */
    KANJI,        /* 0x3448 */
    KANJI,        /* 0x3449 */
    KANJI,        /* 0x344a */
    KANJI,        /* 0x344b */
    KANJI,        /* 0x344c */
    KANJI,        /* 0x344d */
    KANJI,        /* 0x344e */
    KANJI,        /* 0x344f */
    KANJI,        /* 0x3450 */
    KANJI,        /* 0x3451 */
    KANJI,        /* 0x3452 */
    KANJI,        /* 0x3453 */
    KANJI,        /* 0x3454 */
    KANJI,        /* 0x3455 */
    KANJI,        /* 0x3456 */
    KANJI,        /* 0x3457 */
    KANJI,        /* 0x3458 */
    KANJI,        /* 0x3459 */
    KANJI,        /* 0x345a */
    KANJI,        /* 0x345b */
    KANJI,        /* 0x345c */
    KANJI,        /* 0x345d */
    KANJI,        /* 0x345e */
    KANJI,        /* 0x345f */
    KANJI,        /* 0x3460 */
    KANJI,        /* 0x3461 */
    KANJI,        /* 0x3462 */
    KANJI,        /* 0x3463 */
    KANJI,        /* 0x3464 */
    KANJI,        /* 0x3465 */
    KANJI,        /* 0x3466 */
    KANJI,        /* 0x3467 */
    KANJI,        /* 0x3468 */
    KANJI,        /* 0x3469 */
    KANJI,        /* 0x346a */
    KANJI,        /* 0x346b */
    KANJI,        /* 0x346c */
    KANJI,        /* 0x346d */
    KANJI,        /* 0x346e */
    KANJI,        /* 0x346f */
    KANJI,        /* 0x3470 */
    KANJI,        /* 0x3471 */
    KANJI,        /* 0x3472 */
    KANJI,        /* 0x3473 */
    KANJI,        /* 0x3474 */
    KANJI,        /* 0x3475 */
    KANJI,        /* 0x3476 */
    KANJI,        /* 0x3477 */
    KANJI,        /* 0x3478 */
    KANJI,        /* 0x3479 */
    KANJI,        /* 0x347a */
    KANJI,        /* 0x347b */
    KANJI,        /* 0x347c */
    KANJI,        /* 0x347d */
    KANJI,        /* 0x347e */
    KANJI,        /* 0x347f */
    KANJI,        /* 0x3480 */
    KANJI,        /* 0x3481 */
    KANJI,        /* 0x3482 */
    KANJI,        /* 0x3483 */
    KANJI,        /* 0x3484 */
    KANJI,        /* 0x3485 */
    KANJI,        /* 0x3486 */
    KANJI,        /* 0x3487 */
    KANJI,        /* 0x3488 */
    KANJI,        /* 0x3489 */
    KANJI,        /* 0x348a */
    KANJI,        /* 0x348b */
    KANJI,        /* 0x348c */
    KANJI,        /* 0x348d */
    KANJI,        /* 0x348e */
    KANJI,        /* 0x348f */
    KANJI,        /* 0x3490 */
    KANJI,        /* 0x3491 */
    KANJI,        /* 0x3492 */
    KANJI,        /* 0x3493 */
    KANJI,        /* 0x3494 */
    KANJI,        /* 0x3495 */
    KANJI,        /* 0x3496 */
    KANJI,        /* 0x3497 */
    KANJI,        /* 0x3498 */
    KANJI,        /* 0x3499 */
    KANJI,        /* 0x349a */
    KANJI,        /* 0x349b */
    KANJI,        /* 0x349c */
    KANJI,        /* 0x349d */
    KANJI,        /* 0x349e */
    KANJI,        /* 0x349f */
    KANJI,        /* 0x34a0 */
    KANJI,        /* 0x34a1 */
    KANJI,        /* 0x34a2 */
    KANJI,        /* 0x34a3 */
    KANJI,        /* 0x34a4 */
    KANJI,        /* 0x34a5 */
    KANJI,        /* 0x34a6 */
    KANJI,        /* 0x34a7 */
    KANJI,        /* 0x34a8 */
    KANJI,        /* 0x34a9 */
    KANJI,        /* 0x34aa */
    KANJI,        /* 0x34ab */
    KANJI,        /* 0x34ac */
    KANJI,        /* 0x34ad */
    KANJI,        /* 0x34ae */
    KANJI,        /* 0x34af */
    KANJI,        /* 0x34b0 */
    KANJI,        /* 0x34b1 */
    KANJI,        /* 0x34b2 */
    KANJI,        /* 0x34b3 */
    KANJI,        /* 0x34b4 */
    KANJI,        /* 0x34b5 */
    KANJI,        /* 0x34b6 */
    KANJI,        /* 0x34b7 */
    KANJI,        /* 0x34b8 */
    KANJI,        /* 0x34b9 */
    KANJI,        /* 0x34ba */
    KANJI,        /* 0x34bb */
    KANJI,        /* 0x34bc */
    KANJI,        /* 0x34bd */
    KANJI,        /* 0x34be */
    KANJI,        /* 0x34bf */
    KANJI,        /* 0x34c0 */
    KANJI,        /* 0x34c1 */
    KANJI,        /* 0x34c2 */
    KANJI,        /* 0x34c3 */
    KANJI,        /* 0x34c4 */
    KANJI,        /* 0x34c5 */
    KANJI,        /* 0x34c6 */
    KANJI,        /* 0x34c7 */
    KANJI,        /* 0x34c8 */
    KANJI,        /* 0x34c9 */
    KANJI,        /* 0x34ca */
    KANJI,        /* 0x34cb */
    KANJI,        /* 0x34cc */
    KANJI,        /* 0x34cd */
    KANJI,        /* 0x34ce */
    KANJI,        /* 0x34cf */
    KANJI,        /* 0x34d0 */
    KANJI,        /* 0x34d1 */
    KANJI,        /* 0x34d2 */
    KANJI,        /* 0x34d3 */
    KANJI,        /* 0x34d4 */
    KANJI,        /* 0x34d5 */
    KANJI,        /* 0x34d6 */
    KANJI,        /* 0x34d7 */
    KANJI,        /* 0x34d8 */
    KANJI,        /* 0x34d9 */
    KANJI,        /* 0x34da */
    KANJI,        /* 0x34db */
    KANJI,        /* 0x34dc */
    KANJI,        /* 0x34dd */
    KANJI,        /* 0x34de */
    KANJI,        /* 0x34df */
    KANJI,        /* 0x34e0 */
    KANJI,        /* 0x34e1 */
    KANJI,        /* 0x34e2 */
    KANJI,        /* 0x34e3 */
    KANJI,        /* 0x34e4 */
    KANJI,        /* 0x34e5 */
    KANJI,        /* 0x34e6 */
    KANJI,        /* 0x34e7 */
    KANJI,        /* 0x34e8 */
    KANJI,        /* 0x34e9 */
    KANJI,        /* 0x34ea */
    KANJI,        /* 0x34eb */
    KANJI,        /* 0x34ec */
    KANJI,        /* 0x34ed */
    KANJI,        /* 0x34ee */
    KANJI,        /* 0x34ef */
    KANJI,        /* 0x34f0 */
    KANJI,        /* 0x34f1 */
    KANJI,        /* 0x34f2 */
    KANJI,        /* 0x34f3 */
    KANJI,        /* 0x34f4 */
    KANJI,        /* 0x34f5 */
    KANJI,        /* 0x34f6 */
    KANJI,        /* 0x34f7 */
    KANJI,        /* 0x34f8 */
    KANJI,        /* 0x34f9 */
    KANJI,        /* 0x34fa */
    KANJI,        /* 0x34fb */
    KANJI,        /* 0x34fc */
    KANJI,        /* 0x34fd */
    KANJI,        /* 0x34fe */
    KANJI,        /* 0x34ff */
    KANJI,        /* 0x3500 */
    KANJI,        /* 0x3501 */
    KANJI,        /* 0x3502 */
    KANJI,        /* 0x3503 */
    KANJI,        /* 0x3504 */
    KANJI,        /* 0x3505 */
    KANJI,        /* 0x3506 */
    KANJI,        /* 0x3507 */
    KANJI,        /* 0x3508 */
    KANJI,        /* 0x3509 */
    KANJI,        /* 0x350a */
    KANJI,        /* 0x350b */
    KANJI,        /* 0x350c */
    KANJI,        /* 0x350d */
    KANJI,        /* 0x350e */
    KANJI,        /* 0x350f */
    KANJI,        /* 0x3510 */
    KANJI,        /* 0x3511 */
    KANJI,        /* 0x3512 */
    KANJI,        /* 0x3513 */
    KANJI,        /* 0x3514 */
    KANJI,        /* 0x3515 */
    KANJI,        /* 0x3516 */
    KANJI,        /* 0x3517 */
    KANJI,        /* 0x3518 */
    KANJI,        /* 0x3519 */
    KANJI,        /* 0x351a */
    KANJI,        /* 0x351b */
    KANJI,        /* 0x351c */
    KANJI,        /* 0x351d */
    KANJI,        /* 0x351e */
    KANJI,        /* 0x351f */
    KANJI,        /* 0x3520 */
    KANJI,        /* 0x3521 */
    KANJI,        /* 0x3522 */
    KANJI,        /* 0x3523 */
    KANJI,        /* 0x3524 */
    KANJI,        /* 0x3525 */
    KANJI,        /* 0x3526 */
    KANJI,        /* 0x3527 */
    KANJI,        /* 0x3528 */
    KANJI,        /* 0x3529 */
    KANJI,        /* 0x352a */
    KANJI,        /* 0x352b */
    KANJI,        /* 0x352c */
    KANJI,        /* 0x352d */
    KANJI,        /* 0x352e */
    KANJI,        /* 0x352f */
    KANJI,        /* 0x3530 */
    KANJI,        /* 0x3531 */
    KANJI,        /* 0x3532 */
    KANJI,        /* 0x3533 */
    KANJI,        /* 0x3534 */
    KANJI,        /* 0x3535 */
    KANJI,        /* 0x3536 */
    KANJI,        /* 0x3537 */
    KANJI,        /* 0x3538 */
    KANJI,        /* 0x3539 */
    KANJI,        /* 0x353a */
    KANJI,        /* 0x353b */
    KANJI,        /* 0x353c */
    KANJI,        /* 0x353d */
    KANJI,        /* 0x353e */
    KANJI,        /* 0x353f */
    KANJI,        /* 0x3540 */
    KANJI,        /* 0x3541 */
    KANJI,        /* 0x3542 */
    KANJI,        /* 0x3543 */
    KANJI,        /* 0x3544 */
    KANJI,        /* 0x3545 */
    KANJI,        /* 0x3546 */
    KANJI,        /* 0x3547 */
    KANJI,        /* 0x3548 */
    KANJI,        /* 0x3549 */
    KANJI,        /* 0x354a */
    KANJI,        /* 0x354b */
    KANJI,        /* 0x354c */
    KANJI,        /* 0x354d */
    KANJI,        /* 0x354e */
    KANJI,        /* 0x354f */
    KANJI,        /* 0x3550 */
    KANJI,        /* 0x3551 */
    KANJI,        /* 0x3552 */
    KANJI,        /* 0x3553 */
    KANJI,        /* 0x3554 */
    KANJI,        /* 0x3555 */
    KANJI,        /* 0x3556 */
    KANJI,        /* 0x3557 */
    KANJI,        /* 0x3558 */
    KANJI,        /* 0x3559 */
    KANJI,        /* 0x355a */
    KANJI,        /* 0x355b */
    KANJI,        /* 0x355c */
    KANJI,        /* 0x355d */
    KANJI,        /* 0x355e */
    KANJI,        /* 0x355f */
    KANJI,        /* 0x3560 */
    KANJI,        /* 0x3561 */
    KANJI,        /* 0x3562 */
    KANJI,        /* 0x3563 */
    KANJI,        /* 0x3564 */
    KANJI,        /* 0x3565 */
    KANJI,        /* 0x3566 */
    KANJI,        /* 0x3567 */
    KANJI,        /* 0x3568 */
    KANJI,        /* 0x3569 */
    KANJI,        /* 0x356a */
    KANJI,        /* 0x356b */
    KANJI,        /* 0x356c */
    KANJI,        /* 0x356d */
    KANJI,        /* 0x356e */
    KANJI,        /* 0x356f */
    KANJI,        /* 0x3570 */
    KANJI,        /* 0x3571 */
    KANJI,        /* 0x3572 */
    KANJI,        /* 0x3573 */
    KANJI,        /* 0x3574 */
    KANJI,        /* 0x3575 */
    KANJI,        /* 0x3576 */
    KANJI,        /* 0x3577 */
    KANJI,        /* 0x3578 */
    KANJI,        /* 0x3579 */
    KANJI,        /* 0x357a */
    KANJI,        /* 0x357b */
    KANJI,        /* 0x357c */
    KANJI,        /* 0x357d */
    KANJI,        /* 0x357e */
    KANJI,        /* 0x357f */
    KANJI,        /* 0x3580 */
    KANJI,        /* 0x3581 */
    KANJI,        /* 0x3582 */
    KANJI,        /* 0x3583 */
    KANJI,        /* 0x3584 */
    KANJI,        /* 0x3585 */
    KANJI,        /* 0x3586 */
    KANJI,        /* 0x3587 */
    KANJI,        /* 0x3588 */
    KANJI,        /* 0x3589 */
    KANJI,        /* 0x358a */
    KANJI,        /* 0x358b */
    KANJI,        /* 0x358c */
    KANJI,        /* 0x358d */
    KANJI,        /* 0x358e */
    KANJI,        /* 0x358f */
    KANJI,        /* 0x3590 */
    KANJI,        /* 0x3591 */
    KANJI,        /* 0x3592 */
    KANJI,        /* 0x3593 */
    KANJI,        /* 0x3594 */
    KANJI,        /* 0x3595 */
    KANJI,        /* 0x3596 */
    KANJI,        /* 0x3597 */
    KANJI,        /* 0x3598 */
    KANJI,        /* 0x3599 */
    KANJI,        /* 0x359a */
    KANJI,        /* 0x359b */
    KANJI,        /* 0x359c */
    KANJI,        /* 0x359d */
    KANJI,        /* 0x359e */
    KANJI,        /* 0x359f */
    KANJI,        /* 0x35a0 */
    KANJI,        /* 0x35a1 */
    KANJI,        /* 0x35a2 */
    KANJI,        /* 0x35a3 */
    KANJI,        /* 0x35a4 */
    KANJI,        /* 0x35a5 */
    KANJI,        /* 0x35a6 */
    KANJI,        /* 0x35a7 */
    KANJI,        /* 0x35a8 */
    KANJI,        /* 0x35a9 */
    KANJI,        /* 0x35aa */
    KANJI,        /* 0x35ab */
    KANJI,        /* 0x35ac */
    KANJI,        /* 0x35ad */
    KANJI,        /* 0x35ae */
    KANJI,        /* 0x35af */
    KANJI,        /* 0x35b0 */
    KANJI,        /* 0x35b1 */
    KANJI,        /* 0x35b2 */
    KANJI,        /* 0x35b3 */
    KANJI,        /* 0x35b4 */
    KANJI,        /* 0x35b5 */
    KANJI,        /* 0x35b6 */
    KANJI,        /* 0x35b7 */
    KANJI,        /* 0x35b8 */
    KANJI,        /* 0x35b9 */
    KANJI,        /* 0x35ba */
    KANJI,        /* 0x35bb */
    KANJI,        /* 0x35bc */
    KANJI,        /* 0x35bd */
    KANJI,        /* 0x35be */
    KANJI,        /* 0x35bf */
    KANJI,        /* 0x35c0 */
    KANJI,        /* 0x35c1 */
    KANJI,        /* 0x35c2 */
    KANJI,        /* 0x35c3 */
    KANJI,        /* 0x35c4 */
    KANJI,        /* 0x35c5 */
    KANJI,        /* 0x35c6 */
    KANJI,        /* 0x35c7 */
    KANJI,        /* 0x35c8 */
    KANJI,        /* 0x35c9 */
    KANJI,        /* 0x35ca */
    KANJI,        /* 0x35cb */
    KANJI,        /* 0x35cc */
    KANJI,        /* 0x35cd */
    KANJI,        /* 0x35ce */
    KANJI,        /* 0x35cf */
    KANJI,        /* 0x35d0 */
    KANJI,        /* 0x35d1 */
    KANJI,        /* 0x35d2 */
    KANJI,        /* 0x35d3 */
    KANJI,        /* 0x35d4 */
    KANJI,        /* 0x35d5 */
    KANJI,        /* 0x35d6 */
    KANJI,        /* 0x35d7 */
    KANJI,        /* 0x35d8 */
    KANJI,        /* 0x35d9 */
    KANJI,        /* 0x35da */
    KANJI,        /* 0x35db */
    KANJI,        /* 0x35dc */
    KANJI,        /* 0x35dd */
    KANJI,        /* 0x35de */
    KANJI,        /* 0x35df */
    KANJI,        /* 0x35e0 */
    KANJI,        /* 0x35e1 */
    KANJI,        /* 0x35e2 */
    KANJI,        /* 0x35e3 */
    KANJI,        /* 0x35e4 */
    KANJI,        /* 0x35e5 */
    KANJI,        /* 0x35e6 */
    KANJI,        /* 0x35e7 */
    KANJI,        /* 0x35e8 */
    KANJI,        /* 0x35e9 */
    KANJI,        /* 0x35ea */
    KANJI,        /* 0x35eb */
    KANJI,        /* 0x35ec */
    KANJI,        /* 0x35ed */
    KANJI,        /* 0x35ee */
    KANJI,        /* 0x35ef */
    KANJI,        /* 0x35f0 */
    KANJI,        /* 0x35f1 */
    KANJI,        /* 0x35f2 */
    KANJI,        /* 0x35f3 */
    KANJI,        /* 0x35f4 */
    KANJI,        /* 0x35f5 */
    KANJI,        /* 0x35f6 */
    KANJI,        /* 0x35f7 */
    KANJI,        /* 0x35f8 */
    KANJI,        /* 0x35f9 */
    KANJI,        /* 0x35fa */
    KANJI,        /* 0x35fb */
    KANJI,        /* 0x35fc */
    KANJI,        /* 0x35fd */
    KANJI,        /* 0x35fe */
    KANJI,        /* 0x35ff */
    KANJI,        /* 0x3600 */
    KANJI,        /* 0x3601 */
    KANJI,        /* 0x3602 */
    KANJI,        /* 0x3603 */
    KANJI,        /* 0x3604 */
    KANJI,        /* 0x3605 */
    KANJI,        /* 0x3606 */
    KANJI,        /* 0x3607 */
    KANJI,        /* 0x3608 */
    KANJI,        /* 0x3609 */
    KANJI,        /* 0x360a */
    KANJI,        /* 0x360b */
    KANJI,        /* 0x360c */
    KANJI,        /* 0x360d */
    KANJI,        /* 0x360e */
    KANJI,        /* 0x360f */
    KANJI,        /* 0x3610 */
    KANJI,        /* 0x3611 */
    KANJI,        /* 0x3612 */
    KANJI,        /* 0x3613 */
    KANJI,        /* 0x3614 */
    KANJI,        /* 0x3615 */
    KANJI,        /* 0x3616 */
    KANJI,        /* 0x3617 */
    KANJI,        /* 0x3618 */
    KANJI,        /* 0x3619 */
    KANJI,        /* 0x361a */
    KANJI,        /* 0x361b */
    KANJI,        /* 0x361c */
    KANJI,        /* 0x361d */
    KANJI,        /* 0x361e */
    KANJI,        /* 0x361f */
    KANJI,        /* 0x3620 */
    KANJI,        /* 0x3621 */
    KANJI,        /* 0x3622 */
    KANJI,        /* 0x3623 */
    KANJI,        /* 0x3624 */
    KANJI,        /* 0x3625 */
    KANJI,        /* 0x3626 */
    KANJI,        /* 0x3627 */
    KANJI,        /* 0x3628 */
    KANJI,        /* 0x3629 */
    KANJI,        /* 0x362a */
    KANJI,        /* 0x362b */
    KANJI,        /* 0x362c */
    KANJI,        /* 0x362d */
    KANJI,        /* 0x362e */
    KANJI,        /* 0x362f */
    KANJI,        /* 0x3630 */
    KANJI,        /* 0x3631 */
    KANJI,        /* 0x3632 */
    KANJI,        /* 0x3633 */
    KANJI,        /* 0x3634 */
    KANJI,        /* 0x3635 */
    KANJI,        /* 0x3636 */
    KANJI,        /* 0x3637 */
    KANJI,        /* 0x3638 */
    KANJI,        /* 0x3639 */
    KANJI,        /* 0x363a */
    KANJI,        /* 0x363b */
    KANJI,        /* 0x363c */
    KANJI,        /* 0x363d */
    KANJI,        /* 0x363e */
    KANJI,        /* 0x363f */
    KANJI,        /* 0x3640 */
    KANJI,        /* 0x3641 */
    KANJI,        /* 0x3642 */
    KANJI,        /* 0x3643 */
    KANJI,        /* 0x3644 */
    KANJI,        /* 0x3645 */
    KANJI,        /* 0x3646 */
    KANJI,        /* 0x3647 */
    KANJI,        /* 0x3648 */
    KANJI,        /* 0x3649 */
    KANJI,        /* 0x364a */
    KANJI,        /* 0x364b */
    KANJI,        /* 0x364c */
    KANJI,        /* 0x364d */
    KANJI,        /* 0x364e */
    KANJI,        /* 0x364f */
    KANJI,        /* 0x3650 */
    KANJI,        /* 0x3651 */
    KANJI,        /* 0x3652 */
    KANJI,        /* 0x3653 */
    KANJI,        /* 0x3654 */
    KANJI,        /* 0x3655 */
    KANJI,        /* 0x3656 */
    KANJI,        /* 0x3657 */
    KANJI,        /* 0x3658 */
    KANJI,        /* 0x3659 */
    KANJI,        /* 0x365a */
    KANJI,        /* 0x365b */
    KANJI,        /* 0x365c */
    KANJI,        /* 0x365d */
    KANJI,        /* 0x365e */
    KANJI,        /* 0x365f */
    KANJI,        /* 0x3660 */
    KANJI,        /* 0x3661 */
    KANJI,        /* 0x3662 */
    KANJI,        /* 0x3663 */
    KANJI,        /* 0x3664 */
    KANJI,        /* 0x3665 */
    KANJI,        /* 0x3666 */
    KANJI,        /* 0x3667 */
    KANJI,        /* 0x3668 */
    KANJI,        /* 0x3669 */
    KANJI,        /* 0x366a */
    KANJI,        /* 0x366b */
    KANJI,        /* 0x366c */
    KANJI,        /* 0x366d */
    KANJI,        /* 0x366e */
    KANJI,        /* 0x366f */
    KANJI,        /* 0x3670 */
    KANJI,        /* 0x3671 */
    KANJI,        /* 0x3672 */
    KANJI,        /* 0x3673 */
    KANJI,        /* 0x3674 */
    KANJI,        /* 0x3675 */
    KANJI,        /* 0x3676 */
    KANJI,        /* 0x3677 */
    KANJI,        /* 0x3678 */
    KANJI,        /* 0x3679 */
    KANJI,        /* 0x367a */
    KANJI,        /* 0x367b */
    KANJI,        /* 0x367c */
    KANJI,        /* 0x367d */
    KANJI,        /* 0x367e */
    KANJI,        /* 0x367f */
    KANJI,        /* 0x3680 */
    KANJI,        /* 0x3681 */
    KANJI,        /* 0x3682 */
    KANJI,        /* 0x3683 */
    KANJI,        /* 0x3684 */
    KANJI,        /* 0x3685 */
    KANJI,        /* 0x3686 */
    KANJI,        /* 0x3687 */
    KANJI,        /* 0x3688 */
    KANJI,        /* 0x3689 */
    KANJI,        /* 0x368a */
    KANJI,        /* 0x368b */
    KANJI,        /* 0x368c */
    KANJI,        /* 0x368d */
    KANJI,        /* 0x368e */
    KANJI,        /* 0x368f */
    KANJI,        /* 0x3690 */
    KANJI,        /* 0x3691 */
    KANJI,        /* 0x3692 */
    KANJI,        /* 0x3693 */
    KANJI,        /* 0x3694 */
    KANJI,        /* 0x3695 */
    KANJI,        /* 0x3696 */
    KANJI,        /* 0x3697 */
    KANJI,        /* 0x3698 */
    KANJI,        /* 0x3699 */
    KANJI,        /* 0x369a */
    KANJI,        /* 0x369b */
    KANJI,        /* 0x369c */
    KANJI,        /* 0x369d */
    KANJI,        /* 0x369e */
    KANJI,        /* 0x369f */
    KANJI,        /* 0x36a0 */
    KANJI,        /* 0x36a1 */
    KANJI,        /* 0x36a2 */
    KANJI,        /* 0x36a3 */
    KANJI,        /* 0x36a4 */
    KANJI,        /* 0x36a5 */
    KANJI,        /* 0x36a6 */
    KANJI,        /* 0x36a7 */
    KANJI,        /* 0x36a8 */
    KANJI,        /* 0x36a9 */
    KANJI,        /* 0x36aa */
    KANJI,        /* 0x36ab */
    KANJI,        /* 0x36ac */
    KANJI,        /* 0x36ad */
    KANJI,        /* 0x36ae */
    KANJI,        /* 0x36af */
    KANJI,        /* 0x36b0 */
    KANJI,        /* 0x36b1 */
    KANJI,        /* 0x36b2 */
    KANJI,        /* 0x36b3 */
    KANJI,        /* 0x36b4 */
    KANJI,        /* 0x36b5 */
    KANJI,        /* 0x36b6 */
    KANJI,        /* 0x36b7 */
    KANJI,        /* 0x36b8 */
    KANJI,        /* 0x36b9 */
    KANJI,        /* 0x36ba */
    KANJI,        /* 0x36bb */
    KANJI,        /* 0x36bc */
    KANJI,        /* 0x36bd */
    KANJI,        /* 0x36be */
    KANJI,        /* 0x36bf */
    KANJI,        /* 0x36c0 */
    KANJI,        /* 0x36c1 */
    KANJI,        /* 0x36c2 */
    KANJI,        /* 0x36c3 */
    KANJI,        /* 0x36c4 */
    KANJI,        /* 0x36c5 */
    KANJI,        /* 0x36c6 */
    KANJI,        /* 0x36c7 */
    KANJI,        /* 0x36c8 */
    KANJI,        /* 0x36c9 */
    KANJI,        /* 0x36ca */
    KANJI,        /* 0x36cb */
    KANJI,        /* 0x36cc */
    KANJI,        /* 0x36cd */
    KANJI,        /* 0x36ce */
    KANJI,        /* 0x36cf */
    KANJI,        /* 0x36d0 */
    KANJI,        /* 0x36d1 */
    KANJI,        /* 0x36d2 */
    KANJI,        /* 0x36d3 */
    KANJI,        /* 0x36d4 */
    KANJI,        /* 0x36d5 */
    KANJI,        /* 0x36d6 */
    KANJI,        /* 0x36d7 */
    KANJI,        /* 0x36d8 */
    KANJI,        /* 0x36d9 */
    KANJI,        /* 0x36da */
    KANJI,        /* 0x36db */
    KANJI,        /* 0x36dc */
    KANJI,        /* 0x36dd */
    KANJI,        /* 0x36de */
    KANJI,        /* 0x36df */
    KANJI,        /* 0x36e0 */
    KANJI,        /* 0x36e1 */
    KANJI,        /* 0x36e2 */
    KANJI,        /* 0x36e3 */
    KANJI,        /* 0x36e4 */
    KANJI,        /* 0x36e5 */
    KANJI,        /* 0x36e6 */
    KANJI,        /* 0x36e7 */
    KANJI,        /* 0x36e8 */
    KANJI,        /* 0x36e9 */
    KANJI,        /* 0x36ea */
    KANJI,        /* 0x36eb */
    KANJI,        /* 0x36ec */
    KANJI,        /* 0x36ed */
    KANJI,        /* 0x36ee */
    KANJI,        /* 0x36ef */
    KANJI,        /* 0x36f0 */
    KANJI,        /* 0x36f1 */
    KANJI,        /* 0x36f2 */
    KANJI,        /* 0x36f3 */
    KANJI,        /* 0x36f4 */
    KANJI,        /* 0x36f5 */
    KANJI,        /* 0x36f6 */
    KANJI,        /* 0x36f7 */
    KANJI,        /* 0x36f8 */
    KANJI,        /* 0x36f9 */
    KANJI,        /* 0x36fa */
    KANJI,        /* 0x36fb */
    KANJI,        /* 0x36fc */
    KANJI,        /* 0x36fd */
    KANJI,        /* 0x36fe */
    KANJI,        /* 0x36ff */
    KANJI,        /* 0x3700 */
    KANJI,        /* 0x3701 */
    KANJI,        /* 0x3702 */
    KANJI,        /* 0x3703 */
    KANJI,        /* 0x3704 */
    KANJI,        /* 0x3705 */
    KANJI,        /* 0x3706 */
    KANJI,        /* 0x3707 */
    KANJI,        /* 0x3708 */
    KANJI,        /* 0x3709 */
    KANJI,        /* 0x370a */
    KANJI,        /* 0x370b */
    KANJI,        /* 0x370c */
    KANJI,        /* 0x370d */
    KANJI,        /* 0x370e */
    KANJI,        /* 0x370f */
    KANJI,        /* 0x3710 */
    KANJI,        /* 0x3711 */
    KANJI,        /* 0x3712 */
    KANJI,        /* 0x3713 */
    KANJI,        /* 0x3714 */
    KANJI,        /* 0x3715 */
    KANJI,        /* 0x3716 */
    KANJI,        /* 0x3717 */
    KANJI,        /* 0x3718 */
    KANJI,        /* 0x3719 */
    KANJI,        /* 0x371a */
    KANJI,        /* 0x371b */
    KANJI,        /* 0x371c */
    KANJI,        /* 0x371d */
    KANJI,        /* 0x371e */
    KANJI,        /* 0x371f */
    KANJI,        /* 0x3720 */
    KANJI,        /* 0x3721 */
    KANJI,        /* 0x3722 */
    KANJI,        /* 0x3723 */
    KANJI,        /* 0x3724 */
    KANJI,        /* 0x3725 */
    KANJI,        /* 0x3726 */
    KANJI,        /* 0x3727 */
    KANJI,        /* 0x3728 */
    KANJI,        /* 0x3729 */
    KANJI,        /* 0x372a */
    KANJI,        /* 0x372b */
    KANJI,        /* 0x372c */
    KANJI,        /* 0x372d */
    KANJI,        /* 0x372e */
    KANJI,        /* 0x372f */
    KANJI,        /* 0x3730 */
    KANJI,        /* 0x3731 */
    KANJI,        /* 0x3732 */
    KANJI,        /* 0x3733 */
    KANJI,        /* 0x3734 */
    KANJI,        /* 0x3735 */
    KANJI,        /* 0x3736 */
    KANJI,        /* 0x3737 */
    KANJI,        /* 0x3738 */
    KANJI,        /* 0x3739 */
    KANJI,        /* 0x373a */
    KANJI,        /* 0x373b */
    KANJI,        /* 0x373c */
    KANJI,        /* 0x373d */
    KANJI,        /* 0x373e */
    KANJI,        /* 0x373f */
    KANJI,        /* 0x3740 */
    KANJI,        /* 0x3741 */
    KANJI,        /* 0x3742 */
    KANJI,        /* 0x3743 */
    KANJI,        /* 0x3744 */
    KANJI,        /* 0x3745 */
    KANJI,        /* 0x3746 */
    KANJI,        /* 0x3747 */
    KANJI,        /* 0x3748 */
    KANJI,        /* 0x3749 */
    KANJI,        /* 0x374a */
    KANJI,        /* 0x374b */
    KANJI,        /* 0x374c */
    KANJI,        /* 0x374d */
    KANJI,        /* 0x374e */
    KANJI,        /* 0x374f */
    KANJI,        /* 0x3750 */
    KANJI,        /* 0x3751 */
    KANJI,        /* 0x3752 */
    KANJI,        /* 0x3753 */
    KANJI,        /* 0x3754 */
    KANJI,        /* 0x3755 */
    KANJI,        /* 0x3756 */
    KANJI,        /* 0x3757 */
    KANJI,        /* 0x3758 */
    KANJI,        /* 0x3759 */
    KANJI,        /* 0x375a */
    KANJI,        /* 0x375b */
    KANJI,        /* 0x375c */
    KANJI,        /* 0x375d */
    KANJI,        /* 0x375e */
    KANJI,        /* 0x375f */
    KANJI,        /* 0x3760 */
    KANJI,        /* 0x3761 */
    KANJI,        /* 0x3762 */
    KANJI,        /* 0x3763 */
    KANJI,        /* 0x3764 */
    KANJI,        /* 0x3765 */
    KANJI,        /* 0x3766 */
    KANJI,        /* 0x3767 */
    KANJI,        /* 0x3768 */
    KANJI,        /* 0x3769 */
    KANJI,        /* 0x376a */
    KANJI,        /* 0x376b */
    KANJI,        /* 0x376c */
    KANJI,        /* 0x376d */
    KANJI,        /* 0x376e */
    KANJI,        /* 0x376f */
    KANJI,        /* 0x3770 */
    KANJI,        /* 0x3771 */
    KANJI,        /* 0x3772 */
    KANJI,        /* 0x3773 */
    KANJI,        /* 0x3774 */
    KANJI,        /* 0x3775 */
    KANJI,        /* 0x3776 */
    KANJI,        /* 0x3777 */
    KANJI,        /* 0x3778 */
    KANJI,        /* 0x3779 */
    KANJI,        /* 0x377a */
    KANJI,        /* 0x377b */
    KANJI,        /* 0x377c */
    KANJI,        /* 0x377d */
    KANJI,        /* 0x377e */
    KANJI,        /* 0x377f */
    KANJI,        /* 0x3780 */
    KANJI,        /* 0x3781 */
    KANJI,        /* 0x3782 */
    KANJI,        /* 0x3783 */
    KANJI,        /* 0x3784 */
    KANJI,        /* 0x3785 */
    KANJI,        /* 0x3786 */
    KANJI,        /* 0x3787 */
    KANJI,        /* 0x3788 */
    KANJI,        /* 0x3789 */
    KANJI,        /* 0x378a */
    KANJI,        /* 0x378b */
    KANJI,        /* 0x378c */
    KANJI,        /* 0x378d */
    KANJI,        /* 0x378e */
    KANJI,        /* 0x378f */
    KANJI,        /* 0x3790 */
    KANJI,        /* 0x3791 */
    KANJI,        /* 0x3792 */
    KANJI,        /* 0x3793 */
    KANJI,        /* 0x3794 */
    KANJI,        /* 0x3795 */
    KANJI,        /* 0x3796 */
    KANJI,        /* 0x3797 */
    KANJI,        /* 0x3798 */
    KANJI,        /* 0x3799 */
    KANJI,        /* 0x379a */
    KANJI,        /* 0x379b */
    KANJI,        /* 0x379c */
    KANJI,        /* 0x379d */
    KANJI,        /* 0x379e */
    KANJI,        /* 0x379f */
    KANJI,        /* 0x37a0 */
    KANJI,        /* 0x37a1 */
    KANJI,        /* 0x37a2 */
    KANJI,        /* 0x37a3 */
    KANJI,        /* 0x37a4 */
    KANJI,        /* 0x37a5 */
    KANJI,        /* 0x37a6 */
    KANJI,        /* 0x37a7 */
    KANJI,        /* 0x37a8 */
    KANJI,        /* 0x37a9 */
    KANJI,        /* 0x37aa */
    KANJI,        /* 0x37ab */
    KANJI,        /* 0x37ac */
    KANJI,        /* 0x37ad */
    KANJI,        /* 0x37ae */
    KANJI,        /* 0x37af */
    KANJI,        /* 0x37b0 */
    KANJI,        /* 0x37b1 */
    KANJI,        /* 0x37b2 */
    KANJI,        /* 0x37b3 */
    KANJI,        /* 0x37b4 */
    KANJI,        /* 0x37b5 */
    KANJI,        /* 0x37b6 */
    KANJI,        /* 0x37b7 */
    KANJI,        /* 0x37b8 */
    KANJI,        /* 0x37b9 */
    KANJI,        /* 0x37ba */
    KANJI,        /* 0x37bb */
    KANJI,        /* 0x37bc */
    KANJI,        /* 0x37bd */
    KANJI,        /* 0x37be */
    KANJI,        /* 0x37bf */
    KANJI,        /* 0x37c0 */
    KANJI,        /* 0x37c1 */
    KANJI,        /* 0x37c2 */
    KANJI,        /* 0x37c3 */
    KANJI,        /* 0x37c4 */
    KANJI,        /* 0x37c5 */
    KANJI,        /* 0x37c6 */
    KANJI,        /* 0x37c7 */
    KANJI,        /* 0x37c8 */
    KANJI,        /* 0x37c9 */
    KANJI,        /* 0x37ca */
    KANJI,        /* 0x37cb */
    KANJI,        /* 0x37cc */
    KANJI,        /* 0x37cd */
    KANJI,        /* 0x37ce */
    KANJI,        /* 0x37cf */
    KANJI,        /* 0x37d0 */
    KANJI,        /* 0x37d1 */
    KANJI,        /* 0x37d2 */
    KANJI,        /* 0x37d3 */
    KANJI,        /* 0x37d4 */
    KANJI,        /* 0x37d5 */
    KANJI,        /* 0x37d6 */
    KANJI,        /* 0x37d7 */
    KANJI,        /* 0x37d8 */
    KANJI,        /* 0x37d9 */
    KANJI,        /* 0x37da */
    KANJI,        /* 0x37db */
    KANJI,        /* 0x37dc */
    KANJI,        /* 0x37dd */
    KANJI,        /* 0x37de */
    KANJI,        /* 0x37df */
    KANJI,        /* 0x37e0 */
    KANJI,        /* 0x37e1 */
    KANJI,        /* 0x37e2 */
    KANJI,        /* 0x37e3 */
    KANJI,        /* 0x37e4 */
    KANJI,        /* 0x37e5 */
    KANJI,        /* 0x37e6 */
    KANJI,        /* 0x37e7 */
    KANJI,        /* 0x37e8 */
    KANJI,        /* 0x37e9 */
    KANJI,        /* 0x37ea */
    KANJI,        /* 0x37eb */
    KANJI,        /* 0x37ec */
    KANJI,        /* 0x37ed */
    KANJI,        /* 0x37ee */
    KANJI,        /* 0x37ef */
    KANJI,        /* 0x37f0 */
    KANJI,        /* 0x37f1 */
    KANJI,        /* 0x37f2 */
    KANJI,        /* 0x37f3 */
    KANJI,        /* 0x37f4 */
    KANJI,        /* 0x37f5 */
    KANJI,        /* 0x37f6 */
    KANJI,        /* 0x37f7 */
    KANJI,        /* 0x37f8 */
    KANJI,        /* 0x37f9 */
    KANJI,        /* 0x37fa */
    KANJI,        /* 0x37fb */
    KANJI,        /* 0x37fc */
    KANJI,        /* 0x37fd */
    KANJI,        /* 0x37fe */
    KANJI,        /* 0x37ff */
    KANJI,        /* 0x3800 */
    KANJI,        /* 0x3801 */
    KANJI,        /* 0x3802 */
    KANJI,        /* 0x3803 */
    KANJI,        /* 0x3804 */
    KANJI,        /* 0x3805 */
    KANJI,        /* 0x3806 */
    KANJI,        /* 0x3807 */
    KANJI,        /* 0x3808 */
    KANJI,        /* 0x3809 */
    KANJI,        /* 0x380a */
    KANJI,        /* 0x380b */
    KANJI,        /* 0x380c */
    KANJI,        /* 0x380d */
    KANJI,        /* 0x380e */
    KANJI,        /* 0x380f */
    KANJI,        /* 0x3810 */
    KANJI,        /* 0x3811 */
    KANJI,        /* 0x3812 */
    KANJI,        /* 0x3813 */
    KANJI,        /* 0x3814 */
    KANJI,        /* 0x3815 */
    KANJI,        /* 0x3816 */
    KANJI,        /* 0x3817 */
    KANJI,        /* 0x3818 */
    KANJI,        /* 0x3819 */
    KANJI,        /* 0x381a */
    KANJI,        /* 0x381b */
    KANJI,        /* 0x381c */
    KANJI,        /* 0x381d */
    KANJI,        /* 0x381e */
    KANJI,        /* 0x381f */
    KANJI,        /* 0x3820 */
    KANJI,        /* 0x3821 */
    KANJI,        /* 0x3822 */
    KANJI,        /* 0x3823 */
    KANJI,        /* 0x3824 */
    KANJI,        /* 0x3825 */
    KANJI,        /* 0x3826 */
    KANJI,        /* 0x3827 */
    KANJI,        /* 0x3828 */
    KANJI,        /* 0x3829 */
    KANJI,        /* 0x382a */
    KANJI,        /* 0x382b */
    KANJI,        /* 0x382c */
    KANJI,        /* 0x382d */
    KANJI,        /* 0x382e */
    KANJI,        /* 0x382f */
    KANJI,        /* 0x3830 */
    KANJI,        /* 0x3831 */
    KANJI,        /* 0x3832 */
    KANJI,        /* 0x3833 */
    KANJI,        /* 0x3834 */
    KANJI,        /* 0x3835 */
    KANJI,        /* 0x3836 */
    KANJI,        /* 0x3837 */
    KANJI,        /* 0x3838 */
    KANJI,        /* 0x3839 */
    KANJI,        /* 0x383a */
    KANJI,        /* 0x383b */
    KANJI,        /* 0x383c */
    KANJI,        /* 0x383d */
    KANJI,        /* 0x383e */
    KANJI,        /* 0x383f */
    KANJI,        /* 0x3840 */
    KANJI,        /* 0x3841 */
    KANJI,        /* 0x3842 */
    KANJI,        /* 0x3843 */
    KANJI,        /* 0x3844 */
    KANJI,        /* 0x3845 */
    KANJI,        /* 0x3846 */
    KANJI,        /* 0x3847 */
    KANJI,        /* 0x3848 */
    KANJI,        /* 0x3849 */
    KANJI,        /* 0x384a */
    KANJI,        /* 0x384b */
    KANJI,        /* 0x384c */
    KANJI,        /* 0x384d */
    KANJI,        /* 0x384e */
    KANJI,        /* 0x384f */
    KANJI,        /* 0x3850 */
    KANJI,        /* 0x3851 */
    KANJI,        /* 0x3852 */
    KANJI,        /* 0x3853 */
    KANJI,        /* 0x3854 */
    KANJI,        /* 0x3855 */
    KANJI,        /* 0x3856 */
    KANJI,        /* 0x3857 */
    KANJI,        /* 0x3858 */
    KANJI,        /* 0x3859 */
    KANJI,        /* 0x385a */
    KANJI,        /* 0x385b */
    KANJI,        /* 0x385c */
    KANJI,        /* 0x385d */
    KANJI,        /* 0x385e */
    KANJI,        /* 0x385f */
    KANJI,        /* 0x3860 */
    KANJI,        /* 0x3861 */
    KANJI,        /* 0x3862 */
    KANJI,        /* 0x3863 */
    KANJI,        /* 0x3864 */
    KANJI,        /* 0x3865 */
    KANJI,        /* 0x3866 */
    KANJI,        /* 0x3867 */
    KANJI,        /* 0x3868 */
    KANJI,        /* 0x3869 */
    KANJI,        /* 0x386a */
    KANJI,        /* 0x386b */
    KANJI,        /* 0x386c */
    KANJI,        /* 0x386d */
    KANJI,        /* 0x386e */
    KANJI,        /* 0x386f */
    KANJI,        /* 0x3870 */
    KANJI,        /* 0x3871 */
    KANJI,        /* 0x3872 */
    KANJI,        /* 0x3873 */
    KANJI,        /* 0x3874 */
    KANJI,        /* 0x3875 */
    KANJI,        /* 0x3876 */
    KANJI,        /* 0x3877 */
    KANJI,        /* 0x3878 */
    KANJI,        /* 0x3879 */
    KANJI,        /* 0x387a */
    KANJI,        /* 0x387b */
    KANJI,        /* 0x387c */
    KANJI,        /* 0x387d */
    KANJI,        /* 0x387e */
    KANJI,        /* 0x387f */
    KANJI,        /* 0x3880 */
    KANJI,        /* 0x3881 */
    KANJI,        /* 0x3882 */
    KANJI,        /* 0x3883 */
    KANJI,        /* 0x3884 */
    KANJI,        /* 0x3885 */
    KANJI,        /* 0x3886 */
    KANJI,        /* 0x3887 */
    KANJI,        /* 0x3888 */
    KANJI,        /* 0x3889 */
    KANJI,        /* 0x388a */
    KANJI,        /* 0x388b */
    KANJI,        /* 0x388c */
    KANJI,        /* 0x388d */
    KANJI,        /* 0x388e */
    KANJI,        /* 0x388f */
    KANJI,        /* 0x3890 */
    KANJI,        /* 0x3891 */
    KANJI,        /* 0x3892 */
    KANJI,        /* 0x3893 */
    KANJI,        /* 0x3894 */
    KANJI,        /* 0x3895 */
    KANJI,        /* 0x3896 */
    KANJI,        /* 0x3897 */
    KANJI,        /* 0x3898 */
    KANJI,        /* 0x3899 */
    KANJI,        /* 0x389a */
    KANJI,        /* 0x389b */
    KANJI,        /* 0x389c */
    KANJI,        /* 0x389d */
    KANJI,        /* 0x389e */
    KANJI,        /* 0x389f */
    KANJI,        /* 0x38a0 */
    KANJI,        /* 0x38a1 */
    KANJI,        /* 0x38a2 */
    KANJI,        /* 0x38a3 */
    KANJI,        /* 0x38a4 */
    KANJI,        /* 0x38a5 */
    KANJI,        /* 0x38a6 */
    KANJI,        /* 0x38a7 */
    KANJI,        /* 0x38a8 */
    KANJI,        /* 0x38a9 */
    KANJI,        /* 0x38aa */
    KANJI,        /* 0x38ab */
    KANJI,        /* 0x38ac */
    KANJI,        /* 0x38ad */
    KANJI,        /* 0x38ae */
    KANJI,        /* 0x38af */
    KANJI,        /* 0x38b0 */
    KANJI,        /* 0x38b1 */
    KANJI,        /* 0x38b2 */
    KANJI,        /* 0x38b3 */
    KANJI,        /* 0x38b4 */
    KANJI,        /* 0x38b5 */
    KANJI,        /* 0x38b6 */
    KANJI,        /* 0x38b7 */
    KANJI,        /* 0x38b8 */
    KANJI,        /* 0x38b9 */
    KANJI,        /* 0x38ba */
    KANJI,        /* 0x38bb */
    KANJI,        /* 0x38bc */
    KANJI,        /* 0x38bd */
    KANJI,        /* 0x38be */
    KANJI,        /* 0x38bf */
    KANJI,        /* 0x38c0 */
    KANJI,        /* 0x38c1 */
    KANJI,        /* 0x38c2 */
    KANJI,        /* 0x38c3 */
    KANJI,        /* 0x38c4 */
    KANJI,        /* 0x38c5 */
    KANJI,        /* 0x38c6 */
    KANJI,        /* 0x38c7 */
    KANJI,        /* 0x38c8 */
    KANJI,        /* 0x38c9 */
    KANJI,        /* 0x38ca */
    KANJI,        /* 0x38cb */
    KANJI,        /* 0x38cc */
    KANJI,        /* 0x38cd */
    KANJI,        /* 0x38ce */
    KANJI,        /* 0x38cf */
    KANJI,        /* 0x38d0 */
    KANJI,        /* 0x38d1 */
    KANJI,        /* 0x38d2 */
    KANJI,        /* 0x38d3 */
    KANJI,        /* 0x38d4 */
    KANJI,        /* 0x38d5 */
    KANJI,        /* 0x38d6 */
    KANJI,        /* 0x38d7 */
    KANJI,        /* 0x38d8 */
    KANJI,        /* 0x38d9 */
    KANJI,        /* 0x38da */
    KANJI,        /* 0x38db */
    KANJI,        /* 0x38dc */
    KANJI,        /* 0x38dd */
    KANJI,        /* 0x38de */
    KANJI,        /* 0x38df */
    KANJI,        /* 0x38e0 */
    KANJI,        /* 0x38e1 */
    KANJI,        /* 0x38e2 */
    KANJI,        /* 0x38e3 */
    KANJI,        /* 0x38e4 */
    KANJI,        /* 0x38e5 */
    KANJI,        /* 0x38e6 */
    KANJI,        /* 0x38e7 */
    KANJI,        /* 0x38e8 */
    KANJI,        /* 0x38e9 */
    KANJI,        /* 0x38ea */
    KANJI,        /* 0x38eb */
    KANJI,        /* 0x38ec */
    KANJI,        /* 0x38ed */
    KANJI,        /* 0x38ee */
    KANJI,        /* 0x38ef */
    KANJI,        /* 0x38f0 */
    KANJI,        /* 0x38f1 */
    KANJI,        /* 0x38f2 */
    KANJI,        /* 0x38f3 */
    KANJI,        /* 0x38f4 */
    KANJI,        /* 0x38f5 */
    KANJI,        /* 0x38f6 */
    KANJI,        /* 0x38f7 */
    KANJI,        /* 0x38f8 */
    KANJI,        /* 0x38f9 */
    KANJI,        /* 0x38fa */
    KANJI,        /* 0x38fb */
    KANJI,        /* 0x38fc */
    KANJI,        /* 0x38fd */
    KANJI,        /* 0x38fe */
    KANJI,        /* 0x38ff */
    KANJI,        /* 0x3900 */
    KANJI,        /* 0x3901 */
    KANJI,        /* 0x3902 */
    KANJI,        /* 0x3903 */
    KANJI,        /* 0x3904 */
    KANJI,        /* 0x3905 */
    KANJI,        /* 0x3906 */
    KANJI,        /* 0x3907 */
    KANJI,        /* 0x3908 */
    KANJI,        /* 0x3909 */
    KANJI,        /* 0x390a */
    KANJI,        /* 0x390b */
    KANJI,        /* 0x390c */
    KANJI,        /* 0x390d */
    KANJI,        /* 0x390e */
    KANJI,        /* 0x390f */
    KANJI,        /* 0x3910 */
    KANJI,        /* 0x3911 */
    KANJI,        /* 0x3912 */
    KANJI,        /* 0x3913 */
    KANJI,        /* 0x3914 */
    KANJI,        /* 0x3915 */
    KANJI,        /* 0x3916 */
    KANJI,        /* 0x3917 */
    KANJI,        /* 0x3918 */
    KANJI,        /* 0x3919 */
    KANJI,        /* 0x391a */
    KANJI,        /* 0x391b */
    KANJI,        /* 0x391c */
    KANJI,        /* 0x391d */
    KANJI,        /* 0x391e */
    KANJI,        /* 0x391f */
    KANJI,        /* 0x3920 */
    KANJI,        /* 0x3921 */
    KANJI,        /* 0x3922 */
    KANJI,        /* 0x3923 */
    KANJI,        /* 0x3924 */
    KANJI,        /* 0x3925 */
    KANJI,        /* 0x3926 */
    KANJI,        /* 0x3927 */
    KANJI,        /* 0x3928 */
    KANJI,        /* 0x3929 */
    KANJI,        /* 0x392a */
    KANJI,        /* 0x392b */
    KANJI,        /* 0x392c */
    KANJI,        /* 0x392d */
    KANJI,        /* 0x392e */
    KANJI,        /* 0x392f */
    KANJI,        /* 0x3930 */
    KANJI,        /* 0x3931 */
    KANJI,        /* 0x3932 */
    KANJI,        /* 0x3933 */
    KANJI,        /* 0x3934 */
    KANJI,        /* 0x3935 */
    KANJI,        /* 0x3936 */
    KANJI,        /* 0x3937 */
    KANJI,        /* 0x3938 */
    KANJI,        /* 0x3939 */
    KANJI,        /* 0x393a */
    KANJI,        /* 0x393b */
    KANJI,        /* 0x393c */
    KANJI,        /* 0x393d */
    KANJI,        /* 0x393e */
    KANJI,        /* 0x393f */
    KANJI,        /* 0x3940 */
    KANJI,        /* 0x3941 */
    KANJI,        /* 0x3942 */
    KANJI,        /* 0x3943 */
    KANJI,        /* 0x3944 */
    KANJI,        /* 0x3945 */
    KANJI,        /* 0x3946 */
    KANJI,        /* 0x3947 */
    KANJI,        /* 0x3948 */
    KANJI,        /* 0x3949 */
    KANJI,        /* 0x394a */
    KANJI,        /* 0x394b */
    KANJI,        /* 0x394c */
    KANJI,        /* 0x394d */
    KANJI,        /* 0x394e */
    KANJI,        /* 0x394f */
    KANJI,        /* 0x3950 */
    KANJI,        /* 0x3951 */
    KANJI,        /* 0x3952 */
    KANJI,        /* 0x3953 */
    KANJI,        /* 0x3954 */
    KANJI,        /* 0x3955 */
    KANJI,        /* 0x3956 */
    KANJI,        /* 0x3957 */
    KANJI,        /* 0x3958 */
    KANJI,        /* 0x3959 */
    KANJI,        /* 0x395a */
    KANJI,        /* 0x395b */
    KANJI,        /* 0x395c */
    KANJI,        /* 0x395d */
    KANJI,        /* 0x395e */
    KANJI,        /* 0x395f */
    KANJI,        /* 0x3960 */
    KANJI,        /* 0x3961 */
    KANJI,        /* 0x3962 */
    KANJI,        /* 0x3963 */
    KANJI,        /* 0x3964 */
    KANJI,        /* 0x3965 */
    KANJI,        /* 0x3966 */
    KANJI,        /* 0x3967 */
    KANJI,        /* 0x3968 */
    KANJI,        /* 0x3969 */
    KANJI,        /* 0x396a */
    KANJI,        /* 0x396b */
    KANJI,        /* 0x396c */
    KANJI,        /* 0x396d */
    KANJI,        /* 0x396e */
    KANJI,        /* 0x396f */
    KANJI,        /* 0x3970 */
    KANJI,        /* 0x3971 */
    KANJI,        /* 0x3972 */
    KANJI,        /* 0x3973 */
    KANJI,        /* 0x3974 */
    KANJI,        /* 0x3975 */
    KANJI,        /* 0x3976 */
    KANJI,        /* 0x3977 */
    KANJI,        /* 0x3978 */
    KANJI,        /* 0x3979 */
    KANJI,        /* 0x397a */
    KANJI,        /* 0x397b */
    KANJI,        /* 0x397c */
    KANJI,        /* 0x397d */
    KANJI,        /* 0x397e */
    KANJI,        /* 0x397f */
    KANJI,        /* 0x3980 */
    KANJI,        /* 0x3981 */
    KANJI,        /* 0x3982 */
    KANJI,        /* 0x3983 */
    KANJI,        /* 0x3984 */
    KANJI,        /* 0x3985 */
    KANJI,        /* 0x3986 */
    KANJI,        /* 0x3987 */
    KANJI,        /* 0x3988 */
    KANJI,        /* 0x3989 */
    KANJI,        /* 0x398a */
    KANJI,        /* 0x398b */
    KANJI,        /* 0x398c */
    KANJI,        /* 0x398d */
    KANJI,        /* 0x398e */
    KANJI,        /* 0x398f */
    KANJI,        /* 0x3990 */
    KANJI,        /* 0x3991 */
    KANJI,        /* 0x3992 */
    KANJI,        /* 0x3993 */
    KANJI,        /* 0x3994 */
    KANJI,        /* 0x3995 */
    KANJI,        /* 0x3996 */
    KANJI,        /* 0x3997 */
    KANJI,        /* 0x3998 */
    KANJI,        /* 0x3999 */
    KANJI,        /* 0x399a */
    KANJI,        /* 0x399b */
    KANJI,        /* 0x399c */
    KANJI,        /* 0x399d */
    KANJI,        /* 0x399e */
    KANJI,        /* 0x399f */
    KANJI,        /* 0x39a0 */
    KANJI,        /* 0x39a1 */
    KANJI,        /* 0x39a2 */
    KANJI,        /* 0x39a3 */
    KANJI,        /* 0x39a4 */
    KANJI,        /* 0x39a5 */
    KANJI,        /* 0x39a6 */
    KANJI,        /* 0x39a7 */
    KANJI,        /* 0x39a8 */
    KANJI,        /* 0x39a9 */
    KANJI,        /* 0x39aa */
    KANJI,        /* 0x39ab */
    KANJI,        /* 0x39ac */
    KANJI,        /* 0x39ad */
    KANJI,        /* 0x39ae */
    KANJI,        /* 0x39af */
    KANJI,        /* 0x39b0 */
    KANJI,        /* 0x39b1 */
    KANJI,        /* 0x39b2 */
    KANJI,        /* 0x39b3 */
    KANJI,        /* 0x39b4 */
    KANJI,        /* 0x39b5 */
    KANJI,        /* 0x39b6 */
    KANJI,        /* 0x39b7 */
    KANJI,        /* 0x39b8 */
    KANJI,        /* 0x39b9 */
    KANJI,        /* 0x39ba */
    KANJI,        /* 0x39bb */
    KANJI,        /* 0x39bc */
    KANJI,        /* 0x39bd */
    KANJI,        /* 0x39be */
    KANJI,        /* 0x39bf */
    KANJI,        /* 0x39c0 */
    KANJI,        /* 0x39c1 */
    KANJI,        /* 0x39c2 */
    KANJI,        /* 0x39c3 */
    KANJI,        /* 0x39c4 */
    KANJI,        /* 0x39c5 */
    KANJI,        /* 0x39c6 */
    KANJI,        /* 0x39c7 */
    KANJI,        /* 0x39c8 */
    KANJI,        /* 0x39c9 */
    KANJI,        /* 0x39ca */
    KANJI,        /* 0x39cb */
    KANJI,        /* 0x39cc */
    KANJI,        /* 0x39cd */
    KANJI,        /* 0x39ce */
    KANJI,        /* 0x39cf */
    KANJI,        /* 0x39d0 */
    KANJI,        /* 0x39d1 */
    KANJI,        /* 0x39d2 */
    KANJI,        /* 0x39d3 */
    KANJI,        /* 0x39d4 */
    KANJI,        /* 0x39d5 */
    KANJI,        /* 0x39d6 */
    KANJI,        /* 0x39d7 */
    KANJI,        /* 0x39d8 */
    KANJI,        /* 0x39d9 */
    KANJI,        /* 0x39da */
    KANJI,        /* 0x39db */
    KANJI,        /* 0x39dc */
    KANJI,        /* 0x39dd */
    KANJI,        /* 0x39de */
    KANJI,        /* 0x39df */
    KANJI,        /* 0x39e0 */
    KANJI,        /* 0x39e1 */
    KANJI,        /* 0x39e2 */
    KANJI,        /* 0x39e3 */
    KANJI,        /* 0x39e4 */
    KANJI,        /* 0x39e5 */
    KANJI,        /* 0x39e6 */
    KANJI,        /* 0x39e7 */
    KANJI,        /* 0x39e8 */
    KANJI,        /* 0x39e9 */
    KANJI,        /* 0x39ea */
    KANJI,        /* 0x39eb */
    KANJI,        /* 0x39ec */
    KANJI,        /* 0x39ed */
    KANJI,        /* 0x39ee */
    KANJI,        /* 0x39ef */
    KANJI,        /* 0x39f0 */
    KANJI,        /* 0x39f1 */
    KANJI,        /* 0x39f2 */
    KANJI,        /* 0x39f3 */
    KANJI,        /* 0x39f4 */
    KANJI,        /* 0x39f5 */
    KANJI,        /* 0x39f6 */
    KANJI,        /* 0x39f7 */
    KANJI,        /* 0x39f8 */
    KANJI,        /* 0x39f9 */
    KANJI,        /* 0x39fa */
    KANJI,        /* 0x39fb */
    KANJI,        /* 0x39fc */
    KANJI,        /* 0x39fd */
    KANJI,        /* 0x39fe */
    KANJI,        /* 0x39ff */
    KANJI,        /* 0x3a00 */
    KANJI,        /* 0x3a01 */
    KANJI,        /* 0x3a02 */
    KANJI,        /* 0x3a03 */
    KANJI,        /* 0x3a04 */
    KANJI,        /* 0x3a05 */
    KANJI,        /* 0x3a06 */
    KANJI,        /* 0x3a07 */
    KANJI,        /* 0x3a08 */
    KANJI,        /* 0x3a09 */
    KANJI,        /* 0x3a0a */
    KANJI,        /* 0x3a0b */
    KANJI,        /* 0x3a0c */
    KANJI,        /* 0x3a0d */
    KANJI,        /* 0x3a0e */
    KANJI,        /* 0x3a0f */
    KANJI,        /* 0x3a10 */
    KANJI,        /* 0x3a11 */
    KANJI,        /* 0x3a12 */
    KANJI,        /* 0x3a13 */
    KANJI,        /* 0x3a14 */
    KANJI,        /* 0x3a15 */
    KANJI,        /* 0x3a16 */
    KANJI,        /* 0x3a17 */
    KANJI,        /* 0x3a18 */
    KANJI,        /* 0x3a19 */
    KANJI,        /* 0x3a1a */
    KANJI,        /* 0x3a1b */
    KANJI,        /* 0x3a1c */
    KANJI,        /* 0x3a1d */
    KANJI,        /* 0x3a1e */
    KANJI,        /* 0x3a1f */
    KANJI,        /* 0x3a20 */
    KANJI,        /* 0x3a21 */
    KANJI,        /* 0x3a22 */
    KANJI,        /* 0x3a23 */
    KANJI,        /* 0x3a24 */
    KANJI,        /* 0x3a25 */
    KANJI,        /* 0x3a26 */
    KANJI,        /* 0x3a27 */
    KANJI,        /* 0x3a28 */
    KANJI,        /* 0x3a29 */
    KANJI,        /* 0x3a2a */
    KANJI,        /* 0x3a2b */
    KANJI,        /* 0x3a2c */
    KANJI,        /* 0x3a2d */
    KANJI,        /* 0x3a2e */
    KANJI,        /* 0x3a2f */
    KANJI,        /* 0x3a30 */
    KANJI,        /* 0x3a31 */
    KANJI,        /* 0x3a32 */
    KANJI,        /* 0x3a33 */
    KANJI,        /* 0x3a34 */
    KANJI,        /* 0x3a35 */
    KANJI,        /* 0x3a36 */
    KANJI,        /* 0x3a37 */
    KANJI,        /* 0x3a38 */
    KANJI,        /* 0x3a39 */
    KANJI,        /* 0x3a3a */
    KANJI,        /* 0x3a3b */
    KANJI,        /* 0x3a3c */
    KANJI,        /* 0x3a3d */
    KANJI,        /* 0x3a3e */
    KANJI,        /* 0x3a3f */
    KANJI,        /* 0x3a40 */
    KANJI,        /* 0x3a41 */
    KANJI,        /* 0x3a42 */
    KANJI,        /* 0x3a43 */
    KANJI,        /* 0x3a44 */
    KANJI,        /* 0x3a45 */
    KANJI,        /* 0x3a46 */
    KANJI,        /* 0x3a47 */
    KANJI,        /* 0x3a48 */
    KANJI,        /* 0x3a49 */
    KANJI,        /* 0x3a4a */
    KANJI,        /* 0x3a4b */
    KANJI,        /* 0x3a4c */
    KANJI,        /* 0x3a4d */
    KANJI,        /* 0x3a4e */
    KANJI,        /* 0x3a4f */
    KANJI,        /* 0x3a50 */
    KANJI,        /* 0x3a51 */
    KANJI,        /* 0x3a52 */
    KANJI,        /* 0x3a53 */
    KANJI,        /* 0x3a54 */
    KANJI,        /* 0x3a55 */
    KANJI,        /* 0x3a56 */
    KANJI,        /* 0x3a57 */
    KANJI,        /* 0x3a58 */
    KANJI,        /* 0x3a59 */
    KANJI,        /* 0x3a5a */
    KANJI,        /* 0x3a5b */
    KANJI,        /* 0x3a5c */
    KANJI,        /* 0x3a5d */
    KANJI,        /* 0x3a5e */
    KANJI,        /* 0x3a5f */
    KANJI,        /* 0x3a60 */
    KANJI,        /* 0x3a61 */
    KANJI,        /* 0x3a62 */
    KANJI,        /* 0x3a63 */
    KANJI,        /* 0x3a64 */
    KANJI,        /* 0x3a65 */
    KANJI,        /* 0x3a66 */
    KANJI,        /* 0x3a67 */
    KANJI,        /* 0x3a68 */
    KANJI,        /* 0x3a69 */
    KANJI,        /* 0x3a6a */
    KANJI,        /* 0x3a6b */
    KANJI,        /* 0x3a6c */
    KANJI,        /* 0x3a6d */
    KANJI,        /* 0x3a6e */
    KANJI,        /* 0x3a6f */
    KANJI,        /* 0x3a70 */
    KANJI,        /* 0x3a71 */
    KANJI,        /* 0x3a72 */
    KANJI,        /* 0x3a73 */
    KANJI,        /* 0x3a74 */
    KANJI,        /* 0x3a75 */
    KANJI,        /* 0x3a76 */
    KANJI,        /* 0x3a77 */
    KANJI,        /* 0x3a78 */
    KANJI,        /* 0x3a79 */
    KANJI,        /* 0x3a7a */
    KANJI,        /* 0x3a7b */
    KANJI,        /* 0x3a7c */
    KANJI,        /* 0x3a7d */
    KANJI,        /* 0x3a7e */
    KANJI,        /* 0x3a7f */
    KANJI,        /* 0x3a80 */
    KANJI,        /* 0x3a81 */
    KANJI,        /* 0x3a82 */
    KANJI,        /* 0x3a83 */
    KANJI,        /* 0x3a84 */
    KANJI,        /* 0x3a85 */
    KANJI,        /* 0x3a86 */
    KANJI,        /* 0x3a87 */
    KANJI,        /* 0x3a88 */
    KANJI,        /* 0x3a89 */
    KANJI,        /* 0x3a8a */
    KANJI,        /* 0x3a8b */
    KANJI,        /* 0x3a8c */
    KANJI,        /* 0x3a8d */
    KANJI,        /* 0x3a8e */
    KANJI,        /* 0x3a8f */
    KANJI,        /* 0x3a90 */
    KANJI,        /* 0x3a91 */
    KANJI,        /* 0x3a92 */
    KANJI,        /* 0x3a93 */
    KANJI,        /* 0x3a94 */
    KANJI,        /* 0x3a95 */
    KANJI,        /* 0x3a96 */
    KANJI,        /* 0x3a97 */
    KANJI,        /* 0x3a98 */
    KANJI,        /* 0x3a99 */
    KANJI,        /* 0x3a9a */
    KANJI,        /* 0x3a9b */
    KANJI,        /* 0x3a9c */
    KANJI,        /* 0x3a9d */
    KANJI,        /* 0x3a9e */
    KANJI,        /* 0x3a9f */
    KANJI,        /* 0x3aa0 */
    KANJI,        /* 0x3aa1 */
    KANJI,        /* 0x3aa2 */
    KANJI,        /* 0x3aa3 */
    KANJI,        /* 0x3aa4 */
    KANJI,        /* 0x3aa5 */
    KANJI,        /* 0x3aa6 */
    KANJI,        /* 0x3aa7 */
    KANJI,        /* 0x3aa8 */
    KANJI,        /* 0x3aa9 */
    KANJI,        /* 0x3aaa */
    KANJI,        /* 0x3aab */
    KANJI,        /* 0x3aac */
    KANJI,        /* 0x3aad */
    KANJI,        /* 0x3aae */
    KANJI,        /* 0x3aaf */
    KANJI,        /* 0x3ab0 */
    KANJI,        /* 0x3ab1 */
    KANJI,        /* 0x3ab2 */
    KANJI,        /* 0x3ab3 */
    KANJI,        /* 0x3ab4 */
    KANJI,        /* 0x3ab5 */
    KANJI,        /* 0x3ab6 */
    KANJI,        /* 0x3ab7 */
    KANJI,        /* 0x3ab8 */
    KANJI,        /* 0x3ab9 */
    KANJI,        /* 0x3aba */
    KANJI,        /* 0x3abb */
    KANJI,        /* 0x3abc */
    KANJI,        /* 0x3abd */
    KANJI,        /* 0x3abe */
    KANJI,        /* 0x3abf */
    KANJI,        /* 0x3ac0 */
    KANJI,        /* 0x3ac1 */
    KANJI,        /* 0x3ac2 */
    KANJI,        /* 0x3ac3 */
    KANJI,        /* 0x3ac4 */
    KANJI,        /* 0x3ac5 */
    KANJI,        /* 0x3ac6 */
    KANJI,        /* 0x3ac7 */
    KANJI,        /* 0x3ac8 */
    KANJI,        /* 0x3ac9 */
    KANJI,        /* 0x3aca */
    KANJI,        /* 0x3acb */
    KANJI,        /* 0x3acc */
    KANJI,        /* 0x3acd */
    KANJI,        /* 0x3ace */
    KANJI,        /* 0x3acf */
    KANJI,        /* 0x3ad0 */
    KANJI,        /* 0x3ad1 */
    KANJI,        /* 0x3ad2 */
    KANJI,        /* 0x3ad3 */
    KANJI,        /* 0x3ad4 */
    KANJI,        /* 0x3ad5 */
    KANJI,        /* 0x3ad6 */
    KANJI,        /* 0x3ad7 */
    KANJI,        /* 0x3ad8 */
    KANJI,        /* 0x3ad9 */
    KANJI,        /* 0x3ada */
    KANJI,        /* 0x3adb */
    KANJI,        /* 0x3adc */
    KANJI,        /* 0x3add */
    KANJI,        /* 0x3ade */
    KANJI,        /* 0x3adf */
    KANJI,        /* 0x3ae0 */
    KANJI,        /* 0x3ae1 */
    KANJI,        /* 0x3ae2 */
    KANJI,        /* 0x3ae3 */
    KANJI,        /* 0x3ae4 */
    KANJI,        /* 0x3ae5 */
    KANJI,        /* 0x3ae6 */
    KANJI,        /* 0x3ae7 */
    KANJI,        /* 0x3ae8 */
    KANJI,        /* 0x3ae9 */
    KANJI,        /* 0x3aea */
    KANJI,        /* 0x3aeb */
    KANJI,        /* 0x3aec */
    KANJI,        /* 0x3aed */
    KANJI,        /* 0x3aee */
    KANJI,        /* 0x3aef */
    KANJI,        /* 0x3af0 */
    KANJI,        /* 0x3af1 */
    KANJI,        /* 0x3af2 */
    KANJI,        /* 0x3af3 */
    KANJI,        /* 0x3af4 */
    KANJI,        /* 0x3af5 */
    KANJI,        /* 0x3af6 */
    KANJI,        /* 0x3af7 */
    KANJI,        /* 0x3af8 */
    KANJI,        /* 0x3af9 */
    KANJI,        /* 0x3afa */
    KANJI,        /* 0x3afb */
    KANJI,        /* 0x3afc */
    KANJI,        /* 0x3afd */
    KANJI,        /* 0x3afe */
    KANJI,        /* 0x3aff */
    KANJI,        /* 0x3b00 */
    KANJI,        /* 0x3b01 */
    KANJI,        /* 0x3b02 */
    KANJI,        /* 0x3b03 */
    KANJI,        /* 0x3b04 */
    KANJI,        /* 0x3b05 */
    KANJI,        /* 0x3b06 */
    KANJI,        /* 0x3b07 */
    KANJI,        /* 0x3b08 */
    KANJI,        /* 0x3b09 */
    KANJI,        /* 0x3b0a */
    KANJI,        /* 0x3b0b */
    KANJI,        /* 0x3b0c */
    KANJI,        /* 0x3b0d */
    KANJI,        /* 0x3b0e */
    KANJI,        /* 0x3b0f */
    KANJI,        /* 0x3b10 */
    KANJI,        /* 0x3b11 */
    KANJI,        /* 0x3b12 */
    KANJI,        /* 0x3b13 */
    KANJI,        /* 0x3b14 */
    KANJI,        /* 0x3b15 */
    KANJI,        /* 0x3b16 */
    KANJI,        /* 0x3b17 */
    KANJI,        /* 0x3b18 */
    KANJI,        /* 0x3b19 */
    KANJI,        /* 0x3b1a */
    KANJI,        /* 0x3b1b */
    KANJI,        /* 0x3b1c */
    KANJI,        /* 0x3b1d */
    KANJI,        /* 0x3b1e */
    KANJI,        /* 0x3b1f */
    KANJI,        /* 0x3b20 */
    KANJI,        /* 0x3b21 */
    KANJI,        /* 0x3b22 */
    KANJI,        /* 0x3b23 */
    KANJI,        /* 0x3b24 */
    KANJI,        /* 0x3b25 */
    KANJI,        /* 0x3b26 */
    KANJI,        /* 0x3b27 */
    KANJI,        /* 0x3b28 */
    KANJI,        /* 0x3b29 */
    KANJI,        /* 0x3b2a */
    KANJI,        /* 0x3b2b */
    KANJI,        /* 0x3b2c */
    KANJI,        /* 0x3b2d */
    KANJI,        /* 0x3b2e */
    KANJI,        /* 0x3b2f */
    KANJI,        /* 0x3b30 */
    KANJI,        /* 0x3b31 */
    KANJI,        /* 0x3b32 */
    KANJI,        /* 0x3b33 */
    KANJI,        /* 0x3b34 */
    KANJI,        /* 0x3b35 */
    KANJI,        /* 0x3b36 */
    KANJI,        /* 0x3b37 */
    KANJI,        /* 0x3b38 */
    KANJI,        /* 0x3b39 */
    KANJI,        /* 0x3b3a */
    KANJI,        /* 0x3b3b */
    KANJI,        /* 0x3b3c */
    KANJI,        /* 0x3b3d */
    KANJI,        /* 0x3b3e */
    KANJI,        /* 0x3b3f */
    KANJI,        /* 0x3b40 */
    KANJI,        /* 0x3b41 */
    KANJI,        /* 0x3b42 */
    KANJI,        /* 0x3b43 */
    KANJI,        /* 0x3b44 */
    KANJI,        /* 0x3b45 */
    KANJI,        /* 0x3b46 */
    KANJI,        /* 0x3b47 */
    KANJI,        /* 0x3b48 */
    KANJI,        /* 0x3b49 */
    KANJI,        /* 0x3b4a */
    KANJI,        /* 0x3b4b */
    KANJI,        /* 0x3b4c */
    KANJI,        /* 0x3b4d */
    KANJI,        /* 0x3b4e */
    KANJI,        /* 0x3b4f */
    KANJI,        /* 0x3b50 */
    KANJI,        /* 0x3b51 */
    KANJI,        /* 0x3b52 */
    KANJI,        /* 0x3b53 */
    KANJI,        /* 0x3b54 */
    KANJI,        /* 0x3b55 */
    KANJI,        /* 0x3b56 */
    KANJI,        /* 0x3b57 */
    KANJI,        /* 0x3b58 */
    KANJI,        /* 0x3b59 */
    KANJI,        /* 0x3b5a */
    KANJI,        /* 0x3b5b */
    KANJI,        /* 0x3b5c */
    KANJI,        /* 0x3b5d */
    KANJI,        /* 0x3b5e */
    KANJI,        /* 0x3b5f */
    KANJI,        /* 0x3b60 */
    KANJI,        /* 0x3b61 */
    KANJI,        /* 0x3b62 */
    KANJI,        /* 0x3b63 */
    KANJI,        /* 0x3b64 */
    KANJI,        /* 0x3b65 */
    KANJI,        /* 0x3b66 */
    KANJI,        /* 0x3b67 */
    KANJI,        /* 0x3b68 */
    KANJI,        /* 0x3b69 */
    KANJI,        /* 0x3b6a */
    KANJI,        /* 0x3b6b */
    KANJI,        /* 0x3b6c */
    KANJI,        /* 0x3b6d */
    KANJI,        /* 0x3b6e */
    KANJI,        /* 0x3b6f */
    KANJI,        /* 0x3b70 */
    KANJI,        /* 0x3b71 */
    KANJI,        /* 0x3b72 */
    KANJI,        /* 0x3b73 */
    KANJI,        /* 0x3b74 */
    KANJI,        /* 0x3b75 */
    KANJI,        /* 0x3b76 */
    KANJI,        /* 0x3b77 */
    KANJI,        /* 0x3b78 */
    KANJI,        /* 0x3b79 */
    KANJI,        /* 0x3b7a */
    KANJI,        /* 0x3b7b */
    KANJI,        /* 0x3b7c */
    KANJI,        /* 0x3b7d */
    KANJI,        /* 0x3b7e */
    KANJI,        /* 0x3b7f */
    KANJI,        /* 0x3b80 */
    KANJI,        /* 0x3b81 */
    KANJI,        /* 0x3b82 */
    KANJI,        /* 0x3b83 */
    KANJI,        /* 0x3b84 */
    KANJI,        /* 0x3b85 */
    KANJI,        /* 0x3b86 */
    KANJI,        /* 0x3b87 */
    KANJI,        /* 0x3b88 */
    KANJI,        /* 0x3b89 */
    KANJI,        /* 0x3b8a */
    KANJI,        /* 0x3b8b */
    KANJI,        /* 0x3b8c */
    KANJI,        /* 0x3b8d */
    KANJI,        /* 0x3b8e */
    KANJI,        /* 0x3b8f */
    KANJI,        /* 0x3b90 */
    KANJI,        /* 0x3b91 */
    KANJI,        /* 0x3b92 */
    KANJI,        /* 0x3b93 */
    KANJI,        /* 0x3b94 */
    KANJI,        /* 0x3b95 */
    KANJI,        /* 0x3b96 */
    KANJI,        /* 0x3b97 */
    KANJI,        /* 0x3b98 */
    KANJI,        /* 0x3b99 */
    KANJI,        /* 0x3b9a */
    KANJI,        /* 0x3b9b */
    KANJI,        /* 0x3b9c */
    KANJI,        /* 0x3b9d */
    KANJI,        /* 0x3b9e */
    KANJI,        /* 0x3b9f */
    KANJI,        /* 0x3ba0 */
    KANJI,        /* 0x3ba1 */
    KANJI,        /* 0x3ba2 */
    KANJI,        /* 0x3ba3 */
    KANJI,        /* 0x3ba4 */
    KANJI,        /* 0x3ba5 */
    KANJI,        /* 0x3ba6 */
    KANJI,        /* 0x3ba7 */
    KANJI,        /* 0x3ba8 */
    KANJI,        /* 0x3ba9 */
    KANJI,        /* 0x3baa */
    KANJI,        /* 0x3bab */
    KANJI,        /* 0x3bac */
    KANJI,        /* 0x3bad */
    KANJI,        /* 0x3bae */
    KANJI,        /* 0x3baf */
    KANJI,        /* 0x3bb0 */
    KANJI,        /* 0x3bb1 */
    KANJI,        /* 0x3bb2 */
    KANJI,        /* 0x3bb3 */
    KANJI,        /* 0x3bb4 */
    KANJI,        /* 0x3bb5 */
    KANJI,        /* 0x3bb6 */
    KANJI,        /* 0x3bb7 */
    KANJI,        /* 0x3bb8 */
    KANJI,        /* 0x3bb9 */
    KANJI,        /* 0x3bba */
    KANJI,        /* 0x3bbb */
    KANJI,        /* 0x3bbc */
    KANJI,        /* 0x3bbd */
    KANJI,        /* 0x3bbe */
    KANJI,        /* 0x3bbf */
    KANJI,        /* 0x3bc0 */
    KANJI,        /* 0x3bc1 */
    KANJI,        /* 0x3bc2 */
    KANJI,        /* 0x3bc3 */
    KANJI,        /* 0x3bc4 */
    KANJI,        /* 0x3bc5 */
    KANJI,        /* 0x3bc6 */
    KANJI,        /* 0x3bc7 */
    KANJI,        /* 0x3bc8 */
    KANJI,        /* 0x3bc9 */
    KANJI,        /* 0x3bca */
    KANJI,        /* 0x3bcb */
    KANJI,        /* 0x3bcc */
    KANJI,        /* 0x3bcd */
    KANJI,        /* 0x3bce */
    KANJI,        /* 0x3bcf */
    KANJI,        /* 0x3bd0 */
    KANJI,        /* 0x3bd1 */
    KANJI,        /* 0x3bd2 */
    KANJI,        /* 0x3bd3 */
    KANJI,        /* 0x3bd4 */
    KANJI,        /* 0x3bd5 */
    KANJI,        /* 0x3bd6 */
    KANJI,        /* 0x3bd7 */
    KANJI,        /* 0x3bd8 */
    KANJI,        /* 0x3bd9 */
    KANJI,        /* 0x3bda */
    KANJI,        /* 0x3bdb */
    KANJI,        /* 0x3bdc */
    KANJI,        /* 0x3bdd */
    KANJI,        /* 0x3bde */
    KANJI,        /* 0x3bdf */
    KANJI,        /* 0x3be0 */
    KANJI,        /* 0x3be1 */
    KANJI,        /* 0x3be2 */
    KANJI,        /* 0x3be3 */
    KANJI,        /* 0x3be4 */
    KANJI,        /* 0x3be5 */
    KANJI,        /* 0x3be6 */
    KANJI,        /* 0x3be7 */
    KANJI,        /* 0x3be8 */
    KANJI,        /* 0x3be9 */
    KANJI,        /* 0x3bea */
    KANJI,        /* 0x3beb */
    KANJI,        /* 0x3bec */
    KANJI,        /* 0x3bed */
    KANJI,        /* 0x3bee */
    KANJI,        /* 0x3bef */
    KANJI,        /* 0x3bf0 */
    KANJI,        /* 0x3bf1 */
    KANJI,        /* 0x3bf2 */
    KANJI,        /* 0x3bf3 */
    KANJI,        /* 0x3bf4 */
    KANJI,        /* 0x3bf5 */
    KANJI,        /* 0x3bf6 */
    KANJI,        /* 0x3bf7 */
    KANJI,        /* 0x3bf8 */
    KANJI,        /* 0x3bf9 */
    KANJI,        /* 0x3bfa */
    KANJI,        /* 0x3bfb */
    KANJI,        /* 0x3bfc */
    KANJI,        /* 0x3bfd */
    KANJI,        /* 0x3bfe */
    KANJI,        /* 0x3bff */
    KANJI,        /* 0x3c00 */
    KANJI,        /* 0x3c01 */
    KANJI,        /* 0x3c02 */
    KANJI,        /* 0x3c03 */
    KANJI,        /* 0x3c04 */
    KANJI,        /* 0x3c05 */
    KANJI,        /* 0x3c06 */
    KANJI,        /* 0x3c07 */
    KANJI,        /* 0x3c08 */
    KANJI,        /* 0x3c09 */
    KANJI,        /* 0x3c0a */
    KANJI,        /* 0x3c0b */
    KANJI,        /* 0x3c0c */
    KANJI,        /* 0x3c0d */
    KANJI,        /* 0x3c0e */
    KANJI,        /* 0x3c0f */
    KANJI,        /* 0x3c10 */
    KANJI,        /* 0x3c11 */
    KANJI,        /* 0x3c12 */
    KANJI,        /* 0x3c13 */
    KANJI,        /* 0x3c14 */
    KANJI,        /* 0x3c15 */
    KANJI,        /* 0x3c16 */
    KANJI,        /* 0x3c17 */
    KANJI,        /* 0x3c18 */
    KANJI,        /* 0x3c19 */
    KANJI,        /* 0x3c1a */
    KANJI,        /* 0x3c1b */
    KANJI,        /* 0x3c1c */
    KANJI,        /* 0x3c1d */
    KANJI,        /* 0x3c1e */
    KANJI,        /* 0x3c1f */
    KANJI,        /* 0x3c20 */
    KANJI,        /* 0x3c21 */
    KANJI,        /* 0x3c22 */
    KANJI,        /* 0x3c23 */
    KANJI,        /* 0x3c24 */
    KANJI,        /* 0x3c25 */
    KANJI,        /* 0x3c26 */
    KANJI,        /* 0x3c27 */
    KANJI,        /* 0x3c28 */
    KANJI,        /* 0x3c29 */
    KANJI,        /* 0x3c2a */
    KANJI,        /* 0x3c2b */
    KANJI,        /* 0x3c2c */
    KANJI,        /* 0x3c2d */
    KANJI,        /* 0x3c2e */
    KANJI,        /* 0x3c2f */
    KANJI,        /* 0x3c30 */
    KANJI,        /* 0x3c31 */
    KANJI,        /* 0x3c32 */
    KANJI,        /* 0x3c33 */
    KANJI,        /* 0x3c34 */
    KANJI,        /* 0x3c35 */
    KANJI,        /* 0x3c36 */
    KANJI,        /* 0x3c37 */
    KANJI,        /* 0x3c38 */
    KANJI,        /* 0x3c39 */
    KANJI,        /* 0x3c3a */
    KANJI,        /* 0x3c3b */
    KANJI,        /* 0x3c3c */
    KANJI,        /* 0x3c3d */
    KANJI,        /* 0x3c3e */
    KANJI,        /* 0x3c3f */
    KANJI,        /* 0x3c40 */
    KANJI,        /* 0x3c41 */
    KANJI,        /* 0x3c42 */
    KANJI,        /* 0x3c43 */
    KANJI,        /* 0x3c44 */
    KANJI,        /* 0x3c45 */
    KANJI,        /* 0x3c46 */
    KANJI,        /* 0x3c47 */
    KANJI,        /* 0x3c48 */
    KANJI,        /* 0x3c49 */
    KANJI,        /* 0x3c4a */
    KANJI,        /* 0x3c4b */
    KANJI,        /* 0x3c4c */
    KANJI,        /* 0x3c4d */
    KANJI,        /* 0x3c4e */
    KANJI,        /* 0x3c4f */
    KANJI,        /* 0x3c50 */
    KANJI,        /* 0x3c51 */
    KANJI,        /* 0x3c52 */
    KANJI,        /* 0x3c53 */
    KANJI,        /* 0x3c54 */
    KANJI,        /* 0x3c55 */
    KANJI,        /* 0x3c56 */
    KANJI,        /* 0x3c57 */
    KANJI,        /* 0x3c58 */
    KANJI,        /* 0x3c59 */
    KANJI,        /* 0x3c5a */
    KANJI,        /* 0x3c5b */
    KANJI,        /* 0x3c5c */
    KANJI,        /* 0x3c5d */
    KANJI,        /* 0x3c5e */
    KANJI,        /* 0x3c5f */
    KANJI,        /* 0x3c60 */
    KANJI,        /* 0x3c61 */
    KANJI,        /* 0x3c62 */
    KANJI,        /* 0x3c63 */
    KANJI,        /* 0x3c64 */
    KANJI,        /* 0x3c65 */
    KANJI,        /* 0x3c66 */
    KANJI,        /* 0x3c67 */
    KANJI,        /* 0x3c68 */
    KANJI,        /* 0x3c69 */
    KANJI,        /* 0x3c6a */
    KANJI,        /* 0x3c6b */
    KANJI,        /* 0x3c6c */
    KANJI,        /* 0x3c6d */
    KANJI,        /* 0x3c6e */
    KANJI,        /* 0x3c6f */
    KANJI,        /* 0x3c70 */
    KANJI,        /* 0x3c71 */
    KANJI,        /* 0x3c72 */
    KANJI,        /* 0x3c73 */
    KANJI,        /* 0x3c74 */
    KANJI,        /* 0x3c75 */
    KANJI,        /* 0x3c76 */
    KANJI,        /* 0x3c77 */
    KANJI,        /* 0x3c78 */
    KANJI,        /* 0x3c79 */
    KANJI,        /* 0x3c7a */
    KANJI,        /* 0x3c7b */
    KANJI,        /* 0x3c7c */
    KANJI,        /* 0x3c7d */
    KANJI,        /* 0x3c7e */
    KANJI,        /* 0x3c7f */
    KANJI,        /* 0x3c80 */
    KANJI,        /* 0x3c81 */
    KANJI,        /* 0x3c82 */
    KANJI,        /* 0x3c83 */
    KANJI,        /* 0x3c84 */
    KANJI,        /* 0x3c85 */
    KANJI,        /* 0x3c86 */
    KANJI,        /* 0x3c87 */
    KANJI,        /* 0x3c88 */
    KANJI,        /* 0x3c89 */
    KANJI,        /* 0x3c8a */
    KANJI,        /* 0x3c8b */
    KANJI,        /* 0x3c8c */
    KANJI,        /* 0x3c8d */
    KANJI,        /* 0x3c8e */
    KANJI,        /* 0x3c8f */
    KANJI,        /* 0x3c90 */
    KANJI,        /* 0x3c91 */
    KANJI,        /* 0x3c92 */
    KANJI,        /* 0x3c93 */
    KANJI,        /* 0x3c94 */
    KANJI,        /* 0x3c95 */
    KANJI,        /* 0x3c96 */
    KANJI,        /* 0x3c97 */
    KANJI,        /* 0x3c98 */
    KANJI,        /* 0x3c99 */
    KANJI,        /* 0x3c9a */
    KANJI,        /* 0x3c9b */
    KANJI,        /* 0x3c9c */
    KANJI,        /* 0x3c9d */
    KANJI,        /* 0x3c9e */
    KANJI,        /* 0x3c9f */
    KANJI,        /* 0x3ca0 */
    KANJI,        /* 0x3ca1 */
    KANJI,        /* 0x3ca2 */
    KANJI,        /* 0x3ca3 */
    KANJI,        /* 0x3ca4 */
    KANJI,        /* 0x3ca5 */
    KANJI,        /* 0x3ca6 */
    KANJI,        /* 0x3ca7 */
    KANJI,        /* 0x3ca8 */
    KANJI,        /* 0x3ca9 */
    KANJI,        /* 0x3caa */
    KANJI,        /* 0x3cab */
    KANJI,        /* 0x3cac */
    KANJI,        /* 0x3cad */
    KANJI,        /* 0x3cae */
    KANJI,        /* 0x3caf */
    KANJI,        /* 0x3cb0 */
    KANJI,        /* 0x3cb1 */
    KANJI,        /* 0x3cb2 */
    KANJI,        /* 0x3cb3 */
    KANJI,        /* 0x3cb4 */
    KANJI,        /* 0x3cb5 */
    KANJI,        /* 0x3cb6 */
    KANJI,        /* 0x3cb7 */
    KANJI,        /* 0x3cb8 */
    KANJI,        /* 0x3cb9 */
    KANJI,        /* 0x3cba */
    KANJI,        /* 0x3cbb */
    KANJI,        /* 0x3cbc */
    KANJI,        /* 0x3cbd */
    KANJI,        /* 0x3cbe */
    KANJI,        /* 0x3cbf */
    KANJI,        /* 0x3cc0 */
    KANJI,        /* 0x3cc1 */
    KANJI,        /* 0x3cc2 */
    KANJI,        /* 0x3cc3 */
    KANJI,        /* 0x3cc4 */
    KANJI,        /* 0x3cc5 */
    KANJI,        /* 0x3cc6 */
    KANJI,        /* 0x3cc7 */
    KANJI,        /* 0x3cc8 */
    KANJI,        /* 0x3cc9 */
    KANJI,        /* 0x3cca */
    KANJI,        /* 0x3ccb */
    KANJI,        /* 0x3ccc */
    KANJI,        /* 0x3ccd */
    KANJI,        /* 0x3cce */
    KANJI,        /* 0x3ccf */
    KANJI,        /* 0x3cd0 */
    KANJI,        /* 0x3cd1 */
    KANJI,        /* 0x3cd2 */
    KANJI,        /* 0x3cd3 */
    KANJI,        /* 0x3cd4 */
    KANJI,        /* 0x3cd5 */
    KANJI,        /* 0x3cd6 */
    KANJI,        /* 0x3cd7 */
    KANJI,        /* 0x3cd8 */
    KANJI,        /* 0x3cd9 */
    KANJI,        /* 0x3cda */
    KANJI,        /* 0x3cdb */
    KANJI,        /* 0x3cdc */
    KANJI,        /* 0x3cdd */
    KANJI,        /* 0x3cde */
    KANJI,        /* 0x3cdf */
    KANJI,        /* 0x3ce0 */
    KANJI,        /* 0x3ce1 */
    KANJI,        /* 0x3ce2 */
    KANJI,        /* 0x3ce3 */
    KANJI,        /* 0x3ce4 */
    KANJI,        /* 0x3ce5 */
    KANJI,        /* 0x3ce6 */
    KANJI,        /* 0x3ce7 */
    KANJI,        /* 0x3ce8 */
    KANJI,        /* 0x3ce9 */
    KANJI,        /* 0x3cea */
    KANJI,        /* 0x3ceb */
    KANJI,        /* 0x3cec */
    KANJI,        /* 0x3ced */
    KANJI,        /* 0x3cee */
    KANJI,        /* 0x3cef */
    KANJI,        /* 0x3cf0 */
    KANJI,        /* 0x3cf1 */
    KANJI,        /* 0x3cf2 */
    KANJI,        /* 0x3cf3 */
    KANJI,        /* 0x3cf4 */
    KANJI,        /* 0x3cf5 */
    KANJI,        /* 0x3cf6 */
    KANJI,        /* 0x3cf7 */
    KANJI,        /* 0x3cf8 */
    KANJI,        /* 0x3cf9 */
    KANJI,        /* 0x3cfa */
    KANJI,        /* 0x3cfb */
    KANJI,        /* 0x3cfc */
    KANJI,        /* 0x3cfd */
    KANJI,        /* 0x3cfe */
    KANJI,        /* 0x3cff */
    KANJI,        /* 0x3d00 */
    KANJI,        /* 0x3d01 */
    KANJI,        /* 0x3d02 */
    KANJI,        /* 0x3d03 */
    KANJI,        /* 0x3d04 */
    KANJI,        /* 0x3d05 */
    KANJI,        /* 0x3d06 */
    KANJI,        /* 0x3d07 */
    KANJI,        /* 0x3d08 */
    KANJI,        /* 0x3d09 */
    KANJI,        /* 0x3d0a */
    KANJI,        /* 0x3d0b */
    KANJI,        /* 0x3d0c */
    KANJI,        /* 0x3d0d */
    KANJI,        /* 0x3d0e */
    KANJI,        /* 0x3d0f */
    KANJI,        /* 0x3d10 */
    KANJI,        /* 0x3d11 */
    KANJI,        /* 0x3d12 */
    KANJI,        /* 0x3d13 */
    KANJI,        /* 0x3d14 */
    KANJI,        /* 0x3d15 */
    KANJI,        /* 0x3d16 */
    KANJI,        /* 0x3d17 */
    KANJI,        /* 0x3d18 */
    KANJI,        /* 0x3d19 */
    KANJI,        /* 0x3d1a */
    KANJI,        /* 0x3d1b */
    KANJI,        /* 0x3d1c */
    KANJI,        /* 0x3d1d */
    KANJI,        /* 0x3d1e */
    KANJI,        /* 0x3d1f */
    KANJI,        /* 0x3d20 */
    KANJI,        /* 0x3d21 */
    KANJI,        /* 0x3d22 */
    KANJI,        /* 0x3d23 */
    KANJI,        /* 0x3d24 */
    KANJI,        /* 0x3d25 */
    KANJI,        /* 0x3d26 */
    KANJI,        /* 0x3d27 */
    KANJI,        /* 0x3d28 */
    KANJI,        /* 0x3d29 */
    KANJI,        /* 0x3d2a */
    KANJI,        /* 0x3d2b */
    KANJI,        /* 0x3d2c */
    KANJI,        /* 0x3d2d */
    KANJI,        /* 0x3d2e */
    KANJI,        /* 0x3d2f */
    KANJI,        /* 0x3d30 */
    KANJI,        /* 0x3d31 */
    KANJI,        /* 0x3d32 */
    KANJI,        /* 0x3d33 */
    KANJI,        /* 0x3d34 */
    KANJI,        /* 0x3d35 */
    KANJI,        /* 0x3d36 */
    KANJI,        /* 0x3d37 */
    KANJI,        /* 0x3d38 */
    KANJI,        /* 0x3d39 */
    KANJI,        /* 0x3d3a */
    KANJI,        /* 0x3d3b */
    KANJI,        /* 0x3d3c */
    KANJI,        /* 0x3d3d */
    KANJI,        /* 0x3d3e */
    KANJI,        /* 0x3d3f */
    KANJI,        /* 0x3d40 */
    KANJI,        /* 0x3d41 */
    KANJI,        /* 0x3d42 */
    KANJI,        /* 0x3d43 */
    KANJI,        /* 0x3d44 */
    KANJI,        /* 0x3d45 */
    KANJI,        /* 0x3d46 */
    KANJI,        /* 0x3d47 */
    KANJI,        /* 0x3d48 */
    KANJI,        /* 0x3d49 */
    KANJI,        /* 0x3d4a */
    KANJI,        /* 0x3d4b */
    KANJI,        /* 0x3d4c */
    KANJI,        /* 0x3d4d */
    KANJI,        /* 0x3d4e */
    KANJI,        /* 0x3d4f */
    KANJI,        /* 0x3d50 */
    KANJI,        /* 0x3d51 */
    KANJI,        /* 0x3d52 */
    KANJI,        /* 0x3d53 */
    KANJI,        /* 0x3d54 */
    KANJI,        /* 0x3d55 */
    KANJI,        /* 0x3d56 */
    KANJI,        /* 0x3d57 */
    KANJI,        /* 0x3d58 */
    KANJI,        /* 0x3d59 */
    KANJI,        /* 0x3d5a */
    KANJI,        /* 0x3d5b */
    KANJI,        /* 0x3d5c */
    KANJI,        /* 0x3d5d */
    KANJI,        /* 0x3d5e */
    KANJI,        /* 0x3d5f */
    KANJI,        /* 0x3d60 */
    KANJI,        /* 0x3d61 */
    KANJI,        /* 0x3d62 */
    KANJI,        /* 0x3d63 */
    KANJI,        /* 0x3d64 */
    KANJI,        /* 0x3d65 */
    KANJI,        /* 0x3d66 */
    KANJI,        /* 0x3d67 */
    KANJI,        /* 0x3d68 */
    KANJI,        /* 0x3d69 */
    KANJI,        /* 0x3d6a */
    KANJI,        /* 0x3d6b */
    KANJI,        /* 0x3d6c */
    KANJI,        /* 0x3d6d */
    KANJI,        /* 0x3d6e */
    KANJI,        /* 0x3d6f */
    KANJI,        /* 0x3d70 */
    KANJI,        /* 0x3d71 */
    KANJI,        /* 0x3d72 */
    KANJI,        /* 0x3d73 */
    KANJI,        /* 0x3d74 */
    KANJI,        /* 0x3d75 */
    KANJI,        /* 0x3d76 */
    KANJI,        /* 0x3d77 */
    KANJI,        /* 0x3d78 */
    KANJI,        /* 0x3d79 */
    KANJI,        /* 0x3d7a */
    KANJI,        /* 0x3d7b */
    KANJI,        /* 0x3d7c */
    KANJI,        /* 0x3d7d */
    KANJI,        /* 0x3d7e */
    KANJI,        /* 0x3d7f */
    KANJI,        /* 0x3d80 */
    KANJI,        /* 0x3d81 */
    KANJI,        /* 0x3d82 */
    KANJI,        /* 0x3d83 */
    KANJI,        /* 0x3d84 */
    KANJI,        /* 0x3d85 */
    KANJI,        /* 0x3d86 */
    KANJI,        /* 0x3d87 */
    KANJI,        /* 0x3d88 */
    KANJI,        /* 0x3d89 */
    KANJI,        /* 0x3d8a */
    KANJI,        /* 0x3d8b */
    KANJI,        /* 0x3d8c */
    KANJI,        /* 0x3d8d */
    KANJI,        /* 0x3d8e */
    KANJI,        /* 0x3d8f */
    KANJI,        /* 0x3d90 */
    KANJI,        /* 0x3d91 */
    KANJI,        /* 0x3d92 */
    KANJI,        /* 0x3d93 */
    KANJI,        /* 0x3d94 */
    KANJI,        /* 0x3d95 */
    KANJI,        /* 0x3d96 */
    KANJI,        /* 0x3d97 */
    KANJI,        /* 0x3d98 */
    KANJI,        /* 0x3d99 */
    KANJI,        /* 0x3d9a */
    KANJI,        /* 0x3d9b */
    KANJI,        /* 0x3d9c */
    KANJI,        /* 0x3d9d */
    KANJI,        /* 0x3d9e */
    KANJI,        /* 0x3d9f */
    KANJI,        /* 0x3da0 */
    KANJI,        /* 0x3da1 */
    KANJI,        /* 0x3da2 */
    KANJI,        /* 0x3da3 */
    KANJI,        /* 0x3da4 */
    KANJI,        /* 0x3da5 */
    KANJI,        /* 0x3da6 */
    KANJI,        /* 0x3da7 */
    KANJI,        /* 0x3da8 */
    KANJI,        /* 0x3da9 */
    KANJI,        /* 0x3daa */
    KANJI,        /* 0x3dab */
    KANJI,        /* 0x3dac */
    KANJI,        /* 0x3dad */
    KANJI,        /* 0x3dae */
    KANJI,        /* 0x3daf */
    KANJI,        /* 0x3db0 */
    KANJI,        /* 0x3db1 */
    KANJI,        /* 0x3db2 */
    KANJI,        /* 0x3db3 */
    KANJI,        /* 0x3db4 */
    KANJI,        /* 0x3db5 */
    KANJI,        /* 0x3db6 */
    KANJI,        /* 0x3db7 */
    KANJI,        /* 0x3db8 */
    KANJI,        /* 0x3db9 */
    KANJI,        /* 0x3dba */
    KANJI,        /* 0x3dbb */
    KANJI,        /* 0x3dbc */
    KANJI,        /* 0x3dbd */
    KANJI,        /* 0x3dbe */
    KANJI,        /* 0x3dbf */
    KANJI,        /* 0x3dc0 */
    KANJI,        /* 0x3dc1 */
    KANJI,        /* 0x3dc2 */
    KANJI,        /* 0x3dc3 */
    KANJI,        /* 0x3dc4 */
    KANJI,        /* 0x3dc5 */
    KANJI,        /* 0x3dc6 */
    KANJI,        /* 0x3dc7 */
    KANJI,        /* 0x3dc8 */
    KANJI,        /* 0x3dc9 */
    KANJI,        /* 0x3dca */
    KANJI,        /* 0x3dcb */
    KANJI,        /* 0x3dcc */
    KANJI,        /* 0x3dcd */
    KANJI,        /* 0x3dce */
    KANJI,        /* 0x3dcf */
    KANJI,        /* 0x3dd0 */
    KANJI,        /* 0x3dd1 */
    KANJI,        /* 0x3dd2 */
    KANJI,        /* 0x3dd3 */
    KANJI,        /* 0x3dd4 */
    KANJI,        /* 0x3dd5 */
    KANJI,        /* 0x3dd6 */
    KANJI,        /* 0x3dd7 */
    KANJI,        /* 0x3dd8 */
    KANJI,        /* 0x3dd9 */
    KANJI,        /* 0x3dda */
    KANJI,        /* 0x3ddb */
    KANJI,        /* 0x3ddc */
    KANJI,        /* 0x3ddd */
    KANJI,        /* 0x3dde */
    KANJI,        /* 0x3ddf */
    KANJI,        /* 0x3de0 */
    KANJI,        /* 0x3de1 */
    KANJI,        /* 0x3de2 */
    KANJI,        /* 0x3de3 */
    KANJI,        /* 0x3de4 */
    KANJI,        /* 0x3de5 */
    KANJI,        /* 0x3de6 */
    KANJI,        /* 0x3de7 */
    KANJI,        /* 0x3de8 */
    KANJI,        /* 0x3de9 */
    KANJI,        /* 0x3dea */
    KANJI,        /* 0x3deb */
    KANJI,        /* 0x3dec */
    KANJI,        /* 0x3ded */
    KANJI,        /* 0x3dee */
    KANJI,        /* 0x3def */
    KANJI,        /* 0x3df0 */
    KANJI,        /* 0x3df1 */
    KANJI,        /* 0x3df2 */
    KANJI,        /* 0x3df3 */
    KANJI,        /* 0x3df4 */
    KANJI,        /* 0x3df5 */
    KANJI,        /* 0x3df6 */
    KANJI,        /* 0x3df7 */
    KANJI,        /* 0x3df8 */
    KANJI,        /* 0x3df9 */
    KANJI,        /* 0x3dfa */
    KANJI,        /* 0x3dfb */
    KANJI,        /* 0x3dfc */
    KANJI,        /* 0x3dfd */
    KANJI,        /* 0x3dfe */
    KANJI,        /* 0x3dff */
    KANJI,        /* 0x3e00 */
    KANJI,        /* 0x3e01 */
    KANJI,        /* 0x3e02 */
    KANJI,        /* 0x3e03 */
    KANJI,        /* 0x3e04 */
    KANJI,        /* 0x3e05 */
    KANJI,        /* 0x3e06 */
    KANJI,        /* 0x3e07 */
    KANJI,        /* 0x3e08 */
    KANJI,        /* 0x3e09 */
    KANJI,        /* 0x3e0a */
    KANJI,        /* 0x3e0b */
    KANJI,        /* 0x3e0c */
    KANJI,        /* 0x3e0d */
    KANJI,        /* 0x3e0e */
    KANJI,        /* 0x3e0f */
    KANJI,        /* 0x3e10 */
    KANJI,        /* 0x3e11 */
    KANJI,        /* 0x3e12 */
    KANJI,        /* 0x3e13 */
    KANJI,        /* 0x3e14 */
    KANJI,        /* 0x3e15 */
    KANJI,        /* 0x3e16 */
    KANJI,        /* 0x3e17 */
    KANJI,        /* 0x3e18 */
    KANJI,        /* 0x3e19 */
    KANJI,        /* 0x3e1a */
    KANJI,        /* 0x3e1b */
    KANJI,        /* 0x3e1c */
    KANJI,        /* 0x3e1d */
    KANJI,        /* 0x3e1e */
    KANJI,        /* 0x3e1f */
    KANJI,        /* 0x3e20 */
    KANJI,        /* 0x3e21 */
    KANJI,        /* 0x3e22 */
    KANJI,        /* 0x3e23 */
    KANJI,        /* 0x3e24 */
    KANJI,        /* 0x3e25 */
    KANJI,        /* 0x3e26 */
    KANJI,        /* 0x3e27 */
    KANJI,        /* 0x3e28 */
    KANJI,        /* 0x3e29 */
    KANJI,        /* 0x3e2a */
    KANJI,        /* 0x3e2b */
    KANJI,        /* 0x3e2c */
    KANJI,        /* 0x3e2d */
    KANJI,        /* 0x3e2e */
    KANJI,        /* 0x3e2f */
    KANJI,        /* 0x3e30 */
    KANJI,        /* 0x3e31 */
    KANJI,        /* 0x3e32 */
    KANJI,        /* 0x3e33 */
    KANJI,        /* 0x3e34 */
    KANJI,        /* 0x3e35 */
    KANJI,        /* 0x3e36 */
    KANJI,        /* 0x3e37 */
    KANJI,        /* 0x3e38 */
    KANJI,        /* 0x3e39 */
    KANJI,        /* 0x3e3a */
    KANJI,        /* 0x3e3b */
    KANJI,        /* 0x3e3c */
    KANJI,        /* 0x3e3d */
    KANJI,        /* 0x3e3e */
    KANJI,        /* 0x3e3f */
    KANJI,        /* 0x3e40 */
    KANJI,        /* 0x3e41 */
    KANJI,        /* 0x3e42 */
    KANJI,        /* 0x3e43 */
    KANJI,        /* 0x3e44 */
    KANJI,        /* 0x3e45 */
    KANJI,        /* 0x3e46 */
    KANJI,        /* 0x3e47 */
    KANJI,        /* 0x3e48 */
    KANJI,        /* 0x3e49 */
    KANJI,        /* 0x3e4a */
    KANJI,        /* 0x3e4b */
    KANJI,        /* 0x3e4c */
    KANJI,        /* 0x3e4d */
    KANJI,        /* 0x3e4e */
    KANJI,        /* 0x3e4f */
    KANJI,        /* 0x3e50 */
    KANJI,        /* 0x3e51 */
    KANJI,        /* 0x3e52 */
    KANJI,        /* 0x3e53 */
    KANJI,        /* 0x3e54 */
    KANJI,        /* 0x3e55 */
    KANJI,        /* 0x3e56 */
    KANJI,        /* 0x3e57 */
    KANJI,        /* 0x3e58 */
    KANJI,        /* 0x3e59 */
    KANJI,        /* 0x3e5a */
    KANJI,        /* 0x3e5b */
    KANJI,        /* 0x3e5c */
    KANJI,        /* 0x3e5d */
    KANJI,        /* 0x3e5e */
    KANJI,        /* 0x3e5f */
    KANJI,        /* 0x3e60 */
    KANJI,        /* 0x3e61 */
    KANJI,        /* 0x3e62 */
    KANJI,        /* 0x3e63 */
    KANJI,        /* 0x3e64 */
    KANJI,        /* 0x3e65 */
    KANJI,        /* 0x3e66 */
    KANJI,        /* 0x3e67 */
    KANJI,        /* 0x3e68 */
    KANJI,        /* 0x3e69 */
    KANJI,        /* 0x3e6a */
    KANJI,        /* 0x3e6b */
    KANJI,        /* 0x3e6c */
    KANJI,        /* 0x3e6d */
    KANJI,        /* 0x3e6e */
    KANJI,        /* 0x3e6f */
    KANJI,        /* 0x3e70 */
    KANJI,        /* 0x3e71 */
    KANJI,        /* 0x3e72 */
    KANJI,        /* 0x3e73 */
    KANJI,        /* 0x3e74 */
    KANJI,        /* 0x3e75 */
    KANJI,        /* 0x3e76 */
    KANJI,        /* 0x3e77 */
    KANJI,        /* 0x3e78 */
    KANJI,        /* 0x3e79 */
    KANJI,        /* 0x3e7a */
    KANJI,        /* 0x3e7b */
    KANJI,        /* 0x3e7c */
    KANJI,        /* 0x3e7d */
    KANJI,        /* 0x3e7e */
    KANJI,        /* 0x3e7f */
    KANJI,        /* 0x3e80 */
    KANJI,        /* 0x3e81 */
    KANJI,        /* 0x3e82 */
    KANJI,        /* 0x3e83 */
    KANJI,        /* 0x3e84 */
    KANJI,        /* 0x3e85 */
    KANJI,        /* 0x3e86 */
    KANJI,        /* 0x3e87 */
    KANJI,        /* 0x3e88 */
    KANJI,        /* 0x3e89 */
    KANJI,        /* 0x3e8a */
    KANJI,        /* 0x3e8b */
    KANJI,        /* 0x3e8c */
    KANJI,        /* 0x3e8d */
    KANJI,        /* 0x3e8e */
    KANJI,        /* 0x3e8f */
    KANJI,        /* 0x3e90 */
    KANJI,        /* 0x3e91 */
    KANJI,        /* 0x3e92 */
    KANJI,        /* 0x3e93 */
    KANJI,        /* 0x3e94 */
    KANJI,        /* 0x3e95 */
    KANJI,        /* 0x3e96 */
    KANJI,        /* 0x3e97 */
    KANJI,        /* 0x3e98 */
    KANJI,        /* 0x3e99 */
    KANJI,        /* 0x3e9a */
    KANJI,        /* 0x3e9b */
    KANJI,        /* 0x3e9c */
    KANJI,        /* 0x3e9d */
    KANJI,        /* 0x3e9e */
    KANJI,        /* 0x3e9f */
    KANJI,        /* 0x3ea0 */
    KANJI,        /* 0x3ea1 */
    KANJI,        /* 0x3ea2 */
    KANJI,        /* 0x3ea3 */
    KANJI,        /* 0x3ea4 */
    KANJI,        /* 0x3ea5 */
    KANJI,        /* 0x3ea6 */
    KANJI,        /* 0x3ea7 */
    KANJI,        /* 0x3ea8 */
    KANJI,        /* 0x3ea9 */
    KANJI,        /* 0x3eaa */
    KANJI,        /* 0x3eab */
    KANJI,        /* 0x3eac */
    KANJI,        /* 0x3ead */
    KANJI,        /* 0x3eae */
    KANJI,        /* 0x3eaf */
    KANJI,        /* 0x3eb0 */
    KANJI,        /* 0x3eb1 */
    KANJI,        /* 0x3eb2 */
    KANJI,        /* 0x3eb3 */
    KANJI,        /* 0x3eb4 */
    KANJI,        /* 0x3eb5 */
    KANJI,        /* 0x3eb6 */
    KANJI,        /* 0x3eb7 */
    KANJI,        /* 0x3eb8 */
    KANJI,        /* 0x3eb9 */
    KANJI,        /* 0x3eba */
    KANJI,        /* 0x3ebb */
    KANJI,        /* 0x3ebc */
    KANJI,        /* 0x3ebd */
    KANJI,        /* 0x3ebe */
    KANJI,        /* 0x3ebf */
    KANJI,        /* 0x3ec0 */
    KANJI,        /* 0x3ec1 */
    KANJI,        /* 0x3ec2 */
    KANJI,        /* 0x3ec3 */
    KANJI,        /* 0x3ec4 */
    KANJI,        /* 0x3ec5 */
    KANJI,        /* 0x3ec6 */
    KANJI,        /* 0x3ec7 */
    KANJI,        /* 0x3ec8 */
    KANJI,        /* 0x3ec9 */
    KANJI,        /* 0x3eca */
    KANJI,        /* 0x3ecb */
    KANJI,        /* 0x3ecc */
    KANJI,        /* 0x3ecd */
    KANJI,        /* 0x3ece */
    KANJI,        /* 0x3ecf */
    KANJI,        /* 0x3ed0 */
    KANJI,        /* 0x3ed1 */
    KANJI,        /* 0x3ed2 */
    KANJI,        /* 0x3ed3 */
    KANJI,        /* 0x3ed4 */
    KANJI,        /* 0x3ed5 */
    KANJI,        /* 0x3ed6 */
    KANJI,        /* 0x3ed7 */
    KANJI,        /* 0x3ed8 */
    KANJI,        /* 0x3ed9 */
    KANJI,        /* 0x3eda */
    KANJI,        /* 0x3edb */
    KANJI,        /* 0x3edc */
    KANJI,        /* 0x3edd */
    KANJI,        /* 0x3ede */
    KANJI,        /* 0x3edf */
    KANJI,        /* 0x3ee0 */
    KANJI,        /* 0x3ee1 */
    KANJI,        /* 0x3ee2 */
    KANJI,        /* 0x3ee3 */
    KANJI,        /* 0x3ee4 */
    KANJI,        /* 0x3ee5 */
    KANJI,        /* 0x3ee6 */
    KANJI,        /* 0x3ee7 */
    KANJI,        /* 0x3ee8 */
    KANJI,        /* 0x3ee9 */
    KANJI,        /* 0x3eea */
    KANJI,        /* 0x3eeb */
    KANJI,        /* 0x3eec */
    KANJI,        /* 0x3eed */
    KANJI,        /* 0x3eee */
    KANJI,        /* 0x3eef */
    KANJI,        /* 0x3ef0 */
    KANJI,        /* 0x3ef1 */
    KANJI,        /* 0x3ef2 */
    KANJI,        /* 0x3ef3 */
    KANJI,        /* 0x3ef4 */
    KANJI,        /* 0x3ef5 */
    KANJI,        /* 0x3ef6 */
    KANJI,        /* 0x3ef7 */
    KANJI,        /* 0x3ef8 */
    KANJI,        /* 0x3ef9 */
    KANJI,        /* 0x3efa */
    KANJI,        /* 0x3efb */
    KANJI,        /* 0x3efc */
    KANJI,        /* 0x3efd */
    KANJI,        /* 0x3efe */
    KANJI,        /* 0x3eff */
    KANJI,        /* 0x3f00 */
    KANJI,        /* 0x3f01 */
    KANJI,        /* 0x3f02 */
    KANJI,        /* 0x3f03 */
    KANJI,        /* 0x3f04 */
    KANJI,        /* 0x3f05 */
    KANJI,        /* 0x3f06 */
    KANJI,        /* 0x3f07 */
    KANJI,        /* 0x3f08 */
    KANJI,        /* 0x3f09 */
    KANJI,        /* 0x3f0a */
    KANJI,        /* 0x3f0b */
    KANJI,        /* 0x3f0c */
    KANJI,        /* 0x3f0d */
    KANJI,        /* 0x3f0e */
    KANJI,        /* 0x3f0f */
    KANJI,        /* 0x3f10 */
    KANJI,        /* 0x3f11 */
    KANJI,        /* 0x3f12 */
    KANJI,        /* 0x3f13 */
    KANJI,        /* 0x3f14 */
    KANJI,        /* 0x3f15 */
    KANJI,        /* 0x3f16 */
    KANJI,        /* 0x3f17 */
    KANJI,        /* 0x3f18 */
    KANJI,        /* 0x3f19 */
    KANJI,        /* 0x3f1a */
    KANJI,        /* 0x3f1b */
    KANJI,        /* 0x3f1c */
    KANJI,        /* 0x3f1d */
    KANJI,        /* 0x3f1e */
    KANJI,        /* 0x3f1f */
    KANJI,        /* 0x3f20 */
    KANJI,        /* 0x3f21 */
    KANJI,        /* 0x3f22 */
    KANJI,        /* 0x3f23 */
    KANJI,        /* 0x3f24 */
    KANJI,        /* 0x3f25 */
    KANJI,        /* 0x3f26 */
    KANJI,        /* 0x3f27 */
    KANJI,        /* 0x3f28 */
    KANJI,        /* 0x3f29 */
    KANJI,        /* 0x3f2a */
    KANJI,        /* 0x3f2b */
    KANJI,        /* 0x3f2c */
    KANJI,        /* 0x3f2d */
    KANJI,        /* 0x3f2e */
    KANJI,        /* 0x3f2f */
    KANJI,        /* 0x3f30 */
    KANJI,        /* 0x3f31 */
    KANJI,        /* 0x3f32 */
    KANJI,        /* 0x3f33 */
    KANJI,        /* 0x3f34 */
    KANJI,        /* 0x3f35 */
    KANJI,        /* 0x3f36 */
    KANJI,        /* 0x3f37 */
    KANJI,        /* 0x3f38 */
    KANJI,        /* 0x3f39 */
    KANJI,        /* 0x3f3a */
    KANJI,        /* 0x3f3b */
    KANJI,        /* 0x3f3c */
    KANJI,        /* 0x3f3d */
    KANJI,        /* 0x3f3e */
    KANJI,        /* 0x3f3f */
    KANJI,        /* 0x3f40 */
    KANJI,        /* 0x3f41 */
    KANJI,        /* 0x3f42 */
    KANJI,        /* 0x3f43 */
    KANJI,        /* 0x3f44 */
    KANJI,        /* 0x3f45 */
    KANJI,        /* 0x3f46 */
    KANJI,        /* 0x3f47 */
    KANJI,        /* 0x3f48 */
    KANJI,        /* 0x3f49 */
    KANJI,        /* 0x3f4a */
    KANJI,        /* 0x3f4b */
    KANJI,        /* 0x3f4c */
    KANJI,        /* 0x3f4d */
    KANJI,        /* 0x3f4e */
    KANJI,        /* 0x3f4f */
    KANJI,        /* 0x3f50 */
    KANJI,        /* 0x3f51 */
    KANJI,        /* 0x3f52 */
    KANJI,        /* 0x3f53 */
    KANJI,        /* 0x3f54 */
    KANJI,        /* 0x3f55 */
    KANJI,        /* 0x3f56 */
    KANJI,        /* 0x3f57 */
    KANJI,        /* 0x3f58 */
    KANJI,        /* 0x3f59 */
    KANJI,        /* 0x3f5a */
    KANJI,        /* 0x3f5b */
    KANJI,        /* 0x3f5c */
    KANJI,        /* 0x3f5d */
    KANJI,        /* 0x3f5e */
    KANJI,        /* 0x3f5f */
    KANJI,        /* 0x3f60 */
    KANJI,        /* 0x3f61 */
    KANJI,        /* 0x3f62 */
    KANJI,        /* 0x3f63 */
    KANJI,        /* 0x3f64 */
    KANJI,        /* 0x3f65 */
    KANJI,        /* 0x3f66 */
    KANJI,        /* 0x3f67 */
    KANJI,        /* 0x3f68 */
    KANJI,        /* 0x3f69 */
    KANJI,        /* 0x3f6a */
    KANJI,        /* 0x3f6b */
    KANJI,        /* 0x3f6c */
    KANJI,        /* 0x3f6d */
    KANJI,        /* 0x3f6e */
    KANJI,        /* 0x3f6f */
    KANJI,        /* 0x3f70 */
    KANJI,        /* 0x3f71 */
    KANJI,        /* 0x3f72 */
    KANJI,        /* 0x3f73 */
    KANJI,        /* 0x3f74 */
    KANJI,        /* 0x3f75 */
    KANJI,        /* 0x3f76 */
    KANJI,        /* 0x3f77 */
    KANJI,        /* 0x3f78 */
    KANJI,        /* 0x3f79 */
    KANJI,        /* 0x3f7a */
    KANJI,        /* 0x3f7b */
    KANJI,        /* 0x3f7c */
    KANJI,        /* 0x3f7d */
    KANJI,        /* 0x3f7e */
    KANJI,        /* 0x3f7f */
    KANJI,        /* 0x3f80 */
    KANJI,        /* 0x3f81 */
    KANJI,        /* 0x3f82 */
    KANJI,        /* 0x3f83 */
    KANJI,        /* 0x3f84 */
    KANJI,        /* 0x3f85 */
    KANJI,        /* 0x3f86 */
    KANJI,        /* 0x3f87 */
    KANJI,        /* 0x3f88 */
    KANJI,        /* 0x3f89 */
    KANJI,        /* 0x3f8a */
    KANJI,        /* 0x3f8b */
    KANJI,        /* 0x3f8c */
    KANJI,        /* 0x3f8d */
    KANJI,        /* 0x3f8e */
    KANJI,        /* 0x3f8f */
    KANJI,        /* 0x3f90 */
    KANJI,        /* 0x3f91 */
    KANJI,        /* 0x3f92 */
    KANJI,        /* 0x3f93 */
    KANJI,        /* 0x3f94 */
    KANJI,        /* 0x3f95 */
    KANJI,        /* 0x3f96 */
    KANJI,        /* 0x3f97 */
    KANJI,        /* 0x3f98 */
    KANJI,        /* 0x3f99 */
    KANJI,        /* 0x3f9a */
    KANJI,        /* 0x3f9b */
    KANJI,        /* 0x3f9c */
    KANJI,        /* 0x3f9d */
    KANJI,        /* 0x3f9e */
    KANJI,        /* 0x3f9f */
    KANJI,        /* 0x3fa0 */
    KANJI,        /* 0x3fa1 */
    KANJI,        /* 0x3fa2 */
    KANJI,        /* 0x3fa3 */
    KANJI,        /* 0x3fa4 */
    KANJI,        /* 0x3fa5 */
    KANJI,        /* 0x3fa6 */
    KANJI,        /* 0x3fa7 */
    KANJI,        /* 0x3fa8 */
    KANJI,        /* 0x3fa9 */
    KANJI,        /* 0x3faa */
    KANJI,        /* 0x3fab */
    KANJI,        /* 0x3fac */
    KANJI,        /* 0x3fad */
    KANJI,        /* 0x3fae */
    KANJI,        /* 0x3faf */
    KANJI,        /* 0x3fb0 */
    KANJI,        /* 0x3fb1 */
    KANJI,        /* 0x3fb2 */
    KANJI,        /* 0x3fb3 */
    KANJI,        /* 0x3fb4 */
    KANJI,        /* 0x3fb5 */
    KANJI,        /* 0x3fb6 */
    KANJI,        /* 0x3fb7 */
    KANJI,        /* 0x3fb8 */
    KANJI,        /* 0x3fb9 */
    KANJI,        /* 0x3fba */
    KANJI,        /* 0x3fbb */
    KANJI,        /* 0x3fbc */
    KANJI,        /* 0x3fbd */
    KANJI,        /* 0x3fbe */
    KANJI,        /* 0x3fbf */
    KANJI,        /* 0x3fc0 */
    KANJI,        /* 0x3fc1 */
    KANJI,        /* 0x3fc2 */
    KANJI,        /* 0x3fc3 */
    KANJI,        /* 0x3fc4 */
    KANJI,        /* 0x3fc5 */
    KANJI,        /* 0x3fc6 */
    KANJI,        /* 0x3fc7 */
    KANJI,        /* 0x3fc8 */
    KANJI,        /* 0x3fc9 */
    KANJI,        /* 0x3fca */
    KANJI,        /* 0x3fcb */
    KANJI,        /* 0x3fcc */
    KANJI,        /* 0x3fcd */
    KANJI,        /* 0x3fce */
    KANJI,        /* 0x3fcf */
    KANJI,        /* 0x3fd0 */
    KANJI,        /* 0x3fd1 */
    KANJI,        /* 0x3fd2 */
    KANJI,        /* 0x3fd3 */
    KANJI,        /* 0x3fd4 */
    KANJI,        /* 0x3fd5 */
    KANJI,        /* 0x3fd6 */
    KANJI,        /* 0x3fd7 */
    KANJI,        /* 0x3fd8 */
    KANJI,        /* 0x3fd9 */
    KANJI,        /* 0x3fda */
    KANJI,        /* 0x3fdb */
    KANJI,        /* 0x3fdc */
    KANJI,        /* 0x3fdd */
    KANJI,        /* 0x3fde */
    KANJI,        /* 0x3fdf */
    KANJI,        /* 0x3fe0 */
    KANJI,        /* 0x3fe1 */
    KANJI,        /* 0x3fe2 */
    KANJI,        /* 0x3fe3 */
    KANJI,        /* 0x3fe4 */
    KANJI,        /* 0x3fe5 */
    KANJI,        /* 0x3fe6 */
    KANJI,        /* 0x3fe7 */
    KANJI,        /* 0x3fe8 */
    KANJI,        /* 0x3fe9 */
    KANJI,        /* 0x3fea */
    KANJI,        /* 0x3feb */
    KANJI,        /* 0x3fec */
    KANJI,        /* 0x3fed */
    KANJI,        /* 0x3fee */
    KANJI,        /* 0x3fef */
    KANJI,        /* 0x3ff0 */
    KANJI,        /* 0x3ff1 */
    KANJI,        /* 0x3ff2 */
    KANJI,        /* 0x3ff3 */
    KANJI,        /* 0x3ff4 */
    KANJI,        /* 0x3ff5 */
    KANJI,        /* 0x3ff6 */
    KANJI,        /* 0x3ff7 */
    KANJI,        /* 0x3ff8 */
    KANJI,        /* 0x3ff9 */
    KANJI,        /* 0x3ffa */
    KANJI,        /* 0x3ffb */
    KANJI,        /* 0x3ffc */
    KANJI,        /* 0x3ffd */
    KANJI,        /* 0x3ffe */
    KANJI,        /* 0x3fff */
    KANJI,        /* 0x4000 */
    KANJI,        /* 0x4001 */
    KANJI,        /* 0x4002 */
    KANJI,        /* 0x4003 */
    KANJI,        /* 0x4004 */
    KANJI,        /* 0x4005 */
    KANJI,        /* 0x4006 */
    KANJI,        /* 0x4007 */
    KANJI,        /* 0x4008 */
    KANJI,        /* 0x4009 */
    KANJI,        /* 0x400a */
    KANJI,        /* 0x400b */
    KANJI,        /* 0x400c */
    KANJI,        /* 0x400d */
    KANJI,        /* 0x400e */
    KANJI,        /* 0x400f */
    KANJI,        /* 0x4010 */
    KANJI,        /* 0x4011 */
    KANJI,        /* 0x4012 */
    KANJI,        /* 0x4013 */
    KANJI,        /* 0x4014 */
    KANJI,        /* 0x4015 */
    KANJI,        /* 0x4016 */
    KANJI,        /* 0x4017 */
    KANJI,        /* 0x4018 */
    KANJI,        /* 0x4019 */
    KANJI,        /* 0x401a */
    KANJI,        /* 0x401b */
    KANJI,        /* 0x401c */
    KANJI,        /* 0x401d */
    KANJI,        /* 0x401e */
    KANJI,        /* 0x401f */
    KANJI,        /* 0x4020 */
    KANJI,        /* 0x4021 */
    KANJI,        /* 0x4022 */
    KANJI,        /* 0x4023 */
    KANJI,        /* 0x4024 */
    KANJI,        /* 0x4025 */
    KANJI,        /* 0x4026 */
    KANJI,        /* 0x4027 */
    KANJI,        /* 0x4028 */
    KANJI,        /* 0x4029 */
    KANJI,        /* 0x402a */
    KANJI,        /* 0x402b */
    KANJI,        /* 0x402c */
    KANJI,        /* 0x402d */
    KANJI,        /* 0x402e */
    KANJI,        /* 0x402f */
    KANJI,        /* 0x4030 */
    KANJI,        /* 0x4031 */
    KANJI,        /* 0x4032 */
    KANJI,        /* 0x4033 */
    KANJI,        /* 0x4034 */
    KANJI,        /* 0x4035 */
    KANJI,        /* 0x4036 */
    KANJI,        /* 0x4037 */
    KANJI,        /* 0x4038 */
    KANJI,        /* 0x4039 */
    KANJI,        /* 0x403a */
    KANJI,        /* 0x403b */
    KANJI,        /* 0x403c */
    KANJI,        /* 0x403d */
    KANJI,        /* 0x403e */
    KANJI,        /* 0x403f */
    KANJI,        /* 0x4040 */
    KANJI,        /* 0x4041 */
    KANJI,        /* 0x4042 */
    KANJI,        /* 0x4043 */
    KANJI,        /* 0x4044 */
    KANJI,        /* 0x4045 */
    KANJI,        /* 0x4046 */
    KANJI,        /* 0x4047 */
    KANJI,        /* 0x4048 */
    KANJI,        /* 0x4049 */
    KANJI,        /* 0x404a */
    KANJI,        /* 0x404b */
    KANJI,        /* 0x404c */
    KANJI,        /* 0x404d */
    KANJI,        /* 0x404e */
    KANJI,        /* 0x404f */
    KANJI,        /* 0x4050 */
    KANJI,        /* 0x4051 */
    KANJI,        /* 0x4052 */
    KANJI,        /* 0x4053 */
    KANJI,        /* 0x4054 */
    KANJI,        /* 0x4055 */
    KANJI,        /* 0x4056 */
    KANJI,        /* 0x4057 */
    KANJI,        /* 0x4058 */
    KANJI,        /* 0x4059 */
    KANJI,        /* 0x405a */
    KANJI,        /* 0x405b */
    KANJI,        /* 0x405c */
    KANJI,        /* 0x405d */
    KANJI,        /* 0x405e */
    KANJI,        /* 0x405f */
    KANJI,        /* 0x4060 */
    KANJI,        /* 0x4061 */
    KANJI,        /* 0x4062 */
    KANJI,        /* 0x4063 */
    KANJI,        /* 0x4064 */
    KANJI,        /* 0x4065 */
    KANJI,        /* 0x4066 */
    KANJI,        /* 0x4067 */
    KANJI,        /* 0x4068 */
    KANJI,        /* 0x4069 */
    KANJI,        /* 0x406a */
    KANJI,        /* 0x406b */
    KANJI,        /* 0x406c */
    KANJI,        /* 0x406d */
    KANJI,        /* 0x406e */
    KANJI,        /* 0x406f */
    KANJI,        /* 0x4070 */
    KANJI,        /* 0x4071 */
    KANJI,        /* 0x4072 */
    KANJI,        /* 0x4073 */
    KANJI,        /* 0x4074 */
    KANJI,        /* 0x4075 */
    KANJI,        /* 0x4076 */
    KANJI,        /* 0x4077 */
    KANJI,        /* 0x4078 */
    KANJI,        /* 0x4079 */
    KANJI,        /* 0x407a */
    KANJI,        /* 0x407b */
    KANJI,        /* 0x407c */
    KANJI,        /* 0x407d */
    KANJI,        /* 0x407e */
    KANJI,        /* 0x407f */
    KANJI,        /* 0x4080 */
    KANJI,        /* 0x4081 */
    KANJI,        /* 0x4082 */
    KANJI,        /* 0x4083 */
    KANJI,        /* 0x4084 */
    KANJI,        /* 0x4085 */
    KANJI,        /* 0x4086 */
    KANJI,        /* 0x4087 */
    KANJI,        /* 0x4088 */
    KANJI,        /* 0x4089 */
    KANJI,        /* 0x408a */
    KANJI,        /* 0x408b */
    KANJI,        /* 0x408c */
    KANJI,        /* 0x408d */
    KANJI,        /* 0x408e */
    KANJI,        /* 0x408f */
    KANJI,        /* 0x4090 */
    KANJI,        /* 0x4091 */
    KANJI,        /* 0x4092 */
    KANJI,        /* 0x4093 */
    KANJI,        /* 0x4094 */
    KANJI,        /* 0x4095 */
    KANJI,        /* 0x4096 */
    KANJI,        /* 0x4097 */
    KANJI,        /* 0x4098 */
    KANJI,        /* 0x4099 */
    KANJI,        /* 0x409a */
    KANJI,        /* 0x409b */
    KANJI,        /* 0x409c */
    KANJI,        /* 0x409d */
    KANJI,        /* 0x409e */
    KANJI,        /* 0x409f */
    KANJI,        /* 0x40a0 */
    KANJI,        /* 0x40a1 */
    KANJI,        /* 0x40a2 */
    KANJI,        /* 0x40a3 */
    KANJI,        /* 0x40a4 */
    KANJI,        /* 0x40a5 */
    KANJI,        /* 0x40a6 */
    KANJI,        /* 0x40a7 */
    KANJI,        /* 0x40a8 */
    KANJI,        /* 0x40a9 */
    KANJI,        /* 0x40aa */
    KANJI,        /* 0x40ab */
    KANJI,        /* 0x40ac */
    KANJI,        /* 0x40ad */
    KANJI,        /* 0x40ae */
    KANJI,        /* 0x40af */
    KANJI,        /* 0x40b0 */
    KANJI,        /* 0x40b1 */
    KANJI,        /* 0x40b2 */
    KANJI,        /* 0x40b3 */
    KANJI,        /* 0x40b4 */
    KANJI,        /* 0x40b5 */
    KANJI,        /* 0x40b6 */
    KANJI,        /* 0x40b7 */
    KANJI,        /* 0x40b8 */
    KANJI,        /* 0x40b9 */
    KANJI,        /* 0x40ba */
    KANJI,        /* 0x40bb */
    KANJI,        /* 0x40bc */
    KANJI,        /* 0x40bd */
    KANJI,        /* 0x40be */
    KANJI,        /* 0x40bf */
    KANJI,        /* 0x40c0 */
    KANJI,        /* 0x40c1 */
    KANJI,        /* 0x40c2 */
    KANJI,        /* 0x40c3 */
    KANJI,        /* 0x40c4 */
    KANJI,        /* 0x40c5 */
    KANJI,        /* 0x40c6 */
    KANJI,        /* 0x40c7 */
    KANJI,        /* 0x40c8 */
    KANJI,        /* 0x40c9 */
    KANJI,        /* 0x40ca */
    KANJI,        /* 0x40cb */
    KANJI,        /* 0x40cc */
    KANJI,        /* 0x40cd */
    KANJI,        /* 0x40ce */
    KANJI,        /* 0x40cf */
    KANJI,        /* 0x40d0 */
    KANJI,        /* 0x40d1 */
    KANJI,        /* 0x40d2 */
    KANJI,        /* 0x40d3 */
    KANJI,        /* 0x40d4 */
    KANJI,        /* 0x40d5 */
    KANJI,        /* 0x40d6 */
    KANJI,        /* 0x40d7 */
    KANJI,        /* 0x40d8 */
    KANJI,        /* 0x40d9 */
    KANJI,        /* 0x40da */
    KANJI,        /* 0x40db */
    KANJI,        /* 0x40dc */
    KANJI,        /* 0x40dd */
    KANJI,        /* 0x40de */
    KANJI,        /* 0x40df */
    KANJI,        /* 0x40e0 */
    KANJI,        /* 0x40e1 */
    KANJI,        /* 0x40e2 */
    KANJI,        /* 0x40e3 */
    KANJI,        /* 0x40e4 */
    KANJI,        /* 0x40e5 */
    KANJI,        /* 0x40e6 */
    KANJI,        /* 0x40e7 */
    KANJI,        /* 0x40e8 */
    KANJI,        /* 0x40e9 */
    KANJI,        /* 0x40ea */
    KANJI,        /* 0x40eb */
    KANJI,        /* 0x40ec */
    KANJI,        /* 0x40ed */
    KANJI,        /* 0x40ee */
    KANJI,        /* 0x40ef */
    KANJI,        /* 0x40f0 */
    KANJI,        /* 0x40f1 */
    KANJI,        /* 0x40f2 */
    KANJI,        /* 0x40f3 */
    KANJI,        /* 0x40f4 */
    KANJI,        /* 0x40f5 */
    KANJI,        /* 0x40f6 */
    KANJI,        /* 0x40f7 */
    KANJI,        /* 0x40f8 */
    KANJI,        /* 0x40f9 */
    KANJI,        /* 0x40fa */
    KANJI,        /* 0x40fb */
    KANJI,        /* 0x40fc */
    KANJI,        /* 0x40fd */
    KANJI,        /* 0x40fe */
    KANJI,        /* 0x40ff */
    KANJI,        /* 0x4100 */
    KANJI,        /* 0x4101 */
    KANJI,        /* 0x4102 */
    KANJI,        /* 0x4103 */
    KANJI,        /* 0x4104 */
    KANJI,        /* 0x4105 */
    KANJI,        /* 0x4106 */
    KANJI,        /* 0x4107 */
    KANJI,        /* 0x4108 */
    KANJI,        /* 0x4109 */
    KANJI,        /* 0x410a */
    KANJI,        /* 0x410b */
    KANJI,        /* 0x410c */
    KANJI,        /* 0x410d */
    KANJI,        /* 0x410e */
    KANJI,        /* 0x410f */
    KANJI,        /* 0x4110 */
    KANJI,        /* 0x4111 */
    KANJI,        /* 0x4112 */
    KANJI,        /* 0x4113 */
    KANJI,        /* 0x4114 */
    KANJI,        /* 0x4115 */
    KANJI,        /* 0x4116 */
    KANJI,        /* 0x4117 */
    KANJI,        /* 0x4118 */
    KANJI,        /* 0x4119 */
    KANJI,        /* 0x411a */
    KANJI,        /* 0x411b */
    KANJI,        /* 0x411c */
    KANJI,        /* 0x411d */
    KANJI,        /* 0x411e */
    KANJI,        /* 0x411f */
    KANJI,        /* 0x4120 */
    KANJI,        /* 0x4121 */
    KANJI,        /* 0x4122 */
    KANJI,        /* 0x4123 */
    KANJI,        /* 0x4124 */
    KANJI,        /* 0x4125 */
    KANJI,        /* 0x4126 */
    KANJI,        /* 0x4127 */
    KANJI,        /* 0x4128 */
    KANJI,        /* 0x4129 */
    KANJI,        /* 0x412a */
    KANJI,        /* 0x412b */
    KANJI,        /* 0x412c */
    KANJI,        /* 0x412d */
    KANJI,        /* 0x412e */
    KANJI,        /* 0x412f */
    KANJI,        /* 0x4130 */
    KANJI,        /* 0x4131 */
    KANJI,        /* 0x4132 */
    KANJI,        /* 0x4133 */
    KANJI,        /* 0x4134 */
    KANJI,        /* 0x4135 */
    KANJI,        /* 0x4136 */
    KANJI,        /* 0x4137 */
    KANJI,        /* 0x4138 */
    KANJI,        /* 0x4139 */
    KANJI,        /* 0x413a */
    KANJI,        /* 0x413b */
    KANJI,        /* 0x413c */
    KANJI,        /* 0x413d */
    KANJI,        /* 0x413e */
    KANJI,        /* 0x413f */
    KANJI,        /* 0x4140 */
    KANJI,        /* 0x4141 */
    KANJI,        /* 0x4142 */
    KANJI,        /* 0x4143 */
    KANJI,        /* 0x4144 */
    KANJI,        /* 0x4145 */
    KANJI,        /* 0x4146 */
    KANJI,        /* 0x4147 */
    KANJI,        /* 0x4148 */
    KANJI,        /* 0x4149 */
    KANJI,        /* 0x414a */
    KANJI,        /* 0x414b */
    KANJI,        /* 0x414c */
    KANJI,        /* 0x414d */
    KANJI,        /* 0x414e */
    KANJI,        /* 0x414f */
    KANJI,        /* 0x4150 */
    KANJI,        /* 0x4151 */
    KANJI,        /* 0x4152 */
    KANJI,        /* 0x4153 */
    KANJI,        /* 0x4154 */
    KANJI,        /* 0x4155 */
    KANJI,        /* 0x4156 */
    KANJI,        /* 0x4157 */
    KANJI,        /* 0x4158 */
    KANJI,        /* 0x4159 */
    KANJI,        /* 0x415a */
    KANJI,        /* 0x415b */
    KANJI,        /* 0x415c */
    KANJI,        /* 0x415d */
    KANJI,        /* 0x415e */
    KANJI,        /* 0x415f */
    KANJI,        /* 0x4160 */
    KANJI,        /* 0x4161 */
    KANJI,        /* 0x4162 */
    KANJI,        /* 0x4163 */
    KANJI,        /* 0x4164 */
    KANJI,        /* 0x4165 */
    KANJI,        /* 0x4166 */
    KANJI,        /* 0x4167 */
    KANJI,        /* 0x4168 */
    KANJI,        /* 0x4169 */
    KANJI,        /* 0x416a */
    KANJI,        /* 0x416b */
    KANJI,        /* 0x416c */
    KANJI,        /* 0x416d */
    KANJI,        /* 0x416e */
    KANJI,        /* 0x416f */
    KANJI,        /* 0x4170 */
    KANJI,        /* 0x4171 */
    KANJI,        /* 0x4172 */
    KANJI,        /* 0x4173 */
    KANJI,        /* 0x4174 */
    KANJI,        /* 0x4175 */
    KANJI,        /* 0x4176 */
    KANJI,        /* 0x4177 */
    KANJI,        /* 0x4178 */
    KANJI,        /* 0x4179 */
    KANJI,        /* 0x417a */
    KANJI,        /* 0x417b */
    KANJI,        /* 0x417c */
    KANJI,        /* 0x417d */
    KANJI,        /* 0x417e */
    KANJI,        /* 0x417f */
    KANJI,        /* 0x4180 */
    KANJI,        /* 0x4181 */
    KANJI,        /* 0x4182 */
    KANJI,        /* 0x4183 */
    KANJI,        /* 0x4184 */
    KANJI,        /* 0x4185 */
    KANJI,        /* 0x4186 */
    KANJI,        /* 0x4187 */
    KANJI,        /* 0x4188 */
    KANJI,        /* 0x4189 */
    KANJI,        /* 0x418a */
    KANJI,        /* 0x418b */
    KANJI,        /* 0x418c */
    KANJI,        /* 0x418d */
    KANJI,        /* 0x418e */
    KANJI,        /* 0x418f */
    KANJI,        /* 0x4190 */
    KANJI,        /* 0x4191 */
    KANJI,        /* 0x4192 */
    KANJI,        /* 0x4193 */
    KANJI,        /* 0x4194 */
    KANJI,        /* 0x4195 */
    KANJI,        /* 0x4196 */
    KANJI,        /* 0x4197 */
    KANJI,        /* 0x4198 */
    KANJI,        /* 0x4199 */
    KANJI,        /* 0x419a */
    KANJI,        /* 0x419b */
    KANJI,        /* 0x419c */
    KANJI,        /* 0x419d */
    KANJI,        /* 0x419e */
    KANJI,        /* 0x419f */
    KANJI,        /* 0x41a0 */
    KANJI,        /* 0x41a1 */
    KANJI,        /* 0x41a2 */
    KANJI,        /* 0x41a3 */
    KANJI,        /* 0x41a4 */
    KANJI,        /* 0x41a5 */
    KANJI,        /* 0x41a6 */
    KANJI,        /* 0x41a7 */
    KANJI,        /* 0x41a8 */
    KANJI,        /* 0x41a9 */
    KANJI,        /* 0x41aa */
    KANJI,        /* 0x41ab */
    KANJI,        /* 0x41ac */
    KANJI,        /* 0x41ad */
    KANJI,        /* 0x41ae */
    KANJI,        /* 0x41af */
    KANJI,        /* 0x41b0 */
    KANJI,        /* 0x41b1 */
    KANJI,        /* 0x41b2 */
    KANJI,        /* 0x41b3 */
    KANJI,        /* 0x41b4 */
    KANJI,        /* 0x41b5 */
    KANJI,        /* 0x41b6 */
    KANJI,        /* 0x41b7 */
    KANJI,        /* 0x41b8 */
    KANJI,        /* 0x41b9 */
    KANJI,        /* 0x41ba */
    KANJI,        /* 0x41bb */
    KANJI,        /* 0x41bc */
    KANJI,        /* 0x41bd */
    KANJI,        /* 0x41be */
    KANJI,        /* 0x41bf */
    KANJI,        /* 0x41c0 */
    KANJI,        /* 0x41c1 */
    KANJI,        /* 0x41c2 */
    KANJI,        /* 0x41c3 */
    KANJI,        /* 0x41c4 */
    KANJI,        /* 0x41c5 */
    KANJI,        /* 0x41c6 */
    KANJI,        /* 0x41c7 */
    KANJI,        /* 0x41c8 */
    KANJI,        /* 0x41c9 */
    KANJI,        /* 0x41ca */
    KANJI,        /* 0x41cb */
    KANJI,        /* 0x41cc */
    KANJI,        /* 0x41cd */
    KANJI,        /* 0x41ce */
    KANJI,        /* 0x41cf */
    KANJI,        /* 0x41d0 */
    KANJI,        /* 0x41d1 */
    KANJI,        /* 0x41d2 */
    KANJI,        /* 0x41d3 */
    KANJI,        /* 0x41d4 */
    KANJI,        /* 0x41d5 */
    KANJI,        /* 0x41d6 */
    KANJI,        /* 0x41d7 */
    KANJI,        /* 0x41d8 */
    KANJI,        /* 0x41d9 */
    KANJI,        /* 0x41da */
    KANJI,        /* 0x41db */
    KANJI,        /* 0x41dc */
    KANJI,        /* 0x41dd */
    KANJI,        /* 0x41de */
    KANJI,        /* 0x41df */
    KANJI,        /* 0x41e0 */
    KANJI,        /* 0x41e1 */
    KANJI,        /* 0x41e2 */
    KANJI,        /* 0x41e3 */
    KANJI,        /* 0x41e4 */
    KANJI,        /* 0x41e5 */
    KANJI,        /* 0x41e6 */
    KANJI,        /* 0x41e7 */
    KANJI,        /* 0x41e8 */
    KANJI,        /* 0x41e9 */
    KANJI,        /* 0x41ea */
    KANJI,        /* 0x41eb */
    KANJI,        /* 0x41ec */
    KANJI,        /* 0x41ed */
    KANJI,        /* 0x41ee */
    KANJI,        /* 0x41ef */
    KANJI,        /* 0x41f0 */
    KANJI,        /* 0x41f1 */
    KANJI,        /* 0x41f2 */
    KANJI,        /* 0x41f3 */
    KANJI,        /* 0x41f4 */
    KANJI,        /* 0x41f5 */
    KANJI,        /* 0x41f6 */
    KANJI,        /* 0x41f7 */
    KANJI,        /* 0x41f8 */
    KANJI,        /* 0x41f9 */
    KANJI,        /* 0x41fa */
    KANJI,        /* 0x41fb */
    KANJI,        /* 0x41fc */
    KANJI,        /* 0x41fd */
    KANJI,        /* 0x41fe */
    KANJI,        /* 0x41ff */
    KANJI,        /* 0x4200 */
    KANJI,        /* 0x4201 */
    KANJI,        /* 0x4202 */
    KANJI,        /* 0x4203 */
    KANJI,        /* 0x4204 */
    KANJI,        /* 0x4205 */
    KANJI,        /* 0x4206 */
    KANJI,        /* 0x4207 */
    KANJI,        /* 0x4208 */
    KANJI,        /* 0x4209 */
    KANJI,        /* 0x420a */
    KANJI,        /* 0x420b */
    KANJI,        /* 0x420c */
    KANJI,        /* 0x420d */
    KANJI,        /* 0x420e */
    KANJI,        /* 0x420f */
    KANJI,        /* 0x4210 */
    KANJI,        /* 0x4211 */
    KANJI,        /* 0x4212 */
    KANJI,        /* 0x4213 */
    KANJI,        /* 0x4214 */
    KANJI,        /* 0x4215 */
    KANJI,        /* 0x4216 */
    KANJI,        /* 0x4217 */
    KANJI,        /* 0x4218 */
    KANJI,        /* 0x4219 */
    KANJI,        /* 0x421a */
    KANJI,        /* 0x421b */
    KANJI,        /* 0x421c */
    KANJI,        /* 0x421d */
    KANJI,        /* 0x421e */
    KANJI,        /* 0x421f */
    KANJI,        /* 0x4220 */
    KANJI,        /* 0x4221 */
    KANJI,        /* 0x4222 */
    KANJI,        /* 0x4223 */
    KANJI,        /* 0x4224 */
    KANJI,        /* 0x4225 */
    KANJI,        /* 0x4226 */
    KANJI,        /* 0x4227 */
    KANJI,        /* 0x4228 */
    KANJI,        /* 0x4229 */
    KANJI,        /* 0x422a */
    KANJI,        /* 0x422b */
    KANJI,        /* 0x422c */
    KANJI,        /* 0x422d */
    KANJI,        /* 0x422e */
    KANJI,        /* 0x422f */
    KANJI,        /* 0x4230 */
    KANJI,        /* 0x4231 */
    KANJI,        /* 0x4232 */
    KANJI,        /* 0x4233 */
    KANJI,        /* 0x4234 */
    KANJI,        /* 0x4235 */
    KANJI,        /* 0x4236 */
    KANJI,        /* 0x4237 */
    KANJI,        /* 0x4238 */
    KANJI,        /* 0x4239 */
    KANJI,        /* 0x423a */
    KANJI,        /* 0x423b */
    KANJI,        /* 0x423c */
    KANJI,        /* 0x423d */
    KANJI,        /* 0x423e */
    KANJI,        /* 0x423f */
    KANJI,        /* 0x4240 */
    KANJI,        /* 0x4241 */
    KANJI,        /* 0x4242 */
    KANJI,        /* 0x4243 */
    KANJI,        /* 0x4244 */
    KANJI,        /* 0x4245 */
    KANJI,        /* 0x4246 */
    KANJI,        /* 0x4247 */
    KANJI,        /* 0x4248 */
    KANJI,        /* 0x4249 */
    KANJI,        /* 0x424a */
    KANJI,        /* 0x424b */
    KANJI,        /* 0x424c */
    KANJI,        /* 0x424d */
    KANJI,        /* 0x424e */
    KANJI,        /* 0x424f */
    KANJI,        /* 0x4250 */
    KANJI,        /* 0x4251 */
    KANJI,        /* 0x4252 */
    KANJI,        /* 0x4253 */
    KANJI,        /* 0x4254 */
    KANJI,        /* 0x4255 */
    KANJI,        /* 0x4256 */
    KANJI,        /* 0x4257 */
    KANJI,        /* 0x4258 */
    KANJI,        /* 0x4259 */
    KANJI,        /* 0x425a */
    KANJI,        /* 0x425b */
    KANJI,        /* 0x425c */
    KANJI,        /* 0x425d */
    KANJI,        /* 0x425e */
    KANJI,        /* 0x425f */
    KANJI,        /* 0x4260 */
    KANJI,        /* 0x4261 */
    KANJI,        /* 0x4262 */
    KANJI,        /* 0x4263 */
    KANJI,        /* 0x4264 */
    KANJI,        /* 0x4265 */
    KANJI,        /* 0x4266 */
    KANJI,        /* 0x4267 */
    KANJI,        /* 0x4268 */
    KANJI,        /* 0x4269 */
    KANJI,        /* 0x426a */
    KANJI,        /* 0x426b */
    KANJI,        /* 0x426c */
    KANJI,        /* 0x426d */
    KANJI,        /* 0x426e */
    KANJI,        /* 0x426f */
    KANJI,        /* 0x4270 */
    KANJI,        /* 0x4271 */
    KANJI,        /* 0x4272 */
    KANJI,        /* 0x4273 */
    KANJI,        /* 0x4274 */
    KANJI,        /* 0x4275 */
    KANJI,        /* 0x4276 */
    KANJI,        /* 0x4277 */
    KANJI,        /* 0x4278 */
    KANJI,        /* 0x4279 */
    KANJI,        /* 0x427a */
    KANJI,        /* 0x427b */
    KANJI,        /* 0x427c */
    KANJI,        /* 0x427d */
    KANJI,        /* 0x427e */
    KANJI,        /* 0x427f */
    KANJI,        /* 0x4280 */
    KANJI,        /* 0x4281 */
    KANJI,        /* 0x4282 */
    KANJI,        /* 0x4283 */
    KANJI,        /* 0x4284 */
    KANJI,        /* 0x4285 */
    KANJI,        /* 0x4286 */
    KANJI,        /* 0x4287 */
    KANJI,        /* 0x4288 */
    KANJI,        /* 0x4289 */
    KANJI,        /* 0x428a */
    KANJI,        /* 0x428b */
    KANJI,        /* 0x428c */
    KANJI,        /* 0x428d */
    KANJI,        /* 0x428e */
    KANJI,        /* 0x428f */
    KANJI,        /* 0x4290 */
    KANJI,        /* 0x4291 */
    KANJI,        /* 0x4292 */
    KANJI,        /* 0x4293 */
    KANJI,        /* 0x4294 */
    KANJI,        /* 0x4295 */
    KANJI,        /* 0x4296 */
    KANJI,        /* 0x4297 */
    KANJI,        /* 0x4298 */
    KANJI,        /* 0x4299 */
    KANJI,        /* 0x429a */
    KANJI,        /* 0x429b */
    KANJI,        /* 0x429c */
    KANJI,        /* 0x429d */
    KANJI,        /* 0x429e */
    KANJI,        /* 0x429f */
    KANJI,        /* 0x42a0 */
    KANJI,        /* 0x42a1 */
    KANJI,        /* 0x42a2 */
    KANJI,        /* 0x42a3 */
    KANJI,        /* 0x42a4 */
    KANJI,        /* 0x42a5 */
    KANJI,        /* 0x42a6 */
    KANJI,        /* 0x42a7 */
    KANJI,        /* 0x42a8 */
    KANJI,        /* 0x42a9 */
    KANJI,        /* 0x42aa */
    KANJI,        /* 0x42ab */
    KANJI,        /* 0x42ac */
    KANJI,        /* 0x42ad */
    KANJI,        /* 0x42ae */
    KANJI,        /* 0x42af */
    KANJI,        /* 0x42b0 */
    KANJI,        /* 0x42b1 */
    KANJI,        /* 0x42b2 */
    KANJI,        /* 0x42b3 */
    KANJI,        /* 0x42b4 */
    KANJI,        /* 0x42b5 */
    KANJI,        /* 0x42b6 */
    KANJI,        /* 0x42b7 */
    KANJI,        /* 0x42b8 */
    KANJI,        /* 0x42b9 */
    KANJI,        /* 0x42ba */
    KANJI,        /* 0x42bb */
    KANJI,        /* 0x42bc */
    KANJI,        /* 0x42bd */
    KANJI,        /* 0x42be */
    KANJI,        /* 0x42bf */
    KANJI,        /* 0x42c0 */
    KANJI,        /* 0x42c1 */
    KANJI,        /* 0x42c2 */
    KANJI,        /* 0x42c3 */
    KANJI,        /* 0x42c4 */
    KANJI,        /* 0x42c5 */
    KANJI,        /* 0x42c6 */
    KANJI,        /* 0x42c7 */
    KANJI,        /* 0x42c8 */
    KANJI,        /* 0x42c9 */
    KANJI,        /* 0x42ca */
    KANJI,        /* 0x42cb */
    KANJI,        /* 0x42cc */
    KANJI,        /* 0x42cd */
    KANJI,        /* 0x42ce */
    KANJI,        /* 0x42cf */
    KANJI,        /* 0x42d0 */
    KANJI,        /* 0x42d1 */
    KANJI,        /* 0x42d2 */
    KANJI,        /* 0x42d3 */
    KANJI,        /* 0x42d4 */
    KANJI,        /* 0x42d5 */
    KANJI,        /* 0x42d6 */
    KANJI,        /* 0x42d7 */
    KANJI,        /* 0x42d8 */
    KANJI,        /* 0x42d9 */
    KANJI,        /* 0x42da */
    KANJI,        /* 0x42db */
    KANJI,        /* 0x42dc */
    KANJI,        /* 0x42dd */
    KANJI,        /* 0x42de */
    KANJI,        /* 0x42df */
    KANJI,        /* 0x42e0 */
    KANJI,        /* 0x42e1 */
    KANJI,        /* 0x42e2 */
    KANJI,        /* 0x42e3 */
    KANJI,        /* 0x42e4 */
    KANJI,        /* 0x42e5 */
    KANJI,        /* 0x42e6 */
    KANJI,        /* 0x42e7 */
    KANJI,        /* 0x42e8 */
    KANJI,        /* 0x42e9 */
    KANJI,        /* 0x42ea */
    KANJI,        /* 0x42eb */
    KANJI,        /* 0x42ec */
    KANJI,        /* 0x42ed */
    KANJI,        /* 0x42ee */
    KANJI,        /* 0x42ef */
    KANJI,        /* 0x42f0 */
    KANJI,        /* 0x42f1 */
    KANJI,        /* 0x42f2 */
    KANJI,        /* 0x42f3 */
    KANJI,        /* 0x42f4 */
    KANJI,        /* 0x42f5 */
    KANJI,        /* 0x42f6 */
    KANJI,        /* 0x42f7 */
    KANJI,        /* 0x42f8 */
    KANJI,        /* 0x42f9 */
    KANJI,        /* 0x42fa */
    KANJI,        /* 0x42fb */
    KANJI,        /* 0x42fc */
    KANJI,        /* 0x42fd */
    KANJI,        /* 0x42fe */
    KANJI,        /* 0x42ff */
    KANJI,        /* 0x4300 */
    KANJI,        /* 0x4301 */
    KANJI,        /* 0x4302 */
    KANJI,        /* 0x4303 */
    KANJI,        /* 0x4304 */
    KANJI,        /* 0x4305 */
    KANJI,        /* 0x4306 */
    KANJI,        /* 0x4307 */
    KANJI,        /* 0x4308 */
    KANJI,        /* 0x4309 */
    KANJI,        /* 0x430a */
    KANJI,        /* 0x430b */
    KANJI,        /* 0x430c */
    KANJI,        /* 0x430d */
    KANJI,        /* 0x430e */
    KANJI,        /* 0x430f */
    KANJI,        /* 0x4310 */
    KANJI,        /* 0x4311 */
    KANJI,        /* 0x4312 */
    KANJI,        /* 0x4313 */
    KANJI,        /* 0x4314 */
    KANJI,        /* 0x4315 */
    KANJI,        /* 0x4316 */
    KANJI,        /* 0x4317 */
    KANJI,        /* 0x4318 */
    KANJI,        /* 0x4319 */
    KANJI,        /* 0x431a */
    KANJI,        /* 0x431b */
    KANJI,        /* 0x431c */
    KANJI,        /* 0x431d */
    KANJI,        /* 0x431e */
    KANJI,        /* 0x431f */
    KANJI,        /* 0x4320 */
    KANJI,        /* 0x4321 */
    KANJI,        /* 0x4322 */
    KANJI,        /* 0x4323 */
    KANJI,        /* 0x4324 */
    KANJI,        /* 0x4325 */
    KANJI,        /* 0x4326 */
    KANJI,        /* 0x4327 */
    KANJI,        /* 0x4328 */
    KANJI,        /* 0x4329 */
    KANJI,        /* 0x432a */
    KANJI,        /* 0x432b */
    KANJI,        /* 0x432c */
    KANJI,        /* 0x432d */
    KANJI,        /* 0x432e */
    KANJI,        /* 0x432f */
    KANJI,        /* 0x4330 */
    KANJI,        /* 0x4331 */
    KANJI,        /* 0x4332 */
    KANJI,        /* 0x4333 */
    KANJI,        /* 0x4334 */
    KANJI,        /* 0x4335 */
    KANJI,        /* 0x4336 */
    KANJI,        /* 0x4337 */
    KANJI,        /* 0x4338 */
    KANJI,        /* 0x4339 */
    KANJI,        /* 0x433a */
    KANJI,        /* 0x433b */
    KANJI,        /* 0x433c */
    KANJI,        /* 0x433d */
    KANJI,        /* 0x433e */
    KANJI,        /* 0x433f */
    KANJI,        /* 0x4340 */
    KANJI,        /* 0x4341 */
    KANJI,        /* 0x4342 */
    KANJI,        /* 0x4343 */
    KANJI,        /* 0x4344 */
    KANJI,        /* 0x4345 */
    KANJI,        /* 0x4346 */
    KANJI,        /* 0x4347 */
    KANJI,        /* 0x4348 */
    KANJI,        /* 0x4349 */
    KANJI,        /* 0x434a */
    KANJI,        /* 0x434b */
    KANJI,        /* 0x434c */
    KANJI,        /* 0x434d */
    KANJI,        /* 0x434e */
    KANJI,        /* 0x434f */
    KANJI,        /* 0x4350 */
    KANJI,        /* 0x4351 */
    KANJI,        /* 0x4352 */
    KANJI,        /* 0x4353 */
    KANJI,        /* 0x4354 */
    KANJI,        /* 0x4355 */
    KANJI,        /* 0x4356 */
    KANJI,        /* 0x4357 */
    KANJI,        /* 0x4358 */
    KANJI,        /* 0x4359 */
    KANJI,        /* 0x435a */
    KANJI,        /* 0x435b */
    KANJI,        /* 0x435c */
    KANJI,        /* 0x435d */
    KANJI,        /* 0x435e */
    KANJI,        /* 0x435f */
    KANJI,        /* 0x4360 */
    KANJI,        /* 0x4361 */
    KANJI,        /* 0x4362 */
    KANJI,        /* 0x4363 */
    KANJI,        /* 0x4364 */
    KANJI,        /* 0x4365 */
    KANJI,        /* 0x4366 */
    KANJI,        /* 0x4367 */
    KANJI,        /* 0x4368 */
    KANJI,        /* 0x4369 */
    KANJI,        /* 0x436a */
    KANJI,        /* 0x436b */
    KANJI,        /* 0x436c */
    KANJI,        /* 0x436d */
    KANJI,        /* 0x436e */
    KANJI,        /* 0x436f */
    KANJI,        /* 0x4370 */
    KANJI,        /* 0x4371 */
    KANJI,        /* 0x4372 */
    KANJI,        /* 0x4373 */
    KANJI,        /* 0x4374 */
    KANJI,        /* 0x4375 */
    KANJI,        /* 0x4376 */
    KANJI,        /* 0x4377 */
    KANJI,        /* 0x4378 */
    KANJI,        /* 0x4379 */
    KANJI,        /* 0x437a */
    KANJI,        /* 0x437b */
    KANJI,        /* 0x437c */
    KANJI,        /* 0x437d */
    KANJI,        /* 0x437e */
    KANJI,        /* 0x437f */
    KANJI,        /* 0x4380 */
    KANJI,        /* 0x4381 */
    KANJI,        /* 0x4382 */
    KANJI,        /* 0x4383 */
    KANJI,        /* 0x4384 */
    KANJI,        /* 0x4385 */
    KANJI,        /* 0x4386 */
    KANJI,        /* 0x4387 */
    KANJI,        /* 0x4388 */
    KANJI,        /* 0x4389 */
    KANJI,        /* 0x438a */
    KANJI,        /* 0x438b */
    KANJI,        /* 0x438c */
    KANJI,        /* 0x438d */
    KANJI,        /* 0x438e */
    KANJI,        /* 0x438f */
    KANJI,        /* 0x4390 */
    KANJI,        /* 0x4391 */
    KANJI,        /* 0x4392 */
    KANJI,        /* 0x4393 */
    KANJI,        /* 0x4394 */
    KANJI,        /* 0x4395 */
    KANJI,        /* 0x4396 */
    KANJI,        /* 0x4397 */
    KANJI,        /* 0x4398 */
    KANJI,        /* 0x4399 */
    KANJI,        /* 0x439a */
    KANJI,        /* 0x439b */
    KANJI,        /* 0x439c */
    KANJI,        /* 0x439d */
    KANJI,        /* 0x439e */
    KANJI,        /* 0x439f */
    KANJI,        /* 0x43a0 */
    KANJI,        /* 0x43a1 */
    KANJI,        /* 0x43a2 */
    KANJI,        /* 0x43a3 */
    KANJI,        /* 0x43a4 */
    KANJI,        /* 0x43a5 */
    KANJI,        /* 0x43a6 */
    KANJI,        /* 0x43a7 */
    KANJI,        /* 0x43a8 */
    KANJI,        /* 0x43a9 */
    KANJI,        /* 0x43aa */
    KANJI,        /* 0x43ab */
    KANJI,        /* 0x43ac */
    KANJI,        /* 0x43ad */
    KANJI,        /* 0x43ae */
    KANJI,        /* 0x43af */
    KANJI,        /* 0x43b0 */
    KANJI,        /* 0x43b1 */
    KANJI,        /* 0x43b2 */
    KANJI,        /* 0x43b3 */
    KANJI,        /* 0x43b4 */
    KANJI,        /* 0x43b5 */
    KANJI,        /* 0x43b6 */
    KANJI,        /* 0x43b7 */
    KANJI,        /* 0x43b8 */
    KANJI,        /* 0x43b9 */
    KANJI,        /* 0x43ba */
    KANJI,        /* 0x43bb */
    KANJI,        /* 0x43bc */
    KANJI,        /* 0x43bd */
    KANJI,        /* 0x43be */
    KANJI,        /* 0x43bf */
    KANJI,        /* 0x43c0 */
    KANJI,        /* 0x43c1 */
    KANJI,        /* 0x43c2 */
    KANJI,        /* 0x43c3 */
    KANJI,        /* 0x43c4 */
    KANJI,        /* 0x43c5 */
    KANJI,        /* 0x43c6 */
    KANJI,        /* 0x43c7 */
    KANJI,        /* 0x43c8 */
    KANJI,        /* 0x43c9 */
    KANJI,        /* 0x43ca */
    KANJI,        /* 0x43cb */
    KANJI,        /* 0x43cc */
    KANJI,        /* 0x43cd */
    KANJI,        /* 0x43ce */
    KANJI,        /* 0x43cf */
    KANJI,        /* 0x43d0 */
    KANJI,        /* 0x43d1 */
    KANJI,        /* 0x43d2 */
    KANJI,        /* 0x43d3 */
    KANJI,        /* 0x43d4 */
    KANJI,        /* 0x43d5 */
    KANJI,        /* 0x43d6 */
    KANJI,        /* 0x43d7 */
    KANJI,        /* 0x43d8 */
    KANJI,        /* 0x43d9 */
    KANJI,        /* 0x43da */
    KANJI,        /* 0x43db */
    KANJI,        /* 0x43dc */
    KANJI,        /* 0x43dd */
    KANJI,        /* 0x43de */
    KANJI,        /* 0x43df */
    KANJI,        /* 0x43e0 */
    KANJI,        /* 0x43e1 */
    KANJI,        /* 0x43e2 */
    KANJI,        /* 0x43e3 */
    KANJI,        /* 0x43e4 */
    KANJI,        /* 0x43e5 */
    KANJI,        /* 0x43e6 */
    KANJI,        /* 0x43e7 */
    KANJI,        /* 0x43e8 */
    KANJI,        /* 0x43e9 */
    KANJI,        /* 0x43ea */
    KANJI,        /* 0x43eb */
    KANJI,        /* 0x43ec */
    KANJI,        /* 0x43ed */
    KANJI,        /* 0x43ee */
    KANJI,        /* 0x43ef */
    KANJI,        /* 0x43f0 */
    KANJI,        /* 0x43f1 */
    KANJI,        /* 0x43f2 */
    KANJI,        /* 0x43f3 */
    KANJI,        /* 0x43f4 */
    KANJI,        /* 0x43f5 */
    KANJI,        /* 0x43f6 */
    KANJI,        /* 0x43f7 */
    KANJI,        /* 0x43f8 */
    KANJI,        /* 0x43f9 */
    KANJI,        /* 0x43fa */
    KANJI,        /* 0x43fb */
    KANJI,        /* 0x43fc */
    KANJI,        /* 0x43fd */
    KANJI,        /* 0x43fe */
    KANJI,        /* 0x43ff */
    KANJI,        /* 0x4400 */
    KANJI,        /* 0x4401 */
    KANJI,        /* 0x4402 */
    KANJI,        /* 0x4403 */
    KANJI,        /* 0x4404 */
    KANJI,        /* 0x4405 */
    KANJI,        /* 0x4406 */
    KANJI,        /* 0x4407 */
    KANJI,        /* 0x4408 */
    KANJI,        /* 0x4409 */
    KANJI,        /* 0x440a */
    KANJI,        /* 0x440b */
    KANJI,        /* 0x440c */
    KANJI,        /* 0x440d */
    KANJI,        /* 0x440e */
    KANJI,        /* 0x440f */
    KANJI,        /* 0x4410 */
    KANJI,        /* 0x4411 */
    KANJI,        /* 0x4412 */
    KANJI,        /* 0x4413 */
    KANJI,        /* 0x4414 */
    KANJI,        /* 0x4415 */
    KANJI,        /* 0x4416 */
    KANJI,        /* 0x4417 */
    KANJI,        /* 0x4418 */
    KANJI,        /* 0x4419 */
    KANJI,        /* 0x441a */
    KANJI,        /* 0x441b */
    KANJI,        /* 0x441c */
    KANJI,        /* 0x441d */
    KANJI,        /* 0x441e */
    KANJI,        /* 0x441f */
    KANJI,        /* 0x4420 */
    KANJI,        /* 0x4421 */
    KANJI,        /* 0x4422 */
    KANJI,        /* 0x4423 */
    KANJI,        /* 0x4424 */
    KANJI,        /* 0x4425 */
    KANJI,        /* 0x4426 */
    KANJI,        /* 0x4427 */
    KANJI,        /* 0x4428 */
    KANJI,        /* 0x4429 */
    KANJI,        /* 0x442a */
    KANJI,        /* 0x442b */
    KANJI,        /* 0x442c */
    KANJI,        /* 0x442d */
    KANJI,        /* 0x442e */
    KANJI,        /* 0x442f */
    KANJI,        /* 0x4430 */
    KANJI,        /* 0x4431 */
    KANJI,        /* 0x4432 */
    KANJI,        /* 0x4433 */
    KANJI,        /* 0x4434 */
    KANJI,        /* 0x4435 */
    KANJI,        /* 0x4436 */
    KANJI,        /* 0x4437 */
    KANJI,        /* 0x4438 */
    KANJI,        /* 0x4439 */
    KANJI,        /* 0x443a */
    KANJI,        /* 0x443b */
    KANJI,        /* 0x443c */
    KANJI,        /* 0x443d */
    KANJI,        /* 0x443e */
    KANJI,        /* 0x443f */
    KANJI,        /* 0x4440 */
    KANJI,        /* 0x4441 */
    KANJI,        /* 0x4442 */
    KANJI,        /* 0x4443 */
    KANJI,        /* 0x4444 */
    KANJI,        /* 0x4445 */
    KANJI,        /* 0x4446 */
    KANJI,        /* 0x4447 */
    KANJI,        /* 0x4448 */
    KANJI,        /* 0x4449 */
    KANJI,        /* 0x444a */
    KANJI,        /* 0x444b */
    KANJI,        /* 0x444c */
    KANJI,        /* 0x444d */
    KANJI,        /* 0x444e */
    KANJI,        /* 0x444f */
    KANJI,        /* 0x4450 */
    KANJI,        /* 0x4451 */
    KANJI,        /* 0x4452 */
    KANJI,        /* 0x4453 */
    KANJI,        /* 0x4454 */
    KANJI,        /* 0x4455 */
    KANJI,        /* 0x4456 */
    KANJI,        /* 0x4457 */
    KANJI,        /* 0x4458 */
    KANJI,        /* 0x4459 */
    KANJI,        /* 0x445a */
    KANJI,        /* 0x445b */
    KANJI,        /* 0x445c */
    KANJI,        /* 0x445d */
    KANJI,        /* 0x445e */
    KANJI,        /* 0x445f */
    KANJI,        /* 0x4460 */
    KANJI,        /* 0x4461 */
    KANJI,        /* 0x4462 */
    KANJI,        /* 0x4463 */
    KANJI,        /* 0x4464 */
    KANJI,        /* 0x4465 */
    KANJI,        /* 0x4466 */
    KANJI,        /* 0x4467 */
    KANJI,        /* 0x4468 */
    KANJI,        /* 0x4469 */
    KANJI,        /* 0x446a */
    KANJI,        /* 0x446b */
    KANJI,        /* 0x446c */
    KANJI,        /* 0x446d */
    KANJI,        /* 0x446e */
    KANJI,        /* 0x446f */
    KANJI,        /* 0x4470 */
    KANJI,        /* 0x4471 */
    KANJI,        /* 0x4472 */
    KANJI,        /* 0x4473 */
    KANJI,        /* 0x4474 */
    KANJI,        /* 0x4475 */
    KANJI,        /* 0x4476 */
    KANJI,        /* 0x4477 */
    KANJI,        /* 0x4478 */
    KANJI,        /* 0x4479 */
    KANJI,        /* 0x447a */
    KANJI,        /* 0x447b */
    KANJI,        /* 0x447c */
    KANJI,        /* 0x447d */
    KANJI,        /* 0x447e */
    KANJI,        /* 0x447f */
    KANJI,        /* 0x4480 */
    KANJI,        /* 0x4481 */
    KANJI,        /* 0x4482 */
    KANJI,        /* 0x4483 */
    KANJI,        /* 0x4484 */
    KANJI,        /* 0x4485 */
    KANJI,        /* 0x4486 */
    KANJI,        /* 0x4487 */
    KANJI,        /* 0x4488 */
    KANJI,        /* 0x4489 */
    KANJI,        /* 0x448a */
    KANJI,        /* 0x448b */
    KANJI,        /* 0x448c */
    KANJI,        /* 0x448d */
    KANJI,        /* 0x448e */
    KANJI,        /* 0x448f */
    KANJI,        /* 0x4490 */
    KANJI,        /* 0x4491 */
    KANJI,        /* 0x4492 */
    KANJI,        /* 0x4493 */
    KANJI,        /* 0x4494 */
    KANJI,        /* 0x4495 */
    KANJI,        /* 0x4496 */
    KANJI,        /* 0x4497 */
    KANJI,        /* 0x4498 */
    KANJI,        /* 0x4499 */
    KANJI,        /* 0x449a */
    KANJI,        /* 0x449b */
    KANJI,        /* 0x449c */
    KANJI,        /* 0x449d */
    KANJI,        /* 0x449e */
    KANJI,        /* 0x449f */
    KANJI,        /* 0x44a0 */
    KANJI,        /* 0x44a1 */
    KANJI,        /* 0x44a2 */
    KANJI,        /* 0x44a3 */
    KANJI,        /* 0x44a4 */
    KANJI,        /* 0x44a5 */
    KANJI,        /* 0x44a6 */
    KANJI,        /* 0x44a7 */
    KANJI,        /* 0x44a8 */
    KANJI,        /* 0x44a9 */
    KANJI,        /* 0x44aa */
    KANJI,        /* 0x44ab */
    KANJI,        /* 0x44ac */
    KANJI,        /* 0x44ad */
    KANJI,        /* 0x44ae */
    KANJI,        /* 0x44af */
    KANJI,        /* 0x44b0 */
    KANJI,        /* 0x44b1 */
    KANJI,        /* 0x44b2 */
    KANJI,        /* 0x44b3 */
    KANJI,        /* 0x44b4 */
    KANJI,        /* 0x44b5 */
    KANJI,        /* 0x44b6 */
    KANJI,        /* 0x44b7 */
    KANJI,        /* 0x44b8 */
    KANJI,        /* 0x44b9 */
    KANJI,        /* 0x44ba */
    KANJI,        /* 0x44bb */
    KANJI,        /* 0x44bc */
    KANJI,        /* 0x44bd */
    KANJI,        /* 0x44be */
    KANJI,        /* 0x44bf */
    KANJI,        /* 0x44c0 */
    KANJI,        /* 0x44c1 */
    KANJI,        /* 0x44c2 */
    KANJI,        /* 0x44c3 */
    KANJI,        /* 0x44c4 */
    KANJI,        /* 0x44c5 */
    KANJI,        /* 0x44c6 */
    KANJI,        /* 0x44c7 */
    KANJI,        /* 0x44c8 */
    KANJI,        /* 0x44c9 */
    KANJI,        /* 0x44ca */
    KANJI,        /* 0x44cb */
    KANJI,        /* 0x44cc */
    KANJI,        /* 0x44cd */
    KANJI,        /* 0x44ce */
    KANJI,        /* 0x44cf */
    KANJI,        /* 0x44d0 */
    KANJI,        /* 0x44d1 */
    KANJI,        /* 0x44d2 */
    KANJI,        /* 0x44d3 */
    KANJI,        /* 0x44d4 */
    KANJI,        /* 0x44d5 */
    KANJI,        /* 0x44d6 */
    KANJI,        /* 0x44d7 */
    KANJI,        /* 0x44d8 */
    KANJI,        /* 0x44d9 */
    KANJI,        /* 0x44da */
    KANJI,        /* 0x44db */
    KANJI,        /* 0x44dc */
    KANJI,        /* 0x44dd */
    KANJI,        /* 0x44de */
    KANJI,        /* 0x44df */
    KANJI,        /* 0x44e0 */
    KANJI,        /* 0x44e1 */
    KANJI,        /* 0x44e2 */
    KANJI,        /* 0x44e3 */
    KANJI,        /* 0x44e4 */
    KANJI,        /* 0x44e5 */
    KANJI,        /* 0x44e6 */
    KANJI,        /* 0x44e7 */
    KANJI,        /* 0x44e8 */
    KANJI,        /* 0x44e9 */
    KANJI,        /* 0x44ea */
    KANJI,        /* 0x44eb */
    KANJI,        /* 0x44ec */
    KANJI,        /* 0x44ed */
    KANJI,        /* 0x44ee */
    KANJI,        /* 0x44ef */
    KANJI,        /* 0x44f0 */
    KANJI,        /* 0x44f1 */
    KANJI,        /* 0x44f2 */
    KANJI,        /* 0x44f3 */
    KANJI,        /* 0x44f4 */
    KANJI,        /* 0x44f5 */
    KANJI,        /* 0x44f6 */
    KANJI,        /* 0x44f7 */
    KANJI,        /* 0x44f8 */
    KANJI,        /* 0x44f9 */
    KANJI,        /* 0x44fa */
    KANJI,        /* 0x44fb */
    KANJI,        /* 0x44fc */
    KANJI,        /* 0x44fd */
    KANJI,        /* 0x44fe */
    KANJI,        /* 0x44ff */
    KANJI,        /* 0x4500 */
    KANJI,        /* 0x4501 */
    KANJI,        /* 0x4502 */
    KANJI,        /* 0x4503 */
    KANJI,        /* 0x4504 */
    KANJI,        /* 0x4505 */
    KANJI,        /* 0x4506 */
    KANJI,        /* 0x4507 */
    KANJI,        /* 0x4508 */
    KANJI,        /* 0x4509 */
    KANJI,        /* 0x450a */
    KANJI,        /* 0x450b */
    KANJI,        /* 0x450c */
    KANJI,        /* 0x450d */
    KANJI,        /* 0x450e */
    KANJI,        /* 0x450f */
    KANJI,        /* 0x4510 */
    KANJI,        /* 0x4511 */
    KANJI,        /* 0x4512 */
    KANJI,        /* 0x4513 */
    KANJI,        /* 0x4514 */
    KANJI,        /* 0x4515 */
    KANJI,        /* 0x4516 */
    KANJI,        /* 0x4517 */
    KANJI,        /* 0x4518 */
    KANJI,        /* 0x4519 */
    KANJI,        /* 0x451a */
    KANJI,        /* 0x451b */
    KANJI,        /* 0x451c */
    KANJI,        /* 0x451d */
    KANJI,        /* 0x451e */
    KANJI,        /* 0x451f */
    KANJI,        /* 0x4520 */
    KANJI,        /* 0x4521 */
    KANJI,        /* 0x4522 */
    KANJI,        /* 0x4523 */
    KANJI,        /* 0x4524 */
    KANJI,        /* 0x4525 */
    KANJI,        /* 0x4526 */
    KANJI,        /* 0x4527 */
    KANJI,        /* 0x4528 */
    KANJI,        /* 0x4529 */
    KANJI,        /* 0x452a */
    KANJI,        /* 0x452b */
    KANJI,        /* 0x452c */
    KANJI,        /* 0x452d */
    KANJI,        /* 0x452e */
    KANJI,        /* 0x452f */
    KANJI,        /* 0x4530 */
    KANJI,        /* 0x4531 */
    KANJI,        /* 0x4532 */
    KANJI,        /* 0x4533 */
    KANJI,        /* 0x4534 */
    KANJI,        /* 0x4535 */
    KANJI,        /* 0x4536 */
    KANJI,        /* 0x4537 */
    KANJI,        /* 0x4538 */
    KANJI,        /* 0x4539 */
    KANJI,        /* 0x453a */
    KANJI,        /* 0x453b */
    KANJI,        /* 0x453c */
    KANJI,        /* 0x453d */
    KANJI,        /* 0x453e */
    KANJI,        /* 0x453f */
    KANJI,        /* 0x4540 */
    KANJI,        /* 0x4541 */
    KANJI,        /* 0x4542 */
    KANJI,        /* 0x4543 */
    KANJI,        /* 0x4544 */
    KANJI,        /* 0x4545 */
    KANJI,        /* 0x4546 */
    KANJI,        /* 0x4547 */
    KANJI,        /* 0x4548 */
    KANJI,        /* 0x4549 */
    KANJI,        /* 0x454a */
    KANJI,        /* 0x454b */
    KANJI,        /* 0x454c */
    KANJI,        /* 0x454d */
    KANJI,        /* 0x454e */
    KANJI,        /* 0x454f */
    KANJI,        /* 0x4550 */
    KANJI,        /* 0x4551 */
    KANJI,        /* 0x4552 */
    KANJI,        /* 0x4553 */
    KANJI,        /* 0x4554 */
    KANJI,        /* 0x4555 */
    KANJI,        /* 0x4556 */
    KANJI,        /* 0x4557 */
    KANJI,        /* 0x4558 */
    KANJI,        /* 0x4559 */
    KANJI,        /* 0x455a */
    KANJI,        /* 0x455b */
    KANJI,        /* 0x455c */
    KANJI,        /* 0x455d */
    KANJI,        /* 0x455e */
    KANJI,        /* 0x455f */
    KANJI,        /* 0x4560 */
    KANJI,        /* 0x4561 */
    KANJI,        /* 0x4562 */
    KANJI,        /* 0x4563 */
    KANJI,        /* 0x4564 */
    KANJI,        /* 0x4565 */
    KANJI,        /* 0x4566 */
    KANJI,        /* 0x4567 */
    KANJI,        /* 0x4568 */
    KANJI,        /* 0x4569 */
    KANJI,        /* 0x456a */
    KANJI,        /* 0x456b */
    KANJI,        /* 0x456c */
    KANJI,        /* 0x456d */
    KANJI,        /* 0x456e */
    KANJI,        /* 0x456f */
    KANJI,        /* 0x4570 */
    KANJI,        /* 0x4571 */
    KANJI,        /* 0x4572 */
    KANJI,        /* 0x4573 */
    KANJI,        /* 0x4574 */
    KANJI,        /* 0x4575 */
    KANJI,        /* 0x4576 */
    KANJI,        /* 0x4577 */
    KANJI,        /* 0x4578 */
    KANJI,        /* 0x4579 */
    KANJI,        /* 0x457a */
    KANJI,        /* 0x457b */
    KANJI,        /* 0x457c */
    KANJI,        /* 0x457d */
    KANJI,        /* 0x457e */
    KANJI,        /* 0x457f */
    KANJI,        /* 0x4580 */
    KANJI,        /* 0x4581 */
    KANJI,        /* 0x4582 */
    KANJI,        /* 0x4583 */
    KANJI,        /* 0x4584 */
    KANJI,        /* 0x4585 */
    KANJI,        /* 0x4586 */
    KANJI,        /* 0x4587 */
    KANJI,        /* 0x4588 */
    KANJI,        /* 0x4589 */
    KANJI,        /* 0x458a */
    KANJI,        /* 0x458b */
    KANJI,        /* 0x458c */
    KANJI,        /* 0x458d */
    KANJI,        /* 0x458e */
    KANJI,        /* 0x458f */
    KANJI,        /* 0x4590 */
    KANJI,        /* 0x4591 */
    KANJI,        /* 0x4592 */
    KANJI,        /* 0x4593 */
    KANJI,        /* 0x4594 */
    KANJI,        /* 0x4595 */
    KANJI,        /* 0x4596 */
    KANJI,        /* 0x4597 */
    KANJI,        /* 0x4598 */
    KANJI,        /* 0x4599 */
    KANJI,        /* 0x459a */
    KANJI,        /* 0x459b */
    KANJI,        /* 0x459c */
    KANJI,        /* 0x459d */
    KANJI,        /* 0x459e */
    KANJI,        /* 0x459f */
    KANJI,        /* 0x45a0 */
    KANJI,        /* 0x45a1 */
    KANJI,        /* 0x45a2 */
    KANJI,        /* 0x45a3 */
    KANJI,        /* 0x45a4 */
    KANJI,        /* 0x45a5 */
    KANJI,        /* 0x45a6 */
    KANJI,        /* 0x45a7 */
    KANJI,        /* 0x45a8 */
    KANJI,        /* 0x45a9 */
    KANJI,        /* 0x45aa */
    KANJI,        /* 0x45ab */
    KANJI,        /* 0x45ac */
    KANJI,        /* 0x45ad */
    KANJI,        /* 0x45ae */
    KANJI,        /* 0x45af */
    KANJI,        /* 0x45b0 */
    KANJI,        /* 0x45b1 */
    KANJI,        /* 0x45b2 */
    KANJI,        /* 0x45b3 */
    KANJI,        /* 0x45b4 */
    KANJI,        /* 0x45b5 */
    KANJI,        /* 0x45b6 */
    KANJI,        /* 0x45b7 */
    KANJI,        /* 0x45b8 */
    KANJI,        /* 0x45b9 */
    KANJI,        /* 0x45ba */
    KANJI,        /* 0x45bb */
    KANJI,        /* 0x45bc */
    KANJI,        /* 0x45bd */
    KANJI,        /* 0x45be */
    KANJI,        /* 0x45bf */
    KANJI,        /* 0x45c0 */
    KANJI,        /* 0x45c1 */
    KANJI,        /* 0x45c2 */
    KANJI,        /* 0x45c3 */
    KANJI,        /* 0x45c4 */
    KANJI,        /* 0x45c5 */
    KANJI,        /* 0x45c6 */
    KANJI,        /* 0x45c7 */
    KANJI,        /* 0x45c8 */
    KANJI,        /* 0x45c9 */
    KANJI,        /* 0x45ca */
    KANJI,        /* 0x45cb */
    KANJI,        /* 0x45cc */
    KANJI,        /* 0x45cd */
    KANJI,        /* 0x45ce */
    KANJI,        /* 0x45cf */
    KANJI,        /* 0x45d0 */
    KANJI,        /* 0x45d1 */
    KANJI,        /* 0x45d2 */
    KANJI,        /* 0x45d3 */
    KANJI,        /* 0x45d4 */
    KANJI,        /* 0x45d5 */
    KANJI,        /* 0x45d6 */
    KANJI,        /* 0x45d7 */
    KANJI,        /* 0x45d8 */
    KANJI,        /* 0x45d9 */
    KANJI,        /* 0x45da */
    KANJI,        /* 0x45db */
    KANJI,        /* 0x45dc */
    KANJI,        /* 0x45dd */
    KANJI,        /* 0x45de */
    KANJI,        /* 0x45df */
    KANJI,        /* 0x45e0 */
    KANJI,        /* 0x45e1 */
    KANJI,        /* 0x45e2 */
    KANJI,        /* 0x45e3 */
    KANJI,        /* 0x45e4 */
    KANJI,        /* 0x45e5 */
    KANJI,        /* 0x45e6 */
    KANJI,        /* 0x45e7 */
    KANJI,        /* 0x45e8 */
    KANJI,        /* 0x45e9 */
    KANJI,        /* 0x45ea */
    KANJI,        /* 0x45eb */
    KANJI,        /* 0x45ec */
    KANJI,        /* 0x45ed */
    KANJI,        /* 0x45ee */
    KANJI,        /* 0x45ef */
    KANJI,        /* 0x45f0 */
    KANJI,        /* 0x45f1 */
    KANJI,        /* 0x45f2 */
    KANJI,        /* 0x45f3 */
    KANJI,        /* 0x45f4 */
    KANJI,        /* 0x45f5 */
    KANJI,        /* 0x45f6 */
    KANJI,        /* 0x45f7 */
    KANJI,        /* 0x45f8 */
    KANJI,        /* 0x45f9 */
    KANJI,        /* 0x45fa */
    KANJI,        /* 0x45fb */
    KANJI,        /* 0x45fc */
    KANJI,        /* 0x45fd */
    KANJI,        /* 0x45fe */
    KANJI,        /* 0x45ff */
    KANJI,        /* 0x4600 */
    KANJI,        /* 0x4601 */
    KANJI,        /* 0x4602 */
    KANJI,        /* 0x4603 */
    KANJI,        /* 0x4604 */
    KANJI,        /* 0x4605 */
    KANJI,        /* 0x4606 */
    KANJI,        /* 0x4607 */
    KANJI,        /* 0x4608 */
    KANJI,        /* 0x4609 */
    KANJI,        /* 0x460a */
    KANJI,        /* 0x460b */
    KANJI,        /* 0x460c */
    KANJI,        /* 0x460d */
    KANJI,        /* 0x460e */
    KANJI,        /* 0x460f */
    KANJI,        /* 0x4610 */
    KANJI,        /* 0x4611 */
    KANJI,        /* 0x4612 */
    KANJI,        /* 0x4613 */
    KANJI,        /* 0x4614 */
    KANJI,        /* 0x4615 */
    KANJI,        /* 0x4616 */
    KANJI,        /* 0x4617 */
    KANJI,        /* 0x4618 */
    KANJI,        /* 0x4619 */
    KANJI,        /* 0x461a */
    KANJI,        /* 0x461b */
    KANJI,        /* 0x461c */
    KANJI,        /* 0x461d */
    KANJI,        /* 0x461e */
    KANJI,        /* 0x461f */
    KANJI,        /* 0x4620 */
    KANJI,        /* 0x4621 */
    KANJI,        /* 0x4622 */
    KANJI,        /* 0x4623 */
    KANJI,        /* 0x4624 */
    KANJI,        /* 0x4625 */
    KANJI,        /* 0x4626 */
    KANJI,        /* 0x4627 */
    KANJI,        /* 0x4628 */
    KANJI,        /* 0x4629 */
    KANJI,        /* 0x462a */
    KANJI,        /* 0x462b */
    KANJI,        /* 0x462c */
    KANJI,        /* 0x462d */
    KANJI,        /* 0x462e */
    KANJI,        /* 0x462f */
    KANJI,        /* 0x4630 */
    KANJI,        /* 0x4631 */
    KANJI,        /* 0x4632 */
    KANJI,        /* 0x4633 */
    KANJI,        /* 0x4634 */
    KANJI,        /* 0x4635 */
    KANJI,        /* 0x4636 */
    KANJI,        /* 0x4637 */
    KANJI,        /* 0x4638 */
    KANJI,        /* 0x4639 */
    KANJI,        /* 0x463a */
    KANJI,        /* 0x463b */
    KANJI,        /* 0x463c */
    KANJI,        /* 0x463d */
    KANJI,        /* 0x463e */
    KANJI,        /* 0x463f */
    KANJI,        /* 0x4640 */
    KANJI,        /* 0x4641 */
    KANJI,        /* 0x4642 */
    KANJI,        /* 0x4643 */
    KANJI,        /* 0x4644 */
    KANJI,        /* 0x4645 */
    KANJI,        /* 0x4646 */
    KANJI,        /* 0x4647 */
    KANJI,        /* 0x4648 */
    KANJI,        /* 0x4649 */
    KANJI,        /* 0x464a */
    KANJI,        /* 0x464b */
    KANJI,        /* 0x464c */
    KANJI,        /* 0x464d */
    KANJI,        /* 0x464e */
    KANJI,        /* 0x464f */
    KANJI,        /* 0x4650 */
    KANJI,        /* 0x4651 */
    KANJI,        /* 0x4652 */
    KANJI,        /* 0x4653 */
    KANJI,        /* 0x4654 */
    KANJI,        /* 0x4655 */
    KANJI,        /* 0x4656 */
    KANJI,        /* 0x4657 */
    KANJI,        /* 0x4658 */
    KANJI,        /* 0x4659 */
    KANJI,        /* 0x465a */
    KANJI,        /* 0x465b */
    KANJI,        /* 0x465c */
    KANJI,        /* 0x465d */
    KANJI,        /* 0x465e */
    KANJI,        /* 0x465f */
    KANJI,        /* 0x4660 */
    KANJI,        /* 0x4661 */
    KANJI,        /* 0x4662 */
    KANJI,        /* 0x4663 */
    KANJI,        /* 0x4664 */
    KANJI,        /* 0x4665 */
    KANJI,        /* 0x4666 */
    KANJI,        /* 0x4667 */
    KANJI,        /* 0x4668 */
    KANJI,        /* 0x4669 */
    KANJI,        /* 0x466a */
    KANJI,        /* 0x466b */
    KANJI,        /* 0x466c */
    KANJI,        /* 0x466d */
    KANJI,        /* 0x466e */
    KANJI,        /* 0x466f */
    KANJI,        /* 0x4670 */
    KANJI,        /* 0x4671 */
    KANJI,        /* 0x4672 */
    KANJI,        /* 0x4673 */
    KANJI,        /* 0x4674 */
    KANJI,        /* 0x4675 */
    KANJI,        /* 0x4676 */
    KANJI,        /* 0x4677 */
    KANJI,        /* 0x4678 */
    KANJI,        /* 0x4679 */
    KANJI,        /* 0x467a */
    KANJI,        /* 0x467b */
    KANJI,        /* 0x467c */
    KANJI,        /* 0x467d */
    KANJI,        /* 0x467e */
    KANJI,        /* 0x467f */
    KANJI,        /* 0x4680 */
    KANJI,        /* 0x4681 */
    KANJI,        /* 0x4682 */
    KANJI,        /* 0x4683 */
    KANJI,        /* 0x4684 */
    KANJI,        /* 0x4685 */
    KANJI,        /* 0x4686 */
    KANJI,        /* 0x4687 */
    KANJI,        /* 0x4688 */
    KANJI,        /* 0x4689 */
    KANJI,        /* 0x468a */
    KANJI,        /* 0x468b */
    KANJI,        /* 0x468c */
    KANJI,        /* 0x468d */
    KANJI,        /* 0x468e */
    KANJI,        /* 0x468f */
    KANJI,        /* 0x4690 */
    KANJI,        /* 0x4691 */
    KANJI,        /* 0x4692 */
    KANJI,        /* 0x4693 */
    KANJI,        /* 0x4694 */
    KANJI,        /* 0x4695 */
    KANJI,        /* 0x4696 */
    KANJI,        /* 0x4697 */
    KANJI,        /* 0x4698 */
    KANJI,        /* 0x4699 */
    KANJI,        /* 0x469a */
    KANJI,        /* 0x469b */
    KANJI,        /* 0x469c */
    KANJI,        /* 0x469d */
    KANJI,        /* 0x469e */
    KANJI,        /* 0x469f */
    KANJI,        /* 0x46a0 */
    KANJI,        /* 0x46a1 */
    KANJI,        /* 0x46a2 */
    KANJI,        /* 0x46a3 */
    KANJI,        /* 0x46a4 */
    KANJI,        /* 0x46a5 */
    KANJI,        /* 0x46a6 */
    KANJI,        /* 0x46a7 */
    KANJI,        /* 0x46a8 */
    KANJI,        /* 0x46a9 */
    KANJI,        /* 0x46aa */
    KANJI,        /* 0x46ab */
    KANJI,        /* 0x46ac */
    KANJI,        /* 0x46ad */
    KANJI,        /* 0x46ae */
    KANJI,        /* 0x46af */
    KANJI,        /* 0x46b0 */
    KANJI,        /* 0x46b1 */
    KANJI,        /* 0x46b2 */
    KANJI,        /* 0x46b3 */
    KANJI,        /* 0x46b4 */
    KANJI,        /* 0x46b5 */
    KANJI,        /* 0x46b6 */
    KANJI,        /* 0x46b7 */
    KANJI,        /* 0x46b8 */
    KANJI,        /* 0x46b9 */
    KANJI,        /* 0x46ba */
    KANJI,        /* 0x46bb */
    KANJI,        /* 0x46bc */
    KANJI,        /* 0x46bd */
    KANJI,        /* 0x46be */
    KANJI,        /* 0x46bf */
    KANJI,        /* 0x46c0 */
    KANJI,        /* 0x46c1 */
    KANJI,        /* 0x46c2 */
    KANJI,        /* 0x46c3 */
    KANJI,        /* 0x46c4 */
    KANJI,        /* 0x46c5 */
    KANJI,        /* 0x46c6 */
    KANJI,        /* 0x46c7 */
    KANJI,        /* 0x46c8 */
    KANJI,        /* 0x46c9 */
    KANJI,        /* 0x46ca */
    KANJI,        /* 0x46cb */
    KANJI,        /* 0x46cc */
    KANJI,        /* 0x46cd */
    KANJI,        /* 0x46ce */
    KANJI,        /* 0x46cf */
    KANJI,        /* 0x46d0 */
    KANJI,        /* 0x46d1 */
    KANJI,        /* 0x46d2 */
    KANJI,        /* 0x46d3 */
    KANJI,        /* 0x46d4 */
    KANJI,        /* 0x46d5 */
    KANJI,        /* 0x46d6 */
    KANJI,        /* 0x46d7 */
    KANJI,        /* 0x46d8 */
    KANJI,        /* 0x46d9 */
    KANJI,        /* 0x46da */
    KANJI,        /* 0x46db */
    KANJI,        /* 0x46dc */
    KANJI,        /* 0x46dd */
    KANJI,        /* 0x46de */
    KANJI,        /* 0x46df */
    KANJI,        /* 0x46e0 */
    KANJI,        /* 0x46e1 */
    KANJI,        /* 0x46e2 */
    KANJI,        /* 0x46e3 */
    KANJI,        /* 0x46e4 */
    KANJI,        /* 0x46e5 */
    KANJI,        /* 0x46e6 */
    KANJI,        /* 0x46e7 */
    KANJI,        /* 0x46e8 */
    KANJI,        /* 0x46e9 */
    KANJI,        /* 0x46ea */
    KANJI,        /* 0x46eb */
    KANJI,        /* 0x46ec */
    KANJI,        /* 0x46ed */
    KANJI,        /* 0x46ee */
    KANJI,        /* 0x46ef */
    KANJI,        /* 0x46f0 */
    KANJI,        /* 0x46f1 */
    KANJI,        /* 0x46f2 */
    KANJI,        /* 0x46f3 */
    KANJI,        /* 0x46f4 */
    KANJI,        /* 0x46f5 */
    KANJI,        /* 0x46f6 */
    KANJI,        /* 0x46f7 */
    KANJI,        /* 0x46f8 */
    KANJI,        /* 0x46f9 */
    KANJI,        /* 0x46fa */
    KANJI,        /* 0x46fb */
    KANJI,        /* 0x46fc */
    KANJI,        /* 0x46fd */
    KANJI,        /* 0x46fe */
    KANJI,        /* 0x46ff */
    KANJI,        /* 0x4700 */
    KANJI,        /* 0x4701 */
    KANJI,        /* 0x4702 */
    KANJI,        /* 0x4703 */
    KANJI,        /* 0x4704 */
    KANJI,        /* 0x4705 */
    KANJI,        /* 0x4706 */
    KANJI,        /* 0x4707 */
    KANJI,        /* 0x4708 */
    KANJI,        /* 0x4709 */
    KANJI,        /* 0x470a */
    KANJI,        /* 0x470b */
    KANJI,        /* 0x470c */
    KANJI,        /* 0x470d */
    KANJI,        /* 0x470e */
    KANJI,        /* 0x470f */
    KANJI,        /* 0x4710 */
    KANJI,        /* 0x4711 */
    KANJI,        /* 0x4712 */
    KANJI,        /* 0x4713 */
    KANJI,        /* 0x4714 */
    KANJI,        /* 0x4715 */
    KANJI,        /* 0x4716 */
    KANJI,        /* 0x4717 */
    KANJI,        /* 0x4718 */
    KANJI,        /* 0x4719 */
    KANJI,        /* 0x471a */
    KANJI,        /* 0x471b */
    KANJI,        /* 0x471c */
    KANJI,        /* 0x471d */
    KANJI,        /* 0x471e */
    KANJI,        /* 0x471f */
    KANJI,        /* 0x4720 */
    KANJI,        /* 0x4721 */
    KANJI,        /* 0x4722 */
    KANJI,        /* 0x4723 */
    KANJI,        /* 0x4724 */
    KANJI,        /* 0x4725 */
    KANJI,        /* 0x4726 */
    KANJI,        /* 0x4727 */
    KANJI,        /* 0x4728 */
    KANJI,        /* 0x4729 */
    KANJI,        /* 0x472a */
    KANJI,        /* 0x472b */
    KANJI,        /* 0x472c */
    KANJI,        /* 0x472d */
    KANJI,        /* 0x472e */
    KANJI,        /* 0x472f */
    KANJI,        /* 0x4730 */
    KANJI,        /* 0x4731 */
    KANJI,        /* 0x4732 */
    KANJI,        /* 0x4733 */
    KANJI,        /* 0x4734 */
    KANJI,        /* 0x4735 */
    KANJI,        /* 0x4736 */
    KANJI,        /* 0x4737 */
    KANJI,        /* 0x4738 */
    KANJI,        /* 0x4739 */
    KANJI,        /* 0x473a */
    KANJI,        /* 0x473b */
    KANJI,        /* 0x473c */
    KANJI,        /* 0x473d */
    KANJI,        /* 0x473e */
    KANJI,        /* 0x473f */
    KANJI,        /* 0x4740 */
    KANJI,        /* 0x4741 */
    KANJI,        /* 0x4742 */
    KANJI,        /* 0x4743 */
    KANJI,        /* 0x4744 */
    KANJI,        /* 0x4745 */
    KANJI,        /* 0x4746 */
    KANJI,        /* 0x4747 */
    KANJI,        /* 0x4748 */
    KANJI,        /* 0x4749 */
    KANJI,        /* 0x474a */
    KANJI,        /* 0x474b */
    KANJI,        /* 0x474c */
    KANJI,        /* 0x474d */
    KANJI,        /* 0x474e */
    KANJI,        /* 0x474f */
    KANJI,        /* 0x4750 */
    KANJI,        /* 0x4751 */
    KANJI,        /* 0x4752 */
    KANJI,        /* 0x4753 */
    KANJI,        /* 0x4754 */
    KANJI,        /* 0x4755 */
    KANJI,        /* 0x4756 */
    KANJI,        /* 0x4757 */
    KANJI,        /* 0x4758 */
    KANJI,        /* 0x4759 */
    KANJI,        /* 0x475a */
    KANJI,        /* 0x475b */
    KANJI,        /* 0x475c */
    KANJI,        /* 0x475d */
    KANJI,        /* 0x475e */
    KANJI,        /* 0x475f */
    KANJI,        /* 0x4760 */
    KANJI,        /* 0x4761 */
    KANJI,        /* 0x4762 */
    KANJI,        /* 0x4763 */
    KANJI,        /* 0x4764 */
    KANJI,        /* 0x4765 */
    KANJI,        /* 0x4766 */
    KANJI,        /* 0x4767 */
    KANJI,        /* 0x4768 */
    KANJI,        /* 0x4769 */
    KANJI,        /* 0x476a */
    KANJI,        /* 0x476b */
    KANJI,        /* 0x476c */
    KANJI,        /* 0x476d */
    KANJI,        /* 0x476e */
    KANJI,        /* 0x476f */
    KANJI,        /* 0x4770 */
    KANJI,        /* 0x4771 */
    KANJI,        /* 0x4772 */
    KANJI,        /* 0x4773 */
    KANJI,        /* 0x4774 */
    KANJI,        /* 0x4775 */
    KANJI,        /* 0x4776 */
    KANJI,        /* 0x4777 */
    KANJI,        /* 0x4778 */
    KANJI,        /* 0x4779 */
    KANJI,        /* 0x477a */
    KANJI,        /* 0x477b */
    KANJI,        /* 0x477c */
    KANJI,        /* 0x477d */
    KANJI,        /* 0x477e */
    KANJI,        /* 0x477f */
    KANJI,        /* 0x4780 */
    KANJI,        /* 0x4781 */
    KANJI,        /* 0x4782 */
    KANJI,        /* 0x4783 */
    KANJI,        /* 0x4784 */
    KANJI,        /* 0x4785 */
    KANJI,        /* 0x4786 */
    KANJI,        /* 0x4787 */
    KANJI,        /* 0x4788 */
    KANJI,        /* 0x4789 */
    KANJI,        /* 0x478a */
    KANJI,        /* 0x478b */
    KANJI,        /* 0x478c */
    KANJI,        /* 0x478d */
    KANJI,        /* 0x478e */
    KANJI,        /* 0x478f */
    KANJI,        /* 0x4790 */
    KANJI,        /* 0x4791 */
    KANJI,        /* 0x4792 */
    KANJI,        /* 0x4793 */
    KANJI,        /* 0x4794 */
    KANJI,        /* 0x4795 */
    KANJI,        /* 0x4796 */
    KANJI,        /* 0x4797 */
    KANJI,        /* 0x4798 */
    KANJI,        /* 0x4799 */
    KANJI,        /* 0x479a */
    KANJI,        /* 0x479b */
    KANJI,        /* 0x479c */
    KANJI,        /* 0x479d */
    KANJI,        /* 0x479e */
    KANJI,        /* 0x479f */
    KANJI,        /* 0x47a0 */
    KANJI,        /* 0x47a1 */
    KANJI,        /* 0x47a2 */
    KANJI,        /* 0x47a3 */
    KANJI,        /* 0x47a4 */
    KANJI,        /* 0x47a5 */
    KANJI,        /* 0x47a6 */
    KANJI,        /* 0x47a7 */
    KANJI,        /* 0x47a8 */
    KANJI,        /* 0x47a9 */
    KANJI,        /* 0x47aa */
    KANJI,        /* 0x47ab */
    KANJI,        /* 0x47ac */
    KANJI,        /* 0x47ad */
    KANJI,        /* 0x47ae */
    KANJI,        /* 0x47af */
    KANJI,        /* 0x47b0 */
    KANJI,        /* 0x47b1 */
    KANJI,        /* 0x47b2 */
    KANJI,        /* 0x47b3 */
    KANJI,        /* 0x47b4 */
    KANJI,        /* 0x47b5 */
    KANJI,        /* 0x47b6 */
    KANJI,        /* 0x47b7 */
    KANJI,        /* 0x47b8 */
    KANJI,        /* 0x47b9 */
    KANJI,        /* 0x47ba */
    KANJI,        /* 0x47bb */
    KANJI,        /* 0x47bc */
    KANJI,        /* 0x47bd */
    KANJI,        /* 0x47be */
    KANJI,        /* 0x47bf */
    KANJI,        /* 0x47c0 */
    KANJI,        /* 0x47c1 */
    KANJI,        /* 0x47c2 */
    KANJI,        /* 0x47c3 */
    KANJI,        /* 0x47c4 */
    KANJI,        /* 0x47c5 */
    KANJI,        /* 0x47c6 */
    KANJI,        /* 0x47c7 */
    KANJI,        /* 0x47c8 */
    KANJI,        /* 0x47c9 */
    KANJI,        /* 0x47ca */
    KANJI,        /* 0x47cb */
    KANJI,        /* 0x47cc */
    KANJI,        /* 0x47cd */
    KANJI,        /* 0x47ce */
    KANJI,        /* 0x47cf */
    KANJI,        /* 0x47d0 */
    KANJI,        /* 0x47d1 */
    KANJI,        /* 0x47d2 */
    KANJI,        /* 0x47d3 */
    KANJI,        /* 0x47d4 */
    KANJI,        /* 0x47d5 */
    KANJI,        /* 0x47d6 */
    KANJI,        /* 0x47d7 */
    KANJI,        /* 0x47d8 */
    KANJI,        /* 0x47d9 */
    KANJI,        /* 0x47da */
    KANJI,        /* 0x47db */
    KANJI,        /* 0x47dc */
    KANJI,        /* 0x47dd */
    KANJI,        /* 0x47de */
    KANJI,        /* 0x47df */
    KANJI,        /* 0x47e0 */
    KANJI,        /* 0x47e1 */
    KANJI,        /* 0x47e2 */
    KANJI,        /* 0x47e3 */
    KANJI,        /* 0x47e4 */
    KANJI,        /* 0x47e5 */
    KANJI,        /* 0x47e6 */
    KANJI,        /* 0x47e7 */
    KANJI,        /* 0x47e8 */
    KANJI,        /* 0x47e9 */
    KANJI,        /* 0x47ea */
    KANJI,        /* 0x47eb */
    KANJI,        /* 0x47ec */
    KANJI,        /* 0x47ed */
    KANJI,        /* 0x47ee */
    KANJI,        /* 0x47ef */
    KANJI,        /* 0x47f0 */
    KANJI,        /* 0x47f1 */
    KANJI,        /* 0x47f2 */
    KANJI,        /* 0x47f3 */
    KANJI,        /* 0x47f4 */
    KANJI,        /* 0x47f5 */
    KANJI,        /* 0x47f6 */
    KANJI,        /* 0x47f7 */
    KANJI,        /* 0x47f8 */
    KANJI,        /* 0x47f9 */
    KANJI,        /* 0x47fa */
    KANJI,        /* 0x47fb */
    KANJI,        /* 0x47fc */
    KANJI,        /* 0x47fd */
    KANJI,        /* 0x47fe */
    KANJI,        /* 0x47ff */
    KANJI,        /* 0x4800 */
    KANJI,        /* 0x4801 */
    KANJI,        /* 0x4802 */
    KANJI,        /* 0x4803 */
    KANJI,        /* 0x4804 */
    KANJI,        /* 0x4805 */
    KANJI,        /* 0x4806 */
    KANJI,        /* 0x4807 */
    KANJI,        /* 0x4808 */
    KANJI,        /* 0x4809 */
    KANJI,        /* 0x480a */
    KANJI,        /* 0x480b */
    KANJI,        /* 0x480c */
    KANJI,        /* 0x480d */
    KANJI,        /* 0x480e */
    KANJI,        /* 0x480f */
    KANJI,        /* 0x4810 */
    KANJI,        /* 0x4811 */
    KANJI,        /* 0x4812 */
    KANJI,        /* 0x4813 */
    KANJI,        /* 0x4814 */
    KANJI,        /* 0x4815 */
    KANJI,        /* 0x4816 */
    KANJI,        /* 0x4817 */
    KANJI,        /* 0x4818 */
    KANJI,        /* 0x4819 */
    KANJI,        /* 0x481a */
    KANJI,        /* 0x481b */
    KANJI,        /* 0x481c */
    KANJI,        /* 0x481d */
    KANJI,        /* 0x481e */
    KANJI,        /* 0x481f */
    KANJI,        /* 0x4820 */
    KANJI,        /* 0x4821 */
    KANJI,        /* 0x4822 */
    KANJI,        /* 0x4823 */
    KANJI,        /* 0x4824 */
    KANJI,        /* 0x4825 */
    KANJI,        /* 0x4826 */
    KANJI,        /* 0x4827 */
    KANJI,        /* 0x4828 */
    KANJI,        /* 0x4829 */
    KANJI,        /* 0x482a */
    KANJI,        /* 0x482b */
    KANJI,        /* 0x482c */
    KANJI,        /* 0x482d */
    KANJI,        /* 0x482e */
    KANJI,        /* 0x482f */
    KANJI,        /* 0x4830 */
    KANJI,        /* 0x4831 */
    KANJI,        /* 0x4832 */
    KANJI,        /* 0x4833 */
    KANJI,        /* 0x4834 */
    KANJI,        /* 0x4835 */
    KANJI,        /* 0x4836 */
    KANJI,        /* 0x4837 */
    KANJI,        /* 0x4838 */
    KANJI,        /* 0x4839 */
    KANJI,        /* 0x483a */
    KANJI,        /* 0x483b */
    KANJI,        /* 0x483c */
    KANJI,        /* 0x483d */
    KANJI,        /* 0x483e */
    KANJI,        /* 0x483f */
    KANJI,        /* 0x4840 */
    KANJI,        /* 0x4841 */
    KANJI,        /* 0x4842 */
    KANJI,        /* 0x4843 */
    KANJI,        /* 0x4844 */
    KANJI,        /* 0x4845 */
    KANJI,        /* 0x4846 */
    KANJI,        /* 0x4847 */
    KANJI,        /* 0x4848 */
    KANJI,        /* 0x4849 */
    KANJI,        /* 0x484a */
    KANJI,        /* 0x484b */
    KANJI,        /* 0x484c */
    KANJI,        /* 0x484d */
    KANJI,        /* 0x484e */
    KANJI,        /* 0x484f */
    KANJI,        /* 0x4850 */
    KANJI,        /* 0x4851 */
    KANJI,        /* 0x4852 */
    KANJI,        /* 0x4853 */
    KANJI,        /* 0x4854 */
    KANJI,        /* 0x4855 */
    KANJI,        /* 0x4856 */
    KANJI,        /* 0x4857 */
    KANJI,        /* 0x4858 */
    KANJI,        /* 0x4859 */
    KANJI,        /* 0x485a */
    KANJI,        /* 0x485b */
    KANJI,        /* 0x485c */
    KANJI,        /* 0x485d */
    KANJI,        /* 0x485e */
    KANJI,        /* 0x485f */
    KANJI,        /* 0x4860 */
    KANJI,        /* 0x4861 */
    KANJI,        /* 0x4862 */
    KANJI,        /* 0x4863 */
    KANJI,        /* 0x4864 */
    KANJI,        /* 0x4865 */
    KANJI,        /* 0x4866 */
    KANJI,        /* 0x4867 */
    KANJI,        /* 0x4868 */
    KANJI,        /* 0x4869 */
    KANJI,        /* 0x486a */
    KANJI,        /* 0x486b */
    KANJI,        /* 0x486c */
    KANJI,        /* 0x486d */
    KANJI,        /* 0x486e */
    KANJI,        /* 0x486f */
    KANJI,        /* 0x4870 */
    KANJI,        /* 0x4871 */
    KANJI,        /* 0x4872 */
    KANJI,        /* 0x4873 */
    KANJI,        /* 0x4874 */
    KANJI,        /* 0x4875 */
    KANJI,        /* 0x4876 */
    KANJI,        /* 0x4877 */
    KANJI,        /* 0x4878 */
    KANJI,        /* 0x4879 */
    KANJI,        /* 0x487a */
    KANJI,        /* 0x487b */
    KANJI,        /* 0x487c */
    KANJI,        /* 0x487d */
    KANJI,        /* 0x487e */
    KANJI,        /* 0x487f */
    KANJI,        /* 0x4880 */
    KANJI,        /* 0x4881 */
    KANJI,        /* 0x4882 */
    KANJI,        /* 0x4883 */
    KANJI,        /* 0x4884 */
    KANJI,        /* 0x4885 */
    KANJI,        /* 0x4886 */
    KANJI,        /* 0x4887 */
    KANJI,        /* 0x4888 */
    KANJI,        /* 0x4889 */
    KANJI,        /* 0x488a */
    KANJI,        /* 0x488b */
    KANJI,        /* 0x488c */
    KANJI,        /* 0x488d */
    KANJI,        /* 0x488e */
    KANJI,        /* 0x488f */
    KANJI,        /* 0x4890 */
    KANJI,        /* 0x4891 */
    KANJI,        /* 0x4892 */
    KANJI,        /* 0x4893 */
    KANJI,        /* 0x4894 */
    KANJI,        /* 0x4895 */
    KANJI,        /* 0x4896 */
    KANJI,        /* 0x4897 */
    KANJI,        /* 0x4898 */
    KANJI,        /* 0x4899 */
    KANJI,        /* 0x489a */
    KANJI,        /* 0x489b */
    KANJI,        /* 0x489c */
    KANJI,        /* 0x489d */
    KANJI,        /* 0x489e */
    KANJI,        /* 0x489f */
    KANJI,        /* 0x48a0 */
    KANJI,        /* 0x48a1 */
    KANJI,        /* 0x48a2 */
    KANJI,        /* 0x48a3 */
    KANJI,        /* 0x48a4 */
    KANJI,        /* 0x48a5 */
    KANJI,        /* 0x48a6 */
    KANJI,        /* 0x48a7 */
    KANJI,        /* 0x48a8 */
    KANJI,        /* 0x48a9 */
    KANJI,        /* 0x48aa */
    KANJI,        /* 0x48ab */
    KANJI,        /* 0x48ac */
    KANJI,        /* 0x48ad */
    KANJI,        /* 0x48ae */
    KANJI,        /* 0x48af */
    KANJI,        /* 0x48b0 */
    KANJI,        /* 0x48b1 */
    KANJI,        /* 0x48b2 */
    KANJI,        /* 0x48b3 */
    KANJI,        /* 0x48b4 */
    KANJI,        /* 0x48b5 */
    KANJI,        /* 0x48b6 */
    KANJI,        /* 0x48b7 */
    KANJI,        /* 0x48b8 */
    KANJI,        /* 0x48b9 */
    KANJI,        /* 0x48ba */
    KANJI,        /* 0x48bb */
    KANJI,        /* 0x48bc */
    KANJI,        /* 0x48bd */
    KANJI,        /* 0x48be */
    KANJI,        /* 0x48bf */
    KANJI,        /* 0x48c0 */
    KANJI,        /* 0x48c1 */
    KANJI,        /* 0x48c2 */
    KANJI,        /* 0x48c3 */
    KANJI,        /* 0x48c4 */
    KANJI,        /* 0x48c5 */
    KANJI,        /* 0x48c6 */
    KANJI,        /* 0x48c7 */
    KANJI,        /* 0x48c8 */
    KANJI,        /* 0x48c9 */
    KANJI,        /* 0x48ca */
    KANJI,        /* 0x48cb */
    KANJI,        /* 0x48cc */
    KANJI,        /* 0x48cd */
    KANJI,        /* 0x48ce */
    KANJI,        /* 0x48cf */
    KANJI,        /* 0x48d0 */
    KANJI,        /* 0x48d1 */
    KANJI,        /* 0x48d2 */
    KANJI,        /* 0x48d3 */
    KANJI,        /* 0x48d4 */
    KANJI,        /* 0x48d5 */
    KANJI,        /* 0x48d6 */
    KANJI,        /* 0x48d7 */
    KANJI,        /* 0x48d8 */
    KANJI,        /* 0x48d9 */
    KANJI,        /* 0x48da */
    KANJI,        /* 0x48db */
    KANJI,        /* 0x48dc */
    KANJI,        /* 0x48dd */
    KANJI,        /* 0x48de */
    KANJI,        /* 0x48df */
    KANJI,        /* 0x48e0 */
    KANJI,        /* 0x48e1 */
    KANJI,        /* 0x48e2 */
    KANJI,        /* 0x48e3 */
    KANJI,        /* 0x48e4 */
    KANJI,        /* 0x48e5 */
    KANJI,        /* 0x48e6 */
    KANJI,        /* 0x48e7 */
    KANJI,        /* 0x48e8 */
    KANJI,        /* 0x48e9 */
    KANJI,        /* 0x48ea */
    KANJI,        /* 0x48eb */
    KANJI,        /* 0x48ec */
    KANJI,        /* 0x48ed */
    KANJI,        /* 0x48ee */
    KANJI,        /* 0x48ef */
    KANJI,        /* 0x48f0 */
    KANJI,        /* 0x48f1 */
    KANJI,        /* 0x48f2 */
    KANJI,        /* 0x48f3 */
    KANJI,        /* 0x48f4 */
    KANJI,        /* 0x48f5 */
    KANJI,        /* 0x48f6 */
    KANJI,        /* 0x48f7 */
    KANJI,        /* 0x48f8 */
    KANJI,        /* 0x48f9 */
    KANJI,        /* 0x48fa */
    KANJI,        /* 0x48fb */
    KANJI,        /* 0x48fc */
    KANJI,        /* 0x48fd */
    KANJI,        /* 0x48fe */
    KANJI,        /* 0x48ff */
    KANJI,        /* 0x4900 */
    KANJI,        /* 0x4901 */
    KANJI,        /* 0x4902 */
    KANJI,        /* 0x4903 */
    KANJI,        /* 0x4904 */
    KANJI,        /* 0x4905 */
    KANJI,        /* 0x4906 */
    KANJI,        /* 0x4907 */
    KANJI,        /* 0x4908 */
    KANJI,        /* 0x4909 */
    KANJI,        /* 0x490a */
    KANJI,        /* 0x490b */
    KANJI,        /* 0x490c */
    KANJI,        /* 0x490d */
    KANJI,        /* 0x490e */
    KANJI,        /* 0x490f */
    KANJI,        /* 0x4910 */
    KANJI,        /* 0x4911 */
    KANJI,        /* 0x4912 */
    KANJI,        /* 0x4913 */
    KANJI,        /* 0x4914 */
    KANJI,        /* 0x4915 */
    KANJI,        /* 0x4916 */
    KANJI,        /* 0x4917 */
    KANJI,        /* 0x4918 */
    KANJI,        /* 0x4919 */
    KANJI,        /* 0x491a */
    KANJI,        /* 0x491b */
    KANJI,        /* 0x491c */
    KANJI,        /* 0x491d */
    KANJI,        /* 0x491e */
    KANJI,        /* 0x491f */
    KANJI,        /* 0x4920 */
    KANJI,        /* 0x4921 */
    KANJI,        /* 0x4922 */
    KANJI,        /* 0x4923 */
    KANJI,        /* 0x4924 */
    KANJI,        /* 0x4925 */
    KANJI,        /* 0x4926 */
    KANJI,        /* 0x4927 */
    KANJI,        /* 0x4928 */
    KANJI,        /* 0x4929 */
    KANJI,        /* 0x492a */
    KANJI,        /* 0x492b */
    KANJI,        /* 0x492c */
    KANJI,        /* 0x492d */
    KANJI,        /* 0x492e */
    KANJI,        /* 0x492f */
    KANJI,        /* 0x4930 */
    KANJI,        /* 0x4931 */
    KANJI,        /* 0x4932 */
    KANJI,        /* 0x4933 */
    KANJI,        /* 0x4934 */
    KANJI,        /* 0x4935 */
    KANJI,        /* 0x4936 */
    KANJI,        /* 0x4937 */
    KANJI,        /* 0x4938 */
    KANJI,        /* 0x4939 */
    KANJI,        /* 0x493a */
    KANJI,        /* 0x493b */
    KANJI,        /* 0x493c */
    KANJI,        /* 0x493d */
    KANJI,        /* 0x493e */
    KANJI,        /* 0x493f */
    KANJI,        /* 0x4940 */
    KANJI,        /* 0x4941 */
    KANJI,        /* 0x4942 */
    KANJI,        /* 0x4943 */
    KANJI,        /* 0x4944 */
    KANJI,        /* 0x4945 */
    KANJI,        /* 0x4946 */
    KANJI,        /* 0x4947 */
    KANJI,        /* 0x4948 */
    KANJI,        /* 0x4949 */
    KANJI,        /* 0x494a */
    KANJI,        /* 0x494b */
    KANJI,        /* 0x494c */
    KANJI,        /* 0x494d */
    KANJI,        /* 0x494e */
    KANJI,        /* 0x494f */
    KANJI,        /* 0x4950 */
    KANJI,        /* 0x4951 */
    KANJI,        /* 0x4952 */
    KANJI,        /* 0x4953 */
    KANJI,        /* 0x4954 */
    KANJI,        /* 0x4955 */
    KANJI,        /* 0x4956 */
    KANJI,        /* 0x4957 */
    KANJI,        /* 0x4958 */
    KANJI,        /* 0x4959 */
    KANJI,        /* 0x495a */
    KANJI,        /* 0x495b */
    KANJI,        /* 0x495c */
    KANJI,        /* 0x495d */
    KANJI,        /* 0x495e */
    KANJI,        /* 0x495f */
    KANJI,        /* 0x4960 */
    KANJI,        /* 0x4961 */
    KANJI,        /* 0x4962 */
    KANJI,        /* 0x4963 */
    KANJI,        /* 0x4964 */
    KANJI,        /* 0x4965 */
    KANJI,        /* 0x4966 */
    KANJI,        /* 0x4967 */
    KANJI,        /* 0x4968 */
    KANJI,        /* 0x4969 */
    KANJI,        /* 0x496a */
    KANJI,        /* 0x496b */
    KANJI,        /* 0x496c */
    KANJI,        /* 0x496d */
    KANJI,        /* 0x496e */
    KANJI,        /* 0x496f */
    KANJI,        /* 0x4970 */
    KANJI,        /* 0x4971 */
    KANJI,        /* 0x4972 */
    KANJI,        /* 0x4973 */
    KANJI,        /* 0x4974 */
    KANJI,        /* 0x4975 */
    KANJI,        /* 0x4976 */
    KANJI,        /* 0x4977 */
    KANJI,        /* 0x4978 */
    KANJI,        /* 0x4979 */
    KANJI,        /* 0x497a */
    KANJI,        /* 0x497b */
    KANJI,        /* 0x497c */
    KANJI,        /* 0x497d */
    KANJI,        /* 0x497e */
    KANJI,        /* 0x497f */
    KANJI,        /* 0x4980 */
    KANJI,        /* 0x4981 */
    KANJI,        /* 0x4982 */
    KANJI,        /* 0x4983 */
    KANJI,        /* 0x4984 */
    KANJI,        /* 0x4985 */
    KANJI,        /* 0x4986 */
    KANJI,        /* 0x4987 */
    KANJI,        /* 0x4988 */
    KANJI,        /* 0x4989 */
    KANJI,        /* 0x498a */
    KANJI,        /* 0x498b */
    KANJI,        /* 0x498c */
    KANJI,        /* 0x498d */
    KANJI,        /* 0x498e */
    KANJI,        /* 0x498f */
    KANJI,        /* 0x4990 */
    KANJI,        /* 0x4991 */
    KANJI,        /* 0x4992 */
    KANJI,        /* 0x4993 */
    KANJI,        /* 0x4994 */
    KANJI,        /* 0x4995 */
    KANJI,        /* 0x4996 */
    KANJI,        /* 0x4997 */
    KANJI,        /* 0x4998 */
    KANJI,        /* 0x4999 */
    KANJI,        /* 0x499a */
    KANJI,        /* 0x499b */
    KANJI,        /* 0x499c */
    KANJI,        /* 0x499d */
    KANJI,        /* 0x499e */
    KANJI,        /* 0x499f */
    KANJI,        /* 0x49a0 */
    KANJI,        /* 0x49a1 */
    KANJI,        /* 0x49a2 */
    KANJI,        /* 0x49a3 */
    KANJI,        /* 0x49a4 */
    KANJI,        /* 0x49a5 */
    KANJI,        /* 0x49a6 */
    KANJI,        /* 0x49a7 */
    KANJI,        /* 0x49a8 */
    KANJI,        /* 0x49a9 */
    KANJI,        /* 0x49aa */
    KANJI,        /* 0x49ab */
    KANJI,        /* 0x49ac */
    KANJI,        /* 0x49ad */
    KANJI,        /* 0x49ae */
    KANJI,        /* 0x49af */
    KANJI,        /* 0x49b0 */
    KANJI,        /* 0x49b1 */
    KANJI,        /* 0x49b2 */
    KANJI,        /* 0x49b3 */
    KANJI,        /* 0x49b4 */
    KANJI,        /* 0x49b5 */
    KANJI,        /* 0x49b6 */
    KANJI,        /* 0x49b7 */
    KANJI,        /* 0x49b8 */
    KANJI,        /* 0x49b9 */
    KANJI,        /* 0x49ba */
    KANJI,        /* 0x49bb */
    KANJI,        /* 0x49bc */
    KANJI,        /* 0x49bd */
    KANJI,        /* 0x49be */
    KANJI,        /* 0x49bf */
    KANJI,        /* 0x49c0 */
    KANJI,        /* 0x49c1 */
    KANJI,        /* 0x49c2 */
    KANJI,        /* 0x49c3 */
    KANJI,        /* 0x49c4 */
    KANJI,        /* 0x49c5 */
    KANJI,        /* 0x49c6 */
    KANJI,        /* 0x49c7 */
    KANJI,        /* 0x49c8 */
    KANJI,        /* 0x49c9 */
    KANJI,        /* 0x49ca */
    KANJI,        /* 0x49cb */
    KANJI,        /* 0x49cc */
    KANJI,        /* 0x49cd */
    KANJI,        /* 0x49ce */
    KANJI,        /* 0x49cf */
    KANJI,        /* 0x49d0 */
    KANJI,        /* 0x49d1 */
    KANJI,        /* 0x49d2 */
    KANJI,        /* 0x49d3 */
    KANJI,        /* 0x49d4 */
    KANJI,        /* 0x49d5 */
    KANJI,        /* 0x49d6 */
    KANJI,        /* 0x49d7 */
    KANJI,        /* 0x49d8 */
    KANJI,        /* 0x49d9 */
    KANJI,        /* 0x49da */
    KANJI,        /* 0x49db */
    KANJI,        /* 0x49dc */
    KANJI,        /* 0x49dd */
    KANJI,        /* 0x49de */
    KANJI,        /* 0x49df */
    KANJI,        /* 0x49e0 */
    KANJI,        /* 0x49e1 */
    KANJI,        /* 0x49e2 */
    KANJI,        /* 0x49e3 */
    KANJI,        /* 0x49e4 */
    KANJI,        /* 0x49e5 */
    KANJI,        /* 0x49e6 */
    KANJI,        /* 0x49e7 */
    KANJI,        /* 0x49e8 */
    KANJI,        /* 0x49e9 */
    KANJI,        /* 0x49ea */
    KANJI,        /* 0x49eb */
    KANJI,        /* 0x49ec */
    KANJI,        /* 0x49ed */
    KANJI,        /* 0x49ee */
    KANJI,        /* 0x49ef */
    KANJI,        /* 0x49f0 */
    KANJI,        /* 0x49f1 */
    KANJI,        /* 0x49f2 */
    KANJI,        /* 0x49f3 */
    KANJI,        /* 0x49f4 */
    KANJI,        /* 0x49f5 */
    KANJI,        /* 0x49f6 */
    KANJI,        /* 0x49f7 */
    KANJI,        /* 0x49f8 */
    KANJI,        /* 0x49f9 */
    KANJI,        /* 0x49fa */
    KANJI,        /* 0x49fb */
    KANJI,        /* 0x49fc */
    KANJI,        /* 0x49fd */
    KANJI,        /* 0x49fe */
    KANJI,        /* 0x49ff */
    KANJI,        /* 0x4a00 */
    KANJI,        /* 0x4a01 */
    KANJI,        /* 0x4a02 */
    KANJI,        /* 0x4a03 */
    KANJI,        /* 0x4a04 */
    KANJI,        /* 0x4a05 */
    KANJI,        /* 0x4a06 */
    KANJI,        /* 0x4a07 */
    KANJI,        /* 0x4a08 */
    KANJI,        /* 0x4a09 */
    KANJI,        /* 0x4a0a */
    KANJI,        /* 0x4a0b */
    KANJI,        /* 0x4a0c */
    KANJI,        /* 0x4a0d */
    KANJI,        /* 0x4a0e */
    KANJI,        /* 0x4a0f */
    KANJI,        /* 0x4a10 */
    KANJI,        /* 0x4a11 */
    KANJI,        /* 0x4a12 */
    KANJI,        /* 0x4a13 */
    KANJI,        /* 0x4a14 */
    KANJI,        /* 0x4a15 */
    KANJI,        /* 0x4a16 */
    KANJI,        /* 0x4a17 */
    KANJI,        /* 0x4a18 */
    KANJI,        /* 0x4a19 */
    KANJI,        /* 0x4a1a */
    KANJI,        /* 0x4a1b */
    KANJI,        /* 0x4a1c */
    KANJI,        /* 0x4a1d */
    KANJI,        /* 0x4a1e */
    KANJI,        /* 0x4a1f */
    KANJI,        /* 0x4a20 */
    KANJI,        /* 0x4a21 */
    KANJI,        /* 0x4a22 */
    KANJI,        /* 0x4a23 */
    KANJI,        /* 0x4a24 */
    KANJI,        /* 0x4a25 */
    KANJI,        /* 0x4a26 */
    KANJI,        /* 0x4a27 */
    KANJI,        /* 0x4a28 */
    KANJI,        /* 0x4a29 */
    KANJI,        /* 0x4a2a */
    KANJI,        /* 0x4a2b */
    KANJI,        /* 0x4a2c */
    KANJI,        /* 0x4a2d */
    KANJI,        /* 0x4a2e */
    KANJI,        /* 0x4a2f */
    KANJI,        /* 0x4a30 */
    KANJI,        /* 0x4a31 */
    KANJI,        /* 0x4a32 */
    KANJI,        /* 0x4a33 */
    KANJI,        /* 0x4a34 */
    KANJI,        /* 0x4a35 */
    KANJI,        /* 0x4a36 */
    KANJI,        /* 0x4a37 */
    KANJI,        /* 0x4a38 */
    KANJI,        /* 0x4a39 */
    KANJI,        /* 0x4a3a */
    KANJI,        /* 0x4a3b */
    KANJI,        /* 0x4a3c */
    KANJI,        /* 0x4a3d */
    KANJI,        /* 0x4a3e */
    KANJI,        /* 0x4a3f */
    KANJI,        /* 0x4a40 */
    KANJI,        /* 0x4a41 */
    KANJI,        /* 0x4a42 */
    KANJI,        /* 0x4a43 */
    KANJI,        /* 0x4a44 */
    KANJI,        /* 0x4a45 */
    KANJI,        /* 0x4a46 */
    KANJI,        /* 0x4a47 */
    KANJI,        /* 0x4a48 */
    KANJI,        /* 0x4a49 */
    KANJI,        /* 0x4a4a */
    KANJI,        /* 0x4a4b */
    KANJI,        /* 0x4a4c */
    KANJI,        /* 0x4a4d */
    KANJI,        /* 0x4a4e */
    KANJI,        /* 0x4a4f */
    KANJI,        /* 0x4a50 */
    KANJI,        /* 0x4a51 */
    KANJI,        /* 0x4a52 */
    KANJI,        /* 0x4a53 */
    KANJI,        /* 0x4a54 */
    KANJI,        /* 0x4a55 */
    KANJI,        /* 0x4a56 */
    KANJI,        /* 0x4a57 */
    KANJI,        /* 0x4a58 */
    KANJI,        /* 0x4a59 */
    KANJI,        /* 0x4a5a */
    KANJI,        /* 0x4a5b */
    KANJI,        /* 0x4a5c */
    KANJI,        /* 0x4a5d */
    KANJI,        /* 0x4a5e */
    KANJI,        /* 0x4a5f */
    KANJI,        /* 0x4a60 */
    KANJI,        /* 0x4a61 */
    KANJI,        /* 0x4a62 */
    KANJI,        /* 0x4a63 */
    KANJI,        /* 0x4a64 */
    KANJI,        /* 0x4a65 */
    KANJI,        /* 0x4a66 */
    KANJI,        /* 0x4a67 */
    KANJI,        /* 0x4a68 */
    KANJI,        /* 0x4a69 */
    KANJI,        /* 0x4a6a */
    KANJI,        /* 0x4a6b */
    KANJI,        /* 0x4a6c */
    KANJI,        /* 0x4a6d */
    KANJI,        /* 0x4a6e */
    KANJI,        /* 0x4a6f */
    KANJI,        /* 0x4a70 */
    KANJI,        /* 0x4a71 */
    KANJI,        /* 0x4a72 */
    KANJI,        /* 0x4a73 */
    KANJI,        /* 0x4a74 */
    KANJI,        /* 0x4a75 */
    KANJI,        /* 0x4a76 */
    KANJI,        /* 0x4a77 */
    KANJI,        /* 0x4a78 */
    KANJI,        /* 0x4a79 */
    KANJI,        /* 0x4a7a */
    KANJI,        /* 0x4a7b */
    KANJI,        /* 0x4a7c */
    KANJI,        /* 0x4a7d */
    KANJI,        /* 0x4a7e */
    KANJI,        /* 0x4a7f */
    KANJI,        /* 0x4a80 */
    KANJI,        /* 0x4a81 */
    KANJI,        /* 0x4a82 */
    KANJI,        /* 0x4a83 */
    KANJI,        /* 0x4a84 */
    KANJI,        /* 0x4a85 */
    KANJI,        /* 0x4a86 */
    KANJI,        /* 0x4a87 */
    KANJI,        /* 0x4a88 */
    KANJI,        /* 0x4a89 */
    KANJI,        /* 0x4a8a */
    KANJI,        /* 0x4a8b */
    KANJI,        /* 0x4a8c */
    KANJI,        /* 0x4a8d */
    KANJI,        /* 0x4a8e */
    KANJI,        /* 0x4a8f */
    KANJI,        /* 0x4a90 */
    KANJI,        /* 0x4a91 */
    KANJI,        /* 0x4a92 */
    KANJI,        /* 0x4a93 */
    KANJI,        /* 0x4a94 */
    KANJI,        /* 0x4a95 */
    KANJI,        /* 0x4a96 */
    KANJI,        /* 0x4a97 */
    KANJI,        /* 0x4a98 */
    KANJI,        /* 0x4a99 */
    KANJI,        /* 0x4a9a */
    KANJI,        /* 0x4a9b */
    KANJI,        /* 0x4a9c */
    KANJI,        /* 0x4a9d */
    KANJI,        /* 0x4a9e */
    KANJI,        /* 0x4a9f */
    KANJI,        /* 0x4aa0 */
    KANJI,        /* 0x4aa1 */
    KANJI,        /* 0x4aa2 */
    KANJI,        /* 0x4aa3 */
    KANJI,        /* 0x4aa4 */
    KANJI,        /* 0x4aa5 */
    KANJI,        /* 0x4aa6 */
    KANJI,        /* 0x4aa7 */
    KANJI,        /* 0x4aa8 */
    KANJI,        /* 0x4aa9 */
    KANJI,        /* 0x4aaa */
    KANJI,        /* 0x4aab */
    KANJI,        /* 0x4aac */
    KANJI,        /* 0x4aad */
    KANJI,        /* 0x4aae */
    KANJI,        /* 0x4aaf */
    KANJI,        /* 0x4ab0 */
    KANJI,        /* 0x4ab1 */
    KANJI,        /* 0x4ab2 */
    KANJI,        /* 0x4ab3 */
    KANJI,        /* 0x4ab4 */
    KANJI,        /* 0x4ab5 */
    KANJI,        /* 0x4ab6 */
    KANJI,        /* 0x4ab7 */
    KANJI,        /* 0x4ab8 */
    KANJI,        /* 0x4ab9 */
    KANJI,        /* 0x4aba */
    KANJI,        /* 0x4abb */
    KANJI,        /* 0x4abc */
    KANJI,        /* 0x4abd */
    KANJI,        /* 0x4abe */
    KANJI,        /* 0x4abf */
    KANJI,        /* 0x4ac0 */
    KANJI,        /* 0x4ac1 */
    KANJI,        /* 0x4ac2 */
    KANJI,        /* 0x4ac3 */
    KANJI,        /* 0x4ac4 */
    KANJI,        /* 0x4ac5 */
    KANJI,        /* 0x4ac6 */
    KANJI,        /* 0x4ac7 */
    KANJI,        /* 0x4ac8 */
    KANJI,        /* 0x4ac9 */
    KANJI,        /* 0x4aca */
    KANJI,        /* 0x4acb */
    KANJI,        /* 0x4acc */
    KANJI,        /* 0x4acd */
    KANJI,        /* 0x4ace */
    KANJI,        /* 0x4acf */
    KANJI,        /* 0x4ad0 */
    KANJI,        /* 0x4ad1 */
    KANJI,        /* 0x4ad2 */
    KANJI,        /* 0x4ad3 */
    KANJI,        /* 0x4ad4 */
    KANJI,        /* 0x4ad5 */
    KANJI,        /* 0x4ad6 */
    KANJI,        /* 0x4ad7 */
    KANJI,        /* 0x4ad8 */
    KANJI,        /* 0x4ad9 */
    KANJI,        /* 0x4ada */
    KANJI,        /* 0x4adb */
    KANJI,        /* 0x4adc */
    KANJI,        /* 0x4add */
    KANJI,        /* 0x4ade */
    KANJI,        /* 0x4adf */
    KANJI,        /* 0x4ae0 */
    KANJI,        /* 0x4ae1 */
    KANJI,        /* 0x4ae2 */
    KANJI,        /* 0x4ae3 */
    KANJI,        /* 0x4ae4 */
    KANJI,        /* 0x4ae5 */
    KANJI,        /* 0x4ae6 */
    KANJI,        /* 0x4ae7 */
    KANJI,        /* 0x4ae8 */
    KANJI,        /* 0x4ae9 */
    KANJI,        /* 0x4aea */
    KANJI,        /* 0x4aeb */
    KANJI,        /* 0x4aec */
    KANJI,        /* 0x4aed */
    KANJI,        /* 0x4aee */
    KANJI,        /* 0x4aef */
    KANJI,        /* 0x4af0 */
    KANJI,        /* 0x4af1 */
    KANJI,        /* 0x4af2 */
    KANJI,        /* 0x4af3 */
    KANJI,        /* 0x4af4 */
    KANJI,        /* 0x4af5 */
    KANJI,        /* 0x4af6 */
    KANJI,        /* 0x4af7 */
    KANJI,        /* 0x4af8 */
    KANJI,        /* 0x4af9 */
    KANJI,        /* 0x4afa */
    KANJI,        /* 0x4afb */
    KANJI,        /* 0x4afc */
    KANJI,        /* 0x4afd */
    KANJI,        /* 0x4afe */
    KANJI,        /* 0x4aff */
    KANJI,        /* 0x4b00 */
    KANJI,        /* 0x4b01 */
    KANJI,        /* 0x4b02 */
    KANJI,        /* 0x4b03 */
    KANJI,        /* 0x4b04 */
    KANJI,        /* 0x4b05 */
    KANJI,        /* 0x4b06 */
    KANJI,        /* 0x4b07 */
    KANJI,        /* 0x4b08 */
    KANJI,        /* 0x4b09 */
    KANJI,        /* 0x4b0a */
    KANJI,        /* 0x4b0b */
    KANJI,        /* 0x4b0c */
    KANJI,        /* 0x4b0d */
    KANJI,        /* 0x4b0e */
    KANJI,        /* 0x4b0f */
    KANJI,        /* 0x4b10 */
    KANJI,        /* 0x4b11 */
    KANJI,        /* 0x4b12 */
    KANJI,        /* 0x4b13 */
    KANJI,        /* 0x4b14 */
    KANJI,        /* 0x4b15 */
    KANJI,        /* 0x4b16 */
    KANJI,        /* 0x4b17 */
    KANJI,        /* 0x4b18 */
    KANJI,        /* 0x4b19 */
    KANJI,        /* 0x4b1a */
    KANJI,        /* 0x4b1b */
    KANJI,        /* 0x4b1c */
    KANJI,        /* 0x4b1d */
    KANJI,        /* 0x4b1e */
    KANJI,        /* 0x4b1f */
    KANJI,        /* 0x4b20 */
    KANJI,        /* 0x4b21 */
    KANJI,        /* 0x4b22 */
    KANJI,        /* 0x4b23 */
    KANJI,        /* 0x4b24 */
    KANJI,        /* 0x4b25 */
    KANJI,        /* 0x4b26 */
    KANJI,        /* 0x4b27 */
    KANJI,        /* 0x4b28 */
    KANJI,        /* 0x4b29 */
    KANJI,        /* 0x4b2a */
    KANJI,        /* 0x4b2b */
    KANJI,        /* 0x4b2c */
    KANJI,        /* 0x4b2d */
    KANJI,        /* 0x4b2e */
    KANJI,        /* 0x4b2f */
    KANJI,        /* 0x4b30 */
    KANJI,        /* 0x4b31 */
    KANJI,        /* 0x4b32 */
    KANJI,        /* 0x4b33 */
    KANJI,        /* 0x4b34 */
    KANJI,        /* 0x4b35 */
    KANJI,        /* 0x4b36 */
    KANJI,        /* 0x4b37 */
    KANJI,        /* 0x4b38 */
    KANJI,        /* 0x4b39 */
    KANJI,        /* 0x4b3a */
    KANJI,        /* 0x4b3b */
    KANJI,        /* 0x4b3c */
    KANJI,        /* 0x4b3d */
    KANJI,        /* 0x4b3e */
    KANJI,        /* 0x4b3f */
    KANJI,        /* 0x4b40 */
    KANJI,        /* 0x4b41 */
    KANJI,        /* 0x4b42 */
    KANJI,        /* 0x4b43 */
    KANJI,        /* 0x4b44 */
    KANJI,        /* 0x4b45 */
    KANJI,        /* 0x4b46 */
    KANJI,        /* 0x4b47 */
    KANJI,        /* 0x4b48 */
    KANJI,        /* 0x4b49 */
    KANJI,        /* 0x4b4a */
    KANJI,        /* 0x4b4b */
    KANJI,        /* 0x4b4c */
    KANJI,        /* 0x4b4d */
    KANJI,        /* 0x4b4e */
    KANJI,        /* 0x4b4f */
    KANJI,        /* 0x4b50 */
    KANJI,        /* 0x4b51 */
    KANJI,        /* 0x4b52 */
    KANJI,        /* 0x4b53 */
    KANJI,        /* 0x4b54 */
    KANJI,        /* 0x4b55 */
    KANJI,        /* 0x4b56 */
    KANJI,        /* 0x4b57 */
    KANJI,        /* 0x4b58 */
    KANJI,        /* 0x4b59 */
    KANJI,        /* 0x4b5a */
    KANJI,        /* 0x4b5b */
    KANJI,        /* 0x4b5c */
    KANJI,        /* 0x4b5d */
    KANJI,        /* 0x4b5e */
    KANJI,        /* 0x4b5f */
    KANJI,        /* 0x4b60 */
    KANJI,        /* 0x4b61 */
    KANJI,        /* 0x4b62 */
    KANJI,        /* 0x4b63 */
    KANJI,        /* 0x4b64 */
    KANJI,        /* 0x4b65 */
    KANJI,        /* 0x4b66 */
    KANJI,        /* 0x4b67 */
    KANJI,        /* 0x4b68 */
    KANJI,        /* 0x4b69 */
    KANJI,        /* 0x4b6a */
    KANJI,        /* 0x4b6b */
    KANJI,        /* 0x4b6c */
    KANJI,        /* 0x4b6d */
    KANJI,        /* 0x4b6e */
    KANJI,        /* 0x4b6f */
    KANJI,        /* 0x4b70 */
    KANJI,        /* 0x4b71 */
    KANJI,        /* 0x4b72 */
    KANJI,        /* 0x4b73 */
    KANJI,        /* 0x4b74 */
    KANJI,        /* 0x4b75 */
    KANJI,        /* 0x4b76 */
    KANJI,        /* 0x4b77 */
    KANJI,        /* 0x4b78 */
    KANJI,        /* 0x4b79 */
    KANJI,        /* 0x4b7a */
    KANJI,        /* 0x4b7b */
    KANJI,        /* 0x4b7c */
    KANJI,        /* 0x4b7d */
    KANJI,        /* 0x4b7e */
    KANJI,        /* 0x4b7f */
    KANJI,        /* 0x4b80 */
    KANJI,        /* 0x4b81 */
    KANJI,        /* 0x4b82 */
    KANJI,        /* 0x4b83 */
    KANJI,        /* 0x4b84 */
    KANJI,        /* 0x4b85 */
    KANJI,        /* 0x4b86 */
    KANJI,        /* 0x4b87 */
    KANJI,        /* 0x4b88 */
    KANJI,        /* 0x4b89 */
    KANJI,        /* 0x4b8a */
    KANJI,        /* 0x4b8b */
    KANJI,        /* 0x4b8c */
    KANJI,        /* 0x4b8d */
    KANJI,        /* 0x4b8e */
    KANJI,        /* 0x4b8f */
    KANJI,        /* 0x4b90 */
    KANJI,        /* 0x4b91 */
    KANJI,        /* 0x4b92 */
    KANJI,        /* 0x4b93 */
    KANJI,        /* 0x4b94 */
    KANJI,        /* 0x4b95 */
    KANJI,        /* 0x4b96 */
    KANJI,        /* 0x4b97 */
    KANJI,        /* 0x4b98 */
    KANJI,        /* 0x4b99 */
    KANJI,        /* 0x4b9a */
    KANJI,        /* 0x4b9b */
    KANJI,        /* 0x4b9c */
    KANJI,        /* 0x4b9d */
    KANJI,        /* 0x4b9e */
    KANJI,        /* 0x4b9f */
    KANJI,        /* 0x4ba0 */
    KANJI,        /* 0x4ba1 */
    KANJI,        /* 0x4ba2 */
    KANJI,        /* 0x4ba3 */
    KANJI,        /* 0x4ba4 */
    KANJI,        /* 0x4ba5 */
    KANJI,        /* 0x4ba6 */
    KANJI,        /* 0x4ba7 */
    KANJI,        /* 0x4ba8 */
    KANJI,        /* 0x4ba9 */
    KANJI,        /* 0x4baa */
    KANJI,        /* 0x4bab */
    KANJI,        /* 0x4bac */
    KANJI,        /* 0x4bad */
    KANJI,        /* 0x4bae */
    KANJI,        /* 0x4baf */
    KANJI,        /* 0x4bb0 */
    KANJI,        /* 0x4bb1 */
    KANJI,        /* 0x4bb2 */
    KANJI,        /* 0x4bb3 */
    KANJI,        /* 0x4bb4 */
    KANJI,        /* 0x4bb5 */
    KANJI,        /* 0x4bb6 */
    KANJI,        /* 0x4bb7 */
    KANJI,        /* 0x4bb8 */
    KANJI,        /* 0x4bb9 */
    KANJI,        /* 0x4bba */
    KANJI,        /* 0x4bbb */
    KANJI,        /* 0x4bbc */
    KANJI,        /* 0x4bbd */
    KANJI,        /* 0x4bbe */
    KANJI,        /* 0x4bbf */
    KANJI,        /* 0x4bc0 */
    KANJI,        /* 0x4bc1 */
    KANJI,        /* 0x4bc2 */
    KANJI,        /* 0x4bc3 */
    KANJI,        /* 0x4bc4 */
    KANJI,        /* 0x4bc5 */
    KANJI,        /* 0x4bc6 */
    KANJI,        /* 0x4bc7 */
    KANJI,        /* 0x4bc8 */
    KANJI,        /* 0x4bc9 */
    KANJI,        /* 0x4bca */
    KANJI,        /* 0x4bcb */
    KANJI,        /* 0x4bcc */
    KANJI,        /* 0x4bcd */
    KANJI,        /* 0x4bce */
    KANJI,        /* 0x4bcf */
    KANJI,        /* 0x4bd0 */
    KANJI,        /* 0x4bd1 */
    KANJI,        /* 0x4bd2 */
    KANJI,        /* 0x4bd3 */
    KANJI,        /* 0x4bd4 */
    KANJI,        /* 0x4bd5 */
    KANJI,        /* 0x4bd6 */
    KANJI,        /* 0x4bd7 */
    KANJI,        /* 0x4bd8 */
    KANJI,        /* 0x4bd9 */
    KANJI,        /* 0x4bda */
    KANJI,        /* 0x4bdb */
    KANJI,        /* 0x4bdc */
    KANJI,        /* 0x4bdd */
    KANJI,        /* 0x4bde */
    KANJI,        /* 0x4bdf */
    KANJI,        /* 0x4be0 */
    KANJI,        /* 0x4be1 */
    KANJI,        /* 0x4be2 */
    KANJI,        /* 0x4be3 */
    KANJI,        /* 0x4be4 */
    KANJI,        /* 0x4be5 */
    KANJI,        /* 0x4be6 */
    KANJI,        /* 0x4be7 */
    KANJI,        /* 0x4be8 */
    KANJI,        /* 0x4be9 */
    KANJI,        /* 0x4bea */
    KANJI,        /* 0x4beb */
    KANJI,        /* 0x4bec */
    KANJI,        /* 0x4bed */
    KANJI,        /* 0x4bee */
    KANJI,        /* 0x4bef */
    KANJI,        /* 0x4bf0 */
    KANJI,        /* 0x4bf1 */
    KANJI,        /* 0x4bf2 */
    KANJI,        /* 0x4bf3 */
    KANJI,        /* 0x4bf4 */
    KANJI,        /* 0x4bf5 */
    KANJI,        /* 0x4bf6 */
    KANJI,        /* 0x4bf7 */
    KANJI,        /* 0x4bf8 */
    KANJI,        /* 0x4bf9 */
    KANJI,        /* 0x4bfa */
    KANJI,        /* 0x4bfb */
    KANJI,        /* 0x4bfc */
    KANJI,        /* 0x4bfd */
    KANJI,        /* 0x4bfe */
    KANJI,        /* 0x4bff */
    KANJI,        /* 0x4c00 */
    KANJI,        /* 0x4c01 */
    KANJI,        /* 0x4c02 */
    KANJI,        /* 0x4c03 */
    KANJI,        /* 0x4c04 */
    KANJI,        /* 0x4c05 */
    KANJI,        /* 0x4c06 */
    KANJI,        /* 0x4c07 */
    KANJI,        /* 0x4c08 */
    KANJI,        /* 0x4c09 */
    KANJI,        /* 0x4c0a */
    KANJI,        /* 0x4c0b */
    KANJI,        /* 0x4c0c */
    KANJI,        /* 0x4c0d */
    KANJI,        /* 0x4c0e */
    KANJI,        /* 0x4c0f */
    KANJI,        /* 0x4c10 */
    KANJI,        /* 0x4c11 */
    KANJI,        /* 0x4c12 */
    KANJI,        /* 0x4c13 */
    KANJI,        /* 0x4c14 */
    KANJI,        /* 0x4c15 */
    KANJI,        /* 0x4c16 */
    KANJI,        /* 0x4c17 */
    KANJI,        /* 0x4c18 */
    KANJI,        /* 0x4c19 */
    KANJI,        /* 0x4c1a */
    KANJI,        /* 0x4c1b */
    KANJI,        /* 0x4c1c */
    KANJI,        /* 0x4c1d */
    KANJI,        /* 0x4c1e */
    KANJI,        /* 0x4c1f */
    KANJI,        /* 0x4c20 */
    KANJI,        /* 0x4c21 */
    KANJI,        /* 0x4c22 */
    KANJI,        /* 0x4c23 */
    KANJI,        /* 0x4c24 */
    KANJI,        /* 0x4c25 */
    KANJI,        /* 0x4c26 */
    KANJI,        /* 0x4c27 */
    KANJI,        /* 0x4c28 */
    KANJI,        /* 0x4c29 */
    KANJI,        /* 0x4c2a */
    KANJI,        /* 0x4c2b */
    KANJI,        /* 0x4c2c */
    KANJI,        /* 0x4c2d */
    KANJI,        /* 0x4c2e */
    KANJI,        /* 0x4c2f */
    KANJI,        /* 0x4c30 */
    KANJI,        /* 0x4c31 */
    KANJI,        /* 0x4c32 */
    KANJI,        /* 0x4c33 */
    KANJI,        /* 0x4c34 */
    KANJI,        /* 0x4c35 */
    KANJI,        /* 0x4c36 */
    KANJI,        /* 0x4c37 */
    KANJI,        /* 0x4c38 */
    KANJI,        /* 0x4c39 */
    KANJI,        /* 0x4c3a */
    KANJI,        /* 0x4c3b */
    KANJI,        /* 0x4c3c */
    KANJI,        /* 0x4c3d */
    KANJI,        /* 0x4c3e */
    KANJI,        /* 0x4c3f */
    KANJI,        /* 0x4c40 */
    KANJI,        /* 0x4c41 */
    KANJI,        /* 0x4c42 */
    KANJI,        /* 0x4c43 */
    KANJI,        /* 0x4c44 */
    KANJI,        /* 0x4c45 */
    KANJI,        /* 0x4c46 */
    KANJI,        /* 0x4c47 */
    KANJI,        /* 0x4c48 */
    KANJI,        /* 0x4c49 */
    KANJI,        /* 0x4c4a */
    KANJI,        /* 0x4c4b */
    KANJI,        /* 0x4c4c */
    KANJI,        /* 0x4c4d */
    KANJI,        /* 0x4c4e */
    KANJI,        /* 0x4c4f */
    KANJI,        /* 0x4c50 */
    KANJI,        /* 0x4c51 */
    KANJI,        /* 0x4c52 */
    KANJI,        /* 0x4c53 */
    KANJI,        /* 0x4c54 */
    KANJI,        /* 0x4c55 */
    KANJI,        /* 0x4c56 */
    KANJI,        /* 0x4c57 */
    KANJI,        /* 0x4c58 */
    KANJI,        /* 0x4c59 */
    KANJI,        /* 0x4c5a */
    KANJI,        /* 0x4c5b */
    KANJI,        /* 0x4c5c */
    KANJI,        /* 0x4c5d */
    KANJI,        /* 0x4c5e */
    KANJI,        /* 0x4c5f */
    KANJI,        /* 0x4c60 */
    KANJI,        /* 0x4c61 */
    KANJI,        /* 0x4c62 */
    KANJI,        /* 0x4c63 */
    KANJI,        /* 0x4c64 */
    KANJI,        /* 0x4c65 */
    KANJI,        /* 0x4c66 */
    KANJI,        /* 0x4c67 */
    KANJI,        /* 0x4c68 */
    KANJI,        /* 0x4c69 */
    KANJI,        /* 0x4c6a */
    KANJI,        /* 0x4c6b */
    KANJI,        /* 0x4c6c */
    KANJI,        /* 0x4c6d */
    KANJI,        /* 0x4c6e */
    KANJI,        /* 0x4c6f */
    KANJI,        /* 0x4c70 */
    KANJI,        /* 0x4c71 */
    KANJI,        /* 0x4c72 */
    KANJI,        /* 0x4c73 */
    KANJI,        /* 0x4c74 */
    KANJI,        /* 0x4c75 */
    KANJI,        /* 0x4c76 */
    KANJI,        /* 0x4c77 */
    KANJI,        /* 0x4c78 */
    KANJI,        /* 0x4c79 */
    KANJI,        /* 0x4c7a */
    KANJI,        /* 0x4c7b */
    KANJI,        /* 0x4c7c */
    KANJI,        /* 0x4c7d */
    KANJI,        /* 0x4c7e */
    KANJI,        /* 0x4c7f */
    KANJI,        /* 0x4c80 */
    KANJI,        /* 0x4c81 */
    KANJI,        /* 0x4c82 */
    KANJI,        /* 0x4c83 */
    KANJI,        /* 0x4c84 */
    KANJI,        /* 0x4c85 */
    KANJI,        /* 0x4c86 */
    KANJI,        /* 0x4c87 */
    KANJI,        /* 0x4c88 */
    KANJI,        /* 0x4c89 */
    KANJI,        /* 0x4c8a */
    KANJI,        /* 0x4c8b */
    KANJI,        /* 0x4c8c */
    KANJI,        /* 0x4c8d */
    KANJI,        /* 0x4c8e */
    KANJI,        /* 0x4c8f */
    KANJI,        /* 0x4c90 */
    KANJI,        /* 0x4c91 */
    KANJI,        /* 0x4c92 */
    KANJI,        /* 0x4c93 */
    KANJI,        /* 0x4c94 */
    KANJI,        /* 0x4c95 */
    KANJI,        /* 0x4c96 */
    KANJI,        /* 0x4c97 */
    KANJI,        /* 0x4c98 */
    KANJI,        /* 0x4c99 */
    KANJI,        /* 0x4c9a */
    KANJI,        /* 0x4c9b */
    KANJI,        /* 0x4c9c */
    KANJI,        /* 0x4c9d */
    KANJI,        /* 0x4c9e */
    KANJI,        /* 0x4c9f */
    KANJI,        /* 0x4ca0 */
    KANJI,        /* 0x4ca1 */
    KANJI,        /* 0x4ca2 */
    KANJI,        /* 0x4ca3 */
    KANJI,        /* 0x4ca4 */
    KANJI,        /* 0x4ca5 */
    KANJI,        /* 0x4ca6 */
    KANJI,        /* 0x4ca7 */
    KANJI,        /* 0x4ca8 */
    KANJI,        /* 0x4ca9 */
    KANJI,        /* 0x4caa */
    KANJI,        /* 0x4cab */
    KANJI,        /* 0x4cac */
    KANJI,        /* 0x4cad */
    KANJI,        /* 0x4cae */
    KANJI,        /* 0x4caf */
    KANJI,        /* 0x4cb0 */
    KANJI,        /* 0x4cb1 */
    KANJI,        /* 0x4cb2 */
    KANJI,        /* 0x4cb3 */
    KANJI,        /* 0x4cb4 */
    KANJI,        /* 0x4cb5 */
    KANJI,        /* 0x4cb6 */
    KANJI,        /* 0x4cb7 */
    KANJI,        /* 0x4cb8 */
    KANJI,        /* 0x4cb9 */
    KANJI,        /* 0x4cba */
    KANJI,        /* 0x4cbb */
    KANJI,        /* 0x4cbc */
    KANJI,        /* 0x4cbd */
    KANJI,        /* 0x4cbe */
    KANJI,        /* 0x4cbf */
    KANJI,        /* 0x4cc0 */
    KANJI,        /* 0x4cc1 */
    KANJI,        /* 0x4cc2 */
    KANJI,        /* 0x4cc3 */
    KANJI,        /* 0x4cc4 */
    KANJI,        /* 0x4cc5 */
    KANJI,        /* 0x4cc6 */
    KANJI,        /* 0x4cc7 */
    KANJI,        /* 0x4cc8 */
    KANJI,        /* 0x4cc9 */
    KANJI,        /* 0x4cca */
    KANJI,        /* 0x4ccb */
    KANJI,        /* 0x4ccc */
    KANJI,        /* 0x4ccd */
    KANJI,        /* 0x4cce */
    KANJI,        /* 0x4ccf */
    KANJI,        /* 0x4cd0 */
    KANJI,        /* 0x4cd1 */
    KANJI,        /* 0x4cd2 */
    KANJI,        /* 0x4cd3 */
    KANJI,        /* 0x4cd4 */
    KANJI,        /* 0x4cd5 */
    KANJI,        /* 0x4cd6 */
    KANJI,        /* 0x4cd7 */
    KANJI,        /* 0x4cd8 */
    KANJI,        /* 0x4cd9 */
    KANJI,        /* 0x4cda */
    KANJI,        /* 0x4cdb */
    KANJI,        /* 0x4cdc */
    KANJI,        /* 0x4cdd */
    KANJI,        /* 0x4cde */
    KANJI,        /* 0x4cdf */
    KANJI,        /* 0x4ce0 */
    KANJI,        /* 0x4ce1 */
    KANJI,        /* 0x4ce2 */
    KANJI,        /* 0x4ce3 */
    KANJI,        /* 0x4ce4 */
    KANJI,        /* 0x4ce5 */
    KANJI,        /* 0x4ce6 */
    KANJI,        /* 0x4ce7 */
    KANJI,        /* 0x4ce8 */
    KANJI,        /* 0x4ce9 */
    KANJI,        /* 0x4cea */
    KANJI,        /* 0x4ceb */
    KANJI,        /* 0x4cec */
    KANJI,        /* 0x4ced */
    KANJI,        /* 0x4cee */
    KANJI,        /* 0x4cef */
    KANJI,        /* 0x4cf0 */
    KANJI,        /* 0x4cf1 */
    KANJI,        /* 0x4cf2 */
    KANJI,        /* 0x4cf3 */
    KANJI,        /* 0x4cf4 */
    KANJI,        /* 0x4cf5 */
    KANJI,        /* 0x4cf6 */
    KANJI,        /* 0x4cf7 */
    KANJI,        /* 0x4cf8 */
    KANJI,        /* 0x4cf9 */
    KANJI,        /* 0x4cfa */
    KANJI,        /* 0x4cfb */
    KANJI,        /* 0x4cfc */
    KANJI,        /* 0x4cfd */
    KANJI,        /* 0x4cfe */
    KANJI,        /* 0x4cff */
    KANJI,        /* 0x4d00 */
    KANJI,        /* 0x4d01 */
    KANJI,        /* 0x4d02 */
    KANJI,        /* 0x4d03 */
    KANJI,        /* 0x4d04 */
    KANJI,        /* 0x4d05 */
    KANJI,        /* 0x4d06 */
    KANJI,        /* 0x4d07 */
    KANJI,        /* 0x4d08 */
    KANJI,        /* 0x4d09 */
    KANJI,        /* 0x4d0a */
    KANJI,        /* 0x4d0b */
    KANJI,        /* 0x4d0c */
    KANJI,        /* 0x4d0d */
    KANJI,        /* 0x4d0e */
    KANJI,        /* 0x4d0f */
    KANJI,        /* 0x4d10 */
    KANJI,        /* 0x4d11 */
    KANJI,        /* 0x4d12 */
    KANJI,        /* 0x4d13 */
    KANJI,        /* 0x4d14 */
    KANJI,        /* 0x4d15 */
    KANJI,        /* 0x4d16 */
    KANJI,        /* 0x4d17 */
    KANJI,        /* 0x4d18 */
    KANJI,        /* 0x4d19 */
    KANJI,        /* 0x4d1a */
    KANJI,        /* 0x4d1b */
    KANJI,        /* 0x4d1c */
    KANJI,        /* 0x4d1d */
    KANJI,        /* 0x4d1e */
    KANJI,        /* 0x4d1f */
    KANJI,        /* 0x4d20 */
    KANJI,        /* 0x4d21 */
    KANJI,        /* 0x4d22 */
    KANJI,        /* 0x4d23 */
    KANJI,        /* 0x4d24 */
    KANJI,        /* 0x4d25 */
    KANJI,        /* 0x4d26 */
    KANJI,        /* 0x4d27 */
    KANJI,        /* 0x4d28 */
    KANJI,        /* 0x4d29 */
    KANJI,        /* 0x4d2a */
    KANJI,        /* 0x4d2b */
    KANJI,        /* 0x4d2c */
    KANJI,        /* 0x4d2d */
    KANJI,        /* 0x4d2e */
    KANJI,        /* 0x4d2f */
    KANJI,        /* 0x4d30 */
    KANJI,        /* 0x4d31 */
    KANJI,        /* 0x4d32 */
    KANJI,        /* 0x4d33 */
    KANJI,        /* 0x4d34 */
    KANJI,        /* 0x4d35 */
    KANJI,        /* 0x4d36 */
    KANJI,        /* 0x4d37 */
    KANJI,        /* 0x4d38 */
    KANJI,        /* 0x4d39 */
    KANJI,        /* 0x4d3a */
    KANJI,        /* 0x4d3b */
    KANJI,        /* 0x4d3c */
    KANJI,        /* 0x4d3d */
    KANJI,        /* 0x4d3e */
    KANJI,        /* 0x4d3f */
    KANJI,        /* 0x4d40 */
    KANJI,        /* 0x4d41 */
    KANJI,        /* 0x4d42 */
    KANJI,        /* 0x4d43 */
    KANJI,        /* 0x4d44 */
    KANJI,        /* 0x4d45 */
    KANJI,        /* 0x4d46 */
    KANJI,        /* 0x4d47 */
    KANJI,        /* 0x4d48 */
    KANJI,        /* 0x4d49 */
    KANJI,        /* 0x4d4a */
    KANJI,        /* 0x4d4b */
    KANJI,        /* 0x4d4c */
    KANJI,        /* 0x4d4d */
    KANJI,        /* 0x4d4e */
    KANJI,        /* 0x4d4f */
    KANJI,        /* 0x4d50 */
    KANJI,        /* 0x4d51 */
    KANJI,        /* 0x4d52 */
    KANJI,        /* 0x4d53 */
    KANJI,        /* 0x4d54 */
    KANJI,        /* 0x4d55 */
    KANJI,        /* 0x4d56 */
    KANJI,        /* 0x4d57 */
    KANJI,        /* 0x4d58 */
    KANJI,        /* 0x4d59 */
    KANJI,        /* 0x4d5a */
    KANJI,        /* 0x4d5b */
    KANJI,        /* 0x4d5c */
    KANJI,        /* 0x4d5d */
    KANJI,        /* 0x4d5e */
    KANJI,        /* 0x4d5f */
    KANJI,        /* 0x4d60 */
    KANJI,        /* 0x4d61 */
    KANJI,        /* 0x4d62 */
    KANJI,        /* 0x4d63 */
    KANJI,        /* 0x4d64 */
    KANJI,        /* 0x4d65 */
    KANJI,        /* 0x4d66 */
    KANJI,        /* 0x4d67 */
    KANJI,        /* 0x4d68 */
    KANJI,        /* 0x4d69 */
    KANJI,        /* 0x4d6a */
    KANJI,        /* 0x4d6b */
    KANJI,        /* 0x4d6c */
    KANJI,        /* 0x4d6d */
    KANJI,        /* 0x4d6e */
    KANJI,        /* 0x4d6f */
    KANJI,        /* 0x4d70 */
    KANJI,        /* 0x4d71 */
    KANJI,        /* 0x4d72 */
    KANJI,        /* 0x4d73 */
    KANJI,        /* 0x4d74 */
    KANJI,        /* 0x4d75 */
    KANJI,        /* 0x4d76 */
    KANJI,        /* 0x4d77 */
    KANJI,        /* 0x4d78 */
    KANJI,        /* 0x4d79 */
    KANJI,        /* 0x4d7a */
    KANJI,        /* 0x4d7b */
    KANJI,        /* 0x4d7c */
    KANJI,        /* 0x4d7d */
    KANJI,        /* 0x4d7e */
    KANJI,        /* 0x4d7f */
    KANJI,        /* 0x4d80 */
    KANJI,        /* 0x4d81 */
    KANJI,        /* 0x4d82 */
    KANJI,        /* 0x4d83 */
    KANJI,        /* 0x4d84 */
    KANJI,        /* 0x4d85 */
    KANJI,        /* 0x4d86 */
    KANJI,        /* 0x4d87 */
    KANJI,        /* 0x4d88 */
    KANJI,        /* 0x4d89 */
    KANJI,        /* 0x4d8a */
    KANJI,        /* 0x4d8b */
    KANJI,        /* 0x4d8c */
    KANJI,        /* 0x4d8d */
    KANJI,        /* 0x4d8e */
    KANJI,        /* 0x4d8f */
    KANJI,        /* 0x4d90 */
    KANJI,        /* 0x4d91 */
    KANJI,        /* 0x4d92 */
    KANJI,        /* 0x4d93 */
    KANJI,        /* 0x4d94 */
    KANJI,        /* 0x4d95 */
    KANJI,        /* 0x4d96 */
    KANJI,        /* 0x4d97 */
    KANJI,        /* 0x4d98 */
    KANJI,        /* 0x4d99 */
    KANJI,        /* 0x4d9a */
    KANJI,        /* 0x4d9b */
    KANJI,        /* 0x4d9c */
    KANJI,        /* 0x4d9d */
    KANJI,        /* 0x4d9e */
    KANJI,        /* 0x4d9f */
    KANJI,        /* 0x4da0 */
    KANJI,        /* 0x4da1 */
    KANJI,        /* 0x4da2 */
    KANJI,        /* 0x4da3 */
    KANJI,        /* 0x4da4 */
    KANJI,        /* 0x4da5 */
    KANJI,        /* 0x4da6 */
    KANJI,        /* 0x4da7 */
    KANJI,        /* 0x4da8 */
    KANJI,        /* 0x4da9 */
    KANJI,        /* 0x4daa */
    KANJI,        /* 0x4dab */
    KANJI,        /* 0x4dac */
    KANJI,        /* 0x4dad */
    KANJI,        /* 0x4dae */
    KANJI,        /* 0x4daf */
    KANJI,        /* 0x4db0 */
    KANJI,        /* 0x4db1 */
    KANJI,        /* 0x4db2 */
    KANJI,        /* 0x4db3 */
    KANJI,        /* 0x4db4 */
    KANJI,        /* 0x4db5 */
    OTHER,        /* 0x4db6 */
    OTHER,        /* 0x4db7 */
    OTHER,        /* 0x4db8 */
    OTHER,        /* 0x4db9 */
    OTHER,        /* 0x4dba */
    OTHER,        /* 0x4dbb */
    OTHER,        /* 0x4dbc */
    OTHER,        /* 0x4dbd */
    OTHER,        /* 0x4dbe */
    OTHER,        /* 0x4dbf */
    OTHER,        /* 0x4dc0 */
    OTHER,        /* 0x4dc1 */
    OTHER,        /* 0x4dc2 */
    OTHER,        /* 0x4dc3 */
    OTHER,        /* 0x4dc4 */
    OTHER,        /* 0x4dc5 */
    OTHER,        /* 0x4dc6 */
    OTHER,        /* 0x4dc7 */
    OTHER,        /* 0x4dc8 */
    OTHER,        /* 0x4dc9 */
    OTHER,        /* 0x4dca */
    OTHER,        /* 0x4dcb */
    OTHER,        /* 0x4dcc */
    OTHER,        /* 0x4dcd */
    OTHER,        /* 0x4dce */
    OTHER,        /* 0x4dcf */
    OTHER,        /* 0x4dd0 */
    OTHER,        /* 0x4dd1 */
    OTHER,        /* 0x4dd2 */
    OTHER,        /* 0x4dd3 */
    OTHER,        /* 0x4dd4 */
    OTHER,        /* 0x4dd5 */
    OTHER,        /* 0x4dd6 */
    OTHER,        /* 0x4dd7 */
    OTHER,        /* 0x4dd8 */
    OTHER,        /* 0x4dd9 */
    OTHER,        /* 0x4dda */
    OTHER,        /* 0x4ddb */
    OTHER,        /* 0x4ddc */
    OTHER,        /* 0x4ddd */
    OTHER,        /* 0x4dde */
    OTHER,        /* 0x4ddf */
    OTHER,        /* 0x4de0 */
    OTHER,        /* 0x4de1 */
    OTHER,        /* 0x4de2 */
    OTHER,        /* 0x4de3 */
    OTHER,        /* 0x4de4 */
    OTHER,        /* 0x4de5 */
    OTHER,        /* 0x4de6 */
    OTHER,        /* 0x4de7 */
    OTHER,        /* 0x4de8 */
    OTHER,        /* 0x4de9 */
    OTHER,        /* 0x4dea */
    OTHER,        /* 0x4deb */
    OTHER,        /* 0x4dec */
    OTHER,        /* 0x4ded */
    OTHER,        /* 0x4dee */
    OTHER,        /* 0x4def */
    OTHER,        /* 0x4df0 */
    OTHER,        /* 0x4df1 */
    OTHER,        /* 0x4df2 */
    OTHER,        /* 0x4df3 */
    OTHER,        /* 0x4df4 */
    OTHER,        /* 0x4df5 */
    OTHER,        /* 0x4df6 */
    OTHER,        /* 0x4df7 */
    OTHER,        /* 0x4df8 */
    OTHER,        /* 0x4df9 */
    OTHER,        /* 0x4dfa */
    OTHER,        /* 0x4dfb */
    OTHER,        /* 0x4dfc */
    OTHER,        /* 0x4dfd */
    OTHER,        /* 0x4dfe */
    OTHER,        /* 0x4dff */
    KANJINUMERIC,        /* 0x4e00 */
    KANJI,        /* 0x4e01 */
    KANJI,        /* 0x4e02 */
    KANJINUMERIC,        /* 0x4e03 */
    KANJI,        /* 0x4e04 */
    KANJI,        /* 0x4e05 */
    KANJI,        /* 0x4e06 */
    KANJINUMERIC,        /* 0x4e07 */
    KANJI,        /* 0x4e08 */
    KANJINUMERIC,        /* 0x4e09 */
    KANJI,        /* 0x4e0a */
    KANJI,        /* 0x4e0b */
    KANJI,        /* 0x4e0c */
    KANJI,        /* 0x4e0d */
    KANJI,        /* 0x4e0e */
    KANJI,        /* 0x4e0f */
    KANJI,        /* 0x4e10 */
    KANJI,        /* 0x4e11 */
    KANJI,        /* 0x4e12 */
    KANJI,        /* 0x4e13 */
    KANJI,        /* 0x4e14 */
    KANJI,        /* 0x4e15 */
    KANJI,        /* 0x4e16 */
    KANJI,        /* 0x4e17 */
    KANJI,        /* 0x4e18 */
    KANJI,        /* 0x4e19 */
    KANJI,        /* 0x4e1a */
    KANJI,        /* 0x4e1b */
    KANJI,        /* 0x4e1c */
    KANJI,        /* 0x4e1d */
    KANJI,        /* 0x4e1e */
    KANJI,        /* 0x4e1f */
    KANJI,        /* 0x4e20 */
    KANJI,        /* 0x4e21 */
    KANJI,        /* 0x4e22 */
    KANJI,        /* 0x4e23 */
    KANJI,        /* 0x4e24 */
    KANJI,        /* 0x4e25 */
    KANJI,        /* 0x4e26 */
    KANJI,        /* 0x4e27 */
    KANJI,        /* 0x4e28 */
    KANJI,        /* 0x4e29 */
    KANJI,        /* 0x4e2a */
    KANJI,        /* 0x4e2b */
    KANJI,        /* 0x4e2c */
    KANJI,        /* 0x4e2d */
    KANJI,        /* 0x4e2e */
    KANJI,        /* 0x4e2f */
    KANJI,        /* 0x4e30 */
    KANJI,        /* 0x4e31 */
    KANJI,        /* 0x4e32 */
    KANJI,        /* 0x4e33 */
    KANJI,        /* 0x4e34 */
    KANJI,        /* 0x4e35 */
    KANJI,        /* 0x4e36 */
    KANJI,        /* 0x4e37 */
    KANJI,        /* 0x4e38 */
    KANJI,        /* 0x4e39 */
    KANJI,        /* 0x4e3a */
    KANJI,        /* 0x4e3b */
    KANJI,        /* 0x4e3c */
    KANJI,        /* 0x4e3d */
    KANJI,        /* 0x4e3e */
    KANJI,        /* 0x4e3f */
    KANJI,        /* 0x4e40 */
    KANJI,        /* 0x4e41 */
    KANJI,        /* 0x4e42 */
    KANJI,        /* 0x4e43 */
    KANJI,        /* 0x4e44 */
    KANJI,        /* 0x4e45 */
    KANJI,        /* 0x4e46 */
    KANJI,        /* 0x4e47 */
    KANJI,        /* 0x4e48 */
    KANJI,        /* 0x4e49 */
    KANJI,        /* 0x4e4a */
    KANJI,        /* 0x4e4b */
    KANJI,        /* 0x4e4c */
    KANJI,        /* 0x4e4d */
    KANJI,        /* 0x4e4e */
    KANJI,        /* 0x4e4f */
    KANJI,        /* 0x4e50 */
    KANJI,        /* 0x4e51 */
    KANJI,        /* 0x4e52 */
    KANJI,        /* 0x4e53 */
    KANJI,        /* 0x4e54 */
    KANJI,        /* 0x4e55 */
    KANJI,        /* 0x4e56 */
    KANJI,        /* 0x4e57 */
    KANJI,        /* 0x4e58 */
    KANJI,        /* 0x4e59 */
    KANJI,        /* 0x4e5a */
    KANJI,        /* 0x4e5b */
    KANJI,        /* 0x4e5c */
    KANJINUMERIC,        /* 0x4e5d */
    KANJI,        /* 0x4e5e */
    KANJI,        /* 0x4e5f */
    KANJI,        /* 0x4e60 */
    KANJI,        /* 0x4e61 */
    KANJI,        /* 0x4e62 */
    KANJI,        /* 0x4e63 */
    KANJI,        /* 0x4e64 */
    KANJI,        /* 0x4e65 */
    KANJI,        /* 0x4e66 */
    KANJI,        /* 0x4e67 */
    KANJI,        /* 0x4e68 */
    KANJI,        /* 0x4e69 */
    KANJI,        /* 0x4e6a */
    KANJI,        /* 0x4e6b */
    KANJI,        /* 0x4e6c */
    KANJI,        /* 0x4e6d */
    KANJI,        /* 0x4e6e */
    KANJI,        /* 0x4e6f */
    KANJI,        /* 0x4e70 */
    KANJI,        /* 0x4e71 */
    KANJI,        /* 0x4e72 */
    KANJI,        /* 0x4e73 */
    KANJI,        /* 0x4e74 */
    KANJI,        /* 0x4e75 */
    KANJI,        /* 0x4e76 */
    KANJI,        /* 0x4e77 */
    KANJI,        /* 0x4e78 */
    KANJI,        /* 0x4e79 */
    KANJI,        /* 0x4e7a */
    KANJI,        /* 0x4e7b */
    KANJI,        /* 0x4e7c */
    KANJI,        /* 0x4e7d */
    KANJI,        /* 0x4e7e */
    KANJI,        /* 0x4e7f */
    KANJI,        /* 0x4e80 */
    KANJI,        /* 0x4e81 */
    KANJI,        /* 0x4e82 */
    KANJI,        /* 0x4e83 */
    KANJI,        /* 0x4e84 */
    KANJI,        /* 0x4e85 */
    KANJI,        /* 0x4e86 */
    KANJI,        /* 0x4e87 */
    KANJI,        /* 0x4e88 */
    KANJI,        /* 0x4e89 */
    KANJI,        /* 0x4e8a */
    KANJI,        /* 0x4e8b */
    KANJINUMERIC,        /* 0x4e8c */
    KANJI,        /* 0x4e8d */
    KANJI,        /* 0x4e8e */
    KANJI,        /* 0x4e8f */
    KANJI,        /* 0x4e90 */
    KANJI,        /* 0x4e91 */
    KANJI,        /* 0x4e92 */
    KANJI,        /* 0x4e93 */
    KANJINUMERIC,        /* 0x4e94 */
    KANJI,        /* 0x4e95 */
    KANJI,        /* 0x4e96 */
    KANJI,        /* 0x4e97 */
    KANJI,        /* 0x4e98 */
    KANJI,        /* 0x4e99 */
    KANJI,        /* 0x4e9a */
    KANJI,        /* 0x4e9b */
    KANJI,        /* 0x4e9c */
    KANJI,        /* 0x4e9d */
    KANJI,        /* 0x4e9e */
    KANJI,        /* 0x4e9f */
    KANJI,        /* 0x4ea0 */
    KANJI,        /* 0x4ea1 */
    KANJI,        /* 0x4ea2 */
    KANJI,        /* 0x4ea3 */
    KANJI,        /* 0x4ea4 */
    KANJI,        /* 0x4ea5 */
    KANJI,        /* 0x4ea6 */
    KANJI,        /* 0x4ea7 */
    KANJI,        /* 0x4ea8 */
    KANJI,        /* 0x4ea9 */
    KANJI,        /* 0x4eaa */
    KANJI,        /* 0x4eab */
    KANJI,        /* 0x4eac */
    KANJI,        /* 0x4ead */
    KANJI,        /* 0x4eae */
    KANJI,        /* 0x4eaf */
    KANJI,        /* 0x4eb0 */
    KANJI,        /* 0x4eb1 */
    KANJI,        /* 0x4eb2 */
    KANJI,        /* 0x4eb3 */
    KANJI,        /* 0x4eb4 */
    KANJI,        /* 0x4eb5 */
    KANJI,        /* 0x4eb6 */
    KANJI,        /* 0x4eb7 */
    KANJI,        /* 0x4eb8 */
    KANJI,        /* 0x4eb9 */
    KANJI,        /* 0x4eba */
    KANJI,        /* 0x4ebb */
    KANJI,        /* 0x4ebc */
    KANJI,        /* 0x4ebd */
    KANJI,        /* 0x4ebe */
    KANJI,        /* 0x4ebf */
    KANJI,        /* 0x4ec0 */
    KANJI,        /* 0x4ec1 */
    KANJI,        /* 0x4ec2 */
    KANJI,        /* 0x4ec3 */
    KANJI,        /* 0x4ec4 */
    KANJI,        /* 0x4ec5 */
    KANJI,        /* 0x4ec6 */
    KANJI,        /* 0x4ec7 */
    KANJI,        /* 0x4ec8 */
    KANJI,        /* 0x4ec9 */
    KANJI,        /* 0x4eca */
    KANJI,        /* 0x4ecb */
    KANJI,        /* 0x4ecc */
    KANJI,        /* 0x4ecd */
    KANJI,        /* 0x4ece */
    KANJI,        /* 0x4ecf */
    KANJI,        /* 0x4ed0 */
    KANJI,        /* 0x4ed1 */
    KANJI,        /* 0x4ed2 */
    KANJI,        /* 0x4ed3 */
    KANJI,        /* 0x4ed4 */
    KANJI,        /* 0x4ed5 */
    KANJI,        /* 0x4ed6 */
    KANJI,        /* 0x4ed7 */
    KANJI,        /* 0x4ed8 */
    KANJI,        /* 0x4ed9 */
    KANJI,        /* 0x4eda */
    KANJI,        /* 0x4edb */
    KANJI,        /* 0x4edc */
    KANJI,        /* 0x4edd */
    KANJI,        /* 0x4ede */
    KANJI,        /* 0x4edf */
    KANJI,        /* 0x4ee0 */
    KANJI,        /* 0x4ee1 */
    KANJI,        /* 0x4ee2 */
    KANJI,        /* 0x4ee3 */
    KANJI,        /* 0x4ee4 */
    KANJI,        /* 0x4ee5 */
    KANJI,        /* 0x4ee6 */
    KANJI,        /* 0x4ee7 */
    KANJI,        /* 0x4ee8 */
    KANJI,        /* 0x4ee9 */
    KANJI,        /* 0x4eea */
    KANJI,        /* 0x4eeb */
    KANJI,        /* 0x4eec */
    KANJI,        /* 0x4eed */
    KANJI,        /* 0x4eee */
    KANJI,        /* 0x4eef */
    KANJI,        /* 0x4ef0 */
    KANJI,        /* 0x4ef1 */
    KANJI,        /* 0x4ef2 */
    KANJI,        /* 0x4ef3 */
    KANJI,        /* 0x4ef4 */
    KANJI,        /* 0x4ef5 */
    KANJI,        /* 0x4ef6 */
    KANJI,        /* 0x4ef7 */
    KANJI,        /* 0x4ef8 */
    KANJI,        /* 0x4ef9 */
    KANJI,        /* 0x4efa */
    KANJI,        /* 0x4efb */
    KANJI,        /* 0x4efc */
    KANJI,        /* 0x4efd */
    KANJI,        /* 0x4efe */
    KANJI,        /* 0x4eff */
    KANJI,        /* 0x4f00 */
    KANJI,        /* 0x4f01 */
    KANJI,        /* 0x4f02 */
    KANJI,        /* 0x4f03 */
    KANJI,        /* 0x4f04 */
    KANJI,        /* 0x4f05 */
    KANJI,        /* 0x4f06 */
    KANJI,        /* 0x4f07 */
    KANJI,        /* 0x4f08 */
    KANJI,        /* 0x4f09 */
    KANJI,        /* 0x4f0a */
    KANJI,        /* 0x4f0b */
    KANJI,        /* 0x4f0c */
    KANJI,        /* 0x4f0d */
    KANJI,        /* 0x4f0e */
    KANJI,        /* 0x4f0f */
    KANJI,        /* 0x4f10 */
    KANJI,        /* 0x4f11 */
    KANJI,        /* 0x4f12 */
    KANJI,        /* 0x4f13 */
    KANJI,        /* 0x4f14 */
    KANJI,        /* 0x4f15 */
    KANJI,        /* 0x4f16 */
    KANJI,        /* 0x4f17 */
    KANJI,        /* 0x4f18 */
    KANJI,        /* 0x4f19 */
    KANJI,        /* 0x4f1a */
    KANJI,        /* 0x4f1b */
    KANJI,        /* 0x4f1c */
    KANJI,        /* 0x4f1d */
    KANJI,        /* 0x4f1e */
    KANJI,        /* 0x4f1f */
    KANJI,        /* 0x4f20 */
    KANJI,        /* 0x4f21 */
    KANJI,        /* 0x4f22 */
    KANJI,        /* 0x4f23 */
    KANJI,        /* 0x4f24 */
    KANJI,        /* 0x4f25 */
    KANJI,        /* 0x4f26 */
    KANJI,        /* 0x4f27 */
    KANJI,        /* 0x4f28 */
    KANJI,        /* 0x4f29 */
    KANJI,        /* 0x4f2a */
    KANJI,        /* 0x4f2b */
    KANJI,        /* 0x4f2c */
    KANJI,        /* 0x4f2d */
    KANJI,        /* 0x4f2e */
    KANJI,        /* 0x4f2f */
    KANJI,        /* 0x4f30 */
    KANJI,        /* 0x4f31 */
    KANJI,        /* 0x4f32 */
    KANJI,        /* 0x4f33 */
    KANJI,        /* 0x4f34 */
    KANJI,        /* 0x4f35 */
    KANJI,        /* 0x4f36 */
    KANJI,        /* 0x4f37 */
    KANJI,        /* 0x4f38 */
    KANJI,        /* 0x4f39 */
    KANJI,        /* 0x4f3a */
    KANJI,        /* 0x4f3b */
    KANJI,        /* 0x4f3c */
    KANJI,        /* 0x4f3d */
    KANJI,        /* 0x4f3e */
    KANJI,        /* 0x4f3f */
    KANJI,        /* 0x4f40 */
    KANJI,        /* 0x4f41 */
    KANJI,        /* 0x4f42 */
    KANJI,        /* 0x4f43 */
    KANJI,        /* 0x4f44 */
    KANJI,        /* 0x4f45 */
    KANJI,        /* 0x4f46 */
    KANJI,        /* 0x4f47 */
    KANJI,        /* 0x4f48 */
    KANJI,        /* 0x4f49 */
    KANJI,        /* 0x4f4a */
    KANJI,        /* 0x4f4b */
    KANJI,        /* 0x4f4c */
    KANJI,        /* 0x4f4d */
    KANJI,        /* 0x4f4e */
    KANJI,        /* 0x4f4f */
    KANJI,        /* 0x4f50 */
    KANJI,        /* 0x4f51 */
    KANJI,        /* 0x4f52 */
    KANJI,        /* 0x4f53 */
    KANJI,        /* 0x4f54 */
    KANJI,        /* 0x4f55 */
    KANJI,        /* 0x4f56 */
    KANJI,        /* 0x4f57 */
    KANJI,        /* 0x4f58 */
    KANJI,        /* 0x4f59 */
    KANJI,        /* 0x4f5a */
    KANJI,        /* 0x4f5b */
    KANJI,        /* 0x4f5c */
    KANJI,        /* 0x4f5d */
    KANJI,        /* 0x4f5e */
    KANJI,        /* 0x4f5f */
    KANJI,        /* 0x4f60 */
    KANJI,        /* 0x4f61 */
    KANJI,        /* 0x4f62 */
    KANJI,        /* 0x4f63 */
    KANJI,        /* 0x4f64 */
    KANJI,        /* 0x4f65 */
    KANJI,        /* 0x4f66 */
    KANJI,        /* 0x4f67 */
    KANJI,        /* 0x4f68 */
    KANJI,        /* 0x4f69 */
    KANJI,        /* 0x4f6a */
    KANJI,        /* 0x4f6b */
    KANJI,        /* 0x4f6c */
    KANJI,        /* 0x4f6d */
    KANJI,        /* 0x4f6e */
    KANJI,        /* 0x4f6f */
    KANJI,        /* 0x4f70 */
    KANJI,        /* 0x4f71 */
    KANJI,        /* 0x4f72 */
    KANJI,        /* 0x4f73 */
    KANJI,        /* 0x4f74 */
    KANJI,        /* 0x4f75 */
    KANJI,        /* 0x4f76 */
    KANJI,        /* 0x4f77 */
    KANJI,        /* 0x4f78 */
    KANJI,        /* 0x4f79 */
    KANJI,        /* 0x4f7a */
    KANJI,        /* 0x4f7b */
    KANJI,        /* 0x4f7c */
    KANJI,        /* 0x4f7d */
    KANJI,        /* 0x4f7e */
    KANJI,        /* 0x4f7f */
    KANJI,        /* 0x4f80 */
    KANJI,        /* 0x4f81 */
    KANJI,        /* 0x4f82 */
    KANJI,        /* 0x4f83 */
    KANJI,        /* 0x4f84 */
    KANJI,        /* 0x4f85 */
    KANJI,        /* 0x4f86 */
    KANJI,        /* 0x4f87 */
    KANJI,        /* 0x4f88 */
    KANJI,        /* 0x4f89 */
    KANJI,        /* 0x4f8a */
    KANJI,        /* 0x4f8b */
    KANJI,        /* 0x4f8c */
    KANJI,        /* 0x4f8d */
    KANJI,        /* 0x4f8e */
    KANJI,        /* 0x4f8f */
    KANJI,        /* 0x4f90 */
    KANJI,        /* 0x4f91 */
    KANJI,        /* 0x4f92 */
    KANJI,        /* 0x4f93 */
    KANJI,        /* 0x4f94 */
    KANJI,        /* 0x4f95 */
    KANJI,        /* 0x4f96 */
    KANJI,        /* 0x4f97 */
    KANJI,        /* 0x4f98 */
    KANJI,        /* 0x4f99 */
    KANJI,        /* 0x4f9a */
    KANJI,        /* 0x4f9b */
    KANJI,        /* 0x4f9c */
    KANJI,        /* 0x4f9d */
    KANJI,        /* 0x4f9e */
    KANJI,        /* 0x4f9f */
    KANJI,        /* 0x4fa0 */
    KANJI,        /* 0x4fa1 */
    KANJI,        /* 0x4fa2 */
    KANJI,        /* 0x4fa3 */
    KANJI,        /* 0x4fa4 */
    KANJI,        /* 0x4fa5 */
    KANJI,        /* 0x4fa6 */
    KANJI,        /* 0x4fa7 */
    KANJI,        /* 0x4fa8 */
    KANJI,        /* 0x4fa9 */
    KANJI,        /* 0x4faa */
    KANJI,        /* 0x4fab */
    KANJI,        /* 0x4fac */
    KANJI,        /* 0x4fad */
    KANJI,        /* 0x4fae */
    KANJI,        /* 0x4faf */
    KANJI,        /* 0x4fb0 */
    KANJI,        /* 0x4fb1 */
    KANJI,        /* 0x4fb2 */
    KANJI,        /* 0x4fb3 */
    KANJI,        /* 0x4fb4 */
    KANJI,        /* 0x4fb5 */
    KANJI,        /* 0x4fb6 */
    KANJI,        /* 0x4fb7 */
    KANJI,        /* 0x4fb8 */
    KANJI,        /* 0x4fb9 */
    KANJI,        /* 0x4fba */
    KANJI,        /* 0x4fbb */
    KANJI,        /* 0x4fbc */
    KANJI,        /* 0x4fbd */
    KANJI,        /* 0x4fbe */
    KANJI,        /* 0x4fbf */
    KANJI,        /* 0x4fc0 */
    KANJI,        /* 0x4fc1 */
    KANJI,        /* 0x4fc2 */
    KANJI,        /* 0x4fc3 */
    KANJI,        /* 0x4fc4 */
    KANJI,        /* 0x4fc5 */
    KANJI,        /* 0x4fc6 */
    KANJI,        /* 0x4fc7 */
    KANJI,        /* 0x4fc8 */
    KANJI,        /* 0x4fc9 */
    KANJI,        /* 0x4fca */
    KANJI,        /* 0x4fcb */
    KANJI,        /* 0x4fcc */
    KANJI,        /* 0x4fcd */
    KANJI,        /* 0x4fce */
    KANJI,        /* 0x4fcf */
    KANJI,        /* 0x4fd0 */
    KANJI,        /* 0x4fd1 */
    KANJI,        /* 0x4fd2 */
    KANJI,        /* 0x4fd3 */
    KANJI,        /* 0x4fd4 */
    KANJI,        /* 0x4fd5 */
    KANJI,        /* 0x4fd6 */
    KANJI,        /* 0x4fd7 */
    KANJI,        /* 0x4fd8 */
    KANJI,        /* 0x4fd9 */
    KANJI,        /* 0x4fda */
    KANJI,        /* 0x4fdb */
    KANJI,        /* 0x4fdc */
    KANJI,        /* 0x4fdd */
    KANJI,        /* 0x4fde */
    KANJI,        /* 0x4fdf */
    KANJI,        /* 0x4fe0 */
    KANJI,        /* 0x4fe1 */
    KANJI,        /* 0x4fe2 */
    KANJI,        /* 0x4fe3 */
    KANJI,        /* 0x4fe4 */
    KANJI,        /* 0x4fe5 */
    KANJI,        /* 0x4fe6 */
    KANJI,        /* 0x4fe7 */
    KANJI,        /* 0x4fe8 */
    KANJI,        /* 0x4fe9 */
    KANJI,        /* 0x4fea */
    KANJI,        /* 0x4feb */
    KANJI,        /* 0x4fec */
    KANJI,        /* 0x4fed */
    KANJI,        /* 0x4fee */
    KANJI,        /* 0x4fef */
    KANJI,        /* 0x4ff0 */
    KANJI,        /* 0x4ff1 */
    KANJI,        /* 0x4ff2 */
    KANJI,        /* 0x4ff3 */
    KANJI,        /* 0x4ff4 */
    KANJI,        /* 0x4ff5 */
    KANJI,        /* 0x4ff6 */
    KANJI,        /* 0x4ff7 */
    KANJI,        /* 0x4ff8 */
    KANJI,        /* 0x4ff9 */
    KANJI,        /* 0x4ffa */
    KANJI,        /* 0x4ffb */
    KANJI,        /* 0x4ffc */
    KANJI,        /* 0x4ffd */
    KANJI,        /* 0x4ffe */
    KANJI,        /* 0x4fff */
    KANJI,        /* 0x5000 */
    KANJI,        /* 0x5001 */
    KANJI,        /* 0x5002 */
    KANJI,        /* 0x5003 */
    KANJI,        /* 0x5004 */
    KANJI,        /* 0x5005 */
    KANJI,        /* 0x5006 */
    KANJI,        /* 0x5007 */
    KANJI,        /* 0x5008 */
    KANJI,        /* 0x5009 */
    KANJI,        /* 0x500a */
    KANJI,        /* 0x500b */
    KANJI,        /* 0x500c */
    KANJI,        /* 0x500d */
    KANJI,        /* 0x500e */
    KANJI,        /* 0x500f */
    KANJI,        /* 0x5010 */
    KANJI,        /* 0x5011 */
    KANJI,        /* 0x5012 */
    KANJI,        /* 0x5013 */
    KANJI,        /* 0x5014 */
    KANJI,        /* 0x5015 */
    KANJI,        /* 0x5016 */
    KANJI,        /* 0x5017 */
    KANJI,        /* 0x5018 */
    KANJI,        /* 0x5019 */
    KANJI,        /* 0x501a */
    KANJI,        /* 0x501b */
    KANJI,        /* 0x501c */
    KANJI,        /* 0x501d */
    KANJI,        /* 0x501e */
    KANJI,        /* 0x501f */
    KANJI,        /* 0x5020 */
    KANJI,        /* 0x5021 */
    KANJI,        /* 0x5022 */
    KANJI,        /* 0x5023 */
    KANJI,        /* 0x5024 */
    KANJI,        /* 0x5025 */
    KANJI,        /* 0x5026 */
    KANJI,        /* 0x5027 */
    KANJI,        /* 0x5028 */
    KANJI,        /* 0x5029 */
    KANJI,        /* 0x502a */
    KANJI,        /* 0x502b */
    KANJI,        /* 0x502c */
    KANJI,        /* 0x502d */
    KANJI,        /* 0x502e */
    KANJI,        /* 0x502f */
    KANJI,        /* 0x5030 */
    KANJI,        /* 0x5031 */
    KANJI,        /* 0x5032 */
    KANJI,        /* 0x5033 */
    KANJI,        /* 0x5034 */
    KANJI,        /* 0x5035 */
    KANJI,        /* 0x5036 */
    KANJI,        /* 0x5037 */
    KANJI,        /* 0x5038 */
    KANJI,        /* 0x5039 */
    KANJI,        /* 0x503a */
    KANJI,        /* 0x503b */
    KANJI,        /* 0x503c */
    KANJI,        /* 0x503d */
    KANJI,        /* 0x503e */
    KANJI,        /* 0x503f */
    KANJI,        /* 0x5040 */
    KANJI,        /* 0x5041 */
    KANJI,        /* 0x5042 */
    KANJI,        /* 0x5043 */
    KANJI,        /* 0x5044 */
    KANJI,        /* 0x5045 */
    KANJI,        /* 0x5046 */
    KANJI,        /* 0x5047 */
    KANJI,        /* 0x5048 */
    KANJI,        /* 0x5049 */
    KANJI,        /* 0x504a */
    KANJI,        /* 0x504b */
    KANJI,        /* 0x504c */
    KANJI,        /* 0x504d */
    KANJI,        /* 0x504e */
    KANJI,        /* 0x504f */
    KANJI,        /* 0x5050 */
    KANJI,        /* 0x5051 */
    KANJI,        /* 0x5052 */
    KANJI,        /* 0x5053 */
    KANJI,        /* 0x5054 */
    KANJI,        /* 0x5055 */
    KANJI,        /* 0x5056 */
    KANJI,        /* 0x5057 */
    KANJI,        /* 0x5058 */
    KANJI,        /* 0x5059 */
    KANJI,        /* 0x505a */
    KANJI,        /* 0x505b */
    KANJI,        /* 0x505c */
    KANJI,        /* 0x505d */
    KANJI,        /* 0x505e */
    KANJI,        /* 0x505f */
    KANJI,        /* 0x5060 */
    KANJI,        /* 0x5061 */
    KANJI,        /* 0x5062 */
    KANJI,        /* 0x5063 */
    KANJI,        /* 0x5064 */
    KANJI,        /* 0x5065 */
    KANJI,        /* 0x5066 */
    KANJI,        /* 0x5067 */
    KANJI,        /* 0x5068 */
    KANJI,        /* 0x5069 */
    KANJI,        /* 0x506a */
    KANJI,        /* 0x506b */
    KANJI,        /* 0x506c */
    KANJI,        /* 0x506d */
    KANJI,        /* 0x506e */
    KANJI,        /* 0x506f */
    KANJI,        /* 0x5070 */
    KANJI,        /* 0x5071 */
    KANJI,        /* 0x5072 */
    KANJI,        /* 0x5073 */
    KANJI,        /* 0x5074 */
    KANJI,        /* 0x5075 */
    KANJI,        /* 0x5076 */
    KANJI,        /* 0x5077 */
    KANJI,        /* 0x5078 */
    KANJI,        /* 0x5079 */
    KANJI,        /* 0x507a */
    KANJI,        /* 0x507b */
    KANJI,        /* 0x507c */
    KANJI,        /* 0x507d */
    KANJI,        /* 0x507e */
    KANJI,        /* 0x507f */
    KANJI,        /* 0x5080 */
    KANJI,        /* 0x5081 */
    KANJI,        /* 0x5082 */
    KANJI,        /* 0x5083 */
    KANJI,        /* 0x5084 */
    KANJI,        /* 0x5085 */
    KANJI,        /* 0x5086 */
    KANJI,        /* 0x5087 */
    KANJI,        /* 0x5088 */
    KANJI,        /* 0x5089 */
    KANJI,        /* 0x508a */
    KANJI,        /* 0x508b */
    KANJI,        /* 0x508c */
    KANJI,        /* 0x508d */
    KANJI,        /* 0x508e */
    KANJI,        /* 0x508f */
    KANJI,        /* 0x5090 */
    KANJI,        /* 0x5091 */
    KANJI,        /* 0x5092 */
    KANJI,        /* 0x5093 */
    KANJI,        /* 0x5094 */
    KANJI,        /* 0x5095 */
    KANJI,        /* 0x5096 */
    KANJI,        /* 0x5097 */
    KANJI,        /* 0x5098 */
    KANJI,        /* 0x5099 */
    KANJI,        /* 0x509a */
    KANJI,        /* 0x509b */
    KANJI,        /* 0x509c */
    KANJI,        /* 0x509d */
    KANJI,        /* 0x509e */
    KANJI,        /* 0x509f */
    KANJI,        /* 0x50a0 */
    KANJI,        /* 0x50a1 */
    KANJI,        /* 0x50a2 */
    KANJI,        /* 0x50a3 */
    KANJI,        /* 0x50a4 */
    KANJI,        /* 0x50a5 */
    KANJI,        /* 0x50a6 */
    KANJI,        /* 0x50a7 */
    KANJI,        /* 0x50a8 */
    KANJI,        /* 0x50a9 */
    KANJI,        /* 0x50aa */
    KANJI,        /* 0x50ab */
    KANJI,        /* 0x50ac */
    KANJI,        /* 0x50ad */
    KANJI,        /* 0x50ae */
    KANJI,        /* 0x50af */
    KANJI,        /* 0x50b0 */
    KANJI,        /* 0x50b1 */
    KANJI,        /* 0x50b2 */
    KANJI,        /* 0x50b3 */
    KANJI,        /* 0x50b4 */
    KANJI,        /* 0x50b5 */
    KANJI,        /* 0x50b6 */
    KANJI,        /* 0x50b7 */
    KANJI,        /* 0x50b8 */
    KANJI,        /* 0x50b9 */
    KANJI,        /* 0x50ba */
    KANJI,        /* 0x50bb */
    KANJI,        /* 0x50bc */
    KANJI,        /* 0x50bd */
    KANJI,        /* 0x50be */
    KANJI,        /* 0x50bf */
    KANJI,        /* 0x50c0 */
    KANJI,        /* 0x50c1 */
    KANJI,        /* 0x50c2 */
    KANJI,        /* 0x50c3 */
    KANJI,        /* 0x50c4 */
    KANJI,        /* 0x50c5 */
    KANJI,        /* 0x50c6 */
    KANJI,        /* 0x50c7 */
    KANJI,        /* 0x50c8 */
    KANJI,        /* 0x50c9 */
    KANJI,        /* 0x50ca */
    KANJI,        /* 0x50cb */
    KANJI,        /* 0x50cc */
    KANJI,        /* 0x50cd */
    KANJI,        /* 0x50ce */
    KANJI,        /* 0x50cf */
    KANJI,        /* 0x50d0 */
    KANJI,        /* 0x50d1 */
    KANJI,        /* 0x50d2 */
    KANJI,        /* 0x50d3 */
    KANJI,        /* 0x50d4 */
    KANJI,        /* 0x50d5 */
    KANJI,        /* 0x50d6 */
    KANJI,        /* 0x50d7 */
    KANJI,        /* 0x50d8 */
    KANJI,        /* 0x50d9 */
    KANJI,        /* 0x50da */
    KANJI,        /* 0x50db */
    KANJI,        /* 0x50dc */
    KANJI,        /* 0x50dd */
    KANJI,        /* 0x50de */
    KANJI,        /* 0x50df */
    KANJI,        /* 0x50e0 */
    KANJI,        /* 0x50e1 */
    KANJI,        /* 0x50e2 */
    KANJI,        /* 0x50e3 */
    KANJI,        /* 0x50e4 */
    KANJI,        /* 0x50e5 */
    KANJI,        /* 0x50e6 */
    KANJI,        /* 0x50e7 */
    KANJI,        /* 0x50e8 */
    KANJI,        /* 0x50e9 */
    KANJI,        /* 0x50ea */
    KANJI,        /* 0x50eb */
    KANJI,        /* 0x50ec */
    KANJI,        /* 0x50ed */
    KANJI,        /* 0x50ee */
    KANJI,        /* 0x50ef */
    KANJI,        /* 0x50f0 */
    KANJI,        /* 0x50f1 */
    KANJI,        /* 0x50f2 */
    KANJI,        /* 0x50f3 */
    KANJI,        /* 0x50f4 */
    KANJI,        /* 0x50f5 */
    KANJI,        /* 0x50f6 */
    KANJI,        /* 0x50f7 */
    KANJI,        /* 0x50f8 */
    KANJI,        /* 0x50f9 */
    KANJI,        /* 0x50fa */
    KANJI,        /* 0x50fb */
    KANJI,        /* 0x50fc */
    KANJI,        /* 0x50fd */
    KANJI,        /* 0x50fe */
    KANJI,        /* 0x50ff */
    KANJI,        /* 0x5100 */
    KANJI,        /* 0x5101 */
    KANJI,        /* 0x5102 */
    KANJI,        /* 0x5103 */
    KANJINUMERIC,        /* 0x5104 */
    KANJI,        /* 0x5105 */
    KANJI,        /* 0x5106 */
    KANJI,        /* 0x5107 */
    KANJI,        /* 0x5108 */
    KANJI,        /* 0x5109 */
    KANJI,        /* 0x510a */
    KANJI,        /* 0x510b */
    KANJI,        /* 0x510c */
    KANJI,        /* 0x510d */
    KANJI,        /* 0x510e */
    KANJI,        /* 0x510f */
    KANJI,        /* 0x5110 */
    KANJI,        /* 0x5111 */
    KANJI,        /* 0x5112 */
    KANJI,        /* 0x5113 */
    KANJI,        /* 0x5114 */
    KANJI,        /* 0x5115 */
    KANJI,        /* 0x5116 */
    KANJI,        /* 0x5117 */
    KANJI,        /* 0x5118 */
    KANJI,        /* 0x5119 */
    KANJI,        /* 0x511a */
    KANJI,        /* 0x511b */
    KANJI,        /* 0x511c */
    KANJI,        /* 0x511d */
    KANJI,        /* 0x511e */
    KANJI,        /* 0x511f */
    KANJI,        /* 0x5120 */
    KANJI,        /* 0x5121 */
    KANJI,        /* 0x5122 */
    KANJI,        /* 0x5123 */
    KANJI,        /* 0x5124 */
    KANJI,        /* 0x5125 */
    KANJI,        /* 0x5126 */
    KANJI,        /* 0x5127 */
    KANJI,        /* 0x5128 */
    KANJI,        /* 0x5129 */
    KANJI,        /* 0x512a */
    KANJI,        /* 0x512b */
    KANJI,        /* 0x512c */
    KANJI,        /* 0x512d */
    KANJI,        /* 0x512e */
    KANJI,        /* 0x512f */
    KANJI,        /* 0x5130 */
    KANJI,        /* 0x5131 */
    KANJI,        /* 0x5132 */
    KANJI,        /* 0x5133 */
    KANJI,        /* 0x5134 */
    KANJI,        /* 0x5135 */
    KANJI,        /* 0x5136 */
    KANJI,        /* 0x5137 */
    KANJI,        /* 0x5138 */
    KANJI,        /* 0x5139 */
    KANJI,        /* 0x513a */
    KANJI,        /* 0x513b */
    KANJI,        /* 0x513c */
    KANJI,        /* 0x513d */
    KANJI,        /* 0x513e */
    KANJI,        /* 0x513f */
    KANJI,        /* 0x5140 */
    KANJI,        /* 0x5141 */
    KANJI,        /* 0x5142 */
    KANJI,        /* 0x5143 */
    KANJI,        /* 0x5144 */
    KANJI,        /* 0x5145 */
    KANJINUMERIC,        /* 0x5146 */
    KANJI,        /* 0x5147 */
    KANJI,        /* 0x5148 */
    KANJI,        /* 0x5149 */
    KANJI,        /* 0x514a */
    KANJI,        /* 0x514b */
    KANJI,        /* 0x514c */
    KANJI,        /* 0x514d */
    KANJI,        /* 0x514e */
    KANJI,        /* 0x514f */
    KANJI,        /* 0x5150 */
    KANJI,        /* 0x5151 */
    KANJI,        /* 0x5152 */
    KANJI,        /* 0x5153 */
    KANJI,        /* 0x5154 */
    KANJI,        /* 0x5155 */
    KANJI,        /* 0x5156 */
    KANJI,        /* 0x5157 */
    KANJI,        /* 0x5158 */
    KANJI,        /* 0x5159 */
    KANJI,        /* 0x515a */
    KANJI,        /* 0x515b */
    KANJI,        /* 0x515c */
    KANJI,        /* 0x515d */
    KANJI,        /* 0x515e */
    KANJI,        /* 0x515f */
    KANJI,        /* 0x5160 */
    KANJI,        /* 0x5161 */
    KANJI,        /* 0x5162 */
    KANJI,        /* 0x5163 */
    KANJI,        /* 0x5164 */
    KANJI,        /* 0x5165 */
    KANJI,        /* 0x5166 */
    KANJI,        /* 0x5167 */
    KANJI,        /* 0x5168 */
    KANJI,        /* 0x5169 */
    KANJI,        /* 0x516a */
    KANJINUMERIC,        /* 0x516b */
    KANJI,        /* 0x516c */
    KANJINUMERIC,        /* 0x516d */
    KANJI,        /* 0x516e */
    KANJI,        /* 0x516f */
    KANJI,        /* 0x5170 */
    KANJI,        /* 0x5171 */
    KANJI,        /* 0x5172 */
    KANJI,        /* 0x5173 */
    KANJI,        /* 0x5174 */
    KANJI,        /* 0x5175 */
    KANJI,        /* 0x5176 */
    KANJI,        /* 0x5177 */
    KANJI,        /* 0x5178 */
    KANJI,        /* 0x5179 */
    KANJI,        /* 0x517a */
    KANJI,        /* 0x517b */
    KANJI,        /* 0x517c */
    KANJI,        /* 0x517d */
    KANJI,        /* 0x517e */
    KANJI,        /* 0x517f */
    KANJI,        /* 0x5180 */
    KANJI,        /* 0x5181 */
    KANJI,        /* 0x5182 */
    KANJI,        /* 0x5183 */
    KANJI,        /* 0x5184 */
    KANJI,        /* 0x5185 */
    KANJI,        /* 0x5186 */
    KANJI,        /* 0x5187 */
    KANJI,        /* 0x5188 */
    KANJI,        /* 0x5189 */
    KANJI,        /* 0x518a */
    KANJI,        /* 0x518b */
    KANJI,        /* 0x518c */
    KANJI,        /* 0x518d */
    KANJI,        /* 0x518e */
    KANJI,        /* 0x518f */
    KANJI,        /* 0x5190 */
    KANJI,        /* 0x5191 */
    KANJI,        /* 0x5192 */
    KANJI,        /* 0x5193 */
    KANJI,        /* 0x5194 */
    KANJI,        /* 0x5195 */
    KANJI,        /* 0x5196 */
    KANJI,        /* 0x5197 */
    KANJI,        /* 0x5198 */
    KANJI,        /* 0x5199 */
    KANJI,        /* 0x519a */
    KANJI,        /* 0x519b */
    KANJI,        /* 0x519c */
    KANJI,        /* 0x519d */
    KANJI,        /* 0x519e */
    KANJI,        /* 0x519f */
    KANJI,        /* 0x51a0 */
    KANJI,        /* 0x51a1 */
    KANJI,        /* 0x51a2 */
    KANJI,        /* 0x51a3 */
    KANJI,        /* 0x51a4 */
    KANJI,        /* 0x51a5 */
    KANJI,        /* 0x51a6 */
    KANJI,        /* 0x51a7 */
    KANJI,        /* 0x51a8 */
    KANJI,        /* 0x51a9 */
    KANJI,        /* 0x51aa */
    KANJI,        /* 0x51ab */
    KANJI,        /* 0x51ac */
    KANJI,        /* 0x51ad */
    KANJI,        /* 0x51ae */
    KANJI,        /* 0x51af */
    KANJI,        /* 0x51b0 */
    KANJI,        /* 0x51b1 */
    KANJI,        /* 0x51b2 */
    KANJI,        /* 0x51b3 */
    KANJI,        /* 0x51b4 */
    KANJI,        /* 0x51b5 */
    KANJI,        /* 0x51b6 */
    KANJI,        /* 0x51b7 */
    KANJI,        /* 0x51b8 */
    KANJI,        /* 0x51b9 */
    KANJI,        /* 0x51ba */
    KANJI,        /* 0x51bb */
    KANJI,        /* 0x51bc */
    KANJI,        /* 0x51bd */
    KANJI,        /* 0x51be */
    KANJI,        /* 0x51bf */
    KANJI,        /* 0x51c0 */
    KANJI,        /* 0x51c1 */
    KANJI,        /* 0x51c2 */
    KANJI,        /* 0x51c3 */
    KANJI,        /* 0x51c4 */
    KANJI,        /* 0x51c5 */
    KANJI,        /* 0x51c6 */
    KANJI,        /* 0x51c7 */
    KANJI,        /* 0x51c8 */
    KANJI,        /* 0x51c9 */
    KANJI,        /* 0x51ca */
    KANJI,        /* 0x51cb */
    KANJI,        /* 0x51cc */
    KANJI,        /* 0x51cd */
    KANJI,        /* 0x51ce */
    KANJI,        /* 0x51cf */
    KANJI,        /* 0x51d0 */
    KANJI,        /* 0x51d1 */
    KANJI,        /* 0x51d2 */
    KANJI,        /* 0x51d3 */
    KANJI,        /* 0x51d4 */
    KANJI,        /* 0x51d5 */
    KANJI,        /* 0x51d6 */
    KANJI,        /* 0x51d7 */
    KANJI,        /* 0x51d8 */
    KANJI,        /* 0x51d9 */
    KANJI,        /* 0x51da */
    KANJI,        /* 0x51db */
    KANJI,        /* 0x51dc */
    KANJI,        /* 0x51dd */
    KANJI,        /* 0x51de */
    KANJI,        /* 0x51df */
    KANJI,        /* 0x51e0 */
    KANJI,        /* 0x51e1 */
    KANJI,        /* 0x51e2 */
    KANJI,        /* 0x51e3 */
    KANJI,        /* 0x51e4 */
    KANJI,        /* 0x51e5 */
    KANJI,        /* 0x51e6 */
    KANJI,        /* 0x51e7 */
    KANJI,        /* 0x51e8 */
    KANJI,        /* 0x51e9 */
    KANJI,        /* 0x51ea */
    KANJI,        /* 0x51eb */
    KANJI,        /* 0x51ec */
    KANJI,        /* 0x51ed */
    KANJI,        /* 0x51ee */
    KANJI,        /* 0x51ef */
    KANJI,        /* 0x51f0 */
    KANJI,        /* 0x51f1 */
    KANJI,        /* 0x51f2 */
    KANJI,        /* 0x51f3 */
    KANJI,        /* 0x51f4 */
    KANJI,        /* 0x51f5 */
    KANJI,        /* 0x51f6 */
    KANJI,        /* 0x51f7 */
    KANJI,        /* 0x51f8 */
    KANJI,        /* 0x51f9 */
    KANJI,        /* 0x51fa */
    KANJI,        /* 0x51fb */
    KANJI,        /* 0x51fc */
    KANJI,        /* 0x51fd */
    KANJI,        /* 0x51fe */
    KANJI,        /* 0x51ff */
    KANJI,        /* 0x5200 */
    KANJI,        /* 0x5201 */
    KANJI,        /* 0x5202 */
    KANJI,        /* 0x5203 */
    KANJI,        /* 0x5204 */
    KANJI,        /* 0x5205 */
    KANJI,        /* 0x5206 */
    KANJI,        /* 0x5207 */
    KANJI,        /* 0x5208 */
    KANJI,        /* 0x5209 */
    KANJI,        /* 0x520a */
    KANJI,        /* 0x520b */
    KANJI,        /* 0x520c */
    KANJI,        /* 0x520d */
    KANJI,        /* 0x520e */
    KANJI,        /* 0x520f */
    KANJI,        /* 0x5210 */
    KANJI,        /* 0x5211 */
    KANJI,        /* 0x5212 */
    KANJI,        /* 0x5213 */
    KANJI,        /* 0x5214 */
    KANJI,        /* 0x5215 */
    KANJI,        /* 0x5216 */
    KANJI,        /* 0x5217 */
    KANJI,        /* 0x5218 */
    KANJI,        /* 0x5219 */
    KANJI,        /* 0x521a */
    KANJI,        /* 0x521b */
    KANJI,        /* 0x521c */
    KANJI,        /* 0x521d */
    KANJI,        /* 0x521e */
    KANJI,        /* 0x521f */
    KANJI,        /* 0x5220 */
    KANJI,        /* 0x5221 */
    KANJI,        /* 0x5222 */
    KANJI,        /* 0x5223 */
    KANJI,        /* 0x5224 */
    KANJI,        /* 0x5225 */
    KANJI,        /* 0x5226 */
    KANJI,        /* 0x5227 */
    KANJI,        /* 0x5228 */
    KANJI,        /* 0x5229 */
    KANJI,        /* 0x522a */
    KANJI,        /* 0x522b */
    KANJI,        /* 0x522c */
    KANJI,        /* 0x522d */
    KANJI,        /* 0x522e */
    KANJI,        /* 0x522f */
    KANJI,        /* 0x5230 */
    KANJI,        /* 0x5231 */
    KANJI,        /* 0x5232 */
    KANJI,        /* 0x5233 */
    KANJI,        /* 0x5234 */
    KANJI,        /* 0x5235 */
    KANJI,        /* 0x5236 */
    KANJI,        /* 0x5237 */
    KANJI,        /* 0x5238 */
    KANJI,        /* 0x5239 */
    KANJI,        /* 0x523a */
    KANJI,        /* 0x523b */
    KANJI,        /* 0x523c */
    KANJI,        /* 0x523d */
    KANJI,        /* 0x523e */
    KANJI,        /* 0x523f */
    KANJI,        /* 0x5240 */
    KANJI,        /* 0x5241 */
    KANJI,        /* 0x5242 */
    KANJI,        /* 0x5243 */
    KANJI,        /* 0x5244 */
    KANJI,        /* 0x5245 */
    KANJI,        /* 0x5246 */
    KANJI,        /* 0x5247 */
    KANJI,        /* 0x5248 */
    KANJI,        /* 0x5249 */
    KANJI,        /* 0x524a */
    KANJI,        /* 0x524b */
    KANJI,        /* 0x524c */
    KANJI,        /* 0x524d */
    KANJI,        /* 0x524e */
    KANJI,        /* 0x524f */
    KANJI,        /* 0x5250 */
    KANJI,        /* 0x5251 */
    KANJI,        /* 0x5252 */
    KANJI,        /* 0x5253 */
    KANJI,        /* 0x5254 */
    KANJI,        /* 0x5255 */
    KANJI,        /* 0x5256 */
    KANJI,        /* 0x5257 */
    KANJI,        /* 0x5258 */
    KANJI,        /* 0x5259 */
    KANJI,        /* 0x525a */
    KANJI,        /* 0x525b */
    KANJI,        /* 0x525c */
    KANJI,        /* 0x525d */
    KANJI,        /* 0x525e */
    KANJI,        /* 0x525f */
    KANJI,        /* 0x5260 */
    KANJI,        /* 0x5261 */
    KANJI,        /* 0x5262 */
    KANJI,        /* 0x5263 */
    KANJI,        /* 0x5264 */
    KANJI,        /* 0x5265 */
    KANJI,        /* 0x5266 */
    KANJI,        /* 0x5267 */
    KANJI,        /* 0x5268 */
    KANJI,        /* 0x5269 */
    KANJI,        /* 0x526a */
    KANJI,        /* 0x526b */
    KANJI,        /* 0x526c */
    KANJI,        /* 0x526d */
    KANJI,        /* 0x526e */
    KANJI,        /* 0x526f */
    KANJI,        /* 0x5270 */
    KANJI,        /* 0x5271 */
    KANJI,        /* 0x5272 */
    KANJI,        /* 0x5273 */
    KANJI,        /* 0x5274 */
    KANJI,        /* 0x5275 */
    KANJI,        /* 0x5276 */
    KANJI,        /* 0x5277 */
    KANJI,        /* 0x5278 */
    KANJI,        /* 0x5279 */
    KANJI,        /* 0x527a */
    KANJI,        /* 0x527b */
    KANJI,        /* 0x527c */
    KANJI,        /* 0x527d */
    KANJI,        /* 0x527e */
    KANJI,        /* 0x527f */
    KANJI,        /* 0x5280 */
    KANJI,        /* 0x5281 */
    KANJI,        /* 0x5282 */
    KANJI,        /* 0x5283 */
    KANJI,        /* 0x5284 */
    KANJI,        /* 0x5285 */
    KANJI,        /* 0x5286 */
    KANJI,        /* 0x5287 */
    KANJI,        /* 0x5288 */
    KANJI,        /* 0x5289 */
    KANJI,        /* 0x528a */
    KANJI,        /* 0x528b */
    KANJI,        /* 0x528c */
    KANJI,        /* 0x528d */
    KANJI,        /* 0x528e */
    KANJI,        /* 0x528f */
    KANJI,        /* 0x5290 */
    KANJI,        /* 0x5291 */
    KANJI,        /* 0x5292 */
    KANJI,        /* 0x5293 */
    KANJI,        /* 0x5294 */
    KANJI,        /* 0x5295 */
    KANJI,        /* 0x5296 */
    KANJI,        /* 0x5297 */
    KANJI,        /* 0x5298 */
    KANJI,        /* 0x5299 */
    KANJI,        /* 0x529a */
    KANJI,        /* 0x529b */
    KANJI,        /* 0x529c */
    KANJI,        /* 0x529d */
    KANJI,        /* 0x529e */
    KANJI,        /* 0x529f */
    KANJI,        /* 0x52a0 */
    KANJI,        /* 0x52a1 */
    KANJI,        /* 0x52a2 */
    KANJI,        /* 0x52a3 */
    KANJI,        /* 0x52a4 */
    KANJI,        /* 0x52a5 */
    KANJI,        /* 0x52a6 */
    KANJI,        /* 0x52a7 */
    KANJI,        /* 0x52a8 */
    KANJI,        /* 0x52a9 */
    KANJI,        /* 0x52aa */
    KANJI,        /* 0x52ab */
    KANJI,        /* 0x52ac */
    KANJI,        /* 0x52ad */
    KANJI,        /* 0x52ae */
    KANJI,        /* 0x52af */
    KANJI,        /* 0x52b0 */
    KANJI,        /* 0x52b1 */
    KANJI,        /* 0x52b2 */
    KANJI,        /* 0x52b3 */
    KANJI,        /* 0x52b4 */
    KANJI,        /* 0x52b5 */
    KANJI,        /* 0x52b6 */
    KANJI,        /* 0x52b7 */
    KANJI,        /* 0x52b8 */
    KANJI,        /* 0x52b9 */
    KANJI,        /* 0x52ba */
    KANJI,        /* 0x52bb */
    KANJI,        /* 0x52bc */
    KANJI,        /* 0x52bd */
    KANJI,        /* 0x52be */
    KANJI,        /* 0x52bf */
    KANJI,        /* 0x52c0 */
    KANJI,        /* 0x52c1 */
    KANJI,        /* 0x52c2 */
    KANJI,        /* 0x52c3 */
    KANJI,        /* 0x52c4 */
    KANJI,        /* 0x52c5 */
    KANJI,        /* 0x52c6 */
    KANJI,        /* 0x52c7 */
    KANJI,        /* 0x52c8 */
    KANJI,        /* 0x52c9 */
    KANJI,        /* 0x52ca */
    KANJI,        /* 0x52cb */
    KANJI,        /* 0x52cc */
    KANJI,        /* 0x52cd */
    KANJI,        /* 0x52ce */
    KANJI,        /* 0x52cf */
    KANJI,        /* 0x52d0 */
    KANJI,        /* 0x52d1 */
    KANJI,        /* 0x52d2 */
    KANJI,        /* 0x52d3 */
    KANJI,        /* 0x52d4 */
    KANJI,        /* 0x52d5 */
    KANJI,        /* 0x52d6 */
    KANJI,        /* 0x52d7 */
    KANJI,        /* 0x52d8 */
    KANJI,        /* 0x52d9 */
    KANJI,        /* 0x52da */
    KANJI,        /* 0x52db */
    KANJI,        /* 0x52dc */
    KANJI,        /* 0x52dd */
    KANJI,        /* 0x52de */
    KANJI,        /* 0x52df */
    KANJI,        /* 0x52e0 */
    KANJI,        /* 0x52e1 */
    KANJI,        /* 0x52e2 */
    KANJI,        /* 0x52e3 */
    KANJI,        /* 0x52e4 */
    KANJI,        /* 0x52e5 */
    KANJI,        /* 0x52e6 */
    KANJI,        /* 0x52e7 */
    KANJI,        /* 0x52e8 */
    KANJI,        /* 0x52e9 */
    KANJI,        /* 0x52ea */
    KANJI,        /* 0x52eb */
    KANJI,        /* 0x52ec */
    KANJI,        /* 0x52ed */
    KANJI,        /* 0x52ee */
    KANJI,        /* 0x52ef */
    KANJI,        /* 0x52f0 */
    KANJI,        /* 0x52f1 */
    KANJI,        /* 0x52f2 */
    KANJI,        /* 0x52f3 */
    KANJI,        /* 0x52f4 */
    KANJI,        /* 0x52f5 */
    KANJI,        /* 0x52f6 */
    KANJI,        /* 0x52f7 */
    KANJI,        /* 0x52f8 */
    KANJI,        /* 0x52f9 */
    KANJI,        /* 0x52fa */
    KANJI,        /* 0x52fb */
    KANJI,        /* 0x52fc */
    KANJI,        /* 0x52fd */
    KANJI,        /* 0x52fe */
    KANJI,        /* 0x52ff */
    KANJI,        /* 0x5300 */
    KANJI,        /* 0x5301 */
    KANJI,        /* 0x5302 */
    KANJI,        /* 0x5303 */
    KANJI,        /* 0x5304 */
    KANJI,        /* 0x5305 */
    KANJI,        /* 0x5306 */
    KANJI,        /* 0x5307 */
    KANJI,        /* 0x5308 */
    KANJI,        /* 0x5309 */
    KANJI,        /* 0x530a */
    KANJI,        /* 0x530b */
    KANJI,        /* 0x530c */
    KANJI,        /* 0x530d */
    KANJI,        /* 0x530e */
    KANJI,        /* 0x530f */
    KANJI,        /* 0x5310 */
    KANJI,        /* 0x5311 */
    KANJI,        /* 0x5312 */
    KANJI,        /* 0x5313 */
    KANJI,        /* 0x5314 */
    KANJI,        /* 0x5315 */
    KANJI,        /* 0x5316 */
    KANJI,        /* 0x5317 */
    KANJI,        /* 0x5318 */
    KANJI,        /* 0x5319 */
    KANJI,        /* 0x531a */
    KANJI,        /* 0x531b */
    KANJI,        /* 0x531c */
    KANJI,        /* 0x531d */
    KANJI,        /* 0x531e */
    KANJI,        /* 0x531f */
    KANJI,        /* 0x5320 */
    KANJI,        /* 0x5321 */
    KANJI,        /* 0x5322 */
    KANJI,        /* 0x5323 */
    KANJI,        /* 0x5324 */
    KANJI,        /* 0x5325 */
    KANJI,        /* 0x5326 */
    KANJI,        /* 0x5327 */
    KANJI,        /* 0x5328 */
    KANJI,        /* 0x5329 */
    KANJI,        /* 0x532a */
    KANJI,        /* 0x532b */
    KANJI,        /* 0x532c */
    KANJI,        /* 0x532d */
    KANJI,        /* 0x532e */
    KANJI,        /* 0x532f */
    KANJI,        /* 0x5330 */
    KANJI,        /* 0x5331 */
    KANJI,        /* 0x5332 */
    KANJI,        /* 0x5333 */
    KANJI,        /* 0x5334 */
    KANJI,        /* 0x5335 */
    KANJI,        /* 0x5336 */
    KANJI,        /* 0x5337 */
    KANJI,        /* 0x5338 */
    KANJI,        /* 0x5339 */
    KANJI,        /* 0x533a */
    KANJI,        /* 0x533b */
    KANJI,        /* 0x533c */
    KANJI,        /* 0x533d */
    KANJI,        /* 0x533e */
    KANJI,        /* 0x533f */
    KANJI,        /* 0x5340 */
    KANJINUMERIC,        /* 0x5341 */
    KANJI,        /* 0x5342 */
    KANJINUMERIC,        /* 0x5343 */
    KANJI,        /* 0x5344 */
    KANJI,        /* 0x5345 */
    KANJI,        /* 0x5346 */
    KANJI,        /* 0x5347 */
    KANJI,        /* 0x5348 */
    KANJI,        /* 0x5349 */
    KANJI,        /* 0x534a */
    KANJI,        /* 0x534b */
    KANJI,        /* 0x534c */
    KANJI,        /* 0x534d */
    KANJI,        /* 0x534e */
    KANJI,        /* 0x534f */
    KANJI,        /* 0x5350 */
    KANJI,        /* 0x5351 */
    KANJI,        /* 0x5352 */
    KANJI,        /* 0x5353 */
    KANJI,        /* 0x5354 */
    KANJI,        /* 0x5355 */
    KANJI,        /* 0x5356 */
    KANJI,        /* 0x5357 */
    KANJI,        /* 0x5358 */
    KANJI,        /* 0x5359 */
    KANJI,        /* 0x535a */
    KANJI,        /* 0x535b */
    KANJI,        /* 0x535c */
    KANJI,        /* 0x535d */
    KANJI,        /* 0x535e */
    KANJI,        /* 0x535f */
    KANJI,        /* 0x5360 */
    KANJI,        /* 0x5361 */
    KANJI,        /* 0x5362 */
    KANJI,        /* 0x5363 */
    KANJI,        /* 0x5364 */
    KANJI,        /* 0x5365 */
    KANJI,        /* 0x5366 */
    KANJI,        /* 0x5367 */
    KANJI,        /* 0x5368 */
    KANJI,        /* 0x5369 */
    KANJI,        /* 0x536a */
    KANJI,        /* 0x536b */
    KANJI,        /* 0x536c */
    KANJI,        /* 0x536d */
    KANJI,        /* 0x536e */
    KANJI,        /* 0x536f */
    KANJI,        /* 0x5370 */
    KANJI,        /* 0x5371 */
    KANJI,        /* 0x5372 */
    KANJI,        /* 0x5373 */
    KANJI,        /* 0x5374 */
    KANJI,        /* 0x5375 */
    KANJI,        /* 0x5376 */
    KANJI,        /* 0x5377 */
    KANJI,        /* 0x5378 */
    KANJI,        /* 0x5379 */
    KANJI,        /* 0x537a */
    KANJI,        /* 0x537b */
    KANJI,        /* 0x537c */
    KANJI,        /* 0x537d */
    KANJI,        /* 0x537e */
    KANJI,        /* 0x537f */
    KANJI,        /* 0x5380 */
    KANJI,        /* 0x5381 */
    KANJI,        /* 0x5382 */
    KANJI,        /* 0x5383 */
    KANJI,        /* 0x5384 */
    KANJI,        /* 0x5385 */
    KANJI,        /* 0x5386 */
    KANJI,        /* 0x5387 */
    KANJI,        /* 0x5388 */
    KANJI,        /* 0x5389 */
    KANJI,        /* 0x538a */
    KANJI,        /* 0x538b */
    KANJI,        /* 0x538c */
    KANJI,        /* 0x538d */
    KANJI,        /* 0x538e */
    KANJI,        /* 0x538f */
    KANJI,        /* 0x5390 */
    KANJI,        /* 0x5391 */
    KANJI,        /* 0x5392 */
    KANJI,        /* 0x5393 */
    KANJI,        /* 0x5394 */
    KANJI,        /* 0x5395 */
    KANJI,        /* 0x5396 */
    KANJI,        /* 0x5397 */
    KANJI,        /* 0x5398 */
    KANJI,        /* 0x5399 */
    KANJI,        /* 0x539a */
    KANJI,        /* 0x539b */
    KANJI,        /* 0x539c */
    KANJI,        /* 0x539d */
    KANJI,        /* 0x539e */
    KANJI,        /* 0x539f */
    KANJI,        /* 0x53a0 */
    KANJI,        /* 0x53a1 */
    KANJI,        /* 0x53a2 */
    KANJI,        /* 0x53a3 */
    KANJI,        /* 0x53a4 */
    KANJI,        /* 0x53a5 */
    KANJI,        /* 0x53a6 */
    KANJI,        /* 0x53a7 */
    KANJI,        /* 0x53a8 */
    KANJI,        /* 0x53a9 */
    KANJI,        /* 0x53aa */
    KANJI,        /* 0x53ab */
    KANJI,        /* 0x53ac */
    KANJI,        /* 0x53ad */
    KANJI,        /* 0x53ae */
    KANJI,        /* 0x53af */
    KANJI,        /* 0x53b0 */
    KANJI,        /* 0x53b1 */
    KANJI,        /* 0x53b2 */
    KANJI,        /* 0x53b3 */
    KANJI,        /* 0x53b4 */
    KANJI,        /* 0x53b5 */
    KANJI,        /* 0x53b6 */
    KANJI,        /* 0x53b7 */
    KANJI,        /* 0x53b8 */
    KANJI,        /* 0x53b9 */
    KANJI,        /* 0x53ba */
    KANJI,        /* 0x53bb */
    KANJI,        /* 0x53bc */
    KANJI,        /* 0x53bd */
    KANJI,        /* 0x53be */
    KANJI,        /* 0x53bf */
    KANJI,        /* 0x53c0 */
    KANJI,        /* 0x53c1 */
    KANJI,        /* 0x53c2 */
    KANJI,        /* 0x53c3 */
    KANJI,        /* 0x53c4 */
    KANJI,        /* 0x53c5 */
    KANJI,        /* 0x53c6 */
    KANJI,        /* 0x53c7 */
    KANJI,        /* 0x53c8 */
    KANJI,        /* 0x53c9 */
    KANJI,        /* 0x53ca */
    KANJI,        /* 0x53cb */
    KANJI,        /* 0x53cc */
    KANJI,        /* 0x53cd */
    KANJI,        /* 0x53ce */
    KANJI,        /* 0x53cf */
    KANJI,        /* 0x53d0 */
    KANJI,        /* 0x53d1 */
    KANJI,        /* 0x53d2 */
    KANJI,        /* 0x53d3 */
    KANJI,        /* 0x53d4 */
    KANJI,        /* 0x53d5 */
    KANJI,        /* 0x53d6 */
    KANJI,        /* 0x53d7 */
    KANJI,        /* 0x53d8 */
    KANJI,        /* 0x53d9 */
    KANJI,        /* 0x53da */
    KANJI,        /* 0x53db */
    KANJI,        /* 0x53dc */
    KANJI,        /* 0x53dd */
    KANJI,        /* 0x53de */
    KANJI,        /* 0x53df */
    KANJI,        /* 0x53e0 */
    KANJI,        /* 0x53e1 */
    KANJI,        /* 0x53e2 */
    KANJI,        /* 0x53e3 */
    KANJI,        /* 0x53e4 */
    KANJI,        /* 0x53e5 */
    KANJI,        /* 0x53e6 */
    KANJI,        /* 0x53e7 */
    KANJI,        /* 0x53e8 */
    KANJI,        /* 0x53e9 */
    KANJI,        /* 0x53ea */
    KANJI,        /* 0x53eb */
    KANJI,        /* 0x53ec */
    KANJI,        /* 0x53ed */
    KANJI,        /* 0x53ee */
    KANJI,        /* 0x53ef */
    KANJI,        /* 0x53f0 */
    KANJI,        /* 0x53f1 */
    KANJI,        /* 0x53f2 */
    KANJI,        /* 0x53f3 */
    KANJI,        /* 0x53f4 */
    KANJI,        /* 0x53f5 */
    KANJI,        /* 0x53f6 */
    KANJI,        /* 0x53f7 */
    KANJI,        /* 0x53f8 */
    KANJI,        /* 0x53f9 */
    KANJI,        /* 0x53fa */
    KANJI,        /* 0x53fb */
    KANJI,        /* 0x53fc */
    KANJI,        /* 0x53fd */
    KANJI,        /* 0x53fe */
    KANJI,        /* 0x53ff */
    KANJI,        /* 0x5400 */
    KANJI,        /* 0x5401 */
    KANJI,        /* 0x5402 */
    KANJI,        /* 0x5403 */
    KANJI,        /* 0x5404 */
    KANJI,        /* 0x5405 */
    KANJI,        /* 0x5406 */
    KANJI,        /* 0x5407 */
    KANJI,        /* 0x5408 */
    KANJI,        /* 0x5409 */
    KANJI,        /* 0x540a */
    KANJI,        /* 0x540b */
    KANJI,        /* 0x540c */
    KANJI,        /* 0x540d */
    KANJI,        /* 0x540e */
    KANJI,        /* 0x540f */
    KANJI,        /* 0x5410 */
    KANJI,        /* 0x5411 */
    KANJI,        /* 0x5412 */
    KANJI,        /* 0x5413 */
    KANJI,        /* 0x5414 */
    KANJI,        /* 0x5415 */
    KANJI,        /* 0x5416 */
    KANJI,        /* 0x5417 */
    KANJI,        /* 0x5418 */
    KANJI,        /* 0x5419 */
    KANJI,        /* 0x541a */
    KANJI,        /* 0x541b */
    KANJI,        /* 0x541c */
    KANJI,        /* 0x541d */
    KANJI,        /* 0x541e */
    KANJI,        /* 0x541f */
    KANJI,        /* 0x5420 */
    KANJI,        /* 0x5421 */
    KANJI,        /* 0x5422 */
    KANJI,        /* 0x5423 */
    KANJI,        /* 0x5424 */
    KANJI,        /* 0x5425 */
    KANJI,        /* 0x5426 */
    KANJI,        /* 0x5427 */
    KANJI,        /* 0x5428 */
    KANJI,        /* 0x5429 */
    KANJI,        /* 0x542a */
    KANJI,        /* 0x542b */
    KANJI,        /* 0x542c */
    KANJI,        /* 0x542d */
    KANJI,        /* 0x542e */
    KANJI,        /* 0x542f */
    KANJI,        /* 0x5430 */
    KANJI,        /* 0x5431 */
    KANJI,        /* 0x5432 */
    KANJI,        /* 0x5433 */
    KANJI,        /* 0x5434 */
    KANJI,        /* 0x5435 */
    KANJI,        /* 0x5436 */
    KANJI,        /* 0x5437 */
    KANJI,        /* 0x5438 */
    KANJI,        /* 0x5439 */
    KANJI,        /* 0x543a */
    KANJI,        /* 0x543b */
    KANJI,        /* 0x543c */
    KANJI,        /* 0x543d */
    KANJI,        /* 0x543e */
    KANJI,        /* 0x543f */
    KANJI,        /* 0x5440 */
    KANJI,        /* 0x5441 */
    KANJI,        /* 0x5442 */
    KANJI,        /* 0x5443 */
    KANJI,        /* 0x5444 */
    KANJI,        /* 0x5445 */
    KANJI,        /* 0x5446 */
    KANJI,        /* 0x5447 */
    KANJI,        /* 0x5448 */
    KANJI,        /* 0x5449 */
    KANJI,        /* 0x544a */
    KANJI,        /* 0x544b */
    KANJI,        /* 0x544c */
    KANJI,        /* 0x544d */
    KANJI,        /* 0x544e */
    KANJI,        /* 0x544f */
    KANJI,        /* 0x5450 */
    KANJI,        /* 0x5451 */
    KANJI,        /* 0x5452 */
    KANJI,        /* 0x5453 */
    KANJI,        /* 0x5454 */
    KANJI,        /* 0x5455 */
    KANJI,        /* 0x5456 */
    KANJI,        /* 0x5457 */
    KANJI,        /* 0x5458 */
    KANJI,        /* 0x5459 */
    KANJI,        /* 0x545a */
    KANJI,        /* 0x545b */
    KANJI,        /* 0x545c */
    KANJI,        /* 0x545d */
    KANJI,        /* 0x545e */
    KANJI,        /* 0x545f */
    KANJI,        /* 0x5460 */
    KANJI,        /* 0x5461 */
    KANJI,        /* 0x5462 */
    KANJI,        /* 0x5463 */
    KANJI,        /* 0x5464 */
    KANJI,        /* 0x5465 */
    KANJI,        /* 0x5466 */
    KANJI,        /* 0x5467 */
    KANJI,        /* 0x5468 */
    KANJI,        /* 0x5469 */
    KANJI,        /* 0x546a */
    KANJI,        /* 0x546b */
    KANJI,        /* 0x546c */
    KANJI,        /* 0x546d */
    KANJI,        /* 0x546e */
    KANJI,        /* 0x546f */
    KANJI,        /* 0x5470 */
    KANJI,        /* 0x5471 */
    KANJI,        /* 0x5472 */
    KANJI,        /* 0x5473 */
    KANJI,        /* 0x5474 */
    KANJI,        /* 0x5475 */
    KANJI,        /* 0x5476 */
    KANJI,        /* 0x5477 */
    KANJI,        /* 0x5478 */
    KANJI,        /* 0x5479 */
    KANJI,        /* 0x547a */
    KANJI,        /* 0x547b */
    KANJI,        /* 0x547c */
    KANJI,        /* 0x547d */
    KANJI,        /* 0x547e */
    KANJI,        /* 0x547f */
    KANJI,        /* 0x5480 */
    KANJI,        /* 0x5481 */
    KANJI,        /* 0x5482 */
    KANJI,        /* 0x5483 */
    KANJI,        /* 0x5484 */
    KANJI,        /* 0x5485 */
    KANJI,        /* 0x5486 */
    KANJI,        /* 0x5487 */
    KANJI,        /* 0x5488 */
    KANJI,        /* 0x5489 */
    KANJI,        /* 0x548a */
    KANJI,        /* 0x548b */
    KANJI,        /* 0x548c */
    KANJI,        /* 0x548d */
    KANJI,        /* 0x548e */
    KANJI,        /* 0x548f */
    KANJI,        /* 0x5490 */
    KANJI,        /* 0x5491 */
    KANJI,        /* 0x5492 */
    KANJI,        /* 0x5493 */
    KANJI,        /* 0x5494 */
    KANJI,        /* 0x5495 */
    KANJI,        /* 0x5496 */
    KANJI,        /* 0x5497 */
    KANJI,        /* 0x5498 */
    KANJI,        /* 0x5499 */
    KANJI,        /* 0x549a */
    KANJI,        /* 0x549b */
    KANJI,        /* 0x549c */
    KANJI,        /* 0x549d */
    KANJI,        /* 0x549e */
    KANJI,        /* 0x549f */
    KANJI,        /* 0x54a0 */
    KANJI,        /* 0x54a1 */
    KANJI,        /* 0x54a2 */
    KANJI,        /* 0x54a3 */
    KANJI,        /* 0x54a4 */
    KANJI,        /* 0x54a5 */
    KANJI,        /* 0x54a6 */
    KANJI,        /* 0x54a7 */
    KANJI,        /* 0x54a8 */
    KANJI,        /* 0x54a9 */
    KANJI,        /* 0x54aa */
    KANJI,        /* 0x54ab */
    KANJI,        /* 0x54ac */
    KANJI,        /* 0x54ad */
    KANJI,        /* 0x54ae */
    KANJI,        /* 0x54af */
    KANJI,        /* 0x54b0 */
    KANJI,        /* 0x54b1 */
    KANJI,        /* 0x54b2 */
    KANJI,        /* 0x54b3 */
    KANJI,        /* 0x54b4 */
    KANJI,        /* 0x54b5 */
    KANJI,        /* 0x54b6 */
    KANJI,        /* 0x54b7 */
    KANJI,        /* 0x54b8 */
    KANJI,        /* 0x54b9 */
    KANJI,        /* 0x54ba */
    KANJI,        /* 0x54bb */
    KANJI,        /* 0x54bc */
    KANJI,        /* 0x54bd */
    KANJI,        /* 0x54be */
    KANJI,        /* 0x54bf */
    KANJI,        /* 0x54c0 */
    KANJI,        /* 0x54c1 */
    KANJI,        /* 0x54c2 */
    KANJI,        /* 0x54c3 */
    KANJI,        /* 0x54c4 */
    KANJI,        /* 0x54c5 */
    KANJI,        /* 0x54c6 */
    KANJI,        /* 0x54c7 */
    KANJI,        /* 0x54c8 */
    KANJI,        /* 0x54c9 */
    KANJI,        /* 0x54ca */
    KANJI,        /* 0x54cb */
    KANJI,        /* 0x54cc */
    KANJI,        /* 0x54cd */
    KANJI,        /* 0x54ce */
    KANJI,        /* 0x54cf */
    KANJI,        /* 0x54d0 */
    KANJI,        /* 0x54d1 */
    KANJI,        /* 0x54d2 */
    KANJI,        /* 0x54d3 */
    KANJI,        /* 0x54d4 */
    KANJI,        /* 0x54d5 */
    KANJI,        /* 0x54d6 */
    KANJI,        /* 0x54d7 */
    KANJI,        /* 0x54d8 */
    KANJI,        /* 0x54d9 */
    KANJI,        /* 0x54da */
    KANJI,        /* 0x54db */
    KANJI,        /* 0x54dc */
    KANJI,        /* 0x54dd */
    KANJI,        /* 0x54de */
    KANJI,        /* 0x54df */
    KANJI,        /* 0x54e0 */
    KANJI,        /* 0x54e1 */
    KANJI,        /* 0x54e2 */
    KANJI,        /* 0x54e3 */
    KANJI,        /* 0x54e4 */
    KANJI,        /* 0x54e5 */
    KANJI,        /* 0x54e6 */
    KANJI,        /* 0x54e7 */
    KANJI,        /* 0x54e8 */
    KANJI,        /* 0x54e9 */
    KANJI,        /* 0x54ea */
    KANJI,        /* 0x54eb */
    KANJI,        /* 0x54ec */
    KANJI,        /* 0x54ed */
    KANJI,        /* 0x54ee */
    KANJI,        /* 0x54ef */
    KANJI,        /* 0x54f0 */
    KANJI,        /* 0x54f1 */
    KANJI,        /* 0x54f2 */
    KANJI,        /* 0x54f3 */
    KANJI,        /* 0x54f4 */
    KANJI,        /* 0x54f5 */
    KANJI,        /* 0x54f6 */
    KANJI,        /* 0x54f7 */
    KANJI,        /* 0x54f8 */
    KANJI,        /* 0x54f9 */
    KANJI,        /* 0x54fa */
    KANJI,        /* 0x54fb */
    KANJI,        /* 0x54fc */
    KANJI,        /* 0x54fd */
    KANJI,        /* 0x54fe */
    KANJI,        /* 0x54ff */
    KANJI,        /* 0x5500 */
    KANJI,        /* 0x5501 */
    KANJI,        /* 0x5502 */
    KANJI,        /* 0x5503 */
    KANJI,        /* 0x5504 */
    KANJI,        /* 0x5505 */
    KANJI,        /* 0x5506 */
    KANJI,        /* 0x5507 */
    KANJI,        /* 0x5508 */
    KANJI,        /* 0x5509 */
    KANJI,        /* 0x550a */
    KANJI,        /* 0x550b */
    KANJI,        /* 0x550c */
    KANJI,        /* 0x550d */
    KANJI,        /* 0x550e */
    KANJI,        /* 0x550f */
    KANJI,        /* 0x5510 */
    KANJI,        /* 0x5511 */
    KANJI,        /* 0x5512 */
    KANJI,        /* 0x5513 */
    KANJI,        /* 0x5514 */
    KANJI,        /* 0x5515 */
    KANJI,        /* 0x5516 */
    KANJI,        /* 0x5517 */
    KANJI,        /* 0x5518 */
    KANJI,        /* 0x5519 */
    KANJI,        /* 0x551a */
    KANJI,        /* 0x551b */
    KANJI,        /* 0x551c */
    KANJI,        /* 0x551d */
    KANJI,        /* 0x551e */
    KANJI,        /* 0x551f */
    KANJI,        /* 0x5520 */
    KANJI,        /* 0x5521 */
    KANJI,        /* 0x5522 */
    KANJI,        /* 0x5523 */
    KANJI,        /* 0x5524 */
    KANJI,        /* 0x5525 */
    KANJI,        /* 0x5526 */
    KANJI,        /* 0x5527 */
    KANJI,        /* 0x5528 */
    KANJI,        /* 0x5529 */
    KANJI,        /* 0x552a */
    KANJI,        /* 0x552b */
    KANJI,        /* 0x552c */
    KANJI,        /* 0x552d */
    KANJI,        /* 0x552e */
    KANJI,        /* 0x552f */
    KANJI,        /* 0x5530 */
    KANJI,        /* 0x5531 */
    KANJI,        /* 0x5532 */
    KANJI,        /* 0x5533 */
    KANJI,        /* 0x5534 */
    KANJI,        /* 0x5535 */
    KANJI,        /* 0x5536 */
    KANJI,        /* 0x5537 */
    KANJI,        /* 0x5538 */
    KANJI,        /* 0x5539 */
    KANJI,        /* 0x553a */
    KANJI,        /* 0x553b */
    KANJI,        /* 0x553c */
    KANJI,        /* 0x553d */
    KANJI,        /* 0x553e */
    KANJI,        /* 0x553f */
    KANJI,        /* 0x5540 */
    KANJI,        /* 0x5541 */
    KANJI,        /* 0x5542 */
    KANJI,        /* 0x5543 */
    KANJI,        /* 0x5544 */
    KANJI,        /* 0x5545 */
    KANJI,        /* 0x5546 */
    KANJI,        /* 0x5547 */
    KANJI,        /* 0x5548 */
    KANJI,        /* 0x5549 */
    KANJI,        /* 0x554a */
    KANJI,        /* 0x554b */
    KANJI,        /* 0x554c */
    KANJI,        /* 0x554d */
    KANJI,        /* 0x554e */
    KANJI,        /* 0x554f */
    KANJI,        /* 0x5550 */
    KANJI,        /* 0x5551 */
    KANJI,        /* 0x5552 */
    KANJI,        /* 0x5553 */
    KANJI,        /* 0x5554 */
    KANJI,        /* 0x5555 */
    KANJI,        /* 0x5556 */
    KANJI,        /* 0x5557 */
    KANJI,        /* 0x5558 */
    KANJI,        /* 0x5559 */
    KANJI,        /* 0x555a */
    KANJI,        /* 0x555b */
    KANJI,        /* 0x555c */
    KANJI,        /* 0x555d */
    KANJI,        /* 0x555e */
    KANJI,        /* 0x555f */
    KANJI,        /* 0x5560 */
    KANJI,        /* 0x5561 */
    KANJI,        /* 0x5562 */
    KANJI,        /* 0x5563 */
    KANJI,        /* 0x5564 */
    KANJI,        /* 0x5565 */
    KANJI,        /* 0x5566 */
    KANJI,        /* 0x5567 */
    KANJI,        /* 0x5568 */
    KANJI,        /* 0x5569 */
    KANJI,        /* 0x556a */
    KANJI,        /* 0x556b */
    KANJI,        /* 0x556c */
    KANJI,        /* 0x556d */
    KANJI,        /* 0x556e */
    KANJI,        /* 0x556f */
    KANJI,        /* 0x5570 */
    KANJI,        /* 0x5571 */
    KANJI,        /* 0x5572 */
    KANJI,        /* 0x5573 */
    KANJI,        /* 0x5574 */
    KANJI,        /* 0x5575 */
    KANJI,        /* 0x5576 */
    KANJI,        /* 0x5577 */
    KANJI,        /* 0x5578 */
    KANJI,        /* 0x5579 */
    KANJI,        /* 0x557a */
    KANJI,        /* 0x557b */
    KANJI,        /* 0x557c */
    KANJI,        /* 0x557d */
    KANJI,        /* 0x557e */
    KANJI,        /* 0x557f */
    KANJI,        /* 0x5580 */
    KANJI,        /* 0x5581 */
    KANJI,        /* 0x5582 */
    KANJI,        /* 0x5583 */
    KANJI,        /* 0x5584 */
    KANJI,        /* 0x5585 */
    KANJI,        /* 0x5586 */
    KANJI,        /* 0x5587 */
    KANJI,        /* 0x5588 */
    KANJI,        /* 0x5589 */
    KANJI,        /* 0x558a */
    KANJI,        /* 0x558b */
    KANJI,        /* 0x558c */
    KANJI,        /* 0x558d */
    KANJI,        /* 0x558e */
    KANJI,        /* 0x558f */
    KANJI,        /* 0x5590 */
    KANJI,        /* 0x5591 */
    KANJI,        /* 0x5592 */
    KANJI,        /* 0x5593 */
    KANJI,        /* 0x5594 */
    KANJI,        /* 0x5595 */
    KANJI,        /* 0x5596 */
    KANJI,        /* 0x5597 */
    KANJI,        /* 0x5598 */
    KANJI,        /* 0x5599 */
    KANJI,        /* 0x559a */
    KANJI,        /* 0x559b */
    KANJI,        /* 0x559c */
    KANJI,        /* 0x559d */
    KANJI,        /* 0x559e */
    KANJI,        /* 0x559f */
    KANJI,        /* 0x55a0 */
    KANJI,        /* 0x55a1 */
    KANJI,        /* 0x55a2 */
    KANJI,        /* 0x55a3 */
    KANJI,        /* 0x55a4 */
    KANJI,        /* 0x55a5 */
    KANJI,        /* 0x55a6 */
    KANJI,        /* 0x55a7 */
    KANJI,        /* 0x55a8 */
    KANJI,        /* 0x55a9 */
    KANJI,        /* 0x55aa */
    KANJI,        /* 0x55ab */
    KANJI,        /* 0x55ac */
    KANJI,        /* 0x55ad */
    KANJI,        /* 0x55ae */
    KANJI,        /* 0x55af */
    KANJI,        /* 0x55b0 */
    KANJI,        /* 0x55b1 */
    KANJI,        /* 0x55b2 */
    KANJI,        /* 0x55b3 */
    KANJI,        /* 0x55b4 */
    KANJI,        /* 0x55b5 */
    KANJI,        /* 0x55b6 */
    KANJI,        /* 0x55b7 */
    KANJI,        /* 0x55b8 */
    KANJI,        /* 0x55b9 */
    KANJI,        /* 0x55ba */
    KANJI,        /* 0x55bb */
    KANJI,        /* 0x55bc */
    KANJI,        /* 0x55bd */
    KANJI,        /* 0x55be */
    KANJI,        /* 0x55bf */
    KANJI,        /* 0x55c0 */
    KANJI,        /* 0x55c1 */
    KANJI,        /* 0x55c2 */
    KANJI,        /* 0x55c3 */
    KANJI,        /* 0x55c4 */
    KANJI,        /* 0x55c5 */
    KANJI,        /* 0x55c6 */
    KANJI,        /* 0x55c7 */
    KANJI,        /* 0x55c8 */
    KANJI,        /* 0x55c9 */
    KANJI,        /* 0x55ca */
    KANJI,        /* 0x55cb */
    KANJI,        /* 0x55cc */
    KANJI,        /* 0x55cd */
    KANJI,        /* 0x55ce */
    KANJI,        /* 0x55cf */
    KANJI,        /* 0x55d0 */
    KANJI,        /* 0x55d1 */
    KANJI,        /* 0x55d2 */
    KANJI,        /* 0x55d3 */
    KANJI,        /* 0x55d4 */
    KANJI,        /* 0x55d5 */
    KANJI,        /* 0x55d6 */
    KANJI,        /* 0x55d7 */
    KANJI,        /* 0x55d8 */
    KANJI,        /* 0x55d9 */
    KANJI,        /* 0x55da */
    KANJI,        /* 0x55db */
    KANJI,        /* 0x55dc */
    KANJI,        /* 0x55dd */
    KANJI,        /* 0x55de */
    KANJI,        /* 0x55df */
    KANJI,        /* 0x55e0 */
    KANJI,        /* 0x55e1 */
    KANJI,        /* 0x55e2 */
    KANJI,        /* 0x55e3 */
    KANJI,        /* 0x55e4 */
    KANJI,        /* 0x55e5 */
    KANJI,        /* 0x55e6 */
    KANJI,        /* 0x55e7 */
    KANJI,        /* 0x55e8 */
    KANJI,        /* 0x55e9 */
    KANJI,        /* 0x55ea */
    KANJI,        /* 0x55eb */
    KANJI,        /* 0x55ec */
    KANJI,        /* 0x55ed */
    KANJI,        /* 0x55ee */
    KANJI,        /* 0x55ef */
    KANJI,        /* 0x55f0 */
    KANJI,        /* 0x55f1 */
    KANJI,        /* 0x55f2 */
    KANJI,        /* 0x55f3 */
    KANJI,        /* 0x55f4 */
    KANJI,        /* 0x55f5 */
    KANJI,        /* 0x55f6 */
    KANJI,        /* 0x55f7 */
    KANJI,        /* 0x55f8 */
    KANJI,        /* 0x55f9 */
    KANJI,        /* 0x55fa */
    KANJI,        /* 0x55fb */
    KANJI,        /* 0x55fc */
    KANJI,        /* 0x55fd */
    KANJI,        /* 0x55fe */
    KANJI,        /* 0x55ff */
    KANJI,        /* 0x5600 */
    KANJI,        /* 0x5601 */
    KANJI,        /* 0x5602 */
    KANJI,        /* 0x5603 */
    KANJI,        /* 0x5604 */
    KANJI,        /* 0x5605 */
    KANJI,        /* 0x5606 */
    KANJI,        /* 0x5607 */
    KANJI,        /* 0x5608 */
    KANJI,        /* 0x5609 */
    KANJI,        /* 0x560a */
    KANJI,        /* 0x560b */
    KANJI,        /* 0x560c */
    KANJI,        /* 0x560d */
    KANJI,        /* 0x560e */
    KANJI,        /* 0x560f */
    KANJI,        /* 0x5610 */
    KANJI,        /* 0x5611 */
    KANJI,        /* 0x5612 */
    KANJI,        /* 0x5613 */
    KANJI,        /* 0x5614 */
    KANJI,        /* 0x5615 */
    KANJI,        /* 0x5616 */
    KANJI,        /* 0x5617 */
    KANJI,        /* 0x5618 */
    KANJI,        /* 0x5619 */
    KANJI,        /* 0x561a */
    KANJI,        /* 0x561b */
    KANJI,        /* 0x561c */
    KANJI,        /* 0x561d */
    KANJI,        /* 0x561e */
    KANJI,        /* 0x561f */
    KANJI,        /* 0x5620 */
    KANJI,        /* 0x5621 */
    KANJI,        /* 0x5622 */
    KANJI,        /* 0x5623 */
    KANJI,        /* 0x5624 */
    KANJI,        /* 0x5625 */
    KANJI,        /* 0x5626 */
    KANJI,        /* 0x5627 */
    KANJI,        /* 0x5628 */
    KANJI,        /* 0x5629 */
    KANJI,        /* 0x562a */
    KANJI,        /* 0x562b */
    KANJI,        /* 0x562c */
    KANJI,        /* 0x562d */
    KANJI,        /* 0x562e */
    KANJI,        /* 0x562f */
    KANJI,        /* 0x5630 */
    KANJI,        /* 0x5631 */
    KANJI,        /* 0x5632 */
    KANJI,        /* 0x5633 */
    KANJI,        /* 0x5634 */
    KANJI,        /* 0x5635 */
    KANJI,        /* 0x5636 */
    KANJI,        /* 0x5637 */
    KANJI,        /* 0x5638 */
    KANJI,        /* 0x5639 */
    KANJI,        /* 0x563a */
    KANJI,        /* 0x563b */
    KANJI,        /* 0x563c */
    KANJI,        /* 0x563d */
    KANJI,        /* 0x563e */
    KANJI,        /* 0x563f */
    KANJI,        /* 0x5640 */
    KANJI,        /* 0x5641 */
    KANJI,        /* 0x5642 */
    KANJI,        /* 0x5643 */
    KANJI,        /* 0x5644 */
    KANJI,        /* 0x5645 */
    KANJI,        /* 0x5646 */
    KANJI,        /* 0x5647 */
    KANJI,        /* 0x5648 */
    KANJI,        /* 0x5649 */
    KANJI,        /* 0x564a */
    KANJI,        /* 0x564b */
    KANJI,        /* 0x564c */
    KANJI,        /* 0x564d */
    KANJI,        /* 0x564e */
    KANJI,        /* 0x564f */
    KANJI,        /* 0x5650 */
    KANJI,        /* 0x5651 */
    KANJI,        /* 0x5652 */
    KANJI,        /* 0x5653 */
    KANJI,        /* 0x5654 */
    KANJI,        /* 0x5655 */
    KANJI,        /* 0x5656 */
    KANJI,        /* 0x5657 */
    KANJI,        /* 0x5658 */
    KANJI,        /* 0x5659 */
    KANJI,        /* 0x565a */
    KANJI,        /* 0x565b */
    KANJI,        /* 0x565c */
    KANJI,        /* 0x565d */
    KANJI,        /* 0x565e */
    KANJI,        /* 0x565f */
    KANJI,        /* 0x5660 */
    KANJI,        /* 0x5661 */
    KANJI,        /* 0x5662 */
    KANJI,        /* 0x5663 */
    KANJI,        /* 0x5664 */
    KANJI,        /* 0x5665 */
    KANJI,        /* 0x5666 */
    KANJI,        /* 0x5667 */
    KANJI,        /* 0x5668 */
    KANJI,        /* 0x5669 */
    KANJI,        /* 0x566a */
    KANJI,        /* 0x566b */
    KANJI,        /* 0x566c */
    KANJI,        /* 0x566d */
    KANJI,        /* 0x566e */
    KANJI,        /* 0x566f */
    KANJI,        /* 0x5670 */
    KANJI,        /* 0x5671 */
    KANJI,        /* 0x5672 */
    KANJI,        /* 0x5673 */
    KANJI,        /* 0x5674 */
    KANJI,        /* 0x5675 */
    KANJI,        /* 0x5676 */
    KANJI,        /* 0x5677 */
    KANJI,        /* 0x5678 */
    KANJI,        /* 0x5679 */
    KANJI,        /* 0x567a */
    KANJI,        /* 0x567b */
    KANJI,        /* 0x567c */
    KANJI,        /* 0x567d */
    KANJI,        /* 0x567e */
    KANJI,        /* 0x567f */
    KANJI,        /* 0x5680 */
    KANJI,        /* 0x5681 */
    KANJI,        /* 0x5682 */
    KANJI,        /* 0x5683 */
    KANJI,        /* 0x5684 */
    KANJI,        /* 0x5685 */
    KANJI,        /* 0x5686 */
    KANJI,        /* 0x5687 */
    KANJI,        /* 0x5688 */
    KANJI,        /* 0x5689 */
    KANJI,        /* 0x568a */
    KANJI,        /* 0x568b */
    KANJI,        /* 0x568c */
    KANJI,        /* 0x568d */
    KANJI,        /* 0x568e */
    KANJI,        /* 0x568f */
    KANJI,        /* 0x5690 */
    KANJI,        /* 0x5691 */
    KANJI,        /* 0x5692 */
    KANJI,        /* 0x5693 */
    KANJI,        /* 0x5694 */
    KANJI,        /* 0x5695 */
    KANJI,        /* 0x5696 */
    KANJI,        /* 0x5697 */
    KANJI,        /* 0x5698 */
    KANJI,        /* 0x5699 */
    KANJI,        /* 0x569a */
    KANJI,        /* 0x569b */
    KANJI,        /* 0x569c */
    KANJI,        /* 0x569d */
    KANJI,        /* 0x569e */
    KANJI,        /* 0x569f */
    KANJI,        /* 0x56a0 */
    KANJI,        /* 0x56a1 */
    KANJI,        /* 0x56a2 */
    KANJI,        /* 0x56a3 */
    KANJI,        /* 0x56a4 */
    KANJI,        /* 0x56a5 */
    KANJI,        /* 0x56a6 */
    KANJI,        /* 0x56a7 */
    KANJI,        /* 0x56a8 */
    KANJI,        /* 0x56a9 */
    KANJI,        /* 0x56aa */
    KANJI,        /* 0x56ab */
    KANJI,        /* 0x56ac */
    KANJI,        /* 0x56ad */
    KANJI,        /* 0x56ae */
    KANJI,        /* 0x56af */
    KANJI,        /* 0x56b0 */
    KANJI,        /* 0x56b1 */
    KANJI,        /* 0x56b2 */
    KANJI,        /* 0x56b3 */
    KANJI,        /* 0x56b4 */
    KANJI,        /* 0x56b5 */
    KANJI,        /* 0x56b6 */
    KANJI,        /* 0x56b7 */
    KANJI,        /* 0x56b8 */
    KANJI,        /* 0x56b9 */
    KANJI,        /* 0x56ba */
    KANJI,        /* 0x56bb */
    KANJI,        /* 0x56bc */
    KANJI,        /* 0x56bd */
    KANJI,        /* 0x56be */
    KANJI,        /* 0x56bf */
    KANJI,        /* 0x56c0 */
    KANJI,        /* 0x56c1 */
    KANJI,        /* 0x56c2 */
    KANJI,        /* 0x56c3 */
    KANJI,        /* 0x56c4 */
    KANJI,        /* 0x56c5 */
    KANJI,        /* 0x56c6 */
    KANJI,        /* 0x56c7 */
    KANJI,        /* 0x56c8 */
    KANJI,        /* 0x56c9 */
    KANJI,        /* 0x56ca */
    KANJI,        /* 0x56cb */
    KANJI,        /* 0x56cc */
    KANJI,        /* 0x56cd */
    KANJI,        /* 0x56ce */
    KANJI,        /* 0x56cf */
    KANJI,        /* 0x56d0 */
    KANJI,        /* 0x56d1 */
    KANJI,        /* 0x56d2 */
    KANJI,        /* 0x56d3 */
    KANJI,        /* 0x56d4 */
    KANJI,        /* 0x56d5 */
    KANJI,        /* 0x56d6 */
    KANJI,        /* 0x56d7 */
    KANJI,        /* 0x56d8 */
    KANJI,        /* 0x56d9 */
    KANJI,        /* 0x56da */
    KANJINUMERIC,        /* 0x56db */
    KANJI,        /* 0x56dc */
    KANJI,        /* 0x56dd */
    KANJI,        /* 0x56de */
    KANJI,        /* 0x56df */
    KANJI,        /* 0x56e0 */
    KANJI,        /* 0x56e1 */
    KANJI,        /* 0x56e2 */
    KANJI,        /* 0x56e3 */
    KANJI,        /* 0x56e4 */
    KANJI,        /* 0x56e5 */
    KANJI,        /* 0x56e6 */
    KANJI,        /* 0x56e7 */
    KANJI,        /* 0x56e8 */
    KANJI,        /* 0x56e9 */
    KANJI,        /* 0x56ea */
    KANJI,        /* 0x56eb */
    KANJI,        /* 0x56ec */
    KANJI,        /* 0x56ed */
    KANJI,        /* 0x56ee */
    KANJI,        /* 0x56ef */
    KANJI,        /* 0x56f0 */
    KANJI,        /* 0x56f1 */
    KANJI,        /* 0x56f2 */
    KANJI,        /* 0x56f3 */
    KANJI,        /* 0x56f4 */
    KANJI,        /* 0x56f5 */
    KANJI,        /* 0x56f6 */
    KANJI,        /* 0x56f7 */
    KANJI,        /* 0x56f8 */
    KANJI,        /* 0x56f9 */
    KANJI,        /* 0x56fa */
    KANJI,        /* 0x56fb */
    KANJI,        /* 0x56fc */
    KANJI,        /* 0x56fd */
    KANJI,        /* 0x56fe */
    KANJI,        /* 0x56ff */
    KANJI,        /* 0x5700 */
    KANJI,        /* 0x5701 */
    KANJI,        /* 0x5702 */
    KANJI,        /* 0x5703 */
    KANJI,        /* 0x5704 */
    KANJI,        /* 0x5705 */
    KANJI,        /* 0x5706 */
    KANJI,        /* 0x5707 */
    KANJI,        /* 0x5708 */
    KANJI,        /* 0x5709 */
    KANJI,        /* 0x570a */
    KANJI,        /* 0x570b */
    KANJI,        /* 0x570c */
    KANJI,        /* 0x570d */
    KANJI,        /* 0x570e */
    KANJI,        /* 0x570f */
    KANJI,        /* 0x5710 */
    KANJI,        /* 0x5711 */
    KANJI,        /* 0x5712 */
    KANJI,        /* 0x5713 */
    KANJI,        /* 0x5714 */
    KANJI,        /* 0x5715 */
    KANJI,        /* 0x5716 */
    KANJI,        /* 0x5717 */
    KANJI,        /* 0x5718 */
    KANJI,        /* 0x5719 */
    KANJI,        /* 0x571a */
    KANJI,        /* 0x571b */
    KANJI,        /* 0x571c */
    KANJI,        /* 0x571d */
    KANJI,        /* 0x571e */
    KANJI,        /* 0x571f */
    KANJI,        /* 0x5720 */
    KANJI,        /* 0x5721 */
    KANJI,        /* 0x5722 */
    KANJI,        /* 0x5723 */
    KANJI,        /* 0x5724 */
    KANJI,        /* 0x5725 */
    KANJI,        /* 0x5726 */
    KANJI,        /* 0x5727 */
    KANJI,        /* 0x5728 */
    KANJI,        /* 0x5729 */
    KANJI,        /* 0x572a */
    KANJI,        /* 0x572b */
    KANJI,        /* 0x572c */
    KANJI,        /* 0x572d */
    KANJI,        /* 0x572e */
    KANJI,        /* 0x572f */
    KANJI,        /* 0x5730 */
    KANJI,        /* 0x5731 */
    KANJI,        /* 0x5732 */
    KANJI,        /* 0x5733 */
    KANJI,        /* 0x5734 */
    KANJI,        /* 0x5735 */
    KANJI,        /* 0x5736 */
    KANJI,        /* 0x5737 */
    KANJI,        /* 0x5738 */
    KANJI,        /* 0x5739 */
    KANJI,        /* 0x573a */
    KANJI,        /* 0x573b */
    KANJI,        /* 0x573c */
    KANJI,        /* 0x573d */
    KANJI,        /* 0x573e */
    KANJI,        /* 0x573f */
    KANJI,        /* 0x5740 */
    KANJI,        /* 0x5741 */
    KANJI,        /* 0x5742 */
    KANJI,        /* 0x5743 */
    KANJI,        /* 0x5744 */
    KANJI,        /* 0x5745 */
    KANJI,        /* 0x5746 */
    KANJI,        /* 0x5747 */
    KANJI,        /* 0x5748 */
    KANJI,        /* 0x5749 */
    KANJI,        /* 0x574a */
    KANJI,        /* 0x574b */
    KANJI,        /* 0x574c */
    KANJI,        /* 0x574d */
    KANJI,        /* 0x574e */
    KANJI,        /* 0x574f */
    KANJI,        /* 0x5750 */
    KANJI,        /* 0x5751 */
    KANJI,        /* 0x5752 */
    KANJI,        /* 0x5753 */
    KANJI,        /* 0x5754 */
    KANJI,        /* 0x5755 */
    KANJI,        /* 0x5756 */
    KANJI,        /* 0x5757 */
    KANJI,        /* 0x5758 */
    KANJI,        /* 0x5759 */
    KANJI,        /* 0x575a */
    KANJI,        /* 0x575b */
    KANJI,        /* 0x575c */
    KANJI,        /* 0x575d */
    KANJI,        /* 0x575e */
    KANJI,        /* 0x575f */
    KANJI,        /* 0x5760 */
    KANJI,        /* 0x5761 */
    KANJI,        /* 0x5762 */
    KANJI,        /* 0x5763 */
    KANJI,        /* 0x5764 */
    KANJI,        /* 0x5765 */
    KANJI,        /* 0x5766 */
    KANJI,        /* 0x5767 */
    KANJI,        /* 0x5768 */
    KANJI,        /* 0x5769 */
    KANJI,        /* 0x576a */
    KANJI,        /* 0x576b */
    KANJI,        /* 0x576c */
    KANJI,        /* 0x576d */
    KANJI,        /* 0x576e */
    KANJI,        /* 0x576f */
    KANJI,        /* 0x5770 */
    KANJI,        /* 0x5771 */
    KANJI,        /* 0x5772 */
    KANJI,        /* 0x5773 */
    KANJI,        /* 0x5774 */
    KANJI,        /* 0x5775 */
    KANJI,        /* 0x5776 */
    KANJI,        /* 0x5777 */
    KANJI,        /* 0x5778 */
    KANJI,        /* 0x5779 */
    KANJI,        /* 0x577a */
    KANJI,        /* 0x577b */
    KANJI,        /* 0x577c */
    KANJI,        /* 0x577d */
    KANJI,        /* 0x577e */
    KANJI,        /* 0x577f */
    KANJI,        /* 0x5780 */
    KANJI,        /* 0x5781 */
    KANJI,        /* 0x5782 */
    KANJI,        /* 0x5783 */
    KANJI,        /* 0x5784 */
    KANJI,        /* 0x5785 */
    KANJI,        /* 0x5786 */
    KANJI,        /* 0x5787 */
    KANJI,        /* 0x5788 */
    KANJI,        /* 0x5789 */
    KANJI,        /* 0x578a */
    KANJI,        /* 0x578b */
    KANJI,        /* 0x578c */
    KANJI,        /* 0x578d */
    KANJI,        /* 0x578e */
    KANJI,        /* 0x578f */
    KANJI,        /* 0x5790 */
    KANJI,        /* 0x5791 */
    KANJI,        /* 0x5792 */
    KANJI,        /* 0x5793 */
    KANJI,        /* 0x5794 */
    KANJI,        /* 0x5795 */
    KANJI,        /* 0x5796 */
    KANJI,        /* 0x5797 */
    KANJI,        /* 0x5798 */
    KANJI,        /* 0x5799 */
    KANJI,        /* 0x579a */
    KANJI,        /* 0x579b */
    KANJI,        /* 0x579c */
    KANJI,        /* 0x579d */
    KANJI,        /* 0x579e */
    KANJI,        /* 0x579f */
    KANJI,        /* 0x57a0 */
    KANJI,        /* 0x57a1 */
    KANJI,        /* 0x57a2 */
    KANJI,        /* 0x57a3 */
    KANJI,        /* 0x57a4 */
    KANJI,        /* 0x57a5 */
    KANJI,        /* 0x57a6 */
    KANJI,        /* 0x57a7 */
    KANJI,        /* 0x57a8 */
    KANJI,        /* 0x57a9 */
    KANJI,        /* 0x57aa */
    KANJI,        /* 0x57ab */
    KANJI,        /* 0x57ac */
    KANJI,        /* 0x57ad */
    KANJI,        /* 0x57ae */
    KANJI,        /* 0x57af */
    KANJI,        /* 0x57b0 */
    KANJI,        /* 0x57b1 */
    KANJI,        /* 0x57b2 */
    KANJI,        /* 0x57b3 */
    KANJI,        /* 0x57b4 */
    KANJI,        /* 0x57b5 */
    KANJI,        /* 0x57b6 */
    KANJI,        /* 0x57b7 */
    KANJI,        /* 0x57b8 */
    KANJI,        /* 0x57b9 */
    KANJI,        /* 0x57ba */
    KANJI,        /* 0x57bb */
    KANJI,        /* 0x57bc */
    KANJI,        /* 0x57bd */
    KANJI,        /* 0x57be */
    KANJI,        /* 0x57bf */
    KANJI,        /* 0x57c0 */
    KANJI,        /* 0x57c1 */
    KANJI,        /* 0x57c2 */
    KANJI,        /* 0x57c3 */
    KANJI,        /* 0x57c4 */
    KANJI,        /* 0x57c5 */
    KANJI,        /* 0x57c6 */
    KANJI,        /* 0x57c7 */
    KANJI,        /* 0x57c8 */
    KANJI,        /* 0x57c9 */
    KANJI,        /* 0x57ca */
    KANJI,        /* 0x57cb */
    KANJI,        /* 0x57cc */
    KANJI,        /* 0x57cd */
    KANJI,        /* 0x57ce */
    KANJI,        /* 0x57cf */
    KANJI,        /* 0x57d0 */
    KANJI,        /* 0x57d1 */
    KANJI,        /* 0x57d2 */
    KANJI,        /* 0x57d3 */
    KANJI,        /* 0x57d4 */
    KANJI,        /* 0x57d5 */
    KANJI,        /* 0x57d6 */
    KANJI,        /* 0x57d7 */
    KANJI,        /* 0x57d8 */
    KANJI,        /* 0x57d9 */
    KANJI,        /* 0x57da */
    KANJI,        /* 0x57db */
    KANJI,        /* 0x57dc */
    KANJI,        /* 0x57dd */
    KANJI,        /* 0x57de */
    KANJI,        /* 0x57df */
    KANJI,        /* 0x57e0 */
    KANJI,        /* 0x57e1 */
    KANJI,        /* 0x57e2 */
    KANJI,        /* 0x57e3 */
    KANJI,        /* 0x57e4 */
    KANJI,        /* 0x57e5 */
    KANJI,        /* 0x57e6 */
    KANJI,        /* 0x57e7 */
    KANJI,        /* 0x57e8 */
    KANJI,        /* 0x57e9 */
    KANJI,        /* 0x57ea */
    KANJI,        /* 0x57eb */
    KANJI,        /* 0x57ec */
    KANJI,        /* 0x57ed */
    KANJI,        /* 0x57ee */
    KANJI,        /* 0x57ef */
    KANJI,        /* 0x57f0 */
    KANJI,        /* 0x57f1 */
    KANJI,        /* 0x57f2 */
    KANJI,        /* 0x57f3 */
    KANJI,        /* 0x57f4 */
    KANJI,        /* 0x57f5 */
    KANJI,        /* 0x57f6 */
    KANJI,        /* 0x57f7 */
    KANJI,        /* 0x57f8 */
    KANJI,        /* 0x57f9 */
    KANJI,        /* 0x57fa */
    KANJI,        /* 0x57fb */
    KANJI,        /* 0x57fc */
    KANJI,        /* 0x57fd */
    KANJI,        /* 0x57fe */
    KANJI,        /* 0x57ff */
    KANJI,        /* 0x5800 */
    KANJI,        /* 0x5801 */
    KANJI,        /* 0x5802 */
    KANJI,        /* 0x5803 */
    KANJI,        /* 0x5804 */
    KANJI,        /* 0x5805 */
    KANJI,        /* 0x5806 */
    KANJI,        /* 0x5807 */
    KANJI,        /* 0x5808 */
    KANJI,        /* 0x5809 */
    KANJI,        /* 0x580a */
    KANJI,        /* 0x580b */
    KANJI,        /* 0x580c */
    KANJI,        /* 0x580d */
    KANJI,        /* 0x580e */
    KANJI,        /* 0x580f */
    KANJI,        /* 0x5810 */
    KANJI,        /* 0x5811 */
    KANJI,        /* 0x5812 */
    KANJI,        /* 0x5813 */
    KANJI,        /* 0x5814 */
    KANJI,        /* 0x5815 */
    KANJI,        /* 0x5816 */
    KANJI,        /* 0x5817 */
    KANJI,        /* 0x5818 */
    KANJI,        /* 0x5819 */
    KANJI,        /* 0x581a */
    KANJI,        /* 0x581b */
    KANJI,        /* 0x581c */
    KANJI,        /* 0x581d */
    KANJI,        /* 0x581e */
    KANJI,        /* 0x581f */
    KANJI,        /* 0x5820 */
    KANJI,        /* 0x5821 */
    KANJI,        /* 0x5822 */
    KANJI,        /* 0x5823 */
    KANJI,        /* 0x5824 */
    KANJI,        /* 0x5825 */
    KANJI,        /* 0x5826 */
    KANJI,        /* 0x5827 */
    KANJI,        /* 0x5828 */
    KANJI,        /* 0x5829 */
    KANJI,        /* 0x582a */
    KANJI,        /* 0x582b */
    KANJI,        /* 0x582c */
    KANJI,        /* 0x582d */
    KANJI,        /* 0x582e */
    KANJI,        /* 0x582f */
    KANJI,        /* 0x5830 */
    KANJI,        /* 0x5831 */
    KANJI,        /* 0x5832 */
    KANJI,        /* 0x5833 */
    KANJI,        /* 0x5834 */
    KANJI,        /* 0x5835 */
    KANJI,        /* 0x5836 */
    KANJI,        /* 0x5837 */
    KANJI,        /* 0x5838 */
    KANJI,        /* 0x5839 */
    KANJI,        /* 0x583a */
    KANJI,        /* 0x583b */
    KANJI,        /* 0x583c */
    KANJI,        /* 0x583d */
    KANJI,        /* 0x583e */
    KANJI,        /* 0x583f */
    KANJI,        /* 0x5840 */
    KANJI,        /* 0x5841 */
    KANJI,        /* 0x5842 */
    KANJI,        /* 0x5843 */
    KANJI,        /* 0x5844 */
    KANJI,        /* 0x5845 */
    KANJI,        /* 0x5846 */
    KANJI,        /* 0x5847 */
    KANJI,        /* 0x5848 */
    KANJI,        /* 0x5849 */
    KANJI,        /* 0x584a */
    KANJI,        /* 0x584b */
    KANJI,        /* 0x584c */
    KANJI,        /* 0x584d */
    KANJI,        /* 0x584e */
    KANJI,        /* 0x584f */
    KANJI,        /* 0x5850 */
    KANJI,        /* 0x5851 */
    KANJI,        /* 0x5852 */
    KANJI,        /* 0x5853 */
    KANJI,        /* 0x5854 */
    KANJI,        /* 0x5855 */
    KANJI,        /* 0x5856 */
    KANJI,        /* 0x5857 */
    KANJI,        /* 0x5858 */
    KANJI,        /* 0x5859 */
    KANJI,        /* 0x585a */
    KANJI,        /* 0x585b */
    KANJI,        /* 0x585c */
    KANJI,        /* 0x585d */
    KANJI,        /* 0x585e */
    KANJI,        /* 0x585f */
    KANJI,        /* 0x5860 */
    KANJI,        /* 0x5861 */
    KANJI,        /* 0x5862 */
    KANJI,        /* 0x5863 */
    KANJI,        /* 0x5864 */
    KANJI,        /* 0x5865 */
    KANJI,        /* 0x5866 */
    KANJI,        /* 0x5867 */
    KANJI,        /* 0x5868 */
    KANJI,        /* 0x5869 */
    KANJI,        /* 0x586a */
    KANJI,        /* 0x586b */
    KANJI,        /* 0x586c */
    KANJI,        /* 0x586d */
    KANJI,        /* 0x586e */
    KANJI,        /* 0x586f */
    KANJI,        /* 0x5870 */
    KANJI,        /* 0x5871 */
    KANJI,        /* 0x5872 */
    KANJI,        /* 0x5873 */
    KANJI,        /* 0x5874 */
    KANJI,        /* 0x5875 */
    KANJI,        /* 0x5876 */
    KANJI,        /* 0x5877 */
    KANJI,        /* 0x5878 */
    KANJI,        /* 0x5879 */
    KANJI,        /* 0x587a */
    KANJI,        /* 0x587b */
    KANJI,        /* 0x587c */
    KANJI,        /* 0x587d */
    KANJI,        /* 0x587e */
    KANJI,        /* 0x587f */
    KANJI,        /* 0x5880 */
    KANJI,        /* 0x5881 */
    KANJI,        /* 0x5882 */
    KANJI,        /* 0x5883 */
    KANJI,        /* 0x5884 */
    KANJI,        /* 0x5885 */
    KANJI,        /* 0x5886 */
    KANJI,        /* 0x5887 */
    KANJI,        /* 0x5888 */
    KANJI,        /* 0x5889 */
    KANJI,        /* 0x588a */
    KANJI,        /* 0x588b */
    KANJI,        /* 0x588c */
    KANJI,        /* 0x588d */
    KANJI,        /* 0x588e */
    KANJI,        /* 0x588f */
    KANJI,        /* 0x5890 */
    KANJI,        /* 0x5891 */
    KANJI,        /* 0x5892 */
    KANJI,        /* 0x5893 */
    KANJI,        /* 0x5894 */
    KANJI,        /* 0x5895 */
    KANJI,        /* 0x5896 */
    KANJI,        /* 0x5897 */
    KANJI,        /* 0x5898 */
    KANJI,        /* 0x5899 */
    KANJI,        /* 0x589a */
    KANJI,        /* 0x589b */
    KANJI,        /* 0x589c */
    KANJI,        /* 0x589d */
    KANJI,        /* 0x589e */
    KANJI,        /* 0x589f */
    KANJI,        /* 0x58a0 */
    KANJI,        /* 0x58a1 */
    KANJI,        /* 0x58a2 */
    KANJI,        /* 0x58a3 */
    KANJI,        /* 0x58a4 */
    KANJI,        /* 0x58a5 */
    KANJI,        /* 0x58a6 */
    KANJI,        /* 0x58a7 */
    KANJI,        /* 0x58a8 */
    KANJI,        /* 0x58a9 */
    KANJI,        /* 0x58aa */
    KANJI,        /* 0x58ab */
    KANJI,        /* 0x58ac */
    KANJI,        /* 0x58ad */
    KANJI,        /* 0x58ae */
    KANJI,        /* 0x58af */
    KANJI,        /* 0x58b0 */
    KANJI,        /* 0x58b1 */
    KANJI,        /* 0x58b2 */
    KANJI,        /* 0x58b3 */
    KANJI,        /* 0x58b4 */
    KANJI,        /* 0x58b5 */
    KANJI,        /* 0x58b6 */
    KANJI,        /* 0x58b7 */
    KANJI,        /* 0x58b8 */
    KANJI,        /* 0x58b9 */
    KANJI,        /* 0x58ba */
    KANJI,        /* 0x58bb */
    KANJI,        /* 0x58bc */
    KANJI,        /* 0x58bd */
    KANJI,        /* 0x58be */
    KANJI,        /* 0x58bf */
    KANJI,        /* 0x58c0 */
    KANJI,        /* 0x58c1 */
    KANJI,        /* 0x58c2 */
    KANJI,        /* 0x58c3 */
    KANJI,        /* 0x58c4 */
    KANJI,        /* 0x58c5 */
    KANJI,        /* 0x58c6 */
    KANJI,        /* 0x58c7 */
    KANJI,        /* 0x58c8 */
    KANJI,        /* 0x58c9 */
    KANJI,        /* 0x58ca */
    KANJI,        /* 0x58cb */
    KANJI,        /* 0x58cc */
    KANJI,        /* 0x58cd */
    KANJI,        /* 0x58ce */
    KANJI,        /* 0x58cf */
    KANJI,        /* 0x58d0 */
    KANJI,        /* 0x58d1 */
    KANJI,        /* 0x58d2 */
    KANJI,        /* 0x58d3 */
    KANJI,        /* 0x58d4 */
    KANJI,        /* 0x58d5 */
    KANJI,        /* 0x58d6 */
    KANJI,        /* 0x58d7 */
    KANJI,        /* 0x58d8 */
    KANJI,        /* 0x58d9 */
    KANJI,        /* 0x58da */
    KANJI,        /* 0x58db */
    KANJI,        /* 0x58dc */
    KANJI,        /* 0x58dd */
    KANJI,        /* 0x58de */
    KANJI,        /* 0x58df */
    KANJI,        /* 0x58e0 */
    KANJI,        /* 0x58e1 */
    KANJI,        /* 0x58e2 */
    KANJI,        /* 0x58e3 */
    KANJI,        /* 0x58e4 */
    KANJI,        /* 0x58e5 */
    KANJI,        /* 0x58e6 */
    KANJI,        /* 0x58e7 */
    KANJI,        /* 0x58e8 */
    KANJI,        /* 0x58e9 */
    KANJI,        /* 0x58ea */
    KANJI,        /* 0x58eb */
    KANJI,        /* 0x58ec */
    KANJI,        /* 0x58ed */
    KANJI,        /* 0x58ee */
    KANJI,        /* 0x58ef */
    KANJI,        /* 0x58f0 */
    KANJI,        /* 0x58f1 */
    KANJI,        /* 0x58f2 */
    KANJI,        /* 0x58f3 */
    KANJI,        /* 0x58f4 */
    KANJI,        /* 0x58f5 */
    KANJI,        /* 0x58f6 */
    KANJI,        /* 0x58f7 */
    KANJI,        /* 0x58f8 */
    KANJI,        /* 0x58f9 */
    KANJI,        /* 0x58fa */
    KANJI,        /* 0x58fb */
    KANJI,        /* 0x58fc */
    KANJI,        /* 0x58fd */
    KANJI,        /* 0x58fe */
    KANJI,        /* 0x58ff */
    KANJI,        /* 0x5900 */
    KANJI,        /* 0x5901 */
    KANJI,        /* 0x5902 */
    KANJI,        /* 0x5903 */
    KANJI,        /* 0x5904 */
    KANJI,        /* 0x5905 */
    KANJI,        /* 0x5906 */
    KANJI,        /* 0x5907 */
    KANJI,        /* 0x5908 */
    KANJI,        /* 0x5909 */
    KANJI,        /* 0x590a */
    KANJI,        /* 0x590b */
    KANJI,        /* 0x590c */
    KANJI,        /* 0x590d */
    KANJI,        /* 0x590e */
    KANJI,        /* 0x590f */
    KANJI,        /* 0x5910 */
    KANJI,        /* 0x5911 */
    KANJI,        /* 0x5912 */
    KANJI,        /* 0x5913 */
    KANJI,        /* 0x5914 */
    KANJI,        /* 0x5915 */
    KANJI,        /* 0x5916 */
    KANJI,        /* 0x5917 */
    KANJI,        /* 0x5918 */
    KANJI,        /* 0x5919 */
    KANJI,        /* 0x591a */
    KANJI,        /* 0x591b */
    KANJI,        /* 0x591c */
    KANJI,        /* 0x591d */
    KANJI,        /* 0x591e */
    KANJI,        /* 0x591f */
    KANJI,        /* 0x5920 */
    KANJI,        /* 0x5921 */
    KANJI,        /* 0x5922 */
    KANJI,        /* 0x5923 */
    KANJI,        /* 0x5924 */
    KANJI,        /* 0x5925 */
    KANJI,        /* 0x5926 */
    KANJI,        /* 0x5927 */
    KANJI,        /* 0x5928 */
    KANJI,        /* 0x5929 */
    KANJI,        /* 0x592a */
    KANJI,        /* 0x592b */
    KANJI,        /* 0x592c */
    KANJI,        /* 0x592d */
    KANJI,        /* 0x592e */
    KANJI,        /* 0x592f */
    KANJI,        /* 0x5930 */
    KANJI,        /* 0x5931 */
    KANJI,        /* 0x5932 */
    KANJI,        /* 0x5933 */
    KANJI,        /* 0x5934 */
    KANJI,        /* 0x5935 */
    KANJI,        /* 0x5936 */
    KANJI,        /* 0x5937 */
    KANJI,        /* 0x5938 */
    KANJI,        /* 0x5939 */
    KANJI,        /* 0x593a */
    KANJI,        /* 0x593b */
    KANJI,        /* 0x593c */
    KANJI,        /* 0x593d */
    KANJI,        /* 0x593e */
    KANJI,        /* 0x593f */
    KANJI,        /* 0x5940 */
    KANJI,        /* 0x5941 */
    KANJI,        /* 0x5942 */
    KANJI,        /* 0x5943 */
    KANJI,        /* 0x5944 */
    KANJI,        /* 0x5945 */
    KANJI,        /* 0x5946 */
    KANJI,        /* 0x5947 */
    KANJI,        /* 0x5948 */
    KANJI,        /* 0x5949 */
    KANJI,        /* 0x594a */
    KANJI,        /* 0x594b */
    KANJI,        /* 0x594c */
    KANJI,        /* 0x594d */
    KANJI,        /* 0x594e */
    KANJI,        /* 0x594f */
    KANJI,        /* 0x5950 */
    KANJI,        /* 0x5951 */
    KANJI,        /* 0x5952 */
    KANJI,        /* 0x5953 */
    KANJI,        /* 0x5954 */
    KANJI,        /* 0x5955 */
    KANJI,        /* 0x5956 */
    KANJI,        /* 0x5957 */
    KANJI,        /* 0x5958 */
    KANJI,        /* 0x5959 */
    KANJI,        /* 0x595a */
    KANJI,        /* 0x595b */
    KANJI,        /* 0x595c */
    KANJI,        /* 0x595d */
    KANJI,        /* 0x595e */
    KANJI,        /* 0x595f */
    KANJI,        /* 0x5960 */
    KANJI,        /* 0x5961 */
    KANJI,        /* 0x5962 */
    KANJI,        /* 0x5963 */
    KANJI,        /* 0x5964 */
    KANJI,        /* 0x5965 */
    KANJI,        /* 0x5966 */
    KANJI,        /* 0x5967 */
    KANJI,        /* 0x5968 */
    KANJI,        /* 0x5969 */
    KANJI,        /* 0x596a */
    KANJI,        /* 0x596b */
    KANJI,        /* 0x596c */
    KANJI,        /* 0x596d */
    KANJI,        /* 0x596e */
    KANJI,        /* 0x596f */
    KANJI,        /* 0x5970 */
    KANJI,        /* 0x5971 */
    KANJI,        /* 0x5972 */
    KANJI,        /* 0x5973 */
    KANJI,        /* 0x5974 */
    KANJI,        /* 0x5975 */
    KANJI,        /* 0x5976 */
    KANJI,        /* 0x5977 */
    KANJI,        /* 0x5978 */
    KANJI,        /* 0x5979 */
    KANJI,        /* 0x597a */
    KANJI,        /* 0x597b */
    KANJI,        /* 0x597c */
    KANJI,        /* 0x597d */
    KANJI,        /* 0x597e */
    KANJI,        /* 0x597f */
    KANJI,        /* 0x5980 */
    KANJI,        /* 0x5981 */
    KANJI,        /* 0x5982 */
    KANJI,        /* 0x5983 */
    KANJI,        /* 0x5984 */
    KANJI,        /* 0x5985 */
    KANJI,        /* 0x5986 */
    KANJI,        /* 0x5987 */
    KANJI,        /* 0x5988 */
    KANJI,        /* 0x5989 */
    KANJI,        /* 0x598a */
    KANJI,        /* 0x598b */
    KANJI,        /* 0x598c */
    KANJI,        /* 0x598d */
    KANJI,        /* 0x598e */
    KANJI,        /* 0x598f */
    KANJI,        /* 0x5990 */
    KANJI,        /* 0x5991 */
    KANJI,        /* 0x5992 */
    KANJI,        /* 0x5993 */
    KANJI,        /* 0x5994 */
    KANJI,        /* 0x5995 */
    KANJI,        /* 0x5996 */
    KANJI,        /* 0x5997 */
    KANJI,        /* 0x5998 */
    KANJI,        /* 0x5999 */
    KANJI,        /* 0x599a */
    KANJI,        /* 0x599b */
    KANJI,        /* 0x599c */
    KANJI,        /* 0x599d */
    KANJI,        /* 0x599e */
    KANJI,        /* 0x599f */
    KANJI,        /* 0x59a0 */
    KANJI,        /* 0x59a1 */
    KANJI,        /* 0x59a2 */
    KANJI,        /* 0x59a3 */
    KANJI,        /* 0x59a4 */
    KANJI,        /* 0x59a5 */
    KANJI,        /* 0x59a6 */
    KANJI,        /* 0x59a7 */
    KANJI,        /* 0x59a8 */
    KANJI,        /* 0x59a9 */
    KANJI,        /* 0x59aa */
    KANJI,        /* 0x59ab */
    KANJI,        /* 0x59ac */
    KANJI,        /* 0x59ad */
    KANJI,        /* 0x59ae */
    KANJI,        /* 0x59af */
    KANJI,        /* 0x59b0 */
    KANJI,        /* 0x59b1 */
    KANJI,        /* 0x59b2 */
    KANJI,        /* 0x59b3 */
    KANJI,        /* 0x59b4 */
    KANJI,        /* 0x59b5 */
    KANJI,        /* 0x59b6 */
    KANJI,        /* 0x59b7 */
    KANJI,        /* 0x59b8 */
    KANJI,        /* 0x59b9 */
    KANJI,        /* 0x59ba */
    KANJI,        /* 0x59bb */
    KANJI,        /* 0x59bc */
    KANJI,        /* 0x59bd */
    KANJI,        /* 0x59be */
    KANJI,        /* 0x59bf */
    KANJI,        /* 0x59c0 */
    KANJI,        /* 0x59c1 */
    KANJI,        /* 0x59c2 */
    KANJI,        /* 0x59c3 */
    KANJI,        /* 0x59c4 */
    KANJI,        /* 0x59c5 */
    KANJI,        /* 0x59c6 */
    KANJI,        /* 0x59c7 */
    KANJI,        /* 0x59c8 */
    KANJI,        /* 0x59c9 */
    KANJI,        /* 0x59ca */
    KANJI,        /* 0x59cb */
    KANJI,        /* 0x59cc */
    KANJI,        /* 0x59cd */
    KANJI,        /* 0x59ce */
    KANJI,        /* 0x59cf */
    KANJI,        /* 0x59d0 */
    KANJI,        /* 0x59d1 */
    KANJI,        /* 0x59d2 */
    KANJI,        /* 0x59d3 */
    KANJI,        /* 0x59d4 */
    KANJI,        /* 0x59d5 */
    KANJI,        /* 0x59d6 */
    KANJI,        /* 0x59d7 */
    KANJI,        /* 0x59d8 */
    KANJI,        /* 0x59d9 */
    KANJI,        /* 0x59da */
    KANJI,        /* 0x59db */
    KANJI,        /* 0x59dc */
    KANJI,        /* 0x59dd */
    KANJI,        /* 0x59de */
    KANJI,        /* 0x59df */
    KANJI,        /* 0x59e0 */
    KANJI,        /* 0x59e1 */
    KANJI,        /* 0x59e2 */
    KANJI,        /* 0x59e3 */
    KANJI,        /* 0x59e4 */
    KANJI,        /* 0x59e5 */
    KANJI,        /* 0x59e6 */
    KANJI,        /* 0x59e7 */
    KANJI,        /* 0x59e8 */
    KANJI,        /* 0x59e9 */
    KANJI,        /* 0x59ea */
    KANJI,        /* 0x59eb */
    KANJI,        /* 0x59ec */
    KANJI,        /* 0x59ed */
    KANJI,        /* 0x59ee */
    KANJI,        /* 0x59ef */
    KANJI,        /* 0x59f0 */
    KANJI,        /* 0x59f1 */
    KANJI,        /* 0x59f2 */
    KANJI,        /* 0x59f3 */
    KANJI,        /* 0x59f4 */
    KANJI,        /* 0x59f5 */
    KANJI,        /* 0x59f6 */
    KANJI,        /* 0x59f7 */
    KANJI,        /* 0x59f8 */
    KANJI,        /* 0x59f9 */
    KANJI,        /* 0x59fa */
    KANJI,        /* 0x59fb */
    KANJI,        /* 0x59fc */
    KANJI,        /* 0x59fd */
    KANJI,        /* 0x59fe */
    KANJI,        /* 0x59ff */
    KANJI,        /* 0x5a00 */
    KANJI,        /* 0x5a01 */
    KANJI,        /* 0x5a02 */
    KANJI,        /* 0x5a03 */
    KANJI,        /* 0x5a04 */
    KANJI,        /* 0x5a05 */
    KANJI,        /* 0x5a06 */
    KANJI,        /* 0x5a07 */
    KANJI,        /* 0x5a08 */
    KANJI,        /* 0x5a09 */
    KANJI,        /* 0x5a0a */
    KANJI,        /* 0x5a0b */
    KANJI,        /* 0x5a0c */
    KANJI,        /* 0x5a0d */
    KANJI,        /* 0x5a0e */
    KANJI,        /* 0x5a0f */
    KANJI,        /* 0x5a10 */
    KANJI,        /* 0x5a11 */
    KANJI,        /* 0x5a12 */
    KANJI,        /* 0x5a13 */
    KANJI,        /* 0x5a14 */
    KANJI,        /* 0x5a15 */
    KANJI,        /* 0x5a16 */
    KANJI,        /* 0x5a17 */
    KANJI,        /* 0x5a18 */
    KANJI,        /* 0x5a19 */
    KANJI,        /* 0x5a1a */
    KANJI,        /* 0x5a1b */
    KANJI,        /* 0x5a1c */
    KANJI,        /* 0x5a1d */
    KANJI,        /* 0x5a1e */
    KANJI,        /* 0x5a1f */
    KANJI,        /* 0x5a20 */
    KANJI,        /* 0x5a21 */
    KANJI,        /* 0x5a22 */
    KANJI,        /* 0x5a23 */
    KANJI,        /* 0x5a24 */
    KANJI,        /* 0x5a25 */
    KANJI,        /* 0x5a26 */
    KANJI,        /* 0x5a27 */
    KANJI,        /* 0x5a28 */
    KANJI,        /* 0x5a29 */
    KANJI,        /* 0x5a2a */
    KANJI,        /* 0x5a2b */
    KANJI,        /* 0x5a2c */
    KANJI,        /* 0x5a2d */
    KANJI,        /* 0x5a2e */
    KANJI,        /* 0x5a2f */
    KANJI,        /* 0x5a30 */
    KANJI,        /* 0x5a31 */
    KANJI,        /* 0x5a32 */
    KANJI,        /* 0x5a33 */
    KANJI,        /* 0x5a34 */
    KANJI,        /* 0x5a35 */
    KANJI,        /* 0x5a36 */
    KANJI,        /* 0x5a37 */
    KANJI,        /* 0x5a38 */
    KANJI,        /* 0x5a39 */
    KANJI,        /* 0x5a3a */
    KANJI,        /* 0x5a3b */
    KANJI,        /* 0x5a3c */
    KANJI,        /* 0x5a3d */
    KANJI,        /* 0x5a3e */
    KANJI,        /* 0x5a3f */
    KANJI,        /* 0x5a40 */
    KANJI,        /* 0x5a41 */
    KANJI,        /* 0x5a42 */
    KANJI,        /* 0x5a43 */
    KANJI,        /* 0x5a44 */
    KANJI,        /* 0x5a45 */
    KANJI,        /* 0x5a46 */
    KANJI,        /* 0x5a47 */
    KANJI,        /* 0x5a48 */
    KANJI,        /* 0x5a49 */
    KANJI,        /* 0x5a4a */
    KANJI,        /* 0x5a4b */
    KANJI,        /* 0x5a4c */
    KANJI,        /* 0x5a4d */
    KANJI,        /* 0x5a4e */
    KANJI,        /* 0x5a4f */
    KANJI,        /* 0x5a50 */
    KANJI,        /* 0x5a51 */
    KANJI,        /* 0x5a52 */
    KANJI,        /* 0x5a53 */
    KANJI,        /* 0x5a54 */
    KANJI,        /* 0x5a55 */
    KANJI,        /* 0x5a56 */
    KANJI,        /* 0x5a57 */
    KANJI,        /* 0x5a58 */
    KANJI,        /* 0x5a59 */
    KANJI,        /* 0x5a5a */
    KANJI,        /* 0x5a5b */
    KANJI,        /* 0x5a5c */
    KANJI,        /* 0x5a5d */
    KANJI,        /* 0x5a5e */
    KANJI,        /* 0x5a5f */
    KANJI,        /* 0x5a60 */
    KANJI,        /* 0x5a61 */
    KANJI,        /* 0x5a62 */
    KANJI,        /* 0x5a63 */
    KANJI,        /* 0x5a64 */
    KANJI,        /* 0x5a65 */
    KANJI,        /* 0x5a66 */
    KANJI,        /* 0x5a67 */
    KANJI,        /* 0x5a68 */
    KANJI,        /* 0x5a69 */
    KANJI,        /* 0x5a6a */
    KANJI,        /* 0x5a6b */
    KANJI,        /* 0x5a6c */
    KANJI,        /* 0x5a6d */
    KANJI,        /* 0x5a6e */
    KANJI,        /* 0x5a6f */
    KANJI,        /* 0x5a70 */
    KANJI,        /* 0x5a71 */
    KANJI,        /* 0x5a72 */
    KANJI,        /* 0x5a73 */
    KANJI,        /* 0x5a74 */
    KANJI,        /* 0x5a75 */
    KANJI,        /* 0x5a76 */
    KANJI,        /* 0x5a77 */
    KANJI,        /* 0x5a78 */
    KANJI,        /* 0x5a79 */
    KANJI,        /* 0x5a7a */
    KANJI,        /* 0x5a7b */
    KANJI,        /* 0x5a7c */
    KANJI,        /* 0x5a7d */
    KANJI,        /* 0x5a7e */
    KANJI,        /* 0x5a7f */
    KANJI,        /* 0x5a80 */
    KANJI,        /* 0x5a81 */
    KANJI,        /* 0x5a82 */
    KANJI,        /* 0x5a83 */
    KANJI,        /* 0x5a84 */
    KANJI,        /* 0x5a85 */
    KANJI,        /* 0x5a86 */
    KANJI,        /* 0x5a87 */
    KANJI,        /* 0x5a88 */
    KANJI,        /* 0x5a89 */
    KANJI,        /* 0x5a8a */
    KANJI,        /* 0x5a8b */
    KANJI,        /* 0x5a8c */
    KANJI,        /* 0x5a8d */
    KANJI,        /* 0x5a8e */
    KANJI,        /* 0x5a8f */
    KANJI,        /* 0x5a90 */
    KANJI,        /* 0x5a91 */
    KANJI,        /* 0x5a92 */
    KANJI,        /* 0x5a93 */
    KANJI,        /* 0x5a94 */
    KANJI,        /* 0x5a95 */
    KANJI,        /* 0x5a96 */
    KANJI,        /* 0x5a97 */
    KANJI,        /* 0x5a98 */
    KANJI,        /* 0x5a99 */
    KANJI,        /* 0x5a9a */
    KANJI,        /* 0x5a9b */
    KANJI,        /* 0x5a9c */
    KANJI,        /* 0x5a9d */
    KANJI,        /* 0x5a9e */
    KANJI,        /* 0x5a9f */
    KANJI,        /* 0x5aa0 */
    KANJI,        /* 0x5aa1 */
    KANJI,        /* 0x5aa2 */
    KANJI,        /* 0x5aa3 */
    KANJI,        /* 0x5aa4 */
    KANJI,        /* 0x5aa5 */
    KANJI,        /* 0x5aa6 */
    KANJI,        /* 0x5aa7 */
    KANJI,        /* 0x5aa8 */
    KANJI,        /* 0x5aa9 */
    KANJI,        /* 0x5aaa */
    KANJI,        /* 0x5aab */
    KANJI,        /* 0x5aac */
    KANJI,        /* 0x5aad */
    KANJI,        /* 0x5aae */
    KANJI,        /* 0x5aaf */
    KANJI,        /* 0x5ab0 */
    KANJI,        /* 0x5ab1 */
    KANJI,        /* 0x5ab2 */
    KANJI,        /* 0x5ab3 */
    KANJI,        /* 0x5ab4 */
    KANJI,        /* 0x5ab5 */
    KANJI,        /* 0x5ab6 */
    KANJI,        /* 0x5ab7 */
    KANJI,        /* 0x5ab8 */
    KANJI,        /* 0x5ab9 */
    KANJI,        /* 0x5aba */
    KANJI,        /* 0x5abb */
    KANJI,        /* 0x5abc */
    KANJI,        /* 0x5abd */
    KANJI,        /* 0x5abe */
    KANJI,        /* 0x5abf */
    KANJI,        /* 0x5ac0 */
    KANJI,        /* 0x5ac1 */
    KANJI,        /* 0x5ac2 */
    KANJI,        /* 0x5ac3 */
    KANJI,        /* 0x5ac4 */
    KANJI,        /* 0x5ac5 */
    KANJI,        /* 0x5ac6 */
    KANJI,        /* 0x5ac7 */
    KANJI,        /* 0x5ac8 */
    KANJI,        /* 0x5ac9 */
    KANJI,        /* 0x5aca */
    KANJI,        /* 0x5acb */
    KANJI,        /* 0x5acc */
    KANJI,        /* 0x5acd */
    KANJI,        /* 0x5ace */
    KANJI,        /* 0x5acf */
    KANJI,        /* 0x5ad0 */
    KANJI,        /* 0x5ad1 */
    KANJI,        /* 0x5ad2 */
    KANJI,        /* 0x5ad3 */
    KANJI,        /* 0x5ad4 */
    KANJI,        /* 0x5ad5 */
    KANJI,        /* 0x5ad6 */
    KANJI,        /* 0x5ad7 */
    KANJI,        /* 0x5ad8 */
    KANJI,        /* 0x5ad9 */
    KANJI,        /* 0x5ada */
    KANJI,        /* 0x5adb */
    KANJI,        /* 0x5adc */
    KANJI,        /* 0x5add */
    KANJI,        /* 0x5ade */
    KANJI,        /* 0x5adf */
    KANJI,        /* 0x5ae0 */
    KANJI,        /* 0x5ae1 */
    KANJI,        /* 0x5ae2 */
    KANJI,        /* 0x5ae3 */
    KANJI,        /* 0x5ae4 */
    KANJI,        /* 0x5ae5 */
    KANJI,        /* 0x5ae6 */
    KANJI,        /* 0x5ae7 */
    KANJI,        /* 0x5ae8 */
    KANJI,        /* 0x5ae9 */
    KANJI,        /* 0x5aea */
    KANJI,        /* 0x5aeb */
    KANJI,        /* 0x5aec */
    KANJI,        /* 0x5aed */
    KANJI,        /* 0x5aee */
    KANJI,        /* 0x5aef */
    KANJI,        /* 0x5af0 */
    KANJI,        /* 0x5af1 */
    KANJI,        /* 0x5af2 */
    KANJI,        /* 0x5af3 */
    KANJI,        /* 0x5af4 */
    KANJI,        /* 0x5af5 */
    KANJI,        /* 0x5af6 */
    KANJI,        /* 0x5af7 */
    KANJI,        /* 0x5af8 */
    KANJI,        /* 0x5af9 */
    KANJI,        /* 0x5afa */
    KANJI,        /* 0x5afb */
    KANJI,        /* 0x5afc */
    KANJI,        /* 0x5afd */
    KANJI,        /* 0x5afe */
    KANJI,        /* 0x5aff */
    KANJI,        /* 0x5b00 */
    KANJI,        /* 0x5b01 */
    KANJI,        /* 0x5b02 */
    KANJI,        /* 0x5b03 */
    KANJI,        /* 0x5b04 */
    KANJI,        /* 0x5b05 */
    KANJI,        /* 0x5b06 */
    KANJI,        /* 0x5b07 */
    KANJI,        /* 0x5b08 */
    KANJI,        /* 0x5b09 */
    KANJI,        /* 0x5b0a */
    KANJI,        /* 0x5b0b */
    KANJI,        /* 0x5b0c */
    KANJI,        /* 0x5b0d */
    KANJI,        /* 0x5b0e */
    KANJI,        /* 0x5b0f */
    KANJI,        /* 0x5b10 */
    KANJI,        /* 0x5b11 */
    KANJI,        /* 0x5b12 */
    KANJI,        /* 0x5b13 */
    KANJI,        /* 0x5b14 */
    KANJI,        /* 0x5b15 */
    KANJI,        /* 0x5b16 */
    KANJI,        /* 0x5b17 */
    KANJI,        /* 0x5b18 */
    KANJI,        /* 0x5b19 */
    KANJI,        /* 0x5b1a */
    KANJI,        /* 0x5b1b */
    KANJI,        /* 0x5b1c */
    KANJI,        /* 0x5b1d */
    KANJI,        /* 0x5b1e */
    KANJI,        /* 0x5b1f */
    KANJI,        /* 0x5b20 */
    KANJI,        /* 0x5b21 */
    KANJI,        /* 0x5b22 */
    KANJI,        /* 0x5b23 */
    KANJI,        /* 0x5b24 */
    KANJI,        /* 0x5b25 */
    KANJI,        /* 0x5b26 */
    KANJI,        /* 0x5b27 */
    KANJI,        /* 0x5b28 */
    KANJI,        /* 0x5b29 */
    KANJI,        /* 0x5b2a */
    KANJI,        /* 0x5b2b */
    KANJI,        /* 0x5b2c */
    KANJI,        /* 0x5b2d */
    KANJI,        /* 0x5b2e */
    KANJI,        /* 0x5b2f */
    KANJI,        /* 0x5b30 */
    KANJI,        /* 0x5b31 */
    KANJI,        /* 0x5b32 */
    KANJI,        /* 0x5b33 */
    KANJI,        /* 0x5b34 */
    KANJI,        /* 0x5b35 */
    KANJI,        /* 0x5b36 */
    KANJI,        /* 0x5b37 */
    KANJI,        /* 0x5b38 */
    KANJI,        /* 0x5b39 */
    KANJI,        /* 0x5b3a */
    KANJI,        /* 0x5b3b */
    KANJI,        /* 0x5b3c */
    KANJI,        /* 0x5b3d */
    KANJI,        /* 0x5b3e */
    KANJI,        /* 0x5b3f */
    KANJI,        /* 0x5b40 */
    KANJI,        /* 0x5b41 */
    KANJI,        /* 0x5b42 */
    KANJI,        /* 0x5b43 */
    KANJI,        /* 0x5b44 */
    KANJI,        /* 0x5b45 */
    KANJI,        /* 0x5b46 */
    KANJI,        /* 0x5b47 */
    KANJI,        /* 0x5b48 */
    KANJI,        /* 0x5b49 */
    KANJI,        /* 0x5b4a */
    KANJI,        /* 0x5b4b */
    KANJI,        /* 0x5b4c */
    KANJI,        /* 0x5b4d */
    KANJI,        /* 0x5b4e */
    KANJI,        /* 0x5b4f */
    KANJI,        /* 0x5b50 */
    KANJI,        /* 0x5b51 */
    KANJI,        /* 0x5b52 */
    KANJI,        /* 0x5b53 */
    KANJI,        /* 0x5b54 */
    KANJI,        /* 0x5b55 */
    KANJI,        /* 0x5b56 */
    KANJI,        /* 0x5b57 */
    KANJI,        /* 0x5b58 */
    KANJI,        /* 0x5b59 */
    KANJI,        /* 0x5b5a */
    KANJI,        /* 0x5b5b */
    KANJI,        /* 0x5b5c */
    KANJI,        /* 0x5b5d */
    KANJI,        /* 0x5b5e */
    KANJI,        /* 0x5b5f */
    KANJI,        /* 0x5b60 */
    KANJI,        /* 0x5b61 */
    KANJI,        /* 0x5b62 */
    KANJI,        /* 0x5b63 */
    KANJI,        /* 0x5b64 */
    KANJI,        /* 0x5b65 */
    KANJI,        /* 0x5b66 */
    KANJI,        /* 0x5b67 */
    KANJI,        /* 0x5b68 */
    KANJI,        /* 0x5b69 */
    KANJI,        /* 0x5b6a */
    KANJI,        /* 0x5b6b */
    KANJI,        /* 0x5b6c */
    KANJI,        /* 0x5b6d */
    KANJI,        /* 0x5b6e */
    KANJI,        /* 0x5b6f */
    KANJI,        /* 0x5b70 */
    KANJI,        /* 0x5b71 */
    KANJI,        /* 0x5b72 */
    KANJI,        /* 0x5b73 */
    KANJI,        /* 0x5b74 */
    KANJI,        /* 0x5b75 */
    KANJI,        /* 0x5b76 */
    KANJI,        /* 0x5b77 */
    KANJI,        /* 0x5b78 */
    KANJI,        /* 0x5b79 */
    KANJI,        /* 0x5b7a */
    KANJI,        /* 0x5b7b */
    KANJI,        /* 0x5b7c */
    KANJI,        /* 0x5b7d */
    KANJI,        /* 0x5b7e */
    KANJI,        /* 0x5b7f */
    KANJI,        /* 0x5b80 */
    KANJI,        /* 0x5b81 */
    KANJI,        /* 0x5b82 */
    KANJI,        /* 0x5b83 */
    KANJI,        /* 0x5b84 */
    KANJI,        /* 0x5b85 */
    KANJI,        /* 0x5b86 */
    KANJI,        /* 0x5b87 */
    KANJI,        /* 0x5b88 */
    KANJI,        /* 0x5b89 */
    KANJI,        /* 0x5b8a */
    KANJI,        /* 0x5b8b */
    KANJI,        /* 0x5b8c */
    KANJI,        /* 0x5b8d */
    KANJI,        /* 0x5b8e */
    KANJI,        /* 0x5b8f */
    KANJI,        /* 0x5b90 */
    KANJI,        /* 0x5b91 */
    KANJI,        /* 0x5b92 */
    KANJI,        /* 0x5b93 */
    KANJI,        /* 0x5b94 */
    KANJI,        /* 0x5b95 */
    KANJI,        /* 0x5b96 */
    KANJI,        /* 0x5b97 */
    KANJI,        /* 0x5b98 */
    KANJI,        /* 0x5b99 */
    KANJI,        /* 0x5b9a */
    KANJI,        /* 0x5b9b */
    KANJI,        /* 0x5b9c */
    KANJI,        /* 0x5b9d */
    KANJI,        /* 0x5b9e */
    KANJI,        /* 0x5b9f */
    KANJI,        /* 0x5ba0 */
    KANJI,        /* 0x5ba1 */
    KANJI,        /* 0x5ba2 */
    KANJI,        /* 0x5ba3 */
    KANJI,        /* 0x5ba4 */
    KANJI,        /* 0x5ba5 */
    KANJI,        /* 0x5ba6 */
    KANJI,        /* 0x5ba7 */
    KANJI,        /* 0x5ba8 */
    KANJI,        /* 0x5ba9 */
    KANJI,        /* 0x5baa */
    KANJI,        /* 0x5bab */
    KANJI,        /* 0x5bac */
    KANJI,        /* 0x5bad */
    KANJI,        /* 0x5bae */
    KANJI,        /* 0x5baf */
    KANJI,        /* 0x5bb0 */
    KANJI,        /* 0x5bb1 */
    KANJI,        /* 0x5bb2 */
    KANJI,        /* 0x5bb3 */
    KANJI,        /* 0x5bb4 */
    KANJI,        /* 0x5bb5 */
    KANJI,        /* 0x5bb6 */
    KANJI,        /* 0x5bb7 */
    KANJI,        /* 0x5bb8 */
    KANJI,        /* 0x5bb9 */
    KANJI,        /* 0x5bba */
    KANJI,        /* 0x5bbb */
    KANJI,        /* 0x5bbc */
    KANJI,        /* 0x5bbd */
    KANJI,        /* 0x5bbe */
    KANJI,        /* 0x5bbf */
    KANJI,        /* 0x5bc0 */
    KANJI,        /* 0x5bc1 */
    KANJI,        /* 0x5bc2 */
    KANJI,        /* 0x5bc3 */
    KANJI,        /* 0x5bc4 */
    KANJI,        /* 0x5bc5 */
    KANJI,        /* 0x5bc6 */
    KANJI,        /* 0x5bc7 */
    KANJI,        /* 0x5bc8 */
    KANJI,        /* 0x5bc9 */
    KANJI,        /* 0x5bca */
    KANJI,        /* 0x5bcb */
    KANJI,        /* 0x5bcc */
    KANJI,        /* 0x5bcd */
    KANJI,        /* 0x5bce */
    KANJI,        /* 0x5bcf */
    KANJI,        /* 0x5bd0 */
    KANJI,        /* 0x5bd1 */
    KANJI,        /* 0x5bd2 */
    KANJI,        /* 0x5bd3 */
    KANJI,        /* 0x5bd4 */
    KANJI,        /* 0x5bd5 */
    KANJI,        /* 0x5bd6 */
    KANJI,        /* 0x5bd7 */
    KANJI,        /* 0x5bd8 */
    KANJI,        /* 0x5bd9 */
    KANJI,        /* 0x5bda */
    KANJI,        /* 0x5bdb */
    KANJI,        /* 0x5bdc */
    KANJI,        /* 0x5bdd */
    KANJI,        /* 0x5bde */
    KANJI,        /* 0x5bdf */
    KANJI,        /* 0x5be0 */
    KANJI,        /* 0x5be1 */
    KANJI,        /* 0x5be2 */
    KANJI,        /* 0x5be3 */
    KANJI,        /* 0x5be4 */
    KANJI,        /* 0x5be5 */
    KANJI,        /* 0x5be6 */
    KANJI,        /* 0x5be7 */
    KANJI,        /* 0x5be8 */
    KANJI,        /* 0x5be9 */
    KANJI,        /* 0x5bea */
    KANJI,        /* 0x5beb */
    KANJI,        /* 0x5bec */
    KANJI,        /* 0x5bed */
    KANJI,        /* 0x5bee */
    KANJI,        /* 0x5bef */
    KANJI,        /* 0x5bf0 */
    KANJI,        /* 0x5bf1 */
    KANJI,        /* 0x5bf2 */
    KANJI,        /* 0x5bf3 */
    KANJI,        /* 0x5bf4 */
    KANJI,        /* 0x5bf5 */
    KANJI,        /* 0x5bf6 */
    KANJI,        /* 0x5bf7 */
    KANJI,        /* 0x5bf8 */
    KANJI,        /* 0x5bf9 */
    KANJI,        /* 0x5bfa */
    KANJI,        /* 0x5bfb */
    KANJI,        /* 0x5bfc */
    KANJI,        /* 0x5bfd */
    KANJI,        /* 0x5bfe */
    KANJI,        /* 0x5bff */
    KANJI,        /* 0x5c00 */
    KANJI,        /* 0x5c01 */
    KANJI,        /* 0x5c02 */
    KANJI,        /* 0x5c03 */
    KANJI,        /* 0x5c04 */
    KANJI,        /* 0x5c05 */
    KANJI,        /* 0x5c06 */
    KANJI,        /* 0x5c07 */
    KANJI,        /* 0x5c08 */
    KANJI,        /* 0x5c09 */
    KANJI,        /* 0x5c0a */
    KANJI,        /* 0x5c0b */
    KANJI,        /* 0x5c0c */
    KANJI,        /* 0x5c0d */
    KANJI,        /* 0x5c0e */
    KANJI,        /* 0x5c0f */
    KANJI,        /* 0x5c10 */
    KANJI,        /* 0x5c11 */
    KANJI,        /* 0x5c12 */
    KANJI,        /* 0x5c13 */
    KANJI,        /* 0x5c14 */
    KANJI,        /* 0x5c15 */
    KANJI,        /* 0x5c16 */
    KANJI,        /* 0x5c17 */
    KANJI,        /* 0x5c18 */
    KANJI,        /* 0x5c19 */
    KANJI,        /* 0x5c1a */
    KANJI,        /* 0x5c1b */
    KANJI,        /* 0x5c1c */
    KANJI,        /* 0x5c1d */
    KANJI,        /* 0x5c1e */
    KANJI,        /* 0x5c1f */
    KANJI,        /* 0x5c20 */
    KANJI,        /* 0x5c21 */
    KANJI,        /* 0x5c22 */
    KANJI,        /* 0x5c23 */
    KANJI,        /* 0x5c24 */
    KANJI,        /* 0x5c25 */
    KANJI,        /* 0x5c26 */
    KANJI,        /* 0x5c27 */
    KANJI,        /* 0x5c28 */
    KANJI,        /* 0x5c29 */
    KANJI,        /* 0x5c2a */
    KANJI,        /* 0x5c2b */
    KANJI,        /* 0x5c2c */
    KANJI,        /* 0x5c2d */
    KANJI,        /* 0x5c2e */
    KANJI,        /* 0x5c2f */
    KANJI,        /* 0x5c30 */
    KANJI,        /* 0x5c31 */
    KANJI,        /* 0x5c32 */
    KANJI,        /* 0x5c33 */
    KANJI,        /* 0x5c34 */
    KANJI,        /* 0x5c35 */
    KANJI,        /* 0x5c36 */
    KANJI,        /* 0x5c37 */
    KANJI,        /* 0x5c38 */
    KANJI,        /* 0x5c39 */
    KANJI,        /* 0x5c3a */
    KANJI,        /* 0x5c3b */
    KANJI,        /* 0x5c3c */
    KANJI,        /* 0x5c3d */
    KANJI,        /* 0x5c3e */
    KANJI,        /* 0x5c3f */
    KANJI,        /* 0x5c40 */
    KANJI,        /* 0x5c41 */
    KANJI,        /* 0x5c42 */
    KANJI,        /* 0x5c43 */
    KANJI,        /* 0x5c44 */
    KANJI,        /* 0x5c45 */
    KANJI,        /* 0x5c46 */
    KANJI,        /* 0x5c47 */
    KANJI,        /* 0x5c48 */
    KANJI,        /* 0x5c49 */
    KANJI,        /* 0x5c4a */
    KANJI,        /* 0x5c4b */
    KANJI,        /* 0x5c4c */
    KANJI,        /* 0x5c4d */
    KANJI,        /* 0x5c4e */
    KANJI,        /* 0x5c4f */
    KANJI,        /* 0x5c50 */
    KANJI,        /* 0x5c51 */
    KANJI,        /* 0x5c52 */
    KANJI,        /* 0x5c53 */
    KANJI,        /* 0x5c54 */
    KANJI,        /* 0x5c55 */
    KANJI,        /* 0x5c56 */
    KANJI,        /* 0x5c57 */
    KANJI,        /* 0x5c58 */
    KANJI,        /* 0x5c59 */
    KANJI,        /* 0x5c5a */
    KANJI,        /* 0x5c5b */
    KANJI,        /* 0x5c5c */
    KANJI,        /* 0x5c5d */
    KANJI,        /* 0x5c5e */
    KANJI,        /* 0x5c5f */
    KANJI,        /* 0x5c60 */
    KANJI,        /* 0x5c61 */
    KANJI,        /* 0x5c62 */
    KANJI,        /* 0x5c63 */
    KANJI,        /* 0x5c64 */
    KANJI,        /* 0x5c65 */
    KANJI,        /* 0x5c66 */
    KANJI,        /* 0x5c67 */
    KANJI,        /* 0x5c68 */
    KANJI,        /* 0x5c69 */
    KANJI,        /* 0x5c6a */
    KANJI,        /* 0x5c6b */
    KANJI,        /* 0x5c6c */
    KANJI,        /* 0x5c6d */
    KANJI,        /* 0x5c6e */
    KANJI,        /* 0x5c6f */
    KANJI,        /* 0x5c70 */
    KANJI,        /* 0x5c71 */
    KANJI,        /* 0x5c72 */
    KANJI,        /* 0x5c73 */
    KANJI,        /* 0x5c74 */
    KANJI,        /* 0x5c75 */
    KANJI,        /* 0x5c76 */
    KANJI,        /* 0x5c77 */
    KANJI,        /* 0x5c78 */
    KANJI,        /* 0x5c79 */
    KANJI,        /* 0x5c7a */
    KANJI,        /* 0x5c7b */
    KANJI,        /* 0x5c7c */
    KANJI,        /* 0x5c7d */
    KANJI,        /* 0x5c7e */
    KANJI,        /* 0x5c7f */
    KANJI,        /* 0x5c80 */
    KANJI,        /* 0x5c81 */
    KANJI,        /* 0x5c82 */
    KANJI,        /* 0x5c83 */
    KANJI,        /* 0x5c84 */
    KANJI,        /* 0x5c85 */
    KANJI,        /* 0x5c86 */
    KANJI,        /* 0x5c87 */
    KANJI,        /* 0x5c88 */
    KANJI,        /* 0x5c89 */
    KANJI,        /* 0x5c8a */
    KANJI,        /* 0x5c8b */
    KANJI,        /* 0x5c8c */
    KANJI,        /* 0x5c8d */
    KANJI,        /* 0x5c8e */
    KANJI,        /* 0x5c8f */
    KANJI,        /* 0x5c90 */
    KANJI,        /* 0x5c91 */
    KANJI,        /* 0x5c92 */
    KANJI,        /* 0x5c93 */
    KANJI,        /* 0x5c94 */
    KANJI,        /* 0x5c95 */
    KANJI,        /* 0x5c96 */
    KANJI,        /* 0x5c97 */
    KANJI,        /* 0x5c98 */
    KANJI,        /* 0x5c99 */
    KANJI,        /* 0x5c9a */
    KANJI,        /* 0x5c9b */
    KANJI,        /* 0x5c9c */
    KANJI,        /* 0x5c9d */
    KANJI,        /* 0x5c9e */
    KANJI,        /* 0x5c9f */
    KANJI,        /* 0x5ca0 */
    KANJI,        /* 0x5ca1 */
    KANJI,        /* 0x5ca2 */
    KANJI,        /* 0x5ca3 */
    KANJI,        /* 0x5ca4 */
    KANJI,        /* 0x5ca5 */
    KANJI,        /* 0x5ca6 */
    KANJI,        /* 0x5ca7 */
    KANJI,        /* 0x5ca8 */
    KANJI,        /* 0x5ca9 */
    KANJI,        /* 0x5caa */
    KANJI,        /* 0x5cab */
    KANJI,        /* 0x5cac */
    KANJI,        /* 0x5cad */
    KANJI,        /* 0x5cae */
    KANJI,        /* 0x5caf */
    KANJI,        /* 0x5cb0 */
    KANJI,        /* 0x5cb1 */
    KANJI,        /* 0x5cb2 */
    KANJI,        /* 0x5cb3 */
    KANJI,        /* 0x5cb4 */
    KANJI,        /* 0x5cb5 */
    KANJI,        /* 0x5cb6 */
    KANJI,        /* 0x5cb7 */
    KANJI,        /* 0x5cb8 */
    KANJI,        /* 0x5cb9 */
    KANJI,        /* 0x5cba */
    KANJI,        /* 0x5cbb */
    KANJI,        /* 0x5cbc */
    KANJI,        /* 0x5cbd */
    KANJI,        /* 0x5cbe */
    KANJI,        /* 0x5cbf */
    KANJI,        /* 0x5cc0 */
    KANJI,        /* 0x5cc1 */
    KANJI,        /* 0x5cc2 */
    KANJI,        /* 0x5cc3 */
    KANJI,        /* 0x5cc4 */
    KANJI,        /* 0x5cc5 */
    KANJI,        /* 0x5cc6 */
    KANJI,        /* 0x5cc7 */
    KANJI,        /* 0x5cc8 */
    KANJI,        /* 0x5cc9 */
    KANJI,        /* 0x5cca */
    KANJI,        /* 0x5ccb */
    KANJI,        /* 0x5ccc */
    KANJI,        /* 0x5ccd */
    KANJI,        /* 0x5cce */
    KANJI,        /* 0x5ccf */
    KANJI,        /* 0x5cd0 */
    KANJI,        /* 0x5cd1 */
    KANJI,        /* 0x5cd2 */
    KANJI,        /* 0x5cd3 */
    KANJI,        /* 0x5cd4 */
    KANJI,        /* 0x5cd5 */
    KANJI,        /* 0x5cd6 */
    KANJI,        /* 0x5cd7 */
    KANJI,        /* 0x5cd8 */
    KANJI,        /* 0x5cd9 */
    KANJI,        /* 0x5cda */
    KANJI,        /* 0x5cdb */
    KANJI,        /* 0x5cdc */
    KANJI,        /* 0x5cdd */
    KANJI,        /* 0x5cde */
    KANJI,        /* 0x5cdf */
    KANJI,        /* 0x5ce0 */
    KANJI,        /* 0x5ce1 */
    KANJI,        /* 0x5ce2 */
    KANJI,        /* 0x5ce3 */
    KANJI,        /* 0x5ce4 */
    KANJI,        /* 0x5ce5 */
    KANJI,        /* 0x5ce6 */
    KANJI,        /* 0x5ce7 */
    KANJI,        /* 0x5ce8 */
    KANJI,        /* 0x5ce9 */
    KANJI,        /* 0x5cea */
    KANJI,        /* 0x5ceb */
    KANJI,        /* 0x5cec */
    KANJI,        /* 0x5ced */
    KANJI,        /* 0x5cee */
    KANJI,        /* 0x5cef */
    KANJI,        /* 0x5cf0 */
    KANJI,        /* 0x5cf1 */
    KANJI,        /* 0x5cf2 */
    KANJI,        /* 0x5cf3 */
    KANJI,        /* 0x5cf4 */
    KANJI,        /* 0x5cf5 */
    KANJI,        /* 0x5cf6 */
    KANJI,        /* 0x5cf7 */
    KANJI,        /* 0x5cf8 */
    KANJI,        /* 0x5cf9 */
    KANJI,        /* 0x5cfa */
    KANJI,        /* 0x5cfb */
    KANJI,        /* 0x5cfc */
    KANJI,        /* 0x5cfd */
    KANJI,        /* 0x5cfe */
    KANJI,        /* 0x5cff */
    KANJI,        /* 0x5d00 */
    KANJI,        /* 0x5d01 */
    KANJI,        /* 0x5d02 */
    KANJI,        /* 0x5d03 */
    KANJI,        /* 0x5d04 */
    KANJI,        /* 0x5d05 */
    KANJI,        /* 0x5d06 */
    KANJI,        /* 0x5d07 */
    KANJI,        /* 0x5d08 */
    KANJI,        /* 0x5d09 */
    KANJI,        /* 0x5d0a */
    KANJI,        /* 0x5d0b */
    KANJI,        /* 0x5d0c */
    KANJI,        /* 0x5d0d */
    KANJI,        /* 0x5d0e */
    KANJI,        /* 0x5d0f */
    KANJI,        /* 0x5d10 */
    KANJI,        /* 0x5d11 */
    KANJI,        /* 0x5d12 */
    KANJI,        /* 0x5d13 */
    KANJI,        /* 0x5d14 */
    KANJI,        /* 0x5d15 */
    KANJI,        /* 0x5d16 */
    KANJI,        /* 0x5d17 */
    KANJI,        /* 0x5d18 */
    KANJI,        /* 0x5d19 */
    KANJI,        /* 0x5d1a */
    KANJI,        /* 0x5d1b */
    KANJI,        /* 0x5d1c */
    KANJI,        /* 0x5d1d */
    KANJI,        /* 0x5d1e */
    KANJI,        /* 0x5d1f */
    KANJI,        /* 0x5d20 */
    KANJI,        /* 0x5d21 */
    KANJI,        /* 0x5d22 */
    KANJI,        /* 0x5d23 */
    KANJI,        /* 0x5d24 */
    KANJI,        /* 0x5d25 */
    KANJI,        /* 0x5d26 */
    KANJI,        /* 0x5d27 */
    KANJI,        /* 0x5d28 */
    KANJI,        /* 0x5d29 */
    KANJI,        /* 0x5d2a */
    KANJI,        /* 0x5d2b */
    KANJI,        /* 0x5d2c */
    KANJI,        /* 0x5d2d */
    KANJI,        /* 0x5d2e */
    KANJI,        /* 0x5d2f */
    KANJI,        /* 0x5d30 */
    KANJI,        /* 0x5d31 */
    KANJI,        /* 0x5d32 */
    KANJI,        /* 0x5d33 */
    KANJI,        /* 0x5d34 */
    KANJI,        /* 0x5d35 */
    KANJI,        /* 0x5d36 */
    KANJI,        /* 0x5d37 */
    KANJI,        /* 0x5d38 */
    KANJI,        /* 0x5d39 */
    KANJI,        /* 0x5d3a */
    KANJI,        /* 0x5d3b */
    KANJI,        /* 0x5d3c */
    KANJI,        /* 0x5d3d */
    KANJI,        /* 0x5d3e */
    KANJI,        /* 0x5d3f */
    KANJI,        /* 0x5d40 */
    KANJI,        /* 0x5d41 */
    KANJI,        /* 0x5d42 */
    KANJI,        /* 0x5d43 */
    KANJI,        /* 0x5d44 */
    KANJI,        /* 0x5d45 */
    KANJI,        /* 0x5d46 */
    KANJI,        /* 0x5d47 */
    KANJI,        /* 0x5d48 */
    KANJI,        /* 0x5d49 */
    KANJI,        /* 0x5d4a */
    KANJI,        /* 0x5d4b */
    KANJI,        /* 0x5d4c */
    KANJI,        /* 0x5d4d */
    KANJI,        /* 0x5d4e */
    KANJI,        /* 0x5d4f */
    KANJI,        /* 0x5d50 */
    KANJI,        /* 0x5d51 */
    KANJI,        /* 0x5d52 */
    KANJI,        /* 0x5d53 */
    KANJI,        /* 0x5d54 */
    KANJI,        /* 0x5d55 */
    KANJI,        /* 0x5d56 */
    KANJI,        /* 0x5d57 */
    KANJI,        /* 0x5d58 */
    KANJI,        /* 0x5d59 */
    KANJI,        /* 0x5d5a */
    KANJI,        /* 0x5d5b */
    KANJI,        /* 0x5d5c */
    KANJI,        /* 0x5d5d */
    KANJI,        /* 0x5d5e */
    KANJI,        /* 0x5d5f */
    KANJI,        /* 0x5d60 */
    KANJI,        /* 0x5d61 */
    KANJI,        /* 0x5d62 */
    KANJI,        /* 0x5d63 */
    KANJI,        /* 0x5d64 */
    KANJI,        /* 0x5d65 */
    KANJI,        /* 0x5d66 */
    KANJI,        /* 0x5d67 */
    KANJI,        /* 0x5d68 */
    KANJI,        /* 0x5d69 */
    KANJI,        /* 0x5d6a */
    KANJI,        /* 0x5d6b */
    KANJI,        /* 0x5d6c */
    KANJI,        /* 0x5d6d */
    KANJI,        /* 0x5d6e */
    KANJI,        /* 0x5d6f */
    KANJI,        /* 0x5d70 */
    KANJI,        /* 0x5d71 */
    KANJI,        /* 0x5d72 */
    KANJI,        /* 0x5d73 */
    KANJI,        /* 0x5d74 */
    KANJI,        /* 0x5d75 */
    KANJI,        /* 0x5d76 */
    KANJI,        /* 0x5d77 */
    KANJI,        /* 0x5d78 */
    KANJI,        /* 0x5d79 */
    KANJI,        /* 0x5d7a */
    KANJI,        /* 0x5d7b */
    KANJI,        /* 0x5d7c */
    KANJI,        /* 0x5d7d */
    KANJI,        /* 0x5d7e */
    KANJI,        /* 0x5d7f */
    KANJI,        /* 0x5d80 */
    KANJI,        /* 0x5d81 */
    KANJI,        /* 0x5d82 */
    KANJI,        /* 0x5d83 */
    KANJI,        /* 0x5d84 */
    KANJI,        /* 0x5d85 */
    KANJI,        /* 0x5d86 */
    KANJI,        /* 0x5d87 */
    KANJI,        /* 0x5d88 */
    KANJI,        /* 0x5d89 */
    KANJI,        /* 0x5d8a */
    KANJI,        /* 0x5d8b */
    KANJI,        /* 0x5d8c */
    KANJI,        /* 0x5d8d */
    KANJI,        /* 0x5d8e */
    KANJI,        /* 0x5d8f */
    KANJI,        /* 0x5d90 */
    KANJI,        /* 0x5d91 */
    KANJI,        /* 0x5d92 */
    KANJI,        /* 0x5d93 */
    KANJI,        /* 0x5d94 */
    KANJI,        /* 0x5d95 */
    KANJI,        /* 0x5d96 */
    KANJI,        /* 0x5d97 */
    KANJI,        /* 0x5d98 */
    KANJI,        /* 0x5d99 */
    KANJI,        /* 0x5d9a */
    KANJI,        /* 0x5d9b */
    KANJI,        /* 0x5d9c */
    KANJI,        /* 0x5d9d */
    KANJI,        /* 0x5d9e */
    KANJI,        /* 0x5d9f */
    KANJI,        /* 0x5da0 */
    KANJI,        /* 0x5da1 */
    KANJI,        /* 0x5da2 */
    KANJI,        /* 0x5da3 */
    KANJI,        /* 0x5da4 */
    KANJI,        /* 0x5da5 */
    KANJI,        /* 0x5da6 */
    KANJI,        /* 0x5da7 */
    KANJI,        /* 0x5da8 */
    KANJI,        /* 0x5da9 */
    KANJI,        /* 0x5daa */
    KANJI,        /* 0x5dab */
    KANJI,        /* 0x5dac */
    KANJI,        /* 0x5dad */
    KANJI,        /* 0x5dae */
    KANJI,        /* 0x5daf */
    KANJI,        /* 0x5db0 */
    KANJI,        /* 0x5db1 */
    KANJI,        /* 0x5db2 */
    KANJI,        /* 0x5db3 */
    KANJI,        /* 0x5db4 */
    KANJI,        /* 0x5db5 */
    KANJI,        /* 0x5db6 */
    KANJI,        /* 0x5db7 */
    KANJI,        /* 0x5db8 */
    KANJI,        /* 0x5db9 */
    KANJI,        /* 0x5dba */
    KANJI,        /* 0x5dbb */
    KANJI,        /* 0x5dbc */
    KANJI,        /* 0x5dbd */
    KANJI,        /* 0x5dbe */
    KANJI,        /* 0x5dbf */
    KANJI,        /* 0x5dc0 */
    KANJI,        /* 0x5dc1 */
    KANJI,        /* 0x5dc2 */
    KANJI,        /* 0x5dc3 */
    KANJI,        /* 0x5dc4 */
    KANJI,        /* 0x5dc5 */
    KANJI,        /* 0x5dc6 */
    KANJI,        /* 0x5dc7 */
    KANJI,        /* 0x5dc8 */
    KANJI,        /* 0x5dc9 */
    KANJI,        /* 0x5dca */
    KANJI,        /* 0x5dcb */
    KANJI,        /* 0x5dcc */
    KANJI,        /* 0x5dcd */
    KANJI,        /* 0x5dce */
    KANJI,        /* 0x5dcf */
    KANJI,        /* 0x5dd0 */
    KANJI,        /* 0x5dd1 */
    KANJI,        /* 0x5dd2 */
    KANJI,        /* 0x5dd3 */
    KANJI,        /* 0x5dd4 */
    KANJI,        /* 0x5dd5 */
    KANJI,        /* 0x5dd6 */
    KANJI,        /* 0x5dd7 */
    KANJI,        /* 0x5dd8 */
    KANJI,        /* 0x5dd9 */
    KANJI,        /* 0x5dda */
    KANJI,        /* 0x5ddb */
    KANJI,        /* 0x5ddc */
    KANJI,        /* 0x5ddd */
    KANJI,        /* 0x5dde */
    KANJI,        /* 0x5ddf */
    KANJI,        /* 0x5de0 */
    KANJI,        /* 0x5de1 */
    KANJI,        /* 0x5de2 */
    KANJI,        /* 0x5de3 */
    KANJI,        /* 0x5de4 */
    KANJI,        /* 0x5de5 */
    KANJI,        /* 0x5de6 */
    KANJI,        /* 0x5de7 */
    KANJI,        /* 0x5de8 */
    KANJI,        /* 0x5de9 */
    KANJI,        /* 0x5dea */
    KANJI,        /* 0x5deb */
    KANJI,        /* 0x5dec */
    KANJI,        /* 0x5ded */
    KANJI,        /* 0x5dee */
    KANJI,        /* 0x5def */
    KANJI,        /* 0x5df0 */
    KANJI,        /* 0x5df1 */
    KANJI,        /* 0x5df2 */
    KANJI,        /* 0x5df3 */
    KANJI,        /* 0x5df4 */
    KANJI,        /* 0x5df5 */
    KANJI,        /* 0x5df6 */
    KANJI,        /* 0x5df7 */
    KANJI,        /* 0x5df8 */
    KANJI,        /* 0x5df9 */
    KANJI,        /* 0x5dfa */
    KANJI,        /* 0x5dfb */
    KANJI,        /* 0x5dfc */
    KANJI,        /* 0x5dfd */
    KANJI,        /* 0x5dfe */
    KANJI,        /* 0x5dff */
    KANJI,        /* 0x5e00 */
    KANJI,        /* 0x5e01 */
    KANJI,        /* 0x5e02 */
    KANJI,        /* 0x5e03 */
    KANJI,        /* 0x5e04 */
    KANJI,        /* 0x5e05 */
    KANJI,        /* 0x5e06 */
    KANJI,        /* 0x5e07 */
    KANJI,        /* 0x5e08 */
    KANJI,        /* 0x5e09 */
    KANJI,        /* 0x5e0a */
    KANJI,        /* 0x5e0b */
    KANJI,        /* 0x5e0c */
    KANJI,        /* 0x5e0d */
    KANJI,        /* 0x5e0e */
    KANJI,        /* 0x5e0f */
    KANJI,        /* 0x5e10 */
    KANJI,        /* 0x5e11 */
    KANJI,        /* 0x5e12 */
    KANJI,        /* 0x5e13 */
    KANJI,        /* 0x5e14 */
    KANJI,        /* 0x5e15 */
    KANJI,        /* 0x5e16 */
    KANJI,        /* 0x5e17 */
    KANJI,        /* 0x5e18 */
    KANJI,        /* 0x5e19 */
    KANJI,        /* 0x5e1a */
    KANJI,        /* 0x5e1b */
    KANJI,        /* 0x5e1c */
    KANJI,        /* 0x5e1d */
    KANJI,        /* 0x5e1e */
    KANJI,        /* 0x5e1f */
    KANJI,        /* 0x5e20 */
    KANJI,        /* 0x5e21 */
    KANJI,        /* 0x5e22 */
    KANJI,        /* 0x5e23 */
    KANJI,        /* 0x5e24 */
    KANJI,        /* 0x5e25 */
    KANJI,        /* 0x5e26 */
    KANJI,        /* 0x5e27 */
    KANJI,        /* 0x5e28 */
    KANJI,        /* 0x5e29 */
    KANJI,        /* 0x5e2a */
    KANJI,        /* 0x5e2b */
    KANJI,        /* 0x5e2c */
    KANJI,        /* 0x5e2d */
    KANJI,        /* 0x5e2e */
    KANJI,        /* 0x5e2f */
    KANJI,        /* 0x5e30 */
    KANJI,        /* 0x5e31 */
    KANJI,        /* 0x5e32 */
    KANJI,        /* 0x5e33 */
    KANJI,        /* 0x5e34 */
    KANJI,        /* 0x5e35 */
    KANJI,        /* 0x5e36 */
    KANJI,        /* 0x5e37 */
    KANJI,        /* 0x5e38 */
    KANJI,        /* 0x5e39 */
    KANJI,        /* 0x5e3a */
    KANJI,        /* 0x5e3b */
    KANJI,        /* 0x5e3c */
    KANJI,        /* 0x5e3d */
    KANJI,        /* 0x5e3e */
    KANJI,        /* 0x5e3f */
    KANJI,        /* 0x5e40 */
    KANJI,        /* 0x5e41 */
    KANJI,        /* 0x5e42 */
    KANJI,        /* 0x5e43 */
    KANJI,        /* 0x5e44 */
    KANJI,        /* 0x5e45 */
    KANJI,        /* 0x5e46 */
    KANJI,        /* 0x5e47 */
    KANJI,        /* 0x5e48 */
    KANJI,        /* 0x5e49 */
    KANJI,        /* 0x5e4a */
    KANJI,        /* 0x5e4b */
    KANJI,        /* 0x5e4c */
    KANJI,        /* 0x5e4d */
    KANJI,        /* 0x5e4e */
    KANJI,        /* 0x5e4f */
    KANJI,        /* 0x5e50 */
    KANJI,        /* 0x5e51 */
    KANJI,        /* 0x5e52 */
    KANJI,        /* 0x5e53 */
    KANJI,        /* 0x5e54 */
    KANJI,        /* 0x5e55 */
    KANJI,        /* 0x5e56 */
    KANJI,        /* 0x5e57 */
    KANJI,        /* 0x5e58 */
    KANJI,        /* 0x5e59 */
    KANJI,        /* 0x5e5a */
    KANJI,        /* 0x5e5b */
    KANJI,        /* 0x5e5c */
    KANJI,        /* 0x5e5d */
    KANJI,        /* 0x5e5e */
    KANJI,        /* 0x5e5f */
    KANJI,        /* 0x5e60 */
    KANJI,        /* 0x5e61 */
    KANJI,        /* 0x5e62 */
    KANJI,        /* 0x5e63 */
    KANJI,        /* 0x5e64 */
    KANJI,        /* 0x5e65 */
    KANJI,        /* 0x5e66 */
    KANJI,        /* 0x5e67 */
    KANJI,        /* 0x5e68 */
    KANJI,        /* 0x5e69 */
    KANJI,        /* 0x5e6a */
    KANJI,        /* 0x5e6b */
    KANJI,        /* 0x5e6c */
    KANJI,        /* 0x5e6d */
    KANJI,        /* 0x5e6e */
    KANJI,        /* 0x5e6f */
    KANJI,        /* 0x5e70 */
    KANJI,        /* 0x5e71 */
    KANJI,        /* 0x5e72 */
    KANJI,        /* 0x5e73 */
    KANJI,        /* 0x5e74 */
    KANJI,        /* 0x5e75 */
    KANJI,        /* 0x5e76 */
    KANJI,        /* 0x5e77 */
    KANJI,        /* 0x5e78 */
    KANJI,        /* 0x5e79 */
    KANJI,        /* 0x5e7a */
    KANJI,        /* 0x5e7b */
    KANJI,        /* 0x5e7c */
    KANJI,        /* 0x5e7d */
    KANJI,        /* 0x5e7e */
    KANJI,        /* 0x5e7f */
    KANJI,        /* 0x5e80 */
    KANJI,        /* 0x5e81 */
    KANJI,        /* 0x5e82 */
    KANJI,        /* 0x5e83 */
    KANJI,        /* 0x5e84 */
    KANJI,        /* 0x5e85 */
    KANJI,        /* 0x5e86 */
    KANJI,        /* 0x5e87 */
    KANJI,        /* 0x5e88 */
    KANJI,        /* 0x5e89 */
    KANJI,        /* 0x5e8a */
    KANJI,        /* 0x5e8b */
    KANJI,        /* 0x5e8c */
    KANJI,        /* 0x5e8d */
    KANJI,        /* 0x5e8e */
    KANJI,        /* 0x5e8f */
    KANJI,        /* 0x5e90 */
    KANJI,        /* 0x5e91 */
    KANJI,        /* 0x5e92 */
    KANJI,        /* 0x5e93 */
    KANJI,        /* 0x5e94 */
    KANJI,        /* 0x5e95 */
    KANJI,        /* 0x5e96 */
    KANJI,        /* 0x5e97 */
    KANJI,        /* 0x5e98 */
    KANJI,        /* 0x5e99 */
    KANJI,        /* 0x5e9a */
    KANJI,        /* 0x5e9b */
    KANJI,        /* 0x5e9c */
    KANJI,        /* 0x5e9d */
    KANJI,        /* 0x5e9e */
    KANJI,        /* 0x5e9f */
    KANJI,        /* 0x5ea0 */
    KANJI,        /* 0x5ea1 */
    KANJI,        /* 0x5ea2 */
    KANJI,        /* 0x5ea3 */
    KANJI,        /* 0x5ea4 */
    KANJI,        /* 0x5ea5 */
    KANJI,        /* 0x5ea6 */
    KANJI,        /* 0x5ea7 */
    KANJI,        /* 0x5ea8 */
    KANJI,        /* 0x5ea9 */
    KANJI,        /* 0x5eaa */
    KANJI,        /* 0x5eab */
    KANJI,        /* 0x5eac */
    KANJI,        /* 0x5ead */
    KANJI,        /* 0x5eae */
    KANJI,        /* 0x5eaf */
    KANJI,        /* 0x5eb0 */
    KANJI,        /* 0x5eb1 */
    KANJI,        /* 0x5eb2 */
    KANJI,        /* 0x5eb3 */
    KANJI,        /* 0x5eb4 */
    KANJI,        /* 0x5eb5 */
    KANJI,        /* 0x5eb6 */
    KANJI,        /* 0x5eb7 */
    KANJI,        /* 0x5eb8 */
    KANJI,        /* 0x5eb9 */
    KANJI,        /* 0x5eba */
    KANJI,        /* 0x5ebb */
    KANJI,        /* 0x5ebc */
    KANJI,        /* 0x5ebd */
    KANJI,        /* 0x5ebe */
    KANJI,        /* 0x5ebf */
    KANJI,        /* 0x5ec0 */
    KANJI,        /* 0x5ec1 */
    KANJI,        /* 0x5ec2 */
    KANJI,        /* 0x5ec3 */
    KANJI,        /* 0x5ec4 */
    KANJI,        /* 0x5ec5 */
    KANJI,        /* 0x5ec6 */
    KANJI,        /* 0x5ec7 */
    KANJI,        /* 0x5ec8 */
    KANJI,        /* 0x5ec9 */
    KANJI,        /* 0x5eca */
    KANJI,        /* 0x5ecb */
    KANJI,        /* 0x5ecc */
    KANJI,        /* 0x5ecd */
    KANJI,        /* 0x5ece */
    KANJI,        /* 0x5ecf */
    KANJI,        /* 0x5ed0 */
    KANJI,        /* 0x5ed1 */
    KANJI,        /* 0x5ed2 */
    KANJI,        /* 0x5ed3 */
    KANJI,        /* 0x5ed4 */
    KANJI,        /* 0x5ed5 */
    KANJI,        /* 0x5ed6 */
    KANJI,        /* 0x5ed7 */
    KANJI,        /* 0x5ed8 */
    KANJI,        /* 0x5ed9 */
    KANJI,        /* 0x5eda */
    KANJI,        /* 0x5edb */
    KANJI,        /* 0x5edc */
    KANJI,        /* 0x5edd */
    KANJI,        /* 0x5ede */
    KANJI,        /* 0x5edf */
    KANJI,        /* 0x5ee0 */
    KANJI,        /* 0x5ee1 */
    KANJI,        /* 0x5ee2 */
    KANJI,        /* 0x5ee3 */
    KANJI,        /* 0x5ee4 */
    KANJI,        /* 0x5ee5 */
    KANJI,        /* 0x5ee6 */
    KANJI,        /* 0x5ee7 */
    KANJI,        /* 0x5ee8 */
    KANJI,        /* 0x5ee9 */
    KANJI,        /* 0x5eea */
    KANJI,        /* 0x5eeb */
    KANJI,        /* 0x5eec */
    KANJI,        /* 0x5eed */
    KANJI,        /* 0x5eee */
    KANJI,        /* 0x5eef */
    KANJI,        /* 0x5ef0 */
    KANJI,        /* 0x5ef1 */
    KANJI,        /* 0x5ef2 */
    KANJI,        /* 0x5ef3 */
    KANJI,        /* 0x5ef4 */
    KANJI,        /* 0x5ef5 */
    KANJI,        /* 0x5ef6 */
    KANJI,        /* 0x5ef7 */
    KANJI,        /* 0x5ef8 */
    KANJI,        /* 0x5ef9 */
    KANJI,        /* 0x5efa */
    KANJI,        /* 0x5efb */
    KANJI,        /* 0x5efc */
    KANJI,        /* 0x5efd */
    KANJI,        /* 0x5efe */
    KANJI,        /* 0x5eff */
    KANJI,        /* 0x5f00 */
    KANJI,        /* 0x5f01 */
    KANJI,        /* 0x5f02 */
    KANJI,        /* 0x5f03 */
    KANJI,        /* 0x5f04 */
    KANJI,        /* 0x5f05 */
    KANJI,        /* 0x5f06 */
    KANJI,        /* 0x5f07 */
    KANJI,        /* 0x5f08 */
    KANJI,        /* 0x5f09 */
    KANJI,        /* 0x5f0a */
    KANJI,        /* 0x5f0b */
    KANJI,        /* 0x5f0c */
    KANJI,        /* 0x5f0d */
    KANJI,        /* 0x5f0e */
    KANJI,        /* 0x5f0f */
    KANJI,        /* 0x5f10 */
    KANJI,        /* 0x5f11 */
    KANJI,        /* 0x5f12 */
    KANJI,        /* 0x5f13 */
    KANJI,        /* 0x5f14 */
    KANJI,        /* 0x5f15 */
    KANJI,        /* 0x5f16 */
    KANJI,        /* 0x5f17 */
    KANJI,        /* 0x5f18 */
    KANJI,        /* 0x5f19 */
    KANJI,        /* 0x5f1a */
    KANJI,        /* 0x5f1b */
    KANJI,        /* 0x5f1c */
    KANJI,        /* 0x5f1d */
    KANJI,        /* 0x5f1e */
    KANJI,        /* 0x5f1f */
    KANJI,        /* 0x5f20 */
    KANJI,        /* 0x5f21 */
    KANJI,        /* 0x5f22 */
    KANJI,        /* 0x5f23 */
    KANJI,        /* 0x5f24 */
    KANJI,        /* 0x5f25 */
    KANJI,        /* 0x5f26 */
    KANJI,        /* 0x5f27 */
    KANJI,        /* 0x5f28 */
    KANJI,        /* 0x5f29 */
    KANJI,        /* 0x5f2a */
    KANJI,        /* 0x5f2b */
    KANJI,        /* 0x5f2c */
    KANJI,        /* 0x5f2d */
    KANJI,        /* 0x5f2e */
    KANJI,        /* 0x5f2f */
    KANJI,        /* 0x5f30 */
    KANJI,        /* 0x5f31 */
    KANJI,        /* 0x5f32 */
    KANJI,        /* 0x5f33 */
    KANJI,        /* 0x5f34 */
    KANJI,        /* 0x5f35 */
    KANJI,        /* 0x5f36 */
    KANJI,        /* 0x5f37 */
    KANJI,        /* 0x5f38 */
    KANJI,        /* 0x5f39 */
    KANJI,        /* 0x5f3a */
    KANJI,        /* 0x5f3b */
    KANJI,        /* 0x5f3c */
    KANJI,        /* 0x5f3d */
    KANJI,        /* 0x5f3e */
    KANJI,        /* 0x5f3f */
    KANJI,        /* 0x5f40 */
    KANJI,        /* 0x5f41 */
    KANJI,        /* 0x5f42 */
    KANJI,        /* 0x5f43 */
    KANJI,        /* 0x5f44 */
    KANJI,        /* 0x5f45 */
    KANJI,        /* 0x5f46 */
    KANJI,        /* 0x5f47 */
    KANJI,        /* 0x5f48 */
    KANJI,        /* 0x5f49 */
    KANJI,        /* 0x5f4a */
    KANJI,        /* 0x5f4b */
    KANJI,        /* 0x5f4c */
    KANJI,        /* 0x5f4d */
    KANJI,        /* 0x5f4e */
    KANJI,        /* 0x5f4f */
    KANJI,        /* 0x5f50 */
    KANJI,        /* 0x5f51 */
    KANJI,        /* 0x5f52 */
    KANJI,        /* 0x5f53 */
    KANJI,        /* 0x5f54 */
    KANJI,        /* 0x5f55 */
    KANJI,        /* 0x5f56 */
    KANJI,        /* 0x5f57 */
    KANJI,        /* 0x5f58 */
    KANJI,        /* 0x5f59 */
    KANJI,        /* 0x5f5a */
    KANJI,        /* 0x5f5b */
    KANJI,        /* 0x5f5c */
    KANJI,        /* 0x5f5d */
    KANJI,        /* 0x5f5e */
    KANJI,        /* 0x5f5f */
    KANJI,        /* 0x5f60 */
    KANJI,        /* 0x5f61 */
    KANJI,        /* 0x5f62 */
    KANJI,        /* 0x5f63 */
    KANJI,        /* 0x5f64 */
    KANJI,        /* 0x5f65 */
    KANJI,        /* 0x5f66 */
    KANJI,        /* 0x5f67 */
    KANJI,        /* 0x5f68 */
    KANJI,        /* 0x5f69 */
    KANJI,        /* 0x5f6a */
    KANJI,        /* 0x5f6b */
    KANJI,        /* 0x5f6c */
    KANJI,        /* 0x5f6d */
    KANJI,        /* 0x5f6e */
    KANJI,        /* 0x5f6f */
    KANJI,        /* 0x5f70 */
    KANJI,        /* 0x5f71 */
    KANJI,        /* 0x5f72 */
    KANJI,        /* 0x5f73 */
    KANJI,        /* 0x5f74 */
    KANJI,        /* 0x5f75 */
    KANJI,        /* 0x5f76 */
    KANJI,        /* 0x5f77 */
    KANJI,        /* 0x5f78 */
    KANJI,        /* 0x5f79 */
    KANJI,        /* 0x5f7a */
    KANJI,        /* 0x5f7b */
    KANJI,        /* 0x5f7c */
    KANJI,        /* 0x5f7d */
    KANJI,        /* 0x5f7e */
    KANJI,        /* 0x5f7f */
    KANJI,        /* 0x5f80 */
    KANJI,        /* 0x5f81 */
    KANJI,        /* 0x5f82 */
    KANJI,        /* 0x5f83 */
    KANJI,        /* 0x5f84 */
    KANJI,        /* 0x5f85 */
    KANJI,        /* 0x5f86 */
    KANJI,        /* 0x5f87 */
    KANJI,        /* 0x5f88 */
    KANJI,        /* 0x5f89 */
    KANJI,        /* 0x5f8a */
    KANJI,        /* 0x5f8b */
    KANJI,        /* 0x5f8c */
    KANJI,        /* 0x5f8d */
    KANJI,        /* 0x5f8e */
    KANJI,        /* 0x5f8f */
    KANJI,        /* 0x5f90 */
    KANJI,        /* 0x5f91 */
    KANJI,        /* 0x5f92 */
    KANJI,        /* 0x5f93 */
    KANJI,        /* 0x5f94 */
    KANJI,        /* 0x5f95 */
    KANJI,        /* 0x5f96 */
    KANJI,        /* 0x5f97 */
    KANJI,        /* 0x5f98 */
    KANJI,        /* 0x5f99 */
    KANJI,        /* 0x5f9a */
    KANJI,        /* 0x5f9b */
    KANJI,        /* 0x5f9c */
    KANJI,        /* 0x5f9d */
    KANJI,        /* 0x5f9e */
    KANJI,        /* 0x5f9f */
    KANJI,        /* 0x5fa0 */
    KANJI,        /* 0x5fa1 */
    KANJI,        /* 0x5fa2 */
    KANJI,        /* 0x5fa3 */
    KANJI,        /* 0x5fa4 */
    KANJI,        /* 0x5fa5 */
    KANJI,        /* 0x5fa6 */
    KANJI,        /* 0x5fa7 */
    KANJI,        /* 0x5fa8 */
    KANJI,        /* 0x5fa9 */
    KANJI,        /* 0x5faa */
    KANJI,        /* 0x5fab */
    KANJI,        /* 0x5fac */
    KANJI,        /* 0x5fad */
    KANJI,        /* 0x5fae */
    KANJI,        /* 0x5faf */
    KANJI,        /* 0x5fb0 */
    KANJI,        /* 0x5fb1 */
    KANJI,        /* 0x5fb2 */
    KANJI,        /* 0x5fb3 */
    KANJI,        /* 0x5fb4 */
    KANJI,        /* 0x5fb5 */
    KANJI,        /* 0x5fb6 */
    KANJI,        /* 0x5fb7 */
    KANJI,        /* 0x5fb8 */
    KANJI,        /* 0x5fb9 */
    KANJI,        /* 0x5fba */
    KANJI,        /* 0x5fbb */
    KANJI,        /* 0x5fbc */
    KANJI,        /* 0x5fbd */
    KANJI,        /* 0x5fbe */
    KANJI,        /* 0x5fbf */
    KANJI,        /* 0x5fc0 */
    KANJI,        /* 0x5fc1 */
    KANJI,        /* 0x5fc2 */
    KANJI,        /* 0x5fc3 */
    KANJI,        /* 0x5fc4 */
    KANJI,        /* 0x5fc5 */
    KANJI,        /* 0x5fc6 */
    KANJI,        /* 0x5fc7 */
    KANJI,        /* 0x5fc8 */
    KANJI,        /* 0x5fc9 */
    KANJI,        /* 0x5fca */
    KANJI,        /* 0x5fcb */
    KANJI,        /* 0x5fcc */
    KANJI,        /* 0x5fcd */
    KANJI,        /* 0x5fce */
    KANJI,        /* 0x5fcf */
    KANJI,        /* 0x5fd0 */
    KANJI,        /* 0x5fd1 */
    KANJI,        /* 0x5fd2 */
    KANJI,        /* 0x5fd3 */
    KANJI,        /* 0x5fd4 */
    KANJI,        /* 0x5fd5 */
    KANJI,        /* 0x5fd6 */
    KANJI,        /* 0x5fd7 */
    KANJI,        /* 0x5fd8 */
    KANJI,        /* 0x5fd9 */
    KANJI,        /* 0x5fda */
    KANJI,        /* 0x5fdb */
    KANJI,        /* 0x5fdc */
    KANJI,        /* 0x5fdd */
    KANJI,        /* 0x5fde */
    KANJI,        /* 0x5fdf */
    KANJI,        /* 0x5fe0 */
    KANJI,        /* 0x5fe1 */
    KANJI,        /* 0x5fe2 */
    KANJI,        /* 0x5fe3 */
    KANJI,        /* 0x5fe4 */
    KANJI,        /* 0x5fe5 */
    KANJI,        /* 0x5fe6 */
    KANJI,        /* 0x5fe7 */
    KANJI,        /* 0x5fe8 */
    KANJI,        /* 0x5fe9 */
    KANJI,        /* 0x5fea */
    KANJI,        /* 0x5feb */
    KANJI,        /* 0x5fec */
    KANJI,        /* 0x5fed */
    KANJI,        /* 0x5fee */
    KANJI,        /* 0x5fef */
    KANJI,        /* 0x5ff0 */
    KANJI,        /* 0x5ff1 */
    KANJI,        /* 0x5ff2 */
    KANJI,        /* 0x5ff3 */
    KANJI,        /* 0x5ff4 */
    KANJI,        /* 0x5ff5 */
    KANJI,        /* 0x5ff6 */
    KANJI,        /* 0x5ff7 */
    KANJI,        /* 0x5ff8 */
    KANJI,        /* 0x5ff9 */
    KANJI,        /* 0x5ffa */
    KANJI,        /* 0x5ffb */
    KANJI,        /* 0x5ffc */
    KANJI,        /* 0x5ffd */
    KANJI,        /* 0x5ffe */
    KANJI,        /* 0x5fff */
    KANJI,        /* 0x6000 */
    KANJI,        /* 0x6001 */
    KANJI,        /* 0x6002 */
    KANJI,        /* 0x6003 */
    KANJI,        /* 0x6004 */
    KANJI,        /* 0x6005 */
    KANJI,        /* 0x6006 */
    KANJI,        /* 0x6007 */
    KANJI,        /* 0x6008 */
    KANJI,        /* 0x6009 */
    KANJI,        /* 0x600a */
    KANJI,        /* 0x600b */
    KANJI,        /* 0x600c */
    KANJI,        /* 0x600d */
    KANJI,        /* 0x600e */
    KANJI,        /* 0x600f */
    KANJI,        /* 0x6010 */
    KANJI,        /* 0x6011 */
    KANJI,        /* 0x6012 */
    KANJI,        /* 0x6013 */
    KANJI,        /* 0x6014 */
    KANJI,        /* 0x6015 */
    KANJI,        /* 0x6016 */
    KANJI,        /* 0x6017 */
    KANJI,        /* 0x6018 */
    KANJI,        /* 0x6019 */
    KANJI,        /* 0x601a */
    KANJI,        /* 0x601b */
    KANJI,        /* 0x601c */
    KANJI,        /* 0x601d */
    KANJI,        /* 0x601e */
    KANJI,        /* 0x601f */
    KANJI,        /* 0x6020 */
    KANJI,        /* 0x6021 */
    KANJI,        /* 0x6022 */
    KANJI,        /* 0x6023 */
    KANJI,        /* 0x6024 */
    KANJI,        /* 0x6025 */
    KANJI,        /* 0x6026 */
    KANJI,        /* 0x6027 */
    KANJI,        /* 0x6028 */
    KANJI,        /* 0x6029 */
    KANJI,        /* 0x602a */
    KANJI,        /* 0x602b */
    KANJI,        /* 0x602c */
    KANJI,        /* 0x602d */
    KANJI,        /* 0x602e */
    KANJI,        /* 0x602f */
    KANJI,        /* 0x6030 */
    KANJI,        /* 0x6031 */
    KANJI,        /* 0x6032 */
    KANJI,        /* 0x6033 */
    KANJI,        /* 0x6034 */
    KANJI,        /* 0x6035 */
    KANJI,        /* 0x6036 */
    KANJI,        /* 0x6037 */
    KANJI,        /* 0x6038 */
    KANJI,        /* 0x6039 */
    KANJI,        /* 0x603a */
    KANJI,        /* 0x603b */
    KANJI,        /* 0x603c */
    KANJI,        /* 0x603d */
    KANJI,        /* 0x603e */
    KANJI,        /* 0x603f */
    KANJI,        /* 0x6040 */
    KANJI,        /* 0x6041 */
    KANJI,        /* 0x6042 */
    KANJI,        /* 0x6043 */
    KANJI,        /* 0x6044 */
    KANJI,        /* 0x6045 */
    KANJI,        /* 0x6046 */
    KANJI,        /* 0x6047 */
    KANJI,        /* 0x6048 */
    KANJI,        /* 0x6049 */
    KANJI,        /* 0x604a */
    KANJI,        /* 0x604b */
    KANJI,        /* 0x604c */
    KANJI,        /* 0x604d */
    KANJI,        /* 0x604e */
    KANJI,        /* 0x604f */
    KANJI,        /* 0x6050 */
    KANJI,        /* 0x6051 */
    KANJI,        /* 0x6052 */
    KANJI,        /* 0x6053 */
    KANJI,        /* 0x6054 */
    KANJI,        /* 0x6055 */
    KANJI,        /* 0x6056 */
    KANJI,        /* 0x6057 */
    KANJI,        /* 0x6058 */
    KANJI,        /* 0x6059 */
    KANJI,        /* 0x605a */
    KANJI,        /* 0x605b */
    KANJI,        /* 0x605c */
    KANJI,        /* 0x605d */
    KANJI,        /* 0x605e */
    KANJI,        /* 0x605f */
    KANJI,        /* 0x6060 */
    KANJI,        /* 0x6061 */
    KANJI,        /* 0x6062 */
    KANJI,        /* 0x6063 */
    KANJI,        /* 0x6064 */
    KANJI,        /* 0x6065 */
    KANJI,        /* 0x6066 */
    KANJI,        /* 0x6067 */
    KANJI,        /* 0x6068 */
    KANJI,        /* 0x6069 */
    KANJI,        /* 0x606a */
    KANJI,        /* 0x606b */
    KANJI,        /* 0x606c */
    KANJI,        /* 0x606d */
    KANJI,        /* 0x606e */
    KANJI,        /* 0x606f */
    KANJI,        /* 0x6070 */
    KANJI,        /* 0x6071 */
    KANJI,        /* 0x6072 */
    KANJI,        /* 0x6073 */
    KANJI,        /* 0x6074 */
    KANJI,        /* 0x6075 */
    KANJI,        /* 0x6076 */
    KANJI,        /* 0x6077 */
    KANJI,        /* 0x6078 */
    KANJI,        /* 0x6079 */
    KANJI,        /* 0x607a */
    KANJI,        /* 0x607b */
    KANJI,        /* 0x607c */
    KANJI,        /* 0x607d */
    KANJI,        /* 0x607e */
    KANJI,        /* 0x607f */
    KANJI,        /* 0x6080 */
    KANJI,        /* 0x6081 */
    KANJI,        /* 0x6082 */
    KANJI,        /* 0x6083 */
    KANJI,        /* 0x6084 */
    KANJI,        /* 0x6085 */
    KANJI,        /* 0x6086 */
    KANJI,        /* 0x6087 */
    KANJI,        /* 0x6088 */
    KANJI,        /* 0x6089 */
    KANJI,        /* 0x608a */
    KANJI,        /* 0x608b */
    KANJI,        /* 0x608c */
    KANJI,        /* 0x608d */
    KANJI,        /* 0x608e */
    KANJI,        /* 0x608f */
    KANJI,        /* 0x6090 */
    KANJI,        /* 0x6091 */
    KANJI,        /* 0x6092 */
    KANJI,        /* 0x6093 */
    KANJI,        /* 0x6094 */
    KANJI,        /* 0x6095 */
    KANJI,        /* 0x6096 */
    KANJI,        /* 0x6097 */
    KANJI,        /* 0x6098 */
    KANJI,        /* 0x6099 */
    KANJI,        /* 0x609a */
    KANJI,        /* 0x609b */
    KANJI,        /* 0x609c */
    KANJI,        /* 0x609d */
    KANJI,        /* 0x609e */
    KANJI,        /* 0x609f */
    KANJI,        /* 0x60a0 */
    KANJI,        /* 0x60a1 */
    KANJI,        /* 0x60a2 */
    KANJI,        /* 0x60a3 */
    KANJI,        /* 0x60a4 */
    KANJI,        /* 0x60a5 */
    KANJI,        /* 0x60a6 */
    KANJI,        /* 0x60a7 */
    KANJI,        /* 0x60a8 */
    KANJI,        /* 0x60a9 */
    KANJI,        /* 0x60aa */
    KANJI,        /* 0x60ab */
    KANJI,        /* 0x60ac */
    KANJI,        /* 0x60ad */
    KANJI,        /* 0x60ae */
    KANJI,        /* 0x60af */
    KANJI,        /* 0x60b0 */
    KANJI,        /* 0x60b1 */
    KANJI,        /* 0x60b2 */
    KANJI,        /* 0x60b3 */
    KANJI,        /* 0x60b4 */
    KANJI,        /* 0x60b5 */
    KANJI,        /* 0x60b6 */
    KANJI,        /* 0x60b7 */
    KANJI,        /* 0x60b8 */
    KANJI,        /* 0x60b9 */
    KANJI,        /* 0x60ba */
    KANJI,        /* 0x60bb */
    KANJI,        /* 0x60bc */
    KANJI,        /* 0x60bd */
    KANJI,        /* 0x60be */
    KANJI,        /* 0x60bf */
    KANJI,        /* 0x60c0 */
    KANJI,        /* 0x60c1 */
    KANJI,        /* 0x60c2 */
    KANJI,        /* 0x60c3 */
    KANJI,        /* 0x60c4 */
    KANJI,        /* 0x60c5 */
    KANJI,        /* 0x60c6 */
    KANJI,        /* 0x60c7 */
    KANJI,        /* 0x60c8 */
    KANJI,        /* 0x60c9 */
    KANJI,        /* 0x60ca */
    KANJI,        /* 0x60cb */
    KANJI,        /* 0x60cc */
    KANJI,        /* 0x60cd */
    KANJI,        /* 0x60ce */
    KANJI,        /* 0x60cf */
    KANJI,        /* 0x60d0 */
    KANJI,        /* 0x60d1 */
    KANJI,        /* 0x60d2 */
    KANJI,        /* 0x60d3 */
    KANJI,        /* 0x60d4 */
    KANJI,        /* 0x60d5 */
    KANJI,        /* 0x60d6 */
    KANJI,        /* 0x60d7 */
    KANJI,        /* 0x60d8 */
    KANJI,        /* 0x60d9 */
    KANJI,        /* 0x60da */
    KANJI,        /* 0x60db */
    KANJI,        /* 0x60dc */
    KANJI,        /* 0x60dd */
    KANJI,        /* 0x60de */
    KANJI,        /* 0x60df */
    KANJI,        /* 0x60e0 */
    KANJI,        /* 0x60e1 */
    KANJI,        /* 0x60e2 */
    KANJI,        /* 0x60e3 */
    KANJI,        /* 0x60e4 */
    KANJI,        /* 0x60e5 */
    KANJI,        /* 0x60e6 */
    KANJI,        /* 0x60e7 */
    KANJI,        /* 0x60e8 */
    KANJI,        /* 0x60e9 */
    KANJI,        /* 0x60ea */
    KANJI,        /* 0x60eb */
    KANJI,        /* 0x60ec */
    KANJI,        /* 0x60ed */
    KANJI,        /* 0x60ee */
    KANJI,        /* 0x60ef */
    KANJI,        /* 0x60f0 */
    KANJI,        /* 0x60f1 */
    KANJI,        /* 0x60f2 */
    KANJI,        /* 0x60f3 */
    KANJI,        /* 0x60f4 */
    KANJI,        /* 0x60f5 */
    KANJI,        /* 0x60f6 */
    KANJI,        /* 0x60f7 */
    KANJI,        /* 0x60f8 */
    KANJI,        /* 0x60f9 */
    KANJI,        /* 0x60fa */
    KANJI,        /* 0x60fb */
    KANJI,        /* 0x60fc */
    KANJI,        /* 0x60fd */
    KANJI,        /* 0x60fe */
    KANJI,        /* 0x60ff */
    KANJI,        /* 0x6100 */
    KANJI,        /* 0x6101 */
    KANJI,        /* 0x6102 */
    KANJI,        /* 0x6103 */
    KANJI,        /* 0x6104 */
    KANJI,        /* 0x6105 */
    KANJI,        /* 0x6106 */
    KANJI,        /* 0x6107 */
    KANJI,        /* 0x6108 */
    KANJI,        /* 0x6109 */
    KANJI,        /* 0x610a */
    KANJI,        /* 0x610b */
    KANJI,        /* 0x610c */
    KANJI,        /* 0x610d */
    KANJI,        /* 0x610e */
    KANJI,        /* 0x610f */
    KANJI,        /* 0x6110 */
    KANJI,        /* 0x6111 */
    KANJI,        /* 0x6112 */
    KANJI,        /* 0x6113 */
    KANJI,        /* 0x6114 */
    KANJI,        /* 0x6115 */
    KANJI,        /* 0x6116 */
    KANJI,        /* 0x6117 */
    KANJI,        /* 0x6118 */
    KANJI,        /* 0x6119 */
    KANJI,        /* 0x611a */
    KANJI,        /* 0x611b */
    KANJI,        /* 0x611c */
    KANJI,        /* 0x611d */
    KANJI,        /* 0x611e */
    KANJI,        /* 0x611f */
    KANJI,        /* 0x6120 */
    KANJI,        /* 0x6121 */
    KANJI,        /* 0x6122 */
    KANJI,        /* 0x6123 */
    KANJI,        /* 0x6124 */
    KANJI,        /* 0x6125 */
    KANJI,        /* 0x6126 */
    KANJI,        /* 0x6127 */
    KANJI,        /* 0x6128 */
    KANJI,        /* 0x6129 */
    KANJI,        /* 0x612a */
    KANJI,        /* 0x612b */
    KANJI,        /* 0x612c */
    KANJI,        /* 0x612d */
    KANJI,        /* 0x612e */
    KANJI,        /* 0x612f */
    KANJI,        /* 0x6130 */
    KANJI,        /* 0x6131 */
    KANJI,        /* 0x6132 */
    KANJI,        /* 0x6133 */
    KANJI,        /* 0x6134 */
    KANJI,        /* 0x6135 */
    KANJI,        /* 0x6136 */
    KANJI,        /* 0x6137 */
    KANJI,        /* 0x6138 */
    KANJI,        /* 0x6139 */
    KANJI,        /* 0x613a */
    KANJI,        /* 0x613b */
    KANJI,        /* 0x613c */
    KANJI,        /* 0x613d */
    KANJI,        /* 0x613e */
    KANJI,        /* 0x613f */
    KANJI,        /* 0x6140 */
    KANJI,        /* 0x6141 */
    KANJI,        /* 0x6142 */
    KANJI,        /* 0x6143 */
    KANJI,        /* 0x6144 */
    KANJI,        /* 0x6145 */
    KANJI,        /* 0x6146 */
    KANJI,        /* 0x6147 */
    KANJI,        /* 0x6148 */
    KANJI,        /* 0x6149 */
    KANJI,        /* 0x614a */
    KANJI,        /* 0x614b */
    KANJI,        /* 0x614c */
    KANJI,        /* 0x614d */
    KANJI,        /* 0x614e */
    KANJI,        /* 0x614f */
    KANJI,        /* 0x6150 */
    KANJI,        /* 0x6151 */
    KANJI,        /* 0x6152 */
    KANJI,        /* 0x6153 */
    KANJI,        /* 0x6154 */
    KANJI,        /* 0x6155 */
    KANJI,        /* 0x6156 */
    KANJI,        /* 0x6157 */
    KANJI,        /* 0x6158 */
    KANJI,        /* 0x6159 */
    KANJI,        /* 0x615a */
    KANJI,        /* 0x615b */
    KANJI,        /* 0x615c */
    KANJI,        /* 0x615d */
    KANJI,        /* 0x615e */
    KANJI,        /* 0x615f */
    KANJI,        /* 0x6160 */
    KANJI,        /* 0x6161 */
    KANJI,        /* 0x6162 */
    KANJI,        /* 0x6163 */
    KANJI,        /* 0x6164 */
    KANJI,        /* 0x6165 */
    KANJI,        /* 0x6166 */
    KANJI,        /* 0x6167 */
    KANJI,        /* 0x6168 */
    KANJI,        /* 0x6169 */
    KANJI,        /* 0x616a */
    KANJI,        /* 0x616b */
    KANJI,        /* 0x616c */
    KANJI,        /* 0x616d */
    KANJI,        /* 0x616e */
    KANJI,        /* 0x616f */
    KANJI,        /* 0x6170 */
    KANJI,        /* 0x6171 */
    KANJI,        /* 0x6172 */
    KANJI,        /* 0x6173 */
    KANJI,        /* 0x6174 */
    KANJI,        /* 0x6175 */
    KANJI,        /* 0x6176 */
    KANJI,        /* 0x6177 */
    KANJI,        /* 0x6178 */
    KANJI,        /* 0x6179 */
    KANJI,        /* 0x617a */
    KANJI,        /* 0x617b */
    KANJI,        /* 0x617c */
    KANJI,        /* 0x617d */
    KANJI,        /* 0x617e */
    KANJI,        /* 0x617f */
    KANJI,        /* 0x6180 */
    KANJI,        /* 0x6181 */
    KANJI,        /* 0x6182 */
    KANJI,        /* 0x6183 */
    KANJI,        /* 0x6184 */
    KANJI,        /* 0x6185 */
    KANJI,        /* 0x6186 */
    KANJI,        /* 0x6187 */
    KANJI,        /* 0x6188 */
    KANJI,        /* 0x6189 */
    KANJI,        /* 0x618a */
    KANJI,        /* 0x618b */
    KANJI,        /* 0x618c */
    KANJI,        /* 0x618d */
    KANJI,        /* 0x618e */
    KANJI,        /* 0x618f */
    KANJI,        /* 0x6190 */
    KANJI,        /* 0x6191 */
    KANJI,        /* 0x6192 */
    KANJI,        /* 0x6193 */
    KANJI,        /* 0x6194 */
    KANJI,        /* 0x6195 */
    KANJI,        /* 0x6196 */
    KANJI,        /* 0x6197 */
    KANJI,        /* 0x6198 */
    KANJI,        /* 0x6199 */
    KANJI,        /* 0x619a */
    KANJI,        /* 0x619b */
    KANJI,        /* 0x619c */
    KANJI,        /* 0x619d */
    KANJI,        /* 0x619e */
    KANJI,        /* 0x619f */
    KANJI,        /* 0x61a0 */
    KANJI,        /* 0x61a1 */
    KANJI,        /* 0x61a2 */
    KANJI,        /* 0x61a3 */
    KANJI,        /* 0x61a4 */
    KANJI,        /* 0x61a5 */
    KANJI,        /* 0x61a6 */
    KANJI,        /* 0x61a7 */
    KANJI,        /* 0x61a8 */
    KANJI,        /* 0x61a9 */
    KANJI,        /* 0x61aa */
    KANJI,        /* 0x61ab */
    KANJI,        /* 0x61ac */
    KANJI,        /* 0x61ad */
    KANJI,        /* 0x61ae */
    KANJI,        /* 0x61af */
    KANJI,        /* 0x61b0 */
    KANJI,        /* 0x61b1 */
    KANJI,        /* 0x61b2 */
    KANJI,        /* 0x61b3 */
    KANJI,        /* 0x61b4 */
    KANJI,        /* 0x61b5 */
    KANJI,        /* 0x61b6 */
    KANJI,        /* 0x61b7 */
    KANJI,        /* 0x61b8 */
    KANJI,        /* 0x61b9 */
    KANJI,        /* 0x61ba */
    KANJI,        /* 0x61bb */
    KANJI,        /* 0x61bc */
    KANJI,        /* 0x61bd */
    KANJI,        /* 0x61be */
    KANJI,        /* 0x61bf */
    KANJI,        /* 0x61c0 */
    KANJI,        /* 0x61c1 */
    KANJI,        /* 0x61c2 */
    KANJI,        /* 0x61c3 */
    KANJI,        /* 0x61c4 */
    KANJI,        /* 0x61c5 */
    KANJI,        /* 0x61c6 */
    KANJI,        /* 0x61c7 */
    KANJI,        /* 0x61c8 */
    KANJI,        /* 0x61c9 */
    KANJI,        /* 0x61ca */
    KANJI,        /* 0x61cb */
    KANJI,        /* 0x61cc */
    KANJI,        /* 0x61cd */
    KANJI,        /* 0x61ce */
    KANJI,        /* 0x61cf */
    KANJI,        /* 0x61d0 */
    KANJI,        /* 0x61d1 */
    KANJI,        /* 0x61d2 */
    KANJI,        /* 0x61d3 */
    KANJI,        /* 0x61d4 */
    KANJI,        /* 0x61d5 */
    KANJI,        /* 0x61d6 */
    KANJI,        /* 0x61d7 */
    KANJI,        /* 0x61d8 */
    KANJI,        /* 0x61d9 */
    KANJI,        /* 0x61da */
    KANJI,        /* 0x61db */
    KANJI,        /* 0x61dc */
    KANJI,        /* 0x61dd */
    KANJI,        /* 0x61de */
    KANJI,        /* 0x61df */
    KANJI,        /* 0x61e0 */
    KANJI,        /* 0x61e1 */
    KANJI,        /* 0x61e2 */
    KANJI,        /* 0x61e3 */
    KANJI,        /* 0x61e4 */
    KANJI,        /* 0x61e5 */
    KANJI,        /* 0x61e6 */
    KANJI,        /* 0x61e7 */
    KANJI,        /* 0x61e8 */
    KANJI,        /* 0x61e9 */
    KANJI,        /* 0x61ea */
    KANJI,        /* 0x61eb */
    KANJI,        /* 0x61ec */
    KANJI,        /* 0x61ed */
    KANJI,        /* 0x61ee */
    KANJI,        /* 0x61ef */
    KANJI,        /* 0x61f0 */
    KANJI,        /* 0x61f1 */
    KANJI,        /* 0x61f2 */
    KANJI,        /* 0x61f3 */
    KANJI,        /* 0x61f4 */
    KANJI,        /* 0x61f5 */
    KANJI,        /* 0x61f6 */
    KANJI,        /* 0x61f7 */
    KANJI,        /* 0x61f8 */
    KANJI,        /* 0x61f9 */
    KANJI,        /* 0x61fa */
    KANJI,        /* 0x61fb */
    KANJI,        /* 0x61fc */
    KANJI,        /* 0x61fd */
    KANJI,        /* 0x61fe */
    KANJI,        /* 0x61ff */
    KANJI,        /* 0x6200 */
    KANJI,        /* 0x6201 */
    KANJI,        /* 0x6202 */
    KANJI,        /* 0x6203 */
    KANJI,        /* 0x6204 */
    KANJI,        /* 0x6205 */
    KANJI,        /* 0x6206 */
    KANJI,        /* 0x6207 */
    KANJI,        /* 0x6208 */
    KANJI,        /* 0x6209 */
    KANJI,        /* 0x620a */
    KANJI,        /* 0x620b */
    KANJI,        /* 0x620c */
    KANJI,        /* 0x620d */
    KANJI,        /* 0x620e */
    KANJI,        /* 0x620f */
    KANJI,        /* 0x6210 */
    KANJI,        /* 0x6211 */
    KANJI,        /* 0x6212 */
    KANJI,        /* 0x6213 */
    KANJI,        /* 0x6214 */
    KANJI,        /* 0x6215 */
    KANJI,        /* 0x6216 */
    KANJI,        /* 0x6217 */
    KANJI,        /* 0x6218 */
    KANJI,        /* 0x6219 */
    KANJI,        /* 0x621a */
    KANJI,        /* 0x621b */
    KANJI,        /* 0x621c */
    KANJI,        /* 0x621d */
    KANJI,        /* 0x621e */
    KANJI,        /* 0x621f */
    KANJI,        /* 0x6220 */
    KANJI,        /* 0x6221 */
    KANJI,        /* 0x6222 */
    KANJI,        /* 0x6223 */
    KANJI,        /* 0x6224 */
    KANJI,        /* 0x6225 */
    KANJI,        /* 0x6226 */
    KANJI,        /* 0x6227 */
    KANJI,        /* 0x6228 */
    KANJI,        /* 0x6229 */
    KANJI,        /* 0x622a */
    KANJI,        /* 0x622b */
    KANJI,        /* 0x622c */
    KANJI,        /* 0x622d */
    KANJI,        /* 0x622e */
    KANJI,        /* 0x622f */
    KANJI,        /* 0x6230 */
    KANJI,        /* 0x6231 */
    KANJI,        /* 0x6232 */
    KANJI,        /* 0x6233 */
    KANJI,        /* 0x6234 */
    KANJI,        /* 0x6235 */
    KANJI,        /* 0x6236 */
    KANJI,        /* 0x6237 */
    KANJI,        /* 0x6238 */
    KANJI,        /* 0x6239 */
    KANJI,        /* 0x623a */
    KANJI,        /* 0x623b */
    KANJI,        /* 0x623c */
    KANJI,        /* 0x623d */
    KANJI,        /* 0x623e */
    KANJI,        /* 0x623f */
    KANJI,        /* 0x6240 */
    KANJI,        /* 0x6241 */
    KANJI,        /* 0x6242 */
    KANJI,        /* 0x6243 */
    KANJI,        /* 0x6244 */
    KANJI,        /* 0x6245 */
    KANJI,        /* 0x6246 */
    KANJI,        /* 0x6247 */
    KANJI,        /* 0x6248 */
    KANJI,        /* 0x6249 */
    KANJI,        /* 0x624a */
    KANJI,        /* 0x624b */
    KANJI,        /* 0x624c */
    KANJI,        /* 0x624d */
    KANJI,        /* 0x624e */
    KANJI,        /* 0x624f */
    KANJI,        /* 0x6250 */
    KANJI,        /* 0x6251 */
    KANJI,        /* 0x6252 */
    KANJI,        /* 0x6253 */
    KANJI,        /* 0x6254 */
    KANJI,        /* 0x6255 */
    KANJI,        /* 0x6256 */
    KANJI,        /* 0x6257 */
    KANJI,        /* 0x6258 */
    KANJI,        /* 0x6259 */
    KANJI,        /* 0x625a */
    KANJI,        /* 0x625b */
    KANJI,        /* 0x625c */
    KANJI,        /* 0x625d */
    KANJI,        /* 0x625e */
    KANJI,        /* 0x625f */
    KANJI,        /* 0x6260 */
    KANJI,        /* 0x6261 */
    KANJI,        /* 0x6262 */
    KANJI,        /* 0x6263 */
    KANJI,        /* 0x6264 */
    KANJI,        /* 0x6265 */
    KANJI,        /* 0x6266 */
    KANJI,        /* 0x6267 */
    KANJI,        /* 0x6268 */
    KANJI,        /* 0x6269 */
    KANJI,        /* 0x626a */
    KANJI,        /* 0x626b */
    KANJI,        /* 0x626c */
    KANJI,        /* 0x626d */
    KANJI,        /* 0x626e */
    KANJI,        /* 0x626f */
    KANJI,        /* 0x6270 */
    KANJI,        /* 0x6271 */
    KANJI,        /* 0x6272 */
    KANJI,        /* 0x6273 */
    KANJI,        /* 0x6274 */
    KANJI,        /* 0x6275 */
    KANJI,        /* 0x6276 */
    KANJI,        /* 0x6277 */
    KANJI,        /* 0x6278 */
    KANJI,        /* 0x6279 */
    KANJI,        /* 0x627a */
    KANJI,        /* 0x627b */
    KANJI,        /* 0x627c */
    KANJI,        /* 0x627d */
    KANJI,        /* 0x627e */
    KANJI,        /* 0x627f */
    KANJI,        /* 0x6280 */
    KANJI,        /* 0x6281 */
    KANJI,        /* 0x6282 */
    KANJI,        /* 0x6283 */
    KANJI,        /* 0x6284 */
    KANJI,        /* 0x6285 */
    KANJI,        /* 0x6286 */
    KANJI,        /* 0x6287 */
    KANJI,        /* 0x6288 */
    KANJI,        /* 0x6289 */
    KANJI,        /* 0x628a */
    KANJI,        /* 0x628b */
    KANJI,        /* 0x628c */
    KANJI,        /* 0x628d */
    KANJI,        /* 0x628e */
    KANJI,        /* 0x628f */
    KANJI,        /* 0x6290 */
    KANJI,        /* 0x6291 */
    KANJI,        /* 0x6292 */
    KANJI,        /* 0x6293 */
    KANJI,        /* 0x6294 */
    KANJI,        /* 0x6295 */
    KANJI,        /* 0x6296 */
    KANJI,        /* 0x6297 */
    KANJI,        /* 0x6298 */
    KANJI,        /* 0x6299 */
    KANJI,        /* 0x629a */
    KANJI,        /* 0x629b */
    KANJI,        /* 0x629c */
    KANJI,        /* 0x629d */
    KANJI,        /* 0x629e */
    KANJI,        /* 0x629f */
    KANJI,        /* 0x62a0 */
    KANJI,        /* 0x62a1 */
    KANJI,        /* 0x62a2 */
    KANJI,        /* 0x62a3 */
    KANJI,        /* 0x62a4 */
    KANJI,        /* 0x62a5 */
    KANJI,        /* 0x62a6 */
    KANJI,        /* 0x62a7 */
    KANJI,        /* 0x62a8 */
    KANJI,        /* 0x62a9 */
    KANJI,        /* 0x62aa */
    KANJI,        /* 0x62ab */
    KANJI,        /* 0x62ac */
    KANJI,        /* 0x62ad */
    KANJI,        /* 0x62ae */
    KANJI,        /* 0x62af */
    KANJI,        /* 0x62b0 */
    KANJI,        /* 0x62b1 */
    KANJI,        /* 0x62b2 */
    KANJI,        /* 0x62b3 */
    KANJI,        /* 0x62b4 */
    KANJI,        /* 0x62b5 */
    KANJI,        /* 0x62b6 */
    KANJI,        /* 0x62b7 */
    KANJI,        /* 0x62b8 */
    KANJI,        /* 0x62b9 */
    KANJI,        /* 0x62ba */
    KANJI,        /* 0x62bb */
    KANJI,        /* 0x62bc */
    KANJI,        /* 0x62bd */
    KANJI,        /* 0x62be */
    KANJI,        /* 0x62bf */
    KANJI,        /* 0x62c0 */
    KANJI,        /* 0x62c1 */
    KANJI,        /* 0x62c2 */
    KANJI,        /* 0x62c3 */
    KANJI,        /* 0x62c4 */
    KANJI,        /* 0x62c5 */
    KANJI,        /* 0x62c6 */
    KANJI,        /* 0x62c7 */
    KANJI,        /* 0x62c8 */
    KANJI,        /* 0x62c9 */
    KANJI,        /* 0x62ca */
    KANJI,        /* 0x62cb */
    KANJI,        /* 0x62cc */
    KANJI,        /* 0x62cd */
    KANJI,        /* 0x62ce */
    KANJI,        /* 0x62cf */
    KANJI,        /* 0x62d0 */
    KANJI,        /* 0x62d1 */
    KANJI,        /* 0x62d2 */
    KANJI,        /* 0x62d3 */
    KANJI,        /* 0x62d4 */
    KANJI,        /* 0x62d5 */
    KANJI,        /* 0x62d6 */
    KANJI,        /* 0x62d7 */
    KANJI,        /* 0x62d8 */
    KANJI,        /* 0x62d9 */
    KANJI,        /* 0x62da */
    KANJI,        /* 0x62db */
    KANJI,        /* 0x62dc */
    KANJI,        /* 0x62dd */
    KANJI,        /* 0x62de */
    KANJI,        /* 0x62df */
    KANJI,        /* 0x62e0 */
    KANJI,        /* 0x62e1 */
    KANJI,        /* 0x62e2 */
    KANJI,        /* 0x62e3 */
    KANJI,        /* 0x62e4 */
    KANJI,        /* 0x62e5 */
    KANJI,        /* 0x62e6 */
    KANJI,        /* 0x62e7 */
    KANJI,        /* 0x62e8 */
    KANJI,        /* 0x62e9 */
    KANJI,        /* 0x62ea */
    KANJI,        /* 0x62eb */
    KANJI,        /* 0x62ec */
    KANJI,        /* 0x62ed */
    KANJI,        /* 0x62ee */
    KANJI,        /* 0x62ef */
    KANJI,        /* 0x62f0 */
    KANJI,        /* 0x62f1 */
    KANJI,        /* 0x62f2 */
    KANJI,        /* 0x62f3 */
    KANJI,        /* 0x62f4 */
    KANJI,        /* 0x62f5 */
    KANJI,        /* 0x62f6 */
    KANJI,        /* 0x62f7 */
    KANJI,        /* 0x62f8 */
    KANJI,        /* 0x62f9 */
    KANJI,        /* 0x62fa */
    KANJI,        /* 0x62fb */
    KANJI,        /* 0x62fc */
    KANJI,        /* 0x62fd */
    KANJI,        /* 0x62fe */
    KANJI,        /* 0x62ff */
    KANJI,        /* 0x6300 */
    KANJI,        /* 0x6301 */
    KANJI,        /* 0x6302 */
    KANJI,        /* 0x6303 */
    KANJI,        /* 0x6304 */
    KANJI,        /* 0x6305 */
    KANJI,        /* 0x6306 */
    KANJI,        /* 0x6307 */
    KANJI,        /* 0x6308 */
    KANJI,        /* 0x6309 */
    KANJI,        /* 0x630a */
    KANJI,        /* 0x630b */
    KANJI,        /* 0x630c */
    KANJI,        /* 0x630d */
    KANJI,        /* 0x630e */
    KANJI,        /* 0x630f */
    KANJI,        /* 0x6310 */
    KANJI,        /* 0x6311 */
    KANJI,        /* 0x6312 */
    KANJI,        /* 0x6313 */
    KANJI,        /* 0x6314 */
    KANJI,        /* 0x6315 */
    KANJI,        /* 0x6316 */
    KANJI,        /* 0x6317 */
    KANJI,        /* 0x6318 */
    KANJI,        /* 0x6319 */
    KANJI,        /* 0x631a */
    KANJI,        /* 0x631b */
    KANJI,        /* 0x631c */
    KANJI,        /* 0x631d */
    KANJI,        /* 0x631e */
    KANJI,        /* 0x631f */
    KANJI,        /* 0x6320 */
    KANJI,        /* 0x6321 */
    KANJI,        /* 0x6322 */
    KANJI,        /* 0x6323 */
    KANJI,        /* 0x6324 */
    KANJI,        /* 0x6325 */
    KANJI,        /* 0x6326 */
    KANJI,        /* 0x6327 */
    KANJI,        /* 0x6328 */
    KANJI,        /* 0x6329 */
    KANJI,        /* 0x632a */
    KANJI,        /* 0x632b */
    KANJI,        /* 0x632c */
    KANJI,        /* 0x632d */
    KANJI,        /* 0x632e */
    KANJI,        /* 0x632f */
    KANJI,        /* 0x6330 */
    KANJI,        /* 0x6331 */
    KANJI,        /* 0x6332 */
    KANJI,        /* 0x6333 */
    KANJI,        /* 0x6334 */
    KANJI,        /* 0x6335 */
    KANJI,        /* 0x6336 */
    KANJI,        /* 0x6337 */
    KANJI,        /* 0x6338 */
    KANJI,        /* 0x6339 */
    KANJI,        /* 0x633a */
    KANJI,        /* 0x633b */
    KANJI,        /* 0x633c */
    KANJI,        /* 0x633d */
    KANJI,        /* 0x633e */
    KANJI,        /* 0x633f */
    KANJI,        /* 0x6340 */
    KANJI,        /* 0x6341 */
    KANJI,        /* 0x6342 */
    KANJI,        /* 0x6343 */
    KANJI,        /* 0x6344 */
    KANJI,        /* 0x6345 */
    KANJI,        /* 0x6346 */
    KANJI,        /* 0x6347 */
    KANJI,        /* 0x6348 */
    KANJI,        /* 0x6349 */
    KANJI,        /* 0x634a */
    KANJI,        /* 0x634b */
    KANJI,        /* 0x634c */
    KANJI,        /* 0x634d */
    KANJI,        /* 0x634e */
    KANJI,        /* 0x634f */
    KANJI,        /* 0x6350 */
    KANJI,        /* 0x6351 */
    KANJI,        /* 0x6352 */
    KANJI,        /* 0x6353 */
    KANJI,        /* 0x6354 */
    KANJI,        /* 0x6355 */
    KANJI,        /* 0x6356 */
    KANJI,        /* 0x6357 */
    KANJI,        /* 0x6358 */
    KANJI,        /* 0x6359 */
    KANJI,        /* 0x635a */
    KANJI,        /* 0x635b */
    KANJI,        /* 0x635c */
    KANJI,        /* 0x635d */
    KANJI,        /* 0x635e */
    KANJI,        /* 0x635f */
    KANJI,        /* 0x6360 */
    KANJI,        /* 0x6361 */
    KANJI,        /* 0x6362 */
    KANJI,        /* 0x6363 */
    KANJI,        /* 0x6364 */
    KANJI,        /* 0x6365 */
    KANJI,        /* 0x6366 */
    KANJI,        /* 0x6367 */
    KANJI,        /* 0x6368 */
    KANJI,        /* 0x6369 */
    KANJI,        /* 0x636a */
    KANJI,        /* 0x636b */
    KANJI,        /* 0x636c */
    KANJI,        /* 0x636d */
    KANJI,        /* 0x636e */
    KANJI,        /* 0x636f */
    KANJI,        /* 0x6370 */
    KANJI,        /* 0x6371 */
    KANJI,        /* 0x6372 */
    KANJI,        /* 0x6373 */
    KANJI,        /* 0x6374 */
    KANJI,        /* 0x6375 */
    KANJI,        /* 0x6376 */
    KANJI,        /* 0x6377 */
    KANJI,        /* 0x6378 */
    KANJI,        /* 0x6379 */
    KANJI,        /* 0x637a */
    KANJI,        /* 0x637b */
    KANJI,        /* 0x637c */
    KANJI,        /* 0x637d */
    KANJI,        /* 0x637e */
    KANJI,        /* 0x637f */
    KANJI,        /* 0x6380 */
    KANJI,        /* 0x6381 */
    KANJI,        /* 0x6382 */
    KANJI,        /* 0x6383 */
    KANJI,        /* 0x6384 */
    KANJI,        /* 0x6385 */
    KANJI,        /* 0x6386 */
    KANJI,        /* 0x6387 */
    KANJI,        /* 0x6388 */
    KANJI,        /* 0x6389 */
    KANJI,        /* 0x638a */
    KANJI,        /* 0x638b */
    KANJI,        /* 0x638c */
    KANJI,        /* 0x638d */
    KANJI,        /* 0x638e */
    KANJI,        /* 0x638f */
    KANJI,        /* 0x6390 */
    KANJI,        /* 0x6391 */
    KANJI,        /* 0x6392 */
    KANJI,        /* 0x6393 */
    KANJI,        /* 0x6394 */
    KANJI,        /* 0x6395 */
    KANJI,        /* 0x6396 */
    KANJI,        /* 0x6397 */
    KANJI,        /* 0x6398 */
    KANJI,        /* 0x6399 */
    KANJI,        /* 0x639a */
    KANJI,        /* 0x639b */
    KANJI,        /* 0x639c */
    KANJI,        /* 0x639d */
    KANJI,        /* 0x639e */
    KANJI,        /* 0x639f */
    KANJI,        /* 0x63a0 */
    KANJI,        /* 0x63a1 */
    KANJI,        /* 0x63a2 */
    KANJI,        /* 0x63a3 */
    KANJI,        /* 0x63a4 */
    KANJI,        /* 0x63a5 */
    KANJI,        /* 0x63a6 */
    KANJI,        /* 0x63a7 */
    KANJI,        /* 0x63a8 */
    KANJI,        /* 0x63a9 */
    KANJI,        /* 0x63aa */
    KANJI,        /* 0x63ab */
    KANJI,        /* 0x63ac */
    KANJI,        /* 0x63ad */
    KANJI,        /* 0x63ae */
    KANJI,        /* 0x63af */
    KANJI,        /* 0x63b0 */
    KANJI,        /* 0x63b1 */
    KANJI,        /* 0x63b2 */
    KANJI,        /* 0x63b3 */
    KANJI,        /* 0x63b4 */
    KANJI,        /* 0x63b5 */
    KANJI,        /* 0x63b6 */
    KANJI,        /* 0x63b7 */
    KANJI,        /* 0x63b8 */
    KANJI,        /* 0x63b9 */
    KANJI,        /* 0x63ba */
    KANJI,        /* 0x63bb */
    KANJI,        /* 0x63bc */
    KANJI,        /* 0x63bd */
    KANJI,        /* 0x63be */
    KANJI,        /* 0x63bf */
    KANJI,        /* 0x63c0 */
    KANJI,        /* 0x63c1 */
    KANJI,        /* 0x63c2 */
    KANJI,        /* 0x63c3 */
    KANJI,        /* 0x63c4 */
    KANJI,        /* 0x63c5 */
    KANJI,        /* 0x63c6 */
    KANJI,        /* 0x63c7 */
    KANJI,        /* 0x63c8 */
    KANJI,        /* 0x63c9 */
    KANJI,        /* 0x63ca */
    KANJI,        /* 0x63cb */
    KANJI,        /* 0x63cc */
    KANJI,        /* 0x63cd */
    KANJI,        /* 0x63ce */
    KANJI,        /* 0x63cf */
    KANJI,        /* 0x63d0 */
    KANJI,        /* 0x63d1 */
    KANJI,        /* 0x63d2 */
    KANJI,        /* 0x63d3 */
    KANJI,        /* 0x63d4 */
    KANJI,        /* 0x63d5 */
    KANJI,        /* 0x63d6 */
    KANJI,        /* 0x63d7 */
    KANJI,        /* 0x63d8 */
    KANJI,        /* 0x63d9 */
    KANJI,        /* 0x63da */
    KANJI,        /* 0x63db */
    KANJI,        /* 0x63dc */
    KANJI,        /* 0x63dd */
    KANJI,        /* 0x63de */
    KANJI,        /* 0x63df */
    KANJI,        /* 0x63e0 */
    KANJI,        /* 0x63e1 */
    KANJI,        /* 0x63e2 */
    KANJI,        /* 0x63e3 */
    KANJI,        /* 0x63e4 */
    KANJI,        /* 0x63e5 */
    KANJI,        /* 0x63e6 */
    KANJI,        /* 0x63e7 */
    KANJI,        /* 0x63e8 */
    KANJI,        /* 0x63e9 */
    KANJI,        /* 0x63ea */
    KANJI,        /* 0x63eb */
    KANJI,        /* 0x63ec */
    KANJI,        /* 0x63ed */
    KANJI,        /* 0x63ee */
    KANJI,        /* 0x63ef */
    KANJI,        /* 0x63f0 */
    KANJI,        /* 0x63f1 */
    KANJI,        /* 0x63f2 */
    KANJI,        /* 0x63f3 */
    KANJI,        /* 0x63f4 */
    KANJI,        /* 0x63f5 */
    KANJI,        /* 0x63f6 */
    KANJI,        /* 0x63f7 */
    KANJI,        /* 0x63f8 */
    KANJI,        /* 0x63f9 */
    KANJI,        /* 0x63fa */
    KANJI,        /* 0x63fb */
    KANJI,        /* 0x63fc */
    KANJI,        /* 0x63fd */
    KANJI,        /* 0x63fe */
    KANJI,        /* 0x63ff */
    KANJI,        /* 0x6400 */
    KANJI,        /* 0x6401 */
    KANJI,        /* 0x6402 */
    KANJI,        /* 0x6403 */
    KANJI,        /* 0x6404 */
    KANJI,        /* 0x6405 */
    KANJI,        /* 0x6406 */
    KANJI,        /* 0x6407 */
    KANJI,        /* 0x6408 */
    KANJI,        /* 0x6409 */
    KANJI,        /* 0x640a */
    KANJI,        /* 0x640b */
    KANJI,        /* 0x640c */
    KANJI,        /* 0x640d */
    KANJI,        /* 0x640e */
    KANJI,        /* 0x640f */
    KANJI,        /* 0x6410 */
    KANJI,        /* 0x6411 */
    KANJI,        /* 0x6412 */
    KANJI,        /* 0x6413 */
    KANJI,        /* 0x6414 */
    KANJI,        /* 0x6415 */
    KANJI,        /* 0x6416 */
    KANJI,        /* 0x6417 */
    KANJI,        /* 0x6418 */
    KANJI,        /* 0x6419 */
    KANJI,        /* 0x641a */
    KANJI,        /* 0x641b */
    KANJI,        /* 0x641c */
    KANJI,        /* 0x641d */
    KANJI,        /* 0x641e */
    KANJI,        /* 0x641f */
    KANJI,        /* 0x6420 */
    KANJI,        /* 0x6421 */
    KANJI,        /* 0x6422 */
    KANJI,        /* 0x6423 */
    KANJI,        /* 0x6424 */
    KANJI,        /* 0x6425 */
    KANJI,        /* 0x6426 */
    KANJI,        /* 0x6427 */
    KANJI,        /* 0x6428 */
    KANJI,        /* 0x6429 */
    KANJI,        /* 0x642a */
    KANJI,        /* 0x642b */
    KANJI,        /* 0x642c */
    KANJI,        /* 0x642d */
    KANJI,        /* 0x642e */
    KANJI,        /* 0x642f */
    KANJI,        /* 0x6430 */
    KANJI,        /* 0x6431 */
    KANJI,        /* 0x6432 */
    KANJI,        /* 0x6433 */
    KANJI,        /* 0x6434 */
    KANJI,        /* 0x6435 */
    KANJI,        /* 0x6436 */
    KANJI,        /* 0x6437 */
    KANJI,        /* 0x6438 */
    KANJI,        /* 0x6439 */
    KANJI,        /* 0x643a */
    KANJI,        /* 0x643b */
    KANJI,        /* 0x643c */
    KANJI,        /* 0x643d */
    KANJI,        /* 0x643e */
    KANJI,        /* 0x643f */
    KANJI,        /* 0x6440 */
    KANJI,        /* 0x6441 */
    KANJI,        /* 0x6442 */
    KANJI,        /* 0x6443 */
    KANJI,        /* 0x6444 */
    KANJI,        /* 0x6445 */
    KANJI,        /* 0x6446 */
    KANJI,        /* 0x6447 */
    KANJI,        /* 0x6448 */
    KANJI,        /* 0x6449 */
    KANJI,        /* 0x644a */
    KANJI,        /* 0x644b */
    KANJI,        /* 0x644c */
    KANJI,        /* 0x644d */
    KANJI,        /* 0x644e */
    KANJI,        /* 0x644f */
    KANJI,        /* 0x6450 */
    KANJI,        /* 0x6451 */
    KANJI,        /* 0x6452 */
    KANJI,        /* 0x6453 */
    KANJI,        /* 0x6454 */
    KANJI,        /* 0x6455 */
    KANJI,        /* 0x6456 */
    KANJI,        /* 0x6457 */
    KANJI,        /* 0x6458 */
    KANJI,        /* 0x6459 */
    KANJI,        /* 0x645a */
    KANJI,        /* 0x645b */
    KANJI,        /* 0x645c */
    KANJI,        /* 0x645d */
    KANJI,        /* 0x645e */
    KANJI,        /* 0x645f */
    KANJI,        /* 0x6460 */
    KANJI,        /* 0x6461 */
    KANJI,        /* 0x6462 */
    KANJI,        /* 0x6463 */
    KANJI,        /* 0x6464 */
    KANJI,        /* 0x6465 */
    KANJI,        /* 0x6466 */
    KANJI,        /* 0x6467 */
    KANJI,        /* 0x6468 */
    KANJI,        /* 0x6469 */
    KANJI,        /* 0x646a */
    KANJI,        /* 0x646b */
    KANJI,        /* 0x646c */
    KANJI,        /* 0x646d */
    KANJI,        /* 0x646e */
    KANJI,        /* 0x646f */
    KANJI,        /* 0x6470 */
    KANJI,        /* 0x6471 */
    KANJI,        /* 0x6472 */
    KANJI,        /* 0x6473 */
    KANJI,        /* 0x6474 */
    KANJI,        /* 0x6475 */
    KANJI,        /* 0x6476 */
    KANJI,        /* 0x6477 */
    KANJI,        /* 0x6478 */
    KANJI,        /* 0x6479 */
    KANJI,        /* 0x647a */
    KANJI,        /* 0x647b */
    KANJI,        /* 0x647c */
    KANJI,        /* 0x647d */
    KANJI,        /* 0x647e */
    KANJI,        /* 0x647f */
    KANJI,        /* 0x6480 */
    KANJI,        /* 0x6481 */
    KANJI,        /* 0x6482 */
    KANJI,        /* 0x6483 */
    KANJI,        /* 0x6484 */
    KANJI,        /* 0x6485 */
    KANJI,        /* 0x6486 */
    KANJI,        /* 0x6487 */
    KANJI,        /* 0x6488 */
    KANJI,        /* 0x6489 */
    KANJI,        /* 0x648a */
    KANJI,        /* 0x648b */
    KANJI,        /* 0x648c */
    KANJI,        /* 0x648d */
    KANJI,        /* 0x648e */
    KANJI,        /* 0x648f */
    KANJI,        /* 0x6490 */
    KANJI,        /* 0x6491 */
    KANJI,        /* 0x6492 */
    KANJI,        /* 0x6493 */
    KANJI,        /* 0x6494 */
    KANJI,        /* 0x6495 */
    KANJI,        /* 0x6496 */
    KANJI,        /* 0x6497 */
    KANJI,        /* 0x6498 */
    KANJI,        /* 0x6499 */
    KANJI,        /* 0x649a */
    KANJI,        /* 0x649b */
    KANJI,        /* 0x649c */
    KANJI,        /* 0x649d */
    KANJI,        /* 0x649e */
    KANJI,        /* 0x649f */
    KANJI,        /* 0x64a0 */
    KANJI,        /* 0x64a1 */
    KANJI,        /* 0x64a2 */
    KANJI,        /* 0x64a3 */
    KANJI,        /* 0x64a4 */
    KANJI,        /* 0x64a5 */
    KANJI,        /* 0x64a6 */
    KANJI,        /* 0x64a7 */
    KANJI,        /* 0x64a8 */
    KANJI,        /* 0x64a9 */
    KANJI,        /* 0x64aa */
    KANJI,        /* 0x64ab */
    KANJI,        /* 0x64ac */
    KANJI,        /* 0x64ad */
    KANJI,        /* 0x64ae */
    KANJI,        /* 0x64af */
    KANJI,        /* 0x64b0 */
    KANJI,        /* 0x64b1 */
    KANJI,        /* 0x64b2 */
    KANJI,        /* 0x64b3 */
    KANJI,        /* 0x64b4 */
    KANJI,        /* 0x64b5 */
    KANJI,        /* 0x64b6 */
    KANJI,        /* 0x64b7 */
    KANJI,        /* 0x64b8 */
    KANJI,        /* 0x64b9 */
    KANJI,        /* 0x64ba */
    KANJI,        /* 0x64bb */
    KANJI,        /* 0x64bc */
    KANJI,        /* 0x64bd */
    KANJI,        /* 0x64be */
    KANJI,        /* 0x64bf */
    KANJI,        /* 0x64c0 */
    KANJI,        /* 0x64c1 */
    KANJI,        /* 0x64c2 */
    KANJI,        /* 0x64c3 */
    KANJI,        /* 0x64c4 */
    KANJI,        /* 0x64c5 */
    KANJI,        /* 0x64c6 */
    KANJI,        /* 0x64c7 */
    KANJI,        /* 0x64c8 */
    KANJI,        /* 0x64c9 */
    KANJI,        /* 0x64ca */
    KANJI,        /* 0x64cb */
    KANJI,        /* 0x64cc */
    KANJI,        /* 0x64cd */
    KANJI,        /* 0x64ce */
    KANJI,        /* 0x64cf */
    KANJI,        /* 0x64d0 */
    KANJI,        /* 0x64d1 */
    KANJI,        /* 0x64d2 */
    KANJI,        /* 0x64d3 */
    KANJI,        /* 0x64d4 */
    KANJI,        /* 0x64d5 */
    KANJI,        /* 0x64d6 */
    KANJI,        /* 0x64d7 */
    KANJI,        /* 0x64d8 */
    KANJI,        /* 0x64d9 */
    KANJI,        /* 0x64da */
    KANJI,        /* 0x64db */
    KANJI,        /* 0x64dc */
    KANJI,        /* 0x64dd */
    KANJI,        /* 0x64de */
    KANJI,        /* 0x64df */
    KANJI,        /* 0x64e0 */
    KANJI,        /* 0x64e1 */
    KANJI,        /* 0x64e2 */
    KANJI,        /* 0x64e3 */
    KANJI,        /* 0x64e4 */
    KANJI,        /* 0x64e5 */
    KANJI,        /* 0x64e6 */
    KANJI,        /* 0x64e7 */
    KANJI,        /* 0x64e8 */
    KANJI,        /* 0x64e9 */
    KANJI,        /* 0x64ea */
    KANJI,        /* 0x64eb */
    KANJI,        /* 0x64ec */
    KANJI,        /* 0x64ed */
    KANJI,        /* 0x64ee */
    KANJI,        /* 0x64ef */
    KANJI,        /* 0x64f0 */
    KANJI,        /* 0x64f1 */
    KANJI,        /* 0x64f2 */
    KANJI,        /* 0x64f3 */
    KANJI,        /* 0x64f4 */
    KANJI,        /* 0x64f5 */
    KANJI,        /* 0x64f6 */
    KANJI,        /* 0x64f7 */
    KANJI,        /* 0x64f8 */
    KANJI,        /* 0x64f9 */
    KANJI,        /* 0x64fa */
    KANJI,        /* 0x64fb */
    KANJI,        /* 0x64fc */
    KANJI,        /* 0x64fd */
    KANJI,        /* 0x64fe */
    KANJI,        /* 0x64ff */
    KANJI,        /* 0x6500 */
    KANJI,        /* 0x6501 */
    KANJI,        /* 0x6502 */
    KANJI,        /* 0x6503 */
    KANJI,        /* 0x6504 */
    KANJI,        /* 0x6505 */
    KANJI,        /* 0x6506 */
    KANJI,        /* 0x6507 */
    KANJI,        /* 0x6508 */
    KANJI,        /* 0x6509 */
    KANJI,        /* 0x650a */
    KANJI,        /* 0x650b */
    KANJI,        /* 0x650c */
    KANJI,        /* 0x650d */
    KANJI,        /* 0x650e */
    KANJI,        /* 0x650f */
    KANJI,        /* 0x6510 */
    KANJI,        /* 0x6511 */
    KANJI,        /* 0x6512 */
    KANJI,        /* 0x6513 */
    KANJI,        /* 0x6514 */
    KANJI,        /* 0x6515 */
    KANJI,        /* 0x6516 */
    KANJI,        /* 0x6517 */
    KANJI,        /* 0x6518 */
    KANJI,        /* 0x6519 */
    KANJI,        /* 0x651a */
    KANJI,        /* 0x651b */
    KANJI,        /* 0x651c */
    KANJI,        /* 0x651d */
    KANJI,        /* 0x651e */
    KANJI,        /* 0x651f */
    KANJI,        /* 0x6520 */
    KANJI,        /* 0x6521 */
    KANJI,        /* 0x6522 */
    KANJI,        /* 0x6523 */
    KANJI,        /* 0x6524 */
    KANJI,        /* 0x6525 */
    KANJI,        /* 0x6526 */
    KANJI,        /* 0x6527 */
    KANJI,        /* 0x6528 */
    KANJI,        /* 0x6529 */
    KANJI,        /* 0x652a */
    KANJI,        /* 0x652b */
    KANJI,        /* 0x652c */
    KANJI,        /* 0x652d */
    KANJI,        /* 0x652e */
    KANJI,        /* 0x652f */
    KANJI,        /* 0x6530 */
    KANJI,        /* 0x6531 */
    KANJI,        /* 0x6532 */
    KANJI,        /* 0x6533 */
    KANJI,        /* 0x6534 */
    KANJI,        /* 0x6535 */
    KANJI,        /* 0x6536 */
    KANJI,        /* 0x6537 */
    KANJI,        /* 0x6538 */
    KANJI,        /* 0x6539 */
    KANJI,        /* 0x653a */
    KANJI,        /* 0x653b */
    KANJI,        /* 0x653c */
    KANJI,        /* 0x653d */
    KANJI,        /* 0x653e */
    KANJI,        /* 0x653f */
    KANJI,        /* 0x6540 */
    KANJI,        /* 0x6541 */
    KANJI,        /* 0x6542 */
    KANJI,        /* 0x6543 */
    KANJI,        /* 0x6544 */
    KANJI,        /* 0x6545 */
    KANJI,        /* 0x6546 */
    KANJI,        /* 0x6547 */
    KANJI,        /* 0x6548 */
    KANJI,        /* 0x6549 */
    KANJI,        /* 0x654a */
    KANJI,        /* 0x654b */
    KANJI,        /* 0x654c */
    KANJI,        /* 0x654d */
    KANJI,        /* 0x654e */
    KANJI,        /* 0x654f */
    KANJI,        /* 0x6550 */
    KANJI,        /* 0x6551 */
    KANJI,        /* 0x6552 */
    KANJI,        /* 0x6553 */
    KANJI,        /* 0x6554 */
    KANJI,        /* 0x6555 */
    KANJI,        /* 0x6556 */
    KANJI,        /* 0x6557 */
    KANJI,        /* 0x6558 */
    KANJI,        /* 0x6559 */
    KANJI,        /* 0x655a */
    KANJI,        /* 0x655b */
    KANJI,        /* 0x655c */
    KANJI,        /* 0x655d */
    KANJI,        /* 0x655e */
    KANJI,        /* 0x655f */
    KANJI,        /* 0x6560 */
    KANJI,        /* 0x6561 */
    KANJI,        /* 0x6562 */
    KANJI,        /* 0x6563 */
    KANJI,        /* 0x6564 */
    KANJI,        /* 0x6565 */
    KANJI,        /* 0x6566 */
    KANJI,        /* 0x6567 */
    KANJI,        /* 0x6568 */
    KANJI,        /* 0x6569 */
    KANJI,        /* 0x656a */
    KANJI,        /* 0x656b */
    KANJI,        /* 0x656c */
    KANJI,        /* 0x656d */
    KANJI,        /* 0x656e */
    KANJI,        /* 0x656f */
    KANJI,        /* 0x6570 */
    KANJI,        /* 0x6571 */
    KANJI,        /* 0x6572 */
    KANJI,        /* 0x6573 */
    KANJI,        /* 0x6574 */
    KANJI,        /* 0x6575 */
    KANJI,        /* 0x6576 */
    KANJI,        /* 0x6577 */
    KANJI,        /* 0x6578 */
    KANJI,        /* 0x6579 */
    KANJI,        /* 0x657a */
    KANJI,        /* 0x657b */
    KANJI,        /* 0x657c */
    KANJI,        /* 0x657d */
    KANJI,        /* 0x657e */
    KANJI,        /* 0x657f */
    KANJI,        /* 0x6580 */
    KANJI,        /* 0x6581 */
    KANJI,        /* 0x6582 */
    KANJI,        /* 0x6583 */
    KANJI,        /* 0x6584 */
    KANJI,        /* 0x6585 */
    KANJI,        /* 0x6586 */
    KANJI,        /* 0x6587 */
    KANJI,        /* 0x6588 */
    KANJI,        /* 0x6589 */
    KANJI,        /* 0x658a */
    KANJI,        /* 0x658b */
    KANJI,        /* 0x658c */
    KANJI,        /* 0x658d */
    KANJI,        /* 0x658e */
    KANJI,        /* 0x658f */
    KANJI,        /* 0x6590 */
    KANJI,        /* 0x6591 */
    KANJI,        /* 0x6592 */
    KANJI,        /* 0x6593 */
    KANJI,        /* 0x6594 */
    KANJI,        /* 0x6595 */
    KANJI,        /* 0x6596 */
    KANJI,        /* 0x6597 */
    KANJI,        /* 0x6598 */
    KANJI,        /* 0x6599 */
    KANJI,        /* 0x659a */
    KANJI,        /* 0x659b */
    KANJI,        /* 0x659c */
    KANJI,        /* 0x659d */
    KANJI,        /* 0x659e */
    KANJI,        /* 0x659f */
    KANJI,        /* 0x65a0 */
    KANJI,        /* 0x65a1 */
    KANJI,        /* 0x65a2 */
    KANJI,        /* 0x65a3 */
    KANJI,        /* 0x65a4 */
    KANJI,        /* 0x65a5 */
    KANJI,        /* 0x65a6 */
    KANJI,        /* 0x65a7 */
    KANJI,        /* 0x65a8 */
    KANJI,        /* 0x65a9 */
    KANJI,        /* 0x65aa */
    KANJI,        /* 0x65ab */
    KANJI,        /* 0x65ac */
    KANJI,        /* 0x65ad */
    KANJI,        /* 0x65ae */
    KANJI,        /* 0x65af */
    KANJI,        /* 0x65b0 */
    KANJI,        /* 0x65b1 */
    KANJI,        /* 0x65b2 */
    KANJI,        /* 0x65b3 */
    KANJI,        /* 0x65b4 */
    KANJI,        /* 0x65b5 */
    KANJI,        /* 0x65b6 */
    KANJI,        /* 0x65b7 */
    KANJI,        /* 0x65b8 */
    KANJI,        /* 0x65b9 */
    KANJI,        /* 0x65ba */
    KANJI,        /* 0x65bb */
    KANJI,        /* 0x65bc */
    KANJI,        /* 0x65bd */
    KANJI,        /* 0x65be */
    KANJI,        /* 0x65bf */
    KANJI,        /* 0x65c0 */
    KANJI,        /* 0x65c1 */
    KANJI,        /* 0x65c2 */
    KANJI,        /* 0x65c3 */
    KANJI,        /* 0x65c4 */
    KANJI,        /* 0x65c5 */
    KANJI,        /* 0x65c6 */
    KANJI,        /* 0x65c7 */
    KANJI,        /* 0x65c8 */
    KANJI,        /* 0x65c9 */
    KANJI,        /* 0x65ca */
    KANJI,        /* 0x65cb */
    KANJI,        /* 0x65cc */
    KANJI,        /* 0x65cd */
    KANJI,        /* 0x65ce */
    KANJI,        /* 0x65cf */
    KANJI,        /* 0x65d0 */
    KANJI,        /* 0x65d1 */
    KANJI,        /* 0x65d2 */
    KANJI,        /* 0x65d3 */
    KANJI,        /* 0x65d4 */
    KANJI,        /* 0x65d5 */
    KANJI,        /* 0x65d6 */
    KANJI,        /* 0x65d7 */
    KANJI,        /* 0x65d8 */
    KANJI,        /* 0x65d9 */
    KANJI,        /* 0x65da */
    KANJI,        /* 0x65db */
    KANJI,        /* 0x65dc */
    KANJI,        /* 0x65dd */
    KANJI,        /* 0x65de */
    KANJI,        /* 0x65df */
    KANJI,        /* 0x65e0 */
    KANJI,        /* 0x65e1 */
    KANJI,        /* 0x65e2 */
    KANJI,        /* 0x65e3 */
    KANJI,        /* 0x65e4 */
    KANJI,        /* 0x65e5 */
    KANJI,        /* 0x65e6 */
    KANJI,        /* 0x65e7 */
    KANJI,        /* 0x65e8 */
    KANJI,        /* 0x65e9 */
    KANJI,        /* 0x65ea */
    KANJI,        /* 0x65eb */
    KANJI,        /* 0x65ec */
    KANJI,        /* 0x65ed */
    KANJI,        /* 0x65ee */
    KANJI,        /* 0x65ef */
    KANJI,        /* 0x65f0 */
    KANJI,        /* 0x65f1 */
    KANJI,        /* 0x65f2 */
    KANJI,        /* 0x65f3 */
    KANJI,        /* 0x65f4 */
    KANJI,        /* 0x65f5 */
    KANJI,        /* 0x65f6 */
    KANJI,        /* 0x65f7 */
    KANJI,        /* 0x65f8 */
    KANJI,        /* 0x65f9 */
    KANJI,        /* 0x65fa */
    KANJI,        /* 0x65fb */
    KANJI,        /* 0x65fc */
    KANJI,        /* 0x65fd */
    KANJI,        /* 0x65fe */
    KANJI,        /* 0x65ff */
    KANJI,        /* 0x6600 */
    KANJI,        /* 0x6601 */
    KANJI,        /* 0x6602 */
    KANJI,        /* 0x6603 */
    KANJI,        /* 0x6604 */
    KANJI,        /* 0x6605 */
    KANJI,        /* 0x6606 */
    KANJI,        /* 0x6607 */
    KANJI,        /* 0x6608 */
    KANJI,        /* 0x6609 */
    KANJI,        /* 0x660a */
    KANJI,        /* 0x660b */
    KANJI,        /* 0x660c */
    KANJI,        /* 0x660d */
    KANJI,        /* 0x660e */
    KANJI,        /* 0x660f */
    KANJI,        /* 0x6610 */
    KANJI,        /* 0x6611 */
    KANJI,        /* 0x6612 */
    KANJI,        /* 0x6613 */
    KANJI,        /* 0x6614 */
    KANJI,        /* 0x6615 */
    KANJI,        /* 0x6616 */
    KANJI,        /* 0x6617 */
    KANJI,        /* 0x6618 */
    KANJI,        /* 0x6619 */
    KANJI,        /* 0x661a */
    KANJI,        /* 0x661b */
    KANJI,        /* 0x661c */
    KANJI,        /* 0x661d */
    KANJI,        /* 0x661e */
    KANJI,        /* 0x661f */
    KANJI,        /* 0x6620 */
    KANJI,        /* 0x6621 */
    KANJI,        /* 0x6622 */
    KANJI,        /* 0x6623 */
    KANJI,        /* 0x6624 */
    KANJI,        /* 0x6625 */
    KANJI,        /* 0x6626 */
    KANJI,        /* 0x6627 */
    KANJI,        /* 0x6628 */
    KANJI,        /* 0x6629 */
    KANJI,        /* 0x662a */
    KANJI,        /* 0x662b */
    KANJI,        /* 0x662c */
    KANJI,        /* 0x662d */
    KANJI,        /* 0x662e */
    KANJI,        /* 0x662f */
    KANJI,        /* 0x6630 */
    KANJI,        /* 0x6631 */
    KANJI,        /* 0x6632 */
    KANJI,        /* 0x6633 */
    KANJI,        /* 0x6634 */
    KANJI,        /* 0x6635 */
    KANJI,        /* 0x6636 */
    KANJI,        /* 0x6637 */
    KANJI,        /* 0x6638 */
    KANJI,        /* 0x6639 */
    KANJI,        /* 0x663a */
    KANJI,        /* 0x663b */
    KANJI,        /* 0x663c */
    KANJI,        /* 0x663d */
    KANJI,        /* 0x663e */
    KANJI,        /* 0x663f */
    KANJI,        /* 0x6640 */
    KANJI,        /* 0x6641 */
    KANJI,        /* 0x6642 */
    KANJI,        /* 0x6643 */
    KANJI,        /* 0x6644 */
    KANJI,        /* 0x6645 */
    KANJI,        /* 0x6646 */
    KANJI,        /* 0x6647 */
    KANJI,        /* 0x6648 */
    KANJI,        /* 0x6649 */
    KANJI,        /* 0x664a */
    KANJI,        /* 0x664b */
    KANJI,        /* 0x664c */
    KANJI,        /* 0x664d */
    KANJI,        /* 0x664e */
    KANJI,        /* 0x664f */
    KANJI,        /* 0x6650 */
    KANJI,        /* 0x6651 */
    KANJI,        /* 0x6652 */
    KANJI,        /* 0x6653 */
    KANJI,        /* 0x6654 */
    KANJI,        /* 0x6655 */
    KANJI,        /* 0x6656 */
    KANJI,        /* 0x6657 */
    KANJI,        /* 0x6658 */
    KANJI,        /* 0x6659 */
    KANJI,        /* 0x665a */
    KANJI,        /* 0x665b */
    KANJI,        /* 0x665c */
    KANJI,        /* 0x665d */
    KANJI,        /* 0x665e */
    KANJI,        /* 0x665f */
    KANJI,        /* 0x6660 */
    KANJI,        /* 0x6661 */
    KANJI,        /* 0x6662 */
    KANJI,        /* 0x6663 */
    KANJI,        /* 0x6664 */
    KANJI,        /* 0x6665 */
    KANJI,        /* 0x6666 */
    KANJI,        /* 0x6667 */
    KANJI,        /* 0x6668 */
    KANJI,        /* 0x6669 */
    KANJI,        /* 0x666a */
    KANJI,        /* 0x666b */
    KANJI,        /* 0x666c */
    KANJI,        /* 0x666d */
    KANJI,        /* 0x666e */
    KANJI,        /* 0x666f */
    KANJI,        /* 0x6670 */
    KANJI,        /* 0x6671 */
    KANJI,        /* 0x6672 */
    KANJI,        /* 0x6673 */
    KANJI,        /* 0x6674 */
    KANJI,        /* 0x6675 */
    KANJI,        /* 0x6676 */
    KANJI,        /* 0x6677 */
    KANJI,        /* 0x6678 */
    KANJI,        /* 0x6679 */
    KANJI,        /* 0x667a */
    KANJI,        /* 0x667b */
    KANJI,        /* 0x667c */
    KANJI,        /* 0x667d */
    KANJI,        /* 0x667e */
    KANJI,        /* 0x667f */
    KANJI,        /* 0x6680 */
    KANJI,        /* 0x6681 */
    KANJI,        /* 0x6682 */
    KANJI,        /* 0x6683 */
    KANJI,        /* 0x6684 */
    KANJI,        /* 0x6685 */
    KANJI,        /* 0x6686 */
    KANJI,        /* 0x6687 */
    KANJI,        /* 0x6688 */
    KANJI,        /* 0x6689 */
    KANJI,        /* 0x668a */
    KANJI,        /* 0x668b */
    KANJI,        /* 0x668c */
    KANJI,        /* 0x668d */
    KANJI,        /* 0x668e */
    KANJI,        /* 0x668f */
    KANJI,        /* 0x6690 */
    KANJI,        /* 0x6691 */
    KANJI,        /* 0x6692 */
    KANJI,        /* 0x6693 */
    KANJI,        /* 0x6694 */
    KANJI,        /* 0x6695 */
    KANJI,        /* 0x6696 */
    KANJI,        /* 0x6697 */
    KANJI,        /* 0x6698 */
    KANJI,        /* 0x6699 */
    KANJI,        /* 0x669a */
    KANJI,        /* 0x669b */
    KANJI,        /* 0x669c */
    KANJI,        /* 0x669d */
    KANJI,        /* 0x669e */
    KANJI,        /* 0x669f */
    KANJI,        /* 0x66a0 */
    KANJI,        /* 0x66a1 */
    KANJI,        /* 0x66a2 */
    KANJI,        /* 0x66a3 */
    KANJI,        /* 0x66a4 */
    KANJI,        /* 0x66a5 */
    KANJI,        /* 0x66a6 */
    KANJI,        /* 0x66a7 */
    KANJI,        /* 0x66a8 */
    KANJI,        /* 0x66a9 */
    KANJI,        /* 0x66aa */
    KANJI,        /* 0x66ab */
    KANJI,        /* 0x66ac */
    KANJI,        /* 0x66ad */
    KANJI,        /* 0x66ae */
    KANJI,        /* 0x66af */
    KANJI,        /* 0x66b0 */
    KANJI,        /* 0x66b1 */
    KANJI,        /* 0x66b2 */
    KANJI,        /* 0x66b3 */
    KANJI,        /* 0x66b4 */
    KANJI,        /* 0x66b5 */
    KANJI,        /* 0x66b6 */
    KANJI,        /* 0x66b7 */
    KANJI,        /* 0x66b8 */
    KANJI,        /* 0x66b9 */
    KANJI,        /* 0x66ba */
    KANJI,        /* 0x66bb */
    KANJI,        /* 0x66bc */
    KANJI,        /* 0x66bd */
    KANJI,        /* 0x66be */
    KANJI,        /* 0x66bf */
    KANJI,        /* 0x66c0 */
    KANJI,        /* 0x66c1 */
    KANJI,        /* 0x66c2 */
    KANJI,        /* 0x66c3 */
    KANJI,        /* 0x66c4 */
    KANJI,        /* 0x66c5 */
    KANJI,        /* 0x66c6 */
    KANJI,        /* 0x66c7 */
    KANJI,        /* 0x66c8 */
    KANJI,        /* 0x66c9 */
    KANJI,        /* 0x66ca */
    KANJI,        /* 0x66cb */
    KANJI,        /* 0x66cc */
    KANJI,        /* 0x66cd */
    KANJI,        /* 0x66ce */
    KANJI,        /* 0x66cf */
    KANJI,        /* 0x66d0 */
    KANJI,        /* 0x66d1 */
    KANJI,        /* 0x66d2 */
    KANJI,        /* 0x66d3 */
    KANJI,        /* 0x66d4 */
    KANJI,        /* 0x66d5 */
    KANJI,        /* 0x66d6 */
    KANJI,        /* 0x66d7 */
    KANJI,        /* 0x66d8 */
    KANJI,        /* 0x66d9 */
    KANJI,        /* 0x66da */
    KANJI,        /* 0x66db */
    KANJI,        /* 0x66dc */
    KANJI,        /* 0x66dd */
    KANJI,        /* 0x66de */
    KANJI,        /* 0x66df */
    KANJI,        /* 0x66e0 */
    KANJI,        /* 0x66e1 */
    KANJI,        /* 0x66e2 */
    KANJI,        /* 0x66e3 */
    KANJI,        /* 0x66e4 */
    KANJI,        /* 0x66e5 */
    KANJI,        /* 0x66e6 */
    KANJI,        /* 0x66e7 */
    KANJI,        /* 0x66e8 */
    KANJI,        /* 0x66e9 */
    KANJI,        /* 0x66ea */
    KANJI,        /* 0x66eb */
    KANJI,        /* 0x66ec */
    KANJI,        /* 0x66ed */
    KANJI,        /* 0x66ee */
    KANJI,        /* 0x66ef */
    KANJI,        /* 0x66f0 */
    KANJI,        /* 0x66f1 */
    KANJI,        /* 0x66f2 */
    KANJI,        /* 0x66f3 */
    KANJI,        /* 0x66f4 */
    KANJI,        /* 0x66f5 */
    KANJI,        /* 0x66f6 */
    KANJI,        /* 0x66f7 */
    KANJI,        /* 0x66f8 */
    KANJI,        /* 0x66f9 */
    KANJI,        /* 0x66fa */
    KANJI,        /* 0x66fb */
    KANJI,        /* 0x66fc */
    KANJI,        /* 0x66fd */
    KANJI,        /* 0x66fe */
    KANJI,        /* 0x66ff */
    KANJI,        /* 0x6700 */
    KANJI,        /* 0x6701 */
    KANJI,        /* 0x6702 */
    KANJI,        /* 0x6703 */
    KANJI,        /* 0x6704 */
    KANJI,        /* 0x6705 */
    KANJI,        /* 0x6706 */
    KANJI,        /* 0x6707 */
    KANJI,        /* 0x6708 */
    KANJI,        /* 0x6709 */
    KANJI,        /* 0x670a */
    KANJI,        /* 0x670b */
    KANJI,        /* 0x670c */
    KANJI,        /* 0x670d */
    KANJI,        /* 0x670e */
    KANJI,        /* 0x670f */
    KANJI,        /* 0x6710 */
    KANJI,        /* 0x6711 */
    KANJI,        /* 0x6712 */
    KANJI,        /* 0x6713 */
    KANJI,        /* 0x6714 */
    KANJI,        /* 0x6715 */
    KANJI,        /* 0x6716 */
    KANJI,        /* 0x6717 */
    KANJI,        /* 0x6718 */
    KANJI,        /* 0x6719 */
    KANJI,        /* 0x671a */
    KANJI,        /* 0x671b */
    KANJI,        /* 0x671c */
    KANJI,        /* 0x671d */
    KANJI,        /* 0x671e */
    KANJI,        /* 0x671f */
    KANJI,        /* 0x6720 */
    KANJI,        /* 0x6721 */
    KANJI,        /* 0x6722 */
    KANJI,        /* 0x6723 */
    KANJI,        /* 0x6724 */
    KANJI,        /* 0x6725 */
    KANJI,        /* 0x6726 */
    KANJI,        /* 0x6727 */
    KANJI,        /* 0x6728 */
    KANJI,        /* 0x6729 */
    KANJI,        /* 0x672a */
    KANJI,        /* 0x672b */
    KANJI,        /* 0x672c */
    KANJI,        /* 0x672d */
    KANJI,        /* 0x672e */
    KANJI,        /* 0x672f */
    KANJI,        /* 0x6730 */
    KANJI,        /* 0x6731 */
    KANJI,        /* 0x6732 */
    KANJI,        /* 0x6733 */
    KANJI,        /* 0x6734 */
    KANJI,        /* 0x6735 */
    KANJI,        /* 0x6736 */
    KANJI,        /* 0x6737 */
    KANJI,        /* 0x6738 */
    KANJI,        /* 0x6739 */
    KANJI,        /* 0x673a */
    KANJI,        /* 0x673b */
    KANJI,        /* 0x673c */
    KANJI,        /* 0x673d */
    KANJI,        /* 0x673e */
    KANJI,        /* 0x673f */
    KANJI,        /* 0x6740 */
    KANJI,        /* 0x6741 */
    KANJI,        /* 0x6742 */
    KANJI,        /* 0x6743 */
    KANJI,        /* 0x6744 */
    KANJI,        /* 0x6745 */
    KANJI,        /* 0x6746 */
    KANJI,        /* 0x6747 */
    KANJI,        /* 0x6748 */
    KANJI,        /* 0x6749 */
    KANJI,        /* 0x674a */
    KANJI,        /* 0x674b */
    KANJI,        /* 0x674c */
    KANJI,        /* 0x674d */
    KANJI,        /* 0x674e */
    KANJI,        /* 0x674f */
    KANJI,        /* 0x6750 */
    KANJI,        /* 0x6751 */
    KANJI,        /* 0x6752 */
    KANJI,        /* 0x6753 */
    KANJI,        /* 0x6754 */
    KANJI,        /* 0x6755 */
    KANJI,        /* 0x6756 */
    KANJI,        /* 0x6757 */
    KANJI,        /* 0x6758 */
    KANJI,        /* 0x6759 */
    KANJI,        /* 0x675a */
    KANJI,        /* 0x675b */
    KANJI,        /* 0x675c */
    KANJI,        /* 0x675d */
    KANJI,        /* 0x675e */
    KANJI,        /* 0x675f */
    KANJI,        /* 0x6760 */
    KANJI,        /* 0x6761 */
    KANJI,        /* 0x6762 */
    KANJI,        /* 0x6763 */
    KANJI,        /* 0x6764 */
    KANJI,        /* 0x6765 */
    KANJI,        /* 0x6766 */
    KANJI,        /* 0x6767 */
    KANJI,        /* 0x6768 */
    KANJI,        /* 0x6769 */
    KANJI,        /* 0x676a */
    KANJI,        /* 0x676b */
    KANJI,        /* 0x676c */
    KANJI,        /* 0x676d */
    KANJI,        /* 0x676e */
    KANJI,        /* 0x676f */
    KANJI,        /* 0x6770 */
    KANJI,        /* 0x6771 */
    KANJI,        /* 0x6772 */
    KANJI,        /* 0x6773 */
    KANJI,        /* 0x6774 */
    KANJI,        /* 0x6775 */
    KANJI,        /* 0x6776 */
    KANJI,        /* 0x6777 */
    KANJI,        /* 0x6778 */
    KANJI,        /* 0x6779 */
    KANJI,        /* 0x677a */
    KANJI,        /* 0x677b */
    KANJI,        /* 0x677c */
    KANJI,        /* 0x677d */
    KANJI,        /* 0x677e */
    KANJI,        /* 0x677f */
    KANJI,        /* 0x6780 */
    KANJI,        /* 0x6781 */
    KANJI,        /* 0x6782 */
    KANJI,        /* 0x6783 */
    KANJI,        /* 0x6784 */
    KANJI,        /* 0x6785 */
    KANJI,        /* 0x6786 */
    KANJI,        /* 0x6787 */
    KANJI,        /* 0x6788 */
    KANJI,        /* 0x6789 */
    KANJI,        /* 0x678a */
    KANJI,        /* 0x678b */
    KANJI,        /* 0x678c */
    KANJI,        /* 0x678d */
    KANJI,        /* 0x678e */
    KANJI,        /* 0x678f */
    KANJI,        /* 0x6790 */
    KANJI,        /* 0x6791 */
    KANJI,        /* 0x6792 */
    KANJI,        /* 0x6793 */
    KANJI,        /* 0x6794 */
    KANJI,        /* 0x6795 */
    KANJI,        /* 0x6796 */
    KANJI,        /* 0x6797 */
    KANJI,        /* 0x6798 */
    KANJI,        /* 0x6799 */
    KANJI,        /* 0x679a */
    KANJI,        /* 0x679b */
    KANJI,        /* 0x679c */
    KANJI,        /* 0x679d */
    KANJI,        /* 0x679e */
    KANJI,        /* 0x679f */
    KANJI,        /* 0x67a0 */
    KANJI,        /* 0x67a1 */
    KANJI,        /* 0x67a2 */
    KANJI,        /* 0x67a3 */
    KANJI,        /* 0x67a4 */
    KANJI,        /* 0x67a5 */
    KANJI,        /* 0x67a6 */
    KANJI,        /* 0x67a7 */
    KANJI,        /* 0x67a8 */
    KANJI,        /* 0x67a9 */
    KANJI,        /* 0x67aa */
    KANJI,        /* 0x67ab */
    KANJI,        /* 0x67ac */
    KANJI,        /* 0x67ad */
    KANJI,        /* 0x67ae */
    KANJI,        /* 0x67af */
    KANJI,        /* 0x67b0 */
    KANJI,        /* 0x67b1 */
    KANJI,        /* 0x67b2 */
    KANJI,        /* 0x67b3 */
    KANJI,        /* 0x67b4 */
    KANJI,        /* 0x67b5 */
    KANJI,        /* 0x67b6 */
    KANJI,        /* 0x67b7 */
    KANJI,        /* 0x67b8 */
    KANJI,        /* 0x67b9 */
    KANJI,        /* 0x67ba */
    KANJI,        /* 0x67bb */
    KANJI,        /* 0x67bc */
    KANJI,        /* 0x67bd */
    KANJI,        /* 0x67be */
    KANJI,        /* 0x67bf */
    KANJI,        /* 0x67c0 */
    KANJI,        /* 0x67c1 */
    KANJI,        /* 0x67c2 */
    KANJI,        /* 0x67c3 */
    KANJI,        /* 0x67c4 */
    KANJI,        /* 0x67c5 */
    KANJI,        /* 0x67c6 */
    KANJI,        /* 0x67c7 */
    KANJI,        /* 0x67c8 */
    KANJI,        /* 0x67c9 */
    KANJI,        /* 0x67ca */
    KANJI,        /* 0x67cb */
    KANJI,        /* 0x67cc */
    KANJI,        /* 0x67cd */
    KANJI,        /* 0x67ce */
    KANJI,        /* 0x67cf */
    KANJI,        /* 0x67d0 */
    KANJI,        /* 0x67d1 */
    KANJI,        /* 0x67d2 */
    KANJI,        /* 0x67d3 */
    KANJI,        /* 0x67d4 */
    KANJI,        /* 0x67d5 */
    KANJI,        /* 0x67d6 */
    KANJI,        /* 0x67d7 */
    KANJI,        /* 0x67d8 */
    KANJI,        /* 0x67d9 */
    KANJI,        /* 0x67da */
    KANJI,        /* 0x67db */
    KANJI,        /* 0x67dc */
    KANJI,        /* 0x67dd */
    KANJI,        /* 0x67de */
    KANJI,        /* 0x67df */
    KANJI,        /* 0x67e0 */
    KANJI,        /* 0x67e1 */
    KANJI,        /* 0x67e2 */
    KANJI,        /* 0x67e3 */
    KANJI,        /* 0x67e4 */
    KANJI,        /* 0x67e5 */
    KANJI,        /* 0x67e6 */
    KANJI,        /* 0x67e7 */
    KANJI,        /* 0x67e8 */
    KANJI,        /* 0x67e9 */
    KANJI,        /* 0x67ea */
    KANJI,        /* 0x67eb */
    KANJI,        /* 0x67ec */
    KANJI,        /* 0x67ed */
    KANJI,        /* 0x67ee */
    KANJI,        /* 0x67ef */
    KANJI,        /* 0x67f0 */
    KANJI,        /* 0x67f1 */
    KANJI,        /* 0x67f2 */
    KANJI,        /* 0x67f3 */
    KANJI,        /* 0x67f4 */
    KANJI,        /* 0x67f5 */
    KANJI,        /* 0x67f6 */
    KANJI,        /* 0x67f7 */
    KANJI,        /* 0x67f8 */
    KANJI,        /* 0x67f9 */
    KANJI,        /* 0x67fa */
    KANJI,        /* 0x67fb */
    KANJI,        /* 0x67fc */
    KANJI,        /* 0x67fd */
    KANJI,        /* 0x67fe */
    KANJI,        /* 0x67ff */
    KANJI,        /* 0x6800 */
    KANJI,        /* 0x6801 */
    KANJI,        /* 0x6802 */
    KANJI,        /* 0x6803 */
    KANJI,        /* 0x6804 */
    KANJI,        /* 0x6805 */
    KANJI,        /* 0x6806 */
    KANJI,        /* 0x6807 */
    KANJI,        /* 0x6808 */
    KANJI,        /* 0x6809 */
    KANJI,        /* 0x680a */
    KANJI,        /* 0x680b */
    KANJI,        /* 0x680c */
    KANJI,        /* 0x680d */
    KANJI,        /* 0x680e */
    KANJI,        /* 0x680f */
    KANJI,        /* 0x6810 */
    KANJI,        /* 0x6811 */
    KANJI,        /* 0x6812 */
    KANJI,        /* 0x6813 */
    KANJI,        /* 0x6814 */
    KANJI,        /* 0x6815 */
    KANJI,        /* 0x6816 */
    KANJI,        /* 0x6817 */
    KANJI,        /* 0x6818 */
    KANJI,        /* 0x6819 */
    KANJI,        /* 0x681a */
    KANJI,        /* 0x681b */
    KANJI,        /* 0x681c */
    KANJI,        /* 0x681d */
    KANJI,        /* 0x681e */
    KANJI,        /* 0x681f */
    KANJI,        /* 0x6820 */
    KANJI,        /* 0x6821 */
    KANJI,        /* 0x6822 */
    KANJI,        /* 0x6823 */
    KANJI,        /* 0x6824 */
    KANJI,        /* 0x6825 */
    KANJI,        /* 0x6826 */
    KANJI,        /* 0x6827 */
    KANJI,        /* 0x6828 */
    KANJI,        /* 0x6829 */
    KANJI,        /* 0x682a */
    KANJI,        /* 0x682b */
    KANJI,        /* 0x682c */
    KANJI,        /* 0x682d */
    KANJI,        /* 0x682e */
    KANJI,        /* 0x682f */
    KANJI,        /* 0x6830 */
    KANJI,        /* 0x6831 */
    KANJI,        /* 0x6832 */
    KANJI,        /* 0x6833 */
    KANJI,        /* 0x6834 */
    KANJI,        /* 0x6835 */
    KANJI,        /* 0x6836 */
    KANJI,        /* 0x6837 */
    KANJI,        /* 0x6838 */
    KANJI,        /* 0x6839 */
    KANJI,        /* 0x683a */
    KANJI,        /* 0x683b */
    KANJI,        /* 0x683c */
    KANJI,        /* 0x683d */
    KANJI,        /* 0x683e */
    KANJI,        /* 0x683f */
    KANJI,        /* 0x6840 */
    KANJI,        /* 0x6841 */
    KANJI,        /* 0x6842 */
    KANJI,        /* 0x6843 */
    KANJI,        /* 0x6844 */
    KANJI,        /* 0x6845 */
    KANJI,        /* 0x6846 */
    KANJI,        /* 0x6847 */
    KANJI,        /* 0x6848 */
    KANJI,        /* 0x6849 */
    KANJI,        /* 0x684a */
    KANJI,        /* 0x684b */
    KANJI,        /* 0x684c */
    KANJI,        /* 0x684d */
    KANJI,        /* 0x684e */
    KANJI,        /* 0x684f */
    KANJI,        /* 0x6850 */
    KANJI,        /* 0x6851 */
    KANJI,        /* 0x6852 */
    KANJI,        /* 0x6853 */
    KANJI,        /* 0x6854 */
    KANJI,        /* 0x6855 */
    KANJI,        /* 0x6856 */
    KANJI,        /* 0x6857 */
    KANJI,        /* 0x6858 */
    KANJI,        /* 0x6859 */
    KANJI,        /* 0x685a */
    KANJI,        /* 0x685b */
    KANJI,        /* 0x685c */
    KANJI,        /* 0x685d */
    KANJI,        /* 0x685e */
    KANJI,        /* 0x685f */
    KANJI,        /* 0x6860 */
    KANJI,        /* 0x6861 */
    KANJI,        /* 0x6862 */
    KANJI,        /* 0x6863 */
    KANJI,        /* 0x6864 */
    KANJI,        /* 0x6865 */
    KANJI,        /* 0x6866 */
    KANJI,        /* 0x6867 */
    KANJI,        /* 0x6868 */
    KANJI,        /* 0x6869 */
    KANJI,        /* 0x686a */
    KANJI,        /* 0x686b */
    KANJI,        /* 0x686c */
    KANJI,        /* 0x686d */
    KANJI,        /* 0x686e */
    KANJI,        /* 0x686f */
    KANJI,        /* 0x6870 */
    KANJI,        /* 0x6871 */
    KANJI,        /* 0x6872 */
    KANJI,        /* 0x6873 */
    KANJI,        /* 0x6874 */
    KANJI,        /* 0x6875 */
    KANJI,        /* 0x6876 */
    KANJI,        /* 0x6877 */
    KANJI,        /* 0x6878 */
    KANJI,        /* 0x6879 */
    KANJI,        /* 0x687a */
    KANJI,        /* 0x687b */
    KANJI,        /* 0x687c */
    KANJI,        /* 0x687d */
    KANJI,        /* 0x687e */
    KANJI,        /* 0x687f */
    KANJI,        /* 0x6880 */
    KANJI,        /* 0x6881 */
    KANJI,        /* 0x6882 */
    KANJI,        /* 0x6883 */
    KANJI,        /* 0x6884 */
    KANJI,        /* 0x6885 */
    KANJI,        /* 0x6886 */
    KANJI,        /* 0x6887 */
    KANJI,        /* 0x6888 */
    KANJI,        /* 0x6889 */
    KANJI,        /* 0x688a */
    KANJI,        /* 0x688b */
    KANJI,        /* 0x688c */
    KANJI,        /* 0x688d */
    KANJI,        /* 0x688e */
    KANJI,        /* 0x688f */
    KANJI,        /* 0x6890 */
    KANJI,        /* 0x6891 */
    KANJI,        /* 0x6892 */
    KANJI,        /* 0x6893 */
    KANJI,        /* 0x6894 */
    KANJI,        /* 0x6895 */
    KANJI,        /* 0x6896 */
    KANJI,        /* 0x6897 */
    KANJI,        /* 0x6898 */
    KANJI,        /* 0x6899 */
    KANJI,        /* 0x689a */
    KANJI,        /* 0x689b */
    KANJI,        /* 0x689c */
    KANJI,        /* 0x689d */
    KANJI,        /* 0x689e */
    KANJI,        /* 0x689f */
    KANJI,        /* 0x68a0 */
    KANJI,        /* 0x68a1 */
    KANJI,        /* 0x68a2 */
    KANJI,        /* 0x68a3 */
    KANJI,        /* 0x68a4 */
    KANJI,        /* 0x68a5 */
    KANJI,        /* 0x68a6 */
    KANJI,        /* 0x68a7 */
    KANJI,        /* 0x68a8 */
    KANJI,        /* 0x68a9 */
    KANJI,        /* 0x68aa */
    KANJI,        /* 0x68ab */
    KANJI,        /* 0x68ac */
    KANJI,        /* 0x68ad */
    KANJI,        /* 0x68ae */
    KANJI,        /* 0x68af */
    KANJI,        /* 0x68b0 */
    KANJI,        /* 0x68b1 */
    KANJI,        /* 0x68b2 */
    KANJI,        /* 0x68b3 */
    KANJI,        /* 0x68b4 */
    KANJI,        /* 0x68b5 */
    KANJI,        /* 0x68b6 */
    KANJI,        /* 0x68b7 */
    KANJI,        /* 0x68b8 */
    KANJI,        /* 0x68b9 */
    KANJI,        /* 0x68ba */
    KANJI,        /* 0x68bb */
    KANJI,        /* 0x68bc */
    KANJI,        /* 0x68bd */
    KANJI,        /* 0x68be */
    KANJI,        /* 0x68bf */
    KANJI,        /* 0x68c0 */
    KANJI,        /* 0x68c1 */
    KANJI,        /* 0x68c2 */
    KANJI,        /* 0x68c3 */
    KANJI,        /* 0x68c4 */
    KANJI,        /* 0x68c5 */
    KANJI,        /* 0x68c6 */
    KANJI,        /* 0x68c7 */
    KANJI,        /* 0x68c8 */
    KANJI,        /* 0x68c9 */
    KANJI,        /* 0x68ca */
    KANJI,        /* 0x68cb */
    KANJI,        /* 0x68cc */
    KANJI,        /* 0x68cd */
    KANJI,        /* 0x68ce */
    KANJI,        /* 0x68cf */
    KANJI,        /* 0x68d0 */
    KANJI,        /* 0x68d1 */
    KANJI,        /* 0x68d2 */
    KANJI,        /* 0x68d3 */
    KANJI,        /* 0x68d4 */
    KANJI,        /* 0x68d5 */
    KANJI,        /* 0x68d6 */
    KANJI,        /* 0x68d7 */
    KANJI,        /* 0x68d8 */
    KANJI,        /* 0x68d9 */
    KANJI,        /* 0x68da */
    KANJI,        /* 0x68db */
    KANJI,        /* 0x68dc */
    KANJI,        /* 0x68dd */
    KANJI,        /* 0x68de */
    KANJI,        /* 0x68df */
    KANJI,        /* 0x68e0 */
    KANJI,        /* 0x68e1 */
    KANJI,        /* 0x68e2 */
    KANJI,        /* 0x68e3 */
    KANJI,        /* 0x68e4 */
    KANJI,        /* 0x68e5 */
    KANJI,        /* 0x68e6 */
    KANJI,        /* 0x68e7 */
    KANJI,        /* 0x68e8 */
    KANJI,        /* 0x68e9 */
    KANJI,        /* 0x68ea */
    KANJI,        /* 0x68eb */
    KANJI,        /* 0x68ec */
    KANJI,        /* 0x68ed */
    KANJI,        /* 0x68ee */
    KANJI,        /* 0x68ef */
    KANJI,        /* 0x68f0 */
    KANJI,        /* 0x68f1 */
    KANJI,        /* 0x68f2 */
    KANJI,        /* 0x68f3 */
    KANJI,        /* 0x68f4 */
    KANJI,        /* 0x68f5 */
    KANJI,        /* 0x68f6 */
    KANJI,        /* 0x68f7 */
    KANJI,        /* 0x68f8 */
    KANJI,        /* 0x68f9 */
    KANJI,        /* 0x68fa */
    KANJI,        /* 0x68fb */
    KANJI,        /* 0x68fc */
    KANJI,        /* 0x68fd */
    KANJI,        /* 0x68fe */
    KANJI,        /* 0x68ff */
    KANJI,        /* 0x6900 */
    KANJI,        /* 0x6901 */
    KANJI,        /* 0x6902 */
    KANJI,        /* 0x6903 */
    KANJI,        /* 0x6904 */
    KANJI,        /* 0x6905 */
    KANJI,        /* 0x6906 */
    KANJI,        /* 0x6907 */
    KANJI,        /* 0x6908 */
    KANJI,        /* 0x6909 */
    KANJI,        /* 0x690a */
    KANJI,        /* 0x690b */
    KANJI,        /* 0x690c */
    KANJI,        /* 0x690d */
    KANJI,        /* 0x690e */
    KANJI,        /* 0x690f */
    KANJI,        /* 0x6910 */
    KANJI,        /* 0x6911 */
    KANJI,        /* 0x6912 */
    KANJI,        /* 0x6913 */
    KANJI,        /* 0x6914 */
    KANJI,        /* 0x6915 */
    KANJI,        /* 0x6916 */
    KANJI,        /* 0x6917 */
    KANJI,        /* 0x6918 */
    KANJI,        /* 0x6919 */
    KANJI,        /* 0x691a */
    KANJI,        /* 0x691b */
    KANJI,        /* 0x691c */
    KANJI,        /* 0x691d */
    KANJI,        /* 0x691e */
    KANJI,        /* 0x691f */
    KANJI,        /* 0x6920 */
    KANJI,        /* 0x6921 */
    KANJI,        /* 0x6922 */
    KANJI,        /* 0x6923 */
    KANJI,        /* 0x6924 */
    KANJI,        /* 0x6925 */
    KANJI,        /* 0x6926 */
    KANJI,        /* 0x6927 */
    KANJI,        /* 0x6928 */
    KANJI,        /* 0x6929 */
    KANJI,        /* 0x692a */
    KANJI,        /* 0x692b */
    KANJI,        /* 0x692c */
    KANJI,        /* 0x692d */
    KANJI,        /* 0x692e */
    KANJI,        /* 0x692f */
    KANJI,        /* 0x6930 */
    KANJI,        /* 0x6931 */
    KANJI,        /* 0x6932 */
    KANJI,        /* 0x6933 */
    KANJI,        /* 0x6934 */
    KANJI,        /* 0x6935 */
    KANJI,        /* 0x6936 */
    KANJI,        /* 0x6937 */
    KANJI,        /* 0x6938 */
    KANJI,        /* 0x6939 */
    KANJI,        /* 0x693a */
    KANJI,        /* 0x693b */
    KANJI,        /* 0x693c */
    KANJI,        /* 0x693d */
    KANJI,        /* 0x693e */
    KANJI,        /* 0x693f */
    KANJI,        /* 0x6940 */
    KANJI,        /* 0x6941 */
    KANJI,        /* 0x6942 */
    KANJI,        /* 0x6943 */
    KANJI,        /* 0x6944 */
    KANJI,        /* 0x6945 */
    KANJI,        /* 0x6946 */
    KANJI,        /* 0x6947 */
    KANJI,        /* 0x6948 */
    KANJI,        /* 0x6949 */
    KANJI,        /* 0x694a */
    KANJI,        /* 0x694b */
    KANJI,        /* 0x694c */
    KANJI,        /* 0x694d */
    KANJI,        /* 0x694e */
    KANJI,        /* 0x694f */
    KANJI,        /* 0x6950 */
    KANJI,        /* 0x6951 */
    KANJI,        /* 0x6952 */
    KANJI,        /* 0x6953 */
    KANJI,        /* 0x6954 */
    KANJI,        /* 0x6955 */
    KANJI,        /* 0x6956 */
    KANJI,        /* 0x6957 */
    KANJI,        /* 0x6958 */
    KANJI,        /* 0x6959 */
    KANJI,        /* 0x695a */
    KANJI,        /* 0x695b */
    KANJI,        /* 0x695c */
    KANJI,        /* 0x695d */
    KANJI,        /* 0x695e */
    KANJI,        /* 0x695f */
    KANJI,        /* 0x6960 */
    KANJI,        /* 0x6961 */
    KANJI,        /* 0x6962 */
    KANJI,        /* 0x6963 */
    KANJI,        /* 0x6964 */
    KANJI,        /* 0x6965 */
    KANJI,        /* 0x6966 */
    KANJI,        /* 0x6967 */
    KANJI,        /* 0x6968 */
    KANJI,        /* 0x6969 */
    KANJI,        /* 0x696a */
    KANJI,        /* 0x696b */
    KANJI,        /* 0x696c */
    KANJI,        /* 0x696d */
    KANJI,        /* 0x696e */
    KANJI,        /* 0x696f */
    KANJI,        /* 0x6970 */
    KANJI,        /* 0x6971 */
    KANJI,        /* 0x6972 */
    KANJI,        /* 0x6973 */
    KANJI,        /* 0x6974 */
    KANJI,        /* 0x6975 */
    KANJI,        /* 0x6976 */
    KANJI,        /* 0x6977 */
    KANJI,        /* 0x6978 */
    KANJI,        /* 0x6979 */
    KANJI,        /* 0x697a */
    KANJI,        /* 0x697b */
    KANJI,        /* 0x697c */
    KANJI,        /* 0x697d */
    KANJI,        /* 0x697e */
    KANJI,        /* 0x697f */
    KANJI,        /* 0x6980 */
    KANJI,        /* 0x6981 */
    KANJI,        /* 0x6982 */
    KANJI,        /* 0x6983 */
    KANJI,        /* 0x6984 */
    KANJI,        /* 0x6985 */
    KANJI,        /* 0x6986 */
    KANJI,        /* 0x6987 */
    KANJI,        /* 0x6988 */
    KANJI,        /* 0x6989 */
    KANJI,        /* 0x698a */
    KANJI,        /* 0x698b */
    KANJI,        /* 0x698c */
    KANJI,        /* 0x698d */
    KANJI,        /* 0x698e */
    KANJI,        /* 0x698f */
    KANJI,        /* 0x6990 */
    KANJI,        /* 0x6991 */
    KANJI,        /* 0x6992 */
    KANJI,        /* 0x6993 */
    KANJI,        /* 0x6994 */
    KANJI,        /* 0x6995 */
    KANJI,        /* 0x6996 */
    KANJI,        /* 0x6997 */
    KANJI,        /* 0x6998 */
    KANJI,        /* 0x6999 */
    KANJI,        /* 0x699a */
    KANJI,        /* 0x699b */
    KANJI,        /* 0x699c */
    KANJI,        /* 0x699d */
    KANJI,        /* 0x699e */
    KANJI,        /* 0x699f */
    KANJI,        /* 0x69a0 */
    KANJI,        /* 0x69a1 */
    KANJI,        /* 0x69a2 */
    KANJI,        /* 0x69a3 */
    KANJI,        /* 0x69a4 */
    KANJI,        /* 0x69a5 */
    KANJI,        /* 0x69a6 */
    KANJI,        /* 0x69a7 */
    KANJI,        /* 0x69a8 */
    KANJI,        /* 0x69a9 */
    KANJI,        /* 0x69aa */
    KANJI,        /* 0x69ab */
    KANJI,        /* 0x69ac */
    KANJI,        /* 0x69ad */
    KANJI,        /* 0x69ae */
    KANJI,        /* 0x69af */
    KANJI,        /* 0x69b0 */
    KANJI,        /* 0x69b1 */
    KANJI,        /* 0x69b2 */
    KANJI,        /* 0x69b3 */
    KANJI,        /* 0x69b4 */
    KANJI,        /* 0x69b5 */
    KANJI,        /* 0x69b6 */
    KANJI,        /* 0x69b7 */
    KANJI,        /* 0x69b8 */
    KANJI,        /* 0x69b9 */
    KANJI,        /* 0x69ba */
    KANJI,        /* 0x69bb */
    KANJI,        /* 0x69bc */
    KANJI,        /* 0x69bd */
    KANJI,        /* 0x69be */
    KANJI,        /* 0x69bf */
    KANJI,        /* 0x69c0 */
    KANJI,        /* 0x69c1 */
    KANJI,        /* 0x69c2 */
    KANJI,        /* 0x69c3 */
    KANJI,        /* 0x69c4 */
    KANJI,        /* 0x69c5 */
    KANJI,        /* 0x69c6 */
    KANJI,        /* 0x69c7 */
    KANJI,        /* 0x69c8 */
    KANJI,        /* 0x69c9 */
    KANJI,        /* 0x69ca */
    KANJI,        /* 0x69cb */
    KANJI,        /* 0x69cc */
    KANJI,        /* 0x69cd */
    KANJI,        /* 0x69ce */
    KANJI,        /* 0x69cf */
    KANJI,        /* 0x69d0 */
    KANJI,        /* 0x69d1 */
    KANJI,        /* 0x69d2 */
    KANJI,        /* 0x69d3 */
    KANJI,        /* 0x69d4 */
    KANJI,        /* 0x69d5 */
    KANJI,        /* 0x69d6 */
    KANJI,        /* 0x69d7 */
    KANJI,        /* 0x69d8 */
    KANJI,        /* 0x69d9 */
    KANJI,        /* 0x69da */
    KANJI,        /* 0x69db */
    KANJI,        /* 0x69dc */
    KANJI,        /* 0x69dd */
    KANJI,        /* 0x69de */
    KANJI,        /* 0x69df */
    KANJI,        /* 0x69e0 */
    KANJI,        /* 0x69e1 */
    KANJI,        /* 0x69e2 */
    KANJI,        /* 0x69e3 */
    KANJI,        /* 0x69e4 */
    KANJI,        /* 0x69e5 */
    KANJI,        /* 0x69e6 */
    KANJI,        /* 0x69e7 */
    KANJI,        /* 0x69e8 */
    KANJI,        /* 0x69e9 */
    KANJI,        /* 0x69ea */
    KANJI,        /* 0x69eb */
    KANJI,        /* 0x69ec */
    KANJI,        /* 0x69ed */
    KANJI,        /* 0x69ee */
    KANJI,        /* 0x69ef */
    KANJI,        /* 0x69f0 */
    KANJI,        /* 0x69f1 */
    KANJI,        /* 0x69f2 */
    KANJI,        /* 0x69f3 */
    KANJI,        /* 0x69f4 */
    KANJI,        /* 0x69f5 */
    KANJI,        /* 0x69f6 */
    KANJI,        /* 0x69f7 */
    KANJI,        /* 0x69f8 */
    KANJI,        /* 0x69f9 */
    KANJI,        /* 0x69fa */
    KANJI,        /* 0x69fb */
    KANJI,        /* 0x69fc */
    KANJI,        /* 0x69fd */
    KANJI,        /* 0x69fe */
    KANJI,        /* 0x69ff */
    KANJI,        /* 0x6a00 */
    KANJI,        /* 0x6a01 */
    KANJI,        /* 0x6a02 */
    KANJI,        /* 0x6a03 */
    KANJI,        /* 0x6a04 */
    KANJI,        /* 0x6a05 */
    KANJI,        /* 0x6a06 */
    KANJI,        /* 0x6a07 */
    KANJI,        /* 0x6a08 */
    KANJI,        /* 0x6a09 */
    KANJI,        /* 0x6a0a */
    KANJI,        /* 0x6a0b */
    KANJI,        /* 0x6a0c */
    KANJI,        /* 0x6a0d */
    KANJI,        /* 0x6a0e */
    KANJI,        /* 0x6a0f */
    KANJI,        /* 0x6a10 */
    KANJI,        /* 0x6a11 */
    KANJI,        /* 0x6a12 */
    KANJI,        /* 0x6a13 */
    KANJI,        /* 0x6a14 */
    KANJI,        /* 0x6a15 */
    KANJI,        /* 0x6a16 */
    KANJI,        /* 0x6a17 */
    KANJI,        /* 0x6a18 */
    KANJI,        /* 0x6a19 */
    KANJI,        /* 0x6a1a */
    KANJI,        /* 0x6a1b */
    KANJI,        /* 0x6a1c */
    KANJI,        /* 0x6a1d */
    KANJI,        /* 0x6a1e */
    KANJI,        /* 0x6a1f */
    KANJI,        /* 0x6a20 */
    KANJI,        /* 0x6a21 */
    KANJI,        /* 0x6a22 */
    KANJI,        /* 0x6a23 */
    KANJI,        /* 0x6a24 */
    KANJI,        /* 0x6a25 */
    KANJI,        /* 0x6a26 */
    KANJI,        /* 0x6a27 */
    KANJI,        /* 0x6a28 */
    KANJI,        /* 0x6a29 */
    KANJI,        /* 0x6a2a */
    KANJI,        /* 0x6a2b */
    KANJI,        /* 0x6a2c */
    KANJI,        /* 0x6a2d */
    KANJI,        /* 0x6a2e */
    KANJI,        /* 0x6a2f */
    KANJI,        /* 0x6a30 */
    KANJI,        /* 0x6a31 */
    KANJI,        /* 0x6a32 */
    KANJI,        /* 0x6a33 */
    KANJI,        /* 0x6a34 */
    KANJI,        /* 0x6a35 */
    KANJI,        /* 0x6a36 */
    KANJI,        /* 0x6a37 */
    KANJI,        /* 0x6a38 */
    KANJI,        /* 0x6a39 */
    KANJI,        /* 0x6a3a */
    KANJI,        /* 0x6a3b */
    KANJI,        /* 0x6a3c */
    KANJI,        /* 0x6a3d */
    KANJI,        /* 0x6a3e */
    KANJI,        /* 0x6a3f */
    KANJI,        /* 0x6a40 */
    KANJI,        /* 0x6a41 */
    KANJI,        /* 0x6a42 */
    KANJI,        /* 0x6a43 */
    KANJI,        /* 0x6a44 */
    KANJI,        /* 0x6a45 */
    KANJI,        /* 0x6a46 */
    KANJI,        /* 0x6a47 */
    KANJI,        /* 0x6a48 */
    KANJI,        /* 0x6a49 */
    KANJI,        /* 0x6a4a */
    KANJI,        /* 0x6a4b */
    KANJI,        /* 0x6a4c */
    KANJI,        /* 0x6a4d */
    KANJI,        /* 0x6a4e */
    KANJI,        /* 0x6a4f */
    KANJI,        /* 0x6a50 */
    KANJI,        /* 0x6a51 */
    KANJI,        /* 0x6a52 */
    KANJI,        /* 0x6a53 */
    KANJI,        /* 0x6a54 */
    KANJI,        /* 0x6a55 */
    KANJI,        /* 0x6a56 */
    KANJI,        /* 0x6a57 */
    KANJI,        /* 0x6a58 */
    KANJI,        /* 0x6a59 */
    KANJI,        /* 0x6a5a */
    KANJI,        /* 0x6a5b */
    KANJI,        /* 0x6a5c */
    KANJI,        /* 0x6a5d */
    KANJI,        /* 0x6a5e */
    KANJI,        /* 0x6a5f */
    KANJI,        /* 0x6a60 */
    KANJI,        /* 0x6a61 */
    KANJI,        /* 0x6a62 */
    KANJI,        /* 0x6a63 */
    KANJI,        /* 0x6a64 */
    KANJI,        /* 0x6a65 */
    KANJI,        /* 0x6a66 */
    KANJI,        /* 0x6a67 */
    KANJI,        /* 0x6a68 */
    KANJI,        /* 0x6a69 */
    KANJI,        /* 0x6a6a */
    KANJI,        /* 0x6a6b */
    KANJI,        /* 0x6a6c */
    KANJI,        /* 0x6a6d */
    KANJI,        /* 0x6a6e */
    KANJI,        /* 0x6a6f */
    KANJI,        /* 0x6a70 */
    KANJI,        /* 0x6a71 */
    KANJI,        /* 0x6a72 */
    KANJI,        /* 0x6a73 */
    KANJI,        /* 0x6a74 */
    KANJI,        /* 0x6a75 */
    KANJI,        /* 0x6a76 */
    KANJI,        /* 0x6a77 */
    KANJI,        /* 0x6a78 */
    KANJI,        /* 0x6a79 */
    KANJI,        /* 0x6a7a */
    KANJI,        /* 0x6a7b */
    KANJI,        /* 0x6a7c */
    KANJI,        /* 0x6a7d */
    KANJI,        /* 0x6a7e */
    KANJI,        /* 0x6a7f */
    KANJI,        /* 0x6a80 */
    KANJI,        /* 0x6a81 */
    KANJI,        /* 0x6a82 */
    KANJI,        /* 0x6a83 */
    KANJI,        /* 0x6a84 */
    KANJI,        /* 0x6a85 */
    KANJI,        /* 0x6a86 */
    KANJI,        /* 0x6a87 */
    KANJI,        /* 0x6a88 */
    KANJI,        /* 0x6a89 */
    KANJI,        /* 0x6a8a */
    KANJI,        /* 0x6a8b */
    KANJI,        /* 0x6a8c */
    KANJI,        /* 0x6a8d */
    KANJI,        /* 0x6a8e */
    KANJI,        /* 0x6a8f */
    KANJI,        /* 0x6a90 */
    KANJI,        /* 0x6a91 */
    KANJI,        /* 0x6a92 */
    KANJI,        /* 0x6a93 */
    KANJI,        /* 0x6a94 */
    KANJI,        /* 0x6a95 */
    KANJI,        /* 0x6a96 */
    KANJI,        /* 0x6a97 */
    KANJI,        /* 0x6a98 */
    KANJI,        /* 0x6a99 */
    KANJI,        /* 0x6a9a */
    KANJI,        /* 0x6a9b */
    KANJI,        /* 0x6a9c */
    KANJI,        /* 0x6a9d */
    KANJI,        /* 0x6a9e */
    KANJI,        /* 0x6a9f */
    KANJI,        /* 0x6aa0 */
    KANJI,        /* 0x6aa1 */
    KANJI,        /* 0x6aa2 */
    KANJI,        /* 0x6aa3 */
    KANJI,        /* 0x6aa4 */
    KANJI,        /* 0x6aa5 */
    KANJI,        /* 0x6aa6 */
    KANJI,        /* 0x6aa7 */
    KANJI,        /* 0x6aa8 */
    KANJI,        /* 0x6aa9 */
    KANJI,        /* 0x6aaa */
    KANJI,        /* 0x6aab */
    KANJI,        /* 0x6aac */
    KANJI,        /* 0x6aad */
    KANJI,        /* 0x6aae */
    KANJI,        /* 0x6aaf */
    KANJI,        /* 0x6ab0 */
    KANJI,        /* 0x6ab1 */
    KANJI,        /* 0x6ab2 */
    KANJI,        /* 0x6ab3 */
    KANJI,        /* 0x6ab4 */
    KANJI,        /* 0x6ab5 */
    KANJI,        /* 0x6ab6 */
    KANJI,        /* 0x6ab7 */
    KANJI,        /* 0x6ab8 */
    KANJI,        /* 0x6ab9 */
    KANJI,        /* 0x6aba */
    KANJI,        /* 0x6abb */
    KANJI,        /* 0x6abc */
    KANJI,        /* 0x6abd */
    KANJI,        /* 0x6abe */
    KANJI,        /* 0x6abf */
    KANJI,        /* 0x6ac0 */
    KANJI,        /* 0x6ac1 */
    KANJI,        /* 0x6ac2 */
    KANJI,        /* 0x6ac3 */
    KANJI,        /* 0x6ac4 */
    KANJI,        /* 0x6ac5 */
    KANJI,        /* 0x6ac6 */
    KANJI,        /* 0x6ac7 */
    KANJI,        /* 0x6ac8 */
    KANJI,        /* 0x6ac9 */
    KANJI,        /* 0x6aca */
    KANJI,        /* 0x6acb */
    KANJI,        /* 0x6acc */
    KANJI,        /* 0x6acd */
    KANJI,        /* 0x6ace */
    KANJI,        /* 0x6acf */
    KANJI,        /* 0x6ad0 */
    KANJI,        /* 0x6ad1 */
    KANJI,        /* 0x6ad2 */
    KANJI,        /* 0x6ad3 */
    KANJI,        /* 0x6ad4 */
    KANJI,        /* 0x6ad5 */
    KANJI,        /* 0x6ad6 */
    KANJI,        /* 0x6ad7 */
    KANJI,        /* 0x6ad8 */
    KANJI,        /* 0x6ad9 */
    KANJI,        /* 0x6ada */
    KANJI,        /* 0x6adb */
    KANJI,        /* 0x6adc */
    KANJI,        /* 0x6add */
    KANJI,        /* 0x6ade */
    KANJI,        /* 0x6adf */
    KANJI,        /* 0x6ae0 */
    KANJI,        /* 0x6ae1 */
    KANJI,        /* 0x6ae2 */
    KANJI,        /* 0x6ae3 */
    KANJI,        /* 0x6ae4 */
    KANJI,        /* 0x6ae5 */
    KANJI,        /* 0x6ae6 */
    KANJI,        /* 0x6ae7 */
    KANJI,        /* 0x6ae8 */
    KANJI,        /* 0x6ae9 */
    KANJI,        /* 0x6aea */
    KANJI,        /* 0x6aeb */
    KANJI,        /* 0x6aec */
    KANJI,        /* 0x6aed */
    KANJI,        /* 0x6aee */
    KANJI,        /* 0x6aef */
    KANJI,        /* 0x6af0 */
    KANJI,        /* 0x6af1 */
    KANJI,        /* 0x6af2 */
    KANJI,        /* 0x6af3 */
    KANJI,        /* 0x6af4 */
    KANJI,        /* 0x6af5 */
    KANJI,        /* 0x6af6 */
    KANJI,        /* 0x6af7 */
    KANJI,        /* 0x6af8 */
    KANJI,        /* 0x6af9 */
    KANJI,        /* 0x6afa */
    KANJI,        /* 0x6afb */
    KANJI,        /* 0x6afc */
    KANJI,        /* 0x6afd */
    KANJI,        /* 0x6afe */
    KANJI,        /* 0x6aff */
    KANJI,        /* 0x6b00 */
    KANJI,        /* 0x6b01 */
    KANJI,        /* 0x6b02 */
    KANJI,        /* 0x6b03 */
    KANJI,        /* 0x6b04 */
    KANJI,        /* 0x6b05 */
    KANJI,        /* 0x6b06 */
    KANJI,        /* 0x6b07 */
    KANJI,        /* 0x6b08 */
    KANJI,        /* 0x6b09 */
    KANJI,        /* 0x6b0a */
    KANJI,        /* 0x6b0b */
    KANJI,        /* 0x6b0c */
    KANJI,        /* 0x6b0d */
    KANJI,        /* 0x6b0e */
    KANJI,        /* 0x6b0f */
    KANJI,        /* 0x6b10 */
    KANJI,        /* 0x6b11 */
    KANJI,        /* 0x6b12 */
    KANJI,        /* 0x6b13 */
    KANJI,        /* 0x6b14 */
    KANJI,        /* 0x6b15 */
    KANJI,        /* 0x6b16 */
    KANJI,        /* 0x6b17 */
    KANJI,        /* 0x6b18 */
    KANJI,        /* 0x6b19 */
    KANJI,        /* 0x6b1a */
    KANJI,        /* 0x6b1b */
    KANJI,        /* 0x6b1c */
    KANJI,        /* 0x6b1d */
    KANJI,        /* 0x6b1e */
    KANJI,        /* 0x6b1f */
    KANJI,        /* 0x6b20 */
    KANJI,        /* 0x6b21 */
    KANJI,        /* 0x6b22 */
    KANJI,        /* 0x6b23 */
    KANJI,        /* 0x6b24 */
    KANJI,        /* 0x6b25 */
    KANJI,        /* 0x6b26 */
    KANJI,        /* 0x6b27 */
    KANJI,        /* 0x6b28 */
    KANJI,        /* 0x6b29 */
    KANJI,        /* 0x6b2a */
    KANJI,        /* 0x6b2b */
    KANJI,        /* 0x6b2c */
    KANJI,        /* 0x6b2d */
    KANJI,        /* 0x6b2e */
    KANJI,        /* 0x6b2f */
    KANJI,        /* 0x6b30 */
    KANJI,        /* 0x6b31 */
    KANJI,        /* 0x6b32 */
    KANJI,        /* 0x6b33 */
    KANJI,        /* 0x6b34 */
    KANJI,        /* 0x6b35 */
    KANJI,        /* 0x6b36 */
    KANJI,        /* 0x6b37 */
    KANJI,        /* 0x6b38 */
    KANJI,        /* 0x6b39 */
    KANJI,        /* 0x6b3a */
    KANJI,        /* 0x6b3b */
    KANJI,        /* 0x6b3c */
    KANJI,        /* 0x6b3d */
    KANJI,        /* 0x6b3e */
    KANJI,        /* 0x6b3f */
    KANJI,        /* 0x6b40 */
    KANJI,        /* 0x6b41 */
    KANJI,        /* 0x6b42 */
    KANJI,        /* 0x6b43 */
    KANJI,        /* 0x6b44 */
    KANJI,        /* 0x6b45 */
    KANJI,        /* 0x6b46 */
    KANJI,        /* 0x6b47 */
    KANJI,        /* 0x6b48 */
    KANJI,        /* 0x6b49 */
    KANJI,        /* 0x6b4a */
    KANJI,        /* 0x6b4b */
    KANJI,        /* 0x6b4c */
    KANJI,        /* 0x6b4d */
    KANJI,        /* 0x6b4e */
    KANJI,        /* 0x6b4f */
    KANJI,        /* 0x6b50 */
    KANJI,        /* 0x6b51 */
    KANJI,        /* 0x6b52 */
    KANJI,        /* 0x6b53 */
    KANJI,        /* 0x6b54 */
    KANJI,        /* 0x6b55 */
    KANJI,        /* 0x6b56 */
    KANJI,        /* 0x6b57 */
    KANJI,        /* 0x6b58 */
    KANJI,        /* 0x6b59 */
    KANJI,        /* 0x6b5a */
    KANJI,        /* 0x6b5b */
    KANJI,        /* 0x6b5c */
    KANJI,        /* 0x6b5d */
    KANJI,        /* 0x6b5e */
    KANJI,        /* 0x6b5f */
    KANJI,        /* 0x6b60 */
    KANJI,        /* 0x6b61 */
    KANJI,        /* 0x6b62 */
    KANJI,        /* 0x6b63 */
    KANJI,        /* 0x6b64 */
    KANJI,        /* 0x6b65 */
    KANJI,        /* 0x6b66 */
    KANJI,        /* 0x6b67 */
    KANJI,        /* 0x6b68 */
    KANJI,        /* 0x6b69 */
    KANJI,        /* 0x6b6a */
    KANJI,        /* 0x6b6b */
    KANJI,        /* 0x6b6c */
    KANJI,        /* 0x6b6d */
    KANJI,        /* 0x6b6e */
    KANJI,        /* 0x6b6f */
    KANJI,        /* 0x6b70 */
    KANJI,        /* 0x6b71 */
    KANJI,        /* 0x6b72 */
    KANJI,        /* 0x6b73 */
    KANJI,        /* 0x6b74 */
    KANJI,        /* 0x6b75 */
    KANJI,        /* 0x6b76 */
    KANJI,        /* 0x6b77 */
    KANJI,        /* 0x6b78 */
    KANJI,        /* 0x6b79 */
    KANJI,        /* 0x6b7a */
    KANJI,        /* 0x6b7b */
    KANJI,        /* 0x6b7c */
    KANJI,        /* 0x6b7d */
    KANJI,        /* 0x6b7e */
    KANJI,        /* 0x6b7f */
    KANJI,        /* 0x6b80 */
    KANJI,        /* 0x6b81 */
    KANJI,        /* 0x6b82 */
    KANJI,        /* 0x6b83 */
    KANJI,        /* 0x6b84 */
    KANJI,        /* 0x6b85 */
    KANJI,        /* 0x6b86 */
    KANJI,        /* 0x6b87 */
    KANJI,        /* 0x6b88 */
    KANJI,        /* 0x6b89 */
    KANJI,        /* 0x6b8a */
    KANJI,        /* 0x6b8b */
    KANJI,        /* 0x6b8c */
    KANJI,        /* 0x6b8d */
    KANJI,        /* 0x6b8e */
    KANJI,        /* 0x6b8f */
    KANJI,        /* 0x6b90 */
    KANJI,        /* 0x6b91 */
    KANJI,        /* 0x6b92 */
    KANJI,        /* 0x6b93 */
    KANJI,        /* 0x6b94 */
    KANJI,        /* 0x6b95 */
    KANJI,        /* 0x6b96 */
    KANJI,        /* 0x6b97 */
    KANJI,        /* 0x6b98 */
    KANJI,        /* 0x6b99 */
    KANJI,        /* 0x6b9a */
    KANJI,        /* 0x6b9b */
    KANJI,        /* 0x6b9c */
    KANJI,        /* 0x6b9d */
    KANJI,        /* 0x6b9e */
    KANJI,        /* 0x6b9f */
    KANJI,        /* 0x6ba0 */
    KANJI,        /* 0x6ba1 */
    KANJI,        /* 0x6ba2 */
    KANJI,        /* 0x6ba3 */
    KANJI,        /* 0x6ba4 */
    KANJI,        /* 0x6ba5 */
    KANJI,        /* 0x6ba6 */
    KANJI,        /* 0x6ba7 */
    KANJI,        /* 0x6ba8 */
    KANJI,        /* 0x6ba9 */
    KANJI,        /* 0x6baa */
    KANJI,        /* 0x6bab */
    KANJI,        /* 0x6bac */
    KANJI,        /* 0x6bad */
    KANJI,        /* 0x6bae */
    KANJI,        /* 0x6baf */
    KANJI,        /* 0x6bb0 */
    KANJI,        /* 0x6bb1 */
    KANJI,        /* 0x6bb2 */
    KANJI,        /* 0x6bb3 */
    KANJI,        /* 0x6bb4 */
    KANJI,        /* 0x6bb5 */
    KANJI,        /* 0x6bb6 */
    KANJI,        /* 0x6bb7 */
    KANJI,        /* 0x6bb8 */
    KANJI,        /* 0x6bb9 */
    KANJI,        /* 0x6bba */
    KANJI,        /* 0x6bbb */
    KANJI,        /* 0x6bbc */
    KANJI,        /* 0x6bbd */
    KANJI,        /* 0x6bbe */
    KANJI,        /* 0x6bbf */
    KANJI,        /* 0x6bc0 */
    KANJI,        /* 0x6bc1 */
    KANJI,        /* 0x6bc2 */
    KANJI,        /* 0x6bc3 */
    KANJI,        /* 0x6bc4 */
    KANJI,        /* 0x6bc5 */
    KANJI,        /* 0x6bc6 */
    KANJI,        /* 0x6bc7 */
    KANJI,        /* 0x6bc8 */
    KANJI,        /* 0x6bc9 */
    KANJI,        /* 0x6bca */
    KANJI,        /* 0x6bcb */
    KANJI,        /* 0x6bcc */
    KANJI,        /* 0x6bcd */
    KANJI,        /* 0x6bce */
    KANJI,        /* 0x6bcf */
    KANJI,        /* 0x6bd0 */
    KANJI,        /* 0x6bd1 */
    KANJI,        /* 0x6bd2 */
    KANJI,        /* 0x6bd3 */
    KANJI,        /* 0x6bd4 */
    KANJI,        /* 0x6bd5 */
    KANJI,        /* 0x6bd6 */
    KANJI,        /* 0x6bd7 */
    KANJI,        /* 0x6bd8 */
    KANJI,        /* 0x6bd9 */
    KANJI,        /* 0x6bda */
    KANJI,        /* 0x6bdb */
    KANJI,        /* 0x6bdc */
    KANJI,        /* 0x6bdd */
    KANJI,        /* 0x6bde */
    KANJI,        /* 0x6bdf */
    KANJI,        /* 0x6be0 */
    KANJI,        /* 0x6be1 */
    KANJI,        /* 0x6be2 */
    KANJI,        /* 0x6be3 */
    KANJI,        /* 0x6be4 */
    KANJI,        /* 0x6be5 */
    KANJI,        /* 0x6be6 */
    KANJI,        /* 0x6be7 */
    KANJI,        /* 0x6be8 */
    KANJI,        /* 0x6be9 */
    KANJI,        /* 0x6bea */
    KANJI,        /* 0x6beb */
    KANJI,        /* 0x6bec */
    KANJI,        /* 0x6bed */
    KANJI,        /* 0x6bee */
    KANJI,        /* 0x6bef */
    KANJI,        /* 0x6bf0 */
    KANJI,        /* 0x6bf1 */
    KANJI,        /* 0x6bf2 */
    KANJI,        /* 0x6bf3 */
    KANJI,        /* 0x6bf4 */
    KANJI,        /* 0x6bf5 */
    KANJI,        /* 0x6bf6 */
    KANJI,        /* 0x6bf7 */
    KANJI,        /* 0x6bf8 */
    KANJI,        /* 0x6bf9 */
    KANJI,        /* 0x6bfa */
    KANJI,        /* 0x6bfb */
    KANJI,        /* 0x6bfc */
    KANJI,        /* 0x6bfd */
    KANJI,        /* 0x6bfe */
    KANJI,        /* 0x6bff */
    KANJI,        /* 0x6c00 */
    KANJI,        /* 0x6c01 */
    KANJI,        /* 0x6c02 */
    KANJI,        /* 0x6c03 */
    KANJI,        /* 0x6c04 */
    KANJI,        /* 0x6c05 */
    KANJI,        /* 0x6c06 */
    KANJI,        /* 0x6c07 */
    KANJI,        /* 0x6c08 */
    KANJI,        /* 0x6c09 */
    KANJI,        /* 0x6c0a */
    KANJI,        /* 0x6c0b */
    KANJI,        /* 0x6c0c */
    KANJI,        /* 0x6c0d */
    KANJI,        /* 0x6c0e */
    KANJI,        /* 0x6c0f */
    KANJI,        /* 0x6c10 */
    KANJI,        /* 0x6c11 */
    KANJI,        /* 0x6c12 */
    KANJI,        /* 0x6c13 */
    KANJI,        /* 0x6c14 */
    KANJI,        /* 0x6c15 */
    KANJI,        /* 0x6c16 */
    KANJI,        /* 0x6c17 */
    KANJI,        /* 0x6c18 */
    KANJI,        /* 0x6c19 */
    KANJI,        /* 0x6c1a */
    KANJI,        /* 0x6c1b */
    KANJI,        /* 0x6c1c */
    KANJI,        /* 0x6c1d */
    KANJI,        /* 0x6c1e */
    KANJI,        /* 0x6c1f */
    KANJI,        /* 0x6c20 */
    KANJI,        /* 0x6c21 */
    KANJI,        /* 0x6c22 */
    KANJI,        /* 0x6c23 */
    KANJI,        /* 0x6c24 */
    KANJI,        /* 0x6c25 */
    KANJI,        /* 0x6c26 */
    KANJI,        /* 0x6c27 */
    KANJI,        /* 0x6c28 */
    KANJI,        /* 0x6c29 */
    KANJI,        /* 0x6c2a */
    KANJI,        /* 0x6c2b */
    KANJI,        /* 0x6c2c */
    KANJI,        /* 0x6c2d */
    KANJI,        /* 0x6c2e */
    KANJI,        /* 0x6c2f */
    KANJI,        /* 0x6c30 */
    KANJI,        /* 0x6c31 */
    KANJI,        /* 0x6c32 */
    KANJI,        /* 0x6c33 */
    KANJI,        /* 0x6c34 */
    KANJI,        /* 0x6c35 */
    KANJI,        /* 0x6c36 */
    KANJI,        /* 0x6c37 */
    KANJI,        /* 0x6c38 */
    KANJI,        /* 0x6c39 */
    KANJI,        /* 0x6c3a */
    KANJI,        /* 0x6c3b */
    KANJI,        /* 0x6c3c */
    KANJI,        /* 0x6c3d */
    KANJI,        /* 0x6c3e */
    KANJI,        /* 0x6c3f */
    KANJI,        /* 0x6c40 */
    KANJI,        /* 0x6c41 */
    KANJI,        /* 0x6c42 */
    KANJI,        /* 0x6c43 */
    KANJI,        /* 0x6c44 */
    KANJI,        /* 0x6c45 */
    KANJI,        /* 0x6c46 */
    KANJI,        /* 0x6c47 */
    KANJI,        /* 0x6c48 */
    KANJI,        /* 0x6c49 */
    KANJI,        /* 0x6c4a */
    KANJI,        /* 0x6c4b */
    KANJI,        /* 0x6c4c */
    KANJI,        /* 0x6c4d */
    KANJI,        /* 0x6c4e */
    KANJI,        /* 0x6c4f */
    KANJI,        /* 0x6c50 */
    KANJI,        /* 0x6c51 */
    KANJI,        /* 0x6c52 */
    KANJI,        /* 0x6c53 */
    KANJI,        /* 0x6c54 */
    KANJI,        /* 0x6c55 */
    KANJI,        /* 0x6c56 */
    KANJI,        /* 0x6c57 */
    KANJI,        /* 0x6c58 */
    KANJI,        /* 0x6c59 */
    KANJI,        /* 0x6c5a */
    KANJI,        /* 0x6c5b */
    KANJI,        /* 0x6c5c */
    KANJI,        /* 0x6c5d */
    KANJI,        /* 0x6c5e */
    KANJI,        /* 0x6c5f */
    KANJI,        /* 0x6c60 */
    KANJI,        /* 0x6c61 */
    KANJI,        /* 0x6c62 */
    KANJI,        /* 0x6c63 */
    KANJI,        /* 0x6c64 */
    KANJI,        /* 0x6c65 */
    KANJI,        /* 0x6c66 */
    KANJI,        /* 0x6c67 */
    KANJI,        /* 0x6c68 */
    KANJI,        /* 0x6c69 */
    KANJI,        /* 0x6c6a */
    KANJI,        /* 0x6c6b */
    KANJI,        /* 0x6c6c */
    KANJI,        /* 0x6c6d */
    KANJI,        /* 0x6c6e */
    KANJI,        /* 0x6c6f */
    KANJI,        /* 0x6c70 */
    KANJI,        /* 0x6c71 */
    KANJI,        /* 0x6c72 */
    KANJI,        /* 0x6c73 */
    KANJI,        /* 0x6c74 */
    KANJI,        /* 0x6c75 */
    KANJI,        /* 0x6c76 */
    KANJI,        /* 0x6c77 */
    KANJI,        /* 0x6c78 */
    KANJI,        /* 0x6c79 */
    KANJI,        /* 0x6c7a */
    KANJI,        /* 0x6c7b */
    KANJI,        /* 0x6c7c */
    KANJI,        /* 0x6c7d */
    KANJI,        /* 0x6c7e */
    KANJI,        /* 0x6c7f */
    KANJI,        /* 0x6c80 */
    KANJI,        /* 0x6c81 */
    KANJI,        /* 0x6c82 */
    KANJI,        /* 0x6c83 */
    KANJI,        /* 0x6c84 */
    KANJI,        /* 0x6c85 */
    KANJI,        /* 0x6c86 */
    KANJI,        /* 0x6c87 */
    KANJI,        /* 0x6c88 */
    KANJI,        /* 0x6c89 */
    KANJI,        /* 0x6c8a */
    KANJI,        /* 0x6c8b */
    KANJI,        /* 0x6c8c */
    KANJI,        /* 0x6c8d */
    KANJI,        /* 0x6c8e */
    KANJI,        /* 0x6c8f */
    KANJI,        /* 0x6c90 */
    KANJI,        /* 0x6c91 */
    KANJI,        /* 0x6c92 */
    KANJI,        /* 0x6c93 */
    KANJI,        /* 0x6c94 */
    KANJI,        /* 0x6c95 */
    KANJI,        /* 0x6c96 */
    KANJI,        /* 0x6c97 */
    KANJI,        /* 0x6c98 */
    KANJI,        /* 0x6c99 */
    KANJI,        /* 0x6c9a */
    KANJI,        /* 0x6c9b */
    KANJI,        /* 0x6c9c */
    KANJI,        /* 0x6c9d */
    KANJI,        /* 0x6c9e */
    KANJI,        /* 0x6c9f */
    KANJI,        /* 0x6ca0 */
    KANJI,        /* 0x6ca1 */
    KANJI,        /* 0x6ca2 */
    KANJI,        /* 0x6ca3 */
    KANJI,        /* 0x6ca4 */
    KANJI,        /* 0x6ca5 */
    KANJI,        /* 0x6ca6 */
    KANJI,        /* 0x6ca7 */
    KANJI,        /* 0x6ca8 */
    KANJI,        /* 0x6ca9 */
    KANJI,        /* 0x6caa */
    KANJI,        /* 0x6cab */
    KANJI,        /* 0x6cac */
    KANJI,        /* 0x6cad */
    KANJI,        /* 0x6cae */
    KANJI,        /* 0x6caf */
    KANJI,        /* 0x6cb0 */
    KANJI,        /* 0x6cb1 */
    KANJI,        /* 0x6cb2 */
    KANJI,        /* 0x6cb3 */
    KANJI,        /* 0x6cb4 */
    KANJI,        /* 0x6cb5 */
    KANJI,        /* 0x6cb6 */
    KANJI,        /* 0x6cb7 */
    KANJI,        /* 0x6cb8 */
    KANJI,        /* 0x6cb9 */
    KANJI,        /* 0x6cba */
    KANJI,        /* 0x6cbb */
    KANJI,        /* 0x6cbc */
    KANJI,        /* 0x6cbd */
    KANJI,        /* 0x6cbe */
    KANJI,        /* 0x6cbf */
    KANJI,        /* 0x6cc0 */
    KANJI,        /* 0x6cc1 */
    KANJI,        /* 0x6cc2 */
    KANJI,        /* 0x6cc3 */
    KANJI,        /* 0x6cc4 */
    KANJI,        /* 0x6cc5 */
    KANJI,        /* 0x6cc6 */
    KANJI,        /* 0x6cc7 */
    KANJI,        /* 0x6cc8 */
    KANJI,        /* 0x6cc9 */
    KANJI,        /* 0x6cca */
    KANJI,        /* 0x6ccb */
    KANJI,        /* 0x6ccc */
    KANJI,        /* 0x6ccd */
    KANJI,        /* 0x6cce */
    KANJI,        /* 0x6ccf */
    KANJI,        /* 0x6cd0 */
    KANJI,        /* 0x6cd1 */
    KANJI,        /* 0x6cd2 */
    KANJI,        /* 0x6cd3 */
    KANJI,        /* 0x6cd4 */
    KANJI,        /* 0x6cd5 */
    KANJI,        /* 0x6cd6 */
    KANJI,        /* 0x6cd7 */
    KANJI,        /* 0x6cd8 */
    KANJI,        /* 0x6cd9 */
    KANJI,        /* 0x6cda */
    KANJI,        /* 0x6cdb */
    KANJI,        /* 0x6cdc */
    KANJI,        /* 0x6cdd */
    KANJI,        /* 0x6cde */
    KANJI,        /* 0x6cdf */
    KANJI,        /* 0x6ce0 */
    KANJI,        /* 0x6ce1 */
    KANJI,        /* 0x6ce2 */
    KANJI,        /* 0x6ce3 */
    KANJI,        /* 0x6ce4 */
    KANJI,        /* 0x6ce5 */
    KANJI,        /* 0x6ce6 */
    KANJI,        /* 0x6ce7 */
    KANJI,        /* 0x6ce8 */
    KANJI,        /* 0x6ce9 */
    KANJI,        /* 0x6cea */
    KANJI,        /* 0x6ceb */
    KANJI,        /* 0x6cec */
    KANJI,        /* 0x6ced */
    KANJI,        /* 0x6cee */
    KANJI,        /* 0x6cef */
    KANJI,        /* 0x6cf0 */
    KANJI,        /* 0x6cf1 */
    KANJI,        /* 0x6cf2 */
    KANJI,        /* 0x6cf3 */
    KANJI,        /* 0x6cf4 */
    KANJI,        /* 0x6cf5 */
    KANJI,        /* 0x6cf6 */
    KANJI,        /* 0x6cf7 */
    KANJI,        /* 0x6cf8 */
    KANJI,        /* 0x6cf9 */
    KANJI,        /* 0x6cfa */
    KANJI,        /* 0x6cfb */
    KANJI,        /* 0x6cfc */
    KANJI,        /* 0x6cfd */
    KANJI,        /* 0x6cfe */
    KANJI,        /* 0x6cff */
    KANJI,        /* 0x6d00 */
    KANJI,        /* 0x6d01 */
    KANJI,        /* 0x6d02 */
    KANJI,        /* 0x6d03 */
    KANJI,        /* 0x6d04 */
    KANJI,        /* 0x6d05 */
    KANJI,        /* 0x6d06 */
    KANJI,        /* 0x6d07 */
    KANJI,        /* 0x6d08 */
    KANJI,        /* 0x6d09 */
    KANJI,        /* 0x6d0a */
    KANJI,        /* 0x6d0b */
    KANJI,        /* 0x6d0c */
    KANJI,        /* 0x6d0d */
    KANJI,        /* 0x6d0e */
    KANJI,        /* 0x6d0f */
    KANJI,        /* 0x6d10 */
    KANJI,        /* 0x6d11 */
    KANJI,        /* 0x6d12 */
    KANJI,        /* 0x6d13 */
    KANJI,        /* 0x6d14 */
    KANJI,        /* 0x6d15 */
    KANJI,        /* 0x6d16 */
    KANJI,        /* 0x6d17 */
    KANJI,        /* 0x6d18 */
    KANJI,        /* 0x6d19 */
    KANJI,        /* 0x6d1a */
    KANJI,        /* 0x6d1b */
    KANJI,        /* 0x6d1c */
    KANJI,        /* 0x6d1d */
    KANJI,        /* 0x6d1e */
    KANJI,        /* 0x6d1f */
    KANJI,        /* 0x6d20 */
    KANJI,        /* 0x6d21 */
    KANJI,        /* 0x6d22 */
    KANJI,        /* 0x6d23 */
    KANJI,        /* 0x6d24 */
    KANJI,        /* 0x6d25 */
    KANJI,        /* 0x6d26 */
    KANJI,        /* 0x6d27 */
    KANJI,        /* 0x6d28 */
    KANJI,        /* 0x6d29 */
    KANJI,        /* 0x6d2a */
    KANJI,        /* 0x6d2b */
    KANJI,        /* 0x6d2c */
    KANJI,        /* 0x6d2d */
    KANJI,        /* 0x6d2e */
    KANJI,        /* 0x6d2f */
    KANJI,        /* 0x6d30 */
    KANJI,        /* 0x6d31 */
    KANJI,        /* 0x6d32 */
    KANJI,        /* 0x6d33 */
    KANJI,        /* 0x6d34 */
    KANJI,        /* 0x6d35 */
    KANJI,        /* 0x6d36 */
    KANJI,        /* 0x6d37 */
    KANJI,        /* 0x6d38 */
    KANJI,        /* 0x6d39 */
    KANJI,        /* 0x6d3a */
    KANJI,        /* 0x6d3b */
    KANJI,        /* 0x6d3c */
    KANJI,        /* 0x6d3d */
    KANJI,        /* 0x6d3e */
    KANJI,        /* 0x6d3f */
    KANJI,        /* 0x6d40 */
    KANJI,        /* 0x6d41 */
    KANJI,        /* 0x6d42 */
    KANJI,        /* 0x6d43 */
    KANJI,        /* 0x6d44 */
    KANJI,        /* 0x6d45 */
    KANJI,        /* 0x6d46 */
    KANJI,        /* 0x6d47 */
    KANJI,        /* 0x6d48 */
    KANJI,        /* 0x6d49 */
    KANJI,        /* 0x6d4a */
    KANJI,        /* 0x6d4b */
    KANJI,        /* 0x6d4c */
    KANJI,        /* 0x6d4d */
    KANJI,        /* 0x6d4e */
    KANJI,        /* 0x6d4f */
    KANJI,        /* 0x6d50 */
    KANJI,        /* 0x6d51 */
    KANJI,        /* 0x6d52 */
    KANJI,        /* 0x6d53 */
    KANJI,        /* 0x6d54 */
    KANJI,        /* 0x6d55 */
    KANJI,        /* 0x6d56 */
    KANJI,        /* 0x6d57 */
    KANJI,        /* 0x6d58 */
    KANJI,        /* 0x6d59 */
    KANJI,        /* 0x6d5a */
    KANJI,        /* 0x6d5b */
    KANJI,        /* 0x6d5c */
    KANJI,        /* 0x6d5d */
    KANJI,        /* 0x6d5e */
    KANJI,        /* 0x6d5f */
    KANJI,        /* 0x6d60 */
    KANJI,        /* 0x6d61 */
    KANJI,        /* 0x6d62 */
    KANJI,        /* 0x6d63 */
    KANJI,        /* 0x6d64 */
    KANJI,        /* 0x6d65 */
    KANJI,        /* 0x6d66 */
    KANJI,        /* 0x6d67 */
    KANJI,        /* 0x6d68 */
    KANJI,        /* 0x6d69 */
    KANJI,        /* 0x6d6a */
    KANJI,        /* 0x6d6b */
    KANJI,        /* 0x6d6c */
    KANJI,        /* 0x6d6d */
    KANJI,        /* 0x6d6e */
    KANJI,        /* 0x6d6f */
    KANJI,        /* 0x6d70 */
    KANJI,        /* 0x6d71 */
    KANJI,        /* 0x6d72 */
    KANJI,        /* 0x6d73 */
    KANJI,        /* 0x6d74 */
    KANJI,        /* 0x6d75 */
    KANJI,        /* 0x6d76 */
    KANJI,        /* 0x6d77 */
    KANJI,        /* 0x6d78 */
    KANJI,        /* 0x6d79 */
    KANJI,        /* 0x6d7a */
    KANJI,        /* 0x6d7b */
    KANJI,        /* 0x6d7c */
    KANJI,        /* 0x6d7d */
    KANJI,        /* 0x6d7e */
    KANJI,        /* 0x6d7f */
    KANJI,        /* 0x6d80 */
    KANJI,        /* 0x6d81 */
    KANJI,        /* 0x6d82 */
    KANJI,        /* 0x6d83 */
    KANJI,        /* 0x6d84 */
    KANJI,        /* 0x6d85 */
    KANJI,        /* 0x6d86 */
    KANJI,        /* 0x6d87 */
    KANJI,        /* 0x6d88 */
    KANJI,        /* 0x6d89 */
    KANJI,        /* 0x6d8a */
    KANJI,        /* 0x6d8b */
    KANJI,        /* 0x6d8c */
    KANJI,        /* 0x6d8d */
    KANJI,        /* 0x6d8e */
    KANJI,        /* 0x6d8f */
    KANJI,        /* 0x6d90 */
    KANJI,        /* 0x6d91 */
    KANJI,        /* 0x6d92 */
    KANJI,        /* 0x6d93 */
    KANJI,        /* 0x6d94 */
    KANJI,        /* 0x6d95 */
    KANJI,        /* 0x6d96 */
    KANJI,        /* 0x6d97 */
    KANJI,        /* 0x6d98 */
    KANJI,        /* 0x6d99 */
    KANJI,        /* 0x6d9a */
    KANJI,        /* 0x6d9b */
    KANJI,        /* 0x6d9c */
    KANJI,        /* 0x6d9d */
    KANJI,        /* 0x6d9e */
    KANJI,        /* 0x6d9f */
    KANJI,        /* 0x6da0 */
    KANJI,        /* 0x6da1 */
    KANJI,        /* 0x6da2 */
    KANJI,        /* 0x6da3 */
    KANJI,        /* 0x6da4 */
    KANJI,        /* 0x6da5 */
    KANJI,        /* 0x6da6 */
    KANJI,        /* 0x6da7 */
    KANJI,        /* 0x6da8 */
    KANJI,        /* 0x6da9 */
    KANJI,        /* 0x6daa */
    KANJI,        /* 0x6dab */
    KANJI,        /* 0x6dac */
    KANJI,        /* 0x6dad */
    KANJI,        /* 0x6dae */
    KANJI,        /* 0x6daf */
    KANJI,        /* 0x6db0 */
    KANJI,        /* 0x6db1 */
    KANJI,        /* 0x6db2 */
    KANJI,        /* 0x6db3 */
    KANJI,        /* 0x6db4 */
    KANJI,        /* 0x6db5 */
    KANJI,        /* 0x6db6 */
    KANJI,        /* 0x6db7 */
    KANJI,        /* 0x6db8 */
    KANJI,        /* 0x6db9 */
    KANJI,        /* 0x6dba */
    KANJI,        /* 0x6dbb */
    KANJI,        /* 0x6dbc */
    KANJI,        /* 0x6dbd */
    KANJI,        /* 0x6dbe */
    KANJI,        /* 0x6dbf */
    KANJI,        /* 0x6dc0 */
    KANJI,        /* 0x6dc1 */
    KANJI,        /* 0x6dc2 */
    KANJI,        /* 0x6dc3 */
    KANJI,        /* 0x6dc4 */
    KANJI,        /* 0x6dc5 */
    KANJI,        /* 0x6dc6 */
    KANJI,        /* 0x6dc7 */
    KANJI,        /* 0x6dc8 */
    KANJI,        /* 0x6dc9 */
    KANJI,        /* 0x6dca */
    KANJI,        /* 0x6dcb */
    KANJI,        /* 0x6dcc */
    KANJI,        /* 0x6dcd */
    KANJI,        /* 0x6dce */
    KANJI,        /* 0x6dcf */
    KANJI,        /* 0x6dd0 */
    KANJI,        /* 0x6dd1 */
    KANJI,        /* 0x6dd2 */
    KANJI,        /* 0x6dd3 */
    KANJI,        /* 0x6dd4 */
    KANJI,        /* 0x6dd5 */
    KANJI,        /* 0x6dd6 */
    KANJI,        /* 0x6dd7 */
    KANJI,        /* 0x6dd8 */
    KANJI,        /* 0x6dd9 */
    KANJI,        /* 0x6dda */
    KANJI,        /* 0x6ddb */
    KANJI,        /* 0x6ddc */
    KANJI,        /* 0x6ddd */
    KANJI,        /* 0x6dde */
    KANJI,        /* 0x6ddf */
    KANJI,        /* 0x6de0 */
    KANJI,        /* 0x6de1 */
    KANJI,        /* 0x6de2 */
    KANJI,        /* 0x6de3 */
    KANJI,        /* 0x6de4 */
    KANJI,        /* 0x6de5 */
    KANJI,        /* 0x6de6 */
    KANJI,        /* 0x6de7 */
    KANJI,        /* 0x6de8 */
    KANJI,        /* 0x6de9 */
    KANJI,        /* 0x6dea */
    KANJI,        /* 0x6deb */
    KANJI,        /* 0x6dec */
    KANJI,        /* 0x6ded */
    KANJI,        /* 0x6dee */
    KANJI,        /* 0x6def */
    KANJI,        /* 0x6df0 */
    KANJI,        /* 0x6df1 */
    KANJI,        /* 0x6df2 */
    KANJI,        /* 0x6df3 */
    KANJI,        /* 0x6df4 */
    KANJI,        /* 0x6df5 */
    KANJI,        /* 0x6df6 */
    KANJI,        /* 0x6df7 */
    KANJI,        /* 0x6df8 */
    KANJI,        /* 0x6df9 */
    KANJI,        /* 0x6dfa */
    KANJI,        /* 0x6dfb */
    KANJI,        /* 0x6dfc */
    KANJI,        /* 0x6dfd */
    KANJI,        /* 0x6dfe */
    KANJI,        /* 0x6dff */
    KANJI,        /* 0x6e00 */
    KANJI,        /* 0x6e01 */
    KANJI,        /* 0x6e02 */
    KANJI,        /* 0x6e03 */
    KANJI,        /* 0x6e04 */
    KANJI,        /* 0x6e05 */
    KANJI,        /* 0x6e06 */
    KANJI,        /* 0x6e07 */
    KANJI,        /* 0x6e08 */
    KANJI,        /* 0x6e09 */
    KANJI,        /* 0x6e0a */
    KANJI,        /* 0x6e0b */
    KANJI,        /* 0x6e0c */
    KANJI,        /* 0x6e0d */
    KANJI,        /* 0x6e0e */
    KANJI,        /* 0x6e0f */
    KANJI,        /* 0x6e10 */
    KANJI,        /* 0x6e11 */
    KANJI,        /* 0x6e12 */
    KANJI,        /* 0x6e13 */
    KANJI,        /* 0x6e14 */
    KANJI,        /* 0x6e15 */
    KANJI,        /* 0x6e16 */
    KANJI,        /* 0x6e17 */
    KANJI,        /* 0x6e18 */
    KANJI,        /* 0x6e19 */
    KANJI,        /* 0x6e1a */
    KANJI,        /* 0x6e1b */
    KANJI,        /* 0x6e1c */
    KANJI,        /* 0x6e1d */
    KANJI,        /* 0x6e1e */
    KANJI,        /* 0x6e1f */
    KANJI,        /* 0x6e20 */
    KANJI,        /* 0x6e21 */
    KANJI,        /* 0x6e22 */
    KANJI,        /* 0x6e23 */
    KANJI,        /* 0x6e24 */
    KANJI,        /* 0x6e25 */
    KANJI,        /* 0x6e26 */
    KANJI,        /* 0x6e27 */
    KANJI,        /* 0x6e28 */
    KANJI,        /* 0x6e29 */
    KANJI,        /* 0x6e2a */
    KANJI,        /* 0x6e2b */
    KANJI,        /* 0x6e2c */
    KANJI,        /* 0x6e2d */
    KANJI,        /* 0x6e2e */
    KANJI,        /* 0x6e2f */
    KANJI,        /* 0x6e30 */
    KANJI,        /* 0x6e31 */
    KANJI,        /* 0x6e32 */
    KANJI,        /* 0x6e33 */
    KANJI,        /* 0x6e34 */
    KANJI,        /* 0x6e35 */
    KANJI,        /* 0x6e36 */
    KANJI,        /* 0x6e37 */
    KANJI,        /* 0x6e38 */
    KANJI,        /* 0x6e39 */
    KANJI,        /* 0x6e3a */
    KANJI,        /* 0x6e3b */
    KANJI,        /* 0x6e3c */
    KANJI,        /* 0x6e3d */
    KANJI,        /* 0x6e3e */
    KANJI,        /* 0x6e3f */
    KANJI,        /* 0x6e40 */
    KANJI,        /* 0x6e41 */
    KANJI,        /* 0x6e42 */
    KANJI,        /* 0x6e43 */
    KANJI,        /* 0x6e44 */
    KANJI,        /* 0x6e45 */
    KANJI,        /* 0x6e46 */
    KANJI,        /* 0x6e47 */
    KANJI,        /* 0x6e48 */
    KANJI,        /* 0x6e49 */
    KANJI,        /* 0x6e4a */
    KANJI,        /* 0x6e4b */
    KANJI,        /* 0x6e4c */
    KANJI,        /* 0x6e4d */
    KANJI,        /* 0x6e4e */
    KANJI,        /* 0x6e4f */
    KANJI,        /* 0x6e50 */
    KANJI,        /* 0x6e51 */
    KANJI,        /* 0x6e52 */
    KANJI,        /* 0x6e53 */
    KANJI,        /* 0x6e54 */
    KANJI,        /* 0x6e55 */
    KANJI,        /* 0x6e56 */
    KANJI,        /* 0x6e57 */
    KANJI,        /* 0x6e58 */
    KANJI,        /* 0x6e59 */
    KANJI,        /* 0x6e5a */
    KANJI,        /* 0x6e5b */
    KANJI,        /* 0x6e5c */
    KANJI,        /* 0x6e5d */
    KANJI,        /* 0x6e5e */
    KANJI,        /* 0x6e5f */
    KANJI,        /* 0x6e60 */
    KANJI,        /* 0x6e61 */
    KANJI,        /* 0x6e62 */
    KANJI,        /* 0x6e63 */
    KANJI,        /* 0x6e64 */
    KANJI,        /* 0x6e65 */
    KANJI,        /* 0x6e66 */
    KANJI,        /* 0x6e67 */
    KANJI,        /* 0x6e68 */
    KANJI,        /* 0x6e69 */
    KANJI,        /* 0x6e6a */
    KANJI,        /* 0x6e6b */
    KANJI,        /* 0x6e6c */
    KANJI,        /* 0x6e6d */
    KANJI,        /* 0x6e6e */
    KANJI,        /* 0x6e6f */
    KANJI,        /* 0x6e70 */
    KANJI,        /* 0x6e71 */
    KANJI,        /* 0x6e72 */
    KANJI,        /* 0x6e73 */
    KANJI,        /* 0x6e74 */
    KANJI,        /* 0x6e75 */
    KANJI,        /* 0x6e76 */
    KANJI,        /* 0x6e77 */
    KANJI,        /* 0x6e78 */
    KANJI,        /* 0x6e79 */
    KANJI,        /* 0x6e7a */
    KANJI,        /* 0x6e7b */
    KANJI,        /* 0x6e7c */
    KANJI,        /* 0x6e7d */
    KANJI,        /* 0x6e7e */
    KANJI,        /* 0x6e7f */
    KANJI,        /* 0x6e80 */
    KANJI,        /* 0x6e81 */
    KANJI,        /* 0x6e82 */
    KANJI,        /* 0x6e83 */
    KANJI,        /* 0x6e84 */
    KANJI,        /* 0x6e85 */
    KANJI,        /* 0x6e86 */
    KANJI,        /* 0x6e87 */
    KANJI,        /* 0x6e88 */
    KANJI,        /* 0x6e89 */
    KANJI,        /* 0x6e8a */
    KANJI,        /* 0x6e8b */
    KANJI,        /* 0x6e8c */
    KANJI,        /* 0x6e8d */
    KANJI,        /* 0x6e8e */
    KANJI,        /* 0x6e8f */
    KANJI,        /* 0x6e90 */
    KANJI,        /* 0x6e91 */
    KANJI,        /* 0x6e92 */
    KANJI,        /* 0x6e93 */
    KANJI,        /* 0x6e94 */
    KANJI,        /* 0x6e95 */
    KANJI,        /* 0x6e96 */
    KANJI,        /* 0x6e97 */
    KANJI,        /* 0x6e98 */
    KANJI,        /* 0x6e99 */
    KANJI,        /* 0x6e9a */
    KANJI,        /* 0x6e9b */
    KANJI,        /* 0x6e9c */
    KANJI,        /* 0x6e9d */
    KANJI,        /* 0x6e9e */
    KANJI,        /* 0x6e9f */
    KANJI,        /* 0x6ea0 */
    KANJI,        /* 0x6ea1 */
    KANJI,        /* 0x6ea2 */
    KANJI,        /* 0x6ea3 */
    KANJI,        /* 0x6ea4 */
    KANJI,        /* 0x6ea5 */
    KANJI,        /* 0x6ea6 */
    KANJI,        /* 0x6ea7 */
    KANJI,        /* 0x6ea8 */
    KANJI,        /* 0x6ea9 */
    KANJI,        /* 0x6eaa */
    KANJI,        /* 0x6eab */
    KANJI,        /* 0x6eac */
    KANJI,        /* 0x6ead */
    KANJI,        /* 0x6eae */
    KANJI,        /* 0x6eaf */
    KANJI,        /* 0x6eb0 */
    KANJI,        /* 0x6eb1 */
    KANJI,        /* 0x6eb2 */
    KANJI,        /* 0x6eb3 */
    KANJI,        /* 0x6eb4 */
    KANJI,        /* 0x6eb5 */
    KANJI,        /* 0x6eb6 */
    KANJI,        /* 0x6eb7 */
    KANJI,        /* 0x6eb8 */
    KANJI,        /* 0x6eb9 */
    KANJI,        /* 0x6eba */
    KANJI,        /* 0x6ebb */
    KANJI,        /* 0x6ebc */
    KANJI,        /* 0x6ebd */
    KANJI,        /* 0x6ebe */
    KANJI,        /* 0x6ebf */
    KANJI,        /* 0x6ec0 */
    KANJI,        /* 0x6ec1 */
    KANJI,        /* 0x6ec2 */
    KANJI,        /* 0x6ec3 */
    KANJI,        /* 0x6ec4 */
    KANJI,        /* 0x6ec5 */
    KANJI,        /* 0x6ec6 */
    KANJI,        /* 0x6ec7 */
    KANJI,        /* 0x6ec8 */
    KANJI,        /* 0x6ec9 */
    KANJI,        /* 0x6eca */
    KANJI,        /* 0x6ecb */
    KANJI,        /* 0x6ecc */
    KANJI,        /* 0x6ecd */
    KANJI,        /* 0x6ece */
    KANJI,        /* 0x6ecf */
    KANJI,        /* 0x6ed0 */
    KANJI,        /* 0x6ed1 */
    KANJI,        /* 0x6ed2 */
    KANJI,        /* 0x6ed3 */
    KANJI,        /* 0x6ed4 */
    KANJI,        /* 0x6ed5 */
    KANJI,        /* 0x6ed6 */
    KANJI,        /* 0x6ed7 */
    KANJI,        /* 0x6ed8 */
    KANJI,        /* 0x6ed9 */
    KANJI,        /* 0x6eda */
    KANJI,        /* 0x6edb */
    KANJI,        /* 0x6edc */
    KANJI,        /* 0x6edd */
    KANJI,        /* 0x6ede */
    KANJI,        /* 0x6edf */
    KANJI,        /* 0x6ee0 */
    KANJI,        /* 0x6ee1 */
    KANJI,        /* 0x6ee2 */
    KANJI,        /* 0x6ee3 */
    KANJI,        /* 0x6ee4 */
    KANJI,        /* 0x6ee5 */
    KANJI,        /* 0x6ee6 */
    KANJI,        /* 0x6ee7 */
    KANJI,        /* 0x6ee8 */
    KANJI,        /* 0x6ee9 */
    KANJI,        /* 0x6eea */
    KANJI,        /* 0x6eeb */
    KANJI,        /* 0x6eec */
    KANJI,        /* 0x6eed */
    KANJI,        /* 0x6eee */
    KANJI,        /* 0x6eef */
    KANJI,        /* 0x6ef0 */
    KANJI,        /* 0x6ef1 */
    KANJI,        /* 0x6ef2 */
    KANJI,        /* 0x6ef3 */
    KANJI,        /* 0x6ef4 */
    KANJI,        /* 0x6ef5 */
    KANJI,        /* 0x6ef6 */
    KANJI,        /* 0x6ef7 */
    KANJI,        /* 0x6ef8 */
    KANJI,        /* 0x6ef9 */
    KANJI,        /* 0x6efa */
    KANJI,        /* 0x6efb */
    KANJI,        /* 0x6efc */
    KANJI,        /* 0x6efd */
    KANJI,        /* 0x6efe */
    KANJI,        /* 0x6eff */
    KANJI,        /* 0x6f00 */
    KANJI,        /* 0x6f01 */
    KANJI,        /* 0x6f02 */
    KANJI,        /* 0x6f03 */
    KANJI,        /* 0x6f04 */
    KANJI,        /* 0x6f05 */
    KANJI,        /* 0x6f06 */
    KANJI,        /* 0x6f07 */
    KANJI,        /* 0x6f08 */
    KANJI,        /* 0x6f09 */
    KANJI,        /* 0x6f0a */
    KANJI,        /* 0x6f0b */
    KANJI,        /* 0x6f0c */
    KANJI,        /* 0x6f0d */
    KANJI,        /* 0x6f0e */
    KANJI,        /* 0x6f0f */
    KANJI,        /* 0x6f10 */
    KANJI,        /* 0x6f11 */
    KANJI,        /* 0x6f12 */
    KANJI,        /* 0x6f13 */
    KANJI,        /* 0x6f14 */
    KANJI,        /* 0x6f15 */
    KANJI,        /* 0x6f16 */
    KANJI,        /* 0x6f17 */
    KANJI,        /* 0x6f18 */
    KANJI,        /* 0x6f19 */
    KANJI,        /* 0x6f1a */
    KANJI,        /* 0x6f1b */
    KANJI,        /* 0x6f1c */
    KANJI,        /* 0x6f1d */
    KANJI,        /* 0x6f1e */
    KANJI,        /* 0x6f1f */
    KANJI,        /* 0x6f20 */
    KANJI,        /* 0x6f21 */
    KANJI,        /* 0x6f22 */
    KANJI,        /* 0x6f23 */
    KANJI,        /* 0x6f24 */
    KANJI,        /* 0x6f25 */
    KANJI,        /* 0x6f26 */
    KANJI,        /* 0x6f27 */
    KANJI,        /* 0x6f28 */
    KANJI,        /* 0x6f29 */
    KANJI,        /* 0x6f2a */
    KANJI,        /* 0x6f2b */
    KANJI,        /* 0x6f2c */
    KANJI,        /* 0x6f2d */
    KANJI,        /* 0x6f2e */
    KANJI,        /* 0x6f2f */
    KANJI,        /* 0x6f30 */
    KANJI,        /* 0x6f31 */
    KANJI,        /* 0x6f32 */
    KANJI,        /* 0x6f33 */
    KANJI,        /* 0x6f34 */
    KANJI,        /* 0x6f35 */
    KANJI,        /* 0x6f36 */
    KANJI,        /* 0x6f37 */
    KANJI,        /* 0x6f38 */
    KANJI,        /* 0x6f39 */
    KANJI,        /* 0x6f3a */
    KANJI,        /* 0x6f3b */
    KANJI,        /* 0x6f3c */
    KANJI,        /* 0x6f3d */
    KANJI,        /* 0x6f3e */
    KANJI,        /* 0x6f3f */
    KANJI,        /* 0x6f40 */
    KANJI,        /* 0x6f41 */
    KANJI,        /* 0x6f42 */
    KANJI,        /* 0x6f43 */
    KANJI,        /* 0x6f44 */
    KANJI,        /* 0x6f45 */
    KANJI,        /* 0x6f46 */
    KANJI,        /* 0x6f47 */
    KANJI,        /* 0x6f48 */
    KANJI,        /* 0x6f49 */
    KANJI,        /* 0x6f4a */
    KANJI,        /* 0x6f4b */
    KANJI,        /* 0x6f4c */
    KANJI,        /* 0x6f4d */
    KANJI,        /* 0x6f4e */
    KANJI,        /* 0x6f4f */
    KANJI,        /* 0x6f50 */
    KANJI,        /* 0x6f51 */
    KANJI,        /* 0x6f52 */
    KANJI,        /* 0x6f53 */
    KANJI,        /* 0x6f54 */
    KANJI,        /* 0x6f55 */
    KANJI,        /* 0x6f56 */
    KANJI,        /* 0x6f57 */
    KANJI,        /* 0x6f58 */
    KANJI,        /* 0x6f59 */
    KANJI,        /* 0x6f5a */
    KANJI,        /* 0x6f5b */
    KANJI,        /* 0x6f5c */
    KANJI,        /* 0x6f5d */
    KANJI,        /* 0x6f5e */
    KANJI,        /* 0x6f5f */
    KANJI,        /* 0x6f60 */
    KANJI,        /* 0x6f61 */
    KANJI,        /* 0x6f62 */
    KANJI,        /* 0x6f63 */
    KANJI,        /* 0x6f64 */
    KANJI,        /* 0x6f65 */
    KANJI,        /* 0x6f66 */
    KANJI,        /* 0x6f67 */
    KANJI,        /* 0x6f68 */
    KANJI,        /* 0x6f69 */
    KANJI,        /* 0x6f6a */
    KANJI,        /* 0x6f6b */
    KANJI,        /* 0x6f6c */
    KANJI,        /* 0x6f6d */
    KANJI,        /* 0x6f6e */
    KANJI,        /* 0x6f6f */
    KANJI,        /* 0x6f70 */
    KANJI,        /* 0x6f71 */
    KANJI,        /* 0x6f72 */
    KANJI,        /* 0x6f73 */
    KANJI,        /* 0x6f74 */
    KANJI,        /* 0x6f75 */
    KANJI,        /* 0x6f76 */
    KANJI,        /* 0x6f77 */
    KANJI,        /* 0x6f78 */
    KANJI,        /* 0x6f79 */
    KANJI,        /* 0x6f7a */
    KANJI,        /* 0x6f7b */
    KANJI,        /* 0x6f7c */
    KANJI,        /* 0x6f7d */
    KANJI,        /* 0x6f7e */
    KANJI,        /* 0x6f7f */
    KANJI,        /* 0x6f80 */
    KANJI,        /* 0x6f81 */
    KANJI,        /* 0x6f82 */
    KANJI,        /* 0x6f83 */
    KANJI,        /* 0x6f84 */
    KANJI,        /* 0x6f85 */
    KANJI,        /* 0x6f86 */
    KANJI,        /* 0x6f87 */
    KANJI,        /* 0x6f88 */
    KANJI,        /* 0x6f89 */
    KANJI,        /* 0x6f8a */
    KANJI,        /* 0x6f8b */
    KANJI,        /* 0x6f8c */
    KANJI,        /* 0x6f8d */
    KANJI,        /* 0x6f8e */
    KANJI,        /* 0x6f8f */
    KANJI,        /* 0x6f90 */
    KANJI,        /* 0x6f91 */
    KANJI,        /* 0x6f92 */
    KANJI,        /* 0x6f93 */
    KANJI,        /* 0x6f94 */
    KANJI,        /* 0x6f95 */
    KANJI,        /* 0x6f96 */
    KANJI,        /* 0x6f97 */
    KANJI,        /* 0x6f98 */
    KANJI,        /* 0x6f99 */
    KANJI,        /* 0x6f9a */
    KANJI,        /* 0x6f9b */
    KANJI,        /* 0x6f9c */
    KANJI,        /* 0x6f9d */
    KANJI,        /* 0x6f9e */
    KANJI,        /* 0x6f9f */
    KANJI,        /* 0x6fa0 */
    KANJI,        /* 0x6fa1 */
    KANJI,        /* 0x6fa2 */
    KANJI,        /* 0x6fa3 */
    KANJI,        /* 0x6fa4 */
    KANJI,        /* 0x6fa5 */
    KANJI,        /* 0x6fa6 */
    KANJI,        /* 0x6fa7 */
    KANJI,        /* 0x6fa8 */
    KANJI,        /* 0x6fa9 */
    KANJI,        /* 0x6faa */
    KANJI,        /* 0x6fab */
    KANJI,        /* 0x6fac */
    KANJI,        /* 0x6fad */
    KANJI,        /* 0x6fae */
    KANJI,        /* 0x6faf */
    KANJI,        /* 0x6fb0 */
    KANJI,        /* 0x6fb1 */
    KANJI,        /* 0x6fb2 */
    KANJI,        /* 0x6fb3 */
    KANJI,        /* 0x6fb4 */
    KANJI,        /* 0x6fb5 */
    KANJI,        /* 0x6fb6 */
    KANJI,        /* 0x6fb7 */
    KANJI,        /* 0x6fb8 */
    KANJI,        /* 0x6fb9 */
    KANJI,        /* 0x6fba */
    KANJI,        /* 0x6fbb */
    KANJI,        /* 0x6fbc */
    KANJI,        /* 0x6fbd */
    KANJI,        /* 0x6fbe */
    KANJI,        /* 0x6fbf */
    KANJI,        /* 0x6fc0 */
    KANJI,        /* 0x6fc1 */
    KANJI,        /* 0x6fc2 */
    KANJI,        /* 0x6fc3 */
    KANJI,        /* 0x6fc4 */
    KANJI,        /* 0x6fc5 */
    KANJI,        /* 0x6fc6 */
    KANJI,        /* 0x6fc7 */
    KANJI,        /* 0x6fc8 */
    KANJI,        /* 0x6fc9 */
    KANJI,        /* 0x6fca */
    KANJI,        /* 0x6fcb */
    KANJI,        /* 0x6fcc */
    KANJI,        /* 0x6fcd */
    KANJI,        /* 0x6fce */
    KANJI,        /* 0x6fcf */
    KANJI,        /* 0x6fd0 */
    KANJI,        /* 0x6fd1 */
    KANJI,        /* 0x6fd2 */
    KANJI,        /* 0x6fd3 */
    KANJI,        /* 0x6fd4 */
    KANJI,        /* 0x6fd5 */
    KANJI,        /* 0x6fd6 */
    KANJI,        /* 0x6fd7 */
    KANJI,        /* 0x6fd8 */
    KANJI,        /* 0x6fd9 */
    KANJI,        /* 0x6fda */
    KANJI,        /* 0x6fdb */
    KANJI,        /* 0x6fdc */
    KANJI,        /* 0x6fdd */
    KANJI,        /* 0x6fde */
    KANJI,        /* 0x6fdf */
    KANJI,        /* 0x6fe0 */
    KANJI,        /* 0x6fe1 */
    KANJI,        /* 0x6fe2 */
    KANJI,        /* 0x6fe3 */
    KANJI,        /* 0x6fe4 */
    KANJI,        /* 0x6fe5 */
    KANJI,        /* 0x6fe6 */
    KANJI,        /* 0x6fe7 */
    KANJI,        /* 0x6fe8 */
    KANJI,        /* 0x6fe9 */
    KANJI,        /* 0x6fea */
    KANJI,        /* 0x6feb */
    KANJI,        /* 0x6fec */
    KANJI,        /* 0x6fed */
    KANJI,        /* 0x6fee */
    KANJI,        /* 0x6fef */
    KANJI,        /* 0x6ff0 */
    KANJI,        /* 0x6ff1 */
    KANJI,        /* 0x6ff2 */
    KANJI,        /* 0x6ff3 */
    KANJI,        /* 0x6ff4 */
    KANJI,        /* 0x6ff5 */
    KANJI,        /* 0x6ff6 */
    KANJI,        /* 0x6ff7 */
    KANJI,        /* 0x6ff8 */
    KANJI,        /* 0x6ff9 */
    KANJI,        /* 0x6ffa */
    KANJI,        /* 0x6ffb */
    KANJI,        /* 0x6ffc */
    KANJI,        /* 0x6ffd */
    KANJI,        /* 0x6ffe */
    KANJI,        /* 0x6fff */
    KANJI,        /* 0x7000 */
    KANJI,        /* 0x7001 */
    KANJI,        /* 0x7002 */
    KANJI,        /* 0x7003 */
    KANJI,        /* 0x7004 */
    KANJI,        /* 0x7005 */
    KANJI,        /* 0x7006 */
    KANJI,        /* 0x7007 */
    KANJI,        /* 0x7008 */
    KANJI,        /* 0x7009 */
    KANJI,        /* 0x700a */
    KANJI,        /* 0x700b */
    KANJI,        /* 0x700c */
    KANJI,        /* 0x700d */
    KANJI,        /* 0x700e */
    KANJI,        /* 0x700f */
    KANJI,        /* 0x7010 */
    KANJI,        /* 0x7011 */
    KANJI,        /* 0x7012 */
    KANJI,        /* 0x7013 */
    KANJI,        /* 0x7014 */
    KANJI,        /* 0x7015 */
    KANJI,        /* 0x7016 */
    KANJI,        /* 0x7017 */
    KANJI,        /* 0x7018 */
    KANJI,        /* 0x7019 */
    KANJI,        /* 0x701a */
    KANJI,        /* 0x701b */
    KANJI,        /* 0x701c */
    KANJI,        /* 0x701d */
    KANJI,        /* 0x701e */
    KANJI,        /* 0x701f */
    KANJI,        /* 0x7020 */
    KANJI,        /* 0x7021 */
    KANJI,        /* 0x7022 */
    KANJI,        /* 0x7023 */
    KANJI,        /* 0x7024 */
    KANJI,        /* 0x7025 */
    KANJI,        /* 0x7026 */
    KANJI,        /* 0x7027 */
    KANJI,        /* 0x7028 */
    KANJI,        /* 0x7029 */
    KANJI,        /* 0x702a */
    KANJI,        /* 0x702b */
    KANJI,        /* 0x702c */
    KANJI,        /* 0x702d */
    KANJI,        /* 0x702e */
    KANJI,        /* 0x702f */
    KANJI,        /* 0x7030 */
    KANJI,        /* 0x7031 */
    KANJI,        /* 0x7032 */
    KANJI,        /* 0x7033 */
    KANJI,        /* 0x7034 */
    KANJI,        /* 0x7035 */
    KANJI,        /* 0x7036 */
    KANJI,        /* 0x7037 */
    KANJI,        /* 0x7038 */
    KANJI,        /* 0x7039 */
    KANJI,        /* 0x703a */
    KANJI,        /* 0x703b */
    KANJI,        /* 0x703c */
    KANJI,        /* 0x703d */
    KANJI,        /* 0x703e */
    KANJI,        /* 0x703f */
    KANJI,        /* 0x7040 */
    KANJI,        /* 0x7041 */
    KANJI,        /* 0x7042 */
    KANJI,        /* 0x7043 */
    KANJI,        /* 0x7044 */
    KANJI,        /* 0x7045 */
    KANJI,        /* 0x7046 */
    KANJI,        /* 0x7047 */
    KANJI,        /* 0x7048 */
    KANJI,        /* 0x7049 */
    KANJI,        /* 0x704a */
    KANJI,        /* 0x704b */
    KANJI,        /* 0x704c */
    KANJI,        /* 0x704d */
    KANJI,        /* 0x704e */
    KANJI,        /* 0x704f */
    KANJI,        /* 0x7050 */
    KANJI,        /* 0x7051 */
    KANJI,        /* 0x7052 */
    KANJI,        /* 0x7053 */
    KANJI,        /* 0x7054 */
    KANJI,        /* 0x7055 */
    KANJI,        /* 0x7056 */
    KANJI,        /* 0x7057 */
    KANJI,        /* 0x7058 */
    KANJI,        /* 0x7059 */
    KANJI,        /* 0x705a */
    KANJI,        /* 0x705b */
    KANJI,        /* 0x705c */
    KANJI,        /* 0x705d */
    KANJI,        /* 0x705e */
    KANJI,        /* 0x705f */
    KANJI,        /* 0x7060 */
    KANJI,        /* 0x7061 */
    KANJI,        /* 0x7062 */
    KANJI,        /* 0x7063 */
    KANJI,        /* 0x7064 */
    KANJI,        /* 0x7065 */
    KANJI,        /* 0x7066 */
    KANJI,        /* 0x7067 */
    KANJI,        /* 0x7068 */
    KANJI,        /* 0x7069 */
    KANJI,        /* 0x706a */
    KANJI,        /* 0x706b */
    KANJI,        /* 0x706c */
    KANJI,        /* 0x706d */
    KANJI,        /* 0x706e */
    KANJI,        /* 0x706f */
    KANJI,        /* 0x7070 */
    KANJI,        /* 0x7071 */
    KANJI,        /* 0x7072 */
    KANJI,        /* 0x7073 */
    KANJI,        /* 0x7074 */
    KANJI,        /* 0x7075 */
    KANJI,        /* 0x7076 */
    KANJI,        /* 0x7077 */
    KANJI,        /* 0x7078 */
    KANJI,        /* 0x7079 */
    KANJI,        /* 0x707a */
    KANJI,        /* 0x707b */
    KANJI,        /* 0x707c */
    KANJI,        /* 0x707d */
    KANJI,        /* 0x707e */
    KANJI,        /* 0x707f */
    KANJI,        /* 0x7080 */
    KANJI,        /* 0x7081 */
    KANJI,        /* 0x7082 */
    KANJI,        /* 0x7083 */
    KANJI,        /* 0x7084 */
    KANJI,        /* 0x7085 */
    KANJI,        /* 0x7086 */
    KANJI,        /* 0x7087 */
    KANJI,        /* 0x7088 */
    KANJI,        /* 0x7089 */
    KANJI,        /* 0x708a */
    KANJI,        /* 0x708b */
    KANJI,        /* 0x708c */
    KANJI,        /* 0x708d */
    KANJI,        /* 0x708e */
    KANJI,        /* 0x708f */
    KANJI,        /* 0x7090 */
    KANJI,        /* 0x7091 */
    KANJI,        /* 0x7092 */
    KANJI,        /* 0x7093 */
    KANJI,        /* 0x7094 */
    KANJI,        /* 0x7095 */
    KANJI,        /* 0x7096 */
    KANJI,        /* 0x7097 */
    KANJI,        /* 0x7098 */
    KANJI,        /* 0x7099 */
    KANJI,        /* 0x709a */
    KANJI,        /* 0x709b */
    KANJI,        /* 0x709c */
    KANJI,        /* 0x709d */
    KANJI,        /* 0x709e */
    KANJI,        /* 0x709f */
    KANJI,        /* 0x70a0 */
    KANJI,        /* 0x70a1 */
    KANJI,        /* 0x70a2 */
    KANJI,        /* 0x70a3 */
    KANJI,        /* 0x70a4 */
    KANJI,        /* 0x70a5 */
    KANJI,        /* 0x70a6 */
    KANJI,        /* 0x70a7 */
    KANJI,        /* 0x70a8 */
    KANJI,        /* 0x70a9 */
    KANJI,        /* 0x70aa */
    KANJI,        /* 0x70ab */
    KANJI,        /* 0x70ac */
    KANJI,        /* 0x70ad */
    KANJI,        /* 0x70ae */
    KANJI,        /* 0x70af */
    KANJI,        /* 0x70b0 */
    KANJI,        /* 0x70b1 */
    KANJI,        /* 0x70b2 */
    KANJI,        /* 0x70b3 */
    KANJI,        /* 0x70b4 */
    KANJI,        /* 0x70b5 */
    KANJI,        /* 0x70b6 */
    KANJI,        /* 0x70b7 */
    KANJI,        /* 0x70b8 */
    KANJI,        /* 0x70b9 */
    KANJI,        /* 0x70ba */
    KANJI,        /* 0x70bb */
    KANJI,        /* 0x70bc */
    KANJI,        /* 0x70bd */
    KANJI,        /* 0x70be */
    KANJI,        /* 0x70bf */
    KANJI,        /* 0x70c0 */
    KANJI,        /* 0x70c1 */
    KANJI,        /* 0x70c2 */
    KANJI,        /* 0x70c3 */
    KANJI,        /* 0x70c4 */
    KANJI,        /* 0x70c5 */
    KANJI,        /* 0x70c6 */
    KANJI,        /* 0x70c7 */
    KANJI,        /* 0x70c8 */
    KANJI,        /* 0x70c9 */
    KANJI,        /* 0x70ca */
    KANJI,        /* 0x70cb */
    KANJI,        /* 0x70cc */
    KANJI,        /* 0x70cd */
    KANJI,        /* 0x70ce */
    KANJI,        /* 0x70cf */
    KANJI,        /* 0x70d0 */
    KANJI,        /* 0x70d1 */
    KANJI,        /* 0x70d2 */
    KANJI,        /* 0x70d3 */
    KANJI,        /* 0x70d4 */
    KANJI,        /* 0x70d5 */
    KANJI,        /* 0x70d6 */
    KANJI,        /* 0x70d7 */
    KANJI,        /* 0x70d8 */
    KANJI,        /* 0x70d9 */
    KANJI,        /* 0x70da */
    KANJI,        /* 0x70db */
    KANJI,        /* 0x70dc */
    KANJI,        /* 0x70dd */
    KANJI,        /* 0x70de */
    KANJI,        /* 0x70df */
    KANJI,        /* 0x70e0 */
    KANJI,        /* 0x70e1 */
    KANJI,        /* 0x70e2 */
    KANJI,        /* 0x70e3 */
    KANJI,        /* 0x70e4 */
    KANJI,        /* 0x70e5 */
    KANJI,        /* 0x70e6 */
    KANJI,        /* 0x70e7 */
    KANJI,        /* 0x70e8 */
    KANJI,        /* 0x70e9 */
    KANJI,        /* 0x70ea */
    KANJI,        /* 0x70eb */
    KANJI,        /* 0x70ec */
    KANJI,        /* 0x70ed */
    KANJI,        /* 0x70ee */
    KANJI,        /* 0x70ef */
    KANJI,        /* 0x70f0 */
    KANJI,        /* 0x70f1 */
    KANJI,        /* 0x70f2 */
    KANJI,        /* 0x70f3 */
    KANJI,        /* 0x70f4 */
    KANJI,        /* 0x70f5 */
    KANJI,        /* 0x70f6 */
    KANJI,        /* 0x70f7 */
    KANJI,        /* 0x70f8 */
    KANJI,        /* 0x70f9 */
    KANJI,        /* 0x70fa */
    KANJI,        /* 0x70fb */
    KANJI,        /* 0x70fc */
    KANJI,        /* 0x70fd */
    KANJI,        /* 0x70fe */
    KANJI,        /* 0x70ff */
    KANJI,        /* 0x7100 */
    KANJI,        /* 0x7101 */
    KANJI,        /* 0x7102 */
    KANJI,        /* 0x7103 */
    KANJI,        /* 0x7104 */
    KANJI,        /* 0x7105 */
    KANJI,        /* 0x7106 */
    KANJI,        /* 0x7107 */
    KANJI,        /* 0x7108 */
    KANJI,        /* 0x7109 */
    KANJI,        /* 0x710a */
    KANJI,        /* 0x710b */
    KANJI,        /* 0x710c */
    KANJI,        /* 0x710d */
    KANJI,        /* 0x710e */
    KANJI,        /* 0x710f */
    KANJI,        /* 0x7110 */
    KANJI,        /* 0x7111 */
    KANJI,        /* 0x7112 */
    KANJI,        /* 0x7113 */
    KANJI,        /* 0x7114 */
    KANJI,        /* 0x7115 */
    KANJI,        /* 0x7116 */
    KANJI,        /* 0x7117 */
    KANJI,        /* 0x7118 */
    KANJI,        /* 0x7119 */
    KANJI,        /* 0x711a */
    KANJI,        /* 0x711b */
    KANJI,        /* 0x711c */
    KANJI,        /* 0x711d */
    KANJI,        /* 0x711e */
    KANJI,        /* 0x711f */
    KANJI,        /* 0x7120 */
    KANJI,        /* 0x7121 */
    KANJI,        /* 0x7122 */
    KANJI,        /* 0x7123 */
    KANJI,        /* 0x7124 */
    KANJI,        /* 0x7125 */
    KANJI,        /* 0x7126 */
    KANJI,        /* 0x7127 */
    KANJI,        /* 0x7128 */
    KANJI,        /* 0x7129 */
    KANJI,        /* 0x712a */
    KANJI,        /* 0x712b */
    KANJI,        /* 0x712c */
    KANJI,        /* 0x712d */
    KANJI,        /* 0x712e */
    KANJI,        /* 0x712f */
    KANJI,        /* 0x7130 */
    KANJI,        /* 0x7131 */
    KANJI,        /* 0x7132 */
    KANJI,        /* 0x7133 */
    KANJI,        /* 0x7134 */
    KANJI,        /* 0x7135 */
    KANJI,        /* 0x7136 */
    KANJI,        /* 0x7137 */
    KANJI,        /* 0x7138 */
    KANJI,        /* 0x7139 */
    KANJI,        /* 0x713a */
    KANJI,        /* 0x713b */
    KANJI,        /* 0x713c */
    KANJI,        /* 0x713d */
    KANJI,        /* 0x713e */
    KANJI,        /* 0x713f */
    KANJI,        /* 0x7140 */
    KANJI,        /* 0x7141 */
    KANJI,        /* 0x7142 */
    KANJI,        /* 0x7143 */
    KANJI,        /* 0x7144 */
    KANJI,        /* 0x7145 */
    KANJI,        /* 0x7146 */
    KANJI,        /* 0x7147 */
    KANJI,        /* 0x7148 */
    KANJI,        /* 0x7149 */
    KANJI,        /* 0x714a */
    KANJI,        /* 0x714b */
    KANJI,        /* 0x714c */
    KANJI,        /* 0x714d */
    KANJI,        /* 0x714e */
    KANJI,        /* 0x714f */
    KANJI,        /* 0x7150 */
    KANJI,        /* 0x7151 */
    KANJI,        /* 0x7152 */
    KANJI,        /* 0x7153 */
    KANJI,        /* 0x7154 */
    KANJI,        /* 0x7155 */
    KANJI,        /* 0x7156 */
    KANJI,        /* 0x7157 */
    KANJI,        /* 0x7158 */
    KANJI,        /* 0x7159 */
    KANJI,        /* 0x715a */
    KANJI,        /* 0x715b */
    KANJI,        /* 0x715c */
    KANJI,        /* 0x715d */
    KANJI,        /* 0x715e */
    KANJI,        /* 0x715f */
    KANJI,        /* 0x7160 */
    KANJI,        /* 0x7161 */
    KANJI,        /* 0x7162 */
    KANJI,        /* 0x7163 */
    KANJI,        /* 0x7164 */
    KANJI,        /* 0x7165 */
    KANJI,        /* 0x7166 */
    KANJI,        /* 0x7167 */
    KANJI,        /* 0x7168 */
    KANJI,        /* 0x7169 */
    KANJI,        /* 0x716a */
    KANJI,        /* 0x716b */
    KANJI,        /* 0x716c */
    KANJI,        /* 0x716d */
    KANJI,        /* 0x716e */
    KANJI,        /* 0x716f */
    KANJI,        /* 0x7170 */
    KANJI,        /* 0x7171 */
    KANJI,        /* 0x7172 */
    KANJI,        /* 0x7173 */
    KANJI,        /* 0x7174 */
    KANJI,        /* 0x7175 */
    KANJI,        /* 0x7176 */
    KANJI,        /* 0x7177 */
    KANJI,        /* 0x7178 */
    KANJI,        /* 0x7179 */
    KANJI,        /* 0x717a */
    KANJI,        /* 0x717b */
    KANJI,        /* 0x717c */
    KANJI,        /* 0x717d */
    KANJI,        /* 0x717e */
    KANJI,        /* 0x717f */
    KANJI,        /* 0x7180 */
    KANJI,        /* 0x7181 */
    KANJI,        /* 0x7182 */
    KANJI,        /* 0x7183 */
    KANJI,        /* 0x7184 */
    KANJI,        /* 0x7185 */
    KANJI,        /* 0x7186 */
    KANJI,        /* 0x7187 */
    KANJI,        /* 0x7188 */
    KANJI,        /* 0x7189 */
    KANJI,        /* 0x718a */
    KANJI,        /* 0x718b */
    KANJI,        /* 0x718c */
    KANJI,        /* 0x718d */
    KANJI,        /* 0x718e */
    KANJI,        /* 0x718f */
    KANJI,        /* 0x7190 */
    KANJI,        /* 0x7191 */
    KANJI,        /* 0x7192 */
    KANJI,        /* 0x7193 */
    KANJI,        /* 0x7194 */
    KANJI,        /* 0x7195 */
    KANJI,        /* 0x7196 */
    KANJI,        /* 0x7197 */
    KANJI,        /* 0x7198 */
    KANJI,        /* 0x7199 */
    KANJI,        /* 0x719a */
    KANJI,        /* 0x719b */
    KANJI,        /* 0x719c */
    KANJI,        /* 0x719d */
    KANJI,        /* 0x719e */
    KANJI,        /* 0x719f */
    KANJI,        /* 0x71a0 */
    KANJI,        /* 0x71a1 */
    KANJI,        /* 0x71a2 */
    KANJI,        /* 0x71a3 */
    KANJI,        /* 0x71a4 */
    KANJI,        /* 0x71a5 */
    KANJI,        /* 0x71a6 */
    KANJI,        /* 0x71a7 */
    KANJI,        /* 0x71a8 */
    KANJI,        /* 0x71a9 */
    KANJI,        /* 0x71aa */
    KANJI,        /* 0x71ab */
    KANJI,        /* 0x71ac */
    KANJI,        /* 0x71ad */
    KANJI,        /* 0x71ae */
    KANJI,        /* 0x71af */
    KANJI,        /* 0x71b0 */
    KANJI,        /* 0x71b1 */
    KANJI,        /* 0x71b2 */
    KANJI,        /* 0x71b3 */
    KANJI,        /* 0x71b4 */
    KANJI,        /* 0x71b5 */
    KANJI,        /* 0x71b6 */
    KANJI,        /* 0x71b7 */
    KANJI,        /* 0x71b8 */
    KANJI,        /* 0x71b9 */
    KANJI,        /* 0x71ba */
    KANJI,        /* 0x71bb */
    KANJI,        /* 0x71bc */
    KANJI,        /* 0x71bd */
    KANJI,        /* 0x71be */
    KANJI,        /* 0x71bf */
    KANJI,        /* 0x71c0 */
    KANJI,        /* 0x71c1 */
    KANJI,        /* 0x71c2 */
    KANJI,        /* 0x71c3 */
    KANJI,        /* 0x71c4 */
    KANJI,        /* 0x71c5 */
    KANJI,        /* 0x71c6 */
    KANJI,        /* 0x71c7 */
    KANJI,        /* 0x71c8 */
    KANJI,        /* 0x71c9 */
    KANJI,        /* 0x71ca */
    KANJI,        /* 0x71cb */
    KANJI,        /* 0x71cc */
    KANJI,        /* 0x71cd */
    KANJI,        /* 0x71ce */
    KANJI,        /* 0x71cf */
    KANJI,        /* 0x71d0 */
    KANJI,        /* 0x71d1 */
    KANJI,        /* 0x71d2 */
    KANJI,        /* 0x71d3 */
    KANJI,        /* 0x71d4 */
    KANJI,        /* 0x71d5 */
    KANJI,        /* 0x71d6 */
    KANJI,        /* 0x71d7 */
    KANJI,        /* 0x71d8 */
    KANJI,        /* 0x71d9 */
    KANJI,        /* 0x71da */
    KANJI,        /* 0x71db */
    KANJI,        /* 0x71dc */
    KANJI,        /* 0x71dd */
    KANJI,        /* 0x71de */
    KANJI,        /* 0x71df */
    KANJI,        /* 0x71e0 */
    KANJI,        /* 0x71e1 */
    KANJI,        /* 0x71e2 */
    KANJI,        /* 0x71e3 */
    KANJI,        /* 0x71e4 */
    KANJI,        /* 0x71e5 */
    KANJI,        /* 0x71e6 */
    KANJI,        /* 0x71e7 */
    KANJI,        /* 0x71e8 */
    KANJI,        /* 0x71e9 */
    KANJI,        /* 0x71ea */
    KANJI,        /* 0x71eb */
    KANJI,        /* 0x71ec */
    KANJI,        /* 0x71ed */
    KANJI,        /* 0x71ee */
    KANJI,        /* 0x71ef */
    KANJI,        /* 0x71f0 */
    KANJI,        /* 0x71f1 */
    KANJI,        /* 0x71f2 */
    KANJI,        /* 0x71f3 */
    KANJI,        /* 0x71f4 */
    KANJI,        /* 0x71f5 */
    KANJI,        /* 0x71f6 */
    KANJI,        /* 0x71f7 */
    KANJI,        /* 0x71f8 */
    KANJI,        /* 0x71f9 */
    KANJI,        /* 0x71fa */
    KANJI,        /* 0x71fb */
    KANJI,        /* 0x71fc */
    KANJI,        /* 0x71fd */
    KANJI,        /* 0x71fe */
    KANJI,        /* 0x71ff */
    KANJI,        /* 0x7200 */
    KANJI,        /* 0x7201 */
    KANJI,        /* 0x7202 */
    KANJI,        /* 0x7203 */
    KANJI,        /* 0x7204 */
    KANJI,        /* 0x7205 */
    KANJI,        /* 0x7206 */
    KANJI,        /* 0x7207 */
    KANJI,        /* 0x7208 */
    KANJI,        /* 0x7209 */
    KANJI,        /* 0x720a */
    KANJI,        /* 0x720b */
    KANJI,        /* 0x720c */
    KANJI,        /* 0x720d */
    KANJI,        /* 0x720e */
    KANJI,        /* 0x720f */
    KANJI,        /* 0x7210 */
    KANJI,        /* 0x7211 */
    KANJI,        /* 0x7212 */
    KANJI,        /* 0x7213 */
    KANJI,        /* 0x7214 */
    KANJI,        /* 0x7215 */
    KANJI,        /* 0x7216 */
    KANJI,        /* 0x7217 */
    KANJI,        /* 0x7218 */
    KANJI,        /* 0x7219 */
    KANJI,        /* 0x721a */
    KANJI,        /* 0x721b */
    KANJI,        /* 0x721c */
    KANJI,        /* 0x721d */
    KANJI,        /* 0x721e */
    KANJI,        /* 0x721f */
    KANJI,        /* 0x7220 */
    KANJI,        /* 0x7221 */
    KANJI,        /* 0x7222 */
    KANJI,        /* 0x7223 */
    KANJI,        /* 0x7224 */
    KANJI,        /* 0x7225 */
    KANJI,        /* 0x7226 */
    KANJI,        /* 0x7227 */
    KANJI,        /* 0x7228 */
    KANJI,        /* 0x7229 */
    KANJI,        /* 0x722a */
    KANJI,        /* 0x722b */
    KANJI,        /* 0x722c */
    KANJI,        /* 0x722d */
    KANJI,        /* 0x722e */
    KANJI,        /* 0x722f */
    KANJI,        /* 0x7230 */
    KANJI,        /* 0x7231 */
    KANJI,        /* 0x7232 */
    KANJI,        /* 0x7233 */
    KANJI,        /* 0x7234 */
    KANJI,        /* 0x7235 */
    KANJI,        /* 0x7236 */
    KANJI,        /* 0x7237 */
    KANJI,        /* 0x7238 */
    KANJI,        /* 0x7239 */
    KANJI,        /* 0x723a */
    KANJI,        /* 0x723b */
    KANJI,        /* 0x723c */
    KANJI,        /* 0x723d */
    KANJI,        /* 0x723e */
    KANJI,        /* 0x723f */
    KANJI,        /* 0x7240 */
    KANJI,        /* 0x7241 */
    KANJI,        /* 0x7242 */
    KANJI,        /* 0x7243 */
    KANJI,        /* 0x7244 */
    KANJI,        /* 0x7245 */
    KANJI,        /* 0x7246 */
    KANJI,        /* 0x7247 */
    KANJI,        /* 0x7248 */
    KANJI,        /* 0x7249 */
    KANJI,        /* 0x724a */
    KANJI,        /* 0x724b */
    KANJI,        /* 0x724c */
    KANJI,        /* 0x724d */
    KANJI,        /* 0x724e */
    KANJI,        /* 0x724f */
    KANJI,        /* 0x7250 */
    KANJI,        /* 0x7251 */
    KANJI,        /* 0x7252 */
    KANJI,        /* 0x7253 */
    KANJI,        /* 0x7254 */
    KANJI,        /* 0x7255 */
    KANJI,        /* 0x7256 */
    KANJI,        /* 0x7257 */
    KANJI,        /* 0x7258 */
    KANJI,        /* 0x7259 */
    KANJI,        /* 0x725a */
    KANJI,        /* 0x725b */
    KANJI,        /* 0x725c */
    KANJI,        /* 0x725d */
    KANJI,        /* 0x725e */
    KANJI,        /* 0x725f */
    KANJI,        /* 0x7260 */
    KANJI,        /* 0x7261 */
    KANJI,        /* 0x7262 */
    KANJI,        /* 0x7263 */
    KANJI,        /* 0x7264 */
    KANJI,        /* 0x7265 */
    KANJI,        /* 0x7266 */
    KANJI,        /* 0x7267 */
    KANJI,        /* 0x7268 */
    KANJI,        /* 0x7269 */
    KANJI,        /* 0x726a */
    KANJI,        /* 0x726b */
    KANJI,        /* 0x726c */
    KANJI,        /* 0x726d */
    KANJI,        /* 0x726e */
    KANJI,        /* 0x726f */
    KANJI,        /* 0x7270 */
    KANJI,        /* 0x7271 */
    KANJI,        /* 0x7272 */
    KANJI,        /* 0x7273 */
    KANJI,        /* 0x7274 */
    KANJI,        /* 0x7275 */
    KANJI,        /* 0x7276 */
    KANJI,        /* 0x7277 */
    KANJI,        /* 0x7278 */
    KANJI,        /* 0x7279 */
    KANJI,        /* 0x727a */
    KANJI,        /* 0x727b */
    KANJI,        /* 0x727c */
    KANJI,        /* 0x727d */
    KANJI,        /* 0x727e */
    KANJI,        /* 0x727f */
    KANJI,        /* 0x7280 */
    KANJI,        /* 0x7281 */
    KANJI,        /* 0x7282 */
    KANJI,        /* 0x7283 */
    KANJI,        /* 0x7284 */
    KANJI,        /* 0x7285 */
    KANJI,        /* 0x7286 */
    KANJI,        /* 0x7287 */
    KANJI,        /* 0x7288 */
    KANJI,        /* 0x7289 */
    KANJI,        /* 0x728a */
    KANJI,        /* 0x728b */
    KANJI,        /* 0x728c */
    KANJI,        /* 0x728d */
    KANJI,        /* 0x728e */
    KANJI,        /* 0x728f */
    KANJI,        /* 0x7290 */
    KANJI,        /* 0x7291 */
    KANJI,        /* 0x7292 */
    KANJI,        /* 0x7293 */
    KANJI,        /* 0x7294 */
    KANJI,        /* 0x7295 */
    KANJI,        /* 0x7296 */
    KANJI,        /* 0x7297 */
    KANJI,        /* 0x7298 */
    KANJI,        /* 0x7299 */
    KANJI,        /* 0x729a */
    KANJI,        /* 0x729b */
    KANJI,        /* 0x729c */
    KANJI,        /* 0x729d */
    KANJI,        /* 0x729e */
    KANJI,        /* 0x729f */
    KANJI,        /* 0x72a0 */
    KANJI,        /* 0x72a1 */
    KANJI,        /* 0x72a2 */
    KANJI,        /* 0x72a3 */
    KANJI,        /* 0x72a4 */
    KANJI,        /* 0x72a5 */
    KANJI,        /* 0x72a6 */
    KANJI,        /* 0x72a7 */
    KANJI,        /* 0x72a8 */
    KANJI,        /* 0x72a9 */
    KANJI,        /* 0x72aa */
    KANJI,        /* 0x72ab */
    KANJI,        /* 0x72ac */
    KANJI,        /* 0x72ad */
    KANJI,        /* 0x72ae */
    KANJI,        /* 0x72af */
    KANJI,        /* 0x72b0 */
    KANJI,        /* 0x72b1 */
    KANJI,        /* 0x72b2 */
    KANJI,        /* 0x72b3 */
    KANJI,        /* 0x72b4 */
    KANJI,        /* 0x72b5 */
    KANJI,        /* 0x72b6 */
    KANJI,        /* 0x72b7 */
    KANJI,        /* 0x72b8 */
    KANJI,        /* 0x72b9 */
    KANJI,        /* 0x72ba */
    KANJI,        /* 0x72bb */
    KANJI,        /* 0x72bc */
    KANJI,        /* 0x72bd */
    KANJI,        /* 0x72be */
    KANJI,        /* 0x72bf */
    KANJI,        /* 0x72c0 */
    KANJI,        /* 0x72c1 */
    KANJI,        /* 0x72c2 */
    KANJI,        /* 0x72c3 */
    KANJI,        /* 0x72c4 */
    KANJI,        /* 0x72c5 */
    KANJI,        /* 0x72c6 */
    KANJI,        /* 0x72c7 */
    KANJI,        /* 0x72c8 */
    KANJI,        /* 0x72c9 */
    KANJI,        /* 0x72ca */
    KANJI,        /* 0x72cb */
    KANJI,        /* 0x72cc */
    KANJI,        /* 0x72cd */
    KANJI,        /* 0x72ce */
    KANJI,        /* 0x72cf */
    KANJI,        /* 0x72d0 */
    KANJI,        /* 0x72d1 */
    KANJI,        /* 0x72d2 */
    KANJI,        /* 0x72d3 */
    KANJI,        /* 0x72d4 */
    KANJI,        /* 0x72d5 */
    KANJI,        /* 0x72d6 */
    KANJI,        /* 0x72d7 */
    KANJI,        /* 0x72d8 */
    KANJI,        /* 0x72d9 */
    KANJI,        /* 0x72da */
    KANJI,        /* 0x72db */
    KANJI,        /* 0x72dc */
    KANJI,        /* 0x72dd */
    KANJI,        /* 0x72de */
    KANJI,        /* 0x72df */
    KANJI,        /* 0x72e0 */
    KANJI,        /* 0x72e1 */
    KANJI,        /* 0x72e2 */
    KANJI,        /* 0x72e3 */
    KANJI,        /* 0x72e4 */
    KANJI,        /* 0x72e5 */
    KANJI,        /* 0x72e6 */
    KANJI,        /* 0x72e7 */
    KANJI,        /* 0x72e8 */
    KANJI,        /* 0x72e9 */
    KANJI,        /* 0x72ea */
    KANJI,        /* 0x72eb */
    KANJI,        /* 0x72ec */
    KANJI,        /* 0x72ed */
    KANJI,        /* 0x72ee */
    KANJI,        /* 0x72ef */
    KANJI,        /* 0x72f0 */
    KANJI,        /* 0x72f1 */
    KANJI,        /* 0x72f2 */
    KANJI,        /* 0x72f3 */
    KANJI,        /* 0x72f4 */
    KANJI,        /* 0x72f5 */
    KANJI,        /* 0x72f6 */
    KANJI,        /* 0x72f7 */
    KANJI,        /* 0x72f8 */
    KANJI,        /* 0x72f9 */
    KANJI,        /* 0x72fa */
    KANJI,        /* 0x72fb */
    KANJI,        /* 0x72fc */
    KANJI,        /* 0x72fd */
    KANJI,        /* 0x72fe */
    KANJI,        /* 0x72ff */
    KANJI,        /* 0x7300 */
    KANJI,        /* 0x7301 */
    KANJI,        /* 0x7302 */
    KANJI,        /* 0x7303 */
    KANJI,        /* 0x7304 */
    KANJI,        /* 0x7305 */
    KANJI,        /* 0x7306 */
    KANJI,        /* 0x7307 */
    KANJI,        /* 0x7308 */
    KANJI,        /* 0x7309 */
    KANJI,        /* 0x730a */
    KANJI,        /* 0x730b */
    KANJI,        /* 0x730c */
    KANJI,        /* 0x730d */
    KANJI,        /* 0x730e */
    KANJI,        /* 0x730f */
    KANJI,        /* 0x7310 */
    KANJI,        /* 0x7311 */
    KANJI,        /* 0x7312 */
    KANJI,        /* 0x7313 */
    KANJI,        /* 0x7314 */
    KANJI,        /* 0x7315 */
    KANJI,        /* 0x7316 */
    KANJI,        /* 0x7317 */
    KANJI,        /* 0x7318 */
    KANJI,        /* 0x7319 */
    KANJI,        /* 0x731a */
    KANJI,        /* 0x731b */
    KANJI,        /* 0x731c */
    KANJI,        /* 0x731d */
    KANJI,        /* 0x731e */
    KANJI,        /* 0x731f */
    KANJI,        /* 0x7320 */
    KANJI,        /* 0x7321 */
    KANJI,        /* 0x7322 */
    KANJI,        /* 0x7323 */
    KANJI,        /* 0x7324 */
    KANJI,        /* 0x7325 */
    KANJI,        /* 0x7326 */
    KANJI,        /* 0x7327 */
    KANJI,        /* 0x7328 */
    KANJI,        /* 0x7329 */
    KANJI,        /* 0x732a */
    KANJI,        /* 0x732b */
    KANJI,        /* 0x732c */
    KANJI,        /* 0x732d */
    KANJI,        /* 0x732e */
    KANJI,        /* 0x732f */
    KANJI,        /* 0x7330 */
    KANJI,        /* 0x7331 */
    KANJI,        /* 0x7332 */
    KANJI,        /* 0x7333 */
    KANJI,        /* 0x7334 */
    KANJI,        /* 0x7335 */
    KANJI,        /* 0x7336 */
    KANJI,        /* 0x7337 */
    KANJI,        /* 0x7338 */
    KANJI,        /* 0x7339 */
    KANJI,        /* 0x733a */
    KANJI,        /* 0x733b */
    KANJI,        /* 0x733c */
    KANJI,        /* 0x733d */
    KANJI,        /* 0x733e */
    KANJI,        /* 0x733f */
    KANJI,        /* 0x7340 */
    KANJI,        /* 0x7341 */
    KANJI,        /* 0x7342 */
    KANJI,        /* 0x7343 */
    KANJI,        /* 0x7344 */
    KANJI,        /* 0x7345 */
    KANJI,        /* 0x7346 */
    KANJI,        /* 0x7347 */
    KANJI,        /* 0x7348 */
    KANJI,        /* 0x7349 */
    KANJI,        /* 0x734a */
    KANJI,        /* 0x734b */
    KANJI,        /* 0x734c */
    KANJI,        /* 0x734d */
    KANJI,        /* 0x734e */
    KANJI,        /* 0x734f */
    KANJI,        /* 0x7350 */
    KANJI,        /* 0x7351 */
    KANJI,        /* 0x7352 */
    KANJI,        /* 0x7353 */
    KANJI,        /* 0x7354 */
    KANJI,        /* 0x7355 */
    KANJI,        /* 0x7356 */
    KANJI,        /* 0x7357 */
    KANJI,        /* 0x7358 */
    KANJI,        /* 0x7359 */
    KANJI,        /* 0x735a */
    KANJI,        /* 0x735b */
    KANJI,        /* 0x735c */
    KANJI,        /* 0x735d */
    KANJI,        /* 0x735e */
    KANJI,        /* 0x735f */
    KANJI,        /* 0x7360 */
    KANJI,        /* 0x7361 */
    KANJI,        /* 0x7362 */
    KANJI,        /* 0x7363 */
    KANJI,        /* 0x7364 */
    KANJI,        /* 0x7365 */
    KANJI,        /* 0x7366 */
    KANJI,        /* 0x7367 */
    KANJI,        /* 0x7368 */
    KANJI,        /* 0x7369 */
    KANJI,        /* 0x736a */
    KANJI,        /* 0x736b */
    KANJI,        /* 0x736c */
    KANJI,        /* 0x736d */
    KANJI,        /* 0x736e */
    KANJI,        /* 0x736f */
    KANJI,        /* 0x7370 */
    KANJI,        /* 0x7371 */
    KANJI,        /* 0x7372 */
    KANJI,        /* 0x7373 */
    KANJI,        /* 0x7374 */
    KANJI,        /* 0x7375 */
    KANJI,        /* 0x7376 */
    KANJI,        /* 0x7377 */
    KANJI,        /* 0x7378 */
    KANJI,        /* 0x7379 */
    KANJI,        /* 0x737a */
    KANJI,        /* 0x737b */
    KANJI,        /* 0x737c */
    KANJI,        /* 0x737d */
    KANJI,        /* 0x737e */
    KANJI,        /* 0x737f */
    KANJI,        /* 0x7380 */
    KANJI,        /* 0x7381 */
    KANJI,        /* 0x7382 */
    KANJI,        /* 0x7383 */
    KANJI,        /* 0x7384 */
    KANJI,        /* 0x7385 */
    KANJI,        /* 0x7386 */
    KANJI,        /* 0x7387 */
    KANJI,        /* 0x7388 */
    KANJI,        /* 0x7389 */
    KANJI,        /* 0x738a */
    KANJI,        /* 0x738b */
    KANJI,        /* 0x738c */
    KANJI,        /* 0x738d */
    KANJI,        /* 0x738e */
    KANJI,        /* 0x738f */
    KANJI,        /* 0x7390 */
    KANJI,        /* 0x7391 */
    KANJI,        /* 0x7392 */
    KANJI,        /* 0x7393 */
    KANJI,        /* 0x7394 */
    KANJI,        /* 0x7395 */
    KANJI,        /* 0x7396 */
    KANJI,        /* 0x7397 */
    KANJI,        /* 0x7398 */
    KANJI,        /* 0x7399 */
    KANJI,        /* 0x739a */
    KANJI,        /* 0x739b */
    KANJI,        /* 0x739c */
    KANJI,        /* 0x739d */
    KANJI,        /* 0x739e */
    KANJI,        /* 0x739f */
    KANJI,        /* 0x73a0 */
    KANJI,        /* 0x73a1 */
    KANJI,        /* 0x73a2 */
    KANJI,        /* 0x73a3 */
    KANJI,        /* 0x73a4 */
    KANJI,        /* 0x73a5 */
    KANJI,        /* 0x73a6 */
    KANJI,        /* 0x73a7 */
    KANJI,        /* 0x73a8 */
    KANJI,        /* 0x73a9 */
    KANJI,        /* 0x73aa */
    KANJI,        /* 0x73ab */
    KANJI,        /* 0x73ac */
    KANJI,        /* 0x73ad */
    KANJI,        /* 0x73ae */
    KANJI,        /* 0x73af */
    KANJI,        /* 0x73b0 */
    KANJI,        /* 0x73b1 */
    KANJI,        /* 0x73b2 */
    KANJI,        /* 0x73b3 */
    KANJI,        /* 0x73b4 */
    KANJI,        /* 0x73b5 */
    KANJI,        /* 0x73b6 */
    KANJI,        /* 0x73b7 */
    KANJI,        /* 0x73b8 */
    KANJI,        /* 0x73b9 */
    KANJI,        /* 0x73ba */
    KANJI,        /* 0x73bb */
    KANJI,        /* 0x73bc */
    KANJI,        /* 0x73bd */
    KANJI,        /* 0x73be */
    KANJI,        /* 0x73bf */
    KANJI,        /* 0x73c0 */
    KANJI,        /* 0x73c1 */
    KANJI,        /* 0x73c2 */
    KANJI,        /* 0x73c3 */
    KANJI,        /* 0x73c4 */
    KANJI,        /* 0x73c5 */
    KANJI,        /* 0x73c6 */
    KANJI,        /* 0x73c7 */
    KANJI,        /* 0x73c8 */
    KANJI,        /* 0x73c9 */
    KANJI,        /* 0x73ca */
    KANJI,        /* 0x73cb */
    KANJI,        /* 0x73cc */
    KANJI,        /* 0x73cd */
    KANJI,        /* 0x73ce */
    KANJI,        /* 0x73cf */
    KANJI,        /* 0x73d0 */
    KANJI,        /* 0x73d1 */
    KANJI,        /* 0x73d2 */
    KANJI,        /* 0x73d3 */
    KANJI,        /* 0x73d4 */
    KANJI,        /* 0x73d5 */
    KANJI,        /* 0x73d6 */
    KANJI,        /* 0x73d7 */
    KANJI,        /* 0x73d8 */
    KANJI,        /* 0x73d9 */
    KANJI,        /* 0x73da */
    KANJI,        /* 0x73db */
    KANJI,        /* 0x73dc */
    KANJI,        /* 0x73dd */
    KANJI,        /* 0x73de */
    KANJI,        /* 0x73df */
    KANJI,        /* 0x73e0 */
    KANJI,        /* 0x73e1 */
    KANJI,        /* 0x73e2 */
    KANJI,        /* 0x73e3 */
    KANJI,        /* 0x73e4 */
    KANJI,        /* 0x73e5 */
    KANJI,        /* 0x73e6 */
    KANJI,        /* 0x73e7 */
    KANJI,        /* 0x73e8 */
    KANJI,        /* 0x73e9 */
    KANJI,        /* 0x73ea */
    KANJI,        /* 0x73eb */
    KANJI,        /* 0x73ec */
    KANJI,        /* 0x73ed */
    KANJI,        /* 0x73ee */
    KANJI,        /* 0x73ef */
    KANJI,        /* 0x73f0 */
    KANJI,        /* 0x73f1 */
    KANJI,        /* 0x73f2 */
    KANJI,        /* 0x73f3 */
    KANJI,        /* 0x73f4 */
    KANJI,        /* 0x73f5 */
    KANJI,        /* 0x73f6 */
    KANJI,        /* 0x73f7 */
    KANJI,        /* 0x73f8 */
    KANJI,        /* 0x73f9 */
    KANJI,        /* 0x73fa */
    KANJI,        /* 0x73fb */
    KANJI,        /* 0x73fc */
    KANJI,        /* 0x73fd */
    KANJI,        /* 0x73fe */
    KANJI,        /* 0x73ff */
    KANJI,        /* 0x7400 */
    KANJI,        /* 0x7401 */
    KANJI,        /* 0x7402 */
    KANJI,        /* 0x7403 */
    KANJI,        /* 0x7404 */
    KANJI,        /* 0x7405 */
    KANJI,        /* 0x7406 */
    KANJI,        /* 0x7407 */
    KANJI,        /* 0x7408 */
    KANJI,        /* 0x7409 */
    KANJI,        /* 0x740a */
    KANJI,        /* 0x740b */
    KANJI,        /* 0x740c */
    KANJI,        /* 0x740d */
    KANJI,        /* 0x740e */
    KANJI,        /* 0x740f */
    KANJI,        /* 0x7410 */
    KANJI,        /* 0x7411 */
    KANJI,        /* 0x7412 */
    KANJI,        /* 0x7413 */
    KANJI,        /* 0x7414 */
    KANJI,        /* 0x7415 */
    KANJI,        /* 0x7416 */
    KANJI,        /* 0x7417 */
    KANJI,        /* 0x7418 */
    KANJI,        /* 0x7419 */
    KANJI,        /* 0x741a */
    KANJI,        /* 0x741b */
    KANJI,        /* 0x741c */
    KANJI,        /* 0x741d */
    KANJI,        /* 0x741e */
    KANJI,        /* 0x741f */
    KANJI,        /* 0x7420 */
    KANJI,        /* 0x7421 */
    KANJI,        /* 0x7422 */
    KANJI,        /* 0x7423 */
    KANJI,        /* 0x7424 */
    KANJI,        /* 0x7425 */
    KANJI,        /* 0x7426 */
    KANJI,        /* 0x7427 */
    KANJI,        /* 0x7428 */
    KANJI,        /* 0x7429 */
    KANJI,        /* 0x742a */
    KANJI,        /* 0x742b */
    KANJI,        /* 0x742c */
    KANJI,        /* 0x742d */
    KANJI,        /* 0x742e */
    KANJI,        /* 0x742f */
    KANJI,        /* 0x7430 */
    KANJI,        /* 0x7431 */
    KANJI,        /* 0x7432 */
    KANJI,        /* 0x7433 */
    KANJI,        /* 0x7434 */
    KANJI,        /* 0x7435 */
    KANJI,        /* 0x7436 */
    KANJI,        /* 0x7437 */
    KANJI,        /* 0x7438 */
    KANJI,        /* 0x7439 */
    KANJI,        /* 0x743a */
    KANJI,        /* 0x743b */
    KANJI,        /* 0x743c */
    KANJI,        /* 0x743d */
    KANJI,        /* 0x743e */
    KANJI,        /* 0x743f */
    KANJI,        /* 0x7440 */
    KANJI,        /* 0x7441 */
    KANJI,        /* 0x7442 */
    KANJI,        /* 0x7443 */
    KANJI,        /* 0x7444 */
    KANJI,        /* 0x7445 */
    KANJI,        /* 0x7446 */
    KANJI,        /* 0x7447 */
    KANJI,        /* 0x7448 */
    KANJI,        /* 0x7449 */
    KANJI,        /* 0x744a */
    KANJI,        /* 0x744b */
    KANJI,        /* 0x744c */
    KANJI,        /* 0x744d */
    KANJI,        /* 0x744e */
    KANJI,        /* 0x744f */
    KANJI,        /* 0x7450 */
    KANJI,        /* 0x7451 */
    KANJI,        /* 0x7452 */
    KANJI,        /* 0x7453 */
    KANJI,        /* 0x7454 */
    KANJI,        /* 0x7455 */
    KANJI,        /* 0x7456 */
    KANJI,        /* 0x7457 */
    KANJI,        /* 0x7458 */
    KANJI,        /* 0x7459 */
    KANJI,        /* 0x745a */
    KANJI,        /* 0x745b */
    KANJI,        /* 0x745c */
    KANJI,        /* 0x745d */
    KANJI,        /* 0x745e */
    KANJI,        /* 0x745f */
    KANJI,        /* 0x7460 */
    KANJI,        /* 0x7461 */
    KANJI,        /* 0x7462 */
    KANJI,        /* 0x7463 */
    KANJI,        /* 0x7464 */
    KANJI,        /* 0x7465 */
    KANJI,        /* 0x7466 */
    KANJI,        /* 0x7467 */
    KANJI,        /* 0x7468 */
    KANJI,        /* 0x7469 */
    KANJI,        /* 0x746a */
    KANJI,        /* 0x746b */
    KANJI,        /* 0x746c */
    KANJI,        /* 0x746d */
    KANJI,        /* 0x746e */
    KANJI,        /* 0x746f */
    KANJI,        /* 0x7470 */
    KANJI,        /* 0x7471 */
    KANJI,        /* 0x7472 */
    KANJI,        /* 0x7473 */
    KANJI,        /* 0x7474 */
    KANJI,        /* 0x7475 */
    KANJI,        /* 0x7476 */
    KANJI,        /* 0x7477 */
    KANJI,        /* 0x7478 */
    KANJI,        /* 0x7479 */
    KANJI,        /* 0x747a */
    KANJI,        /* 0x747b */
    KANJI,        /* 0x747c */
    KANJI,        /* 0x747d */
    KANJI,        /* 0x747e */
    KANJI,        /* 0x747f */
    KANJI,        /* 0x7480 */
    KANJI,        /* 0x7481 */
    KANJI,        /* 0x7482 */
    KANJI,        /* 0x7483 */
    KANJI,        /* 0x7484 */
    KANJI,        /* 0x7485 */
    KANJI,        /* 0x7486 */
    KANJI,        /* 0x7487 */
    KANJI,        /* 0x7488 */
    KANJI,        /* 0x7489 */
    KANJI,        /* 0x748a */
    KANJI,        /* 0x748b */
    KANJI,        /* 0x748c */
    KANJI,        /* 0x748d */
    KANJI,        /* 0x748e */
    KANJI,        /* 0x748f */
    KANJI,        /* 0x7490 */
    KANJI,        /* 0x7491 */
    KANJI,        /* 0x7492 */
    KANJI,        /* 0x7493 */
    KANJI,        /* 0x7494 */
    KANJI,        /* 0x7495 */
    KANJI,        /* 0x7496 */
    KANJI,        /* 0x7497 */
    KANJI,        /* 0x7498 */
    KANJI,        /* 0x7499 */
    KANJI,        /* 0x749a */
    KANJI,        /* 0x749b */
    KANJI,        /* 0x749c */
    KANJI,        /* 0x749d */
    KANJI,        /* 0x749e */
    KANJI,        /* 0x749f */
    KANJI,        /* 0x74a0 */
    KANJI,        /* 0x74a1 */
    KANJI,        /* 0x74a2 */
    KANJI,        /* 0x74a3 */
    KANJI,        /* 0x74a4 */
    KANJI,        /* 0x74a5 */
    KANJI,        /* 0x74a6 */
    KANJI,        /* 0x74a7 */
    KANJI,        /* 0x74a8 */
    KANJI,        /* 0x74a9 */
    KANJI,        /* 0x74aa */
    KANJI,        /* 0x74ab */
    KANJI,        /* 0x74ac */
    KANJI,        /* 0x74ad */
    KANJI,        /* 0x74ae */
    KANJI,        /* 0x74af */
    KANJI,        /* 0x74b0 */
    KANJI,        /* 0x74b1 */
    KANJI,        /* 0x74b2 */
    KANJI,        /* 0x74b3 */
    KANJI,        /* 0x74b4 */
    KANJI,        /* 0x74b5 */
    KANJI,        /* 0x74b6 */
    KANJI,        /* 0x74b7 */
    KANJI,        /* 0x74b8 */
    KANJI,        /* 0x74b9 */
    KANJI,        /* 0x74ba */
    KANJI,        /* 0x74bb */
    KANJI,        /* 0x74bc */
    KANJI,        /* 0x74bd */
    KANJI,        /* 0x74be */
    KANJI,        /* 0x74bf */
    KANJI,        /* 0x74c0 */
    KANJI,        /* 0x74c1 */
    KANJI,        /* 0x74c2 */
    KANJI,        /* 0x74c3 */
    KANJI,        /* 0x74c4 */
    KANJI,        /* 0x74c5 */
    KANJI,        /* 0x74c6 */
    KANJI,        /* 0x74c7 */
    KANJI,        /* 0x74c8 */
    KANJI,        /* 0x74c9 */
    KANJI,        /* 0x74ca */
    KANJI,        /* 0x74cb */
    KANJI,        /* 0x74cc */
    KANJI,        /* 0x74cd */
    KANJI,        /* 0x74ce */
    KANJI,        /* 0x74cf */
    KANJI,        /* 0x74d0 */
    KANJI,        /* 0x74d1 */
    KANJI,        /* 0x74d2 */
    KANJI,        /* 0x74d3 */
    KANJI,        /* 0x74d4 */
    KANJI,        /* 0x74d5 */
    KANJI,        /* 0x74d6 */
    KANJI,        /* 0x74d7 */
    KANJI,        /* 0x74d8 */
    KANJI,        /* 0x74d9 */
    KANJI,        /* 0x74da */
    KANJI,        /* 0x74db */
    KANJI,        /* 0x74dc */
    KANJI,        /* 0x74dd */
    KANJI,        /* 0x74de */
    KANJI,        /* 0x74df */
    KANJI,        /* 0x74e0 */
    KANJI,        /* 0x74e1 */
    KANJI,        /* 0x74e2 */
    KANJI,        /* 0x74e3 */
    KANJI,        /* 0x74e4 */
    KANJI,        /* 0x74e5 */
    KANJI,        /* 0x74e6 */
    KANJI,        /* 0x74e7 */
    KANJI,        /* 0x74e8 */
    KANJI,        /* 0x74e9 */
    KANJI,        /* 0x74ea */
    KANJI,        /* 0x74eb */
    KANJI,        /* 0x74ec */
    KANJI,        /* 0x74ed */
    KANJI,        /* 0x74ee */
    KANJI,        /* 0x74ef */
    KANJI,        /* 0x74f0 */
    KANJI,        /* 0x74f1 */
    KANJI,        /* 0x74f2 */
    KANJI,        /* 0x74f3 */
    KANJI,        /* 0x74f4 */
    KANJI,        /* 0x74f5 */
    KANJI,        /* 0x74f6 */
    KANJI,        /* 0x74f7 */
    KANJI,        /* 0x74f8 */
    KANJI,        /* 0x74f9 */
    KANJI,        /* 0x74fa */
    KANJI,        /* 0x74fb */
    KANJI,        /* 0x74fc */
    KANJI,        /* 0x74fd */
    KANJI,        /* 0x74fe */
    KANJI,        /* 0x74ff */
    KANJI,        /* 0x7500 */
    KANJI,        /* 0x7501 */
    KANJI,        /* 0x7502 */
    KANJI,        /* 0x7503 */
    KANJI,        /* 0x7504 */
    KANJI,        /* 0x7505 */
    KANJI,        /* 0x7506 */
    KANJI,        /* 0x7507 */
    KANJI,        /* 0x7508 */
    KANJI,        /* 0x7509 */
    KANJI,        /* 0x750a */
    KANJI,        /* 0x750b */
    KANJI,        /* 0x750c */
    KANJI,        /* 0x750d */
    KANJI,        /* 0x750e */
    KANJI,        /* 0x750f */
    KANJI,        /* 0x7510 */
    KANJI,        /* 0x7511 */
    KANJI,        /* 0x7512 */
    KANJI,        /* 0x7513 */
    KANJI,        /* 0x7514 */
    KANJI,        /* 0x7515 */
    KANJI,        /* 0x7516 */
    KANJI,        /* 0x7517 */
    KANJI,        /* 0x7518 */
    KANJI,        /* 0x7519 */
    KANJI,        /* 0x751a */
    KANJI,        /* 0x751b */
    KANJI,        /* 0x751c */
    KANJI,        /* 0x751d */
    KANJI,        /* 0x751e */
    KANJI,        /* 0x751f */
    KANJI,        /* 0x7520 */
    KANJI,        /* 0x7521 */
    KANJI,        /* 0x7522 */
    KANJI,        /* 0x7523 */
    KANJI,        /* 0x7524 */
    KANJI,        /* 0x7525 */
    KANJI,        /* 0x7526 */
    KANJI,        /* 0x7527 */
    KANJI,        /* 0x7528 */
    KANJI,        /* 0x7529 */
    KANJI,        /* 0x752a */
    KANJI,        /* 0x752b */
    KANJI,        /* 0x752c */
    KANJI,        /* 0x752d */
    KANJI,        /* 0x752e */
    KANJI,        /* 0x752f */
    KANJI,        /* 0x7530 */
    KANJI,        /* 0x7531 */
    KANJI,        /* 0x7532 */
    KANJI,        /* 0x7533 */
    KANJI,        /* 0x7534 */
    KANJI,        /* 0x7535 */
    KANJI,        /* 0x7536 */
    KANJI,        /* 0x7537 */
    KANJI,        /* 0x7538 */
    KANJI,        /* 0x7539 */
    KANJI,        /* 0x753a */
    KANJI,        /* 0x753b */
    KANJI,        /* 0x753c */
    KANJI,        /* 0x753d */
    KANJI,        /* 0x753e */
    KANJI,        /* 0x753f */
    KANJI,        /* 0x7540 */
    KANJI,        /* 0x7541 */
    KANJI,        /* 0x7542 */
    KANJI,        /* 0x7543 */
    KANJI,        /* 0x7544 */
    KANJI,        /* 0x7545 */
    KANJI,        /* 0x7546 */
    KANJI,        /* 0x7547 */
    KANJI,        /* 0x7548 */
    KANJI,        /* 0x7549 */
    KANJI,        /* 0x754a */
    KANJI,        /* 0x754b */
    KANJI,        /* 0x754c */
    KANJI,        /* 0x754d */
    KANJI,        /* 0x754e */
    KANJI,        /* 0x754f */
    KANJI,        /* 0x7550 */
    KANJI,        /* 0x7551 */
    KANJI,        /* 0x7552 */
    KANJI,        /* 0x7553 */
    KANJI,        /* 0x7554 */
    KANJI,        /* 0x7555 */
    KANJI,        /* 0x7556 */
    KANJI,        /* 0x7557 */
    KANJI,        /* 0x7558 */
    KANJI,        /* 0x7559 */
    KANJI,        /* 0x755a */
    KANJI,        /* 0x755b */
    KANJI,        /* 0x755c */
    KANJI,        /* 0x755d */
    KANJI,        /* 0x755e */
    KANJI,        /* 0x755f */
    KANJI,        /* 0x7560 */
    KANJI,        /* 0x7561 */
    KANJI,        /* 0x7562 */
    KANJI,        /* 0x7563 */
    KANJI,        /* 0x7564 */
    KANJI,        /* 0x7565 */
    KANJI,        /* 0x7566 */
    KANJI,        /* 0x7567 */
    KANJI,        /* 0x7568 */
    KANJI,        /* 0x7569 */
    KANJI,        /* 0x756a */
    KANJI,        /* 0x756b */
    KANJI,        /* 0x756c */
    KANJI,        /* 0x756d */
    KANJI,        /* 0x756e */
    KANJI,        /* 0x756f */
    KANJI,        /* 0x7570 */
    KANJI,        /* 0x7571 */
    KANJI,        /* 0x7572 */
    KANJI,        /* 0x7573 */
    KANJI,        /* 0x7574 */
    KANJI,        /* 0x7575 */
    KANJI,        /* 0x7576 */
    KANJI,        /* 0x7577 */
    KANJI,        /* 0x7578 */
    KANJI,        /* 0x7579 */
    KANJI,        /* 0x757a */
    KANJI,        /* 0x757b */
    KANJI,        /* 0x757c */
    KANJI,        /* 0x757d */
    KANJI,        /* 0x757e */
    KANJI,        /* 0x757f */
    KANJI,        /* 0x7580 */
    KANJI,        /* 0x7581 */
    KANJI,        /* 0x7582 */
    KANJI,        /* 0x7583 */
    KANJI,        /* 0x7584 */
    KANJI,        /* 0x7585 */
    KANJI,        /* 0x7586 */
    KANJI,        /* 0x7587 */
    KANJI,        /* 0x7588 */
    KANJI,        /* 0x7589 */
    KANJI,        /* 0x758a */
    KANJI,        /* 0x758b */
    KANJI,        /* 0x758c */
    KANJI,        /* 0x758d */
    KANJI,        /* 0x758e */
    KANJI,        /* 0x758f */
    KANJI,        /* 0x7590 */
    KANJI,        /* 0x7591 */
    KANJI,        /* 0x7592 */
    KANJI,        /* 0x7593 */
    KANJI,        /* 0x7594 */
    KANJI,        /* 0x7595 */
    KANJI,        /* 0x7596 */
    KANJI,        /* 0x7597 */
    KANJI,        /* 0x7598 */
    KANJI,        /* 0x7599 */
    KANJI,        /* 0x759a */
    KANJI,        /* 0x759b */
    KANJI,        /* 0x759c */
    KANJI,        /* 0x759d */
    KANJI,        /* 0x759e */
    KANJI,        /* 0x759f */
    KANJI,        /* 0x75a0 */
    KANJI,        /* 0x75a1 */
    KANJI,        /* 0x75a2 */
    KANJI,        /* 0x75a3 */
    KANJI,        /* 0x75a4 */
    KANJI,        /* 0x75a5 */
    KANJI,        /* 0x75a6 */
    KANJI,        /* 0x75a7 */
    KANJI,        /* 0x75a8 */
    KANJI,        /* 0x75a9 */
    KANJI,        /* 0x75aa */
    KANJI,        /* 0x75ab */
    KANJI,        /* 0x75ac */
    KANJI,        /* 0x75ad */
    KANJI,        /* 0x75ae */
    KANJI,        /* 0x75af */
    KANJI,        /* 0x75b0 */
    KANJI,        /* 0x75b1 */
    KANJI,        /* 0x75b2 */
    KANJI,        /* 0x75b3 */
    KANJI,        /* 0x75b4 */
    KANJI,        /* 0x75b5 */
    KANJI,        /* 0x75b6 */
    KANJI,        /* 0x75b7 */
    KANJI,        /* 0x75b8 */
    KANJI,        /* 0x75b9 */
    KANJI,        /* 0x75ba */
    KANJI,        /* 0x75bb */
    KANJI,        /* 0x75bc */
    KANJI,        /* 0x75bd */
    KANJI,        /* 0x75be */
    KANJI,        /* 0x75bf */
    KANJI,        /* 0x75c0 */
    KANJI,        /* 0x75c1 */
    KANJI,        /* 0x75c2 */
    KANJI,        /* 0x75c3 */
    KANJI,        /* 0x75c4 */
    KANJI,        /* 0x75c5 */
    KANJI,        /* 0x75c6 */
    KANJI,        /* 0x75c7 */
    KANJI,        /* 0x75c8 */
    KANJI,        /* 0x75c9 */
    KANJI,        /* 0x75ca */
    KANJI,        /* 0x75cb */
    KANJI,        /* 0x75cc */
    KANJI,        /* 0x75cd */
    KANJI,        /* 0x75ce */
    KANJI,        /* 0x75cf */
    KANJI,        /* 0x75d0 */
    KANJI,        /* 0x75d1 */
    KANJI,        /* 0x75d2 */
    KANJI,        /* 0x75d3 */
    KANJI,        /* 0x75d4 */
    KANJI,        /* 0x75d5 */
    KANJI,        /* 0x75d6 */
    KANJI,        /* 0x75d7 */
    KANJI,        /* 0x75d8 */
    KANJI,        /* 0x75d9 */
    KANJI,        /* 0x75da */
    KANJI,        /* 0x75db */
    KANJI,        /* 0x75dc */
    KANJI,        /* 0x75dd */
    KANJI,        /* 0x75de */
    KANJI,        /* 0x75df */
    KANJI,        /* 0x75e0 */
    KANJI,        /* 0x75e1 */
    KANJI,        /* 0x75e2 */
    KANJI,        /* 0x75e3 */
    KANJI,        /* 0x75e4 */
    KANJI,        /* 0x75e5 */
    KANJI,        /* 0x75e6 */
    KANJI,        /* 0x75e7 */
    KANJI,        /* 0x75e8 */
    KANJI,        /* 0x75e9 */
    KANJI,        /* 0x75ea */
    KANJI,        /* 0x75eb */
    KANJI,        /* 0x75ec */
    KANJI,        /* 0x75ed */
    KANJI,        /* 0x75ee */
    KANJI,        /* 0x75ef */
    KANJI,        /* 0x75f0 */
    KANJI,        /* 0x75f1 */
    KANJI,        /* 0x75f2 */
    KANJI,        /* 0x75f3 */
    KANJI,        /* 0x75f4 */
    KANJI,        /* 0x75f5 */
    KANJI,        /* 0x75f6 */
    KANJI,        /* 0x75f7 */
    KANJI,        /* 0x75f8 */
    KANJI,        /* 0x75f9 */
    KANJI,        /* 0x75fa */
    KANJI,        /* 0x75fb */
    KANJI,        /* 0x75fc */
    KANJI,        /* 0x75fd */
    KANJI,        /* 0x75fe */
    KANJI,        /* 0x75ff */
    KANJI,        /* 0x7600 */
    KANJI,        /* 0x7601 */
    KANJI,        /* 0x7602 */
    KANJI,        /* 0x7603 */
    KANJI,        /* 0x7604 */
    KANJI,        /* 0x7605 */
    KANJI,        /* 0x7606 */
    KANJI,        /* 0x7607 */
    KANJI,        /* 0x7608 */
    KANJI,        /* 0x7609 */
    KANJI,        /* 0x760a */
    KANJI,        /* 0x760b */
    KANJI,        /* 0x760c */
    KANJI,        /* 0x760d */
    KANJI,        /* 0x760e */
    KANJI,        /* 0x760f */
    KANJI,        /* 0x7610 */
    KANJI,        /* 0x7611 */
    KANJI,        /* 0x7612 */
    KANJI,        /* 0x7613 */
    KANJI,        /* 0x7614 */
    KANJI,        /* 0x7615 */
    KANJI,        /* 0x7616 */
    KANJI,        /* 0x7617 */
    KANJI,        /* 0x7618 */
    KANJI,        /* 0x7619 */
    KANJI,        /* 0x761a */
    KANJI,        /* 0x761b */
    KANJI,        /* 0x761c */
    KANJI,        /* 0x761d */
    KANJI,        /* 0x761e */
    KANJI,        /* 0x761f */
    KANJI,        /* 0x7620 */
    KANJI,        /* 0x7621 */
    KANJI,        /* 0x7622 */
    KANJI,        /* 0x7623 */
    KANJI,        /* 0x7624 */
    KANJI,        /* 0x7625 */
    KANJI,        /* 0x7626 */
    KANJI,        /* 0x7627 */
    KANJI,        /* 0x7628 */
    KANJI,        /* 0x7629 */
    KANJI,        /* 0x762a */
    KANJI,        /* 0x762b */
    KANJI,        /* 0x762c */
    KANJI,        /* 0x762d */
    KANJI,        /* 0x762e */
    KANJI,        /* 0x762f */
    KANJI,        /* 0x7630 */
    KANJI,        /* 0x7631 */
    KANJI,        /* 0x7632 */
    KANJI,        /* 0x7633 */
    KANJI,        /* 0x7634 */
    KANJI,        /* 0x7635 */
    KANJI,        /* 0x7636 */
    KANJI,        /* 0x7637 */
    KANJI,        /* 0x7638 */
    KANJI,        /* 0x7639 */
    KANJI,        /* 0x763a */
    KANJI,        /* 0x763b */
    KANJI,        /* 0x763c */
    KANJI,        /* 0x763d */
    KANJI,        /* 0x763e */
    KANJI,        /* 0x763f */
    KANJI,        /* 0x7640 */
    KANJI,        /* 0x7641 */
    KANJI,        /* 0x7642 */
    KANJI,        /* 0x7643 */
    KANJI,        /* 0x7644 */
    KANJI,        /* 0x7645 */
    KANJI,        /* 0x7646 */
    KANJI,        /* 0x7647 */
    KANJI,        /* 0x7648 */
    KANJI,        /* 0x7649 */
    KANJI,        /* 0x764a */
    KANJI,        /* 0x764b */
    KANJI,        /* 0x764c */
    KANJI,        /* 0x764d */
    KANJI,        /* 0x764e */
    KANJI,        /* 0x764f */
    KANJI,        /* 0x7650 */
    KANJI,        /* 0x7651 */
    KANJI,        /* 0x7652 */
    KANJI,        /* 0x7653 */
    KANJI,        /* 0x7654 */
    KANJI,        /* 0x7655 */
    KANJI,        /* 0x7656 */
    KANJI,        /* 0x7657 */
    KANJI,        /* 0x7658 */
    KANJI,        /* 0x7659 */
    KANJI,        /* 0x765a */
    KANJI,        /* 0x765b */
    KANJI,        /* 0x765c */
    KANJI,        /* 0x765d */
    KANJI,        /* 0x765e */
    KANJI,        /* 0x765f */
    KANJI,        /* 0x7660 */
    KANJI,        /* 0x7661 */
    KANJI,        /* 0x7662 */
    KANJI,        /* 0x7663 */
    KANJI,        /* 0x7664 */
    KANJI,        /* 0x7665 */
    KANJI,        /* 0x7666 */
    KANJI,        /* 0x7667 */
    KANJI,        /* 0x7668 */
    KANJI,        /* 0x7669 */
    KANJI,        /* 0x766a */
    KANJI,        /* 0x766b */
    KANJI,        /* 0x766c */
    KANJI,        /* 0x766d */
    KANJI,        /* 0x766e */
    KANJI,        /* 0x766f */
    KANJI,        /* 0x7670 */
    KANJI,        /* 0x7671 */
    KANJI,        /* 0x7672 */
    KANJI,        /* 0x7673 */
    KANJI,        /* 0x7674 */
    KANJI,        /* 0x7675 */
    KANJI,        /* 0x7676 */
    KANJI,        /* 0x7677 */
    KANJI,        /* 0x7678 */
    KANJI,        /* 0x7679 */
    KANJI,        /* 0x767a */
    KANJI,        /* 0x767b */
    KANJI,        /* 0x767c */
    KANJI,        /* 0x767d */
    KANJINUMERIC,        /* 0x767e */
    KANJI,        /* 0x767f */
    KANJI,        /* 0x7680 */
    KANJI,        /* 0x7681 */
    KANJI,        /* 0x7682 */
    KANJI,        /* 0x7683 */
    KANJI,        /* 0x7684 */
    KANJI,        /* 0x7685 */
    KANJI,        /* 0x7686 */
    KANJI,        /* 0x7687 */
    KANJI,        /* 0x7688 */
    KANJI,        /* 0x7689 */
    KANJI,        /* 0x768a */
    KANJI,        /* 0x768b */
    KANJI,        /* 0x768c */
    KANJI,        /* 0x768d */
    KANJI,        /* 0x768e */
    KANJI,        /* 0x768f */
    KANJI,        /* 0x7690 */
    KANJI,        /* 0x7691 */
    KANJI,        /* 0x7692 */
    KANJI,        /* 0x7693 */
    KANJI,        /* 0x7694 */
    KANJI,        /* 0x7695 */
    KANJI,        /* 0x7696 */
    KANJI,        /* 0x7697 */
    KANJI,        /* 0x7698 */
    KANJI,        /* 0x7699 */
    KANJI,        /* 0x769a */
    KANJI,        /* 0x769b */
    KANJI,        /* 0x769c */
    KANJI,        /* 0x769d */
    KANJI,        /* 0x769e */
    KANJI,        /* 0x769f */
    KANJI,        /* 0x76a0 */
    KANJI,        /* 0x76a1 */
    KANJI,        /* 0x76a2 */
    KANJI,        /* 0x76a3 */
    KANJI,        /* 0x76a4 */
    KANJI,        /* 0x76a5 */
    KANJI,        /* 0x76a6 */
    KANJI,        /* 0x76a7 */
    KANJI,        /* 0x76a8 */
    KANJI,        /* 0x76a9 */
    KANJI,        /* 0x76aa */
    KANJI,        /* 0x76ab */
    KANJI,        /* 0x76ac */
    KANJI,        /* 0x76ad */
    KANJI,        /* 0x76ae */
    KANJI,        /* 0x76af */
    KANJI,        /* 0x76b0 */
    KANJI,        /* 0x76b1 */
    KANJI,        /* 0x76b2 */
    KANJI,        /* 0x76b3 */
    KANJI,        /* 0x76b4 */
    KANJI,        /* 0x76b5 */
    KANJI,        /* 0x76b6 */
    KANJI,        /* 0x76b7 */
    KANJI,        /* 0x76b8 */
    KANJI,        /* 0x76b9 */
    KANJI,        /* 0x76ba */
    KANJI,        /* 0x76bb */
    KANJI,        /* 0x76bc */
    KANJI,        /* 0x76bd */
    KANJI,        /* 0x76be */
    KANJI,        /* 0x76bf */
    KANJI,        /* 0x76c0 */
    KANJI,        /* 0x76c1 */
    KANJI,        /* 0x76c2 */
    KANJI,        /* 0x76c3 */
    KANJI,        /* 0x76c4 */
    KANJI,        /* 0x76c5 */
    KANJI,        /* 0x76c6 */
    KANJI,        /* 0x76c7 */
    KANJI,        /* 0x76c8 */
    KANJI,        /* 0x76c9 */
    KANJI,        /* 0x76ca */
    KANJI,        /* 0x76cb */
    KANJI,        /* 0x76cc */
    KANJI,        /* 0x76cd */
    KANJI,        /* 0x76ce */
    KANJI,        /* 0x76cf */
    KANJI,        /* 0x76d0 */
    KANJI,        /* 0x76d1 */
    KANJI,        /* 0x76d2 */
    KANJI,        /* 0x76d3 */
    KANJI,        /* 0x76d4 */
    KANJI,        /* 0x76d5 */
    KANJI,        /* 0x76d6 */
    KANJI,        /* 0x76d7 */
    KANJI,        /* 0x76d8 */
    KANJI,        /* 0x76d9 */
    KANJI,        /* 0x76da */
    KANJI,        /* 0x76db */
    KANJI,        /* 0x76dc */
    KANJI,        /* 0x76dd */
    KANJI,        /* 0x76de */
    KANJI,        /* 0x76df */
    KANJI,        /* 0x76e0 */
    KANJI,        /* 0x76e1 */
    KANJI,        /* 0x76e2 */
    KANJI,        /* 0x76e3 */
    KANJI,        /* 0x76e4 */
    KANJI,        /* 0x76e5 */
    KANJI,        /* 0x76e6 */
    KANJI,        /* 0x76e7 */
    KANJI,        /* 0x76e8 */
    KANJI,        /* 0x76e9 */
    KANJI,        /* 0x76ea */
    KANJI,        /* 0x76eb */
    KANJI,        /* 0x76ec */
    KANJI,        /* 0x76ed */
    KANJI,        /* 0x76ee */
    KANJI,        /* 0x76ef */
    KANJI,        /* 0x76f0 */
    KANJI,        /* 0x76f1 */
    KANJI,        /* 0x76f2 */
    KANJI,        /* 0x76f3 */
    KANJI,        /* 0x76f4 */
    KANJI,        /* 0x76f5 */
    KANJI,        /* 0x76f6 */
    KANJI,        /* 0x76f7 */
    KANJI,        /* 0x76f8 */
    KANJI,        /* 0x76f9 */
    KANJI,        /* 0x76fa */
    KANJI,        /* 0x76fb */
    KANJI,        /* 0x76fc */
    KANJI,        /* 0x76fd */
    KANJI,        /* 0x76fe */
    KANJI,        /* 0x76ff */
    KANJI,        /* 0x7700 */
    KANJI,        /* 0x7701 */
    KANJI,        /* 0x7702 */
    KANJI,        /* 0x7703 */
    KANJI,        /* 0x7704 */
    KANJI,        /* 0x7705 */
    KANJI,        /* 0x7706 */
    KANJI,        /* 0x7707 */
    KANJI,        /* 0x7708 */
    KANJI,        /* 0x7709 */
    KANJI,        /* 0x770a */
    KANJI,        /* 0x770b */
    KANJI,        /* 0x770c */
    KANJI,        /* 0x770d */
    KANJI,        /* 0x770e */
    KANJI,        /* 0x770f */
    KANJI,        /* 0x7710 */
    KANJI,        /* 0x7711 */
    KANJI,        /* 0x7712 */
    KANJI,        /* 0x7713 */
    KANJI,        /* 0x7714 */
    KANJI,        /* 0x7715 */
    KANJI,        /* 0x7716 */
    KANJI,        /* 0x7717 */
    KANJI,        /* 0x7718 */
    KANJI,        /* 0x7719 */
    KANJI,        /* 0x771a */
    KANJI,        /* 0x771b */
    KANJI,        /* 0x771c */
    KANJI,        /* 0x771d */
    KANJI,        /* 0x771e */
    KANJI,        /* 0x771f */
    KANJI,        /* 0x7720 */
    KANJI,        /* 0x7721 */
    KANJI,        /* 0x7722 */
    KANJI,        /* 0x7723 */
    KANJI,        /* 0x7724 */
    KANJI,        /* 0x7725 */
    KANJI,        /* 0x7726 */
    KANJI,        /* 0x7727 */
    KANJI,        /* 0x7728 */
    KANJI,        /* 0x7729 */
    KANJI,        /* 0x772a */
    KANJI,        /* 0x772b */
    KANJI,        /* 0x772c */
    KANJI,        /* 0x772d */
    KANJI,        /* 0x772e */
    KANJI,        /* 0x772f */
    KANJI,        /* 0x7730 */
    KANJI,        /* 0x7731 */
    KANJI,        /* 0x7732 */
    KANJI,        /* 0x7733 */
    KANJI,        /* 0x7734 */
    KANJI,        /* 0x7735 */
    KANJI,        /* 0x7736 */
    KANJI,        /* 0x7737 */
    KANJI,        /* 0x7738 */
    KANJI,        /* 0x7739 */
    KANJI,        /* 0x773a */
    KANJI,        /* 0x773b */
    KANJI,        /* 0x773c */
    KANJI,        /* 0x773d */
    KANJI,        /* 0x773e */
    KANJI,        /* 0x773f */
    KANJI,        /* 0x7740 */
    KANJI,        /* 0x7741 */
    KANJI,        /* 0x7742 */
    KANJI,        /* 0x7743 */
    KANJI,        /* 0x7744 */
    KANJI,        /* 0x7745 */
    KANJI,        /* 0x7746 */
    KANJI,        /* 0x7747 */
    KANJI,        /* 0x7748 */
    KANJI,        /* 0x7749 */
    KANJI,        /* 0x774a */
    KANJI,        /* 0x774b */
    KANJI,        /* 0x774c */
    KANJI,        /* 0x774d */
    KANJI,        /* 0x774e */
    KANJI,        /* 0x774f */
    KANJI,        /* 0x7750 */
    KANJI,        /* 0x7751 */
    KANJI,        /* 0x7752 */
    KANJI,        /* 0x7753 */
    KANJI,        /* 0x7754 */
    KANJI,        /* 0x7755 */
    KANJI,        /* 0x7756 */
    KANJI,        /* 0x7757 */
    KANJI,        /* 0x7758 */
    KANJI,        /* 0x7759 */
    KANJI,        /* 0x775a */
    KANJI,        /* 0x775b */
    KANJI,        /* 0x775c */
    KANJI,        /* 0x775d */
    KANJI,        /* 0x775e */
    KANJI,        /* 0x775f */
    KANJI,        /* 0x7760 */
    KANJI,        /* 0x7761 */
    KANJI,        /* 0x7762 */
    KANJI,        /* 0x7763 */
    KANJI,        /* 0x7764 */
    KANJI,        /* 0x7765 */
    KANJI,        /* 0x7766 */
    KANJI,        /* 0x7767 */
    KANJI,        /* 0x7768 */
    KANJI,        /* 0x7769 */
    KANJI,        /* 0x776a */
    KANJI,        /* 0x776b */
    KANJI,        /* 0x776c */
    KANJI,        /* 0x776d */
    KANJI,        /* 0x776e */
    KANJI,        /* 0x776f */
    KANJI,        /* 0x7770 */
    KANJI,        /* 0x7771 */
    KANJI,        /* 0x7772 */
    KANJI,        /* 0x7773 */
    KANJI,        /* 0x7774 */
    KANJI,        /* 0x7775 */
    KANJI,        /* 0x7776 */
    KANJI,        /* 0x7777 */
    KANJI,        /* 0x7778 */
    KANJI,        /* 0x7779 */
    KANJI,        /* 0x777a */
    KANJI,        /* 0x777b */
    KANJI,        /* 0x777c */
    KANJI,        /* 0x777d */
    KANJI,        /* 0x777e */
    KANJI,        /* 0x777f */
    KANJI,        /* 0x7780 */
    KANJI,        /* 0x7781 */
    KANJI,        /* 0x7782 */
    KANJI,        /* 0x7783 */
    KANJI,        /* 0x7784 */
    KANJI,        /* 0x7785 */
    KANJI,        /* 0x7786 */
    KANJI,        /* 0x7787 */
    KANJI,        /* 0x7788 */
    KANJI,        /* 0x7789 */
    KANJI,        /* 0x778a */
    KANJI,        /* 0x778b */
    KANJI,        /* 0x778c */
    KANJI,        /* 0x778d */
    KANJI,        /* 0x778e */
    KANJI,        /* 0x778f */
    KANJI,        /* 0x7790 */
    KANJI,        /* 0x7791 */
    KANJI,        /* 0x7792 */
    KANJI,        /* 0x7793 */
    KANJI,        /* 0x7794 */
    KANJI,        /* 0x7795 */
    KANJI,        /* 0x7796 */
    KANJI,        /* 0x7797 */
    KANJI,        /* 0x7798 */
    KANJI,        /* 0x7799 */
    KANJI,        /* 0x779a */
    KANJI,        /* 0x779b */
    KANJI,        /* 0x779c */
    KANJI,        /* 0x779d */
    KANJI,        /* 0x779e */
    KANJI,        /* 0x779f */
    KANJI,        /* 0x77a0 */
    KANJI,        /* 0x77a1 */
    KANJI,        /* 0x77a2 */
    KANJI,        /* 0x77a3 */
    KANJI,        /* 0x77a4 */
    KANJI,        /* 0x77a5 */
    KANJI,        /* 0x77a6 */
    KANJI,        /* 0x77a7 */
    KANJI,        /* 0x77a8 */
    KANJI,        /* 0x77a9 */
    KANJI,        /* 0x77aa */
    KANJI,        /* 0x77ab */
    KANJI,        /* 0x77ac */
    KANJI,        /* 0x77ad */
    KANJI,        /* 0x77ae */
    KANJI,        /* 0x77af */
    KANJI,        /* 0x77b0 */
    KANJI,        /* 0x77b1 */
    KANJI,        /* 0x77b2 */
    KANJI,        /* 0x77b3 */
    KANJI,        /* 0x77b4 */
    KANJI,        /* 0x77b5 */
    KANJI,        /* 0x77b6 */
    KANJI,        /* 0x77b7 */
    KANJI,        /* 0x77b8 */
    KANJI,        /* 0x77b9 */
    KANJI,        /* 0x77ba */
    KANJI,        /* 0x77bb */
    KANJI,        /* 0x77bc */
    KANJI,        /* 0x77bd */
    KANJI,        /* 0x77be */
    KANJI,        /* 0x77bf */
    KANJI,        /* 0x77c0 */
    KANJI,        /* 0x77c1 */
    KANJI,        /* 0x77c2 */
    KANJI,        /* 0x77c3 */
    KANJI,        /* 0x77c4 */
    KANJI,        /* 0x77c5 */
    KANJI,        /* 0x77c6 */
    KANJI,        /* 0x77c7 */
    KANJI,        /* 0x77c8 */
    KANJI,        /* 0x77c9 */
    KANJI,        /* 0x77ca */
    KANJI,        /* 0x77cb */
    KANJI,        /* 0x77cc */
    KANJI,        /* 0x77cd */
    KANJI,        /* 0x77ce */
    KANJI,        /* 0x77cf */
    KANJI,        /* 0x77d0 */
    KANJI,        /* 0x77d1 */
    KANJI,        /* 0x77d2 */
    KANJI,        /* 0x77d3 */
    KANJI,        /* 0x77d4 */
    KANJI,        /* 0x77d5 */
    KANJI,        /* 0x77d6 */
    KANJI,        /* 0x77d7 */
    KANJI,        /* 0x77d8 */
    KANJI,        /* 0x77d9 */
    KANJI,        /* 0x77da */
    KANJI,        /* 0x77db */
    KANJI,        /* 0x77dc */
    KANJI,        /* 0x77dd */
    KANJI,        /* 0x77de */
    KANJI,        /* 0x77df */
    KANJI,        /* 0x77e0 */
    KANJI,        /* 0x77e1 */
    KANJI,        /* 0x77e2 */
    KANJI,        /* 0x77e3 */
    KANJI,        /* 0x77e4 */
    KANJI,        /* 0x77e5 */
    KANJI,        /* 0x77e6 */
    KANJI,        /* 0x77e7 */
    KANJI,        /* 0x77e8 */
    KANJI,        /* 0x77e9 */
    KANJI,        /* 0x77ea */
    KANJI,        /* 0x77eb */
    KANJI,        /* 0x77ec */
    KANJI,        /* 0x77ed */
    KANJI,        /* 0x77ee */
    KANJI,        /* 0x77ef */
    KANJI,        /* 0x77f0 */
    KANJI,        /* 0x77f1 */
    KANJI,        /* 0x77f2 */
    KANJI,        /* 0x77f3 */
    KANJI,        /* 0x77f4 */
    KANJI,        /* 0x77f5 */
    KANJI,        /* 0x77f6 */
    KANJI,        /* 0x77f7 */
    KANJI,        /* 0x77f8 */
    KANJI,        /* 0x77f9 */
    KANJI,        /* 0x77fa */
    KANJI,        /* 0x77fb */
    KANJI,        /* 0x77fc */
    KANJI,        /* 0x77fd */
    KANJI,        /* 0x77fe */
    KANJI,        /* 0x77ff */
    KANJI,        /* 0x7800 */
    KANJI,        /* 0x7801 */
    KANJI,        /* 0x7802 */
    KANJI,        /* 0x7803 */
    KANJI,        /* 0x7804 */
    KANJI,        /* 0x7805 */
    KANJI,        /* 0x7806 */
    KANJI,        /* 0x7807 */
    KANJI,        /* 0x7808 */
    KANJI,        /* 0x7809 */
    KANJI,        /* 0x780a */
    KANJI,        /* 0x780b */
    KANJI,        /* 0x780c */
    KANJI,        /* 0x780d */
    KANJI,        /* 0x780e */
    KANJI,        /* 0x780f */
    KANJI,        /* 0x7810 */
    KANJI,        /* 0x7811 */
    KANJI,        /* 0x7812 */
    KANJI,        /* 0x7813 */
    KANJI,        /* 0x7814 */
    KANJI,        /* 0x7815 */
    KANJI,        /* 0x7816 */
    KANJI,        /* 0x7817 */
    KANJI,        /* 0x7818 */
    KANJI,        /* 0x7819 */
    KANJI,        /* 0x781a */
    KANJI,        /* 0x781b */
    KANJI,        /* 0x781c */
    KANJI,        /* 0x781d */
    KANJI,        /* 0x781e */
    KANJI,        /* 0x781f */
    KANJI,        /* 0x7820 */
    KANJI,        /* 0x7821 */
    KANJI,        /* 0x7822 */
    KANJI,        /* 0x7823 */
    KANJI,        /* 0x7824 */
    KANJI,        /* 0x7825 */
    KANJI,        /* 0x7826 */
    KANJI,        /* 0x7827 */
    KANJI,        /* 0x7828 */
    KANJI,        /* 0x7829 */
    KANJI,        /* 0x782a */
    KANJI,        /* 0x782b */
    KANJI,        /* 0x782c */
    KANJI,        /* 0x782d */
    KANJI,        /* 0x782e */
    KANJI,        /* 0x782f */
    KANJI,        /* 0x7830 */
    KANJI,        /* 0x7831 */
    KANJI,        /* 0x7832 */
    KANJI,        /* 0x7833 */
    KANJI,        /* 0x7834 */
    KANJI,        /* 0x7835 */
    KANJI,        /* 0x7836 */
    KANJI,        /* 0x7837 */
    KANJI,        /* 0x7838 */
    KANJI,        /* 0x7839 */
    KANJI,        /* 0x783a */
    KANJI,        /* 0x783b */
    KANJI,        /* 0x783c */
    KANJI,        /* 0x783d */
    KANJI,        /* 0x783e */
    KANJI,        /* 0x783f */
    KANJI,        /* 0x7840 */
    KANJI,        /* 0x7841 */
    KANJI,        /* 0x7842 */
    KANJI,        /* 0x7843 */
    KANJI,        /* 0x7844 */
    KANJI,        /* 0x7845 */
    KANJI,        /* 0x7846 */
    KANJI,        /* 0x7847 */
    KANJI,        /* 0x7848 */
    KANJI,        /* 0x7849 */
    KANJI,        /* 0x784a */
    KANJI,        /* 0x784b */
    KANJI,        /* 0x784c */
    KANJI,        /* 0x784d */
    KANJI,        /* 0x784e */
    KANJI,        /* 0x784f */
    KANJI,        /* 0x7850 */
    KANJI,        /* 0x7851 */
    KANJI,        /* 0x7852 */
    KANJI,        /* 0x7853 */
    KANJI,        /* 0x7854 */
    KANJI,        /* 0x7855 */
    KANJI,        /* 0x7856 */
    KANJI,        /* 0x7857 */
    KANJI,        /* 0x7858 */
    KANJI,        /* 0x7859 */
    KANJI,        /* 0x785a */
    KANJI,        /* 0x785b */
    KANJI,        /* 0x785c */
    KANJI,        /* 0x785d */
    KANJI,        /* 0x785e */
    KANJI,        /* 0x785f */
    KANJI,        /* 0x7860 */
    KANJI,        /* 0x7861 */
    KANJI,        /* 0x7862 */
    KANJI,        /* 0x7863 */
    KANJI,        /* 0x7864 */
    KANJI,        /* 0x7865 */
    KANJI,        /* 0x7866 */
    KANJI,        /* 0x7867 */
    KANJI,        /* 0x7868 */
    KANJI,        /* 0x7869 */
    KANJI,        /* 0x786a */
    KANJI,        /* 0x786b */
    KANJI,        /* 0x786c */
    KANJI,        /* 0x786d */
    KANJI,        /* 0x786e */
    KANJI,        /* 0x786f */
    KANJI,        /* 0x7870 */
    KANJI,        /* 0x7871 */
    KANJI,        /* 0x7872 */
    KANJI,        /* 0x7873 */
    KANJI,        /* 0x7874 */
    KANJI,        /* 0x7875 */
    KANJI,        /* 0x7876 */
    KANJI,        /* 0x7877 */
    KANJI,        /* 0x7878 */
    KANJI,        /* 0x7879 */
    KANJI,        /* 0x787a */
    KANJI,        /* 0x787b */
    KANJI,        /* 0x787c */
    KANJI,        /* 0x787d */
    KANJI,        /* 0x787e */
    KANJI,        /* 0x787f */
    KANJI,        /* 0x7880 */
    KANJI,        /* 0x7881 */
    KANJI,        /* 0x7882 */
    KANJI,        /* 0x7883 */
    KANJI,        /* 0x7884 */
    KANJI,        /* 0x7885 */
    KANJI,        /* 0x7886 */
    KANJI,        /* 0x7887 */
    KANJI,        /* 0x7888 */
    KANJI,        /* 0x7889 */
    KANJI,        /* 0x788a */
    KANJI,        /* 0x788b */
    KANJI,        /* 0x788c */
    KANJI,        /* 0x788d */
    KANJI,        /* 0x788e */
    KANJI,        /* 0x788f */
    KANJI,        /* 0x7890 */
    KANJI,        /* 0x7891 */
    KANJI,        /* 0x7892 */
    KANJI,        /* 0x7893 */
    KANJI,        /* 0x7894 */
    KANJI,        /* 0x7895 */
    KANJI,        /* 0x7896 */
    KANJI,        /* 0x7897 */
    KANJI,        /* 0x7898 */
    KANJI,        /* 0x7899 */
    KANJI,        /* 0x789a */
    KANJI,        /* 0x789b */
    KANJI,        /* 0x789c */
    KANJI,        /* 0x789d */
    KANJI,        /* 0x789e */
    KANJI,        /* 0x789f */
    KANJI,        /* 0x78a0 */
    KANJI,        /* 0x78a1 */
    KANJI,        /* 0x78a2 */
    KANJI,        /* 0x78a3 */
    KANJI,        /* 0x78a4 */
    KANJI,        /* 0x78a5 */
    KANJI,        /* 0x78a6 */
    KANJI,        /* 0x78a7 */
    KANJI,        /* 0x78a8 */
    KANJI,        /* 0x78a9 */
    KANJI,        /* 0x78aa */
    KANJI,        /* 0x78ab */
    KANJI,        /* 0x78ac */
    KANJI,        /* 0x78ad */
    KANJI,        /* 0x78ae */
    KANJI,        /* 0x78af */
    KANJI,        /* 0x78b0 */
    KANJI,        /* 0x78b1 */
    KANJI,        /* 0x78b2 */
    KANJI,        /* 0x78b3 */
    KANJI,        /* 0x78b4 */
    KANJI,        /* 0x78b5 */
    KANJI,        /* 0x78b6 */
    KANJI,        /* 0x78b7 */
    KANJI,        /* 0x78b8 */
    KANJI,        /* 0x78b9 */
    KANJI,        /* 0x78ba */
    KANJI,        /* 0x78bb */
    KANJI,        /* 0x78bc */
    KANJI,        /* 0x78bd */
    KANJI,        /* 0x78be */
    KANJI,        /* 0x78bf */
    KANJI,        /* 0x78c0 */
    KANJI,        /* 0x78c1 */
    KANJI,        /* 0x78c2 */
    KANJI,        /* 0x78c3 */
    KANJI,        /* 0x78c4 */
    KANJI,        /* 0x78c5 */
    KANJI,        /* 0x78c6 */
    KANJI,        /* 0x78c7 */
    KANJI,        /* 0x78c8 */
    KANJI,        /* 0x78c9 */
    KANJI,        /* 0x78ca */
    KANJI,        /* 0x78cb */
    KANJI,        /* 0x78cc */
    KANJI,        /* 0x78cd */
    KANJI,        /* 0x78ce */
    KANJI,        /* 0x78cf */
    KANJI,        /* 0x78d0 */
    KANJI,        /* 0x78d1 */
    KANJI,        /* 0x78d2 */
    KANJI,        /* 0x78d3 */
    KANJI,        /* 0x78d4 */
    KANJI,        /* 0x78d5 */
    KANJI,        /* 0x78d6 */
    KANJI,        /* 0x78d7 */
    KANJI,        /* 0x78d8 */
    KANJI,        /* 0x78d9 */
    KANJI,        /* 0x78da */
    KANJI,        /* 0x78db */
    KANJI,        /* 0x78dc */
    KANJI,        /* 0x78dd */
    KANJI,        /* 0x78de */
    KANJI,        /* 0x78df */
    KANJI,        /* 0x78e0 */
    KANJI,        /* 0x78e1 */
    KANJI,        /* 0x78e2 */
    KANJI,        /* 0x78e3 */
    KANJI,        /* 0x78e4 */
    KANJI,        /* 0x78e5 */
    KANJI,        /* 0x78e6 */
    KANJI,        /* 0x78e7 */
    KANJI,        /* 0x78e8 */
    KANJI,        /* 0x78e9 */
    KANJI,        /* 0x78ea */
    KANJI,        /* 0x78eb */
    KANJI,        /* 0x78ec */
    KANJI,        /* 0x78ed */
    KANJI,        /* 0x78ee */
    KANJI,        /* 0x78ef */
    KANJI,        /* 0x78f0 */
    KANJI,        /* 0x78f1 */
    KANJI,        /* 0x78f2 */
    KANJI,        /* 0x78f3 */
    KANJI,        /* 0x78f4 */
    KANJI,        /* 0x78f5 */
    KANJI,        /* 0x78f6 */
    KANJI,        /* 0x78f7 */
    KANJI,        /* 0x78f8 */
    KANJI,        /* 0x78f9 */
    KANJI,        /* 0x78fa */
    KANJI,        /* 0x78fb */
    KANJI,        /* 0x78fc */
    KANJI,        /* 0x78fd */
    KANJI,        /* 0x78fe */
    KANJI,        /* 0x78ff */
    KANJI,        /* 0x7900 */
    KANJI,        /* 0x7901 */
    KANJI,        /* 0x7902 */
    KANJI,        /* 0x7903 */
    KANJI,        /* 0x7904 */
    KANJI,        /* 0x7905 */
    KANJI,        /* 0x7906 */
    KANJI,        /* 0x7907 */
    KANJI,        /* 0x7908 */
    KANJI,        /* 0x7909 */
    KANJI,        /* 0x790a */
    KANJI,        /* 0x790b */
    KANJI,        /* 0x790c */
    KANJI,        /* 0x790d */
    KANJI,        /* 0x790e */
    KANJI,        /* 0x790f */
    KANJI,        /* 0x7910 */
    KANJI,        /* 0x7911 */
    KANJI,        /* 0x7912 */
    KANJI,        /* 0x7913 */
    KANJI,        /* 0x7914 */
    KANJI,        /* 0x7915 */
    KANJI,        /* 0x7916 */
    KANJI,        /* 0x7917 */
    KANJI,        /* 0x7918 */
    KANJI,        /* 0x7919 */
    KANJI,        /* 0x791a */
    KANJI,        /* 0x791b */
    KANJI,        /* 0x791c */
    KANJI,        /* 0x791d */
    KANJI,        /* 0x791e */
    KANJI,        /* 0x791f */
    KANJI,        /* 0x7920 */
    KANJI,        /* 0x7921 */
    KANJI,        /* 0x7922 */
    KANJI,        /* 0x7923 */
    KANJI,        /* 0x7924 */
    KANJI,        /* 0x7925 */
    KANJI,        /* 0x7926 */
    KANJI,        /* 0x7927 */
    KANJI,        /* 0x7928 */
    KANJI,        /* 0x7929 */
    KANJI,        /* 0x792a */
    KANJI,        /* 0x792b */
    KANJI,        /* 0x792c */
    KANJI,        /* 0x792d */
    KANJI,        /* 0x792e */
    KANJI,        /* 0x792f */
    KANJI,        /* 0x7930 */
    KANJI,        /* 0x7931 */
    KANJI,        /* 0x7932 */
    KANJI,        /* 0x7933 */
    KANJI,        /* 0x7934 */
    KANJI,        /* 0x7935 */
    KANJI,        /* 0x7936 */
    KANJI,        /* 0x7937 */
    KANJI,        /* 0x7938 */
    KANJI,        /* 0x7939 */
    KANJI,        /* 0x793a */
    KANJI,        /* 0x793b */
    KANJI,        /* 0x793c */
    KANJI,        /* 0x793d */
    KANJI,        /* 0x793e */
    KANJI,        /* 0x793f */
    KANJI,        /* 0x7940 */
    KANJI,        /* 0x7941 */
    KANJI,        /* 0x7942 */
    KANJI,        /* 0x7943 */
    KANJI,        /* 0x7944 */
    KANJI,        /* 0x7945 */
    KANJI,        /* 0x7946 */
    KANJI,        /* 0x7947 */
    KANJI,        /* 0x7948 */
    KANJI,        /* 0x7949 */
    KANJI,        /* 0x794a */
    KANJI,        /* 0x794b */
    KANJI,        /* 0x794c */
    KANJI,        /* 0x794d */
    KANJI,        /* 0x794e */
    KANJI,        /* 0x794f */
    KANJI,        /* 0x7950 */
    KANJI,        /* 0x7951 */
    KANJI,        /* 0x7952 */
    KANJI,        /* 0x7953 */
    KANJI,        /* 0x7954 */
    KANJI,        /* 0x7955 */
    KANJI,        /* 0x7956 */
    KANJI,        /* 0x7957 */
    KANJI,        /* 0x7958 */
    KANJI,        /* 0x7959 */
    KANJI,        /* 0x795a */
    KANJI,        /* 0x795b */
    KANJI,        /* 0x795c */
    KANJI,        /* 0x795d */
    KANJI,        /* 0x795e */
    KANJI,        /* 0x795f */
    KANJI,        /* 0x7960 */
    KANJI,        /* 0x7961 */
    KANJI,        /* 0x7962 */
    KANJI,        /* 0x7963 */
    KANJI,        /* 0x7964 */
    KANJI,        /* 0x7965 */
    KANJI,        /* 0x7966 */
    KANJI,        /* 0x7967 */
    KANJI,        /* 0x7968 */
    KANJI,        /* 0x7969 */
    KANJI,        /* 0x796a */
    KANJI,        /* 0x796b */
    KANJI,        /* 0x796c */
    KANJI,        /* 0x796d */
    KANJI,        /* 0x796e */
    KANJI,        /* 0x796f */
    KANJI,        /* 0x7970 */
    KANJI,        /* 0x7971 */
    KANJI,        /* 0x7972 */
    KANJI,        /* 0x7973 */
    KANJI,        /* 0x7974 */
    KANJI,        /* 0x7975 */
    KANJI,        /* 0x7976 */
    KANJI,        /* 0x7977 */
    KANJI,        /* 0x7978 */
    KANJI,        /* 0x7979 */
    KANJI,        /* 0x797a */
    KANJI,        /* 0x797b */
    KANJI,        /* 0x797c */
    KANJI,        /* 0x797d */
    KANJI,        /* 0x797e */
    KANJI,        /* 0x797f */
    KANJI,        /* 0x7980 */
    KANJI,        /* 0x7981 */
    KANJI,        /* 0x7982 */
    KANJI,        /* 0x7983 */
    KANJI,        /* 0x7984 */
    KANJI,        /* 0x7985 */
    KANJI,        /* 0x7986 */
    KANJI,        /* 0x7987 */
    KANJI,        /* 0x7988 */
    KANJI,        /* 0x7989 */
    KANJI,        /* 0x798a */
    KANJI,        /* 0x798b */
    KANJI,        /* 0x798c */
    KANJI,        /* 0x798d */
    KANJI,        /* 0x798e */
    KANJI,        /* 0x798f */
    KANJI,        /* 0x7990 */
    KANJI,        /* 0x7991 */
    KANJI,        /* 0x7992 */
    KANJI,        /* 0x7993 */
    KANJI,        /* 0x7994 */
    KANJI,        /* 0x7995 */
    KANJI,        /* 0x7996 */
    KANJI,        /* 0x7997 */
    KANJI,        /* 0x7998 */
    KANJI,        /* 0x7999 */
    KANJI,        /* 0x799a */
    KANJI,        /* 0x799b */
    KANJI,        /* 0x799c */
    KANJI,        /* 0x799d */
    KANJI,        /* 0x799e */
    KANJI,        /* 0x799f */
    KANJI,        /* 0x79a0 */
    KANJI,        /* 0x79a1 */
    KANJI,        /* 0x79a2 */
    KANJI,        /* 0x79a3 */
    KANJI,        /* 0x79a4 */
    KANJI,        /* 0x79a5 */
    KANJI,        /* 0x79a6 */
    KANJI,        /* 0x79a7 */
    KANJI,        /* 0x79a8 */
    KANJI,        /* 0x79a9 */
    KANJI,        /* 0x79aa */
    KANJI,        /* 0x79ab */
    KANJI,        /* 0x79ac */
    KANJI,        /* 0x79ad */
    KANJI,        /* 0x79ae */
    KANJI,        /* 0x79af */
    KANJI,        /* 0x79b0 */
    KANJI,        /* 0x79b1 */
    KANJI,        /* 0x79b2 */
    KANJI,        /* 0x79b3 */
    KANJI,        /* 0x79b4 */
    KANJI,        /* 0x79b5 */
    KANJI,        /* 0x79b6 */
    KANJI,        /* 0x79b7 */
    KANJI,        /* 0x79b8 */
    KANJI,        /* 0x79b9 */
    KANJI,        /* 0x79ba */
    KANJI,        /* 0x79bb */
    KANJI,        /* 0x79bc */
    KANJI,        /* 0x79bd */
    KANJI,        /* 0x79be */
    KANJI,        /* 0x79bf */
    KANJI,        /* 0x79c0 */
    KANJI,        /* 0x79c1 */
    KANJI,        /* 0x79c2 */
    KANJI,        /* 0x79c3 */
    KANJI,        /* 0x79c4 */
    KANJI,        /* 0x79c5 */
    KANJI,        /* 0x79c6 */
    KANJI,        /* 0x79c7 */
    KANJI,        /* 0x79c8 */
    KANJI,        /* 0x79c9 */
    KANJI,        /* 0x79ca */
    KANJI,        /* 0x79cb */
    KANJI,        /* 0x79cc */
    KANJI,        /* 0x79cd */
    KANJI,        /* 0x79ce */
    KANJI,        /* 0x79cf */
    KANJI,        /* 0x79d0 */
    KANJI,        /* 0x79d1 */
    KANJI,        /* 0x79d2 */
    KANJI,        /* 0x79d3 */
    KANJI,        /* 0x79d4 */
    KANJI,        /* 0x79d5 */
    KANJI,        /* 0x79d6 */
    KANJI,        /* 0x79d7 */
    KANJI,        /* 0x79d8 */
    KANJI,        /* 0x79d9 */
    KANJI,        /* 0x79da */
    KANJI,        /* 0x79db */
    KANJI,        /* 0x79dc */
    KANJI,        /* 0x79dd */
    KANJI,        /* 0x79de */
    KANJI,        /* 0x79df */
    KANJI,        /* 0x79e0 */
    KANJI,        /* 0x79e1 */
    KANJI,        /* 0x79e2 */
    KANJI,        /* 0x79e3 */
    KANJI,        /* 0x79e4 */
    KANJI,        /* 0x79e5 */
    KANJI,        /* 0x79e6 */
    KANJI,        /* 0x79e7 */
    KANJI,        /* 0x79e8 */
    KANJI,        /* 0x79e9 */
    KANJI,        /* 0x79ea */
    KANJI,        /* 0x79eb */
    KANJI,        /* 0x79ec */
    KANJI,        /* 0x79ed */
    KANJI,        /* 0x79ee */
    KANJI,        /* 0x79ef */
    KANJI,        /* 0x79f0 */
    KANJI,        /* 0x79f1 */
    KANJI,        /* 0x79f2 */
    KANJI,        /* 0x79f3 */
    KANJI,        /* 0x79f4 */
    KANJI,        /* 0x79f5 */
    KANJI,        /* 0x79f6 */
    KANJI,        /* 0x79f7 */
    KANJI,        /* 0x79f8 */
    KANJI,        /* 0x79f9 */
    KANJI,        /* 0x79fa */
    KANJI,        /* 0x79fb */
    KANJI,        /* 0x79fc */
    KANJI,        /* 0x79fd */
    KANJI,        /* 0x79fe */
    KANJI,        /* 0x79ff */
    KANJI,        /* 0x7a00 */
    KANJI,        /* 0x7a01 */
    KANJI,        /* 0x7a02 */
    KANJI,        /* 0x7a03 */
    KANJI,        /* 0x7a04 */
    KANJI,        /* 0x7a05 */
    KANJI,        /* 0x7a06 */
    KANJI,        /* 0x7a07 */
    KANJI,        /* 0x7a08 */
    KANJI,        /* 0x7a09 */
    KANJI,        /* 0x7a0a */
    KANJI,        /* 0x7a0b */
    KANJI,        /* 0x7a0c */
    KANJI,        /* 0x7a0d */
    KANJI,        /* 0x7a0e */
    KANJI,        /* 0x7a0f */
    KANJI,        /* 0x7a10 */
    KANJI,        /* 0x7a11 */
    KANJI,        /* 0x7a12 */
    KANJI,        /* 0x7a13 */
    KANJI,        /* 0x7a14 */
    KANJI,        /* 0x7a15 */
    KANJI,        /* 0x7a16 */
    KANJI,        /* 0x7a17 */
    KANJI,        /* 0x7a18 */
    KANJI,        /* 0x7a19 */
    KANJI,        /* 0x7a1a */
    KANJI,        /* 0x7a1b */
    KANJI,        /* 0x7a1c */
    KANJI,        /* 0x7a1d */
    KANJI,        /* 0x7a1e */
    KANJI,        /* 0x7a1f */
    KANJI,        /* 0x7a20 */
    KANJI,        /* 0x7a21 */
    KANJI,        /* 0x7a22 */
    KANJI,        /* 0x7a23 */
    KANJI,        /* 0x7a24 */
    KANJI,        /* 0x7a25 */
    KANJI,        /* 0x7a26 */
    KANJI,        /* 0x7a27 */
    KANJI,        /* 0x7a28 */
    KANJI,        /* 0x7a29 */
    KANJI,        /* 0x7a2a */
    KANJI,        /* 0x7a2b */
    KANJI,        /* 0x7a2c */
    KANJI,        /* 0x7a2d */
    KANJI,        /* 0x7a2e */
    KANJI,        /* 0x7a2f */
    KANJI,        /* 0x7a30 */
    KANJI,        /* 0x7a31 */
    KANJI,        /* 0x7a32 */
    KANJI,        /* 0x7a33 */
    KANJI,        /* 0x7a34 */
    KANJI,        /* 0x7a35 */
    KANJI,        /* 0x7a36 */
    KANJI,        /* 0x7a37 */
    KANJI,        /* 0x7a38 */
    KANJI,        /* 0x7a39 */
    KANJI,        /* 0x7a3a */
    KANJI,        /* 0x7a3b */
    KANJI,        /* 0x7a3c */
    KANJI,        /* 0x7a3d */
    KANJI,        /* 0x7a3e */
    KANJI,        /* 0x7a3f */
    KANJI,        /* 0x7a40 */
    KANJI,        /* 0x7a41 */
    KANJI,        /* 0x7a42 */
    KANJI,        /* 0x7a43 */
    KANJI,        /* 0x7a44 */
    KANJI,        /* 0x7a45 */
    KANJI,        /* 0x7a46 */
    KANJI,        /* 0x7a47 */
    KANJI,        /* 0x7a48 */
    KANJI,        /* 0x7a49 */
    KANJI,        /* 0x7a4a */
    KANJI,        /* 0x7a4b */
    KANJI,        /* 0x7a4c */
    KANJI,        /* 0x7a4d */
    KANJI,        /* 0x7a4e */
    KANJI,        /* 0x7a4f */
    KANJI,        /* 0x7a50 */
    KANJI,        /* 0x7a51 */
    KANJI,        /* 0x7a52 */
    KANJI,        /* 0x7a53 */
    KANJI,        /* 0x7a54 */
    KANJI,        /* 0x7a55 */
    KANJI,        /* 0x7a56 */
    KANJI,        /* 0x7a57 */
    KANJI,        /* 0x7a58 */
    KANJI,        /* 0x7a59 */
    KANJI,        /* 0x7a5a */
    KANJI,        /* 0x7a5b */
    KANJI,        /* 0x7a5c */
    KANJI,        /* 0x7a5d */
    KANJI,        /* 0x7a5e */
    KANJI,        /* 0x7a5f */
    KANJI,        /* 0x7a60 */
    KANJI,        /* 0x7a61 */
    KANJI,        /* 0x7a62 */
    KANJI,        /* 0x7a63 */
    KANJI,        /* 0x7a64 */
    KANJI,        /* 0x7a65 */
    KANJI,        /* 0x7a66 */
    KANJI,        /* 0x7a67 */
    KANJI,        /* 0x7a68 */
    KANJI,        /* 0x7a69 */
    KANJI,        /* 0x7a6a */
    KANJI,        /* 0x7a6b */
    KANJI,        /* 0x7a6c */
    KANJI,        /* 0x7a6d */
    KANJI,        /* 0x7a6e */
    KANJI,        /* 0x7a6f */
    KANJI,        /* 0x7a70 */
    KANJI,        /* 0x7a71 */
    KANJI,        /* 0x7a72 */
    KANJI,        /* 0x7a73 */
    KANJI,        /* 0x7a74 */
    KANJI,        /* 0x7a75 */
    KANJI,        /* 0x7a76 */
    KANJI,        /* 0x7a77 */
    KANJI,        /* 0x7a78 */
    KANJI,        /* 0x7a79 */
    KANJI,        /* 0x7a7a */
    KANJI,        /* 0x7a7b */
    KANJI,        /* 0x7a7c */
    KANJI,        /* 0x7a7d */
    KANJI,        /* 0x7a7e */
    KANJI,        /* 0x7a7f */
    KANJI,        /* 0x7a80 */
    KANJI,        /* 0x7a81 */
    KANJI,        /* 0x7a82 */
    KANJI,        /* 0x7a83 */
    KANJI,        /* 0x7a84 */
    KANJI,        /* 0x7a85 */
    KANJI,        /* 0x7a86 */
    KANJI,        /* 0x7a87 */
    KANJI,        /* 0x7a88 */
    KANJI,        /* 0x7a89 */
    KANJI,        /* 0x7a8a */
    KANJI,        /* 0x7a8b */
    KANJI,        /* 0x7a8c */
    KANJI,        /* 0x7a8d */
    KANJI,        /* 0x7a8e */
    KANJI,        /* 0x7a8f */
    KANJI,        /* 0x7a90 */
    KANJI,        /* 0x7a91 */
    KANJI,        /* 0x7a92 */
    KANJI,        /* 0x7a93 */
    KANJI,        /* 0x7a94 */
    KANJI,        /* 0x7a95 */
    KANJI,        /* 0x7a96 */
    KANJI,        /* 0x7a97 */
    KANJI,        /* 0x7a98 */
    KANJI,        /* 0x7a99 */
    KANJI,        /* 0x7a9a */
    KANJI,        /* 0x7a9b */
    KANJI,        /* 0x7a9c */
    KANJI,        /* 0x7a9d */
    KANJI,        /* 0x7a9e */
    KANJI,        /* 0x7a9f */
    KANJI,        /* 0x7aa0 */
    KANJI,        /* 0x7aa1 */
    KANJI,        /* 0x7aa2 */
    KANJI,        /* 0x7aa3 */
    KANJI,        /* 0x7aa4 */
    KANJI,        /* 0x7aa5 */
    KANJI,        /* 0x7aa6 */
    KANJI,        /* 0x7aa7 */
    KANJI,        /* 0x7aa8 */
    KANJI,        /* 0x7aa9 */
    KANJI,        /* 0x7aaa */
    KANJI,        /* 0x7aab */
    KANJI,        /* 0x7aac */
    KANJI,        /* 0x7aad */
    KANJI,        /* 0x7aae */
    KANJI,        /* 0x7aaf */
    KANJI,        /* 0x7ab0 */
    KANJI,        /* 0x7ab1 */
    KANJI,        /* 0x7ab2 */
    KANJI,        /* 0x7ab3 */
    KANJI,        /* 0x7ab4 */
    KANJI,        /* 0x7ab5 */
    KANJI,        /* 0x7ab6 */
    KANJI,        /* 0x7ab7 */
    KANJI,        /* 0x7ab8 */
    KANJI,        /* 0x7ab9 */
    KANJI,        /* 0x7aba */
    KANJI,        /* 0x7abb */
    KANJI,        /* 0x7abc */
    KANJI,        /* 0x7abd */
    KANJI,        /* 0x7abe */
    KANJI,        /* 0x7abf */
    KANJI,        /* 0x7ac0 */
    KANJI,        /* 0x7ac1 */
    KANJI,        /* 0x7ac2 */
    KANJI,        /* 0x7ac3 */
    KANJI,        /* 0x7ac4 */
    KANJI,        /* 0x7ac5 */
    KANJI,        /* 0x7ac6 */
    KANJI,        /* 0x7ac7 */
    KANJI,        /* 0x7ac8 */
    KANJI,        /* 0x7ac9 */
    KANJI,        /* 0x7aca */
    KANJI,        /* 0x7acb */
    KANJI,        /* 0x7acc */
    KANJI,        /* 0x7acd */
    KANJI,        /* 0x7ace */
    KANJI,        /* 0x7acf */
    KANJI,        /* 0x7ad0 */
    KANJI,        /* 0x7ad1 */
    KANJI,        /* 0x7ad2 */
    KANJI,        /* 0x7ad3 */
    KANJI,        /* 0x7ad4 */
    KANJI,        /* 0x7ad5 */
    KANJI,        /* 0x7ad6 */
    KANJI,        /* 0x7ad7 */
    KANJI,        /* 0x7ad8 */
    KANJI,        /* 0x7ad9 */
    KANJI,        /* 0x7ada */
    KANJI,        /* 0x7adb */
    KANJI,        /* 0x7adc */
    KANJI,        /* 0x7add */
    KANJI,        /* 0x7ade */
    KANJI,        /* 0x7adf */
    KANJI,        /* 0x7ae0 */
    KANJI,        /* 0x7ae1 */
    KANJI,        /* 0x7ae2 */
    KANJI,        /* 0x7ae3 */
    KANJI,        /* 0x7ae4 */
    KANJI,        /* 0x7ae5 */
    KANJI,        /* 0x7ae6 */
    KANJI,        /* 0x7ae7 */
    KANJI,        /* 0x7ae8 */
    KANJI,        /* 0x7ae9 */
    KANJI,        /* 0x7aea */
    KANJI,        /* 0x7aeb */
    KANJI,        /* 0x7aec */
    KANJI,        /* 0x7aed */
    KANJI,        /* 0x7aee */
    KANJI,        /* 0x7aef */
    KANJI,        /* 0x7af0 */
    KANJI,        /* 0x7af1 */
    KANJI,        /* 0x7af2 */
    KANJI,        /* 0x7af3 */
    KANJI,        /* 0x7af4 */
    KANJI,        /* 0x7af5 */
    KANJI,        /* 0x7af6 */
    KANJI,        /* 0x7af7 */
    KANJI,        /* 0x7af8 */
    KANJI,        /* 0x7af9 */
    KANJI,        /* 0x7afa */
    KANJI,        /* 0x7afb */
    KANJI,        /* 0x7afc */
    KANJI,        /* 0x7afd */
    KANJI,        /* 0x7afe */
    KANJI,        /* 0x7aff */
    KANJI,        /* 0x7b00 */
    KANJI,        /* 0x7b01 */
    KANJI,        /* 0x7b02 */
    KANJI,        /* 0x7b03 */
    KANJI,        /* 0x7b04 */
    KANJI,        /* 0x7b05 */
    KANJI,        /* 0x7b06 */
    KANJI,        /* 0x7b07 */
    KANJI,        /* 0x7b08 */
    KANJI,        /* 0x7b09 */
    KANJI,        /* 0x7b0a */
    KANJI,        /* 0x7b0b */
    KANJI,        /* 0x7b0c */
    KANJI,        /* 0x7b0d */
    KANJI,        /* 0x7b0e */
    KANJI,        /* 0x7b0f */
    KANJI,        /* 0x7b10 */
    KANJI,        /* 0x7b11 */
    KANJI,        /* 0x7b12 */
    KANJI,        /* 0x7b13 */
    KANJI,        /* 0x7b14 */
    KANJI,        /* 0x7b15 */
    KANJI,        /* 0x7b16 */
    KANJI,        /* 0x7b17 */
    KANJI,        /* 0x7b18 */
    KANJI,        /* 0x7b19 */
    KANJI,        /* 0x7b1a */
    KANJI,        /* 0x7b1b */
    KANJI,        /* 0x7b1c */
    KANJI,        /* 0x7b1d */
    KANJI,        /* 0x7b1e */
    KANJI,        /* 0x7b1f */
    KANJI,        /* 0x7b20 */
    KANJI,        /* 0x7b21 */
    KANJI,        /* 0x7b22 */
    KANJI,        /* 0x7b23 */
    KANJI,        /* 0x7b24 */
    KANJI,        /* 0x7b25 */
    KANJI,        /* 0x7b26 */
    KANJI,        /* 0x7b27 */
    KANJI,        /* 0x7b28 */
    KANJI,        /* 0x7b29 */
    KANJI,        /* 0x7b2a */
    KANJI,        /* 0x7b2b */
    KANJI,        /* 0x7b2c */
    KANJI,        /* 0x7b2d */
    KANJI,        /* 0x7b2e */
    KANJI,        /* 0x7b2f */
    KANJI,        /* 0x7b30 */
    KANJI,        /* 0x7b31 */
    KANJI,        /* 0x7b32 */
    KANJI,        /* 0x7b33 */
    KANJI,        /* 0x7b34 */
    KANJI,        /* 0x7b35 */
    KANJI,        /* 0x7b36 */
    KANJI,        /* 0x7b37 */
    KANJI,        /* 0x7b38 */
    KANJI,        /* 0x7b39 */
    KANJI,        /* 0x7b3a */
    KANJI,        /* 0x7b3b */
    KANJI,        /* 0x7b3c */
    KANJI,        /* 0x7b3d */
    KANJI,        /* 0x7b3e */
    KANJI,        /* 0x7b3f */
    KANJI,        /* 0x7b40 */
    KANJI,        /* 0x7b41 */
    KANJI,        /* 0x7b42 */
    KANJI,        /* 0x7b43 */
    KANJI,        /* 0x7b44 */
    KANJI,        /* 0x7b45 */
    KANJI,        /* 0x7b46 */
    KANJI,        /* 0x7b47 */
    KANJI,        /* 0x7b48 */
    KANJI,        /* 0x7b49 */
    KANJI,        /* 0x7b4a */
    KANJI,        /* 0x7b4b */
    KANJI,        /* 0x7b4c */
    KANJI,        /* 0x7b4d */
    KANJI,        /* 0x7b4e */
    KANJI,        /* 0x7b4f */
    KANJI,        /* 0x7b50 */
    KANJI,        /* 0x7b51 */
    KANJI,        /* 0x7b52 */
    KANJI,        /* 0x7b53 */
    KANJI,        /* 0x7b54 */
    KANJI,        /* 0x7b55 */
    KANJI,        /* 0x7b56 */
    KANJI,        /* 0x7b57 */
    KANJI,        /* 0x7b58 */
    KANJI,        /* 0x7b59 */
    KANJI,        /* 0x7b5a */
    KANJI,        /* 0x7b5b */
    KANJI,        /* 0x7b5c */
    KANJI,        /* 0x7b5d */
    KANJI,        /* 0x7b5e */
    KANJI,        /* 0x7b5f */
    KANJI,        /* 0x7b60 */
    KANJI,        /* 0x7b61 */
    KANJI,        /* 0x7b62 */
    KANJI,        /* 0x7b63 */
    KANJI,        /* 0x7b64 */
    KANJI,        /* 0x7b65 */
    KANJI,        /* 0x7b66 */
    KANJI,        /* 0x7b67 */
    KANJI,        /* 0x7b68 */
    KANJI,        /* 0x7b69 */
    KANJI,        /* 0x7b6a */
    KANJI,        /* 0x7b6b */
    KANJI,        /* 0x7b6c */
    KANJI,        /* 0x7b6d */
    KANJI,        /* 0x7b6e */
    KANJI,        /* 0x7b6f */
    KANJI,        /* 0x7b70 */
    KANJI,        /* 0x7b71 */
    KANJI,        /* 0x7b72 */
    KANJI,        /* 0x7b73 */
    KANJI,        /* 0x7b74 */
    KANJI,        /* 0x7b75 */
    KANJI,        /* 0x7b76 */
    KANJI,        /* 0x7b77 */
    KANJI,        /* 0x7b78 */
    KANJI,        /* 0x7b79 */
    KANJI,        /* 0x7b7a */
    KANJI,        /* 0x7b7b */
    KANJI,        /* 0x7b7c */
    KANJI,        /* 0x7b7d */
    KANJI,        /* 0x7b7e */
    KANJI,        /* 0x7b7f */
    KANJI,        /* 0x7b80 */
    KANJI,        /* 0x7b81 */
    KANJI,        /* 0x7b82 */
    KANJI,        /* 0x7b83 */
    KANJI,        /* 0x7b84 */
    KANJI,        /* 0x7b85 */
    KANJI,        /* 0x7b86 */
    KANJI,        /* 0x7b87 */
    KANJI,        /* 0x7b88 */
    KANJI,        /* 0x7b89 */
    KANJI,        /* 0x7b8a */
    KANJI,        /* 0x7b8b */
    KANJI,        /* 0x7b8c */
    KANJI,        /* 0x7b8d */
    KANJI,        /* 0x7b8e */
    KANJI,        /* 0x7b8f */
    KANJI,        /* 0x7b90 */
    KANJI,        /* 0x7b91 */
    KANJI,        /* 0x7b92 */
    KANJI,        /* 0x7b93 */
    KANJI,        /* 0x7b94 */
    KANJI,        /* 0x7b95 */
    KANJI,        /* 0x7b96 */
    KANJI,        /* 0x7b97 */
    KANJI,        /* 0x7b98 */
    KANJI,        /* 0x7b99 */
    KANJI,        /* 0x7b9a */
    KANJI,        /* 0x7b9b */
    KANJI,        /* 0x7b9c */
    KANJI,        /* 0x7b9d */
    KANJI,        /* 0x7b9e */
    KANJI,        /* 0x7b9f */
    KANJI,        /* 0x7ba0 */
    KANJI,        /* 0x7ba1 */
    KANJI,        /* 0x7ba2 */
    KANJI,        /* 0x7ba3 */
    KANJI,        /* 0x7ba4 */
    KANJI,        /* 0x7ba5 */
    KANJI,        /* 0x7ba6 */
    KANJI,        /* 0x7ba7 */
    KANJI,        /* 0x7ba8 */
    KANJI,        /* 0x7ba9 */
    KANJI,        /* 0x7baa */
    KANJI,        /* 0x7bab */
    KANJI,        /* 0x7bac */
    KANJI,        /* 0x7bad */
    KANJI,        /* 0x7bae */
    KANJI,        /* 0x7baf */
    KANJI,        /* 0x7bb0 */
    KANJI,        /* 0x7bb1 */
    KANJI,        /* 0x7bb2 */
    KANJI,        /* 0x7bb3 */
    KANJI,        /* 0x7bb4 */
    KANJI,        /* 0x7bb5 */
    KANJI,        /* 0x7bb6 */
    KANJI,        /* 0x7bb7 */
    KANJI,        /* 0x7bb8 */
    KANJI,        /* 0x7bb9 */
    KANJI,        /* 0x7bba */
    KANJI,        /* 0x7bbb */
    KANJI,        /* 0x7bbc */
    KANJI,        /* 0x7bbd */
    KANJI,        /* 0x7bbe */
    KANJI,        /* 0x7bbf */
    KANJI,        /* 0x7bc0 */
    KANJI,        /* 0x7bc1 */
    KANJI,        /* 0x7bc2 */
    KANJI,        /* 0x7bc3 */
    KANJI,        /* 0x7bc4 */
    KANJI,        /* 0x7bc5 */
    KANJI,        /* 0x7bc6 */
    KANJI,        /* 0x7bc7 */
    KANJI,        /* 0x7bc8 */
    KANJI,        /* 0x7bc9 */
    KANJI,        /* 0x7bca */
    KANJI,        /* 0x7bcb */
    KANJI,        /* 0x7bcc */
    KANJI,        /* 0x7bcd */
    KANJI,        /* 0x7bce */
    KANJI,        /* 0x7bcf */
    KANJI,        /* 0x7bd0 */
    KANJI,        /* 0x7bd1 */
    KANJI,        /* 0x7bd2 */
    KANJI,        /* 0x7bd3 */
    KANJI,        /* 0x7bd4 */
    KANJI,        /* 0x7bd5 */
    KANJI,        /* 0x7bd6 */
    KANJI,        /* 0x7bd7 */
    KANJI,        /* 0x7bd8 */
    KANJI,        /* 0x7bd9 */
    KANJI,        /* 0x7bda */
    KANJI,        /* 0x7bdb */
    KANJI,        /* 0x7bdc */
    KANJI,        /* 0x7bdd */
    KANJI,        /* 0x7bde */
    KANJI,        /* 0x7bdf */
    KANJI,        /* 0x7be0 */
    KANJI,        /* 0x7be1 */
    KANJI,        /* 0x7be2 */
    KANJI,        /* 0x7be3 */
    KANJI,        /* 0x7be4 */
    KANJI,        /* 0x7be5 */
    KANJI,        /* 0x7be6 */
    KANJI,        /* 0x7be7 */
    KANJI,        /* 0x7be8 */
    KANJI,        /* 0x7be9 */
    KANJI,        /* 0x7bea */
    KANJI,        /* 0x7beb */
    KANJI,        /* 0x7bec */
    KANJI,        /* 0x7bed */
    KANJI,        /* 0x7bee */
    KANJI,        /* 0x7bef */
    KANJI,        /* 0x7bf0 */
    KANJI,        /* 0x7bf1 */
    KANJI,        /* 0x7bf2 */
    KANJI,        /* 0x7bf3 */
    KANJI,        /* 0x7bf4 */
    KANJI,        /* 0x7bf5 */
    KANJI,        /* 0x7bf6 */
    KANJI,        /* 0x7bf7 */
    KANJI,        /* 0x7bf8 */
    KANJI,        /* 0x7bf9 */
    KANJI,        /* 0x7bfa */
    KANJI,        /* 0x7bfb */
    KANJI,        /* 0x7bfc */
    KANJI,        /* 0x7bfd */
    KANJI,        /* 0x7bfe */
    KANJI,        /* 0x7bff */
    KANJI,        /* 0x7c00 */
    KANJI,        /* 0x7c01 */
    KANJI,        /* 0x7c02 */
    KANJI,        /* 0x7c03 */
    KANJI,        /* 0x7c04 */
    KANJI,        /* 0x7c05 */
    KANJI,        /* 0x7c06 */
    KANJI,        /* 0x7c07 */
    KANJI,        /* 0x7c08 */
    KANJI,        /* 0x7c09 */
    KANJI,        /* 0x7c0a */
    KANJI,        /* 0x7c0b */
    KANJI,        /* 0x7c0c */
    KANJI,        /* 0x7c0d */
    KANJI,        /* 0x7c0e */
    KANJI,        /* 0x7c0f */
    KANJI,        /* 0x7c10 */
    KANJI,        /* 0x7c11 */
    KANJI,        /* 0x7c12 */
    KANJI,        /* 0x7c13 */
    KANJI,        /* 0x7c14 */
    KANJI,        /* 0x7c15 */
    KANJI,        /* 0x7c16 */
    KANJI,        /* 0x7c17 */
    KANJI,        /* 0x7c18 */
    KANJI,        /* 0x7c19 */
    KANJI,        /* 0x7c1a */
    KANJI,        /* 0x7c1b */
    KANJI,        /* 0x7c1c */
    KANJI,        /* 0x7c1d */
    KANJI,        /* 0x7c1e */
    KANJI,        /* 0x7c1f */
    KANJI,        /* 0x7c20 */
    KANJI,        /* 0x7c21 */
    KANJI,        /* 0x7c22 */
    KANJI,        /* 0x7c23 */
    KANJI,        /* 0x7c24 */
    KANJI,        /* 0x7c25 */
    KANJI,        /* 0x7c26 */
    KANJI,        /* 0x7c27 */
    KANJI,        /* 0x7c28 */
    KANJI,        /* 0x7c29 */
    KANJI,        /* 0x7c2a */
    KANJI,        /* 0x7c2b */
    KANJI,        /* 0x7c2c */
    KANJI,        /* 0x7c2d */
    KANJI,        /* 0x7c2e */
    KANJI,        /* 0x7c2f */
    KANJI,        /* 0x7c30 */
    KANJI,        /* 0x7c31 */
    KANJI,        /* 0x7c32 */
    KANJI,        /* 0x7c33 */
    KANJI,        /* 0x7c34 */
    KANJI,        /* 0x7c35 */
    KANJI,        /* 0x7c36 */
    KANJI,        /* 0x7c37 */
    KANJI,        /* 0x7c38 */
    KANJI,        /* 0x7c39 */
    KANJI,        /* 0x7c3a */
    KANJI,        /* 0x7c3b */
    KANJI,        /* 0x7c3c */
    KANJI,        /* 0x7c3d */
    KANJI,        /* 0x7c3e */
    KANJI,        /* 0x7c3f */
    KANJI,        /* 0x7c40 */
    KANJI,        /* 0x7c41 */
    KANJI,        /* 0x7c42 */
    KANJI,        /* 0x7c43 */
    KANJI,        /* 0x7c44 */
    KANJI,        /* 0x7c45 */
    KANJI,        /* 0x7c46 */
    KANJI,        /* 0x7c47 */
    KANJI,        /* 0x7c48 */
    KANJI,        /* 0x7c49 */
    KANJI,        /* 0x7c4a */
    KANJI,        /* 0x7c4b */
    KANJI,        /* 0x7c4c */
    KANJI,        /* 0x7c4d */
    KANJI,        /* 0x7c4e */
    KANJI,        /* 0x7c4f */
    KANJI,        /* 0x7c50 */
    KANJI,        /* 0x7c51 */
    KANJI,        /* 0x7c52 */
    KANJI,        /* 0x7c53 */
    KANJI,        /* 0x7c54 */
    KANJI,        /* 0x7c55 */
    KANJI,        /* 0x7c56 */
    KANJI,        /* 0x7c57 */
    KANJI,        /* 0x7c58 */
    KANJI,        /* 0x7c59 */
    KANJI,        /* 0x7c5a */
    KANJI,        /* 0x7c5b */
    KANJI,        /* 0x7c5c */
    KANJI,        /* 0x7c5d */
    KANJI,        /* 0x7c5e */
    KANJI,        /* 0x7c5f */
    KANJI,        /* 0x7c60 */
    KANJI,        /* 0x7c61 */
    KANJI,        /* 0x7c62 */
    KANJI,        /* 0x7c63 */
    KANJI,        /* 0x7c64 */
    KANJI,        /* 0x7c65 */
    KANJI,        /* 0x7c66 */
    KANJI,        /* 0x7c67 */
    KANJI,        /* 0x7c68 */
    KANJI,        /* 0x7c69 */
    KANJI,        /* 0x7c6a */
    KANJI,        /* 0x7c6b */
    KANJI,        /* 0x7c6c */
    KANJI,        /* 0x7c6d */
    KANJI,        /* 0x7c6e */
    KANJI,        /* 0x7c6f */
    KANJI,        /* 0x7c70 */
    KANJI,        /* 0x7c71 */
    KANJI,        /* 0x7c72 */
    KANJI,        /* 0x7c73 */
    KANJI,        /* 0x7c74 */
    KANJI,        /* 0x7c75 */
    KANJI,        /* 0x7c76 */
    KANJI,        /* 0x7c77 */
    KANJI,        /* 0x7c78 */
    KANJI,        /* 0x7c79 */
    KANJI,        /* 0x7c7a */
    KANJI,        /* 0x7c7b */
    KANJI,        /* 0x7c7c */
    KANJI,        /* 0x7c7d */
    KANJI,        /* 0x7c7e */
    KANJI,        /* 0x7c7f */
    KANJI,        /* 0x7c80 */
    KANJI,        /* 0x7c81 */
    KANJI,        /* 0x7c82 */
    KANJI,        /* 0x7c83 */
    KANJI,        /* 0x7c84 */
    KANJI,        /* 0x7c85 */
    KANJI,        /* 0x7c86 */
    KANJI,        /* 0x7c87 */
    KANJI,        /* 0x7c88 */
    KANJI,        /* 0x7c89 */
    KANJI,        /* 0x7c8a */
    KANJI,        /* 0x7c8b */
    KANJI,        /* 0x7c8c */
    KANJI,        /* 0x7c8d */
    KANJI,        /* 0x7c8e */
    KANJI,        /* 0x7c8f */
    KANJI,        /* 0x7c90 */
    KANJI,        /* 0x7c91 */
    KANJI,        /* 0x7c92 */
    KANJI,        /* 0x7c93 */
    KANJI,        /* 0x7c94 */
    KANJI,        /* 0x7c95 */
    KANJI,        /* 0x7c96 */
    KANJI,        /* 0x7c97 */
    KANJI,        /* 0x7c98 */
    KANJI,        /* 0x7c99 */
    KANJI,        /* 0x7c9a */
    KANJI,        /* 0x7c9b */
    KANJI,        /* 0x7c9c */
    KANJI,        /* 0x7c9d */
    KANJI,        /* 0x7c9e */
    KANJI,        /* 0x7c9f */
    KANJI,        /* 0x7ca0 */
    KANJI,        /* 0x7ca1 */
    KANJI,        /* 0x7ca2 */
    KANJI,        /* 0x7ca3 */
    KANJI,        /* 0x7ca4 */
    KANJI,        /* 0x7ca5 */
    KANJI,        /* 0x7ca6 */
    KANJI,        /* 0x7ca7 */
    KANJI,        /* 0x7ca8 */
    KANJI,        /* 0x7ca9 */
    KANJI,        /* 0x7caa */
    KANJI,        /* 0x7cab */
    KANJI,        /* 0x7cac */
    KANJI,        /* 0x7cad */
    KANJI,        /* 0x7cae */
    KANJI,        /* 0x7caf */
    KANJI,        /* 0x7cb0 */
    KANJI,        /* 0x7cb1 */
    KANJI,        /* 0x7cb2 */
    KANJI,        /* 0x7cb3 */
    KANJI,        /* 0x7cb4 */
    KANJI,        /* 0x7cb5 */
    KANJI,        /* 0x7cb6 */
    KANJI,        /* 0x7cb7 */
    KANJI,        /* 0x7cb8 */
    KANJI,        /* 0x7cb9 */
    KANJI,        /* 0x7cba */
    KANJI,        /* 0x7cbb */
    KANJI,        /* 0x7cbc */
    KANJI,        /* 0x7cbd */
    KANJI,        /* 0x7cbe */
    KANJI,        /* 0x7cbf */
    KANJI,        /* 0x7cc0 */
    KANJI,        /* 0x7cc1 */
    KANJI,        /* 0x7cc2 */
    KANJI,        /* 0x7cc3 */
    KANJI,        /* 0x7cc4 */
    KANJI,        /* 0x7cc5 */
    KANJI,        /* 0x7cc6 */
    KANJI,        /* 0x7cc7 */
    KANJI,        /* 0x7cc8 */
    KANJI,        /* 0x7cc9 */
    KANJI,        /* 0x7cca */
    KANJI,        /* 0x7ccb */
    KANJI,        /* 0x7ccc */
    KANJI,        /* 0x7ccd */
    KANJI,        /* 0x7cce */
    KANJI,        /* 0x7ccf */
    KANJI,        /* 0x7cd0 */
    KANJI,        /* 0x7cd1 */
    KANJI,        /* 0x7cd2 */
    KANJI,        /* 0x7cd3 */
    KANJI,        /* 0x7cd4 */
    KANJI,        /* 0x7cd5 */
    KANJI,        /* 0x7cd6 */
    KANJI,        /* 0x7cd7 */
    KANJI,        /* 0x7cd8 */
    KANJI,        /* 0x7cd9 */
    KANJI,        /* 0x7cda */
    KANJI,        /* 0x7cdb */
    KANJI,        /* 0x7cdc */
    KANJI,        /* 0x7cdd */
    KANJI,        /* 0x7cde */
    KANJI,        /* 0x7cdf */
    KANJI,        /* 0x7ce0 */
    KANJI,        /* 0x7ce1 */
    KANJI,        /* 0x7ce2 */
    KANJI,        /* 0x7ce3 */
    KANJI,        /* 0x7ce4 */
    KANJI,        /* 0x7ce5 */
    KANJI,        /* 0x7ce6 */
    KANJI,        /* 0x7ce7 */
    KANJI,        /* 0x7ce8 */
    KANJI,        /* 0x7ce9 */
    KANJI,        /* 0x7cea */
    KANJI,        /* 0x7ceb */
    KANJI,        /* 0x7cec */
    KANJI,        /* 0x7ced */
    KANJI,        /* 0x7cee */
    KANJI,        /* 0x7cef */
    KANJI,        /* 0x7cf0 */
    KANJI,        /* 0x7cf1 */
    KANJI,        /* 0x7cf2 */
    KANJI,        /* 0x7cf3 */
    KANJI,        /* 0x7cf4 */
    KANJI,        /* 0x7cf5 */
    KANJI,        /* 0x7cf6 */
    KANJI,        /* 0x7cf7 */
    KANJI,        /* 0x7cf8 */
    KANJI,        /* 0x7cf9 */
    KANJI,        /* 0x7cfa */
    KANJI,        /* 0x7cfb */
    KANJI,        /* 0x7cfc */
    KANJI,        /* 0x7cfd */
    KANJI,        /* 0x7cfe */
    KANJI,        /* 0x7cff */
    KANJI,        /* 0x7d00 */
    KANJI,        /* 0x7d01 */
    KANJI,        /* 0x7d02 */
    KANJI,        /* 0x7d03 */
    KANJI,        /* 0x7d04 */
    KANJI,        /* 0x7d05 */
    KANJI,        /* 0x7d06 */
    KANJI,        /* 0x7d07 */
    KANJI,        /* 0x7d08 */
    KANJI,        /* 0x7d09 */
    KANJI,        /* 0x7d0a */
    KANJI,        /* 0x7d0b */
    KANJI,        /* 0x7d0c */
    KANJI,        /* 0x7d0d */
    KANJI,        /* 0x7d0e */
    KANJI,        /* 0x7d0f */
    KANJI,        /* 0x7d10 */
    KANJI,        /* 0x7d11 */
    KANJI,        /* 0x7d12 */
    KANJI,        /* 0x7d13 */
    KANJI,        /* 0x7d14 */
    KANJI,        /* 0x7d15 */
    KANJI,        /* 0x7d16 */
    KANJI,        /* 0x7d17 */
    KANJI,        /* 0x7d18 */
    KANJI,        /* 0x7d19 */
    KANJI,        /* 0x7d1a */
    KANJI,        /* 0x7d1b */
    KANJI,        /* 0x7d1c */
    KANJI,        /* 0x7d1d */
    KANJI,        /* 0x7d1e */
    KANJI,        /* 0x7d1f */
    KANJI,        /* 0x7d20 */
    KANJI,        /* 0x7d21 */
    KANJI,        /* 0x7d22 */
    KANJI,        /* 0x7d23 */
    KANJI,        /* 0x7d24 */
    KANJI,        /* 0x7d25 */
    KANJI,        /* 0x7d26 */
    KANJI,        /* 0x7d27 */
    KANJI,        /* 0x7d28 */
    KANJI,        /* 0x7d29 */
    KANJI,        /* 0x7d2a */
    KANJI,        /* 0x7d2b */
    KANJI,        /* 0x7d2c */
    KANJI,        /* 0x7d2d */
    KANJI,        /* 0x7d2e */
    KANJI,        /* 0x7d2f */
    KANJI,        /* 0x7d30 */
    KANJI,        /* 0x7d31 */
    KANJI,        /* 0x7d32 */
    KANJI,        /* 0x7d33 */
    KANJI,        /* 0x7d34 */
    KANJI,        /* 0x7d35 */
    KANJI,        /* 0x7d36 */
    KANJI,        /* 0x7d37 */
    KANJI,        /* 0x7d38 */
    KANJI,        /* 0x7d39 */
    KANJI,        /* 0x7d3a */
    KANJI,        /* 0x7d3b */
    KANJI,        /* 0x7d3c */
    KANJI,        /* 0x7d3d */
    KANJI,        /* 0x7d3e */
    KANJI,        /* 0x7d3f */
    KANJI,        /* 0x7d40 */
    KANJI,        /* 0x7d41 */
    KANJI,        /* 0x7d42 */
    KANJI,        /* 0x7d43 */
    KANJI,        /* 0x7d44 */
    KANJI,        /* 0x7d45 */
    KANJI,        /* 0x7d46 */
    KANJI,        /* 0x7d47 */
    KANJI,        /* 0x7d48 */
    KANJI,        /* 0x7d49 */
    KANJI,        /* 0x7d4a */
    KANJI,        /* 0x7d4b */
    KANJI,        /* 0x7d4c */
    KANJI,        /* 0x7d4d */
    KANJI,        /* 0x7d4e */
    KANJI,        /* 0x7d4f */
    KANJI,        /* 0x7d50 */
    KANJI,        /* 0x7d51 */
    KANJI,        /* 0x7d52 */
    KANJI,        /* 0x7d53 */
    KANJI,        /* 0x7d54 */
    KANJI,        /* 0x7d55 */
    KANJI,        /* 0x7d56 */
    KANJI,        /* 0x7d57 */
    KANJI,        /* 0x7d58 */
    KANJI,        /* 0x7d59 */
    KANJI,        /* 0x7d5a */
    KANJI,        /* 0x7d5b */
    KANJI,        /* 0x7d5c */
    KANJI,        /* 0x7d5d */
    KANJI,        /* 0x7d5e */
    KANJI,        /* 0x7d5f */
    KANJI,        /* 0x7d60 */
    KANJI,        /* 0x7d61 */
    KANJI,        /* 0x7d62 */
    KANJI,        /* 0x7d63 */
    KANJI,        /* 0x7d64 */
    KANJI,        /* 0x7d65 */
    KANJI,        /* 0x7d66 */
    KANJI,        /* 0x7d67 */
    KANJI,        /* 0x7d68 */
    KANJI,        /* 0x7d69 */
    KANJI,        /* 0x7d6a */
    KANJI,        /* 0x7d6b */
    KANJI,        /* 0x7d6c */
    KANJI,        /* 0x7d6d */
    KANJI,        /* 0x7d6e */
    KANJI,        /* 0x7d6f */
    KANJI,        /* 0x7d70 */
    KANJI,        /* 0x7d71 */
    KANJI,        /* 0x7d72 */
    KANJI,        /* 0x7d73 */
    KANJI,        /* 0x7d74 */
    KANJI,        /* 0x7d75 */
    KANJI,        /* 0x7d76 */
    KANJI,        /* 0x7d77 */
    KANJI,        /* 0x7d78 */
    KANJI,        /* 0x7d79 */
    KANJI,        /* 0x7d7a */
    KANJI,        /* 0x7d7b */
    KANJI,        /* 0x7d7c */
    KANJI,        /* 0x7d7d */
    KANJI,        /* 0x7d7e */
    KANJI,        /* 0x7d7f */
    KANJI,        /* 0x7d80 */
    KANJI,        /* 0x7d81 */
    KANJI,        /* 0x7d82 */
    KANJI,        /* 0x7d83 */
    KANJI,        /* 0x7d84 */
    KANJI,        /* 0x7d85 */
    KANJI,        /* 0x7d86 */
    KANJI,        /* 0x7d87 */
    KANJI,        /* 0x7d88 */
    KANJI,        /* 0x7d89 */
    KANJI,        /* 0x7d8a */
    KANJI,        /* 0x7d8b */
    KANJI,        /* 0x7d8c */
    KANJI,        /* 0x7d8d */
    KANJI,        /* 0x7d8e */
    KANJI,        /* 0x7d8f */
    KANJI,        /* 0x7d90 */
    KANJI,        /* 0x7d91 */
    KANJI,        /* 0x7d92 */
    KANJI,        /* 0x7d93 */
    KANJI,        /* 0x7d94 */
    KANJI,        /* 0x7d95 */
    KANJI,        /* 0x7d96 */
    KANJI,        /* 0x7d97 */
    KANJI,        /* 0x7d98 */
    KANJI,        /* 0x7d99 */
    KANJI,        /* 0x7d9a */
    KANJI,        /* 0x7d9b */
    KANJI,        /* 0x7d9c */
    KANJI,        /* 0x7d9d */
    KANJI,        /* 0x7d9e */
    KANJI,        /* 0x7d9f */
    KANJI,        /* 0x7da0 */
    KANJI,        /* 0x7da1 */
    KANJI,        /* 0x7da2 */
    KANJI,        /* 0x7da3 */
    KANJI,        /* 0x7da4 */
    KANJI,        /* 0x7da5 */
    KANJI,        /* 0x7da6 */
    KANJI,        /* 0x7da7 */
    KANJI,        /* 0x7da8 */
    KANJI,        /* 0x7da9 */
    KANJI,        /* 0x7daa */
    KANJI,        /* 0x7dab */
    KANJI,        /* 0x7dac */
    KANJI,        /* 0x7dad */
    KANJI,        /* 0x7dae */
    KANJI,        /* 0x7daf */
    KANJI,        /* 0x7db0 */
    KANJI,        /* 0x7db1 */
    KANJI,        /* 0x7db2 */
    KANJI,        /* 0x7db3 */
    KANJI,        /* 0x7db4 */
    KANJI,        /* 0x7db5 */
    KANJI,        /* 0x7db6 */
    KANJI,        /* 0x7db7 */
    KANJI,        /* 0x7db8 */
    KANJI,        /* 0x7db9 */
    KANJI,        /* 0x7dba */
    KANJI,        /* 0x7dbb */
    KANJI,        /* 0x7dbc */
    KANJI,        /* 0x7dbd */
    KANJI,        /* 0x7dbe */
    KANJI,        /* 0x7dbf */
    KANJI,        /* 0x7dc0 */
    KANJI,        /* 0x7dc1 */
    KANJI,        /* 0x7dc2 */
    KANJI,        /* 0x7dc3 */
    KANJI,        /* 0x7dc4 */
  