# 3.14.2.0 [Mikolaj Konarski](mailto:mikolaj@well-typed.com) April 2025
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.14.2.0.md

# 3.14.1.0 [Hécate](mailto:hecate+github@glitchbra.in) November 2024
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.14.1.0.md

# 3.14.0.0 [Hécate](mailto:hecate+github@glitchbra.in) September 2024
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.14.0.0.md

# 3.12.1.0 [Artem Pelenitsyn](mailto:a.pelenitsyn@gmail.com) June 2024
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.12.1.0.md

# 3.12.0.0 [Francesco Ariis](mailto:fa-ml@ariis.it) May 2024
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.12.0.0.md

# 3.10.3.0 [Hécate](mailto:hecate+github@glitchbra.in) January 2024
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.10.3.0.md

# 3.10.2.1 [Hécate](mailto:hecate+github@glitchbra.in) October 2023
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.10.2.1.md

# 3.10.2.0 [Hécate](mailto:hecate+github@glitchbra.in) August 2023
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.10.2.0.md

# 3.10.1.0 [Mikolaj Konarski](mailto:mikolaj@well-typed.com) March 2023
* See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.10.1.0.md

# 3.8.1.0 [Mikolaj Konarski](mailto:mikolaj@well-typed.com) August 2022
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.8.1.0.md

# 3.6.3.0 March 2022
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.6.3.0.md

# 3.6.2.0 [Emily Pillmore](mailto:emilypi@cohomolo.gy) October 2021
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.6.2.0.md

# 3.6.1.0 [Emily Pillmore](mailto:emilypi@cohomolo.gy) August 2021
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.6.1.0.md

# 3.6.0.0 [Emily Pillmore](mailto:emilypi@cohomolo.gy) August 2021
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.6.0.0.md

# 3.4.1.0 [Emily Pillmore](mailto:emilypi@cohomolo.gy) October 2021
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.4.1.0.md

# 3.4.0.0 [Oleg Grenrus](mailto:oleg.grnerus@iki.fi) February 2021
  * See https://github.com/haskell/cabal/blob/master/release-notes/Cabal-3.4.0.0.md

# 3.2.1.0 [Oleg Grenrus](mailto:oleg.grenris@iki.fi) October 2020
  * Pass `cxx-options` with `-optcxx` for GHC >= 8.10
  * Use process jobs when calling subprocesses
  * Require custom-setup for `cabal-version: 1.24` and later
  * Accept `linux-androideabi` as an alias for Android
  * Fix ghci being launched before other sources are built
  * Require cabal-versions >=1.25 to be exact

# 3.2.0.0 [Herbert Valerio Riedel](mailto:hvr@gnu.org) April 2020
  * Change free text `String` fields to use `ShortText` in package description
    and installed package info.
  * Split `Distribution.Types.Flag` and `Distribution.Types.ConfVar`
    `Distribution.Types.GenericPackageDescription`.
  * Add GHC-8.10 support, including new extensions to
    `Language.Haskell.Extension`.
  * Use more `NonEmpty` instead of ordinary lists.
  * Add `Distribution.Utils.Structured` for fingeprinting `Binary` blobs.
  * Add `null`, `length` and `unsafeFromUTF8BS` to `Distribution.Utils.ShortText`.
  * Refactor `Distribution.Utils.IOData` module.
  * Rename `Distribution.Compat.MD5` to `Distribution.Utils.MD5`.
  * Add `safeHead`, `safeTail`, `safeLast` to `Distribution.Utils.Generic`.
  * Add `unsnoc` and `unsnocNE` to `Distribution.Utils.Generic`.
  * Add `Set'` modifier to `Distribution.Parsec.Newtypes`.
  * Add `Distribution.Compat.Async`.

# 3.0.2.0 [Herbert Valerio Riedel](mailto:hvr@gnu.org) April 2020
  * Disallow spaces around colon `:` in Dependency `build-depends` syntax
    ([#6538](https://github.com/haskell/cabal/pull/6538)).
  * Make `configure` accept any `pkg-config --modversion` output
    ([#6541](https://github.com/haskell/cabal/pull/6541)).

# 3.0.1.0 [Herbert Valerio Riedel](mailto:hvr@gnu.org) April 2020
  * Add GHC-8.8 flags to `normaliseGhcFlags`
    ([#6379](https://github.com/haskell/cabal/pull/6379)).
  * Typo fixes
    ([#6372](https://github.com/haskell/cabal/pull/6372)).
  * Limit version number parts to contain at most 9 digits
    ([#6386](https://github.com/haskell/cabal/pull/6386)).
  * Fix boundless sublibrary dependency parse failure
    ([#5846](https://github.com/haskell/cabal/issues/5846)).
  * `cabal check` verifies `cpp-options` more pedantically, allowing only
    options starting with `-D` and `-U`.
  * Don’t rebuild world when new ghc flags that affect how error
    messages are presented is specified.
  * Fix dropExeExtension behaviour on Windows
    ([#6287](https://github.com/haskell/cabal/pull/6287)).

# 3.0.0.0 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) August 2019
  * The 3.0 migration guide gives advice on adapting Custom setup
    scripts to backwards-incompatible changes in this release:
    https://github.com/haskell/cabal/wiki/3.0-migration-guide.
  * Due to [#5119](https://github.com/haskell/cabal/issues/5119), the
    `cabal check` warning for bounds on internal libraries has been
    disabled.
  * Introduce set notation for `^>=` and `==` operators
    ([#5906](https://github.com/haskell/cabal/pull/5906)).
  * 'check' reports warnings for various ghc-\*-options fields separately
    ([#5342](https://github.com/haskell/cabal/issues/5432)).
  * `KnownExtension`: added new extensions `DerivingVia` and
    `EmptyDataDeriving`.
  * Add `extra-dynamic-library-flavours`, to specify extra dynamic library
    flavours to build and install from a .cabal file.
  * `autoconfUserHooks` now passes `--host=$HOST` when cross-compiling
  * Introduce multiple public libraries feature
    ([#5526](https://github.com/haskell/cabal/pull/5526)).
    * New build-depends syntax
    * Add a set of library components to the `Dependency` datatype
    * New `visibility` field in the `library` stanza
    * New `LibraryVisibility` field in `InstalledPackageInfo`
    * New syntax for the `--dependency` Cabal flag
  * Static linking
    * Add `--enable-executable-static` flag for building fully
      static executables (GHC's normal "statish" linking links
      Haskell libraries statically, but libc and system dependencies
      dynamically). This new flag links everything statically.
    * Note you likely want to link against `musl` or another libc that
      supports fully static linking;
      [`glibc` has some issues](https://sourceware.org/glibc/wiki/FAQ#Even_statically_linked_programs_need_some_shared_libraries_which_is_not_acceptable_for_me.__What_can_I_do.3F)
      with fully static linking.
  * Fix corrupted config file header for non-ASCII package names
    ([2557](https://github.com/haskell/cabal/issues/2557)).
  * Extend `Distribution.Simple.Utils.rewriteFileEx` from ASCII to UTF-8 encoding.
  * Change the arguments of `Newtype` class to better suit @DeriveAnyClass@ usage,
    add default implementation in terms of `coerce` / `unsafeCoerce`.
  * Implement support for response file arguments to defaultMain* and cabal-install.
  * Uniformly provide 'Semigroup' instances for `base < 4.9` via `semigroups` package
  * Implement `{cmm,asm}-{sources,options} buildinfo fields for
    separate compilation of C-- and ASM source files (#6033).
  * Setting `debug-info` now implies `library-stripping: False` and
    `executable-stripping: False) ([#2702](https://github.com/haskell/cabal/issues/2702))
  * `Setup.hs copy` and `install` now work in the presence of
    `data-files` that use `**` syntax
    ([#6125](https://github.com/haskell/cabal/issues/6125)).

----

### 2.4.1.1 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) December 2018

  * Fix `--with-compiler` failing to locate compiler on Windows
    ([#5753](https://github.com/haskell/cabal/pull/5753)).
  * Cabal can once again be built with GHC 7.8 and 7.6
    ([#5730](https://github.com/haskell/cabal/pull/5730)).

### 2.4.1.0 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) November 2018

  * Warnings in autogenerated files are now silenced
    ([#5678](https://github.com/haskell/cabal/pull/5678)).
  * Improved recompilation avoidance, especially when using GHC 8.6
    ([#5589](https://github.com/haskell/cabal/pull/5589)).
  * Do not error on empty packagedbs in `getInstalledPackages`
    ([#5516](https://github.com/haskell/cabal/issues/5516)).


### 2.4.0.1 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) September 2018

  * Allow arguments to be passed to `Setup.hs haddock` for `build-type:configure`
    ([#5503](https://github.com/haskell/cabal/issues/5503)).

# 2.4.0.0 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) September 2018
  * Due to [#5119](https://github.com/haskell/cabal/issues/5119), the
    `cabal check` warning for bounds on internal libraries has been
    disabled.
  * `Distribution.Simple.Haddock` now checks to ensure that it
    does not erroneously call Haddock with no target modules.
    ([#5232](https://github.com/haskell/cabal/issues/5232),
    [#5459](https://github.com/haskell/cabal/issues/5459)).
  * Add `getting` (less general than `to`) Lens combinator,
    `non`) and an optics to access the modules in a component
    of a `PackageDescription` by the `ComponentName`:
    `componentBuildInfo` and `componentModules`
  * Linker `ld-options` are now passed to GHC as `-optl` options
    ([#4925](https://github.com/haskell/cabal/pull/4925)).
  * Add `readGhcEnvironmentFile` to parse GHC environment files.
  * Drop support for GHC 7.4, since it is out of our support window
    (and has been for over a year!)
  * Deprecate `preSDist`, `sDistHook`, and `postSDist` in service of
    `new-sdist`, since they violate key invariants of the new-build
    ecosystem. Use `autogen-modules` and `build-tool-depends` instead.
    ([#5389](https://github.com/haskell/cabal/pull/5389)).
  * Added `--repl-options` flag to `Setup repl` used to pass flags to the
    underlying repl without affecting the `LocalBuildInfo`
    ([#4247](https://github.com/haskell/cabal/issues/4247),
    [#5287](https://github.com/haskell/cabal/pull/5287))
  * `KnownExtension`: added new extensions `BlockArguments`
    ([#5101](https://github.com/haskell/cabal/issues/5101)),
    `NumericUnderscores`
    ([#5130]((https://github.com/haskell/cabal/issues/5130)),
    `QuantifiedConstraints`, and `StarIsType`.
  * `buildDepends` is removed from `PackageDescription`. It had long been
    uselessly hanging about as top-level build-depends already got put
    into per-component condition trees anyway. Now it's finally been put
    out of its misery
    ([#4383](https://github.com/haskell/cabal/issues/4283)).
  * Added `Eta` to `CompilerFlavor` and to known compilers.
  * `cabal haddock` now generates per-component documentation
    ([#5226](https://github.com/haskell/cabal/issues/5226)).
  * Wildcard improvements:
    * Allow `**` wildcards in `data-files`, `extra-source-files` and
      `extra-doc-files`. These allow a limited form of recursive
      matching, and require `cabal-version: 2.4`.
      ([#5284](https://github.com/haskell/cabal/issues/5284),
      [#3178](https://github.com/haskell/cabal/issues/3178), et al.)
    * With `cabal-version: 2.4`, when matching a wildcard, the
      requirement for the full extension to match exactly has been
      loosened. Instead, if the wildcard's extension is a suffix of the
      file's extension, the file will be selected. For example,
      previously `foo.en.html` would not match `*.html`, and
      `foo.solaris.tar.gz` would not match `*.tar.gz`, but now both
      do. This may lead to files unexpectedly being included by `sdist`;
      please audit your package descriptions if you rely on this
      behaviour to keep sensitive data out of distributed packages
      ([#5372](https://github.com/haskell/cabal/pull/5372),
      [#784](https://github.com/haskell/cabal/issues/784),
      [#5057](https://github.com/haskell/cabal/issues/5057)).
    * Wildcard syntax errors (misplaced `*`, etc), wildcards that
      refer to missing directories, and wildcards that do not match
      anything are now all detected by `cabal check`.
    * Wildcard ('globbing') functions have been moved from
      `Distribution.Simple.Utils` to `Distribution.Simple.Glob` and
      have been refactored.
  * Fixed `cxx-options` and `cxx-sources` buildinfo fields for
    separate compilation of C++ source files to correctly build and link
    non-library components ([#5309](https://github.com/haskell/cabal/issues/5309)).
  * Reduced warnings generated by hsc2hs and c2hs when `cxx-options` field
    is present in a component.
  * `cabal check` now warns if `-j` is used in `ghc-options` in a Cabal
    file. ([#5277](https://github.com/haskell/cabal/issues/5277))
  * `install-includes` now works as expected with foreign libraries
    ([#5302](https://github.com/haskell/cabal/issues/5299)).
  * Removed support for JHC.
  * Options listed in `ghc-options`, `cc-options`, `ld-options`,
    `cxx-options`, `cpp-options` are not deduplicated anymore
    ([#4449](https://github.com/haskell/cabal/issues/4449)).
  * Deprecated `cabal hscolour` in favour of `cabal haddock --hyperlink-source` ([#5236](https://github.com/haskell/cabal/pull/5236/)).
  * Recognize `powerpc64le` as architecture PPC64.
  * Cabal now deduplicates more `-I` and `-L` and flags to avoid `E2BIG`
    ([#5356](https://github.com/haskell/cabal/issues/5356)).
  * With `build-type: configure`, avoid using backslashes to delimit
    path components on Windows and warn about other unsafe characters
    in the path to the source directory on all platforms
    ([#5386](https://github.com/haskell/cabal/issues/5386)).
  * `Distribution.PackageDescription.Check.checkPackageFiles` now
    accepts a `Verbosity` argument.
  * Added a parameter to
    `Distribution.Backpack.ConfiguredComponent.toConfiguredComponent` in order to fix
    [#5409](https://github.com/haskell/cabal/issues/5409).
  * Partially silence `abi-depends` warnings
    ([#5465](https://github.com/haskell/cabal/issues/5465)).
  * Foreign libraries are now linked against the threaded RTS when the
    'ghc-options: -threaded' flag is used
    ([#5431](https://github.com/haskell/cabal/pull/5431)).
  * Pass command line arguments to `hsc2hs` using response files when possible
    ([#3122](https://github.com/haskell/cabal/issues/3122)).

----

## 2.2.0.1 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) March 2018

  * Fix `checkPackageFiles` for relative directories ([#5206](https://github.com/haskell/cabal/issues/5206))


# 2.2.0.0 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) March 2018

  * The 2.2 migration guide gives advice on adapting Custom setup
    scripts to backwards-incompatible changes in this release:
    https://github.com/haskell/cabal/wiki/2.2-migration-guide.
  * New Parsec-based parser for `.cabal` files is now the
    default. This brings memory consumption and speed improvements, as
    well as making new syntax extensions easier to implement.
  * Support for common stanzas (#4751).
  * Added elif-conditionals to `.cabal` syntax (#4750).
  * The package license information can now be specified using the
    SPDX syntax. This requires setting `cabal-version` to 2.2+ (#2547,
    #5050).
  * Support for GHC's numeric -g debug levels (#4673).
  * Compilation with section splitting is now supported via the
    `--enable-split-sections` flag (#4819)
  * Fields with mandatory commas (e.g. build-depends) may now have a
    leading or a trailing comma (either one, not both) (#4953)
  * Added `virtual-modules` field, to allow modules that are not built
    but registered (#4875).
  * Use better defaulting for `build-type`; rename `PackageDescription`'s
    `buildType` field to `buildTypeRaw` and introduce new `buildType`
    function (#4958)
  * `D.T.PackageDescription.allBuildInfo` now returns all build infos, not
    only for buildable components (#5087).
  * Removed `UnknownBuildType` constructor from `BuildType` (#5003).
  * Added `HexFloatLiterals` to `KnownExtension`.
  * Cabal will no longer try to build an empty set of `inputModules`
    (#4890).
  * `copyComponent` and `installIncludeFiles` will now look for
    include headers in the build directory (`dist/build/...` by
    default) as well (#4866).
  * Added `cxx-options` and `cxx-sources` buildinfo fields for
    separate compilation of C++ source files (#3700).
  * Removed unused `--allow-newer`/`--allow-older` support from
    `Setup configure` (#4527).
  * Changed `FlagAssignment` to be an opaque `newtype` (#4849).
  * Changed `rawSystemStdInOut` to use proper type to represent
    binary and textual data; new `Distribution.Utils.IOData` module;
    removed obsolete `startsWithBOM`, `fileHasBOM`, `fromUTF8`,
    and `toUTF8` functions; add new `toUTF8BS`/`toUTF8LBS`
    encoding functions. (#4666)
  * Added a `cabal check` warning when the `.cabal` file name does
    not match package name (#4592).
  * The `ar` program now receives its arguments via a response file
    (`@file`).  Old behaviour can be restored with
    `--disable-response-files` argument to `configure` or
    `install` (#4596).
  * Added `.Lens` modules, with optics for package description data
    types (#4701).
  * Support for building with Win32 version 2.6 (#4835).
  * Change `compilerExtensions` and `ghcOptExtensionMap` to contain
    `Maybe Flag`s, since a supported extension can lack a flag (#4443).
  * Pretty-printing of `.cabal` files is slightly different due to
    parser changes. For an example, see
    https://mail.haskell.org/pipermail/cabal-devel/2017-December/010414.html.
  * `--hyperlink-source` now uses Haddock's hyperlinker backend when
    Haddock is new enough, falling back to HsColour otherwise.
  * `D.S.defaultHookedPackageDesc` has been deprecated in favour of
    `D.S.findHookedPackageDesc` (#4874).
  * `D.S.getHookedBuildInfo` now takes an additional parameter
    specifying the build directory path (#4874).
  * Emit warning when encountering unknown GHC versions (#415).

### 2.0.1.1 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) December 2017

  * Don't pass `other-modules` to stub executable for detailed-0.9
  (#4918).
  * Hpc: Use relative .mix search paths (#4917).

## 2.0.1.0 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) November 2017

  * Support for GHC's numeric -g debug levels (#4673).
  * Added a new `Distribution.Verbosity.modifyVerbosity` combinator
    (#4724).
  * Added a new `cabal check` warning about unused, undeclared or
    non-Unicode flags.  Also, it warns about leading dash, which is
    unusable but accepted if it's unused in conditionals. (#4687)
  * Modify `allBuildInfo` to include foreign library info (#4763).
  * Documentation fixes.

### 2.0.0.2 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) July 2017

  * See http://coldwa.st/e/blog/2017-09-09-Cabal-2-0.html
    for more detailed release notes.
  * The 2.0 migration guide gives advice on adapting Custom setup
    scripts to backwards-incompatible changes in this release:
    https://github.com/haskell/cabal/wiki/2.0-migration-guide
  * Add CURRENT_PACKAGE_VERSION to cabal_macros.h (#4319)
  * Dropped support for versions of GHC earlier than 6.12 (#3111).
  * GHC compatibility window for the Cabal library has been extended
    to five years (#3838).
  * Convenience/internal libraries are now supported (#269).
    An internal library is declared using the stanza `library
    'libname'`.  Packages which use internal libraries can
    result in multiple registrations; thus `--gen-pkg-config`
    can now output a directory of registration scripts rather than
    a single file.
  * Backwards incompatible change to preprocessor interface:
    the function in `PPSuffixHandler` now takes an additional
    `ComponentLocalBuildInfo` specifying the build information
    of the component being preprocessed.
  * Backwards incompatible change to `cabal_macros.h` (#1893): we now
    generate a macro file for each component which contains only
    information about the direct dependencies of that component.
    Consequently, `dist/build/autogen/cabal_macros.h` contains
    only the macros for the library, and is not generated if a
    package has no library; to find the macros for an executable
    named `foobar`, look in `dist/build/foobar/autogen/cabal_macros.h`.
    Similarly, if you used `autogenModulesDir` you should now
    use `autogenComponentModulesDir`, which now requires a
    `ComponentLocalBuildInfo` argument as well in order to
    disambiguate which component the autogenerated files are for.
  * Backwards incompatible change to `Component`: `TestSuite` and
    `Benchmark` no longer have `testEnabled` and
    `benchmarkEnabled`.  If you used
    `enabledTests` or `enabledBenchmarks`, please instead use
    `enabledTestLBIs` and `enabledBenchLBIs`
    (you will need a `LocalBuildInfo` for these functions.)
    Additionally, the semantics of `withTest` and `withBench`
    have changed: they now iterate over all buildable
    such components, regardless of whether or not they have
    been enabled; if you only want enabled components,
    use `withTestLBI` and `withBenchLBI`.
    `finalizePackageDescription` is deprecated:
    its replacement `finalizePD` now takes an extra argument
    `ComponentRequestedSpec` which specifies what components
    are to be enabled: use this instead of modifying the
    `Component` in a `GenericPackageDescription`.  (As
    it's not possible now, `finalizePackageDescription`
    will assume tests/benchmarks are disabled.)
    If you only need to test if a component is buildable
    (i.e., it is marked buildable in the Cabal file)
    use the new function `componentBuildable`.
  * Backwards incompatible change to `PackageName` (#3896):
    `PackageName` is now opaque; conversion to/from `String` now works
    via (old) `unPackageName` and (new) `mkPackageName` functions.
  * Backwards incompatible change to `ComponentId` (#3917):
    `ComponentId` is now opaque; conversion to/from `String` now works
    via `unComponentId` and `mkComponentId` functions.
  * Backwards incompatible change to `AbiHash` (#3921):
    `AbiHash` is now opaque; conversion to/from `String` now works
    via `unAbiHash` and `mkAbiHash` functions.
  * Backwards incompatible change to `FlagName` (#4062):
    `FlagName` is now opaque; conversion to/from `String` now works
    via `unFlagName` and `mkFlagName` functions.
  * Backwards incompatible change to `Version` (#3905):
    Version is now opaque; conversion to/from `[Int]` now works
    via `versionNumbers` and `mkVersion` functions.
  * Add support for `--allow-older` (dual to `--allow-newer`) (#3466)
  * Improved an error message for process output decoding errors
  (#3408).
  * `getComponentLocalBuildInfo`, `withComponentsInBuildOrder`
    and `componentsInBuildOrder` are deprecated in favor of a
    new interface in `Distribution.Types.LocalBuildInfo`.
  * New `autogen-modules` field. Modules that are built automatically at
    setup, like Paths_PACKAGENAME or others created with a build-type
    custom, appear on `other-modules` for the Library, Executable,
    Test-Suite or Benchmark stanzas or also on `exposed-modules` for
    libraries but are not really on the package when distributed. This
    makes commands like sdist fail because the file is not found, so with
    this new field modules that appear there are treated the same way as
    Paths_PACKAGENAME was and there is no need to create complex build
    hooks. Just add the module names on `other-modules` and
    `exposed-modules` as always and on the new `autogen-modules` besides.
  (#3656).
  * New `./Setup configure` flag `--cabal-file`, allowing multiple
  `.cabal` files in a single directory (#3553). Primarily intended for
  internal use.
  * Macros in `cabal_macros.h` are now ifndef'd, so that they
  don't cause an error if the macro is already defined. (#3041)
  * `./Setup configure` now accepts a single argument specifying
    the component to be configured.  The semantics of this mode
    of operation are described in
    <https://github.com/ghc-proposals/ghc-proposals/pull/4>
  * Internal `build-tools` dependencies are now added to PATH
    upon invocation of GHC, so that they can be conveniently
    used via `-pgmF`. (#1541)
  * Add support for new caret-style version range operator `^>=` (#3705)
  * Verbosity `-v` now takes an extended format which allows
    specifying exactly what you want to be logged.  The format is
    `[silent|normal|verbose|debug] flags`, where flags is a space
    separated list of flags. At the moment, only the flags
    +callsite and +callstack are supported; these report the
    call site/stack of a logging output respectively (these
    are only supported if Cabal is built with GHC 8.0/7.10.2
    or greater, respectively).
  * New `Distribution.Utils.ShortText.ShortText` type for representing
    short text strings compactly (#3898)
  * Cabal no longer supports using a version bound to disambiguate
    between an internal and external package (#4020).  This should
    not affect many people, as this mode of use already did not
    work with the dependency solver.
  * Support for "foreign libraries" (#2540), which are Haskell
    libraries intended to be used by foreign languages like C.
    Foreign libraries only work with GHC 7.8 and later.
  * Added a technical preview version of integrated doctest support (#4480).
  * Added a new `scope` field to the executable stanza. Executables
    with `scope: private` get installed into
    $libexecdir/$libexecsubdir. Additionally $libexecdir now has a
    subdir structure similar to $lib(sub)dir to allow installing
    private executables of different packages and package versions
    alongside one another.  Private executables are those that are
    expected to be run by other programs rather than users. (#3461)

## 1.24.2.0 [Mikhail Glushenkov](mailto:mikhail.glushenkov@gmail.com) December 2016
  * Fixed a bug in the handling of non-buildable components (#4094).
  * Reverted a PVP-noncompliant API change in 1.24.1.0 (#4123).
  * Bumped the directory upper bound to < 1.4 (#4158).

## 1.24.1.0 [Ryan Thomas](mailto:ryan@ryant.org) October 2016
  * API addition: `differenceVersionRanges` (#3519).
  * Fixed reexported-modules display mangling (#3928).
  * Check that the correct cabal-version is specified when the
  extra-doc-files field is present (#3825).
  * Fixed an incorrect invocation of GetShortPathName that was
  causing build failures on Windows (#3649).
  * Linker flags are now set correctly on GHC >= 7.8 (#3443).

# 1.24.0.0 [Ryan Thomas](mailto:ryan@ryant.org) March 2016
  * Support GHC 8.
  * Deal with extra C sources from preprocessors (#238).
  * Include cabal_macros.h when running c2hs (#2600).
  * Don't recompile C sources unless needed (#2601).
  * Read `builddir` option from `CABAL_BUILDDIR` environment variable.
  * Add `--profiling-detail=$level` flag with a default for libraries
    and executables of `exported-functions` and `toplevel-functions`
    respectively (GHC's `-fprof-auto-{exported,top}` flags) (#193).
  * New `custom-setup` stanza to specify setup deps. Setup is also built
    with the cabal_macros.h style macros, for conditional compilation.
  * Support Haddock response files (#2746).
  * Fixed a bug in the Text instance for Platform (#2862).
  * New `setup haddock` option: `--for-hackage` (#2852).
  * New `--show-detail=direct`; like streaming, but allows the test
    program to detect that is connected to a terminal, and works
    reliable with a non-threaded runtime (#2911, and serves as a
    work-around for #2398)
  * Library support for multi-instance package DBs (#2948).
  * Improved the `./Setup configure` solver (#3082, #3076).
  * The `--allow-newer` option can be now used with `./Setup
  configure` (#3163).
  * Added a way to specify extra locations to find OS X frameworks
  in (`extra-framework-dirs`). Can be used both in `.cabal` files and
  as an argument to `./Setup configure` (#3158).
  * Macros `VERSION_$pkgname` and `MIN_VERSION_$pkgname` are now
  also generated for the current package. (#3235).
  * Backpack is supported!  Two new fields supported in Cabal
  files: signatures and mixins; and a new flag
  to setup scripts, `--instantiate-with`.  See
  https://github.com/ezyang/ghc-proposals/blob/backpack/proposals/0000-backpack.rst
  for more details.

----

## 1.22.8.0 [Ryan Thomas](mailto:ryan@ryant.org) March 2016
  * Distribution.Simple.Setup: remove job cap. Fixes #3191.
  * Check all object file suffixes for recompilation. Fixes #3128.
  * Move source files under `src/`. Fixes #3003.

## 1.22.7.0 [Ryan Thomas](mailto:ryan@ryant.org) January 2016
  * Backport #3012 to the 1.22 branch
  * Cabal.cabal: change build-type to Simple
  * Add foldl' import
  * The Cabal part for fully gcc-like response files

## 1.22.6.0 [Ryan Thomas](mailto:ryan@ryant.org) December 2015
  * Relax upper bound to allow upcoming binary-0.8

## 1.22.5.0 [Ryan Thomas](mailto:ryan@ryant.org) November 2015
  * Don't recompile C sources unless needed (#2601). (Luke Iannini)
  * Support Haddock response files.
  * Add frameworks when linking a dynamic library.

## 1.22.4.0 [Ryan Thomas](mailto:ryan@ryant.org) June 2015
  * Add libname install-dirs variable, use it by default. Fixes #2437. (Edward Z. Yang)
  * Reduce temporary directory name length, fixes #2502. (Edward Z. Yang)
  * Workaround for #2527. (Mikhail Glushenkov)

## 1.22.3.0 [Ryan Thomas](mailto:ryan@ryant.org) April 2015
  * Fix for the ghcjs-pkg version number handling (Luite Stegeman)
  * filterConfigureFlags: filter more flags (Mikhail Glushenkov)
  * Cabal check will fail on -fprof-auto passed as a ghc-option - Fixes #2479 (John Chee)

## 1.22.2.0 [Ryan Thomas](mailto:ryan@ryant.org) March 2015
  * Don't pass `--{en,dis}able-profiling` to old setup.
  * Add -Wall police
  * Fix dependencies on `old-time`
  * Fix test interface detailed-0.9 with GHC 7.10
  * Fix HPC tests with GHC 7.10
  * Make sure to pass the package key to ghc
  * Use `--package-{name|version}` when available for Haddock when available
  * Put full package name and version in library names
  * Fully specify package key format, so external tools can generate it.

# 1.22.0.0 [Johan Tibell](mailto:johan.tibell@gmail.com) January 2015
  * Support GHC 7.10.
  * Experimental support for emitting DWARF debug info.
  * Preliminary support for relocatable packages.
  * Allow cabal to be used inside cabal exec environments.
  * hpc: support multiple "ways" (e.g. profiling and vanilla).
  * Support GHCJS.
  * Improved command line documentation.
  * Add `-none` constraint syntax for version ranges (#2093).
  * Make the default doc index file path compiler/arch/os-dependent
  (#2136).
  * Warn instead of dying when generating documentation and hscolour
  isn't installed (455f51622fa38347db62197a04bb0fa5b928ff17).
  * Support the new BinaryLiterals extension
  (1f25ab3c5eff311ada73c6c987061b80e9bbebd9).
  * Warn about `ghc-prof-options: -auto-all` in `cabal check` (#2162).
  * Add preliminary support for multiple instances of the same package
  version installed side-by-side (#2002).
  * New binary build config format - faster build times (#2076).
  * Support module thinning and renaming (#2038).
  * Add a new license type: UnspecifiedLicense (#2141).
  * Remove support for Hugs and nhc98 (#2168).
  * Invoke `tar` with `--formar ustar` if possible in `sdist` (#1903).
  * Replace `--enable-library-coverage` with `--enable-coverage`, which
  enables program coverage for all components (#1945).
  * Suggest that `ExitFailure 9` is probably due to memory
  exhaustion (#1522).
  * Drop support for Haddock < 2.0 (#1808, #1718).
  * Make `cabal test`/`cabal bench` build only what's needed for
  running tests/benchmarks (#1821).
  * Build shared libraries by default when linking executables dynamically.
  * Build profiled libraries by default when profiling executables.

----

### 1.20.0.4 [Ryan Thomas](mailto:ryan@ryant.org) January 2016
  * Cabal.cabal: change build-type to Simple.

### 1.20.0.1 [Johan Tibell](mailto:johan.tibell@gmail.com) May 2014
  * Fix streaming test output.

# 1.20.0.0 [Johan Tibell](mailto:johan.tibell@gmail.com) April 2014
  * Rewrite user guide
  * Fix repl Ctrl+C handling
  * Add haskell-suite compiler support
  * Add __HADDOCK_VERSION__ define
  * Allow specifying exact dependency version using hash
  * Rename extra-html-files to extra-doc-files
  * Add parallel build support for GHC 7.8 and later
  * Don't call ranlib on OS X
  * Avoid re-linking executables, test suites, and benchmarks
  unnecessarily, shortening build times
  * Add `--allow-newer` which allows upper version bounds to be
  ignored
  * Add `--enable-library-stripping`
  * Add command for freezing dependencies
  * Allow repl to be used outside Cabal packages
  * Add `--require-sandbox`
  * Don't use `--strip-unneeded` on OS X or iOS
  * Add new license-files field got additional licenses
  * Fix if(solaris) on some Solaris versions
  * Don't use -dylib-install-name on OS X with GHC > 7.8
  * Add DragonFly as a known OS
  * Improve pretty-printing of Cabal files
  * Add test flag `--show-details=streaming` for real-time test output
  * Add exec command

----

## 1.10.2.0 [Duncan Coutts](mailto:duncan@community.haskell.org) June 2011
  * Include test suites in cabal sdist
  * Fix for conditionals in test suite stanzas in `.cabal` files
  * Fix permissions of directories created during install
  * Fix for global builds when $HOME env var is not set

## 1.10.1.0 [Duncan Coutts](mailto:duncan@community.haskell.org) February 2011
  * Improved error messages when test suites are not enabled
  * Template parameters allowed in test `--test-option(s)` flag
  * Improved documentation of the test feature
  * Relaxed QA check on cabal-version when using test-suite sections
  * `haddock` command now allows both `--hoogle` and `--html` at the same time
  * Find ghc-version-specific instances of the hsc2hs program
  * Preserve file executable permissions in sdist tarballs
  * Pass gcc location and flags to ./configure scripts
  * Get default gcc flags from ghc

# 1.10.0.0 [Duncan Coutts](mailto:duncan@haskell.org) November 2010
  * New cabal test feature
  * Initial support for UHC
  * New default-language and other-languages fields (e.g. Haskell98/2010)
  * New default-extensions and other-extensions fields
  * Deprecated extensions field (for packages using cabal-version >=1.10)
  * Cabal-version field must now only be of the form `>= x.y`
  * Removed deprecated `--copy-prefix=` feature
  * Auto-reconfigure when `.cabal` file changes
  * Workaround for haddock overwriting .hi and .o files when using TH
  * Extra cpp flags used with hsc2hs and c2hs (-D${os}_BUILD_OS etc)
  * New cpp define VERSION_<package> gives string version of dependencies
  * User guide source now in markdown format for easier editing
  * Improved checks and error messages for C libraries and headers
  * Removed BSD4 from the list of suggested licenses
  * Updated list of known language extensions
  * Fix for include paths to allow C code to import FFI stub.h files
  * Fix for intra-package dependencies on OSX
  * Stricter checks on various bits of `.cabal` file syntax
  * Minor fixes for c2hs

----

### 1.8.0.6 [Duncan Coutts](mailto:duncan@haskell.org) June 2010
  * Fix `register --global/--user`

### 1.8.0.4 [Duncan Coutts](mailto:duncan@haskell.org) March 2010
  * Set dylib-install-name for dynalic libs on OSX
  * Stricter configure check that compiler supports a package's extensions
  * More configure-time warnings
  * Hugs can compile Cabal lib again
  * Default datadir now follows prefix on Windows
  * Support for finding installed packages for hugs
  * Cabal version macros now have proper parenthesis
  * Reverted change to filter out deps of non-buildable components
  * Fix for registering inplace when using a specific package db
  * Fix mismatch between $os and $arch path template variables
  * Fix for finding ar.exe on Windows, always pick ghc's version
  * Fix for intra-package dependencies with ghc-6.12

# 1.8.0.2 [Duncan Coutts](mailto:duncan@haskell.org) December 2009
  * Support for GHC-6.12
  * New unique installed package IDs which use a package hash
  * Allow executables to depend on the lib within the same package
  * Dependencies for each component apply only to that component
    (previously applied to all the other components too)
  * Added new known license MIT and versioned GPL and LGPL
  * More liberal package version range syntax
  * Package registration files are now UTF8
  * Support for LHC and JHC-0.7.2
  * Deprecated RecordPuns extension in favour of NamedFieldPuns
  * Deprecated PatternSignatures extension in favor of ScopedTypeVariables
  * New VersionRange semantic view as a sequence of intervals
  * Improved package quality checks
  * Minor simplification in a couple `Setup.hs` hooks
  * Beginnings of a unit level testsuite using QuickCheck
  * Various bug fixes
  * Various internal cleanups

----

### 1.6.0.2 [Duncan Coutts](mailto:duncan@haskell.org) February 2009
  * New configure-time check for C headers and libraries
  * Added language extensions present in ghc-6.10
  * Added support for NamedFieldPuns extension in ghc-6.8
  * Fix in configure step for ghc-6.6 on Windows
  * Fix warnings in `Path_pkgname.hs` module on Windows
  * Fix for exotic flags in ld-options field
  * Fix for using pkg-config in a package with a lib and an executable
  * Fix for building haddock docs for exes that use the Paths module
  * Fix for installing header files in subdirectories
  * Fix for the case of building profiling libs but not ordinary libs
  * Fix read-only attribute of installed files on Windows
  * Ignore ghc -threaded flag when profiling in ghc-6.8 and older

### 1.6.0.1 [Duncan Coutts](mailto:duncan@haskell.org) October 2008
  * Export a compat function to help alex and happy

# 1.6.0.0 [Duncan Coutts](mailto:duncan@haskell.org) October 2008
  * Support for ghc-6.10
  * Source control repositories can now be specified in `.cabal` files
  * Bug report URLs can be now specified in `.cabal` files
  * Wildcards now allowed in data-files and extra-source-files fields
  * New syntactic sugar for dependencies `build-depends: foo ==1.2.*`
  * New cabal_macros.h provides macros to test versions of dependencies
  * Relocatable bindists now possible on unix via env vars
  * New `exposed` field allows packages to be not exposed by default
  * Install dir flags can now use $os and $arch variables
  * New `--builddir` flag allows multiple builds from a single sources dir
  * cc-options now only apply to .c files, not for -fvia-C
  * cc-options are not longer propagated to dependent packages
  * The cpp/cc/ld-options fields no longer use `,` as a separator
  * hsc2hs is now called using gcc instead of using ghc as gcc
  * New api for manipulating sets and graphs of packages
  * Internal api improvements and code cleanups
  * Minor improvements to the user guide
  * Miscellaneous minor bug fixes

----

### 1.4.0.2 [Duncan Coutts](mailto:duncan@haskell.org) August 2008
  * Fix executable stripping default
  * Fix striping exes on OSX that export dynamic symbols (like ghc)
  * Correct the order of arguments given by `--prog-options=`
  * Fix corner case with overlapping user and global packages
  * Fix for modules that use pre-processing and `.hs-boot` files
  * Clarify some points in the user guide and readme text
  * Fix verbosity flags passed to sub-command like haddock
  * Fix `sdist --snapshot`
  * Allow meta-packages that contain no modules or C code
  * Make the generated Paths module -Wall clean on Windows

### 1.4.0.1 [Duncan Coutts](mailto:duncan@haskell.org) June 2008
  * Fix a bug which caused `.` to always be in the sources search path
  * Haddock-2.2 and later do now support the `--hoogle` flag

# 1.4.0.0 [Duncan Coutts](mailto:duncan@haskell.org) June 2008
  * Rewritten command line handling support
  * Command line completion with bash
  * Better support for Haddock 2
  * Improved support for nhc98
  * Removed support for ghc-6.2
  * Haddock markup in `.lhs` files now supported
  * Default colour scheme for highlighted source code
  * Default prefix for `--user` installs is now `$HOME/.cabal`
  * All `.cabal` files are treaded as UTF-8 and must be valid
  * Many checks added for common mistakes
  * New `--package-db=` option for specific package databases
  * Many internal changes to support cabal-install
  * Stricter parsing for version strings, eg dissalows "1.05"
  * Improved user guide introduction
  * Programatica support removed
  * New options `--program-prefix/suffix` allows eg versioned programs
  * Support packages that use `.hs-boot` files
  * Fix sdist for Main modules that require preprocessing
  * New configure -O flag with optimisation level 0--2
  * Provide access to "`x-`" extension fields through the Cabal api
  * Added check for broken installed packages
  * Added warning about using inconsistent versions of dependencies
  * Strip binary executable files by default with an option to disable
  * New options to add site-specific include and library search paths
  * Lift the restriction that libraries must have exposed-modules
  * Many bugs fixed.
  * Many internal structural improvements and code cleanups

----

## 1.2.4.0 [Duncan Coutts](mailto:duncan@haskell.org) June 2008
  * Released with GHC 6.8.3
  * Backported several fixes and minor improvements from Cabal-1.4
  * Use a default colour scheme for sources with hscolour >=1.9
  * Support `--hyperlink-source` for Haddock >= 2.0
  * Fix for running in a non-writable directory
  * Add OSX -framework arguments when linking executables
  * Updates to the user guide
  * Allow build-tools names to include + and _
  * Export autoconfUserHooks and simpleUserHooks
  * Export ccLdOptionsBuildInfo for `Setup.hs` scripts
  * Export unionBuildInfo and make BuildInfo an instance of Monoid
  * Fix to allow the `main-is` module to use a pre-processor

## 1.2.3.0 [Duncan Coutts](mailto:duncan@haskell.org) Nov 2007
  * Released with GHC 6.8.2
  * Includes full list of GHC language extensions
  * Fix infamous `dist/conftest.c` bug
  * Fix `configure --interfacedir=`
  * Find ld.exe on Windows correctly
  * Export PreProcessor constructor and mkSimplePreProcessor
  * Fix minor bug in unlit code
  * Fix some markup in the haddock docs

## 1.2.2.0 [Duncan Coutts](mailto:duncan@haskell.org) Nov 2007
  * Released with GHC 6.8.1
  * Support haddock-2.0
  * Support building DSOs with GHC
  * Require reconfiguring if the `.cabal` file has changed
  * Fix os(windows) configuration test
  * Fix building documentation
  * Fix building packages on Solaris
  * Other minor bug fixes

## 1.2.1 [Duncan Coutts](mailto:duncan@haskell.org) Oct 2007
  * To be included in GHC 6.8.1
  * New field `cpp-options` used when preprocessing Haskell modules
  * Fixes for hsc2hs when using ghc
  * C source code gets compiled with -O2 by default
  * OS aliases, to allow os(windows) rather than requiring os(mingw32)
  * Fix cleaning of `stub` files
  * Fix cabal-setup, command line ui that replaces `runhaskell Setup.hs`
  * Build docs even when dependent packages docs are missing
  * Allow the `--html-dir` to be specified at configure time
  * Fix building with ghc-6.2
  * Other minor bug fixes and build fixes

# 1.2.0  [Duncan Coutts](mailto:duncan.coutts@worc.ox.ac.uk) Sept 2007
  * To be included in GHC 6.8.x
  * New configurations feature
  * Can make haddock docs link to highlighted sources (with hscolour)
  * New flag to allow linking to haddock docs on the web
  * Supports pkg-config
  * New field `build-tools` for tool dependencies
  * Improved c2hs support
  * Preprocessor output no longer clutters source dirs
  * Separate `includes` and `install-includes` fields
  * Makefile command to generate makefiles for building libs with GHC
  * New `--docdir` configure flag
  * Generic `--with-prog` `--prog-args` configure flags
  * Better default installation paths on Windows
  * Install paths can be specified relative to each other
  * License files now installed
  * Initial support for NHC (incomplete)
  * Consistent treatment of verbosity
  * Reduced verbosity of configure step by default
  * Improved helpfulness of output messages
  * Help output now clearer and fits in 80 columns
  * New setup register `--gen-pkg-config` flag for distros
  * Major internal refactoring, hooks api has changed
  * Dozens of bug fixes

----

### 1.1.6.2 [Duncan Coutts](mailto:duncan.coutts@worc.ox.ac.uk) May 2007

  * Released with GHC 6.6.1
  * Handle windows text file encoding for `.cabal` files
  * Fix compiling a executable for profiling that uses Template Haskell
  * Other minor bug fixes and user guide clarifications

### 1.1.6.1 [Duncan Coutts](mailto:duncan.coutts@worc.ox.ac.uk) Oct 2006

  * fix unlit code
  * fix escaping in register.sh

## 1.1.6  [Duncan Coutts](mailto:duncan.coutts@worc.ox.ac.uk) Oct 2006

  * Released with GHC 6.6
  * Added support for hoogle
  * Allow profiling and normal builds of libs to be chosen independently
  * Default installation directories on Win32 changed
  * Register haddock docs with ghc-pkg
  * Get haddock to make hyperlinks to dependent package docs
  * Added BangPatterns language extension
  * Various bug fixes

## 1.1.4  [Duncan Coutts](mailto:duncan.coutts@worc.ox.ac.uk) May 2006

  * Released with GHC 6.4.2
  * Better support for packages that need to install header files
  * cabal-setup added, but not installed by default yet
  * Implemented `setup register --inplace`
  * Have packages exposed by default with ghc-6.2
  * It is no longer necessary to run `configure` before `clean` or `sdist`
  * Added support for ghc's `-split-objs`
  * Initial support for JHC
  * Ignore extension fields in `.cabal` files (fields beginning with "`x-`")
  * Some changes to command hooks API to improve consistency
  * Hugs support improvements
  * Added GeneralisedNewtypeDeriving language extension
  * Added cabal-version field
  * Support hidden modules with haddock
  * Internal code refactoring
  * More bug fixes

## 1.1.3  [Isaac Jones](mailto:ijones@syntaxpolice.org) Sept 2005

  * WARNING: Interfaces not documented in the user's guide may
    change in future releases.
  * Move building of GHCi .o libs to the build phase rather than
  register phase. (from Duncan Coutts)
  * Use .tar.gz for source package extension
  * Uses GHC instead of cpphs if the latter is not available
  * Added experimental "command hooks" which completely override the
  default behavior of a command.
  * Some bugfixes

# 1.1.1  [Isaac Jones](mailto:ijones@syntaxpolice.org) July 2005

  * WARNING: Interfaces not documented in the user's guide may
    change in future releases.
  * Handles recursive modules for GHC 6.2 and GHC 6.4.
  * Added `setup test` command (Used with UserHook)
  * implemented handling of _stub.{c,h,o} files
  * Added support for profiling
  * Changed install prefix of libraries (pref/pkgname-version
    to prefix/pkgname-version/compname-version)
  * Added pattern guards as a language extension
  * Moved some functionality to Language.Haskell.Extension
  * Register / unregister .bat files for windows
  * Exposed more of the API
  * Added support for the hide-all-packages flag in GHC > 6.4
  * Several bug fixes

----

# 1.0  [Isaac Jones](mailto:ijones@syntaxpolice.org) March 11 2005

  * Released with GHC 6.4, Hugs March 2005, and nhc98 1.18
  * Some sanity checking

----

# 0.5  [Isaac Jones](mailto:ijones@syntaxpolice.org) Wed Feb 19 2005

  * __WARNING__: this is a pre-release and the interfaces are
    still likely to change until we reach a 1.0 release.
  * Hooks interfaces changed
  * Added preprocessors to user hooks
  * No more executable-modules or hidden-modules.  Use
    `other-modules` instead.
  * Certain fields moved into BuildInfo, much refactoring
  * `extra-libs` -> `extra-libraries`
  * Added `--gen-script` to configure and unconfigure.
  * `modules-ghc` (etc) now `ghc-modules` (etc)
  * added new fields including `synopsis`
  * Lots of bug fixes
  * spaces can sometimes be used instead of commas
  * A user manual has appeared (Thanks, ross!)
  * for ghc 6.4, configures versioned depends properly
  * more features to `./setup haddock`

----

# 0.4  [Isaac Jones](mailto:ijones@syntaxpolice.org) Sun Jan 16 2005

  * Much thanks to all the awesome fptools hackers who have been
  working hard to build the Haskell Cabal!

  * __Interface Changes__:

    * __WARNING__: this is a pre-release and the interfaces are still
    likely to change until we reach a 1.0 release.

    * Instead of Package.description, you should name your
    description files <something>.cabal.  In particular, we suggest
    that you name it <packagename>.cabal, but this is not enforced
    (yet).  Multiple `.cabal` files in the same directory is an error,
    at least for now.

    * `./setup install --install-prefix` is gone.  Use `./setup copy`
    `--copy-prefix` instead.

    * The `Modules` field is gone.  Use `hidden-modules`,
    `exposed-modules`, and `executable-modules`.

    * `Build-depends` is now a package-only field, and can't go into
    executable stanzas.  Build-depends is a package-to-package
    relationship.

    * Some new fields.  Use the Source.

  * __New Features__

    * Cabal is now included as a package in the CVS version of
    fptools.  That means it'll be released as `-package Cabal` in
    future versions of the compilers, and if you are a bleeding-edge
    user, you can grab it from the CVS repository with the compilers.

    * Hugs compatibility and NHC98 compatibility should both be
    improved.

    * Hooks Interface / Autoconf compatibility: Most of the hooks
    interface is hidden for now, because it's not finalized.  I have
    exposed only `defaultMainWithHooks` and `defaultUserHooks`.  This
    allows you to use a ./configure script to preprocess
    `foo.buildinfo`, which gets merged with `foo.cabal`.  In future
    releases, we'll expose UserHooks, but we're definitely going to
    change the interface to those.  The interface to the two functions
    I've exposed should stay the same, though.

    * ./setup haddock is a baby feature which pre-processes the
    source code with hscpp and runs haddock on it.  This is brand new
    and hardly tested, so you get to knock it around and see what you
    think.

    * Some commands now actually implement verbosity.

    * The preprocessors have been tested a bit more, and seem to work
    OK.  Please give feedback if you use these.

----

# 0.3  [Isaac Jones](mailto:ijones@syntaxpolice.org) Sun Jan 16 2005

  * Unstable snapshot release
  * From now on, stable releases are even.

----

# 0.2  [Isaac Jones](mailto:ijones@syntaxpolice.org)

  * Adds more HUGS support and preprocessor support.
