#add parent dir to find package. Only needed for source code build, pip install doesn't need it.
import os, inspect
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(os.path.dirname(currentdir))
os.sys.path.insert(0,parentdir)

import gym
import numpy as np
import pybullet as p
import pybullet_envs
import time

def relu(x):
    return np.maximum(x, 0)

class SmallReactivePolicy:
    "Simple multi-layer perceptron policy, no internal state"
    def __init__(self, observation_space, action_space):
        assert weights_dense1_w.shape == (observation_space.shape[0], 128)
        assert weights_dense2_w.shape == (128, 64)
        assert weights_final_w.shape  == (64, action_space.shape[0])

    def act(self, ob):
        x = ob
        x = relu(np.dot(x, weights_dense1_w) + weights_dense1_b)
        x = relu(np.dot(x, weights_dense2_w) + weights_dense2_b)
        x = np.dot(x, weights_final_w) + weights_final_b
        return x

def main():
    env = gym.make("HalfCheetahBulletEnv-v0")
    env.render(mode="human")

    pi = SmallReactivePolicy(env.observation_space, env.action_space)
    #disable rendering during reset, makes loading much faster
    env.reset()
    torsoId = -1
    for i in range (p.getNumBodies()):
        print(p.getBodyInfo(i))
        if (p.getBodyInfo(i)[1].decode() == "cheetah"):
           torsoId=i
           print("found torso")
           print(p.getNumJoints(torsoId))
           for j in range (p.getNumJoints(torsoId)):
              print(p.getJointInfo(torsoId,j))#LinkState(torsoId,j))

    while 1:
        frame = 0
        score = 0
        restart_delay = 0
        obs = env.reset()
     
        while 1:
            time.sleep(0.01)
            a = pi.act(obs)
            obs, r, done, _ = env.step(a)
            score += r
            frame += 1
            distance=5
            yaw = 0
            humanPos = p.getLinkState(torsoId,4)[0]
            p.resetDebugVisualizerCamera(distance,yaw,-20,humanPos);
            still_open = env.render("human")
            if still_open==False:
                return
            if not done: continue
            if restart_delay==0:
                print("score=%0.2f in %i frames" % (score, frame))
                restart_delay = 60*2  # 2 sec at 60 fps
            else:
                restart_delay -= 1
                if restart_delay==0: break

weights_dense1_w = np.array([
[ -0.4105, +0.5540, +0.2791, +0.4953, -0.0309, +0.8480, +0.1630, +0.0630, +0.7107, +0.0597, +0.2675, -0.1931, -0.2436, +0.2909, +0.3563, +0.4564, -0.0445, -0.2228, +0.7005, +0.8368, +0.3631, +0.7365, +0.2453, +0.4687, +0.4819, +0.4940, +0.5096, +0.5929, +0.5504, +0.2265, +0.4118, +0.5993, +0.2402, -0.5087, -0.0756, +0.7520, -0.0086, -0.0648, +0.0564, -0.0812, -0.0093, +0.8482, +0.7333, +0.4401, -0.1273, -0.2974, +0.1284, -0.4948, +0.1120, +0.7938, +0.1297, +1.0807, +0.2480, +0.2444, +0.4258, +0.1515, -0.0126, +0.3098, -0.2786, +0.4913, +0.3065, +0.3356, +0.6884, +0.3117, +0.3163, +0.4234, +0.1172, +0.8810, +0.3574, -0.3993, -0.5597, +0.2233, +0.8058, +0.3391, -0.1113, +0.1884, +0.1324, +0.0503, +0.1807, +0.0441, -0.2065, +0.1978, +0.0852, -0.3531, +0.2180, +0.7946, -0.0318, +0.0650, -0.3174, -0.1715, -0.0486, +0.2131, -0.3901, +0.1995, +0.8593, +0.1786, +0.3595, +0.7852, +0.3491, -0.4206, +0.6117, -0.1991, +0.1876, -0.3114, -0.2007, -0.2738, -0.0388, +0.0465, +0.2726, -0.5321, +0.4720, -0.0555, +0.3415, +0.1447, -0.1132, -0.2958, -0.6729, -0.5003, -0.4960, -0.2600, -0.4158, -0.4476, -0.8244, -0.0574, +0.2194, +0.0541, -0.3526, -0.1131],
[ -0.2662, +0.1763, +0.0520, +0.3624, +0.0564, +0.2756, +0.0743, +0.0155, +0.1861, -0.5311, +0.2181, -0.3643, +0.1433, +0.1801, -0.1781, -0.3576, -0.2487, +0.0588, +0.3906, -0.3994, +0.1343, +0.2701, +0.1613, +0.1962, -0.0277, +0.0303, +0.0845, -0.1033, -0.1092, -0.1026, -0.2261, +0.3324, +0.1881, -0.2780, -0.0865, -0.2131, -0.1238, -0.1727, +0.1086, +0.1383, +0.1794, +0.0677, -0.0582, -0.0758, +0.0834, +0.0847, +0.0945, +0.1888, -0.0696, +0.0111, -0.0028, +0.0439, -0.3847, -0.1564, -0.2226, +0.0002, +0.0926, -0.2819, -0.0868, +0.2233, +0.0738, +0.1671, -0.0326, +0.3784, -0.0117, +0.0836, +0.0285, +0.0376, +0.0157, +0.1297, +0.0556, -0.0533, -0.0103, +0.0740, -0.1825, -0.2399, -0.0609, -0.0030, +0.1811, -0.2784, -0.2249, +0.3637, +0.1895, +0.3102, -0.0767, +0.1143, -0.0840, +0.2981, -0.3040, +0.0135, +0.2495, +0.0036, -0.1493, -0.1144, -0.0006, +0.1195, +0.0961, -0.4227, -0.3022, +0.2102, +0.2024, -0.2111, +0.1507, +0.2948, -0.1822, +0.2263, -0.3213, +0.0380, -0.1188, +0.1237, +0.0731, +0.0044, -0.1637, -0.3173, +0.0895, -0.0130, +0.0703, -0.2186, +0.1401, +0.1191, +0.0225, -0.3208, -0.0578, -0.3113, +0.1041, -0.1957, -0.3054, -0.0797],
[ +0.3485, -0.3161, -0.4092, +0.1190, -0.5706, -0.3627, +0.0576, -0.1068, +0.1367, +0.1686, +0.0284, -0.1694, -0.0496, -0.1647, +0.0111, -0.1897, -0.4613, -0.5996, -0.0601, -0.1417, -0.0236, -0.0898, +0.1239, -0.2693, -0.1709, +0.3592, -0.1284, -0.0376, -0.1308, -0.1832, -0.0538, -0.0467, -0.1181, -0.0994, -0.3281, +0.0527, -0.4579, -0.1062, -0.1058, -0.4459, -0.0901, -0.0246, -0.1125, +0.1228, -0.3428, -0.3385, +0.0366, -0.0988, +0.1345, +0.0299, +0.2921, -0.1347, +0.1688, -0.1350, -0.0888, +0.0734, -0.0936, -0.2695, +0.0154, +0.0237, -0.1334, -0.3247, -0.1856, -0.0449, -0.0772, +0.0176, -0.0856, -0.1746, -0.1575, -0.2365, -0.0741, -0.1638, +0.0864, -0.0243, -0.0472, +0.0423, -0.2962, -0.2523, -0.1430, +0.1470, -0.1122, -0.1843, -0.1437, -0.1895, +0.1110, -0.2572, -0.3307, -0.2597, -0.4706, -0.2441, -0.2988, -0.5409, -0.1696, +0.0810, -0.2336, -0.0925, +0.4226, +0.1162, -0.3211, -0.2118, -0.3100, -0.1384, +0.1625, +0.0005, -0.1936, +0.2836, +0.1660, -0.2154, +0.1341, -0.2413, -0.1203, -0.3427, +0.0863, +0.1393, -0.3580, +0.1443, -0.2158, -0.4703, -0.2687, -0.0573, +0.1099, -0.2551, -0.0506, -0.3351, -0.2325, -0.0119, -0.0907, -0.0628],
[ +0.0565, +0.2158, +0.1461, +0.1045, -0.3548, -0.2816, -0.0124, -0.0931, +0.1249, +0.0093, -0.3325, -0.1646, +0.3022, -0.0509, -0.1403, +0.3703, +0.2642, +0.0835, +0.1347, +0.1734, -0.0112, +0.3162, -0.0076, +0.1258, -0.2059, +0.2387, +0.0775, -0.1653, -0.3899, -0.1205, -0.2263, +0.2800, -0.1979, +0.1708, +0.0505, -0.0998, +0.1838, -0.1314, -0.1932, -0.1897, -0.3157, -0.0113, -0.3488, +0.1534, -0.3546, -0.1098, +0.0652, -0.1327, -0.0131, +0.3698, -0.0927, +0.1735, -0.4869, +0.1768, -0.0187, -0.1069, -0.2118, -0.2557, -0.1380, -0.0579, -0.2147, +0.3389, -0.1801, +0.1954, -0.2856, +0.0825, +0.1846, -0.2102, +0.4063, -0.0422, +0.1645, -0.2313, -0.2017, -0.2554, +0.1597, -0.1198, +0.4493, +0.1135, +0.1556, -0.0380, +0.0527, -0.0505, -0.5094, -0.4410, +0.2543, +0.2891, -0.0031, -0.0863, +0.2982, +0.1069, -0.4814, +0.0295, -0.0547, +0.0518, -0.4326, -0.0295, -0.3795, +0.0399, +0.0363, +0.1623, +0.4509, +0.2852, -0.4404, +0.0109, -0.0394, +0.0092, -0.1684, +0.4728, -0.1317, +0.0575, -0.3862, -0.1313, +0.0676, +0.1321, -0.2816, -0.0500, -0.0027, +0.0906, +0.0297, -0.1476, +0.0337, +0.0911, -0.1591, +0.2816, -0.0435, -0.3437, -0.0732, -0.4545],
[ -0.2090, -0.1890, -0.4459, +0.0942, +0.2823, -0.0085, -0.1576, -0.5515, +0.1211, -0.0689, +0.2807, +0.1457, +0.2009, -0.2739, +0.0296, -0.0511, -0.1048, -0.1275, +0.2358, +0.3103, +0.2239, +0.2028, -0.0858, +0.0520, -0.1453, +0.2013, -0.2131, -0.0596, -0.0469, -0.0934, -0.2082, +0.2071, -0.5051, +0.1719, -0.1380, -0.2781, -0.0598, -0.1636, +0.2784, -0.0144, +0.0655, -0.1932, +0.1421, -0.0840, -0.0277, -0.2310, -0.0509, +0.0870, +0.0721, -0.1785, +0.1514, -0.1485, -0.1158, +0.1124, -0.1155, -0.4105, -0.1765, +0.0103, -0.1695, +0.0521, -0.1132, -0.1209, -0.1313, -0.0419, +0.1828, -0.1026, +0.0564, +0.0095, -0.0414, +0.1264, +0.1588, -0.2200, +0.1928, -0.2098, +0.4256, -0.3453, -0.3882, -0.2238, -0.1347, +0.2160, +0.4278, -0.2666, -0.1046, +0.2501, +0.0238, +0.2802, -0.3955, +0.1452, +0.1773, -0.0727, -0.3603, -0.2480, -0.0412, +0.2462, +0.2148, -0.2819, +0.0982, -0.0102, +0.0310, +0.0147, +0.0597, +0.0514, -0.0032, +0.1320, -0.0606, -0.0637, +0.0398, +0.1367, +0.0646, -0.0435, +0.0527, +0.1258, -0.2075, -0.1816, -0.2129, -0.1253, +0.2394, -0.2325, -0.1115, -0.4115, -0.1196, -0.2855, +0.3805, -0.2741, -0.0278, -0.3461, +0.0139, -0.0499],
[ -0.6025, +0.2692, +0.5276, +0.3615, -0.3196, +0.3828, +0.1312, -1.1323, -0.0073, -0.1227, -0.0831, +0.0605, -1.0515, -0.1917, -0.2510, +0.2964, -1.1074, -0.1708, -0.4475, -0.1189, +0.3345, +0.5101, +0.4628, +1.1872, +0.5829, +0.0234, +0.0306, +0.0021, -0.1827, -0.0257, -0.2993, +0.0083, -0.9032, -0.0311, +0.0045, +0.6173, +0.3095, -0.1490, -0.2561, +0.2011, -0.1550, -0.1936, +0.0729, +0.7613, -0.9194, +0.1954, +0.0306, +0.2292, +0.1529, -0.1161, -0.0182, -0.2625, -0.3142, -0.9182, +0.2761, +0.3656, +0.3537, +1.0318, -0.4273, +0.1703, -0.2378, -0.4640, +0.6184, +0.3686, -0.3043, -0.4850, -0.2155, -0.6656, +0.1921, -0.2552, -0.8096, +0.8593, -0.3583, -0.0332, -0.5619, +0.2977, -0.3425, -0.7839, -0.4299, -0.2358, +0.0526, -0.0752, -0.6535, +0.0501, -0.4043, +0.8261, -0.4269, -0.1165, +0.3480, -0.2337, -0.3269, -0.2775, +0.7307, +0.5863, -0.1005, -0.3421, +0.1591, +0.4530, -0.1228, -1.0896, +0.6218, -0.0610, -0.1239, -1.5883, -0.1711, -0.4331, -0.3553, +0.0773, +0.3669, -0.5690, +0.7117, -0.2021, -0.1426, -0.1125, +0.0364, +0.2397, -0.1739, -0.3131, -0.9135, -0.7713, -0.0638, -0.3219, +0.0353, +0.3407, -0.0035, -0.1492, -0.1118, -0.4841],
[ -0.0175, -0.3710, +0.0894, +0.2056, -0.2250, +0.0982, +0.0039, -0.2128, -0.0479, +0.3049, +0.2228, -0.1747, -0.0936, +0.1146, +0.1377, +0.0127, +0.0014, +0.1374, +0.1557, -0.1890, -0.2396, +0.2248, +0.1710, -0.2916, +0.4568, -0.0645, -0.0760, -0.2067, -0.3900, +0.0276, -0.3171, -0.0148, +0.2019, -0.1335, -0.0731, -0.3224, +0.0859, +0.2299, +0.0602, +0.0499, -0.2686, +0.1028, +0.1204, +0.0321, +0.0636, -0.1350, -0.1789, -0.0529, -0.2255, +0.1867, +0.1258, +0.1392, -0.2657, +0.1478, +0.1961, -0.0687, +0.1878, +0.2016, -0.2413, +0.0050, -0.0666, -0.0226, -0.0185, +0.4750, -0.1661, +0.0637, -0.2668, +0.1875, +0.0032, +0.1176, +0.1844, -0.1665, -0.1806, -0.3208, +0.0606, -0.0122, +0.2792, +0.1867, +0.1424, +0.2775, +0.1074, -0.2996, +0.0562, -0.1864, +0.1985, +0.1356, -0.3013, -0.0824, -0.1534, -0.0795, -0.0086, -0.0490, -0.0861, -0.0986, +0.3499, -0.0630, +0.0028, -0.1540, +0.0377, -0.1057, +0.1303, +0.1379, -0.1257, -0.2578, -0.0744, -0.1304, +0.0411, -0.1635, +0.0535, +0.0271, +0.1674, +0.1309, -0.0397, -0.1127, -0.2217, +0.0548, -0.5178, +0.1170, +0.4857, +0.1134, +0.0598, +0.1467, +0.1405, -0.1152, +0.1825, -0.0382, +0.1325, +0.2708],
[ -0.1185, -1.2480, -0.6130, -0.9105, +0.1073, -0.7702, -1.2908, +0.6513, -0.3928, -0.7365, -0.2977, +0.7845, +0.3186, +0.2207, -1.1391, -0.9353, +1.1582, -0.7291, +0.2077, +0.2808, -0.5894, +0.4805, -0.2316, -0.8861, -0.4102, -1.1704, +0.9183, -0.0637, -0.1935, -0.2971, -0.6144, +0.6113, +0.1596, -0.2931, +0.3199, -0.2938, -0.2098, +0.3615, -0.3433, +0.0334, +0.2148, -1.9070, -0.0655, -0.5875, +0.5659, +0.0436, +0.5074, +0.5399, -0.2164, -0.7224, -0.1556, -1.3397, +0.5629, +0.1272, -0.1749, -1.2117, +0.9305, -0.9436, -0.9450, -0.4745, -0.9840, -0.5153, -0.1703, -0.5252, -0.0291, +0.3351, +1.0137, -1.4468, +0.1594, +0.4054, +0.9667, -0.3279, -1.2628, -0.6361, -0.1322, -0.4219, -0.8181, +0.1316, +0.3924, +0.4478, +0.5855, -0.0547, -1.4541, +0.1199, -0.2794, -0.9176, +0.8841, +0.2706, -0.1612, +0.7667, -0.3909, -1.6514, +0.1562, -0.3166, -0.2654, +1.0692, -0.1898, -1.3619, +0.0357, +0.6267, -0.0957, -0.5473, -0.9002, +0.4248, +0.7671, +0.6034, +0.1176, +0.4126, -0.4076, +0.5846, -0.4275, +0.0146, +0.5074, +0.4825, +0.3414, -0.0289, +0.5663, +0.9628, +0.9791, -0.1043, +1.2530, +1.3600, +1.6041, +0.4200, -0.2415, -0.4470, +0.6965, +0.2395],
[ +1.2479, -0.0619, -0.4174, -0.2800, +0.2902, +0.2310, +0.0858, -0.0805, +0.2556, +0.8018, -0.1018, +0.9876, +0.2342, +0.3219, +0.3031, -0.1343, +0.0737, +0.2219, -0.6479, -0.4475, +0.3711, +0.4780, -0.8735, +0.6208, -0.3031, +0.1480, +0.4935, +0.9053, +0.0797, -0.3932, +0.0853, -0.4709, -0.6192, +1.1604, -0.0924, -0.2548, +0.5836, +0.0325, -0.2435, -0.1506, -0.1754, -0.2248, -0.8059, -0.1997, +0.7772, +0.1456, -0.1463, -0.0360, -0.0240, -0.1852, -0.1289, +0.9165, -0.2434, +0.7580, +0.3838, -0.0338, +0.1199, -0.1700, -0.4038, -0.1863, +0.0925, -0.2396, +0.4659, +0.1810, +0.6990, +0.2880, +0.0641, -0.3991, +0.6049, -0.5948, -0.1894, -0.7874, -0.6910, +0.0824, +0.5111, -0.2513, +0.4632, +0.7014, -0.6793, +0.0562, -0.0800, +0.2665, -0.0270, +0.1830, +0.8184, +0.5293, -0.3352, +0.1144, +0.7672, -0.0924, +0.2099, -0.0854, -0.1534, +0.2607, -0.1140, -0.1163, +0.0403, +0.2623, +0.4065, +0.9303, +0.4008, -0.1773, +0.0368, +0.4014, -0.6941, +0.0333, +0.3245, +0.0262, +0.7663, +0.3834, +0.4088, +0.0289, -0.6102, +0.5717, -0.0787, +0.2367, +0.2061, -0.3039, -0.0797, +0.0814, +1.2009, +0.4369, +0.0788, +0.2358, +0.9926, +0.5428, -0.5656, -0.2758],
[ +0.3487, +0.2086, -0.0813, +0.4360, -0.2904, +0.4395, +0.1773, +0.0481, +0.4503, +0.4991, +0.3741, +0.1866, -0.2241, -0.3511, +0.2302, +0.5140, +0.5208, +0.5968, +0.5189, +0.2814, +0.3372, +0.3461, +0.0298, +0.0069, -0.1004, +0.5782, -0.2609, +0.1167, -0.5090, -0.3220, +0.0509, +0.4076, -0.1667, +0.2021, -0.0495, +0.2189, -0.0504, -0.3792, -0.4321, +0.0364, -0.0175, -0.0359, +0.0965, +0.3641, -0.2778, -0.1170, +0.7745, -0.2177, +0.1121, +0.0240, +0.6502, +0.1845, -0.0903, +0.3065, +0.0884, +0.4046, -0.2021, -0.3310, +0.0056, -0.2555, +0.0209, +0.5952, -0.1765, +0.0503, -0.0449, +0.2059, +0.2699, -0.2488, -0.6611, +0.2942, -0.4384, +0.3329, +0.4411, -0.1499, -0.0820, +0.5042, +0.2737, -0.3949, +0.4931, +0.0065, -0.8717, -0.4590, +0.1508, +0.3686, +0.1564, -0.2887, -0.3002, -0.0485, +0.0003, -0.4201, -0.0104, +0.2674, +0.1690, +0.1299, -0.0258, -0.0109, +0.6633, +0.3255, -0.0330, +0.4770, +0.3560, +0.1506, +0.3608, +0.4205, +0.0090, -0.3770, +0.2320, -0.2200, +0.0256, -0.2081, -0.1292, +0.0661, -0.3286, +0.1211, +0.1542, +0.5790, +0.0675, -0.1831, -0.0903, +0.0403, +0.1506, -0.2725, +0.1505, -0.3582, -0.2939, -0.3307, -0.2906, -0.1859],
[ +0.6120, +0.3881, -0.2144, +0.0539, +0.2717, +0.0574, -0.6547, -1.1043, -0.4978, +1.0026, -0.2662, -0.3964, -0.4590, +0.5876, +0.3651, +0.2121, -0.3029, +0.4225, -0.2654, -0.0867, -0.0286, +0.4754, +0.5950, -0.0923, +0.5628, -0.1033, -0.1225, -0.5554, -0.9027, -0.3767, -0.7881, -0.0124, -0.6633, -0.7063, +0.4806, -1.2205, -0.1279, +0.0321, +0.3928, +0.0134, +0.3143, -0.5378, +0.0553, +0.1611, +0.0254, -0.4512, +0.7660, +0.4550, +0.6917, +0.0186, +0.1970, -0.4484, +0.4214, +0.5640, +0.7182, -0.6329, +0.3644, -0.5340, -0.0268, -0.3028, +0.4847, -0.1190, -0.3030, +0.4755, +0.1916, -0.1579, -0.1899, -0.1830, +0.2239, -0.8405, -0.0194, -0.4524, -0.6924, +1.0233, -0.1682, -1.0005, -0.1989, +0.0655, -0.5738, +0.3489, -0.2032, -0.5767, +0.2677, -0.2104, +0.9164, -0.6995, +0.3138, +0.2631, +0.4646, -0.7949, -0.4088, +0.0390, +0.5322, +0.8076, +0.3327, -0.8003, -0.4473, +0.2003, -0.0771, +0.9627, -0.5091, +0.5703, -0.3930, +0.3132, +0.9709, +0.2298, +0.2046, -0.4682, -0.4135, +0.8331, -0.0837, -0.2126, -0.2461, -0.6451, -0.3118, +0.1340, +0.3047, -0.3990, +0.8511, -0.0305, +0.7664, +0.2561, +0.5513, +0.2083, -0.7912, -0.5125, -0.5167, -0.5089],
[ +0.2836, +0.6191, -0.2299, +0.4317, +0.1775, -0.6181, +0.0461, +0.0362, +0.0559, +0.7882, -0.1351, -0.3722, +0.1090, +0.0281, +0.1148, +0.7799, -0.2107, -0.3900, -0.2063, -0.3643, +0.7287, -0.2938, +0.1283, -0.1046, +0.0992, -0.1031, +0.6297, -0.8027, -0.0918, +0.2503, +0.5527, +0.3296, -0.0083, -0.1686, +0.0065, +0.2643, +0.1768, -0.4890, +0.0692, +0.5517, +0.6225, -0.0423, -1.0015, -0.5841, -0.2217, -0.6242, -0.1942, -0.3841, +0.7571, +0.4939, -0.2331, +0.1612, +0.0843, +1.2429, -0.2966, -0.5344, +1.0299, -0.7019, -0.1317, -0.0856, +0.2293, -0.0003, -0.0487, -0.5326, +0.0300, +0.5683, +0.2054, -0.3269, +0.6114, -0.5650, -0.1812, -0.8703, +0.0364, +0.6392, -0.7844, +0.0227, +0.6228, +0.5272, -0.8685, -0.4089, -0.3416, -0.1562, +0.1535, -0.0063, +0.6183, -0.5915, -0.1640, -0.2188, +0.4079, -0.3470, +0.5118, +0.4866, -0.9074, -0.0650, +0.3942, -0.1759, -0.3695, +0.1913, +0.9200, +0.2702, -0.2663, +0.1217, -0.1575, -0.2490, +0.1515, -0.7135, +0.4985, +0.1606, -0.1133, -0.2688, -0.4154, -0.5524, -0.0633, -0.0389, +0.4926, -0.0719, -0.3427, -0.6053, -0.1829, -0.5910, +0.1137, +0.0312, +0.4532, +0.1142, +0.3834, -0.0407, -0.5945, -0.6180],
[ +0.0362, -0.5185, -0.3235, +0.0613, +0.3283, +0.6853, -0.3136, +0.4028, +0.2535, +0.0223, +0.1985, -0.9784, +0.8819, -0.4328, -0.1815, +0.2478, -0.1824, -0.0182, +0.3654, -0.2296, +0.3019, -0.1017, +0.5535, +0.2589, -0.4000, +0.0137, -0.4569, +0.4085, +0.3198, +0.1833, -0.2268, +0.1447, +0.3493, +0.4606, -0.2277, -0.0773, -0.6224, +0.8234, +0.0221, +0.5623, -0.1428, -0.5706, +0.5371, +0.8732, -0.5540, -0.0395, +0.8031, +0.3599, +0.5903, +0.0713, -0.1844, +0.5461, +0.1745, +0.1545, -0.2652, -0.0803, +0.2160, -0.4186, -0.3271, +1.0229, -0.0675, +0.0257, +0.3415, +0.1843, -0.4467, +0.0753, +0.3914, -0.0426, +0.2589, -0.2688, -0.2011, -0.0360, -0.2472, -0.4691, +0.1115, -0.3416, +0.1560, -0.1638, -0.3131, -0.3056, +0.1102, +0.0386, -0.0213, +0.0334, +0.5400, +0.3385, +0.0520, +0.2917, +0.0586, +0.3761, -0.2422, -0.4576, -0.0317, +0.2312, +0.7176, +0.2603, -0.1864, -0.3297, -0.3581, +0.3024, +0.4191, +0.1382, -0.4671, -0.1097, +0.3002, +0.1556, +0.3214, +0.0859, +0.2674, -0.0762, +0.1793, +0.8109, +0.5113, +0.0960, +0.2222, +0.2567, -0.0165, +0.8895, -0.0689, -0.1649, +0.5046, +0.1555, +0.2201, -0.2468, -0.5657, -0.5523, -0.7054, -0.2129],
[ +0.0779, -0.1795, -0.3084, +0.0991, +0.0959, -0.0223, +0.3783, +0.3527, -0.2872, +0.3394, +0.0425, -0.0484, -0.2041, +0.9751, -0.2537, +0.0812, +0.2257, +0.4729, +0.4647, +0.4171, +0.0146, -0.1489, +0.5499, +0.4513, -0.2661, -0.8428, +0.3146, -0.1790, +0.0097, -0.1133, +0.0693, +0.3234, +0.0583, -0.6285, -0.7520, -0.2485, -0.5776, +0.6696, -0.2599, -0.0951, -0.2328, -0.5490, +0.5175, +0.0767, -0.3109, -0.2104, +0.1518, -0.5617, +0.0181, +0.2775, +0.0589, +0.3021, -0.8439, -0.0653, -0.4131, -0.4757, +0.6912, -0.0174, -0.3354, +0.5238, -0.2113, +0.0943, -0.1804, +0.0211, +0.5478, +0.5479, +0.3961, +0.0754, +0.0795, -0.2051, -0.1059, -0.2414, +0.0145, +0.6187, +0.1991, +0.1538, -0.5956, -0.0687, -0.1066, +0.5816, +0.3722, -0.3560, +0.4422, +0.4901, +0.5202, -0.1284, +0.6292, +0.8110, +0.5204, -0.2698, -0.1241, -0.0359, -0.0064, -0.3268, +0.7780, -0.3028, +0.1004, -0.0382, -0.4620, +0.2837, -0.8406, -0.2417, +0.2056, +0.0777, -0.2286, +0.0642, +0.5493, -0.8877, -0.1941, +0.3304, +0.4645, -0.4799, -0.2487, +0.2221, +0.7077, +0.2539, -0.1791, +0.2926, +0.1322, +0.0905, +0.1544, -0.2086, +0.3299, -0.0308, -0.0567, +0.1242, -0.0968, +0.4553],
[ -0.2603, -0.4800, +0.0541, -0.8000, -0.6535, -0.8949, -0.3607, -0.0667, -0.7336, -0.3965, +0.3150, +0.1505, -0.3550, -0.1260, +0.3011, -0.0821, -0.3796, -0.1918, -0.3090, +0.0550, +0.1061, -0.3667, -0.8571, -0.4193, -0.4680, -0.3205, +0.2565, -0.3090, -0.2638, +0.1026, -0.1909, -0.5068, +0.0748, -0.4648, +0.0748, -0.2874, +0.2573, -0.1646, -0.1574, +0.1782, -0.2502, +0.1568, -0.1522, -0.5577, +0.5309, +0.1850, -0.1607, +0.2624, +0.0171, +0.2342, -0.8137, +0.2716, -0.1085, -0.4303, -0.5537, -0.0020, -0.0393, -0.3333, +0.2081, -0.0905, -0.6573, +0.1222, -0.4209, -0.3416, -0.2223, +0.5376, -0.0664, +0.2956, +0.4846, +0.5470, +0.3633, -0.2415, -0.6977, -0.4417, -0.1011, -0.4229, -0.1614, -0.0722, -0.4239, -0.2685, +0.4363, +0.1485, -0.0346, -0.1507, +0.0344, -0.0586, -0.1486, +0.1647, -0.0353, +0.3965, +0.1495, -0.1808, -0.3812, -0.3466, -0.6642, -0.1044, -0.6627, -0.3414, -0.3478, -0.0244, -0.0663, -0.2007, -0.3840, -0.6573, -0.4302, +0.0623, +0.0473, -0.1558, -0.5837, +0.1068, -0.1332, -0.0385, -0.0638, -0.7497, -0.1423, -0.3235, -0.2541, -0.2405, +0.3238, -0.1456, +0.2076, +0.1714, +0.0112, +0.3124, +0.0782, +0.1887, +0.3277, +0.1156],
[ -1.0948, -0.2236, +0.1540, -0.6062, -0.2097, -0.2825, -0.4756, +0.3731, -0.5436, -0.3209, -0.3609, -0.1703, -0.6188, +0.0140, -0.0252, +0.5627, +0.0186, +0.1253, -0.0046, +0.0767, -0.2195, +0.3782, -0.1052, -0.1369, +0.3583, -0.5566, +0.6542, -0.3200, +0.2563, -0.1301, +0.0185, -0.8119, +0.5848, +0.4946, -0.0112, +0.1033, +0.1308, -0.1700, +0.1149, +0.3101, -0.3001, +0.2433, +0.2101, +0.1298, -0.1548, +0.1310, -0.2388, +0.3923, +0.9332, +0.5030, -1.0263, -0.1072, +0.1241, -0.0134, -0.0806, -0.3525, +0.5211, -0.0752, +0.0334, +0.2871, -0.4669, -0.2720, -0.0067, +0.1326, -0.4609, -0.0674, -0.6579, -0.2538, +0.2333, +0.4456, +0.5642, -0.1694, -0.3706, +0.5684, -0.7867, -0.4995, +0.3289, -0.6711, -0.1191, -0.8581, +0.3775, +0.8927, +0.5052, -0.0896, +0.0121, +0.6358, +0.1183, +0.5200, +0.7512, +0.0846, -0.1086, -0.0426, -0.0155, +0.6603, +0.0812, +0.4987, +0.0256, +0.0992, +0.2730, -0.0697, +0.2773, -0.7570, -0.7726, -0.3871, -0.3158, -0.3692, -0.7297, -0.0744, -0.5920, +0.6132, -0.0072, +0.1400, -0.1782, -0.0227, +0.1123, -0.6036, -0.6343, +0.5520, +0.3165, -0.4080, -0.0338, -0.1839, -0.0071, +0.3603, -0.3050, +0.4097, -0.5939, -0.1245],
[ -0.3346, -0.2795, +0.2751, +0.2150, +0.4031, +0.5422, +0.3587, +0.5206, -0.6544, +0.1672, -1.0438, -0.3010, +0.6246, +1.1339, -0.6914, -0.1198, +0.0050, -0.8139, -0.1150, +0.9000, -1.1849, +1.0507, -0.2149, -0.3482, -0.7118, +0.3377, +0.2528, +0.2764, +0.2596, -0.4997, -0.8768, +0.4370, -0.0810, +0.1831, -0.0584, +0.0562, +0.4426, -0.4548, -0.6110, -0.3985, -0.0168, -0.5126, +0.5279, -0.4445, +0.0281, +0.3755, -0.0337, -0.7288, -0.4249, +0.6200, -0.1673, -0.4617, +0.0127, -0.1385, +0.6653, -0.1985, +0.4186, -0.5372, -0.5204, +0.8371, +0.2907, -0.7418, +0.0020, +0.4483, +0.1869, +0.6499, +0.1529, +0.4740, +0.6753, +0.6005, +0.7086, -0.3005, +0.5440, +0.3387, +0.2046, +0.4181, -0.8759, -0.7487, -0.1262, -0.0293, +0.8712, +0.0119, -0.7947, -1.2465, -0.0061, -0.0503, -0.2992, +0.5275, -0.3151, +0.1889, -1.5430, +0.5531, +0.2559, -0.2591, -0.2807, -0.1324, -0.7027, -0.4375, +0.1984, -0.3944, -0.0467, -0.3111, -0.6493, -0.2939, -0.0617, +0.2605, -0.9876, -0.0857, -0.6928, +0.7228, -1.2047, +0.3026, -0.7448, +0.4988, -0.3507, -0.7106, -0.7583, +0.3245, +0.2599, -1.4422, +0.4198, -0.6388, -1.3088, +0.9680, -0.0616, -0.4120, -0.3508, +0.1672],
[ -0.5261, +0.4924, +0.1685, -0.2603, +0.3052, +0.3751, -0.8492, -0.1073, +0.1541, +0.1367, +0.1658, +0.0405, -0.0968, -0.0074, -0.3535, -0.4133, +0.0255, -0.6547, -0.0838, +0.2996, +0.1273, -0.1657, +0.0394, +0.4691, +0.0353, -0.2699, +0.1696, +0.5037, +0.0277, -0.1267, -0.3741, +0.2501, +0.1612, -0.3687, -0.0763, -0.2902, +0.3456, +0.1048, +0.0277, +0.1918, -0.6208, +0.1135, -0.1049, -0.0283, +0.0202, +0.0171, +0.0822, -0.2369, +0.1969, +0.5290, -0.0731, +0.4711, -0.2303, -0.0833, -0.3602, -0.1438, -0.0070, -0.5158, -0.3721, +0.0134, +0.4545, -0.0207, +0.2113, -0.0665, -0.2343, +0.2490, -0.2058, +0.1182, +0.0765, +0.3709, +0.3816, -0.1490, -0.1526, -0.0174, +0.6291, +0.4946, -0.3356, -0.0425, -0.0716, -0.6482, +0.4502, +0.0332, -0.2189, -0.6447, +0.1329, +0.4471, -0.0323, -0.0798, -0.1390, +0.1446, -0.2377, +0.4462, -0.2870, -0.2893, -0.0998, +0.1104, -0.1755, +0.2786, +0.3976, -0.6894, -0.4004, -0.3018, -0.2645, +0.0620, +0.0661, +0.1230, -0.3739, +0.0862, -0.2077, -0.1822, +0.0729, +0.0871, -0.2029, +0.0181, +0.3299, -0.5234, +0.0010, +0.1996, +0.0403, -0.6255, +0.1214, +0.0402, -0.3186, +0.1235, +0.0944, +0.2717, +0.1232, -0.3457],
[ -0.1970, -0.3969, -0.2225, +0.1993, +0.1553, -0.0254, -0.1890, -0.3057, +0.4549, -0.0170, -0.5648, -0.4915, -0.0502, -0.2149, +0.2144, -0.5744, -0.1044, -0.4353, +0.0233, -0.0785, -0.3143, -0.3626, +0.0585, -0.3341, -0.0893, -0.4231, -0.0378, +0.0274, -0.4611, +0.0728, -0.1463, -0.2042, +0.0172, -0.4561, -0.0206, -0.1719, -0.0000, -0.4023, +0.0364, -0.1958, -0.5589, -0.0532, +0.0099, -0.0872, +0.0206, -0.0009, -0.3550, -0.3123, -0.0938, -0.2254, -0.1686, -0.2615, -0.2844, +0.0994, +0.0554, +0.1692, -0.2632, -0.1443, -0.1879, -0.1459, -0.6597, -0.3367, -0.1862, -0.3134, +0.1299, -0.0695, +0.2293, +0.0609, +0.2819, -0.1567, -0.2090, -0.1359, +0.3011, -0.2784, -0.2469, +0.0022, -0.1715, -0.1446, -0.2693, -0.3637, -0.1232, -0.2147, -0.2098, +0.0446, +0.1409, -0.0058, +0.0383, -0.1855, -0.1377, +0.0460, -0.2215, +0.3805, -0.2653, -0.1465, -0.4812, -0.0015, +0.0714, +0.0472, -0.2914, -0.2133, -0.1082, -0.8207, +0.1838, -0.1654, -0.6285, -0.5248, +0.0549, -0.1583, -0.5096, +0.1266, -0.5755, -0.3374, +0.0946, -0.3824, -0.4274, +0.1813, -0.3312, +0.1190, -0.2241, +0.0402, +0.2119, +0.1831, -0.0826, -0.1367, -0.2986, -0.4726, -0.5516, -0.0995],
[ -0.5413, +0.2330, +0.8049, -0.1323, +0.1069, +0.8225, +0.5138, +0.5381, +0.4208, +0.0392, -0.8431, +0.4248, -0.0927, +0.0971, -0.1803, -0.9058, +0.8480, -0.3816, -0.6984, -0.3827, -0.2599, +0.2374, -0.1889, -0.3184, -0.3037, +0.2556, -0.3310, -0.0797, -0.0166, -0.8056, +0.5743, +0.3340, -0.3261, -1.1856, -0.1586, -0.2816, -0.4614, -0.8387, -0.8821, -0.2603, -0.3087, -0.4192, +0.0168, -0.2696, +0.2092, -0.2967, -0.3088, +0.1593, -0.3350, +0.7112, +0.6204, +0.1440, -0.1400, +0.4595, +0.6284, -0.4182, +0.4677, +0.4245, -0.2426, +0.4360, +0.5265, +0.4846, +1.0185, -0.5593, +0.9728, +0.4769, +0.7221, +0.6885, -0.0294, +0.2469, +0.0124, +0.5220, -0.4949, -0.1693, +0.6676, +0.7299, -0.0920, +0.5961, -0.4980, -0.3700, +0.4610, -0.0052, -1.1549, -0.2259, -0.7090, +0.0568, +0.5237, -0.4150, +0.3867, -0.0865, -0.0347, +0.2796, -0.3372, +0.4407, +0.4653, +0.4029, +0.0542, -0.4820, +0.5448, +0.0841, +0.3830, -0.5634, +0.3101, -0.3656, +0.5915, +0.5094, +0.0265, +0.3061, -0.1867, +0.4472, +0.0831, -1.4864, +0.6205, -0.7317, +0.0345, +0.0241, -0.4189, +0.2699, -0.0454, +0.1761, +0.1418, +1.0411, -0.1500, -0.5850, +0.4274, -0.2819, -0.0049, -0.0539],
[ +0.3625, +0.0194, -0.3223, -0.1543, -0.3422, +0.1361, -0.1979, +0.1716, +0.1964, +0.1080, -0.2562, +0.5515, -0.6231, +0.0645, -0.2820, -0.4138, -0.3513, -0.1298, +0.1236, -0.1571, +0.0996, -0.4628, -0.0855, +0.6111, +0.2735, +0.1079, +0.0759, -0.8790, +0.2145, -0.6007, -0.0575, +0.4727, -0.0139, -0.2520, -0.1913, -0.1010, +0.0459, +0.2930, -0.5473, -0.6486, +0.0525, -0.9643, +0.0756, -0.0343, -0.3489, +0.2362, +0.5423, -0.2968, -0.0831, -0.4753, -0.2939, +0.1316, -0.6055, +0.3439, -0.4793, -0.9334, -0.0404, -0.0067, -0.1639, -0.2048, +0.2024, +0.0257, -0.7722, +0.3862, +0.3280, -1.2964, +0.3508, -0.4320, -0.0618, +0.0669, -0.1487, +0.0590, -0.0657, -0.5083, -0.3131, -0.3795, -0.3027, -0.7377, -0.2656, -0.1819, +0.0315, -0.1914, -0.3061, -0.0285, +0.1491, -0.3607, -0.6081, +0.3564, +0.2935, -0.1484, +0.1152, -0.5023, +0.1752, -1.5863, +0.1823, -0.3487, +0.3613, +0.0175, -0.2217, -0.1352, -0.5851, +0.1753, -0.0871, +0.5474, +0.3244, -0.8566, -0.3348, -0.0279, +0.5935, +0.2750, +0.0797, +0.1091, -0.8979, +0.7681, +0.3679, +0.3083, +0.2425, +0.1221, +0.3024, +0.4512, +0.0880, -0.0056, -0.1940, +0.3921, +0.4914, -0.7178, -0.2134, +0.1143],
[ +0.0679, -0.0794, -0.3814, +0.2536, -0.1512, +0.1385, -0.1787, -0.1347, -0.1905, +0.0860, +0.1867, -0.0860, +0.0923, +0.1577, +0.1129, +0.2066, +0.2144, +0.0983, +0.1848, +0.3214, -0.3866, +0.1045, -0.0303, -0.2351, -0.1582, -0.0153, -0.1058, +0.0740, -0.0575, -0.1356, +0.0975, +0.2816, +0.0862, -0.2179, -0.4657, -0.2575, -0.1307, -0.1683, -0.0066, +0.0145, +0.2131, -0.0987, +0.2698, +0.1188, +0.0539, +0.3335, -0.0699, -0.1512, -0.0397, +0.0569, +0.0859, +0.2909, +0.0149, -0.0338, +0.3416, +0.0462, -0.0262, +0.3987, -0.1117, +0.0869, +0.2025, +0.0820, +0.0110, -0.0663, -0.0989, +0.0121, +0.2080, +0.2500, -0.2012, -0.0425, -0.3801, +0.2980, -0.1070, -0.2112, -0.2358, -0.0148, +0.0342, +0.1877, -0.0190, -0.3003, -0.0384, +0.3230, +0.0058, +0.1883, +0.1429, -0.0525, -0.0369, +0.1965, +0.4171, -0.2498, +0.3534, +0.1377, -0.1843, -0.0786, -0.0334, -0.2252, -0.2525, -0.4377, +0.0970, -0.0632, -0.1115, +0.1151, -0.2193, +0.4269, +0.0589, +0.2567, -0.0083, -0.1317, -0.0140, -0.2162, +0.1460, +0.2144, -0.2364, +0.2052, +0.1361, +0.3009, -0.0415, +0.0753, +0.1605, -0.0008, +0.1161, -0.0075, +0.1132, -0.1271, +0.5005, +0.0962, +0.0963, +0.2632],
[ -0.0499, -0.1868, +0.0577, +0.1447, +0.1636, -0.3556, -0.1492, +0.0388, -0.1583, -0.0774, +0.0437, +0.0230, -0.1318, +0.0701, +0.3213, -0.0902, -0.1691, +0.0205, +0.0912, -0.0380, +0.0704, -0.0709, -0.0177, -0.1689, -0.3108, +0.0728, -0.2808, -0.0876, -0.0702, -0.4691, +0.3010, +0.2589, -0.1658, -0.3264, +0.1423, +0.0444, -0.0579, +0.0883, -0.1900, -0.3669, +0.0899, +0.0842, +0.1387, +0.0023, +0.0807, -0.1238, +0.1961, +0.0881, -0.0594, -0.1222, -0.2213, +0.2254, +0.0348, -0.1841, -0.1994, -0.4183, +0.0770, -0.2080, -0.0388, +0.0821, +0.0289, +0.0999, -0.0389, +0.0711, -0.2250, -0.0025, -0.2014, +0.2883, +0.3065, -0.1356, -0.0597, -0.1037, -0.0451, -0.1849, +0.0913, -0.0457, +0.0217, -0.0981, +0.0654, -0.1176, +0.1646, +0.2142, -0.3388, -0.5200, -0.2313, -0.1905, +0.0708, -0.0961, -0.1217, -0.1662, -0.1982, +0.1837, -0.0128, +0.0935, +0.0200, +0.1873, -0.2688, +0.2296, +0.2719, -0.2736, +0.2598, +0.1866, +0.1070, -0.0368, -0.0790, +0.3079, -0.1966, +0.0417, -0.2708, +0.0273, +0.3073, +0.2085, -0.1423, -0.1677, -0.2092, -0.3405, +0.1060, -0.3134, -0.1067, +0.0272, +0.1868, -0.2262, +0.2388, -0.4858, -0.0006, +0.3641, -0.0149, +0.1635],
[ -0.0293, -0.6816, +0.0207, -0.3203, +0.5807, +0.2284, +0.0608, -0.0782, -0.7455, +0.0780, +0.1824, +0.2558, +0.6335, +0.3215, -0.1083, -0.4061, +0.2560, -0.2431, -0.9005, -0.7526, +0.0429, +0.0809, +0.3405, -0.1655, +0.1869, -0.4230, +0.1290, -0.0598, -0.8880, -1.3204, -0.6279, +0.1188, -0.1528, +0.1304, +0.3002, -0.2851, -0.4151, +0.1325, +0.0967, -1.1975, -1.4119, -0.1437, +0.1030, +0.1688, +0.1357, +0.5681, +0.1686, -0.6273, -0.0961, -0.1940, -0.4501, -0.3292, -0.4322, -0.0958, -0.1608, +0.0745, -0.2823, +0.1386, -0.3401, -0.0044, +0.1450, -0.9192, +0.1943, -1.0786, -0.3468, -0.2210, -0.8898, +0.2841, -0.1573, +0.0027, +0.5140, +0.2573, -0.2886, -0.1363, +0.0590, -0.0752, -0.5069, +0.4482, -0.2980, -0.0193, +0.0242, -0.1357, +0.3524, -0.0679, -0.4083, -0.1631, -0.0261, +0.0079, +0.4069, +0.0506, +0.0312, +0.1185, +0.3524, -0.1431, -1.3855, +0.2428, -0.4439, +0.2224, -0.6006, +0.1477, -0.1597, -0.4273, -0.1280, +0.4005, +0.2949, +0.1104, -0.0679, +0.3744, +0.6098, -0.5700, +0.1008, +0.2341, -0.4750, -0.3084, -0.2798, -0.7803, +0.6083, -0.0650, +0.0205, -0.1667, +0.0401, -0.1926, +0.4924, +0.1119, -0.8171, +0.2006, +0.3861, -1.1334],
[ +0.3379, -0.0630, -0.3660, +0.3327, +0.0593, -0.1086, +0.5011, +0.1324, -0.2487, -0.0698, +0.1031, -0.1188, +0.2941, +0.0543, -0.0504, -0.1540, -0.0798, +0.2290, +0.2369, -0.0698, +0.1134, +0.4617, +0.1530, -0.3301, -0.2881, -0.2488, +0.0245, -0.0285, -0.2306, -0.1149, -0.0003, -0.0923, -0.1315, +0.0210, -0.1870, +0.0622, -0.0506, -0.0135, -0.1995, -0.0287, +0.0711, -0.0130, +0.3577, -0.1441, -0.1204, -0.3320, -0.2458, -0.0879, +0.0139, +0.2201, -0.3011, +0.0393, +0.2918, -0.0472, -0.1514, -0.1190, -0.0056, +0.2567, -0.3284, -0.5337, -0.0050, -0.1086, -0.1834, -0.3311, -0.1851, +0.1848, -0.0175, -0.1277, -0.1361, +0.1587, +0.0424, +0.0936, +0.1683, -0.0294, +0.1407, -0.0313, -0.0279, +0.2524, +0.1912, +0.1002, +0.1337, +0.0550, +0.1725, +0.0323, +0.1961, +0.2280, +0.4421, +0.1152, +0.0211, +0.1519, -0.0487, -0.0903, +0.1088, -0.1067, -0.1932, +0.0741, -0.1907, -0.1498, +0.3873, -0.1806, -0.1683, +0.1372, +0.0304, +0.0863, -0.1042, -0.0114, +0.1071, +0.1654, +0.2195, -0.1274, -0.2964, +0.1572, +0.1514, +0.0736, +0.1129, +0.1630, -0.0438, +0.2270, -0.0895, +0.2149, +0.2307, +0.0664, +0.0300, +0.3303, +0.0999, +0.3439, +0.0904, +0.1683],
[ +0.0340, -0.0989, -0.0451, +0.2294, +0.2241, +0.2625, -0.1814, +0.0073, -0.3025, +0.3027, -0.3313, -0.0211, +0.0333, +0.1126, -0.0768, -0.1360, -0.3812, +0.2599, -0.2655, -0.0163, +0.2248, -0.1354, +0.1735, -0.1578, -0.0827, +0.1191, +0.1209, -0.2733, +0.2359, -0.2004, -0.0624, +0.2381, -0.0092, -0.0115, +0.0134, -0.2366, +0.2267, -0.3574, -0.0541, -0.3561, -0.0686, -0.0024, -0.0964, -0.0168, +0.0758, +0.1287, +0.0970, +0.2117, +0.4078, +0.2125, -0.1938, +0.0866, -0.2325, -0.0116, -0.2797, -0.2403, +0.1878, -0.2757, -0.2458, +0.2984, -0.0047, +0.1370, -0.3392, -0.1224, +0.2413, +0.1075, +0.3686, +0.2316, -0.0368, +0.0658, +0.0282, +0.2231, -0.1776, +0.0984, +0.2372, +0.2452, +0.0692, -0.0771, +0.2522, +0.2017, +0.1455, +0.2602, +0.1297, -0.0145, -0.1484, +0.0469, -0.0616, +0.2906, +0.1185, +0.2783, +0.0614, +0.0493, -0.2796, +0.1048, -0.2029, +0.1820, -0.2846, +0.0042, +0.0699, +0.2208, +0.1126, -0.0028, -0.0612, -0.0730, -0.0883, +0.1355, -0.2635, -0.4806, +0.1522, -0.5489, -0.1904, -0.2650, +0.1945, -0.0204, -0.0391, +0.2104, +0.2261, +0.2982, -0.5277, +0.0563, -0.0652, -0.0232, +0.0058, +0.0107, +0.1389, -0.1388, +0.3945, +0.1338]
])

weights_dense1_b = np.array([ +0.0484, -0.2398, -0.1357, +0.0298, -0.3778, -0.2392, -0.0211, -0.1728, +0.0154, -0.1052, -0.0235, -0.0825, -0.0137, -0.1951, +0.1408, -0.2835, -0.4597, -0.2002, -0.1659, -0.2736, -0.0233, -0.2472, -0.0697, -0.1892, -0.1340, -0.0051, -0.1712, -0.1986, -0.1902, -0.1213, -0.1363, -0.2731, -0.0609, +0.0803, -0.1623, +0.0661, -0.0660, -0.1206, -0.2835, -0.1281, -0.1008, -0.2377, -0.1436, -0.1027, -0.1816, -0.1699, -0.2476, -0.0886, -0.1582, -0.1714, -0.1558, -0.2484, -0.1255, -0.1657, -0.0830, -0.0800, -0.1293, -0.0594, +0.0174, +0.1097, -0.1769, -0.1648, -0.1995, -0.1082, -0.1761, +0.0342, -0.1445, -0.0106, -0.2021, -0.1352, -0.2769, -0.1503, +0.1171, -0.2275, -0.1514, -0.1064, -0.1877, +0.0308, -0.1081, -0.0229, -0.1273, -0.0516, -0.0789, -0.1148, -0.0308, -0.1946, -0.3185, -0.1215, -0.0605, -0.1876, -0.1192, -0.1545, -0.0148, -0.0218, -0.3640, -0.2230, +0.1549, +0.0196, -0.2555, -0.1814, -0.3217, -0.1741, +0.0117, -0.1752, -0.2445, -0.0863, +0.0041, +0.0058, -0.0948, -0.1010, -0.0595, +0.0182, -0.0761, -0.0141, -0.1886, -0.0474, +0.0057, -0.1247, -0.3390, +0.0672, -0.0612, -0.1059, +0.0219, -0.1802, -0.1265, -0.1287, +0.0565, -0.0502])

weights_dense2_w = np.array([
[ +0.4072, -0.1577, +0.0300, -0.0725, +0.6609, -0.5568, +0.0820, -0.2073, +0.3434, +0.0637, +0.0899, -0.1563, +0.1371, +0.7268, -0.4818, +0.0706, -0.1386, +0.4026, +0.2577, -0.4374, +0.4362, +0.2120, +0.0860, +0.0373, -0.5472, -0.4427, +0.0769, +0.3067, +0.3401, -0.0008, -0.7384, +0.0566, -0.0583, -0.3481, -0.2953, -0.1032, -0.7956, -0.6262, -0.0733, -0.6908, -0.4126, -0.2014, +0.6791, -0.5321, +0.5106, -0.1055, +0.0604, -0.5233, -0.8984, -0.4227, -1.3192, +0.3693, +0.2789, -0.2774, +0.0132, -0.1824, -0.0690, -1.6134, -0.2901, -0.1739, -0.5780, -0.3432, +0.0980, -0.3106],
[ -0.3167, -0.2520, +0.1710, +0.1912, +0.0268, -0.1353, +0.0637, -0.3158, +0.3448, +0.4247, -0.2795, -0.6464, -0.5002, +0.1116, -0.0497, -0.7619, -0.1402, +0.0142, -0.0314, -0.0418, -0.6087, +0.1742, -0.2843, -0.3738, +0.0595, +0.2382, +0.7762, +0.4531, -0.8817, -0.0971, -0.4319, +0.0168, -0.7739, -0.6792, +0.3594, -0.2188, -0.7423, +0.2473, -0.2793, +0.0149, -0.2970, -0.0695, +0.6082, -0.5475, -0.5990, +0.6079, +0.2662, +0.2195, -0.5335, -0.1782, -0.1657, +0.0951, -0.1763, -0.3554, -0.1032, +0.3347, -0.2818, -0.6144, -0.2387, -0.3771, -0.0378, +0.0776, -1.4711, -0.1353],
[ -0.2935, -0.8083, -0.1306, +0.1952, -0.1178, -0.4799, +0.0777, -0.4029, -0.5699, -0.1755, -0.0172, +0.1791, -0.0261, -0.2480, +0.0181, -1.0284, -0.2705, +0.4318, +0.1634, -0.2889, -0.0075, -0.1050, +0.0859, +0.0544, -1.0494, +0.0273, -0.1991, -0.2565, -0.3891, -0.1883, -0.4818, -0.2458, +0.2761, +0.1295, -0.2284, -0.0114, +0.2609, -0.1632, -0.0384, +0.0558, -0.2330, -0.3149, -0.1879, -0.0787, +0.2492, -0.1629, +0.3027, +0.5257, -0.4112, -0.2063, -0.0745, +0.0864, -0.1151, -0.3392, +0.2214, +0.2084, -0.1933, +0.0103, -0.0245, +0.0280, +0.0170, -0.1814, +0.0239, -0.6701],
[ +0.0470, -0.1471, -0.3533, -0.2277, +0.2617, -0.2955, -0.2491, -0.1937, +0.2634, +0.0681, -0.2869, -0.1950, +0.1615, +0.2557, -0.0025, +0.2327, -1.0104, +0.3358, +0.2386, -0.6202, -0.0829, +0.3342, +0.0617, -0.0119, -0.6297, -0.2430, +0.2088, +0.0102, +0.3480, -0.0119, -0.3172, +0.1668, -0.2217, +0.1130, -0.0817, +0.0391, -0.0480, -0.1680, -0.1306, -0.4677, -0.1638, -0.3569, -0.1594, +0.2110, +0.3875, -0.1732, -0.0210, -0.3070, -0.7983, +0.2381, -0.0294, -0.2019, +0.1801, +0.2116, +0.2506, -0.0342, -0.7177, -0.6430, +0.3333, -0.7577, -0.3507, -1.0563, -0.4578, +0.0739],
[ +0.0584, +0.2110, +0.2883, +0.4496, -1.4306, -0.3233, +0.1243, -0.5887, +0.1677, -0.1064, -0.3807, -0.0439, -0.8551, -1.2286, +0.2521, -0.0060, +0.6236, -0.1993, +0.3985, -0.2662, -0.0002, +0.0486, -0.2869, -0.6390, -0.1125, -1.3003, +0.1867, -0.3180, -0.7481, +0.1080, +0.3788, -0.3003, -0.1799, -0.4549, -0.0974, -0.0827, +0.3762, +0.2356, -0.2579, +0.4377, -0.1295, -0.3391, -0.7046, -0.1904, -0.1341, -0.0194, -0.2193, -0.3140, -0.1927, -0.3742, +0.2955, +0.1099, -0.5704, +0.0968, -0.0678, -0.1847, -0.0211, -0.3002, -0.4862, +0.4810, -0.0444, +0.4728, +0.1298, -0.0902],
[ +0.0349, +0.9685, -1.9391, -0.3447, -0.1261, -0.3633, -0.0598, -0.6471, -0.8648, -0.7718, -0.4766, -0.8915, -0.5728, -0.5278, +0.5933, -0.3178, +0.0116, +0.3050, +0.3750, -1.1527, -0.0571, -0.2033, +0.4198, +0.2105, -0.7927, -0.6716, -1.0696, -0.7200, -0.5883, -0.6538, -0.4865, -0.8737, +0.0426, +0.2175, -0.2165, -0.0444, -0.1326, -0.0308, -0.1097, +0.0105, -0.1852, -0.3861, -0.2117, -0.5265, +0.0367, -0.0218, +0.2472, -0.2354, -1.1444, -0.3036, -1.6033, +0.1154, -0.3195, +0.3943, -0.8171, -0.0495, -0.0950, -0.3764, -0.1523, -0.8749, +0.2594, +0.2451, -0.1734, -0.0927],
[ +0.4523, +0.0513, -0.0013, +0.1556, +0.2430, -1.2187, -0.3108, -0.7597, -0.7845, -0.6297, -0.0224, +0.3207, +0.2222, -0.2645, +0.1510, +0.1624, -0.0568, -0.8426, -0.3564, +0.0187, +0.2791, +0.0447, -0.1822, -0.2627, +0.0078, -0.9392, +0.0805, +0.0339, +0.3228, -0.0153, -1.4823, -0.0994, +0.2658, -0.0138, -0.1071, +0.2001, -0.3299, -0.5982, -0.2859, -0.1269, +0.0496, -0.0371, +0.3491, -0.3822, +0.1167, -0.2964, -0.4635, +0.0549, -0.6313, -0.4994, -0.2447, +0.0584, +0.2663, -0.0663, -0.1714, -0.1748, -0.5364, -0.3646, +0.1584, +0.0349, +0.1420, -0.6877, -0.3539, +0.2209],
[ -1.2158, -0.7080, +0.1037, -0.1613, +0.0811, -0.9051, -0.4186, -0.6072, -0.6212, +0.0362, -0.3524, +0.2563, -0.7313, -0.2856, +0.0658, -0.1271, -0.1249, -0.6959, -0.4723, +0.4467, -0.1244, -0.0056, +0.5042, -0.5181, +0.0475, +0.2931, +0.3883, -0.2017, -0.0388, +0.0403, +0.1562, -0.9404, +0.0620, -0.5598, -0.5657, +0.0578, +0.0086, -0.5689, -0.9304, +0.3161, -0.1303, -0.4087, -0.5053, -0.1267, +0.0123, -0.6312, -0.6991, -0.0800, -0.8634, +0.2347, +0.1449, +0.3955, +0.4396, -0.0684, +0.2644, -0.7668, -0.1511, +0.0324, +0.0823, -0.3579, +0.0592, +0.0904, +0.2380, +0.0873],
[ -0.6992, +0.1539, +0.4253, -0.2513, +0.1882, +0.6842, -0.6867, -0.2942, -0.3434, +0.2486, -0.4180, -0.6950, +0.2628, +0.7324, -0.2667, -0.1330, -1.3123, +0.0990, -0.1324, -0.0016, -0.0310, +0.0778, -0.1325, +0.2886, -0.2052, +0.0094, +0.1791, +0.1105, +0.4348, -0.6778, -0.3301, +0.1438, +0.1093, +0.0140, -0.1957, -0.1226, +0.0676, +0.9343, -0.1993, +0.1818, -0.1565, +0.3443, -0.1359, -0.5234, +0.2591, +0.3769, +0.4966, -0.6424, -0.0288, +0.0357, -0.3554, -0.1676, -0.2453, -0.4502, -0.3745, -0.1692, -0.2449, -0.2132, -0.0001, +0.0087, +0.3669, +0.3835, +0.0003, +0.6565],
[ +0.2329, -0.0695, +0.4082, -0.0004, +0.0059, +0.1418, +0.1081, -0.3141, +0.2218, -0.0538, -0.0670, +0.0018, -0.1211, -0.0491, -0.3059, -0.4239, -0.1665, +0.0700, +0.4327, -0.5063, +0.3045, +0.7774, +0.4464, +0.2276, -0.3467, +0.5197, +0.1607, -0.1339, -0.1663, +0.0881, +0.0232, -0.3337, +0.0157, -1.1305, -0.1427, -0.7464, -0.3650, +0.2386, +0.2734, +0.5966, -0.4067, +0.3709, +0.2986, -0.3682, -0.1436, +0.3259, +0.3393, -1.2748, -0.5180, +0.1099, -0.0843, +0.0421, +0.1176, +0.0935, +0.3649, +0.1282, +0.2074, -0.4244, -0.3379, -0.8103, -0.1238, -0.6615, -0.5262, -0.9899],
[ +0.2683, +0.0401, -0.2063, -0.0863, -1.1390, -0.1614, +0.4551, -0.2386, -0.9135, -0.1037, +0.3364, +0.0943, +0.3665, -0.2748, +0.2592, -0.0339, +0.4767, -0.1381, -0.2326, +0.0600, +0.1522, -0.3524, +0.4203, -0.4977, -0.2533, -0.4959, +0.1211, -0.1722, +0.0681, -0.2369, +0.2398, +0.2182, +0.0582, +0.4106, -0.2708, +0.1474, +0.3402, +0.3310, +0.1319, -0.2479, +0.1749, +0.3886, -0.1866, +0.0482, +0.2373, -0.4678, -0.1560, +0.4025, -0.3261, +0.6000, -1.2795, +0.2571, -0.0926, -0.2927, +0.2793, -0.4958, +0.0614, -0.0140, -0.1622, -0.4095, -0.1560, -0.2754, +0.1172, -0.1319],
[ -0.5295, -0.0999, +0.0220, +0.3271, +0.2059, -0.4296, +0.3921, -0.0843, -0.4874, +0.3199, +0.4602, -0.8274, +0.2366, +0.6108, -0.3201, +0.1853, +0.3175, +0.0078, -0.4971, +0.7472, +0.1544, -0.3018, +0.2934, -0.2034, +0.3348, +0.3705, -1.3035, +0.2084, +0.4699, +0.0053, -0.3233, -0.8634, -0.4203, -0.6225, -0.2153, +0.5059, +0.1571, -0.7581, -0.9790, +0.1196, -0.6516, +0.1740, +0.3164, -0.0439, -0.7366, -0.0850, +0.4464, -0.9298, +0.3098, +0.6134, +0.0513, -0.1314, -0.7751, -0.4632, +0.2998, -0.2841, -0.1156, +0.2272, -0.6840, +0.2023, +0.2771, +0.0181, +0.3241, +0.0077],
[ -0.0280, -1.3387, -0.3547, -0.0743, +0.1483, -0.0627, -0.3067, -0.3430, +0.0588, +0.0807, +0.4038, +0.4257, +0.4200, -0.1636, -0.6085, +0.0772, +0.3777, -0.0100, -0.5085, -0.4027, +0.1783, +0.3648, +0.2458, -0.6546, -0.3100, -0.0142, +0.5146, +0.5179, +0.3174, -0.0085, -0.5655, +0.6930, -0.0170, -0.0840, -0.4820, +0.3951, +0.2091, -0.1006, -0.1043, -0.1592, +0.5631, +0.0762, +0.0353, +0.3549, -0.5710, +0.6521, -0.5372, +0.5439, -0.6006, -0.3861, -0.9696, +0.3836, +0.0144, -0.0445, +0.2625, +0.0893, +0.3533, -0.0816, +0.3946, -0.1645, -1.0470, +0.4605, +0.2646, -0.0709],
[ +0.1597, -0.1930, +0.1695, +0.0883, +0.3863, -0.0690, -0.3626, -0.0751, -0.2489, -0.2651, +0.3078, -0.0279, +0.0915, -0.3568, +0.0135, +0.0301, +0.1845, +0.0936, +0.1046, -1.0295, -0.4317, +0.0053, +0.3181, +0.1241, +0.1828, -0.1518, +0.3664, -0.0194, -0.0056, -0.9545, -0.3588, +0.5326, -0.9760, -0.2063, +0.4710, -0.7108, -0.0157, -1.2469, -0.3011, -0.2258, -0.1896, +0.0305, +0.1823, +0.2524, +0.0734, -0.0195, +0.2741, +0.0458, -0.0258, -0.1458, -0.0499, +0.2720, +0.2632, -0.1566, -0.3169, +0.4742, -0.1019, -0.1814, +0.3763, +0.2875, +0.4905, -0.4019, +0.2122, -0.9641],
[ +0.3189, +0.1388, -0.3550, -0.3842, +0.0898, +0.0547, -0.7110, -0.1182, +0.0259, +0.0704, +0.1494, -0.1821, -0.1159, +0.0213, +0.2096, -0.4418, -0.6512, +0.1241, +0.0305, -0.1008, +0.0562, +0.0968, +0.0081, +0.1199, +0.1381, -0.2673, -0.2059, -0.0357, +0.3140, +0.2211, -1.0964, +0.1492, +0.1469, -0.5406, -0.0557, +0.3461, -0.0567, +0.2042, +0.1409, -0.1752, -0.5634, -0.7240, -0.0985, +0.4507, -0.0405, +0.1548, -0.0590, +0.2785, +0.0398, -0.0766, +0.3026, -0.3093, -0.0211, +0.3418, -0.0372, +0.1007, -0.1287, -0.1216, +0.1111, +0.0391, -0.4399, -0.1719, -0.7748, +0.0015],
[ -0.8898, +0.1587, -0.1158, -0.2147, +0.1854, +0.0673, -1.6078, +0.3145, +0.1855, +0.0176, -0.6532, +0.1946, -0.2744, -0.2392, +0.0001, -0.5411, -0.3275, -0.6474, -0.3419, +0.0351, -0.2511, +0.2090, -0.1401, -1.2570, -0.3467, -0.1794, -0.0238, -0.3511, +0.0885, +0.2340, -0.2762, +0.2349, -0.0718, -0.1801, -0.5107, +0.1164, +0.2997, -0.1047, +0.1091, +0.1830, -0.0604, -0.5492, +0.0451, +0.5144, -0.1682, -0.2848, -0.3148, -0.0800, -0.6753, +0.8912, -0.3167, +0.1553, -0.1064, +0.4668, -0.1185, +0.0205, +0.2634, -1.4268, -1.4053, +0.1865, -1.1680, -0.5715, -0.1411, -0.0048],
[ -1.1451, -0.8007, -0.7188, +0.2194, +0.0224, -0.3902, -1.0708, +0.1315, -0.4508, -0.0171, -0.1646, -0.8523, +0.0246, -0.2483, +0.2628, -0.0709, +0.1284, -0.0332, +0.2452, +0.6453, +0.0372, +0.0580, -0.4814, -0.0367, -0.6464, -0.1864, -0.0876, -0.3798, -0.1084, -0.2326, +0.3449, -1.0821, +0.3558, -0.2093, -0.1611, +0.0181, -0.1593, -0.7092, -0.5308, +0.3392, -0.2771, -0.8510, -0.0332, +0.1636, -0.1288, -0.1509, -0.0123, -0.3427, -0.2880, -0.9719, -1.0379, -0.2061, -1.2064, +0.0703, +0.0296, -0.5942, +0.1367, +0.2798, -0.9892, +0.2638, +0.6593, +0.3467, +0.2717, -0.2685],
[ -0.2935, -0.2457, -0.1847, -0.1120, +0.2738, -0.1316, -0.1218, +0.1977, +0.2899, -0.2914, -0.9864, +0.4904, -0.1894, -0.0953, +0.0076, -0.0067, -0.6684, -0.0314, +0.0872, +0.4462, +0.2811, -0.1232, -0.3337, -0.7796, -0.7328, +0.0966, -0.1373, +0.4435, +0.1715, +0.1189, -0.3743, +0.3548, -0.0802, -0.5682, -1.3086, -0.0364, -0.2844, -0.3369, +0.3544, -0.0662, -0.1867, -0.3540, -0.2038, -0.4980, +0.3799, -0.1018, -0.9164, +0.3697, -0.0067, -0.5775, -0.1818, +0.0175, -0.1748, +0.4688, -0.5308, -0.4231, +0.1482, -0.5617, -1.2285, +0.3348, +0.2546, +0.3433, -0.0552, -0.4434],
[ -0.5986, -0.0456, -0.0579, +0.0098, +0.5195, +0.2289, -0.0547, +0.0712, +0.3579, +0.0200, -0.3965, +0.3115, -0.3113, -0.2659, +0.2821, -0.0527, -0.1284, -0.5430, -0.6974, +0.0659, -0.4766, -0.1915, -0.1467, -1.0685, -0.5390, +0.4510, +0.3700, +0.1105, -0.1987, -0.0297, +0.0635, +0.2345, +0.1594, -0.0839, -0.1305, -0.1000, +0.2680, +0.1591, -0.5661, +0.1602, -0.0069, -0.1623, -1.4309, -0.1520, -0.0090, -0.3502, -0.6969, -0.0949, +0.0562, -0.0869, -0.2017, +0.0475, +0.5724, +0.1771, -0.0398, -0.7070, -0.1830, -0.0220, -0.1941, -0.9674, +0.0262, -0.1637, -0.0094, +0.4634],
[ -0.0007, -0.1887, +0.2479, +0.0483, +0.2260, -0.1202, -0.2455, -0.5935, -0.0951, +0.2204, +0.2221, +0.3503, +0.0909, -0.2512, +0.0191, -1.0021, -0.2003, +0.6241, +0.2894, -0.0605, -0.4665, -0.2199, -0.1427, -1.2488, -0.1763, +0.3383, +0.4418, +0.2648, -0.9742, +0.2356, +0.1240, +0.1305, -0.4167, +0.0351, +0.3759, -0.2039, +0.0351, -0.6693, -0.8583, +0.0616, +0.2169, -0.4452, -0.4786, -0.0808, +0.0579, -0.1770, +0.1975, -0.3272, -0.0747, -0.3015, -0.0030, -0.3779, -0.1084, +0.0285, +0.2040, +0.0064, -0.6207, +0.1540, +0.2691, -0.4465, +0.3775, -0.7416, +0.0563, -0.0898],
[ +0.1254, +0.4967, +0.1999, -0.2316, +0.2500, -0.0650, +0.5256, -0.4156, -0.2651, +0.1705, +0.0690, -0.0314, -0.6562, +0.0699, -0.8152, +0.1149, +0.0980, +0.6136, +0.2356, -0.4453, +0.3604, +0.4151, +0.1505, -0.3277, -0.2119, +0.0359, -0.1290, -0.1692, -0.0831, -0.0644, -0.1416, -0.0558, +0.0298, -0.0870, -0.1409, -0.5095, -0.3006, -0.0250, +0.4266, -0.3381, -0.3222, +0.3626, -0.0441, +0.2182, -0.1688, +0.0500, +0.2828, -0.2694, -0.0921, +0.1291, -0.7688, +0.2200, +0.1006, -0.3204, -0.1588, -0.5138, -0.6525, -0.3203, +0.5614, +0.1583, -0.3336, -0.6822, -0.0527, -0.0729],
[ +0.2401, -1.5531, -1.1594, +0.0219, -0.1680, -0.0307, -0.1397, -0.4195, +0.2302, +0.2705, +0.0780, -0.3434, +0.2748, -0.1826, -0.4300, -1.2819, -2.0983, +0.2545, +0.3414, +0.1059, +0.1937, +0.0885, +0.3678, +0.0745, -0.2122, -0.2374, +0.2199, +0.1136, +0.0291, -1.5077, -0.6176, +0.0825, +0.0813, -0.2417, -0.3546, +0.2231, +0.3004, +0.0066, -0.0259, +0.5017, -0.6783, -0.5061, +0.0575, -0.1790, -0.4460, -0.6383, -0.1353, -0.1327, +0.0067, +0.2322, -0.0208, +0.2877, +0.1562, -0.5431, +0.0227, -0.1356, +0.0365, -0.2004, -0.1343, +0.1730, -0.5527, +0.1656, +0.1991, -0.8294],
[ +0.4524, +0.7614, -0.1415, -0.0766, +0.1568, +0.0408, +0.0539, -0.2856, +0.1050, -0.1615, -0.8484, +0.5459, +0.1695, +0.2730, -0.0014, +0.6478, +0.1634, -0.0715, -0.0612, -0.1463, -0.1214, -0.1158, +0.1563, +0.2598, +0.0758, -0.4645, -0.2913, -0.3810, -0.7767, -0.3182, +0.1396, +0.1954, -0.0150, -0.1029, -0.2936, -0.5085, -0.0514, +0.1485, -0.1216, -0.1714, -0.1193, +0.4209, +0.0558, -0.4255, +0.2840, -0.5583, -0.3015, -0.2423, +0.0089, -0.4503, +0.3085, +0.2502, +0.2749, +0.2995, -0.7768, -0.3364, -0.5740, +0.0843, -0.2877, -0.5731, -0.3221, -0.2253, -0.3227, -0.0065],
[ +0.0540, -0.0224, -0.3116, -0.5707, -0.0632, -1.4873, +0.2964, -0.4894, -0.2578, +0.2032, +0.0937, -0.4259, -0.0588, +0.4007, +0.1099, -0.2633, -0.3422, +0.1973, -0.0170, +0.0451, +0.1670, +0.4853, +0.2068, +0.2066, -0.1544, +0.0191, -0.0957, -0.9554, -0.6965, -0.6022, +0.1666, +0.0026, +0.5176, -0.0584, -0.9679, -0.2898, +0.2451, +0.2050, -0.2909, +0.0002, -0.0763, -0.2100, -0.1929, +0.0985, -0.2612, -0.3684, +0.3190, -0.5681, +0.2765, -0.1663, +0.0422, +0.3252, +0.2741, -0.2385, -0.1602, +0.2504, -0.2370, +0.0891, -0.2204, +0.1525, +0.0444, +0.0188, +0.3538, -0.0313],
[ +0.0984, +0.2622, +0.1601, -0.3252, -0.2292, -0.0494, +0.2185, +0.2202, +0.4945, -0.3545, -0.1730, -0.6882, -0.6645, -0.1178, -0.2491, +0.2497, -0.1072, -0.2019, -0.0944, +0.2118, -0.2281, +0.2338, +0.0924, +0.1178, +0.0920, +0.0422, +0.3113, -1.1795, -0.8658, -0.6011, +0.0714, +0.0290, -0.5830, +0.2370, +0.3508, -0.0178, -0.6966, +0.2269, -0.2966, -0.6947, +0.1769, +0.1461, -1.0021, +0.0781, -0.3731, -0.0153, -0.2721, +0.0699, -0.2057, +0.0791, -0.2055, -0.4152, +0.2414, +0.0939, -0.4560, -0.3566, -0.0381, +0.1090, -0.5755, -0.4283, +0.2504, +0.0863, -0.6288, -0.9822],
[ -0.0122, -1.0238, +0.0346, -0.2412, -0.7928, -0.3765, -0.2889, -0.0948, +0.1003, +0.7268, +0.2033, -0.6144, +0.4689, +0.2045, +0.0799, +0.2687, -0.3528, +0.0560, +0.0682, +0.0874, -0.1901, -0.0082, +0.3474, -1.0391, -0.4695, -0.0233, -0.0259, -0.0901, -0.1084, -1.4681, +0.0081, -0.3583, -0.2599, -0.1273, -0.6221, +0.2186, -0.1878, +0.4510, +0.0409, -0.1692, +0.1495, -0.3093, -0.0192, -0.1835, -0.5964, +0.0327, -0.5086, +0.2446, -0.5980, +0.1981, +0.0441, -0.1232, -0.4881, -0.6698, -0.0519, -0.0831, -0.6186, -0.6176, +0.0503, +0.2250, +0.0662, -0.8334, -0.0077, -0.7196],
[ -0.2566, -0.7118, +0.2935, -0.1195, -0.1146, -0.0123, +0.1455, +0.1784, -0.2927, +0.3859, +0.2592, -0.0991, -0.6787, -0.2469, +0.1925, +0.0359, +0.2956, +0.2008, +0.0844, -0.3478, -0.2671, -0.0078, +0.3483, -0.0814, +0.5766, +0.2134, +0.0878, +0.3362, -0.1537, +0.3245, +0.2214, -0.2824, +0.1635, -0.5485, -0.1898, -0.1885, -0.0076, -0.2640, -0.2163, +0.4214, -0.2781, +0.1793, -0.1132, -0.3325, -0.3830, +0.1018, +0.0151, -0.7901, +0.1946, +0.3539, -0.4104, -0.1557, +0.3991, -0.0178, +0.1242, +0.4661, -0.0344, -0.4815, +0.1843, +0.6808, -0.0437, -0.3225, +0.2147, -0.4555],
[ -0.0638, -0.3322, -0.2387, +0.2534, -0.5326, -0.8410, -0.2301, -0.8189, -1.0886, +0.2326, -0.6260, -0.4507, -0.1068, -0.7282, +0.5187, +0.1134, +0.2561, +0.1038, +0.3431, -1.1889, +0.6843, -0.7160, -0.6177, -0.2679, -0.0451, +0.0572, +0.0807, +0.6884, +0.5089, +0.5436, +0.3386, -0.4832, +0.4377, +0.4794, -0.4475, -0.6358, -0.0388, +0.3861, +0.1041, +0.0640, -0.0701, +0.0340, +0.1640, -0.4543, -0.4830, -0.4003, -0.2349, +0.1010, -0.9351, -0.2592, -0.2928, -0.1271, -1.0826, -0.1847, +0.1704, -0.4475, -0.2948, +0.2068, -0.5627, -0.0093, +0.0881, -0.2164, -0.0049, +0.1603],
[ +0.1574, -0.0650, -0.2662, +0.1164, +0.4237, -0.6874, +0.4308, +0.4112, -0.0215, -0.0763, +0.2667, -0.3433, -0.4008, +0.2368, +0.1596, -0.1390, -0.4850, -0.0810, +0.1081, -0.1730, -0.8641, -0.3173, -0.2085, +0.1296, +0.2189, -0.4631, -0.3093, +0.0174, -0.0811, -0.4710, +0.0884, -0.5081, -0.2918, -0.0430, -0.1509, +0.4783, -0.1912, -0.7071, -0.3763, +0.0781, +0.1794, -0.3923, -0.9474, +0.3877, -0.2204, -0.2234, -0.0250, -0.3792, -0.6236, +0.1750, -1.4279, -0.4849, -0.6417, +0.1128, -0.2395, -0.1343, -0.5671, -0.1158, -0.1158, -0.3690, -0.1078, -0.2042, -0.3332, -0.2509],
[ +0.0333, -0.2800, -0.1392, +0.0001, +0.0705, -0.1369, -0.1756, +0.1453, +0.3505, +0.3330, -0.1388, -0.7255, -0.4376, -0.0105, +0.0049, -0.8412, -0.3385, -0.1028, -0.3672, -0.8725, -0.3093, -0.0453, +0.0416, -0.1510, +0.3841, -0.2103, +0.0864, +0.1017, -0.3006, -0.0184, +0.4379, +0.4946, +0.1351, +0.2742, -0.1733, +0.1185, +0.0766, -0.7874, +0.3184, -0.5364, +0.1065, +0.1258, -0.2782, +0.2434, +0.3819, -0.2390, +0.2471, +0.1067, +0.1810, +0.0401, -0.4542, +0.1356, +0.1049, -0.1339, -0.1564, -0.0183, +0.1957, -0.1304, -0.0602, -1.1445, -0.1470, -0.0536, -0.0504, +0.3606],
[ -0.4758, +0.1761, -0.4846, -1.0187, -0.1317, +0.4057, -0.7446, -0.0029, -0.1074, +0.3271, +0.2986, -0.2398, -0.1716, +0.0999, -0.3667, -0.3235, +0.0859, -0.2204, -0.0886, -0.3845, -0.1990, -0.4520, -0.0453, +0.0367, +0.4391, -0.5058, -0.5205, +0.0438, +0.0949, -0.2365, +0.0034, -0.0972, +0.2460, -0.3402, +0.2640, +0.1962, +1.0076, -0.0240, -0.0881, +0.3680, +0.1796, -0.1007, -0.7938, +0.1620, -0.2244, +0.1086, +0.0835, -0.6081, -0.0907, -0.2010, +0.1411, -0.1199, +0.1650, +0.0291, -0.1783, -0.2652, -0.1174, -0.4219, -0.2506, +0.0413, +0.0460, -0.6699, -1.2885, +0.1545],
[ +0.1129, -0.1235, -0.0860, -0.3039, +0.0470, +0.1649, -0.6282, -0.0529, -0.0862, +0.2638, -0.0880, -0.9592, +0.3736, -0.1045, +0.3156, -0.3239, -0.0977, +0.1138, +0.1028, +0.0075, -0.4383, +0.0055, +0.1644, -0.5601, +0.0328, +0.2353, -0.1457, +0.0268, -0.1316, +0.1369, +0.1295, -0.0454, -0.0704, -0.6862, -0.1434, +0.1058, -0.0882, -0.2573, -0.1518, -0.0106, -0.1371, +0.3189, +0.4066, -0.2663, -0.5477, +0.3918, +0.0601, -1.2816, +0.0213, -1.0473, +0.2741, -0.0658, -0.3203, +0.0561, +0.2982, -0.0264, +0.3706, +0.3083, +0.4189, -0.3125, +0.2324, -0.0699, -0.0653, +0.3647],
[ -0.0693, +0.4631, +0.0902, +0.3558, -0.1712, +0.1079, -0.0386, +0.1094, -0.3096, -0.2886, -0.2315, -0.2787, -0.5874, -0.6247, +0.5268, -0.1084, +0.7058, +0.1418, -0.5504, +0.0670, -0.0498, +0.1770, -0.1857, -0.0256, +0.0751, +0.1447, +0.1853, -0.1040, +0.0456, -0.5765, +0.0473, +0.1485, +0.3068, -0.2301, -0.2385, +0.2792, -0.8568, -0.5057, -0.0070, +0.0129, +0.4641, -0.2125, -0.6467, +0.0405, +0.0443, +0.0706, -1.0480, -0.2147, +0.1343, +0.1673, +0.0443, +0.1780, -0.3776, +0.3203, -1.0370, -0.5205, -0.0960, +0.4009, +0.2349, +0.1341, +0.0472, -0.1244, -0.1439, +0.0556],
[ +0.1598, -1.2782, +0.6361, -0.5370, -0.1456, -0.8548, -1.0428, -0.8559, -0.2116, -0.3637, -0.4516, -0.0612, +0.0129, +0.0675, -0.5432, +0.1841, -0.3792, +0.2158, +0.0596, -0.6030, +0.8449, +0.4651, -0.2557, -1.2864, -0.2594, -0.0408, -0.4892, +0.3451, +0.3054, +0.3925, -0.1913, -0.4430, -0.0513, +0.2399, -0.3757, +0.4300, -0.5091, +0.3864, -0.5291, -0.4042, +0.1954, +0.5566, +0.5156, +0.3129, -0.0074, -0.5308, -0.0965, +0.4685, -0.6602, -0.5140, -0.0500, -0.0512, -0.0719, -0.2983, -0.0757, -1.4385, -0.3450, -0.5004, -0.8424, +0.3685, -0.4302, -0.3252, +0.2352, -0.2397],
[ +0.2517, -0.0510, -0.8445, -0.0101, -0.2960, +0.3604, -0.0354, -0.2369, +0.4843, -0.2510, -0.0606, -0.0558, +0.1601, +0.1233, -0.0533, -0.6993, -0.1938, -0.0681, +0.1999, +0.1705, -0.3202, -0.0766, +0.2753, -0.4941, +0.2154, +0.1077, +0.2094, -0.0723, -0.1037, -0.0066, +0.0075, -0.0346, +0.2195, +0.1334, -0.1074, +0.0879, -0.2654, +0.2319, -0.1298, -0.3219, +0.3351, -0.6852, -0.5198, -0.2214, -0.0373, +0.2662, -0.2757, +0.0667, +0.1171, +0.1987, +0.4252, -0.5109, -0.5771, -0.2238, -0.0016, -0.1032, +0.2942, -0.4498, -0.1209, +0.0526, +0.0681, -0.0631, -0.2249, -0.5044],
[ +0.1015, -0.1221, -0.0457, -0.1632, +0.1805, -0.4646, +0.1515, +0.3582, +0.0226, -0.1206, -1.2033, -0.5519, -0.7632, +0.1745, +0.2149, -0.3880, +0.8417, +0.0764, +0.3466, -0.0296, -0.1456, +0.0030, -0.4206, -0.6899, +0.1030, -0.4873, -0.1851, +0.2350, -0.5323, -0.7947, -0.1631, -0.0664, -0.7279, +0.2869, -0.1196, +0.3290, -0.3650, -0.2667, +0.0680, +0.0420, +0.0880, +0.0988, -0.7243, +0.2308, +0.6681, -0.4614, -0.2574, +0.1210, +0.1116, -0.0749, -0.8760, -0.2902, -0.0932, -0.0302, -0.4676, -0.0909, -0.0998, -0.1058, -0.1159, -0.0889, +0.1690, +0.0106, -0.1399, -0.6091],
[ -0.3936, -0.2924, -0.0566, +0.0908, +0.1229, -0.4908, +0.2100, +0.3042, -0.1919, -0.2383, -0.1356, -0.2715, +0.5147, -0.0937, -0.2436, +0.2805, -0.4522, +0.1256, +0.0199, -0.2870, -0.1586, -0.1113, -0.4221, +0.5571, +0.4612, +0.0522, +0.0469, +0.1000, -0.3156, -0.2255, +0.0661, -0.8530, -0.1866, -0.0146, -0.2175, -0.5078, -0.2589, -0.0452, -0.0606, -0.1495, -0.0759, -0.0676, -0.4239, +0.1552, -0.3918, +0.2913, -0.1573, -0.1386, +0.4216, +0.3134, -0.2761, -0.0822, +0.4101, -0.4691, -0.3533, -0.4907, -0.6454, -0.6846, -0.5219, +0.2845, +0.0990, +0.5448, +0.0043, -0.1068],
[ +0.2038, +0.3592, -0.0381, -0.3525, -0.4154, -0.0967, +0.1296, +0.0537, -0.0668, +0.1384, -0.3061, -0.3796, -0.0676, +0.2463, +0.0337, +0.2712, +0.2327, +0.2747, -0.0390, -0.4290, -0.1667, -0.2714, +0.0036, -0.2474, -0.0108, -0.5544, -0.3588, -1.0251, -0.1637, -0.6376, +0.1074, -0.2695, -0.2931, +0.2847, -0.3638, +0.2679, +0.3571, +0.3164, +0.0257, -0.1720, +0.0306, -0.0424, -1.3316, -0.2671, +0.1664, -0.6751, -1.3701, -0.1609, -0.5226, +0.2046, -0.2826, +0.0329, -0.1094, +0.0457, +0.2797, -0.3022, -0.2398, -0.1309, +0.1237, -0.6917, -0.1042, -0.5504, +0.0599, -0.0993],
[ +0.2578, +0.2448, -0.3515, +0.2550, -0.4556, -0.1521, -0.0937, +0.1082, +0.0064, -0.1935, -0.0986, -0.4707, -0.8805, +0.0902, -0.2753, -0.1709, -0.0610, -0.5028, -0.2642, -0.5600, +0.0068, +0.3170, +0.3340, -0.3805, +0.2661, -0.6105, -0.0338, -0.3294, -0.5872, -1.0930, -0.0021, +0.0525, -0.4677, +0.2302, +0.2422, +0.0805, -0.8454, -0.1925, +0.3445, -0.0826, +0.1550, -0.1808, -0.9067, +0.1723, +0.0365, -0.2956, -0.0784, +0.2945, +0.0641, +0.0239, -0.0561, +0.0630, -0.1646, +0.0403, -0.9467, -0.6385, +0.1264, -0.2964, -0.1579, +0.2373, -0.0417, +0.1332, +0.4347, -0.2901],
[ -0.1863, -0.0242, -1.3175, -0.0210, +0.7122, -0.0967, +0.2298, -0.2379, +0.0625, -1.0683, -0.5156, -0.2993, +0.3003, +0.2490, -0.2035, +0.1202, -0.0714, -0.2515, +0.1050, -0.0244, -0.0323, -0.0142, -0.3243, -1.0355, -0.1945, -0.6769, -0.1482, -0.6095, -1.2543, -0.1212, +0.2109, +0.1281, -0.5586, -0.1869, -0.0505, +0.3053, -1.4947, -0.4599, +0.3102, -0.0713, +0.0294, -0.3146, +0.3229, +0.0378, +0.5098, +0.3752, -1.1693, +0.2510, +0.5305, +0.0346, +0.4966, +0.1118, -0.1061, -0.2008, -0.8236, -0.3700, +0.0883, -0.3168, -0.6185, +0.7089, -0.7464, +0.0953, +0.5762, -0.1075],
[ -0.0649, +0.0128, -0.1768, -0.6602, -0.1332, +0.2819, +0.2196, -0.5156, +0.3175, +0.1690, +0.2806, -0.4787, -0.6439, +0.2791, -0.2997, +0.1521, -0.1161, -0.0450, +0.3153, +0.2059, -0.0687, +0.1672, +0.1408, +0.1332, -0.0993, +0.3110, +0.0697, +0.1563, +0.1029, -0.9687, -0.0195, +0.2097, -0.1263, +0.0773, +0.0347, +0.1860, -0.0304, -0.2414, -0.8054, +0.1562, +0.2249, -0.9248, -0.8415, +0.3590, -0.1355, +0.3704, -0.4522, -0.3624, -0.7113, +0.2271, -1.0906, -0.5597, +0.2343, -0.3852, -1.1641, -0.2844, +0.3131, +0.0553, +0.1024, -1.8251, -0.7928, +0.1100, -0.1679, -0.9488],
[ -0.2144, -0.1724, -0.3429, +0.4875, +0.1602, +0.3609, +0.2947, -0.0800, -0.1385, +0.1008, +0.0328, -0.4782, -0.0638, +0.1748, +0.1134, -1.1389, -0.3115, -0.5365, -0.6607, -0.4707, -0.7305, +0.1676, -0.0230, +0.2286, -0.6695, +0.0748, +0.1772, -0.2285, -0.4459, +0.1489, -0.3056, -0.2268, -0.1158, +0.2677, -0.5665, +0.2966, -0.1029, +0.0172, +0.5579, +0.2357, -0.2072, -0.3823, -0.7458, +0.2185, -0.7836, -0.2562, -0.5589, -0.0523, -0.5152, +0.1166, +0.2566, -0.4698, +0.1755, +0.2976, -0.2948, -0.0285, -1.5112, +0.1225, -0.0690, -0.0911, +0.1124, -0.3546, +0.0632, +0.4610],
[ -0.1956, +0.0370, -0.0308, -0.1817, +0.1882, -0.1052, -0.0503, +0.3709, -0.2240, -0.0828, -0.8304, +0.0044, +0.0459, +0.0761, +0.0206, +0.1419, +0.4986, -0.0567, -0.3287, -0.7981, -0.2592, -0.7543, -0.4157, -0.0182, -0.0886, -0.7827, +0.0057, -0.0465, -0.3869, -1.4567, +0.2595, +0.0849, -0.8865, +0.0156, -0.1862, +0.2267, +0.4277, +0.2811, -0.8963, -0.2927, +0.1019, -0.1663, -0.8428, -0.2191, +0.4336, -0.9808, -0.8575, +0.1630, +0.0028, -0.4473, +0.5544, -0.2155, +0.0422, +0.1349, -0.3771, -0.0671, -0.0194, +0.2140, -0.3160, -0.5825, +0.3150, -0.0496, -0.0514, -0.2068],
[ +0.2710, +0.2079, -0.7397, -0.5588, -0.3865, -0.3099, +0.3502, -0.0669, -0.0064, +0.1037, -0.8617, -0.3000, -0.2977, +0.2392, -1.4580, +0.3477, +0.0329, -0.5653, -0.6458, -0.2955, +0.1288, +0.1199, -0.5390, +0.1431, +0.1088, -0.5537, -0.0880, -0.3841, +0.0801, -1.8213, -0.5604, -0.9688, +0.3403, +0.7033, +0.7676, -0.0232, +0.1272, -0.0812, +0.0785, -0.0681, +0.3825, -0.1818, +0.0268, +0.0546, +0.0451, -0.4763, -0.0513, -0.3287, +0.5841, -0.1963, +0.1147, +0.1113, -0.5448, -0.3498, -0.0750, -0.0585, -0.5094, +0.0116, +0.6219, -0.1440, -0.0742, -0.1261, +0.0572, +0.4366],
[ +0.0369, -0.3345, -0.0768, +0.4205, -0.1390, -0.2384, -0.1629, +0.0786, +0.6107, -0.2725, +0.0444, +0.2727, +0.3295, +0.3000, -0.4049, +0.1150, -0.7289, -0.5964, +0.1346, +0.0574, -0.1202, -0.2461, -0.1504, -0.1282, +0.5685, -0.3631, +0.4576, +0.6880, +0.2554, -0.1782, -0.2704, -0.5299, +0.0232, -0.4567, -0.1116, -0.2672, +0.4286, -0.0448, +0.2230, +0.0236, -0.0343, -0.0985, +0.8088, +0.2633, -0.7682, -0.0642, +0.0384, +0.0750, +0.0595, +0.1717, +0.5152, +0.2972, +0.0325, +0.0450, +0.2534, -0.1186, +0.1540, -0.0107, -1.5430, -0.1050, +0.4161, +0.0592, +0.0044, +0.0843],
[ +0.1402, +0.1111, +0.4706, +0.3944, -0.1486, +0.1623, -0.1863, +0.0468, -0.4898, -0.0224, +0.2583, +0.1336, -0.1123, +0.0581, -0.0853, -0.0288, +0.0372, -0.1358, -0.0016, -0.5055, -0.2581, -0.3232, +0.0418, -0.5329, +0.0167, -0.1626, +0.0284, -0.8795, +0.1812, +0.1044, +0.3439, -0.3482, -0.1301, +0.1099, -0.3284, -0.3683, -0.0479, -0.2303, -0.2175, +0.2400, +0.4435, +0.0818, +0.3271, -0.0304, -0.4587, -0.3401, +0.1851, +0.1210, +0.0699, +0.2149, +0.3445, -0.3352, -1.0872, +0.1455, +0.2182, -0.7787, -0.4760, +0.0306, -0.2152, +0.1286, +0.1384, -0.0821, +0.1290, -0.0055],
[ -0.3143, -0.1360, -0.4878, +0.1358, +0.5162, -0.0948, -0.1355, +0.0911, +0.3592, +0.3475, -0.5666, -0.1593, +0.1584, +0.3172, -0.0814, -0.1594, +0.1179, -0.6127, -0.3628, +0.1970, -0.6501, +0.1911, +0.4294, -0.2048, +0.3984, -0.0478, +0.1101, -0.5869, +0.4901, +0.2732, +0.1232, +0.4142, -0.1033, -0.7990, -0.2998, -0.2509, +0.2344, -0.2567, -0.0217, -0.0533, +0.0065, +0.2979, +0.1800, -0.0104, +0.1369, -0.0922, +0.0936, -0.7170, -0.0760, +0.8108, -0.5491, +0.6483, -0.2240, +0.3839, +0.1498, -0.3039, -0.1461, +0.6054, -0.2897, -0.0078, -0.5547, -0.2711, +0.0759, +0.3237],
[ +0.5616, +0.6020, +0.1514, -0.0995, -0.2372, +0.0439, +0.1131, -0.4839, -0.0951, +0.0364, -0.5441, +0.4846, -1.2297, +0.0283, +0.0222, -0.0880, -0.2479, -0.9553, -0.3495, -0.2920, +0.1952, +0.1342, -0.0358, +0.0231, +0.2965, +0.1285, -0.6684, -0.1393, +0.0285, -0.2817, +0.4368, +0.2012, -0.2838, +0.4132, +0.1914, +0.0013, -1.7082, -0.0351, -0.4860, +0.7094, -0.2159, -0.1761, -1.0276, -0.1694, -0.3221, +0.0570, -0.4394, -0.2167, +0.4231, -0.1657, +0.6024, -0.2707, -0.8380, -0.3110, -0.2727, -0.0000, +0.0231, -0.1633, -0.1836, -0.2276, -0.4032, +0.1383, -0.1814, +0.0089],
[ -0.5613, +0.4738, -0.0094, +0.1051, -0.1535, +0.4020, +0.1245, -0.2956, -0.3178, +0.2353, -0.1440, -0.4745, +0.5712, -0.6119, -0.2502, +0.1111, -0.2901, +0.1149, -0.2184, +0.0947, -0.2306, +0.0607, +0.5822, +0.1520, +0.3781, +0.1310, -0.1419, -0.3509, -0.0049, -0.1097, -0.0186, +0.1534, +0.0022, -0.0835, +0.1862, -0.2482, -0.1495, +0.1222, +0.4941, +0.1029, -0.7218, -0.3025, +0.1426, +0.5004, -0.0558, +0.2425, +0.0040, +0.1861, +0.2947, +0.1472, -0.1007, +0.4316, +0.2087, +0.1794, -0.3261, +0.3879, +0.3172, -0.1491, -0.2332, -0.1210, +0.1350, -0.6219, -0.1570, -0.3347],
[ -0.3358, -0.0382, -0.7346, +0.4532, +0.1010, +0.1139, +0.2213, -0.1050, -0.0101, +0.3208, -0.0250, -0.7625, -0.2357, -0.4067, +0.3186, -0.9441, -0.0734, +0.0728, +0.0527, -0.0968, -0.0641, +0.2877, -0.0233, +0.0247, -0.1409, +0.1281, +0.0714, -0.0970, -0.4026, -0.3684, +0.3176, -0.1875, +0.5452, +0.0015, -0.0651, +0.1397, +0.1550, -0.2029, +0.1350, +0.5028, -0.4886, +0.0630, +0.1046, +0.5003, -0.5631, -0.1724, +0.2490, -0.0635, +0.2186, -0.6167, +0.2855, -0.0579, -0.3821, +0.0562, +0.3526, +0.1313, -0.1232, +0.5154, +0.2603, -0.0256, -0.0428, -0.4523, +0.1544, +0.4509],
[ +0.4364, +0.1492, -0.8081, -0.7765, +0.6166, -0.1982, -1.1432, +0.1429, -0.2398, +0.5563, +0.6239, -0.5039, +0.5798, +0.2796, -0.1920, +1.1087, -1.2430, +0.3100, -0.1673, -0.2110, -0.1677, -0.2675, -0.6310, +0.4756, -0.9587, +0.2184, -0.4932, +0.1294, +0.3719, -0.4294, -0.5482, -0.0035, -0.8373, -0.8548, -0.3245, -0.0418, -0.0565, +0.1039, +0.0908, -0.7536, -0.2366, +0.3019, +0.2688, -0.5386, +0.1596, -0.1945, +0.6900, -0.8411, -0.2744, -1.1320, +0.0096, +0.0270, +0.4991, -0.1475, -0.0282, -0.0996, -0.1922, +0.1317, +0.0331, -0.1740, +0.0127, -0.5657, -0.0071, +0.3783],
[ -0.9835, -0.0852, +0.0673, +0.3608, -0.5972, -0.6473, +0.2292, -0.8121, -0.2935, +0.3361, +0.1431, -0.9612, -0.4476, -0.3111, -1.0042, -0.3003, +0.0550, -0.4980, -0.1894, -0.2824, +0.2057, +0.4801, +0.2026, -0.0641, -0.5990, +0.2153, +0.1995, +0.2198, -0.3514, -0.0224, -0.1561, -0.9427, +0.5208, +0.2935, +0.3871, -0.1506, -0.0125, +0.6396, -0.0254, +0.4302, -0.3523, +0.0043, -0.0100, +0.3120, -0.1009, -0.9246, +0.0267, -0.1770, -1.4509, +0.0446, -0.3987, -0.0527, -0.3977, -0.8643, +0.0371, -0.2630, -0.0853, +0.1048, +0.0452, -0.5723, -0.0805, -0.0452, -0.0489, +0.3637],
[ -0.1134, +0.1550, -0.0273, -0.5159, -0.1409, -0.0753, +0.3230, -0.4589, +0.2979, +0.1357, +0.1507, -0.9132, -0.9848, -0.0549, -0.1922, +0.1292, -0.2662, -0.0223, +0.1236, -0.1861, +0.1619, +0.3042, +0.2029, -0.1568, +0.1171, +0.2165, +0.3397, +0.4358, -0.0830, -1.0290, +0.2147, +0.1445, -0.0959, +0.4696, +0.1496, +0.2696, -1.2499, +0.0610, -0.7221, -0.5853, +0.1479, -0.7158, -0.9965, +0.4685, +0.1279, +0.2654, -0.2122, -0.2593, -0.0377, +0.1686, +0.2055, -0.4425, -0.3739, -0.5889, -0.2026, +0.0867, +0.1399, -0.2259, -0.1120, -0.7030, -0.2465, +0.1833, -0.4158, +0.2191],
[ -0.3483, +0.1839, +0.0828, -1.1050, -0.1233, +0.1977, +0.1525, +0.4061, +0.5995, +0.0719, +0.2548, -0.7088, +0.0960, +0.8649, -0.4205, +0.0785, -1.6571, +0.3270, +0.1325, -0.3489, -0.1474, +0.4878, +0.6677, +0.1169, +0.0927, -0.7217, +0.2176, +0.4076, +0.2830, +0.1905, +0.2715, +0.0414, +0.0528, +0.2191, -0.0137, -0.6578, +0.0925, -0.0096, -0.0277, +0.3254, -0.1541, -0.1264, +0.3611, +0.4325, -0.5513, +0.5342, +0.5277, +0.0938, +0.1011, -0.3802, -0.3093, -0.3772, +0.2394, -0.0069, +0.2487, -0.0366, -0.2062, -0.4031, +0.1757, +0.1664, -0.6083, -0.4812, +0.3686, -1.8912],
[ +0.4638, -0.6215, -0.9444, -0.2262, -0.0024, -0.1107, +0.2688, -0.8943, +0.2925, +0.0938, -0.2213, -0.0040, +0.5671, +0.1933, -0.1180, +0.8275, -0.4667, +0.4134, +0.2031, -0.7823, -0.2169, -0.0449, -0.0460, +0.2337, -0.6242, +0.1746, +0.1719, -0.3266, -0.0035, -2.0916, -0.9540, -0.4786, +0.1893, +0.0484, -0.2314, +0.0707, +0.6548, +0.1558, -1.5931, -0.1063, -0.0078, -0.1189, +0.2243, -0.4626, +0.9811, +0.0963, +0.3128, +0.2263, -0.1932, +0.2922, -0.8837, +0.4654, +0.3331, -0.7873, -0.1036, +0.1652, -0.3548, -0.6482, -0.3590, -0.4473, -0.5732, -0.6507, +0.0124, +0.3495],
[ +0.2305, -0.0983, -0.6019, +0.0341, -0.0379, -0.3943, +0.2129, -0.1420, -0.4793, +0.1007, +0.0970, -1.2953, +0.1626, +0.1505, -0.0289, -0.0156, -0.8020, -0.5636, -0.3583, -0.5833, -0.0779, +0.0571, -0.6464, -0.3262, -0.0799, +0.1420, -0.2370, +0.2553, -0.0499, +0.0923, -0.0051, +0.1285, +0.3178, +0.4984, -0.8847, +0.0226, -0.0542, +0.0218, +0.1203, -0.3696, -0.1743, +0.2263, -0.2901, +0.2136, -0.1456, -0.1032, -0.3173, +0.2449, +0.3368, -0.0686, +0.2705, -0.3874, -0.0087, +0.1807, +0.1054, -0.5347, -0.4611, -0.0363, +0.3767, -0.4282, +0.2581, -0.1649, +0.2136, +0.2720],
[ +0.0920, -0.0227, +0.2435, -0.0693, -0.1166, +0.4459, +0.0340, +0.1341, +0.0651, -0.4839, -1.2283, -0.3406, -0.0625, -0.1543, -0.5159, -0.1331, -0.1011, +0.1511, +0.1291, -0.3677, +0.1103, +0.3123, -0.0555, +0.0921, +0.2083, -1.2922, +0.4564, +0.2563, -0.3195, -1.2801, +0.2871, -0.2701, -1.0224, -0.4784, +0.2698, +0.0970, -0.3113, -0.2468, -0.5107, -0.1610, -0.0608, -0.5730, +0.0112, -0.3562, +0.0284, +0.3547, -0.1682, -0.4646, -0.5916, +0.0556, -0.4088, +0.3740, +0.1835, +0.2922, -0.2365, -0.0748, +0.3475, -0.1332, -0.0565, -0.6135, -0.2440, -0.0980, +0.0177, +0.2084],
[ +0.5078, +0.2882, -0.1070, -0.2375, +0.1945, -0.1556, -0.1868, +0.4579, -0.1407, -0.3003, +0.5034, -0.1413, -0.1191, +0.5198, -0.0995, +0.2052, -0.6323, +0.3269, +0.1478, -0.9499, -0.0894, -0.5471, -1.0356, -1.0237, +0.1626, +0.0408, -1.5120, +0.5972, -0.2106, -0.1963, -0.2037, +0.4696, +0.0170, +0.3471, +0.6302, +0.3234, +0.0171, +0.2163, -0.2019, -0.8498, -0.7691, +0.0792, +0.1790, -0.2880, +0.1583, -0.2802, +0.3539, -0.2478, +0.2920, -0.8338, +0.3591, -0.6136, -0.0626, +0.5065, +0.3065, -0.3856, -0.7768, +1.0600, -0.3624, +0.4283, +0.6014, -0.2987, -0.5462, +0.5388],
[ -0.1657, +0.2175, +0.1502, +0.1590, +0.2511, -0.1747, +0.0322, +0.0047, -0.1304, +0.1304, -0.2217, +0.2689, -0.0998, +0.0495, +0.5198, -0.4353, +0.3513, -0.3965, -0.7116, +0.1963, -0.2455, +0.1669, +0.0317, +0.0209, -0.9937, +0.0478, -0.1112, +0.0802, -0.0946, +0.2395, -0.4575, +0.2455, -0.0041, +0.2040, -0.1288, +0.4845, -0.0935, +0.1073, -0.1772, -0.0717, +0.1100, -1.2535, -0.4555, +0.1200, +0.0925, +0.2260, -0.3057, +0.1682, -0.7064, +0.0541, +0.2077, -0.6310, +0.1636, +0.4050, +0.0783, -0.2254, -0.5860, +0.0542, -0.1233, +0.0088, -0.1021, -0.4150, -0.5846, +0.0780],
[ +0.0137, +0.1261, +0.2534, +0.0314, +0.1516, +0.2854, -0.2887, -0.0637, -0.1735, +0.0230, -0.2352, -0.2550, -0.4087, -0.1375, +0.5831, -0.4667, -0.1422, -0.0267, -0.1625, -0.4943, +0.0660, -0.0611, -0.2226, -0.1747, +0.2218, +0.0342, -0.0662, -0.5225, -0.2543, -0.3675, +0.2921, -0.5501, -0.6124, -1.0240, -0.0340, +0.3921, +0.0436, -0.1442, +0.1874, +0.3041, -0.1329, +0.0904, -0.4785, -0.1100, +0.7130, -0.9416, -0.3120, -0.3972, -0.0667, -0.2238, +0.5337, +0.2120, -0.3086, +0.1386, +0.0945, -0.0784, +0.0060, +0.3076, +0.1153, -0.8886, +0.2775, -0.3114, +0.1672, +0.2318],
[ +0.0146, -0.1282, -1.1506, +0.1754, +0.0246, -0.4277, +0.1070, -0.5093, -0.0829, -0.9763, -1.5423, +0.0999, +0.1235, -0.5906, -0.0747, +0.0536, -0.0421, +0.0307, +0.2496, +0.1554, -0.0956, +0.2644, +0.0617, -0.0836, -0.8209, +0.2670, -0.0349, -0.7920, -0.0636, -0.5876, -0.5698, -0.2682, -0.3274, +0.2240, -0.0315, -0.3318, -0.1250, -0.1955, -0.2965, +0.2306, -0.0729, -0.2693, -0.2185, +0.1496, +0.1656, +0.2526, -0.3052, -0.1906, -0.3483, -1.2051, +0.3049, -0.1922, -0.3015, -0.4155, -0.3547, +0.0109, -0.4658, -0.7525, -0.4770, -0.5124, +0.1414, -0.1773, -0.5394, +0.0918],
[ -0.9757, +0.5451, -0.1582, -0.0760, +0.2780, +0.0088, -0.5886, +0.7647, +0.0055, +0.2014, +0.2445, -1.4211, -0.0321, +0.2212, +0.4337, -0.5242, -0.2517, +0.1777, -0.0283, -0.4325, -0.0527, -0.3353, -0.1614, -0.7283, +0.6176, -0.4128, -0.2551, +0.1218, -0.2137, -0.5500, +0.2138, -0.5199, +0.1999, +0.5070, +0.8055, +0.4022, -0.0963, -0.0710, -0.6852, -0.1077, +0.1993, -0.0105, +0.1279, +0.0083, -0.2906, -0.6892, -0.5177, -0.5738, -0.0834, -0.1992, -0.2419, +0.5335, -0.1230, +0.1839, -0.2993, +0.4106, -0.7241, +0.3990, +0.1751, +0.2938, +0.0499, -1.0744, -0.2422, -0.4619],
[ -0.4866, -0.3855, -0.1042, -0.1423, +0.2359, +0.2600, -0.1206, -0.1596, -0.0135, -0.7623, +0.8498, -0.4058, -0.2221, -0.2718, -0.2202, -0.0022, -0.3595, -0.5880, -0.2412, -0.0803, +0.2923, +0.0932, -0.0245, +0.0494, -0.0914, +0.0065, -0.1044, +0.2288, -0.2645, +0.1512, -0.7647, +0.4264, +0.5612, -0.1165, +0.0498, +0.2486, -0.4278, -0.5425, +0.2555, -0.2089, +0.1553, +0.2537, +0.6342, -0.6339, -0.3252, +0.4005, +0.3177, -1.0503, -0.0484, -0.6869, -1.2052, +0.0518, -0.2127, +0.6565, +0.1174, -0.0542, +0.0330, -0.3769, -0.8160, -0.3341, +0.5011, -0.2296, -0.0582, +0.2720],
[ -0.2740, -0.4031, +0.1220, +0.2121, -0.2756, -1.1033, -0.7286, -0.1866, +0.3279, +0.2347, -0.6916, +0.0782, -0.3519, +0.5791, -0.0632, -1.1896, -0.5604, -0.2738, +0.2529, +0.0344, -0.0932, -0.1923, -0.1518, -0.0706, +0.1075, +0.2185, -0.3537, -0.3668, -0.5451, +0.7531, -0.2921, +0.9216, -0.6654, -0.4376, +0.0435, -0.4269, +0.0265, -0.4000, -0.5693, -0.2149, +0.0681, -0.1618, -0.1684, -0.1539, -0.0432, +0.0356, +0.1934, +0.1132, -0.8665, -0.2111, -0.0802, +0.0847, +0.2886, -0.2710, -0.1154, -0.1229, +0.0220, -0.2838, -0.2988, +0.2642, -0.1269, +0.0378, -0.0577, +0.2332],
[ -0.0167, -0.2866, -0.5837, -0.3393, -0.2001, -0.2052, -0.0069, -0.0557, +0.0957, -0.0296, -1.2254, +0.6089, -0.7623, +0.2794, -0.1563, -0.5299, -0.2602, +0.3578, +0.2024, -1.1151, -0.7019, -0.3572, -0.2302, -0.0681, +0.1533, -0.3679, +0.3212, -0.0854, -0.3797, -1.4589, +0.2442, -0.7591, -0.5560, -0.1719, -0.4811, +0.0760, +0.2026, -0.0090, +0.3387, +0.5250, -0.3101, -0.5067, +0.6807, -0.2780, +0.1402, +0.0732, -0.0141, -0.5621, -0.5418, -0.1793, -0.1043, -0.1398, -0.2086, +0.0398, +0.5175, -0.0853, +0.2001, +0.0463, +0.0370, -0.1317, -0.5319, +0.1052, -0.3744, -0.0245],
[ -0.2261, +0.1322, +0.2244, +0.0686, +0.6216, +0.2085, -0.2037, -0.6063, -0.1096, -0.3126, +0.4351, +0.3109, -0.1477, -0.0571, +0.4007, -0.3581, +0.3124, +0.2700, +0.3172, -0.5340, +0.2530, +0.1908, +0.0630, +0.4039, +0.2531, +0.1035, +0.5428, +1.0849, -0.6678, -0.1461, +0.1677, +0.6444, -0.1607, +0.0921, +0.0428, -0.4171, +0.0052, -0.6449, +0.5795, +0.3778, -0.2117, +0.6219, +0.4147, -0.2854, +0.0800, +0.2086, +0.1057, +0.0211, +0.1335, +0.0754, -1.0412, +0.3630, -0.3308, -0.0163, +0.3209, +0.6749, +0.1818, +0.0622, +0.0631, -0.0780, -0.2003, +0.0502, -0.1801, +0.1226],
[ -0.5705, -0.4520, -0.2005, -0.1099, +0.0716, +0.1710, -0.5488, -0.0350, +0.3769, +0.5694, +0.2142, -0.2680, +0.3770, +0.0675, +0.1544, -0.1849, -0.1091, -0.8965, +0.2643, +0.0145, -0.1163, +0.0022, +0.0120, +0.4676, +0.0786, +0.0047, -0.0236, +0.2523, -0.0296, -0.1272, -0.1784, -0.0316, -0.1040, -0.0833, -0.5759, +0.1137, +0.1781, -0.1794, -0.7452, +0.2339, -0.2118, -0.0421, +0.1374, -0.7774, +0.0419, +0.2437, -0.1457, -0.3050, -0.5618, -0.8883, +0.3731, +0.1214, +0.2160, -0.2766, +0.2474, -0.0136, -0.0689, +0.2249, +0.4861, +0.3022, +0.0187, +0.4610, +0.0144, -0.0760],
[ +0.0452, -0.0096, +0.0093, +0.3166, +0.0104, -0.8211, +0.0320, -0.9130, -0.9762, +0.3912, +0.0517, -0.0086, -0.1364, -0.5440, +0.3999, -0.8466, +0.1587, +0.3064, -0.0849, -1.0372, -0.3295, -0.0011, +0.0702, +0.0558, -0.3068, -0.0579, +0.1683, +0.1862, -0.3232, +0.0126, -0.0197, +0.3761, +0.3451, +0.1456, -0.1702, +0.3671, +0.2129, +0.1910, -0.4390, -0.2298, +0.2539, -0.2647, -0.0812, +0.1049, +0.0182, +0.0124, +0.1412, +0.7550, +0.1466, +0.0842, -0.2089, -0.1244, -0.1409, -0.0448, +0.4329, +0.2906, +0.1276, +0.0849, +0.1483, -0.1114, +0.1040, -0.1841, +0.0504, +0.0628],
[ -0.7229, -0.2299, +0.3797, +0.2634, +0.1779, +0.1996, -0.0516, +0.1889, -0.0321, -0.0180, +0.1005, -0.1224, -0.7053, -0.1657, +0.2718, -0.1325, -0.3542, -0.0817, +0.0660, -0.3473, -0.1094, +0.3669, +0.0287, +0.4202, +0.5254, +0.3843, +0.2454, -0.1032, -0.2225, +0.1151, +0.2620, -0.2615, +0.1377, -0.0886, +0.1253, -0.2241, +0.2043, -0.6399, -0.0001, +0.2756, -0.5004, +0.0097, +0.1577, +0.1704, -0.4630, +0.0586, +0.1950, -0.2765, +0.3850, +0.1792, -0.0390, +0.0853, +0.0609, +0.3052, +0.1366, +0.4978, -0.0320, -0.0238, -0.2433, +0.1354, -0.3672, +0.1638, +0.3015, +0.0190],
[ -0.5652, -0.5404, +0.3047, +0.2983, +0.0327, -0.2695, +0.3298, +0.0245, -0.8883, -0.2214, +0.0148, +0.2319, -0.4585, -0.4131, +0.1738, -0.0687, +0.2266, -0.0930, -0.0778, +0.0594, -0.7182, -0.5207, -0.1110, -0.6784, +0.1840, +0.4566, +0.0854, -0.0213, -0.4181, +0.1902, +0.3848, -0.3574, +0.0339, +0.0642, +0.2140, +0.2387, +0.1925, -0.4425, -0.1289, +0.0003, +0.4367, -0.1658, -0.6550, +0.0966, -0.2929, -0.0290, +0.0821, +0.0917, +0.0588, +0.0215, +0.2516, -0.6177, -0.3127, +0.1305, +0.1058, -0.2301, -0.1769, +0.3145, +0.0931, +0.0435, +0.2786, +0.4412, +0.1732, -0.1200],
[ -0.0996, -0.6608, -0.0364, +0.3340, +0.0165, +0.3010, +0.0927, +0.1056, -0.2970, -0.1835, +0.0571, +0.2240, +0.0030, -0.6368, +0.2202, -0.1890, +0.4696, -0.0632, -0.0631, +0.0907, -0.1202, -0.3129, -0.0065, -0.2858, +0.5460, +0.2200, +0.2605, +0.0594, -0.2014, +0.3389, +0.3456, -0.0752, +0.0585, -0.0157, +0.0157, +0.0445, +0.3628, -0.4249, -0.3869, -0.0149, +0.3033, -0.2029, +0.3068, +0.2245, -0.3317, +0.5013, +0.2260, +0.0021, +0.5501, +0.0470, +0.0281, -0.4652, -0.5074, +0.0623, +0.2559, +0.1474, +0.3211, +0.3766, -0.0389, +0.3026, +0.0087, +0.4048, +0.4947, -0.1758],
[ +0.1554, -0.1069, +0.0311, +0.1231, +0.1511, -0.5720, -0.2430, +0.0702, -0.3883, +0.0351, -0.4604, +0.2486, -0.1264, +0.0224, -0.4056, -0.0509, -0.2476, +0.4460, +0.3992, -1.0177, -0.4811, -0.0661, -0.4349, +0.0118, -0.3434, -0.0266, -0.4486, -0.2416, -0.2670, -0.2086, -0.6751, +0.0134, -0.0306, +0.1693, -0.1759, +0.2342, +0.0876, +0.0606, +0.5759, -0.6247, -0.0825, +0.8001, -0.4028, -0.3971, +0.4740, -0.7486, -0.1452, +0.0966, -1.1183, -1.7440, +0.3747, -0.2859, -0.4128, +0.0351, -0.1834, +0.2799, -0.5416, +0.1614, -0.1525, +0.5196, +0.1470, +0.2015, -0.0209, +0.4493],
[ +0.4452, +0.3101, -0.1846, -0.2601, +0.0557, -0.1652, +0.2796, -0.2789, -0.3574, +0.7659, -0.0928, -0.1773, +0.2040, +0.3471, +0.0277, +0.1219, +0.1127, +0.2735, -0.0420, -0.3129, -0.8266, -0.0287, -0.1716, +0.0738, -1.1224, -0.2538, -0.1206, +0.4969, +0.5520, -0.9201, -0.4422, -0.4078, -0.2800, +0.0784, -0.1056, -0.1181, -0.6464, +0.1835, -0.1094, -0.0400, +0.3895, -0.4687, +0.7645, +0.1850, +0.8089, -0.0632, +0.3379, -0.1370, -1.2702, -0.1647, -0.0076, -0.3014, +0.5104, -0.8770, -0.1667, +0.0547, -0.9042, -0.7874, +0.4112, -0.6015, +0.1230, -0.3193, -0.3689, +0.7722],
[ -0.1760, +0.0806, +0.0633, +0.1495, -0.2089, -0.1720, +0.3683, -0.7910, -0.1092, -0.0286, -0.2381, -0.3570, -0.3146, -0.4156, -0.4463, +0.2495, +0.1315, -0.4987, -0.0444, -0.3366, +0.4729, +0.5814, +0.2111, +0.5879, -0.4906, -0.2095, +0.1884, -0.8830, +0.0099, -0.5141, -0.0253, +0.0638, -0.5014, -0.6889, +0.4109, -0.3437, -0.5957, -0.3521, +0.4051, +0.1513, +0.0929, +0.2743, -0.5853, -0.0101, +0.0543, +0.0796, +0.0171, -0.1006, -0.8329, +0.3093, -0.7488, -0.1443, +0.4323, -0.3448, -0.6281, +0.4770, +0.4202, -0.8632, -0.3805, -1.1830, -0.7543, -0.5576, -0.5449, +0.2612],
[ -0.7124, +0.0296, -0.0180, +0.1221, +0.3492, -0.1979, +0.1803, -0.6664, -0.4365, +0.0834, +0.0055, +0.2783, +0.2842, -0.3726, -0.1905, -0.3562, +0.4659, +0.5841, +0.2670, +0.3766, +0.2223, -0.2560, -1.2231, +0.3688, -0.6143, -0.4259, -0.0066, -0.6308, -0.0026, -0.4631, -0.1651, -0.3861, +0.1432, +0.3695, +0.3812, +0.1687, -0.0687, +0.6742, -0.1006, -0.0740, +0.3388, -0.1572, +0.3848, +0.1060, -0.3427, -0.0441, +0.1701, -0.9669, -0.6756, -0.7418, -0.4919, +0.1873, -0.0749, -0.0006, -0.2966, -0.3439, +0.1329, +0.1904, -0.4898, -0.7065, +0.3420, -0.1842, +0.2152, -0.0524],
[ -0.0034, +0.0550, -1.2687, -0.0799, +0.3824, -0.1359, +0.2033, -0.0635, -0.1804, -0.0437, +0.1483, -0.5138, -0.7083, -0.4176, +0.4133, -0.9608, -0.1535, +0.2607, +0.1512, +0.0048, +0.1409, +0.0624, -0.2070, -0.6507, -0.1054, -0.1554, -0.9355, +0.1028, +0.6517, -0.1690, -0.0253, -0.6379, -0.4949, -0.0544, -0.0154, +0.2114, -0.2261, +0.6168, +0.0140, +0.0834, +0.2390, -0.4280, -0.5701, -0.3384, +0.3953, -0.0290, -0.0415, +0.1204, +0.0763, -0.5635, -0.6979, -0.2972, +0.1168, +0.0858, +0.5719, +0.0460, -0.1850, +0.3278, +0.2367, -0.1745, +0.3339, +0.2345, -0.7674, +0.2316],
[ -0.7640, +0.4325, -0.7808, -0.8599, +0.0685, +0.1389, -0.4254, +0.1816, +0.5504, +0.5307, -0.3181, -0.6939, -0.4922, +0.2190, -0.0280, +0.0948, -0.0696, +0.2561, -0.3489, +0.1103, +0.2562, -0.0775, -0.4995, -0.3639, +0.4419, -0.0798, +0.1815, -0.4532, +0.0092, -0.3042, -0.5383, +0.2354, -0.0964, -0.3795, +0.6289, -0.0032, +0.8141, +0.1504, +0.3532, +0.4816, -0.4394, -0.2215, -0.2689, +0.6740, -0.1720, +0.0399, -1.3940, -0.0466, -0.6636, -0.7952, +0.2715, +0.1412, +0.1164, +0.1355, -0.4197, -0.1231, +0.0225, +0.1704, -0.6381, -0.1786, +0.1951, +0.7547, +0.0585, -0.9978],
[ +0.2424, +0.1429, -0.5942, -0.8311, -0.4039, +0.0123, -0.5286, -0.1538, +0.1444, -0.2057, +0.1541, +0.3277, +0.0325, -0.1216, -0.2855, -0.3571, -1.2245, +0.5472, +0.8566, -0.4063, -0.0020, +0.0161, -0.0828, +0.1365, -0.3165, +0.1856, +0.4180, +0.3827, +0.4085, +0.1363, -0.5951, +0.2136, +0.4635, -0.3175, -0.0179, -0.1298, +0.3717, +0.3155, +0.7539, -0.3723, -0.9288, -0.0145, +0.2546, -0.1112, +0.0629, +0.1843, +0.3677, -0.3291, -0.4158, -0.4757, -0.6994, +0.1739, +0.2550, -0.2444, +0.1263, +0.2426, +0.2999, -0.1290, -0.3900, +0.3528, +0.1145, +0.2559, -0.0819, -0.4488],
[ -0.4228, -0.1394, -0.2091, -0.0344, +0.4417, -0.0600, -0.5085, +0.2543, -0.0523, +0.3243, +0.0854, +0.2292, +0.0820, -0.0431, +0.0678, -0.0514, -0.0348, -0.0160, +0.5653, +0.1224, +0.2047, -0.1892, -0.9762, -1.0318, -0.9600, +0.2571, +0.0527, +0.2796, -0.0836, +0.0239, -0.6415, +0.2080, +0.3183, +0.1883, -1.2626, +0.2661, +0.1099, -0.3269, -0.3931, -0.2218, -0.0774, -0.1932, -0.2984, -0.2962, -0.0536, -0.4651, -0.2370, -0.1265, -0.1956, -0.5390, -0.5313, -0.4435, -0.0816, +0.1992, -0.2242, -0.5927, -0.0626, +0.1441, +0.0228, -0.1464, +0.1223, -0.0883, +0.2199, +0.1578],
[ +0.3977, +0.0629, -0.0984, -0.4987, +0.4269, -0.1940, -0.1254, +0.2561, +0.2799, -0.2491, -0.1810, +0.2404, +0.5219, +0.0879, -0.2920, +0.3293, +0.0132, +0.0919, -0.1286, +0.5001, +0.1045, -0.1544, -0.5092, -0.2277, +0.1893, -0.6046, +0.1304, +0.9889, +0.1189, +0.2228, -0.3941, -0.0629, -0.3580, -1.2052, -0.3574, -0.5456, -0.2044, -0.3054, -0.0874, -0.7163, +0.0782, +0.4724, +0.4832, -1.0618, +0.2777, -0.3273, +0.0845, +0.0028, +0.1905, +0.3128, +0.1351, +0.1499, -0.1993, +0.0798, +0.0308, -0.8532, +0.0118, -0.2095, -0.0387, +0.1203, +0.1096, -0.0137, +0.1436, -0.2861],
[ -0.2417, -0.0439, +0.1189, +0.2369, -0.2781, +0.3031, +0.0773, +0.6085, +0.0232, -0.1423, -0.6961, -0.8309, -0.6136, -0.2563, +0.0283, -0.1212, -0.4166, -0.0050, +0.0318, +0.0260, -0.2687, -0.1907, -0.2317, -0.6242, +0.4980, -0.2121, -0.2454, -0.8505, -0.6092, -1.1722, +0.5666, +0.1006, -0.1905, -0.0702, +0.0700, +0.0617, +0.1817, -0.2282, +0.0176, -0.2242, +0.1264, -0.2623, -0.7171, -0.1821, -0.3619, -0.1819, -0.2828, -0.2249, -0.0303, +0.0185, +0.2609, -0.0549, -0.0996, +0.4723, -0.3633, +0.0846, +0.0765, +0.3280, -0.2451, +0.1041, -0.0034, +0.2080, +0.1936, -0.4749],
[ -0.4080, +0.0101, +0.4896, +0.2650, -0.0713, -0.4852, -0.4725, -0.1664, +0.1746, -0.1745, +0.1742, +0.0886, -0.0533, -0.2693, -0.1717, -0.1211, -0.5343, -0.2970, -0.2407, -0.0890, +0.2510, +0.1665, -0.0280, -0.5085, -0.0720, +0.0815, +0.0286, -1.0586, -0.0480, +0.6197, -0.1686, -0.0971, -0.0590, -0.0530, -0.5561, +0.2351, -0.8316, -0.4513, -0.0833, +0.3241, -0.2440, +0.0885, -0.0566, -0.0628, +0.0390, +0.0530, +0.1303, +0.2249, +0.3535, -0.1897, -0.0028, -0.4503, -0.4608, -0.4771, +0.0547, +0.1368, -0.0396, -0.0574, -0.7205, -0.0545, +0.3713, -0.1449, +0.0460, -0.2573],
[ +0.1729, +0.3328, -0.0483, +0.3430, -0.8166, -0.7130, -0.1524, -0.8914, -0.0284, +0.3845, +0.3261, -0.2930, -0.1704, -0.0667, -0.0761, -1.0040, +0.5002, +0.0138, +0.0480, -0.1500, -0.1398, +0.1682, +0.4195, -0.2878, -0.4181, -0.5565, +0.1091, -0.2138, -0.0314, -0.9147, -0.2513, +0.0348, -0.1134, -0.1961, +0.5464, +0.2765, +0.0357, -0.5474, -0.6593, -0.0637, -0.5578, +0.0965, -0.3782, -0.0283, +0.1986, -0.7640, -0.2243, +0.1620, -0.4975, +0.4370, -0.0027, -0.4728, -0.5417, +0.1895, +0.4871, -0.7267, -0.0884, -0.4895, -0.3184, -0.2400, +0.5365, -0.6006, -0.0316, -0.2627],
[ -0.1250, -0.2274, -0.4734, -0.8212, -0.8737, -0.2582, -0.1367, +0.0765, +0.1154, -0.0014, +0.1208, -0.0270, -0.0425, +0.3288, -0.1526, +0.3159, -0.3454, +0.3237, +0.0894, -0.5365, +0.1782, -1.0302, +0.0365, -0.2069, +0.1498, -0.5999, -0.2724, -0.1894, +0.4306, -0.3260, -0.3904, -0.0550, -0.2776, -0.2343, +0.4672, -0.1577, -0.2296, +0.2996, -0.6247, -0.2263, -0.4007, -0.2281, -0.0291, -0.6503, +0.3853, -0.7961, +0.3894, -0.0580, -1.3425, -0.2164, -0.1007, +0.1227, -0.4520, +0.1167, +0.1217, +0.1238, +0.0792, -1.1752, +0.1036, +0.0568, -0.3924, +0.0349, -0.5209, +0.3545],
[ +0.0287, -0.3782, +0.1962, -0.1268, +0.3571, -0.0019, -0.0362, -0.0845, +0.3061, +0.2659, -0.5059, -0.1129, -0.4579, +0.2661, +0.0929, +0.0436, +0.0056, +0.2657, +0.3845, -0.5530, +0.1714, +0.4608, +0.2531, +0.3154, +0.0426, +0.5664, +0.2775, -0.1081, +0.2637, -0.1573, -0.2128, +0.0684, -0.4874, -0.0263, -0.0327, -0.0933, -0.1256, -0.7359, -0.0188, +0.5449, -0.1793, +0.2461, +0.1168, +0.1503, +0.4420, +0.0875, -0.4102, +0.0356, -0.2893, +0.2913, -0.8194, +0.4889, +0.0413, +0.3302, -0.2903, +0.0952, +0.0212, +0.3041, +0.1542, -0.4005, -0.2331, -1.3377, +0.1470, -0.7202],
[ -0.9282, -0.1059, -0.0082, -0.1766, -1.3977, -1.3125, +0.3087, -0.3368, -0.6917, +0.0534, +0.0881, -0.7281, -0.4862, +0.0312, -0.8796, -0.0374, -0.0516, -0.3584, -0.9422, -0.8726, +0.0645, +0.0442, -0.2800, -0.3980, -0.1358, +0.4521, +0.1079, -0.1224, +0.1390, -0.5237, -0.2044, -0.8309, +0.2561, +0.4951, -0.7866, -0.1615, -0.2310, -0.2373, +0.0514, +0.2622, -0.4641, -0.1833, -0.1839, -0.0406, -0.3321, -0.2933, -0.0421, +0.1813, -0.2127, -0.1382, -0.0012, -0.6567, -1.4080, -0.3627, +0.3178, -1.2242, -0.9392, -0.1510, +0.2459, -0.0221, +0.4568, -0.4586, -0.0793, +0.3680],
[ -0.3041, +0.2604, -0.2652, +0.6025, +0.0916, +0.0136, -0.2971, +0.3269, +0.0725, -0.2456, -0.3518, +0.2903, +0.1801, -0.6663, +0.3020, +0.1644, +0.3541, -0.2844, -0.5166, -0.1280, -0.0661, +0.5309, +0.2226, +0.0688, -0.1076, -0.0739, +0.1466, +0.5006, -0.0508, -0.1852, +0.0641, +0.0069, -0.6020, -0.2326, -0.1071, -0.1683, +0.1069, +0.3673, -0.1795, -0.3418, -0.0471, +0.2649, +0.0608, -0.9008, +0.1314, +0.0451, -0.4691, -0.1016, -0.5714, +0.0841, +0.1224, +0.1867, -0.0598, -0.1693, -0.3963, +0.0738, +0.5359, +0.3494, +0.1235, +0.4378, -0.0009, +0.5538, +0.4332, -0.0908],
[ -0.5524, +0.2589, +0.1305, -0.4090, -0.0750, +0.1026, +0.5287, +0.2289, +0.4169, -0.0428, -0.3602, -0.1625, +0.0370, -0.4344, -0.2947, -0.0240, +0.1273, -0.0985, -1.3586, -0.7712, -0.2291, -0.4270, +0.4181, +0.3414, +0.1665, +0.0272, +0.3223, -0.1411, -0.0644, -0.7001, +0.1848, +0.3318, -0.4295, -0.7952, -0.0880, -0.4895, +0.2159, -0.1718, -0.3125, +0.0386, -0.6332, -0.3036, -0.5912, -0.4327, -0.0451, -0.5203, -0.0132, -0.1439, -0.1113, +0.0051, +0.0134, -0.0185, -0.0601, -0.0629, -0.2407, -0.4088, +0.0155, -0.2293, -1.0280, +0.0067, +0.1398, -0.1448, +0.3806, +0.2182],
[ +0.0648, -0.0437, -0.0942, -0.2744, -0.4381, -0.2502, +0.1999, -0.1825, +0.3736, -0.5487, -0.2808, -0.8762, -0.0995, -0.7099, -0.1731, -0.0471, +0.0135, +0.3748, -0.4082, -0.2058, +0.5860, +0.4465, +0.2315, +0.1135, -0.3129, -0.8307, +0.1438, -0.6274, +0.0895, -0.1950, -0.0484, -0.2457, +0.1510, -0.8775, -0.9142, -0.1708, -0.0972, -0.6048, +0.2905, +0.5451, -0.2202, -0.3213, -0.0398, -0.3397, +0.0215, -0.1846, +0.1132, -0.0441, -0.4064, -0.2330, -0.5510, +0.4083, +0.0116, -0.1033, -0.0460, +0.1744, +0.1322, -0.7649, -0.5508, +0.6277, +0.0331, -0.4214, +0.2977, +0.3355],
[ -0.1351, -0.2439, +0.3468, +0.2800, -0.0715, +0.0273, +0.0259, +0.2220, -0.1142, -0.2086, +0.1733, -0.3081, -0.0993, +0.0308, -0.8777, +0.2663, -0.0156, -0.0179, +0.3093, +0.2105, -0.1656, -0.3246, -0.0365, -0.4435, +0.3391, -0.0303, +0.2684, -0.6413, -0.0021, -0.7990, +0.1877, -0.3394, +0.2103, +0.0907, +0.0610, +0.0687, +0.2747, -0.3606, +0.1065, +0.0569, +0.2614, +0.1773, -0.8595, +0.0669, -0.1244, -0.4618, -0.3705, -0.0510, +0.2129, +0.1995, +0.0395, -0.0747, -0.2724, +0.1117, -0.3345, -0.3311, +0.0042, +0.3678, +0.3423, +0.2525, -0.0849, +0.3778, +0.4023, -0.1001],
[ +0.1241, -0.0503, -0.0182, -0.2132, -0.2386, -0.3724, -0.2412, -0.1737, -0.1700, +0.3160, -0.0092, +0.2899, -1.5977, +0.1411, -0.7268, -0.0835, +0.5029, +0.1386, -0.0634, -0.4580, +0.1020, -0.4675, +0.5110, -0.2398, +0.3636, -0.5651, -0.1730, +0.1509, +0.3955, -1.8248, -0.0228, -0.4183, -0.2963, +0.1007, +0.4309, +0.0637, -0.0066, -0.0472, -0.1385, +0.0819, +0.0202, -0.3139, -0.0896, +0.5357, -0.7048, -0.0429, -0.1733, -0.6343, -0.2395, +0.2319, +0.1909, -0.3611, -0.0093, +0.0513, +0.2180, -0.2943, +0.1112, -0.1285, -0.6500, +0.4892, +0.0203, -1.1220, -0.0724, +0.4504],
[ +0.1112, -0.0448, -0.6431, +0.1884, +0.3960, -0.1572, +0.1121, -0.1994, -0.0486, -0.2115, -0.0936, -1.5022, -0.2118, -0.6693, +0.3676, -0.2709, -0.3703, +0.3534, -0.0593, +0.2411, -0.3764, +0.2110, +0.2070, -0.3406, -0.2990, +0.4268, -0.0408, +0.1984, -0.3161, +0.3869, -0.3141, -0.4338, +0.0395, -0.3092, +0.2746, -0.2975, -1.0016, +0.0616, -0.2120, +0.0863, -0.0899, -0.3227, -0.1391, +0.2368, -0.5746, +0.3478, +0.0162, +0.8646, -0.4043, -1.0257, +0.3557, -0.1569, +0.1722, -0.1626, +0.2160, +0.4056, -0.7633, -0.3259, -0.2412, -0.0411, -0.0130, -0.1054, -0.6206, -0.3220],
[ +0.4052, -1.3239, +0.1395, +0.1058, -0.1199, -0.1038, +0.1456, +0.3265, -0.3059, -0.7138, -0.0618, +0.3480, +0.5171, +0.0254, -0.2988, +0.2774, +0.0976, -1.0849, +0.3354, -0.0790, +0.2007, -0.1853, -0.5298, +0.0797, -0.0231, -0.7360, +0.0341, -0.2407, -0.0900, -0.2925, -0.3616, +0.1548, -0.2782, -0.0473, +0.0645, -0.1320, +0.1575, +0.0137, +0.1537, -0.3346, -0.0175, +0.1294, +0.2803, +0.2576, -0.1722, -0.4272, +0.1171, +0.0722, +0.1484, -0.6063, +0.0117, -0.1859, -0.8487, +0.4184, -0.0151, +0.1533, +0.1805, +0.0843, -0.2879, +0.1382, -0.2115, -0.0440, +0.0444, -0.0504],
[ +0.2015, -0.0965, -0.1258, +0.1679, -0.1030, -0.0350, -0.6746, -0.3363, +0.0040, -0.4968, -0.5428, +0.0732, +0.1692, -0.2251, -0.1405, -0.8176, -0.8816, -0.2601, -1.5304, +0.1403, +0.0187, +0.2748, -0.3534, -0.5089, -0.3561, +0.0367, -0.1690, -0.1544, +0.0946, -0.2731, -1.0779, -0.0782, +0.0202, +0.2626, -0.1983, -0.0035, +0.0846, +0.2907, +0.3259, -0.2063, -0.2135, -2.0981, -0.0221, +0.0993, +0.0145, +0.1018, -1.0300, +0.1958, -0.4191, -0.1791, -1.3965, -0.0060, -0.2669, +0.1638, -0.2012, +0.1843, +0.0784, +0.2943, -0.7675, +0.2927, -1.4470, +0.0775, -0.3201, -0.3827],
[ +0.0769, +0.5498, -1.0880, -0.2418, -0.2665, -0.2998, -0.1256, -0.6255, -0.3412, -1.4133, -0.0203, -0.0106, -0.3917, -0.8333, +0.4150, -0.3510, -0.5165, -0.4994, -0.7379, +0.3555, -0.0781, +0.0691, +0.6025, -0.1950, -0.5176, -1.1022, -0.2531, +0.1358, -0.7036, -0.2015, -0.3584, -1.2470, -0.1838, -0.2505, -0.1474, -0.4272, +0.2569, -0.5964, -0.9194, -0.0551, +0.3572, -0.0710, +0.1742, -0.4531, -0.3903, -0.3115, -0.1155, -0.2580, -0.7872, +0.2532, -0.1176, -0.1610, -0.7792, -0.6183, -0.4232, +0.3920, -0.2407, -0.8548, +0.3624, +0.3435, -0.8205, -0.2136, -0.2942, -0.8762],
[ -0.0060, -0.1489, -0.0067, -0.0177, +0.2215, -0.0389, -0.5227, -0.2337, -0.2741, +0.0386, -0.3261, -0.0032, -1.0200, -0.1971, -0.2788, +0.1595, -0.2238, +0.0137, -0.0144, -0.2236, -0.2323, +0.2903, +0.3488, -0.2384, +0.1007, +0.2121, +0.3509, -0.4017, +0.0860, -0.7740, +0.0739, -0.8059, -0.0612, -0.0426, +0.2213, +0.2794, -0.1782, -0.0981, +0.0738, -0.1360, +0.0495, +0.1766, -1.0368, +0.0651, -0.1478, -0.3529, +0.6294, -0.0024, +0.0441, -0.2223, +0.2321, +0.5418, -0.3990, -0.1180, +0.2173, +0.0073, +0.0535, +0.0381, +0.0572, +0.1349, +0.1543, -0.0255, -0.0671, -0.3958],
[ +0.0025, +0.2615, +0.2055, -0.3618, +0.2058, -0.0355, +0.2262, +0.1584, -0.2848, +0.3526, -0.1021, +0.4582, -0.2301, +0.8823, -0.3449, +0.7340, -0.2356, -0.1065, -0.1333, +0.1678, +0.0023, -0.5715, +0.0944, -0.2364, -0.0328, -0.1789, -0.7771, +0.0033, +0.6611, +0.1509, -0.0369, -0.1838, -0.0900, +0.0302, +0.4032, +0.3461, -0.3497, +0.3714, -0.2241, +0.3681, -0.1810, +0.1401, +0.4326, -0.3580, +0.1228, -0.5266, +0.1445, -0.1295, -0.7390, -0.0307, +0.2383, -0.3647, +0.8082, -0.2832, -0.1272, -0.6293, -0.0267, +0.0772, +0.5436, -0.4430, +0.2039, -0.0094, -0.4602, +0.3507],
[ +0.4441, -0.5284, -0.3247, -0.1185, +0.1127, +0.2549, -0.1608, +0.0508, -0.1256, +0.1456, +0.0630, -0.3331, +0.2147, -0.1859, -0.1065, -0.8297, -0.8537, -0.5747, -0.2079, -0.2383, -0.0755, +0.2487, +0.4479, +0.2179, -0.4586, -0.0045, +0.0736, +0.0240, -0.1013, +0.1411, -0.3923, +0.0215, -0.2443, -0.9218, -0.0136, +0.2523, -0.3079, +0.2825, +0.4820, -0.0487, -0.4192, +0.3460, +0.2341, -0.1544, -0.1730, +0.1748, +0.4015, -0.0670, -0.4138, -0.7546, -0.0984, -0.1398, -0.1484, +0.2143, +0.3287, +0.3576, -0.1715, -0.4426, -0.1114, +0.2873, -0.1759, -0.2131, -0.3125, +0.2399],
[ -0.3040, -0.7858, -0.0431, +0.2444, -0.4689, +0.5505, -0.0415, -0.2255, +0.4772, -0.9782, -1.3075, -0.7475, -0.2918, -0.4632, -0.4139, -0.2807, -0.9729, +0.0464, +0.2641, -0.0045, +0.2904, +0.2615, -0.4323, -0.2294, +0.4595, -0.4169, +0.2735, -0.7092, -0.8494, -0.9467, +0.0363, -1.6053, -0.0743, +0.1101, +0.2005, -0.1111, -0.2316, +0.3037, -0.0224, +0.4787, -0.1178, -0.2842, -0.1521, +0.0089, +0.0149, +0.2476, -0.3097, +0.4197, -0.0513, -0.3052, -0.1770, +0.0698, -0.0028, -0.7217, -0.0423, +0.0789, +0.0522, -0.4582, -0.0321, +0.8307, +0.2203, -0.0733, +0.3136, +0.0570],
[ +0.1303, +0.0891, -1.0181, -1.4978, +0.0734, +0.1124, +0.2199, +0.0153, +0.4390, -0.4317, -0.5141, -0.4691, +0.0737, +0.3579, -0.1853, -0.0772, -0.8077, -0.6385, -0.4633, +0.4321, +0.5496, +0.2986, -0.1555, -0.1559, +0.0699, -0.3715, -0.2052, -0.2325, +0.3984, -0.4306, -0.6361, -0.3066, -0.4227, -0.7002, -0.5833, -0.0950, -0.2275, -0.2462, -0.2574, +0.3585, -0.2933, -0.1192, +0.4343, -0.5342, +0.1994, +0.3493, -0.7433, +0.0396, -0.2139, -0.7354, -1.5901, +0.2998, +0.2103, -0.2378, -0.3848, -0.1763, +0.5698, -0.8950, -1.7041, +0.2384, -0.1701, +0.1376, +0.3842, -0.8876],
[ -0.1219, +0.3198, -0.2701, +0.1497, -0.1258, +0.3358, -0.4570, -0.4552, +0.5140, -0.1106, -0.5427, -1.0853, -0.1620, +0.1679, -0.7057, -0.5208, -1.5624, -0.6301, -0.6283, +0.0699, -0.1598, -0.1935, +0.0253, +0.1096, +0.0912, -0.0082, +0.0710, -0.9496, -0.0222, -0.3077, -0.4092, -0.1090, -0.1891, -0.0032, +0.4414, -0.4561, -1.1972, +0.4971, -0.0040, +0.0863, -1.3692, -0.1463, -0.1298, +0.3283, -0.2834, -0.0431, +0.0177, +0.0811, -0.2410, -0.0614, +0.2315, +0.3008, -0.6321, -0.8940, -1.5395, -0.6845, -0.5164, +0.5963, -0.1694, +0.0239, +0.3146, +0.5295, -0.1202, -0.2046],
[ -0.4515, -0.5445, -0.4470, +0.1876, -0.0639, -0.2497, +0.2629, +0.2056, +0.4504, +0.1000, -0.1992, -0.1178, +0.5982, +0.1020, +0.2526, -0.5141, -0.3257, +0.2873, +0.2843, +0.0204, -0.0355, +0.4963, -0.0575, -0.2666, -0.6928, -0.0279, -0.4045, +0.4385, -0.1725, +0.2043, -1.0905, +0.3458, +0.2299, -0.1574, -0.6403, +0.4463, -0.4436, -0.0591, -0.8299, -0.2485, +0.3504, -0.2333, +0.1834, +0.0245, +0.0756, -0.0047, -1.1088, -0.0788, -1.0611, -0.2504, +0.2807, +0.1821, -0.1618, +0.0871, -0.1961, -0.0566, -0.8393, -0.2867, -0.5395, -0.7387, -0.9088, +0.1558, -0.0021, +0.1817],
[ +0.2262, -0.0991, -0.7318, +0.0777, +0.0829, +0.1066, +0.0909, +0.0586, -0.1002, +0.2647, +0.3763, +0.2981, +0.2813, +0.1898, +0.2196, +0.1406, -0.2669, -0.0615, -0.4188, -0.3941, -0.2429, -0.2700, -0.6246, +0.0977, -0.0156, -0.6503, -0.3818, +0.2284, +0.2446, -0.2068, -0.0891, +0.1039, -0.5602, -0.0217, -0.0608, -0.0454, +0.0959, +0.4183, +0.2183, -0.3189, +0.1210, -0.0680, +0.1768, -0.3043, -0.2762, -0.8097, +0.4302, +0.1414, -0.6430, -0.1104, -0.3396, -0.4695, +0.4050, -0.1201, +0.0801, -0.1988, -0.0255, +0.1783, -0.0352, -0.4146, +0.1602, +0.0232, -0.4713, +0.2315],
[ -0.2409, -0.2534, +0.3787, +0.8244, +0.0585, -0.1560, +0.3867, +0.4848, +0.0786, +0.3797, -0.4736, +0.1127, -0.1765, +0.4122, -0.0028, -0.0079, +0.4908, -0.2022, +0.0382, +0.3820, +0.1218, +0.4168, +0.0748, -0.0767, +0.1911, +0.1314, -0.3224, +0.2587, +0.2849, +0.3945, +0.0604, +0.0050, -0.3590, -0.7451, -0.3942, +0.2198, +0.2039, +0.2079, -0.3846, -0.0248, -0.4721, +0.1699, -0.0122, -1.2120, +0.4807, +0.0437, -0.1432, -0.0937, +0.3850, +0.0717, -0.6115, -0.1069, -0.3580, -0.7625, -0.1524, -0.5527, +0.0189, +0.2040, +0.1220, +0.4873, -0.3443, +0.1473, +0.2942, -1.2750],
[ -0.0321, +0.0938, -0.1564, +0.0153, -0.0956, +0.0683, -0.1992, -0.8894, +0.0980, -0.0950, -0.5909, +0.1010, +0.0940, -0.7160, +0.0752, +0.5469, -0.6442, -0.0053, +0.2000, +0.3000, -0.3391, -0.1122, +0.3253, +0.1063, +0.1491, -0.0684, -0.0410, -0.3039, -0.6195, +0.2862, -0.1455, -0.8795, -0.3885, +0.0299, -0.0195, -0.1107, +0.0015, +0.4024, -0.9457, -0.4620, +0.0877, -0.2296, -0.0326, +0.2932, -0.2720, +0.4663, -0.0610, +0.1745, +0.1352, -0.5966, -0.1366, +0.2271, -0.4483, -0.4548, +0.0057, +0.2810, -0.4279, +0.0572, -0.8984, +0.1419, -0.1966, +0.0214, -0.5856, -0.4380],
[ -0.2850, -0.4454, -0.0200, +0.1379, +0.1279, +0.1286, +0.5722, -0.0797, +0.1775, +0.0054, +0.3466, -1.1324, +0.0630, -0.0436, -0.9319, +0.0692, +0.1615, -0.1780, +0.1783, +0.0662, +0.2824, -0.0309, -0.1921, +0.2110, -0.2472, +0.0026, +0.3590, -0.1833, -0.0167, -0.6163, -0.1092, +0.2120, +0.4458, +0.0250, -0.8406, -0.0331, +0.3448, -0.5886, -0.0235, +0.0602, +0.3971, +0.4033, +0.3516, -0.1472, -0.2371, -0.8047, +0.1336, -0.1083, -0.5510, +0.3792, -0.4230, -0.1216, -0.7740, -0.4497, -0.2848, -0.3698, -0.0160, +0.5724, -0.4150, +0.3254, -0.2344, +0.4417, +0.0460, -0.0463],
[ -0.1091, -0.0947, -0.3343, -0.8910, -0.0137, +0.1534, -0.3422, -0.5111, +0.0206, +0.2841, +0.2981, +0.3313, +0.2598, -0.0501, -0.5783, +0.3304, -0.2725, +0.1159, -0.2722, -0.5441, +0.2231, -0.0244, +0.3478, +0.1623, -0.2798, -0.0695, +0.3506, -0.1275, +0.2209, -0.3317, -0.2965, +0.4564, -0.2473, -0.3701, +0.4166, -0.1918, +0.0488, +0.5048, +0.4159, -0.1447, +0.0998, +0.0424, +0.0734, -0.3713, +0.3236, -0.4136, -0.2221, +0.1728, -0.6407, +0.2623, -0.4332, +0.4175, +0.2960, -0.3424, -0.5264, -0.5679, +0.2437, -0.6032, -0.5213, -0.0424, -0.5911, -0.0611, -0.1877, +0.2423],
[ -0.0360, -0.4567, -0.1493, -0.0765, -0.2676, +0.1338, +0.1486, +0.3867, +0.2451, -0.2054, -0.1088, -1.5518, +0.2254, +0.0175, -0.1154, -0.3777, -0.6173, -0.8897, -0.1523, +0.1594, -0.1772, -0.3349, -0.1155, -1.1580, +0.2605, +0.0570, +0.1894, -0.0755, +0.2382, -0.1726, -0.0400, +0.4391, +0.2241, +0.0551, -0.1106, +0.0817, +0.0128, -0.1330, -0.0162, -0.3872, -0.2613, -0.2073, +0.0483, +0.0026, -0.1008, -0.0389, -0.6723, -0.0657, +0.1532, -0.0627, -0.2517, -0.1961, -0.0313, -0.2694, +0.1040, +0.2662, -0.3370, +0.2086, -0.2202, +0.2812, -0.9275, -0.0331, +0.1384, -0.4651],
[ -0.0323, +0.5816, +0.2069, +0.1766, +0.8736, -0.1321, -0.5366, +0.4362, -0.9437, +0.5586, +0.8281, +0.1417, +0.4988, +0.2451, -0.1327, +0.3295, +0.1639, +0.2168, -0.5869, -0.9139, +0.3259, -1.2364, +0.0104, -0.4723, -0.2869, -0.0693, -0.1767, +0.0528, +0.3629, +0.0766, -0.2554, +0.7631, +0.0007, +0.3657, +0.2479, +0.0949, -0.1070, +0.2789, -0.6009, +0.3627, -0.1986, +0.3212, +0.5274, +0.2307, +0.1055, -0.8864, +0.4670, +0.0430, -0.2485, +0.0445, -0.0792, +0.0362, -0.7101, -0.1554, +0.4530, -0.5127, -1.0097, -0.4877, +0.1803, +0.1016, +0.2774, -0.7071, -0.2316, +0.1476],
[ +0.0676, -0.2920, +0.4224, -0.1409, +0.0856, -0.0969, +0.2461, -0.7079, -0.4348, -0.8510, -0.2213, -0.0541, -0.0461, -0.2451, +0.2312, -0.0496, +0.3432, -0.1916, +0.1832, +0.4089, +0.1642, -0.0928, +0.1869, +0.2472, -0.9379, -0.0356, -0.2276, -0.1867, -0.1108, +0.3021, -0.7620, -0.0141, +0.3072, -0.0326, -0.1854, -0.0535, +0.3489, -0.3910, -0.8369, +0.5177, +0.3154, +0.6535, -0.4463, -0.4381, -0.2189, +0.2761, +0.1655, +0.1010, -0.0769, -0.5381, -0.4710, +0.1980, -0.0818, -0.3762, +0.0076, +0.1753, -0.0984, -0.5887, -0.0019, -0.4983, +0.2914, -0.7693, +0.1656, -0.6165],
[ +0.2126, -0.3435, -0.2802, +0.0979, -0.9373, -0.7181, +0.2063, -0.2545, +0.3562, +0.0894, +0.5294, -0.3816, +0.5833, -0.2488, -0.4786, +0.2132, -0.3223, +0.2189, +0.2034, +0.0680, +0.3741, -0.2337, -0.2645, -0.2871, -0.3461, +0.3580, -0.7551, -0.4948, -0.4941, -0.1607, -0.0062, +0.3991, +0.5354, -0.1153, +0.4384, +0.2346, +0.0923, +0.6214, +0.2485, -0.2547, -0.2755, +0.3398, +0.2522, +0.0409, +0.1309, -1.1476, +0.4321, -1.6605, -0.6035, -0.5415, -0.0799, -0.1754, -0.5326, -0.1910, +0.1372, -0.4079, -0.3110, +0.0060, +0.0015, -0.7618, +0.5021, -0.3054, -0.1895, +0.4327],
[ +0.1316, +0.1998, +0.0677, +0.2773, -0.2720, -0.8087, -0.0022, -0.2622, -1.0104, -0.4908, +0.4249, +0.0597, -0.5553, -0.4698, -0.0096, -0.1893, +0.1355, -0.6921, +0.0211, +0.3253, -0.0769, +0.0565, -0.6166, -0.7295, +0.0477, -0.0101, -0.5214, -0.6498, -0.7418, -0.8979, +0.0792, -0.1958, -0.5255, +0.1953, -0.6446, -0.0748, -0.3183, +0.1582, -0.3667, +0.2170, +0.2665, -0.0075, +0.0740, +0.2708, -0.1289, +0.0462, -0.6262, -0.4190, -0.1797, +0.3994, -0.8803, -0.4579, -0.3235, +0.2903, -1.3589, -0.5549, -0.6767, +0.0308, +0.0491, -0.3117, +0.2053, +0.1075, +0.2042, -0.4537],
[ -0.9114, +0.3823, -0.2137, -0.0383, +0.0891, -0.5047, -0.3632, -0.0115, -0.3604, +0.2107, -0.4123, -0.1508, -0.3897, -0.1566, -0.3869, +0.0458, -0.3594, -0.6799, -1.0821, -0.2322, +0.1464, +0.2626, -0.1674, -0.5577, +0.0910, -0.1279, +0.4003, -0.1568, +0.0907, -0.1528, -0.0554, +0.4973, +0.3610, +0.3540, +0.3717, -0.2353, +0.1743, +0.2026, +0.8891, -0.5409, -0.3690, +0.1897, -1.1785, -0.0244, +0.0283, +0.0709, -0.9182, -0.1485, +0.3410, -0.3562, +0.1126, +0.3459, +0.0190, +0.4073, -0.0685, -0.0834, +0.1817, +0.3957, +0.3428, +0.2351, -0.2072, -0.2002, +0.0579, +0.2585],
[ +0.0476, -0.7260, -0.2175, -0.8305, +0.3673, -0.1075, -0.7324, +0.1022, -0.1264, +0.0679, -0.2494, +0.2647, -0.7667, +0.1632, -0.1487, -0.1800, -0.4566, -0.4716, +0.3124, +0.4227, -0.2557, +0.1477, -0.0946, +0.0803, +0.0136, +0.0699, -0.6304, +0.5944, +0.1812, -0.0072, -1.2447, +0.7503, -0.7340, -0.6389, -0.0202, +0.1716, -0.0661, -0.7511, -0.6451, +0.4344, +0.2398, +0.9628, -0.2201, +0.1901, +0.6633, -0.0529, -0.3787, +0.3837, -0.4481, +0.1792, -0.2828, +0.7377, +0.6304, -0.9296, +0.1690, +0.5375, +0.3884, -0.3548, +0.0788, -0.7348, +0.2273, -0.5028, -0.4739, +0.1150],
[ +0.1521, -0.0100, -0.1015, +0.1975, -0.5804, -0.0891, +0.4443, -0.0275, -0.3218, -0.3674, -1.0237, -0.9589, +0.1408, +0.1039, -0.4158, -0.3465, -0.2163, +0.3031, -0.0905, -1.1000, +0.0028, +0.1196, +0.1130, +0.4777, -0.0803, -0.3295, -1.5273, -0.4059, -0.2642, -0.6425, +0.1149, -0.0094, +0.1067, -0.6440, -0.0806, +0.2513, +0.2070, -0.0682, -0.0854, -0.4654, +0.0119, -0.2918, +0.0766, -0.0766, +0.0621, -0.5751, -0.7636, -0.4295, -0.1413, +0.0667, -0.0193, +0.0210, +0.1867, +0.1727, -0.0391, -0.5251, -0.0746, +0.0615, -0.0581, -0.4284, -0.2977, -0.0883, -0.1302, +0.1829],
[ -0.1256, +0.0829, -0.5799, -1.0012, +0.3669, +0.2700, +0.2691, -0.2078, +0.6662, +0.4342, -0.7014, +0.1332, +0.0736, +0.5960, +0.1266, +0.4412, -0.3859, +0.0702, -0.7489, -0.1285, +0.1080, -0.0248, -0.0614, -0.2922, -0.1791, +0.2619, -0.2986, +0.1326, -0.1112, -0.4128, -0.3499, -0.2148, +0.0886, -0.3239, +0.1767, +0.2782, -0.1033, -0.1350, +0.0324, -0.2402, +0.2440, +0.2858, +0.0111, -0.6319, +0.3694, -0.5569, +0.0758, -0.5506, -0.8423, -0.6073, -0.0642, +0.0559, +0.3943, -0.1092, -0.3964, +0.0705, -0.3753, +0.2106, -0.0118, -0.2122, -0.0904, +0.3428, -0.2614, -0.0007],
[ +0.3415, +0.4062, -0.4667, +0.2757, -0.5389, -0.1429, -0.0005, +0.1749, -0.1646, -0.9262, +0.1978, -0.3748, +0.3384, +0.1757, -0.0899, +0.1567, +0.3043, -0.0828, -0.7369, +0.2833, +0.2871, -0.0150, -0.0895, +0.2181, -0.3692, -0.2344, -0.3813, -0.4984, +0.2426, +0.3936, -0.3995, -0.0257, -0.2650, -0.5329, -0.6254, +0.0492, -0.0428, +0.3595, -0.1242, -0.3341, -0.1174, +0.2283, +0.3051, -0.0794, -0.0715, +0.2324, +0.1567, -0.4121, +0.0756, -0.6483, -0.7294, -0.0235, -0.5082, -0.1506, -0.0962, +0.1123, +0.1990, -0.5521, -0.8837, +0.2634, -0.6452, +0.0470, +0.0747, +0.0456],
[ -1.2951, +0.1232, -0.8490, +0.2284, +0.3593, -0.9968, +0.1914, +0.3673, +0.1287, +0.0485, -0.6153, -0.6149, -0.2634, -0.7023, +0.2006, +0.2657, -0.0201, -0.6250, -0.1045, -0.5447, -0.2495, -0.0712, -0.2281, -0.1573, -0.0079, -0.4966, -0.5428, -1.5871, -0.0332, -0.3754, +0.0438, -0.2096, -0.0341, -0.2111, -0.1953, -0.1146, +0.0260, -0.0840, -0.9739, +0.0693, +0.1628, -0.6525, -0.9299, +0.1602, -0.0673, -1.1183, -1.1446, -0.0575, +0.0123, +0.0463, +0.0683, +0.0192, -0.7718, -0.1055, -0.1894, +0.3897, -0.8589, +0.2829, +0.0774, -0.1157, +0.0772, +0.0168, +0.3460, +0.2657],
[ -0.3160, +0.3029, +0.2132, -0.2024, -0.0573, +0.2263, +0.3686, -0.2059, +0.2531, -0.4922, -0.4110, -0.0881, -0.0267, -0.3069, +0.2496, -0.2458, -0.0348, -0.4285, +0.0564, +0.5539, +0.3510, +0.0755, +0.2656, +0.5299, -0.0647, +0.0431, +0.3277, +0.0192, -0.3490, +0.2500, +0.2519, +0.2055, +0.2462, -0.2927, +0.2902, -0.1451, -0.0611, -0.3940, -0.6985, +0.0295, -0.1272, -0.0507, +0.0030, -0.0484, -0.4220, +0.3042, -0.1346, -0.4380, +0.0247, -0.2205, -0.1549, -0.7229, -0.1487, -0.1124, +0.2539, +0.1274, +0.6169, +0.3346, -0.1577, +0.4318, +0.1469, -0.0689, +0.0982, -0.3816],
[ +0.4151, +0.1020, -0.3973, -0.1940, -0.0893, -0.5294, -0.0714, +0.1221, +0.2081, -0.1500, +0.0839, +0.0651, +0.1602, +0.1521, +0.3755, +0.4533, -0.0749, -0.1498, +0.0048, +0.2987, +0.3013, -0.2483, -0.8249, +0.1123, -0.2657, -0.0776, -0.8314, -0.0567, +0.4846, +0.1280, -0.4166, +0.2149, -0.5095, -0.2219, -0.6757, +0.5484, +0.2117, +0.1901, -0.3840, -0.0860, -0.0527, -0.8445, +0.1747, -0.7124, +0.3261, -0.0172, -0.4794, +0.2829, -0.9583, -0.3825, -0.2641, -0.1610, +0.0921, +0.0395, -0.7542, -0.4747, +0.0891, -0.5037, +0.4109, +0.2718, -0.1609, +0.3680, -0.2975, +0.0092],
[ -0.2679, -0.2103, +0.1004, +0.2703, +0.0541, +0.4900, +0.1016, +0.0008, -0.0075, +0.0959, -0.2459, -0.4452, +0.1211, -0.0521, -0.5468, +0.2349, -0.0690, +0.0936, -0.3218, -0.0093, +0.0644, +0.4158, +0.1109, +0.2373, +0.3008, -0.2570, +0.2886, -0.1720, +0.3146, -0.6991, +0.2565, -0.1762, -0.0239, -0.6296, -0.8216, -0.8141, +0.0871, -0.5981, +0.2595, +0.2109, -0.3252, -0.2758, +0.2662, -0.1662, +0.0087, -0.3265, +0.2910, -0.3716, +0.3225, +0.0907, +0.0550, +0.4069, +0.3731, -0.0367, -0.0844, -0.7320, +0.3318, +0.0839, +0.1493, -0.1054, -0.4476, +0.0671, +0.3858, -0.3728],
[ -0.0163, +0.4856, -0.1412, -0.0100, -0.2343, +0.1223, -0.5244, -0.4046, +0.1738, -0.0262, +0.0922, -0.6767, +0.2672, +0.1770, -0.4969, +0.3919, -0.1103, -0.3749, +0.2580, -0.0209, -0.2500, -0.1089, +0.0587, +0.4735, +0.2116, +0.0299, +0.1709, +0.0804, +0.8460, +0.1637, +0.1775, -0.3955, +0.2403, -0.1843, +0.0579, -0.3362, +0.1129, +0.2148, -0.0079, -0.0662, -0.1286, +0.1830, +0.0437, +0.0167, -0.0824, -0.1148, +0.2380, -0.3372, -0.0684, -0.3226, +0.2914, +0.0994, -0.1599, +0.0130, +0.1584, +0.0975, +0.2723, +0.1877, -0.4828, +0.1463, -0.2304, +0.3497, +0.0522, -0.0404],
[ +0.3846, +0.3960, +0.0721, -0.5932, -0.6720, +0.3994, -1.1131, +0.0500, -0.0433, -0.5014, -0.2795, +0.0226, -0.0276, -0.3389, -0.1971, +0.3228, -0.3439, +0.5770, +0.5260, -0.2861, +0.3810, -0.0225, +0.3133, +0.1716, +0.0778, -0.1298, +0.0765, -0.1700, +0.5689, +0.2767, -0.5815, +0.2572, -0.7600, -0.1481, +0.2901, -0.4648, +0.1381, +0.2972, -0.4802, -0.6701, -0.6240, -0.0784, -0.0330, -0.5339, +0.1989, +0.2422, +0.0886, -0.1819, -0.2638, +0.0189, -0.1023, +0.3559, +0.2563, +0.0272, -0.1343, +0.2034, +0.6096, -0.2862, -0.2925, +0.1162, -0.5740, -0.4293, -0.1544, -0.3657],
[ -0.1666, -0.5683, +0.3239, +0.0008, -0.0790, +0.0108, +0.1210, +0.2313, -0.0242, -0.3114, +0.1546, -0.0983, -0.1095, -0.5754, +0.1360, -0.7269, +0.0714, -0.9205, +0.2401, +0.0983, +0.1060, +0.0410, +0.2889, -0.7942, +0.3511, +0.1338, +0.1118, +0.1873, -0.4490, +0.2648, -0.1163, +0.1410, -0.0005, -0.0627, +0.2816, -0.0261, +0.0111, -0.3929, -0.3200, +0.3405, +0.1021, -0.0294, +0.2000, -0.2919, -0.2395, +0.1867, +0.1548, -0.0702, +0.0021, +0.5599, -0.2662, -0.4859, -0.1809, +0.2777, +0.2588, +0.1977, +0.0975, -0.3367, -0.1211, +0.1057, -0.0247, +0.4044, +0.4802, -0.4940],
[ -0.3074, +0.2169, +0.0655, -0.3575, +0.2765, -1.0735, +0.3228, -0.7085, -0.1075, -0.1250, +0.1302, -0.2700, -0.6832, -0.0223, -0.5448, +0.3824, -0.5548, +0.2615, -0.4700, +1.0847, -0.0443, -0.9753, +0.1278, +1.0526, +0.7114, +0.2395, +0.1612, -0.3276, +0.3154, +0.4751, -0.3890, -0.2353, +0.6575, -0.1306, -0.4566, -0.3303, +0.6051, -0.1868, -0.9390, -0.3405, +0.3341, +0.5198, +0.0939, -0.6396, -0.0410, -0.0942, -0.4784, -0.6260, -0.0983, -0.3750, -0.1402, -0.0351, +0.0890, -0.5765, +0.3816, -0.5375, +0.6580, +0.0448, -0.3544, +0.1669, +0.0808, -0.4698, +0.0085, +0.5292],
[ -0.1747, -0.5134, +0.1257, +0.6530, +0.3251, +0.0013, +0.8608, -0.6414, +0.3327, -0.3861, +0.5066, -0.8033, +0.1957, -0.2380, -0.1649, -0.0760, -0.3093, -0.3283, +0.0661, -0.1066, +0.3787, -0.3254, +0.5536, -0.4949, +0.1560, +0.1118, +0.1465, +0.3107, +0.5213, +0.1194, +0.2602, +0.0551, -0.0612, +0.1378, -0.1037, +0.5086, -0.3383, -0.2024, -0.1786, -0.2193, -0.3955, -0.0600, +0.4502, -0.0450, -0.3765, -0.9599, +0.2312, +0.0751, -0.1329, +0.1573, -0.2891, -0.0944, -0.4619, +0.3256, +0.2486, -0.2238, +0.2054, -0.1677, -1.2201, +0.2986, +0.5681, +0.0700, -0.0916, +0.3844],
[ +0.5860, +0.1473, -0.3536, +0.1924, -0.1819, +0.3126, -0.3094, +0.4127, -0.3403, -0.3101, +0.4899, +0.3310, +0.3136, -0.1343, +0.1557, +0.0007, +0.0431, -0.0531, -0.3300, +0.3820, -0.3771, -0.6818, -0.4023, -0.1221, -0.0995, +0.1512, -0.2698, -0.0544, +0.0406, +0.0104, +0.2382, +0.0113, +0.5360, +0.3837, +0.0947, +0.4839, +0.0278, -0.4629, -0.1912, -0.7728, -0.0162, +0.5847, +0.1752, +0.1536, -0.3113, -0.4624, -0.2032, -0.2410, -0.0095, -0.3411, -0.2375, -0.3024, -0.0689, +0.0134, -0.2987, +0.2678, +0.1053, +0.3568, -0.3776, -0.0956, +0.1105, +0.1802, +0.3608, +0.2763],
[ -0.0126, -0.1275, +0.1721, -0.1653, +0.0189, -0.0586, +0.1487, +0.2661, -0.0924, -0.1733, +0.0411, +0.1124, -0.0426, -0.0405, +0.0713, -0.1322, +0.1053, +0.2013, +0.2442, -0.4979, +0.3654, -0.2099, +0.0049, -0.6743, -0.1063, -0.1213, +0.2036, +0.2109, -0.2639, +0.1839, +0.3105, -0.0961, +0.3935, +0.1186, -0.0959, +0.5348, -0.3605, -0.6159, -0.3268, +0.1327, +0.5812, -0.4447, -1.8573, +0.1350, -0.0151, +0.1569, +0.0348, +0.2221, -0.6421, -0.2810, +0.1918, -0.1290, +0.0505, +0.0517, +0.0313, -0.0781, +0.1746, +0.0713, +0.2894, -1.0579, -0.1106, +0.3800, -0.6895, -1.1236]
])

weights_dense2_b = np.array([ +0.1534, -0.0356, +0.0392, +0.0272, +0.0733, +0.2141, -0.0432, -0.0479, -0.1264, +0.1456, +0.2103, -0.0233, +0.2320, -0.0525, +0.1808, +0.1565, -0.0347, -0.0719, -0.2635, -0.1948, -0.1301, +0.0453, -0.0722, +0.0875, +0.3780, +0.1023, +0.1012, +0.3150, +0.1801, +0.1941, +0.2014, +0.1381, +0.1411, -0.0371, -0.0987, +0.1987, +0.1015, -0.2282, +0.0072, -0.0800, +0.0323, +0.1198, +0.2822, +0.0090, -0.1950, +0.0864, +0.2694, -0.0746, +0.2193, +0.1658, +0.0712, -0.1185, +0.1351, +0.1331, +0.3542, +0.1543, +0.1557, -0.0575, +0.0659, -0.0090, -0.1502, +0.0665, +0.1853, -0.0413])

weights_final_w = np.array([
[ +0.5409, +0.1061, +0.1214, +0.0961, -0.0304, +0.2028],
[ +0.3719, +0.0252, -0.1683, +0.1448, +0.0874, -0.0254],
[ -0.1174, +0.2622, -0.1514, -0.2936, -0.1060, -0.5701],
[ +0.0623, +0.0379, -0.0004, -0.3542, -0.0684, -0.2670],
[ +0.0487, +0.0638, -0.5099, -0.1448, -0.0639, +0.1894],
[ -0.3975, -0.1887, +0.2938, -0.0159, +0.1679, +0.5848],
[ +0.1560, -0.0012, -0.0360, -0.2195, -0.3875, +0.0259],
[ -0.0942, -0.0268, -0.1722, -0.0594, -0.0527, +0.5528],
[ +0.1087, -0.3823, -0.1868, -0.0919, +0.2626, +0.2375],
[ +0.0054, -0.1016, -0.3405, +0.4056, +0.0899, +0.0129],
[ -0.0055, +0.1361, +0.2055, +0.6780, +0.0250, -0.0961],
[ +0.0586, +0.7423, -0.0014, +0.1401, +0.4564, +0.5103],
[ -0.1461, +0.1129, +0.2607, +0.3828, +0.2286, +0.0225],
[ -0.0789, +0.0790, -0.1576, +0.3564, +0.4390, +0.2671],
[ +0.2657, +0.0888, -0.2312, -0.1819, -0.1583, -0.1158],
[ -0.0429, +0.1533, -0.0649, +0.1670, +0.5324, +0.2681],
[ +0.1750, +0.0582, -0.1742, +0.7826, -0.0295, -0.0646],
[ +0.1563, +0.0241, -0.4052, +0.5419, +0.0212, -0.1529],
[ +0.1667, -0.0708, +0.0750, +0.0286, +0.2312, -0.2932],
[ -0.0755, +0.3814, -0.3422, -0.3412, +0.0820, -0.6145],
[ -0.0485, -0.1721, -0.1366, -0.0866, +0.0972, +0.4096],
[ -0.0026, -0.3586, -0.0705, -0.0509, +0.0127, +0.3078],
[ +0.1658, -0.2918, -0.4419, -0.1099, -0.1852, -0.0318],
[ +0.3883, -0.1925, -0.3671, -0.3079, -0.1405, -0.6695],
[ -0.3967, -0.1212, +0.2062, -0.4248, +0.2445, +0.5061],
[ +0.2296, +0.0054, +0.1389, +0.1225, -0.2944, -0.3264],
[ -0.3366, -0.1053, +0.1004, +0.0522, -0.2441, -0.1599],
[ +0.3214, +0.3230, -0.3416, +0.1735, -0.0354, +0.0172],
[ -0.0715, -0.0971, +0.2212, +0.0870, +0.4960, +0.0409],
[ +0.6941, +0.1916, +0.4534, -0.3305, -0.1206, +0.2755],
[ -0.0466, +0.2676, -0.2066, -0.2910, +0.0603, +0.1708],
[ +0.3716, +0.1599, -0.1473, +0.0362, -0.0572, +0.4125],
[ +0.0225, -0.1431, +0.3085, -0.1022, -0.3053, -0.3167],
[ +0.1484, +0.3096, +0.2186, -0.2676, +0.2821, -0.0416],
[ +0.2600, -0.1355, +0.1571, -0.4409, +0.1009, +0.1011],
[ +0.2334, +0.3423, -0.0794, +0.0448, -0.0112, -0.0245],
[ -0.3402, +0.1981, -0.0945, +0.1727, -0.0363, -0.1486],
[ -0.4074, -0.1319, +0.0434, +0.4359, -0.2658, -0.3302],
[ +0.2756, -0.2130, -0.2856, -0.1436, -0.4224, +0.1142],
[ -0.1194, +0.2529, -0.2741, -0.0691, -0.2947, -0.0033],
[ -0.0449, +0.4437, -0.0389, +0.1377, +0.1102, -0.1049],
[ +0.4368, +0.1699, +0.3433, -0.4160, -0.3043, +0.1180],
[ -0.1328, -0.6681, +0.4017, +0.3457, +0.1843, -0.0134],
[ +0.0630, +0.2032, +0.2331, -0.1384, -0.1024, +0.3183],
[ +0.1946, +0.1460, -0.1598, -0.2830, +0.2411, +0.3073],
[ +0.4296, -0.2071, +0.3769, +0.0840, -0.0062, -0.1579],
[ -0.0790, -0.1186, +0.0962, +0.4871, -0.2901, +0.6272],
[ -0.2573, +0.3325, +0.1097, -0.2340, -0.0787, +0.1208],
[ -0.4469, -0.3637, -0.1740, -0.4408, +0.0512, +0.5575],
[ +0.1426, -0.3975, -0.0685, -0.0452, -0.4517, +0.4320],
[ -0.5925, +0.3324, -0.1968, -0.2537, +0.6491, -0.2922],
[ -0.2201, -0.3118, -0.3722, +0.0216, +0.1670, -0.1343],
[ +0.0638, -0.2374, -0.1480, +0.4090, +0.2347, +0.1456],
[ -0.0656, +0.1516, -0.3281, -0.2661, +0.0645, +0.0550],
[ +0.3725, +0.2281, +0.3031, +0.0774, -0.3138, +0.0967],
[ +0.3016, +0.0322, +0.0556, -0.0571, -0.1177, -0.2442],
[ -0.2769, -0.5119, -0.0336, -0.1588, +0.0503, -0.2331],
[ +0.1518, +0.4363, +0.0093, -0.3960, -0.1347, +0.2931],
[ +0.1897, -0.0655, +0.1977, +0.4321, +0.6998, -0.0863],
[ +0.0391, -0.0305, +0.3576, -0.4996, -0.0640, -0.0039],
[ +0.2922, +0.3815, +0.2834, +0.1990, -0.0568, +0.2077],
[ -0.5371, +0.2796, +0.2952, +0.1182, +0.0523, -0.2151],
[ -0.5111, +0.2231, -0.1034, +0.0479, -0.0543, +0.0605],
[ +0.0822, -0.4530, -0.0345, +0.1621, -0.2487, +0.1516]
])

weights_final_b = np.array([ +0.1367, +0.1107, -0.0148, +0.1158, -0.0820, +0.3047])

if __name__=="__main__":
    main()
