# Installing BSD Owl Scripts

## Requirements

BSD Owl Scripts v2.2 works at least in the following
environments:

- FreeBSD 9.0+ and the base system program `make`;
- Mac OS X 10.5+ and the base system program `bsdmake`;
- Mac OS X 10.4 and the base system program `bsdmake`;
- Debian Jessy and the third-party program `bmake`.

Some special features require extra software being installed on the
system where BSD Owl Scripts is used.  This is advertised in
the corresponding documentation.


## Site-wide installation procedure

First of all, acquire the latest tarball `bsdowl-2.2.tar.xz`
and its signature `bsdowl-2.2.tar.xz.sig` that you should
verify.  Point a root shell to the directory containing the tarball:

    # tar xjf bsdowl-2.2.tar.xz
    # cd bsdowl-2.2

You now have to choose an installation prefix, say `/usr/local`, where
the directives and a few helper scripts are installed:

    # ./configure --prefix=/usr/local
    # make all
    # make install

Ensure that `/usr/local/bin` is listed in the path for each system
user.  Ensure that `/usr/local/share/mk` is listed in the search path
for your compatible make program, this is usually done by adding the
line

    .MAKEFLAGS: -I/usr/local/share/mk

To the file `/etc/make.conf`.


## User-specific installation procedure

First of all, acquire the latest tarball `bsdowl-2.2.tar.xz`
and its signature `bsdowl-2.2.tar.xz.sig` that you should
verify.  Point a user shell to the directory containing the tarball:

    $ tar xjf bsdowl-2.2.tar.xz
    $ cd bsdowl-2.2
    $ ./configure --prefix=${HOME}
    $ make all
    $ make install

Ensure that `${HOME}/bin` is listed in your path and that the
`MAKEFLAGS` variable contains the word `-I${HOME}/share/mk`.  If you
are using `bash` or `sh` you can achieve this by appending the lines

	PATH="${HOME}/bin:${PATH}"
	MAKEFLAGS="${MAKEFLAGS}${MAKEFLAGS:+ }-I${HOME}/share/mk"
	export PATH
	export MAKEFLAGS

to your `~/.profile` or `~/.bashrc` file, depending on your
configuration.  If you are using tcsh you can achieve this by
appending the following lines

	set -f path = ( $path $HOME/bin )

	if ( $?MAKEFLAGS ) then
	    set makeflags = ( $MAKEFLAGS )
	else
	    set makeflags = ()
	endif

	set -f makeflags = ( $makeflags "-I${HOME}/share/mk" )
	setenv	MAKEFLAGS	"$makeflags"
	unset makeflags

to your `~/.cshrc` or `~/.tcshrc`, depending on your configuration.
These two suggestions will work in typical cases but a special
configuration will require arrangements.
