# Welcome to BSD Owl Scripts wiki!

BSD Owl Scripts is a small group of BSD Make directive
files. Modules are written in the spirit of FreeBSD's project
files.

This collection of BSD Make directives can be used to create workflows
including the following activities:

- preparation and publication of TeX documents;
- development of TeX macros with NOWEB;
- development of OCaml software;
- maintainance of a FreeBSD workstation configuration files;
- preparation of a static website with ONSGMLS.

The documentation wiki is not only a [[UserManual]] but also a
[[DeveloperManual]], a [[RecipeBook]] and a [[Community]].  The `README.md`
contains instructions to [[Download]] and [[Install]] and your are
now probably interested in [[GettingStarted]].

## Using BSD Owl Scripts

- Learn to [[ProduceLaTeXDocuments]] documents, with support for
  METAPOST figures, bibliographies, and documents spreading acroess
  several files or directories (like a thesis).

- Useful scripts support you if you [[DevelopOCamlSoftware]] taking
  care of the compilation of programs, libraries and toplevels.
  Dependencies are automatically generated with `ocamldep` and
  parallel builds are supported.

- As a UNIX user you are likely to [[DevelopShellScripts]] or to have
  several [configuration files](ManageDotFiles) so we help
  you taking care of them.


## Wiki features

This wiki uses the
[Markdown](http://daringfireball.net/projects/markdown/) syntax for
document preparation and [Creole](http://www.wikicreole.org/) as a
wiki engine.

The wiki itself is actually a git repository, which means you can clone it, edit it locally/offline, add images or any other file type, and push it back to us. It will be live immediately.

Go ahead and try:

```
$ git clone https://michipili@bitbucket.org/michipili/bsdowl.git/wiki
```

Wiki pages are normal files, with the .md extension. You can edit them locally, as well as creating new ones.

## Syntax highlighting


You can also highlight snippets of text (we use the excellent [Pygments][] library).

[Pygments]: http://www.pygments.org/


Here's an example of some Python code:

```
#!python

def wiki_rocks(text):
    formatter = lambda t: "funky"+t
    return formatter(text)
```


You can check out the source of this page to see how that's done, and make sure to bookmark [the vast library of Pygment lexers][lexers], we accept the 'short name' or the 'mimetype' of anything in there.
[lexers]: http://pygments.org/docs/lexers/


Have fun!
