# Description of packages

## Package identification

PACKAGE
 The name of a package.

   It must be a sequence of characters [-+_A-Za-z0-9].


VERSION
 The version of a package.

   It should have the form MAJOR.MINOR.PATCHLEVEL or
   MAJOR.MINOR.PATCHLEVEL-IDENTIFIER (for pre-releases).


OFFICER
 The release engineering officer.

  This is the GPG identity used to sign the tarballs.


## Environment

PREFIX
 The installation prefix of the package

  Ususally /usr /usr/local /opt/local or /home/joeuser. It must be set
  at configuration time.

DESTDIR
 A directory to prepend to PREFIX, only when copying files.

  Usually not set. Useful to install in a filesystem whose root is not
  the root of the full filesystem.

Other directories, à la GNU.

MAKEOBJDIR
 The location where build products should be placed.

  We want to support three settings:
  - the dirty setting where objects are stored in the source tree
  - the flat setting where objects are stored in a
    package/configuration/architecture specific directory
  - the hierarchichal setting where objects are stored in a
    packge/configuration/architecture specific file hierarchy replicating
    the source tree.

  Make this setting CONFIGURATION dependant.

Issue-preparation: Describe OBJDIR settings
                    (Also their relation to CONFIGURATION.)
Issue-preparation: Prepare issues to implement each setting and their

## Installation method

Credential switch with su, sudo.

  Should we support jails, chroot, ssh? It is probably not a serious
  limitation to require users to log on the remote host and perform
  there an actual installation.

  Note that some systems do not have a root suser (e.g. Cygwin), this
  should be detected at configuration time. See #60.

## Build Configuration

A *build configuration* or *configuration* is a name like `Debug` or
`Release` which is used to read a file under Library/Configuration
where compilaton flags can be adjusted.

A target archtecture can also be specified for tools supporting
cross-compilation. This is done using a target triplet (actually 4let)
as described by Autotools.

CONFIGURATION
 The name of the configuration used

ARCHITECTURE
 The name of the build architecture

 This variable identifies the architecture for which the package is
 being built.

The variables

	ARCHITECTURE_CPU
	ARCHITECTURE_VENDOR
	ARCHITECTURE_SYSTEM
	ARCHITECTURE_KERNEL

are automatically filled. Leaving ARCHITECTURE undefined or setting it
to `native` will fill the four other variables to describe the current
host. The predicate

	ARCHITECTURE_IS_NATIVE

is always defined and it is set to `yes` iff the architecture is the
native architecture.  The set of possible architectures is determined
during the configuration of `bsdowl` and stored in the variables

	ARCHITECTURE_AVAILABLE_CPU
	ARCHITECTURE_AVAILABLE_VENDOR
	ARCHITECTURE_AVAILABLE_SYSTEM
	ARCHITECTURE_AVAILABLE_KERNEL

The native architecture is determined during the configuration of
`bsdowl` and is stored in the variables

	ARCHITECTURE_NATIVE
	ARCHITECTURE_NATIVE_CPU
	ARCHITECTURE_NATIVE_VENDOR
	ARCHITECTURE_NATIVE_SYSTEM
	ARCHITECTURE_NATIVE_KERNEL

Some languages can run on one or several virtual machines.  