
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/elem.hpp>
#include <boost/vmd/equal.hpp>
#include <boost/vmd/not_equal.hpp>
#include <boost/detail/lightweight_test.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS
 
 #define BOOST_VMD_REGISTER_AN_ID1 (AN_ID1)
 #define BOOST_VMD_REGISTER_AN_ID2 (AN_ID2)
 
 #define BOOST_VMD_DETECT_AN_ID1_AN_ID1
 #define BOOST_VMD_DETECT_AN_ID2_AN_ID2
 
 #define AN_IDENTIFIER1 AN_ID1
 #define AN_IDENTIFIER2 AN_ID2
 #define AN_IDENTIFIER3 AN_ID1
 
 #define A_NUMBER1 33
 #define A_NUMBER2 145
 #define A_NUMBER3 33
 
 #define A_TUPLE1 (AN_IDENTIFIER1,A_NUMBER1)
 #define A_TUPLE2 (AN_IDENTIFIER1,A_NUMBER2)
 #define A_TUPLE3 (AN_IDENTIFIER3,A_NUMBER3)
 
 #define A_LIST1 (A_NUMBER1,(A_NUMBER3,BOOST_PP_NIL))
 #define A_LIST2 (A_NUMBER1,(A_NUMBER2,BOOST_PP_NIL))
 #define A_LIST3 (A_NUMBER1,(A_NUMBER3,BOOST_PP_NIL))
 #define A_LIST4 BOOST_PP_NIL
 #define A_LIST5 BOOST_PP_NIL

 BOOST_TEST(BOOST_VMD_NOT_EQUAL(AN_IDENTIFIER1,AN_IDENTIFIER2,BOOST_VMD_TYPE_IDENTIFIER));
 BOOST_TEST(BOOST_VMD_EQUAL(AN_IDENTIFIER1,AN_IDENTIFIER3,BOOST_VMD_TYPE_IDENTIFIER));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(AN_IDENTIFIER1,AN_IDENTIFIER3,BOOST_VMD_TYPE_TYPE));
 
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_NUMBER1,A_NUMBER2,BOOST_VMD_TYPE_NUMBER));
 BOOST_TEST(BOOST_VMD_EQUAL(A_NUMBER1,A_NUMBER3,BOOST_VMD_TYPE_NUMBER));
 BOOST_TEST(BOOST_VMD_EQUAL(A_NUMBER1,A_NUMBER3,BOOST_VMD_TYPE_IDENTIFIER));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_NUMBER1,A_NUMBER3,BOOST_VMD_TYPE_EMPTY));
 
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_TUPLE1,A_TUPLE2,BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(A_TUPLE1,A_TUPLE3,BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_TUPLE1,A_TUPLE3,BOOST_VMD_TYPE_ARRAY));
 
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_LIST1,A_LIST2,BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_EQUAL(A_LIST1,A_LIST3,BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_LIST1,A_LIST3,BOOST_VMD_TYPE_IDENTIFIER));
 BOOST_TEST(BOOST_VMD_EQUAL(A_LIST1,A_LIST3,BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(A_LIST4,A_LIST5,BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_EQUAL(A_LIST4,A_LIST5,BOOST_VMD_TYPE_IDENTIFIER));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_LIST4,A_LIST5,BOOST_VMD_TYPE_TUPLE));
 
 #define BOOST_VMD_REGISTER_ANAME (ANAME)
 #define BOOST_VMD_REGISTER_list_data1 (list_data1)
 #define BOOST_VMD_REGISTER_list_data2 (list_data2)
 #define BOOST_VMD_DETECT_ANAME_ANAME
 #define BOOST_VMD_DETECT_list_data1_list_data1
 #define BOOST_VMD_DETECT_list_data2_list_data2
 
 #define A_SEQUENCE (1,2,3) 46 (list_data1,(list_data2,BOOST_PP_NIL)) BOOST_VMD_TYPE_SEQ ANAME
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,A_SEQUENCE),(1,2,3)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,A_SEQUENCE,BOOST_VMD_TYPE_TUPLE),(1,2,3)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,A_SEQUENCE,BOOST_VMD_TYPE_SEQ),));
 
 BOOST_TEST_EQ(BOOST_VMD_ELEM(1,A_SEQUENCE),46);
 BOOST_TEST_EQ(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_NUMBER),46);
 BOOST_TEST_EQ(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER),46);
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_LIST),));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(2,A_SEQUENCE),(list_data1,(list_data2,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(2,A_SEQUENCE,BOOST_VMD_TYPE_LIST),(list_data1,(list_data2,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(2,A_SEQUENCE,BOOST_VMD_TYPE_TUPLE),(list_data1,(list_data2,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(2,A_SEQUENCE,BOOST_VMD_TYPE_TYPE),));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE,BOOST_VMD_TYPE_TYPE),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE,BOOST_VMD_TYPE_TUPLE),));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(4,A_SEQUENCE),ANAME));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(4,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER),ANAME));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(4,A_SEQUENCE,BOOST_VMD_TYPE_NUMBER),));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,BOOST_PP_NIL),BOOST_PP_NIL));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,BOOST_PP_NIL,BOOST_VMD_TYPE_LIST),BOOST_PP_NIL));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,BOOST_PP_NIL,BOOST_VMD_TYPE_IDENTIFIER),BOOST_PP_NIL));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,BOOST_PP_NIL,BOOST_VMD_TYPE_TUPLE),));
 
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
