/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.GroovyException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.CompilationFailuresException;
import org.codehaus.groovy.tools.CompilerBugException;
import org.codehaus.groovy.tools.ExceptionCollector;

public class ErrorReporter {
    private Throwable base = null;
    private boolean debug = false;
    private Source source = null;
    private Map sources = null;
    private Object output = null;

    public ErrorReporter(Throwable e) {
        this.base = e;
    }

    public ErrorReporter(Throwable e, boolean debug) {
        this.base = e;
        this.debug = debug;
    }

    public void setSources(Map sources) {
        this.sources = sources;
    }

    public void write(PrintStream stream) {
        this.output = stream;
        this.dispatch(this.base, false);
        this.cleanup();
        stream.flush();
    }

    public void write(PrintWriter writer) {
        this.output = writer;
        this.dispatch(this.base, false);
        this.cleanup();
        writer.flush();
    }

    protected void dispatch(Throwable object, boolean child) {
        if (object instanceof CompilationFailuresException) {
            this.report((CompilationFailuresException)object, child);
        } else if (object instanceof ExceptionCollector) {
            this.report((ExceptionCollector)object, child);
        } else if (object instanceof CompilerBugException) {
            this.report((CompilerBugException)object, child);
        } else if (object instanceof SyntaxException) {
            this.report((SyntaxException)object, child);
        } else if (object instanceof Exception) {
            this.report((Exception)object, child);
        } else {
            this.report(object, child);
        }
    }

    protected void report(CompilationFailuresException e, boolean child) {
        Iterator sources = e.iterator();
        while (sources.hasNext()) {
            String source = (String)sources.next();
            ExceptionCollector collection = e.get(source);
            this.setSource(source);
            this.report(collection, true);
        }
    }

    protected void report(ExceptionCollector e, boolean child) {
        Iterator iterator = e.iterator();
        while (iterator.hasNext()) {
            GroovyException error = (GroovyException)iterator.next();
            this.dispatch(error, true);
            this.println("");
        }
    }

    protected void report(SyntaxException e, boolean child) {
        if (this.source == null && e.getSourceLocator() != null) {
            this.setSource(e.getSourceLocator());
        }
        if (this.source != null) {
            String description = this.source.getDescriptor() + ":" + e.getLine() + ": " + e.getMessage();
            this.println(description);
            String sample = this.source.getSample(e.getLine(), e.getEndColumn() - 1);
            if (sample != null) {
                this.println(sample);
            }
        } else {
            this.println(":" + e.getLine() + ": " + e.getMessage());
        }
        this.stacktrace(e, false);
    }

    protected void report(CompilerBugException e, boolean child) {
        this.println(">>> caught a bug:\n>>> " + e.getMessage());
        this.stacktrace(e.getUnderlyingException(), true);
    }

    protected void report(GroovyException e, boolean child) {
        this.println(e.getMessage());
        this.stacktrace(e, false);
    }

    protected void report(Exception e, boolean child) {
        this.println(e.getMessage());
        this.stacktrace(e, false);
    }

    protected void report(Throwable e, boolean child) {
        this.println(">>> a serious error occurred: " + e.getMessage());
        this.stacktrace(e, true);
    }

    protected void println(String line) {
        if (this.output instanceof PrintStream) {
            ((PrintStream)this.output).println(line);
        } else {
            ((PrintWriter)this.output).println(line);
        }
    }

    protected void println(StringBuffer line) {
        if (this.output instanceof PrintStream) {
            ((PrintStream)this.output).println(line);
        } else {
            ((PrintWriter)this.output).println(line);
        }
    }

    protected void stacktrace(Throwable e, boolean always) {
        if (this.debug || always) {
            this.println(">>> stacktrace:");
            if (this.output instanceof PrintStream) {
                e.printStackTrace((PrintStream)this.output);
            } else {
                e.printStackTrace((PrintWriter)this.output);
            }
        }
    }

    protected String repeatString(String pattern, int repeats) {
        StringBuffer buffer = new StringBuffer(pattern.length() * repeats);
        for (int i = 0; i < repeats; ++i) {
            buffer.append(pattern);
        }
        return new String(buffer);
    }

    protected String eol() {
        return System.getProperty("line.separator", "\n");
    }

    protected void setSource(String path) {
        if (this.source != null) {
            this.source.close();
        }
        this.source = new Source(path, this.sources == null);
    }

    protected void cleanup() {
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    private class Source {
        private String path = null;
        private boolean isFile = false;
        private BufferedReader file = null;
        private String line = null;
        private int number = 0;

        public Source(String descriptor, boolean isFile) {
            this.path = descriptor;
            this.isFile = isFile;
        }

        public String getDescriptor() {
            return this.path;
        }

        public String getSample(int lineNumber, int column) {
            String sample = null;
            if (this.getLine(lineNumber) != null) {
                if (column > 0) {
                    String marker = ErrorReporter.this.repeatString(" ", column - 1) + "^";
                    if (column > 40) {
                        int start = column - 30 - 1;
                        int end = column + 10 > this.line.length() ? this.line.length() : column + 10 - 1;
                        sample = "   " + this.line.substring(start, end) + ErrorReporter.this.eol() + "   " + marker.substring(start, marker.length());
                    } else {
                        sample = "   " + this.line + ErrorReporter.this.eol() + "   " + marker;
                    }
                } else {
                    sample = this.line;
                }
            }
            return sample;
        }

        public String getLine(int lineNumber) {
            if (this.open() && lineNumber < this.number) {
                this.reopen();
            }
            if (this.file != null) {
                boolean done;
                boolean bl = done = lineNumber < 0;
                while (this.number < lineNumber && !done) {
                    try {
                        this.line = this.file.readLine();
                        ++this.number;
                    }
                    catch (Exception e) {
                        this.close();
                        done = true;
                    }
                }
            }
            return this.line;
        }

        public boolean open() {
            if (this.file == null) {
                try {
                    if (this.isFile) {
                        this.file = new BufferedReader(new FileReader(this.path));
                    } else if (ErrorReporter.this.sources.containsKey(this.path)) {
                        this.file = new BufferedReader(new StringReader((String)ErrorReporter.this.sources.get(this.path)));
                    }
                }
                catch (Exception e) {
                    this.file = null;
                }
            }
            return this.file != null;
        }

        public void close() {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.file = null;
            this.line = null;
            this.number = 0;
        }

        protected boolean reopen() {
            this.close();
            return this.open();
        }
    }
}

